/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PaymentIntentUpdateParams
extends ApiRequestParams {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="application_fee_amount")
    Object applicationFeeAmount;
    @SerializedName(value="currency")
    Object currency;
    @SerializedName(value="customer")
    Object customer;
    @SerializedName(value="description")
    Object description;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="metadata")
    Object metadata;
    @SerializedName(value="payment_method")
    Object paymentMethod;
    @SerializedName(value="payment_method_data")
    PaymentMethodData paymentMethodData;
    @SerializedName(value="payment_method_options")
    PaymentMethodOptions paymentMethodOptions;
    @SerializedName(value="payment_method_types")
    List<String> paymentMethodTypes;
    @SerializedName(value="receipt_email")
    Object receiptEmail;
    @SerializedName(value="setup_future_usage")
    ApiRequestParams.EnumParam setupFutureUsage;
    @SerializedName(value="shipping")
    Object shipping;
    @SerializedName(value="statement_descriptor")
    Object statementDescriptor;
    @SerializedName(value="statement_descriptor_suffix")
    Object statementDescriptorSuffix;
    @SerializedName(value="transfer_data")
    TransferData transferData;
    @SerializedName(value="transfer_group")
    Object transferGroup;

    private PaymentIntentUpdateParams(Long amount, Object applicationFeeAmount, Object currency, Object customer, Object description, List<String> expand, Map<String, Object> extraParams, Object metadata, Object paymentMethod, PaymentMethodData paymentMethodData, PaymentMethodOptions paymentMethodOptions, List<String> paymentMethodTypes, Object receiptEmail, ApiRequestParams.EnumParam setupFutureUsage, Object shipping, Object statementDescriptor, Object statementDescriptorSuffix, TransferData transferData, Object transferGroup) {
        this.amount = amount;
        this.applicationFeeAmount = applicationFeeAmount;
        this.currency = currency;
        this.customer = customer;
        this.description = description;
        this.expand = expand;
        this.extraParams = extraParams;
        this.metadata = metadata;
        this.paymentMethod = paymentMethod;
        this.paymentMethodData = paymentMethodData;
        this.paymentMethodOptions = paymentMethodOptions;
        this.paymentMethodTypes = paymentMethodTypes;
        this.receiptEmail = receiptEmail;
        this.setupFutureUsage = setupFutureUsage;
        this.shipping = shipping;
        this.statementDescriptor = statementDescriptor;
        this.statementDescriptorSuffix = statementDescriptorSuffix;
        this.transferData = transferData;
        this.transferGroup = transferGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Object getApplicationFeeAmount() {
        return this.applicationFeeAmount;
    }

    @Generated
    public Object getCurrency() {
        return this.currency;
    }

    @Generated
    public Object getCustomer() {
        return this.customer;
    }

    @Generated
    public Object getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public Object getMetadata() {
        return this.metadata;
    }

    @Generated
    public Object getPaymentMethod() {
        return this.paymentMethod;
    }

    @Generated
    public PaymentMethodData getPaymentMethodData() {
        return this.paymentMethodData;
    }

    @Generated
    public PaymentMethodOptions getPaymentMethodOptions() {
        return this.paymentMethodOptions;
    }

    @Generated
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public Object getReceiptEmail() {
        return this.receiptEmail;
    }

    @Generated
    public ApiRequestParams.EnumParam getSetupFutureUsage() {
        return this.setupFutureUsage;
    }

    @Generated
    public Object getShipping() {
        return this.shipping;
    }

    @Generated
    public Object getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public Object getStatementDescriptorSuffix() {
        return this.statementDescriptorSuffix;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public Object getTransferGroup() {
        return this.transferGroup;
    }

    public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
    {
        OFF_SESSION("off_session"),
        ON_SESSION("on_session");

        private final String value;

        private SetupFutureUsage(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class TransferData {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private TransferData(Long amount, Map<String, Object> extraParams) {
            this.amount = amount;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class Builder {
            private Long amount;
            private Map<String, Object> extraParams;

            public TransferData build() {
                return new TransferData(this.amount, this.extraParams);
            }

            public Builder setAmount(Long amount) {
                this.amount = amount;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class Shipping {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="carrier")
        Object carrier;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="name")
        Object name;
        @SerializedName(value="phone")
        Object phone;
        @SerializedName(value="tracking_number")
        Object trackingNumber;

        private Shipping(Address address, Object carrier, Map<String, Object> extraParams, Object name, Object phone, Object trackingNumber) {
            this.address = address;
            this.carrier = carrier;
            this.extraParams = extraParams;
            this.name = name;
            this.phone = phone;
            this.trackingNumber = trackingNumber;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public Object getCarrier() {
            return this.carrier;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Object getName() {
            return this.name;
        }

        @Generated
        public Object getPhone() {
            return this.phone;
        }

        @Generated
        public Object getTrackingNumber() {
            return this.trackingNumber;
        }

        public static class Address {
            @SerializedName(value="city")
            Object city;
            @SerializedName(value="country")
            Object country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            Object line1;
            @SerializedName(value="line2")
            Object line2;
            @SerializedName(value="postal_code")
            Object postalCode;
            @SerializedName(value="state")
            Object state;

            private Address(Object city, Object country, Map<String, Object> extraParams, Object line1, Object line2, Object postalCode, Object state) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getCity() {
                return this.city;
            }

            @Generated
            public Object getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getLine1() {
                return this.line1;
            }

            @Generated
            public Object getLine2() {
                return this.line2;
            }

            @Generated
            public Object getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public Object getState() {
                return this.state;
            }

            public static class Builder {
                private Object city;
                private Object country;
                private Map<String, Object> extraParams;
                private Object line1;
                private Object line2;
                private Object postalCode;
                private Object state;

                public Address build() {
                    return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCity(EmptyParam city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder setCountry(EmptyParam country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine1(EmptyParam line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setLine2(EmptyParam line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setPostalCode(EmptyParam postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }

                public Builder setState(EmptyParam state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private Object carrier;
            private Map<String, Object> extraParams;
            private Object name;
            private Object phone;
            private Object trackingNumber;

            public Shipping build() {
                return new Shipping(this.address, this.carrier, this.extraParams, this.name, this.phone, this.trackingNumber);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setCarrier(String carrier) {
                this.carrier = carrier;
                return this;
            }

            public Builder setCarrier(EmptyParam carrier) {
                this.carrier = carrier;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setName(EmptyParam name) {
                this.name = name;
                return this;
            }

            public Builder setPhone(String phone) {
                this.phone = phone;
                return this;
            }

            public Builder setPhone(EmptyParam phone) {
                this.phone = phone;
                return this;
            }

            public Builder setTrackingNumber(String trackingNumber) {
                this.trackingNumber = trackingNumber;
                return this;
            }

            public Builder setTrackingNumber(EmptyParam trackingNumber) {
                this.trackingNumber = trackingNumber;
                return this;
            }
        }
    }

    public static class PaymentMethodOptions {
        @SerializedName(value="alipay")
        Object alipay;
        @SerializedName(value="bancontact")
        Object bancontact;
        @SerializedName(value="card")
        Object card;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="oxxo")
        Object oxxo;
        @SerializedName(value="p24")
        Object p24;
        @SerializedName(value="sofort")
        Object sofort;

        private PaymentMethodOptions(Object alipay, Object bancontact, Object card, Map<String, Object> extraParams, Object oxxo, Object p24, Object sofort) {
            this.alipay = alipay;
            this.bancontact = bancontact;
            this.card = card;
            this.extraParams = extraParams;
            this.oxxo = oxxo;
            this.p24 = p24;
            this.sofort = sofort;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Object getAlipay() {
            return this.alipay;
        }

        @Generated
        public Object getBancontact() {
            return this.bancontact;
        }

        @Generated
        public Object getCard() {
            return this.card;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Object getOxxo() {
            return this.oxxo;
        }

        @Generated
        public Object getP24() {
            return this.p24;
        }

        @Generated
        public Object getSofort() {
            return this.sofort;
        }

        public static class Sofort {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="preferred_language")
            PreferredLanguage preferredLanguage;

            private Sofort(Map<String, Object> extraParams, PreferredLanguage preferredLanguage) {
                this.extraParams = extraParams;
                this.preferredLanguage = preferredLanguage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public PreferredLanguage getPreferredLanguage() {
                return this.preferredLanguage;
            }

            public static enum PreferredLanguage implements ApiRequestParams.EnumParam
            {
                DE("de"),
                EN("en"),
                ES("es"),
                FR("fr"),
                IT("it"),
                NL("nl"),
                PL("pl");

                private final String value;

                private PreferredLanguage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private PreferredLanguage preferredLanguage;

                public Sofort build() {
                    return new Sofort(this.extraParams, this.preferredLanguage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPreferredLanguage(PreferredLanguage preferredLanguage) {
                    this.preferredLanguage = preferredLanguage;
                    return this;
                }
            }
        }

        public static class P24 {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private P24(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public P24 build() {
                    return new P24(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Oxxo {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Oxxo(Long expiresAfterDays, Map<String, Object> extraParams) {
                this.expiresAfterDays = expiresAfterDays;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Long expiresAfterDays;
                private Map<String, Object> extraParams;

                public Oxxo build() {
                    return new Oxxo(this.expiresAfterDays, this.extraParams);
                }

                public Builder setExpiresAfterDays(Long expiresAfterDays) {
                    this.expiresAfterDays = expiresAfterDays;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Card {
            @SerializedName(value="cvc_token")
            Object cvcToken;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="installments")
            Installments installments;
            @SerializedName(value="moto")
            Boolean moto;
            @SerializedName(value="network")
            Network network;
            @SerializedName(value="request_three_d_secure")
            RequestThreeDSecure requestThreeDSecure;

            private Card(Object cvcToken, Map<String, Object> extraParams, Installments installments, Boolean moto, Network network, RequestThreeDSecure requestThreeDSecure) {
                this.cvcToken = cvcToken;
                this.extraParams = extraParams;
                this.installments = installments;
                this.moto = moto;
                this.network = network;
                this.requestThreeDSecure = requestThreeDSecure;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getCvcToken() {
                return this.cvcToken;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Installments getInstallments() {
                return this.installments;
            }

            @Generated
            public Boolean getMoto() {
                return this.moto;
            }

            @Generated
            public Network getNetwork() {
                return this.network;
            }

            @Generated
            public RequestThreeDSecure getRequestThreeDSecure() {
                return this.requestThreeDSecure;
            }

            public static enum RequestThreeDSecure implements ApiRequestParams.EnumParam
            {
                ANY("any"),
                AUTOMATIC("automatic");

                private final String value;

                private RequestThreeDSecure(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum Network implements ApiRequestParams.EnumParam
            {
                AMEX("amex"),
                CARTES_BANCAIRES("cartes_bancaires"),
                DINERS("diners"),
                DISCOVER("discover"),
                INTERAC("interac"),
                JCB("jcb"),
                MASTERCARD("mastercard"),
                UNIONPAY("unionpay"),
                UNKNOWN("unknown"),
                VISA("visa");

                private final String value;

                private Network(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Installments {
                @SerializedName(value="enabled")
                Boolean enabled;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="plan")
                Object plan;

                private Installments(Boolean enabled, Map<String, Object> extraParams, Object plan) {
                    this.enabled = enabled;
                    this.extraParams = extraParams;
                    this.plan = plan;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Boolean getEnabled() {
                    return this.enabled;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getPlan() {
                    return this.plan;
                }

                public static class Plan {
                    @SerializedName(value="count")
                    Long count;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="interval")
                    Interval interval;
                    @SerializedName(value="type")
                    Type type;

                    private Plan(Long count, Map<String, Object> extraParams, Interval interval, Type type) {
                        this.count = count;
                        this.extraParams = extraParams;
                        this.interval = interval;
                        this.type = type;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Long getCount() {
                        return this.count;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Interval getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public Type getType() {
                        return this.type;
                    }

                    public static enum Type implements ApiRequestParams.EnumParam
                    {
                        FIXED_COUNT("fixed_count");

                        private final String value;

                        private Type(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static enum Interval implements ApiRequestParams.EnumParam
                    {
                        MONTH("month");

                        private final String value;

                        private Interval(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Long count;
                        private Map<String, Object> extraParams;
                        private Interval interval;
                        private Type type;

                        public Plan build() {
                            return new Plan(this.count, this.extraParams, this.interval, this.type);
                        }

                        public Builder setCount(Long count) {
                            this.count = count;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setInterval(Interval interval) {
                            this.interval = interval;
                            return this;
                        }

                        public Builder setType(Type type) {
                            this.type = type;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Boolean enabled;
                    private Map<String, Object> extraParams;
                    private Object plan;

                    public Installments build() {
                        return new Installments(this.enabled, this.extraParams, this.plan);
                    }

                    public Builder setEnabled(Boolean enabled) {
                        this.enabled = enabled;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setPlan(Plan plan) {
                        this.plan = plan;
                        return this;
                    }

                    public Builder setPlan(EmptyParam plan) {
                        this.plan = plan;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Object cvcToken;
                private Map<String, Object> extraParams;
                private Installments installments;
                private Boolean moto;
                private Network network;
                private RequestThreeDSecure requestThreeDSecure;

                public Card build() {
                    return new Card(this.cvcToken, this.extraParams, this.installments, this.moto, this.network, this.requestThreeDSecure);
                }

                public Builder setCvcToken(String cvcToken) {
                    this.cvcToken = cvcToken;
                    return this;
                }

                public Builder setCvcToken(EmptyParam cvcToken) {
                    this.cvcToken = cvcToken;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setInstallments(Installments installments) {
                    this.installments = installments;
                    return this;
                }

                public Builder setMoto(Boolean moto) {
                    this.moto = moto;
                    return this;
                }

                public Builder setNetwork(Network network) {
                    this.network = network;
                    return this;
                }

                public Builder setRequestThreeDSecure(RequestThreeDSecure requestThreeDSecure) {
                    this.requestThreeDSecure = requestThreeDSecure;
                    return this;
                }
            }
        }

        public static class Bancontact {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="preferred_language")
            PreferredLanguage preferredLanguage;

            private Bancontact(Map<String, Object> extraParams, PreferredLanguage preferredLanguage) {
                this.extraParams = extraParams;
                this.preferredLanguage = preferredLanguage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public PreferredLanguage getPreferredLanguage() {
                return this.preferredLanguage;
            }

            public static enum PreferredLanguage implements ApiRequestParams.EnumParam
            {
                DE("de"),
                EN("en"),
                FR("fr"),
                NL("nl");

                private final String value;

                private PreferredLanguage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private PreferredLanguage preferredLanguage;

                public Bancontact build() {
                    return new Bancontact(this.extraParams, this.preferredLanguage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPreferredLanguage(PreferredLanguage preferredLanguage) {
                    this.preferredLanguage = preferredLanguage;
                    return this;
                }
            }
        }

        public static class Alipay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Alipay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Alipay build() {
                    return new Alipay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Builder {
            private Object alipay;
            private Object bancontact;
            private Object card;
            private Map<String, Object> extraParams;
            private Object oxxo;
            private Object p24;
            private Object sofort;

            public PaymentMethodOptions build() {
                return new PaymentMethodOptions(this.alipay, this.bancontact, this.card, this.extraParams, this.oxxo, this.p24, this.sofort);
            }

            public Builder setAlipay(Alipay alipay) {
                this.alipay = alipay;
                return this;
            }

            public Builder setAlipay(EmptyParam alipay) {
                this.alipay = alipay;
                return this;
            }

            public Builder setBancontact(Bancontact bancontact) {
                this.bancontact = bancontact;
                return this;
            }

            public Builder setBancontact(EmptyParam bancontact) {
                this.bancontact = bancontact;
                return this;
            }

            public Builder setCard(Card card) {
                this.card = card;
                return this;
            }

            public Builder setCard(EmptyParam card) {
                this.card = card;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setOxxo(Oxxo oxxo) {
                this.oxxo = oxxo;
                return this;
            }

            public Builder setOxxo(EmptyParam oxxo) {
                this.oxxo = oxxo;
                return this;
            }

            public Builder setP24(P24 p24) {
                this.p24 = p24;
                return this;
            }

            public Builder setP24(EmptyParam p24) {
                this.p24 = p24;
                return this;
            }

            public Builder setSofort(Sofort sofort) {
                this.sofort = sofort;
                return this;
            }

            public Builder setSofort(EmptyParam sofort) {
                this.sofort = sofort;
                return this;
            }
        }
    }

    public static class PaymentMethodData {
        @SerializedName(value="alipay")
        Alipay alipay;
        @SerializedName(value="au_becs_debit")
        AuBecsDebit auBecsDebit;
        @SerializedName(value="bacs_debit")
        BacsDebit bacsDebit;
        @SerializedName(value="bancontact")
        Bancontact bancontact;
        @SerializedName(value="billing_details")
        BillingDetails billingDetails;
        @SerializedName(value="eps")
        Eps eps;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="fpx")
        Fpx fpx;
        @SerializedName(value="giropay")
        Giropay giropay;
        @SerializedName(value="ideal")
        Ideal ideal;
        @SerializedName(value="interac_present")
        InteracPresent interacPresent;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="oxxo")
        Oxxo oxxo;
        @SerializedName(value="p24")
        P24 p24;
        @SerializedName(value="sepa_debit")
        SepaDebit sepaDebit;
        @SerializedName(value="sofort")
        Sofort sofort;
        @SerializedName(value="type")
        Type type;

        private PaymentMethodData(Alipay alipay, AuBecsDebit auBecsDebit, BacsDebit bacsDebit, Bancontact bancontact, BillingDetails billingDetails, Eps eps, Map<String, Object> extraParams, Fpx fpx, Giropay giropay, Ideal ideal, InteracPresent interacPresent, Map<String, String> metadata, Oxxo oxxo, P24 p24, SepaDebit sepaDebit, Sofort sofort, Type type) {
            this.alipay = alipay;
            this.auBecsDebit = auBecsDebit;
            this.bacsDebit = bacsDebit;
            this.bancontact = bancontact;
            this.billingDetails = billingDetails;
            this.eps = eps;
            this.extraParams = extraParams;
            this.fpx = fpx;
            this.giropay = giropay;
            this.ideal = ideal;
            this.interacPresent = interacPresent;
            this.metadata = metadata;
            this.oxxo = oxxo;
            this.p24 = p24;
            this.sepaDebit = sepaDebit;
            this.sofort = sofort;
            this.type = type;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Alipay getAlipay() {
            return this.alipay;
        }

        @Generated
        public AuBecsDebit getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public BacsDebit getBacsDebit() {
            return this.bacsDebit;
        }

        @Generated
        public Bancontact getBancontact() {
            return this.bancontact;
        }

        @Generated
        public BillingDetails getBillingDetails() {
            return this.billingDetails;
        }

        @Generated
        public Eps getEps() {
            return this.eps;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Fpx getFpx() {
            return this.fpx;
        }

        @Generated
        public Giropay getGiropay() {
            return this.giropay;
        }

        @Generated
        public Ideal getIdeal() {
            return this.ideal;
        }

        @Generated
        public InteracPresent getInteracPresent() {
            return this.interacPresent;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public Oxxo getOxxo() {
            return this.oxxo;
        }

        @Generated
        public P24 getP24() {
            return this.p24;
        }

        @Generated
        public SepaDebit getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public Sofort getSofort() {
            return this.sofort;
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        public static enum Type implements ApiRequestParams.EnumParam
        {
            ALIPAY("alipay"),
            AU_BECS_DEBIT("au_becs_debit"),
            BACS_DEBIT("bacs_debit"),
            BANCONTACT("bancontact"),
            EPS("eps"),
            FPX("fpx"),
            GIROPAY("giropay"),
            IDEAL("ideal"),
            OXXO("oxxo"),
            P24("p24"),
            SEPA_DEBIT("sepa_debit"),
            SOFORT("sofort");

            private final String value;

            private Type(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Sofort {
            @SerializedName(value="country")
            Country country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Sofort(Country country, Map<String, Object> extraParams) {
                this.country = country;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Country getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static enum Country implements ApiRequestParams.EnumParam
            {
                AT("AT"),
                BE("BE"),
                DE("DE"),
                ES("ES"),
                IT("IT"),
                NL("NL");

                private final String value;

                private Country(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Country country;
                private Map<String, Object> extraParams;

                public Sofort build() {
                    return new Sofort(this.country, this.extraParams);
                }

                public Builder setCountry(Country country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class SepaDebit {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="iban")
            Object iban;

            private SepaDebit(Map<String, Object> extraParams, Object iban) {
                this.extraParams = extraParams;
                this.iban = iban;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getIban() {
                return this.iban;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Object iban;

                public SepaDebit build() {
                    return new SepaDebit(this.extraParams, this.iban);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setIban(String iban) {
                    this.iban = iban;
                    return this;
                }

                public Builder setIban(EmptyParam iban) {
                    this.iban = iban;
                    return this;
                }
            }
        }

        public static class P24 {
            @SerializedName(value="bank")
            Bank bank;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private P24(Bank bank, Map<String, Object> extraParams) {
                this.bank = bank;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Bank getBank() {
                return this.bank;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static enum Bank implements ApiRequestParams.EnumParam
            {
                ALIOR_BANK("alior_bank"),
                BANK_MILLENNIUM("bank_millennium"),
                BANK_NOWY_BFG_SA("bank_nowy_bfg_sa"),
                BANK_PEKAO_SA("bank_pekao_sa"),
                BANKI_SPBDZIELCZE("banki_spbdzielcze"),
                BLIK("blik"),
                BNP_PARIBAS("bnp_paribas"),
                BOZ("boz"),
                CITI_HANDLOWY("citi_handlowy"),
                CREDIT_AGRICOLE("credit_agricole"),
                ENVELOBANK("envelobank"),
                ETRANSFER_POCZTOWY24("etransfer_pocztowy24"),
                GETIN_BANK("getin_bank"),
                IDEABANK("ideabank"),
                ING("ing"),
                INTELIGO("inteligo"),
                MBANK_MTRANSFER("mbank_mtransfer"),
                NEST_PRZELEW("nest_przelew"),
                NOBLE_PAY("noble_pay"),
                PBAC_Z_IPKO("pbac_z_ipko"),
                PLUS_BANK("plus_bank"),
                SANTANDER_PRZELEW24("santander_przelew24"),
                TMOBILE_USBUGI_BANKOWE("tmobile_usbugi_bankowe"),
                TOYOTA_BANK("toyota_bank"),
                VOLKSWAGEN_BANK("volkswagen_bank");

                private final String value;

                private Bank(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Bank bank;
                private Map<String, Object> extraParams;

                public P24 build() {
                    return new P24(this.bank, this.extraParams);
                }

                public Builder setBank(Bank bank) {
                    this.bank = bank;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Oxxo {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Oxxo(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Oxxo build() {
                    return new Oxxo(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class InteracPresent {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private InteracPresent(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public InteracPresent build() {
                    return new InteracPresent(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Ideal {
            @SerializedName(value="bank")
            Bank bank;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Ideal(Bank bank, Map<String, Object> extraParams) {
                this.bank = bank;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Bank getBank() {
                return this.bank;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static enum Bank implements ApiRequestParams.EnumParam
            {
                ABN_AMRO("abn_amro"),
                ASN_BANK("asn_bank"),
                BUNQ("bunq"),
                HANDELSBANKEN("handelsbanken"),
                ING("ing"),
                KNAB("knab"),
                MONEYOU("moneyou"),
                RABOBANK("rabobank"),
                REGIOBANK("regiobank"),
                SNS_BANK("sns_bank"),
                TRIODOS_BANK("triodos_bank"),
                VAN_LANSCHOT("van_lanschot");

                private final String value;

                private Bank(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Bank bank;
                private Map<String, Object> extraParams;

                public Ideal build() {
                    return new Ideal(this.bank, this.extraParams);
                }

                public Builder setBank(Bank bank) {
                    this.bank = bank;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Giropay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Giropay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Giropay build() {
                    return new Giropay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Fpx {
            @SerializedName(value="account_holder_type")
            AccountHolderType accountHolderType;
            @SerializedName(value="bank")
            Bank bank;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Fpx(AccountHolderType accountHolderType, Bank bank, Map<String, Object> extraParams) {
                this.accountHolderType = accountHolderType;
                this.bank = bank;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public AccountHolderType getAccountHolderType() {
                return this.accountHolderType;
            }

            @Generated
            public Bank getBank() {
                return this.bank;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static enum Bank implements ApiRequestParams.EnumParam
            {
                AFFIN_BANK("affin_bank"),
                ALLIANCE_BANK("alliance_bank"),
                AMBANK("ambank"),
                BANK_ISLAM("bank_islam"),
                BANK_MUAMALAT("bank_muamalat"),
                BANK_RAKYAT("bank_rakyat"),
                BSN("bsn"),
                CIMB("cimb"),
                DEUTSCHE_BANK("deutsche_bank"),
                HONG_LEONG_BANK("hong_leong_bank"),
                HSBC("hsbc"),
                KFH("kfh"),
                MAYBANK2E("maybank2e"),
                MAYBANK2U("maybank2u"),
                OCBC("ocbc"),
                PB_ENTERPRISE("pb_enterprise"),
                PUBLIC_BANK("public_bank"),
                RHB("rhb"),
                STANDARD_CHARTERED("standard_chartered"),
                UOB("uob");

                private final String value;

                private Bank(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum AccountHolderType implements ApiRequestParams.EnumParam
            {
                COMPANY("company"),
                INDIVIDUAL("individual");

                private final String value;

                private AccountHolderType(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private AccountHolderType accountHolderType;
                private Bank bank;
                private Map<String, Object> extraParams;

                public Fpx build() {
                    return new Fpx(this.accountHolderType, this.bank, this.extraParams);
                }

                public Builder setAccountHolderType(AccountHolderType accountHolderType) {
                    this.accountHolderType = accountHolderType;
                    return this;
                }

                public Builder setBank(Bank bank) {
                    this.bank = bank;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Eps {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Eps(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Eps build() {
                    return new Eps(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class BillingDetails {
            @SerializedName(value="address")
            Object address;
            @SerializedName(value="email")
            Object email;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="name")
            Object name;
            @SerializedName(value="phone")
            Object phone;

            private BillingDetails(Object address, Object email, Map<String, Object> extraParams, Object name, Object phone) {
                this.address = address;
                this.email = email;
                this.extraParams = extraParams;
                this.name = name;
                this.phone = phone;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getAddress() {
                return this.address;
            }

            @Generated
            public Object getEmail() {
                return this.email;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getName() {
                return this.name;
            }

            @Generated
            public Object getPhone() {
                return this.phone;
            }

            public static class Address {
                @SerializedName(value="city")
                Object city;
                @SerializedName(value="country")
                Object country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                Object line1;
                @SerializedName(value="line2")
                Object line2;
                @SerializedName(value="postal_code")
                Object postalCode;
                @SerializedName(value="state")
                Object state;

                private Address(Object city, Object country, Map<String, Object> extraParams, Object line1, Object line2, Object postalCode, Object state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Object getCity() {
                    return this.city;
                }

                @Generated
                public Object getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getLine1() {
                    return this.line1;
                }

                @Generated
                public Object getLine2() {
                    return this.line2;
                }

                @Generated
                public Object getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public Object getState() {
                    return this.state;
                }

                public static class Builder {
                    private Object city;
                    private Object country;
                    private Map<String, Object> extraParams;
                    private Object line1;
                    private Object line2;
                    private Object postalCode;
                    private Object state;

                    public Address build() {
                        return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCity(EmptyParam city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder setCountry(EmptyParam country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine1(EmptyParam line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setLine2(EmptyParam line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setPostalCode(EmptyParam postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }

                    public Builder setState(EmptyParam state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Object address;
                private Object email;
                private Map<String, Object> extraParams;
                private Object name;
                private Object phone;

                public BillingDetails build() {
                    return new BillingDetails(this.address, this.email, this.extraParams, this.name, this.phone);
                }

                public Builder setAddress(Address address) {
                    this.address = address;
                    return this;
                }

                public Builder setAddress(EmptyParam address) {
                    this.address = address;
                    return this;
                }

                public Builder setEmail(String email) {
                    this.email = email;
                    return this;
                }

                public Builder setEmail(EmptyParam email) {
                    this.email = email;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setName(EmptyParam name) {
                    this.name = name;
                    return this;
                }

                public Builder setPhone(String phone) {
                    this.phone = phone;
                    return this;
                }

                public Builder setPhone(EmptyParam phone) {
                    this.phone = phone;
                    return this;
                }
            }
        }

        public static class Bancontact {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Bancontact(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Bancontact build() {
                    return new Bancontact(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class BacsDebit {
            @SerializedName(value="account_number")
            Object accountNumber;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="sort_code")
            Object sortCode;

            private BacsDebit(Object accountNumber, Map<String, Object> extraParams, Object sortCode) {
                this.accountNumber = accountNumber;
                this.extraParams = extraParams;
                this.sortCode = sortCode;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getSortCode() {
                return this.sortCode;
            }

            public static class Builder {
                private Object accountNumber;
                private Map<String, Object> extraParams;
                private Object sortCode;

                public BacsDebit build() {
                    return new BacsDebit(this.accountNumber, this.extraParams, this.sortCode);
                }

                public Builder setAccountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder setAccountNumber(EmptyParam accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSortCode(String sortCode) {
                    this.sortCode = sortCode;
                    return this;
                }

                public Builder setSortCode(EmptyParam sortCode) {
                    this.sortCode = sortCode;
                    return this;
                }
            }
        }

        public static class AuBecsDebit {
            @SerializedName(value="account_number")
            Object accountNumber;
            @SerializedName(value="bsb_number")
            Object bsbNumber;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private AuBecsDebit(Object accountNumber, Object bsbNumber, Map<String, Object> extraParams) {
                this.accountNumber = accountNumber;
                this.bsbNumber = bsbNumber;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public Object getBsbNumber() {
                return this.bsbNumber;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Object accountNumber;
                private Object bsbNumber;
                private Map<String, Object> extraParams;

                public AuBecsDebit build() {
                    return new AuBecsDebit(this.accountNumber, this.bsbNumber, this.extraParams);
                }

                public Builder setAccountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder setAccountNumber(EmptyParam accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder setBsbNumber(String bsbNumber) {
                    this.bsbNumber = bsbNumber;
                    return this;
                }

                public Builder setBsbNumber(EmptyParam bsbNumber) {
                    this.bsbNumber = bsbNumber;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Alipay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Alipay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Alipay build() {
                    return new Alipay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Builder {
            private Alipay alipay;
            private AuBecsDebit auBecsDebit;
            private BacsDebit bacsDebit;
            private Bancontact bancontact;
            private BillingDetails billingDetails;
            private Eps eps;
            private Map<String, Object> extraParams;
            private Fpx fpx;
            private Giropay giropay;
            private Ideal ideal;
            private InteracPresent interacPresent;
            private Map<String, String> metadata;
            private Oxxo oxxo;
            private P24 p24;
            private SepaDebit sepaDebit;
            private Sofort sofort;
            private Type type;

            public PaymentMethodData build() {
                return new PaymentMethodData(this.alipay, this.auBecsDebit, this.bacsDebit, this.bancontact, this.billingDetails, this.eps, this.extraParams, this.fpx, this.giropay, this.ideal, this.interacPresent, this.metadata, this.oxxo, this.p24, this.sepaDebit, this.sofort, this.type);
            }

            public Builder setAlipay(Alipay alipay) {
                this.alipay = alipay;
                return this;
            }

            public Builder setAuBecsDebit(AuBecsDebit auBecsDebit) {
                this.auBecsDebit = auBecsDebit;
                return this;
            }

            public Builder setBacsDebit(BacsDebit bacsDebit) {
                this.bacsDebit = bacsDebit;
                return this;
            }

            public Builder setBancontact(Bancontact bancontact) {
                this.bancontact = bancontact;
                return this;
            }

            public Builder setBillingDetails(BillingDetails billingDetails) {
                this.billingDetails = billingDetails;
                return this;
            }

            public Builder setEps(Eps eps) {
                this.eps = eps;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setFpx(Fpx fpx) {
                this.fpx = fpx;
                return this;
            }

            public Builder setGiropay(Giropay giropay) {
                this.giropay = giropay;
                return this;
            }

            public Builder setIdeal(Ideal ideal) {
                this.ideal = ideal;
                return this;
            }

            public Builder setInteracPresent(InteracPresent interacPresent) {
                this.interacPresent = interacPresent;
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setOxxo(Oxxo oxxo) {
                this.oxxo = oxxo;
                return this;
            }

            public Builder setP24(P24 p24) {
                this.p24 = p24;
                return this;
            }

            public Builder setSepaDebit(SepaDebit sepaDebit) {
                this.sepaDebit = sepaDebit;
                return this;
            }

            public Builder setSofort(Sofort sofort) {
                this.sofort = sofort;
                return this;
            }

            public Builder setType(Type type) {
                this.type = type;
                return this;
            }
        }
    }

    public static class Builder {
        private Long amount;
        private Object applicationFeeAmount;
        private Object currency;
        private Object customer;
        private Object description;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private Object metadata;
        private Object paymentMethod;
        private PaymentMethodData paymentMethodData;
        private PaymentMethodOptions paymentMethodOptions;
        private List<String> paymentMethodTypes;
        private Object receiptEmail;
        private ApiRequestParams.EnumParam setupFutureUsage;
        private Object shipping;
        private Object statementDescriptor;
        private Object statementDescriptorSuffix;
        private TransferData transferData;
        private Object transferGroup;

        public PaymentIntentUpdateParams build() {
            return new PaymentIntentUpdateParams(this.amount, this.applicationFeeAmount, this.currency, this.customer, this.description, this.expand, this.extraParams, this.metadata, this.paymentMethod, this.paymentMethodData, this.paymentMethodOptions, this.paymentMethodTypes, this.receiptEmail, this.setupFutureUsage, this.shipping, this.statementDescriptor, this.statementDescriptorSuffix, this.transferData, this.transferGroup);
        }

        public Builder setAmount(Long amount) {
            this.amount = amount;
            return this;
        }

        public Builder setApplicationFeeAmount(Long applicationFeeAmount) {
            this.applicationFeeAmount = applicationFeeAmount;
            return this;
        }

        public Builder setApplicationFeeAmount(EmptyParam applicationFeeAmount) {
            this.applicationFeeAmount = applicationFeeAmount;
            return this;
        }

        public Builder setCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder setCurrency(EmptyParam currency) {
            this.currency = currency;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCustomer(EmptyParam customer) {
            this.customer = customer;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setDescription(EmptyParam description) {
            this.description = description;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null || this.metadata instanceof EmptyParam) {
                this.metadata = new HashMap();
            }
            ((Map)this.metadata).put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null || this.metadata instanceof EmptyParam) {
                this.metadata = new HashMap();
            }
            ((Map)this.metadata).putAll(map);
            return this;
        }

        public Builder setMetadata(EmptyParam metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setPaymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder setPaymentMethod(EmptyParam paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder setPaymentMethodData(PaymentMethodData paymentMethodData) {
            this.paymentMethodData = paymentMethodData;
            return this;
        }

        public Builder setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
            this.paymentMethodOptions = paymentMethodOptions;
            return this;
        }

        public Builder addPaymentMethodType(String element) {
            if (this.paymentMethodTypes == null) {
                this.paymentMethodTypes = new ArrayList<String>();
            }
            this.paymentMethodTypes.add(element);
            return this;
        }

        public Builder addAllPaymentMethodType(List<String> elements) {
            if (this.paymentMethodTypes == null) {
                this.paymentMethodTypes = new ArrayList<String>();
            }
            this.paymentMethodTypes.addAll(elements);
            return this;
        }

        public Builder setReceiptEmail(String receiptEmail) {
            this.receiptEmail = receiptEmail;
            return this;
        }

        public Builder setReceiptEmail(EmptyParam receiptEmail) {
            this.receiptEmail = receiptEmail;
            return this;
        }

        public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
            return this;
        }

        public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
            return this;
        }

        public Builder setShipping(Shipping shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder setShipping(EmptyParam shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        public Builder setStatementDescriptor(EmptyParam statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        public Builder setStatementDescriptorSuffix(String statementDescriptorSuffix) {
            this.statementDescriptorSuffix = statementDescriptorSuffix;
            return this;
        }

        public Builder setStatementDescriptorSuffix(EmptyParam statementDescriptorSuffix) {
            this.statementDescriptorSuffix = statementDescriptorSuffix;
            return this;
        }

        public Builder setTransferData(TransferData transferData) {
            this.transferData = transferData;
            return this;
        }

        public Builder setTransferGroup(String transferGroup) {
            this.transferGroup = transferGroup;
            return this;
        }

        public Builder setTransferGroup(EmptyParam transferGroup) {
            this.transferGroup = transferGroup;
            return this;
        }
    }
}

