// Generated by delombok at Mon Mar 22 12:39:07 EDT 2021
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PersonUpdateParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class Person extends ApiResource implements HasId, MetadataStore<Person> {
  /**
   * The account the person is associated with.
   */
  @SerializedName("account")
  String account;
  @SerializedName("address")
  Address address;
  /**
   * The Kana variation of the person's address (Japan only).
   */
  @SerializedName("address_kana")
  JapanAddress addressKana;
  /**
   * The Kanji variation of the person's address (Japan only).
   */
  @SerializedName("address_kanji")
  JapanAddress addressKanji;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Always true for a deleted object.
   */
  @SerializedName("deleted")
  Boolean deleted;
  @SerializedName("dob")
  DateOfBirth dob;
  /**
   * The person's email address.
   */
  @SerializedName("email")
  String email;
  /**
   * The person's first name.
   */
  @SerializedName("first_name")
  String firstName;
  /**
   * The Kana variation of the person's first name (Japan only).
   */
  @SerializedName("first_name_kana")
  String firstNameKana;
  /**
   * The Kanji variation of the person's first name (Japan only).
   */
  @SerializedName("first_name_kanji")
  String firstNameKanji;
  /**
   * The person's gender (International regulations require either &quot;male&quot; or
   * &quot;female&quot;).
   */
  @SerializedName("gender")
  String gender;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Whether the person's {@code id_number} was provided.
   */
  @SerializedName("id_number_provided")
  Boolean idNumberProvided;
  /**
   * The person's last name.
   */
  @SerializedName("last_name")
  String lastName;
  /**
   * The Kana variation of the person's last name (Japan only).
   */
  @SerializedName("last_name_kana")
  String lastNameKana;
  /**
   * The Kanji variation of the person's last name (Japan only).
   */
  @SerializedName("last_name_kanji")
  String lastNameKanji;
  /**
   * The person's maiden name.
   */
  @SerializedName("maiden_name")
  String maidenName;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * The country where the person is a national.
   */
  @SerializedName("nationality")
  String nationality;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code person}.
   */
  @SerializedName("object")
  String object;
  /**
   * The person's phone number.
   */
  @SerializedName("phone")
  String phone;
  /**
   * Indicates if the person or any of their representatives, family members, or other closely
   * related persons, declares that they hold or have held an important public job or function, in
   * any jurisdiction.
   *
   * <p>One of {@code existing}, or {@code none}.
   */
  @SerializedName("political_exposure")
  String politicalExposure;
  @SerializedName("relationship")
  Relationship relationship;
  /**
   * Information about the requirements for this person, including what information needs to be
   * collected, and by when.
   */
  @SerializedName("requirements")
  Requirements requirements;
  /**
   * Whether the last four digits of the person's Social Security number have been provided (U.S.
   * only).
   */
  @SerializedName("ssn_last_4_provided")
  Boolean ssnLast4Provided;
  @SerializedName("verification")
  Verification verification;

  /**
   * Updates an existing person.
   */
  @Override
  public Person update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates an existing person.
   */
  @Override
  public Person update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/persons/%s", ApiResource.urlEncodeId(this.getAccount()), ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Person.class, options);
  }

  /**
   * Updates an existing person.
   */
  public Person update(PersonUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates an existing person.
   */
  public Person update(PersonUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/persons/%s", ApiResource.urlEncodeId(this.getAccount()), ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Person.class, options);
  }

  /**
   * Deletes an existing person’s relationship to the account’s legal entity. Any person with a
   * relationship for an account can be deleted through the API, except if the person is the <code>
   * account_opener</code>. If your integration is using the <code>executive</code> parameter, you
   * cannot delete the only verified <code>executive</code> on file.
   */
  public Person delete() throws StripeException {
    return delete((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Deletes an existing person’s relationship to the account’s legal entity. Any person with a
   * relationship for an account can be deleted through the API, except if the person is the <code>
   * account_opener</code>. If your integration is using the <code>executive</code> parameter, you
   * cannot delete the only verified <code>executive</code> on file.
   */
  public Person delete(RequestOptions options) throws StripeException {
    return delete((Map<String, Object>) null, options);
  }

  /**
   * Deletes an existing person’s relationship to the account’s legal entity. Any person with a
   * relationship for an account can be deleted through the API, except if the person is the <code>
   * account_opener</code>. If your integration is using the <code>executive</code> parameter, you
   * cannot delete the only verified <code>executive</code> on file.
   */
  public Person delete(Map<String, Object> params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * Deletes an existing person’s relationship to the account’s legal entity. Any person with a
   * relationship for an account can be deleted through the API, except if the person is the <code>
   * account_opener</code>. If your integration is using the <code>executive</code> parameter, you
   * cannot delete the only verified <code>executive</code> on file.
   */
  public Person delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/persons/%s", ApiResource.urlEncodeId(this.getAccount()), ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Person.class, options);
  }


  public static class DateOfBirth extends StripeObject {
    /**
     * The day of birth, between 1 and 31.
     */
    @SerializedName("day")
    Long day;
    /**
     * The month of birth, between 1 and 12.
     */
    @SerializedName("month")
    Long month;
    /**
     * The four-digit year of birth.
     */
    @SerializedName("year")
    Long year;

    /**
     * The day of birth, between 1 and 31.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDay() {
      return this.day;
    }

    /**
     * The month of birth, between 1 and 12.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMonth() {
      return this.month;
    }

    /**
     * The four-digit year of birth.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getYear() {
      return this.year;
    }

    /**
     * The day of birth, between 1 and 31.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDay(final Long day) {
      this.day = day;
    }

    /**
     * The month of birth, between 1 and 12.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMonth(final Long month) {
      this.month = month;
    }

    /**
     * The four-digit year of birth.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setYear(final Long year) {
      this.year = year;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Person.DateOfBirth)) return false;
      final Person.DateOfBirth other = (Person.DateOfBirth) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$day = this.getDay();
      final java.lang.Object other$day = other.getDay();
      if (this$day == null ? other$day != null : !this$day.equals(other$day)) return false;
      final java.lang.Object this$month = this.getMonth();
      final java.lang.Object other$month = other.getMonth();
      if (this$month == null ? other$month != null : !this$month.equals(other$month)) return false;
      final java.lang.Object this$year = this.getYear();
      final java.lang.Object other$year = other.getYear();
      if (this$year == null ? other$year != null : !this$year.equals(other$year)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Person.DateOfBirth;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $day = this.getDay();
      result = result * PRIME + ($day == null ? 43 : $day.hashCode());
      final java.lang.Object $month = this.getMonth();
      result = result * PRIME + ($month == null ? 43 : $month.hashCode());
      final java.lang.Object $year = this.getYear();
      result = result * PRIME + ($year == null ? 43 : $year.hashCode());
      return result;
    }
  }


  public static class JapanAddress extends StripeObject {
    /**
     * City/Ward.
     */
    @SerializedName("city")
    String city;
    /**
     * Two-letter country code (<a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO
     * 3166-1 alpha-2</a>).
     */
    @SerializedName("country")
    String country;
    /**
     * Block/Building number.
     */
    @SerializedName("line1")
    String line1;
    /**
     * Building details.
     */
    @SerializedName("line2")
    String line2;
    /**
     * ZIP or postal code.
     */
    @SerializedName("postal_code")
    String postalCode;
    /**
     * Prefecture.
     */
    @SerializedName("state")
    String state;
    /**
     * Town/cho-me.
     */
    @SerializedName("town")
    String town;

    /**
     * City/Ward.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCity() {
      return this.city;
    }

    /**
     * Two-letter country code (<a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO
     * 3166-1 alpha-2</a>).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCountry() {
      return this.country;
    }

    /**
     * Block/Building number.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLine1() {
      return this.line1;
    }

    /**
     * Building details.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLine2() {
      return this.line2;
    }

    /**
     * ZIP or postal code.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPostalCode() {
      return this.postalCode;
    }

    /**
     * Prefecture.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getState() {
      return this.state;
    }

    /**
     * Town/cho-me.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTown() {
      return this.town;
    }

    /**
     * City/Ward.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCity(final String city) {
      this.city = city;
    }

    /**
     * Two-letter country code (<a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO
     * 3166-1 alpha-2</a>).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCountry(final String country) {
      this.country = country;
    }

    /**
     * Block/Building number.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLine1(final String line1) {
      this.line1 = line1;
    }

    /**
     * Building details.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLine2(final String line2) {
      this.line2 = line2;
    }

    /**
     * ZIP or postal code.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPostalCode(final String postalCode) {
      this.postalCode = postalCode;
    }

    /**
     * Prefecture.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setState(final String state) {
      this.state = state;
    }

    /**
     * Town/cho-me.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTown(final String town) {
      this.town = town;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Person.JapanAddress)) return false;
      final Person.JapanAddress other = (Person.JapanAddress) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$city = this.getCity();
      final java.lang.Object other$city = other.getCity();
      if (this$city == null ? other$city != null : !this$city.equals(other$city)) return false;
      final java.lang.Object this$country = this.getCountry();
      final java.lang.Object other$country = other.getCountry();
      if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
      final java.lang.Object this$line1 = this.getLine1();
      final java.lang.Object other$line1 = other.getLine1();
      if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) return false;
      final java.lang.Object this$line2 = this.getLine2();
      final java.lang.Object other$line2 = other.getLine2();
      if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) return false;
      final java.lang.Object this$postalCode = this.getPostalCode();
      final java.lang.Object other$postalCode = other.getPostalCode();
      if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) return false;
      final java.lang.Object this$state = this.getState();
      final java.lang.Object other$state = other.getState();
      if (this$state == null ? other$state != null : !this$state.equals(other$state)) return false;
      final java.lang.Object this$town = this.getTown();
      final java.lang.Object other$town = other.getTown();
      if (this$town == null ? other$town != null : !this$town.equals(other$town)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Person.JapanAddress;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $city = this.getCity();
      result = result * PRIME + ($city == null ? 43 : $city.hashCode());
      final java.lang.Object $country = this.getCountry();
      result = result * PRIME + ($country == null ? 43 : $country.hashCode());
      final java.lang.Object $line1 = this.getLine1();
      result = result * PRIME + ($line1 == null ? 43 : $line1.hashCode());
      final java.lang.Object $line2 = this.getLine2();
      result = result * PRIME + ($line2 == null ? 43 : $line2.hashCode());
      final java.lang.Object $postalCode = this.getPostalCode();
      result = result * PRIME + ($postalCode == null ? 43 : $postalCode.hashCode());
      final java.lang.Object $state = this.getState();
      result = result * PRIME + ($state == null ? 43 : $state.hashCode());
      final java.lang.Object $town = this.getTown();
      result = result * PRIME + ($town == null ? 43 : $town.hashCode());
      return result;
    }
  }


  public static class Relationship extends StripeObject {
    /**
     * Whether the person is a director of the account's legal entity. Currently only required for
     * accounts in the EU. Directors are typically members of the governing board of the company, or
     * responsible for ensuring the company meets its regulatory obligations.
     */
    @SerializedName("director")
    Boolean director;
    /**
     * Whether the person has significant responsibility to control, manage, or direct the
     * organization.
     */
    @SerializedName("executive")
    Boolean executive;
    /**
     * Whether the person is an owner of the account’s legal entity.
     */
    @SerializedName("owner")
    Boolean owner;
    /**
     * The percent owned by the person of the account's legal entity.
     */
    @SerializedName("percent_ownership")
    BigDecimal percentOwnership;
    /**
     * Whether the person is authorized as the primary representative of the account. This is the
     * person nominated by the business to provide information about themselves, and general
     * information about the account. There can only be one representative at any given time. At the
     * time the account is created, this person should be set to the person responsible for opening
     * the account.
     */
    @SerializedName("representative")
    Boolean representative;
    /**
     * The person's title (e.g., CEO, Support Engineer).
     */
    @SerializedName("title")
    String title;

    /**
     * Whether the person is a director of the account's legal entity. Currently only required for
     * accounts in the EU. Directors are typically members of the governing board of the company, or
     * responsible for ensuring the company meets its regulatory obligations.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getDirector() {
      return this.director;
    }

    /**
     * Whether the person has significant responsibility to control, manage, or direct the
     * organization.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getExecutive() {
      return this.executive;
    }

    /**
     * Whether the person is an owner of the account’s legal entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getOwner() {
      return this.owner;
    }

    /**
     * The percent owned by the person of the account's legal entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BigDecimal getPercentOwnership() {
      return this.percentOwnership;
    }

    /**
     * Whether the person is authorized as the primary representative of the account. This is the
     * person nominated by the business to provide information about themselves, and general
     * information about the account. There can only be one representative at any given time. At the
     * time the account is created, this person should be set to the person responsible for opening
     * the account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getRepresentative() {
      return this.representative;
    }

    /**
     * The person's title (e.g., CEO, Support Engineer).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTitle() {
      return this.title;
    }

    /**
     * Whether the person is a director of the account's legal entity. Currently only required for
     * accounts in the EU. Directors are typically members of the governing board of the company, or
     * responsible for ensuring the company meets its regulatory obligations.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDirector(final Boolean director) {
      this.director = director;
    }

    /**
     * Whether the person has significant responsibility to control, manage, or direct the
     * organization.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExecutive(final Boolean executive) {
      this.executive = executive;
    }

    /**
     * Whether the person is an owner of the account’s legal entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOwner(final Boolean owner) {
      this.owner = owner;
    }

    /**
     * The percent owned by the person of the account's legal entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPercentOwnership(final BigDecimal percentOwnership) {
      this.percentOwnership = percentOwnership;
    }

    /**
     * Whether the person is authorized as the primary representative of the account. This is the
     * person nominated by the business to provide information about themselves, and general
     * information about the account. There can only be one representative at any given time. At the
     * time the account is created, this person should be set to the person responsible for opening
     * the account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRepresentative(final Boolean representative) {
      this.representative = representative;
    }

    /**
     * The person's title (e.g., CEO, Support Engineer).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTitle(final String title) {
      this.title = title;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Person.Relationship)) return false;
      final Person.Relationship other = (Person.Relationship) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$director = this.getDirector();
      final java.lang.Object other$director = other.getDirector();
      if (this$director == null ? other$director != null : !this$director.equals(other$director)) return false;
      final java.lang.Object this$executive = this.getExecutive();
      final java.lang.Object other$executive = other.getExecutive();
      if (this$executive == null ? other$executive != null : !this$executive.equals(other$executive)) return false;
      final java.lang.Object this$owner = this.getOwner();
      final java.lang.Object other$owner = other.getOwner();
      if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) return false;
      final java.lang.Object this$representative = this.getRepresentative();
      final java.lang.Object other$representative = other.getRepresentative();
      if (this$representative == null ? other$representative != null : !this$representative.equals(other$representative)) return false;
      final java.lang.Object this$percentOwnership = this.getPercentOwnership();
      final java.lang.Object other$percentOwnership = other.getPercentOwnership();
      if (this$percentOwnership == null ? other$percentOwnership != null : !this$percentOwnership.equals(other$percentOwnership)) return false;
      final java.lang.Object this$title = this.getTitle();
      final java.lang.Object other$title = other.getTitle();
      if (this$title == null ? other$title != null : !this$title.equals(other$title)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Person.Relationship;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $director = this.getDirector();
      result = result * PRIME + ($director == null ? 43 : $director.hashCode());
      final java.lang.Object $executive = this.getExecutive();
      result = result * PRIME + ($executive == null ? 43 : $executive.hashCode());
      final java.lang.Object $owner = this.getOwner();
      result = result * PRIME + ($owner == null ? 43 : $owner.hashCode());
      final java.lang.Object $representative = this.getRepresentative();
      result = result * PRIME + ($representative == null ? 43 : $representative.hashCode());
      final java.lang.Object $percentOwnership = this.getPercentOwnership();
      result = result * PRIME + ($percentOwnership == null ? 43 : $percentOwnership.hashCode());
      final java.lang.Object $title = this.getTitle();
      result = result * PRIME + ($title == null ? 43 : $title.hashCode());
      return result;
    }
  }


  public static class Requirements extends StripeObject {
    /**
     * Fields that need to be collected to keep the person's account enabled. If not collected by
     * the account's {@code current_deadline}, these fields appear in {@code past_due} as well, and
     * the account is disabled.
     */
    @SerializedName("currently_due")
    List<String> currentlyDue;
    /**
     * The fields that are {@code currently_due} and need to be collected again because validation
     * or verification failed for some reason.
     */
    @SerializedName("errors")
    List<Account.Requirements.Errors> errors;
    /**
     * Fields that need to be collected assuming all volume thresholds are reached. As fields are
     * needed, they are moved to {@code currently_due} and the account's {@code current_deadline} is
     * set.
     */
    @SerializedName("eventually_due")
    List<String> eventuallyDue;
    /**
     * Fields that weren't collected by the account's {@code current_deadline}. These fields need to
     * be collected to enable payouts for the person's account.
     */
    @SerializedName("past_due")
    List<String> pastDue;
    /**
     * Fields that may become required depending on the results of verification or review. An empty
     * array unless an asynchronous verification is pending. If verification fails, the fields in
     * this array become required and move to {@code currently_due} or {@code past_due}.
     */
    @SerializedName("pending_verification")
    List<String> pendingVerification;

    /**
     * Fields that need to be collected to keep the person's account enabled. If not collected by
     * the account's {@code current_deadline}, these fields appear in {@code past_due} as well, and
     * the account is disabled.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getCurrentlyDue() {
      return this.currentlyDue;
    }

    /**
     * The fields that are {@code currently_due} and need to be collected again because validation
     * or verification failed for some reason.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Account.Requirements.Errors> getErrors() {
      return this.errors;
    }

    /**
     * Fields that need to be collected assuming all volume thresholds are reached. As fields are
     * needed, they are moved to {@code currently_due} and the account's {@code current_deadline} is
     * set.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getEventuallyDue() {
      return this.eventuallyDue;
    }

    /**
     * Fields that weren't collected by the account's {@code current_deadline}. These fields need to
     * be collected to enable payouts for the person's account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getPastDue() {
      return this.pastDue;
    }

    /**
     * Fields that may become required depending on the results of verification or review. An empty
     * array unless an asynchronous verification is pending. If verification fails, the fields in
     * this array become required and move to {@code currently_due} or {@code past_due}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getPendingVerification() {
      return this.pendingVerification;
    }

    /**
     * Fields that need to be collected to keep the person's account enabled. If not collected by
     * the account's {@code current_deadline}, these fields appear in {@code past_due} as well, and
     * the account is disabled.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrentlyDue(final List<String> currentlyDue) {
      this.currentlyDue = currentlyDue;
    }

    /**
     * The fields that are {@code currently_due} and need to be collected again because validation
     * or verification failed for some reason.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setErrors(final List<Account.Requirements.Errors> errors) {
      this.errors = errors;
    }

    /**
     * Fields that need to be collected assuming all volume thresholds are reached. As fields are
     * needed, they are moved to {@code currently_due} and the account's {@code current_deadline} is
     * set.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEventuallyDue(final List<String> eventuallyDue) {
      this.eventuallyDue = eventuallyDue;
    }

    /**
     * Fields that weren't collected by the account's {@code current_deadline}. These fields need to
     * be collected to enable payouts for the person's account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPastDue(final List<String> pastDue) {
      this.pastDue = pastDue;
    }

    /**
     * Fields that may become required depending on the results of verification or review. An empty
     * array unless an asynchronous verification is pending. If verification fails, the fields in
     * this array become required and move to {@code currently_due} or {@code past_due}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPendingVerification(final List<String> pendingVerification) {
      this.pendingVerification = pendingVerification;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Person.Requirements)) return false;
      final Person.Requirements other = (Person.Requirements) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$currentlyDue = this.getCurrentlyDue();
      final java.lang.Object other$currentlyDue = other.getCurrentlyDue();
      if (this$currentlyDue == null ? other$currentlyDue != null : !this$currentlyDue.equals(other$currentlyDue)) return false;
      final java.lang.Object this$errors = this.getErrors();
      final java.lang.Object other$errors = other.getErrors();
      if (this$errors == null ? other$errors != null : !this$errors.equals(other$errors)) return false;
      final java.lang.Object this$eventuallyDue = this.getEventuallyDue();
      final java.lang.Object other$eventuallyDue = other.getEventuallyDue();
      if (this$eventuallyDue == null ? other$eventuallyDue != null : !this$eventuallyDue.equals(other$eventuallyDue)) return false;
      final java.lang.Object this$pastDue = this.getPastDue();
      final java.lang.Object other$pastDue = other.getPastDue();
      if (this$pastDue == null ? other$pastDue != null : !this$pastDue.equals(other$pastDue)) return false;
      final java.lang.Object this$pendingVerification = this.getPendingVerification();
      final java.lang.Object other$pendingVerification = other.getPendingVerification();
      if (this$pendingVerification == null ? other$pendingVerification != null : !this$pendingVerification.equals(other$pendingVerification)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Person.Requirements;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $currentlyDue = this.getCurrentlyDue();
      result = result * PRIME + ($currentlyDue == null ? 43 : $currentlyDue.hashCode());
      final java.lang.Object $errors = this.getErrors();
      result = result * PRIME + ($errors == null ? 43 : $errors.hashCode());
      final java.lang.Object $eventuallyDue = this.getEventuallyDue();
      result = result * PRIME + ($eventuallyDue == null ? 43 : $eventuallyDue.hashCode());
      final java.lang.Object $pastDue = this.getPastDue();
      result = result * PRIME + ($pastDue == null ? 43 : $pastDue.hashCode());
      final java.lang.Object $pendingVerification = this.getPendingVerification();
      result = result * PRIME + ($pendingVerification == null ? 43 : $pendingVerification.hashCode());
      return result;
    }
  }


  public static class Verification extends StripeObject {
    /**
     * A document showing address, either a passport, local ID card, or utility bill from a
     * well-known utility company.
     */
    @SerializedName("additional_document")
    VerificationDocument additionalDocument;
    /**
     * A user-displayable string describing the verification state for the person. For example, this
     * may say &quot;Provided identity information could not be verified&quot;.
     */
    @SerializedName("details")
    String details;
    /**
     * One of {@code document_address_mismatch}, {@code document_dob_mismatch}, {@code
     * document_duplicate_type}, {@code document_id_number_mismatch}, {@code
     * document_name_mismatch}, {@code document_nationality_mismatch}, {@code
     * failed_keyed_identity}, or {@code failed_other}. A machine-readable code specifying the
     * verification state for the person.
     */
    @SerializedName("details_code")
    String detailsCode;
    @SerializedName("document")
    VerificationDocument document;
    /**
     * The state of verification for the person. Possible values are {@code unverified}, {@code
     * pending}, or {@code verified}.
     */
    @SerializedName("status")
    String status;

    /**
     * A document showing address, either a passport, local ID card, or utility bill from a
     * well-known utility company.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public VerificationDocument getAdditionalDocument() {
      return this.additionalDocument;
    }

    /**
     * A user-displayable string describing the verification state for the person. For example, this
     * may say &quot;Provided identity information could not be verified&quot;.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDetails() {
      return this.details;
    }

    /**
     * One of {@code document_address_mismatch}, {@code document_dob_mismatch}, {@code
     * document_duplicate_type}, {@code document_id_number_mismatch}, {@code
     * document_name_mismatch}, {@code document_nationality_mismatch}, {@code
     * failed_keyed_identity}, or {@code failed_other}. A machine-readable code specifying the
     * verification state for the person.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDetailsCode() {
      return this.detailsCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public VerificationDocument getDocument() {
      return this.document;
    }

    /**
     * The state of verification for the person. Possible values are {@code unverified}, {@code
     * pending}, or {@code verified}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    /**
     * A document showing address, either a passport, local ID card, or utility bill from a
     * well-known utility company.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAdditionalDocument(final VerificationDocument additionalDocument) {
      this.additionalDocument = additionalDocument;
    }

    /**
     * A user-displayable string describing the verification state for the person. For example, this
     * may say &quot;Provided identity information could not be verified&quot;.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDetails(final String details) {
      this.details = details;
    }

    /**
     * One of {@code document_address_mismatch}, {@code document_dob_mismatch}, {@code
     * document_duplicate_type}, {@code document_id_number_mismatch}, {@code
     * document_name_mismatch}, {@code document_nationality_mismatch}, {@code
     * failed_keyed_identity}, or {@code failed_other}. A machine-readable code specifying the
     * verification state for the person.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDetailsCode(final String detailsCode) {
      this.detailsCode = detailsCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDocument(final VerificationDocument document) {
      this.document = document;
    }

    /**
     * The state of verification for the person. Possible values are {@code unverified}, {@code
     * pending}, or {@code verified}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Person.Verification)) return false;
      final Person.Verification other = (Person.Verification) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$additionalDocument = this.getAdditionalDocument();
      final java.lang.Object other$additionalDocument = other.getAdditionalDocument();
      if (this$additionalDocument == null ? other$additionalDocument != null : !this$additionalDocument.equals(other$additionalDocument)) return false;
      final java.lang.Object this$details = this.getDetails();
      final java.lang.Object other$details = other.getDetails();
      if (this$details == null ? other$details != null : !this$details.equals(other$details)) return false;
      final java.lang.Object this$detailsCode = this.getDetailsCode();
      final java.lang.Object other$detailsCode = other.getDetailsCode();
      if (this$detailsCode == null ? other$detailsCode != null : !this$detailsCode.equals(other$detailsCode)) return false;
      final java.lang.Object this$document = this.getDocument();
      final java.lang.Object other$document = other.getDocument();
      if (this$document == null ? other$document != null : !this$document.equals(other$document)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Person.Verification;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $additionalDocument = this.getAdditionalDocument();
      result = result * PRIME + ($additionalDocument == null ? 43 : $additionalDocument.hashCode());
      final java.lang.Object $details = this.getDetails();
      result = result * PRIME + ($details == null ? 43 : $details.hashCode());
      final java.lang.Object $detailsCode = this.getDetailsCode();
      result = result * PRIME + ($detailsCode == null ? 43 : $detailsCode.hashCode());
      final java.lang.Object $document = this.getDocument();
      result = result * PRIME + ($document == null ? 43 : $document.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      return result;
    }
  }


  public static class VerificationDocument extends StripeObject {
    /**
     * The back of an ID returned by a <a href="https://stripe.com/docs/api#create_file">file
     * upload</a> with a {@code purpose} value of {@code identity_document}.
     */
    @SerializedName("back")
    ExpandableField<File> back;
    /**
     * A user-displayable string describing the verification state of this document. For example, if
     * a document is uploaded and the picture is too fuzzy, this may say &quot;Identity document is
     * too unclear to read&quot;.
     */
    @SerializedName("details")
    String details;
    /**
     * One of {@code document_corrupt}, {@code document_country_not_supported}, {@code
     * document_expired}, {@code document_failed_copy}, {@code document_failed_other}, {@code
     * document_failed_test_mode}, {@code document_fraudulent}, {@code document_failed_greyscale},
     * {@code document_incomplete}, {@code document_invalid}, {@code document_manipulated}, {@code
     * document_missing_back}, {@code document_missing_front}, {@code document_not_readable}, {@code
     * document_not_uploaded}, {@code document_photo_mismatch}, {@code document_too_large}, or
     * {@code document_type_not_supported}. A machine-readable code specifying the verification
     * state for this document.
     */
    @SerializedName("details_code")
    String detailsCode;
    /**
     * The front of an ID returned by a <a href="https://stripe.com/docs/api#create_file">file
     * upload</a> with a {@code purpose} value of {@code identity_document}.
     */
    @SerializedName("front")
    ExpandableField<File> front;

    /** Get ID of expandable {@code back} object. */
    public String getBack() {
      return (this.back != null) ? this.back.getId() : null;
    }

    public void setBack(String id) {
      this.back = ApiResource.setExpandableFieldId(id, this.back);
    }

    /** Get expanded {@code back}. */
    public File getBackObject() {
      return (this.back != null) ? this.back.getExpanded() : null;
    }

    public void setBackObject(File expandableObject) {
      this.back = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    /** Get ID of expandable {@code front} object. */
    public String getFront() {
      return (this.front != null) ? this.front.getId() : null;
    }

    public void setFront(String id) {
      this.front = ApiResource.setExpandableFieldId(id, this.front);
    }

    /** Get expanded {@code front}. */
    public File getFrontObject() {
      return (this.front != null) ? this.front.getExpanded() : null;
    }

    public void setFrontObject(File expandableObject) {
      this.front = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDetails() {
      return this.details;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDetailsCode() {
      return this.detailsCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDetails(final String details) {
      this.details = details;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDetailsCode(final String detailsCode) {
      this.detailsCode = detailsCode;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Person.VerificationDocument)) return false;
      final Person.VerificationDocument other = (Person.VerificationDocument) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$back = this.getBack();
      final java.lang.Object other$back = other.getBack();
      if (this$back == null ? other$back != null : !this$back.equals(other$back)) return false;
      final java.lang.Object this$details = this.getDetails();
      final java.lang.Object other$details = other.getDetails();
      if (this$details == null ? other$details != null : !this$details.equals(other$details)) return false;
      final java.lang.Object this$detailsCode = this.getDetailsCode();
      final java.lang.Object other$detailsCode = other.getDetailsCode();
      if (this$detailsCode == null ? other$detailsCode != null : !this$detailsCode.equals(other$detailsCode)) return false;
      final java.lang.Object this$front = this.getFront();
      final java.lang.Object other$front = other.getFront();
      if (this$front == null ? other$front != null : !this$front.equals(other$front)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Person.VerificationDocument;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $back = this.getBack();
      result = result * PRIME + ($back == null ? 43 : $back.hashCode());
      final java.lang.Object $details = this.getDetails();
      result = result * PRIME + ($details == null ? 43 : $details.hashCode());
      final java.lang.Object $detailsCode = this.getDetailsCode();
      result = result * PRIME + ($detailsCode == null ? 43 : $detailsCode.hashCode());
      final java.lang.Object $front = this.getFront();
      result = result * PRIME + ($front == null ? 43 : $front.hashCode());
      return result;
    }
  }

  /**
   * The account the person is associated with.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAccount() {
    return this.account;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Address getAddress() {
    return this.address;
  }

  /**
   * The Kana variation of the person's address (Japan only).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public JapanAddress getAddressKana() {
    return this.addressKana;
  }

  /**
   * The Kanji variation of the person's address (Japan only).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public JapanAddress getAddressKanji() {
    return this.addressKanji;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DateOfBirth getDob() {
    return this.dob;
  }

  /**
   * The person's email address.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEmail() {
    return this.email;
  }

  /**
   * The person's first name.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFirstName() {
    return this.firstName;
  }

  /**
   * The Kana variation of the person's first name (Japan only).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFirstNameKana() {
    return this.firstNameKana;
  }

  /**
   * The Kanji variation of the person's first name (Japan only).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFirstNameKanji() {
    return this.firstNameKanji;
  }

  /**
   * The person's gender (International regulations require either &quot;male&quot; or
   * &quot;female&quot;).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getGender() {
    return this.gender;
  }

  /**
   * Whether the person's {@code id_number} was provided.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getIdNumberProvided() {
    return this.idNumberProvided;
  }

  /**
   * The person's last name.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLastName() {
    return this.lastName;
  }

  /**
   * The Kana variation of the person's last name (Japan only).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLastNameKana() {
    return this.lastNameKana;
  }

  /**
   * The Kanji variation of the person's last name (Japan only).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLastNameKanji() {
    return this.lastNameKanji;
  }

  /**
   * The person's maiden name.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getMaidenName() {
    return this.maidenName;
  }

  /**
   * The country where the person is a national.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getNationality() {
    return this.nationality;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code person}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The person's phone number.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPhone() {
    return this.phone;
  }

  /**
   * Indicates if the person or any of their representatives, family members, or other closely
   * related persons, declares that they hold or have held an important public job or function, in
   * any jurisdiction.
   *
   * <p>One of {@code existing}, or {@code none}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPoliticalExposure() {
    return this.politicalExposure;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Relationship getRelationship() {
    return this.relationship;
  }

  /**
   * Information about the requirements for this person, including what information needs to be
   * collected, and by when.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Requirements getRequirements() {
    return this.requirements;
  }

  /**
   * Whether the last four digits of the person's Social Security number have been provided (U.S.
   * only).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getSsnLast4Provided() {
    return this.ssnLast4Provided;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Verification getVerification() {
    return this.verification;
  }

  /**
   * The account the person is associated with.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAccount(final String account) {
    this.account = account;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAddress(final Address address) {
    this.address = address;
  }

  /**
   * The Kana variation of the person's address (Japan only).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAddressKana(final JapanAddress addressKana) {
    this.addressKana = addressKana;
  }

  /**
   * The Kanji variation of the person's address (Japan only).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAddressKanji(final JapanAddress addressKanji) {
    this.addressKanji = addressKanji;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDob(final DateOfBirth dob) {
    this.dob = dob;
  }

  /**
   * The person's email address.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEmail(final String email) {
    this.email = email;
  }

  /**
   * The person's first name.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFirstName(final String firstName) {
    this.firstName = firstName;
  }

  /**
   * The Kana variation of the person's first name (Japan only).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFirstNameKana(final String firstNameKana) {
    this.firstNameKana = firstNameKana;
  }

  /**
   * The Kanji variation of the person's first name (Japan only).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFirstNameKanji(final String firstNameKanji) {
    this.firstNameKanji = firstNameKanji;
  }

  /**
   * The person's gender (International regulations require either &quot;male&quot; or
   * &quot;female&quot;).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setGender(final String gender) {
    this.gender = gender;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Whether the person's {@code id_number} was provided.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIdNumberProvided(final Boolean idNumberProvided) {
    this.idNumberProvided = idNumberProvided;
  }

  /**
   * The person's last name.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLastName(final String lastName) {
    this.lastName = lastName;
  }

  /**
   * The Kana variation of the person's last name (Japan only).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLastNameKana(final String lastNameKana) {
    this.lastNameKana = lastNameKana;
  }

  /**
   * The Kanji variation of the person's last name (Japan only).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLastNameKanji(final String lastNameKanji) {
    this.lastNameKanji = lastNameKanji;
  }

  /**
   * The person's maiden name.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMaidenName(final String maidenName) {
    this.maidenName = maidenName;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * The country where the person is a national.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationality(final String nationality) {
    this.nationality = nationality;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code person}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The person's phone number.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPhone(final String phone) {
    this.phone = phone;
  }

  /**
   * Indicates if the person or any of their representatives, family members, or other closely
   * related persons, declares that they hold or have held an important public job or function, in
   * any jurisdiction.
   *
   * <p>One of {@code existing}, or {@code none}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPoliticalExposure(final String politicalExposure) {
    this.politicalExposure = politicalExposure;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRelationship(final Relationship relationship) {
    this.relationship = relationship;
  }

  /**
   * Information about the requirements for this person, including what information needs to be
   * collected, and by when.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRequirements(final Requirements requirements) {
    this.requirements = requirements;
  }

  /**
   * Whether the last four digits of the person's Social Security number have been provided (U.S.
   * only).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSsnLast4Provided(final Boolean ssnLast4Provided) {
    this.ssnLast4Provided = ssnLast4Provided;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVerification(final Verification verification) {
    this.verification = verification;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Person)) return false;
    final Person other = (Person) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$idNumberProvided = this.getIdNumberProvided();
    final java.lang.Object other$idNumberProvided = other.getIdNumberProvided();
    if (this$idNumberProvided == null ? other$idNumberProvided != null : !this$idNumberProvided.equals(other$idNumberProvided)) return false;
    final java.lang.Object this$ssnLast4Provided = this.getSsnLast4Provided();
    final java.lang.Object other$ssnLast4Provided = other.getSsnLast4Provided();
    if (this$ssnLast4Provided == null ? other$ssnLast4Provided != null : !this$ssnLast4Provided.equals(other$ssnLast4Provided)) return false;
    final java.lang.Object this$account = this.getAccount();
    final java.lang.Object other$account = other.getAccount();
    if (this$account == null ? other$account != null : !this$account.equals(other$account)) return false;
    final java.lang.Object this$address = this.getAddress();
    final java.lang.Object other$address = other.getAddress();
    if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
    final java.lang.Object this$addressKana = this.getAddressKana();
    final java.lang.Object other$addressKana = other.getAddressKana();
    if (this$addressKana == null ? other$addressKana != null : !this$addressKana.equals(other$addressKana)) return false;
    final java.lang.Object this$addressKanji = this.getAddressKanji();
    final java.lang.Object other$addressKanji = other.getAddressKanji();
    if (this$addressKanji == null ? other$addressKanji != null : !this$addressKanji.equals(other$addressKanji)) return false;
    final java.lang.Object this$dob = this.getDob();
    final java.lang.Object other$dob = other.getDob();
    if (this$dob == null ? other$dob != null : !this$dob.equals(other$dob)) return false;
    final java.lang.Object this$email = this.getEmail();
    final java.lang.Object other$email = other.getEmail();
    if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
    final java.lang.Object this$firstName = this.getFirstName();
    final java.lang.Object other$firstName = other.getFirstName();
    if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) return false;
    final java.lang.Object this$firstNameKana = this.getFirstNameKana();
    final java.lang.Object other$firstNameKana = other.getFirstNameKana();
    if (this$firstNameKana == null ? other$firstNameKana != null : !this$firstNameKana.equals(other$firstNameKana)) return false;
    final java.lang.Object this$firstNameKanji = this.getFirstNameKanji();
    final java.lang.Object other$firstNameKanji = other.getFirstNameKanji();
    if (this$firstNameKanji == null ? other$firstNameKanji != null : !this$firstNameKanji.equals(other$firstNameKanji)) return false;
    final java.lang.Object this$gender = this.getGender();
    final java.lang.Object other$gender = other.getGender();
    if (this$gender == null ? other$gender != null : !this$gender.equals(other$gender)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$lastName = this.getLastName();
    final java.lang.Object other$lastName = other.getLastName();
    if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) return false;
    final java.lang.Object this$lastNameKana = this.getLastNameKana();
    final java.lang.Object other$lastNameKana = other.getLastNameKana();
    if (this$lastNameKana == null ? other$lastNameKana != null : !this$lastNameKana.equals(other$lastNameKana)) return false;
    final java.lang.Object this$lastNameKanji = this.getLastNameKanji();
    final java.lang.Object other$lastNameKanji = other.getLastNameKanji();
    if (this$lastNameKanji == null ? other$lastNameKanji != null : !this$lastNameKanji.equals(other$lastNameKanji)) return false;
    final java.lang.Object this$maidenName = this.getMaidenName();
    final java.lang.Object other$maidenName = other.getMaidenName();
    if (this$maidenName == null ? other$maidenName != null : !this$maidenName.equals(other$maidenName)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$nationality = this.getNationality();
    final java.lang.Object other$nationality = other.getNationality();
    if (this$nationality == null ? other$nationality != null : !this$nationality.equals(other$nationality)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$phone = this.getPhone();
    final java.lang.Object other$phone = other.getPhone();
    if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) return false;
    final java.lang.Object this$politicalExposure = this.getPoliticalExposure();
    final java.lang.Object other$politicalExposure = other.getPoliticalExposure();
    if (this$politicalExposure == null ? other$politicalExposure != null : !this$politicalExposure.equals(other$politicalExposure)) return false;
    final java.lang.Object this$relationship = this.getRelationship();
    final java.lang.Object other$relationship = other.getRelationship();
    if (this$relationship == null ? other$relationship != null : !this$relationship.equals(other$relationship)) return false;
    final java.lang.Object this$requirements = this.getRequirements();
    final java.lang.Object other$requirements = other.getRequirements();
    if (this$requirements == null ? other$requirements != null : !this$requirements.equals(other$requirements)) return false;
    final java.lang.Object this$verification = this.getVerification();
    final java.lang.Object other$verification = other.getVerification();
    if (this$verification == null ? other$verification != null : !this$verification.equals(other$verification)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Person;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $idNumberProvided = this.getIdNumberProvided();
    result = result * PRIME + ($idNumberProvided == null ? 43 : $idNumberProvided.hashCode());
    final java.lang.Object $ssnLast4Provided = this.getSsnLast4Provided();
    result = result * PRIME + ($ssnLast4Provided == null ? 43 : $ssnLast4Provided.hashCode());
    final java.lang.Object $account = this.getAccount();
    result = result * PRIME + ($account == null ? 43 : $account.hashCode());
    final java.lang.Object $address = this.getAddress();
    result = result * PRIME + ($address == null ? 43 : $address.hashCode());
    final java.lang.Object $addressKana = this.getAddressKana();
    result = result * PRIME + ($addressKana == null ? 43 : $addressKana.hashCode());
    final java.lang.Object $addressKanji = this.getAddressKanji();
    result = result * PRIME + ($addressKanji == null ? 43 : $addressKanji.hashCode());
    final java.lang.Object $dob = this.getDob();
    result = result * PRIME + ($dob == null ? 43 : $dob.hashCode());
    final java.lang.Object $email = this.getEmail();
    result = result * PRIME + ($email == null ? 43 : $email.hashCode());
    final java.lang.Object $firstName = this.getFirstName();
    result = result * PRIME + ($firstName == null ? 43 : $firstName.hashCode());
    final java.lang.Object $firstNameKana = this.getFirstNameKana();
    result = result * PRIME + ($firstNameKana == null ? 43 : $firstNameKana.hashCode());
    final java.lang.Object $firstNameKanji = this.getFirstNameKanji();
    result = result * PRIME + ($firstNameKanji == null ? 43 : $firstNameKanji.hashCode());
    final java.lang.Object $gender = this.getGender();
    result = result * PRIME + ($gender == null ? 43 : $gender.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $lastName = this.getLastName();
    result = result * PRIME + ($lastName == null ? 43 : $lastName.hashCode());
    final java.lang.Object $lastNameKana = this.getLastNameKana();
    result = result * PRIME + ($lastNameKana == null ? 43 : $lastNameKana.hashCode());
    final java.lang.Object $lastNameKanji = this.getLastNameKanji();
    result = result * PRIME + ($lastNameKanji == null ? 43 : $lastNameKanji.hashCode());
    final java.lang.Object $maidenName = this.getMaidenName();
    result = result * PRIME + ($maidenName == null ? 43 : $maidenName.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $nationality = this.getNationality();
    result = result * PRIME + ($nationality == null ? 43 : $nationality.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $phone = this.getPhone();
    result = result * PRIME + ($phone == null ? 43 : $phone.hashCode());
    final java.lang.Object $politicalExposure = this.getPoliticalExposure();
    result = result * PRIME + ($politicalExposure == null ? 43 : $politicalExposure.hashCode());
    final java.lang.Object $relationship = this.getRelationship();
    result = result * PRIME + ($relationship == null ? 43 : $relationship.hashCode());
    final java.lang.Object $requirements = this.getRequirements();
    result = result * PRIME + ($requirements == null ? 43 : $requirements.hashCode());
    final java.lang.Object $verification = this.getVerification();
    result = result * PRIME + ($verification == null ? 43 : $verification.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
