// Generated by delombok at Thu Mar 25 15:41:27 EDT 2021
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.ApplicationFeeListParams;
import com.stripe.param.ApplicationFeeRetrieveParams;
import java.util.Map;

public class ApplicationFee extends ApiResource implements BalanceTransactionSource {
  /**
   * ID of the Stripe account this fee was taken from.
   */
  @SerializedName("account")
  ExpandableField<Account> account;
  /**
   * Amount earned, in %s.
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Amount in %s refunded (can be less than the amount attribute on the fee if a partial refund was
   * issued).
   */
  @SerializedName("amount_refunded")
  Long amountRefunded;
  /**
   * ID of the Connect application that earned the fee.
   */
  @SerializedName("application")
  ExpandableField<Application> application;
  /**
   * Balance transaction that describes the impact of this collected application fee on your account
   * balance (not including refunds).
   */
  @SerializedName("balance_transaction")
  ExpandableField<BalanceTransaction> balanceTransaction;
  /**
   * ID of the charge that the application fee was taken from.
   */
  @SerializedName("charge")
  ExpandableField<Charge> charge;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code application_fee}.
   */
  @SerializedName("object")
  String object;
  /**
   * ID of the corresponding charge on the platform account, if this fee was the result of a charge
   * using the {@code destination} parameter.
   */
  @SerializedName("originating_transaction")
  ExpandableField<Charge> originatingTransaction;
  /**
   * Whether the fee has been fully refunded. If the fee is only partially refunded, this attribute
   * will still be false.
   */
  @SerializedName("refunded")
  Boolean refunded;
  /**
   * A list of refunds that have been applied to the fee.
   */
  @SerializedName("refunds")
  FeeRefundCollection refunds;

  /**
   * Get ID of expandable {@code account} object.
   */
  public String getAccount() {
    return (this.account != null) ? this.account.getId() : null;
  }

  public void setAccount(String id) {
    this.account = ApiResource.setExpandableFieldId(id, this.account);
  }

  /**
   * Get expanded {@code account}.
   */
  public Account getAccountObject() {
    return (this.account != null) ? this.account.getExpanded() : null;
  }

  public void setAccountObject(Account expandableObject) {
    this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code application} object.
   */
  public String getApplication() {
    return (this.application != null) ? this.application.getId() : null;
  }

  public void setApplication(String id) {
    this.application = ApiResource.setExpandableFieldId(id, this.application);
  }

  /**
   * Get expanded {@code application}.
   */
  public Application getApplicationObject() {
    return (this.application != null) ? this.application.getExpanded() : null;
  }

  public void setApplicationObject(Application expandableObject) {
    this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code balanceTransaction} object.
   */
  public String getBalanceTransaction() {
    return (this.balanceTransaction != null) ? this.balanceTransaction.getId() : null;
  }

  public void setBalanceTransaction(String id) {
    this.balanceTransaction = ApiResource.setExpandableFieldId(id, this.balanceTransaction);
  }

  /**
   * Get expanded {@code balanceTransaction}.
   */
  public BalanceTransaction getBalanceTransactionObject() {
    return (this.balanceTransaction != null) ? this.balanceTransaction.getExpanded() : null;
  }

  public void setBalanceTransactionObject(BalanceTransaction expandableObject) {
    this.balanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code charge} object.
   */
  public String getCharge() {
    return (this.charge != null) ? this.charge.getId() : null;
  }

  public void setCharge(String id) {
    this.charge = ApiResource.setExpandableFieldId(id, this.charge);
  }

  /**
   * Get expanded {@code charge}.
   */
  public Charge getChargeObject() {
    return (this.charge != null) ? this.charge.getExpanded() : null;
  }

  public void setChargeObject(Charge expandableObject) {
    this.charge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code originatingTransaction} object.
   */
  public String getOriginatingTransaction() {
    return (this.originatingTransaction != null) ? this.originatingTransaction.getId() : null;
  }

  public void setOriginatingTransaction(String id) {
    this.originatingTransaction = ApiResource.setExpandableFieldId(id, this.originatingTransaction);
  }

  /**
   * Get expanded {@code originatingTransaction}.
   */
  public Charge getOriginatingTransactionObject() {
    return (this.originatingTransaction != null) ? this.originatingTransaction.getExpanded() : null;
  }

  public void setOriginatingTransactionObject(Charge expandableObject) {
    this.originatingTransaction = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
  }

  /**
   * Returns a list of application fees you’ve previously collected. The application fees are
   * returned in sorted order, with the most recent fees appearing first.
   */
  public static ApplicationFeeCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of application fees you’ve previously collected. The application fees are
   * returned in sorted order, with the most recent fees appearing first.
   */
  public static ApplicationFeeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/application_fees");
    return ApiResource.requestCollection(url, params, ApplicationFeeCollection.class, options);
  }

  /**
   * Returns a list of application fees you’ve previously collected. The application fees are
   * returned in sorted order, with the most recent fees appearing first.
   */
  public static ApplicationFeeCollection list(ApplicationFeeListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of application fees you’ve previously collected. The application fees are
   * returned in sorted order, with the most recent fees appearing first.
   */
  public static ApplicationFeeCollection list(ApplicationFeeListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/application_fees");
    return ApiResource.requestCollection(url, params, ApplicationFeeCollection.class, options);
  }

  /**
   * Retrieves the details of an application fee that your account has collected. The same
   * information is returned when refunding the application fee.
   */
  public static ApplicationFee retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an application fee that your account has collected. The same
   * information is returned when refunding the application fee.
   */
  public static ApplicationFee retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an application fee that your account has collected. The same
   * information is returned when refunding the application fee.
   */
  public static ApplicationFee retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/application_fees/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ApplicationFee.class, options);
  }

  /**
   * Retrieves the details of an application fee that your account has collected. The same
   * information is returned when refunding the application fee.
   */
  public static ApplicationFee retrieve(String id, ApplicationFeeRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/application_fees/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ApplicationFee.class, options);
  }

  /**
   * Amount earned, in %s.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Amount in %s refunded (can be less than the amount attribute on the fee if a partial refund was
   * issued).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountRefunded() {
    return this.amountRefunded;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code application_fee}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Whether the fee has been fully refunded. If the fee is only partially refunded, this attribute
   * will still be false.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getRefunded() {
    return this.refunded;
  }

  /**
   * A list of refunds that have been applied to the fee.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public FeeRefundCollection getRefunds() {
    return this.refunds;
  }

  /**
   * Amount earned, in %s.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Amount in %s refunded (can be less than the amount attribute on the fee if a partial refund was
   * issued).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountRefunded(final Long amountRefunded) {
    this.amountRefunded = amountRefunded;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code application_fee}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Whether the fee has been fully refunded. If the fee is only partially refunded, this attribute
   * will still be false.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRefunded(final Boolean refunded) {
    this.refunded = refunded;
  }

  /**
   * A list of refunds that have been applied to the fee.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRefunds(final FeeRefundCollection refunds) {
    this.refunds = refunds;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ApplicationFee)) return false;
    final ApplicationFee other = (ApplicationFee) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$amountRefunded = this.getAmountRefunded();
    final java.lang.Object other$amountRefunded = other.getAmountRefunded();
    if (this$amountRefunded == null ? other$amountRefunded != null : !this$amountRefunded.equals(other$amountRefunded)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$refunded = this.getRefunded();
    final java.lang.Object other$refunded = other.getRefunded();
    if (this$refunded == null ? other$refunded != null : !this$refunded.equals(other$refunded)) return false;
    final java.lang.Object this$account = this.getAccount();
    final java.lang.Object other$account = other.getAccount();
    if (this$account == null ? other$account != null : !this$account.equals(other$account)) return false;
    final java.lang.Object this$application = this.getApplication();
    final java.lang.Object other$application = other.getApplication();
    if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
    final java.lang.Object this$balanceTransaction = this.getBalanceTransaction();
    final java.lang.Object other$balanceTransaction = other.getBalanceTransaction();
    if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) return false;
    final java.lang.Object this$charge = this.getCharge();
    final java.lang.Object other$charge = other.getCharge();
    if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$originatingTransaction = this.getOriginatingTransaction();
    final java.lang.Object other$originatingTransaction = other.getOriginatingTransaction();
    if (this$originatingTransaction == null ? other$originatingTransaction != null : !this$originatingTransaction.equals(other$originatingTransaction)) return false;
    final java.lang.Object this$refunds = this.getRefunds();
    final java.lang.Object other$refunds = other.getRefunds();
    if (this$refunds == null ? other$refunds != null : !this$refunds.equals(other$refunds)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ApplicationFee;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $amountRefunded = this.getAmountRefunded();
    result = result * PRIME + ($amountRefunded == null ? 43 : $amountRefunded.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $refunded = this.getRefunded();
    result = result * PRIME + ($refunded == null ? 43 : $refunded.hashCode());
    final java.lang.Object $account = this.getAccount();
    result = result * PRIME + ($account == null ? 43 : $account.hashCode());
    final java.lang.Object $application = this.getApplication();
    result = result * PRIME + ($application == null ? 43 : $application.hashCode());
    final java.lang.Object $balanceTransaction = this.getBalanceTransaction();
    result = result * PRIME + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
    final java.lang.Object $charge = this.getCharge();
    result = result * PRIME + ($charge == null ? 43 : $charge.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $originatingTransaction = this.getOriginatingTransaction();
    result = result * PRIME + ($originatingTransaction == null ? 43 : $originatingTransaction.hashCode());
    final java.lang.Object $refunds = this.getRefunds();
    result = result * PRIME + ($refunds == null ? 43 : $refunds.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
