/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Application;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Mandate;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentMethod;
import com.stripe.model.SetupAttempt;
import com.stripe.model.SetupIntentCollection;
import com.stripe.model.StripeError;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.SetupIntentCancelParams;
import com.stripe.param.SetupIntentConfirmParams;
import com.stripe.param.SetupIntentCreateParams;
import com.stripe.param.SetupIntentListParams;
import com.stripe.param.SetupIntentRetrieveParams;
import com.stripe.param.SetupIntentUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SetupIntent
extends ApiResource
implements HasId,
MetadataStore<SetupIntent> {
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="cancellation_reason")
    String cancellationReason;
    @SerializedName(value="client_secret")
    String clientSecret;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="last_setup_error")
    StripeError lastSetupError;
    @SerializedName(value="latest_attempt")
    ExpandableField<SetupAttempt> latestAttempt;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="mandate")
    ExpandableField<Mandate> mandate;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="next_action")
    NextAction nextAction;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="on_behalf_of")
    ExpandableField<Account> onBehalfOf;
    @SerializedName(value="payment_method")
    ExpandableField<PaymentMethod> paymentMethod;
    @SerializedName(value="payment_method_options")
    PaymentMethodOptions paymentMethodOptions;
    @SerializedName(value="payment_method_types")
    List<String> paymentMethodTypes;
    @SerializedName(value="single_use_mandate")
    ExpandableField<Mandate> singleUseMandate;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="usage")
    String usage;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getLatestAttempt() {
        return this.latestAttempt != null ? this.latestAttempt.getId() : null;
    }

    public void setLatestAttempt(String id) {
        this.latestAttempt = ApiResource.setExpandableFieldId(id, this.latestAttempt);
    }

    public SetupAttempt getLatestAttemptObject() {
        return this.latestAttempt != null ? this.latestAttempt.getExpanded() : null;
    }

    public void setLatestAttemptObject(SetupAttempt expandableObject) {
        this.latestAttempt = new ExpandableField<SetupAttempt>(expandableObject.getId(), expandableObject);
    }

    public String getMandate() {
        return this.mandate != null ? this.mandate.getId() : null;
    }

    public void setMandate(String id) {
        this.mandate = ApiResource.setExpandableFieldId(id, this.mandate);
    }

    public Mandate getMandateObject() {
        return this.mandate != null ? this.mandate.getExpanded() : null;
    }

    public void setMandateObject(Mandate expandableObject) {
        this.mandate = new ExpandableField<Mandate>(expandableObject.getId(), expandableObject);
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String id) {
        this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
    }

    public Account getOnBehalfOfObject() {
        return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account expandableObject) {
        this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentMethod() {
        return this.paymentMethod != null ? this.paymentMethod.getId() : null;
    }

    public void setPaymentMethod(String id) {
        this.paymentMethod = ApiResource.setExpandableFieldId(id, this.paymentMethod);
    }

    public PaymentMethod getPaymentMethodObject() {
        return this.paymentMethod != null ? this.paymentMethod.getExpanded() : null;
    }

    public void setPaymentMethodObject(PaymentMethod expandableObject) {
        this.paymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
    }

    public String getSingleUseMandate() {
        return this.singleUseMandate != null ? this.singleUseMandate.getId() : null;
    }

    public void setSingleUseMandate(String id) {
        this.singleUseMandate = ApiResource.setExpandableFieldId(id, this.singleUseMandate);
    }

    public Mandate getSingleUseMandateObject() {
        return this.singleUseMandate != null ? this.singleUseMandate.getExpanded() : null;
    }

    public void setSingleUseMandateObject(Mandate expandableObject) {
        this.singleUseMandate = new ExpandableField<Mandate>(expandableObject.getId(), expandableObject);
    }

    public static SetupIntent create(Map<String, Object> params) throws StripeException {
        return SetupIntent.create(params, (RequestOptions)null);
    }

    public static SetupIntent create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/setup_intents");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
    }

    public static SetupIntent create(SetupIntentCreateParams params) throws StripeException {
        return SetupIntent.create(params, (RequestOptions)null);
    }

    public static SetupIntent create(SetupIntentCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/setup_intents");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
    }

    public static SetupIntentCollection list(Map<String, Object> params) throws StripeException {
        return SetupIntent.list(params, (RequestOptions)null);
    }

    public static SetupIntentCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/setup_intents");
        return ApiResource.requestCollection(url, params, SetupIntentCollection.class, options);
    }

    public static SetupIntentCollection list(SetupIntentListParams params) throws StripeException {
        return SetupIntent.list(params, (RequestOptions)null);
    }

    public static SetupIntentCollection list(SetupIntentListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/setup_intents");
        return ApiResource.requestCollection(url, params, SetupIntentCollection.class, options);
    }

    public static SetupIntent retrieve(String intent) throws StripeException {
        return SetupIntent.retrieve(intent, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static SetupIntent retrieve(String intent, RequestOptions options) throws StripeException {
        return SetupIntent.retrieve(intent, (Map<String, Object>)null, options);
    }

    public static SetupIntent retrieve(String intent, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s", ApiResource.urlEncodeId(intent)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SetupIntent.class, options);
    }

    public static SetupIntent retrieve(String intent, SetupIntentRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s", ApiResource.urlEncodeId(intent)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SetupIntent.class, options);
    }

    public SetupIntent update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public SetupIntent update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
    }

    public SetupIntent update(SetupIntentUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public SetupIntent update(SetupIntentUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
    }

    public SetupIntent confirm() throws StripeException {
        return this.confirm((Map<String, Object>)null, (RequestOptions)null);
    }

    public SetupIntent confirm(RequestOptions options) throws StripeException {
        return this.confirm((Map<String, Object>)null, options);
    }

    public SetupIntent confirm(Map<String, Object> params) throws StripeException {
        return this.confirm(params, (RequestOptions)null);
    }

    public SetupIntent confirm(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s/confirm", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
    }

    public SetupIntent confirm(SetupIntentConfirmParams params) throws StripeException {
        return this.confirm(params, (RequestOptions)null);
    }

    public SetupIntent confirm(SetupIntentConfirmParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s/confirm", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
    }

    public SetupIntent cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public SetupIntent cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public SetupIntent cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public SetupIntent cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
    }

    public SetupIntent cancel(SetupIntentCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public SetupIntent cancel(SetupIntentCancelParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/setup_intents/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SetupIntent.class, options);
    }

    @Generated
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public StripeError getLastSetupError() {
        return this.lastSetupError;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public NextAction getNextAction() {
        return this.nextAction;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PaymentMethodOptions getPaymentMethodOptions() {
        return this.paymentMethodOptions;
    }

    @Generated
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getUsage() {
        return this.usage;
    }

    @Generated
    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLastSetupError(StripeError lastSetupError) {
        this.lastSetupError = lastSetupError;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNextAction(NextAction nextAction) {
        this.nextAction = nextAction;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
        this.paymentMethodOptions = paymentMethodOptions;
    }

    @Generated
    public void setPaymentMethodTypes(List<String> paymentMethodTypes) {
        this.paymentMethodTypes = paymentMethodTypes;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setUsage(String usage) {
        this.usage = usage;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetupIntent)) {
            return false;
        }
        SetupIntent other = (SetupIntent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$cancellationReason = this.getCancellationReason();
        String other$cancellationReason = other.getCancellationReason();
        if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        StripeError this$lastSetupError = this.getLastSetupError();
        StripeError other$lastSetupError = other.getLastSetupError();
        if (this$lastSetupError == null ? other$lastSetupError != null : !((Object)this$lastSetupError).equals(other$lastSetupError)) {
            return false;
        }
        String this$latestAttempt = this.getLatestAttempt();
        String other$latestAttempt = other.getLatestAttempt();
        if (this$latestAttempt == null ? other$latestAttempt != null : !this$latestAttempt.equals(other$latestAttempt)) {
            return false;
        }
        String this$mandate = this.getMandate();
        String other$mandate = other.getMandate();
        if (this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        NextAction this$nextAction = this.getNextAction();
        NextAction other$nextAction = other.getNextAction();
        if (this$nextAction == null ? other$nextAction != null : !((Object)this$nextAction).equals(other$nextAction)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        PaymentMethodOptions this$paymentMethodOptions = this.getPaymentMethodOptions();
        PaymentMethodOptions other$paymentMethodOptions = other.getPaymentMethodOptions();
        if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !((Object)this$paymentMethodOptions).equals(other$paymentMethodOptions)) {
            return false;
        }
        List<String> this$paymentMethodTypes = this.getPaymentMethodTypes();
        List<String> other$paymentMethodTypes = other.getPaymentMethodTypes();
        if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !((Object)this$paymentMethodTypes).equals(other$paymentMethodTypes)) {
            return false;
        }
        String this$singleUseMandate = this.getSingleUseMandate();
        String other$singleUseMandate = other.getSingleUseMandate();
        if (this$singleUseMandate == null ? other$singleUseMandate != null : !this$singleUseMandate.equals(other$singleUseMandate)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$usage = this.getUsage();
        String other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !this$usage.equals(other$usage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetupIntent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $cancellationReason = this.getCancellationReason();
        result = result * 59 + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        StripeError $lastSetupError = this.getLastSetupError();
        result = result * 59 + ($lastSetupError == null ? 43 : ((Object)$lastSetupError).hashCode());
        String $latestAttempt = this.getLatestAttempt();
        result = result * 59 + ($latestAttempt == null ? 43 : $latestAttempt.hashCode());
        String $mandate = this.getMandate();
        result = result * 59 + ($mandate == null ? 43 : $mandate.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        NextAction $nextAction = this.getNextAction();
        result = result * 59 + ($nextAction == null ? 43 : ((Object)$nextAction).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        PaymentMethodOptions $paymentMethodOptions = this.getPaymentMethodOptions();
        result = result * 59 + ($paymentMethodOptions == null ? 43 : ((Object)$paymentMethodOptions).hashCode());
        List<String> $paymentMethodTypes = this.getPaymentMethodTypes();
        result = result * 59 + ($paymentMethodTypes == null ? 43 : ((Object)$paymentMethodTypes).hashCode());
        String $singleUseMandate = this.getSingleUseMandate();
        result = result * 59 + ($singleUseMandate == null ? 43 : $singleUseMandate.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class PaymentMethodOptions
    extends StripeObject {
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="sepa_debit")
        SepaDebit sepaDebit;

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public SepaDebit getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setSepaDebit(SepaDebit sepaDebit) {
            this.sepaDebit = sepaDebit;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodOptions)) {
                return false;
            }
            PaymentMethodOptions other = (PaymentMethodOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            SepaDebit this$sepaDebit = this.getSepaDebit();
            SepaDebit other$sepaDebit = other.getSepaDebit();
            return !(this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            SepaDebit $sepaDebit = this.getSepaDebit();
            result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
            return result;
        }

        public static class SepaDebitMandateOptions
        extends StripeObject {
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaDebitMandateOptions)) {
                    return false;
                }
                SepaDebitMandateOptions other = (SepaDebitMandateOptions)o;
                return other.canEqual(this);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaDebitMandateOptions;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }
        }

        public static class SepaDebit
        extends StripeObject {
            @SerializedName(value="mandate_options")
            SepaDebitMandateOptions mandateOptions;

            @Generated
            public SepaDebitMandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public void setMandateOptions(SepaDebitMandateOptions mandateOptions) {
                this.mandateOptions = mandateOptions;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaDebit)) {
                    return false;
                }
                SepaDebit other = (SepaDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                SepaDebitMandateOptions this$mandateOptions = this.getMandateOptions();
                SepaDebitMandateOptions other$mandateOptions = other.getMandateOptions();
                return !(this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                SepaDebitMandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                return result;
            }
        }

        public static class Card
        extends StripeObject {
            @SerializedName(value="request_three_d_secure")
            String requestThreeDSecure;

            @Generated
            public String getRequestThreeDSecure() {
                return this.requestThreeDSecure;
            }

            @Generated
            public void setRequestThreeDSecure(String requestThreeDSecure) {
                this.requestThreeDSecure = requestThreeDSecure;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$requestThreeDSecure = this.getRequestThreeDSecure();
                String other$requestThreeDSecure = other.getRequestThreeDSecure();
                return !(this$requestThreeDSecure == null ? other$requestThreeDSecure != null : !this$requestThreeDSecure.equals(other$requestThreeDSecure));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $requestThreeDSecure = this.getRequestThreeDSecure();
                result = result * 59 + ($requestThreeDSecure == null ? 43 : $requestThreeDSecure.hashCode());
                return result;
            }
        }
    }

    public static class NextActionRedirectToUrl
    extends StripeObject {
        @SerializedName(value="return_url")
        String returnUrl;
        @SerializedName(value="url")
        String url;

        @Generated
        public String getReturnUrl() {
            return this.returnUrl;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setReturnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextActionRedirectToUrl)) {
                return false;
            }
            NextActionRedirectToUrl other = (NextActionRedirectToUrl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$returnUrl = this.getReturnUrl();
            String other$returnUrl = other.getReturnUrl();
            if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NextActionRedirectToUrl;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $returnUrl = this.getReturnUrl();
            result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }
    }

    public static class NextAction
    extends StripeObject {
        @SerializedName(value="redirect_to_url")
        NextActionRedirectToUrl redirectToUrl;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="use_stripe_sdk")
        Map<String, Object> useStripeSdk;

        @Generated
        public NextActionRedirectToUrl getRedirectToUrl() {
            return this.redirectToUrl;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Map<String, Object> getUseStripeSdk() {
            return this.useStripeSdk;
        }

        @Generated
        public void setRedirectToUrl(NextActionRedirectToUrl redirectToUrl) {
            this.redirectToUrl = redirectToUrl;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUseStripeSdk(Map<String, Object> useStripeSdk) {
            this.useStripeSdk = useStripeSdk;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextAction)) {
                return false;
            }
            NextAction other = (NextAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            NextActionRedirectToUrl this$redirectToUrl = this.getRedirectToUrl();
            NextActionRedirectToUrl other$redirectToUrl = other.getRedirectToUrl();
            if (this$redirectToUrl == null ? other$redirectToUrl != null : !((Object)this$redirectToUrl).equals(other$redirectToUrl)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Map<String, Object> this$useStripeSdk = this.getUseStripeSdk();
            Map<String, Object> other$useStripeSdk = other.getUseStripeSdk();
            return !(this$useStripeSdk == null ? other$useStripeSdk != null : !((Object)this$useStripeSdk).equals(other$useStripeSdk));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NextAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            NextActionRedirectToUrl $redirectToUrl = this.getRedirectToUrl();
            result = result * 59 + ($redirectToUrl == null ? 43 : ((Object)$redirectToUrl).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Map<String, Object> $useStripeSdk = this.getUseStripeSdk();
            result = result * 59 + ($useStripeSdk == null ? 43 : ((Object)$useStripeSdk).hashCode());
            return result;
        }
    }
}

