// Generated by delombok at Fri Mar 26 16:55:53 EDT 2021
// File generated from our OpenAPI spec
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.issuing.CardCreateParams;
import com.stripe.param.issuing.CardListParams;
import com.stripe.param.issuing.CardRetrieveParams;
import com.stripe.param.issuing.CardUpdateParams;
import java.util.List;
import java.util.Map;

public class Card extends ApiResource implements HasId, MetadataStore<Card> {
  /**
   * The brand of the card.
   */
  @SerializedName("brand")
  String brand;
  /**
   * The reason why the card was canceled.
   *
   * <p>One of {@code lost}, or {@code stolen}.
   */
  @SerializedName("cancellation_reason")
  String cancellationReason;
  /**
   * An Issuing {@code Cardholder} object represents an individual or business entity who is <a
   * href="https://stripe.com/docs/issuing">issued</a> cards.
   *
   * <p>Related guide: <a href="https://stripe.com/docs/issuing/cards#create-cardholder">How to
   * create a Cardholder</a>
   */
  @SerializedName("cardholder")
  Cardholder cardholder;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * The card's CVC. For security reasons, this is only available for virtual cards, and will be
   * omitted unless you explicitly request it with <a
   * href="https://stripe.com/docs/api/expanding_objects">the {@code expand} parameter</a>.
   * Additionally, it's only available via the <a
   * href="https://stripe.com/docs/api/issuing/cards/retrieve">&quot;Retrieve a card&quot;
   * endpoint</a>, not via &quot;List all cards&quot; or any other endpoint.
   */
  @SerializedName("cvc")
  String cvc;
  /**
   * The expiration month of the card.
   */
  @SerializedName("exp_month")
  Long expMonth;
  /**
   * The expiration year of the card.
   */
  @SerializedName("exp_year")
  Long expYear;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * The last 4 digits of the card number.
   */
  @SerializedName("last4")
  String last4;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * The full unredacted card number. For security reasons, this is only available for virtual
   * cards, and will be omitted unless you explicitly request it with <a
   * href="https://stripe.com/docs/api/expanding_objects">the {@code expand} parameter</a>.
   * Additionally, it's only available via the <a
   * href="https://stripe.com/docs/api/issuing/cards/retrieve">&quot;Retrieve a card&quot;
   * endpoint</a>, not via &quot;List all cards&quot; or any other endpoint.
   */
  @SerializedName("number")
  String number;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code issuing.card}.
   */
  @SerializedName("object")
  String object;
  /**
   * The latest card that replaces this card, if any.
   */
  @SerializedName("replaced_by")
  ExpandableField<Card> replacedBy;
  /**
   * The card this card replaces, if any.
   */
  @SerializedName("replacement_for")
  ExpandableField<Card> replacementFor;
  /**
   * The reason why the previous card needed to be replaced.
   *
   * <p>One of {@code damaged}, {@code expired}, {@code lost}, or {@code stolen}.
   */
  @SerializedName("replacement_reason")
  String replacementReason;
  /**
   * Where and how the card will be shipped.
   */
  @SerializedName("shipping")
  Shipping shipping;
  @SerializedName("spending_controls")
  SpendingControls spendingControls;
  /**
   * Whether authorizations can be approved on this card.
   *
   * <p>One of {@code active}, {@code canceled}, or {@code inactive}.
   */
  @SerializedName("status")
  String status;
  /**
   * The type of the card.
   *
   * <p>One of {@code physical}, or {@code virtual}.
   */
  @SerializedName("type")
  String type;

  /**
   * Get ID of expandable {@code replacedBy} object.
   */
  public String getReplacedBy() {
    return (this.replacedBy != null) ? this.replacedBy.getId() : null;
  }

  public void setReplacedBy(String id) {
    this.replacedBy = ApiResource.setExpandableFieldId(id, this.replacedBy);
  }

  /**
   * Get expanded {@code replacedBy}.
   */
  public Card getReplacedByObject() {
    return (this.replacedBy != null) ? this.replacedBy.getExpanded() : null;
  }

  public void setReplacedByObject(Card expandableObject) {
    this.replacedBy = new ExpandableField<Card>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code replacementFor} object.
   */
  public String getReplacementFor() {
    return (this.replacementFor != null) ? this.replacementFor.getId() : null;
  }

  public void setReplacementFor(String id) {
    this.replacementFor = ApiResource.setExpandableFieldId(id, this.replacementFor);
  }

  /**
   * Get expanded {@code replacementFor}.
   */
  public Card getReplacementForObject() {
    return (this.replacementFor != null) ? this.replacementFor.getExpanded() : null;
  }

  public void setReplacementForObject(Card expandableObject) {
    this.replacementFor = new ExpandableField<Card>(expandableObject.getId(), expandableObject);
  }

  /**
   * Returns a list of Issuing <code>Card</code> objects. The objects are sorted in descending order
   * by creation date, with the most recently created object appearing first.
   */
  public static CardCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of Issuing <code>Card</code> objects. The objects are sorted in descending order
   * by creation date, with the most recently created object appearing first.
   */
  public static CardCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cards");
    return ApiResource.requestCollection(url, params, CardCollection.class, options);
  }

  /**
   * Returns a list of Issuing <code>Card</code> objects. The objects are sorted in descending order
   * by creation date, with the most recently created object appearing first.
   */
  public static CardCollection list(CardListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of Issuing <code>Card</code> objects. The objects are sorted in descending order
   * by creation date, with the most recently created object appearing first.
   */
  public static CardCollection list(CardListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cards");
    return ApiResource.requestCollection(url, params, CardCollection.class, options);
  }

  /**
   * Creates an Issuing <code>Card</code> object.
   */
  public static Card create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates an Issuing <code>Card</code> object.
   */
  public static Card create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cards");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
  }

  /**
   * Creates an Issuing <code>Card</code> object.
   */
  public static Card create(CardCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates an Issuing <code>Card</code> object.
   */
  public static Card create(CardCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cards");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
  }

  /**
   * Retrieves an Issuing <code>Card</code> object.
   */
  public static Card retrieve(String card) throws StripeException {
    return retrieve(card, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves an Issuing <code>Card</code> object.
   */
  public static Card retrieve(String card, RequestOptions options) throws StripeException {
    return retrieve(card, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves an Issuing <code>Card</code> object.
   */
  public static Card retrieve(String card, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cards/%s", ApiResource.urlEncodeId(card)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Card.class, options);
  }

  /**
   * Retrieves an Issuing <code>Card</code> object.
   */
  public static Card retrieve(String card, CardRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cards/%s", ApiResource.urlEncodeId(card)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Card.class, options);
  }

  /**
   * Updates the specified Issuing <code>Card</code> object by setting the values of the parameters
   * passed. Any parameters not provided will be left unchanged.
   */
  @Override
  public Card update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified Issuing <code>Card</code> object by setting the values of the parameters
   * passed. Any parameters not provided will be left unchanged.
   */
  @Override
  public Card update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cards/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
  }

  /**
   * Updates the specified Issuing <code>Card</code> object by setting the values of the parameters
   * passed. Any parameters not provided will be left unchanged.
   */
  public Card update(CardUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified Issuing <code>Card</code> object by setting the values of the parameters
   * passed. Any parameters not provided will be left unchanged.
   */
  public Card update(CardUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cards/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
  }


  public static class Shipping extends StripeObject {
    @SerializedName("address")
    Address address;
    /**
     * The delivery company that shipped a card.
     *
     * <p>One of {@code fedex}, or {@code usps}.
     */
    @SerializedName("carrier")
    String carrier;
    /**
     * A unix timestamp representing a best estimate of when the card will be delivered.
     */
    @SerializedName("eta")
    Long eta;
    /**
     * Recipient name.
     */
    @SerializedName("name")
    String name;
    /**
     * Shipment service, such as {@code standard} or {@code express}.
     *
     * <p>One of {@code express}, {@code priority}, or {@code standard}.
     */
    @SerializedName("service")
    String service;
    /**
     * The delivery status of the card.
     *
     * <p>One of {@code canceled}, {@code delivered}, {@code failure}, {@code pending}, {@code
     * returned}, or {@code shipped}.
     */
    @SerializedName("status")
    String status;
    /**
     * A tracking number for a card shipment.
     */
    @SerializedName("tracking_number")
    String trackingNumber;
    /**
     * A link to the shipping carrier's site where you can view detailed information about a card
     * shipment.
     */
    @SerializedName("tracking_url")
    String trackingUrl;
    /**
     * Packaging options.
     *
     * <p>One of {@code bulk}, or {@code individual}.
     */
    @SerializedName("type")
    String type;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Address getAddress() {
      return this.address;
    }

    /**
     * The delivery company that shipped a card.
     *
     * <p>One of {@code fedex}, or {@code usps}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCarrier() {
      return this.carrier;
    }

    /**
     * A unix timestamp representing a best estimate of when the card will be delivered.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getEta() {
      return this.eta;
    }

    /**
     * Recipient name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    /**
     * Shipment service, such as {@code standard} or {@code express}.
     *
     * <p>One of {@code express}, {@code priority}, or {@code standard}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getService() {
      return this.service;
    }

    /**
     * The delivery status of the card.
     *
     * <p>One of {@code canceled}, {@code delivered}, {@code failure}, {@code pending}, {@code
     * returned}, or {@code shipped}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    /**
     * A tracking number for a card shipment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTrackingNumber() {
      return this.trackingNumber;
    }

    /**
     * A link to the shipping carrier's site where you can view detailed information about a card
     * shipment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTrackingUrl() {
      return this.trackingUrl;
    }

    /**
     * Packaging options.
     *
     * <p>One of {@code bulk}, or {@code individual}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddress(final Address address) {
      this.address = address;
    }

    /**
     * The delivery company that shipped a card.
     *
     * <p>One of {@code fedex}, or {@code usps}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCarrier(final String carrier) {
      this.carrier = carrier;
    }

    /**
     * A unix timestamp representing a best estimate of when the card will be delivered.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEta(final Long eta) {
      this.eta = eta;
    }

    /**
     * Recipient name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
      this.name = name;
    }

    /**
     * Shipment service, such as {@code standard} or {@code express}.
     *
     * <p>One of {@code express}, {@code priority}, or {@code standard}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setService(final String service) {
      this.service = service;
    }

    /**
     * The delivery status of the card.
     *
     * <p>One of {@code canceled}, {@code delivered}, {@code failure}, {@code pending}, {@code
     * returned}, or {@code shipped}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    /**
     * A tracking number for a card shipment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTrackingNumber(final String trackingNumber) {
      this.trackingNumber = trackingNumber;
    }

    /**
     * A link to the shipping carrier's site where you can view detailed information about a card
     * shipment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTrackingUrl(final String trackingUrl) {
      this.trackingUrl = trackingUrl;
    }

    /**
     * Packaging options.
     *
     * <p>One of {@code bulk}, or {@code individual}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Card.Shipping)) return false;
      final Card.Shipping other = (Card.Shipping) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$eta = this.getEta();
      final java.lang.Object other$eta = other.getEta();
      if (this$eta == null ? other$eta != null : !this$eta.equals(other$eta)) return false;
      final java.lang.Object this$address = this.getAddress();
      final java.lang.Object other$address = other.getAddress();
      if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
      final java.lang.Object this$carrier = this.getCarrier();
      final java.lang.Object other$carrier = other.getCarrier();
      if (this$carrier == null ? other$carrier != null : !this$carrier.equals(other$carrier)) return false;
      final java.lang.Object this$name = this.getName();
      final java.lang.Object other$name = other.getName();
      if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
      final java.lang.Object this$service = this.getService();
      final java.lang.Object other$service = other.getService();
      if (this$service == null ? other$service != null : !this$service.equals(other$service)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      final java.lang.Object this$trackingNumber = this.getTrackingNumber();
      final java.lang.Object other$trackingNumber = other.getTrackingNumber();
      if (this$trackingNumber == null ? other$trackingNumber != null : !this$trackingNumber.equals(other$trackingNumber)) return false;
      final java.lang.Object this$trackingUrl = this.getTrackingUrl();
      final java.lang.Object other$trackingUrl = other.getTrackingUrl();
      if (this$trackingUrl == null ? other$trackingUrl != null : !this$trackingUrl.equals(other$trackingUrl)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Card.Shipping;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $eta = this.getEta();
      result = result * PRIME + ($eta == null ? 43 : $eta.hashCode());
      final java.lang.Object $address = this.getAddress();
      result = result * PRIME + ($address == null ? 43 : $address.hashCode());
      final java.lang.Object $carrier = this.getCarrier();
      result = result * PRIME + ($carrier == null ? 43 : $carrier.hashCode());
      final java.lang.Object $name = this.getName();
      result = result * PRIME + ($name == null ? 43 : $name.hashCode());
      final java.lang.Object $service = this.getService();
      result = result * PRIME + ($service == null ? 43 : $service.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      final java.lang.Object $trackingNumber = this.getTrackingNumber();
      result = result * PRIME + ($trackingNumber == null ? 43 : $trackingNumber.hashCode());
      final java.lang.Object $trackingUrl = this.getTrackingUrl();
      result = result * PRIME + ($trackingUrl == null ? 43 : $trackingUrl.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }


  public static class SpendingControls extends StripeObject {
    /**
     * Array of strings containing <a
     * href="https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category">categories</a>
     * of authorizations to allow. All other categories will be blocked. Cannot be set with {@code
     * blocked_categories}.
     */
    @SerializedName("allowed_categories")
    List<String> allowedCategories;
    /**
     * Array of strings containing <a
     * href="https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category">categories</a>
     * of authorizations to decline. All other categories will be allowed. Cannot be set with {@code
     * allowed_categories}.
     */
    @SerializedName("blocked_categories")
    List<String> blockedCategories;
    /**
     * Limit spending with amount-based rules that apply across any cards this card replaced (i.e.,
     * its {@code replacement_for} card and <em>that</em> card's {@code replacement_for} card, up
     * the chain).
     */
    @SerializedName("spending_limits")
    List<Card.SpendingControls.SpendingLimit> spendingLimits;
    /**
     * Currency of the amounts within {@code spending_limits}. Always the same as the currency of
     * the card.
     */
    @SerializedName("spending_limits_currency")
    String spendingLimitsCurrency;


    public static class SpendingLimit extends StripeObject {
      /** Maximum amount allowed to spend per interval. */
      @SerializedName("amount")
      Long amount;
      /**
       * Array of strings containing <a
       * href="https://stripe.com/docs/api#issuing_authorization_object-merchant_data-category">categories</a>
       * this limit applies to. Omitting this field will apply the limit to all categories.
       */
      @SerializedName("categories")
      List<String> categories;
      /**
       * Interval (or event) to which the amount applies.
       *
       * <p>One of {@code all_time}, {@code daily}, {@code monthly}, {@code per_authorization},
       * {@code weekly}, or {@code yearly}.
       */
      @SerializedName("interval")
      String interval;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getAmount() {
        return this.amount;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getCategories() {
        return this.categories;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getInterval() {
        return this.interval;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAmount(final Long amount) {
        this.amount = amount;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCategories(final List<String> categories) {
        this.categories = categories;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setInterval(final String interval) {
        this.interval = interval;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Card.SpendingControls.SpendingLimit)) return false;
        final Card.SpendingControls.SpendingLimit other = (Card.SpendingControls.SpendingLimit) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$amount = this.getAmount();
        final java.lang.Object other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
        final java.lang.Object this$categories = this.getCategories();
        final java.lang.Object other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !this$categories.equals(other$categories)) return false;
        final java.lang.Object this$interval = this.getInterval();
        final java.lang.Object other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Card.SpendingControls.SpendingLimit;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $amount = this.getAmount();
        result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
        final java.lang.Object $categories = this.getCategories();
        result = result * PRIME + ($categories == null ? 43 : $categories.hashCode());
        final java.lang.Object $interval = this.getInterval();
        result = result * PRIME + ($interval == null ? 43 : $interval.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getAllowedCategories() {
      return this.allowedCategories;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getBlockedCategories() {
      return this.blockedCategories;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Card.SpendingControls.SpendingLimit> getSpendingLimits() {
      return this.spendingLimits;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSpendingLimitsCurrency() {
      return this.spendingLimitsCurrency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAllowedCategories(final List<String> allowedCategories) {
      this.allowedCategories = allowedCategories;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBlockedCategories(final List<String> blockedCategories) {
      this.blockedCategories = blockedCategories;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSpendingLimits(final List<Card.SpendingControls.SpendingLimit> spendingLimits) {
      this.spendingLimits = spendingLimits;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSpendingLimitsCurrency(final String spendingLimitsCurrency) {
      this.spendingLimitsCurrency = spendingLimitsCurrency;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Card.SpendingControls)) return false;
      final Card.SpendingControls other = (Card.SpendingControls) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$allowedCategories = this.getAllowedCategories();
      final java.lang.Object other$allowedCategories = other.getAllowedCategories();
      if (this$allowedCategories == null ? other$allowedCategories != null : !this$allowedCategories.equals(other$allowedCategories)) return false;
      final java.lang.Object this$blockedCategories = this.getBlockedCategories();
      final java.lang.Object other$blockedCategories = other.getBlockedCategories();
      if (this$blockedCategories == null ? other$blockedCategories != null : !this$blockedCategories.equals(other$blockedCategories)) return false;
      final java.lang.Object this$spendingLimits = this.getSpendingLimits();
      final java.lang.Object other$spendingLimits = other.getSpendingLimits();
      if (this$spendingLimits == null ? other$spendingLimits != null : !this$spendingLimits.equals(other$spendingLimits)) return false;
      final java.lang.Object this$spendingLimitsCurrency = this.getSpendingLimitsCurrency();
      final java.lang.Object other$spendingLimitsCurrency = other.getSpendingLimitsCurrency();
      if (this$spendingLimitsCurrency == null ? other$spendingLimitsCurrency != null : !this$spendingLimitsCurrency.equals(other$spendingLimitsCurrency)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Card.SpendingControls;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $allowedCategories = this.getAllowedCategories();
      result = result * PRIME + ($allowedCategories == null ? 43 : $allowedCategories.hashCode());
      final java.lang.Object $blockedCategories = this.getBlockedCategories();
      result = result * PRIME + ($blockedCategories == null ? 43 : $blockedCategories.hashCode());
      final java.lang.Object $spendingLimits = this.getSpendingLimits();
      result = result * PRIME + ($spendingLimits == null ? 43 : $spendingLimits.hashCode());
      final java.lang.Object $spendingLimitsCurrency = this.getSpendingLimitsCurrency();
      result = result * PRIME + ($spendingLimitsCurrency == null ? 43 : $spendingLimitsCurrency.hashCode());
      return result;
    }
  }

  /**
   * The brand of the card.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBrand() {
    return this.brand;
  }

  /**
   * The reason why the card was canceled.
   *
   * <p>One of {@code lost}, or {@code stolen}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCancellationReason() {
    return this.cancellationReason;
  }

  /**
   * An Issuing {@code Cardholder} object represents an individual or business entity who is <a
   * href="https://stripe.com/docs/issuing">issued</a> cards.
   *
   * <p>Related guide: <a href="https://stripe.com/docs/issuing/cards#create-cardholder">How to
   * create a Cardholder</a>
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Cardholder getCardholder() {
    return this.cardholder;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * The card's CVC. For security reasons, this is only available for virtual cards, and will be
   * omitted unless you explicitly request it with <a
   * href="https://stripe.com/docs/api/expanding_objects">the {@code expand} parameter</a>.
   * Additionally, it's only available via the <a
   * href="https://stripe.com/docs/api/issuing/cards/retrieve">&quot;Retrieve a card&quot;
   * endpoint</a>, not via &quot;List all cards&quot; or any other endpoint.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCvc() {
    return this.cvc;
  }

  /**
   * The expiration month of the card.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getExpMonth() {
    return this.expMonth;
  }

  /**
   * The expiration year of the card.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getExpYear() {
    return this.expYear;
  }

  /**
   * The last 4 digits of the card number.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLast4() {
    return this.last4;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * The full unredacted card number. For security reasons, this is only available for virtual
   * cards, and will be omitted unless you explicitly request it with <a
   * href="https://stripe.com/docs/api/expanding_objects">the {@code expand} parameter</a>.
   * Additionally, it's only available via the <a
   * href="https://stripe.com/docs/api/issuing/cards/retrieve">&quot;Retrieve a card&quot;
   * endpoint</a>, not via &quot;List all cards&quot; or any other endpoint.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getNumber() {
    return this.number;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code issuing.card}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The reason why the previous card needed to be replaced.
   *
   * <p>One of {@code damaged}, {@code expired}, {@code lost}, or {@code stolen}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReplacementReason() {
    return this.replacementReason;
  }

  /**
   * Where and how the card will be shipped.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Shipping getShipping() {
    return this.shipping;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public SpendingControls getSpendingControls() {
    return this.spendingControls;
  }

  /**
   * Whether authorizations can be approved on this card.
   *
   * <p>One of {@code active}, {@code canceled}, or {@code inactive}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * The type of the card.
   *
   * <p>One of {@code physical}, or {@code virtual}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * The brand of the card.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBrand(final String brand) {
    this.brand = brand;
  }

  /**
   * The reason why the card was canceled.
   *
   * <p>One of {@code lost}, or {@code stolen}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCancellationReason(final String cancellationReason) {
    this.cancellationReason = cancellationReason;
  }

  /**
   * An Issuing {@code Cardholder} object represents an individual or business entity who is <a
   * href="https://stripe.com/docs/issuing">issued</a> cards.
   *
   * <p>Related guide: <a href="https://stripe.com/docs/issuing/cards#create-cardholder">How to
   * create a Cardholder</a>
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCardholder(final Cardholder cardholder) {
    this.cardholder = cardholder;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * The card's CVC. For security reasons, this is only available for virtual cards, and will be
   * omitted unless you explicitly request it with <a
   * href="https://stripe.com/docs/api/expanding_objects">the {@code expand} parameter</a>.
   * Additionally, it's only available via the <a
   * href="https://stripe.com/docs/api/issuing/cards/retrieve">&quot;Retrieve a card&quot;
   * endpoint</a>, not via &quot;List all cards&quot; or any other endpoint.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCvc(final String cvc) {
    this.cvc = cvc;
  }

  /**
   * The expiration month of the card.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExpMonth(final Long expMonth) {
    this.expMonth = expMonth;
  }

  /**
   * The expiration year of the card.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExpYear(final Long expYear) {
    this.expYear = expYear;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The last 4 digits of the card number.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLast4(final String last4) {
    this.last4 = last4;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * The full unredacted card number. For security reasons, this is only available for virtual
   * cards, and will be omitted unless you explicitly request it with <a
   * href="https://stripe.com/docs/api/expanding_objects">the {@code expand} parameter</a>.
   * Additionally, it's only available via the <a
   * href="https://stripe.com/docs/api/issuing/cards/retrieve">&quot;Retrieve a card&quot;
   * endpoint</a>, not via &quot;List all cards&quot; or any other endpoint.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNumber(final String number) {
    this.number = number;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code issuing.card}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The reason why the previous card needed to be replaced.
   *
   * <p>One of {@code damaged}, {@code expired}, {@code lost}, or {@code stolen}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReplacementReason(final String replacementReason) {
    this.replacementReason = replacementReason;
  }

  /**
   * Where and how the card will be shipped.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShipping(final Shipping shipping) {
    this.shipping = shipping;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSpendingControls(final SpendingControls spendingControls) {
    this.spendingControls = spendingControls;
  }

  /**
   * Whether authorizations can be approved on this card.
   *
   * <p>One of {@code active}, {@code canceled}, or {@code inactive}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * The type of the card.
   *
   * <p>One of {@code physical}, or {@code virtual}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Card)) return false;
    final Card other = (Card) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$expMonth = this.getExpMonth();
    final java.lang.Object other$expMonth = other.getExpMonth();
    if (this$expMonth == null ? other$expMonth != null : !this$expMonth.equals(other$expMonth)) return false;
    final java.lang.Object this$expYear = this.getExpYear();
    final java.lang.Object other$expYear = other.getExpYear();
    if (this$expYear == null ? other$expYear != null : !this$expYear.equals(other$expYear)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$brand = this.getBrand();
    final java.lang.Object other$brand = other.getBrand();
    if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) return false;
    final java.lang.Object this$cancellationReason = this.getCancellationReason();
    final java.lang.Object other$cancellationReason = other.getCancellationReason();
    if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) return false;
    final java.lang.Object this$cardholder = this.getCardholder();
    final java.lang.Object other$cardholder = other.getCardholder();
    if (this$cardholder == null ? other$cardholder != null : !this$cardholder.equals(other$cardholder)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$cvc = this.getCvc();
    final java.lang.Object other$cvc = other.getCvc();
    if (this$cvc == null ? other$cvc != null : !this$cvc.equals(other$cvc)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$last4 = this.getLast4();
    final java.lang.Object other$last4 = other.getLast4();
    if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$number = this.getNumber();
    final java.lang.Object other$number = other.getNumber();
    if (this$number == null ? other$number != null : !this$number.equals(other$number)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$replacedBy = this.getReplacedBy();
    final java.lang.Object other$replacedBy = other.getReplacedBy();
    if (this$replacedBy == null ? other$replacedBy != null : !this$replacedBy.equals(other$replacedBy)) return false;
    final java.lang.Object this$replacementFor = this.getReplacementFor();
    final java.lang.Object other$replacementFor = other.getReplacementFor();
    if (this$replacementFor == null ? other$replacementFor != null : !this$replacementFor.equals(other$replacementFor)) return false;
    final java.lang.Object this$replacementReason = this.getReplacementReason();
    final java.lang.Object other$replacementReason = other.getReplacementReason();
    if (this$replacementReason == null ? other$replacementReason != null : !this$replacementReason.equals(other$replacementReason)) return false;
    final java.lang.Object this$shipping = this.getShipping();
    final java.lang.Object other$shipping = other.getShipping();
    if (this$shipping == null ? other$shipping != null : !this$shipping.equals(other$shipping)) return false;
    final java.lang.Object this$spendingControls = this.getSpendingControls();
    final java.lang.Object other$spendingControls = other.getSpendingControls();
    if (this$spendingControls == null ? other$spendingControls != null : !this$spendingControls.equals(other$spendingControls)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Card;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $expMonth = this.getExpMonth();
    result = result * PRIME + ($expMonth == null ? 43 : $expMonth.hashCode());
    final java.lang.Object $expYear = this.getExpYear();
    result = result * PRIME + ($expYear == null ? 43 : $expYear.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $brand = this.getBrand();
    result = result * PRIME + ($brand == null ? 43 : $brand.hashCode());
    final java.lang.Object $cancellationReason = this.getCancellationReason();
    result = result * PRIME + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
    final java.lang.Object $cardholder = this.getCardholder();
    result = result * PRIME + ($cardholder == null ? 43 : $cardholder.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $cvc = this.getCvc();
    result = result * PRIME + ($cvc == null ? 43 : $cvc.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $last4 = this.getLast4();
    result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $number = this.getNumber();
    result = result * PRIME + ($number == null ? 43 : $number.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $replacedBy = this.getReplacedBy();
    result = result * PRIME + ($replacedBy == null ? 43 : $replacedBy.hashCode());
    final java.lang.Object $replacementFor = this.getReplacementFor();
    result = result * PRIME + ($replacementFor == null ? 43 : $replacementFor.hashCode());
    final java.lang.Object $replacementReason = this.getReplacementReason();
    result = result * PRIME + ($replacementReason == null ? 43 : $replacementReason.hashCode());
    final java.lang.Object $shipping = this.getShipping();
    result = result * PRIME + ($shipping == null ? 43 : $shipping.hashCode());
    final java.lang.Object $spendingControls = this.getSpendingControls();
    result = result * PRIME + ($spendingControls == null ? 43 : $spendingControls.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
