// Generated by delombok at Wed May 05 19:45:50 EDT 2021
// File generated from our OpenAPI spec
package com.stripe.model.radar;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.radar.ValueListItemCreateParams;
import com.stripe.param.radar.ValueListItemListParams;
import com.stripe.param.radar.ValueListItemRetrieveParams;
import java.util.Map;

public class ValueListItem extends ApiResource implements HasId {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * The name or email address of the user who added this item to the value list.
   */
  @SerializedName("created_by")
  String createdBy;
  /**
   * Always true for a deleted object.
   */
  @SerializedName("deleted")
  Boolean deleted;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code radar.value_list_item}.
   */
  @SerializedName("object")
  String object;
  /**
   * The value of the item.
   */
  @SerializedName("value")
  String value;
  /**
   * The identifier of the value list this item belongs to.
   */
  @SerializedName("value_list")
  String valueList;

  /**
   * Returns a list of <code>ValueListItem</code> objects. The objects are sorted in descending
   * order by creation date, with the most recently created object appearing first.
   */
  public static ValueListItemCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of <code>ValueListItem</code> objects. The objects are sorted in descending
   * order by creation date, with the most recently created object appearing first.
   */
  public static ValueListItemCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/radar/value_list_items");
    return ApiResource.requestCollection(url, params, ValueListItemCollection.class, options);
  }

  /**
   * Returns a list of <code>ValueListItem</code> objects. The objects are sorted in descending
   * order by creation date, with the most recently created object appearing first.
   */
  public static ValueListItemCollection list(ValueListItemListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of <code>ValueListItem</code> objects. The objects are sorted in descending
   * order by creation date, with the most recently created object appearing first.
   */
  public static ValueListItemCollection list(ValueListItemListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/radar/value_list_items");
    return ApiResource.requestCollection(url, params, ValueListItemCollection.class, options);
  }

  /**
   * Retrieves a <code>ValueListItem</code> object.
   */
  public static ValueListItem retrieve(String item) throws StripeException {
    return retrieve(item, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves a <code>ValueListItem</code> object.
   */
  public static ValueListItem retrieve(String item, RequestOptions options) throws StripeException {
    return retrieve(item, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves a <code>ValueListItem</code> object.
   */
  public static ValueListItem retrieve(String item, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/radar/value_list_items/%s", ApiResource.urlEncodeId(item)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ValueListItem.class, options);
  }

  /**
   * Retrieves a <code>ValueListItem</code> object.
   */
  public static ValueListItem retrieve(String item, ValueListItemRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/radar/value_list_items/%s", ApiResource.urlEncodeId(item)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ValueListItem.class, options);
  }

  /**
   * Creates a new <code>ValueListItem</code> object, which is added to the specified parent value
   * list.
   */
  public static ValueListItem create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new <code>ValueListItem</code> object, which is added to the specified parent value
   * list.
   */
  public static ValueListItem create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/radar/value_list_items");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ValueListItem.class, options);
  }

  /**
   * Creates a new <code>ValueListItem</code> object, which is added to the specified parent value
   * list.
   */
  public static ValueListItem create(ValueListItemCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new <code>ValueListItem</code> object, which is added to the specified parent value
   * list.
   */
  public static ValueListItem create(ValueListItemCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/radar/value_list_items");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ValueListItem.class, options);
  }

  /**
   * Deletes a <code>ValueListItem</code> object, removing it from its parent value list.
   */
  public ValueListItem delete() throws StripeException {
    return delete((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Deletes a <code>ValueListItem</code> object, removing it from its parent value list.
   */
  public ValueListItem delete(RequestOptions options) throws StripeException {
    return delete((Map<String, Object>) null, options);
  }

  /**
   * Deletes a <code>ValueListItem</code> object, removing it from its parent value list.
   */
  public ValueListItem delete(Map<String, Object> params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * Deletes a <code>ValueListItem</code> object, removing it from its parent value list.
   */
  public ValueListItem delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/radar/value_list_items/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, ValueListItem.class, options);
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * The name or email address of the user who added this item to the value list.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCreatedBy() {
    return this.createdBy;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code radar.value_list_item}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The value of the item.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getValue() {
    return this.value;
  }

  /**
   * The identifier of the value list this item belongs to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getValueList() {
    return this.valueList;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * The name or email address of the user who added this item to the value list.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreatedBy(final String createdBy) {
    this.createdBy = createdBy;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code radar.value_list_item}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The value of the item.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setValue(final String value) {
    this.value = value;
  }

  /**
   * The identifier of the value list this item belongs to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setValueList(final String valueList) {
    this.valueList = valueList;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ValueListItem)) return false;
    final ValueListItem other = (ValueListItem) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$createdBy = this.getCreatedBy();
    final java.lang.Object other$createdBy = other.getCreatedBy();
    if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$value = this.getValue();
    final java.lang.Object other$value = other.getValue();
    if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
    final java.lang.Object this$valueList = this.getValueList();
    final java.lang.Object other$valueList = other.getValueList();
    if (this$valueList == null ? other$valueList != null : !this$valueList.equals(other$valueList)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ValueListItem;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $createdBy = this.getCreatedBy();
    result = result * PRIME + ($createdBy == null ? 43 : $createdBy.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $value = this.getValue();
    result = result * PRIME + ($value == null ? 43 : $value.hashCode());
    final java.lang.Object $valueList = this.getValueList();
    result = result * PRIME + ($valueList == null ? 43 : $valueList.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
