// Generated by delombok at Fri Jun 18 00:48:01 EDT 2021
// File generated from our OpenAPI spec
package com.stripe.model.sigma;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.File;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.sigma.ScheduledQueryRunListParams;
import com.stripe.param.sigma.ScheduledQueryRunRetrieveParams;
import java.util.Map;

public class ScheduledQueryRun extends ApiResource implements HasId {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * When the query was run, Sigma contained a snapshot of your Stripe data at this time.
   */
  @SerializedName("data_load_time")
  Long dataLoadTime;
  @SerializedName("error")
  RunError error;
  /**
   * The file object representing the results of the query.
   */
  @SerializedName("file")
  File file;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code scheduled_query_run}.
   */
  @SerializedName("object")
  String object;
  /**
   * Time at which the result expires and is no longer available for download.
   */
  @SerializedName("result_available_until")
  Long resultAvailableUntil;
  /**
   * SQL for the query.
   */
  @SerializedName("sql")
  String sql;
  /**
   * The query's execution status, which will be {@code completed} for successful runs, and {@code
   * canceled}, {@code failed}, or {@code timed_out} otherwise.
   */
  @SerializedName("status")
  String status;
  /**
   * Title of the query.
   */
  @SerializedName("title")
  String title;

  /**
   * Returns a list of scheduled query runs.
   */
  public static ScheduledQueryRunCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of scheduled query runs.
   */
  public static ScheduledQueryRunCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/sigma/scheduled_query_runs");
    return ApiResource.requestCollection(url, params, ScheduledQueryRunCollection.class, options);
  }

  /**
   * Returns a list of scheduled query runs.
   */
  public static ScheduledQueryRunCollection list(ScheduledQueryRunListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of scheduled query runs.
   */
  public static ScheduledQueryRunCollection list(ScheduledQueryRunListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/sigma/scheduled_query_runs");
    return ApiResource.requestCollection(url, params, ScheduledQueryRunCollection.class, options);
  }

  /**
   * Retrieves the details of an scheduled query run.
   */
  public static ScheduledQueryRun retrieve(String scheduledQueryRun) throws StripeException {
    return retrieve(scheduledQueryRun, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an scheduled query run.
   */
  public static ScheduledQueryRun retrieve(String scheduledQueryRun, RequestOptions options) throws StripeException {
    return retrieve(scheduledQueryRun, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an scheduled query run.
   */
  public static ScheduledQueryRun retrieve(String scheduledQueryRun, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sigma/scheduled_query_runs/%s", ApiResource.urlEncodeId(scheduledQueryRun)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ScheduledQueryRun.class, options);
  }

  /**
   * Retrieves the details of an scheduled query run.
   */
  public static ScheduledQueryRun retrieve(String scheduledQueryRun, ScheduledQueryRunRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/sigma/scheduled_query_runs/%s", ApiResource.urlEncodeId(scheduledQueryRun)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ScheduledQueryRun.class, options);
  }


  public static class RunError extends StripeObject {
    /** Information about the run failure. */
    @SerializedName("message")
    String message;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMessage() {
      return this.message;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMessage(final String message) {
      this.message = message;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof ScheduledQueryRun.RunError)) return false;
      final ScheduledQueryRun.RunError other = (ScheduledQueryRun.RunError) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$message = this.getMessage();
      final java.lang.Object other$message = other.getMessage();
      if (this$message == null ? other$message != null : !this$message.equals(other$message)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof ScheduledQueryRun.RunError;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $message = this.getMessage();
      result = result * PRIME + ($message == null ? 43 : $message.hashCode());
      return result;
    }
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * When the query was run, Sigma contained a snapshot of your Stripe data at this time.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getDataLoadTime() {
    return this.dataLoadTime;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public RunError getError() {
    return this.error;
  }

  /**
   * The file object representing the results of the query.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public File getFile() {
    return this.file;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code scheduled_query_run}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Time at which the result expires and is no longer available for download.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getResultAvailableUntil() {
    return this.resultAvailableUntil;
  }

  /**
   * SQL for the query.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSql() {
    return this.sql;
  }

  /**
   * The query's execution status, which will be {@code completed} for successful runs, and {@code
   * canceled}, {@code failed}, or {@code timed_out} otherwise.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * Title of the query.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTitle() {
    return this.title;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * When the query was run, Sigma contained a snapshot of your Stripe data at this time.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDataLoadTime(final Long dataLoadTime) {
    this.dataLoadTime = dataLoadTime;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setError(final RunError error) {
    this.error = error;
  }

  /**
   * The file object representing the results of the query.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFile(final File file) {
    this.file = file;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code scheduled_query_run}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Time at which the result expires and is no longer available for download.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setResultAvailableUntil(final Long resultAvailableUntil) {
    this.resultAvailableUntil = resultAvailableUntil;
  }

  /**
   * SQL for the query.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSql(final String sql) {
    this.sql = sql;
  }

  /**
   * The query's execution status, which will be {@code completed} for successful runs, and {@code
   * canceled}, {@code failed}, or {@code timed_out} otherwise.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * Title of the query.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTitle(final String title) {
    this.title = title;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ScheduledQueryRun)) return false;
    final ScheduledQueryRun other = (ScheduledQueryRun) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$dataLoadTime = this.getDataLoadTime();
    final java.lang.Object other$dataLoadTime = other.getDataLoadTime();
    if (this$dataLoadTime == null ? other$dataLoadTime != null : !this$dataLoadTime.equals(other$dataLoadTime)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$resultAvailableUntil = this.getResultAvailableUntil();
    final java.lang.Object other$resultAvailableUntil = other.getResultAvailableUntil();
    if (this$resultAvailableUntil == null ? other$resultAvailableUntil != null : !this$resultAvailableUntil.equals(other$resultAvailableUntil)) return false;
    final java.lang.Object this$error = this.getError();
    final java.lang.Object other$error = other.getError();
    if (this$error == null ? other$error != null : !this$error.equals(other$error)) return false;
    final java.lang.Object this$file = this.getFile();
    final java.lang.Object other$file = other.getFile();
    if (this$file == null ? other$file != null : !this$file.equals(other$file)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$sql = this.getSql();
    final java.lang.Object other$sql = other.getSql();
    if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$title = this.getTitle();
    final java.lang.Object other$title = other.getTitle();
    if (this$title == null ? other$title != null : !this$title.equals(other$title)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ScheduledQueryRun;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $dataLoadTime = this.getDataLoadTime();
    result = result * PRIME + ($dataLoadTime == null ? 43 : $dataLoadTime.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $resultAvailableUntil = this.getResultAvailableUntil();
    result = result * PRIME + ($resultAvailableUntil == null ? 43 : $resultAvailableUntil.hashCode());
    final java.lang.Object $error = this.getError();
    result = result * PRIME + ($error == null ? 43 : $error.hashCode());
    final java.lang.Object $file = this.getFile();
    result = result * PRIME + ($file == null ? 43 : $file.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $sql = this.getSql();
    result = result * PRIME + ($sql == null ? 43 : $sql.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $title = this.getTitle();
    result = result * PRIME + ($title == null ? 43 : $title.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
