/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.Stripe;
import com.stripe.exception.ApiConnectionException;
import com.stripe.net.ApiResource;
import com.stripe.net.HttpClient;
import com.stripe.net.HttpHeaders;
import com.stripe.net.StripeRequest;
import com.stripe.net.StripeResponse;
import com.stripe.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpURLConnectionClient
extends HttpClient {
    @Override
    public StripeResponse request(StripeRequest request) throws ApiConnectionException {
        try {
            HttpURLConnection conn = HttpURLConnectionClient.createStripeConnection(request);
            int responseCode = conn.getResponseCode();
            HttpHeaders headers = HttpHeaders.of(conn.getHeaderFields());
            InputStream responseStream = responseCode >= 200 && responseCode < 300 ? conn.getInputStream() : conn.getErrorStream();
            String responseBody = StreamUtils.readToEnd(responseStream, ApiResource.CHARSET);
            responseStream.close();
            return new StripeResponse(responseCode, headers, responseBody);
        }
        catch (IOException e) {
            throw new ApiConnectionException(String.format("IOException during API request to Stripe (%s): %s Please check your internet connection and try again. If this problem persists,you should check Stripe's service status at https://twitter.com/stripestatus, or let us know at support@stripe.com.", Stripe.getApiBase(), e.getMessage()), e);
        }
    }

    static HttpHeaders getHeaders(StripeRequest request) {
        HashMap<String, List<String>> userAgentHeadersMap = new HashMap<String, List<String>>();
        userAgentHeadersMap.put("User-Agent", Arrays.asList(HttpURLConnectionClient.buildUserAgentString()));
        userAgentHeadersMap.put("X-Stripe-Client-User-Agent", Arrays.asList(HttpURLConnectionClient.buildXStripeClientUserAgentString()));
        return request.headers().withAdditionalHeaders(userAgentHeadersMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection createStripeConnection(final StripeRequest request) throws IOException, ApiConnectionException {
        HttpURLConnection conn = null;
        if (request.options().getConnectionProxy() != null) {
            conn = (HttpURLConnection)request.url().openConnection(request.options().getConnectionProxy());
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return request.options().getProxyCredential();
                }
            });
        } else {
            conn = (HttpURLConnection)request.url().openConnection();
        }
        conn.setConnectTimeout(request.options().getConnectTimeout());
        conn.setReadTimeout(request.options().getReadTimeout());
        conn.setUseCaches(false);
        for (Map.Entry<String, List<String>> entry : HttpURLConnectionClient.getHeaders(request).map().entrySet()) {
            conn.setRequestProperty(entry.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
        }
        conn.setRequestMethod(request.method().name());
        if (request.content() != null) {
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", request.content().contentType());
            OutputStream output = conn.getOutputStream();
            try {
                output.write(request.content().byteArrayContent());
            }
            finally {
                if (Collections.singletonList(output).get(0) != null) {
                    output.close();
                }
            }
        }
        return conn;
    }
}

