// Generated by delombok at Fri Jul 09 22:22:26 EDT 2021
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.InvalidRequestException;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.BankAccountUpdateOnAccountParams;
import com.stripe.param.BankAccountUpdateOnCustomerParams;
import com.stripe.param.BankAccountVerifyParams;
import java.util.List;
import java.util.Map;

public class BankAccount extends ApiResource implements MetadataStore<BankAccount>, ExternalAccount, PaymentSource {
  /**
   * The ID of the account that the bank account is associated with.
   */
  @SerializedName("account")
  ExpandableField<Account> account;
  /**
   * The name of the person or business that owns the bank account.
   */
  @SerializedName("account_holder_name")
  String accountHolderName;
  /**
   * The type of entity that holds the account. This can be either {@code individual} or {@code
   * company}.
   */
  @SerializedName("account_holder_type")
  String accountHolderType;
  /**
   * A set of available payout methods for this bank account. Only values from this set should be
   * passed as the {@code method} when creating a payout.
   */
  @SerializedName("available_payout_methods")
  List<String> availablePayoutMethods;
  /**
   * Name of the bank associated with the routing number (e.g., {@code WELLS FARGO}).
   */
  @SerializedName("bank_name")
  String bankName;
  /**
   * Two-letter ISO code representing the country the bank account is located in.
   */
  @SerializedName("country")
  String country;
  /**
   * Three-letter <a href="https://stripe.com/docs/payouts">ISO code for the currency</a> paid out
   * to the bank account.
   */
  @SerializedName("currency")
  String currency;
  /**
   * The ID of the customer that the bank account is associated with.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  /**
   * Whether this bank account is the default external account for its currency.
   */
  @SerializedName("default_for_currency")
  Boolean defaultForCurrency;
  /**
   * Always true for a deleted object.
   */
  @SerializedName("deleted")
  Boolean deleted;
  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether
   * two bank accounts are the same.
   */
  @SerializedName("fingerprint")
  String fingerprint;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * The last four digits of the bank account number.
   */
  @SerializedName("last4")
  String last4;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code bank_account}.
   */
  @SerializedName("object")
  String object;
  /**
   * The routing transit number for the bank account.
   */
  @SerializedName("routing_number")
  String routingNumber;
  /**
   * For bank accounts, possible values are {@code new}, {@code validated}, {@code verified}, {@code
   * verification_failed}, or {@code errored}. A bank account that hasn't had any activity or
   * validation performed is {@code new}. If Stripe can determine that the bank account exists, its
   * status will be {@code validated}. Note that there often isn’t enough information to know (e.g.,
   * for smaller credit unions), and the validation is not always run. If customer bank account
   * verification has succeeded, the bank account status will be {@code verified}. If the
   * verification failed for any reason, such as microdeposit failure, the status will be {@code
   * verification_failed}. If a transfer sent to this bank account fails, we'll set the status to
   * {@code errored} and will not continue to send transfers until the bank details are updated.
   *
   * <p>For external accounts, possible values are {@code new} and {@code errored}. Validations
   * aren't run against external accounts because they're only used for payouts. This means the
   * other statuses don't apply. If a transfer fails, the status is set to {@code errored} and
   * transfers are stopped until account details are updated.
   */
  @SerializedName("status")
  String status;

  /**
   * Get ID of expandable {@code account} object.
   */
  public String getAccount() {
    return (this.account != null) ? this.account.getId() : null;
  }

  public void setAccount(String id) {
    this.account = ApiResource.setExpandableFieldId(id, this.account);
  }

  /**
   * Get expanded {@code account}.
   */
  public Account getAccountObject() {
    return (this.account != null) ? this.account.getExpanded() : null;
  }

  public void setAccountObject(Account expandableObject) {
    this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code customer} object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded {@code customer}.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Verify a specified bank account for a given customer.
   */
  public BankAccount verify() throws StripeException {
    return verify((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Verify a specified bank account for a given customer.
   */
  public BankAccount verify(RequestOptions options) throws StripeException {
    return verify((Map<String, Object>) null, options);
  }

  /**
   * Verify a specified bank account for a given customer.
   */
  public BankAccount verify(Map<String, Object> params) throws StripeException {
    return verify(params, (RequestOptions) null);
  }

  /**
   * Verify a specified bank account for a given customer.
   */
  public BankAccount verify(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/sources/%s/verify", ApiResource.urlEncodeId(this.getCustomer()), ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, BankAccount.class, options);
  }

  /**
   * Verify a specified bank account for a given customer.
   */
  public BankAccount verify(BankAccountVerifyParams params) throws StripeException {
    return verify(params, (RequestOptions) null);
  }

  /**
   * Verify a specified bank account for a given customer.
   */
  public BankAccount verify(BankAccountVerifyParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/sources/%s/verify", ApiResource.urlEncodeId(this.getCustomer()), ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, BankAccount.class, options);
  }

  /**
   * Updates the metadata, account holder name, and account holder type of a bank account belonging
   * to a <a href="https://stripe.com/docs/connect/custom-accounts">Custom account</a>, and
   * optionally sets it as the default for its currency. Other bank account details are not editable
   * by design.
   *
   * <p>You can re-enable a disabled bank account by performing an update call without providing any
   * arguments or changes.
   *
   * <p>Updates the <code>account_holder_name</code>, <code>account_holder_type</code>, and <code>
   * metadata</code> of a bank account belonging to a customer. Other bank account details are not
   * editable, by design.
   */
  @Override
  public BankAccount update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the metadata, account holder name, and account holder type of a bank account belonging
   * to a <a href="https://stripe.com/docs/connect/custom-accounts">Custom account</a>, and
   * optionally sets it as the default for its currency. Other bank account details are not editable
   * by design.
   *
   * <p>You can re-enable a disabled bank account by performing an update call without providing any
   * arguments or changes.
   *
   * <p>Updates the <code>account_holder_name</code>, <code>account_holder_type</code>, and <code>
   * metadata</code> of a bank account belonging to a customer. Other bank account details are not
   * editable, by design.
   */
  @Override
  public BankAccount update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url;
    if (this.getAccount() != null) {
      url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/external_accounts/%s", ApiResource.urlEncodeId(this.getAccount()), ApiResource.urlEncodeId(this.getId())));
    } else if (this.getCustomer() != null) {
      url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/sources/%s", ApiResource.urlEncodeId(this.getCustomer()), ApiResource.urlEncodeId(this.getId())));
    } else {
      throw new InvalidRequestException("Unable to construct url because [account, customer] field(s) are all null", null, null, null, 0, null);
    }
    return request(ApiResource.RequestMethod.POST, url, params, BankAccount.class, options);
  }

  /**
   * Updates the metadata, account holder name, and account holder type of a bank account belonging
   * to a <a href="https://stripe.com/docs/connect/custom-accounts">Custom account</a>, and
   * optionally sets it as the default for its currency. Other bank account details are not editable
   * by design.
   *
   * <p>You can re-enable a disabled bank account by performing an update call without providing any
   * arguments or changes.
   *
   * <p>Updates the <code>account_holder_name</code>, <code>account_holder_type</code>, and <code>
   * metadata</code> of a bank account belonging to a customer. Other bank account details are not
   * editable, by design.
   */
  public BankAccount update(BankAccountUpdateOnAccountParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the metadata, account holder name, and account holder type of a bank account belonging
   * to a <a href="https://stripe.com/docs/connect/custom-accounts">Custom account</a>, and
   * optionally sets it as the default for its currency. Other bank account details are not editable
   * by design.
   *
   * <p>You can re-enable a disabled bank account by performing an update call without providing any
   * arguments or changes.
   *
   * <p>Updates the <code>account_holder_name</code>, <code>account_holder_type</code>, and <code>
   * metadata</code> of a bank account belonging to a customer. Other bank account details are not
   * editable, by design.
   */
  public BankAccount update(BankAccountUpdateOnAccountParams params, RequestOptions options) throws StripeException {
    String url;
    if (this.getAccount() != null) {
      url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/external_accounts/%s", ApiResource.urlEncodeId(this.getAccount()), ApiResource.urlEncodeId(this.getId())));
    } else {
      throw new InvalidRequestException("Unable to construct url because [account] field(s) are all null", null, null, null, 0, null);
    }
    return request(ApiResource.RequestMethod.POST, url, params, BankAccount.class, options);
  }

  /**
   * Updates the metadata, account holder name, and account holder type of a bank account belonging
   * to a <a href="https://stripe.com/docs/connect/custom-accounts">Custom account</a>, and
   * optionally sets it as the default for its currency. Other bank account details are not editable
   * by design.
   *
   * <p>You can re-enable a disabled bank account by performing an update call without providing any
   * arguments or changes.
   *
   * <p>Updates the <code>account_holder_name</code>, <code>account_holder_type</code>, and <code>
   * metadata</code> of a bank account belonging to a customer. Other bank account details are not
   * editable, by design.
   */
  public BankAccount update(BankAccountUpdateOnCustomerParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the metadata, account holder name, and account holder type of a bank account belonging
   * to a <a href="https://stripe.com/docs/connect/custom-accounts">Custom account</a>, and
   * optionally sets it as the default for its currency. Other bank account details are not editable
   * by design.
   *
   * <p>You can re-enable a disabled bank account by performing an update call without providing any
   * arguments or changes.
   *
   * <p>Updates the <code>account_holder_name</code>, <code>account_holder_type</code>, and <code>
   * metadata</code> of a bank account belonging to a customer. Other bank account details are not
   * editable, by design.
   */
  public BankAccount update(BankAccountUpdateOnCustomerParams params, RequestOptions options) throws StripeException {
    String url;
    if (this.getCustomer() != null) {
      url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/sources/%s", ApiResource.urlEncodeId(this.getCustomer()), ApiResource.urlEncodeId(this.getId())));
    } else {
      throw new InvalidRequestException("Unable to construct url because [customer] field(s) are all null", null, null, null, 0, null);
    }
    return request(ApiResource.RequestMethod.POST, url, params, BankAccount.class, options);
  }

  /**
   * Delete a specified external account for a given account.
   *
   * <p>Delete a specified source for a given customer.
   */
  @Override
  public BankAccount delete() throws StripeException {
    return delete((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Delete a specified external account for a given account.
   *
   * <p>Delete a specified source for a given customer.
   */
  @Override
  public BankAccount delete(RequestOptions options) throws StripeException {
    return delete((Map<String, Object>) null, options);
  }

  /**
   * Delete a specified external account for a given account.
   *
   * <p>Delete a specified source for a given customer.
   */
  @Override
  public BankAccount delete(Map<String, Object> params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * Delete a specified external account for a given account.
   *
   * <p>Delete a specified source for a given customer.
   */
  @Override
  public BankAccount delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url;
    if (this.getAccount() != null) {
      url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/external_accounts/%s", ApiResource.urlEncodeId(this.getAccount()), ApiResource.urlEncodeId(this.getId())));
    } else if (this.getCustomer() != null) {
      url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/customers/%s/sources/%s", ApiResource.urlEncodeId(this.getCustomer()), ApiResource.urlEncodeId(this.getId())));
    } else {
      throw new InvalidRequestException("Unable to construct url because [account, customer] field(s) are all null", null, null, null, 0, null);
    }
    return request(ApiResource.RequestMethod.DELETE, url, params, BankAccount.class, options);
  }

  /**
   * The name of the person or business that owns the bank account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAccountHolderName() {
    return this.accountHolderName;
  }

  /**
   * The type of entity that holds the account. This can be either {@code individual} or {@code
   * company}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAccountHolderType() {
    return this.accountHolderType;
  }

  /**
   * A set of available payout methods for this bank account. Only values from this set should be
   * passed as the {@code method} when creating a payout.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getAvailablePayoutMethods() {
    return this.availablePayoutMethods;
  }

  /**
   * Name of the bank associated with the routing number (e.g., {@code WELLS FARGO}).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBankName() {
    return this.bankName;
  }

  /**
   * Two-letter ISO code representing the country the bank account is located in.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCountry() {
    return this.country;
  }

  /**
   * Three-letter <a href="https://stripe.com/docs/payouts">ISO code for the currency</a> paid out
   * to the bank account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * Whether this bank account is the default external account for its currency.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDefaultForCurrency() {
    return this.defaultForCurrency;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether
   * two bank accounts are the same.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFingerprint() {
    return this.fingerprint;
  }

  /**
   * The last four digits of the bank account number.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLast4() {
    return this.last4;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code bank_account}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The routing transit number for the bank account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getRoutingNumber() {
    return this.routingNumber;
  }

  /**
   * For bank accounts, possible values are {@code new}, {@code validated}, {@code verified}, {@code
   * verification_failed}, or {@code errored}. A bank account that hasn't had any activity or
   * validation performed is {@code new}. If Stripe can determine that the bank account exists, its
   * status will be {@code validated}. Note that there often isn’t enough information to know (e.g.,
   * for smaller credit unions), and the validation is not always run. If customer bank account
   * verification has succeeded, the bank account status will be {@code verified}. If the
   * verification failed for any reason, such as microdeposit failure, the status will be {@code
   * verification_failed}. If a transfer sent to this bank account fails, we'll set the status to
   * {@code errored} and will not continue to send transfers until the bank details are updated.
   *
   * <p>For external accounts, possible values are {@code new} and {@code errored}. Validations
   * aren't run against external accounts because they're only used for payouts. This means the
   * other statuses don't apply. If a transfer fails, the status is set to {@code errored} and
   * transfers are stopped until account details are updated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * The name of the person or business that owns the bank account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAccountHolderName(final String accountHolderName) {
    this.accountHolderName = accountHolderName;
  }

  /**
   * The type of entity that holds the account. This can be either {@code individual} or {@code
   * company}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAccountHolderType(final String accountHolderType) {
    this.accountHolderType = accountHolderType;
  }

  /**
   * A set of available payout methods for this bank account. Only values from this set should be
   * passed as the {@code method} when creating a payout.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAvailablePayoutMethods(final List<String> availablePayoutMethods) {
    this.availablePayoutMethods = availablePayoutMethods;
  }

  /**
   * Name of the bank associated with the routing number (e.g., {@code WELLS FARGO}).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBankName(final String bankName) {
    this.bankName = bankName;
  }

  /**
   * Two-letter ISO code representing the country the bank account is located in.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCountry(final String country) {
    this.country = country;
  }

  /**
   * Three-letter <a href="https://stripe.com/docs/payouts">ISO code for the currency</a> paid out
   * to the bank account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * Whether this bank account is the default external account for its currency.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDefaultForCurrency(final Boolean defaultForCurrency) {
    this.defaultForCurrency = defaultForCurrency;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * Uniquely identifies this particular bank account. You can use this attribute to check whether
   * two bank accounts are the same.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFingerprint(final String fingerprint) {
    this.fingerprint = fingerprint;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The last four digits of the bank account number.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLast4(final String last4) {
    this.last4 = last4;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code bank_account}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The routing transit number for the bank account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRoutingNumber(final String routingNumber) {
    this.routingNumber = routingNumber;
  }

  /**
   * For bank accounts, possible values are {@code new}, {@code validated}, {@code verified}, {@code
   * verification_failed}, or {@code errored}. A bank account that hasn't had any activity or
   * validation performed is {@code new}. If Stripe can determine that the bank account exists, its
   * status will be {@code validated}. Note that there often isn’t enough information to know (e.g.,
   * for smaller credit unions), and the validation is not always run. If customer bank account
   * verification has succeeded, the bank account status will be {@code verified}. If the
   * verification failed for any reason, such as microdeposit failure, the status will be {@code
   * verification_failed}. If a transfer sent to this bank account fails, we'll set the status to
   * {@code errored} and will not continue to send transfers until the bank details are updated.
   *
   * <p>For external accounts, possible values are {@code new} and {@code errored}. Validations
   * aren't run against external accounts because they're only used for payouts. This means the
   * other statuses don't apply. If a transfer fails, the status is set to {@code errored} and
   * transfers are stopped until account details are updated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof BankAccount)) return false;
    final BankAccount other = (BankAccount) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$defaultForCurrency = this.getDefaultForCurrency();
    final java.lang.Object other$defaultForCurrency = other.getDefaultForCurrency();
    if (this$defaultForCurrency == null ? other$defaultForCurrency != null : !this$defaultForCurrency.equals(other$defaultForCurrency)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$account = this.getAccount();
    final java.lang.Object other$account = other.getAccount();
    if (this$account == null ? other$account != null : !this$account.equals(other$account)) return false;
    final java.lang.Object this$accountHolderName = this.getAccountHolderName();
    final java.lang.Object other$accountHolderName = other.getAccountHolderName();
    if (this$accountHolderName == null ? other$accountHolderName != null : !this$accountHolderName.equals(other$accountHolderName)) return false;
    final java.lang.Object this$accountHolderType = this.getAccountHolderType();
    final java.lang.Object other$accountHolderType = other.getAccountHolderType();
    if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) return false;
    final java.lang.Object this$availablePayoutMethods = this.getAvailablePayoutMethods();
    final java.lang.Object other$availablePayoutMethods = other.getAvailablePayoutMethods();
    if (this$availablePayoutMethods == null ? other$availablePayoutMethods != null : !this$availablePayoutMethods.equals(other$availablePayoutMethods)) return false;
    final java.lang.Object this$bankName = this.getBankName();
    final java.lang.Object other$bankName = other.getBankName();
    if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
    final java.lang.Object this$country = this.getCountry();
    final java.lang.Object other$country = other.getCountry();
    if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$fingerprint = this.getFingerprint();
    final java.lang.Object other$fingerprint = other.getFingerprint();
    if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$last4 = this.getLast4();
    final java.lang.Object other$last4 = other.getLast4();
    if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$routingNumber = this.getRoutingNumber();
    final java.lang.Object other$routingNumber = other.getRoutingNumber();
    if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof BankAccount;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $defaultForCurrency = this.getDefaultForCurrency();
    result = result * PRIME + ($defaultForCurrency == null ? 43 : $defaultForCurrency.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $account = this.getAccount();
    result = result * PRIME + ($account == null ? 43 : $account.hashCode());
    final java.lang.Object $accountHolderName = this.getAccountHolderName();
    result = result * PRIME + ($accountHolderName == null ? 43 : $accountHolderName.hashCode());
    final java.lang.Object $accountHolderType = this.getAccountHolderType();
    result = result * PRIME + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
    final java.lang.Object $availablePayoutMethods = this.getAvailablePayoutMethods();
    result = result * PRIME + ($availablePayoutMethods == null ? 43 : $availablePayoutMethods.hashCode());
    final java.lang.Object $bankName = this.getBankName();
    result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
    final java.lang.Object $country = this.getCountry();
    result = result * PRIME + ($country == null ? 43 : $country.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $fingerprint = this.getFingerprint();
    result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $last4 = this.getLast4();
    result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $routingNumber = this.getRoutingNumber();
    result = result * PRIME + ($routingNumber == null ? 43 : $routingNumber.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
