// Generated by delombok at Tue Jul 20 21:21:41 EDT 2021
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiResource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InvoiceLineItem extends StripeObject implements HasId {
  /**
   * The amount, in %s.
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @SerializedName("description")
  String description;
  /**
   * The amount of discount calculated per discount for this line item.
   */
  @SerializedName("discount_amounts")
  List<DiscountAmount> discountAmounts;
  /**
   * If true, discounts will apply to this line item. Always false for prorations.
   */
  @SerializedName("discountable")
  Boolean discountable;
  /**
   * The discounts applied to the invoice line item. Line item discounts are applied before invoice
   * discounts. Use {@code expand[]=discounts} to expand each discount.
   */
  @SerializedName("discounts")
  List<ExpandableField<Discount>> discounts;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * The ID of the <a href="https://stripe.com/docs/api/invoiceitems">invoice item</a> associated
   * with this line item if any.
   */
  @SerializedName("invoice_item")
  String invoiceItem;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format. Note that for line items with {@code type=subscription} this will reflect
   * the metadata of the subscription that caused the line item to be created.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code line_item}.
   */
  @SerializedName("object")
  String object;
  @SerializedName("period")
  InvoiceLineItemPeriod period;
  /**
   * The plan of the subscription, if the line item is a subscription or a proration.
   */
  @SerializedName("plan")
  Plan plan;
  /**
   * The price of the line item.
   */
  @SerializedName("price")
  Price price;
  /**
   * Whether this is a proration.
   */
  @SerializedName("proration")
  Boolean proration;
  /**
   * The quantity of the subscription, if the line item is a subscription or a proration.
   */
  @SerializedName("quantity")
  Long quantity;
  /**
   * The subscription that the invoice item pertains to, if any.
   */
  @SerializedName("subscription")
  String subscription;
  /**
   * The subscription item that generated this invoice item. Left empty if the line item is not an
   * explicit result of a subscription.
   */
  @SerializedName("subscription_item")
  String subscriptionItem;
  /**
   * The amount of tax calculated per tax rate for this line item.
   */
  @SerializedName("tax_amounts")
  List<Invoice.TaxAmount> taxAmounts;
  /**
   * The tax rates which apply to the line item.
   */
  @SerializedName("tax_rates")
  List<TaxRate> taxRates;
  /**
   * A string identifying the type of the source of this line item, either an {@code invoiceitem} or
   * a {@code subscription}.
   *
   * <p>One of {@code invoiceitem}, or {@code subscription}.
   */
  @SerializedName("type")
  String type;

  /**
   * Get IDs of expandable {@code discounts} object list.
   */
  public List<String> getDiscounts() {
    return (this.discounts != null) ? this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
  }

  public void setDiscounts(List<String> ids) {
    if (ids == null) {
      this.discounts = null;
      return;
    }
    if (this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
      // noop if the ids are equal to what are already present
      return;
    }
    this.discounts = (ids != null) ? ids.stream().map(id -> new ExpandableField<Discount>(id, null)).collect(Collectors.toList()) : null;
  }

  /**
   * Get expanded {@code discounts}.
   */
  public List<Discount> getDiscountObjects() {
    return (this.discounts != null) ? this.discounts.stream().map(x -> x.getExpanded()).collect(Collectors.toList()) : null;
  }

  public void setDiscountObjects(List<Discount> objs) {
    this.discounts = objs != null ? objs.stream().map(x -> new ExpandableField<Discount>(x.getId(), x)).collect(Collectors.toList()) : null;
  }


  public static class DiscountAmount extends StripeObject {
    /** The amount, in %s, of the discount. */
    @SerializedName("amount")
    Long amount;
    /** The discount that was applied to get this discount amount. */
    @SerializedName("discount")
    ExpandableField<Discount> discount;

    /** Get ID of expandable {@code discount} object. */
    public String getDiscount() {
      return (this.discount != null) ? this.discount.getId() : null;
    }

    public void setDiscount(String id) {
      this.discount = ApiResource.setExpandableFieldId(id, this.discount);
    }

    /** Get expanded {@code discount}. */
    public Discount getDiscountObject() {
      return (this.discount != null) ? this.discount.getExpanded() : null;
    }

    public void setDiscountObject(Discount expandableObject) {
      this.discount = new ExpandableField<Discount>(expandableObject.getId(), expandableObject);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof InvoiceLineItem.DiscountAmount)) return false;
      final InvoiceLineItem.DiscountAmount other = (InvoiceLineItem.DiscountAmount) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$discount = this.getDiscount();
      final java.lang.Object other$discount = other.getDiscount();
      if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof InvoiceLineItem.DiscountAmount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $discount = this.getDiscount();
      result = result * PRIME + ($discount == null ? 43 : $discount.hashCode());
      return result;
    }
  }

  /**
   * The amount, in %s.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * The amount of discount calculated per discount for this line item.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<DiscountAmount> getDiscountAmounts() {
    return this.discountAmounts;
  }

  /**
   * If true, discounts will apply to this line item. Always false for prorations.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDiscountable() {
    return this.discountable;
  }

  /**
   * The ID of the <a href="https://stripe.com/docs/api/invoiceitems">invoice item</a> associated
   * with this line item if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getInvoiceItem() {
    return this.invoiceItem;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format. Note that for line items with {@code type=subscription} this will reflect
   * the metadata of the subscription that caused the line item to be created.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code line_item}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public InvoiceLineItemPeriod getPeriod() {
    return this.period;
  }

  /**
   * The plan of the subscription, if the line item is a subscription or a proration.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Plan getPlan() {
    return this.plan;
  }

  /**
   * The price of the line item.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Price getPrice() {
    return this.price;
  }

  /**
   * Whether this is a proration.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getProration() {
    return this.proration;
  }

  /**
   * The quantity of the subscription, if the line item is a subscription or a proration.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getQuantity() {
    return this.quantity;
  }

  /**
   * The subscription that the invoice item pertains to, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSubscription() {
    return this.subscription;
  }

  /**
   * The subscription item that generated this invoice item. Left empty if the line item is not an
   * explicit result of a subscription.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSubscriptionItem() {
    return this.subscriptionItem;
  }

  /**
   * The amount of tax calculated per tax rate for this line item.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<Invoice.TaxAmount> getTaxAmounts() {
    return this.taxAmounts;
  }

  /**
   * The tax rates which apply to the line item.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<TaxRate> getTaxRates() {
    return this.taxRates;
  }

  /**
   * A string identifying the type of the source of this line item, either an {@code invoiceitem} or
   * a {@code subscription}.
   *
   * <p>One of {@code invoiceitem}, or {@code subscription}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * The amount, in %s.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * The amount of discount calculated per discount for this line item.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiscountAmounts(final List<DiscountAmount> discountAmounts) {
    this.discountAmounts = discountAmounts;
  }

  /**
   * If true, discounts will apply to this line item. Always false for prorations.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiscountable(final Boolean discountable) {
    this.discountable = discountable;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The ID of the <a href="https://stripe.com/docs/api/invoiceitems">invoice item</a> associated
   * with this line item if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setInvoiceItem(final String invoiceItem) {
    this.invoiceItem = invoiceItem;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format. Note that for line items with {@code type=subscription} this will reflect
   * the metadata of the subscription that caused the line item to be created.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code line_item}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPeriod(final InvoiceLineItemPeriod period) {
    this.period = period;
  }

  /**
   * The plan of the subscription, if the line item is a subscription or a proration.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPlan(final Plan plan) {
    this.plan = plan;
  }

  /**
   * The price of the line item.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPrice(final Price price) {
    this.price = price;
  }

  /**
   * Whether this is a proration.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProration(final Boolean proration) {
    this.proration = proration;
  }

  /**
   * The quantity of the subscription, if the line item is a subscription or a proration.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setQuantity(final Long quantity) {
    this.quantity = quantity;
  }

  /**
   * The subscription that the invoice item pertains to, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubscription(final String subscription) {
    this.subscription = subscription;
  }

  /**
   * The subscription item that generated this invoice item. Left empty if the line item is not an
   * explicit result of a subscription.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubscriptionItem(final String subscriptionItem) {
    this.subscriptionItem = subscriptionItem;
  }

  /**
   * The amount of tax calculated per tax rate for this line item.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTaxAmounts(final List<Invoice.TaxAmount> taxAmounts) {
    this.taxAmounts = taxAmounts;
  }

  /**
   * The tax rates which apply to the line item.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTaxRates(final List<TaxRate> taxRates) {
    this.taxRates = taxRates;
  }

  /**
   * A string identifying the type of the source of this line item, either an {@code invoiceitem} or
   * a {@code subscription}.
   *
   * <p>One of {@code invoiceitem}, or {@code subscription}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof InvoiceLineItem)) return false;
    final InvoiceLineItem other = (InvoiceLineItem) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$discountable = this.getDiscountable();
    final java.lang.Object other$discountable = other.getDiscountable();
    if (this$discountable == null ? other$discountable != null : !this$discountable.equals(other$discountable)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$proration = this.getProration();
    final java.lang.Object other$proration = other.getProration();
    if (this$proration == null ? other$proration != null : !this$proration.equals(other$proration)) return false;
    final java.lang.Object this$quantity = this.getQuantity();
    final java.lang.Object other$quantity = other.getQuantity();
    if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$discountAmounts = this.getDiscountAmounts();
    final java.lang.Object other$discountAmounts = other.getDiscountAmounts();
    if (this$discountAmounts == null ? other$discountAmounts != null : !this$discountAmounts.equals(other$discountAmounts)) return false;
    final java.lang.Object this$discounts = this.getDiscounts();
    final java.lang.Object other$discounts = other.getDiscounts();
    if (this$discounts == null ? other$discounts != null : !this$discounts.equals(other$discounts)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$invoiceItem = this.getInvoiceItem();
    final java.lang.Object other$invoiceItem = other.getInvoiceItem();
    if (this$invoiceItem == null ? other$invoiceItem != null : !this$invoiceItem.equals(other$invoiceItem)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$period = this.getPeriod();
    final java.lang.Object other$period = other.getPeriod();
    if (this$period == null ? other$period != null : !this$period.equals(other$period)) return false;
    final java.lang.Object this$plan = this.getPlan();
    final java.lang.Object other$plan = other.getPlan();
    if (this$plan == null ? other$plan != null : !this$plan.equals(other$plan)) return false;
    final java.lang.Object this$price = this.getPrice();
    final java.lang.Object other$price = other.getPrice();
    if (this$price == null ? other$price != null : !this$price.equals(other$price)) return false;
    final java.lang.Object this$subscription = this.getSubscription();
    final java.lang.Object other$subscription = other.getSubscription();
    if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) return false;
    final java.lang.Object this$subscriptionItem = this.getSubscriptionItem();
    final java.lang.Object other$subscriptionItem = other.getSubscriptionItem();
    if (this$subscriptionItem == null ? other$subscriptionItem != null : !this$subscriptionItem.equals(other$subscriptionItem)) return false;
    final java.lang.Object this$taxAmounts = this.getTaxAmounts();
    final java.lang.Object other$taxAmounts = other.getTaxAmounts();
    if (this$taxAmounts == null ? other$taxAmounts != null : !this$taxAmounts.equals(other$taxAmounts)) return false;
    final java.lang.Object this$taxRates = this.getTaxRates();
    final java.lang.Object other$taxRates = other.getTaxRates();
    if (this$taxRates == null ? other$taxRates != null : !this$taxRates.equals(other$taxRates)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof InvoiceLineItem;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $discountable = this.getDiscountable();
    result = result * PRIME + ($discountable == null ? 43 : $discountable.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $proration = this.getProration();
    result = result * PRIME + ($proration == null ? 43 : $proration.hashCode());
    final java.lang.Object $quantity = this.getQuantity();
    result = result * PRIME + ($quantity == null ? 43 : $quantity.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $discountAmounts = this.getDiscountAmounts();
    result = result * PRIME + ($discountAmounts == null ? 43 : $discountAmounts.hashCode());
    final java.lang.Object $discounts = this.getDiscounts();
    result = result * PRIME + ($discounts == null ? 43 : $discounts.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $invoiceItem = this.getInvoiceItem();
    result = result * PRIME + ($invoiceItem == null ? 43 : $invoiceItem.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $period = this.getPeriod();
    result = result * PRIME + ($period == null ? 43 : $period.hashCode());
    final java.lang.Object $plan = this.getPlan();
    result = result * PRIME + ($plan == null ? 43 : $plan.hashCode());
    final java.lang.Object $price = this.getPrice();
    result = result * PRIME + ($price == null ? 43 : $price.hashCode());
    final java.lang.Object $subscription = this.getSubscription();
    result = result * PRIME + ($subscription == null ? 43 : $subscription.hashCode());
    final java.lang.Object $subscriptionItem = this.getSubscriptionItem();
    result = result * PRIME + ($subscriptionItem == null ? 43 : $subscriptionItem.hashCode());
    final java.lang.Object $taxAmounts = this.getTaxAmounts();
    result = result * PRIME + ($taxAmounts == null ? 43 : $taxAmounts.hashCode());
    final java.lang.Object $taxRates = this.getTaxRates();
    result = result * PRIME + ($taxRates == null ? 43 : $taxRates.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
