// Generated by delombok at Fri Sep 03 11:26:23 EDT 2021
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.EphemeralKeyCreateParams;
import java.util.List;
import java.util.Map;

public class EphemeralKey extends ApiResource implements HasId {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Time at which the key will expire. Measured in seconds since the Unix epoch.
   */
  @SerializedName("expires")
  Long expires;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @SerializedName("object")
  String object;
  /**
   * The key's secret. You can use this value to make authorized requests to the Stripe API.
   */
  @SerializedName("secret")
  String secret;
  List<AssociatedObject> associatedObjects;
  transient String rawJson;

  /**
   * Creates an ephemeral API key for a given resource.
   *
   * @param params request parameters
   * @param options request options. {@code stripeVersion} is required when creating ephemeral keys.
   *     it must have non-null {@link RequestOptions#getStripeVersionOverride()}.
   * @return the new ephemeral key
   */
  public static EphemeralKey create(EphemeralKeyCreateParams params, RequestOptions options) throws StripeException {
    checkNullTypedParams(classUrl(EphemeralKey.class), params);
    return create(params.toMap(), options);
  }

  /**
   * Creates an ephemeral API key for a given resource.
   *
   * @param params request parameters
   * @param options request options. {@code stripeVersion} is required when creating ephemeral keys.
   *     it must have non-null {@link RequestOptions#getStripeVersionOverride()}.
   * @return the new ephemeral key
   */
  public static EphemeralKey create(Map<String, Object> params, RequestOptions options) throws StripeException {
    if (options.getStripeVersionOverride() == null) {
      throw new IllegalArgumentException("`stripeVersionOverride` must be specified in " + "RequestOptions with stripe version of your mobile client.");
    }
    return request(RequestMethod.POST, classUrl(EphemeralKey.class), params, EphemeralKey.class, options);
  }

  /**
   * Invalidates an ephemeral API key for a given resource.
   */
  public EphemeralKey delete() throws StripeException {
    return delete(null);
  }

  /**
   * Invalidates an ephemeral API key for a given resource.
   */
  public EphemeralKey delete(RequestOptions options) throws StripeException {
    return request(RequestMethod.DELETE, instanceUrl(EphemeralKey.class, this.id), (Map<String, Object>) null, EphemeralKey.class, options);
  }


  public static class AssociatedObject extends StripeObject implements HasId {
    String id;
    String type;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setId(final String id) {
      this.id = id;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof EphemeralKey.AssociatedObject)) return false;
      final EphemeralKey.AssociatedObject other = (EphemeralKey.AssociatedObject) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$id = this.getId();
      final java.lang.Object other$id = other.getId();
      if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof EphemeralKey.AssociatedObject;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $id = this.getId();
      result = result * PRIME + ($id == null ? 43 : $id.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }

    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getId() {
      return this.id;
    }
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Time at which the key will expire. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getExpires() {
    return this.expires;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The key's secret. You can use this value to make authorized requests to the Stripe API.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSecret() {
    return this.secret;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<AssociatedObject> getAssociatedObjects() {
    return this.associatedObjects;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getRawJson() {
    return this.rawJson;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Time at which the key will expire. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExpires(final Long expires) {
    this.expires = expires;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The key's secret. You can use this value to make authorized requests to the Stripe API.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSecret(final String secret) {
    this.secret = secret;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAssociatedObjects(final List<AssociatedObject> associatedObjects) {
    this.associatedObjects = associatedObjects;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRawJson(final String rawJson) {
    this.rawJson = rawJson;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof EphemeralKey)) return false;
    final EphemeralKey other = (EphemeralKey) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$expires = this.getExpires();
    final java.lang.Object other$expires = other.getExpires();
    if (this$expires == null ? other$expires != null : !this$expires.equals(other$expires)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$secret = this.getSecret();
    final java.lang.Object other$secret = other.getSecret();
    if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) return false;
    final java.lang.Object this$associatedObjects = this.getAssociatedObjects();
    final java.lang.Object other$associatedObjects = other.getAssociatedObjects();
    if (this$associatedObjects == null ? other$associatedObjects != null : !this$associatedObjects.equals(other$associatedObjects)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof EphemeralKey;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $expires = this.getExpires();
    result = result * PRIME + ($expires == null ? 43 : $expires.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $secret = this.getSecret();
    result = result * PRIME + ($secret == null ? 43 : $secret.hashCode());
    final java.lang.Object $associatedObjects = this.getAssociatedObjects();
    result = result * PRIME + ($associatedObjects == null ? 43 : $associatedObjects.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
