/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class FileCreateParams
extends ApiRequestParams {
    @SerializedName(value="expand")
    List<String> expand;
    transient Object file;
    @SerializedName(value="file_link_data")
    FileLinkData fileLinkData;
    @SerializedName(value="purpose")
    Purpose purpose;

    private FileCreateParams(List<String> expand, Object file, FileLinkData fileLinkData, Purpose purpose) {
        this.expand = expand;
        this.file = file;
        this.fileLinkData = fileLinkData;
        this.purpose = purpose;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Map<String, Object> toMap() {
        Object fileObject = this.file;
        Map<String, Object> untypedParamWithPrimitiveTypes = super.toMap();
        untypedParamWithPrimitiveTypes.put("file", fileObject);
        return untypedParamWithPrimitiveTypes;
    }

    public static enum Purpose implements ApiRequestParams.EnumParam
    {
        ACCOUNT_REQUIREMENT("account_requirement"),
        ADDITIONAL_VERIFICATION("additional_verification"),
        BUSINESS_ICON("business_icon"),
        BUSINESS_LOGO("business_logo"),
        CUSTOMER_SIGNATURE("customer_signature"),
        DISPUTE_EVIDENCE("dispute_evidence"),
        IDENTITY_DOCUMENT("identity_document"),
        PCI_DOCUMENT("pci_document"),
        TAX_DOCUMENT_USER_UPLOAD("tax_document_user_upload");

        private final String value;

        private Purpose(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class FileLinkData {
        @SerializedName(value="create")
        Boolean create;
        @SerializedName(value="expires_at")
        Long expiresAt;
        @SerializedName(value="metadata")
        Map<String, String> metadata;

        private FileLinkData(Boolean create, Long expiresAt, Map<String, String> metadata) {
            this.create = create;
            this.expiresAt = expiresAt;
            this.metadata = metadata;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Boolean create;
            private Long expiresAt;
            private Map<String, String> metadata;

            public FileLinkData build() {
                return new FileLinkData(this.create, this.expiresAt, this.metadata);
            }

            public Builder setCreate(Boolean create) {
                this.create = create;
                return this;
            }

            public Builder setExpiresAt(Long expiresAt) {
                this.expiresAt = expiresAt;
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }
        }
    }

    public static class Builder {
        private List<String> expand;
        private Object file;
        private FileLinkData fileLinkData;
        private Purpose purpose;

        public FileCreateParams build() {
            return new FileCreateParams(this.expand, this.file, this.fileLinkData, this.purpose);
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder setFile(File file) {
            this.file = file;
            return this;
        }

        public Builder setFile(InputStream file) {
            this.file = file;
            return this;
        }

        public Builder setFileLinkData(FileLinkData fileLinkData) {
            this.fileLinkData = fileLinkData;
            return this;
        }

        public Builder setPurpose(Purpose purpose) {
            this.purpose = purpose;
            return this;
        }
    }
}

