// Generated by delombok at Wed Nov 17 15:17:34 EST 2021
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.ExchangeRateListParams;
import com.stripe.param.ExchangeRateRetrieveParams;
import java.math.BigDecimal;
import java.util.Map;

public class ExchangeRate extends ApiResource implements HasId {
  /**
   * Unique identifier for the object. Represented as the three-letter <a
   * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a> in lowercase.
   */
  @SerializedName("id")
  String id;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code exchange_rate}.
   */
  @SerializedName("object")
  String object;
  /**
   * Hash where the keys are supported currencies and the values are the exchange rate at which the
   * base id currency converts to the key currency.
   */
  @SerializedName("rates")
  Map<String, BigDecimal> rates;

  /**
   * Returns a list of objects that contain the rates at which foreign currencies are converted to
   * one another. Only shows the currencies for which Stripe supports.
   */
  public static ExchangeRateCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of objects that contain the rates at which foreign currencies are converted to
   * one another. Only shows the currencies for which Stripe supports.
   */
  public static ExchangeRateCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/exchange_rates");
    return ApiResource.requestCollection(url, params, ExchangeRateCollection.class, options);
  }

  /**
   * Returns a list of objects that contain the rates at which foreign currencies are converted to
   * one another. Only shows the currencies for which Stripe supports.
   */
  public static ExchangeRateCollection list(ExchangeRateListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of objects that contain the rates at which foreign currencies are converted to
   * one another. Only shows the currencies for which Stripe supports.
   */
  public static ExchangeRateCollection list(ExchangeRateListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/exchange_rates");
    return ApiResource.requestCollection(url, params, ExchangeRateCollection.class, options);
  }

  /**
   * Retrieves the exchange rates from the given currency to every supported currency.
   */
  public static ExchangeRate retrieve(String rateId) throws StripeException {
    return retrieve(rateId, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the exchange rates from the given currency to every supported currency.
   */
  public static ExchangeRate retrieve(String rateId, RequestOptions options) throws StripeException {
    return retrieve(rateId, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the exchange rates from the given currency to every supported currency.
   */
  public static ExchangeRate retrieve(String rateId, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/exchange_rates/%s", ApiResource.urlEncodeId(rateId)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ExchangeRate.class, options);
  }

  /**
   * Retrieves the exchange rates from the given currency to every supported currency.
   */
  public static ExchangeRate retrieve(String rateId, ExchangeRateRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/exchange_rates/%s", ApiResource.urlEncodeId(rateId)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ExchangeRate.class, options);
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code exchange_rate}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Hash where the keys are supported currencies and the values are the exchange rate at which the
   * base id currency converts to the key currency.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, BigDecimal> getRates() {
    return this.rates;
  }

  /**
   * Unique identifier for the object. Represented as the three-letter <a
   * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a> in lowercase.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code exchange_rate}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Hash where the keys are supported currencies and the values are the exchange rate at which the
   * base id currency converts to the key currency.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRates(final Map<String, BigDecimal> rates) {
    this.rates = rates;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ExchangeRate)) return false;
    final ExchangeRate other = (ExchangeRate) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$rates = this.getRates();
    final java.lang.Object other$rates = other.getRates();
    if (this$rates == null ? other$rates != null : !this$rates.equals(other$rates)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ExchangeRate;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $rates = this.getRates();
    result = result * PRIME + ($rates == null ? 43 : $rates.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object. Represented as the three-letter <a
   * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a> in lowercase.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
