/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.ExpandableField;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.AuthorizationCollection;
import com.stripe.model.issuing.Card;
import com.stripe.model.issuing.Cardholder;
import com.stripe.model.issuing.Transaction;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.issuing.AuthorizationApproveParams;
import com.stripe.param.issuing.AuthorizationDeclineParams;
import com.stripe.param.issuing.AuthorizationListParams;
import com.stripe.param.issuing.AuthorizationRetrieveParams;
import com.stripe.param.issuing.AuthorizationUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Authorization
extends ApiResource
implements MetadataStore<Authorization>,
BalanceTransactionSource {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="amount_details")
    AmountDetails amountDetails;
    @SerializedName(value="approved")
    Boolean approved;
    @SerializedName(value="authorization_method")
    String authorizationMethod;
    @SerializedName(value="balance_transactions")
    List<BalanceTransaction> balanceTransactions;
    @SerializedName(value="card")
    Card card;
    @SerializedName(value="cardholder")
    ExpandableField<Cardholder> cardholder;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="merchant_amount")
    Long merchantAmount;
    @SerializedName(value="merchant_currency")
    String merchantCurrency;
    @SerializedName(value="merchant_data")
    MerchantData merchantData;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="pending_request")
    PendingRequest pendingRequest;
    @SerializedName(value="request_history")
    List<RequestHistory> requestHistory;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="transactions")
    List<Transaction> transactions;
    @SerializedName(value="verification_data")
    VerificationData verificationData;
    @SerializedName(value="wallet")
    String wallet;

    public String getCardholder() {
        return this.cardholder != null ? this.cardholder.getId() : null;
    }

    public void setCardholder(String id) {
        this.cardholder = ApiResource.setExpandableFieldId(id, this.cardholder);
    }

    public Cardholder getCardholderObject() {
        return this.cardholder != null ? this.cardholder.getExpanded() : null;
    }

    public void setCardholderObject(Cardholder expandableObject) {
        this.cardholder = new ExpandableField<Cardholder>(expandableObject.getId(), expandableObject);
    }

    public static AuthorizationCollection list(Map<String, Object> params) throws StripeException {
        return Authorization.list(params, (RequestOptions)null);
    }

    public static AuthorizationCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/authorizations");
        return ApiResource.requestCollection(url, params, AuthorizationCollection.class, options);
    }

    public static AuthorizationCollection list(AuthorizationListParams params) throws StripeException {
        return Authorization.list(params, (RequestOptions)null);
    }

    public static AuthorizationCollection list(AuthorizationListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/authorizations");
        return ApiResource.requestCollection(url, params, AuthorizationCollection.class, options);
    }

    public static Authorization retrieve(String authorization) throws StripeException {
        return Authorization.retrieve(authorization, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Authorization retrieve(String authorization, RequestOptions options) throws StripeException {
        return Authorization.retrieve(authorization, (Map<String, Object>)null, options);
    }

    public static Authorization retrieve(String authorization, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(authorization)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Authorization.class, options);
    }

    public static Authorization retrieve(String authorization, AuthorizationRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(authorization)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Authorization.class, options);
    }

    public Authorization update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Authorization update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
    }

    public Authorization update(AuthorizationUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Authorization update(AuthorizationUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
    }

    public Authorization approve() throws StripeException {
        return this.approve((Map<String, Object>)null, (RequestOptions)null);
    }

    public Authorization approve(RequestOptions options) throws StripeException {
        return this.approve((Map<String, Object>)null, options);
    }

    public Authorization approve(Map<String, Object> params) throws StripeException {
        return this.approve(params, (RequestOptions)null);
    }

    public Authorization approve(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s/approve", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
    }

    public Authorization approve(AuthorizationApproveParams params) throws StripeException {
        return this.approve(params, (RequestOptions)null);
    }

    public Authorization approve(AuthorizationApproveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s/approve", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
    }

    public Authorization decline() throws StripeException {
        return this.decline((Map<String, Object>)null, (RequestOptions)null);
    }

    public Authorization decline(RequestOptions options) throws StripeException {
        return this.decline((Map<String, Object>)null, options);
    }

    public Authorization decline(Map<String, Object> params) throws StripeException {
        return this.decline(params, (RequestOptions)null);
    }

    public Authorization decline(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s/decline", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
    }

    public Authorization decline(AuthorizationDeclineParams params) throws StripeException {
        return this.decline(params, (RequestOptions)null);
    }

    public Authorization decline(AuthorizationDeclineParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/authorizations/%s/decline", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Authorization.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public AmountDetails getAmountDetails() {
        return this.amountDetails;
    }

    @Generated
    public Boolean getApproved() {
        return this.approved;
    }

    @Generated
    public String getAuthorizationMethod() {
        return this.authorizationMethod;
    }

    @Generated
    public List<BalanceTransaction> getBalanceTransactions() {
        return this.balanceTransactions;
    }

    @Generated
    public Card getCard() {
        return this.card;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Long getMerchantAmount() {
        return this.merchantAmount;
    }

    @Generated
    public String getMerchantCurrency() {
        return this.merchantCurrency;
    }

    @Generated
    public MerchantData getMerchantData() {
        return this.merchantData;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PendingRequest getPendingRequest() {
        return this.pendingRequest;
    }

    @Generated
    public List<RequestHistory> getRequestHistory() {
        return this.requestHistory;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    @Generated
    public VerificationData getVerificationData() {
        return this.verificationData;
    }

    @Generated
    public String getWallet() {
        return this.wallet;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountDetails(AmountDetails amountDetails) {
        this.amountDetails = amountDetails;
    }

    @Generated
    public void setApproved(Boolean approved) {
        this.approved = approved;
    }

    @Generated
    public void setAuthorizationMethod(String authorizationMethod) {
        this.authorizationMethod = authorizationMethod;
    }

    @Generated
    public void setBalanceTransactions(List<BalanceTransaction> balanceTransactions) {
        this.balanceTransactions = balanceTransactions;
    }

    @Generated
    public void setCard(Card card) {
        this.card = card;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMerchantAmount(Long merchantAmount) {
        this.merchantAmount = merchantAmount;
    }

    @Generated
    public void setMerchantCurrency(String merchantCurrency) {
        this.merchantCurrency = merchantCurrency;
    }

    @Generated
    public void setMerchantData(MerchantData merchantData) {
        this.merchantData = merchantData;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPendingRequest(PendingRequest pendingRequest) {
        this.pendingRequest = pendingRequest;
    }

    @Generated
    public void setRequestHistory(List<RequestHistory> requestHistory) {
        this.requestHistory = requestHistory;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
    }

    @Generated
    public void setVerificationData(VerificationData verificationData) {
        this.verificationData = verificationData;
    }

    @Generated
    public void setWallet(String wallet) {
        this.wallet = wallet;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Authorization)) {
            return false;
        }
        Authorization other = (Authorization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Boolean this$approved = this.getApproved();
        Boolean other$approved = other.getApproved();
        if (this$approved == null ? other$approved != null : !((Object)this$approved).equals(other$approved)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$merchantAmount = this.getMerchantAmount();
        Long other$merchantAmount = other.getMerchantAmount();
        if (this$merchantAmount == null ? other$merchantAmount != null : !((Object)this$merchantAmount).equals(other$merchantAmount)) {
            return false;
        }
        AmountDetails this$amountDetails = this.getAmountDetails();
        AmountDetails other$amountDetails = other.getAmountDetails();
        if (this$amountDetails == null ? other$amountDetails != null : !((Object)this$amountDetails).equals(other$amountDetails)) {
            return false;
        }
        String this$authorizationMethod = this.getAuthorizationMethod();
        String other$authorizationMethod = other.getAuthorizationMethod();
        if (this$authorizationMethod == null ? other$authorizationMethod != null : !this$authorizationMethod.equals(other$authorizationMethod)) {
            return false;
        }
        List<BalanceTransaction> this$balanceTransactions = this.getBalanceTransactions();
        List<BalanceTransaction> other$balanceTransactions = other.getBalanceTransactions();
        if (this$balanceTransactions == null ? other$balanceTransactions != null : !((Object)this$balanceTransactions).equals(other$balanceTransactions)) {
            return false;
        }
        Card this$card = this.getCard();
        Card other$card = other.getCard();
        if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
            return false;
        }
        String this$cardholder = this.getCardholder();
        String other$cardholder = other.getCardholder();
        if (this$cardholder == null ? other$cardholder != null : !this$cardholder.equals(other$cardholder)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$merchantCurrency = this.getMerchantCurrency();
        String other$merchantCurrency = other.getMerchantCurrency();
        if (this$merchantCurrency == null ? other$merchantCurrency != null : !this$merchantCurrency.equals(other$merchantCurrency)) {
            return false;
        }
        MerchantData this$merchantData = this.getMerchantData();
        MerchantData other$merchantData = other.getMerchantData();
        if (this$merchantData == null ? other$merchantData != null : !((Object)this$merchantData).equals(other$merchantData)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        PendingRequest this$pendingRequest = this.getPendingRequest();
        PendingRequest other$pendingRequest = other.getPendingRequest();
        if (this$pendingRequest == null ? other$pendingRequest != null : !((Object)this$pendingRequest).equals(other$pendingRequest)) {
            return false;
        }
        List<RequestHistory> this$requestHistory = this.getRequestHistory();
        List<RequestHistory> other$requestHistory = other.getRequestHistory();
        if (this$requestHistory == null ? other$requestHistory != null : !((Object)this$requestHistory).equals(other$requestHistory)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        List<Transaction> this$transactions = this.getTransactions();
        List<Transaction> other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
            return false;
        }
        VerificationData this$verificationData = this.getVerificationData();
        VerificationData other$verificationData = other.getVerificationData();
        if (this$verificationData == null ? other$verificationData != null : !((Object)this$verificationData).equals(other$verificationData)) {
            return false;
        }
        String this$wallet = this.getWallet();
        String other$wallet = other.getWallet();
        return !(this$wallet == null ? other$wallet != null : !this$wallet.equals(other$wallet));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Authorization;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Boolean $approved = this.getApproved();
        result = result * 59 + ($approved == null ? 43 : ((Object)$approved).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $merchantAmount = this.getMerchantAmount();
        result = result * 59 + ($merchantAmount == null ? 43 : ((Object)$merchantAmount).hashCode());
        AmountDetails $amountDetails = this.getAmountDetails();
        result = result * 59 + ($amountDetails == null ? 43 : ((Object)$amountDetails).hashCode());
        String $authorizationMethod = this.getAuthorizationMethod();
        result = result * 59 + ($authorizationMethod == null ? 43 : $authorizationMethod.hashCode());
        List<BalanceTransaction> $balanceTransactions = this.getBalanceTransactions();
        result = result * 59 + ($balanceTransactions == null ? 43 : ((Object)$balanceTransactions).hashCode());
        Card $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
        String $cardholder = this.getCardholder();
        result = result * 59 + ($cardholder == null ? 43 : $cardholder.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $merchantCurrency = this.getMerchantCurrency();
        result = result * 59 + ($merchantCurrency == null ? 43 : $merchantCurrency.hashCode());
        MerchantData $merchantData = this.getMerchantData();
        result = result * 59 + ($merchantData == null ? 43 : ((Object)$merchantData).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        PendingRequest $pendingRequest = this.getPendingRequest();
        result = result * 59 + ($pendingRequest == null ? 43 : ((Object)$pendingRequest).hashCode());
        List<RequestHistory> $requestHistory = this.getRequestHistory();
        result = result * 59 + ($requestHistory == null ? 43 : ((Object)$requestHistory).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        List<Transaction> $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        VerificationData $verificationData = this.getVerificationData();
        result = result * 59 + ($verificationData == null ? 43 : ((Object)$verificationData).hashCode());
        String $wallet = this.getWallet();
        result = result * 59 + ($wallet == null ? 43 : $wallet.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class VerificationData
    extends StripeObject {
        @SerializedName(value="address_line1_check")
        String addressLine1Check;
        @SerializedName(value="address_postal_code_check")
        String addressPostalCodeCheck;
        @SerializedName(value="cvc_check")
        String cvcCheck;
        @SerializedName(value="expiry_check")
        String expiryCheck;

        @Generated
        public String getAddressLine1Check() {
            return this.addressLine1Check;
        }

        @Generated
        public String getAddressPostalCodeCheck() {
            return this.addressPostalCodeCheck;
        }

        @Generated
        public String getCvcCheck() {
            return this.cvcCheck;
        }

        @Generated
        public String getExpiryCheck() {
            return this.expiryCheck;
        }

        @Generated
        public void setAddressLine1Check(String addressLine1Check) {
            this.addressLine1Check = addressLine1Check;
        }

        @Generated
        public void setAddressPostalCodeCheck(String addressPostalCodeCheck) {
            this.addressPostalCodeCheck = addressPostalCodeCheck;
        }

        @Generated
        public void setCvcCheck(String cvcCheck) {
            this.cvcCheck = cvcCheck;
        }

        @Generated
        public void setExpiryCheck(String expiryCheck) {
            this.expiryCheck = expiryCheck;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerificationData)) {
                return false;
            }
            VerificationData other = (VerificationData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$addressLine1Check = this.getAddressLine1Check();
            String other$addressLine1Check = other.getAddressLine1Check();
            if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) {
                return false;
            }
            String this$addressPostalCodeCheck = this.getAddressPostalCodeCheck();
            String other$addressPostalCodeCheck = other.getAddressPostalCodeCheck();
            if (this$addressPostalCodeCheck == null ? other$addressPostalCodeCheck != null : !this$addressPostalCodeCheck.equals(other$addressPostalCodeCheck)) {
                return false;
            }
            String this$cvcCheck = this.getCvcCheck();
            String other$cvcCheck = other.getCvcCheck();
            if (this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck)) {
                return false;
            }
            String this$expiryCheck = this.getExpiryCheck();
            String other$expiryCheck = other.getExpiryCheck();
            return !(this$expiryCheck == null ? other$expiryCheck != null : !this$expiryCheck.equals(other$expiryCheck));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VerificationData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $addressLine1Check = this.getAddressLine1Check();
            result = result * 59 + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
            String $addressPostalCodeCheck = this.getAddressPostalCodeCheck();
            result = result * 59 + ($addressPostalCodeCheck == null ? 43 : $addressPostalCodeCheck.hashCode());
            String $cvcCheck = this.getCvcCheck();
            result = result * 59 + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
            String $expiryCheck = this.getExpiryCheck();
            result = result * 59 + ($expiryCheck == null ? 43 : $expiryCheck.hashCode());
            return result;
        }
    }

    public static class RequestHistory
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="amount_details")
        AmountDetails amountDetails;
        @SerializedName(value="approved")
        Boolean approved;
        @SerializedName(value="created")
        Long created;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="merchant_amount")
        Long merchantAmount;
        @SerializedName(value="merchant_currency")
        String merchantCurrency;
        @SerializedName(value="reason")
        String reason;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public AmountDetails getAmountDetails() {
            return this.amountDetails;
        }

        @Generated
        public Boolean getApproved() {
            return this.approved;
        }

        @Generated
        public Long getCreated() {
            return this.created;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Long getMerchantAmount() {
            return this.merchantAmount;
        }

        @Generated
        public String getMerchantCurrency() {
            return this.merchantCurrency;
        }

        @Generated
        public String getReason() {
            return this.reason;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setAmountDetails(AmountDetails amountDetails) {
            this.amountDetails = amountDetails;
        }

        @Generated
        public void setApproved(Boolean approved) {
            this.approved = approved;
        }

        @Generated
        public void setCreated(Long created) {
            this.created = created;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setMerchantAmount(Long merchantAmount) {
            this.merchantAmount = merchantAmount;
        }

        @Generated
        public void setMerchantCurrency(String merchantCurrency) {
            this.merchantCurrency = merchantCurrency;
        }

        @Generated
        public void setReason(String reason) {
            this.reason = reason;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestHistory)) {
                return false;
            }
            RequestHistory other = (RequestHistory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            Boolean this$approved = this.getApproved();
            Boolean other$approved = other.getApproved();
            if (this$approved == null ? other$approved != null : !((Object)this$approved).equals(other$approved)) {
                return false;
            }
            Long this$created = this.getCreated();
            Long other$created = other.getCreated();
            if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
                return false;
            }
            Long this$merchantAmount = this.getMerchantAmount();
            Long other$merchantAmount = other.getMerchantAmount();
            if (this$merchantAmount == null ? other$merchantAmount != null : !((Object)this$merchantAmount).equals(other$merchantAmount)) {
                return false;
            }
            AmountDetails this$amountDetails = this.getAmountDetails();
            AmountDetails other$amountDetails = other.getAmountDetails();
            if (this$amountDetails == null ? other$amountDetails != null : !((Object)this$amountDetails).equals(other$amountDetails)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            String this$merchantCurrency = this.getMerchantCurrency();
            String other$merchantCurrency = other.getMerchantCurrency();
            if (this$merchantCurrency == null ? other$merchantCurrency != null : !this$merchantCurrency.equals(other$merchantCurrency)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RequestHistory;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            Boolean $approved = this.getApproved();
            result = result * 59 + ($approved == null ? 43 : ((Object)$approved).hashCode());
            Long $created = this.getCreated();
            result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
            Long $merchantAmount = this.getMerchantAmount();
            result = result * 59 + ($merchantAmount == null ? 43 : ((Object)$merchantAmount).hashCode());
            AmountDetails $amountDetails = this.getAmountDetails();
            result = result * 59 + ($amountDetails == null ? 43 : ((Object)$amountDetails).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            String $merchantCurrency = this.getMerchantCurrency();
            result = result * 59 + ($merchantCurrency == null ? 43 : $merchantCurrency.hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            return result;
        }
    }

    public static class PendingRequest
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="amount_details")
        AmountDetails amountDetails;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="is_amount_controllable")
        Boolean isAmountControllable;
        @SerializedName(value="merchant_amount")
        Long merchantAmount;
        @SerializedName(value="merchant_currency")
        String merchantCurrency;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public AmountDetails getAmountDetails() {
            return this.amountDetails;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Boolean getIsAmountControllable() {
            return this.isAmountControllable;
        }

        @Generated
        public Long getMerchantAmount() {
            return this.merchantAmount;
        }

        @Generated
        public String getMerchantCurrency() {
            return this.merchantCurrency;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setAmountDetails(AmountDetails amountDetails) {
            this.amountDetails = amountDetails;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setIsAmountControllable(Boolean isAmountControllable) {
            this.isAmountControllable = isAmountControllable;
        }

        @Generated
        public void setMerchantAmount(Long merchantAmount) {
            this.merchantAmount = merchantAmount;
        }

        @Generated
        public void setMerchantCurrency(String merchantCurrency) {
            this.merchantCurrency = merchantCurrency;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PendingRequest)) {
                return false;
            }
            PendingRequest other = (PendingRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            Boolean this$isAmountControllable = this.getIsAmountControllable();
            Boolean other$isAmountControllable = other.getIsAmountControllable();
            if (this$isAmountControllable == null ? other$isAmountControllable != null : !((Object)this$isAmountControllable).equals(other$isAmountControllable)) {
                return false;
            }
            Long this$merchantAmount = this.getMerchantAmount();
            Long other$merchantAmount = other.getMerchantAmount();
            if (this$merchantAmount == null ? other$merchantAmount != null : !((Object)this$merchantAmount).equals(other$merchantAmount)) {
                return false;
            }
            AmountDetails this$amountDetails = this.getAmountDetails();
            AmountDetails other$amountDetails = other.getAmountDetails();
            if (this$amountDetails == null ? other$amountDetails != null : !((Object)this$amountDetails).equals(other$amountDetails)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            String this$merchantCurrency = this.getMerchantCurrency();
            String other$merchantCurrency = other.getMerchantCurrency();
            return !(this$merchantCurrency == null ? other$merchantCurrency != null : !this$merchantCurrency.equals(other$merchantCurrency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PendingRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            Boolean $isAmountControllable = this.getIsAmountControllable();
            result = result * 59 + ($isAmountControllable == null ? 43 : ((Object)$isAmountControllable).hashCode());
            Long $merchantAmount = this.getMerchantAmount();
            result = result * 59 + ($merchantAmount == null ? 43 : ((Object)$merchantAmount).hashCode());
            AmountDetails $amountDetails = this.getAmountDetails();
            result = result * 59 + ($amountDetails == null ? 43 : ((Object)$amountDetails).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            String $merchantCurrency = this.getMerchantCurrency();
            result = result * 59 + ($merchantCurrency == null ? 43 : $merchantCurrency.hashCode());
            return result;
        }
    }

    public static class MerchantData
    extends StripeObject {
        @SerializedName(value="category")
        String category;
        @SerializedName(value="category_code")
        String categoryCode;
        @SerializedName(value="city")
        String city;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="network_id")
        String networkId;
        @SerializedName(value="postal_code")
        String postalCode;
        @SerializedName(value="state")
        String state;

        @Generated
        public String getCategory() {
            return this.category;
        }

        @Generated
        public String getCategoryCode() {
            return this.categoryCode;
        }

        @Generated
        public String getCity() {
            return this.city;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getNetworkId() {
            return this.networkId;
        }

        @Generated
        public String getPostalCode() {
            return this.postalCode;
        }

        @Generated
        public String getState() {
            return this.state;
        }

        @Generated
        public void setCategory(String category) {
            this.category = category;
        }

        @Generated
        public void setCategoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
        }

        @Generated
        public void setCity(String city) {
            this.city = city;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Generated
        public void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Generated
        public void setState(String state) {
            this.state = state;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MerchantData)) {
                return false;
            }
            MerchantData other = (MerchantData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$category = this.getCategory();
            String other$category = other.getCategory();
            if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                return false;
            }
            String this$categoryCode = this.getCategoryCode();
            String other$categoryCode = other.getCategoryCode();
            if (this$categoryCode == null ? other$categoryCode != null : !this$categoryCode.equals(other$categoryCode)) {
                return false;
            }
            String this$city = this.getCity();
            String other$city = other.getCity();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$networkId = this.getNetworkId();
            String other$networkId = other.getNetworkId();
            if (this$networkId == null ? other$networkId != null : !this$networkId.equals(other$networkId)) {
                return false;
            }
            String this$postalCode = this.getPostalCode();
            String other$postalCode = other.getPostalCode();
            if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                return false;
            }
            String this$state = this.getState();
            String other$state = other.getState();
            return !(this$state == null ? other$state != null : !this$state.equals(other$state));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MerchantData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            String $categoryCode = this.getCategoryCode();
            result = result * 59 + ($categoryCode == null ? 43 : $categoryCode.hashCode());
            String $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $networkId = this.getNetworkId();
            result = result * 59 + ($networkId == null ? 43 : $networkId.hashCode());
            String $postalCode = this.getPostalCode();
            result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
            String $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            return result;
        }
    }

    public static class AmountDetails
    extends StripeObject {
        @SerializedName(value="atm_fee")
        Long atmFee;

        @Generated
        public Long getAtmFee() {
            return this.atmFee;
        }

        @Generated
        public void setAtmFee(Long atmFee) {
            this.atmFee = atmFee;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmountDetails)) {
                return false;
            }
            AmountDetails other = (AmountDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$atmFee = this.getAtmFee();
            Long other$atmFee = other.getAtmFee();
            return !(this$atmFee == null ? other$atmFee != null : !((Object)this$atmFee).equals(other$atmFee));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AmountDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $atmFee = this.getAtmFee();
            result = result * 59 + ($atmFee == null ? 43 : ((Object)$atmFee).hashCode());
            return result;
        }
    }
}

