// Generated by delombok at Thu Dec 09 10:51:01 EST 2021
// File generated from our OpenAPI spec
package com.stripe.model.identity;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.identity.VerificationReportListParams;
import com.stripe.param.identity.VerificationReportRetrieveParams;
import java.util.List;
import java.util.Map;

public class VerificationReport extends ApiResource implements HasId {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Result from a document check.
   */
  @SerializedName("document")
  Document document;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Result from an id_number check.
   */
  @SerializedName("id_number")
  IdNumber idNumber;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code identity.verification_report}.
   */
  @SerializedName("object")
  String object;
  @SerializedName("options")
  Options options;
  /**
   * Result from a selfie check.
   */
  @SerializedName("selfie")
  Selfie selfie;
  /**
   * Type of report.
   *
   * <p>One of {@code document}, or {@code id_number}.
   */
  @SerializedName("type")
  String type;
  /**
   * ID of the VerificationSession that created this report.
   */
  @SerializedName("verification_session")
  String verificationSession;

  /**
   * Retrieves an existing VerificationReport.
   */
  public static VerificationReport retrieve(String report) throws StripeException {
    return retrieve(report, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves an existing VerificationReport.
   */
  public static VerificationReport retrieve(String report, RequestOptions options) throws StripeException {
    return retrieve(report, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves an existing VerificationReport.
   */
  public static VerificationReport retrieve(String report, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/identity/verification_reports/%s", ApiResource.urlEncodeId(report)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, VerificationReport.class, options);
  }

  /**
   * Retrieves an existing VerificationReport.
   */
  public static VerificationReport retrieve(String report, VerificationReportRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/identity/verification_reports/%s", ApiResource.urlEncodeId(report)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, VerificationReport.class, options);
  }

  /**
   * List all verification reports.
   */
  public static VerificationReportCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * List all verification reports.
   */
  public static VerificationReportCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/identity/verification_reports");
    return ApiResource.requestCollection(url, params, VerificationReportCollection.class, options);
  }

  /**
   * List all verification reports.
   */
  public static VerificationReportCollection list(VerificationReportListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * List all verification reports.
   */
  public static VerificationReportCollection list(VerificationReportListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/identity/verification_reports");
    return ApiResource.requestCollection(url, params, VerificationReportCollection.class, options);
  }


  public static class Document extends StripeObject {
    /**
     * Address as it appears in the document.
     */
    @SerializedName("address")
    Address address;
    /**
     * Date of birth as it appears in the document.
     */
    @SerializedName("dob")
    DateOfBirth dob;
    /**
     * Details on the verification error. Present when status is {@code unverified}.
     */
    @SerializedName("error")
    DocumentCheckError error;
    /**
     * Expiration date of the document.
     */
    @SerializedName("expiration_date")
    ExpirationDate expirationDate;
    /**
     * Array of <a href="https://stripe.com/docs/api/files">File</a> ids containing images for this
     * document.
     */
    @SerializedName("files")
    List<String> files;
    /**
     * First name as it appears in the document.
     */
    @SerializedName("first_name")
    String firstName;
    /**
     * Issued date of the document.
     */
    @SerializedName("issued_date")
    IssuedDate issuedDate;
    /**
     * Issuing country of the document.
     */
    @SerializedName("issuing_country")
    String issuingCountry;
    /**
     * Last name as it appears in the document.
     */
    @SerializedName("last_name")
    String lastName;
    /**
     * Document ID number.
     */
    @SerializedName("number")
    String number;
    /**
     * Status of this {@code document} check.
     *
     * <p>One of {@code unverified}, or {@code verified}.
     */
    @SerializedName("status")
    String status;
    /**
     * Type of the document.
     *
     * <p>One of {@code driving_license}, {@code id_card}, or {@code passport}.
     */
    @SerializedName("type")
    String type;


    public static class DateOfBirth extends StripeObject {
      /**
       * Numerical day between 1 and 31.
       */
      @SerializedName("day")
      Long day;
      /**
       * Numerical month between 1 and 12.
       */
      @SerializedName("month")
      Long month;
      /**
       * The four-digit year.
       */
      @SerializedName("year")
      Long year;

      /**
       * Numerical day between 1 and 31.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getDay() {
        return this.day;
      }

      /**
       * Numerical month between 1 and 12.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getMonth() {
        return this.month;
      }

      /**
       * The four-digit year.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getYear() {
        return this.year;
      }

      /**
       * Numerical day between 1 and 31.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDay(final Long day) {
        this.day = day;
      }

      /**
       * Numerical month between 1 and 12.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMonth(final Long month) {
        this.month = month;
      }

      /**
       * The four-digit year.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setYear(final Long year) {
        this.year = year;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof VerificationReport.Document.DateOfBirth)) return false;
        final VerificationReport.Document.DateOfBirth other = (VerificationReport.Document.DateOfBirth) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$day = this.getDay();
        final java.lang.Object other$day = other.getDay();
        if (this$day == null ? other$day != null : !this$day.equals(other$day)) return false;
        final java.lang.Object this$month = this.getMonth();
        final java.lang.Object other$month = other.getMonth();
        if (this$month == null ? other$month != null : !this$month.equals(other$month)) return false;
        final java.lang.Object this$year = this.getYear();
        final java.lang.Object other$year = other.getYear();
        if (this$year == null ? other$year != null : !this$year.equals(other$year)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof VerificationReport.Document.DateOfBirth;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $day = this.getDay();
        result = result * PRIME + ($day == null ? 43 : $day.hashCode());
        final java.lang.Object $month = this.getMonth();
        result = result * PRIME + ($month == null ? 43 : $month.hashCode());
        final java.lang.Object $year = this.getYear();
        result = result * PRIME + ($year == null ? 43 : $year.hashCode());
        return result;
      }
    }


    public static class DocumentCheckError extends StripeObject {
      /**
       * A short machine-readable string giving the reason for the verification failure.
       *
       * <p>One of {@code document_expired}, {@code document_type_not_supported}, or {@code
       * document_unverified_other}.
       */
      @SerializedName("code")
      String code;
      /**
       * A human-readable message giving the reason for the failure. These messages can be shown to
       * your users.
       */
      @SerializedName("reason")
      String reason;

      /**
       * A short machine-readable string giving the reason for the verification failure.
       *
       * <p>One of {@code document_expired}, {@code document_type_not_supported}, or {@code
       * document_unverified_other}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCode() {
        return this.code;
      }

      /**
       * A human-readable message giving the reason for the failure. These messages can be shown to
       * your users.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getReason() {
        return this.reason;
      }

      /**
       * A short machine-readable string giving the reason for the verification failure.
       *
       * <p>One of {@code document_expired}, {@code document_type_not_supported}, or {@code
       * document_unverified_other}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCode(final String code) {
        this.code = code;
      }

      /**
       * A human-readable message giving the reason for the failure. These messages can be shown to
       * your users.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReason(final String reason) {
        this.reason = reason;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof VerificationReport.Document.DocumentCheckError)) return false;
        final VerificationReport.Document.DocumentCheckError other = (VerificationReport.Document.DocumentCheckError) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$code = this.getCode();
        final java.lang.Object other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
        final java.lang.Object this$reason = this.getReason();
        final java.lang.Object other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof VerificationReport.Document.DocumentCheckError;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $code = this.getCode();
        result = result * PRIME + ($code == null ? 43 : $code.hashCode());
        final java.lang.Object $reason = this.getReason();
        result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
        return result;
      }
    }


    public static class ExpirationDate extends StripeObject {
      /**
       * Numerical day between 1 and 31.
       */
      @SerializedName("day")
      Long day;
      /**
       * Numerical month between 1 and 12.
       */
      @SerializedName("month")
      Long month;
      /**
       * The four-digit year.
       */
      @SerializedName("year")
      Long year;

      /**
       * Numerical day between 1 and 31.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getDay() {
        return this.day;
      }

      /**
       * Numerical month between 1 and 12.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getMonth() {
        return this.month;
      }

      /**
       * The four-digit year.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getYear() {
        return this.year;
      }

      /**
       * Numerical day between 1 and 31.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDay(final Long day) {
        this.day = day;
      }

      /**
       * Numerical month between 1 and 12.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMonth(final Long month) {
        this.month = month;
      }

      /**
       * The four-digit year.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setYear(final Long year) {
        this.year = year;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof VerificationReport.Document.ExpirationDate)) return false;
        final VerificationReport.Document.ExpirationDate other = (VerificationReport.Document.ExpirationDate) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$day = this.getDay();
        final java.lang.Object other$day = other.getDay();
        if (this$day == null ? other$day != null : !this$day.equals(other$day)) return false;
        final java.lang.Object this$month = this.getMonth();
        final java.lang.Object other$month = other.getMonth();
        if (this$month == null ? other$month != null : !this$month.equals(other$month)) return false;
        final java.lang.Object this$year = this.getYear();
        final java.lang.Object other$year = other.getYear();
        if (this$year == null ? other$year != null : !this$year.equals(other$year)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof VerificationReport.Document.ExpirationDate;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $day = this.getDay();
        result = result * PRIME + ($day == null ? 43 : $day.hashCode());
        final java.lang.Object $month = this.getMonth();
        result = result * PRIME + ($month == null ? 43 : $month.hashCode());
        final java.lang.Object $year = this.getYear();
        result = result * PRIME + ($year == null ? 43 : $year.hashCode());
        return result;
      }
    }


    public static class IssuedDate extends StripeObject {
      /** Numerical day between 1 and 31. */
      @SerializedName("day")
      Long day;
      /** Numerical month between 1 and 12. */
      @SerializedName("month")
      Long month;
      @SerializedName("year")
      Long year;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getDay() {
        return this.day;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getMonth() {
        return this.month;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getYear() {
        return this.year;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDay(final Long day) {
        this.day = day;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMonth(final Long month) {
        this.month = month;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setYear(final Long year) {
        this.year = year;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof VerificationReport.Document.IssuedDate)) return false;
        final VerificationReport.Document.IssuedDate other = (VerificationReport.Document.IssuedDate) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$day = this.getDay();
        final java.lang.Object other$day = other.getDay();
        if (this$day == null ? other$day != null : !this$day.equals(other$day)) return false;
        final java.lang.Object this$month = this.getMonth();
        final java.lang.Object other$month = other.getMonth();
        if (this$month == null ? other$month != null : !this$month.equals(other$month)) return false;
        final java.lang.Object this$year = this.getYear();
        final java.lang.Object other$year = other.getYear();
        if (this$year == null ? other$year != null : !this$year.equals(other$year)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof VerificationReport.Document.IssuedDate;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $day = this.getDay();
        result = result * PRIME + ($day == null ? 43 : $day.hashCode());
        final java.lang.Object $month = this.getMonth();
        result = result * PRIME + ($month == null ? 43 : $month.hashCode());
        final java.lang.Object $year = this.getYear();
        result = result * PRIME + ($year == null ? 43 : $year.hashCode());
        return result;
      }
    }

    /**
     * Address as it appears in the document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Address getAddress() {
      return this.address;
    }

    /**
     * Date of birth as it appears in the document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DateOfBirth getDob() {
      return this.dob;
    }

    /**
     * Details on the verification error. Present when status is {@code unverified}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DocumentCheckError getError() {
      return this.error;
    }

    /**
     * Expiration date of the document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ExpirationDate getExpirationDate() {
      return this.expirationDate;
    }

    /**
     * Array of <a href="https://stripe.com/docs/api/files">File</a> ids containing images for this
     * document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getFiles() {
      return this.files;
    }

    /**
     * First name as it appears in the document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFirstName() {
      return this.firstName;
    }

    /**
     * Issued date of the document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IssuedDate getIssuedDate() {
      return this.issuedDate;
    }

    /**
     * Issuing country of the document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIssuingCountry() {
      return this.issuingCountry;
    }

    /**
     * Last name as it appears in the document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLastName() {
      return this.lastName;
    }

    /**
     * Document ID number.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNumber() {
      return this.number;
    }

    /**
     * Status of this {@code document} check.
     *
     * <p>One of {@code unverified}, or {@code verified}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    /**
     * Type of the document.
     *
     * <p>One of {@code driving_license}, {@code id_card}, or {@code passport}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    /**
     * Address as it appears in the document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddress(final Address address) {
      this.address = address;
    }

    /**
     * Date of birth as it appears in the document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDob(final DateOfBirth dob) {
      this.dob = dob;
    }

    /**
     * Details on the verification error. Present when status is {@code unverified}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setError(final DocumentCheckError error) {
      this.error = error;
    }

    /**
     * Expiration date of the document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExpirationDate(final ExpirationDate expirationDate) {
      this.expirationDate = expirationDate;
    }

    /**
     * Array of <a href="https://stripe.com/docs/api/files">File</a> ids containing images for this
     * document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFiles(final List<String> files) {
      this.files = files;
    }

    /**
     * First name as it appears in the document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFirstName(final String firstName) {
      this.firstName = firstName;
    }

    /**
     * Issued date of the document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIssuedDate(final IssuedDate issuedDate) {
      this.issuedDate = issuedDate;
    }

    /**
     * Issuing country of the document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIssuingCountry(final String issuingCountry) {
      this.issuingCountry = issuingCountry;
    }

    /**
     * Last name as it appears in the document.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLastName(final String lastName) {
      this.lastName = lastName;
    }

    /**
     * Document ID number.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNumber(final String number) {
      this.number = number;
    }

    /**
     * Status of this {@code document} check.
     *
     * <p>One of {@code unverified}, or {@code verified}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    /**
     * Type of the document.
     *
     * <p>One of {@code driving_license}, {@code id_card}, or {@code passport}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof VerificationReport.Document)) return false;
      final VerificationReport.Document other = (VerificationReport.Document) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$address = this.getAddress();
      final java.lang.Object other$address = other.getAddress();
      if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
      final java.lang.Object this$dob = this.getDob();
      final java.lang.Object other$dob = other.getDob();
      if (this$dob == null ? other$dob != null : !this$dob.equals(other$dob)) return false;
      final java.lang.Object this$error = this.getError();
      final java.lang.Object other$error = other.getError();
      if (this$error == null ? other$error != null : !this$error.equals(other$error)) return false;
      final java.lang.Object this$expirationDate = this.getExpirationDate();
      final java.lang.Object other$expirationDate = other.getExpirationDate();
      if (this$expirationDate == null ? other$expirationDate != null : !this$expirationDate.equals(other$expirationDate)) return false;
      final java.lang.Object this$files = this.getFiles();
      final java.lang.Object other$files = other.getFiles();
      if (this$files == null ? other$files != null : !this$files.equals(other$files)) return false;
      final java.lang.Object this$firstName = this.getFirstName();
      final java.lang.Object other$firstName = other.getFirstName();
      if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) return false;
      final java.lang.Object this$issuedDate = this.getIssuedDate();
      final java.lang.Object other$issuedDate = other.getIssuedDate();
      if (this$issuedDate == null ? other$issuedDate != null : !this$issuedDate.equals(other$issuedDate)) return false;
      final java.lang.Object this$issuingCountry = this.getIssuingCountry();
      final java.lang.Object other$issuingCountry = other.getIssuingCountry();
      if (this$issuingCountry == null ? other$issuingCountry != null : !this$issuingCountry.equals(other$issuingCountry)) return false;
      final java.lang.Object this$lastName = this.getLastName();
      final java.lang.Object other$lastName = other.getLastName();
      if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) return false;
      final java.lang.Object this$number = this.getNumber();
      final java.lang.Object other$number = other.getNumber();
      if (this$number == null ? other$number != null : !this$number.equals(other$number)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof VerificationReport.Document;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $address = this.getAddress();
      result = result * PRIME + ($address == null ? 43 : $address.hashCode());
      final java.lang.Object $dob = this.getDob();
      result = result * PRIME + ($dob == null ? 43 : $dob.hashCode());
      final java.lang.Object $error = this.getError();
      result = result * PRIME + ($error == null ? 43 : $error.hashCode());
      final java.lang.Object $expirationDate = this.getExpirationDate();
      result = result * PRIME + ($expirationDate == null ? 43 : $expirationDate.hashCode());
      final java.lang.Object $files = this.getFiles();
      result = result * PRIME + ($files == null ? 43 : $files.hashCode());
      final java.lang.Object $firstName = this.getFirstName();
      result = result * PRIME + ($firstName == null ? 43 : $firstName.hashCode());
      final java.lang.Object $issuedDate = this.getIssuedDate();
      result = result * PRIME + ($issuedDate == null ? 43 : $issuedDate.hashCode());
      final java.lang.Object $issuingCountry = this.getIssuingCountry();
      result = result * PRIME + ($issuingCountry == null ? 43 : $issuingCountry.hashCode());
      final java.lang.Object $lastName = this.getLastName();
      result = result * PRIME + ($lastName == null ? 43 : $lastName.hashCode());
      final java.lang.Object $number = this.getNumber();
      result = result * PRIME + ($number == null ? 43 : $number.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }


  /**
   * The four-digit year.
   */
  public static class IdNumber extends StripeObject {
    /**
     * Date of birth.
     */
    @SerializedName("dob")
    DateOfBirth dob;
    /**
     * Details on the verification error. Present when status is {@code unverified}.
     */
    @SerializedName("error")
    IdNumberCheckError error;
    /**
     * First name.
     */
    @SerializedName("first_name")
    String firstName;
    /**
     * ID number.
     */
    @SerializedName("id_number")
    String idNumber;
    /**
     * Type of ID number.
     *
     * <p>One of {@code br_cpf}, {@code sg_nric}, or {@code us_ssn}.
     */
    @SerializedName("id_number_type")
    String idNumberType;
    /**
     * Last name.
     */
    @SerializedName("last_name")
    String lastName;
    /**
     * Status of this {@code id_number} check.
     *
     * <p>One of {@code unverified}, or {@code verified}.
     */
    @SerializedName("status")
    String status;


    public static class DateOfBirth extends StripeObject {
      /**
       * Numerical day between 1 and 31.
       */
      @SerializedName("day")
      Long day;
      /**
       * Numerical month between 1 and 12.
       */
      @SerializedName("month")
      Long month;
      /**
       * The four-digit year.
       */
      @SerializedName("year")
      Long year;

      /**
       * Numerical day between 1 and 31.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getDay() {
        return this.day;
      }

      /**
       * Numerical month between 1 and 12.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getMonth() {
        return this.month;
      }

      /**
       * The four-digit year.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getYear() {
        return this.year;
      }

      /**
       * Numerical day between 1 and 31.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDay(final Long day) {
        this.day = day;
      }

      /**
       * Numerical month between 1 and 12.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMonth(final Long month) {
        this.month = month;
      }

      /**
       * The four-digit year.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setYear(final Long year) {
        this.year = year;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof VerificationReport.IdNumber.DateOfBirth)) return false;
        final VerificationReport.IdNumber.DateOfBirth other = (VerificationReport.IdNumber.DateOfBirth) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$day = this.getDay();
        final java.lang.Object other$day = other.getDay();
        if (this$day == null ? other$day != null : !this$day.equals(other$day)) return false;
        final java.lang.Object this$month = this.getMonth();
        final java.lang.Object other$month = other.getMonth();
        if (this$month == null ? other$month != null : !this$month.equals(other$month)) return false;
        final java.lang.Object this$year = this.getYear();
        final java.lang.Object other$year = other.getYear();
        if (this$year == null ? other$year != null : !this$year.equals(other$year)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof VerificationReport.IdNumber.DateOfBirth;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $day = this.getDay();
        result = result * PRIME + ($day == null ? 43 : $day.hashCode());
        final java.lang.Object $month = this.getMonth();
        result = result * PRIME + ($month == null ? 43 : $month.hashCode());
        final java.lang.Object $year = this.getYear();
        result = result * PRIME + ($year == null ? 43 : $year.hashCode());
        return result;
      }
    }


    public static class IdNumberCheckError extends StripeObject {
      /**
       * A short machine-readable string giving the reason for the verification failure.
       *
       * <p>One of {@code id_number_insufficient_document_data}, {@code id_number_mismatch}, or
       * {@code id_number_unverified_other}.
       */
      @SerializedName("code")
      String code;
      @SerializedName("reason")
      String reason;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCode() {
        return this.code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getReason() {
        return this.reason;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCode(final String code) {
        this.code = code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReason(final String reason) {
        this.reason = reason;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof VerificationReport.IdNumber.IdNumberCheckError)) return false;
        final VerificationReport.IdNumber.IdNumberCheckError other = (VerificationReport.IdNumber.IdNumberCheckError) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$code = this.getCode();
        final java.lang.Object other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
        final java.lang.Object this$reason = this.getReason();
        final java.lang.Object other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof VerificationReport.IdNumber.IdNumberCheckError;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $code = this.getCode();
        result = result * PRIME + ($code == null ? 43 : $code.hashCode());
        final java.lang.Object $reason = this.getReason();
        result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
        return result;
      }
    }

    /**
     * Date of birth.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DateOfBirth getDob() {
      return this.dob;
    }

    /**
     * Details on the verification error. Present when status is {@code unverified}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IdNumberCheckError getError() {
      return this.error;
    }

    /**
     * First name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFirstName() {
      return this.firstName;
    }

    /**
     * ID number.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIdNumber() {
      return this.idNumber;
    }

    /**
     * Type of ID number.
     *
     * <p>One of {@code br_cpf}, {@code sg_nric}, or {@code us_ssn}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIdNumberType() {
      return this.idNumberType;
    }

    /**
     * Last name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLastName() {
      return this.lastName;
    }

    /**
     * Status of this {@code id_number} check.
     *
     * <p>One of {@code unverified}, or {@code verified}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    /**
     * Date of birth.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDob(final DateOfBirth dob) {
      this.dob = dob;
    }

    /**
     * Details on the verification error. Present when status is {@code unverified}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setError(final IdNumberCheckError error) {
      this.error = error;
    }

    /**
     * First name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFirstName(final String firstName) {
      this.firstName = firstName;
    }

    /**
     * ID number.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIdNumber(final String idNumber) {
      this.idNumber = idNumber;
    }

    /**
     * Type of ID number.
     *
     * <p>One of {@code br_cpf}, {@code sg_nric}, or {@code us_ssn}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIdNumberType(final String idNumberType) {
      this.idNumberType = idNumberType;
    }

    /**
     * Last name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLastName(final String lastName) {
      this.lastName = lastName;
    }

    /**
     * Status of this {@code id_number} check.
     *
     * <p>One of {@code unverified}, or {@code verified}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof VerificationReport.IdNumber)) return false;
      final VerificationReport.IdNumber other = (VerificationReport.IdNumber) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$dob = this.getDob();
      final java.lang.Object other$dob = other.getDob();
      if (this$dob == null ? other$dob != null : !this$dob.equals(other$dob)) return false;
      final java.lang.Object this$error = this.getError();
      final java.lang.Object other$error = other.getError();
      if (this$error == null ? other$error != null : !this$error.equals(other$error)) return false;
      final java.lang.Object this$firstName = this.getFirstName();
      final java.lang.Object other$firstName = other.getFirstName();
      if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) return false;
      final java.lang.Object this$idNumber = this.getIdNumber();
      final java.lang.Object other$idNumber = other.getIdNumber();
      if (this$idNumber == null ? other$idNumber != null : !this$idNumber.equals(other$idNumber)) return false;
      final java.lang.Object this$idNumberType = this.getIdNumberType();
      final java.lang.Object other$idNumberType = other.getIdNumberType();
      if (this$idNumberType == null ? other$idNumberType != null : !this$idNumberType.equals(other$idNumberType)) return false;
      final java.lang.Object this$lastName = this.getLastName();
      final java.lang.Object other$lastName = other.getLastName();
      if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof VerificationReport.IdNumber;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $dob = this.getDob();
      result = result * PRIME + ($dob == null ? 43 : $dob.hashCode());
      final java.lang.Object $error = this.getError();
      result = result * PRIME + ($error == null ? 43 : $error.hashCode());
      final java.lang.Object $firstName = this.getFirstName();
      result = result * PRIME + ($firstName == null ? 43 : $firstName.hashCode());
      final java.lang.Object $idNumber = this.getIdNumber();
      result = result * PRIME + ($idNumber == null ? 43 : $idNumber.hashCode());
      final java.lang.Object $idNumberType = this.getIdNumberType();
      result = result * PRIME + ($idNumberType == null ? 43 : $idNumberType.hashCode());
      final java.lang.Object $lastName = this.getLastName();
      result = result * PRIME + ($lastName == null ? 43 : $lastName.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      return result;
    }
  }


  /**
   * A human-readable message giving the reason for the failure. These messages can be shown to
   * your users.
   */
  public static class Options extends StripeObject {
    @SerializedName("document")
    Document document;
    @SerializedName("id_number")
    IdNumber idNumber;


    public static class Document extends StripeObject {
      /**
       * Array of strings of allowed identity document types. If the provided identity document
       * isn’t one of the allowed types, the verification check will fail with a
       * document_type_not_allowed error code.
       */
      @SerializedName("allowed_types")
      List<String> allowedTypes;
      /**
       * Collect an ID number and perform an <a
       * href="https://stripe.com/docs/identity/verification-checks?type=id-number">ID number
       * check</a> with the document’s extracted name and date of birth.
       */
      @SerializedName("require_id_number")
      Boolean requireIdNumber;
      /**
       * Disable image uploads, identity document images have to be captured using the device’s
       * camera.
       */
      @SerializedName("require_live_capture")
      Boolean requireLiveCapture;
      /**
       * Capture a face image and perform a <a
       * href="https://stripe.com/docs/identity/verification-checks?type=selfie">selfie check</a>
       * comparing a photo ID and a picture of your user’s face. <a
       * href="https://stripe.com/docs/identity/selfie">Learn more</a>.
       */
      @SerializedName("require_matching_selfie")
      Boolean requireMatchingSelfie;

      /**
       * Array of strings of allowed identity document types. If the provided identity document
       * isn’t one of the allowed types, the verification check will fail with a
       * document_type_not_allowed error code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getAllowedTypes() {
        return this.allowedTypes;
      }

      /**
       * Collect an ID number and perform an <a
       * href="https://stripe.com/docs/identity/verification-checks?type=id-number">ID number
       * check</a> with the document’s extracted name and date of birth.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getRequireIdNumber() {
        return this.requireIdNumber;
      }

      /**
       * Disable image uploads, identity document images have to be captured using the device’s
       * camera.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getRequireLiveCapture() {
        return this.requireLiveCapture;
      }

      /**
       * Capture a face image and perform a <a
       * href="https://stripe.com/docs/identity/verification-checks?type=selfie">selfie check</a>
       * comparing a photo ID and a picture of your user’s face. <a
       * href="https://stripe.com/docs/identity/selfie">Learn more</a>.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getRequireMatchingSelfie() {
        return this.requireMatchingSelfie;
      }

      /**
       * Array of strings of allowed identity document types. If the provided identity document
       * isn’t one of the allowed types, the verification check will fail with a
       * document_type_not_allowed error code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAllowedTypes(final List<String> allowedTypes) {
        this.allowedTypes = allowedTypes;
      }

      /**
       * Collect an ID number and perform an <a
       * href="https://stripe.com/docs/identity/verification-checks?type=id-number">ID number
       * check</a> with the document’s extracted name and date of birth.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequireIdNumber(final Boolean requireIdNumber) {
        this.requireIdNumber = requireIdNumber;
      }

      /**
       * Disable image uploads, identity document images have to be captured using the device’s
       * camera.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequireLiveCapture(final Boolean requireLiveCapture) {
        this.requireLiveCapture = requireLiveCapture;
      }

      /**
       * Capture a face image and perform a <a
       * href="https://stripe.com/docs/identity/verification-checks?type=selfie">selfie check</a>
       * comparing a photo ID and a picture of your user’s face. <a
       * href="https://stripe.com/docs/identity/selfie">Learn more</a>.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequireMatchingSelfie(final Boolean requireMatchingSelfie) {
        this.requireMatchingSelfie = requireMatchingSelfie;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof VerificationReport.Options.Document)) return false;
        final VerificationReport.Options.Document other = (VerificationReport.Options.Document) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$requireIdNumber = this.getRequireIdNumber();
        final java.lang.Object other$requireIdNumber = other.getRequireIdNumber();
        if (this$requireIdNumber == null ? other$requireIdNumber != null : !this$requireIdNumber.equals(other$requireIdNumber)) return false;
        final java.lang.Object this$requireLiveCapture = this.getRequireLiveCapture();
        final java.lang.Object other$requireLiveCapture = other.getRequireLiveCapture();
        if (this$requireLiveCapture == null ? other$requireLiveCapture != null : !this$requireLiveCapture.equals(other$requireLiveCapture)) return false;
        final java.lang.Object this$requireMatchingSelfie = this.getRequireMatchingSelfie();
        final java.lang.Object other$requireMatchingSelfie = other.getRequireMatchingSelfie();
        if (this$requireMatchingSelfie == null ? other$requireMatchingSelfie != null : !this$requireMatchingSelfie.equals(other$requireMatchingSelfie)) return false;
        final java.lang.Object this$allowedTypes = this.getAllowedTypes();
        final java.lang.Object other$allowedTypes = other.getAllowedTypes();
        if (this$allowedTypes == null ? other$allowedTypes != null : !this$allowedTypes.equals(other$allowedTypes)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof VerificationReport.Options.Document;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $requireIdNumber = this.getRequireIdNumber();
        result = result * PRIME + ($requireIdNumber == null ? 43 : $requireIdNumber.hashCode());
        final java.lang.Object $requireLiveCapture = this.getRequireLiveCapture();
        result = result * PRIME + ($requireLiveCapture == null ? 43 : $requireLiveCapture.hashCode());
        final java.lang.Object $requireMatchingSelfie = this.getRequireMatchingSelfie();
        result = result * PRIME + ($requireMatchingSelfie == null ? 43 : $requireMatchingSelfie.hashCode());
        final java.lang.Object $allowedTypes = this.getAllowedTypes();
        result = result * PRIME + ($allowedTypes == null ? 43 : $allowedTypes.hashCode());
        return result;
      }
    }


    public static class IdNumber extends StripeObject {
      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof VerificationReport.Options.IdNumber)) return false;
        final VerificationReport.Options.IdNumber other = (VerificationReport.Options.IdNumber) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof VerificationReport.Options.IdNumber;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int result = 1;
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Document getDocument() {
      return this.document;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IdNumber getIdNumber() {
      return this.idNumber;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDocument(final Document document) {
      this.document = document;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIdNumber(final IdNumber idNumber) {
      this.idNumber = idNumber;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof VerificationReport.Options)) return false;
      final VerificationReport.Options other = (VerificationReport.Options) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$document = this.getDocument();
      final java.lang.Object other$document = other.getDocument();
      if (this$document == null ? other$document != null : !this$document.equals(other$document)) return false;
      final java.lang.Object this$idNumber = this.getIdNumber();
      final java.lang.Object other$idNumber = other.getIdNumber();
      if (this$idNumber == null ? other$idNumber != null : !this$idNumber.equals(other$idNumber)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof VerificationReport.Options;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $document = this.getDocument();
      result = result * PRIME + ($document == null ? 43 : $document.hashCode());
      final java.lang.Object $idNumber = this.getIdNumber();
      result = result * PRIME + ($idNumber == null ? 43 : $idNumber.hashCode());
      return result;
    }
  }


  public static class Selfie extends StripeObject {
    /**
     * ID of the <a href="https://stripe.com/docs/api/files">File</a> holding the image of the
     * identity document used in this check.
     */
    @SerializedName("document")
    String document;
    /** Details on the verification error. Present when status is {@code unverified}. */
    @SerializedName("error")
    SelfieCheckError error;
    /**
     * ID of the <a href="https://stripe.com/docs/api/files">File</a> holding the image of the
     * selfie used in this check.
     */
    @SerializedName("selfie")
    String selfie;
    /**
     * Status of this {@code selfie} check.
     *
     * <p>One of {@code unverified}, or {@code verified}.
     */
    @SerializedName("status")
    String status;


    public static class SelfieCheckError extends StripeObject {
      /**
       * A short machine-readable string giving the reason for the verification failure.
       *
       * <p>One of {@code selfie_document_missing_photo}, {@code selfie_face_mismatch}, {@code
       * selfie_manipulated}, or {@code selfie_unverified_other}.
       */
      @SerializedName("code")
      String code;
      /**
       * A human-readable message giving the reason for the failure. These messages can be shown to
       * your users.
       */
      @SerializedName("reason")
      String reason;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCode() {
        return this.code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getReason() {
        return this.reason;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCode(final String code) {
        this.code = code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReason(final String reason) {
        this.reason = reason;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof VerificationReport.Selfie.SelfieCheckError)) return false;
        final VerificationReport.Selfie.SelfieCheckError other = (VerificationReport.Selfie.SelfieCheckError) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$code = this.getCode();
        final java.lang.Object other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
        final java.lang.Object this$reason = this.getReason();
        final java.lang.Object other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof VerificationReport.Selfie.SelfieCheckError;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $code = this.getCode();
        result = result * PRIME + ($code == null ? 43 : $code.hashCode());
        final java.lang.Object $reason = this.getReason();
        result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDocument() {
      return this.document;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SelfieCheckError getError() {
      return this.error;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSelfie() {
      return this.selfie;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDocument(final String document) {
      this.document = document;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setError(final SelfieCheckError error) {
      this.error = error;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSelfie(final String selfie) {
      this.selfie = selfie;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof VerificationReport.Selfie)) return false;
      final VerificationReport.Selfie other = (VerificationReport.Selfie) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$document = this.getDocument();
      final java.lang.Object other$document = other.getDocument();
      if (this$document == null ? other$document != null : !this$document.equals(other$document)) return false;
      final java.lang.Object this$error = this.getError();
      final java.lang.Object other$error = other.getError();
      if (this$error == null ? other$error != null : !this$error.equals(other$error)) return false;
      final java.lang.Object this$selfie = this.getSelfie();
      final java.lang.Object other$selfie = other.getSelfie();
      if (this$selfie == null ? other$selfie != null : !this$selfie.equals(other$selfie)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof VerificationReport.Selfie;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $document = this.getDocument();
      result = result * PRIME + ($document == null ? 43 : $document.hashCode());
      final java.lang.Object $error = this.getError();
      result = result * PRIME + ($error == null ? 43 : $error.hashCode());
      final java.lang.Object $selfie = this.getSelfie();
      result = result * PRIME + ($selfie == null ? 43 : $selfie.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      return result;
    }
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Result from a document check.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Document getDocument() {
    return this.document;
  }

  /**
   * Result from an id_number check.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public IdNumber getIdNumber() {
    return this.idNumber;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code identity.verification_report}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Options getOptions() {
    return this.options;
  }

  /**
   * Result from a selfie check.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Selfie getSelfie() {
    return this.selfie;
  }

  /**
   * Type of report.
   *
   * <p>One of {@code document}, or {@code id_number}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * ID of the VerificationSession that created this report.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getVerificationSession() {
    return this.verificationSession;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Result from a document check.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDocument(final Document document) {
    this.document = document;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Result from an id_number check.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIdNumber(final IdNumber idNumber) {
    this.idNumber = idNumber;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code identity.verification_report}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOptions(final Options options) {
    this.options = options;
  }

  /**
   * Result from a selfie check.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSelfie(final Selfie selfie) {
    this.selfie = selfie;
  }

  /**
   * Type of report.
   *
   * <p>One of {@code document}, or {@code id_number}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  /**
   * ID of the VerificationSession that created this report.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVerificationSession(final String verificationSession) {
    this.verificationSession = verificationSession;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof VerificationReport)) return false;
    final VerificationReport other = (VerificationReport) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$document = this.getDocument();
    final java.lang.Object other$document = other.getDocument();
    if (this$document == null ? other$document != null : !this$document.equals(other$document)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$idNumber = this.getIdNumber();
    final java.lang.Object other$idNumber = other.getIdNumber();
    if (this$idNumber == null ? other$idNumber != null : !this$idNumber.equals(other$idNumber)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$options = this.getOptions();
    final java.lang.Object other$options = other.getOptions();
    if (this$options == null ? other$options != null : !this$options.equals(other$options)) return false;
    final java.lang.Object this$selfie = this.getSelfie();
    final java.lang.Object other$selfie = other.getSelfie();
    if (this$selfie == null ? other$selfie != null : !this$selfie.equals(other$selfie)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    final java.lang.Object this$verificationSession = this.getVerificationSession();
    final java.lang.Object other$verificationSession = other.getVerificationSession();
    if (this$verificationSession == null ? other$verificationSession != null : !this$verificationSession.equals(other$verificationSession)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof VerificationReport;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $document = this.getDocument();
    result = result * PRIME + ($document == null ? 43 : $document.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $idNumber = this.getIdNumber();
    result = result * PRIME + ($idNumber == null ? 43 : $idNumber.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $options = this.getOptions();
    result = result * PRIME + ($options == null ? 43 : $options.hashCode());
    final java.lang.Object $selfie = this.getSelfie();
    result = result * PRIME + ($selfie == null ? 43 : $selfie.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    final java.lang.Object $verificationSession = this.getVerificationSession();
    result = result * PRIME + ($verificationSession == null ? 43 : $verificationSession.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
