// Generated by delombok at Thu Dec 09 15:45:44 EST 2021
// File generated from our OpenAPI spec
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.ExpandableField;
import com.stripe.model.File;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.issuing.DisputeCreateParams;
import com.stripe.param.issuing.DisputeListParams;
import com.stripe.param.issuing.DisputeRetrieveParams;
import com.stripe.param.issuing.DisputeSubmitParams;
import com.stripe.param.issuing.DisputeUpdateParams;
import java.util.List;
import java.util.Map;

public class Dispute extends ApiResource implements MetadataStore<Dispute>, BalanceTransactionSource {
  /**
   * Disputed amount. Usually the amount of the {@code transaction}, but can differ (usually because
   * of currency fluctuation).
   */
  @SerializedName("amount")
  Long amount;
  /**
   * List of balance transactions associated with the dispute.
   */
  @SerializedName("balance_transactions")
  List<BalanceTransaction> balanceTransactions;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * The currency the {@code transaction} was made in.
   */
  @SerializedName("currency")
  String currency;
  @SerializedName("evidence")
  Evidence evidence;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code issuing.dispute}.
   */
  @SerializedName("object")
  String object;
  /**
   * Current status of the dispute.
   *
   * <p>One of {@code expired}, {@code lost}, {@code submitted}, {@code unsubmitted}, or {@code
   * won}.
   */
  @SerializedName("status")
  String status;
  /**
   * The transaction being disputed.
   */
  @SerializedName("transaction")
  ExpandableField<Transaction> transaction;

  /**
   * Get ID of expandable {@code transaction} object.
   */
  public String getTransaction() {
    return (this.transaction != null) ? this.transaction.getId() : null;
  }

  public void setTransaction(String id) {
    this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
  }

  /**
   * Get expanded {@code transaction}.
   */
  public Transaction getTransactionObject() {
    return (this.transaction != null) ? this.transaction.getExpanded() : null;
  }

  public void setTransactionObject(Transaction expandableObject) {
    this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
  }

  /**
   * Returns a list of Issuing <code>Dispute</code> objects. The objects are sorted in descending
   * order by creation date, with the most recently created object appearing first.
   */
  public static DisputeCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of Issuing <code>Dispute</code> objects. The objects are sorted in descending
   * order by creation date, with the most recently created object appearing first.
   */
  public static DisputeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/disputes");
    return ApiResource.requestCollection(url, params, DisputeCollection.class, options);
  }

  /**
   * Returns a list of Issuing <code>Dispute</code> objects. The objects are sorted in descending
   * order by creation date, with the most recently created object appearing first.
   */
  public static DisputeCollection list(DisputeListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of Issuing <code>Dispute</code> objects. The objects are sorted in descending
   * order by creation date, with the most recently created object appearing first.
   */
  public static DisputeCollection list(DisputeListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/disputes");
    return ApiResource.requestCollection(url, params, DisputeCollection.class, options);
  }

  /**
   * Creates an Issuing <code>Dispute</code> object. Individual pieces of evidence within the <code>
   * evidence</code> object are optional at this point. Stripe only validates that required evidence
   * is present during submission. Refer to <a
   * href="https://stripe.com/docs/issuing/purchases/disputes#dispute-reasons-and-evidence">Dispute
   * reasons and evidence</a> for more details about evidence requirements.
   */
  public static Dispute create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates an Issuing <code>Dispute</code> object. Individual pieces of evidence within the <code>
   * evidence</code> object are optional at this point. Stripe only validates that required evidence
   * is present during submission. Refer to <a
   * href="https://stripe.com/docs/issuing/purchases/disputes#dispute-reasons-and-evidence">Dispute
   * reasons and evidence</a> for more details about evidence requirements.
   */
  public static Dispute create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/disputes");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
  }

  /**
   * Creates an Issuing <code>Dispute</code> object. Individual pieces of evidence within the <code>
   * evidence</code> object are optional at this point. Stripe only validates that required evidence
   * is present during submission. Refer to <a
   * href="https://stripe.com/docs/issuing/purchases/disputes#dispute-reasons-and-evidence">Dispute
   * reasons and evidence</a> for more details about evidence requirements.
   */
  public static Dispute create(DisputeCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates an Issuing <code>Dispute</code> object. Individual pieces of evidence within the <code>
   * evidence</code> object are optional at this point. Stripe only validates that required evidence
   * is present during submission. Refer to <a
   * href="https://stripe.com/docs/issuing/purchases/disputes#dispute-reasons-and-evidence">Dispute
   * reasons and evidence</a> for more details about evidence requirements.
   */
  public static Dispute create(DisputeCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/disputes");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
  }

  /**
   * Updates the specified Issuing <code>Dispute</code> object by setting the values of the
   * parameters passed. Any parameters not provided will be left unchanged. Properties on the <code>
   * evidence</code> object can be unset by passing in an empty string.
   */
  @Override
  public Dispute update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified Issuing <code>Dispute</code> object by setting the values of the
   * parameters passed. Any parameters not provided will be left unchanged. Properties on the <code>
   * evidence</code> object can be unset by passing in an empty string.
   */
  @Override
  public Dispute update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
  }

  /**
   * Updates the specified Issuing <code>Dispute</code> object by setting the values of the
   * parameters passed. Any parameters not provided will be left unchanged. Properties on the <code>
   * evidence</code> object can be unset by passing in an empty string.
   */
  public Dispute update(DisputeUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specified Issuing <code>Dispute</code> object by setting the values of the
   * parameters passed. Any parameters not provided will be left unchanged. Properties on the <code>
   * evidence</code> object can be unset by passing in an empty string.
   */
  public Dispute update(DisputeUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
  }

  /**
   * Retrieves an Issuing <code>Dispute</code> object.
   */
  public static Dispute retrieve(String dispute) throws StripeException {
    return retrieve(dispute, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves an Issuing <code>Dispute</code> object.
   */
  public static Dispute retrieve(String dispute, RequestOptions options) throws StripeException {
    return retrieve(dispute, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves an Issuing <code>Dispute</code> object.
   */
  public static Dispute retrieve(String dispute, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(dispute)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Dispute.class, options);
  }

  /**
   * Retrieves an Issuing <code>Dispute</code> object.
   */
  public static Dispute retrieve(String dispute, DisputeRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(dispute)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Dispute.class, options);
  }

  /**
   * Submits an Issuing <code>Dispute</code> to the card network. Stripe validates that all evidence
   * fields required for the dispute’s reason are present. For more details, see <a
   * href="https://stripe.com/docs/issuing/purchases/disputes#dispute-reasons-and-evidence">Dispute
   * reasons and evidence</a>.
   */
  public Dispute submit() throws StripeException {
    return submit((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Submits an Issuing <code>Dispute</code> to the card network. Stripe validates that all evidence
   * fields required for the dispute’s reason are present. For more details, see <a
   * href="https://stripe.com/docs/issuing/purchases/disputes#dispute-reasons-and-evidence">Dispute
   * reasons and evidence</a>.
   */
  public Dispute submit(RequestOptions options) throws StripeException {
    return submit((Map<String, Object>) null, options);
  }

  /**
   * Submits an Issuing <code>Dispute</code> to the card network. Stripe validates that all evidence
   * fields required for the dispute’s reason are present. For more details, see <a
   * href="https://stripe.com/docs/issuing/purchases/disputes#dispute-reasons-and-evidence">Dispute
   * reasons and evidence</a>.
   */
  public Dispute submit(Map<String, Object> params) throws StripeException {
    return submit(params, (RequestOptions) null);
  }

  /**
   * Submits an Issuing <code>Dispute</code> to the card network. Stripe validates that all evidence
   * fields required for the dispute’s reason are present. For more details, see <a
   * href="https://stripe.com/docs/issuing/purchases/disputes#dispute-reasons-and-evidence">Dispute
   * reasons and evidence</a>.
   */
  public Dispute submit(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s/submit", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
  }

  /**
   * Submits an Issuing <code>Dispute</code> to the card network. Stripe validates that all evidence
   * fields required for the dispute’s reason are present. For more details, see <a
   * href="https://stripe.com/docs/issuing/purchases/disputes#dispute-reasons-and-evidence">Dispute
   * reasons and evidence</a>.
   */
  public Dispute submit(DisputeSubmitParams params) throws StripeException {
    return submit(params, (RequestOptions) null);
  }

  /**
   * Submits an Issuing <code>Dispute</code> to the card network. Stripe validates that all evidence
   * fields required for the dispute’s reason are present. For more details, see <a
   * href="https://stripe.com/docs/issuing/purchases/disputes#dispute-reasons-and-evidence">Dispute
   * reasons and evidence</a>.
   */
  public Dispute submit(DisputeSubmitParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s/submit", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
  }


  public static class Evidence extends StripeObject {
    @SerializedName("canceled")
    Canceled canceled;
    @SerializedName("duplicate")
    Duplicate duplicate;
    @SerializedName("fraudulent")
    Fraudulent fraudulent;
    @SerializedName("merchandise_not_as_described")
    MerchandiseNotAsDescribed merchandiseNotAsDescribed;
    @SerializedName("not_received")
    NotReceived notReceived;
    @SerializedName("other")
    Other other;
    /**
     * The reason for filing the dispute. Its value will match the field containing the evidence.
     *
     * <p>One of {@code canceled}, {@code duplicate}, {@code fraudulent}, {@code
     * merchandise_not_as_described}, {@code not_received}, {@code other}, or {@code
     * service_not_as_described}.
     */
    @SerializedName("reason")
    String reason;
    @SerializedName("service_not_as_described")
    ServiceNotAsDescribed serviceNotAsDescribed;


    public static class Canceled extends StripeObject {
      /**
       * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Additional
       * documentation supporting the dispute.
       */
      @SerializedName("additional_documentation")
      ExpandableField<File> additionalDocumentation;
      /** Date when order was canceled. */
      @SerializedName("canceled_at")
      Long canceledAt;
      /** Whether the cardholder was provided with a cancellation policy. */
      @SerializedName("cancellation_policy_provided")
      Boolean cancellationPolicyProvided;
      /** Reason for canceling the order. */
      @SerializedName("cancellation_reason")
      String cancellationReason;
      /** Date when the cardholder expected to receive the product. */
      @SerializedName("expected_at")
      Long expectedAt;
      /** Explanation of why the cardholder is disputing this transaction. */
      @SerializedName("explanation")
      String explanation;
      /** Description of the merchandise or service that was purchased. */
      @SerializedName("product_description")
      String productDescription;
      /**
       * Whether the product was a merchandise or service.
       *
       * <p>One of {@code merchandise}, or {@code service}.
       */
      @SerializedName("product_type")
      String productType;
      /** Date when the product was returned or attempted to be returned. */
      @SerializedName("returned_at")
      Long returnedAt;
      /**
       * Result of cardholder's attempt to return the product.
       *
       * <p>One of {@code merchant_rejected}, or {@code successful}.
       */
      @SerializedName("return_status")
      String returnStatus;

      /** Get ID of expandable {@code additionalDocumentation} object. */
      public String getAdditionalDocumentation() {
        return (this.additionalDocumentation != null) ? this.additionalDocumentation.getId() : null;
      }

      public void setAdditionalDocumentation(String id) {
        this.additionalDocumentation = ApiResource.setExpandableFieldId(id, this.additionalDocumentation);
      }

      /** Get expanded {@code additionalDocumentation}. */
      public File getAdditionalDocumentationObject() {
        return (this.additionalDocumentation != null) ? this.additionalDocumentation.getExpanded() : null;
      }

      public void setAdditionalDocumentationObject(File expandableObject) {
        this.additionalDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getCanceledAt() {
        return this.canceledAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getCancellationPolicyProvided() {
        return this.cancellationPolicyProvided;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCancellationReason() {
        return this.cancellationReason;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getExpectedAt() {
        return this.expectedAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getExplanation() {
        return this.explanation;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getProductDescription() {
        return this.productDescription;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getProductType() {
        return this.productType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getReturnedAt() {
        return this.returnedAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getReturnStatus() {
        return this.returnStatus;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCanceledAt(final Long canceledAt) {
        this.canceledAt = canceledAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCancellationPolicyProvided(final Boolean cancellationPolicyProvided) {
        this.cancellationPolicyProvided = cancellationPolicyProvided;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCancellationReason(final String cancellationReason) {
        this.cancellationReason = cancellationReason;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExpectedAt(final Long expectedAt) {
        this.expectedAt = expectedAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExplanation(final String explanation) {
        this.explanation = explanation;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setProductDescription(final String productDescription) {
        this.productDescription = productDescription;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setProductType(final String productType) {
        this.productType = productType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReturnedAt(final Long returnedAt) {
        this.returnedAt = returnedAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReturnStatus(final String returnStatus) {
        this.returnStatus = returnStatus;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Dispute.Evidence.Canceled)) return false;
        final Dispute.Evidence.Canceled other = (Dispute.Evidence.Canceled) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$canceledAt = this.getCanceledAt();
        final java.lang.Object other$canceledAt = other.getCanceledAt();
        if (this$canceledAt == null ? other$canceledAt != null : !this$canceledAt.equals(other$canceledAt)) return false;
        final java.lang.Object this$cancellationPolicyProvided = this.getCancellationPolicyProvided();
        final java.lang.Object other$cancellationPolicyProvided = other.getCancellationPolicyProvided();
        if (this$cancellationPolicyProvided == null ? other$cancellationPolicyProvided != null : !this$cancellationPolicyProvided.equals(other$cancellationPolicyProvided)) return false;
        final java.lang.Object this$expectedAt = this.getExpectedAt();
        final java.lang.Object other$expectedAt = other.getExpectedAt();
        if (this$expectedAt == null ? other$expectedAt != null : !this$expectedAt.equals(other$expectedAt)) return false;
        final java.lang.Object this$returnedAt = this.getReturnedAt();
        final java.lang.Object other$returnedAt = other.getReturnedAt();
        if (this$returnedAt == null ? other$returnedAt != null : !this$returnedAt.equals(other$returnedAt)) return false;
        final java.lang.Object this$additionalDocumentation = this.getAdditionalDocumentation();
        final java.lang.Object other$additionalDocumentation = other.getAdditionalDocumentation();
        if (this$additionalDocumentation == null ? other$additionalDocumentation != null : !this$additionalDocumentation.equals(other$additionalDocumentation)) return false;
        final java.lang.Object this$cancellationReason = this.getCancellationReason();
        final java.lang.Object other$cancellationReason = other.getCancellationReason();
        if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) return false;
        final java.lang.Object this$explanation = this.getExplanation();
        final java.lang.Object other$explanation = other.getExplanation();
        if (this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation)) return false;
        final java.lang.Object this$productDescription = this.getProductDescription();
        final java.lang.Object other$productDescription = other.getProductDescription();
        if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) return false;
        final java.lang.Object this$productType = this.getProductType();
        final java.lang.Object other$productType = other.getProductType();
        if (this$productType == null ? other$productType != null : !this$productType.equals(other$productType)) return false;
        final java.lang.Object this$returnStatus = this.getReturnStatus();
        final java.lang.Object other$returnStatus = other.getReturnStatus();
        if (this$returnStatus == null ? other$returnStatus != null : !this$returnStatus.equals(other$returnStatus)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Dispute.Evidence.Canceled;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $canceledAt = this.getCanceledAt();
        result = result * PRIME + ($canceledAt == null ? 43 : $canceledAt.hashCode());
        final java.lang.Object $cancellationPolicyProvided = this.getCancellationPolicyProvided();
        result = result * PRIME + ($cancellationPolicyProvided == null ? 43 : $cancellationPolicyProvided.hashCode());
        final java.lang.Object $expectedAt = this.getExpectedAt();
        result = result * PRIME + ($expectedAt == null ? 43 : $expectedAt.hashCode());
        final java.lang.Object $returnedAt = this.getReturnedAt();
        result = result * PRIME + ($returnedAt == null ? 43 : $returnedAt.hashCode());
        final java.lang.Object $additionalDocumentation = this.getAdditionalDocumentation();
        result = result * PRIME + ($additionalDocumentation == null ? 43 : $additionalDocumentation.hashCode());
        final java.lang.Object $cancellationReason = this.getCancellationReason();
        result = result * PRIME + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
        final java.lang.Object $explanation = this.getExplanation();
        result = result * PRIME + ($explanation == null ? 43 : $explanation.hashCode());
        final java.lang.Object $productDescription = this.getProductDescription();
        result = result * PRIME + ($productDescription == null ? 43 : $productDescription.hashCode());
        final java.lang.Object $productType = this.getProductType();
        result = result * PRIME + ($productType == null ? 43 : $productType.hashCode());
        final java.lang.Object $returnStatus = this.getReturnStatus();
        result = result * PRIME + ($returnStatus == null ? 43 : $returnStatus.hashCode());
        return result;
      }
    }


    public static class Duplicate extends StripeObject {
      /**
       * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Additional
       * documentation supporting the dispute.
       */
      @SerializedName("additional_documentation")
      ExpandableField<File> additionalDocumentation;
      /**
       * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Copy of the
       * card statement showing that the product had already been paid for.
       */
      @SerializedName("card_statement")
      ExpandableField<File> cardStatement;
      /**
       * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Copy of the
       * receipt showing that the product had been paid for in cash.
       */
      @SerializedName("cash_receipt")
      ExpandableField<File> cashReceipt;
      /**
       * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Image of the
       * front and back of the check that was used to pay for the product.
       */
      @SerializedName("check_image")
      ExpandableField<File> checkImage;
      /** Explanation of why the cardholder is disputing this transaction. */
      @SerializedName("explanation")
      String explanation;
      /**
       * Transaction (e.g., ipi_...) that the disputed transaction is a duplicate of. Of the two or
       * more transactions that are copies of each other, this is original undisputed one.
       */
      @SerializedName("original_transaction")
      String originalTransaction;

      /** Get ID of expandable {@code additionalDocumentation} object. */
      public String getAdditionalDocumentation() {
        return (this.additionalDocumentation != null) ? this.additionalDocumentation.getId() : null;
      }

      public void setAdditionalDocumentation(String id) {
        this.additionalDocumentation = ApiResource.setExpandableFieldId(id, this.additionalDocumentation);
      }

      /** Get expanded {@code additionalDocumentation}. */
      public File getAdditionalDocumentationObject() {
        return (this.additionalDocumentation != null) ? this.additionalDocumentation.getExpanded() : null;
      }

      public void setAdditionalDocumentationObject(File expandableObject) {
        this.additionalDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
      }

      /** Get ID of expandable {@code cardStatement} object. */
      public String getCardStatement() {
        return (this.cardStatement != null) ? this.cardStatement.getId() : null;
      }

      public void setCardStatement(String id) {
        this.cardStatement = ApiResource.setExpandableFieldId(id, this.cardStatement);
      }

      /** Get expanded {@code cardStatement}. */
      public File getCardStatementObject() {
        return (this.cardStatement != null) ? this.cardStatement.getExpanded() : null;
      }

      public void setCardStatementObject(File expandableObject) {
        this.cardStatement = new ExpandableField<File>(expandableObject.getId(), expandableObject);
      }

      /** Get ID of expandable {@code cashReceipt} object. */
      public String getCashReceipt() {
        return (this.cashReceipt != null) ? this.cashReceipt.getId() : null;
      }

      public void setCashReceipt(String id) {
        this.cashReceipt = ApiResource.setExpandableFieldId(id, this.cashReceipt);
      }

      /** Get expanded {@code cashReceipt}. */
      public File getCashReceiptObject() {
        return (this.cashReceipt != null) ? this.cashReceipt.getExpanded() : null;
      }

      public void setCashReceiptObject(File expandableObject) {
        this.cashReceipt = new ExpandableField<File>(expandableObject.getId(), expandableObject);
      }

      /** Get ID of expandable {@code checkImage} object. */
      public String getCheckImage() {
        return (this.checkImage != null) ? this.checkImage.getId() : null;
      }

      public void setCheckImage(String id) {
        this.checkImage = ApiResource.setExpandableFieldId(id, this.checkImage);
      }

      /** Get expanded {@code checkImage}. */
      public File getCheckImageObject() {
        return (this.checkImage != null) ? this.checkImage.getExpanded() : null;
      }

      public void setCheckImageObject(File expandableObject) {
        this.checkImage = new ExpandableField<File>(expandableObject.getId(), expandableObject);
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getExplanation() {
        return this.explanation;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getOriginalTransaction() {
        return this.originalTransaction;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExplanation(final String explanation) {
        this.explanation = explanation;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setOriginalTransaction(final String originalTransaction) {
        this.originalTransaction = originalTransaction;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Dispute.Evidence.Duplicate)) return false;
        final Dispute.Evidence.Duplicate other = (Dispute.Evidence.Duplicate) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$additionalDocumentation = this.getAdditionalDocumentation();
        final java.lang.Object other$additionalDocumentation = other.getAdditionalDocumentation();
        if (this$additionalDocumentation == null ? other$additionalDocumentation != null : !this$additionalDocumentation.equals(other$additionalDocumentation)) return false;
        final java.lang.Object this$cardStatement = this.getCardStatement();
        final java.lang.Object other$cardStatement = other.getCardStatement();
        if (this$cardStatement == null ? other$cardStatement != null : !this$cardStatement.equals(other$cardStatement)) return false;
        final java.lang.Object this$cashReceipt = this.getCashReceipt();
        final java.lang.Object other$cashReceipt = other.getCashReceipt();
        if (this$cashReceipt == null ? other$cashReceipt != null : !this$cashReceipt.equals(other$cashReceipt)) return false;
        final java.lang.Object this$checkImage = this.getCheckImage();
        final java.lang.Object other$checkImage = other.getCheckImage();
        if (this$checkImage == null ? other$checkImage != null : !this$checkImage.equals(other$checkImage)) return false;
        final java.lang.Object this$explanation = this.getExplanation();
        final java.lang.Object other$explanation = other.getExplanation();
        if (this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation)) return false;
        final java.lang.Object this$originalTransaction = this.getOriginalTransaction();
        final java.lang.Object other$originalTransaction = other.getOriginalTransaction();
        if (this$originalTransaction == null ? other$originalTransaction != null : !this$originalTransaction.equals(other$originalTransaction)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Dispute.Evidence.Duplicate;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $additionalDocumentation = this.getAdditionalDocumentation();
        result = result * PRIME + ($additionalDocumentation == null ? 43 : $additionalDocumentation.hashCode());
        final java.lang.Object $cardStatement = this.getCardStatement();
        result = result * PRIME + ($cardStatement == null ? 43 : $cardStatement.hashCode());
        final java.lang.Object $cashReceipt = this.getCashReceipt();
        result = result * PRIME + ($cashReceipt == null ? 43 : $cashReceipt.hashCode());
        final java.lang.Object $checkImage = this.getCheckImage();
        result = result * PRIME + ($checkImage == null ? 43 : $checkImage.hashCode());
        final java.lang.Object $explanation = this.getExplanation();
        result = result * PRIME + ($explanation == null ? 43 : $explanation.hashCode());
        final java.lang.Object $originalTransaction = this.getOriginalTransaction();
        result = result * PRIME + ($originalTransaction == null ? 43 : $originalTransaction.hashCode());
        return result;
      }
    }


    public static class Fraudulent extends StripeObject {
      /**
       * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Additional
       * documentation supporting the dispute.
       */
      @SerializedName("additional_documentation")
      ExpandableField<File> additionalDocumentation;
      /** Explanation of why the cardholder is disputing this transaction. */
      @SerializedName("explanation")
      String explanation;

      /** Get ID of expandable {@code additionalDocumentation} object. */
      public String getAdditionalDocumentation() {
        return (this.additionalDocumentation != null) ? this.additionalDocumentation.getId() : null;
      }

      public void setAdditionalDocumentation(String id) {
        this.additionalDocumentation = ApiResource.setExpandableFieldId(id, this.additionalDocumentation);
      }

      /** Get expanded {@code additionalDocumentation}. */
      public File getAdditionalDocumentationObject() {
        return (this.additionalDocumentation != null) ? this.additionalDocumentation.getExpanded() : null;
      }

      public void setAdditionalDocumentationObject(File expandableObject) {
        this.additionalDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getExplanation() {
        return this.explanation;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExplanation(final String explanation) {
        this.explanation = explanation;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Dispute.Evidence.Fraudulent)) return false;
        final Dispute.Evidence.Fraudulent other = (Dispute.Evidence.Fraudulent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$additionalDocumentation = this.getAdditionalDocumentation();
        final java.lang.Object other$additionalDocumentation = other.getAdditionalDocumentation();
        if (this$additionalDocumentation == null ? other$additionalDocumentation != null : !this$additionalDocumentation.equals(other$additionalDocumentation)) return false;
        final java.lang.Object this$explanation = this.getExplanation();
        final java.lang.Object other$explanation = other.getExplanation();
        if (this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Dispute.Evidence.Fraudulent;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $additionalDocumentation = this.getAdditionalDocumentation();
        result = result * PRIME + ($additionalDocumentation == null ? 43 : $additionalDocumentation.hashCode());
        final java.lang.Object $explanation = this.getExplanation();
        result = result * PRIME + ($explanation == null ? 43 : $explanation.hashCode());
        return result;
      }
    }


    public static class MerchandiseNotAsDescribed extends StripeObject {
      /**
       * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Additional
       * documentation supporting the dispute.
       */
      @SerializedName("additional_documentation")
      ExpandableField<File> additionalDocumentation;
      /** Explanation of why the cardholder is disputing this transaction. */
      @SerializedName("explanation")
      String explanation;
      /** Date when the product was received. */
      @SerializedName("received_at")
      Long receivedAt;
      /** Description of the cardholder's attempt to return the product. */
      @SerializedName("return_description")
      String returnDescription;
      /** Date when the product was returned or attempted to be returned. */
      @SerializedName("returned_at")
      Long returnedAt;
      /**
       * Result of cardholder's attempt to return the product.
       *
       * <p>One of {@code merchant_rejected}, or {@code successful}.
       */
      @SerializedName("return_status")
      String returnStatus;

      /** Get ID of expandable {@code additionalDocumentation} object. */
      public String getAdditionalDocumentation() {
        return (this.additionalDocumentation != null) ? this.additionalDocumentation.getId() : null;
      }

      public void setAdditionalDocumentation(String id) {
        this.additionalDocumentation = ApiResource.setExpandableFieldId(id, this.additionalDocumentation);
      }

      /** Get expanded {@code additionalDocumentation}. */
      public File getAdditionalDocumentationObject() {
        return (this.additionalDocumentation != null) ? this.additionalDocumentation.getExpanded() : null;
      }

      public void setAdditionalDocumentationObject(File expandableObject) {
        this.additionalDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getExplanation() {
        return this.explanation;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getReceivedAt() {
        return this.receivedAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getReturnDescription() {
        return this.returnDescription;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getReturnedAt() {
        return this.returnedAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getReturnStatus() {
        return this.returnStatus;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExplanation(final String explanation) {
        this.explanation = explanation;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReceivedAt(final Long receivedAt) {
        this.receivedAt = receivedAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReturnDescription(final String returnDescription) {
        this.returnDescription = returnDescription;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReturnedAt(final Long returnedAt) {
        this.returnedAt = returnedAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReturnStatus(final String returnStatus) {
        this.returnStatus = returnStatus;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Dispute.Evidence.MerchandiseNotAsDescribed)) return false;
        final Dispute.Evidence.MerchandiseNotAsDescribed other = (Dispute.Evidence.MerchandiseNotAsDescribed) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$receivedAt = this.getReceivedAt();
        final java.lang.Object other$receivedAt = other.getReceivedAt();
        if (this$receivedAt == null ? other$receivedAt != null : !this$receivedAt.equals(other$receivedAt)) return false;
        final java.lang.Object this$returnedAt = this.getReturnedAt();
        final java.lang.Object other$returnedAt = other.getReturnedAt();
        if (this$returnedAt == null ? other$returnedAt != null : !this$returnedAt.equals(other$returnedAt)) return false;
        final java.lang.Object this$additionalDocumentation = this.getAdditionalDocumentation();
        final java.lang.Object other$additionalDocumentation = other.getAdditionalDocumentation();
        if (this$additionalDocumentation == null ? other$additionalDocumentation != null : !this$additionalDocumentation.equals(other$additionalDocumentation)) return false;
        final java.lang.Object this$explanation = this.getExplanation();
        final java.lang.Object other$explanation = other.getExplanation();
        if (this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation)) return false;
        final java.lang.Object this$returnDescription = this.getReturnDescription();
        final java.lang.Object other$returnDescription = other.getReturnDescription();
        if (this$returnDescription == null ? other$returnDescription != null : !this$returnDescription.equals(other$returnDescription)) return false;
        final java.lang.Object this$returnStatus = this.getReturnStatus();
        final java.lang.Object other$returnStatus = other.getReturnStatus();
        if (this$returnStatus == null ? other$returnStatus != null : !this$returnStatus.equals(other$returnStatus)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Dispute.Evidence.MerchandiseNotAsDescribed;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $receivedAt = this.getReceivedAt();
        result = result * PRIME + ($receivedAt == null ? 43 : $receivedAt.hashCode());
        final java.lang.Object $returnedAt = this.getReturnedAt();
        result = result * PRIME + ($returnedAt == null ? 43 : $returnedAt.hashCode());
        final java.lang.Object $additionalDocumentation = this.getAdditionalDocumentation();
        result = result * PRIME + ($additionalDocumentation == null ? 43 : $additionalDocumentation.hashCode());
        final java.lang.Object $explanation = this.getExplanation();
        result = result * PRIME + ($explanation == null ? 43 : $explanation.hashCode());
        final java.lang.Object $returnDescription = this.getReturnDescription();
        result = result * PRIME + ($returnDescription == null ? 43 : $returnDescription.hashCode());
        final java.lang.Object $returnStatus = this.getReturnStatus();
        result = result * PRIME + ($returnStatus == null ? 43 : $returnStatus.hashCode());
        return result;
      }
    }


    public static class NotReceived extends StripeObject {
      /**
       * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Additional
       * documentation supporting the dispute.
       */
      @SerializedName("additional_documentation")
      ExpandableField<File> additionalDocumentation;
      /** Date when the cardholder expected to receive the product. */
      @SerializedName("expected_at")
      Long expectedAt;
      /** Explanation of why the cardholder is disputing this transaction. */
      @SerializedName("explanation")
      String explanation;
      /** Description of the merchandise or service that was purchased. */
      @SerializedName("product_description")
      String productDescription;
      /**
       * Whether the product was a merchandise or service.
       *
       * <p>One of {@code merchandise}, or {@code service}.
       */
      @SerializedName("product_type")
      String productType;

      /** Get ID of expandable {@code additionalDocumentation} object. */
      public String getAdditionalDocumentation() {
        return (this.additionalDocumentation != null) ? this.additionalDocumentation.getId() : null;
      }

      public void setAdditionalDocumentation(String id) {
        this.additionalDocumentation = ApiResource.setExpandableFieldId(id, this.additionalDocumentation);
      }

      /** Get expanded {@code additionalDocumentation}. */
      public File getAdditionalDocumentationObject() {
        return (this.additionalDocumentation != null) ? this.additionalDocumentation.getExpanded() : null;
      }

      public void setAdditionalDocumentationObject(File expandableObject) {
        this.additionalDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getExpectedAt() {
        return this.expectedAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getExplanation() {
        return this.explanation;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getProductDescription() {
        return this.productDescription;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getProductType() {
        return this.productType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExpectedAt(final Long expectedAt) {
        this.expectedAt = expectedAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExplanation(final String explanation) {
        this.explanation = explanation;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setProductDescription(final String productDescription) {
        this.productDescription = productDescription;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setProductType(final String productType) {
        this.productType = productType;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Dispute.Evidence.NotReceived)) return false;
        final Dispute.Evidence.NotReceived other = (Dispute.Evidence.NotReceived) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$expectedAt = this.getExpectedAt();
        final java.lang.Object other$expectedAt = other.getExpectedAt();
        if (this$expectedAt == null ? other$expectedAt != null : !this$expectedAt.equals(other$expectedAt)) return false;
        final java.lang.Object this$additionalDocumentation = this.getAdditionalDocumentation();
        final java.lang.Object other$additionalDocumentation = other.getAdditionalDocumentation();
        if (this$additionalDocumentation == null ? other$additionalDocumentation != null : !this$additionalDocumentation.equals(other$additionalDocumentation)) return false;
        final java.lang.Object this$explanation = this.getExplanation();
        final java.lang.Object other$explanation = other.getExplanation();
        if (this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation)) return false;
        final java.lang.Object this$productDescription = this.getProductDescription();
        final java.lang.Object other$productDescription = other.getProductDescription();
        if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) return false;
        final java.lang.Object this$productType = this.getProductType();
        final java.lang.Object other$productType = other.getProductType();
        if (this$productType == null ? other$productType != null : !this$productType.equals(other$productType)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Dispute.Evidence.NotReceived;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $expectedAt = this.getExpectedAt();
        result = result * PRIME + ($expectedAt == null ? 43 : $expectedAt.hashCode());
        final java.lang.Object $additionalDocumentation = this.getAdditionalDocumentation();
        result = result * PRIME + ($additionalDocumentation == null ? 43 : $additionalDocumentation.hashCode());
        final java.lang.Object $explanation = this.getExplanation();
        result = result * PRIME + ($explanation == null ? 43 : $explanation.hashCode());
        final java.lang.Object $productDescription = this.getProductDescription();
        result = result * PRIME + ($productDescription == null ? 43 : $productDescription.hashCode());
        final java.lang.Object $productType = this.getProductType();
        result = result * PRIME + ($productType == null ? 43 : $productType.hashCode());
        return result;
      }
    }


    public static class Other extends StripeObject {
      /**
       * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Additional
       * documentation supporting the dispute.
       */
      @SerializedName("additional_documentation")
      ExpandableField<File> additionalDocumentation;
      /** Explanation of why the cardholder is disputing this transaction. */
      @SerializedName("explanation")
      String explanation;
      /** Description of the merchandise or service that was purchased. */
      @SerializedName("product_description")
      String productDescription;
      /**
       * Whether the product was a merchandise or service.
       *
       * <p>One of {@code merchandise}, or {@code service}.
       */
      @SerializedName("product_type")
      String productType;

      /** Get ID of expandable {@code additionalDocumentation} object. */
      public String getAdditionalDocumentation() {
        return (this.additionalDocumentation != null) ? this.additionalDocumentation.getId() : null;
      }

      public void setAdditionalDocumentation(String id) {
        this.additionalDocumentation = ApiResource.setExpandableFieldId(id, this.additionalDocumentation);
      }

      /** Get expanded {@code additionalDocumentation}. */
      public File getAdditionalDocumentationObject() {
        return (this.additionalDocumentation != null) ? this.additionalDocumentation.getExpanded() : null;
      }

      public void setAdditionalDocumentationObject(File expandableObject) {
        this.additionalDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getExplanation() {
        return this.explanation;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getProductDescription() {
        return this.productDescription;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getProductType() {
        return this.productType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExplanation(final String explanation) {
        this.explanation = explanation;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setProductDescription(final String productDescription) {
        this.productDescription = productDescription;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setProductType(final String productType) {
        this.productType = productType;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Dispute.Evidence.Other)) return false;
        final Dispute.Evidence.Other other = (Dispute.Evidence.Other) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$additionalDocumentation = this.getAdditionalDocumentation();
        final java.lang.Object other$additionalDocumentation = other.getAdditionalDocumentation();
        if (this$additionalDocumentation == null ? other$additionalDocumentation != null : !this$additionalDocumentation.equals(other$additionalDocumentation)) return false;
        final java.lang.Object this$explanation = this.getExplanation();
        final java.lang.Object other$explanation = other.getExplanation();
        if (this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation)) return false;
        final java.lang.Object this$productDescription = this.getProductDescription();
        final java.lang.Object other$productDescription = other.getProductDescription();
        if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) return false;
        final java.lang.Object this$productType = this.getProductType();
        final java.lang.Object other$productType = other.getProductType();
        if (this$productType == null ? other$productType != null : !this$productType.equals(other$productType)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Dispute.Evidence.Other;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $additionalDocumentation = this.getAdditionalDocumentation();
        result = result * PRIME + ($additionalDocumentation == null ? 43 : $additionalDocumentation.hashCode());
        final java.lang.Object $explanation = this.getExplanation();
        result = result * PRIME + ($explanation == null ? 43 : $explanation.hashCode());
        final java.lang.Object $productDescription = this.getProductDescription();
        result = result * PRIME + ($productDescription == null ? 43 : $productDescription.hashCode());
        final java.lang.Object $productType = this.getProductType();
        result = result * PRIME + ($productType == null ? 43 : $productType.hashCode());
        return result;
      }
    }


    public static class ServiceNotAsDescribed extends StripeObject {
      /**
       * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) Additional
       * documentation supporting the dispute.
       */
      @SerializedName("additional_documentation")
      ExpandableField<File> additionalDocumentation;
      /** Date when order was canceled. */
      @SerializedName("canceled_at")
      Long canceledAt;
      /** Reason for canceling the order. */
      @SerializedName("cancellation_reason")
      String cancellationReason;
      /** Explanation of why the cardholder is disputing this transaction. */
      @SerializedName("explanation")
      String explanation;
      /** Date when the product was received. */
      @SerializedName("received_at")
      Long receivedAt;

      /** Get ID of expandable {@code additionalDocumentation} object. */
      public String getAdditionalDocumentation() {
        return (this.additionalDocumentation != null) ? this.additionalDocumentation.getId() : null;
      }

      public void setAdditionalDocumentation(String id) {
        this.additionalDocumentation = ApiResource.setExpandableFieldId(id, this.additionalDocumentation);
      }

      /** Get expanded {@code additionalDocumentation}. */
      public File getAdditionalDocumentationObject() {
        return (this.additionalDocumentation != null) ? this.additionalDocumentation.getExpanded() : null;
      }

      public void setAdditionalDocumentationObject(File expandableObject) {
        this.additionalDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getCanceledAt() {
        return this.canceledAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCancellationReason() {
        return this.cancellationReason;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getExplanation() {
        return this.explanation;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getReceivedAt() {
        return this.receivedAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCanceledAt(final Long canceledAt) {
        this.canceledAt = canceledAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCancellationReason(final String cancellationReason) {
        this.cancellationReason = cancellationReason;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExplanation(final String explanation) {
        this.explanation = explanation;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReceivedAt(final Long receivedAt) {
        this.receivedAt = receivedAt;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Dispute.Evidence.ServiceNotAsDescribed)) return false;
        final Dispute.Evidence.ServiceNotAsDescribed other = (Dispute.Evidence.ServiceNotAsDescribed) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$canceledAt = this.getCanceledAt();
        final java.lang.Object other$canceledAt = other.getCanceledAt();
        if (this$canceledAt == null ? other$canceledAt != null : !this$canceledAt.equals(other$canceledAt)) return false;
        final java.lang.Object this$receivedAt = this.getReceivedAt();
        final java.lang.Object other$receivedAt = other.getReceivedAt();
        if (this$receivedAt == null ? other$receivedAt != null : !this$receivedAt.equals(other$receivedAt)) return false;
        final java.lang.Object this$additionalDocumentation = this.getAdditionalDocumentation();
        final java.lang.Object other$additionalDocumentation = other.getAdditionalDocumentation();
        if (this$additionalDocumentation == null ? other$additionalDocumentation != null : !this$additionalDocumentation.equals(other$additionalDocumentation)) return false;
        final java.lang.Object this$cancellationReason = this.getCancellationReason();
        final java.lang.Object other$cancellationReason = other.getCancellationReason();
        if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) return false;
        final java.lang.Object this$explanation = this.getExplanation();
        final java.lang.Object other$explanation = other.getExplanation();
        if (this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Dispute.Evidence.ServiceNotAsDescribed;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $canceledAt = this.getCanceledAt();
        result = result * PRIME + ($canceledAt == null ? 43 : $canceledAt.hashCode());
        final java.lang.Object $receivedAt = this.getReceivedAt();
        result = result * PRIME + ($receivedAt == null ? 43 : $receivedAt.hashCode());
        final java.lang.Object $additionalDocumentation = this.getAdditionalDocumentation();
        result = result * PRIME + ($additionalDocumentation == null ? 43 : $additionalDocumentation.hashCode());
        final java.lang.Object $cancellationReason = this.getCancellationReason();
        result = result * PRIME + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
        final java.lang.Object $explanation = this.getExplanation();
        result = result * PRIME + ($explanation == null ? 43 : $explanation.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Canceled getCanceled() {
      return this.canceled;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Duplicate getDuplicate() {
      return this.duplicate;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Fraudulent getFraudulent() {
      return this.fraudulent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MerchandiseNotAsDescribed getMerchandiseNotAsDescribed() {
      return this.merchandiseNotAsDescribed;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NotReceived getNotReceived() {
      return this.notReceived;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Other getOther() {
      return this.other;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReason() {
      return this.reason;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServiceNotAsDescribed getServiceNotAsDescribed() {
      return this.serviceNotAsDescribed;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCanceled(final Canceled canceled) {
      this.canceled = canceled;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDuplicate(final Duplicate duplicate) {
      this.duplicate = duplicate;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFraudulent(final Fraudulent fraudulent) {
      this.fraudulent = fraudulent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMerchandiseNotAsDescribed(final MerchandiseNotAsDescribed merchandiseNotAsDescribed) {
      this.merchandiseNotAsDescribed = merchandiseNotAsDescribed;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNotReceived(final NotReceived notReceived) {
      this.notReceived = notReceived;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOther(final Other other) {
      this.other = other;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReason(final String reason) {
      this.reason = reason;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setServiceNotAsDescribed(final ServiceNotAsDescribed serviceNotAsDescribed) {
      this.serviceNotAsDescribed = serviceNotAsDescribed;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Dispute.Evidence)) return false;
      final Dispute.Evidence other = (Dispute.Evidence) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$canceled = this.getCanceled();
      final java.lang.Object other$canceled = other.getCanceled();
      if (this$canceled == null ? other$canceled != null : !this$canceled.equals(other$canceled)) return false;
      final java.lang.Object this$duplicate = this.getDuplicate();
      final java.lang.Object other$duplicate = other.getDuplicate();
      if (this$duplicate == null ? other$duplicate != null : !this$duplicate.equals(other$duplicate)) return false;
      final java.lang.Object this$fraudulent = this.getFraudulent();
      final java.lang.Object other$fraudulent = other.getFraudulent();
      if (this$fraudulent == null ? other$fraudulent != null : !this$fraudulent.equals(other$fraudulent)) return false;
      final java.lang.Object this$merchandiseNotAsDescribed = this.getMerchandiseNotAsDescribed();
      final java.lang.Object other$merchandiseNotAsDescribed = other.getMerchandiseNotAsDescribed();
      if (this$merchandiseNotAsDescribed == null ? other$merchandiseNotAsDescribed != null : !this$merchandiseNotAsDescribed.equals(other$merchandiseNotAsDescribed)) return false;
      final java.lang.Object this$notReceived = this.getNotReceived();
      final java.lang.Object other$notReceived = other.getNotReceived();
      if (this$notReceived == null ? other$notReceived != null : !this$notReceived.equals(other$notReceived)) return false;
      final java.lang.Object this$other = this.getOther();
      final java.lang.Object other$other = other.getOther();
      if (this$other == null ? other$other != null : !this$other.equals(other$other)) return false;
      final java.lang.Object this$reason = this.getReason();
      final java.lang.Object other$reason = other.getReason();
      if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
      final java.lang.Object this$serviceNotAsDescribed = this.getServiceNotAsDescribed();
      final java.lang.Object other$serviceNotAsDescribed = other.getServiceNotAsDescribed();
      if (this$serviceNotAsDescribed == null ? other$serviceNotAsDescribed != null : !this$serviceNotAsDescribed.equals(other$serviceNotAsDescribed)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Dispute.Evidence;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $canceled = this.getCanceled();
      result = result * PRIME + ($canceled == null ? 43 : $canceled.hashCode());
      final java.lang.Object $duplicate = this.getDuplicate();
      result = result * PRIME + ($duplicate == null ? 43 : $duplicate.hashCode());
      final java.lang.Object $fraudulent = this.getFraudulent();
      result = result * PRIME + ($fraudulent == null ? 43 : $fraudulent.hashCode());
      final java.lang.Object $merchandiseNotAsDescribed = this.getMerchandiseNotAsDescribed();
      result = result * PRIME + ($merchandiseNotAsDescribed == null ? 43 : $merchandiseNotAsDescribed.hashCode());
      final java.lang.Object $notReceived = this.getNotReceived();
      result = result * PRIME + ($notReceived == null ? 43 : $notReceived.hashCode());
      final java.lang.Object $other = this.getOther();
      result = result * PRIME + ($other == null ? 43 : $other.hashCode());
      final java.lang.Object $reason = this.getReason();
      result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
      final java.lang.Object $serviceNotAsDescribed = this.getServiceNotAsDescribed();
      result = result * PRIME + ($serviceNotAsDescribed == null ? 43 : $serviceNotAsDescribed.hashCode());
      return result;
    }
  }

  /**
   * Disputed amount. Usually the amount of the {@code transaction}, but can differ (usually because
   * of currency fluctuation).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * List of balance transactions associated with the dispute.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<BalanceTransaction> getBalanceTransactions() {
    return this.balanceTransactions;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * The currency the {@code transaction} was made in.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Evidence getEvidence() {
    return this.evidence;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code issuing.dispute}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Current status of the dispute.
   *
   * <p>One of {@code expired}, {@code lost}, {@code submitted}, {@code unsubmitted}, or {@code
   * won}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * Disputed amount. Usually the amount of the {@code transaction}, but can differ (usually because
   * of currency fluctuation).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * List of balance transactions associated with the dispute.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBalanceTransactions(final List<BalanceTransaction> balanceTransactions) {
    this.balanceTransactions = balanceTransactions;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * The currency the {@code transaction} was made in.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEvidence(final Evidence evidence) {
    this.evidence = evidence;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code issuing.dispute}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Current status of the dispute.
   *
   * <p>One of {@code expired}, {@code lost}, {@code submitted}, {@code unsubmitted}, or {@code
   * won}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Dispute)) return false;
    final Dispute other = (Dispute) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$balanceTransactions = this.getBalanceTransactions();
    final java.lang.Object other$balanceTransactions = other.getBalanceTransactions();
    if (this$balanceTransactions == null ? other$balanceTransactions != null : !this$balanceTransactions.equals(other$balanceTransactions)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$evidence = this.getEvidence();
    final java.lang.Object other$evidence = other.getEvidence();
    if (this$evidence == null ? other$evidence != null : !this$evidence.equals(other$evidence)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$transaction = this.getTransaction();
    final java.lang.Object other$transaction = other.getTransaction();
    if (this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Dispute;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $balanceTransactions = this.getBalanceTransactions();
    result = result * PRIME + ($balanceTransactions == null ? 43 : $balanceTransactions.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $evidence = this.getEvidence();
    result = result * PRIME + ($evidence == null ? 43 : $evidence.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $transaction = this.getTransaction();
    result = result * PRIME + ($transaction == null ? 43 : $transaction.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
