/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.CardCollection;
import com.stripe.model.issuing.Cardholder;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.issuing.CardCreateParams;
import com.stripe.param.issuing.CardListParams;
import com.stripe.param.issuing.CardRetrieveParams;
import com.stripe.param.issuing.CardUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Card
extends ApiResource
implements HasId,
MetadataStore<Card> {
    @SerializedName(value="brand")
    String brand;
    @SerializedName(value="cancellation_reason")
    String cancellationReason;
    @SerializedName(value="cardholder")
    Cardholder cardholder;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="cvc")
    String cvc;
    @SerializedName(value="exp_month")
    Long expMonth;
    @SerializedName(value="exp_year")
    Long expYear;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="last4")
    String last4;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="number")
    String number;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="replaced_by")
    ExpandableField<Card> replacedBy;
    @SerializedName(value="replacement_for")
    ExpandableField<Card> replacementFor;
    @SerializedName(value="replacement_reason")
    String replacementReason;
    @SerializedName(value="shipping")
    Shipping shipping;
    @SerializedName(value="spending_controls")
    SpendingControls spendingControls;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="wallets")
    Wallets wallets;

    public String getReplacedBy() {
        return this.replacedBy != null ? this.replacedBy.getId() : null;
    }

    public void setReplacedBy(String id) {
        this.replacedBy = ApiResource.setExpandableFieldId(id, this.replacedBy);
    }

    public Card getReplacedByObject() {
        return this.replacedBy != null ? this.replacedBy.getExpanded() : null;
    }

    public void setReplacedByObject(Card expandableObject) {
        this.replacedBy = new ExpandableField<Card>(expandableObject.getId(), expandableObject);
    }

    public String getReplacementFor() {
        return this.replacementFor != null ? this.replacementFor.getId() : null;
    }

    public void setReplacementFor(String id) {
        this.replacementFor = ApiResource.setExpandableFieldId(id, this.replacementFor);
    }

    public Card getReplacementForObject() {
        return this.replacementFor != null ? this.replacementFor.getExpanded() : null;
    }

    public void setReplacementForObject(Card expandableObject) {
        this.replacementFor = new ExpandableField<Card>(expandableObject.getId(), expandableObject);
    }

    public static CardCollection list(Map<String, Object> params) throws StripeException {
        return Card.list(params, (RequestOptions)null);
    }

    public static CardCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cards");
        return ApiResource.requestCollection(url, params, CardCollection.class, options);
    }

    public static CardCollection list(CardListParams params) throws StripeException {
        return Card.list(params, (RequestOptions)null);
    }

    public static CardCollection list(CardListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cards");
        return ApiResource.requestCollection(url, params, CardCollection.class, options);
    }

    public static Card create(Map<String, Object> params) throws StripeException {
        return Card.create(params, (RequestOptions)null);
    }

    public static Card create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cards");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
    }

    public static Card create(CardCreateParams params) throws StripeException {
        return Card.create(params, (RequestOptions)null);
    }

    public static Card create(CardCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/cards");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
    }

    public static Card retrieve(String card) throws StripeException {
        return Card.retrieve(card, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Card retrieve(String card, RequestOptions options) throws StripeException {
        return Card.retrieve(card, (Map<String, Object>)null, options);
    }

    public static Card retrieve(String card, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cards/%s", ApiResource.urlEncodeId(card)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Card.class, options);
    }

    public static Card retrieve(String card, CardRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cards/%s", ApiResource.urlEncodeId(card)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Card.class, options);
    }

    public Card update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Card update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cards/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
    }

    public Card update(CardUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Card update(CardUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/cards/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
    }

    @Generated
    public String getBrand() {
        return this.brand;
    }

    @Generated
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    @Generated
    public Cardholder getCardholder() {
        return this.cardholder;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getCvc() {
        return this.cvc;
    }

    @Generated
    public Long getExpMonth() {
        return this.expMonth;
    }

    @Generated
    public Long getExpYear() {
        return this.expYear;
    }

    @Generated
    public String getLast4() {
        return this.last4;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getNumber() {
        return this.number;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getReplacementReason() {
        return this.replacementReason;
    }

    @Generated
    public Shipping getShipping() {
        return this.shipping;
    }

    @Generated
    public SpendingControls getSpendingControls() {
        return this.spendingControls;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Wallets getWallets() {
        return this.wallets;
    }

    @Generated
    public void setBrand(String brand) {
        this.brand = brand;
    }

    @Generated
    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    @Generated
    public void setCardholder(Cardholder cardholder) {
        this.cardholder = cardholder;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCvc(String cvc) {
        this.cvc = cvc;
    }

    @Generated
    public void setExpMonth(Long expMonth) {
        this.expMonth = expMonth;
    }

    @Generated
    public void setExpYear(Long expYear) {
        this.expYear = expYear;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLast4(String last4) {
        this.last4 = last4;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNumber(String number) {
        this.number = number;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setReplacementReason(String replacementReason) {
        this.replacementReason = replacementReason;
    }

    @Generated
    public void setShipping(Shipping shipping) {
        this.shipping = shipping;
    }

    @Generated
    public void setSpendingControls(SpendingControls spendingControls) {
        this.spendingControls = spendingControls;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setWallets(Wallets wallets) {
        this.wallets = wallets;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Card)) {
            return false;
        }
        Card other = (Card)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$expMonth = this.getExpMonth();
        Long other$expMonth = other.getExpMonth();
        if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
            return false;
        }
        Long this$expYear = this.getExpYear();
        Long other$expYear = other.getExpYear();
        if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$brand = this.getBrand();
        String other$brand = other.getBrand();
        if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
            return false;
        }
        String this$cancellationReason = this.getCancellationReason();
        String other$cancellationReason = other.getCancellationReason();
        if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) {
            return false;
        }
        Cardholder this$cardholder = this.getCardholder();
        Cardholder other$cardholder = other.getCardholder();
        if (this$cardholder == null ? other$cardholder != null : !((Object)this$cardholder).equals(other$cardholder)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$cvc = this.getCvc();
        String other$cvc = other.getCvc();
        if (this$cvc == null ? other$cvc != null : !this$cvc.equals(other$cvc)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$last4 = this.getLast4();
        String other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$replacedBy = this.getReplacedBy();
        String other$replacedBy = other.getReplacedBy();
        if (this$replacedBy == null ? other$replacedBy != null : !this$replacedBy.equals(other$replacedBy)) {
            return false;
        }
        String this$replacementFor = this.getReplacementFor();
        String other$replacementFor = other.getReplacementFor();
        if (this$replacementFor == null ? other$replacementFor != null : !this$replacementFor.equals(other$replacementFor)) {
            return false;
        }
        String this$replacementReason = this.getReplacementReason();
        String other$replacementReason = other.getReplacementReason();
        if (this$replacementReason == null ? other$replacementReason != null : !this$replacementReason.equals(other$replacementReason)) {
            return false;
        }
        Shipping this$shipping = this.getShipping();
        Shipping other$shipping = other.getShipping();
        if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
            return false;
        }
        SpendingControls this$spendingControls = this.getSpendingControls();
        SpendingControls other$spendingControls = other.getSpendingControls();
        if (this$spendingControls == null ? other$spendingControls != null : !((Object)this$spendingControls).equals(other$spendingControls)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Wallets this$wallets = this.getWallets();
        Wallets other$wallets = other.getWallets();
        return !(this$wallets == null ? other$wallets != null : !((Object)this$wallets).equals(other$wallets));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Card;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $expMonth = this.getExpMonth();
        result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
        Long $expYear = this.getExpYear();
        result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $brand = this.getBrand();
        result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
        String $cancellationReason = this.getCancellationReason();
        result = result * 59 + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
        Cardholder $cardholder = this.getCardholder();
        result = result * 59 + ($cardholder == null ? 43 : ((Object)$cardholder).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $cvc = this.getCvc();
        result = result * 59 + ($cvc == null ? 43 : $cvc.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $last4 = this.getLast4();
        result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $replacedBy = this.getReplacedBy();
        result = result * 59 + ($replacedBy == null ? 43 : $replacedBy.hashCode());
        String $replacementFor = this.getReplacementFor();
        result = result * 59 + ($replacementFor == null ? 43 : $replacementFor.hashCode());
        String $replacementReason = this.getReplacementReason();
        result = result * 59 + ($replacementReason == null ? 43 : $replacementReason.hashCode());
        Shipping $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        SpendingControls $spendingControls = this.getSpendingControls();
        result = result * 59 + ($spendingControls == null ? 43 : ((Object)$spendingControls).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Wallets $wallets = this.getWallets();
        result = result * 59 + ($wallets == null ? 43 : ((Object)$wallets).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Wallets
    extends StripeObject {
        @SerializedName(value="apple_pay")
        ApplePay applePay;
        @SerializedName(value="google_pay")
        GooglePay googlePay;
        @SerializedName(value="primary_account_identifier")
        String primaryAccountIdentifier;

        @Generated
        public ApplePay getApplePay() {
            return this.applePay;
        }

        @Generated
        public GooglePay getGooglePay() {
            return this.googlePay;
        }

        @Generated
        public String getPrimaryAccountIdentifier() {
            return this.primaryAccountIdentifier;
        }

        @Generated
        public void setApplePay(ApplePay applePay) {
            this.applePay = applePay;
        }

        @Generated
        public void setGooglePay(GooglePay googlePay) {
            this.googlePay = googlePay;
        }

        @Generated
        public void setPrimaryAccountIdentifier(String primaryAccountIdentifier) {
            this.primaryAccountIdentifier = primaryAccountIdentifier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Wallets)) {
                return false;
            }
            Wallets other = (Wallets)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ApplePay this$applePay = this.getApplePay();
            ApplePay other$applePay = other.getApplePay();
            if (this$applePay == null ? other$applePay != null : !((Object)this$applePay).equals(other$applePay)) {
                return false;
            }
            GooglePay this$googlePay = this.getGooglePay();
            GooglePay other$googlePay = other.getGooglePay();
            if (this$googlePay == null ? other$googlePay != null : !((Object)this$googlePay).equals(other$googlePay)) {
                return false;
            }
            String this$primaryAccountIdentifier = this.getPrimaryAccountIdentifier();
            String other$primaryAccountIdentifier = other.getPrimaryAccountIdentifier();
            return !(this$primaryAccountIdentifier == null ? other$primaryAccountIdentifier != null : !this$primaryAccountIdentifier.equals(other$primaryAccountIdentifier));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Wallets;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ApplePay $applePay = this.getApplePay();
            result = result * 59 + ($applePay == null ? 43 : ((Object)$applePay).hashCode());
            GooglePay $googlePay = this.getGooglePay();
            result = result * 59 + ($googlePay == null ? 43 : ((Object)$googlePay).hashCode());
            String $primaryAccountIdentifier = this.getPrimaryAccountIdentifier();
            result = result * 59 + ($primaryAccountIdentifier == null ? 43 : $primaryAccountIdentifier.hashCode());
            return result;
        }

        public static class GooglePay
        extends StripeObject {
            @SerializedName(value="eligible")
            Boolean eligible;
            @SerializedName(value="ineligible_reason")
            String ineligibleReason;

            @Generated
            public Boolean getEligible() {
                return this.eligible;
            }

            @Generated
            public String getIneligibleReason() {
                return this.ineligibleReason;
            }

            @Generated
            public void setEligible(Boolean eligible) {
                this.eligible = eligible;
            }

            @Generated
            public void setIneligibleReason(String ineligibleReason) {
                this.ineligibleReason = ineligibleReason;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GooglePay)) {
                    return false;
                }
                GooglePay other = (GooglePay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$eligible = this.getEligible();
                Boolean other$eligible = other.getEligible();
                if (this$eligible == null ? other$eligible != null : !((Object)this$eligible).equals(other$eligible)) {
                    return false;
                }
                String this$ineligibleReason = this.getIneligibleReason();
                String other$ineligibleReason = other.getIneligibleReason();
                return !(this$ineligibleReason == null ? other$ineligibleReason != null : !this$ineligibleReason.equals(other$ineligibleReason));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof GooglePay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $eligible = this.getEligible();
                result = result * 59 + ($eligible == null ? 43 : ((Object)$eligible).hashCode());
                String $ineligibleReason = this.getIneligibleReason();
                result = result * 59 + ($ineligibleReason == null ? 43 : $ineligibleReason.hashCode());
                return result;
            }
        }

        public static class ApplePay
        extends StripeObject {
            @SerializedName(value="eligible")
            Boolean eligible;
            @SerializedName(value="ineligible_reason")
            String ineligibleReason;

            @Generated
            public Boolean getEligible() {
                return this.eligible;
            }

            @Generated
            public String getIneligibleReason() {
                return this.ineligibleReason;
            }

            @Generated
            public void setEligible(Boolean eligible) {
                this.eligible = eligible;
            }

            @Generated
            public void setIneligibleReason(String ineligibleReason) {
                this.ineligibleReason = ineligibleReason;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ApplePay)) {
                    return false;
                }
                ApplePay other = (ApplePay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$eligible = this.getEligible();
                Boolean other$eligible = other.getEligible();
                if (this$eligible == null ? other$eligible != null : !((Object)this$eligible).equals(other$eligible)) {
                    return false;
                }
                String this$ineligibleReason = this.getIneligibleReason();
                String other$ineligibleReason = other.getIneligibleReason();
                return !(this$ineligibleReason == null ? other$ineligibleReason != null : !this$ineligibleReason.equals(other$ineligibleReason));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ApplePay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $eligible = this.getEligible();
                result = result * 59 + ($eligible == null ? 43 : ((Object)$eligible).hashCode());
                String $ineligibleReason = this.getIneligibleReason();
                result = result * 59 + ($ineligibleReason == null ? 43 : $ineligibleReason.hashCode());
                return result;
            }
        }
    }

    public static class SpendingControls
    extends StripeObject {
        @SerializedName(value="allowed_categories")
        List<String> allowedCategories;
        @SerializedName(value="blocked_categories")
        List<String> blockedCategories;
        @SerializedName(value="spending_limits")
        List<SpendingLimit> spendingLimits;
        @SerializedName(value="spending_limits_currency")
        String spendingLimitsCurrency;

        @Generated
        public List<String> getAllowedCategories() {
            return this.allowedCategories;
        }

        @Generated
        public List<String> getBlockedCategories() {
            return this.blockedCategories;
        }

        @Generated
        public List<SpendingLimit> getSpendingLimits() {
            return this.spendingLimits;
        }

        @Generated
        public String getSpendingLimitsCurrency() {
            return this.spendingLimitsCurrency;
        }

        @Generated
        public void setAllowedCategories(List<String> allowedCategories) {
            this.allowedCategories = allowedCategories;
        }

        @Generated
        public void setBlockedCategories(List<String> blockedCategories) {
            this.blockedCategories = blockedCategories;
        }

        @Generated
        public void setSpendingLimits(List<SpendingLimit> spendingLimits) {
            this.spendingLimits = spendingLimits;
        }

        @Generated
        public void setSpendingLimitsCurrency(String spendingLimitsCurrency) {
            this.spendingLimitsCurrency = spendingLimitsCurrency;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpendingControls)) {
                return false;
            }
            SpendingControls other = (SpendingControls)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$allowedCategories = this.getAllowedCategories();
            List<String> other$allowedCategories = other.getAllowedCategories();
            if (this$allowedCategories == null ? other$allowedCategories != null : !((Object)this$allowedCategories).equals(other$allowedCategories)) {
                return false;
            }
            List<String> this$blockedCategories = this.getBlockedCategories();
            List<String> other$blockedCategories = other.getBlockedCategories();
            if (this$blockedCategories == null ? other$blockedCategories != null : !((Object)this$blockedCategories).equals(other$blockedCategories)) {
                return false;
            }
            List<SpendingLimit> this$spendingLimits = this.getSpendingLimits();
            List<SpendingLimit> other$spendingLimits = other.getSpendingLimits();
            if (this$spendingLimits == null ? other$spendingLimits != null : !((Object)this$spendingLimits).equals(other$spendingLimits)) {
                return false;
            }
            String this$spendingLimitsCurrency = this.getSpendingLimitsCurrency();
            String other$spendingLimitsCurrency = other.getSpendingLimitsCurrency();
            return !(this$spendingLimitsCurrency == null ? other$spendingLimitsCurrency != null : !this$spendingLimitsCurrency.equals(other$spendingLimitsCurrency));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SpendingControls;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $allowedCategories = this.getAllowedCategories();
            result = result * 59 + ($allowedCategories == null ? 43 : ((Object)$allowedCategories).hashCode());
            List<String> $blockedCategories = this.getBlockedCategories();
            result = result * 59 + ($blockedCategories == null ? 43 : ((Object)$blockedCategories).hashCode());
            List<SpendingLimit> $spendingLimits = this.getSpendingLimits();
            result = result * 59 + ($spendingLimits == null ? 43 : ((Object)$spendingLimits).hashCode());
            String $spendingLimitsCurrency = this.getSpendingLimitsCurrency();
            result = result * 59 + ($spendingLimitsCurrency == null ? 43 : $spendingLimitsCurrency.hashCode());
            return result;
        }

        public static class SpendingLimit
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="categories")
            List<String> categories;
            @SerializedName(value="interval")
            String interval;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public List<String> getCategories() {
                return this.categories;
            }

            @Generated
            public String getInterval() {
                return this.interval;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setCategories(List<String> categories) {
                this.categories = categories;
            }

            @Generated
            public void setInterval(String interval) {
                this.interval = interval;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SpendingLimit)) {
                    return false;
                }
                SpendingLimit other = (SpendingLimit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                List<String> this$categories = this.getCategories();
                List<String> other$categories = other.getCategories();
                if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
                    return false;
                }
                String this$interval = this.getInterval();
                String other$interval = other.getInterval();
                return !(this$interval == null ? other$interval != null : !this$interval.equals(other$interval));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SpendingLimit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                List<String> $categories = this.getCategories();
                result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
                String $interval = this.getInterval();
                result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                return result;
            }
        }
    }

    public static class Shipping
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="carrier")
        String carrier;
        @SerializedName(value="eta")
        Long eta;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="service")
        String service;
        @SerializedName(value="status")
        String status;
        @SerializedName(value="tracking_number")
        String trackingNumber;
        @SerializedName(value="tracking_url")
        String trackingUrl;
        @SerializedName(value="type")
        String type;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public String getCarrier() {
            return this.carrier;
        }

        @Generated
        public Long getEta() {
            return this.eta;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getService() {
            return this.service;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public String getTrackingNumber() {
            return this.trackingNumber;
        }

        @Generated
        public String getTrackingUrl() {
            return this.trackingUrl;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setCarrier(String carrier) {
            this.carrier = carrier;
        }

        @Generated
        public void setEta(Long eta) {
            this.eta = eta;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setService(String service) {
            this.service = service;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setTrackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
        }

        @Generated
        public void setTrackingUrl(String trackingUrl) {
            this.trackingUrl = trackingUrl;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Shipping)) {
                return false;
            }
            Shipping other = (Shipping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$eta = this.getEta();
            Long other$eta = other.getEta();
            if (this$eta == null ? other$eta != null : !((Object)this$eta).equals(other$eta)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            String this$carrier = this.getCarrier();
            String other$carrier = other.getCarrier();
            if (this$carrier == null ? other$carrier != null : !this$carrier.equals(other$carrier)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$service = this.getService();
            String other$service = other.getService();
            if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$trackingNumber = this.getTrackingNumber();
            String other$trackingNumber = other.getTrackingNumber();
            if (this$trackingNumber == null ? other$trackingNumber != null : !this$trackingNumber.equals(other$trackingNumber)) {
                return false;
            }
            String this$trackingUrl = this.getTrackingUrl();
            String other$trackingUrl = other.getTrackingUrl();
            if (this$trackingUrl == null ? other$trackingUrl != null : !this$trackingUrl.equals(other$trackingUrl)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Shipping;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $eta = this.getEta();
            result = result * 59 + ($eta == null ? 43 : ((Object)$eta).hashCode());
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            String $carrier = this.getCarrier();
            result = result * 59 + ($carrier == null ? 43 : $carrier.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $service = this.getService();
            result = result * 59 + ($service == null ? 43 : $service.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $trackingNumber = this.getTrackingNumber();
            result = result * 59 + ($trackingNumber == null ? 43 : $trackingNumber.hashCode());
            String $trackingUrl = this.getTrackingUrl();
            result = result * 59 + ($trackingUrl == null ? 43 : $trackingUrl.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }
}

