/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.CapabilityUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Capability
extends ApiResource
implements HasId {
    @SerializedName(value="account")
    ExpandableField<Account> account;
    @SerializedName(value="future_requirements")
    FutureRequirements futureRequirements;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="requested")
    Boolean requested;
    @SerializedName(value="requested_at")
    Long requestedAt;
    @SerializedName(value="requirements")
    Requirements requirements;
    @SerializedName(value="status")
    String status;

    public String getAccount() {
        return this.account != null ? this.account.getId() : null;
    }

    public void setAccount(String id) {
        this.account = ApiResource.setExpandableFieldId(id, this.account);
    }

    public Account getAccountObject() {
        return this.account != null ? this.account.getExpanded() : null;
    }

    public void setAccountObject(Account expandableObject) {
        this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public Capability update(Map<String, Object> params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Capability update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/capabilities/%s", ApiResource.urlEncodeId(this.getAccount()), ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Capability.class, options);
    }

    public Capability update(CapabilityUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Capability update(CapabilityUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/capabilities/%s", ApiResource.urlEncodeId(this.getAccount()), ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Capability.class, options);
    }

    @Generated
    public FutureRequirements getFutureRequirements() {
        return this.futureRequirements;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Boolean getRequested() {
        return this.requested;
    }

    @Generated
    public Long getRequestedAt() {
        return this.requestedAt;
    }

    @Generated
    public Requirements getRequirements() {
        return this.requirements;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setFutureRequirements(FutureRequirements futureRequirements) {
        this.futureRequirements = futureRequirements;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setRequested(Boolean requested) {
        this.requested = requested;
    }

    @Generated
    public void setRequestedAt(Long requestedAt) {
        this.requestedAt = requestedAt;
    }

    @Generated
    public void setRequirements(Requirements requirements) {
        this.requirements = requirements;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Capability)) {
            return false;
        }
        Capability other = (Capability)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$requested = this.getRequested();
        Boolean other$requested = other.getRequested();
        if (this$requested == null ? other$requested != null : !((Object)this$requested).equals(other$requested)) {
            return false;
        }
        Long this$requestedAt = this.getRequestedAt();
        Long other$requestedAt = other.getRequestedAt();
        if (this$requestedAt == null ? other$requestedAt != null : !((Object)this$requestedAt).equals(other$requestedAt)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        FutureRequirements this$futureRequirements = this.getFutureRequirements();
        FutureRequirements other$futureRequirements = other.getFutureRequirements();
        if (this$futureRequirements == null ? other$futureRequirements != null : !((Object)this$futureRequirements).equals(other$futureRequirements)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Requirements this$requirements = this.getRequirements();
        Requirements other$requirements = other.getRequirements();
        if (this$requirements == null ? other$requirements != null : !((Object)this$requirements).equals(other$requirements)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Capability;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $requested = this.getRequested();
        result = result * 59 + ($requested == null ? 43 : ((Object)$requested).hashCode());
        Long $requestedAt = this.getRequestedAt();
        result = result * 59 + ($requestedAt == null ? 43 : ((Object)$requestedAt).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        FutureRequirements $futureRequirements = this.getFutureRequirements();
        result = result * 59 + ($futureRequirements == null ? 43 : ((Object)$futureRequirements).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Requirements $requirements = this.getRequirements();
        result = result * 59 + ($requirements == null ? 43 : ((Object)$requirements).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Requirements
    extends StripeObject {
        @SerializedName(value="alternatives")
        List<Alternative> alternatives;
        @SerializedName(value="current_deadline")
        Long currentDeadline;
        @SerializedName(value="currently_due")
        List<String> currentlyDue;
        @SerializedName(value="disabled_reason")
        String disabledReason;
        @SerializedName(value="errors")
        List<Account.Requirements.Errors> errors;
        @SerializedName(value="eventually_due")
        List<String> eventuallyDue;
        @SerializedName(value="past_due")
        List<String> pastDue;
        @SerializedName(value="pending_verification")
        List<String> pendingVerification;

        @Generated
        public List<Alternative> getAlternatives() {
            return this.alternatives;
        }

        @Generated
        public Long getCurrentDeadline() {
            return this.currentDeadline;
        }

        @Generated
        public List<String> getCurrentlyDue() {
            return this.currentlyDue;
        }

        @Generated
        public String getDisabledReason() {
            return this.disabledReason;
        }

        @Generated
        public List<Account.Requirements.Errors> getErrors() {
            return this.errors;
        }

        @Generated
        public List<String> getEventuallyDue() {
            return this.eventuallyDue;
        }

        @Generated
        public List<String> getPastDue() {
            return this.pastDue;
        }

        @Generated
        public List<String> getPendingVerification() {
            return this.pendingVerification;
        }

        @Generated
        public void setAlternatives(List<Alternative> alternatives) {
            this.alternatives = alternatives;
        }

        @Generated
        public void setCurrentDeadline(Long currentDeadline) {
            this.currentDeadline = currentDeadline;
        }

        @Generated
        public void setCurrentlyDue(List<String> currentlyDue) {
            this.currentlyDue = currentlyDue;
        }

        @Generated
        public void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @Generated
        public void setErrors(List<Account.Requirements.Errors> errors) {
            this.errors = errors;
        }

        @Generated
        public void setEventuallyDue(List<String> eventuallyDue) {
            this.eventuallyDue = eventuallyDue;
        }

        @Generated
        public void setPastDue(List<String> pastDue) {
            this.pastDue = pastDue;
        }

        @Generated
        public void setPendingVerification(List<String> pendingVerification) {
            this.pendingVerification = pendingVerification;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Requirements)) {
                return false;
            }
            Requirements other = (Requirements)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$currentDeadline = this.getCurrentDeadline();
            Long other$currentDeadline = other.getCurrentDeadline();
            if (this$currentDeadline == null ? other$currentDeadline != null : !((Object)this$currentDeadline).equals(other$currentDeadline)) {
                return false;
            }
            List<Alternative> this$alternatives = this.getAlternatives();
            List<Alternative> other$alternatives = other.getAlternatives();
            if (this$alternatives == null ? other$alternatives != null : !((Object)this$alternatives).equals(other$alternatives)) {
                return false;
            }
            List<String> this$currentlyDue = this.getCurrentlyDue();
            List<String> other$currentlyDue = other.getCurrentlyDue();
            if (this$currentlyDue == null ? other$currentlyDue != null : !((Object)this$currentlyDue).equals(other$currentlyDue)) {
                return false;
            }
            String this$disabledReason = this.getDisabledReason();
            String other$disabledReason = other.getDisabledReason();
            if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) {
                return false;
            }
            List<Account.Requirements.Errors> this$errors = this.getErrors();
            List<Account.Requirements.Errors> other$errors = other.getErrors();
            if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
                return false;
            }
            List<String> this$eventuallyDue = this.getEventuallyDue();
            List<String> other$eventuallyDue = other.getEventuallyDue();
            if (this$eventuallyDue == null ? other$eventuallyDue != null : !((Object)this$eventuallyDue).equals(other$eventuallyDue)) {
                return false;
            }
            List<String> this$pastDue = this.getPastDue();
            List<String> other$pastDue = other.getPastDue();
            if (this$pastDue == null ? other$pastDue != null : !((Object)this$pastDue).equals(other$pastDue)) {
                return false;
            }
            List<String> this$pendingVerification = this.getPendingVerification();
            List<String> other$pendingVerification = other.getPendingVerification();
            return !(this$pendingVerification == null ? other$pendingVerification != null : !((Object)this$pendingVerification).equals(other$pendingVerification));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Requirements;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $currentDeadline = this.getCurrentDeadline();
            result = result * 59 + ($currentDeadline == null ? 43 : ((Object)$currentDeadline).hashCode());
            List<Alternative> $alternatives = this.getAlternatives();
            result = result * 59 + ($alternatives == null ? 43 : ((Object)$alternatives).hashCode());
            List<String> $currentlyDue = this.getCurrentlyDue();
            result = result * 59 + ($currentlyDue == null ? 43 : ((Object)$currentlyDue).hashCode());
            String $disabledReason = this.getDisabledReason();
            result = result * 59 + ($disabledReason == null ? 43 : $disabledReason.hashCode());
            List<Account.Requirements.Errors> $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
            List<String> $eventuallyDue = this.getEventuallyDue();
            result = result * 59 + ($eventuallyDue == null ? 43 : ((Object)$eventuallyDue).hashCode());
            List<String> $pastDue = this.getPastDue();
            result = result * 59 + ($pastDue == null ? 43 : ((Object)$pastDue).hashCode());
            List<String> $pendingVerification = this.getPendingVerification();
            result = result * 59 + ($pendingVerification == null ? 43 : ((Object)$pendingVerification).hashCode());
            return result;
        }

        public static class Alternative
        extends StripeObject {
            @SerializedName(value="alternative_fields_due")
            List<String> alternativeFieldsDue;
            @SerializedName(value="original_fields_due")
            List<String> originalFieldsDue;

            @Generated
            public List<String> getAlternativeFieldsDue() {
                return this.alternativeFieldsDue;
            }

            @Generated
            public List<String> getOriginalFieldsDue() {
                return this.originalFieldsDue;
            }

            @Generated
            public void setAlternativeFieldsDue(List<String> alternativeFieldsDue) {
                this.alternativeFieldsDue = alternativeFieldsDue;
            }

            @Generated
            public void setOriginalFieldsDue(List<String> originalFieldsDue) {
                this.originalFieldsDue = originalFieldsDue;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alternative)) {
                    return false;
                }
                Alternative other = (Alternative)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$alternativeFieldsDue = this.getAlternativeFieldsDue();
                List<String> other$alternativeFieldsDue = other.getAlternativeFieldsDue();
                if (this$alternativeFieldsDue == null ? other$alternativeFieldsDue != null : !((Object)this$alternativeFieldsDue).equals(other$alternativeFieldsDue)) {
                    return false;
                }
                List<String> this$originalFieldsDue = this.getOriginalFieldsDue();
                List<String> other$originalFieldsDue = other.getOriginalFieldsDue();
                return !(this$originalFieldsDue == null ? other$originalFieldsDue != null : !((Object)this$originalFieldsDue).equals(other$originalFieldsDue));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alternative;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $alternativeFieldsDue = this.getAlternativeFieldsDue();
                result = result * 59 + ($alternativeFieldsDue == null ? 43 : ((Object)$alternativeFieldsDue).hashCode());
                List<String> $originalFieldsDue = this.getOriginalFieldsDue();
                result = result * 59 + ($originalFieldsDue == null ? 43 : ((Object)$originalFieldsDue).hashCode());
                return result;
            }
        }
    }

    public static class FutureRequirements
    extends StripeObject {
        @SerializedName(value="alternatives")
        List<Alternative> alternatives;
        @SerializedName(value="current_deadline")
        Long currentDeadline;
        @SerializedName(value="currently_due")
        List<String> currentlyDue;
        @SerializedName(value="disabled_reason")
        String disabledReason;
        @SerializedName(value="errors")
        List<Errors> errors;
        @SerializedName(value="eventually_due")
        List<String> eventuallyDue;
        @SerializedName(value="past_due")
        List<String> pastDue;
        @SerializedName(value="pending_verification")
        List<String> pendingVerification;

        @Generated
        public List<Alternative> getAlternatives() {
            return this.alternatives;
        }

        @Generated
        public Long getCurrentDeadline() {
            return this.currentDeadline;
        }

        @Generated
        public List<String> getCurrentlyDue() {
            return this.currentlyDue;
        }

        @Generated
        public String getDisabledReason() {
            return this.disabledReason;
        }

        @Generated
        public List<Errors> getErrors() {
            return this.errors;
        }

        @Generated
        public List<String> getEventuallyDue() {
            return this.eventuallyDue;
        }

        @Generated
        public List<String> getPastDue() {
            return this.pastDue;
        }

        @Generated
        public List<String> getPendingVerification() {
            return this.pendingVerification;
        }

        @Generated
        public void setAlternatives(List<Alternative> alternatives) {
            this.alternatives = alternatives;
        }

        @Generated
        public void setCurrentDeadline(Long currentDeadline) {
            this.currentDeadline = currentDeadline;
        }

        @Generated
        public void setCurrentlyDue(List<String> currentlyDue) {
            this.currentlyDue = currentlyDue;
        }

        @Generated
        public void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @Generated
        public void setErrors(List<Errors> errors) {
            this.errors = errors;
        }

        @Generated
        public void setEventuallyDue(List<String> eventuallyDue) {
            this.eventuallyDue = eventuallyDue;
        }

        @Generated
        public void setPastDue(List<String> pastDue) {
            this.pastDue = pastDue;
        }

        @Generated
        public void setPendingVerification(List<String> pendingVerification) {
            this.pendingVerification = pendingVerification;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FutureRequirements)) {
                return false;
            }
            FutureRequirements other = (FutureRequirements)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$currentDeadline = this.getCurrentDeadline();
            Long other$currentDeadline = other.getCurrentDeadline();
            if (this$currentDeadline == null ? other$currentDeadline != null : !((Object)this$currentDeadline).equals(other$currentDeadline)) {
                return false;
            }
            List<Alternative> this$alternatives = this.getAlternatives();
            List<Alternative> other$alternatives = other.getAlternatives();
            if (this$alternatives == null ? other$alternatives != null : !((Object)this$alternatives).equals(other$alternatives)) {
                return false;
            }
            List<String> this$currentlyDue = this.getCurrentlyDue();
            List<String> other$currentlyDue = other.getCurrentlyDue();
            if (this$currentlyDue == null ? other$currentlyDue != null : !((Object)this$currentlyDue).equals(other$currentlyDue)) {
                return false;
            }
            String this$disabledReason = this.getDisabledReason();
            String other$disabledReason = other.getDisabledReason();
            if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) {
                return false;
            }
            List<Errors> this$errors = this.getErrors();
            List<Errors> other$errors = other.getErrors();
            if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
                return false;
            }
            List<String> this$eventuallyDue = this.getEventuallyDue();
            List<String> other$eventuallyDue = other.getEventuallyDue();
            if (this$eventuallyDue == null ? other$eventuallyDue != null : !((Object)this$eventuallyDue).equals(other$eventuallyDue)) {
                return false;
            }
            List<String> this$pastDue = this.getPastDue();
            List<String> other$pastDue = other.getPastDue();
            if (this$pastDue == null ? other$pastDue != null : !((Object)this$pastDue).equals(other$pastDue)) {
                return false;
            }
            List<String> this$pendingVerification = this.getPendingVerification();
            List<String> other$pendingVerification = other.getPendingVerification();
            return !(this$pendingVerification == null ? other$pendingVerification != null : !((Object)this$pendingVerification).equals(other$pendingVerification));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FutureRequirements;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $currentDeadline = this.getCurrentDeadline();
            result = result * 59 + ($currentDeadline == null ? 43 : ((Object)$currentDeadline).hashCode());
            List<Alternative> $alternatives = this.getAlternatives();
            result = result * 59 + ($alternatives == null ? 43 : ((Object)$alternatives).hashCode());
            List<String> $currentlyDue = this.getCurrentlyDue();
            result = result * 59 + ($currentlyDue == null ? 43 : ((Object)$currentlyDue).hashCode());
            String $disabledReason = this.getDisabledReason();
            result = result * 59 + ($disabledReason == null ? 43 : $disabledReason.hashCode());
            List<Errors> $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
            List<String> $eventuallyDue = this.getEventuallyDue();
            result = result * 59 + ($eventuallyDue == null ? 43 : ((Object)$eventuallyDue).hashCode());
            List<String> $pastDue = this.getPastDue();
            result = result * 59 + ($pastDue == null ? 43 : ((Object)$pastDue).hashCode());
            List<String> $pendingVerification = this.getPendingVerification();
            result = result * 59 + ($pendingVerification == null ? 43 : ((Object)$pendingVerification).hashCode());
            return result;
        }

        public static class Errors
        extends StripeObject {
            @SerializedName(value="code")
            String code;
            @SerializedName(value="reason")
            String reason;
            @SerializedName(value="requirement")
            String requirement;

            @Generated
            public String getCode() {
                return this.code;
            }

            @Generated
            public String getReason() {
                return this.reason;
            }

            @Generated
            public String getRequirement() {
                return this.requirement;
            }

            @Generated
            public void setCode(String code) {
                this.code = code;
            }

            @Generated
            public void setReason(String reason) {
                this.reason = reason;
            }

            @Generated
            public void setRequirement(String requirement) {
                this.requirement = requirement;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Errors)) {
                    return false;
                }
                Errors other = (Errors)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$code = this.getCode();
                String other$code = other.getCode();
                if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                    return false;
                }
                String this$reason = this.getReason();
                String other$reason = other.getReason();
                if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                    return false;
                }
                String this$requirement = this.getRequirement();
                String other$requirement = other.getRequirement();
                return !(this$requirement == null ? other$requirement != null : !this$requirement.equals(other$requirement));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Errors;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $code = this.getCode();
                result = result * 59 + ($code == null ? 43 : $code.hashCode());
                String $reason = this.getReason();
                result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
                String $requirement = this.getRequirement();
                result = result * 59 + ($requirement == null ? 43 : $requirement.hashCode());
                return result;
            }
        }

        public static class Alternative
        extends StripeObject {
            @SerializedName(value="alternative_fields_due")
            List<String> alternativeFieldsDue;
            @SerializedName(value="original_fields_due")
            List<String> originalFieldsDue;

            @Generated
            public List<String> getAlternativeFieldsDue() {
                return this.alternativeFieldsDue;
            }

            @Generated
            public List<String> getOriginalFieldsDue() {
                return this.originalFieldsDue;
            }

            @Generated
            public void setAlternativeFieldsDue(List<String> alternativeFieldsDue) {
                this.alternativeFieldsDue = alternativeFieldsDue;
            }

            @Generated
            public void setOriginalFieldsDue(List<String> originalFieldsDue) {
                this.originalFieldsDue = originalFieldsDue;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alternative)) {
                    return false;
                }
                Alternative other = (Alternative)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$alternativeFieldsDue = this.getAlternativeFieldsDue();
                List<String> other$alternativeFieldsDue = other.getAlternativeFieldsDue();
                if (this$alternativeFieldsDue == null ? other$alternativeFieldsDue != null : !((Object)this$alternativeFieldsDue).equals(other$alternativeFieldsDue)) {
                    return false;
                }
                List<String> this$originalFieldsDue = this.getOriginalFieldsDue();
                List<String> other$originalFieldsDue = other.getOriginalFieldsDue();
                return !(this$originalFieldsDue == null ? other$originalFieldsDue != null : !((Object)this$originalFieldsDue).equals(other$originalFieldsDue));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alternative;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $alternativeFieldsDue = this.getAlternativeFieldsDue();
                result = result * 59 + ($alternativeFieldsDue == null ? 43 : ((Object)$alternativeFieldsDue).hashCode());
                List<String> $originalFieldsDue = this.getOriginalFieldsDue();
                result = result * 59 + ($originalFieldsDue == null ? 43 : ((Object)$originalFieldsDue).hashCode());
                return result;
            }
        }
    }
}

