/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PaymentIntentConfirmParams
extends ApiRequestParams {
    @SerializedName(value="error_on_requires_action")
    Boolean errorOnRequiresAction;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="mandate")
    String mandate;
    @SerializedName(value="mandate_data")
    Object mandateData;
    @SerializedName(value="off_session")
    Object offSession;
    @SerializedName(value="payment_method")
    String paymentMethod;
    @SerializedName(value="payment_method_data")
    PaymentMethodData paymentMethodData;
    @SerializedName(value="payment_method_options")
    PaymentMethodOptions paymentMethodOptions;
    @SerializedName(value="receipt_email")
    Object receiptEmail;
    @SerializedName(value="return_url")
    String returnUrl;
    @SerializedName(value="setup_future_usage")
    ApiRequestParams.EnumParam setupFutureUsage;
    @SerializedName(value="shipping")
    Object shipping;
    @SerializedName(value="use_stripe_sdk")
    Boolean useStripeSdk;

    private PaymentIntentConfirmParams(Boolean errorOnRequiresAction, List<String> expand, Map<String, Object> extraParams, String mandate, Object mandateData, Object offSession, String paymentMethod, PaymentMethodData paymentMethodData, PaymentMethodOptions paymentMethodOptions, Object receiptEmail, String returnUrl, ApiRequestParams.EnumParam setupFutureUsage, Object shipping, Boolean useStripeSdk) {
        this.errorOnRequiresAction = errorOnRequiresAction;
        this.expand = expand;
        this.extraParams = extraParams;
        this.mandate = mandate;
        this.mandateData = mandateData;
        this.offSession = offSession;
        this.paymentMethod = paymentMethod;
        this.paymentMethodData = paymentMethodData;
        this.paymentMethodOptions = paymentMethodOptions;
        this.receiptEmail = receiptEmail;
        this.returnUrl = returnUrl;
        this.setupFutureUsage = setupFutureUsage;
        this.shipping = shipping;
        this.useStripeSdk = useStripeSdk;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Boolean getErrorOnRequiresAction() {
        return this.errorOnRequiresAction;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public String getMandate() {
        return this.mandate;
    }

    @Generated
    public Object getMandateData() {
        return this.mandateData;
    }

    @Generated
    public Object getOffSession() {
        return this.offSession;
    }

    @Generated
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    @Generated
    public PaymentMethodData getPaymentMethodData() {
        return this.paymentMethodData;
    }

    @Generated
    public PaymentMethodOptions getPaymentMethodOptions() {
        return this.paymentMethodOptions;
    }

    @Generated
    public Object getReceiptEmail() {
        return this.receiptEmail;
    }

    @Generated
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Generated
    public ApiRequestParams.EnumParam getSetupFutureUsage() {
        return this.setupFutureUsage;
    }

    @Generated
    public Object getShipping() {
        return this.shipping;
    }

    @Generated
    public Boolean getUseStripeSdk() {
        return this.useStripeSdk;
    }

    public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
    {
        OFF_SESSION("off_session"),
        ON_SESSION("on_session");

        private final String value;

        private SetupFutureUsage(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum OffSession implements ApiRequestParams.EnumParam
    {
        ONE_OFF("one_off"),
        RECURRING("recurring");

        private final String value;

        private OffSession(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Shipping {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="carrier")
        String carrier;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="tracking_number")
        String trackingNumber;

        private Shipping(Address address, String carrier, Map<String, Object> extraParams, String name, String phone, String trackingNumber) {
            this.address = address;
            this.carrier = carrier;
            this.extraParams = extraParams;
            this.name = name;
            this.phone = phone;
            this.trackingNumber = trackingNumber;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public String getCarrier() {
            return this.carrier;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public String getTrackingNumber() {
            return this.trackingNumber;
        }

        public static class Address {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getLine1() {
                return this.line1;
            }

            @Generated
            public String getLine2() {
                return this.line2;
            }

            @Generated
            public String getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            public static class Builder {
                private String city;
                private String country;
                private Map<String, Object> extraParams;
                private String line1;
                private String line2;
                private String postalCode;
                private String state;

                public Address build() {
                    return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private String carrier;
            private Map<String, Object> extraParams;
            private String name;
            private String phone;
            private String trackingNumber;

            public Shipping build() {
                return new Shipping(this.address, this.carrier, this.extraParams, this.name, this.phone, this.trackingNumber);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setCarrier(String carrier) {
                this.carrier = carrier;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setPhone(String phone) {
                this.phone = phone;
                return this;
            }

            public Builder setTrackingNumber(String trackingNumber) {
                this.trackingNumber = trackingNumber;
                return this;
            }
        }
    }

    public static class PaymentMethodOptions {
        @SerializedName(value="acss_debit")
        Object acssDebit;
        @SerializedName(value="afterpay_clearpay")
        Object afterpayClearpay;
        @SerializedName(value="alipay")
        Object alipay;
        @SerializedName(value="au_becs_debit")
        Object auBecsDebit;
        @SerializedName(value="bancontact")
        Object bancontact;
        @SerializedName(value="boleto")
        Object boleto;
        @SerializedName(value="card")
        Object card;
        @SerializedName(value="card_present")
        Object cardPresent;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="giropay")
        Object giropay;
        @SerializedName(value="ideal")
        Object ideal;
        @SerializedName(value="interac_present")
        Object interacPresent;
        @SerializedName(value="klarna")
        Object klarna;
        @SerializedName(value="oxxo")
        Object oxxo;
        @SerializedName(value="p24")
        Object p24;
        @SerializedName(value="sepa_debit")
        Object sepaDebit;
        @SerializedName(value="sofort")
        Object sofort;
        @SerializedName(value="wechat_pay")
        Object wechatPay;

        private PaymentMethodOptions(Object acssDebit, Object afterpayClearpay, Object alipay, Object auBecsDebit, Object bancontact, Object boleto, Object card, Object cardPresent, Map<String, Object> extraParams, Object giropay, Object ideal, Object interacPresent, Object klarna, Object oxxo, Object p24, Object sepaDebit, Object sofort, Object wechatPay) {
            this.acssDebit = acssDebit;
            this.afterpayClearpay = afterpayClearpay;
            this.alipay = alipay;
            this.auBecsDebit = auBecsDebit;
            this.bancontact = bancontact;
            this.boleto = boleto;
            this.card = card;
            this.cardPresent = cardPresent;
            this.extraParams = extraParams;
            this.giropay = giropay;
            this.ideal = ideal;
            this.interacPresent = interacPresent;
            this.klarna = klarna;
            this.oxxo = oxxo;
            this.p24 = p24;
            this.sepaDebit = sepaDebit;
            this.sofort = sofort;
            this.wechatPay = wechatPay;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Object getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public Object getAfterpayClearpay() {
            return this.afterpayClearpay;
        }

        @Generated
        public Object getAlipay() {
            return this.alipay;
        }

        @Generated
        public Object getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public Object getBancontact() {
            return this.bancontact;
        }

        @Generated
        public Object getBoleto() {
            return this.boleto;
        }

        @Generated
        public Object getCard() {
            return this.card;
        }

        @Generated
        public Object getCardPresent() {
            return this.cardPresent;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Object getGiropay() {
            return this.giropay;
        }

        @Generated
        public Object getIdeal() {
            return this.ideal;
        }

        @Generated
        public Object getInteracPresent() {
            return this.interacPresent;
        }

        @Generated
        public Object getKlarna() {
            return this.klarna;
        }

        @Generated
        public Object getOxxo() {
            return this.oxxo;
        }

        @Generated
        public Object getP24() {
            return this.p24;
        }

        @Generated
        public Object getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public Object getSofort() {
            return this.sofort;
        }

        @Generated
        public Object getWechatPay() {
            return this.wechatPay;
        }

        public static class WechatPay {
            @SerializedName(value="app_id")
            String appId;
            @SerializedName(value="client")
            Client client;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private WechatPay(String appId, Client client, Map<String, Object> extraParams) {
                this.appId = appId;
                this.client = client;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getAppId() {
                return this.appId;
            }

            @Generated
            public Client getClient() {
                return this.client;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static enum Client implements ApiRequestParams.EnumParam
            {
                ANDROID("android"),
                IOS("ios"),
                WEB("web");

                private final String value;

                private Client(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private String appId;
                private Client client;
                private Map<String, Object> extraParams;

                public WechatPay build() {
                    return new WechatPay(this.appId, this.client, this.extraParams);
                }

                public Builder setAppId(String appId) {
                    this.appId = appId;
                    return this;
                }

                public Builder setClient(Client client) {
                    this.client = client;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Sofort {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="preferred_language")
            ApiRequestParams.EnumParam preferredLanguage;

            private Sofort(Map<String, Object> extraParams, ApiRequestParams.EnumParam preferredLanguage) {
                this.extraParams = extraParams;
                this.preferredLanguage = preferredLanguage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getPreferredLanguage() {
                return this.preferredLanguage;
            }

            public static enum PreferredLanguage implements ApiRequestParams.EnumParam
            {
                DE("de"),
                EN("en"),
                ES("es"),
                FR("fr"),
                IT("it"),
                NL("nl"),
                PL("pl");

                private final String value;

                private PreferredLanguage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam preferredLanguage;

                public Sofort build() {
                    return new Sofort(this.extraParams, this.preferredLanguage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPreferredLanguage(PreferredLanguage preferredLanguage) {
                    this.preferredLanguage = preferredLanguage;
                    return this;
                }

                public Builder setPreferredLanguage(EmptyParam preferredLanguage) {
                    this.preferredLanguage = preferredLanguage;
                    return this;
                }
            }
        }

        public static class SepaDebit {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;

            private SepaDebit(Map<String, Object> extraParams, MandateOptions mandateOptions) {
                this.extraParams = extraParams;
                this.mandateOptions = mandateOptions;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            public static class MandateOptions {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private MandateOptions(Map<String, Object> extraParams) {
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;

                    public MandateOptions build() {
                        return new MandateOptions(this.extraParams);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private MandateOptions mandateOptions;

                public SepaDebit build() {
                    return new SepaDebit(this.extraParams, this.mandateOptions);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setMandateOptions(MandateOptions mandateOptions) {
                    this.mandateOptions = mandateOptions;
                    return this;
                }
            }
        }

        public static class P24 {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="tos_shown_and_accepted")
            Boolean tosShownAndAccepted;

            private P24(Map<String, Object> extraParams, Boolean tosShownAndAccepted) {
                this.extraParams = extraParams;
                this.tosShownAndAccepted = tosShownAndAccepted;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getTosShownAndAccepted() {
                return this.tosShownAndAccepted;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean tosShownAndAccepted;

                public P24 build() {
                    return new P24(this.extraParams, this.tosShownAndAccepted);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setTosShownAndAccepted(Boolean tosShownAndAccepted) {
                    this.tosShownAndAccepted = tosShownAndAccepted;
                    return this;
                }
            }
        }

        public static class Oxxo {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Oxxo(Long expiresAfterDays, Map<String, Object> extraParams) {
                this.expiresAfterDays = expiresAfterDays;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Long expiresAfterDays;
                private Map<String, Object> extraParams;

                public Oxxo build() {
                    return new Oxxo(this.expiresAfterDays, this.extraParams);
                }

                public Builder setExpiresAfterDays(Long expiresAfterDays) {
                    this.expiresAfterDays = expiresAfterDays;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Klarna {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="preferred_locale")
            PreferredLocale preferredLocale;

            private Klarna(Map<String, Object> extraParams, PreferredLocale preferredLocale) {
                this.extraParams = extraParams;
                this.preferredLocale = preferredLocale;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public PreferredLocale getPreferredLocale() {
                return this.preferredLocale;
            }

            public static enum PreferredLocale implements ApiRequestParams.EnumParam
            {
                DA_DK("da-DK"),
                DE_AT("de-AT"),
                DE_DE("de-DE"),
                EN_AT("en-AT"),
                EN_BE("en-BE"),
                EN_DE("en-DE"),
                EN_DK("en-DK"),
                EN_ES("en-ES"),
                EN_FI("en-FI"),
                EN_FR("en-FR"),
                EN_GB("en-GB"),
                EN_IE("en-IE"),
                EN_IT("en-IT"),
                EN_NL("en-NL"),
                EN_NO("en-NO"),
                EN_SE("en-SE"),
                EN_US("en-US"),
                ES_ES("es-ES"),
                ES_US("es-US"),
                FI_FI("fi-FI"),
                FR_BE("fr-BE"),
                FR_FR("fr-FR"),
                IT_IT("it-IT"),
                NB_NO("nb-NO"),
                NL_BE("nl-BE"),
                NL_NL("nl-NL"),
                SV_FI("sv-FI"),
                SV_SE("sv-SE");

                private final String value;

                private PreferredLocale(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private PreferredLocale preferredLocale;

                public Klarna build() {
                    return new Klarna(this.extraParams, this.preferredLocale);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPreferredLocale(PreferredLocale preferredLocale) {
                    this.preferredLocale = preferredLocale;
                    return this;
                }
            }
        }

        public static class InteracPresent {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private InteracPresent(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public InteracPresent build() {
                    return new InteracPresent(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Ideal {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Ideal(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Ideal build() {
                    return new Ideal(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Giropay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Giropay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Giropay build() {
                    return new Giropay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class CardPresent {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private CardPresent(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public CardPresent build() {
                    return new CardPresent(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Card {
            @SerializedName(value="cvc_token")
            String cvcToken;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="installments")
            Installments installments;
            @SerializedName(value="moto")
            Boolean moto;
            @SerializedName(value="network")
            Network network;
            @SerializedName(value="request_three_d_secure")
            RequestThreeDSecure requestThreeDSecure;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private Card(String cvcToken, Map<String, Object> extraParams, Installments installments, Boolean moto, Network network, RequestThreeDSecure requestThreeDSecure, ApiRequestParams.EnumParam setupFutureUsage) {
                this.cvcToken = cvcToken;
                this.extraParams = extraParams;
                this.installments = installments;
                this.moto = moto;
                this.network = network;
                this.requestThreeDSecure = requestThreeDSecure;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCvcToken() {
                return this.cvcToken;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Installments getInstallments() {
                return this.installments;
            }

            @Generated
            public Boolean getMoto() {
                return this.moto;
            }

            @Generated
            public Network getNetwork() {
                return this.network;
            }

            @Generated
            public RequestThreeDSecure getRequestThreeDSecure() {
                return this.requestThreeDSecure;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum RequestThreeDSecure implements ApiRequestParams.EnumParam
            {
                ANY("any"),
                AUTOMATIC("automatic");

                private final String value;

                private RequestThreeDSecure(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum Network implements ApiRequestParams.EnumParam
            {
                AMEX("amex"),
                CARTES_BANCAIRES("cartes_bancaires"),
                DINERS("diners"),
                DISCOVER("discover"),
                INTERAC("interac"),
                JCB("jcb"),
                MASTERCARD("mastercard"),
                UNIONPAY("unionpay"),
                UNKNOWN("unknown"),
                VISA("visa");

                private final String value;

                private Network(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Installments {
                @SerializedName(value="enabled")
                Boolean enabled;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="plan")
                Object plan;

                private Installments(Boolean enabled, Map<String, Object> extraParams, Object plan) {
                    this.enabled = enabled;
                    this.extraParams = extraParams;
                    this.plan = plan;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Boolean getEnabled() {
                    return this.enabled;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getPlan() {
                    return this.plan;
                }

                public static class Plan {
                    @SerializedName(value="count")
                    Long count;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="interval")
                    Interval interval;
                    @SerializedName(value="type")
                    Type type;

                    private Plan(Long count, Map<String, Object> extraParams, Interval interval, Type type) {
                        this.count = count;
                        this.extraParams = extraParams;
                        this.interval = interval;
                        this.type = type;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Long getCount() {
                        return this.count;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Interval getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public Type getType() {
                        return this.type;
                    }

                    public static enum Type implements ApiRequestParams.EnumParam
                    {
                        FIXED_COUNT("fixed_count");

                        private final String value;

                        private Type(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static enum Interval implements ApiRequestParams.EnumParam
                    {
                        MONTH("month");

                        private final String value;

                        private Interval(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Long count;
                        private Map<String, Object> extraParams;
                        private Interval interval;
                        private Type type;

                        public Plan build() {
                            return new Plan(this.count, this.extraParams, this.interval, this.type);
                        }

                        public Builder setCount(Long count) {
                            this.count = count;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setInterval(Interval interval) {
                            this.interval = interval;
                            return this;
                        }

                        public Builder setType(Type type) {
                            this.type = type;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Boolean enabled;
                    private Map<String, Object> extraParams;
                    private Object plan;

                    public Installments build() {
                        return new Installments(this.enabled, this.extraParams, this.plan);
                    }

                    public Builder setEnabled(Boolean enabled) {
                        this.enabled = enabled;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setPlan(Plan plan) {
                        this.plan = plan;
                        return this;
                    }

                    public Builder setPlan(EmptyParam plan) {
                        this.plan = plan;
                        return this;
                    }
                }
            }

            public static class Builder {
                private String cvcToken;
                private Map<String, Object> extraParams;
                private Installments installments;
                private Boolean moto;
                private Network network;
                private RequestThreeDSecure requestThreeDSecure;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public Card build() {
                    return new Card(this.cvcToken, this.extraParams, this.installments, this.moto, this.network, this.requestThreeDSecure, this.setupFutureUsage);
                }

                public Builder setCvcToken(String cvcToken) {
                    this.cvcToken = cvcToken;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setInstallments(Installments installments) {
                    this.installments = installments;
                    return this;
                }

                public Builder setMoto(Boolean moto) {
                    this.moto = moto;
                    return this;
                }

                public Builder setNetwork(Network network) {
                    this.network = network;
                    return this;
                }

                public Builder setRequestThreeDSecure(RequestThreeDSecure requestThreeDSecure) {
                    this.requestThreeDSecure = requestThreeDSecure;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Boleto {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Boleto(Long expiresAfterDays, Map<String, Object> extraParams) {
                this.expiresAfterDays = expiresAfterDays;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Long expiresAfterDays;
                private Map<String, Object> extraParams;

                public Boleto build() {
                    return new Boleto(this.expiresAfterDays, this.extraParams);
                }

                public Builder setExpiresAfterDays(Long expiresAfterDays) {
                    this.expiresAfterDays = expiresAfterDays;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Bancontact {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="preferred_language")
            PreferredLanguage preferredLanguage;

            private Bancontact(Map<String, Object> extraParams, PreferredLanguage preferredLanguage) {
                this.extraParams = extraParams;
                this.preferredLanguage = preferredLanguage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public PreferredLanguage getPreferredLanguage() {
                return this.preferredLanguage;
            }

            public static enum PreferredLanguage implements ApiRequestParams.EnumParam
            {
                DE("de"),
                EN("en"),
                FR("fr"),
                NL("nl");

                private final String value;

                private PreferredLanguage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private PreferredLanguage preferredLanguage;

                public Bancontact build() {
                    return new Bancontact(this.extraParams, this.preferredLanguage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPreferredLanguage(PreferredLanguage preferredLanguage) {
                    this.preferredLanguage = preferredLanguage;
                    return this;
                }
            }
        }

        public static class AuBecsDebit {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private AuBecsDebit(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public AuBecsDebit build() {
                    return new AuBecsDebit(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Alipay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Alipay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Alipay build() {
                    return new Alipay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class AfterpayClearpay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="reference")
            String reference;

            private AfterpayClearpay(Map<String, Object> extraParams, String reference) {
                this.extraParams = extraParams;
                this.reference = reference;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getReference() {
                return this.reference;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private String reference;

                public AfterpayClearpay build() {
                    return new AfterpayClearpay(this.extraParams, this.reference);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setReference(String reference) {
                    this.reference = reference;
                    return this;
                }
            }
        }

        public static class AcssDebit {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="verification_method")
            VerificationMethod verificationMethod;

            private AcssDebit(Map<String, Object> extraParams, MandateOptions mandateOptions, VerificationMethod verificationMethod) {
                this.extraParams = extraParams;
                this.mandateOptions = mandateOptions;
                this.verificationMethod = verificationMethod;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public VerificationMethod getVerificationMethod() {
                return this.verificationMethod;
            }

            public static enum VerificationMethod implements ApiRequestParams.EnumParam
            {
                AUTOMATIC("automatic"),
                INSTANT("instant"),
                MICRODEPOSITS("microdeposits");

                private final String value;

                private VerificationMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class MandateOptions {
                @SerializedName(value="custom_mandate_url")
                Object customMandateUrl;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="interval_description")
                String intervalDescription;
                @SerializedName(value="payment_schedule")
                PaymentSchedule paymentSchedule;
                @SerializedName(value="transaction_type")
                TransactionType transactionType;

                private MandateOptions(Object customMandateUrl, Map<String, Object> extraParams, String intervalDescription, PaymentSchedule paymentSchedule, TransactionType transactionType) {
                    this.customMandateUrl = customMandateUrl;
                    this.extraParams = extraParams;
                    this.intervalDescription = intervalDescription;
                    this.paymentSchedule = paymentSchedule;
                    this.transactionType = transactionType;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Object getCustomMandateUrl() {
                    return this.customMandateUrl;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getIntervalDescription() {
                    return this.intervalDescription;
                }

                @Generated
                public PaymentSchedule getPaymentSchedule() {
                    return this.paymentSchedule;
                }

                @Generated
                public TransactionType getTransactionType() {
                    return this.transactionType;
                }

                public static enum TransactionType implements ApiRequestParams.EnumParam
                {
                    BUSINESS("business"),
                    PERSONAL("personal");

                    private final String value;

                    private TransactionType(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum PaymentSchedule implements ApiRequestParams.EnumParam
                {
                    COMBINED("combined"),
                    INTERVAL("interval"),
                    SPORADIC("sporadic");

                    private final String value;

                    private PaymentSchedule(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Object customMandateUrl;
                    private Map<String, Object> extraParams;
                    private String intervalDescription;
                    private PaymentSchedule paymentSchedule;
                    private TransactionType transactionType;

                    public MandateOptions build() {
                        return new MandateOptions(this.customMandateUrl, this.extraParams, this.intervalDescription, this.paymentSchedule, this.transactionType);
                    }

                    public Builder setCustomMandateUrl(String customMandateUrl) {
                        this.customMandateUrl = customMandateUrl;
                        return this;
                    }

                    public Builder setCustomMandateUrl(EmptyParam customMandateUrl) {
                        this.customMandateUrl = customMandateUrl;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setIntervalDescription(String intervalDescription) {
                        this.intervalDescription = intervalDescription;
                        return this;
                    }

                    public Builder setPaymentSchedule(PaymentSchedule paymentSchedule) {
                        this.paymentSchedule = paymentSchedule;
                        return this;
                    }

                    public Builder setTransactionType(TransactionType transactionType) {
                        this.transactionType = transactionType;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private MandateOptions mandateOptions;
                private VerificationMethod verificationMethod;

                public AcssDebit build() {
                    return new AcssDebit(this.extraParams, this.mandateOptions, this.verificationMethod);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setMandateOptions(MandateOptions mandateOptions) {
                    this.mandateOptions = mandateOptions;
                    return this;
                }

                public Builder setVerificationMethod(VerificationMethod verificationMethod) {
                    this.verificationMethod = verificationMethod;
                    return this;
                }
            }
        }

        public static class Builder {
            private Object acssDebit;
            private Object afterpayClearpay;
            private Object alipay;
            private Object auBecsDebit;
            private Object bancontact;
            private Object boleto;
            private Object card;
            private Object cardPresent;
            private Map<String, Object> extraParams;
            private Object giropay;
            private Object ideal;
            private Object interacPresent;
            private Object klarna;
            private Object oxxo;
            private Object p24;
            private Object sepaDebit;
            private Object sofort;
            private Object wechatPay;

            public PaymentMethodOptions build() {
                return new PaymentMethodOptions(this.acssDebit, this.afterpayClearpay, this.alipay, this.auBecsDebit, this.bancontact, this.boleto, this.card, this.cardPresent, this.extraParams, this.giropay, this.ideal, this.interacPresent, this.klarna, this.oxxo, this.p24, this.sepaDebit, this.sofort, this.wechatPay);
            }

            public Builder setAcssDebit(AcssDebit acssDebit) {
                this.acssDebit = acssDebit;
                return this;
            }

            public Builder setAcssDebit(EmptyParam acssDebit) {
                this.acssDebit = acssDebit;
                return this;
            }

            public Builder setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
                this.afterpayClearpay = afterpayClearpay;
                return this;
            }

            public Builder setAfterpayClearpay(EmptyParam afterpayClearpay) {
                this.afterpayClearpay = afterpayClearpay;
                return this;
            }

            public Builder setAlipay(Alipay alipay) {
                this.alipay = alipay;
                return this;
            }

            public Builder setAlipay(EmptyParam alipay) {
                this.alipay = alipay;
                return this;
            }

            public Builder setAuBecsDebit(AuBecsDebit auBecsDebit) {
                this.auBecsDebit = auBecsDebit;
                return this;
            }

            public Builder setAuBecsDebit(EmptyParam auBecsDebit) {
                this.auBecsDebit = auBecsDebit;
                return this;
            }

            public Builder setBancontact(Bancontact bancontact) {
                this.bancontact = bancontact;
                return this;
            }

            public Builder setBancontact(EmptyParam bancontact) {
                this.bancontact = bancontact;
                return this;
            }

            public Builder setBoleto(Boleto boleto) {
                this.boleto = boleto;
                return this;
            }

            public Builder setBoleto(EmptyParam boleto) {
                this.boleto = boleto;
                return this;
            }

            public Builder setCard(Card card) {
                this.card = card;
                return this;
            }

            public Builder setCard(EmptyParam card) {
                this.card = card;
                return this;
            }

            public Builder setCardPresent(CardPresent cardPresent) {
                this.cardPresent = cardPresent;
                return this;
            }

            public Builder setCardPresent(EmptyParam cardPresent) {
                this.cardPresent = cardPresent;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setGiropay(Giropay giropay) {
                this.giropay = giropay;
                return this;
            }

            public Builder setGiropay(EmptyParam giropay) {
                this.giropay = giropay;
                return this;
            }

            public Builder setIdeal(Ideal ideal) {
                this.ideal = ideal;
                return this;
            }

            public Builder setIdeal(EmptyParam ideal) {
                this.ideal = ideal;
                return this;
            }

            public Builder setInteracPresent(InteracPresent interacPresent) {
                this.interacPresent = interacPresent;
                return this;
            }

            public Builder setInteracPresent(EmptyParam interacPresent) {
                this.interacPresent = interacPresent;
                return this;
            }

            public Builder setKlarna(Klarna klarna) {
                this.klarna = klarna;
                return this;
            }

            public Builder setKlarna(EmptyParam klarna) {
                this.klarna = klarna;
                return this;
            }

            public Builder setOxxo(Oxxo oxxo) {
                this.oxxo = oxxo;
                return this;
            }

            public Builder setOxxo(EmptyParam oxxo) {
                this.oxxo = oxxo;
                return this;
            }

            public Builder setP24(P24 p24) {
                this.p24 = p24;
                return this;
            }

            public Builder setP24(EmptyParam p24) {
                this.p24 = p24;
                return this;
            }

            public Builder setSepaDebit(SepaDebit sepaDebit) {
                this.sepaDebit = sepaDebit;
                return this;
            }

            public Builder setSepaDebit(EmptyParam sepaDebit) {
                this.sepaDebit = sepaDebit;
                return this;
            }

            public Builder setSofort(Sofort sofort) {
                this.sofort = sofort;
                return this;
            }

            public Builder setSofort(EmptyParam sofort) {
                this.sofort = sofort;
                return this;
            }

            public Builder setWechatPay(WechatPay wechatPay) {
                this.wechatPay = wechatPay;
                return this;
            }

            public Builder setWechatPay(EmptyParam wechatPay) {
                this.wechatPay = wechatPay;
                return this;
            }
        }
    }

    public static class PaymentMethodData {
        @SerializedName(value="acss_debit")
        AcssDebit acssDebit;
        @SerializedName(value="afterpay_clearpay")
        AfterpayClearpay afterpayClearpay;
        @SerializedName(value="alipay")
        Alipay alipay;
        @SerializedName(value="au_becs_debit")
        AuBecsDebit auBecsDebit;
        @SerializedName(value="bacs_debit")
        BacsDebit bacsDebit;
        @SerializedName(value="bancontact")
        Bancontact bancontact;
        @SerializedName(value="billing_details")
        BillingDetails billingDetails;
        @SerializedName(value="boleto")
        Boleto boleto;
        @SerializedName(value="eps")
        Eps eps;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="fpx")
        Fpx fpx;
        @SerializedName(value="giropay")
        Giropay giropay;
        @SerializedName(value="grabpay")
        Grabpay grabpay;
        @SerializedName(value="ideal")
        Ideal ideal;
        @SerializedName(value="interac_present")
        InteracPresent interacPresent;
        @SerializedName(value="klarna")
        Klarna klarna;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="oxxo")
        Oxxo oxxo;
        @SerializedName(value="p24")
        P24 p24;
        @SerializedName(value="sepa_debit")
        SepaDebit sepaDebit;
        @SerializedName(value="sofort")
        Sofort sofort;
        @SerializedName(value="type")
        Type type;
        @SerializedName(value="wechat_pay")
        WechatPay wechatPay;

        private PaymentMethodData(AcssDebit acssDebit, AfterpayClearpay afterpayClearpay, Alipay alipay, AuBecsDebit auBecsDebit, BacsDebit bacsDebit, Bancontact bancontact, BillingDetails billingDetails, Boleto boleto, Eps eps, Map<String, Object> extraParams, Fpx fpx, Giropay giropay, Grabpay grabpay, Ideal ideal, InteracPresent interacPresent, Klarna klarna, Map<String, String> metadata, Oxxo oxxo, P24 p24, SepaDebit sepaDebit, Sofort sofort, Type type, WechatPay wechatPay) {
            this.acssDebit = acssDebit;
            this.afterpayClearpay = afterpayClearpay;
            this.alipay = alipay;
            this.auBecsDebit = auBecsDebit;
            this.bacsDebit = bacsDebit;
            this.bancontact = bancontact;
            this.billingDetails = billingDetails;
            this.boleto = boleto;
            this.eps = eps;
            this.extraParams = extraParams;
            this.fpx = fpx;
            this.giropay = giropay;
            this.grabpay = grabpay;
            this.ideal = ideal;
            this.interacPresent = interacPresent;
            this.klarna = klarna;
            this.metadata = metadata;
            this.oxxo = oxxo;
            this.p24 = p24;
            this.sepaDebit = sepaDebit;
            this.sofort = sofort;
            this.type = type;
            this.wechatPay = wechatPay;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public AcssDebit getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public AfterpayClearpay getAfterpayClearpay() {
            return this.afterpayClearpay;
        }

        @Generated
        public Alipay getAlipay() {
            return this.alipay;
        }

        @Generated
        public AuBecsDebit getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public BacsDebit getBacsDebit() {
            return this.bacsDebit;
        }

        @Generated
        public Bancontact getBancontact() {
            return this.bancontact;
        }

        @Generated
        public BillingDetails getBillingDetails() {
            return this.billingDetails;
        }

        @Generated
        public Boleto getBoleto() {
            return this.boleto;
        }

        @Generated
        public Eps getEps() {
            return this.eps;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Fpx getFpx() {
            return this.fpx;
        }

        @Generated
        public Giropay getGiropay() {
            return this.giropay;
        }

        @Generated
        public Grabpay getGrabpay() {
            return this.grabpay;
        }

        @Generated
        public Ideal getIdeal() {
            return this.ideal;
        }

        @Generated
        public InteracPresent getInteracPresent() {
            return this.interacPresent;
        }

        @Generated
        public Klarna getKlarna() {
            return this.klarna;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public Oxxo getOxxo() {
            return this.oxxo;
        }

        @Generated
        public P24 getP24() {
            return this.p24;
        }

        @Generated
        public SepaDebit getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public Sofort getSofort() {
            return this.sofort;
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public WechatPay getWechatPay() {
            return this.wechatPay;
        }

        public static enum Type implements ApiRequestParams.EnumParam
        {
            ACSS_DEBIT("acss_debit"),
            AFTERPAY_CLEARPAY("afterpay_clearpay"),
            ALIPAY("alipay"),
            AU_BECS_DEBIT("au_becs_debit"),
            BACS_DEBIT("bacs_debit"),
            BANCONTACT("bancontact"),
            BOLETO("boleto"),
            EPS("eps"),
            FPX("fpx"),
            GIROPAY("giropay"),
            GRABPAY("grabpay"),
            IDEAL("ideal"),
            KLARNA("klarna"),
            OXXO("oxxo"),
            P24("p24"),
            SEPA_DEBIT("sepa_debit"),
            SOFORT("sofort"),
            WECHAT_PAY("wechat_pay");

            private final String value;

            private Type(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class WechatPay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private WechatPay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public WechatPay build() {
                    return new WechatPay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Sofort {
            @SerializedName(value="country")
            Country country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Sofort(Country country, Map<String, Object> extraParams) {
                this.country = country;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Country getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static enum Country implements ApiRequestParams.EnumParam
            {
                AT("AT"),
                BE("BE"),
                DE("DE"),
                ES("ES"),
                IT("IT"),
                NL("NL");

                private final String value;

                private Country(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Country country;
                private Map<String, Object> extraParams;

                public Sofort build() {
                    return new Sofort(this.country, this.extraParams);
                }

                public Builder setCountry(Country country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class SepaDebit {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="iban")
            String iban;

            private SepaDebit(Map<String, Object> extraParams, String iban) {
                this.extraParams = extraParams;
                this.iban = iban;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getIban() {
                return this.iban;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private String iban;

                public SepaDebit build() {
                    return new SepaDebit(this.extraParams, this.iban);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setIban(String iban) {
                    this.iban = iban;
                    return this;
                }
            }
        }

        public static class P24 {
            @SerializedName(value="bank")
            Bank bank;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private P24(Bank bank, Map<String, Object> extraParams) {
                this.bank = bank;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Bank getBank() {
                return this.bank;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static enum Bank implements ApiRequestParams.EnumParam
            {
                ALIOR_BANK("alior_bank"),
                BANK_MILLENNIUM("bank_millennium"),
                BANK_NOWY_BFG_SA("bank_nowy_bfg_sa"),
                BANK_PEKAO_SA("bank_pekao_sa"),
                BANKI_SPBDZIELCZE("banki_spbdzielcze"),
                BLIK("blik"),
                BNP_PARIBAS("bnp_paribas"),
                BOZ("boz"),
                CITI_HANDLOWY("citi_handlowy"),
                CREDIT_AGRICOLE("credit_agricole"),
                ENVELOBANK("envelobank"),
                ETRANSFER_POCZTOWY24("etransfer_pocztowy24"),
                GETIN_BANK("getin_bank"),
                IDEABANK("ideabank"),
                ING("ing"),
                INTELIGO("inteligo"),
                MBANK_MTRANSFER("mbank_mtransfer"),
                NEST_PRZELEW("nest_przelew"),
                NOBLE_PAY("noble_pay"),
                PBAC_Z_IPKO("pbac_z_ipko"),
                PLUS_BANK("plus_bank"),
                SANTANDER_PRZELEW24("santander_przelew24"),
                TMOBILE_USBUGI_BANKOWE("tmobile_usbugi_bankowe"),
                TOYOTA_BANK("toyota_bank"),
                VOLKSWAGEN_BANK("volkswagen_bank");

                private final String value;

                private Bank(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Bank bank;
                private Map<String, Object> extraParams;

                public P24 build() {
                    return new P24(this.bank, this.extraParams);
                }

                public Builder setBank(Bank bank) {
                    this.bank = bank;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Oxxo {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Oxxo(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Oxxo build() {
                    return new Oxxo(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Klarna {
            @SerializedName(value="dob")
            Dob dob;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Klarna(Dob dob, Map<String, Object> extraParams) {
                this.dob = dob;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Dob getDob() {
                return this.dob;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Dob {
                @SerializedName(value="day")
                Long day;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="month")
                Long month;
                @SerializedName(value="year")
                Long year;

                private Dob(Long day, Map<String, Object> extraParams, Long month, Long year) {
                    this.day = day;
                    this.extraParams = extraParams;
                    this.month = month;
                    this.year = year;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Long getDay() {
                    return this.day;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Long getMonth() {
                    return this.month;
                }

                @Generated
                public Long getYear() {
                    return this.year;
                }

                public static class Builder {
                    private Long day;
                    private Map<String, Object> extraParams;
                    private Long month;
                    private Long year;

                    public Dob build() {
                        return new Dob(this.day, this.extraParams, this.month, this.year);
                    }

                    public Builder setDay(Long day) {
                        this.day = day;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMonth(Long month) {
                        this.month = month;
                        return this;
                    }

                    public Builder setYear(Long year) {
                        this.year = year;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Dob dob;
                private Map<String, Object> extraParams;

                public Klarna build() {
                    return new Klarna(this.dob, this.extraParams);
                }

                public Builder setDob(Dob dob) {
                    this.dob = dob;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class InteracPresent {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private InteracPresent(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public InteracPresent build() {
                    return new InteracPresent(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Ideal {
            @SerializedName(value="bank")
            Bank bank;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Ideal(Bank bank, Map<String, Object> extraParams) {
                this.bank = bank;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Bank getBank() {
                return this.bank;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static enum Bank implements ApiRequestParams.EnumParam
            {
                ABN_AMRO("abn_amro"),
                ASN_BANK("asn_bank"),
                BUNQ("bunq"),
                HANDELSBANKEN("handelsbanken"),
                ING("ing"),
                KNAB("knab"),
                MONEYOU("moneyou"),
                RABOBANK("rabobank"),
                REGIOBANK("regiobank"),
                REVOLUT("revolut"),
                SNS_BANK("sns_bank"),
                TRIODOS_BANK("triodos_bank"),
                VAN_LANSCHOT("van_lanschot");

                private final String value;

                private Bank(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Bank bank;
                private Map<String, Object> extraParams;

                public Ideal build() {
                    return new Ideal(this.bank, this.extraParams);
                }

                public Builder setBank(Bank bank) {
                    this.bank = bank;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Grabpay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Grabpay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Grabpay build() {
                    return new Grabpay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Giropay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Giropay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Giropay build() {
                    return new Giropay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Fpx {
            @SerializedName(value="account_holder_type")
            AccountHolderType accountHolderType;
            @SerializedName(value="bank")
            Bank bank;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Fpx(AccountHolderType accountHolderType, Bank bank, Map<String, Object> extraParams) {
                this.accountHolderType = accountHolderType;
                this.bank = bank;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public AccountHolderType getAccountHolderType() {
                return this.accountHolderType;
            }

            @Generated
            public Bank getBank() {
                return this.bank;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static enum Bank implements ApiRequestParams.EnumParam
            {
                AFFIN_BANK("affin_bank"),
                AGROBANK("agrobank"),
                ALLIANCE_BANK("alliance_bank"),
                AMBANK("ambank"),
                BANK_ISLAM("bank_islam"),
                BANK_MUAMALAT("bank_muamalat"),
                BANK_RAKYAT("bank_rakyat"),
                BSN("bsn"),
                CIMB("cimb"),
                DEUTSCHE_BANK("deutsche_bank"),
                HONG_LEONG_BANK("hong_leong_bank"),
                HSBC("hsbc"),
                KFH("kfh"),
                MAYBANK2E("maybank2e"),
                MAYBANK2U("maybank2u"),
                OCBC("ocbc"),
                PB_ENTERPRISE("pb_enterprise"),
                PUBLIC_BANK("public_bank"),
                RHB("rhb"),
                STANDARD_CHARTERED("standard_chartered"),
                UOB("uob");

                private final String value;

                private Bank(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum AccountHolderType implements ApiRequestParams.EnumParam
            {
                COMPANY("company"),
                INDIVIDUAL("individual");

                private final String value;

                private AccountHolderType(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private AccountHolderType accountHolderType;
                private Bank bank;
                private Map<String, Object> extraParams;

                public Fpx build() {
                    return new Fpx(this.accountHolderType, this.bank, this.extraParams);
                }

                public Builder setAccountHolderType(AccountHolderType accountHolderType) {
                    this.accountHolderType = accountHolderType;
                    return this;
                }

                public Builder setBank(Bank bank) {
                    this.bank = bank;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Eps {
            @SerializedName(value="bank")
            Bank bank;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Eps(Bank bank, Map<String, Object> extraParams) {
                this.bank = bank;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Bank getBank() {
                return this.bank;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static enum Bank implements ApiRequestParams.EnumParam
            {
                ARZTE_UND_APOTHEKER_BANK("arzte_und_apotheker_bank"),
                AUSTRIAN_ANADI_BANK_AG("austrian_anadi_bank_ag"),
                BANK_AUSTRIA("bank_austria"),
                BANKHAUS_CARL_SPANGLER("bankhaus_carl_spangler"),
                BANKHAUS_SCHELHAMMER_UND_SCHATTERA_AG("bankhaus_schelhammer_und_schattera_ag"),
                BAWAG_PSK_AG("bawag_psk_ag"),
                BKS_BANK_AG("bks_bank_ag"),
                BRULL_KALLMUS_BANK_AG("brull_kallmus_bank_ag"),
                BTV_VIER_LANDER_BANK("btv_vier_lander_bank"),
                CAPITAL_BANK_GRAWE_GRUPPE_AG("capital_bank_grawe_gruppe_ag"),
                DOLOMITENBANK("dolomitenbank"),
                EASYBANK_AG("easybank_ag"),
                ERSTE_BANK_UND_SPARKASSEN("erste_bank_und_sparkassen"),
                HYPO_ALPEADRIABANK_INTERNATIONAL_AG("hypo_alpeadriabank_international_ag"),
                HYPO_BANK_BURGENLAND_AKTIENGESELLSCHAFT("hypo_bank_burgenland_aktiengesellschaft"),
                HYPO_NOE_LB_FUR_NIEDEROSTERREICH_U_WIEN("hypo_noe_lb_fur_niederosterreich_u_wien"),
                HYPO_OBEROSTERREICH_SALZBURG_STEIERMARK("hypo_oberosterreich_salzburg_steiermark"),
                HYPO_TIROL_BANK_AG("hypo_tirol_bank_ag"),
                HYPO_VORARLBERG_BANK_AG("hypo_vorarlberg_bank_ag"),
                MARCHFELDER_BANK("marchfelder_bank"),
                OBERBANK_AG("oberbank_ag"),
                RAIFFEISEN_BANKENGRUPPE_OSTERREICH("raiffeisen_bankengruppe_osterreich"),
                SCHOELLERBANK_AG("schoellerbank_ag"),
                SPARDA_BANK_WIEN("sparda_bank_wien"),
                VOLKSBANK_GRUPPE("volksbank_gruppe"),
                VOLKSKREDITBANK_AG("volkskreditbank_ag"),
                VR_BANK_BRAUNAU("vr_bank_braunau");

                private final String value;

                private Bank(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Bank bank;
                private Map<String, Object> extraParams;

                public Eps build() {
                    return new Eps(this.bank, this.extraParams);
                }

                public Builder setBank(Bank bank) {
                    this.bank = bank;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Boleto {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="tax_id")
            String taxId;

            private Boleto(Map<String, Object> extraParams, String taxId) {
                this.extraParams = extraParams;
                this.taxId = taxId;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getTaxId() {
                return this.taxId;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private String taxId;

                public Boleto build() {
                    return new Boleto(this.extraParams, this.taxId);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setTaxId(String taxId) {
                    this.taxId = taxId;
                    return this;
                }
            }
        }

        public static class BillingDetails {
            @SerializedName(value="address")
            Object address;
            @SerializedName(value="email")
            Object email;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="name")
            String name;
            @SerializedName(value="phone")
            String phone;

            private BillingDetails(Object address, Object email, Map<String, Object> extraParams, String name, String phone) {
                this.address = address;
                this.email = email;
                this.extraParams = extraParams;
                this.name = name;
                this.phone = phone;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getAddress() {
                return this.address;
            }

            @Generated
            public Object getEmail() {
                return this.email;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getPhone() {
                return this.phone;
            }

            public static class Address {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                public static class Builder {
                    private String city;
                    private String country;
                    private Map<String, Object> extraParams;
                    private String line1;
                    private String line2;
                    private String postalCode;
                    private String state;

                    public Address build() {
                        return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Object address;
                private Object email;
                private Map<String, Object> extraParams;
                private String name;
                private String phone;

                public BillingDetails build() {
                    return new BillingDetails(this.address, this.email, this.extraParams, this.name, this.phone);
                }

                public Builder setAddress(Address address) {
                    this.address = address;
                    return this;
                }

                public Builder setAddress(EmptyParam address) {
                    this.address = address;
                    return this;
                }

                public Builder setEmail(String email) {
                    this.email = email;
                    return this;
                }

                public Builder setEmail(EmptyParam email) {
                    this.email = email;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setPhone(String phone) {
                    this.phone = phone;
                    return this;
                }
            }
        }

        public static class Bancontact {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Bancontact(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Bancontact build() {
                    return new Bancontact(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class BacsDebit {
            @SerializedName(value="account_number")
            String accountNumber;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="sort_code")
            String sortCode;

            private BacsDebit(String accountNumber, Map<String, Object> extraParams, String sortCode) {
                this.accountNumber = accountNumber;
                this.extraParams = extraParams;
                this.sortCode = sortCode;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getSortCode() {
                return this.sortCode;
            }

            public static class Builder {
                private String accountNumber;
                private Map<String, Object> extraParams;
                private String sortCode;

                public BacsDebit build() {
                    return new BacsDebit(this.accountNumber, this.extraParams, this.sortCode);
                }

                public Builder setAccountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSortCode(String sortCode) {
                    this.sortCode = sortCode;
                    return this;
                }
            }
        }

        public static class AuBecsDebit {
            @SerializedName(value="account_number")
            String accountNumber;
            @SerializedName(value="bsb_number")
            String bsbNumber;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private AuBecsDebit(String accountNumber, String bsbNumber, Map<String, Object> extraParams) {
                this.accountNumber = accountNumber;
                this.bsbNumber = bsbNumber;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public String getBsbNumber() {
                return this.bsbNumber;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private String accountNumber;
                private String bsbNumber;
                private Map<String, Object> extraParams;

                public AuBecsDebit build() {
                    return new AuBecsDebit(this.accountNumber, this.bsbNumber, this.extraParams);
                }

                public Builder setAccountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder setBsbNumber(String bsbNumber) {
                    this.bsbNumber = bsbNumber;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Alipay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Alipay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Alipay build() {
                    return new Alipay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class AfterpayClearpay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private AfterpayClearpay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public AfterpayClearpay build() {
                    return new AfterpayClearpay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class AcssDebit {
            @SerializedName(value="account_number")
            String accountNumber;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="institution_number")
            String institutionNumber;
            @SerializedName(value="transit_number")
            String transitNumber;

            private AcssDebit(String accountNumber, Map<String, Object> extraParams, String institutionNumber, String transitNumber) {
                this.accountNumber = accountNumber;
                this.extraParams = extraParams;
                this.institutionNumber = institutionNumber;
                this.transitNumber = transitNumber;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getInstitutionNumber() {
                return this.institutionNumber;
            }

            @Generated
            public String getTransitNumber() {
                return this.transitNumber;
            }

            public static class Builder {
                private String accountNumber;
                private Map<String, Object> extraParams;
                private String institutionNumber;
                private String transitNumber;

                public AcssDebit build() {
                    return new AcssDebit(this.accountNumber, this.extraParams, this.institutionNumber, this.transitNumber);
                }

                public Builder setAccountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setInstitutionNumber(String institutionNumber) {
                    this.institutionNumber = institutionNumber;
                    return this;
                }

                public Builder setTransitNumber(String transitNumber) {
                    this.transitNumber = transitNumber;
                    return this;
                }
            }
        }

        public static class Builder {
            private AcssDebit acssDebit;
            private AfterpayClearpay afterpayClearpay;
            private Alipay alipay;
            private AuBecsDebit auBecsDebit;
            private BacsDebit bacsDebit;
            private Bancontact bancontact;
            private BillingDetails billingDetails;
            private Boleto boleto;
            private Eps eps;
            private Map<String, Object> extraParams;
            private Fpx fpx;
            private Giropay giropay;
            private Grabpay grabpay;
            private Ideal ideal;
            private InteracPresent interacPresent;
            private Klarna klarna;
            private Map<String, String> metadata;
            private Oxxo oxxo;
            private P24 p24;
            private SepaDebit sepaDebit;
            private Sofort sofort;
            private Type type;
            private WechatPay wechatPay;

            public PaymentMethodData build() {
                return new PaymentMethodData(this.acssDebit, this.afterpayClearpay, this.alipay, this.auBecsDebit, this.bacsDebit, this.bancontact, this.billingDetails, this.boleto, this.eps, this.extraParams, this.fpx, this.giropay, this.grabpay, this.ideal, this.interacPresent, this.klarna, this.metadata, this.oxxo, this.p24, this.sepaDebit, this.sofort, this.type, this.wechatPay);
            }

            public Builder setAcssDebit(AcssDebit acssDebit) {
                this.acssDebit = acssDebit;
                return this;
            }

            public Builder setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
                this.afterpayClearpay = afterpayClearpay;
                return this;
            }

            public Builder setAlipay(Alipay alipay) {
                this.alipay = alipay;
                return this;
            }

            public Builder setAuBecsDebit(AuBecsDebit auBecsDebit) {
                this.auBecsDebit = auBecsDebit;
                return this;
            }

            public Builder setBacsDebit(BacsDebit bacsDebit) {
                this.bacsDebit = bacsDebit;
                return this;
            }

            public Builder setBancontact(Bancontact bancontact) {
                this.bancontact = bancontact;
                return this;
            }

            public Builder setBillingDetails(BillingDetails billingDetails) {
                this.billingDetails = billingDetails;
                return this;
            }

            public Builder setBoleto(Boleto boleto) {
                this.boleto = boleto;
                return this;
            }

            public Builder setEps(Eps eps) {
                this.eps = eps;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setFpx(Fpx fpx) {
                this.fpx = fpx;
                return this;
            }

            public Builder setGiropay(Giropay giropay) {
                this.giropay = giropay;
                return this;
            }

            public Builder setGrabpay(Grabpay grabpay) {
                this.grabpay = grabpay;
                return this;
            }

            public Builder setIdeal(Ideal ideal) {
                this.ideal = ideal;
                return this;
            }

            public Builder setInteracPresent(InteracPresent interacPresent) {
                this.interacPresent = interacPresent;
                return this;
            }

            public Builder setKlarna(Klarna klarna) {
                this.klarna = klarna;
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setOxxo(Oxxo oxxo) {
                this.oxxo = oxxo;
                return this;
            }

            public Builder setP24(P24 p24) {
                this.p24 = p24;
                return this;
            }

            public Builder setSepaDebit(SepaDebit sepaDebit) {
                this.sepaDebit = sepaDebit;
                return this;
            }

            public Builder setSofort(Sofort sofort) {
                this.sofort = sofort;
                return this;
            }

            public Builder setType(Type type) {
                this.type = type;
                return this;
            }

            public Builder setWechatPay(WechatPay wechatPay) {
                this.wechatPay = wechatPay;
                return this;
            }
        }
    }

    public static class MandateData {
        @SerializedName(value="customer_acceptance")
        CustomerAcceptance customerAcceptance;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private MandateData(CustomerAcceptance customerAcceptance, Map<String, Object> extraParams) {
            this.customerAcceptance = customerAcceptance;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public CustomerAcceptance getCustomerAcceptance() {
            return this.customerAcceptance;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class CustomerAcceptance {
            @SerializedName(value="accepted_at")
            Long acceptedAt;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="offline")
            Offline offline;
            @SerializedName(value="online")
            Online online;
            @SerializedName(value="type")
            Type type;

            private CustomerAcceptance(Long acceptedAt, Map<String, Object> extraParams, Offline offline, Online online, Type type) {
                this.acceptedAt = acceptedAt;
                this.extraParams = extraParams;
                this.offline = offline;
                this.online = online;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getAcceptedAt() {
                return this.acceptedAt;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Offline getOffline() {
                return this.offline;
            }

            @Generated
            public Online getOnline() {
                return this.online;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                OFFLINE("offline"),
                ONLINE("online");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Online {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="ip_address")
                String ipAddress;
                @SerializedName(value="user_agent")
                String userAgent;

                private Online(Map<String, Object> extraParams, String ipAddress, String userAgent) {
                    this.extraParams = extraParams;
                    this.ipAddress = ipAddress;
                    this.userAgent = userAgent;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getIpAddress() {
                    return this.ipAddress;
                }

                @Generated
                public String getUserAgent() {
                    return this.userAgent;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String ipAddress;
                    private String userAgent;

                    public Online build() {
                        return new Online(this.extraParams, this.ipAddress, this.userAgent);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setIpAddress(String ipAddress) {
                        this.ipAddress = ipAddress;
                        return this;
                    }

                    public Builder setUserAgent(String userAgent) {
                        this.userAgent = userAgent;
                        return this;
                    }
                }
            }

            public static class Offline {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private Offline(Map<String, Object> extraParams) {
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;

                    public Offline build() {
                        return new Offline(this.extraParams);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }

            public static class Builder {
                private Long acceptedAt;
                private Map<String, Object> extraParams;
                private Offline offline;
                private Online online;
                private Type type;

                public CustomerAcceptance build() {
                    return new CustomerAcceptance(this.acceptedAt, this.extraParams, this.offline, this.online, this.type);
                }

                public Builder setAcceptedAt(Long acceptedAt) {
                    this.acceptedAt = acceptedAt;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setOffline(Offline offline) {
                    this.offline = offline;
                    return this;
                }

                public Builder setOnline(Online online) {
                    this.online = online;
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }
            }
        }

        public static class Builder {
            private CustomerAcceptance customerAcceptance;
            private Map<String, Object> extraParams;

            public MandateData build() {
                return new MandateData(this.customerAcceptance, this.extraParams);
            }

            public Builder setCustomerAcceptance(CustomerAcceptance customerAcceptance) {
                this.customerAcceptance = customerAcceptance;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class Builder {
        private Boolean errorOnRequiresAction;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private String mandate;
        private Object mandateData;
        private Object offSession;
        private String paymentMethod;
        private PaymentMethodData paymentMethodData;
        private PaymentMethodOptions paymentMethodOptions;
        private Object receiptEmail;
        private String returnUrl;
        private ApiRequestParams.EnumParam setupFutureUsage;
        private Object shipping;
        private Boolean useStripeSdk;

        public PaymentIntentConfirmParams build() {
            return new PaymentIntentConfirmParams(this.errorOnRequiresAction, this.expand, this.extraParams, this.mandate, this.mandateData, this.offSession, this.paymentMethod, this.paymentMethodData, this.paymentMethodOptions, this.receiptEmail, this.returnUrl, this.setupFutureUsage, this.shipping, this.useStripeSdk);
        }

        public Builder setErrorOnRequiresAction(Boolean errorOnRequiresAction) {
            this.errorOnRequiresAction = errorOnRequiresAction;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setMandate(String mandate) {
            this.mandate = mandate;
            return this;
        }

        public Builder setMandateData(MandateData mandateData) {
            this.mandateData = mandateData;
            return this;
        }

        public Builder setOffSession(Boolean offSession) {
            this.offSession = offSession;
            return this;
        }

        public Builder setOffSession(OffSession offSession) {
            this.offSession = offSession;
            return this;
        }

        public Builder setPaymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder setPaymentMethodData(PaymentMethodData paymentMethodData) {
            this.paymentMethodData = paymentMethodData;
            return this;
        }

        public Builder setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
            this.paymentMethodOptions = paymentMethodOptions;
            return this;
        }

        public Builder setReceiptEmail(String receiptEmail) {
            this.receiptEmail = receiptEmail;
            return this;
        }

        public Builder setReceiptEmail(EmptyParam receiptEmail) {
            this.receiptEmail = receiptEmail;
            return this;
        }

        public Builder setReturnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
            return this;
        }

        public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
            return this;
        }

        public Builder setShipping(Shipping shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder setShipping(EmptyParam shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder setUseStripeSdk(Boolean useStripeSdk) {
            this.useStripeSdk = useStripeSdk;
            return this;
        }
    }
}

