// Generated by delombok at Wed Jan 12 17:15:35 EST 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.CapabilityUpdateParams;
import java.util.List;
import java.util.Map;

public class Capability extends ApiResource implements HasId {
  /**
   * The account for which the capability enables functionality.
   */
  @SerializedName("account")
  ExpandableField<Account> account;
  @SerializedName("future_requirements")
  FutureRequirements futureRequirements;
  /**
   * The identifier for the capability.
   */
  @SerializedName("id")
  String id;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code capability}.
   */
  @SerializedName("object")
  String object;
  /**
   * Whether the capability has been requested.
   */
  @SerializedName("requested")
  Boolean requested;
  /**
   * Time at which the capability was requested. Measured in seconds since the Unix epoch.
   */
  @SerializedName("requested_at")
  Long requestedAt;
  @SerializedName("requirements")
  Requirements requirements;
  /**
   * The status of the capability. Can be {@code active}, {@code inactive}, {@code pending}, or
   * {@code unrequested}.
   */
  @SerializedName("status")
  String status;

  /**
   * Get ID of expandable {@code account} object.
   */
  public String getAccount() {
    return (this.account != null) ? this.account.getId() : null;
  }

  public void setAccount(String id) {
    this.account = ApiResource.setExpandableFieldId(id, this.account);
  }

  /**
   * Get expanded {@code account}.
   */
  public Account getAccountObject() {
    return (this.account != null) ? this.account.getExpanded() : null;
  }

  public void setAccountObject(Account expandableObject) {
    this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
  }

  /**
   * Updates an existing Account Capability.
   */
  public Capability update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates an existing Account Capability.
   */
  public Capability update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/capabilities/%s", ApiResource.urlEncodeId(this.getAccount()), ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Capability.class, options);
  }

  /**
   * Updates an existing Account Capability.
   */
  public Capability update(CapabilityUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates an existing Account Capability.
   */
  public Capability update(CapabilityUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/capabilities/%s", ApiResource.urlEncodeId(this.getAccount()), ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Capability.class, options);
  }


  public static class FutureRequirements extends StripeObject {
    /**
     * Fields that are due and can be satisfied by providing the corresponding alternative fields
     * instead.
     */
    @SerializedName("alternatives")
    List<Capability.FutureRequirements.Alternative> alternatives;
    /**
     * Date on which {@code future_requirements} merges with the main {@code requirements} hash and
     * {@code future_requirements} becomes empty. After the transition, {@code currently_due}
     * requirements may immediately become {@code past_due}, but the account may also be given a
     * grace period depending on the capability's enablement state prior to transitioning.
     */
    @SerializedName("current_deadline")
    Long currentDeadline;
    /**
     * Fields that need to be collected to keep the capability enabled. If not collected by {@code
     * future_requirements[current_deadline]}, these fields will transition to the main {@code
     * requirements} hash.
     */
    @SerializedName("currently_due")
    List<String> currentlyDue;
    /**
     * This is typed as a string for consistency with {@code requirements.disabled_reason}, but it
     * safe to assume {@code future_requirements.disabled_reason} is empty because fields in {@code
     * future_requirements} will never disable the account.
     */
    @SerializedName("disabled_reason")
    String disabledReason;
    /**
     * Fields that are {@code currently_due} and need to be collected again because validation or
     * verification failed.
     */
    @SerializedName("errors")
    List<Capability.FutureRequirements.Errors> errors;
    /**
     * Fields that need to be collected assuming all volume thresholds are reached. As they become
     * required, they appear in {@code currently_due} as well.
     */
    @SerializedName("eventually_due")
    List<String> eventuallyDue;
    /**
     * Fields that weren't collected by {@code requirements.current_deadline}. These fields need to
     * be collected to enable the capability on the account. New fields will never appear here;
     * {@code future_requirements.past_due} will always be a subset of {@code
     * requirements.past_due}.
     */
    @SerializedName("past_due")
    List<String> pastDue;
    /**
     * Fields that may become required depending on the results of verification or review. Will be
     * an empty array unless an asynchronous verification is pending. If verification fails, these
     * fields move to {@code eventually_due} or {@code currently_due}.
     */
    @SerializedName("pending_verification")
    List<String> pendingVerification;


    public static class Alternative extends StripeObject {
      /**
       * Fields that can be provided to satisfy all fields in {@code original_fields_due}.
       */
      @SerializedName("alternative_fields_due")
      List<String> alternativeFieldsDue;
      /**
       * Fields that are due and can be satisfied by providing all fields in {@code
       * alternative_fields_due}.
       */
      @SerializedName("original_fields_due")
      List<String> originalFieldsDue;

      /**
       * Fields that can be provided to satisfy all fields in {@code original_fields_due}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getAlternativeFieldsDue() {
        return this.alternativeFieldsDue;
      }

      /**
       * Fields that are due and can be satisfied by providing all fields in {@code
       * alternative_fields_due}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getOriginalFieldsDue() {
        return this.originalFieldsDue;
      }

      /**
       * Fields that can be provided to satisfy all fields in {@code original_fields_due}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAlternativeFieldsDue(final List<String> alternativeFieldsDue) {
        this.alternativeFieldsDue = alternativeFieldsDue;
      }

      /**
       * Fields that are due and can be satisfied by providing all fields in {@code
       * alternative_fields_due}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setOriginalFieldsDue(final List<String> originalFieldsDue) {
        this.originalFieldsDue = originalFieldsDue;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Capability.FutureRequirements.Alternative)) return false;
        final Capability.FutureRequirements.Alternative other = (Capability.FutureRequirements.Alternative) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$alternativeFieldsDue = this.getAlternativeFieldsDue();
        final java.lang.Object other$alternativeFieldsDue = other.getAlternativeFieldsDue();
        if (this$alternativeFieldsDue == null ? other$alternativeFieldsDue != null : !this$alternativeFieldsDue.equals(other$alternativeFieldsDue)) return false;
        final java.lang.Object this$originalFieldsDue = this.getOriginalFieldsDue();
        final java.lang.Object other$originalFieldsDue = other.getOriginalFieldsDue();
        if (this$originalFieldsDue == null ? other$originalFieldsDue != null : !this$originalFieldsDue.equals(other$originalFieldsDue)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Capability.FutureRequirements.Alternative;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $alternativeFieldsDue = this.getAlternativeFieldsDue();
        result = result * PRIME + ($alternativeFieldsDue == null ? 43 : $alternativeFieldsDue.hashCode());
        final java.lang.Object $originalFieldsDue = this.getOriginalFieldsDue();
        result = result * PRIME + ($originalFieldsDue == null ? 43 : $originalFieldsDue.hashCode());
        return result;
      }
    }


    public static class Errors extends StripeObject {
      /**
       * The code for the type of error.
       *
       * <p>One of {@code invalid_address_city_state_postal_code}, {@code invalid_street_address},
       * {@code invalid_value_other}, {@code verification_document_address_mismatch}, {@code
       * verification_document_address_missing}, {@code verification_document_corrupt}, {@code
       * verification_document_country_not_supported}, {@code verification_document_dob_mismatch},
       * {@code verification_document_duplicate_type}, {@code verification_document_expired}, {@code
       * verification_document_failed_copy}, {@code verification_document_failed_greyscale}, {@code
       * verification_document_failed_other}, {@code verification_document_failed_test_mode}, {@code
       * verification_document_fraudulent}, {@code verification_document_id_number_mismatch}, {@code
       * verification_document_id_number_missing}, {@code verification_document_incomplete}, {@code
       * verification_document_invalid}, {@code verification_document_issue_or_expiry_date_missing},
       * {@code verification_document_manipulated}, {@code verification_document_missing_back},
       * {@code verification_document_missing_front}, {@code verification_document_name_mismatch},
       * {@code verification_document_name_missing}, {@code
       * verification_document_nationality_mismatch}, {@code verification_document_not_readable},
       * {@code verification_document_not_signed}, {@code verification_document_not_uploaded},
       * {@code verification_document_photo_mismatch}, {@code verification_document_too_large},
       * {@code verification_document_type_not_supported}, {@code
       * verification_failed_address_match}, {@code verification_failed_business_iec_number}, {@code
       * verification_failed_document_match}, {@code verification_failed_id_number_match}, {@code
       * verification_failed_keyed_identity}, {@code verification_failed_keyed_match}, {@code
       * verification_failed_name_match}, {@code verification_failed_other}, {@code
       * verification_failed_tax_id_match}, {@code verification_failed_tax_id_not_issued}, {@code
       * verification_missing_executives}, {@code verification_missing_owners}, or {@code
       * verification_requires_additional_memorandum_of_associations}.
       */
      @SerializedName("code")
      String code;
      /**
       * An informative message that indicates the error type and provides additional details about
       * the error.
       */
      @SerializedName("reason")
      String reason;
      @SerializedName("requirement")
      String requirement;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCode() {
        return this.code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getReason() {
        return this.reason;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRequirement() {
        return this.requirement;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCode(final String code) {
        this.code = code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReason(final String reason) {
        this.reason = reason;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequirement(final String requirement) {
        this.requirement = requirement;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Capability.FutureRequirements.Errors)) return false;
        final Capability.FutureRequirements.Errors other = (Capability.FutureRequirements.Errors) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$code = this.getCode();
        final java.lang.Object other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
        final java.lang.Object this$reason = this.getReason();
        final java.lang.Object other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
        final java.lang.Object this$requirement = this.getRequirement();
        final java.lang.Object other$requirement = other.getRequirement();
        if (this$requirement == null ? other$requirement != null : !this$requirement.equals(other$requirement)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Capability.FutureRequirements.Errors;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $code = this.getCode();
        result = result * PRIME + ($code == null ? 43 : $code.hashCode());
        final java.lang.Object $reason = this.getReason();
        result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
        final java.lang.Object $requirement = this.getRequirement();
        result = result * PRIME + ($requirement == null ? 43 : $requirement.hashCode());
        return result;
      }
    }

    /**
     * Fields that are due and can be satisfied by providing the corresponding alternative fields
     * instead.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Capability.FutureRequirements.Alternative> getAlternatives() {
      return this.alternatives;
    }

    /**
     * Date on which {@code future_requirements} merges with the main {@code requirements} hash and
     * {@code future_requirements} becomes empty. After the transition, {@code currently_due}
     * requirements may immediately become {@code past_due}, but the account may also be given a
     * grace period depending on the capability's enablement state prior to transitioning.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCurrentDeadline() {
      return this.currentDeadline;
    }

    /**
     * Fields that need to be collected to keep the capability enabled. If not collected by {@code
     * future_requirements[current_deadline]}, these fields will transition to the main {@code
     * requirements} hash.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getCurrentlyDue() {
      return this.currentlyDue;
    }

    /**
     * This is typed as a string for consistency with {@code requirements.disabled_reason}, but it
     * safe to assume {@code future_requirements.disabled_reason} is empty because fields in {@code
     * future_requirements} will never disable the account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisabledReason() {
      return this.disabledReason;
    }

    /**
     * Fields that are {@code currently_due} and need to be collected again because validation or
     * verification failed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Capability.FutureRequirements.Errors> getErrors() {
      return this.errors;
    }

    /**
     * Fields that need to be collected assuming all volume thresholds are reached. As they become
     * required, they appear in {@code currently_due} as well.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getEventuallyDue() {
      return this.eventuallyDue;
    }

    /**
     * Fields that weren't collected by {@code requirements.current_deadline}. These fields need to
     * be collected to enable the capability on the account. New fields will never appear here;
     * {@code future_requirements.past_due} will always be a subset of {@code
     * requirements.past_due}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getPastDue() {
      return this.pastDue;
    }

    /**
     * Fields that may become required depending on the results of verification or review. Will be
     * an empty array unless an asynchronous verification is pending. If verification fails, these
     * fields move to {@code eventually_due} or {@code currently_due}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getPendingVerification() {
      return this.pendingVerification;
    }

    /**
     * Fields that are due and can be satisfied by providing the corresponding alternative fields
     * instead.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAlternatives(final List<Capability.FutureRequirements.Alternative> alternatives) {
      this.alternatives = alternatives;
    }

    /**
     * Date on which {@code future_requirements} merges with the main {@code requirements} hash and
     * {@code future_requirements} becomes empty. After the transition, {@code currently_due}
     * requirements may immediately become {@code past_due}, but the account may also be given a
     * grace period depending on the capability's enablement state prior to transitioning.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrentDeadline(final Long currentDeadline) {
      this.currentDeadline = currentDeadline;
    }

    /**
     * Fields that need to be collected to keep the capability enabled. If not collected by {@code
     * future_requirements[current_deadline]}, these fields will transition to the main {@code
     * requirements} hash.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrentlyDue(final List<String> currentlyDue) {
      this.currentlyDue = currentlyDue;
    }

    /**
     * This is typed as a string for consistency with {@code requirements.disabled_reason}, but it
     * safe to assume {@code future_requirements.disabled_reason} is empty because fields in {@code
     * future_requirements} will never disable the account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisabledReason(final String disabledReason) {
      this.disabledReason = disabledReason;
    }

    /**
     * Fields that are {@code currently_due} and need to be collected again because validation or
     * verification failed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setErrors(final List<Capability.FutureRequirements.Errors> errors) {
      this.errors = errors;
    }

    /**
     * Fields that need to be collected assuming all volume thresholds are reached. As they become
     * required, they appear in {@code currently_due} as well.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEventuallyDue(final List<String> eventuallyDue) {
      this.eventuallyDue = eventuallyDue;
    }

    /**
     * Fields that weren't collected by {@code requirements.current_deadline}. These fields need to
     * be collected to enable the capability on the account. New fields will never appear here;
     * {@code future_requirements.past_due} will always be a subset of {@code
     * requirements.past_due}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPastDue(final List<String> pastDue) {
      this.pastDue = pastDue;
    }

    /**
     * Fields that may become required depending on the results of verification or review. Will be
     * an empty array unless an asynchronous verification is pending. If verification fails, these
     * fields move to {@code eventually_due} or {@code currently_due}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPendingVerification(final List<String> pendingVerification) {
      this.pendingVerification = pendingVerification;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Capability.FutureRequirements)) return false;
      final Capability.FutureRequirements other = (Capability.FutureRequirements) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$currentDeadline = this.getCurrentDeadline();
      final java.lang.Object other$currentDeadline = other.getCurrentDeadline();
      if (this$currentDeadline == null ? other$currentDeadline != null : !this$currentDeadline.equals(other$currentDeadline)) return false;
      final java.lang.Object this$alternatives = this.getAlternatives();
      final java.lang.Object other$alternatives = other.getAlternatives();
      if (this$alternatives == null ? other$alternatives != null : !this$alternatives.equals(other$alternatives)) return false;
      final java.lang.Object this$currentlyDue = this.getCurrentlyDue();
      final java.lang.Object other$currentlyDue = other.getCurrentlyDue();
      if (this$currentlyDue == null ? other$currentlyDue != null : !this$currentlyDue.equals(other$currentlyDue)) return false;
      final java.lang.Object this$disabledReason = this.getDisabledReason();
      final java.lang.Object other$disabledReason = other.getDisabledReason();
      if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) return false;
      final java.lang.Object this$errors = this.getErrors();
      final java.lang.Object other$errors = other.getErrors();
      if (this$errors == null ? other$errors != null : !this$errors.equals(other$errors)) return false;
      final java.lang.Object this$eventuallyDue = this.getEventuallyDue();
      final java.lang.Object other$eventuallyDue = other.getEventuallyDue();
      if (this$eventuallyDue == null ? other$eventuallyDue != null : !this$eventuallyDue.equals(other$eventuallyDue)) return false;
      final java.lang.Object this$pastDue = this.getPastDue();
      final java.lang.Object other$pastDue = other.getPastDue();
      if (this$pastDue == null ? other$pastDue != null : !this$pastDue.equals(other$pastDue)) return false;
      final java.lang.Object this$pendingVerification = this.getPendingVerification();
      final java.lang.Object other$pendingVerification = other.getPendingVerification();
      if (this$pendingVerification == null ? other$pendingVerification != null : !this$pendingVerification.equals(other$pendingVerification)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Capability.FutureRequirements;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $currentDeadline = this.getCurrentDeadline();
      result = result * PRIME + ($currentDeadline == null ? 43 : $currentDeadline.hashCode());
      final java.lang.Object $alternatives = this.getAlternatives();
      result = result * PRIME + ($alternatives == null ? 43 : $alternatives.hashCode());
      final java.lang.Object $currentlyDue = this.getCurrentlyDue();
      result = result * PRIME + ($currentlyDue == null ? 43 : $currentlyDue.hashCode());
      final java.lang.Object $disabledReason = this.getDisabledReason();
      result = result * PRIME + ($disabledReason == null ? 43 : $disabledReason.hashCode());
      final java.lang.Object $errors = this.getErrors();
      result = result * PRIME + ($errors == null ? 43 : $errors.hashCode());
      final java.lang.Object $eventuallyDue = this.getEventuallyDue();
      result = result * PRIME + ($eventuallyDue == null ? 43 : $eventuallyDue.hashCode());
      final java.lang.Object $pastDue = this.getPastDue();
      result = result * PRIME + ($pastDue == null ? 43 : $pastDue.hashCode());
      final java.lang.Object $pendingVerification = this.getPendingVerification();
      result = result * PRIME + ($pendingVerification == null ? 43 : $pendingVerification.hashCode());
      return result;
    }
  }


  /**
   * The specific user onboarding requirement field (in the requirements hash) that needs to be
   * resolved.
   */
  public static class Requirements extends StripeObject {
    /**
     * Fields that are due and can be satisfied by providing the corresponding alternative fields
     * instead.
     */
    @SerializedName("alternatives")
    List<Capability.Requirements.Alternative> alternatives;
    /**
     * Date by which the fields in {@code currently_due} must be collected to keep the capability
     * enabled for the account. These fields may disable the capability sooner if the next threshold
     * is reached before they are collected.
     */
    @SerializedName("current_deadline")
    Long currentDeadline;
    /**
     * Fields that need to be collected to keep the capability enabled. If not collected by {@code
     * current_deadline}, these fields appear in {@code past_due} as well, and the capability is
     * disabled.
     */
    @SerializedName("currently_due")
    List<String> currentlyDue;
    /**
     * If the capability is disabled, this string describes why. Can be {@code
     * requirements.past_due}, {@code requirements.pending_verification}, {@code listed}, {@code
     * platform_paused}, {@code rejected.fraud}, {@code rejected.listed}, {@code
     * rejected.terms_of_service}, {@code rejected.other}, {@code under_review}, or {@code other}.
     *
     * <p>{@code rejected.unsupported_business} means that the account's business is not supported
     * by the capability. For example, payment methods may restrict the businesses they support in
     * their terms of service:
     *
     * <p>- <a href="https://stripe.com/afterpay-clearpay/legal#restricted-businesses">Afterpay
     * Clearpay's terms of service</a>
     *
     * <p>If you believe that the rejection is in error, please contact support at
     * https://support.stripe.com/contact/ for assistance.
     */
    @SerializedName("disabled_reason")
    String disabledReason;
    /**
     * Fields that are {@code currently_due} and need to be collected again because validation or
     * verification failed.
     */
    @SerializedName("errors")
    List<Account.Requirements.Errors> errors;
    /**
     * Fields that need to be collected assuming all volume thresholds are reached. As they become
     * required, they appear in {@code currently_due} as well, and {@code current_deadline} becomes
     * set.
     */
    @SerializedName("eventually_due")
    List<String> eventuallyDue;
    /**
     * Fields that weren't collected by {@code current_deadline}. These fields need to be collected
     * to enable the capability on the account.
     */
    @SerializedName("past_due")
    List<String> pastDue;
    /**
     * Fields that may become required depending on the results of verification or review. Will be
     * an empty array unless an asynchronous verification is pending. If verification fails, these
     * fields move to {@code eventually_due}, {@code currently_due}, or {@code past_due}.
     */
    @SerializedName("pending_verification")
    List<String> pendingVerification;


    public static class Alternative extends StripeObject {
      /** Fields that can be provided to satisfy all fields in {@code original_fields_due}. */
      @SerializedName("alternative_fields_due")
      List<String> alternativeFieldsDue;
      /**
       * Fields that are due and can be satisfied by providing all fields in {@code
       * alternative_fields_due}.
       */
      @SerializedName("original_fields_due")
      List<String> originalFieldsDue;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getAlternativeFieldsDue() {
        return this.alternativeFieldsDue;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getOriginalFieldsDue() {
        return this.originalFieldsDue;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAlternativeFieldsDue(final List<String> alternativeFieldsDue) {
        this.alternativeFieldsDue = alternativeFieldsDue;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setOriginalFieldsDue(final List<String> originalFieldsDue) {
        this.originalFieldsDue = originalFieldsDue;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Capability.Requirements.Alternative)) return false;
        final Capability.Requirements.Alternative other = (Capability.Requirements.Alternative) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$alternativeFieldsDue = this.getAlternativeFieldsDue();
        final java.lang.Object other$alternativeFieldsDue = other.getAlternativeFieldsDue();
        if (this$alternativeFieldsDue == null ? other$alternativeFieldsDue != null : !this$alternativeFieldsDue.equals(other$alternativeFieldsDue)) return false;
        final java.lang.Object this$originalFieldsDue = this.getOriginalFieldsDue();
        final java.lang.Object other$originalFieldsDue = other.getOriginalFieldsDue();
        if (this$originalFieldsDue == null ? other$originalFieldsDue != null : !this$originalFieldsDue.equals(other$originalFieldsDue)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Capability.Requirements.Alternative;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $alternativeFieldsDue = this.getAlternativeFieldsDue();
        result = result * PRIME + ($alternativeFieldsDue == null ? 43 : $alternativeFieldsDue.hashCode());
        final java.lang.Object $originalFieldsDue = this.getOriginalFieldsDue();
        result = result * PRIME + ($originalFieldsDue == null ? 43 : $originalFieldsDue.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Capability.Requirements.Alternative> getAlternatives() {
      return this.alternatives;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCurrentDeadline() {
      return this.currentDeadline;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getCurrentlyDue() {
      return this.currentlyDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisabledReason() {
      return this.disabledReason;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Account.Requirements.Errors> getErrors() {
      return this.errors;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getEventuallyDue() {
      return this.eventuallyDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getPastDue() {
      return this.pastDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getPendingVerification() {
      return this.pendingVerification;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAlternatives(final List<Capability.Requirements.Alternative> alternatives) {
      this.alternatives = alternatives;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrentDeadline(final Long currentDeadline) {
      this.currentDeadline = currentDeadline;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrentlyDue(final List<String> currentlyDue) {
      this.currentlyDue = currentlyDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisabledReason(final String disabledReason) {
      this.disabledReason = disabledReason;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setErrors(final List<Account.Requirements.Errors> errors) {
      this.errors = errors;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEventuallyDue(final List<String> eventuallyDue) {
      this.eventuallyDue = eventuallyDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPastDue(final List<String> pastDue) {
      this.pastDue = pastDue;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPendingVerification(final List<String> pendingVerification) {
      this.pendingVerification = pendingVerification;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Capability.Requirements)) return false;
      final Capability.Requirements other = (Capability.Requirements) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$currentDeadline = this.getCurrentDeadline();
      final java.lang.Object other$currentDeadline = other.getCurrentDeadline();
      if (this$currentDeadline == null ? other$currentDeadline != null : !this$currentDeadline.equals(other$currentDeadline)) return false;
      final java.lang.Object this$alternatives = this.getAlternatives();
      final java.lang.Object other$alternatives = other.getAlternatives();
      if (this$alternatives == null ? other$alternatives != null : !this$alternatives.equals(other$alternatives)) return false;
      final java.lang.Object this$currentlyDue = this.getCurrentlyDue();
      final java.lang.Object other$currentlyDue = other.getCurrentlyDue();
      if (this$currentlyDue == null ? other$currentlyDue != null : !this$currentlyDue.equals(other$currentlyDue)) return false;
      final java.lang.Object this$disabledReason = this.getDisabledReason();
      final java.lang.Object other$disabledReason = other.getDisabledReason();
      if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) return false;
      final java.lang.Object this$errors = this.getErrors();
      final java.lang.Object other$errors = other.getErrors();
      if (this$errors == null ? other$errors != null : !this$errors.equals(other$errors)) return false;
      final java.lang.Object this$eventuallyDue = this.getEventuallyDue();
      final java.lang.Object other$eventuallyDue = other.getEventuallyDue();
      if (this$eventuallyDue == null ? other$eventuallyDue != null : !this$eventuallyDue.equals(other$eventuallyDue)) return false;
      final java.lang.Object this$pastDue = this.getPastDue();
      final java.lang.Object other$pastDue = other.getPastDue();
      if (this$pastDue == null ? other$pastDue != null : !this$pastDue.equals(other$pastDue)) return false;
      final java.lang.Object this$pendingVerification = this.getPendingVerification();
      final java.lang.Object other$pendingVerification = other.getPendingVerification();
      if (this$pendingVerification == null ? other$pendingVerification != null : !this$pendingVerification.equals(other$pendingVerification)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Capability.Requirements;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $currentDeadline = this.getCurrentDeadline();
      result = result * PRIME + ($currentDeadline == null ? 43 : $currentDeadline.hashCode());
      final java.lang.Object $alternatives = this.getAlternatives();
      result = result * PRIME + ($alternatives == null ? 43 : $alternatives.hashCode());
      final java.lang.Object $currentlyDue = this.getCurrentlyDue();
      result = result * PRIME + ($currentlyDue == null ? 43 : $currentlyDue.hashCode());
      final java.lang.Object $disabledReason = this.getDisabledReason();
      result = result * PRIME + ($disabledReason == null ? 43 : $disabledReason.hashCode());
      final java.lang.Object $errors = this.getErrors();
      result = result * PRIME + ($errors == null ? 43 : $errors.hashCode());
      final java.lang.Object $eventuallyDue = this.getEventuallyDue();
      result = result * PRIME + ($eventuallyDue == null ? 43 : $eventuallyDue.hashCode());
      final java.lang.Object $pastDue = this.getPastDue();
      result = result * PRIME + ($pastDue == null ? 43 : $pastDue.hashCode());
      final java.lang.Object $pendingVerification = this.getPendingVerification();
      result = result * PRIME + ($pendingVerification == null ? 43 : $pendingVerification.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public FutureRequirements getFutureRequirements() {
    return this.futureRequirements;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code capability}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Whether the capability has been requested.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getRequested() {
    return this.requested;
  }

  /**
   * Time at which the capability was requested. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getRequestedAt() {
    return this.requestedAt;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Requirements getRequirements() {
    return this.requirements;
  }

  /**
   * The status of the capability. Can be {@code active}, {@code inactive}, {@code pending}, or
   * {@code unrequested}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFutureRequirements(final FutureRequirements futureRequirements) {
    this.futureRequirements = futureRequirements;
  }

  /**
   * The identifier for the capability.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code capability}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Whether the capability has been requested.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRequested(final Boolean requested) {
    this.requested = requested;
  }

  /**
   * Time at which the capability was requested. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRequestedAt(final Long requestedAt) {
    this.requestedAt = requestedAt;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRequirements(final Requirements requirements) {
    this.requirements = requirements;
  }

  /**
   * The status of the capability. Can be {@code active}, {@code inactive}, {@code pending}, or
   * {@code unrequested}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Capability)) return false;
    final Capability other = (Capability) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$requested = this.getRequested();
    final java.lang.Object other$requested = other.getRequested();
    if (this$requested == null ? other$requested != null : !this$requested.equals(other$requested)) return false;
    final java.lang.Object this$requestedAt = this.getRequestedAt();
    final java.lang.Object other$requestedAt = other.getRequestedAt();
    if (this$requestedAt == null ? other$requestedAt != null : !this$requestedAt.equals(other$requestedAt)) return false;
    final java.lang.Object this$account = this.getAccount();
    final java.lang.Object other$account = other.getAccount();
    if (this$account == null ? other$account != null : !this$account.equals(other$account)) return false;
    final java.lang.Object this$futureRequirements = this.getFutureRequirements();
    final java.lang.Object other$futureRequirements = other.getFutureRequirements();
    if (this$futureRequirements == null ? other$futureRequirements != null : !this$futureRequirements.equals(other$futureRequirements)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$requirements = this.getRequirements();
    final java.lang.Object other$requirements = other.getRequirements();
    if (this$requirements == null ? other$requirements != null : !this$requirements.equals(other$requirements)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Capability;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $requested = this.getRequested();
    result = result * PRIME + ($requested == null ? 43 : $requested.hashCode());
    final java.lang.Object $requestedAt = this.getRequestedAt();
    result = result * PRIME + ($requestedAt == null ? 43 : $requestedAt.hashCode());
    final java.lang.Object $account = this.getAccount();
    result = result * PRIME + ($account == null ? 43 : $account.hashCode());
    final java.lang.Object $futureRequirements = this.getFutureRequirements();
    result = result * PRIME + ($futureRequirements == null ? 43 : $futureRequirements.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $requirements = this.getRequirements();
    result = result * PRIME + ($requirements == null ? 43 : $requirements.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    return result;
  }

  /**
   * The identifier for the capability.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
