// Generated by delombok at Tue Jan 25 14:46:56 EST 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.ReviewApproveParams;
import com.stripe.param.ReviewListParams;
import com.stripe.param.ReviewRetrieveParams;
import java.math.BigDecimal;
import java.util.Map;

public class Review extends ApiResource implements HasId {
  /**
   * The ZIP or postal code of the card used, if applicable.
   */
  @SerializedName("billing_zip")
  String billingZip;
  /**
   * The charge associated with this review.
   */
  @SerializedName("charge")
  ExpandableField<Charge> charge;
  /**
   * The reason the review was closed, or null if it has not yet been closed. One of {@code
   * approved}, {@code refunded}, {@code refunded_as_fraud}, {@code disputed}, or {@code redacted}.
   */
  @SerializedName("closed_reason")
  String closedReason;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * The IP address where the payment originated.
   */
  @SerializedName("ip_address")
  String ipAddress;
  /**
   * Information related to the location of the payment. Note that this information is an
   * approximation and attempts to locate the nearest population center - it should not be used to
   * determine a specific address.
   */
  @SerializedName("ip_address_location")
  Location ipAddressLocation;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code review}.
   */
  @SerializedName("object")
  String object;
  /**
   * If {@code true}, the review needs action.
   */
  @SerializedName("open")
  Boolean open;
  /**
   * The reason the review was opened. One of {@code rule} or {@code manual}.
   */
  @SerializedName("opened_reason")
  String openedReason;
  /**
   * The PaymentIntent ID associated with this review, if one exists.
   */
  @SerializedName("payment_intent")
  ExpandableField<PaymentIntent> paymentIntent;
  /**
   * The reason the review is currently open or closed. One of {@code rule}, {@code manual}, {@code
   * approved}, {@code refunded}, {@code refunded_as_fraud}, {@code disputed}, or {@code redacted}.
   */
  @SerializedName("reason")
  String reason;
  /**
   * Information related to the browsing session of the user who initiated the payment.
   */
  @SerializedName("session")
  Session session;

  /**
   * Get ID of expandable {@code charge} object.
   */
  public String getCharge() {
    return (this.charge != null) ? this.charge.getId() : null;
  }

  public void setCharge(String id) {
    this.charge = ApiResource.setExpandableFieldId(id, this.charge);
  }

  /**
   * Get expanded {@code charge}.
   */
  public Charge getChargeObject() {
    return (this.charge != null) ? this.charge.getExpanded() : null;
  }

  public void setChargeObject(Charge expandableObject) {
    this.charge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code paymentIntent} object.
   */
  public String getPaymentIntent() {
    return (this.paymentIntent != null) ? this.paymentIntent.getId() : null;
  }

  public void setPaymentIntent(String id) {
    this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
  }

  /**
   * Get expanded {@code paymentIntent}.
   */
  public PaymentIntent getPaymentIntentObject() {
    return (this.paymentIntent != null) ? this.paymentIntent.getExpanded() : null;
  }

  public void setPaymentIntentObject(PaymentIntent expandableObject) {
    this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
  }

  /**
   * Returns a list of <code>Review</code> objects that have <code>open</code> set to <code>true
   * </code>. The objects are sorted in descending order by creation date, with the most recently
   * created object appearing first.
   */
  public static ReviewCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of <code>Review</code> objects that have <code>open</code> set to <code>true
   * </code>. The objects are sorted in descending order by creation date, with the most recently
   * created object appearing first.
   */
  public static ReviewCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/reviews");
    return ApiResource.requestCollection(url, params, ReviewCollection.class, options);
  }

  /**
   * Returns a list of <code>Review</code> objects that have <code>open</code> set to <code>true
   * </code>. The objects are sorted in descending order by creation date, with the most recently
   * created object appearing first.
   */
  public static ReviewCollection list(ReviewListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of <code>Review</code> objects that have <code>open</code> set to <code>true
   * </code>. The objects are sorted in descending order by creation date, with the most recently
   * created object appearing first.
   */
  public static ReviewCollection list(ReviewListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/reviews");
    return ApiResource.requestCollection(url, params, ReviewCollection.class, options);
  }

  /**
   * Retrieves a <code>Review</code> object.
   */
  public static Review retrieve(String review) throws StripeException {
    return retrieve(review, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves a <code>Review</code> object.
   */
  public static Review retrieve(String review, RequestOptions options) throws StripeException {
    return retrieve(review, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves a <code>Review</code> object.
   */
  public static Review retrieve(String review, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/reviews/%s", ApiResource.urlEncodeId(review)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Review.class, options);
  }

  /**
   * Retrieves a <code>Review</code> object.
   */
  public static Review retrieve(String review, ReviewRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/reviews/%s", ApiResource.urlEncodeId(review)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Review.class, options);
  }

  /**
   * Approves a <code>Review</code> object, closing it and removing it from the list of reviews.
   */
  public Review approve() throws StripeException {
    return approve((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Approves a <code>Review</code> object, closing it and removing it from the list of reviews.
   */
  public Review approve(RequestOptions options) throws StripeException {
    return approve((Map<String, Object>) null, options);
  }

  /**
   * Approves a <code>Review</code> object, closing it and removing it from the list of reviews.
   */
  public Review approve(Map<String, Object> params) throws StripeException {
    return approve(params, (RequestOptions) null);
  }

  /**
   * Approves a <code>Review</code> object, closing it and removing it from the list of reviews.
   */
  public Review approve(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/reviews/%s/approve", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Review.class, options);
  }

  /**
   * Approves a <code>Review</code> object, closing it and removing it from the list of reviews.
   */
  public Review approve(ReviewApproveParams params) throws StripeException {
    return approve(params, (RequestOptions) null);
  }

  /**
   * Approves a <code>Review</code> object, closing it and removing it from the list of reviews.
   */
  public Review approve(ReviewApproveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/reviews/%s/approve", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Review.class, options);
  }


  public static class Location extends StripeObject {
    /**
     * The city where the payment originated.
     */
    @SerializedName("city")
    String city;
    /**
     * Two-letter ISO code representing the country where the payment originated.
     */
    @SerializedName("country")
    String country;
    /**
     * The geographic latitude where the payment originated.
     */
    @SerializedName("latitude")
    BigDecimal latitude;
    /**
     * The geographic longitude where the payment originated.
     */
    @SerializedName("longitude")
    BigDecimal longitude;
    /**
     * The state/county/province/region where the payment originated.
     */
    @SerializedName("region")
    String region;

    /**
     * The city where the payment originated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCity() {
      return this.city;
    }

    /**
     * Two-letter ISO code representing the country where the payment originated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCountry() {
      return this.country;
    }

    /**
     * The geographic latitude where the payment originated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BigDecimal getLatitude() {
      return this.latitude;
    }

    /**
     * The geographic longitude where the payment originated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BigDecimal getLongitude() {
      return this.longitude;
    }

    /**
     * The state/county/province/region where the payment originated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRegion() {
      return this.region;
    }

    /**
     * The city where the payment originated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCity(final String city) {
      this.city = city;
    }

    /**
     * Two-letter ISO code representing the country where the payment originated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCountry(final String country) {
      this.country = country;
    }

    /**
     * The geographic latitude where the payment originated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLatitude(final BigDecimal latitude) {
      this.latitude = latitude;
    }

    /**
     * The geographic longitude where the payment originated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLongitude(final BigDecimal longitude) {
      this.longitude = longitude;
    }

    /**
     * The state/county/province/region where the payment originated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRegion(final String region) {
      this.region = region;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Review.Location)) return false;
      final Review.Location other = (Review.Location) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$city = this.getCity();
      final java.lang.Object other$city = other.getCity();
      if (this$city == null ? other$city != null : !this$city.equals(other$city)) return false;
      final java.lang.Object this$country = this.getCountry();
      final java.lang.Object other$country = other.getCountry();
      if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
      final java.lang.Object this$latitude = this.getLatitude();
      final java.lang.Object other$latitude = other.getLatitude();
      if (this$latitude == null ? other$latitude != null : !this$latitude.equals(other$latitude)) return false;
      final java.lang.Object this$longitude = this.getLongitude();
      final java.lang.Object other$longitude = other.getLongitude();
      if (this$longitude == null ? other$longitude != null : !this$longitude.equals(other$longitude)) return false;
      final java.lang.Object this$region = this.getRegion();
      final java.lang.Object other$region = other.getRegion();
      if (this$region == null ? other$region != null : !this$region.equals(other$region)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Review.Location;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $city = this.getCity();
      result = result * PRIME + ($city == null ? 43 : $city.hashCode());
      final java.lang.Object $country = this.getCountry();
      result = result * PRIME + ($country == null ? 43 : $country.hashCode());
      final java.lang.Object $latitude = this.getLatitude();
      result = result * PRIME + ($latitude == null ? 43 : $latitude.hashCode());
      final java.lang.Object $longitude = this.getLongitude();
      result = result * PRIME + ($longitude == null ? 43 : $longitude.hashCode());
      final java.lang.Object $region = this.getRegion();
      result = result * PRIME + ($region == null ? 43 : $region.hashCode());
      return result;
    }
  }


  public static class Session extends StripeObject {
    /** The browser used in this browser session (e.g., {@code Chrome}). */
    @SerializedName("browser")
    String browser;
    /**
     * Information about the device used for the browser session (e.g., {@code Samsung SM-G930T}).
     */
    @SerializedName("device")
    String device;
    /** The platform for the browser session (e.g., {@code Macintosh}). */
    @SerializedName("platform")
    String platform;
    /** The version for the browser session (e.g., {@code 61.0.3163.100}). */
    @SerializedName("version")
    String version;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBrowser() {
      return this.browser;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDevice() {
      return this.device;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPlatform() {
      return this.platform;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getVersion() {
      return this.version;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBrowser(final String browser) {
      this.browser = browser;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDevice(final String device) {
      this.device = device;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPlatform(final String platform) {
      this.platform = platform;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVersion(final String version) {
      this.version = version;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Review.Session)) return false;
      final Review.Session other = (Review.Session) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$browser = this.getBrowser();
      final java.lang.Object other$browser = other.getBrowser();
      if (this$browser == null ? other$browser != null : !this$browser.equals(other$browser)) return false;
      final java.lang.Object this$device = this.getDevice();
      final java.lang.Object other$device = other.getDevice();
      if (this$device == null ? other$device != null : !this$device.equals(other$device)) return false;
      final java.lang.Object this$platform = this.getPlatform();
      final java.lang.Object other$platform = other.getPlatform();
      if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) return false;
      final java.lang.Object this$version = this.getVersion();
      final java.lang.Object other$version = other.getVersion();
      if (this$version == null ? other$version != null : !this$version.equals(other$version)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Review.Session;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $browser = this.getBrowser();
      result = result * PRIME + ($browser == null ? 43 : $browser.hashCode());
      final java.lang.Object $device = this.getDevice();
      result = result * PRIME + ($device == null ? 43 : $device.hashCode());
      final java.lang.Object $platform = this.getPlatform();
      result = result * PRIME + ($platform == null ? 43 : $platform.hashCode());
      final java.lang.Object $version = this.getVersion();
      result = result * PRIME + ($version == null ? 43 : $version.hashCode());
      return result;
    }
  }

  /**
   * The ZIP or postal code of the card used, if applicable.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBillingZip() {
    return this.billingZip;
  }

  /**
   * The reason the review was closed, or null if it has not yet been closed. One of {@code
   * approved}, {@code refunded}, {@code refunded_as_fraud}, {@code disputed}, or {@code redacted}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getClosedReason() {
    return this.closedReason;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * The IP address where the payment originated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getIpAddress() {
    return this.ipAddress;
  }

  /**
   * Information related to the location of the payment. Note that this information is an
   * approximation and attempts to locate the nearest population center - it should not be used to
   * determine a specific address.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Location getIpAddressLocation() {
    return this.ipAddressLocation;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code review}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * If {@code true}, the review needs action.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getOpen() {
    return this.open;
  }

  /**
   * The reason the review was opened. One of {@code rule} or {@code manual}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getOpenedReason() {
    return this.openedReason;
  }

  /**
   * The reason the review is currently open or closed. One of {@code rule}, {@code manual}, {@code
   * approved}, {@code refunded}, {@code refunded_as_fraud}, {@code disputed}, or {@code redacted}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReason() {
    return this.reason;
  }

  /**
   * Information related to the browsing session of the user who initiated the payment.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Session getSession() {
    return this.session;
  }

  /**
   * The ZIP or postal code of the card used, if applicable.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingZip(final String billingZip) {
    this.billingZip = billingZip;
  }

  /**
   * The reason the review was closed, or null if it has not yet been closed. One of {@code
   * approved}, {@code refunded}, {@code refunded_as_fraud}, {@code disputed}, or {@code redacted}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setClosedReason(final String closedReason) {
    this.closedReason = closedReason;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The IP address where the payment originated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIpAddress(final String ipAddress) {
    this.ipAddress = ipAddress;
  }

  /**
   * Information related to the location of the payment. Note that this information is an
   * approximation and attempts to locate the nearest population center - it should not be used to
   * determine a specific address.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIpAddressLocation(final Location ipAddressLocation) {
    this.ipAddressLocation = ipAddressLocation;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code review}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * If {@code true}, the review needs action.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOpen(final Boolean open) {
    this.open = open;
  }

  /**
   * The reason the review was opened. One of {@code rule} or {@code manual}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOpenedReason(final String openedReason) {
    this.openedReason = openedReason;
  }

  /**
   * The reason the review is currently open or closed. One of {@code rule}, {@code manual}, {@code
   * approved}, {@code refunded}, {@code refunded_as_fraud}, {@code disputed}, or {@code redacted}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReason(final String reason) {
    this.reason = reason;
  }

  /**
   * Information related to the browsing session of the user who initiated the payment.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSession(final Session session) {
    this.session = session;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Review)) return false;
    final Review other = (Review) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$open = this.getOpen();
    final java.lang.Object other$open = other.getOpen();
    if (this$open == null ? other$open != null : !this$open.equals(other$open)) return false;
    final java.lang.Object this$billingZip = this.getBillingZip();
    final java.lang.Object other$billingZip = other.getBillingZip();
    if (this$billingZip == null ? other$billingZip != null : !this$billingZip.equals(other$billingZip)) return false;
    final java.lang.Object this$charge = this.getCharge();
    final java.lang.Object other$charge = other.getCharge();
    if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) return false;
    final java.lang.Object this$closedReason = this.getClosedReason();
    final java.lang.Object other$closedReason = other.getClosedReason();
    if (this$closedReason == null ? other$closedReason != null : !this$closedReason.equals(other$closedReason)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$ipAddress = this.getIpAddress();
    final java.lang.Object other$ipAddress = other.getIpAddress();
    if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) return false;
    final java.lang.Object this$ipAddressLocation = this.getIpAddressLocation();
    final java.lang.Object other$ipAddressLocation = other.getIpAddressLocation();
    if (this$ipAddressLocation == null ? other$ipAddressLocation != null : !this$ipAddressLocation.equals(other$ipAddressLocation)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$openedReason = this.getOpenedReason();
    final java.lang.Object other$openedReason = other.getOpenedReason();
    if (this$openedReason == null ? other$openedReason != null : !this$openedReason.equals(other$openedReason)) return false;
    final java.lang.Object this$paymentIntent = this.getPaymentIntent();
    final java.lang.Object other$paymentIntent = other.getPaymentIntent();
    if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) return false;
    final java.lang.Object this$reason = this.getReason();
    final java.lang.Object other$reason = other.getReason();
    if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
    final java.lang.Object this$session = this.getSession();
    final java.lang.Object other$session = other.getSession();
    if (this$session == null ? other$session != null : !this$session.equals(other$session)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Review;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $open = this.getOpen();
    result = result * PRIME + ($open == null ? 43 : $open.hashCode());
    final java.lang.Object $billingZip = this.getBillingZip();
    result = result * PRIME + ($billingZip == null ? 43 : $billingZip.hashCode());
    final java.lang.Object $charge = this.getCharge();
    result = result * PRIME + ($charge == null ? 43 : $charge.hashCode());
    final java.lang.Object $closedReason = this.getClosedReason();
    result = result * PRIME + ($closedReason == null ? 43 : $closedReason.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $ipAddress = this.getIpAddress();
    result = result * PRIME + ($ipAddress == null ? 43 : $ipAddress.hashCode());
    final java.lang.Object $ipAddressLocation = this.getIpAddressLocation();
    result = result * PRIME + ($ipAddressLocation == null ? 43 : $ipAddressLocation.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $openedReason = this.getOpenedReason();
    result = result * PRIME + ($openedReason == null ? 43 : $openedReason.hashCode());
    final java.lang.Object $paymentIntent = this.getPaymentIntent();
    result = result * PRIME + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
    final java.lang.Object $reason = this.getReason();
    result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
    final java.lang.Object $session = this.getSession();
    result = result * PRIME + ($session == null ? 43 : $session.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
