// Generated by delombok at Tue Aug 02 15:52:37 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.terminal;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentIntent;
import com.stripe.model.SetupIntent;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.terminal.ReaderCancelActionParams;
import com.stripe.param.terminal.ReaderCreateParams;
import com.stripe.param.terminal.ReaderListParams;
import com.stripe.param.terminal.ReaderPresentPaymentMethodParams;
import com.stripe.param.terminal.ReaderProcessPaymentIntentParams;
import com.stripe.param.terminal.ReaderProcessSetupIntentParams;
import com.stripe.param.terminal.ReaderRetrieveParams;
import com.stripe.param.terminal.ReaderSetReaderDisplayParams;
import com.stripe.param.terminal.ReaderUpdateParams;
import java.util.List;
import java.util.Map;

public class Reader extends ApiResource implements HasId, MetadataStore<Reader> {
  /**
   * The most recent action performed by the reader.
   */
  @SerializedName("action")
  ReaderAction action;
  /**
   * Always true for a deleted object.
   */
  @SerializedName("deleted")
  Boolean deleted;
  /**
   * The current software version of the reader.
   */
  @SerializedName("device_sw_version")
  String deviceSwVersion;
  /**
   * Type of reader, one of {@code bbpos_wisepad3}, {@code stripe_m2}, {@code bbpos_chipper2x},
   * {@code bbpos_wisepos_e}, {@code verifone_P400}, or {@code simulated_wisepos_e}.
   */
  @SerializedName("device_type")
  String deviceType;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * The local IP address of the reader.
   */
  @SerializedName("ip_address")
  String ipAddress;
  /**
   * Custom label given to the reader for easier identification.
   */
  @SerializedName("label")
  String label;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * The location identifier of the reader.
   */
  @SerializedName("location")
  ExpandableField<Location> location;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code terminal.reader}.
   */
  @SerializedName("object")
  String object;
  /**
   * Serial number of the reader.
   */
  @SerializedName("serial_number")
  String serialNumber;
  /**
   * The networking status of the reader.
   */
  @SerializedName("status")
  String status;

  /**
   * Get ID of expandable {@code location} object.
   */
  public String getLocation() {
    return (this.location != null) ? this.location.getId() : null;
  }

  public void setLocation(String id) {
    this.location = ApiResource.setExpandableFieldId(id, this.location);
  }

  /**
   * Get expanded {@code location}.
   */
  public Location getLocationObject() {
    return (this.location != null) ? this.location.getExpanded() : null;
  }

  public void setLocationObject(Location expandableObject) {
    this.location = new ExpandableField<Location>(expandableObject.getId(), expandableObject);
  }

  /**
   * Updates a <code>Reader</code> object by setting the values of the parameters passed. Any
   * parameters not provided will be left unchanged.
   */
  @Override
  public Reader update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a <code>Reader</code> object by setting the values of the parameters passed. Any
   * parameters not provided will be left unchanged.
   */
  @Override
  public Reader update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
  }

  /**
   * Updates a <code>Reader</code> object by setting the values of the parameters passed. Any
   * parameters not provided will be left unchanged.
   */
  public Reader update(ReaderUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a <code>Reader</code> object by setting the values of the parameters passed. Any
   * parameters not provided will be left unchanged.
   */
  public Reader update(ReaderUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
  }

  /**
   * Retrieves a <code>Reader</code> object.
   */
  public static Reader retrieve(String reader) throws StripeException {
    return retrieve(reader, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves a <code>Reader</code> object.
   */
  public static Reader retrieve(String reader, RequestOptions options) throws StripeException {
    return retrieve(reader, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves a <code>Reader</code> object.
   */
  public static Reader retrieve(String reader, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(reader)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Reader.class, options);
  }

  /**
   * Retrieves a <code>Reader</code> object.
   */
  public static Reader retrieve(String reader, ReaderRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(reader)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Reader.class, options);
  }

  /**
   * Creates a new <code>Reader</code> object.
   */
  public static Reader create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new <code>Reader</code> object.
   */
  public static Reader create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/readers");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
  }

  /**
   * Creates a new <code>Reader</code> object.
   */
  public static Reader create(ReaderCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new <code>Reader</code> object.
   */
  public static Reader create(ReaderCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/readers");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
  }

  /**
   * Returns a list of <code>Reader</code> objects.
   */
  public static ReaderCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of <code>Reader</code> objects.
   */
  public static ReaderCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/readers");
    return ApiResource.requestCollection(url, params, ReaderCollection.class, options);
  }

  /**
   * Returns a list of <code>Reader</code> objects.
   */
  public static ReaderCollection list(ReaderListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of <code>Reader</code> objects.
   */
  public static ReaderCollection list(ReaderListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/readers");
    return ApiResource.requestCollection(url, params, ReaderCollection.class, options);
  }

  /**
   * Deletes a <code>Reader</code> object.
   */
  public Reader delete() throws StripeException {
    return delete((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Deletes a <code>Reader</code> object.
   */
  public Reader delete(RequestOptions options) throws StripeException {
    return delete((Map<String, Object>) null, options);
  }

  /**
   * Deletes a <code>Reader</code> object.
   */
  public Reader delete(Map<String, Object> params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * Deletes a <code>Reader</code> object.
   */
  public Reader delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Reader.class, options);
  }

  /**
   * Initiates a payment flow on a Reader.
   */
  public Reader processPaymentIntent(Map<String, Object> params) throws StripeException {
    return processPaymentIntent(params, (RequestOptions) null);
  }

  /**
   * Initiates a payment flow on a Reader.
   */
  public Reader processPaymentIntent(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s/process_payment_intent", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
  }

  /**
   * Initiates a payment flow on a Reader.
   */
  public Reader processPaymentIntent(ReaderProcessPaymentIntentParams params) throws StripeException {
    return processPaymentIntent(params, (RequestOptions) null);
  }

  /**
   * Initiates a payment flow on a Reader.
   */
  public Reader processPaymentIntent(ReaderProcessPaymentIntentParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s/process_payment_intent", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
  }

  /**
   * Initiates a setup intent flow on a Reader.
   */
  public Reader processSetupIntent(Map<String, Object> params) throws StripeException {
    return processSetupIntent(params, (RequestOptions) null);
  }

  /**
   * Initiates a setup intent flow on a Reader.
   */
  public Reader processSetupIntent(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s/process_setup_intent", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
  }

  /**
   * Initiates a setup intent flow on a Reader.
   */
  public Reader processSetupIntent(ReaderProcessSetupIntentParams params) throws StripeException {
    return processSetupIntent(params, (RequestOptions) null);
  }

  /**
   * Initiates a setup intent flow on a Reader.
   */
  public Reader processSetupIntent(ReaderProcessSetupIntentParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s/process_setup_intent", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
  }

  /**
   * Cancels the current reader action.
   */
  public Reader cancelAction() throws StripeException {
    return cancelAction((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Cancels the current reader action.
   */
  public Reader cancelAction(RequestOptions options) throws StripeException {
    return cancelAction((Map<String, Object>) null, options);
  }

  /**
   * Cancels the current reader action.
   */
  public Reader cancelAction(Map<String, Object> params) throws StripeException {
    return cancelAction(params, (RequestOptions) null);
  }

  /**
   * Cancels the current reader action.
   */
  public Reader cancelAction(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s/cancel_action", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
  }

  /**
   * Cancels the current reader action.
   */
  public Reader cancelAction(ReaderCancelActionParams params) throws StripeException {
    return cancelAction(params, (RequestOptions) null);
  }

  /**
   * Cancels the current reader action.
   */
  public Reader cancelAction(ReaderCancelActionParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s/cancel_action", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
  }

  /**
   * Sets reader display to show cart details.
   */
  public Reader setReaderDisplay(Map<String, Object> params) throws StripeException {
    return setReaderDisplay(params, (RequestOptions) null);
  }

  /**
   * Sets reader display to show cart details.
   */
  public Reader setReaderDisplay(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s/set_reader_display", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
  }

  /**
   * Sets reader display to show cart details.
   */
  public Reader setReaderDisplay(ReaderSetReaderDisplayParams params) throws StripeException {
    return setReaderDisplay(params, (RequestOptions) null);
  }

  /**
   * Sets reader display to show cart details.
   */
  public Reader setReaderDisplay(ReaderSetReaderDisplayParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s/set_reader_display", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
  }


  public static class ReaderAction extends StripeObject {
    /**
     * Failure code, only set if status is {@code failed}.
     */
    @SerializedName("failure_code")
    String failureCode;
    /**
     * Detailed failure message, only set if status is {@code failed}.
     */
    @SerializedName("failure_message")
    String failureMessage;
    /**
     * Represents a reader action to process a payment intent.
     */
    @SerializedName("process_payment_intent")
    ProcessPaymentIntentAction processPaymentIntent;
    /**
     * Represents a reader action to process a setup intent.
     */
    @SerializedName("process_setup_intent")
    ProcessSetupIntentAction processSetupIntent;
    /**
     * Represents a reader action to set the reader display.
     */
    @SerializedName("set_reader_display")
    SetReaderDisplayAction setReaderDisplay;
    /**
     * Status of the action performed by the reader.
     *
     * <p>One of {@code failed}, {@code in_progress}, or {@code succeeded}.
     */
    @SerializedName("status")
    String status;
    /**
     * Type of action performed by the reader.
     *
     * <p>One of {@code process_payment_intent}, {@code process_setup_intent}, or {@code
     * set_reader_display}.
     */
    @SerializedName("type")
    String type;


    public static class ProcessPaymentIntentAction extends StripeObject {
      /**
       * Most recent PaymentIntent processed by the reader.
       */
      @SerializedName("payment_intent")
      ExpandableField<PaymentIntent> paymentIntent;

      /**
       * Get ID of expandable {@code paymentIntent} object.
       */
      public String getPaymentIntent() {
        return (this.paymentIntent != null) ? this.paymentIntent.getId() : null;
      }

      public void setPaymentIntent(String id) {
        this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
      }

      /**
       * Get expanded {@code paymentIntent}.
       */
      public PaymentIntent getPaymentIntentObject() {
        return (this.paymentIntent != null) ? this.paymentIntent.getExpanded() : null;
      }

      public void setPaymentIntentObject(PaymentIntent expandableObject) {
        this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Reader.ReaderAction.ProcessPaymentIntentAction)) return false;
        final Reader.ReaderAction.ProcessPaymentIntentAction other = (Reader.ReaderAction.ProcessPaymentIntentAction) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$paymentIntent = this.getPaymentIntent();
        final java.lang.Object other$paymentIntent = other.getPaymentIntent();
        if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Reader.ReaderAction.ProcessPaymentIntentAction;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $paymentIntent = this.getPaymentIntent();
        result = result * PRIME + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
        return result;
      }
    }


    public static class ProcessSetupIntentAction extends StripeObject {
      @SerializedName("generated_card")
      String generatedCard;
      /**
       * Most recent SetupIntent processed by the reader.
       */
      @SerializedName("setup_intent")
      ExpandableField<SetupIntent> setupIntent;

      /**
       * Get ID of expandable {@code setupIntent} object.
       */
      public String getSetupIntent() {
        return (this.setupIntent != null) ? this.setupIntent.getId() : null;
      }

      public void setSetupIntent(String id) {
        this.setupIntent = ApiResource.setExpandableFieldId(id, this.setupIntent);
      }

      /**
       * Get expanded {@code setupIntent}.
       */
      public SetupIntent getSetupIntentObject() {
        return (this.setupIntent != null) ? this.setupIntent.getExpanded() : null;
      }

      public void setSetupIntentObject(SetupIntent expandableObject) {
        this.setupIntent = new ExpandableField<SetupIntent>(expandableObject.getId(), expandableObject);
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getGeneratedCard() {
        return this.generatedCard;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setGeneratedCard(final String generatedCard) {
        this.generatedCard = generatedCard;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Reader.ReaderAction.ProcessSetupIntentAction)) return false;
        final Reader.ReaderAction.ProcessSetupIntentAction other = (Reader.ReaderAction.ProcessSetupIntentAction) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$generatedCard = this.getGeneratedCard();
        final java.lang.Object other$generatedCard = other.getGeneratedCard();
        if (this$generatedCard == null ? other$generatedCard != null : !this$generatedCard.equals(other$generatedCard)) return false;
        final java.lang.Object this$setupIntent = this.getSetupIntent();
        final java.lang.Object other$setupIntent = other.getSetupIntent();
        if (this$setupIntent == null ? other$setupIntent != null : !this$setupIntent.equals(other$setupIntent)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Reader.ReaderAction.ProcessSetupIntentAction;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $generatedCard = this.getGeneratedCard();
        result = result * PRIME + ($generatedCard == null ? 43 : $generatedCard.hashCode());
        final java.lang.Object $setupIntent = this.getSetupIntent();
        result = result * PRIME + ($setupIntent == null ? 43 : $setupIntent.hashCode());
        return result;
      }
    }


    public static class SetReaderDisplayAction extends StripeObject {
      /** Cart object to be displayed by the reader. */
      @SerializedName("cart")
      Cart cart;
      /**
       * Type of information to be displayed by the reader.
       *
       * <p>Equal to {@code cart}.
       */
      @SerializedName("type")
      String type;


      public static class Cart extends StripeObject {
        /**
         * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
         * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
         * currency</a>.
         */
        @SerializedName("currency")
        String currency;
        /** List of line items in the cart. */
        @SerializedName("line_items")
        List<Reader.ReaderAction.SetReaderDisplayAction.Cart.LineItem> lineItems;
        /**
         * Tax amount for the entire cart. A positive integer in the <a
         * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
         */
        @SerializedName("tax")
        Long tax;
        /**
         * Total amount for the entire cart, including tax. A positive integer in the <a
         * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
         */
        @SerializedName("total")
        Long total;


        public static class LineItem extends StripeObject {
          /**
           * The amount of the line item. A positive integer in the <a
           * href="https://stripe.com/docs/currencies#zero-decimal">smallest currency unit</a>.
           */
          @SerializedName("amount")
          Long amount;
          /** Description of the line item. */
          @SerializedName("description")
          String description;
          @SerializedName("quantity")
          Long quantity;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public Long getAmount() {
            return this.amount;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getDescription() {
            return this.description;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public Long getQuantity() {
            return this.quantity;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setAmount(final Long amount) {
            this.amount = amount;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setDescription(final String description) {
            this.description = description;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setQuantity(final Long quantity) {
            this.quantity = quantity;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Reader.ReaderAction.SetReaderDisplayAction.Cart.LineItem)) return false;
            final Reader.ReaderAction.SetReaderDisplayAction.Cart.LineItem other = (Reader.ReaderAction.SetReaderDisplayAction.Cart.LineItem) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$amount = this.getAmount();
            final java.lang.Object other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
            final java.lang.Object this$quantity = this.getQuantity();
            final java.lang.Object other$quantity = other.getQuantity();
            if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) return false;
            final java.lang.Object this$description = this.getDescription();
            final java.lang.Object other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Reader.ReaderAction.SetReaderDisplayAction.Cart.LineItem;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $amount = this.getAmount();
            result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
            final java.lang.Object $quantity = this.getQuantity();
            result = result * PRIME + ($quantity == null ? 43 : $quantity.hashCode());
            final java.lang.Object $description = this.getDescription();
            result = result * PRIME + ($description == null ? 43 : $description.hashCode());
            return result;
          }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCurrency() {
          return this.currency;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<Reader.ReaderAction.SetReaderDisplayAction.Cart.LineItem> getLineItems() {
          return this.lineItems;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getTax() {
          return this.tax;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getTotal() {
          return this.total;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCurrency(final String currency) {
          this.currency = currency;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setLineItems(final List<Reader.ReaderAction.SetReaderDisplayAction.Cart.LineItem> lineItems) {
          this.lineItems = lineItems;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setTax(final Long tax) {
          this.tax = tax;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setTotal(final Long total) {
          this.total = total;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Reader.ReaderAction.SetReaderDisplayAction.Cart)) return false;
          final Reader.ReaderAction.SetReaderDisplayAction.Cart other = (Reader.ReaderAction.SetReaderDisplayAction.Cart) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$tax = this.getTax();
          final java.lang.Object other$tax = other.getTax();
          if (this$tax == null ? other$tax != null : !this$tax.equals(other$tax)) return false;
          final java.lang.Object this$total = this.getTotal();
          final java.lang.Object other$total = other.getTotal();
          if (this$total == null ? other$total != null : !this$total.equals(other$total)) return false;
          final java.lang.Object this$currency = this.getCurrency();
          final java.lang.Object other$currency = other.getCurrency();
          if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
          final java.lang.Object this$lineItems = this.getLineItems();
          final java.lang.Object other$lineItems = other.getLineItems();
          if (this$lineItems == null ? other$lineItems != null : !this$lineItems.equals(other$lineItems)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Reader.ReaderAction.SetReaderDisplayAction.Cart;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $tax = this.getTax();
          result = result * PRIME + ($tax == null ? 43 : $tax.hashCode());
          final java.lang.Object $total = this.getTotal();
          result = result * PRIME + ($total == null ? 43 : $total.hashCode());
          final java.lang.Object $currency = this.getCurrency();
          result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
          final java.lang.Object $lineItems = this.getLineItems();
          result = result * PRIME + ($lineItems == null ? 43 : $lineItems.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Cart getCart() {
        return this.cart;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getType() {
        return this.type;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCart(final Cart cart) {
        this.cart = cart;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setType(final String type) {
        this.type = type;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Reader.ReaderAction.SetReaderDisplayAction)) return false;
        final Reader.ReaderAction.SetReaderDisplayAction other = (Reader.ReaderAction.SetReaderDisplayAction) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$cart = this.getCart();
        final java.lang.Object other$cart = other.getCart();
        if (this$cart == null ? other$cart != null : !this$cart.equals(other$cart)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Reader.ReaderAction.SetReaderDisplayAction;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $cart = this.getCart();
        result = result * PRIME + ($cart == null ? 43 : $cart.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        return result;
      }
    }

    /**
     * Failure code, only set if status is {@code failed}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFailureCode() {
      return this.failureCode;
    }

    /**
     * Detailed failure message, only set if status is {@code failed}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFailureMessage() {
      return this.failureMessage;
    }

    /**
     * Represents a reader action to process a payment intent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ProcessPaymentIntentAction getProcessPaymentIntent() {
      return this.processPaymentIntent;
    }

    /**
     * Represents a reader action to process a setup intent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ProcessSetupIntentAction getProcessSetupIntent() {
      return this.processSetupIntent;
    }

    /**
     * Represents a reader action to set the reader display.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SetReaderDisplayAction getSetReaderDisplay() {
      return this.setReaderDisplay;
    }

    /**
     * Status of the action performed by the reader.
     *
     * <p>One of {@code failed}, {@code in_progress}, or {@code succeeded}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    /**
     * Type of action performed by the reader.
     *
     * <p>One of {@code process_payment_intent}, {@code process_setup_intent}, or {@code
     * set_reader_display}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    /**
     * Failure code, only set if status is {@code failed}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFailureCode(final String failureCode) {
      this.failureCode = failureCode;
    }

    /**
     * Detailed failure message, only set if status is {@code failed}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFailureMessage(final String failureMessage) {
      this.failureMessage = failureMessage;
    }

    /**
     * Represents a reader action to process a payment intent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProcessPaymentIntent(final ProcessPaymentIntentAction processPaymentIntent) {
      this.processPaymentIntent = processPaymentIntent;
    }

    /**
     * Represents a reader action to process a setup intent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProcessSetupIntent(final ProcessSetupIntentAction processSetupIntent) {
      this.processSetupIntent = processSetupIntent;
    }

    /**
     * Represents a reader action to set the reader display.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSetReaderDisplay(final SetReaderDisplayAction setReaderDisplay) {
      this.setReaderDisplay = setReaderDisplay;
    }

    /**
     * Status of the action performed by the reader.
     *
     * <p>One of {@code failed}, {@code in_progress}, or {@code succeeded}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    /**
     * Type of action performed by the reader.
     *
     * <p>One of {@code process_payment_intent}, {@code process_setup_intent}, or {@code
     * set_reader_display}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Reader.ReaderAction)) return false;
      final Reader.ReaderAction other = (Reader.ReaderAction) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$failureCode = this.getFailureCode();
      final java.lang.Object other$failureCode = other.getFailureCode();
      if (this$failureCode == null ? other$failureCode != null : !this$failureCode.equals(other$failureCode)) return false;
      final java.lang.Object this$failureMessage = this.getFailureMessage();
      final java.lang.Object other$failureMessage = other.getFailureMessage();
      if (this$failureMessage == null ? other$failureMessage != null : !this$failureMessage.equals(other$failureMessage)) return false;
      final java.lang.Object this$processPaymentIntent = this.getProcessPaymentIntent();
      final java.lang.Object other$processPaymentIntent = other.getProcessPaymentIntent();
      if (this$processPaymentIntent == null ? other$processPaymentIntent != null : !this$processPaymentIntent.equals(other$processPaymentIntent)) return false;
      final java.lang.Object this$processSetupIntent = this.getProcessSetupIntent();
      final java.lang.Object other$processSetupIntent = other.getProcessSetupIntent();
      if (this$processSetupIntent == null ? other$processSetupIntent != null : !this$processSetupIntent.equals(other$processSetupIntent)) return false;
      final java.lang.Object this$setReaderDisplay = this.getSetReaderDisplay();
      final java.lang.Object other$setReaderDisplay = other.getSetReaderDisplay();
      if (this$setReaderDisplay == null ? other$setReaderDisplay != null : !this$setReaderDisplay.equals(other$setReaderDisplay)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Reader.ReaderAction;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $failureCode = this.getFailureCode();
      result = result * PRIME + ($failureCode == null ? 43 : $failureCode.hashCode());
      final java.lang.Object $failureMessage = this.getFailureMessage();
      result = result * PRIME + ($failureMessage == null ? 43 : $failureMessage.hashCode());
      final java.lang.Object $processPaymentIntent = this.getProcessPaymentIntent();
      result = result * PRIME + ($processPaymentIntent == null ? 43 : $processPaymentIntent.hashCode());
      final java.lang.Object $processSetupIntent = this.getProcessSetupIntent();
      result = result * PRIME + ($processSetupIntent == null ? 43 : $processSetupIntent.hashCode());
      final java.lang.Object $setReaderDisplay = this.getSetReaderDisplay();
      result = result * PRIME + ($setReaderDisplay == null ? 43 : $setReaderDisplay.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }

  /**
   * The quantity of the line item.
   */
  public TestHelpers getTestHelpers() {
    return new TestHelpers(this);
  }


  public static class TestHelpers {
    private final Reader resource;

    private TestHelpers(Reader resource) {
      this.resource = resource;
    }

    /**
     * Presents a payment method on a simulated reader. Can be used to simulate accepting a payment,
     * saving a card or refunding a transaction.
     */
    public Reader presentPaymentMethod() throws StripeException {
      return presentPaymentMethod((Map<String, Object>) null, (RequestOptions) null);
    }

    /**
     * Presents a payment method on a simulated reader. Can be used to simulate accepting a payment,
     * saving a card or refunding a transaction.
     */
    public Reader presentPaymentMethod(RequestOptions options) throws StripeException {
      return presentPaymentMethod((Map<String, Object>) null, options);
    }

    /**
     * Presents a payment method on a simulated reader. Can be used to simulate accepting a payment,
     * saving a card or refunding a transaction.
     */
    public Reader presentPaymentMethod(Map<String, Object> params) throws StripeException {
      return presentPaymentMethod(params, (RequestOptions) null);
    }

    /**
     * Presents a payment method on a simulated reader. Can be used to simulate accepting a payment,
     * saving a card or refunding a transaction.
     */
    public Reader presentPaymentMethod(Map<String, Object> params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/terminal/readers/%s/present_payment_method", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
    }

    /**
     * Presents a payment method on a simulated reader. Can be used to simulate accepting a payment,
     * saving a card or refunding a transaction.
     */
    public Reader presentPaymentMethod(ReaderPresentPaymentMethodParams params) throws StripeException {
      return presentPaymentMethod(params, (RequestOptions) null);
    }

    /**
     * Presents a payment method on a simulated reader. Can be used to simulate accepting a payment,
     * saving a card or refunding a transaction.
     */
    public Reader presentPaymentMethod(ReaderPresentPaymentMethodParams params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/terminal/readers/%s/present_payment_method", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
    }
  }

  /**
   * The most recent action performed by the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ReaderAction getAction() {
    return this.action;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * The current software version of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDeviceSwVersion() {
    return this.deviceSwVersion;
  }

  /**
   * Type of reader, one of {@code bbpos_wisepad3}, {@code stripe_m2}, {@code bbpos_chipper2x},
   * {@code bbpos_wisepos_e}, {@code verifone_P400}, or {@code simulated_wisepos_e}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDeviceType() {
    return this.deviceType;
  }

  /**
   * The local IP address of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getIpAddress() {
    return this.ipAddress;
  }

  /**
   * Custom label given to the reader for easier identification.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLabel() {
    return this.label;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code terminal.reader}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Serial number of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSerialNumber() {
    return this.serialNumber;
  }

  /**
   * The networking status of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * The most recent action performed by the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAction(final ReaderAction action) {
    this.action = action;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * The current software version of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeviceSwVersion(final String deviceSwVersion) {
    this.deviceSwVersion = deviceSwVersion;
  }

  /**
   * Type of reader, one of {@code bbpos_wisepad3}, {@code stripe_m2}, {@code bbpos_chipper2x},
   * {@code bbpos_wisepos_e}, {@code verifone_P400}, or {@code simulated_wisepos_e}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeviceType(final String deviceType) {
    this.deviceType = deviceType;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The local IP address of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIpAddress(final String ipAddress) {
    this.ipAddress = ipAddress;
  }

  /**
   * Custom label given to the reader for easier identification.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLabel(final String label) {
    this.label = label;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code terminal.reader}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Serial number of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSerialNumber(final String serialNumber) {
    this.serialNumber = serialNumber;
  }

  /**
   * The networking status of the reader.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Reader)) return false;
    final Reader other = (Reader) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$action = this.getAction();
    final java.lang.Object other$action = other.getAction();
    if (this$action == null ? other$action != null : !this$action.equals(other$action)) return false;
    final java.lang.Object this$deviceSwVersion = this.getDeviceSwVersion();
    final java.lang.Object other$deviceSwVersion = other.getDeviceSwVersion();
    if (this$deviceSwVersion == null ? other$deviceSwVersion != null : !this$deviceSwVersion.equals(other$deviceSwVersion)) return false;
    final java.lang.Object this$deviceType = this.getDeviceType();
    final java.lang.Object other$deviceType = other.getDeviceType();
    if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$ipAddress = this.getIpAddress();
    final java.lang.Object other$ipAddress = other.getIpAddress();
    if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) return false;
    final java.lang.Object this$label = this.getLabel();
    final java.lang.Object other$label = other.getLabel();
    if (this$label == null ? other$label != null : !this$label.equals(other$label)) return false;
    final java.lang.Object this$location = this.getLocation();
    final java.lang.Object other$location = other.getLocation();
    if (this$location == null ? other$location != null : !this$location.equals(other$location)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$serialNumber = this.getSerialNumber();
    final java.lang.Object other$serialNumber = other.getSerialNumber();
    if (this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Reader;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $action = this.getAction();
    result = result * PRIME + ($action == null ? 43 : $action.hashCode());
    final java.lang.Object $deviceSwVersion = this.getDeviceSwVersion();
    result = result * PRIME + ($deviceSwVersion == null ? 43 : $deviceSwVersion.hashCode());
    final java.lang.Object $deviceType = this.getDeviceType();
    result = result * PRIME + ($deviceType == null ? 43 : $deviceType.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $ipAddress = this.getIpAddress();
    result = result * PRIME + ($ipAddress == null ? 43 : $ipAddress.hashCode());
    final java.lang.Object $label = this.getLabel();
    result = result * PRIME + ($label == null ? 43 : $label.hashCode());
    final java.lang.Object $location = this.getLocation();
    result = result * PRIME + ($location == null ? 43 : $location.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $serialNumber = this.getSerialNumber();
    result = result * PRIME + ($serialNumber == null ? 43 : $serialNumber.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
