// Generated by delombok at Wed Aug 03 21:09:12 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.TaxCodeListParams;
import com.stripe.param.TaxCodeRetrieveParams;
import java.util.Map;

public class TaxCode extends ApiResource implements HasId {
  /**
   * A detailed description of which types of products the tax code represents.
   */
  @SerializedName("description")
  String description;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * A short name for the tax code.
   */
  @SerializedName("name")
  String name;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code tax_code}.
   */
  @SerializedName("object")
  String object;

  /**
   * A list of <a href="https://stripe.com/docs/tax/tax-categories">all tax codes available</a> to
   * add to Products in order to allow specific tax calculations.
   */
  public static TaxCodeCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * A list of <a href="https://stripe.com/docs/tax/tax-categories">all tax codes available</a> to
   * add to Products in order to allow specific tax calculations.
   */
  public static TaxCodeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/tax_codes");
    return ApiResource.requestCollection(url, params, TaxCodeCollection.class, options);
  }

  /**
   * A list of <a href="https://stripe.com/docs/tax/tax-categories">all tax codes available</a> to
   * add to Products in order to allow specific tax calculations.
   */
  public static TaxCodeCollection list(TaxCodeListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * A list of <a href="https://stripe.com/docs/tax/tax-categories">all tax codes available</a> to
   * add to Products in order to allow specific tax calculations.
   */
  public static TaxCodeCollection list(TaxCodeListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/tax_codes");
    return ApiResource.requestCollection(url, params, TaxCodeCollection.class, options);
  }

  /**
   * Retrieves the details of an existing tax code. Supply the unique tax code ID and Stripe will
   * return the corresponding tax code information.
   */
  public static TaxCode retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an existing tax code. Supply the unique tax code ID and Stripe will
   * return the corresponding tax code information.
   */
  public static TaxCode retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an existing tax code. Supply the unique tax code ID and Stripe will
   * return the corresponding tax code information.
   */
  public static TaxCode retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/tax_codes/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, TaxCode.class, options);
  }

  /**
   * Retrieves the details of an existing tax code. Supply the unique tax code ID and Stripe will
   * return the corresponding tax code information.
   */
  public static TaxCode retrieve(String id, TaxCodeRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/tax_codes/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, TaxCode.class, options);
  }

  /**
   * A detailed description of which types of products the tax code represents.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * A short name for the tax code.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getName() {
    return this.name;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code tax_code}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * A detailed description of which types of products the tax code represents.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * A short name for the tax code.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setName(final String name) {
    this.name = name;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code tax_code}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof TaxCode)) return false;
    final TaxCode other = (TaxCode) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$name = this.getName();
    final java.lang.Object other$name = other.getName();
    if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof TaxCode;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $name = this.getName();
    result = result * PRIME + ($name == null ? 43 : $name.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
