/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.radar;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.radar.ValueListItemCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.radar.ValueListItemCreateParams;
import com.stripe.param.radar.ValueListItemListParams;
import com.stripe.param.radar.ValueListItemRetrieveParams;
import java.util.Map;
import lombok.Generated;

public class ValueListItem
extends ApiResource
implements HasId {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="created_by")
    String createdBy;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="value")
    String value;
    @SerializedName(value="value_list")
    String valueList;

    public static ValueListItemCollection list(Map<String, Object> params) throws StripeException {
        return ValueListItem.list(params, (RequestOptions)null);
    }

    public static ValueListItemCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/radar/value_list_items");
        return ApiResource.requestCollection(url, params, ValueListItemCollection.class, options);
    }

    public static ValueListItemCollection list(ValueListItemListParams params) throws StripeException {
        return ValueListItem.list(params, (RequestOptions)null);
    }

    public static ValueListItemCollection list(ValueListItemListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/radar/value_list_items");
        return ApiResource.requestCollection(url, params, ValueListItemCollection.class, options);
    }

    public static ValueListItem retrieve(String item) throws StripeException {
        return ValueListItem.retrieve(item, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static ValueListItem retrieve(String item, RequestOptions options) throws StripeException {
        return ValueListItem.retrieve(item, (Map<String, Object>)null, options);
    }

    public static ValueListItem retrieve(String item, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/radar/value_list_items/%s", ApiResource.urlEncodeId(item)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ValueListItem.class, options);
    }

    public static ValueListItem retrieve(String item, ValueListItemRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/radar/value_list_items/%s", ApiResource.urlEncodeId(item)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ValueListItem.class, options);
    }

    public static ValueListItem create(Map<String, Object> params) throws StripeException {
        return ValueListItem.create(params, (RequestOptions)null);
    }

    public static ValueListItem create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/radar/value_list_items");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ValueListItem.class, options);
    }

    public static ValueListItem create(ValueListItemCreateParams params) throws StripeException {
        return ValueListItem.create(params, (RequestOptions)null);
    }

    public static ValueListItem create(ValueListItemCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/radar/value_list_items");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ValueListItem.class, options);
    }

    public ValueListItem delete() throws StripeException {
        return this.delete(null, null);
    }

    public ValueListItem delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public ValueListItem delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public ValueListItem delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/radar/value_list_items/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, ValueListItem.class, options);
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getValueList() {
        return this.valueList;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setValueList(String valueList) {
        this.valueList = valueList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueListItem)) {
            return false;
        }
        ValueListItem other = (ValueListItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$valueList = this.getValueList();
        String other$valueList = other.getValueList();
        return !(this$valueList == null ? other$valueList != null : !this$valueList.equals(other$valueList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ValueListItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $valueList = this.getValueList();
        result = result * 59 + ($valueList == null ? 43 : $valueList.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

