// Generated by delombok at Tue Aug 09 19:34:09 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.testhelpers.TestClock;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.InvoiceCreateParams;
import com.stripe.param.InvoiceFinalizeInvoiceParams;
import com.stripe.param.InvoiceListParams;
import com.stripe.param.InvoiceMarkUncollectibleParams;
import com.stripe.param.InvoicePayParams;
import com.stripe.param.InvoiceRetrieveParams;
import com.stripe.param.InvoiceSearchParams;
import com.stripe.param.InvoiceSendInvoiceParams;
import com.stripe.param.InvoiceUpcomingParams;
import com.stripe.param.InvoiceUpdateParams;
import com.stripe.param.InvoiceVoidInvoiceParams;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Invoice extends ApiResource implements HasId, MetadataStore<Invoice> {
  /**
   * The country of the business associated with this invoice, most often the business creating the
   * invoice.
   */
  @SerializedName("account_country")
  String accountCountry;
  /**
   * The public name of the business associated with this invoice, most often the business creating
   * the invoice.
   */
  @SerializedName("account_name")
  String accountName;
  /**
   * The account tax IDs associated with the invoice. Only editable when the invoice is a draft.
   */
  @SerializedName("account_tax_ids")
  List<ExpandableField<TaxId>> accountTaxIds;
  /**
   * Final amount due at this time for this invoice. If the invoice's total is smaller than the
   * minimum charge amount, for example, or if there is account credit that can be applied to the
   * invoice, the {@code amount_due} may be 0. If there is a positive {@code starting_balance} for
   * the invoice (the customer owes money), the {@code amount_due} will also take that into account.
   * The charge that gets generated for the invoice will be for the amount specified in {@code
   * amount_due}.
   */
  @SerializedName("amount_due")
  Long amountDue;
  /**
   * The amount, in %s, that was paid.
   */
  @SerializedName("amount_paid")
  Long amountPaid;
  /**
   * The difference between amount_due and amount_paid, in %s.
   */
  @SerializedName("amount_remaining")
  Long amountRemaining;
  /**
   * ID of the Connect Application that created the invoice.
   */
  @SerializedName("application")
  ExpandableField<Application> application;
  /**
   * The fee in %s that will be applied to the invoice and transferred to the application owner's
   * Stripe account when the invoice is paid.
   */
  @SerializedName("application_fee_amount")
  Long applicationFeeAmount;
  /**
   * Number of payment attempts made for this invoice, from the perspective of the payment retry
   * schedule. Any payment attempt counts as the first attempt, and subsequently only automatic
   * retries increment the attempt count. In other words, manual payment attempts after the first
   * attempt do not affect the retry schedule.
   */
  @SerializedName("attempt_count")
  Long attemptCount;
  /**
   * Whether an attempt has been made to pay the invoice. An invoice is not attempted until 1 hour
   * after the {@code invoice.created} webhook, for example, so you might not want to display that
   * invoice as unpaid to your users.
   */
  @SerializedName("attempted")
  Boolean attempted;
  /**
   * Controls whether Stripe will perform <a
   * href="https://stripe.com/docs/billing/invoices/workflow/#auto_advance">automatic collection</a>
   * of the invoice. When {@code false}, the invoice's state will not automatically advance without
   * an explicit action.
   */
  @SerializedName("auto_advance")
  Boolean autoAdvance;
  @SerializedName("automatic_tax")
  AutomaticTax automaticTax;
  /**
   * Indicates the reason why the invoice was created. {@code subscription_cycle} indicates an
   * invoice created by a subscription advancing into a new period. {@code subscription_create}
   * indicates an invoice created due to creating a subscription. {@code subscription_update}
   * indicates an invoice created due to updating a subscription. {@code subscription} is set for
   * all old invoices to indicate either a change to a subscription or a period advancement. {@code
   * manual} is set for all invoices unrelated to a subscription (for example: created via the
   * invoice editor). The {@code upcoming} value is reserved for simulated invoices per the upcoming
   * invoice endpoint. {@code subscription_threshold} indicates an invoice created due to a billing
   * threshold being reached.
   *
   * <p>One of {@code automatic_pending_invoice_item_invoice}, {@code manual}, {@code quote_accept},
   * {@code subscription}, {@code subscription_create}, {@code subscription_cycle}, {@code
   * subscription_threshold}, {@code subscription_update}, or {@code upcoming}.
   */
  @SerializedName("billing_reason")
  String billingReason;
  /**
   * ID of the latest charge generated for this invoice, if any.
   */
  @SerializedName("charge")
  ExpandableField<Charge> charge;
  /**
   * Either {@code charge_automatically}, or {@code send_invoice}. When charging automatically,
   * Stripe will attempt to pay this invoice using the default source attached to the customer. When
   * sending an invoice, Stripe will email this invoice to the customer with payment instructions.
   *
   * <p>One of {@code charge_automatically}, or {@code send_invoice}.
   */
  @SerializedName("collection_method")
  String collectionMethod;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * The ID of the customer who will be billed.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  /**
   * The customer's address. Until the invoice is finalized, this field will equal {@code
   * customer.address}. Once the invoice is finalized, this field will no longer be updated.
   */
  @SerializedName("customer_address")
  Address customerAddress;
  /**
   * The customer's email. Until the invoice is finalized, this field will equal {@code
   * customer.email}. Once the invoice is finalized, this field will no longer be updated.
   */
  @SerializedName("customer_email")
  String customerEmail;
  /**
   * The customer's name. Until the invoice is finalized, this field will equal {@code
   * customer.name}. Once the invoice is finalized, this field will no longer be updated.
   */
  @SerializedName("customer_name")
  String customerName;
  /**
   * The customer's phone number. Until the invoice is finalized, this field will equal {@code
   * customer.phone}. Once the invoice is finalized, this field will no longer be updated.
   */
  @SerializedName("customer_phone")
  String customerPhone;
  /**
   * The customer's shipping information. Until the invoice is finalized, this field will equal
   * {@code customer.shipping}. Once the invoice is finalized, this field will no longer be updated.
   */
  @SerializedName("customer_shipping")
  ShippingDetails customerShipping;
  /**
   * The customer's tax exempt status. Until the invoice is finalized, this field will equal {@code
   * customer.tax_exempt}. Once the invoice is finalized, this field will no longer be updated.
   *
   * <p>One of {@code exempt}, {@code none}, or {@code reverse}.
   */
  @SerializedName("customer_tax_exempt")
  String customerTaxExempt;
  /**
   * The customer's tax IDs. Until the invoice is finalized, this field will contain the same tax
   * IDs as {@code customer.tax_ids}. Once the invoice is finalized, this field will no longer be
   * updated.
   */
  @SerializedName("customer_tax_ids")
  List<Invoice.CustomerTaxId> customerTaxIds;
  /**
   * Custom fields displayed on the invoice.
   */
  @SerializedName("custom_fields")
  List<Invoice.CustomField> customFields;
  /**
   * ID of the default payment method for the invoice. It must belong to the customer associated
   * with the invoice. If not set, defaults to the subscription's default payment method, if any, or
   * to the default payment method in the customer's invoice settings.
   */
  @SerializedName("default_payment_method")
  ExpandableField<PaymentMethod> defaultPaymentMethod;
  /**
   * ID of the default payment source for the invoice. It must belong to the customer associated
   * with the invoice and be in a chargeable state. If not set, defaults to the subscription's
   * default source, if any, or to the customer's default source.
   */
  @SerializedName("default_source")
  ExpandableField<PaymentSource> defaultSource;
  /**
   * The tax rates applied to this invoice, if any.
   */
  @SerializedName("default_tax_rates")
  List<TaxRate> defaultTaxRates;
  /**
   * Always true for a deleted object.
   */
  @SerializedName("deleted")
  Boolean deleted;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users. Referenced as
   * 'memo' in the Dashboard.
   */
  @SerializedName("description")
  String description;
  /**
   * Describes the current discount applied to this invoice, if there is one. Not populated if there
   * are multiple discounts.
   */
  @SerializedName("discount")
  Discount discount;
  /**
   * The discounts applied to the invoice. Line item discounts are applied before invoice discounts.
   * Use {@code expand[]=discounts} to expand each discount.
   */
  @SerializedName("discounts")
  List<ExpandableField<Discount>> discounts;
  /**
   * The date on which payment for this invoice is due. This value will be {@code null} for invoices
   * where {@code collection_method=charge_automatically}.
   */
  @SerializedName("due_date")
  Long dueDate;
  /**
   * Ending customer balance after the invoice is finalized. Invoices are finalized approximately an
   * hour after successful webhook delivery or when payment collection is attempted for the invoice.
   * If the invoice has not been finalized yet, this will be null.
   */
  @SerializedName("ending_balance")
  Long endingBalance;
  /**
   * Footer displayed on the invoice.
   */
  @SerializedName("footer")
  String footer;
  /**
   * The URL for the hosted invoice page, which allows customers to view and pay an invoice. If the
   * invoice has not been finalized yet, this will be null.
   */
  @SerializedName("hosted_invoice_url")
  String hostedInvoiceUrl;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * The link to download the PDF for the invoice. If the invoice has not been finalized yet, this
   * will be null.
   */
  @SerializedName("invoice_pdf")
  String invoicePdf;
  /**
   * The error encountered during the previous attempt to finalize the invoice. This field is
   * cleared when the invoice is successfully finalized.
   */
  @SerializedName("last_finalization_error")
  StripeError lastFinalizationError;
  /**
   * The individual line items that make up the invoice. {@code lines} is sorted as follows: invoice
   * items in reverse chronological order, followed by the subscription, if any.
   */
  @SerializedName("lines")
  InvoiceLineItemCollection lines;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * The time at which payment will next be attempted. This value will be {@code null} for invoices
   * where {@code collection_method=send_invoice}.
   */
  @SerializedName("next_payment_attempt")
  Long nextPaymentAttempt;
  /**
   * A unique, identifying string that appears on emails sent to the customer for this invoice. This
   * starts with the customer's unique invoice_prefix if it is specified.
   */
  @SerializedName("number")
  String number;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code invoice}.
   */
  @SerializedName("object")
  String object;
  /**
   * The account (if any) for which the funds of the invoice payment are intended. If set, the
   * invoice will be presented with the branding and support information of the specified account.
   * See the <a href="https://stripe.com/docs/billing/invoices/connect">Invoices with Connect</a>
   * documentation for details.
   */
  @SerializedName("on_behalf_of")
  ExpandableField<Account> onBehalfOf;
  /**
   * Whether payment was successfully collected for this invoice. An invoice can be paid (most
   * commonly) with a charge or with credit from the customer's account balance.
   */
  @SerializedName("paid")
  Boolean paid;
  /**
   * Returns true if the invoice was manually marked paid, returns false if the invoice hasn't been
   * paid yet or was paid on Stripe.
   */
  @SerializedName("paid_out_of_band")
  Boolean paidOutOfBand;
  /**
   * The PaymentIntent associated with this invoice. The PaymentIntent is generated when the invoice
   * is finalized, and can then be used to pay the invoice. Note that voiding an invoice will cancel
   * the PaymentIntent.
   */
  @SerializedName("payment_intent")
  ExpandableField<PaymentIntent> paymentIntent;
  @SerializedName("payment_settings")
  PaymentSettings paymentSettings;
  /**
   * End of the usage period during which invoice items were added to this invoice.
   */
  @SerializedName("period_end")
  Long periodEnd;
  /**
   * Start of the usage period during which invoice items were added to this invoice.
   */
  @SerializedName("period_start")
  Long periodStart;
  /**
   * Total amount of all post-payment credit notes issued for this invoice.
   */
  @SerializedName("post_payment_credit_notes_amount")
  Long postPaymentCreditNotesAmount;
  /**
   * Total amount of all pre-payment credit notes issued for this invoice.
   */
  @SerializedName("pre_payment_credit_notes_amount")
  Long prePaymentCreditNotesAmount;
  /**
   * The quote this invoice was generated from.
   */
  @SerializedName("quote")
  ExpandableField<Quote> quote;
  /**
   * This is the transaction number that appears on email receipts sent for this invoice.
   */
  @SerializedName("receipt_number")
  String receiptNumber;
  /**
   * Options for invoice PDF rendering.
   */
  @SerializedName("rendering_options")
  RenderingOptions renderingOptions;
  /**
   * Starting customer balance before the invoice is finalized. If the invoice has not been
   * finalized yet, this will be the current customer balance.
   */
  @SerializedName("starting_balance")
  Long startingBalance;
  /**
   * Extra information about an invoice for the customer's credit card statement.
   */
  @SerializedName("statement_descriptor")
  String statementDescriptor;
  /**
   * The status of the invoice, one of {@code draft}, {@code open}, {@code paid}, {@code
   * uncollectible}, or {@code void}. <a
   * href="https://stripe.com/docs/billing/invoices/workflow#workflow-overview">Learn more</a>
   */
  @SerializedName("status")
  String status;
  @SerializedName("status_transitions")
  StatusTransitions statusTransitions;
  /**
   * The subscription that this invoice was prepared for, if any.
   */
  @SerializedName("subscription")
  ExpandableField<Subscription> subscription;
  /**
   * Only set for upcoming invoices that preview prorations. The time used to calculate prorations.
   */
  @SerializedName("subscription_proration_date")
  Long subscriptionProrationDate;
  /**
   * Total of all subscriptions, invoice items, and prorations on the invoice before any invoice
   * level discount or exclusive tax is applied. Item discounts are already incorporated
   */
  @SerializedName("subtotal")
  Long subtotal;
  /**
   * The integer amount in %s representing the subtotal of the invoice before any invoice level
   * discount or tax is applied. Item discounts are already incorporated
   */
  @SerializedName("subtotal_excluding_tax")
  Long subtotalExcludingTax;
  /**
   * The amount of tax on this invoice. This is the sum of all the tax amounts on this invoice.
   */
  @SerializedName("tax")
  Long tax;
  /**
   * ID of the test clock this invoice belongs to.
   */
  @SerializedName("test_clock")
  ExpandableField<TestClock> testClock;
  @SerializedName("threshold_reason")
  ThresholdReason thresholdReason;
  /**
   * Total after discounts and taxes.
   */
  @SerializedName("total")
  Long total;
  /**
   * The aggregate amounts calculated per discount across all line items.
   */
  @SerializedName("total_discount_amounts")
  List<DiscountAmount> totalDiscountAmounts;
  /**
   * The integer amount in %s representing the total amount of the invoice including all discounts
   * but excluding all tax.
   */
  @SerializedName("total_excluding_tax")
  Long totalExcludingTax;
  /**
   * The aggregate amounts calculated per tax rate for all line items.
   */
  @SerializedName("total_tax_amounts")
  List<Invoice.TaxAmount> totalTaxAmounts;
  /**
   * The account (if any) the payment will be attributed to for tax reporting, and where funds from
   * the payment will be transferred to for the invoice.
   */
  @SerializedName("transfer_data")
  TransferData transferData;
  /**
   * Invoices are automatically paid or sent 1 hour after webhooks are delivered, or until all
   * webhook delivery attempts have <a
   * href="https://stripe.com/docs/billing/webhooks#understand">been exhausted</a>. This field
   * tracks the time when webhooks for this invoice were successfully delivered. If the invoice had
   * no webhooks to deliver, this will be set while the invoice is being created.
   */
  @SerializedName("webhooks_delivered_at")
  Long webhooksDeliveredAt;

  /**
   * Get ID of expandable {@code application} object.
   */
  public String getApplication() {
    return (this.application != null) ? this.application.getId() : null;
  }

  public void setApplication(String id) {
    this.application = ApiResource.setExpandableFieldId(id, this.application);
  }

  /**
   * Get expanded {@code application}.
   */
  public Application getApplicationObject() {
    return (this.application != null) ? this.application.getExpanded() : null;
  }

  public void setApplicationObject(Application expandableObject) {
    this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code charge} object.
   */
  public String getCharge() {
    return (this.charge != null) ? this.charge.getId() : null;
  }

  public void setCharge(String id) {
    this.charge = ApiResource.setExpandableFieldId(id, this.charge);
  }

  /**
   * Get expanded {@code charge}.
   */
  public Charge getChargeObject() {
    return (this.charge != null) ? this.charge.getExpanded() : null;
  }

  public void setChargeObject(Charge expandableObject) {
    this.charge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code customer} object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded {@code customer}.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code defaultPaymentMethod} object.
   */
  public String getDefaultPaymentMethod() {
    return (this.defaultPaymentMethod != null) ? this.defaultPaymentMethod.getId() : null;
  }

  public void setDefaultPaymentMethod(String id) {
    this.defaultPaymentMethod = ApiResource.setExpandableFieldId(id, this.defaultPaymentMethod);
  }

  /**
   * Get expanded {@code defaultPaymentMethod}.
   */
  public PaymentMethod getDefaultPaymentMethodObject() {
    return (this.defaultPaymentMethod != null) ? this.defaultPaymentMethod.getExpanded() : null;
  }

  public void setDefaultPaymentMethodObject(PaymentMethod expandableObject) {
    this.defaultPaymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code defaultSource} object.
   */
  public String getDefaultSource() {
    return (this.defaultSource != null) ? this.defaultSource.getId() : null;
  }

  public void setDefaultSource(String id) {
    this.defaultSource = ApiResource.setExpandableFieldId(id, this.defaultSource);
  }

  /**
   * Get expanded {@code defaultSource}.
   */
  public PaymentSource getDefaultSourceObject() {
    return (this.defaultSource != null) ? this.defaultSource.getExpanded() : null;
  }

  public void setDefaultSourceObject(PaymentSource expandableObject) {
    this.defaultSource = new ExpandableField<PaymentSource>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code onBehalfOf} object.
   */
  public String getOnBehalfOf() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getId() : null;
  }

  public void setOnBehalfOf(String id) {
    this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
  }

  /**
   * Get expanded {@code onBehalfOf}.
   */
  public Account getOnBehalfOfObject() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getExpanded() : null;
  }

  public void setOnBehalfOfObject(Account expandableObject) {
    this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code paymentIntent} object.
   */
  public String getPaymentIntent() {
    return (this.paymentIntent != null) ? this.paymentIntent.getId() : null;
  }

  public void setPaymentIntent(String id) {
    this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
  }

  /**
   * Get expanded {@code paymentIntent}.
   */
  public PaymentIntent getPaymentIntentObject() {
    return (this.paymentIntent != null) ? this.paymentIntent.getExpanded() : null;
  }

  public void setPaymentIntentObject(PaymentIntent expandableObject) {
    this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code quote} object.
   */
  public String getQuote() {
    return (this.quote != null) ? this.quote.getId() : null;
  }

  public void setQuote(String id) {
    this.quote = ApiResource.setExpandableFieldId(id, this.quote);
  }

  /**
   * Get expanded {@code quote}.
   */
  public Quote getQuoteObject() {
    return (this.quote != null) ? this.quote.getExpanded() : null;
  }

  public void setQuoteObject(Quote expandableObject) {
    this.quote = new ExpandableField<Quote>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code subscription} object.
   */
  public String getSubscription() {
    return (this.subscription != null) ? this.subscription.getId() : null;
  }

  public void setSubscription(String id) {
    this.subscription = ApiResource.setExpandableFieldId(id, this.subscription);
  }

  /**
   * Get expanded {@code subscription}.
   */
  public Subscription getSubscriptionObject() {
    return (this.subscription != null) ? this.subscription.getExpanded() : null;
  }

  public void setSubscriptionObject(Subscription expandableObject) {
    this.subscription = new ExpandableField<Subscription>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code testClock} object.
   */
  public String getTestClock() {
    return (this.testClock != null) ? this.testClock.getId() : null;
  }

  public void setTestClock(String id) {
    this.testClock = ApiResource.setExpandableFieldId(id, this.testClock);
  }

  /**
   * Get expanded {@code testClock}.
   */
  public TestClock getTestClockObject() {
    return (this.testClock != null) ? this.testClock.getExpanded() : null;
  }

  public void setTestClockObject(TestClock expandableObject) {
    this.testClock = new ExpandableField<TestClock>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get IDs of expandable {@code accountTaxIds} object list.
   */
  public List<String> getAccountTaxIds() {
    return (this.accountTaxIds != null) ? this.accountTaxIds.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
  }

  public void setAccountTaxIds(List<String> ids) {
    if (ids == null) {
      this.accountTaxIds = null;
      return;
    }
    if (this.accountTaxIds != null && this.accountTaxIds.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
      // noop if the ids are equal to what are already present
      return;
    }
    this.accountTaxIds = (ids != null) ? ids.stream().map(id -> new ExpandableField<TaxId>(id, null)).collect(Collectors.toList()) : null;
  }

  /**
   * Get expanded {@code accountTaxIds}.
   */
  public List<TaxId> getAccountTaxIdObjects() {
    return (this.accountTaxIds != null) ? this.accountTaxIds.stream().map(x -> x.getExpanded()).collect(Collectors.toList()) : null;
  }

  public void setAccountTaxIdObjects(List<TaxId> objs) {
    this.accountTaxIds = objs != null ? objs.stream().map(x -> new ExpandableField<TaxId>(x.getId(), x)).collect(Collectors.toList()) : null;
  }

  /**
   * Get IDs of expandable {@code discounts} object list.
   */
  public List<String> getDiscounts() {
    return (this.discounts != null) ? this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
  }

  public void setDiscounts(List<String> ids) {
    if (ids == null) {
      this.discounts = null;
      return;
    }
    if (this.discounts != null && this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
      // noop if the ids are equal to what are already present
      return;
    }
    this.discounts = (ids != null) ? ids.stream().map(id -> new ExpandableField<Discount>(id, null)).collect(Collectors.toList()) : null;
  }

  /**
   * Get expanded {@code discounts}.
   */
  public List<Discount> getDiscountObjects() {
    return (this.discounts != null) ? this.discounts.stream().map(x -> x.getExpanded()).collect(Collectors.toList()) : null;
  }

  public void setDiscountObjects(List<Discount> objs) {
    this.discounts = objs != null ? objs.stream().map(x -> new ExpandableField<Discount>(x.getId(), x)).collect(Collectors.toList()) : null;
  }

  /**
   * Search for invoices you’ve previously created using Stripe’s <a
   * href="https://stripe.com/docs/search#search-query-language">Search Query Language</a>. Don’t
   * use search in read-after-write flows where strict consistency is necessary. Under normal
   * operating conditions, data is searchable in less than a minute. Occasionally, propagation of
   * new or updated data can be up to an hour behind during outages. Search functionality is not
   * available to merchants in India.
   */
  public static InvoiceSearchResult search(Map<String, Object> params) throws StripeException {
    return search(params, (RequestOptions) null);
  }

  /**
   * Search for invoices you’ve previously created using Stripe’s <a
   * href="https://stripe.com/docs/search#search-query-language">Search Query Language</a>. Don’t
   * use search in read-after-write flows where strict consistency is necessary. Under normal
   * operating conditions, data is searchable in less than a minute. Occasionally, propagation of
   * new or updated data can be up to an hour behind during outages. Search functionality is not
   * available to merchants in India.
   */
  public static InvoiceSearchResult search(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/invoices/search");
    return ApiResource.requestSearchResult(url, params, InvoiceSearchResult.class, options);
  }

  /**
   * Search for invoices you’ve previously created using Stripe’s <a
   * href="https://stripe.com/docs/search#search-query-language">Search Query Language</a>. Don’t
   * use search in read-after-write flows where strict consistency is necessary. Under normal
   * operating conditions, data is searchable in less than a minute. Occasionally, propagation of
   * new or updated data can be up to an hour behind during outages. Search functionality is not
   * available to merchants in India.
   */
  public static InvoiceSearchResult search(InvoiceSearchParams params) throws StripeException {
    return search(params, (RequestOptions) null);
  }

  /**
   * Search for invoices you’ve previously created using Stripe’s <a
   * href="https://stripe.com/docs/search#search-query-language">Search Query Language</a>. Don’t
   * use search in read-after-write flows where strict consistency is necessary. Under normal
   * operating conditions, data is searchable in less than a minute. Occasionally, propagation of
   * new or updated data can be up to an hour behind during outages. Search functionality is not
   * available to merchants in India.
   */
  public static InvoiceSearchResult search(InvoiceSearchParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/invoices/search");
    return ApiResource.requestSearchResult(url, params, InvoiceSearchResult.class, options);
  }

  /**
   * You can list all invoices, or list the invoices for a specific customer. The invoices are
   * returned sorted by creation date, with the most recently created invoices appearing first.
   */
  public static InvoiceCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * You can list all invoices, or list the invoices for a specific customer. The invoices are
   * returned sorted by creation date, with the most recently created invoices appearing first.
   */
  public static InvoiceCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/invoices");
    return ApiResource.requestCollection(url, params, InvoiceCollection.class, options);
  }

  /**
   * You can list all invoices, or list the invoices for a specific customer. The invoices are
   * returned sorted by creation date, with the most recently created invoices appearing first.
   */
  public static InvoiceCollection list(InvoiceListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * You can list all invoices, or list the invoices for a specific customer. The invoices are
   * returned sorted by creation date, with the most recently created invoices appearing first.
   */
  public static InvoiceCollection list(InvoiceListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/invoices");
    return ApiResource.requestCollection(url, params, InvoiceCollection.class, options);
  }

  /**
   * At any time, you can preview the upcoming invoice for a customer. This will show you all the
   * charges that are pending, including subscription renewal charges, invoice item charges, etc. It
   * will also show you any discounts that are applicable to the invoice.
   *
   * <p>Note that when you are viewing an upcoming invoice, you are simply viewing a preview – the
   * invoice has not yet been created. As such, the upcoming invoice will not show up in invoice
   * listing calls, and you cannot use the API to pay or edit the invoice. If you want to change the
   * amount that your customer will be billed, you can add, remove, or update pending invoice items,
   * or update the customer’s discount.
   *
   * <p>You can preview the effects of updating a subscription, including a preview of what
   * proration will take place. To ensure that the actual proration is calculated exactly the same
   * as the previewed proration, you should pass a <code>proration_date</code> parameter when doing
   * the actual subscription update. The value passed in should be the same as the <code>
   * subscription_proration_date</code> returned on the upcoming invoice resource. The recommended
   * way to get only the prorations being previewed is to consider only proration line items where
   * <code>period[start]</code> is equal to the <code>subscription_proration_date</code> on the
   * upcoming invoice resource.
   */
  public static Invoice upcoming() throws StripeException {
    return upcoming((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * At any time, you can preview the upcoming invoice for a customer. This will show you all the
   * charges that are pending, including subscription renewal charges, invoice item charges, etc. It
   * will also show you any discounts that are applicable to the invoice.
   *
   * <p>Note that when you are viewing an upcoming invoice, you are simply viewing a preview – the
   * invoice has not yet been created. As such, the upcoming invoice will not show up in invoice
   * listing calls, and you cannot use the API to pay or edit the invoice. If you want to change the
   * amount that your customer will be billed, you can add, remove, or update pending invoice items,
   * or update the customer’s discount.
   *
   * <p>You can preview the effects of updating a subscription, including a preview of what
   * proration will take place. To ensure that the actual proration is calculated exactly the same
   * as the previewed proration, you should pass a <code>proration_date</code> parameter when doing
   * the actual subscription update. The value passed in should be the same as the <code>
   * subscription_proration_date</code> returned on the upcoming invoice resource. The recommended
   * way to get only the prorations being previewed is to consider only proration line items where
   * <code>period[start]</code> is equal to the <code>subscription_proration_date</code> on the
   * upcoming invoice resource.
   */
  public static Invoice upcoming(Map<String, Object> params) throws StripeException {
    return upcoming(params, (RequestOptions) null);
  }

  /**
   * At any time, you can preview the upcoming invoice for a customer. This will show you all the
   * charges that are pending, including subscription renewal charges, invoice item charges, etc. It
   * will also show you any discounts that are applicable to the invoice.
   *
   * <p>Note that when you are viewing an upcoming invoice, you are simply viewing a preview – the
   * invoice has not yet been created. As such, the upcoming invoice will not show up in invoice
   * listing calls, and you cannot use the API to pay or edit the invoice. If you want to change the
   * amount that your customer will be billed, you can add, remove, or update pending invoice items,
   * or update the customer’s discount.
   *
   * <p>You can preview the effects of updating a subscription, including a preview of what
   * proration will take place. To ensure that the actual proration is calculated exactly the same
   * as the previewed proration, you should pass a <code>proration_date</code> parameter when doing
   * the actual subscription update. The value passed in should be the same as the <code>
   * subscription_proration_date</code> returned on the upcoming invoice resource. The recommended
   * way to get only the prorations being previewed is to consider only proration line items where
   * <code>period[start]</code> is equal to the <code>subscription_proration_date</code> on the
   * upcoming invoice resource.
   */
  public static Invoice upcoming(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/invoices/upcoming");
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Invoice.class, options);
  }

  /**
   * At any time, you can preview the upcoming invoice for a customer. This will show you all the
   * charges that are pending, including subscription renewal charges, invoice item charges, etc. It
   * will also show you any discounts that are applicable to the invoice.
   *
   * <p>Note that when you are viewing an upcoming invoice, you are simply viewing a preview – the
   * invoice has not yet been created. As such, the upcoming invoice will not show up in invoice
   * listing calls, and you cannot use the API to pay or edit the invoice. If you want to change the
   * amount that your customer will be billed, you can add, remove, or update pending invoice items,
   * or update the customer’s discount.
   *
   * <p>You can preview the effects of updating a subscription, including a preview of what
   * proration will take place. To ensure that the actual proration is calculated exactly the same
   * as the previewed proration, you should pass a <code>proration_date</code> parameter when doing
   * the actual subscription update. The value passed in should be the same as the <code>
   * subscription_proration_date</code> returned on the upcoming invoice resource. The recommended
   * way to get only the prorations being previewed is to consider only proration line items where
   * <code>period[start]</code> is equal to the <code>subscription_proration_date</code> on the
   * upcoming invoice resource.
   */
  public static Invoice upcoming(InvoiceUpcomingParams params) throws StripeException {
    return upcoming(params, (RequestOptions) null);
  }

  /**
   * At any time, you can preview the upcoming invoice for a customer. This will show you all the
   * charges that are pending, including subscription renewal charges, invoice item charges, etc. It
   * will also show you any discounts that are applicable to the invoice.
   *
   * <p>Note that when you are viewing an upcoming invoice, you are simply viewing a preview – the
   * invoice has not yet been created. As such, the upcoming invoice will not show up in invoice
   * listing calls, and you cannot use the API to pay or edit the invoice. If you want to change the
   * amount that your customer will be billed, you can add, remove, or update pending invoice items,
   * or update the customer’s discount.
   *
   * <p>You can preview the effects of updating a subscription, including a preview of what
   * proration will take place. To ensure that the actual proration is calculated exactly the same
   * as the previewed proration, you should pass a <code>proration_date</code> parameter when doing
   * the actual subscription update. The value passed in should be the same as the <code>
   * subscription_proration_date</code> returned on the upcoming invoice resource. The recommended
   * way to get only the prorations being previewed is to consider only proration line items where
   * <code>period[start]</code> is equal to the <code>subscription_proration_date</code> on the
   * upcoming invoice resource.
   */
  public static Invoice upcoming(InvoiceUpcomingParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/invoices/upcoming");
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Invoice.class, options);
  }

  /**
   * This endpoint creates a draft invoice for a given customer. The draft invoice created pulls in
   * all pending invoice items on that customer, including prorations. The invoice remains a draft
   * until you <a href="https://stripe.com/docs/api#finalize_invoice">finalize</a> the invoice,
   * which allows you to <a href="https://stripe.com/docs/api#pay_invoice">pay</a> or <a
   * href="https://stripe.com/docs/api#send_invoice">send</a> the invoice to your customers.
   */
  public static Invoice create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * This endpoint creates a draft invoice for a given customer. The draft invoice created pulls in
   * all pending invoice items on that customer, including prorations. The invoice remains a draft
   * until you <a href="https://stripe.com/docs/api#finalize_invoice">finalize</a> the invoice,
   * which allows you to <a href="https://stripe.com/docs/api#pay_invoice">pay</a> or <a
   * href="https://stripe.com/docs/api#send_invoice">send</a> the invoice to your customers.
   */
  public static Invoice create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/invoices");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
  }

  /**
   * This endpoint creates a draft invoice for a given customer. The draft invoice created pulls in
   * all pending invoice items on that customer, including prorations. The invoice remains a draft
   * until you <a href="https://stripe.com/docs/api#finalize_invoice">finalize</a> the invoice,
   * which allows you to <a href="https://stripe.com/docs/api#pay_invoice">pay</a> or <a
   * href="https://stripe.com/docs/api#send_invoice">send</a> the invoice to your customers.
   */
  public static Invoice create(InvoiceCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * This endpoint creates a draft invoice for a given customer. The draft invoice created pulls in
   * all pending invoice items on that customer, including prorations. The invoice remains a draft
   * until you <a href="https://stripe.com/docs/api#finalize_invoice">finalize</a> the invoice,
   * which allows you to <a href="https://stripe.com/docs/api#pay_invoice">pay</a> or <a
   * href="https://stripe.com/docs/api#send_invoice">send</a> the invoice to your customers.
   */
  public static Invoice create(InvoiceCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/invoices");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
  }

  /**
   * Retrieves the invoice with the given ID.
   */
  public static Invoice retrieve(String invoice) throws StripeException {
    return retrieve(invoice, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the invoice with the given ID.
   */
  public static Invoice retrieve(String invoice, RequestOptions options) throws StripeException {
    return retrieve(invoice, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the invoice with the given ID.
   */
  public static Invoice retrieve(String invoice, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoices/%s", ApiResource.urlEncodeId(invoice)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Invoice.class, options);
  }

  /**
   * Retrieves the invoice with the given ID.
   */
  public static Invoice retrieve(String invoice, InvoiceRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoices/%s", ApiResource.urlEncodeId(invoice)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Invoice.class, options);
  }

  /**
   * Draft invoices are fully editable. Once an invoice is <a
   * href="https://stripe.com/docs/billing/invoices/workflow#finalized">finalized</a>, monetary
   * values, as well as <code>collection_method</code>, become uneditable.
   *
   * <p>If you would like to stop the Stripe Billing engine from automatically finalizing,
   * reattempting payments on, sending reminders for, or <a
   * href="https://stripe.com/docs/billing/invoices/reconciliation">automatically reconciling</a>
   * invoices, pass <code>auto_advance=false</code>.
   */
  @Override
  public Invoice update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Draft invoices are fully editable. Once an invoice is <a
   * href="https://stripe.com/docs/billing/invoices/workflow#finalized">finalized</a>, monetary
   * values, as well as <code>collection_method</code>, become uneditable.
   *
   * <p>If you would like to stop the Stripe Billing engine from automatically finalizing,
   * reattempting payments on, sending reminders for, or <a
   * href="https://stripe.com/docs/billing/invoices/reconciliation">automatically reconciling</a>
   * invoices, pass <code>auto_advance=false</code>.
   */
  @Override
  public Invoice update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoices/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
  }

  /**
   * Draft invoices are fully editable. Once an invoice is <a
   * href="https://stripe.com/docs/billing/invoices/workflow#finalized">finalized</a>, monetary
   * values, as well as <code>collection_method</code>, become uneditable.
   *
   * <p>If you would like to stop the Stripe Billing engine from automatically finalizing,
   * reattempting payments on, sending reminders for, or <a
   * href="https://stripe.com/docs/billing/invoices/reconciliation">automatically reconciling</a>
   * invoices, pass <code>auto_advance=false</code>.
   */
  public Invoice update(InvoiceUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Draft invoices are fully editable. Once an invoice is <a
   * href="https://stripe.com/docs/billing/invoices/workflow#finalized">finalized</a>, monetary
   * values, as well as <code>collection_method</code>, become uneditable.
   *
   * <p>If you would like to stop the Stripe Billing engine from automatically finalizing,
   * reattempting payments on, sending reminders for, or <a
   * href="https://stripe.com/docs/billing/invoices/reconciliation">automatically reconciling</a>
   * invoices, pass <code>auto_advance=false</code>.
   */
  public Invoice update(InvoiceUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoices/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
  }

  /**
   * Permanently deletes a one-off invoice draft. This cannot be undone. Attempts to delete invoices
   * that are no longer in a draft state will fail; once an invoice has been finalized or if an
   * invoice is for a subscription, it must be <a
   * href="https://stripe.com/docs/api#void_invoice">voided</a>.
   */
  public Invoice delete() throws StripeException {
    return delete((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Permanently deletes a one-off invoice draft. This cannot be undone. Attempts to delete invoices
   * that are no longer in a draft state will fail; once an invoice has been finalized or if an
   * invoice is for a subscription, it must be <a
   * href="https://stripe.com/docs/api#void_invoice">voided</a>.
   */
  public Invoice delete(RequestOptions options) throws StripeException {
    return delete((Map<String, Object>) null, options);
  }

  /**
   * Permanently deletes a one-off invoice draft. This cannot be undone. Attempts to delete invoices
   * that are no longer in a draft state will fail; once an invoice has been finalized or if an
   * invoice is for a subscription, it must be <a
   * href="https://stripe.com/docs/api#void_invoice">voided</a>.
   */
  public Invoice delete(Map<String, Object> params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * Permanently deletes a one-off invoice draft. This cannot be undone. Attempts to delete invoices
   * that are no longer in a draft state will fail; once an invoice has been finalized or if an
   * invoice is for a subscription, it must be <a
   * href="https://stripe.com/docs/api#void_invoice">voided</a>.
   */
  public Invoice delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoices/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Invoice.class, options);
  }

  /**
   * Stripe automatically creates and then attempts to collect payment on invoices for customers on
   * subscriptions according to your <a
   * href="https://dashboard.stripe.com/account/billing/automatic">subscriptions settings</a>.
   * However, if you’d like to attempt payment on an invoice out of the normal collection schedule
   * or for some other reason, you can do so.
   */
  public Invoice pay() throws StripeException {
    return pay((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Stripe automatically creates and then attempts to collect payment on invoices for customers on
   * subscriptions according to your <a
   * href="https://dashboard.stripe.com/account/billing/automatic">subscriptions settings</a>.
   * However, if you’d like to attempt payment on an invoice out of the normal collection schedule
   * or for some other reason, you can do so.
   */
  public Invoice pay(RequestOptions options) throws StripeException {
    return pay((Map<String, Object>) null, options);
  }

  /**
   * Stripe automatically creates and then attempts to collect payment on invoices for customers on
   * subscriptions according to your <a
   * href="https://dashboard.stripe.com/account/billing/automatic">subscriptions settings</a>.
   * However, if you’d like to attempt payment on an invoice out of the normal collection schedule
   * or for some other reason, you can do so.
   */
  public Invoice pay(Map<String, Object> params) throws StripeException {
    return pay(params, (RequestOptions) null);
  }

  /**
   * Stripe automatically creates and then attempts to collect payment on invoices for customers on
   * subscriptions according to your <a
   * href="https://dashboard.stripe.com/account/billing/automatic">subscriptions settings</a>.
   * However, if you’d like to attempt payment on an invoice out of the normal collection schedule
   * or for some other reason, you can do so.
   */
  public Invoice pay(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoices/%s/pay", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
  }

  /**
   * Stripe automatically creates and then attempts to collect payment on invoices for customers on
   * subscriptions according to your <a
   * href="https://dashboard.stripe.com/account/billing/automatic">subscriptions settings</a>.
   * However, if you’d like to attempt payment on an invoice out of the normal collection schedule
   * or for some other reason, you can do so.
   */
  public Invoice pay(InvoicePayParams params) throws StripeException {
    return pay(params, (RequestOptions) null);
  }

  /**
   * Stripe automatically creates and then attempts to collect payment on invoices for customers on
   * subscriptions according to your <a
   * href="https://dashboard.stripe.com/account/billing/automatic">subscriptions settings</a>.
   * However, if you’d like to attempt payment on an invoice out of the normal collection schedule
   * or for some other reason, you can do so.
   */
  public Invoice pay(InvoicePayParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoices/%s/pay", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
  }

  /**
   * Stripe automatically finalizes drafts before sending and attempting payment on invoices.
   * However, if you’d like to finalize a draft invoice manually, you can do so using this method.
   */
  public Invoice finalizeInvoice() throws StripeException {
    return finalizeInvoice((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Stripe automatically finalizes drafts before sending and attempting payment on invoices.
   * However, if you’d like to finalize a draft invoice manually, you can do so using this method.
   */
  public Invoice finalizeInvoice(RequestOptions options) throws StripeException {
    return finalizeInvoice((Map<String, Object>) null, options);
  }

  /**
   * Stripe automatically finalizes drafts before sending and attempting payment on invoices.
   * However, if you’d like to finalize a draft invoice manually, you can do so using this method.
   */
  public Invoice finalizeInvoice(Map<String, Object> params) throws StripeException {
    return finalizeInvoice(params, (RequestOptions) null);
  }

  /**
   * Stripe automatically finalizes drafts before sending and attempting payment on invoices.
   * However, if you’d like to finalize a draft invoice manually, you can do so using this method.
   */
  public Invoice finalizeInvoice(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoices/%s/finalize", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
  }

  /**
   * Stripe automatically finalizes drafts before sending and attempting payment on invoices.
   * However, if you’d like to finalize a draft invoice manually, you can do so using this method.
   */
  public Invoice finalizeInvoice(InvoiceFinalizeInvoiceParams params) throws StripeException {
    return finalizeInvoice(params, (RequestOptions) null);
  }

  /**
   * Stripe automatically finalizes drafts before sending and attempting payment on invoices.
   * However, if you’d like to finalize a draft invoice manually, you can do so using this method.
   */
  public Invoice finalizeInvoice(InvoiceFinalizeInvoiceParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoices/%s/finalize", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
  }

  /**
   * Stripe will automatically send invoices to customers according to your <a
   * href="https://dashboard.stripe.com/account/billing/automatic">subscriptions settings</a>.
   * However, if you’d like to manually send an invoice to your customer out of the normal schedule,
   * you can do so. When sending invoices that have already been paid, there will be no reference to
   * the payment in the email.
   *
   * <p>Requests made in test-mode result in no emails being sent, despite sending an <code>
   * invoice.sent</code> event.
   */
  public Invoice sendInvoice() throws StripeException {
    return sendInvoice((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Stripe will automatically send invoices to customers according to your <a
   * href="https://dashboard.stripe.com/account/billing/automatic">subscriptions settings</a>.
   * However, if you’d like to manually send an invoice to your customer out of the normal schedule,
   * you can do so. When sending invoices that have already been paid, there will be no reference to
   * the payment in the email.
   *
   * <p>Requests made in test-mode result in no emails being sent, despite sending an <code>
   * invoice.sent</code> event.
   */
  public Invoice sendInvoice(RequestOptions options) throws StripeException {
    return sendInvoice((Map<String, Object>) null, options);
  }

  /**
   * Stripe will automatically send invoices to customers according to your <a
   * href="https://dashboard.stripe.com/account/billing/automatic">subscriptions settings</a>.
   * However, if you’d like to manually send an invoice to your customer out of the normal schedule,
   * you can do so. When sending invoices that have already been paid, there will be no reference to
   * the payment in the email.
   *
   * <p>Requests made in test-mode result in no emails being sent, despite sending an <code>
   * invoice.sent</code> event.
   */
  public Invoice sendInvoice(Map<String, Object> params) throws StripeException {
    return sendInvoice(params, (RequestOptions) null);
  }

  /**
   * Stripe will automatically send invoices to customers according to your <a
   * href="https://dashboard.stripe.com/account/billing/automatic">subscriptions settings</a>.
   * However, if you’d like to manually send an invoice to your customer out of the normal schedule,
   * you can do so. When sending invoices that have already been paid, there will be no reference to
   * the payment in the email.
   *
   * <p>Requests made in test-mode result in no emails being sent, despite sending an <code>
   * invoice.sent</code> event.
   */
  public Invoice sendInvoice(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoices/%s/send", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
  }

  /**
   * Stripe will automatically send invoices to customers according to your <a
   * href="https://dashboard.stripe.com/account/billing/automatic">subscriptions settings</a>.
   * However, if you’d like to manually send an invoice to your customer out of the normal schedule,
   * you can do so. When sending invoices that have already been paid, there will be no reference to
   * the payment in the email.
   *
   * <p>Requests made in test-mode result in no emails being sent, despite sending an <code>
   * invoice.sent</code> event.
   */
  public Invoice sendInvoice(InvoiceSendInvoiceParams params) throws StripeException {
    return sendInvoice(params, (RequestOptions) null);
  }

  /**
   * Stripe will automatically send invoices to customers according to your <a
   * href="https://dashboard.stripe.com/account/billing/automatic">subscriptions settings</a>.
   * However, if you’d like to manually send an invoice to your customer out of the normal schedule,
   * you can do so. When sending invoices that have already been paid, there will be no reference to
   * the payment in the email.
   *
   * <p>Requests made in test-mode result in no emails being sent, despite sending an <code>
   * invoice.sent</code> event.
   */
  public Invoice sendInvoice(InvoiceSendInvoiceParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoices/%s/send", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
  }

  /**
   * Marking an invoice as uncollectible is useful for keeping track of bad debts that can be
   * written off for accounting purposes.
   */
  public Invoice markUncollectible() throws StripeException {
    return markUncollectible((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Marking an invoice as uncollectible is useful for keeping track of bad debts that can be
   * written off for accounting purposes.
   */
  public Invoice markUncollectible(RequestOptions options) throws StripeException {
    return markUncollectible((Map<String, Object>) null, options);
  }

  /**
   * Marking an invoice as uncollectible is useful for keeping track of bad debts that can be
   * written off for accounting purposes.
   */
  public Invoice markUncollectible(Map<String, Object> params) throws StripeException {
    return markUncollectible(params, (RequestOptions) null);
  }

  /**
   * Marking an invoice as uncollectible is useful for keeping track of bad debts that can be
   * written off for accounting purposes.
   */
  public Invoice markUncollectible(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoices/%s/mark_uncollectible", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
  }

  /**
   * Marking an invoice as uncollectible is useful for keeping track of bad debts that can be
   * written off for accounting purposes.
   */
  public Invoice markUncollectible(InvoiceMarkUncollectibleParams params) throws StripeException {
    return markUncollectible(params, (RequestOptions) null);
  }

  /**
   * Marking an invoice as uncollectible is useful for keeping track of bad debts that can be
   * written off for accounting purposes.
   */
  public Invoice markUncollectible(InvoiceMarkUncollectibleParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoices/%s/mark_uncollectible", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
  }

  /**
   * Mark a finalized invoice as void. This cannot be undone. Voiding an invoice is similar to <a
   * href="https://stripe.com/docs/api#delete_invoice">deletion</a>, however it only applies to
   * finalized invoices and maintains a papertrail where the invoice can still be found.
   */
  public Invoice voidInvoice() throws StripeException {
    return voidInvoice((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Mark a finalized invoice as void. This cannot be undone. Voiding an invoice is similar to <a
   * href="https://stripe.com/docs/api#delete_invoice">deletion</a>, however it only applies to
   * finalized invoices and maintains a papertrail where the invoice can still be found.
   */
  public Invoice voidInvoice(RequestOptions options) throws StripeException {
    return voidInvoice((Map<String, Object>) null, options);
  }

  /**
   * Mark a finalized invoice as void. This cannot be undone. Voiding an invoice is similar to <a
   * href="https://stripe.com/docs/api#delete_invoice">deletion</a>, however it only applies to
   * finalized invoices and maintains a papertrail where the invoice can still be found.
   */
  public Invoice voidInvoice(Map<String, Object> params) throws StripeException {
    return voidInvoice(params, (RequestOptions) null);
  }

  /**
   * Mark a finalized invoice as void. This cannot be undone. Voiding an invoice is similar to <a
   * href="https://stripe.com/docs/api#delete_invoice">deletion</a>, however it only applies to
   * finalized invoices and maintains a papertrail where the invoice can still be found.
   */
  public Invoice voidInvoice(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoices/%s/void", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
  }

  /**
   * Mark a finalized invoice as void. This cannot be undone. Voiding an invoice is similar to <a
   * href="https://stripe.com/docs/api#delete_invoice">deletion</a>, however it only applies to
   * finalized invoices and maintains a papertrail where the invoice can still be found.
   */
  public Invoice voidInvoice(InvoiceVoidInvoiceParams params) throws StripeException {
    return voidInvoice(params, (RequestOptions) null);
  }

  /**
   * Mark a finalized invoice as void. This cannot be undone. Voiding an invoice is similar to <a
   * href="https://stripe.com/docs/api#delete_invoice">deletion</a>, however it only applies to
   * finalized invoices and maintains a papertrail where the invoice can still be found.
   */
  public Invoice voidInvoice(InvoiceVoidInvoiceParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/invoices/%s/void", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Invoice.class, options);
  }


  public static class AutomaticTax extends StripeObject {
    /**
     * Whether Stripe automatically computes tax on this invoice. Note that incompatible invoice
     * items (invoice items with manually specified <a
     * href="https://stripe.com/docs/api/tax_rates">tax rates</a>, negative amounts, or {@code
     * tax_behavior=unspecified}) cannot be added to automatic tax invoices.
     */
    @SerializedName("enabled")
    Boolean enabled;
    /**
     * The status of the most recent automated tax calculation for this invoice.
     *
     * <p>One of {@code complete}, {@code failed}, or {@code requires_location_inputs}.
     */
    @SerializedName("status")
    String status;

    /**
     * Whether Stripe automatically computes tax on this invoice. Note that incompatible invoice
     * items (invoice items with manually specified <a
     * href="https://stripe.com/docs/api/tax_rates">tax rates</a>, negative amounts, or {@code
     * tax_behavior=unspecified}) cannot be added to automatic tax invoices.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getEnabled() {
      return this.enabled;
    }

    /**
     * The status of the most recent automated tax calculation for this invoice.
     *
     * <p>One of {@code complete}, {@code failed}, or {@code requires_location_inputs}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    /**
     * Whether Stripe automatically computes tax on this invoice. Note that incompatible invoice
     * items (invoice items with manually specified <a
     * href="https://stripe.com/docs/api/tax_rates">tax rates</a>, negative amounts, or {@code
     * tax_behavior=unspecified}) cannot be added to automatic tax invoices.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEnabled(final Boolean enabled) {
      this.enabled = enabled;
    }

    /**
     * The status of the most recent automated tax calculation for this invoice.
     *
     * <p>One of {@code complete}, {@code failed}, or {@code requires_location_inputs}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Invoice.AutomaticTax)) return false;
      final Invoice.AutomaticTax other = (Invoice.AutomaticTax) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$enabled = this.getEnabled();
      final java.lang.Object other$enabled = other.getEnabled();
      if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Invoice.AutomaticTax;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $enabled = this.getEnabled();
      result = result * PRIME + ($enabled == null ? 43 : $enabled.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      return result;
    }
  }


  public static class CustomField extends StripeObject {
    /**
     * The name of the custom field.
     */
    @SerializedName("name")
    String name;
    /**
     * The value of the custom field.
     */
    @SerializedName("value")
    String value;

    /**
     * The name of the custom field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    /**
     * The value of the custom field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }

    /**
     * The name of the custom field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
      this.name = name;
    }

    /**
     * The value of the custom field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setValue(final String value) {
      this.value = value;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Invoice.CustomField)) return false;
      final Invoice.CustomField other = (Invoice.CustomField) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$name = this.getName();
      final java.lang.Object other$name = other.getName();
      if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
      final java.lang.Object this$value = this.getValue();
      final java.lang.Object other$value = other.getValue();
      if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Invoice.CustomField;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $name = this.getName();
      result = result * PRIME + ($name == null ? 43 : $name.hashCode());
      final java.lang.Object $value = this.getValue();
      result = result * PRIME + ($value == null ? 43 : $value.hashCode());
      return result;
    }
  }


  public static class CustomerTaxId extends StripeObject {
    /**
     * The type of the tax ID, one of {@code eu_vat}, {@code br_cnpj}, {@code br_cpf}, {@code
     * eu_oss_vat}, {@code gb_vat}, {@code nz_gst}, {@code au_abn}, {@code au_arn}, {@code in_gst},
     * {@code no_vat}, {@code za_vat}, {@code ch_vat}, {@code mx_rfc}, {@code sg_uen}, {@code
     * ru_inn}, {@code ru_kpp}, {@code ca_bn}, {@code hk_br}, {@code es_cif}, {@code tw_vat}, {@code
     * th_vat}, {@code jp_cn}, {@code jp_rn}, {@code li_uid}, {@code my_itn}, {@code us_ein}, {@code
     * kr_brn}, {@code ca_qst}, {@code ca_gst_hst}, {@code ca_pst_bc}, {@code ca_pst_mb}, {@code
     * ca_pst_sk}, {@code my_sst}, {@code sg_gst}, {@code ae_trn}, {@code cl_tin}, {@code sa_vat},
     * {@code id_npwp}, {@code my_frp}, {@code il_vat}, {@code ge_vat}, {@code ua_vat}, {@code
     * is_vat}, {@code bg_uic}, {@code hu_tin}, {@code si_tin}, or {@code unknown}.
     */
    @SerializedName("type")
    String type;
    /**
     * The value of the tax ID.
     */
    @SerializedName("value")
    String value;

    /**
     * The type of the tax ID, one of {@code eu_vat}, {@code br_cnpj}, {@code br_cpf}, {@code
     * eu_oss_vat}, {@code gb_vat}, {@code nz_gst}, {@code au_abn}, {@code au_arn}, {@code in_gst},
     * {@code no_vat}, {@code za_vat}, {@code ch_vat}, {@code mx_rfc}, {@code sg_uen}, {@code
     * ru_inn}, {@code ru_kpp}, {@code ca_bn}, {@code hk_br}, {@code es_cif}, {@code tw_vat}, {@code
     * th_vat}, {@code jp_cn}, {@code jp_rn}, {@code li_uid}, {@code my_itn}, {@code us_ein}, {@code
     * kr_brn}, {@code ca_qst}, {@code ca_gst_hst}, {@code ca_pst_bc}, {@code ca_pst_mb}, {@code
     * ca_pst_sk}, {@code my_sst}, {@code sg_gst}, {@code ae_trn}, {@code cl_tin}, {@code sa_vat},
     * {@code id_npwp}, {@code my_frp}, {@code il_vat}, {@code ge_vat}, {@code ua_vat}, {@code
     * is_vat}, {@code bg_uic}, {@code hu_tin}, {@code si_tin}, or {@code unknown}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    /**
     * The value of the tax ID.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
      return this.value;
    }

    /**
     * The type of the tax ID, one of {@code eu_vat}, {@code br_cnpj}, {@code br_cpf}, {@code
     * eu_oss_vat}, {@code gb_vat}, {@code nz_gst}, {@code au_abn}, {@code au_arn}, {@code in_gst},
     * {@code no_vat}, {@code za_vat}, {@code ch_vat}, {@code mx_rfc}, {@code sg_uen}, {@code
     * ru_inn}, {@code ru_kpp}, {@code ca_bn}, {@code hk_br}, {@code es_cif}, {@code tw_vat}, {@code
     * th_vat}, {@code jp_cn}, {@code jp_rn}, {@code li_uid}, {@code my_itn}, {@code us_ein}, {@code
     * kr_brn}, {@code ca_qst}, {@code ca_gst_hst}, {@code ca_pst_bc}, {@code ca_pst_mb}, {@code
     * ca_pst_sk}, {@code my_sst}, {@code sg_gst}, {@code ae_trn}, {@code cl_tin}, {@code sa_vat},
     * {@code id_npwp}, {@code my_frp}, {@code il_vat}, {@code ge_vat}, {@code ua_vat}, {@code
     * is_vat}, {@code bg_uic}, {@code hu_tin}, {@code si_tin}, or {@code unknown}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    /**
     * The value of the tax ID.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setValue(final String value) {
      this.value = value;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Invoice.CustomerTaxId)) return false;
      final Invoice.CustomerTaxId other = (Invoice.CustomerTaxId) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      final java.lang.Object this$value = this.getValue();
      final java.lang.Object other$value = other.getValue();
      if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Invoice.CustomerTaxId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      final java.lang.Object $value = this.getValue();
      result = result * PRIME + ($value == null ? 43 : $value.hashCode());
      return result;
    }
  }


  public static class DiscountAmount extends StripeObject {
    /**
     * The amount, in %s, of the discount.
     */
    @SerializedName("amount")
    Long amount;
    /**
     * The discount that was applied to get this discount amount.
     */
    @SerializedName("discount")
    ExpandableField<Discount> discount;

    /**
     * Get ID of expandable {@code discount} object.
     */
    public String getDiscount() {
      return (this.discount != null) ? this.discount.getId() : null;
    }

    public void setDiscount(String id) {
      this.discount = ApiResource.setExpandableFieldId(id, this.discount);
    }

    /**
     * Get expanded {@code discount}.
     */
    public Discount getDiscountObject() {
      return (this.discount != null) ? this.discount.getExpanded() : null;
    }

    public void setDiscountObject(Discount expandableObject) {
      this.discount = new ExpandableField<Discount>(expandableObject.getId(), expandableObject);
    }

    /**
     * The amount, in %s, of the discount.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    /**
     * The amount, in %s, of the discount.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Invoice.DiscountAmount)) return false;
      final Invoice.DiscountAmount other = (Invoice.DiscountAmount) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$discount = this.getDiscount();
      final java.lang.Object other$discount = other.getDiscount();
      if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Invoice.DiscountAmount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $discount = this.getDiscount();
      result = result * PRIME + ($discount == null ? 43 : $discount.hashCode());
      return result;
    }
  }


  public static class PaymentMethodOptions extends StripeObject {
    /**
     * If paying by {@code acss_debit}, this sub-hash contains details about the Canadian
     * pre-authorized debit payment method options to pass to the invoice’s PaymentIntent.
     */
    @SerializedName("acss_debit")
    AcssDebit acssDebit;
    /**
     * If paying by {@code bancontact}, this sub-hash contains details about the Bancontact payment
     * method options to pass to the invoice’s PaymentIntent.
     */
    @SerializedName("bancontact")
    Bancontact bancontact;
    /**
     * If paying by {@code card}, this sub-hash contains details about the Card payment method
     * options to pass to the invoice’s PaymentIntent.
     */
    @SerializedName("card")
    Card card;
    /**
     * If paying by {@code customer_balance}, this sub-hash contains details about the Bank transfer
     * payment method options to pass to the invoice’s PaymentIntent.
     */
    @SerializedName("customer_balance")
    CustomerBalance customerBalance;
    /**
     * If paying by {@code konbini}, this sub-hash contains details about the Konbini payment method
     * options to pass to the invoice’s PaymentIntent.
     */
    @SerializedName("konbini")
    Konbini konbini;
    /**
     * If paying by {@code us_bank_account}, this sub-hash contains details about the ACH direct
     * debit payment method options to pass to the invoice’s PaymentIntent.
     */
    @SerializedName("us_bank_account")
    UsBankAccount usBankAccount;


    public static class AcssDebit extends StripeObject {
      @SerializedName("mandate_options")
      MandateOptions mandateOptions;
      /**
       * Bank account verification method.
       *
       * <p>One of {@code automatic}, {@code instant}, or {@code microdeposits}.
       */
      @SerializedName("verification_method")
      String verificationMethod;


      public static class MandateOptions extends StripeObject {
        @SerializedName("transaction_type")
        String transactionType;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getTransactionType() {
          return this.transactionType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setTransactionType(final String transactionType) {
          this.transactionType = transactionType;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Invoice.PaymentMethodOptions.AcssDebit.MandateOptions)) return false;
          final Invoice.PaymentMethodOptions.AcssDebit.MandateOptions other = (Invoice.PaymentMethodOptions.AcssDebit.MandateOptions) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$transactionType = this.getTransactionType();
          final java.lang.Object other$transactionType = other.getTransactionType();
          if (this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Invoice.PaymentMethodOptions.AcssDebit.MandateOptions;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $transactionType = this.getTransactionType();
          result = result * PRIME + ($transactionType == null ? 43 : $transactionType.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public MandateOptions getMandateOptions() {
        return this.mandateOptions;
      }

      /**
       * Bank account verification method.
       *
       * <p>One of {@code automatic}, {@code instant}, or {@code microdeposits}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getVerificationMethod() {
        return this.verificationMethod;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMandateOptions(final MandateOptions mandateOptions) {
        this.mandateOptions = mandateOptions;
      }

      /**
       * Bank account verification method.
       *
       * <p>One of {@code automatic}, {@code instant}, or {@code microdeposits}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setVerificationMethod(final String verificationMethod) {
        this.verificationMethod = verificationMethod;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Invoice.PaymentMethodOptions.AcssDebit)) return false;
        final Invoice.PaymentMethodOptions.AcssDebit other = (Invoice.PaymentMethodOptions.AcssDebit) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$mandateOptions = this.getMandateOptions();
        final java.lang.Object other$mandateOptions = other.getMandateOptions();
        if (this$mandateOptions == null ? other$mandateOptions != null : !this$mandateOptions.equals(other$mandateOptions)) return false;
        final java.lang.Object this$verificationMethod = this.getVerificationMethod();
        final java.lang.Object other$verificationMethod = other.getVerificationMethod();
        if (this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Invoice.PaymentMethodOptions.AcssDebit;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $mandateOptions = this.getMandateOptions();
        result = result * PRIME + ($mandateOptions == null ? 43 : $mandateOptions.hashCode());
        final java.lang.Object $verificationMethod = this.getVerificationMethod();
        result = result * PRIME + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
        return result;
      }
    }


    /**
     * Transaction type of the mandate.
     *
     * <p>One of {@code business}, or {@code personal}.
     */
    public static class Bancontact extends StripeObject {
      /**
       * Preferred language of the Bancontact authorization page that the customer is redirected to.
       *
       * <p>One of {@code de}, {@code en}, {@code fr}, or {@code nl}.
       */
      @SerializedName("preferred_language")
      String preferredLanguage;

      /**
       * Preferred language of the Bancontact authorization page that the customer is redirected to.
       *
       * <p>One of {@code de}, {@code en}, {@code fr}, or {@code nl}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getPreferredLanguage() {
        return this.preferredLanguage;
      }

      /**
       * Preferred language of the Bancontact authorization page that the customer is redirected to.
       *
       * <p>One of {@code de}, {@code en}, {@code fr}, or {@code nl}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPreferredLanguage(final String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Invoice.PaymentMethodOptions.Bancontact)) return false;
        final Invoice.PaymentMethodOptions.Bancontact other = (Invoice.PaymentMethodOptions.Bancontact) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$preferredLanguage = this.getPreferredLanguage();
        final java.lang.Object other$preferredLanguage = other.getPreferredLanguage();
        if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Invoice.PaymentMethodOptions.Bancontact;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $preferredLanguage = this.getPreferredLanguage();
        result = result * PRIME + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
        return result;
      }
    }


    public static class Card extends StripeObject {
      @SerializedName("installments")
      Installments installments;
      /**
       * We strongly recommend that you rely on our SCA Engine to automatically prompt your
       * customers for authentication based on risk level and <a
       * href="https://stripe.com/docs/strong-customer-authentication">other requirements</a>.
       * However, if you wish to request 3D Secure based on logic from your own fraud engine,
       * provide this option. Read our guide on <a
       * href="https://stripe.com/docs/payments/3d-secure#manual-three-ds">manually requesting 3D
       * Secure</a> for more information on how this configuration interacts with Radar and our SCA
       * Engine.
       *
       * <p>One of {@code any}, or {@code automatic}.
       */
      @SerializedName("request_three_d_secure")
      String requestThreeDSecure;


      public static class Installments extends StripeObject {
        @SerializedName("enabled")
        Boolean enabled;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getEnabled() {
          return this.enabled;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setEnabled(final Boolean enabled) {
          this.enabled = enabled;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Invoice.PaymentMethodOptions.Card.Installments)) return false;
          final Invoice.PaymentMethodOptions.Card.Installments other = (Invoice.PaymentMethodOptions.Card.Installments) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$enabled = this.getEnabled();
          final java.lang.Object other$enabled = other.getEnabled();
          if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Invoice.PaymentMethodOptions.Card.Installments;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $enabled = this.getEnabled();
          result = result * PRIME + ($enabled == null ? 43 : $enabled.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Installments getInstallments() {
        return this.installments;
      }

      /**
       * We strongly recommend that you rely on our SCA Engine to automatically prompt your
       * customers for authentication based on risk level and <a
       * href="https://stripe.com/docs/strong-customer-authentication">other requirements</a>.
       * However, if you wish to request 3D Secure based on logic from your own fraud engine,
       * provide this option. Read our guide on <a
       * href="https://stripe.com/docs/payments/3d-secure#manual-three-ds">manually requesting 3D
       * Secure</a> for more information on how this configuration interacts with Radar and our SCA
       * Engine.
       *
       * <p>One of {@code any}, or {@code automatic}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRequestThreeDSecure() {
        return this.requestThreeDSecure;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setInstallments(final Installments installments) {
        this.installments = installments;
      }

      /**
       * We strongly recommend that you rely on our SCA Engine to automatically prompt your
       * customers for authentication based on risk level and <a
       * href="https://stripe.com/docs/strong-customer-authentication">other requirements</a>.
       * However, if you wish to request 3D Secure based on logic from your own fraud engine,
       * provide this option. Read our guide on <a
       * href="https://stripe.com/docs/payments/3d-secure#manual-three-ds">manually requesting 3D
       * Secure</a> for more information on how this configuration interacts with Radar and our SCA
       * Engine.
       *
       * <p>One of {@code any}, or {@code automatic}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequestThreeDSecure(final String requestThreeDSecure) {
        this.requestThreeDSecure = requestThreeDSecure;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Invoice.PaymentMethodOptions.Card)) return false;
        final Invoice.PaymentMethodOptions.Card other = (Invoice.PaymentMethodOptions.Card) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$installments = this.getInstallments();
        final java.lang.Object other$installments = other.getInstallments();
        if (this$installments == null ? other$installments != null : !this$installments.equals(other$installments)) return false;
        final java.lang.Object this$requestThreeDSecure = this.getRequestThreeDSecure();
        final java.lang.Object other$requestThreeDSecure = other.getRequestThreeDSecure();
        if (this$requestThreeDSecure == null ? other$requestThreeDSecure != null : !this$requestThreeDSecure.equals(other$requestThreeDSecure)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Invoice.PaymentMethodOptions.Card;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $installments = this.getInstallments();
        result = result * PRIME + ($installments == null ? 43 : $installments.hashCode());
        final java.lang.Object $requestThreeDSecure = this.getRequestThreeDSecure();
        result = result * PRIME + ($requestThreeDSecure == null ? 43 : $requestThreeDSecure.hashCode());
        return result;
      }
    }


    /**
     * Whether Installments are enabled for this Invoice.
     */
    public static class CustomerBalance extends StripeObject {
      @SerializedName("bank_transfer")
      BankTransfer bankTransfer;
      /**
       * The funding method type to be used when there are not enough funds in the customer balance.
       * Permitted values include: {@code bank_transfer}.
       *
       * <p>Equal to {@code bank_transfer}.
       */
      @SerializedName("funding_type")
      String fundingType;


      public static class BankTransfer extends StripeObject {
        @SerializedName("eu_bank_transfer")
        EuBankTransfer euBankTransfer;
        /**
         * The bank transfer type that can be used for funding. Permitted values include: {@code
         * eu_bank_transfer}, {@code gb_bank_transfer}, {@code jp_bank_transfer}, or {@code
         * mx_bank_transfer}.
         */
        @SerializedName("type")
        String type;


        public static class EuBankTransfer extends StripeObject {
          @SerializedName("country")
          String country;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getCountry() {
            return this.country;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setCountry(final String country) {
            this.country = country;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Invoice.PaymentMethodOptions.CustomerBalance.BankTransfer.EuBankTransfer)) return false;
            final Invoice.PaymentMethodOptions.CustomerBalance.BankTransfer.EuBankTransfer other = (Invoice.PaymentMethodOptions.CustomerBalance.BankTransfer.EuBankTransfer) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$country = this.getCountry();
            final java.lang.Object other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Invoice.PaymentMethodOptions.CustomerBalance.BankTransfer.EuBankTransfer;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $country = this.getCountry();
            result = result * PRIME + ($country == null ? 43 : $country.hashCode());
            return result;
          }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public EuBankTransfer getEuBankTransfer() {
          return this.euBankTransfer;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getType() {
          return this.type;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setEuBankTransfer(final EuBankTransfer euBankTransfer) {
          this.euBankTransfer = euBankTransfer;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setType(final String type) {
          this.type = type;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Invoice.PaymentMethodOptions.CustomerBalance.BankTransfer)) return false;
          final Invoice.PaymentMethodOptions.CustomerBalance.BankTransfer other = (Invoice.PaymentMethodOptions.CustomerBalance.BankTransfer) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$euBankTransfer = this.getEuBankTransfer();
          final java.lang.Object other$euBankTransfer = other.getEuBankTransfer();
          if (this$euBankTransfer == null ? other$euBankTransfer != null : !this$euBankTransfer.equals(other$euBankTransfer)) return false;
          final java.lang.Object this$type = this.getType();
          final java.lang.Object other$type = other.getType();
          if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Invoice.PaymentMethodOptions.CustomerBalance.BankTransfer;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $euBankTransfer = this.getEuBankTransfer();
          result = result * PRIME + ($euBankTransfer == null ? 43 : $euBankTransfer.hashCode());
          final java.lang.Object $type = this.getType();
          result = result * PRIME + ($type == null ? 43 : $type.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public BankTransfer getBankTransfer() {
        return this.bankTransfer;
      }

      /**
       * The funding method type to be used when there are not enough funds in the customer balance.
       * Permitted values include: {@code bank_transfer}.
       *
       * <p>Equal to {@code bank_transfer}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFundingType() {
        return this.fundingType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankTransfer(final BankTransfer bankTransfer) {
        this.bankTransfer = bankTransfer;
      }

      /**
       * The funding method type to be used when there are not enough funds in the customer balance.
       * Permitted values include: {@code bank_transfer}.
       *
       * <p>Equal to {@code bank_transfer}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFundingType(final String fundingType) {
        this.fundingType = fundingType;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Invoice.PaymentMethodOptions.CustomerBalance)) return false;
        final Invoice.PaymentMethodOptions.CustomerBalance other = (Invoice.PaymentMethodOptions.CustomerBalance) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$bankTransfer = this.getBankTransfer();
        final java.lang.Object other$bankTransfer = other.getBankTransfer();
        if (this$bankTransfer == null ? other$bankTransfer != null : !this$bankTransfer.equals(other$bankTransfer)) return false;
        final java.lang.Object this$fundingType = this.getFundingType();
        final java.lang.Object other$fundingType = other.getFundingType();
        if (this$fundingType == null ? other$fundingType != null : !this$fundingType.equals(other$fundingType)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Invoice.PaymentMethodOptions.CustomerBalance;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $bankTransfer = this.getBankTransfer();
        result = result * PRIME + ($bankTransfer == null ? 43 : $bankTransfer.hashCode());
        final java.lang.Object $fundingType = this.getFundingType();
        result = result * PRIME + ($fundingType == null ? 43 : $fundingType.hashCode());
        return result;
      }
    }


    /**
     * The desired country code of the bank account information. Permitted values include:
     * {@code DE}, {@code ES}, {@code FR}, {@code IE}, or {@code NL}.
     *
     * <p>One of {@code DE}, {@code ES}, {@code FR}, {@code IE}, or {@code NL}.
     */
    public static class Konbini extends StripeObject {
      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Invoice.PaymentMethodOptions.Konbini)) return false;
        final Invoice.PaymentMethodOptions.Konbini other = (Invoice.PaymentMethodOptions.Konbini) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Invoice.PaymentMethodOptions.Konbini;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int result = 1;
        return result;
      }
    }


    public static class UsBankAccount extends StripeObject {
      @SerializedName("financial_connections")
      FinancialConnections financialConnections;
      /**
       * Bank account verification method.
       *
       * <p>One of {@code automatic}, {@code instant}, or {@code microdeposits}.
       */
      @SerializedName("verification_method")
      String verificationMethod;


      public static class FinancialConnections extends StripeObject {
        @SerializedName("permissions")
        List<String> permissions;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getPermissions() {
          return this.permissions;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setPermissions(final List<String> permissions) {
          this.permissions = permissions;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Invoice.PaymentMethodOptions.UsBankAccount.FinancialConnections)) return false;
          final Invoice.PaymentMethodOptions.UsBankAccount.FinancialConnections other = (Invoice.PaymentMethodOptions.UsBankAccount.FinancialConnections) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$permissions = this.getPermissions();
          final java.lang.Object other$permissions = other.getPermissions();
          if (this$permissions == null ? other$permissions != null : !this$permissions.equals(other$permissions)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Invoice.PaymentMethodOptions.UsBankAccount.FinancialConnections;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $permissions = this.getPermissions();
          result = result * PRIME + ($permissions == null ? 43 : $permissions.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public FinancialConnections getFinancialConnections() {
        return this.financialConnections;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getVerificationMethod() {
        return this.verificationMethod;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFinancialConnections(final FinancialConnections financialConnections) {
        this.financialConnections = financialConnections;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setVerificationMethod(final String verificationMethod) {
        this.verificationMethod = verificationMethod;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Invoice.PaymentMethodOptions.UsBankAccount)) return false;
        final Invoice.PaymentMethodOptions.UsBankAccount other = (Invoice.PaymentMethodOptions.UsBankAccount) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$financialConnections = this.getFinancialConnections();
        final java.lang.Object other$financialConnections = other.getFinancialConnections();
        if (this$financialConnections == null ? other$financialConnections != null : !this$financialConnections.equals(other$financialConnections)) return false;
        final java.lang.Object this$verificationMethod = this.getVerificationMethod();
        final java.lang.Object other$verificationMethod = other.getVerificationMethod();
        if (this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Invoice.PaymentMethodOptions.UsBankAccount;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $financialConnections = this.getFinancialConnections();
        result = result * PRIME + ($financialConnections == null ? 43 : $financialConnections.hashCode());
        final java.lang.Object $verificationMethod = this.getVerificationMethod();
        result = result * PRIME + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
        return result;
      }
    }

    /**
     * If paying by {@code acss_debit}, this sub-hash contains details about the Canadian
     * pre-authorized debit payment method options to pass to the invoice’s PaymentIntent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AcssDebit getAcssDebit() {
      return this.acssDebit;
    }

    /**
     * If paying by {@code bancontact}, this sub-hash contains details about the Bancontact payment
     * method options to pass to the invoice’s PaymentIntent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Bancontact getBancontact() {
      return this.bancontact;
    }

    /**
     * If paying by {@code card}, this sub-hash contains details about the Card payment method
     * options to pass to the invoice’s PaymentIntent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Card getCard() {
      return this.card;
    }

    /**
     * If paying by {@code customer_balance}, this sub-hash contains details about the Bank transfer
     * payment method options to pass to the invoice’s PaymentIntent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CustomerBalance getCustomerBalance() {
      return this.customerBalance;
    }

    /**
     * If paying by {@code konbini}, this sub-hash contains details about the Konbini payment method
     * options to pass to the invoice’s PaymentIntent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Konbini getKonbini() {
      return this.konbini;
    }

    /**
     * If paying by {@code us_bank_account}, this sub-hash contains details about the ACH direct
     * debit payment method options to pass to the invoice’s PaymentIntent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UsBankAccount getUsBankAccount() {
      return this.usBankAccount;
    }

    /**
     * If paying by {@code acss_debit}, this sub-hash contains details about the Canadian
     * pre-authorized debit payment method options to pass to the invoice’s PaymentIntent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAcssDebit(final AcssDebit acssDebit) {
      this.acssDebit = acssDebit;
    }

    /**
     * If paying by {@code bancontact}, this sub-hash contains details about the Bancontact payment
     * method options to pass to the invoice’s PaymentIntent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBancontact(final Bancontact bancontact) {
      this.bancontact = bancontact;
    }

    /**
     * If paying by {@code card}, this sub-hash contains details about the Card payment method
     * options to pass to the invoice’s PaymentIntent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCard(final Card card) {
      this.card = card;
    }

    /**
     * If paying by {@code customer_balance}, this sub-hash contains details about the Bank transfer
     * payment method options to pass to the invoice’s PaymentIntent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCustomerBalance(final CustomerBalance customerBalance) {
      this.customerBalance = customerBalance;
    }

    /**
     * If paying by {@code konbini}, this sub-hash contains details about the Konbini payment method
     * options to pass to the invoice’s PaymentIntent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setKonbini(final Konbini konbini) {
      this.konbini = konbini;
    }

    /**
     * If paying by {@code us_bank_account}, this sub-hash contains details about the ACH direct
     * debit payment method options to pass to the invoice’s PaymentIntent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUsBankAccount(final UsBankAccount usBankAccount) {
      this.usBankAccount = usBankAccount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Invoice.PaymentMethodOptions)) return false;
      final Invoice.PaymentMethodOptions other = (Invoice.PaymentMethodOptions) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$acssDebit = this.getAcssDebit();
      final java.lang.Object other$acssDebit = other.getAcssDebit();
      if (this$acssDebit == null ? other$acssDebit != null : !this$acssDebit.equals(other$acssDebit)) return false;
      final java.lang.Object this$bancontact = this.getBancontact();
      final java.lang.Object other$bancontact = other.getBancontact();
      if (this$bancontact == null ? other$bancontact != null : !this$bancontact.equals(other$bancontact)) return false;
      final java.lang.Object this$card = this.getCard();
      final java.lang.Object other$card = other.getCard();
      if (this$card == null ? other$card != null : !this$card.equals(other$card)) return false;
      final java.lang.Object this$customerBalance = this.getCustomerBalance();
      final java.lang.Object other$customerBalance = other.getCustomerBalance();
      if (this$customerBalance == null ? other$customerBalance != null : !this$customerBalance.equals(other$customerBalance)) return false;
      final java.lang.Object this$konbini = this.getKonbini();
      final java.lang.Object other$konbini = other.getKonbini();
      if (this$konbini == null ? other$konbini != null : !this$konbini.equals(other$konbini)) return false;
      final java.lang.Object this$usBankAccount = this.getUsBankAccount();
      final java.lang.Object other$usBankAccount = other.getUsBankAccount();
      if (this$usBankAccount == null ? other$usBankAccount != null : !this$usBankAccount.equals(other$usBankAccount)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Invoice.PaymentMethodOptions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $acssDebit = this.getAcssDebit();
      result = result * PRIME + ($acssDebit == null ? 43 : $acssDebit.hashCode());
      final java.lang.Object $bancontact = this.getBancontact();
      result = result * PRIME + ($bancontact == null ? 43 : $bancontact.hashCode());
      final java.lang.Object $card = this.getCard();
      result = result * PRIME + ($card == null ? 43 : $card.hashCode());
      final java.lang.Object $customerBalance = this.getCustomerBalance();
      result = result * PRIME + ($customerBalance == null ? 43 : $customerBalance.hashCode());
      final java.lang.Object $konbini = this.getKonbini();
      result = result * PRIME + ($konbini == null ? 43 : $konbini.hashCode());
      final java.lang.Object $usBankAccount = this.getUsBankAccount();
      result = result * PRIME + ($usBankAccount == null ? 43 : $usBankAccount.hashCode());
      return result;
    }
  }


  /**
   * The list of permissions to request. The {@code payment_method} permission must be
   * included.
   */
  public static class PaymentSettings extends StripeObject {
    /**
     * ID of the mandate to be used for this invoice. It must correspond to the payment method used
     * to pay the invoice, including the invoice's default_payment_method or default_source, if set.
     */
    @SerializedName("default_mandate")
    String defaultMandate;
    /**
     * Payment-method-specific configuration to provide to the invoice’s PaymentIntent.
     */
    @SerializedName("payment_method_options")
    PaymentMethodOptions paymentMethodOptions;
    /**
     * The list of payment method types (e.g. card) to provide to the invoice’s PaymentIntent. If
     * not set, Stripe attempts to automatically determine the types to use by looking at the
     * invoice’s default payment method, the subscription’s default payment method, the customer’s
     * default payment method, and your <a
     * href="https://dashboard.stripe.com/settings/billing/invoice">invoice template settings</a>.
     */
    @SerializedName("payment_method_types")
    List<String> paymentMethodTypes;

    /**
     * ID of the mandate to be used for this invoice. It must correspond to the payment method used
     * to pay the invoice, including the invoice's default_payment_method or default_source, if set.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDefaultMandate() {
      return this.defaultMandate;
    }

    /**
     * Payment-method-specific configuration to provide to the invoice’s PaymentIntent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PaymentMethodOptions getPaymentMethodOptions() {
      return this.paymentMethodOptions;
    }

    /**
     * The list of payment method types (e.g. card) to provide to the invoice’s PaymentIntent. If
     * not set, Stripe attempts to automatically determine the types to use by looking at the
     * invoice’s default payment method, the subscription’s default payment method, the customer’s
     * default payment method, and your <a
     * href="https://dashboard.stripe.com/settings/billing/invoice">invoice template settings</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getPaymentMethodTypes() {
      return this.paymentMethodTypes;
    }

    /**
     * ID of the mandate to be used for this invoice. It must correspond to the payment method used
     * to pay the invoice, including the invoice's default_payment_method or default_source, if set.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDefaultMandate(final String defaultMandate) {
      this.defaultMandate = defaultMandate;
    }

    /**
     * Payment-method-specific configuration to provide to the invoice’s PaymentIntent.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPaymentMethodOptions(final PaymentMethodOptions paymentMethodOptions) {
      this.paymentMethodOptions = paymentMethodOptions;
    }

    /**
     * The list of payment method types (e.g. card) to provide to the invoice’s PaymentIntent. If
     * not set, Stripe attempts to automatically determine the types to use by looking at the
     * invoice’s default payment method, the subscription’s default payment method, the customer’s
     * default payment method, and your <a
     * href="https://dashboard.stripe.com/settings/billing/invoice">invoice template settings</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPaymentMethodTypes(final List<String> paymentMethodTypes) {
      this.paymentMethodTypes = paymentMethodTypes;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Invoice.PaymentSettings)) return false;
      final Invoice.PaymentSettings other = (Invoice.PaymentSettings) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$defaultMandate = this.getDefaultMandate();
      final java.lang.Object other$defaultMandate = other.getDefaultMandate();
      if (this$defaultMandate == null ? other$defaultMandate != null : !this$defaultMandate.equals(other$defaultMandate)) return false;
      final java.lang.Object this$paymentMethodOptions = this.getPaymentMethodOptions();
      final java.lang.Object other$paymentMethodOptions = other.getPaymentMethodOptions();
      if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !this$paymentMethodOptions.equals(other$paymentMethodOptions)) return false;
      final java.lang.Object this$paymentMethodTypes = this.getPaymentMethodTypes();
      final java.lang.Object other$paymentMethodTypes = other.getPaymentMethodTypes();
      if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !this$paymentMethodTypes.equals(other$paymentMethodTypes)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Invoice.PaymentSettings;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $defaultMandate = this.getDefaultMandate();
      result = result * PRIME + ($defaultMandate == null ? 43 : $defaultMandate.hashCode());
      final java.lang.Object $paymentMethodOptions = this.getPaymentMethodOptions();
      result = result * PRIME + ($paymentMethodOptions == null ? 43 : $paymentMethodOptions.hashCode());
      final java.lang.Object $paymentMethodTypes = this.getPaymentMethodTypes();
      result = result * PRIME + ($paymentMethodTypes == null ? 43 : $paymentMethodTypes.hashCode());
      return result;
    }
  }


  public static class RenderingOptions extends StripeObject {
    /**
     * How line-item prices and amounts will be displayed with respect to tax on invoice PDFs.
     */
    @SerializedName("amount_tax_display")
    String amountTaxDisplay;

    /**
     * How line-item prices and amounts will be displayed with respect to tax on invoice PDFs.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAmountTaxDisplay() {
      return this.amountTaxDisplay;
    }

    /**
     * How line-item prices and amounts will be displayed with respect to tax on invoice PDFs.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountTaxDisplay(final String amountTaxDisplay) {
      this.amountTaxDisplay = amountTaxDisplay;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Invoice.RenderingOptions)) return false;
      final Invoice.RenderingOptions other = (Invoice.RenderingOptions) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amountTaxDisplay = this.getAmountTaxDisplay();
      final java.lang.Object other$amountTaxDisplay = other.getAmountTaxDisplay();
      if (this$amountTaxDisplay == null ? other$amountTaxDisplay != null : !this$amountTaxDisplay.equals(other$amountTaxDisplay)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Invoice.RenderingOptions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amountTaxDisplay = this.getAmountTaxDisplay();
      result = result * PRIME + ($amountTaxDisplay == null ? 43 : $amountTaxDisplay.hashCode());
      return result;
    }
  }


  public static class StatusTransitions extends StripeObject {
    /**
     * The time that the invoice draft was finalized.
     */
    @SerializedName("finalized_at")
    Long finalizedAt;
    /**
     * The time that the invoice was marked uncollectible.
     */
    @SerializedName("marked_uncollectible_at")
    Long markedUncollectibleAt;
    /**
     * The time that the invoice was paid.
     */
    @SerializedName("paid_at")
    Long paidAt;
    /**
     * The time that the invoice was voided.
     */
    @SerializedName("voided_at")
    Long voidedAt;

    /**
     * The time that the invoice draft was finalized.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getFinalizedAt() {
      return this.finalizedAt;
    }

    /**
     * The time that the invoice was marked uncollectible.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMarkedUncollectibleAt() {
      return this.markedUncollectibleAt;
    }

    /**
     * The time that the invoice was paid.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPaidAt() {
      return this.paidAt;
    }

    /**
     * The time that the invoice was voided.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getVoidedAt() {
      return this.voidedAt;
    }

    /**
     * The time that the invoice draft was finalized.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFinalizedAt(final Long finalizedAt) {
      this.finalizedAt = finalizedAt;
    }

    /**
     * The time that the invoice was marked uncollectible.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMarkedUncollectibleAt(final Long markedUncollectibleAt) {
      this.markedUncollectibleAt = markedUncollectibleAt;
    }

    /**
     * The time that the invoice was paid.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPaidAt(final Long paidAt) {
      this.paidAt = paidAt;
    }

    /**
     * The time that the invoice was voided.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVoidedAt(final Long voidedAt) {
      this.voidedAt = voidedAt;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Invoice.StatusTransitions)) return false;
      final Invoice.StatusTransitions other = (Invoice.StatusTransitions) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$finalizedAt = this.getFinalizedAt();
      final java.lang.Object other$finalizedAt = other.getFinalizedAt();
      if (this$finalizedAt == null ? other$finalizedAt != null : !this$finalizedAt.equals(other$finalizedAt)) return false;
      final java.lang.Object this$markedUncollectibleAt = this.getMarkedUncollectibleAt();
      final java.lang.Object other$markedUncollectibleAt = other.getMarkedUncollectibleAt();
      if (this$markedUncollectibleAt == null ? other$markedUncollectibleAt != null : !this$markedUncollectibleAt.equals(other$markedUncollectibleAt)) return false;
      final java.lang.Object this$paidAt = this.getPaidAt();
      final java.lang.Object other$paidAt = other.getPaidAt();
      if (this$paidAt == null ? other$paidAt != null : !this$paidAt.equals(other$paidAt)) return false;
      final java.lang.Object this$voidedAt = this.getVoidedAt();
      final java.lang.Object other$voidedAt = other.getVoidedAt();
      if (this$voidedAt == null ? other$voidedAt != null : !this$voidedAt.equals(other$voidedAt)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Invoice.StatusTransitions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $finalizedAt = this.getFinalizedAt();
      result = result * PRIME + ($finalizedAt == null ? 43 : $finalizedAt.hashCode());
      final java.lang.Object $markedUncollectibleAt = this.getMarkedUncollectibleAt();
      result = result * PRIME + ($markedUncollectibleAt == null ? 43 : $markedUncollectibleAt.hashCode());
      final java.lang.Object $paidAt = this.getPaidAt();
      result = result * PRIME + ($paidAt == null ? 43 : $paidAt.hashCode());
      final java.lang.Object $voidedAt = this.getVoidedAt();
      result = result * PRIME + ($voidedAt == null ? 43 : $voidedAt.hashCode());
      return result;
    }
  }


  public static class TaxAmount extends StripeObject {
    /**
     * The amount, in %s, of the tax.
     */
    @SerializedName("amount")
    Long amount;
    /**
     * Whether this tax amount is inclusive or exclusive.
     */
    @SerializedName("inclusive")
    Boolean inclusive;
    /**
     * The tax rate that was applied to get this tax amount.
     */
    @SerializedName("tax_rate")
    ExpandableField<TaxRate> taxRate;

    /**
     * Get ID of expandable {@code taxRate} object.
     */
    public String getTaxRate() {
      return (this.taxRate != null) ? this.taxRate.getId() : null;
    }

    public void setTaxRate(String id) {
      this.taxRate = ApiResource.setExpandableFieldId(id, this.taxRate);
    }

    /**
     * Get expanded {@code taxRate}.
     */
    public TaxRate getTaxRateObject() {
      return (this.taxRate != null) ? this.taxRate.getExpanded() : null;
    }

    public void setTaxRateObject(TaxRate expandableObject) {
      this.taxRate = new ExpandableField<TaxRate>(expandableObject.getId(), expandableObject);
    }

    /**
     * The amount, in %s, of the tax.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    /**
     * Whether this tax amount is inclusive or exclusive.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getInclusive() {
      return this.inclusive;
    }

    /**
     * The amount, in %s, of the tax.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    /**
     * Whether this tax amount is inclusive or exclusive.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInclusive(final Boolean inclusive) {
      this.inclusive = inclusive;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Invoice.TaxAmount)) return false;
      final Invoice.TaxAmount other = (Invoice.TaxAmount) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$inclusive = this.getInclusive();
      final java.lang.Object other$inclusive = other.getInclusive();
      if (this$inclusive == null ? other$inclusive != null : !this$inclusive.equals(other$inclusive)) return false;
      final java.lang.Object this$taxRate = this.getTaxRate();
      final java.lang.Object other$taxRate = other.getTaxRate();
      if (this$taxRate == null ? other$taxRate != null : !this$taxRate.equals(other$taxRate)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Invoice.TaxAmount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $inclusive = this.getInclusive();
      result = result * PRIME + ($inclusive == null ? 43 : $inclusive.hashCode());
      final java.lang.Object $taxRate = this.getTaxRate();
      result = result * PRIME + ($taxRate == null ? 43 : $taxRate.hashCode());
      return result;
    }
  }


  public static class ThresholdItemReason extends StripeObject {
    /**
     * The IDs of the line items that triggered the threshold invoice.
     */
    @SerializedName("line_item_ids")
    List<String> lineItemIds;
    /**
     * The quantity threshold boundary that applied to the given line item.
     */
    @SerializedName("usage_gte")
    Long usageGte;

    /**
     * The IDs of the line items that triggered the threshold invoice.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getLineItemIds() {
      return this.lineItemIds;
    }

    /**
     * The quantity threshold boundary that applied to the given line item.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getUsageGte() {
      return this.usageGte;
    }

    /**
     * The IDs of the line items that triggered the threshold invoice.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLineItemIds(final List<String> lineItemIds) {
      this.lineItemIds = lineItemIds;
    }

    /**
     * The quantity threshold boundary that applied to the given line item.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUsageGte(final Long usageGte) {
      this.usageGte = usageGte;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Invoice.ThresholdItemReason)) return false;
      final Invoice.ThresholdItemReason other = (Invoice.ThresholdItemReason) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$usageGte = this.getUsageGte();
      final java.lang.Object other$usageGte = other.getUsageGte();
      if (this$usageGte == null ? other$usageGte != null : !this$usageGte.equals(other$usageGte)) return false;
      final java.lang.Object this$lineItemIds = this.getLineItemIds();
      final java.lang.Object other$lineItemIds = other.getLineItemIds();
      if (this$lineItemIds == null ? other$lineItemIds != null : !this$lineItemIds.equals(other$lineItemIds)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Invoice.ThresholdItemReason;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $usageGte = this.getUsageGte();
      result = result * PRIME + ($usageGte == null ? 43 : $usageGte.hashCode());
      final java.lang.Object $lineItemIds = this.getLineItemIds();
      result = result * PRIME + ($lineItemIds == null ? 43 : $lineItemIds.hashCode());
      return result;
    }
  }


  public static class ThresholdReason extends StripeObject {
    /**
     * The total invoice amount threshold boundary if it triggered the threshold invoice.
     */
    @SerializedName("amount_gte")
    Long amountGte;
    /**
     * Indicates which line items triggered a threshold invoice.
     */
    @SerializedName("item_reasons")
    List<Invoice.ThresholdItemReason> itemReasons;

    /**
     * The total invoice amount threshold boundary if it triggered the threshold invoice.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountGte() {
      return this.amountGte;
    }

    /**
     * Indicates which line items triggered a threshold invoice.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Invoice.ThresholdItemReason> getItemReasons() {
      return this.itemReasons;
    }

    /**
     * The total invoice amount threshold boundary if it triggered the threshold invoice.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountGte(final Long amountGte) {
      this.amountGte = amountGte;
    }

    /**
     * Indicates which line items triggered a threshold invoice.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setItemReasons(final List<Invoice.ThresholdItemReason> itemReasons) {
      this.itemReasons = itemReasons;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Invoice.ThresholdReason)) return false;
      final Invoice.ThresholdReason other = (Invoice.ThresholdReason) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amountGte = this.getAmountGte();
      final java.lang.Object other$amountGte = other.getAmountGte();
      if (this$amountGte == null ? other$amountGte != null : !this$amountGte.equals(other$amountGte)) return false;
      final java.lang.Object this$itemReasons = this.getItemReasons();
      final java.lang.Object other$itemReasons = other.getItemReasons();
      if (this$itemReasons == null ? other$itemReasons != null : !this$itemReasons.equals(other$itemReasons)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Invoice.ThresholdReason;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amountGte = this.getAmountGte();
      result = result * PRIME + ($amountGte == null ? 43 : $amountGte.hashCode());
      final java.lang.Object $itemReasons = this.getItemReasons();
      result = result * PRIME + ($itemReasons == null ? 43 : $itemReasons.hashCode());
      return result;
    }
  }


  public static class TransferData extends StripeObject {
    /**
     * The amount in %s that will be transferred to the destination account when the invoice is
     * paid. By default, the entire amount is transferred to the destination.
     */
    @SerializedName("amount")
    Long amount;
    /** The account where funds from the payment will be transferred to upon payment success. */
    @SerializedName("destination")
    ExpandableField<Account> destination;

    /** Get ID of expandable {@code destination} object. */
    public String getDestination() {
      return (this.destination != null) ? this.destination.getId() : null;
    }

    public void setDestination(String id) {
      this.destination = ApiResource.setExpandableFieldId(id, this.destination);
    }

    /** Get expanded {@code destination}. */
    public Account getDestinationObject() {
      return (this.destination != null) ? this.destination.getExpanded() : null;
    }

    public void setDestinationObject(Account expandableObject) {
      this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Invoice.TransferData)) return false;
      final Invoice.TransferData other = (Invoice.TransferData) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$destination = this.getDestination();
      final java.lang.Object other$destination = other.getDestination();
      if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Invoice.TransferData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $destination = this.getDestination();
      result = result * PRIME + ($destination == null ? 43 : $destination.hashCode());
      return result;
    }
  }

  /**
   * The country of the business associated with this invoice, most often the business creating the
   * invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAccountCountry() {
    return this.accountCountry;
  }

  /**
   * The public name of the business associated with this invoice, most often the business creating
   * the invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAccountName() {
    return this.accountName;
  }

  /**
   * Final amount due at this time for this invoice. If the invoice's total is smaller than the
   * minimum charge amount, for example, or if there is account credit that can be applied to the
   * invoice, the {@code amount_due} may be 0. If there is a positive {@code starting_balance} for
   * the invoice (the customer owes money), the {@code amount_due} will also take that into account.
   * The charge that gets generated for the invoice will be for the amount specified in {@code
   * amount_due}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountDue() {
    return this.amountDue;
  }

  /**
   * The amount, in %s, that was paid.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountPaid() {
    return this.amountPaid;
  }

  /**
   * The difference between amount_due and amount_paid, in %s.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountRemaining() {
    return this.amountRemaining;
  }

  /**
   * The fee in %s that will be applied to the invoice and transferred to the application owner's
   * Stripe account when the invoice is paid.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getApplicationFeeAmount() {
    return this.applicationFeeAmount;
  }

  /**
   * Number of payment attempts made for this invoice, from the perspective of the payment retry
   * schedule. Any payment attempt counts as the first attempt, and subsequently only automatic
   * retries increment the attempt count. In other words, manual payment attempts after the first
   * attempt do not affect the retry schedule.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAttemptCount() {
    return this.attemptCount;
  }

  /**
   * Whether an attempt has been made to pay the invoice. An invoice is not attempted until 1 hour
   * after the {@code invoice.created} webhook, for example, so you might not want to display that
   * invoice as unpaid to your users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getAttempted() {
    return this.attempted;
  }

  /**
   * Controls whether Stripe will perform <a
   * href="https://stripe.com/docs/billing/invoices/workflow/#auto_advance">automatic collection</a>
   * of the invoice. When {@code false}, the invoice's state will not automatically advance without
   * an explicit action.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getAutoAdvance() {
    return this.autoAdvance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AutomaticTax getAutomaticTax() {
    return this.automaticTax;
  }

  /**
   * Indicates the reason why the invoice was created. {@code subscription_cycle} indicates an
   * invoice created by a subscription advancing into a new period. {@code subscription_create}
   * indicates an invoice created due to creating a subscription. {@code subscription_update}
   * indicates an invoice created due to updating a subscription. {@code subscription} is set for
   * all old invoices to indicate either a change to a subscription or a period advancement. {@code
   * manual} is set for all invoices unrelated to a subscription (for example: created via the
   * invoice editor). The {@code upcoming} value is reserved for simulated invoices per the upcoming
   * invoice endpoint. {@code subscription_threshold} indicates an invoice created due to a billing
   * threshold being reached.
   *
   * <p>One of {@code automatic_pending_invoice_item_invoice}, {@code manual}, {@code quote_accept},
   * {@code subscription}, {@code subscription_create}, {@code subscription_cycle}, {@code
   * subscription_threshold}, {@code subscription_update}, or {@code upcoming}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBillingReason() {
    return this.billingReason;
  }

  /**
   * Either {@code charge_automatically}, or {@code send_invoice}. When charging automatically,
   * Stripe will attempt to pay this invoice using the default source attached to the customer. When
   * sending an invoice, Stripe will email this invoice to the customer with payment instructions.
   *
   * <p>One of {@code charge_automatically}, or {@code send_invoice}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCollectionMethod() {
    return this.collectionMethod;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * The customer's address. Until the invoice is finalized, this field will equal {@code
   * customer.address}. Once the invoice is finalized, this field will no longer be updated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Address getCustomerAddress() {
    return this.customerAddress;
  }

  /**
   * The customer's email. Until the invoice is finalized, this field will equal {@code
   * customer.email}. Once the invoice is finalized, this field will no longer be updated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCustomerEmail() {
    return this.customerEmail;
  }

  /**
   * The customer's name. Until the invoice is finalized, this field will equal {@code
   * customer.name}. Once the invoice is finalized, this field will no longer be updated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCustomerName() {
    return this.customerName;
  }

  /**
   * The customer's phone number. Until the invoice is finalized, this field will equal {@code
   * customer.phone}. Once the invoice is finalized, this field will no longer be updated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCustomerPhone() {
    return this.customerPhone;
  }

  /**
   * The customer's shipping information. Until the invoice is finalized, this field will equal
   * {@code customer.shipping}. Once the invoice is finalized, this field will no longer be updated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ShippingDetails getCustomerShipping() {
    return this.customerShipping;
  }

  /**
   * The customer's tax exempt status. Until the invoice is finalized, this field will equal {@code
   * customer.tax_exempt}. Once the invoice is finalized, this field will no longer be updated.
   *
   * <p>One of {@code exempt}, {@code none}, or {@code reverse}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCustomerTaxExempt() {
    return this.customerTaxExempt;
  }

  /**
   * The customer's tax IDs. Until the invoice is finalized, this field will contain the same tax
   * IDs as {@code customer.tax_ids}. Once the invoice is finalized, this field will no longer be
   * updated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<Invoice.CustomerTaxId> getCustomerTaxIds() {
    return this.customerTaxIds;
  }

  /**
   * Custom fields displayed on the invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<Invoice.CustomField> getCustomFields() {
    return this.customFields;
  }

  /**
   * The tax rates applied to this invoice, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<TaxRate> getDefaultTaxRates() {
    return this.defaultTaxRates;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users. Referenced as
   * 'memo' in the Dashboard.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * Describes the current discount applied to this invoice, if there is one. Not populated if there
   * are multiple discounts.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Discount getDiscount() {
    return this.discount;
  }

  /**
   * The date on which payment for this invoice is due. This value will be {@code null} for invoices
   * where {@code collection_method=charge_automatically}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getDueDate() {
    return this.dueDate;
  }

  /**
   * Ending customer balance after the invoice is finalized. Invoices are finalized approximately an
   * hour after successful webhook delivery or when payment collection is attempted for the invoice.
   * If the invoice has not been finalized yet, this will be null.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getEndingBalance() {
    return this.endingBalance;
  }

  /**
   * Footer displayed on the invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFooter() {
    return this.footer;
  }

  /**
   * The URL for the hosted invoice page, which allows customers to view and pay an invoice. If the
   * invoice has not been finalized yet, this will be null.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHostedInvoiceUrl() {
    return this.hostedInvoiceUrl;
  }

  /**
   * The link to download the PDF for the invoice. If the invoice has not been finalized yet, this
   * will be null.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getInvoicePdf() {
    return this.invoicePdf;
  }

  /**
   * The error encountered during the previous attempt to finalize the invoice. This field is
   * cleared when the invoice is successfully finalized.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public StripeError getLastFinalizationError() {
    return this.lastFinalizationError;
  }

  /**
   * The individual line items that make up the invoice. {@code lines} is sorted as follows: invoice
   * items in reverse chronological order, followed by the subscription, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public InvoiceLineItemCollection getLines() {
    return this.lines;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * The time at which payment will next be attempted. This value will be {@code null} for invoices
   * where {@code collection_method=send_invoice}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getNextPaymentAttempt() {
    return this.nextPaymentAttempt;
  }

  /**
   * A unique, identifying string that appears on emails sent to the customer for this invoice. This
   * starts with the customer's unique invoice_prefix if it is specified.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getNumber() {
    return this.number;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code invoice}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Whether payment was successfully collected for this invoice. An invoice can be paid (most
   * commonly) with a charge or with credit from the customer's account balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getPaid() {
    return this.paid;
  }

  /**
   * Returns true if the invoice was manually marked paid, returns false if the invoice hasn't been
   * paid yet or was paid on Stripe.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getPaidOutOfBand() {
    return this.paidOutOfBand;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PaymentSettings getPaymentSettings() {
    return this.paymentSettings;
  }

  /**
   * End of the usage period during which invoice items were added to this invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getPeriodEnd() {
    return this.periodEnd;
  }

  /**
   * Start of the usage period during which invoice items were added to this invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getPeriodStart() {
    return this.periodStart;
  }

  /**
   * Total amount of all post-payment credit notes issued for this invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getPostPaymentCreditNotesAmount() {
    return this.postPaymentCreditNotesAmount;
  }

  /**
   * Total amount of all pre-payment credit notes issued for this invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getPrePaymentCreditNotesAmount() {
    return this.prePaymentCreditNotesAmount;
  }

  /**
   * This is the transaction number that appears on email receipts sent for this invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReceiptNumber() {
    return this.receiptNumber;
  }

  /**
   * Options for invoice PDF rendering.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public RenderingOptions getRenderingOptions() {
    return this.renderingOptions;
  }

  /**
   * Starting customer balance before the invoice is finalized. If the invoice has not been
   * finalized yet, this will be the current customer balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getStartingBalance() {
    return this.startingBalance;
  }

  /**
   * Extra information about an invoice for the customer's credit card statement.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatementDescriptor() {
    return this.statementDescriptor;
  }

  /**
   * The status of the invoice, one of {@code draft}, {@code open}, {@code paid}, {@code
   * uncollectible}, or {@code void}. <a
   * href="https://stripe.com/docs/billing/invoices/workflow#workflow-overview">Learn more</a>
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public StatusTransitions getStatusTransitions() {
    return this.statusTransitions;
  }

  /**
   * Only set for upcoming invoices that preview prorations. The time used to calculate prorations.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getSubscriptionProrationDate() {
    return this.subscriptionProrationDate;
  }

  /**
   * Total of all subscriptions, invoice items, and prorations on the invoice before any invoice
   * level discount or exclusive tax is applied. Item discounts are already incorporated
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getSubtotal() {
    return this.subtotal;
  }

  /**
   * The integer amount in %s representing the subtotal of the invoice before any invoice level
   * discount or tax is applied. Item discounts are already incorporated
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getSubtotalExcludingTax() {
    return this.subtotalExcludingTax;
  }

  /**
   * The amount of tax on this invoice. This is the sum of all the tax amounts on this invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getTax() {
    return this.tax;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ThresholdReason getThresholdReason() {
    return this.thresholdReason;
  }

  /**
   * Total after discounts and taxes.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getTotal() {
    return this.total;
  }

  /**
   * The aggregate amounts calculated per discount across all line items.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<DiscountAmount> getTotalDiscountAmounts() {
    return this.totalDiscountAmounts;
  }

  /**
   * The integer amount in %s representing the total amount of the invoice including all discounts
   * but excluding all tax.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getTotalExcludingTax() {
    return this.totalExcludingTax;
  }

  /**
   * The aggregate amounts calculated per tax rate for all line items.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<Invoice.TaxAmount> getTotalTaxAmounts() {
    return this.totalTaxAmounts;
  }

  /**
   * The account (if any) the payment will be attributed to for tax reporting, and where funds from
   * the payment will be transferred to for the invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TransferData getTransferData() {
    return this.transferData;
  }

  /**
   * Invoices are automatically paid or sent 1 hour after webhooks are delivered, or until all
   * webhook delivery attempts have <a
   * href="https://stripe.com/docs/billing/webhooks#understand">been exhausted</a>. This field
   * tracks the time when webhooks for this invoice were successfully delivered. If the invoice had
   * no webhooks to deliver, this will be set while the invoice is being created.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getWebhooksDeliveredAt() {
    return this.webhooksDeliveredAt;
  }

  /**
   * The country of the business associated with this invoice, most often the business creating the
   * invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAccountCountry(final String accountCountry) {
    this.accountCountry = accountCountry;
  }

  /**
   * The public name of the business associated with this invoice, most often the business creating
   * the invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAccountName(final String accountName) {
    this.accountName = accountName;
  }

  /**
   * Final amount due at this time for this invoice. If the invoice's total is smaller than the
   * minimum charge amount, for example, or if there is account credit that can be applied to the
   * invoice, the {@code amount_due} may be 0. If there is a positive {@code starting_balance} for
   * the invoice (the customer owes money), the {@code amount_due} will also take that into account.
   * The charge that gets generated for the invoice will be for the amount specified in {@code
   * amount_due}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountDue(final Long amountDue) {
    this.amountDue = amountDue;
  }

  /**
   * The amount, in %s, that was paid.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountPaid(final Long amountPaid) {
    this.amountPaid = amountPaid;
  }

  /**
   * The difference between amount_due and amount_paid, in %s.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountRemaining(final Long amountRemaining) {
    this.amountRemaining = amountRemaining;
  }

  /**
   * The fee in %s that will be applied to the invoice and transferred to the application owner's
   * Stripe account when the invoice is paid.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApplicationFeeAmount(final Long applicationFeeAmount) {
    this.applicationFeeAmount = applicationFeeAmount;
  }

  /**
   * Number of payment attempts made for this invoice, from the perspective of the payment retry
   * schedule. Any payment attempt counts as the first attempt, and subsequently only automatic
   * retries increment the attempt count. In other words, manual payment attempts after the first
   * attempt do not affect the retry schedule.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAttemptCount(final Long attemptCount) {
    this.attemptCount = attemptCount;
  }

  /**
   * Whether an attempt has been made to pay the invoice. An invoice is not attempted until 1 hour
   * after the {@code invoice.created} webhook, for example, so you might not want to display that
   * invoice as unpaid to your users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAttempted(final Boolean attempted) {
    this.attempted = attempted;
  }

  /**
   * Controls whether Stripe will perform <a
   * href="https://stripe.com/docs/billing/invoices/workflow/#auto_advance">automatic collection</a>
   * of the invoice. When {@code false}, the invoice's state will not automatically advance without
   * an explicit action.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAutoAdvance(final Boolean autoAdvance) {
    this.autoAdvance = autoAdvance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAutomaticTax(final AutomaticTax automaticTax) {
    this.automaticTax = automaticTax;
  }

  /**
   * Indicates the reason why the invoice was created. {@code subscription_cycle} indicates an
   * invoice created by a subscription advancing into a new period. {@code subscription_create}
   * indicates an invoice created due to creating a subscription. {@code subscription_update}
   * indicates an invoice created due to updating a subscription. {@code subscription} is set for
   * all old invoices to indicate either a change to a subscription or a period advancement. {@code
   * manual} is set for all invoices unrelated to a subscription (for example: created via the
   * invoice editor). The {@code upcoming} value is reserved for simulated invoices per the upcoming
   * invoice endpoint. {@code subscription_threshold} indicates an invoice created due to a billing
   * threshold being reached.
   *
   * <p>One of {@code automatic_pending_invoice_item_invoice}, {@code manual}, {@code quote_accept},
   * {@code subscription}, {@code subscription_create}, {@code subscription_cycle}, {@code
   * subscription_threshold}, {@code subscription_update}, or {@code upcoming}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingReason(final String billingReason) {
    this.billingReason = billingReason;
  }

  /**
   * Either {@code charge_automatically}, or {@code send_invoice}. When charging automatically,
   * Stripe will attempt to pay this invoice using the default source attached to the customer. When
   * sending an invoice, Stripe will email this invoice to the customer with payment instructions.
   *
   * <p>One of {@code charge_automatically}, or {@code send_invoice}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCollectionMethod(final String collectionMethod) {
    this.collectionMethod = collectionMethod;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * The customer's address. Until the invoice is finalized, this field will equal {@code
   * customer.address}. Once the invoice is finalized, this field will no longer be updated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCustomerAddress(final Address customerAddress) {
    this.customerAddress = customerAddress;
  }

  /**
   * The customer's email. Until the invoice is finalized, this field will equal {@code
   * customer.email}. Once the invoice is finalized, this field will no longer be updated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCustomerEmail(final String customerEmail) {
    this.customerEmail = customerEmail;
  }

  /**
   * The customer's name. Until the invoice is finalized, this field will equal {@code
   * customer.name}. Once the invoice is finalized, this field will no longer be updated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCustomerName(final String customerName) {
    this.customerName = customerName;
  }

  /**
   * The customer's phone number. Until the invoice is finalized, this field will equal {@code
   * customer.phone}. Once the invoice is finalized, this field will no longer be updated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCustomerPhone(final String customerPhone) {
    this.customerPhone = customerPhone;
  }

  /**
   * The customer's shipping information. Until the invoice is finalized, this field will equal
   * {@code customer.shipping}. Once the invoice is finalized, this field will no longer be updated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCustomerShipping(final ShippingDetails customerShipping) {
    this.customerShipping = customerShipping;
  }

  /**
   * The customer's tax exempt status. Until the invoice is finalized, this field will equal {@code
   * customer.tax_exempt}. Once the invoice is finalized, this field will no longer be updated.
   *
   * <p>One of {@code exempt}, {@code none}, or {@code reverse}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCustomerTaxExempt(final String customerTaxExempt) {
    this.customerTaxExempt = customerTaxExempt;
  }

  /**
   * The customer's tax IDs. Until the invoice is finalized, this field will contain the same tax
   * IDs as {@code customer.tax_ids}. Once the invoice is finalized, this field will no longer be
   * updated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCustomerTaxIds(final List<Invoice.CustomerTaxId> customerTaxIds) {
    this.customerTaxIds = customerTaxIds;
  }

  /**
   * Custom fields displayed on the invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCustomFields(final List<Invoice.CustomField> customFields) {
    this.customFields = customFields;
  }

  /**
   * The tax rates applied to this invoice, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDefaultTaxRates(final List<TaxRate> defaultTaxRates) {
    this.defaultTaxRates = defaultTaxRates;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users. Referenced as
   * 'memo' in the Dashboard.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * Describes the current discount applied to this invoice, if there is one. Not populated if there
   * are multiple discounts.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiscount(final Discount discount) {
    this.discount = discount;
  }

  /**
   * The date on which payment for this invoice is due. This value will be {@code null} for invoices
   * where {@code collection_method=charge_automatically}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDueDate(final Long dueDate) {
    this.dueDate = dueDate;
  }

  /**
   * Ending customer balance after the invoice is finalized. Invoices are finalized approximately an
   * hour after successful webhook delivery or when payment collection is attempted for the invoice.
   * If the invoice has not been finalized yet, this will be null.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEndingBalance(final Long endingBalance) {
    this.endingBalance = endingBalance;
  }

  /**
   * Footer displayed on the invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFooter(final String footer) {
    this.footer = footer;
  }

  /**
   * The URL for the hosted invoice page, which allows customers to view and pay an invoice. If the
   * invoice has not been finalized yet, this will be null.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHostedInvoiceUrl(final String hostedInvoiceUrl) {
    this.hostedInvoiceUrl = hostedInvoiceUrl;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The link to download the PDF for the invoice. If the invoice has not been finalized yet, this
   * will be null.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setInvoicePdf(final String invoicePdf) {
    this.invoicePdf = invoicePdf;
  }

  /**
   * The error encountered during the previous attempt to finalize the invoice. This field is
   * cleared when the invoice is successfully finalized.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLastFinalizationError(final StripeError lastFinalizationError) {
    this.lastFinalizationError = lastFinalizationError;
  }

  /**
   * The individual line items that make up the invoice. {@code lines} is sorted as follows: invoice
   * items in reverse chronological order, followed by the subscription, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLines(final InvoiceLineItemCollection lines) {
    this.lines = lines;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * The time at which payment will next be attempted. This value will be {@code null} for invoices
   * where {@code collection_method=send_invoice}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNextPaymentAttempt(final Long nextPaymentAttempt) {
    this.nextPaymentAttempt = nextPaymentAttempt;
  }

  /**
   * A unique, identifying string that appears on emails sent to the customer for this invoice. This
   * starts with the customer's unique invoice_prefix if it is specified.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNumber(final String number) {
    this.number = number;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code invoice}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Whether payment was successfully collected for this invoice. An invoice can be paid (most
   * commonly) with a charge or with credit from the customer's account balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaid(final Boolean paid) {
    this.paid = paid;
  }

  /**
   * Returns true if the invoice was manually marked paid, returns false if the invoice hasn't been
   * paid yet or was paid on Stripe.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaidOutOfBand(final Boolean paidOutOfBand) {
    this.paidOutOfBand = paidOutOfBand;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentSettings(final PaymentSettings paymentSettings) {
    this.paymentSettings = paymentSettings;
  }

  /**
   * End of the usage period during which invoice items were added to this invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPeriodEnd(final Long periodEnd) {
    this.periodEnd = periodEnd;
  }

  /**
   * Start of the usage period during which invoice items were added to this invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPeriodStart(final Long periodStart) {
    this.periodStart = periodStart;
  }

  /**
   * Total amount of all post-payment credit notes issued for this invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPostPaymentCreditNotesAmount(final Long postPaymentCreditNotesAmount) {
    this.postPaymentCreditNotesAmount = postPaymentCreditNotesAmount;
  }

  /**
   * Total amount of all pre-payment credit notes issued for this invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPrePaymentCreditNotesAmount(final Long prePaymentCreditNotesAmount) {
    this.prePaymentCreditNotesAmount = prePaymentCreditNotesAmount;
  }

  /**
   * This is the transaction number that appears on email receipts sent for this invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReceiptNumber(final String receiptNumber) {
    this.receiptNumber = receiptNumber;
  }

  /**
   * Options for invoice PDF rendering.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRenderingOptions(final RenderingOptions renderingOptions) {
    this.renderingOptions = renderingOptions;
  }

  /**
   * Starting customer balance before the invoice is finalized. If the invoice has not been
   * finalized yet, this will be the current customer balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStartingBalance(final Long startingBalance) {
    this.startingBalance = startingBalance;
  }

  /**
   * Extra information about an invoice for the customer's credit card statement.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatementDescriptor(final String statementDescriptor) {
    this.statementDescriptor = statementDescriptor;
  }

  /**
   * The status of the invoice, one of {@code draft}, {@code open}, {@code paid}, {@code
   * uncollectible}, or {@code void}. <a
   * href="https://stripe.com/docs/billing/invoices/workflow#workflow-overview">Learn more</a>
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatusTransitions(final StatusTransitions statusTransitions) {
    this.statusTransitions = statusTransitions;
  }

  /**
   * Only set for upcoming invoices that preview prorations. The time used to calculate prorations.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubscriptionProrationDate(final Long subscriptionProrationDate) {
    this.subscriptionProrationDate = subscriptionProrationDate;
  }

  /**
   * Total of all subscriptions, invoice items, and prorations on the invoice before any invoice
   * level discount or exclusive tax is applied. Item discounts are already incorporated
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubtotal(final Long subtotal) {
    this.subtotal = subtotal;
  }

  /**
   * The integer amount in %s representing the subtotal of the invoice before any invoice level
   * discount or tax is applied. Item discounts are already incorporated
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubtotalExcludingTax(final Long subtotalExcludingTax) {
    this.subtotalExcludingTax = subtotalExcludingTax;
  }

  /**
   * The amount of tax on this invoice. This is the sum of all the tax amounts on this invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTax(final Long tax) {
    this.tax = tax;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setThresholdReason(final ThresholdReason thresholdReason) {
    this.thresholdReason = thresholdReason;
  }

  /**
   * Total after discounts and taxes.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotal(final Long total) {
    this.total = total;
  }

  /**
   * The aggregate amounts calculated per discount across all line items.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalDiscountAmounts(final List<DiscountAmount> totalDiscountAmounts) {
    this.totalDiscountAmounts = totalDiscountAmounts;
  }

  /**
   * The integer amount in %s representing the total amount of the invoice including all discounts
   * but excluding all tax.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalExcludingTax(final Long totalExcludingTax) {
    this.totalExcludingTax = totalExcludingTax;
  }

  /**
   * The aggregate amounts calculated per tax rate for all line items.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalTaxAmounts(final List<Invoice.TaxAmount> totalTaxAmounts) {
    this.totalTaxAmounts = totalTaxAmounts;
  }

  /**
   * The account (if any) the payment will be attributed to for tax reporting, and where funds from
   * the payment will be transferred to for the invoice.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferData(final TransferData transferData) {
    this.transferData = transferData;
  }

  /**
   * Invoices are automatically paid or sent 1 hour after webhooks are delivered, or until all
   * webhook delivery attempts have <a
   * href="https://stripe.com/docs/billing/webhooks#understand">been exhausted</a>. This field
   * tracks the time when webhooks for this invoice were successfully delivered. If the invoice had
   * no webhooks to deliver, this will be set while the invoice is being created.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWebhooksDeliveredAt(final Long webhooksDeliveredAt) {
    this.webhooksDeliveredAt = webhooksDeliveredAt;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Invoice)) return false;
    final Invoice other = (Invoice) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amountDue = this.getAmountDue();
    final java.lang.Object other$amountDue = other.getAmountDue();
    if (this$amountDue == null ? other$amountDue != null : !this$amountDue.equals(other$amountDue)) return false;
    final java.lang.Object this$amountPaid = this.getAmountPaid();
    final java.lang.Object other$amountPaid = other.getAmountPaid();
    if (this$amountPaid == null ? other$amountPaid != null : !this$amountPaid.equals(other$amountPaid)) return false;
    final java.lang.Object this$amountRemaining = this.getAmountRemaining();
    final java.lang.Object other$amountRemaining = other.getAmountRemaining();
    if (this$amountRemaining == null ? other$amountRemaining != null : !this$amountRemaining.equals(other$amountRemaining)) return false;
    final java.lang.Object this$applicationFeeAmount = this.getApplicationFeeAmount();
    final java.lang.Object other$applicationFeeAmount = other.getApplicationFeeAmount();
    if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !this$applicationFeeAmount.equals(other$applicationFeeAmount)) return false;
    final java.lang.Object this$attemptCount = this.getAttemptCount();
    final java.lang.Object other$attemptCount = other.getAttemptCount();
    if (this$attemptCount == null ? other$attemptCount != null : !this$attemptCount.equals(other$attemptCount)) return false;
    final java.lang.Object this$attempted = this.getAttempted();
    final java.lang.Object other$attempted = other.getAttempted();
    if (this$attempted == null ? other$attempted != null : !this$attempted.equals(other$attempted)) return false;
    final java.lang.Object this$autoAdvance = this.getAutoAdvance();
    final java.lang.Object other$autoAdvance = other.getAutoAdvance();
    if (this$autoAdvance == null ? other$autoAdvance != null : !this$autoAdvance.equals(other$autoAdvance)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$dueDate = this.getDueDate();
    final java.lang.Object other$dueDate = other.getDueDate();
    if (this$dueDate == null ? other$dueDate != null : !this$dueDate.equals(other$dueDate)) return false;
    final java.lang.Object this$endingBalance = this.getEndingBalance();
    final java.lang.Object other$endingBalance = other.getEndingBalance();
    if (this$endingBalance == null ? other$endingBalance != null : !this$endingBalance.equals(other$endingBalance)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$nextPaymentAttempt = this.getNextPaymentAttempt();
    final java.lang.Object other$nextPaymentAttempt = other.getNextPaymentAttempt();
    if (this$nextPaymentAttempt == null ? other$nextPaymentAttempt != null : !this$nextPaymentAttempt.equals(other$nextPaymentAttempt)) return false;
    final java.lang.Object this$paid = this.getPaid();
    final java.lang.Object other$paid = other.getPaid();
    if (this$paid == null ? other$paid != null : !this$paid.equals(other$paid)) return false;
    final java.lang.Object this$paidOutOfBand = this.getPaidOutOfBand();
    final java.lang.Object other$paidOutOfBand = other.getPaidOutOfBand();
    if (this$paidOutOfBand == null ? other$paidOutOfBand != null : !this$paidOutOfBand.equals(other$paidOutOfBand)) return false;
    final java.lang.Object this$periodEnd = this.getPeriodEnd();
    final java.lang.Object other$periodEnd = other.getPeriodEnd();
    if (this$periodEnd == null ? other$periodEnd != null : !this$periodEnd.equals(other$periodEnd)) return false;
    final java.lang.Object this$periodStart = this.getPeriodStart();
    final java.lang.Object other$periodStart = other.getPeriodStart();
    if (this$periodStart == null ? other$periodStart != null : !this$periodStart.equals(other$periodStart)) return false;
    final java.lang.Object this$postPaymentCreditNotesAmount = this.getPostPaymentCreditNotesAmount();
    final java.lang.Object other$postPaymentCreditNotesAmount = other.getPostPaymentCreditNotesAmount();
    if (this$postPaymentCreditNotesAmount == null ? other$postPaymentCreditNotesAmount != null : !this$postPaymentCreditNotesAmount.equals(other$postPaymentCreditNotesAmount)) return false;
    final java.lang.Object this$prePaymentCreditNotesAmount = this.getPrePaymentCreditNotesAmount();
    final java.lang.Object other$prePaymentCreditNotesAmount = other.getPrePaymentCreditNotesAmount();
    if (this$prePaymentCreditNotesAmount == null ? other$prePaymentCreditNotesAmount != null : !this$prePaymentCreditNotesAmount.equals(other$prePaymentCreditNotesAmount)) return false;
    final java.lang.Object this$startingBalance = this.getStartingBalance();
    final java.lang.Object other$startingBalance = other.getStartingBalance();
    if (this$startingBalance == null ? other$startingBalance != null : !this$startingBalance.equals(other$startingBalance)) return false;
    final java.lang.Object this$subscriptionProrationDate = this.getSubscriptionProrationDate();
    final java.lang.Object other$subscriptionProrationDate = other.getSubscriptionProrationDate();
    if (this$subscriptionProrationDate == null ? other$subscriptionProrationDate != null : !this$subscriptionProrationDate.equals(other$subscriptionProrationDate)) return false;
    final java.lang.Object this$subtotal = this.getSubtotal();
    final java.lang.Object other$subtotal = other.getSubtotal();
    if (this$subtotal == null ? other$subtotal != null : !this$subtotal.equals(other$subtotal)) return false;
    final java.lang.Object this$subtotalExcludingTax = this.getSubtotalExcludingTax();
    final java.lang.Object other$subtotalExcludingTax = other.getSubtotalExcludingTax();
    if (this$subtotalExcludingTax == null ? other$subtotalExcludingTax != null : !this$subtotalExcludingTax.equals(other$subtotalExcludingTax)) return false;
    final java.lang.Object this$tax = this.getTax();
    final java.lang.Object other$tax = other.getTax();
    if (this$tax == null ? other$tax != null : !this$tax.equals(other$tax)) return false;
    final java.lang.Object this$total = this.getTotal();
    final java.lang.Object other$total = other.getTotal();
    if (this$total == null ? other$total != null : !this$total.equals(other$total)) return false;
    final java.lang.Object this$totalExcludingTax = this.getTotalExcludingTax();
    final java.lang.Object other$totalExcludingTax = other.getTotalExcludingTax();
    if (this$totalExcludingTax == null ? other$totalExcludingTax != null : !this$totalExcludingTax.equals(other$totalExcludingTax)) return false;
    final java.lang.Object this$webhooksDeliveredAt = this.getWebhooksDeliveredAt();
    final java.lang.Object other$webhooksDeliveredAt = other.getWebhooksDeliveredAt();
    if (this$webhooksDeliveredAt == null ? other$webhooksDeliveredAt != null : !this$webhooksDeliveredAt.equals(other$webhooksDeliveredAt)) return false;
    final java.lang.Object this$accountCountry = this.getAccountCountry();
    final java.lang.Object other$accountCountry = other.getAccountCountry();
    if (this$accountCountry == null ? other$accountCountry != null : !this$accountCountry.equals(other$accountCountry)) return false;
    final java.lang.Object this$accountName = this.getAccountName();
    final java.lang.Object other$accountName = other.getAccountName();
    if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) return false;
    final java.lang.Object this$accountTaxIds = this.getAccountTaxIds();
    final java.lang.Object other$accountTaxIds = other.getAccountTaxIds();
    if (this$accountTaxIds == null ? other$accountTaxIds != null : !this$accountTaxIds.equals(other$accountTaxIds)) return false;
    final java.lang.Object this$application = this.getApplication();
    final java.lang.Object other$application = other.getApplication();
    if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
    final java.lang.Object this$automaticTax = this.getAutomaticTax();
    final java.lang.Object other$automaticTax = other.getAutomaticTax();
    if (this$automaticTax == null ? other$automaticTax != null : !this$automaticTax.equals(other$automaticTax)) return false;
    final java.lang.Object this$billingReason = this.getBillingReason();
    final java.lang.Object other$billingReason = other.getBillingReason();
    if (this$billingReason == null ? other$billingReason != null : !this$billingReason.equals(other$billingReason)) return false;
    final java.lang.Object this$charge = this.getCharge();
    final java.lang.Object other$charge = other.getCharge();
    if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) return false;
    final java.lang.Object this$collectionMethod = this.getCollectionMethod();
    final java.lang.Object other$collectionMethod = other.getCollectionMethod();
    if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$customerAddress = this.getCustomerAddress();
    final java.lang.Object other$customerAddress = other.getCustomerAddress();
    if (this$customerAddress == null ? other$customerAddress != null : !this$customerAddress.equals(other$customerAddress)) return false;
    final java.lang.Object this$customerEmail = this.getCustomerEmail();
    final java.lang.Object other$customerEmail = other.getCustomerEmail();
    if (this$customerEmail == null ? other$customerEmail != null : !this$customerEmail.equals(other$customerEmail)) return false;
    final java.lang.Object this$customerName = this.getCustomerName();
    final java.lang.Object other$customerName = other.getCustomerName();
    if (this$customerName == null ? other$customerName != null : !this$customerName.equals(other$customerName)) return false;
    final java.lang.Object this$customerPhone = this.getCustomerPhone();
    final java.lang.Object other$customerPhone = other.getCustomerPhone();
    if (this$customerPhone == null ? other$customerPhone != null : !this$customerPhone.equals(other$customerPhone)) return false;
    final java.lang.Object this$customerShipping = this.getCustomerShipping();
    final java.lang.Object other$customerShipping = other.getCustomerShipping();
    if (this$customerShipping == null ? other$customerShipping != null : !this$customerShipping.equals(other$customerShipping)) return false;
    final java.lang.Object this$customerTaxExempt = this.getCustomerTaxExempt();
    final java.lang.Object other$customerTaxExempt = other.getCustomerTaxExempt();
    if (this$customerTaxExempt == null ? other$customerTaxExempt != null : !this$customerTaxExempt.equals(other$customerTaxExempt)) return false;
    final java.lang.Object this$customerTaxIds = this.getCustomerTaxIds();
    final java.lang.Object other$customerTaxIds = other.getCustomerTaxIds();
    if (this$customerTaxIds == null ? other$customerTaxIds != null : !this$customerTaxIds.equals(other$customerTaxIds)) return false;
    final java.lang.Object this$customFields = this.getCustomFields();
    final java.lang.Object other$customFields = other.getCustomFields();
    if (this$customFields == null ? other$customFields != null : !this$customFields.equals(other$customFields)) return false;
    final java.lang.Object this$defaultPaymentMethod = this.getDefaultPaymentMethod();
    final java.lang.Object other$defaultPaymentMethod = other.getDefaultPaymentMethod();
    if (this$defaultPaymentMethod == null ? other$defaultPaymentMethod != null : !this$defaultPaymentMethod.equals(other$defaultPaymentMethod)) return false;
    final java.lang.Object this$defaultSource = this.getDefaultSource();
    final java.lang.Object other$defaultSource = other.getDefaultSource();
    if (this$defaultSource == null ? other$defaultSource != null : !this$defaultSource.equals(other$defaultSource)) return false;
    final java.lang.Object this$defaultTaxRates = this.getDefaultTaxRates();
    final java.lang.Object other$defaultTaxRates = other.getDefaultTaxRates();
    if (this$defaultTaxRates == null ? other$defaultTaxRates != null : !this$defaultTaxRates.equals(other$defaultTaxRates)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$discount = this.getDiscount();
    final java.lang.Object other$discount = other.getDiscount();
    if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) return false;
    final java.lang.Object this$discounts = this.getDiscounts();
    final java.lang.Object other$discounts = other.getDiscounts();
    if (this$discounts == null ? other$discounts != null : !this$discounts.equals(other$discounts)) return false;
    final java.lang.Object this$footer = this.getFooter();
    final java.lang.Object other$footer = other.getFooter();
    if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) return false;
    final java.lang.Object this$hostedInvoiceUrl = this.getHostedInvoiceUrl();
    final java.lang.Object other$hostedInvoiceUrl = other.getHostedInvoiceUrl();
    if (this$hostedInvoiceUrl == null ? other$hostedInvoiceUrl != null : !this$hostedInvoiceUrl.equals(other$hostedInvoiceUrl)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$invoicePdf = this.getInvoicePdf();
    final java.lang.Object other$invoicePdf = other.getInvoicePdf();
    if (this$invoicePdf == null ? other$invoicePdf != null : !this$invoicePdf.equals(other$invoicePdf)) return false;
    final java.lang.Object this$lastFinalizationError = this.getLastFinalizationError();
    final java.lang.Object other$lastFinalizationError = other.getLastFinalizationError();
    if (this$lastFinalizationError == null ? other$lastFinalizationError != null : !this$lastFinalizationError.equals(other$lastFinalizationError)) return false;
    final java.lang.Object this$lines = this.getLines();
    final java.lang.Object other$lines = other.getLines();
    if (this$lines == null ? other$lines != null : !this$lines.equals(other$lines)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$number = this.getNumber();
    final java.lang.Object other$number = other.getNumber();
    if (this$number == null ? other$number != null : !this$number.equals(other$number)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$onBehalfOf = this.getOnBehalfOf();
    final java.lang.Object other$onBehalfOf = other.getOnBehalfOf();
    if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) return false;
    final java.lang.Object this$paymentIntent = this.getPaymentIntent();
    final java.lang.Object other$paymentIntent = other.getPaymentIntent();
    if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) return false;
    final java.lang.Object this$paymentSettings = this.getPaymentSettings();
    final java.lang.Object other$paymentSettings = other.getPaymentSettings();
    if (this$paymentSettings == null ? other$paymentSettings != null : !this$paymentSettings.equals(other$paymentSettings)) return false;
    final java.lang.Object this$quote = this.getQuote();
    final java.lang.Object other$quote = other.getQuote();
    if (this$quote == null ? other$quote != null : !this$quote.equals(other$quote)) return false;
    final java.lang.Object this$receiptNumber = this.getReceiptNumber();
    final java.lang.Object other$receiptNumber = other.getReceiptNumber();
    if (this$receiptNumber == null ? other$receiptNumber != null : !this$receiptNumber.equals(other$receiptNumber)) return false;
    final java.lang.Object this$renderingOptions = this.getRenderingOptions();
    final java.lang.Object other$renderingOptions = other.getRenderingOptions();
    if (this$renderingOptions == null ? other$renderingOptions != null : !this$renderingOptions.equals(other$renderingOptions)) return false;
    final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
    final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
    if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$statusTransitions = this.getStatusTransitions();
    final java.lang.Object other$statusTransitions = other.getStatusTransitions();
    if (this$statusTransitions == null ? other$statusTransitions != null : !this$statusTransitions.equals(other$statusTransitions)) return false;
    final java.lang.Object this$subscription = this.getSubscription();
    final java.lang.Object other$subscription = other.getSubscription();
    if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) return false;
    final java.lang.Object this$testClock = this.getTestClock();
    final java.lang.Object other$testClock = other.getTestClock();
    if (this$testClock == null ? other$testClock != null : !this$testClock.equals(other$testClock)) return false;
    final java.lang.Object this$thresholdReason = this.getThresholdReason();
    final java.lang.Object other$thresholdReason = other.getThresholdReason();
    if (this$thresholdReason == null ? other$thresholdReason != null : !this$thresholdReason.equals(other$thresholdReason)) return false;
    final java.lang.Object this$totalDiscountAmounts = this.getTotalDiscountAmounts();
    final java.lang.Object other$totalDiscountAmounts = other.getTotalDiscountAmounts();
    if (this$totalDiscountAmounts == null ? other$totalDiscountAmounts != null : !this$totalDiscountAmounts.equals(other$totalDiscountAmounts)) return false;
    final java.lang.Object this$totalTaxAmounts = this.getTotalTaxAmounts();
    final java.lang.Object other$totalTaxAmounts = other.getTotalTaxAmounts();
    if (this$totalTaxAmounts == null ? other$totalTaxAmounts != null : !this$totalTaxAmounts.equals(other$totalTaxAmounts)) return false;
    final java.lang.Object this$transferData = this.getTransferData();
    final java.lang.Object other$transferData = other.getTransferData();
    if (this$transferData == null ? other$transferData != null : !this$transferData.equals(other$transferData)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Invoice;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amountDue = this.getAmountDue();
    result = result * PRIME + ($amountDue == null ? 43 : $amountDue.hashCode());
    final java.lang.Object $amountPaid = this.getAmountPaid();
    result = result * PRIME + ($amountPaid == null ? 43 : $amountPaid.hashCode());
    final java.lang.Object $amountRemaining = this.getAmountRemaining();
    result = result * PRIME + ($amountRemaining == null ? 43 : $amountRemaining.hashCode());
    final java.lang.Object $applicationFeeAmount = this.getApplicationFeeAmount();
    result = result * PRIME + ($applicationFeeAmount == null ? 43 : $applicationFeeAmount.hashCode());
    final java.lang.Object $attemptCount = this.getAttemptCount();
    result = result * PRIME + ($attemptCount == null ? 43 : $attemptCount.hashCode());
    final java.lang.Object $attempted = this.getAttempted();
    result = result * PRIME + ($attempted == null ? 43 : $attempted.hashCode());
    final java.lang.Object $autoAdvance = this.getAutoAdvance();
    result = result * PRIME + ($autoAdvance == null ? 43 : $autoAdvance.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $dueDate = this.getDueDate();
    result = result * PRIME + ($dueDate == null ? 43 : $dueDate.hashCode());
    final java.lang.Object $endingBalance = this.getEndingBalance();
    result = result * PRIME + ($endingBalance == null ? 43 : $endingBalance.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $nextPaymentAttempt = this.getNextPaymentAttempt();
    result = result * PRIME + ($nextPaymentAttempt == null ? 43 : $nextPaymentAttempt.hashCode());
    final java.lang.Object $paid = this.getPaid();
    result = result * PRIME + ($paid == null ? 43 : $paid.hashCode());
    final java.lang.Object $paidOutOfBand = this.getPaidOutOfBand();
    result = result * PRIME + ($paidOutOfBand == null ? 43 : $paidOutOfBand.hashCode());
    final java.lang.Object $periodEnd = this.getPeriodEnd();
    result = result * PRIME + ($periodEnd == null ? 43 : $periodEnd.hashCode());
    final java.lang.Object $periodStart = this.getPeriodStart();
    result = result * PRIME + ($periodStart == null ? 43 : $periodStart.hashCode());
    final java.lang.Object $postPaymentCreditNotesAmount = this.getPostPaymentCreditNotesAmount();
    result = result * PRIME + ($postPaymentCreditNotesAmount == null ? 43 : $postPaymentCreditNotesAmount.hashCode());
    final java.lang.Object $prePaymentCreditNotesAmount = this.getPrePaymentCreditNotesAmount();
    result = result * PRIME + ($prePaymentCreditNotesAmount == null ? 43 : $prePaymentCreditNotesAmount.hashCode());
    final java.lang.Object $startingBalance = this.getStartingBalance();
    result = result * PRIME + ($startingBalance == null ? 43 : $startingBalance.hashCode());
    final java.lang.Object $subscriptionProrationDate = this.getSubscriptionProrationDate();
    result = result * PRIME + ($subscriptionProrationDate == null ? 43 : $subscriptionProrationDate.hashCode());
    final java.lang.Object $subtotal = this.getSubtotal();
    result = result * PRIME + ($subtotal == null ? 43 : $subtotal.hashCode());
    final java.lang.Object $subtotalExcludingTax = this.getSubtotalExcludingTax();
    result = result * PRIME + ($subtotalExcludingTax == null ? 43 : $subtotalExcludingTax.hashCode());
    final java.lang.Object $tax = this.getTax();
    result = result * PRIME + ($tax == null ? 43 : $tax.hashCode());
    final java.lang.Object $total = this.getTotal();
    result = result * PRIME + ($total == null ? 43 : $total.hashCode());
    final java.lang.Object $totalExcludingTax = this.getTotalExcludingTax();
    result = result * PRIME + ($totalExcludingTax == null ? 43 : $totalExcludingTax.hashCode());
    final java.lang.Object $webhooksDeliveredAt = this.getWebhooksDeliveredAt();
    result = result * PRIME + ($webhooksDeliveredAt == null ? 43 : $webhooksDeliveredAt.hashCode());
    final java.lang.Object $accountCountry = this.getAccountCountry();
    result = result * PRIME + ($accountCountry == null ? 43 : $accountCountry.hashCode());
    final java.lang.Object $accountName = this.getAccountName();
    result = result * PRIME + ($accountName == null ? 43 : $accountName.hashCode());
    final java.lang.Object $accountTaxIds = this.getAccountTaxIds();
    result = result * PRIME + ($accountTaxIds == null ? 43 : $accountTaxIds.hashCode());
    final java.lang.Object $application = this.getApplication();
    result = result * PRIME + ($application == null ? 43 : $application.hashCode());
    final java.lang.Object $automaticTax = this.getAutomaticTax();
    result = result * PRIME + ($automaticTax == null ? 43 : $automaticTax.hashCode());
    final java.lang.Object $billingReason = this.getBillingReason();
    result = result * PRIME + ($billingReason == null ? 43 : $billingReason.hashCode());
    final java.lang.Object $charge = this.getCharge();
    result = result * PRIME + ($charge == null ? 43 : $charge.hashCode());
    final java.lang.Object $collectionMethod = this.getCollectionMethod();
    result = result * PRIME + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $customerAddress = this.getCustomerAddress();
    result = result * PRIME + ($customerAddress == null ? 43 : $customerAddress.hashCode());
    final java.lang.Object $customerEmail = this.getCustomerEmail();
    result = result * PRIME + ($customerEmail == null ? 43 : $customerEmail.hashCode());
    final java.lang.Object $customerName = this.getCustomerName();
    result = result * PRIME + ($customerName == null ? 43 : $customerName.hashCode());
    final java.lang.Object $customerPhone = this.getCustomerPhone();
    result = result * PRIME + ($customerPhone == null ? 43 : $customerPhone.hashCode());
    final java.lang.Object $customerShipping = this.getCustomerShipping();
    result = result * PRIME + ($customerShipping == null ? 43 : $customerShipping.hashCode());
    final java.lang.Object $customerTaxExempt = this.getCustomerTaxExempt();
    result = result * PRIME + ($customerTaxExempt == null ? 43 : $customerTaxExempt.hashCode());
    final java.lang.Object $customerTaxIds = this.getCustomerTaxIds();
    result = result * PRIME + ($customerTaxIds == null ? 43 : $customerTaxIds.hashCode());
    final java.lang.Object $customFields = this.getCustomFields();
    result = result * PRIME + ($customFields == null ? 43 : $customFields.hashCode());
    final java.lang.Object $defaultPaymentMethod = this.getDefaultPaymentMethod();
    result = result * PRIME + ($defaultPaymentMethod == null ? 43 : $defaultPaymentMethod.hashCode());
    final java.lang.Object $defaultSource = this.getDefaultSource();
    result = result * PRIME + ($defaultSource == null ? 43 : $defaultSource.hashCode());
    final java.lang.Object $defaultTaxRates = this.getDefaultTaxRates();
    result = result * PRIME + ($defaultTaxRates == null ? 43 : $defaultTaxRates.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $discount = this.getDiscount();
    result = result * PRIME + ($discount == null ? 43 : $discount.hashCode());
    final java.lang.Object $discounts = this.getDiscounts();
    result = result * PRIME + ($discounts == null ? 43 : $discounts.hashCode());
    final java.lang.Object $footer = this.getFooter();
    result = result * PRIME + ($footer == null ? 43 : $footer.hashCode());
    final java.lang.Object $hostedInvoiceUrl = this.getHostedInvoiceUrl();
    result = result * PRIME + ($hostedInvoiceUrl == null ? 43 : $hostedInvoiceUrl.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $invoicePdf = this.getInvoicePdf();
    result = result * PRIME + ($invoicePdf == null ? 43 : $invoicePdf.hashCode());
    final java.lang.Object $lastFinalizationError = this.getLastFinalizationError();
    result = result * PRIME + ($lastFinalizationError == null ? 43 : $lastFinalizationError.hashCode());
    final java.lang.Object $lines = this.getLines();
    result = result * PRIME + ($lines == null ? 43 : $lines.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $number = this.getNumber();
    result = result * PRIME + ($number == null ? 43 : $number.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $onBehalfOf = this.getOnBehalfOf();
    result = result * PRIME + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
    final java.lang.Object $paymentIntent = this.getPaymentIntent();
    result = result * PRIME + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
    final java.lang.Object $paymentSettings = this.getPaymentSettings();
    result = result * PRIME + ($paymentSettings == null ? 43 : $paymentSettings.hashCode());
    final java.lang.Object $quote = this.getQuote();
    result = result * PRIME + ($quote == null ? 43 : $quote.hashCode());
    final java.lang.Object $receiptNumber = this.getReceiptNumber();
    result = result * PRIME + ($receiptNumber == null ? 43 : $receiptNumber.hashCode());
    final java.lang.Object $renderingOptions = this.getRenderingOptions();
    result = result * PRIME + ($renderingOptions == null ? 43 : $renderingOptions.hashCode());
    final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
    result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $statusTransitions = this.getStatusTransitions();
    result = result * PRIME + ($statusTransitions == null ? 43 : $statusTransitions.hashCode());
    final java.lang.Object $subscription = this.getSubscription();
    result = result * PRIME + ($subscription == null ? 43 : $subscription.hashCode());
    final java.lang.Object $testClock = this.getTestClock();
    result = result * PRIME + ($testClock == null ? 43 : $testClock.hashCode());
    final java.lang.Object $thresholdReason = this.getThresholdReason();
    result = result * PRIME + ($thresholdReason == null ? 43 : $thresholdReason.hashCode());
    final java.lang.Object $totalDiscountAmounts = this.getTotalDiscountAmounts();
    result = result * PRIME + ($totalDiscountAmounts == null ? 43 : $totalDiscountAmounts.hashCode());
    final java.lang.Object $totalTaxAmounts = this.getTotalTaxAmounts();
    result = result * PRIME + ($totalTaxAmounts == null ? 43 : $totalTaxAmounts.hashCode());
    final java.lang.Object $transferData = this.getTransferData();
    result = result * PRIME + ($transferData == null ? 43 : $transferData.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
