// Generated by delombok at Thu Sep 29 15:26:29 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PaymentIntentApplyCustomerBalanceParams;
import com.stripe.param.PaymentIntentCancelParams;
import com.stripe.param.PaymentIntentCaptureParams;
import com.stripe.param.PaymentIntentConfirmParams;
import com.stripe.param.PaymentIntentCreateParams;
import com.stripe.param.PaymentIntentIncrementAuthorizationParams;
import com.stripe.param.PaymentIntentListParams;
import com.stripe.param.PaymentIntentRetrieveParams;
import com.stripe.param.PaymentIntentSearchParams;
import com.stripe.param.PaymentIntentUpdateParams;
import com.stripe.param.PaymentIntentVerifyMicrodepositsParams;
import java.util.List;
import java.util.Map;

/**
 * A PaymentIntent guides you through the process of collecting a payment from your customer. We
 * recommend that you create exactly one PaymentIntent for each order or customer session in your
 * system. You can reference the PaymentIntent later to see the history of payment attempts for a
 * particular session.
 *
 * <p>A PaymentIntent transitions through <a
 * href="https://stripe.com/docs/payments/intents#intent-statuses">multiple statuses</a> throughout
 * its lifetime as it interfaces with Stripe.js to perform authentication flows and ultimately
 * creates at most one successful charge.
 *
 * <p>Related guide: <a href="https://stripe.com/docs/payments/payment-intents">Payment Intents
 * API</a>.
 */
public class PaymentIntent extends ApiResource implements HasId, MetadataStore<PaymentIntent> {
  /**
   * Amount intended to be collected by this PaymentIntent. A positive integer representing how much
   * to charge in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
   * unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The
   * minimum amount is $0.50 US or <a
   * href="https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts">equivalent in
   * charge currency</a>. The amount value supports up to eight digits (e.g., a value of 99999999
   * for a USD charge of $999,999.99).
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Amount that can be captured from this PaymentIntent.
   */
  @SerializedName("amount_capturable")
  Long amountCapturable;
  @SerializedName("amount_details")
  AmountDetails amountDetails;
  /**
   * Amount that was collected by this PaymentIntent.
   */
  @SerializedName("amount_received")
  Long amountReceived;
  /**
   * ID of the Connect application that created the PaymentIntent.
   */
  @SerializedName("application")
  ExpandableField<Application> application;
  /**
   * The amount of the application fee (if any) that will be requested to be applied to the payment
   * and transferred to the application owner's Stripe account. The amount of the application fee
   * collected will be capped at the total payment amount. For more information, see the
   * PaymentIntents <a href="https://stripe.com/docs/payments/connected-accounts">use case for
   * connected accounts</a>.
   */
  @SerializedName("application_fee_amount")
  Long applicationFeeAmount;
  /**
   * Settings to configure compatible payment methods from the <a
   * href="https://dashboard.stripe.com/settings/payment_methods">Stripe Dashboard.</a>
   */
  @SerializedName("automatic_payment_methods")
  AutomaticPaymentMethodsPaymentIntent automaticPaymentMethods;
  /**
   * Populated when {@code status} is {@code canceled}, this is the time at which the PaymentIntent
   * was canceled. Measured in seconds since the Unix epoch.
   */
  @SerializedName("canceled_at")
  Long canceledAt;
  /**
   * Reason for cancellation of this PaymentIntent, either user-provided ({@code duplicate}, {@code
   * fraudulent}, {@code requested_by_customer}, or {@code abandoned}) or generated by Stripe
   * internally ({@code failed_invoice}, {@code void_invoice}, or {@code automatic}).
   *
   * <p>One of {@code abandoned}, {@code automatic}, {@code duplicate}, {@code failed_invoice},
   * {@code fraudulent}, {@code requested_by_customer}, or {@code void_invoice}.
   */
  @SerializedName("cancellation_reason")
  String cancellationReason;
  /**
   * Controls when the funds will be captured from the customer's account.
   *
   * <p>One of {@code automatic}, or {@code manual}.
   */
  @SerializedName("capture_method")
  String captureMethod;
  /**
   * Charges that were created by this PaymentIntent, if any.
   */
  @SerializedName("charges")
  ChargeCollection charges;
  /**
   * The client secret of this PaymentIntent. Used for client-side retrieval using a publishable
   * key.
   *
   * <p>The client secret can be used to complete a payment from your frontend. It should not be
   * stored, logged, or exposed to anyone other than the customer. Make sure that you have TLS
   * enabled on any page that includes the client secret.
   *
   * <p>Refer to our docs to <a
   * href="https://stripe.com/docs/payments/accept-a-payment?ui=elements">accept a payment</a> and
   * learn about how {@code client_secret} should be handled.
   */
  @SerializedName("client_secret")
  String clientSecret;
  @SerializedName("confirmation_method")
  String confirmationMethod;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * ID of the Customer this PaymentIntent belongs to, if one exists.
   *
   * <p>Payment methods attached to other Customers cannot be used with this PaymentIntent.
   *
   * <p>If present in combination with <a
   * href="https://stripe.com/docs/api#payment_intent_object-setup_future_usage">setup_future_usage</a>,
   * this PaymentIntent's payment method will be attached to the Customer after the PaymentIntent
   * has been confirmed and any required actions from the user are complete.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @SerializedName("description")
  String description;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * ID of the invoice that created this PaymentIntent, if it exists.
   */
  @SerializedName("invoice")
  ExpandableField<Invoice> invoice;
  /**
   * The payment error encountered in the previous PaymentIntent confirmation. It will be cleared if
   * the PaymentIntent is later updated for any reason.
   */
  @SerializedName("last_payment_error")
  StripeError lastPaymentError;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format. For more information, see the <a
   * href="https://stripe.com/docs/payments/payment-intents/creating-payment-intents#storing-information-in-metadata">documentation</a>.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * If present, this property tells you what actions you need to take in order for your customer to
   * fulfill a payment using the provided source.
   */
  @SerializedName("next_action")
  NextAction nextAction;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code payment_intent}.
   */
  @SerializedName("object")
  String object;
  /**
   * The account (if any) for which the funds of the PaymentIntent are intended. See the
   * PaymentIntents <a href="https://stripe.com/docs/payments/connected-accounts">use case for
   * connected accounts</a> for details.
   */
  @SerializedName("on_behalf_of")
  ExpandableField<Account> onBehalfOf;
  /**
   * ID of the payment method used in this PaymentIntent.
   */
  @SerializedName("payment_method")
  ExpandableField<PaymentMethod> paymentMethod;
  /**
   * Payment-method-specific configuration for this PaymentIntent.
   */
  @SerializedName("payment_method_options")
  PaymentMethodOptions paymentMethodOptions;
  /**
   * The list of payment method types (e.g. card) that this PaymentIntent is allowed to use.
   */
  @SerializedName("payment_method_types")
  List<String> paymentMethodTypes;
  /**
   * If present, this property tells you about the processing state of the payment.
   */
  @SerializedName("processing")
  Processing processing;
  /**
   * Email address that the receipt for the resulting payment will be sent to. If {@code
   * receipt_email} is specified for a payment in live mode, a receipt will be sent regardless of
   * your <a href="https://dashboard.stripe.com/account/emails">email settings</a>.
   */
  @SerializedName("receipt_email")
  String receiptEmail;
  /**
   * ID of the review associated with this PaymentIntent, if any.
   */
  @SerializedName("review")
  ExpandableField<Review> review;
  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * <p>Providing this parameter will <a
   * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a> to
   * the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required
   * actions from the user are complete. If no Customer was provided, the payment method can still
   * be <a href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
   * after the transaction completes.
   *
   * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to dynamically
   * optimize your payment flow and comply with regional legislation and network rules, such as <a
   * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
   *
   * <p>One of {@code off_session}, or {@code on_session}.
   */
  @SerializedName("setup_future_usage")
  String setupFutureUsage;
  /**
   * Shipping information for this PaymentIntent.
   */
  @SerializedName("shipping")
  ShippingDetails shipping;
  /**
   * This is a legacy field that will be removed in the future. It is the ID of the Source object
   * that is associated with this PaymentIntent, if one was supplied.
   */
  @SerializedName("source")
  ExpandableField<PaymentSource> source;
  /**
   * For non-card charges, you can use this value as the complete description that appears on your
   * customers’ statements. Must contain at least one letter, maximum 22 characters.
   */
  @SerializedName("statement_descriptor")
  String statementDescriptor;
  /**
   * Provides information about a card payment that customers see on their statements. Concatenated
   * with the prefix (shortened descriptor) or statement descriptor that’s set on the account to
   * form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.
   */
  @SerializedName("statement_descriptor_suffix")
  String statementDescriptorSuffix;
  /**
   * Status of this PaymentIntent, one of {@code requires_payment_method}, {@code
   * requires_confirmation}, {@code requires_action}, {@code processing}, {@code requires_capture},
   * {@code canceled}, or {@code succeeded}. Read more about each PaymentIntent <a
   * href="https://stripe.com/docs/payments/intents#intent-statuses">status</a>.
   */
  @SerializedName("status")
  String status;
  /**
   * The data with which to automatically create a Transfer when the payment is finalized. See the
   * PaymentIntents <a href="https://stripe.com/docs/payments/connected-accounts">use case for
   * connected accounts</a> for details.
   */
  @SerializedName("transfer_data")
  TransferData transferData;
  /**
   * A string that identifies the resulting payment as part of a group. See the PaymentIntents <a
   * href="https://stripe.com/docs/payments/connected-accounts">use case for connected accounts</a>
   * for details.
   */
  @SerializedName("transfer_group")
  String transferGroup;

  /**
   * Get ID of expandable {@code application} object.
   */
  public String getApplication() {
    return (this.application != null) ? this.application.getId() : null;
  }

  public void setApplication(String id) {
    this.application = ApiResource.setExpandableFieldId(id, this.application);
  }

  /**
   * Get expanded {@code application}.
   */
  public Application getApplicationObject() {
    return (this.application != null) ? this.application.getExpanded() : null;
  }

  public void setApplicationObject(Application expandableObject) {
    this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code customer} object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded {@code customer}.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code invoice} object.
   */
  public String getInvoice() {
    return (this.invoice != null) ? this.invoice.getId() : null;
  }

  public void setInvoice(String id) {
    this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
  }

  /**
   * Get expanded {@code invoice}.
   */
  public Invoice getInvoiceObject() {
    return (this.invoice != null) ? this.invoice.getExpanded() : null;
  }

  public void setInvoiceObject(Invoice expandableObject) {
    this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code onBehalfOf} object.
   */
  public String getOnBehalfOf() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getId() : null;
  }

  public void setOnBehalfOf(String id) {
    this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
  }

  /**
   * Get expanded {@code onBehalfOf}.
   */
  public Account getOnBehalfOfObject() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getExpanded() : null;
  }

  public void setOnBehalfOfObject(Account expandableObject) {
    this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code paymentMethod} object.
   */
  public String getPaymentMethod() {
    return (this.paymentMethod != null) ? this.paymentMethod.getId() : null;
  }

  public void setPaymentMethod(String id) {
    this.paymentMethod = ApiResource.setExpandableFieldId(id, this.paymentMethod);
  }

  /**
   * Get expanded {@code paymentMethod}.
   */
  public PaymentMethod getPaymentMethodObject() {
    return (this.paymentMethod != null) ? this.paymentMethod.getExpanded() : null;
  }

  public void setPaymentMethodObject(PaymentMethod expandableObject) {
    this.paymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code review} object.
   */
  public String getReview() {
    return (this.review != null) ? this.review.getId() : null;
  }

  public void setReview(String id) {
    this.review = ApiResource.setExpandableFieldId(id, this.review);
  }

  /**
   * Get expanded {@code review}.
   */
  public Review getReviewObject() {
    return (this.review != null) ? this.review.getExpanded() : null;
  }

  public void setReviewObject(Review expandableObject) {
    this.review = new ExpandableField<Review>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code source} object.
   */
  public String getSource() {
    return (this.source != null) ? this.source.getId() : null;
  }

  public void setSource(String id) {
    this.source = ApiResource.setExpandableFieldId(id, this.source);
  }

  /**
   * Get expanded {@code source}.
   */
  public PaymentSource getSourceObject() {
    return (this.source != null) ? this.source.getExpanded() : null;
  }

  public void setSourceObject(PaymentSource expandableObject) {
    this.source = new ExpandableField<PaymentSource>(expandableObject.getId(), expandableObject);
  }

  /**
   * Manually reconcile the remaining amount for a customer_balance PaymentIntent.
   */
  public PaymentIntent applyCustomerBalance() throws StripeException {
    return applyCustomerBalance((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Manually reconcile the remaining amount for a customer_balance PaymentIntent.
   */
  public PaymentIntent applyCustomerBalance(RequestOptions options) throws StripeException {
    return applyCustomerBalance((Map<String, Object>) null, options);
  }

  /**
   * Manually reconcile the remaining amount for a customer_balance PaymentIntent.
   */
  public PaymentIntent applyCustomerBalance(Map<String, Object> params) throws StripeException {
    return applyCustomerBalance(params, (RequestOptions) null);
  }

  /**
   * Manually reconcile the remaining amount for a customer_balance PaymentIntent.
   */
  public PaymentIntent applyCustomerBalance(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/apply_customer_balance", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Manually reconcile the remaining amount for a customer_balance PaymentIntent.
   */
  public PaymentIntent applyCustomerBalance(PaymentIntentApplyCustomerBalanceParams params) throws StripeException {
    return applyCustomerBalance(params, (RequestOptions) null);
  }

  /**
   * Manually reconcile the remaining amount for a customer_balance PaymentIntent.
   */
  public PaymentIntent applyCustomerBalance(PaymentIntentApplyCustomerBalanceParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/apply_customer_balance", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * A PaymentIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_capture</code>, <code>requires_confirmation
   * </code>, <code>requires_action</code>, or <code>processing</code>.
   *
   * <p>Once canceled, no additional charges will be made by the PaymentIntent and any operations on
   * the PaymentIntent will fail with an error. For PaymentIntents with <code>
   * status=’requires_capture’</code>, the remaining <code>amount_capturable</code> will
   * automatically be refunded.
   *
   * <p>You cannot cancel the PaymentIntent for a Checkout Session. <a
   * href="https://stripe.com/docs/api/checkout/sessions/expire">Expire the Checkout Session</a>
   * instead
   */
  public PaymentIntent cancel() throws StripeException {
    return cancel((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * A PaymentIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_capture</code>, <code>requires_confirmation
   * </code>, <code>requires_action</code>, or <code>processing</code>.
   *
   * <p>Once canceled, no additional charges will be made by the PaymentIntent and any operations on
   * the PaymentIntent will fail with an error. For PaymentIntents with <code>
   * status=’requires_capture’</code>, the remaining <code>amount_capturable</code> will
   * automatically be refunded.
   *
   * <p>You cannot cancel the PaymentIntent for a Checkout Session. <a
   * href="https://stripe.com/docs/api/checkout/sessions/expire">Expire the Checkout Session</a>
   * instead
   */
  public PaymentIntent cancel(RequestOptions options) throws StripeException {
    return cancel((Map<String, Object>) null, options);
  }

  /**
   * A PaymentIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_capture</code>, <code>requires_confirmation
   * </code>, <code>requires_action</code>, or <code>processing</code>.
   *
   * <p>Once canceled, no additional charges will be made by the PaymentIntent and any operations on
   * the PaymentIntent will fail with an error. For PaymentIntents with <code>
   * status=’requires_capture’</code>, the remaining <code>amount_capturable</code> will
   * automatically be refunded.
   *
   * <p>You cannot cancel the PaymentIntent for a Checkout Session. <a
   * href="https://stripe.com/docs/api/checkout/sessions/expire">Expire the Checkout Session</a>
   * instead
   */
  public PaymentIntent cancel(Map<String, Object> params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * A PaymentIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_capture</code>, <code>requires_confirmation
   * </code>, <code>requires_action</code>, or <code>processing</code>.
   *
   * <p>Once canceled, no additional charges will be made by the PaymentIntent and any operations on
   * the PaymentIntent will fail with an error. For PaymentIntents with <code>
   * status=’requires_capture’</code>, the remaining <code>amount_capturable</code> will
   * automatically be refunded.
   *
   * <p>You cannot cancel the PaymentIntent for a Checkout Session. <a
   * href="https://stripe.com/docs/api/checkout/sessions/expire">Expire the Checkout Session</a>
   * instead
   */
  public PaymentIntent cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * A PaymentIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_capture</code>, <code>requires_confirmation
   * </code>, <code>requires_action</code>, or <code>processing</code>.
   *
   * <p>Once canceled, no additional charges will be made by the PaymentIntent and any operations on
   * the PaymentIntent will fail with an error. For PaymentIntents with <code>
   * status=’requires_capture’</code>, the remaining <code>amount_capturable</code> will
   * automatically be refunded.
   *
   * <p>You cannot cancel the PaymentIntent for a Checkout Session. <a
   * href="https://stripe.com/docs/api/checkout/sessions/expire">Expire the Checkout Session</a>
   * instead
   */
  public PaymentIntent cancel(PaymentIntentCancelParams params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * A PaymentIntent object can be canceled when it is in one of these statuses: <code>
   * requires_payment_method</code>, <code>requires_capture</code>, <code>requires_confirmation
   * </code>, <code>requires_action</code>, or <code>processing</code>.
   *
   * <p>Once canceled, no additional charges will be made by the PaymentIntent and any operations on
   * the PaymentIntent will fail with an error. For PaymentIntents with <code>
   * status=’requires_capture’</code>, the remaining <code>amount_capturable</code> will
   * automatically be refunded.
   *
   * <p>You cannot cancel the PaymentIntent for a Checkout Session. <a
   * href="https://stripe.com/docs/api/checkout/sessions/expire">Expire the Checkout Session</a>
   * instead
   */
  public PaymentIntent cancel(PaymentIntentCancelParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Capture the funds of an existing uncaptured PaymentIntent when its status is <code>
   * requires_capture</code>.
   *
   * <p>Uncaptured PaymentIntents will be canceled a set number of days after they are created (7 by
   * default).
   *
   * <p>Learn more about <a href="https://stripe.com/docs/payments/capture-later">separate
   * authorization and capture</a>.
   */
  public PaymentIntent capture() throws StripeException {
    return capture((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Capture the funds of an existing uncaptured PaymentIntent when its status is <code>
   * requires_capture</code>.
   *
   * <p>Uncaptured PaymentIntents will be canceled a set number of days after they are created (7 by
   * default).
   *
   * <p>Learn more about <a href="https://stripe.com/docs/payments/capture-later">separate
   * authorization and capture</a>.
   */
  public PaymentIntent capture(RequestOptions options) throws StripeException {
    return capture((Map<String, Object>) null, options);
  }

  /**
   * Capture the funds of an existing uncaptured PaymentIntent when its status is <code>
   * requires_capture</code>.
   *
   * <p>Uncaptured PaymentIntents will be canceled a set number of days after they are created (7 by
   * default).
   *
   * <p>Learn more about <a href="https://stripe.com/docs/payments/capture-later">separate
   * authorization and capture</a>.
   */
  public PaymentIntent capture(Map<String, Object> params) throws StripeException {
    return capture(params, (RequestOptions) null);
  }

  /**
   * Capture the funds of an existing uncaptured PaymentIntent when its status is <code>
   * requires_capture</code>.
   *
   * <p>Uncaptured PaymentIntents will be canceled a set number of days after they are created (7 by
   * default).
   *
   * <p>Learn more about <a href="https://stripe.com/docs/payments/capture-later">separate
   * authorization and capture</a>.
   */
  public PaymentIntent capture(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/capture", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Capture the funds of an existing uncaptured PaymentIntent when its status is <code>
   * requires_capture</code>.
   *
   * <p>Uncaptured PaymentIntents will be canceled a set number of days after they are created (7 by
   * default).
   *
   * <p>Learn more about <a href="https://stripe.com/docs/payments/capture-later">separate
   * authorization and capture</a>.
   */
  public PaymentIntent capture(PaymentIntentCaptureParams params) throws StripeException {
    return capture(params, (RequestOptions) null);
  }

  /**
   * Capture the funds of an existing uncaptured PaymentIntent when its status is <code>
   * requires_capture</code>.
   *
   * <p>Uncaptured PaymentIntents will be canceled a set number of days after they are created (7 by
   * default).
   *
   * <p>Learn more about <a href="https://stripe.com/docs/payments/capture-later">separate
   * authorization and capture</a>.
   */
  public PaymentIntent capture(PaymentIntentCaptureParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/capture", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Confirm that your customer intends to pay with current or provided payment method. Upon
   * confirmation, the PaymentIntent will attempt to initiate a payment.
   *
   * <p>If the selected payment method requires additional authentication steps, the PaymentIntent
   * will transition to the <code>requires_action</code> status and suggest additional actions via
   * <code>next_action</code>. If payment fails, the PaymentIntent will transition to the <code>
   * requires_payment_method</code> status. If payment succeeds, the PaymentIntent will transition
   * to the <code>succeeded</code> status (or <code>requires_capture</code>, if <code>capture_method
   * </code> is set to <code>manual</code>).
   *
   * <p>If the <code>confirmation_method</code> is <code>automatic</code>, payment may be attempted
   * using our <a
   * href="https://stripe.com/docs/stripe-js/reference#stripe-handle-card-payment">client SDKs</a>
   * and the PaymentIntent’s <a
   * href="https://stripe.com/docs/api#payment_intent_object-client_secret">client_secret</a>. After
   * <code>next_action</code>s are handled by the client, no additional confirmation is required to
   * complete the payment.
   *
   * <p>If the <code>confirmation_method</code> is <code>manual</code>, all payment attempts must be
   * initiated using a secret key. If any actions are required for the payment, the PaymentIntent
   * will return to the <code>requires_confirmation</code> state after those actions are completed.
   * Your server needs to then explicitly re-confirm the PaymentIntent to initiate the next payment
   * attempt. Read the <a
   * href="https://stripe.com/docs/payments/payment-intents/web-manual">expanded documentation</a>
   * to learn more about manual confirmation.
   */
  public PaymentIntent confirm() throws StripeException {
    return confirm((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Confirm that your customer intends to pay with current or provided payment method. Upon
   * confirmation, the PaymentIntent will attempt to initiate a payment.
   *
   * <p>If the selected payment method requires additional authentication steps, the PaymentIntent
   * will transition to the <code>requires_action</code> status and suggest additional actions via
   * <code>next_action</code>. If payment fails, the PaymentIntent will transition to the <code>
   * requires_payment_method</code> status. If payment succeeds, the PaymentIntent will transition
   * to the <code>succeeded</code> status (or <code>requires_capture</code>, if <code>capture_method
   * </code> is set to <code>manual</code>).
   *
   * <p>If the <code>confirmation_method</code> is <code>automatic</code>, payment may be attempted
   * using our <a
   * href="https://stripe.com/docs/stripe-js/reference#stripe-handle-card-payment">client SDKs</a>
   * and the PaymentIntent’s <a
   * href="https://stripe.com/docs/api#payment_intent_object-client_secret">client_secret</a>. After
   * <code>next_action</code>s are handled by the client, no additional confirmation is required to
   * complete the payment.
   *
   * <p>If the <code>confirmation_method</code> is <code>manual</code>, all payment attempts must be
   * initiated using a secret key. If any actions are required for the payment, the PaymentIntent
   * will return to the <code>requires_confirmation</code> state after those actions are completed.
   * Your server needs to then explicitly re-confirm the PaymentIntent to initiate the next payment
   * attempt. Read the <a
   * href="https://stripe.com/docs/payments/payment-intents/web-manual">expanded documentation</a>
   * to learn more about manual confirmation.
   */
  public PaymentIntent confirm(RequestOptions options) throws StripeException {
    return confirm((Map<String, Object>) null, options);
  }

  /**
   * Confirm that your customer intends to pay with current or provided payment method. Upon
   * confirmation, the PaymentIntent will attempt to initiate a payment.
   *
   * <p>If the selected payment method requires additional authentication steps, the PaymentIntent
   * will transition to the <code>requires_action</code> status and suggest additional actions via
   * <code>next_action</code>. If payment fails, the PaymentIntent will transition to the <code>
   * requires_payment_method</code> status. If payment succeeds, the PaymentIntent will transition
   * to the <code>succeeded</code> status (or <code>requires_capture</code>, if <code>capture_method
   * </code> is set to <code>manual</code>).
   *
   * <p>If the <code>confirmation_method</code> is <code>automatic</code>, payment may be attempted
   * using our <a
   * href="https://stripe.com/docs/stripe-js/reference#stripe-handle-card-payment">client SDKs</a>
   * and the PaymentIntent’s <a
   * href="https://stripe.com/docs/api#payment_intent_object-client_secret">client_secret</a>. After
   * <code>next_action</code>s are handled by the client, no additional confirmation is required to
   * complete the payment.
   *
   * <p>If the <code>confirmation_method</code> is <code>manual</code>, all payment attempts must be
   * initiated using a secret key. If any actions are required for the payment, the PaymentIntent
   * will return to the <code>requires_confirmation</code> state after those actions are completed.
   * Your server needs to then explicitly re-confirm the PaymentIntent to initiate the next payment
   * attempt. Read the <a
   * href="https://stripe.com/docs/payments/payment-intents/web-manual">expanded documentation</a>
   * to learn more about manual confirmation.
   */
  public PaymentIntent confirm(Map<String, Object> params) throws StripeException {
    return confirm(params, (RequestOptions) null);
  }

  /**
   * Confirm that your customer intends to pay with current or provided payment method. Upon
   * confirmation, the PaymentIntent will attempt to initiate a payment.
   *
   * <p>If the selected payment method requires additional authentication steps, the PaymentIntent
   * will transition to the <code>requires_action</code> status and suggest additional actions via
   * <code>next_action</code>. If payment fails, the PaymentIntent will transition to the <code>
   * requires_payment_method</code> status. If payment succeeds, the PaymentIntent will transition
   * to the <code>succeeded</code> status (or <code>requires_capture</code>, if <code>capture_method
   * </code> is set to <code>manual</code>).
   *
   * <p>If the <code>confirmation_method</code> is <code>automatic</code>, payment may be attempted
   * using our <a
   * href="https://stripe.com/docs/stripe-js/reference#stripe-handle-card-payment">client SDKs</a>
   * and the PaymentIntent’s <a
   * href="https://stripe.com/docs/api#payment_intent_object-client_secret">client_secret</a>. After
   * <code>next_action</code>s are handled by the client, no additional confirmation is required to
   * complete the payment.
   *
   * <p>If the <code>confirmation_method</code> is <code>manual</code>, all payment attempts must be
   * initiated using a secret key. If any actions are required for the payment, the PaymentIntent
   * will return to the <code>requires_confirmation</code> state after those actions are completed.
   * Your server needs to then explicitly re-confirm the PaymentIntent to initiate the next payment
   * attempt. Read the <a
   * href="https://stripe.com/docs/payments/payment-intents/web-manual">expanded documentation</a>
   * to learn more about manual confirmation.
   */
  public PaymentIntent confirm(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/confirm", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Confirm that your customer intends to pay with current or provided payment method. Upon
   * confirmation, the PaymentIntent will attempt to initiate a payment.
   *
   * <p>If the selected payment method requires additional authentication steps, the PaymentIntent
   * will transition to the <code>requires_action</code> status and suggest additional actions via
   * <code>next_action</code>. If payment fails, the PaymentIntent will transition to the <code>
   * requires_payment_method</code> status. If payment succeeds, the PaymentIntent will transition
   * to the <code>succeeded</code> status (or <code>requires_capture</code>, if <code>capture_method
   * </code> is set to <code>manual</code>).
   *
   * <p>If the <code>confirmation_method</code> is <code>automatic</code>, payment may be attempted
   * using our <a
   * href="https://stripe.com/docs/stripe-js/reference#stripe-handle-card-payment">client SDKs</a>
   * and the PaymentIntent’s <a
   * href="https://stripe.com/docs/api#payment_intent_object-client_secret">client_secret</a>. After
   * <code>next_action</code>s are handled by the client, no additional confirmation is required to
   * complete the payment.
   *
   * <p>If the <code>confirmation_method</code> is <code>manual</code>, all payment attempts must be
   * initiated using a secret key. If any actions are required for the payment, the PaymentIntent
   * will return to the <code>requires_confirmation</code> state after those actions are completed.
   * Your server needs to then explicitly re-confirm the PaymentIntent to initiate the next payment
   * attempt. Read the <a
   * href="https://stripe.com/docs/payments/payment-intents/web-manual">expanded documentation</a>
   * to learn more about manual confirmation.
   */
  public PaymentIntent confirm(PaymentIntentConfirmParams params) throws StripeException {
    return confirm(params, (RequestOptions) null);
  }

  /**
   * Confirm that your customer intends to pay with current or provided payment method. Upon
   * confirmation, the PaymentIntent will attempt to initiate a payment.
   *
   * <p>If the selected payment method requires additional authentication steps, the PaymentIntent
   * will transition to the <code>requires_action</code> status and suggest additional actions via
   * <code>next_action</code>. If payment fails, the PaymentIntent will transition to the <code>
   * requires_payment_method</code> status. If payment succeeds, the PaymentIntent will transition
   * to the <code>succeeded</code> status (or <code>requires_capture</code>, if <code>capture_method
   * </code> is set to <code>manual</code>).
   *
   * <p>If the <code>confirmation_method</code> is <code>automatic</code>, payment may be attempted
   * using our <a
   * href="https://stripe.com/docs/stripe-js/reference#stripe-handle-card-payment">client SDKs</a>
   * and the PaymentIntent’s <a
   * href="https://stripe.com/docs/api#payment_intent_object-client_secret">client_secret</a>. After
   * <code>next_action</code>s are handled by the client, no additional confirmation is required to
   * complete the payment.
   *
   * <p>If the <code>confirmation_method</code> is <code>manual</code>, all payment attempts must be
   * initiated using a secret key. If any actions are required for the payment, the PaymentIntent
   * will return to the <code>requires_confirmation</code> state after those actions are completed.
   * Your server needs to then explicitly re-confirm the PaymentIntent to initiate the next payment
   * attempt. Read the <a
   * href="https://stripe.com/docs/payments/payment-intents/web-manual">expanded documentation</a>
   * to learn more about manual confirmation.
   */
  public PaymentIntent confirm(PaymentIntentConfirmParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/confirm", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Creates a PaymentIntent object.
   *
   * <p>After the PaymentIntent is created, attach a payment method and <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm</a> to continue the payment.
   * You can read more about the different payment flows available via the Payment Intents API <a
   * href="https://stripe.com/docs/payments/payment-intents">here</a>.
   *
   * <p>When <code>confirm=true</code> is used during creation, it is equivalent to creating and
   * confirming the PaymentIntent in the same call. You may use any parameters available in the <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm API</a> when <code>
   * confirm=true</code> is supplied.
   */
  public static PaymentIntent create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a PaymentIntent object.
   *
   * <p>After the PaymentIntent is created, attach a payment method and <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm</a> to continue the payment.
   * You can read more about the different payment flows available via the Payment Intents API <a
   * href="https://stripe.com/docs/payments/payment-intents">here</a>.
   *
   * <p>When <code>confirm=true</code> is used during creation, it is equivalent to creating and
   * confirming the PaymentIntent in the same call. You may use any parameters available in the <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm API</a> when <code>
   * confirm=true</code> is supplied.
   */
  public static PaymentIntent create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Creates a PaymentIntent object.
   *
   * <p>After the PaymentIntent is created, attach a payment method and <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm</a> to continue the payment.
   * You can read more about the different payment flows available via the Payment Intents API <a
   * href="https://stripe.com/docs/payments/payment-intents">here</a>.
   *
   * <p>When <code>confirm=true</code> is used during creation, it is equivalent to creating and
   * confirming the PaymentIntent in the same call. You may use any parameters available in the <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm API</a> when <code>
   * confirm=true</code> is supplied.
   */
  public static PaymentIntent create(PaymentIntentCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a PaymentIntent object.
   *
   * <p>After the PaymentIntent is created, attach a payment method and <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm</a> to continue the payment.
   * You can read more about the different payment flows available via the Payment Intents API <a
   * href="https://stripe.com/docs/payments/payment-intents">here</a>.
   *
   * <p>When <code>confirm=true</code> is used during creation, it is equivalent to creating and
   * confirming the PaymentIntent in the same call. You may use any parameters available in the <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm API</a> when <code>
   * confirm=true</code> is supplied.
   */
  public static PaymentIntent create(PaymentIntentCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Perform an incremental authorization on an eligible <a
   * href="https://stripe.com/docs/api/payment_intents/object">PaymentIntent</a>. To be eligible,
   * the PaymentIntent’s status must be <code>requires_capture</code> and <a
   * href="https://stripe.com/docs/api/charges/object#charge_object-payment_method_details-card_present-incremental_authorization_supported">incremental_authorization_supported</a>
   * must be <code>true</code>.
   *
   * <p>Incremental authorizations attempt to increase the authorized amount on your customer’s card
   * to the new, higher <code>amount</code> provided. As with the initial authorization, incremental
   * authorizations may be declined. A single PaymentIntent can call this endpoint multiple times to
   * further increase the authorized amount.
   *
   * <p>If the incremental authorization succeeds, the PaymentIntent object is returned with the
   * updated <a
   * href="https://stripe.com/docs/api/payment_intents/object#payment_intent_object-amount">amount</a>.
   * If the incremental authorization fails, a <a
   * href="https://stripe.com/docs/error-codes#card-declined">card_declined</a> error is returned,
   * and no fields on the PaymentIntent or Charge are updated. The PaymentIntent object remains
   * capturable for the previously authorized amount.
   *
   * <p>Each PaymentIntent can have a maximum of 10 incremental authorization attempts, including
   * declines. Once captured, a PaymentIntent can no longer be incremented.
   *
   * <p>Learn more about <a
   * href="https://stripe.com/docs/terminal/features/incremental-authorizations">incremental
   * authorizations</a>.
   */
  public PaymentIntent incrementAuthorization(Map<String, Object> params) throws StripeException {
    return incrementAuthorization(params, (RequestOptions) null);
  }

  /**
   * Perform an incremental authorization on an eligible <a
   * href="https://stripe.com/docs/api/payment_intents/object">PaymentIntent</a>. To be eligible,
   * the PaymentIntent’s status must be <code>requires_capture</code> and <a
   * href="https://stripe.com/docs/api/charges/object#charge_object-payment_method_details-card_present-incremental_authorization_supported">incremental_authorization_supported</a>
   * must be <code>true</code>.
   *
   * <p>Incremental authorizations attempt to increase the authorized amount on your customer’s card
   * to the new, higher <code>amount</code> provided. As with the initial authorization, incremental
   * authorizations may be declined. A single PaymentIntent can call this endpoint multiple times to
   * further increase the authorized amount.
   *
   * <p>If the incremental authorization succeeds, the PaymentIntent object is returned with the
   * updated <a
   * href="https://stripe.com/docs/api/payment_intents/object#payment_intent_object-amount">amount</a>.
   * If the incremental authorization fails, a <a
   * href="https://stripe.com/docs/error-codes#card-declined">card_declined</a> error is returned,
   * and no fields on the PaymentIntent or Charge are updated. The PaymentIntent object remains
   * capturable for the previously authorized amount.
   *
   * <p>Each PaymentIntent can have a maximum of 10 incremental authorization attempts, including
   * declines. Once captured, a PaymentIntent can no longer be incremented.
   *
   * <p>Learn more about <a
   * href="https://stripe.com/docs/terminal/features/incremental-authorizations">incremental
   * authorizations</a>.
   */
  public PaymentIntent incrementAuthorization(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/increment_authorization", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Perform an incremental authorization on an eligible <a
   * href="https://stripe.com/docs/api/payment_intents/object">PaymentIntent</a>. To be eligible,
   * the PaymentIntent’s status must be <code>requires_capture</code> and <a
   * href="https://stripe.com/docs/api/charges/object#charge_object-payment_method_details-card_present-incremental_authorization_supported">incremental_authorization_supported</a>
   * must be <code>true</code>.
   *
   * <p>Incremental authorizations attempt to increase the authorized amount on your customer’s card
   * to the new, higher <code>amount</code> provided. As with the initial authorization, incremental
   * authorizations may be declined. A single PaymentIntent can call this endpoint multiple times to
   * further increase the authorized amount.
   *
   * <p>If the incremental authorization succeeds, the PaymentIntent object is returned with the
   * updated <a
   * href="https://stripe.com/docs/api/payment_intents/object#payment_intent_object-amount">amount</a>.
   * If the incremental authorization fails, a <a
   * href="https://stripe.com/docs/error-codes#card-declined">card_declined</a> error is returned,
   * and no fields on the PaymentIntent or Charge are updated. The PaymentIntent object remains
   * capturable for the previously authorized amount.
   *
   * <p>Each PaymentIntent can have a maximum of 10 incremental authorization attempts, including
   * declines. Once captured, a PaymentIntent can no longer be incremented.
   *
   * <p>Learn more about <a
   * href="https://stripe.com/docs/terminal/features/incremental-authorizations">incremental
   * authorizations</a>.
   */
  public PaymentIntent incrementAuthorization(PaymentIntentIncrementAuthorizationParams params) throws StripeException {
    return incrementAuthorization(params, (RequestOptions) null);
  }

  /**
   * Perform an incremental authorization on an eligible <a
   * href="https://stripe.com/docs/api/payment_intents/object">PaymentIntent</a>. To be eligible,
   * the PaymentIntent’s status must be <code>requires_capture</code> and <a
   * href="https://stripe.com/docs/api/charges/object#charge_object-payment_method_details-card_present-incremental_authorization_supported">incremental_authorization_supported</a>
   * must be <code>true</code>.
   *
   * <p>Incremental authorizations attempt to increase the authorized amount on your customer’s card
   * to the new, higher <code>amount</code> provided. As with the initial authorization, incremental
   * authorizations may be declined. A single PaymentIntent can call this endpoint multiple times to
   * further increase the authorized amount.
   *
   * <p>If the incremental authorization succeeds, the PaymentIntent object is returned with the
   * updated <a
   * href="https://stripe.com/docs/api/payment_intents/object#payment_intent_object-amount">amount</a>.
   * If the incremental authorization fails, a <a
   * href="https://stripe.com/docs/error-codes#card-declined">card_declined</a> error is returned,
   * and no fields on the PaymentIntent or Charge are updated. The PaymentIntent object remains
   * capturable for the previously authorized amount.
   *
   * <p>Each PaymentIntent can have a maximum of 10 incremental authorization attempts, including
   * declines. Once captured, a PaymentIntent can no longer be incremented.
   *
   * <p>Learn more about <a
   * href="https://stripe.com/docs/terminal/features/incremental-authorizations">incremental
   * authorizations</a>.
   */
  public PaymentIntent incrementAuthorization(PaymentIntentIncrementAuthorizationParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/increment_authorization", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Returns a list of PaymentIntents.
   */
  public static PaymentIntentCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of PaymentIntents.
   */
  public static PaymentIntentCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
    return ApiResource.requestCollection(url, params, PaymentIntentCollection.class, options);
  }

  /**
   * Returns a list of PaymentIntents.
   */
  public static PaymentIntentCollection list(PaymentIntentListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of PaymentIntents.
   */
  public static PaymentIntentCollection list(PaymentIntentListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents");
    return ApiResource.requestCollection(url, params, PaymentIntentCollection.class, options);
  }

  /**
   * Retrieves the details of a PaymentIntent that has previously been created.
   *
   * <p>Client-side retrieval using a publishable key is allowed when the <code>client_secret</code>
   * is provided in the query string.
   *
   * <p>When retrieved with a publishable key, only a subset of properties will be returned. Please
   * refer to the <a href="https://stripe.com/docs/api#payment_intent_object">payment intent</a>
   * object reference for more details.
   */
  public static PaymentIntent retrieve(String intent) throws StripeException {
    return retrieve(intent, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of a PaymentIntent that has previously been created.
   *
   * <p>Client-side retrieval using a publishable key is allowed when the <code>client_secret</code>
   * is provided in the query string.
   *
   * <p>When retrieved with a publishable key, only a subset of properties will be returned. Please
   * refer to the <a href="https://stripe.com/docs/api#payment_intent_object">payment intent</a>
   * object reference for more details.
   */
  public static PaymentIntent retrieve(String intent, RequestOptions options) throws StripeException {
    return retrieve(intent, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of a PaymentIntent that has previously been created.
   *
   * <p>Client-side retrieval using a publishable key is allowed when the <code>client_secret</code>
   * is provided in the query string.
   *
   * <p>When retrieved with a publishable key, only a subset of properties will be returned. Please
   * refer to the <a href="https://stripe.com/docs/api#payment_intent_object">payment intent</a>
   * object reference for more details.
   */
  public static PaymentIntent retrieve(String intent, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(intent)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentIntent.class, options);
  }

  /**
   * Retrieves the details of a PaymentIntent that has previously been created.
   *
   * <p>Client-side retrieval using a publishable key is allowed when the <code>client_secret</code>
   * is provided in the query string.
   *
   * <p>When retrieved with a publishable key, only a subset of properties will be returned. Please
   * refer to the <a href="https://stripe.com/docs/api#payment_intent_object">payment intent</a>
   * object reference for more details.
   */
  public static PaymentIntent retrieve(String intent, PaymentIntentRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(intent)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentIntent.class, options);
  }

  /**
   * Search for PaymentIntents you’ve previously created using Stripe’s <a
   * href="https://stripe.com/docs/search#search-query-language">Search Query Language</a>. Don’t
   * use search in read-after-write flows where strict consistency is necessary. Under normal
   * operating conditions, data is searchable in less than a minute. Occasionally, propagation of
   * new or updated data can be up to an hour behind during outages. Search functionality is not
   * available to merchants in India.
   */
  public static PaymentIntentSearchResult search(Map<String, Object> params) throws StripeException {
    return search(params, (RequestOptions) null);
  }

  /**
   * Search for PaymentIntents you’ve previously created using Stripe’s <a
   * href="https://stripe.com/docs/search#search-query-language">Search Query Language</a>. Don’t
   * use search in read-after-write flows where strict consistency is necessary. Under normal
   * operating conditions, data is searchable in less than a minute. Occasionally, propagation of
   * new or updated data can be up to an hour behind during outages. Search functionality is not
   * available to merchants in India.
   */
  public static PaymentIntentSearchResult search(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents/search");
    return ApiResource.requestSearchResult(url, params, PaymentIntentSearchResult.class, options);
  }

  /**
   * Search for PaymentIntents you’ve previously created using Stripe’s <a
   * href="https://stripe.com/docs/search#search-query-language">Search Query Language</a>. Don’t
   * use search in read-after-write flows where strict consistency is necessary. Under normal
   * operating conditions, data is searchable in less than a minute. Occasionally, propagation of
   * new or updated data can be up to an hour behind during outages. Search functionality is not
   * available to merchants in India.
   */
  public static PaymentIntentSearchResult search(PaymentIntentSearchParams params) throws StripeException {
    return search(params, (RequestOptions) null);
  }

  /**
   * Search for PaymentIntents you’ve previously created using Stripe’s <a
   * href="https://stripe.com/docs/search#search-query-language">Search Query Language</a>. Don’t
   * use search in read-after-write flows where strict consistency is necessary. Under normal
   * operating conditions, data is searchable in less than a minute. Occasionally, propagation of
   * new or updated data can be up to an hour behind during outages. Search functionality is not
   * available to merchants in India.
   */
  public static PaymentIntentSearchResult search(PaymentIntentSearchParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_intents/search");
    return ApiResource.requestSearchResult(url, params, PaymentIntentSearchResult.class, options);
  }

  /**
   * Updates properties on a PaymentIntent object without confirming.
   *
   * <p>Depending on which properties you update, you may need to confirm the PaymentIntent again.
   * For example, updating the <code>payment_method</code> will always require you to confirm the
   * PaymentIntent again. If you prefer to update and confirm at the same time, we recommend
   * updating properties via the <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm API</a> instead.
   */
  @Override
  public PaymentIntent update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates properties on a PaymentIntent object without confirming.
   *
   * <p>Depending on which properties you update, you may need to confirm the PaymentIntent again.
   * For example, updating the <code>payment_method</code> will always require you to confirm the
   * PaymentIntent again. If you prefer to update and confirm at the same time, we recommend
   * updating properties via the <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm API</a> instead.
   */
  @Override
  public PaymentIntent update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Updates properties on a PaymentIntent object without confirming.
   *
   * <p>Depending on which properties you update, you may need to confirm the PaymentIntent again.
   * For example, updating the <code>payment_method</code> will always require you to confirm the
   * PaymentIntent again. If you prefer to update and confirm at the same time, we recommend
   * updating properties via the <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm API</a> instead.
   */
  public PaymentIntent update(PaymentIntentUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates properties on a PaymentIntent object without confirming.
   *
   * <p>Depending on which properties you update, you may need to confirm the PaymentIntent again.
   * For example, updating the <code>payment_method</code> will always require you to confirm the
   * PaymentIntent again. If you prefer to update and confirm at the same time, we recommend
   * updating properties via the <a
   * href="https://stripe.com/docs/api/payment_intents/confirm">confirm API</a> instead.
   */
  public PaymentIntent update(PaymentIntentUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Verifies microdeposits on a PaymentIntent object.
   */
  public PaymentIntent verifyMicrodeposits() throws StripeException {
    return verifyMicrodeposits((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Verifies microdeposits on a PaymentIntent object.
   */
  public PaymentIntent verifyMicrodeposits(RequestOptions options) throws StripeException {
    return verifyMicrodeposits((Map<String, Object>) null, options);
  }

  /**
   * Verifies microdeposits on a PaymentIntent object.
   */
  public PaymentIntent verifyMicrodeposits(Map<String, Object> params) throws StripeException {
    return verifyMicrodeposits(params, (RequestOptions) null);
  }

  /**
   * Verifies microdeposits on a PaymentIntent object.
   */
  public PaymentIntent verifyMicrodeposits(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/verify_microdeposits", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }

  /**
   * Verifies microdeposits on a PaymentIntent object.
   */
  public PaymentIntent verifyMicrodeposits(PaymentIntentVerifyMicrodepositsParams params) throws StripeException {
    return verifyMicrodeposits(params, (RequestOptions) null);
  }

  /**
   * Verifies microdeposits on a PaymentIntent object.
   */
  public PaymentIntent verifyMicrodeposits(PaymentIntentVerifyMicrodepositsParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_intents/%s/verify_microdeposits", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentIntent.class, options);
  }


  public static class AmountDetails extends StripeObject {
    @SerializedName("tip")
    Tip tip;


    public static class Tip extends StripeObject {
      @SerializedName("amount")
      Long amount;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getAmount() {
        return this.amount;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAmount(final Long amount) {
        this.amount = amount;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.AmountDetails.Tip)) return false;
        final PaymentIntent.AmountDetails.Tip other = (PaymentIntent.AmountDetails.Tip) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$amount = this.getAmount();
        final java.lang.Object other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.AmountDetails.Tip;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $amount = this.getAmount();
        result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Tip getTip() {
      return this.tip;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTip(final Tip tip) {
      this.tip = tip;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.AmountDetails)) return false;
      final PaymentIntent.AmountDetails other = (PaymentIntent.AmountDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$tip = this.getTip();
      final java.lang.Object other$tip = other.getTip();
      if (this$tip == null ? other$tip != null : !this$tip.equals(other$tip)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.AmountDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $tip = this.getTip();
      result = result * PRIME + ($tip == null ? 43 : $tip.hashCode());
      return result;
    }
  }


  /**
   * Portion of the amount that corresponds to a tip.
   */
  public static class NextAction extends StripeObject {
    @SerializedName("alipay_handle_redirect")
    NextActionAlipayHandleRedirect alipayHandleRedirect;
    @SerializedName("boleto_display_details")
    NextActionDisplayBoletoDetails boletoDisplayDetails;
    @SerializedName("card_await_notification")
    NextActionCardAwaitNotification cardAwaitNotification;
    @SerializedName("display_bank_transfer_instructions")
    NextActionDisplayBankTransferInstructions displayBankTransferInstructions;
    @SerializedName("konbini_display_details")
    NextActionKonbiniDisplayDetails konbiniDisplayDetails;
    @SerializedName("oxxo_display_details")
    NextActionOxxoDisplayDetails oxxoDisplayDetails;
    @SerializedName("paynow_display_qr_code")
    PaynowDisplayQrCode paynowDisplayQrCode;
    @SerializedName("pix_display_qr_code")
    PixDisplayQrCode pixDisplayQrCode;
    @SerializedName("promptpay_display_qr_code")
    PromptpayDisplayQrCode promptpayDisplayQrCode;
    @SerializedName("redirect_to_url")
    NextActionRedirectToUrl redirectToUrl;
    /**
     * Type of the next action to perform, one of {@code redirect_to_url}, {@code use_stripe_sdk},
     * {@code alipay_handle_redirect}, {@code oxxo_display_details}, or {@code
     * verify_with_microdeposits}.
     */
    @SerializedName("type")
    String type;
    /**
     * When confirming a PaymentIntent with Stripe.js, Stripe.js depends on the contents of this
     * dictionary to invoke authentication flows. The shape of the contents is subject to change and
     * is only intended to be used by Stripe.js.
     */
    @SerializedName("use_stripe_sdk")
    Map<String, Object> useStripeSdk;
    @SerializedName("verify_with_microdeposits")
    VerifyWithMicrodeposits verifyWithMicrodeposits;
    @SerializedName("wechat_pay_display_qr_code")
    WechatPayDisplayQrCode wechatPayDisplayQrCode;
    @SerializedName("wechat_pay_redirect_to_android_app")
    WechatPayRedirectToAndroidApp wechatPayRedirectToAndroidApp;
    @SerializedName("wechat_pay_redirect_to_ios_app")
    WechatPayRedirectToIosApp wechatPayRedirectToIosApp;


    public static class PaynowDisplayQrCode extends StripeObject {
      /**
       * The raw data string used to generate QR code, it should be used together with QR code
       * library.
       */
      @SerializedName("data")
      String data;
      /**
       * The image_url_png string used to render QR code.
       */
      @SerializedName("image_url_png")
      String imageUrlPng;
      /**
       * The image_url_svg string used to render QR code.
       */
      @SerializedName("image_url_svg")
      String imageUrlSvg;

      /**
       * The raw data string used to generate QR code, it should be used together with QR code
       * library.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getData() {
        return this.data;
      }

      /**
       * The image_url_png string used to render QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getImageUrlPng() {
        return this.imageUrlPng;
      }

      /**
       * The image_url_svg string used to render QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getImageUrlSvg() {
        return this.imageUrlSvg;
      }

      /**
       * The raw data string used to generate QR code, it should be used together with QR code
       * library.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setData(final String data) {
        this.data = data;
      }

      /**
       * The image_url_png string used to render QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setImageUrlPng(final String imageUrlPng) {
        this.imageUrlPng = imageUrlPng;
      }

      /**
       * The image_url_svg string used to render QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setImageUrlSvg(final String imageUrlSvg) {
        this.imageUrlSvg = imageUrlSvg;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.NextAction.PaynowDisplayQrCode)) return false;
        final PaymentIntent.NextAction.PaynowDisplayQrCode other = (PaymentIntent.NextAction.PaynowDisplayQrCode) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$data = this.getData();
        final java.lang.Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) return false;
        final java.lang.Object this$imageUrlPng = this.getImageUrlPng();
        final java.lang.Object other$imageUrlPng = other.getImageUrlPng();
        if (this$imageUrlPng == null ? other$imageUrlPng != null : !this$imageUrlPng.equals(other$imageUrlPng)) return false;
        final java.lang.Object this$imageUrlSvg = this.getImageUrlSvg();
        final java.lang.Object other$imageUrlSvg = other.getImageUrlSvg();
        if (this$imageUrlSvg == null ? other$imageUrlSvg != null : !this$imageUrlSvg.equals(other$imageUrlSvg)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.NextAction.PaynowDisplayQrCode;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $data = this.getData();
        result = result * PRIME + ($data == null ? 43 : $data.hashCode());
        final java.lang.Object $imageUrlPng = this.getImageUrlPng();
        result = result * PRIME + ($imageUrlPng == null ? 43 : $imageUrlPng.hashCode());
        final java.lang.Object $imageUrlSvg = this.getImageUrlSvg();
        result = result * PRIME + ($imageUrlSvg == null ? 43 : $imageUrlSvg.hashCode());
        return result;
      }
    }


    public static class PixDisplayQrCode extends StripeObject {
      /**
       * The raw data string used to generate QR code, it should be used together with QR code
       * library.
       */
      @SerializedName("data")
      String data;
      /**
       * The date (unix timestamp) when the PIX expires.
       */
      @SerializedName("expires_at")
      Long expiresAt;
      /**
       * The URL to the hosted pix instructions page, which allows customers to view the pix QR
       * code.
       */
      @SerializedName("hosted_instructions_url")
      String hostedInstructionsUrl;
      /**
       * The image_url_png string used to render png QR code.
       */
      @SerializedName("image_url_png")
      String imageUrlPng;
      /**
       * The image_url_svg string used to render svg QR code.
       */
      @SerializedName("image_url_svg")
      String imageUrlSvg;

      /**
       * The raw data string used to generate QR code, it should be used together with QR code
       * library.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getData() {
        return this.data;
      }

      /**
       * The date (unix timestamp) when the PIX expires.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getExpiresAt() {
        return this.expiresAt;
      }

      /**
       * The URL to the hosted pix instructions page, which allows customers to view the pix QR
       * code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getHostedInstructionsUrl() {
        return this.hostedInstructionsUrl;
      }

      /**
       * The image_url_png string used to render png QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getImageUrlPng() {
        return this.imageUrlPng;
      }

      /**
       * The image_url_svg string used to render svg QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getImageUrlSvg() {
        return this.imageUrlSvg;
      }

      /**
       * The raw data string used to generate QR code, it should be used together with QR code
       * library.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setData(final String data) {
        this.data = data;
      }

      /**
       * The date (unix timestamp) when the PIX expires.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExpiresAt(final Long expiresAt) {
        this.expiresAt = expiresAt;
      }

      /**
       * The URL to the hosted pix instructions page, which allows customers to view the pix QR
       * code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setHostedInstructionsUrl(final String hostedInstructionsUrl) {
        this.hostedInstructionsUrl = hostedInstructionsUrl;
      }

      /**
       * The image_url_png string used to render png QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setImageUrlPng(final String imageUrlPng) {
        this.imageUrlPng = imageUrlPng;
      }

      /**
       * The image_url_svg string used to render svg QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setImageUrlSvg(final String imageUrlSvg) {
        this.imageUrlSvg = imageUrlSvg;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.NextAction.PixDisplayQrCode)) return false;
        final PaymentIntent.NextAction.PixDisplayQrCode other = (PaymentIntent.NextAction.PixDisplayQrCode) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$expiresAt = this.getExpiresAt();
        final java.lang.Object other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !this$expiresAt.equals(other$expiresAt)) return false;
        final java.lang.Object this$data = this.getData();
        final java.lang.Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) return false;
        final java.lang.Object this$hostedInstructionsUrl = this.getHostedInstructionsUrl();
        final java.lang.Object other$hostedInstructionsUrl = other.getHostedInstructionsUrl();
        if (this$hostedInstructionsUrl == null ? other$hostedInstructionsUrl != null : !this$hostedInstructionsUrl.equals(other$hostedInstructionsUrl)) return false;
        final java.lang.Object this$imageUrlPng = this.getImageUrlPng();
        final java.lang.Object other$imageUrlPng = other.getImageUrlPng();
        if (this$imageUrlPng == null ? other$imageUrlPng != null : !this$imageUrlPng.equals(other$imageUrlPng)) return false;
        final java.lang.Object this$imageUrlSvg = this.getImageUrlSvg();
        final java.lang.Object other$imageUrlSvg = other.getImageUrlSvg();
        if (this$imageUrlSvg == null ? other$imageUrlSvg != null : !this$imageUrlSvg.equals(other$imageUrlSvg)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.NextAction.PixDisplayQrCode;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $expiresAt = this.getExpiresAt();
        result = result * PRIME + ($expiresAt == null ? 43 : $expiresAt.hashCode());
        final java.lang.Object $data = this.getData();
        result = result * PRIME + ($data == null ? 43 : $data.hashCode());
        final java.lang.Object $hostedInstructionsUrl = this.getHostedInstructionsUrl();
        result = result * PRIME + ($hostedInstructionsUrl == null ? 43 : $hostedInstructionsUrl.hashCode());
        final java.lang.Object $imageUrlPng = this.getImageUrlPng();
        result = result * PRIME + ($imageUrlPng == null ? 43 : $imageUrlPng.hashCode());
        final java.lang.Object $imageUrlSvg = this.getImageUrlSvg();
        result = result * PRIME + ($imageUrlSvg == null ? 43 : $imageUrlSvg.hashCode());
        return result;
      }
    }


    public static class PromptpayDisplayQrCode extends StripeObject {
      /**
       * The raw data string used to generate QR code, it should be used together with QR code
       * library.
       */
      @SerializedName("data")
      String data;
      /**
       * The URL to the hosted PromptPay instructions page, which allows customers to view the
       * PromptPay QR code.
       */
      @SerializedName("hosted_instructions_url")
      String hostedInstructionsUrl;
      /**
       * The image_url_png string used to render QR code, can be used as &lt;img src=&quot;…&quot;
       * /&gt;.
       */
      @SerializedName("image_url_png")
      String imageUrlPng;
      /**
       * The image_url_svg string used to render QR code, can be used as &lt;img src=&quot;…&quot;
       * /&gt;.
       */
      @SerializedName("image_url_svg")
      String imageUrlSvg;

      /**
       * The raw data string used to generate QR code, it should be used together with QR code
       * library.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getData() {
        return this.data;
      }

      /**
       * The URL to the hosted PromptPay instructions page, which allows customers to view the
       * PromptPay QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getHostedInstructionsUrl() {
        return this.hostedInstructionsUrl;
      }

      /**
       * The image_url_png string used to render QR code, can be used as &lt;img src=&quot;…&quot;
       * /&gt;.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getImageUrlPng() {
        return this.imageUrlPng;
      }

      /**
       * The image_url_svg string used to render QR code, can be used as &lt;img src=&quot;…&quot;
       * /&gt;.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getImageUrlSvg() {
        return this.imageUrlSvg;
      }

      /**
       * The raw data string used to generate QR code, it should be used together with QR code
       * library.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setData(final String data) {
        this.data = data;
      }

      /**
       * The URL to the hosted PromptPay instructions page, which allows customers to view the
       * PromptPay QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setHostedInstructionsUrl(final String hostedInstructionsUrl) {
        this.hostedInstructionsUrl = hostedInstructionsUrl;
      }

      /**
       * The image_url_png string used to render QR code, can be used as &lt;img src=&quot;…&quot;
       * /&gt;.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setImageUrlPng(final String imageUrlPng) {
        this.imageUrlPng = imageUrlPng;
      }

      /**
       * The image_url_svg string used to render QR code, can be used as &lt;img src=&quot;…&quot;
       * /&gt;.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setImageUrlSvg(final String imageUrlSvg) {
        this.imageUrlSvg = imageUrlSvg;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.NextAction.PromptpayDisplayQrCode)) return false;
        final PaymentIntent.NextAction.PromptpayDisplayQrCode other = (PaymentIntent.NextAction.PromptpayDisplayQrCode) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$data = this.getData();
        final java.lang.Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) return false;
        final java.lang.Object this$hostedInstructionsUrl = this.getHostedInstructionsUrl();
        final java.lang.Object other$hostedInstructionsUrl = other.getHostedInstructionsUrl();
        if (this$hostedInstructionsUrl == null ? other$hostedInstructionsUrl != null : !this$hostedInstructionsUrl.equals(other$hostedInstructionsUrl)) return false;
        final java.lang.Object this$imageUrlPng = this.getImageUrlPng();
        final java.lang.Object other$imageUrlPng = other.getImageUrlPng();
        if (this$imageUrlPng == null ? other$imageUrlPng != null : !this$imageUrlPng.equals(other$imageUrlPng)) return false;
        final java.lang.Object this$imageUrlSvg = this.getImageUrlSvg();
        final java.lang.Object other$imageUrlSvg = other.getImageUrlSvg();
        if (this$imageUrlSvg == null ? other$imageUrlSvg != null : !this$imageUrlSvg.equals(other$imageUrlSvg)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.NextAction.PromptpayDisplayQrCode;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $data = this.getData();
        result = result * PRIME + ($data == null ? 43 : $data.hashCode());
        final java.lang.Object $hostedInstructionsUrl = this.getHostedInstructionsUrl();
        result = result * PRIME + ($hostedInstructionsUrl == null ? 43 : $hostedInstructionsUrl.hashCode());
        final java.lang.Object $imageUrlPng = this.getImageUrlPng();
        result = result * PRIME + ($imageUrlPng == null ? 43 : $imageUrlPng.hashCode());
        final java.lang.Object $imageUrlSvg = this.getImageUrlSvg();
        result = result * PRIME + ($imageUrlSvg == null ? 43 : $imageUrlSvg.hashCode());
        return result;
      }
    }


    public static class VerifyWithMicrodeposits extends StripeObject {
      /**
       * The timestamp when the microdeposits are expected to land.
       */
      @SerializedName("arrival_date")
      Long arrivalDate;
      /**
       * The URL for the hosted verification page, which allows customers to verify their bank
       * account.
       */
      @SerializedName("hosted_verification_url")
      String hostedVerificationUrl;
      /**
       * The type of the microdeposit sent to the customer. Used to distinguish between different
       * verification methods.
       *
       * <p>One of {@code amounts}, or {@code descriptor_code}.
       */
      @SerializedName("microdeposit_type")
      String microdepositType;

      /**
       * The timestamp when the microdeposits are expected to land.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getArrivalDate() {
        return this.arrivalDate;
      }

      /**
       * The URL for the hosted verification page, which allows customers to verify their bank
       * account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getHostedVerificationUrl() {
        return this.hostedVerificationUrl;
      }

      /**
       * The type of the microdeposit sent to the customer. Used to distinguish between different
       * verification methods.
       *
       * <p>One of {@code amounts}, or {@code descriptor_code}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getMicrodepositType() {
        return this.microdepositType;
      }

      /**
       * The timestamp when the microdeposits are expected to land.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setArrivalDate(final Long arrivalDate) {
        this.arrivalDate = arrivalDate;
      }

      /**
       * The URL for the hosted verification page, which allows customers to verify their bank
       * account.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setHostedVerificationUrl(final String hostedVerificationUrl) {
        this.hostedVerificationUrl = hostedVerificationUrl;
      }

      /**
       * The type of the microdeposit sent to the customer. Used to distinguish between different
       * verification methods.
       *
       * <p>One of {@code amounts}, or {@code descriptor_code}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMicrodepositType(final String microdepositType) {
        this.microdepositType = microdepositType;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.NextAction.VerifyWithMicrodeposits)) return false;
        final PaymentIntent.NextAction.VerifyWithMicrodeposits other = (PaymentIntent.NextAction.VerifyWithMicrodeposits) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$arrivalDate = this.getArrivalDate();
        final java.lang.Object other$arrivalDate = other.getArrivalDate();
        if (this$arrivalDate == null ? other$arrivalDate != null : !this$arrivalDate.equals(other$arrivalDate)) return false;
        final java.lang.Object this$hostedVerificationUrl = this.getHostedVerificationUrl();
        final java.lang.Object other$hostedVerificationUrl = other.getHostedVerificationUrl();
        if (this$hostedVerificationUrl == null ? other$hostedVerificationUrl != null : !this$hostedVerificationUrl.equals(other$hostedVerificationUrl)) return false;
        final java.lang.Object this$microdepositType = this.getMicrodepositType();
        final java.lang.Object other$microdepositType = other.getMicrodepositType();
        if (this$microdepositType == null ? other$microdepositType != null : !this$microdepositType.equals(other$microdepositType)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.NextAction.VerifyWithMicrodeposits;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $arrivalDate = this.getArrivalDate();
        result = result * PRIME + ($arrivalDate == null ? 43 : $arrivalDate.hashCode());
        final java.lang.Object $hostedVerificationUrl = this.getHostedVerificationUrl();
        result = result * PRIME + ($hostedVerificationUrl == null ? 43 : $hostedVerificationUrl.hashCode());
        final java.lang.Object $microdepositType = this.getMicrodepositType();
        result = result * PRIME + ($microdepositType == null ? 43 : $microdepositType.hashCode());
        return result;
      }
    }


    public static class WechatPayDisplayQrCode extends StripeObject {
      /**
       * The data being used to generate QR code.
       */
      @SerializedName("data")
      String data;
      /**
       * The base64 image data for a pre-generated QR code.
       */
      @SerializedName("image_data_url")
      String imageDataUrl;
      /**
       * The image_url_png string used to render QR code.
       */
      @SerializedName("image_url_png")
      String imageUrlPng;
      /**
       * The image_url_svg string used to render QR code.
       */
      @SerializedName("image_url_svg")
      String imageUrlSvg;

      /**
       * The data being used to generate QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getData() {
        return this.data;
      }

      /**
       * The base64 image data for a pre-generated QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getImageDataUrl() {
        return this.imageDataUrl;
      }

      /**
       * The image_url_png string used to render QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getImageUrlPng() {
        return this.imageUrlPng;
      }

      /**
       * The image_url_svg string used to render QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getImageUrlSvg() {
        return this.imageUrlSvg;
      }

      /**
       * The data being used to generate QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setData(final String data) {
        this.data = data;
      }

      /**
       * The base64 image data for a pre-generated QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setImageDataUrl(final String imageDataUrl) {
        this.imageDataUrl = imageDataUrl;
      }

      /**
       * The image_url_png string used to render QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setImageUrlPng(final String imageUrlPng) {
        this.imageUrlPng = imageUrlPng;
      }

      /**
       * The image_url_svg string used to render QR code.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setImageUrlSvg(final String imageUrlSvg) {
        this.imageUrlSvg = imageUrlSvg;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.NextAction.WechatPayDisplayQrCode)) return false;
        final PaymentIntent.NextAction.WechatPayDisplayQrCode other = (PaymentIntent.NextAction.WechatPayDisplayQrCode) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$data = this.getData();
        final java.lang.Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) return false;
        final java.lang.Object this$imageDataUrl = this.getImageDataUrl();
        final java.lang.Object other$imageDataUrl = other.getImageDataUrl();
        if (this$imageDataUrl == null ? other$imageDataUrl != null : !this$imageDataUrl.equals(other$imageDataUrl)) return false;
        final java.lang.Object this$imageUrlPng = this.getImageUrlPng();
        final java.lang.Object other$imageUrlPng = other.getImageUrlPng();
        if (this$imageUrlPng == null ? other$imageUrlPng != null : !this$imageUrlPng.equals(other$imageUrlPng)) return false;
        final java.lang.Object this$imageUrlSvg = this.getImageUrlSvg();
        final java.lang.Object other$imageUrlSvg = other.getImageUrlSvg();
        if (this$imageUrlSvg == null ? other$imageUrlSvg != null : !this$imageUrlSvg.equals(other$imageUrlSvg)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.NextAction.WechatPayDisplayQrCode;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $data = this.getData();
        result = result * PRIME + ($data == null ? 43 : $data.hashCode());
        final java.lang.Object $imageDataUrl = this.getImageDataUrl();
        result = result * PRIME + ($imageDataUrl == null ? 43 : $imageDataUrl.hashCode());
        final java.lang.Object $imageUrlPng = this.getImageUrlPng();
        result = result * PRIME + ($imageUrlPng == null ? 43 : $imageUrlPng.hashCode());
        final java.lang.Object $imageUrlSvg = this.getImageUrlSvg();
        result = result * PRIME + ($imageUrlSvg == null ? 43 : $imageUrlSvg.hashCode());
        return result;
      }
    }


    public static class WechatPayRedirectToAndroidApp extends StripeObject {
      /**
       * app_id is the APP ID registered on WeChat open platform.
       */
      @SerializedName("app_id")
      String appId;
      /**
       * nonce_str is a random string.
       */
      @SerializedName("nonce_str")
      String nonceStr;
      /**
       * an unique merchant ID assigned by WeChat Pay.
       */
      @SerializedName("partner_id")
      String partnerId;
      /**
       * an unique trading ID assigned by WeChat Pay.
       */
      @SerializedName("prepay_id")
      String prepayId;
      /**
       * A signature.
       */
      @SerializedName("sign")
      String sign;
      /**
       * Specifies the current time in epoch format.
       */
      @SerializedName("timestamp")
      String timestamp;
      // package is a reserved word so we append an
      // underscore to the private field and expose
      // a custom getter and setter
      @SerializedName("package")
      String package_;

      public String getPackage() {
        return this.package_;
      }

      public void setPackage(String package_) {
        this.package_ = package_;
      }

      /**
       * app_id is the APP ID registered on WeChat open platform.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAppId() {
        return this.appId;
      }

      /**
       * nonce_str is a random string.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getNonceStr() {
        return this.nonceStr;
      }

      /**
       * an unique merchant ID assigned by WeChat Pay.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getPartnerId() {
        return this.partnerId;
      }

      /**
       * an unique trading ID assigned by WeChat Pay.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getPrepayId() {
        return this.prepayId;
      }

      /**
       * A signature.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSign() {
        return this.sign;
      }

      /**
       * Specifies the current time in epoch format.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getTimestamp() {
        return this.timestamp;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getPackage_() {
        return this.package_;
      }

      /**
       * app_id is the APP ID registered on WeChat open platform.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAppId(final String appId) {
        this.appId = appId;
      }

      /**
       * nonce_str is a random string.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setNonceStr(final String nonceStr) {
        this.nonceStr = nonceStr;
      }

      /**
       * an unique merchant ID assigned by WeChat Pay.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPartnerId(final String partnerId) {
        this.partnerId = partnerId;
      }

      /**
       * an unique trading ID assigned by WeChat Pay.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPrepayId(final String prepayId) {
        this.prepayId = prepayId;
      }

      /**
       * A signature.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSign(final String sign) {
        this.sign = sign;
      }

      /**
       * Specifies the current time in epoch format.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setTimestamp(final String timestamp) {
        this.timestamp = timestamp;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPackage_(final String package_) {
        this.package_ = package_;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.NextAction.WechatPayRedirectToAndroidApp)) return false;
        final PaymentIntent.NextAction.WechatPayRedirectToAndroidApp other = (PaymentIntent.NextAction.WechatPayRedirectToAndroidApp) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$appId = this.getAppId();
        final java.lang.Object other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) return false;
        final java.lang.Object this$nonceStr = this.getNonceStr();
        final java.lang.Object other$nonceStr = other.getNonceStr();
        if (this$nonceStr == null ? other$nonceStr != null : !this$nonceStr.equals(other$nonceStr)) return false;
        final java.lang.Object this$partnerId = this.getPartnerId();
        final java.lang.Object other$partnerId = other.getPartnerId();
        if (this$partnerId == null ? other$partnerId != null : !this$partnerId.equals(other$partnerId)) return false;
        final java.lang.Object this$prepayId = this.getPrepayId();
        final java.lang.Object other$prepayId = other.getPrepayId();
        if (this$prepayId == null ? other$prepayId != null : !this$prepayId.equals(other$prepayId)) return false;
        final java.lang.Object this$sign = this.getSign();
        final java.lang.Object other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) return false;
        final java.lang.Object this$timestamp = this.getTimestamp();
        final java.lang.Object other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) return false;
        final java.lang.Object this$package_ = this.getPackage_();
        final java.lang.Object other$package_ = other.getPackage_();
        if (this$package_ == null ? other$package_ != null : !this$package_.equals(other$package_)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.NextAction.WechatPayRedirectToAndroidApp;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $appId = this.getAppId();
        result = result * PRIME + ($appId == null ? 43 : $appId.hashCode());
        final java.lang.Object $nonceStr = this.getNonceStr();
        result = result * PRIME + ($nonceStr == null ? 43 : $nonceStr.hashCode());
        final java.lang.Object $partnerId = this.getPartnerId();
        result = result * PRIME + ($partnerId == null ? 43 : $partnerId.hashCode());
        final java.lang.Object $prepayId = this.getPrepayId();
        result = result * PRIME + ($prepayId == null ? 43 : $prepayId.hashCode());
        final java.lang.Object $sign = this.getSign();
        result = result * PRIME + ($sign == null ? 43 : $sign.hashCode());
        final java.lang.Object $timestamp = this.getTimestamp();
        result = result * PRIME + ($timestamp == null ? 43 : $timestamp.hashCode());
        final java.lang.Object $package_ = this.getPackage_();
        result = result * PRIME + ($package_ == null ? 43 : $package_.hashCode());
        return result;
      }
    }


    public static class WechatPayRedirectToIosApp extends StripeObject {
      @SerializedName("native_url")
      String nativeUrl;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getNativeUrl() {
        return this.nativeUrl;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setNativeUrl(final String nativeUrl) {
        this.nativeUrl = nativeUrl;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.NextAction.WechatPayRedirectToIosApp)) return false;
        final PaymentIntent.NextAction.WechatPayRedirectToIosApp other = (PaymentIntent.NextAction.WechatPayRedirectToIosApp) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$nativeUrl = this.getNativeUrl();
        final java.lang.Object other$nativeUrl = other.getNativeUrl();
        if (this$nativeUrl == null ? other$nativeUrl != null : !this$nativeUrl.equals(other$nativeUrl)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.NextAction.WechatPayRedirectToIosApp;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $nativeUrl = this.getNativeUrl();
        result = result * PRIME + ($nativeUrl == null ? 43 : $nativeUrl.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NextActionAlipayHandleRedirect getAlipayHandleRedirect() {
      return this.alipayHandleRedirect;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NextActionDisplayBoletoDetails getBoletoDisplayDetails() {
      return this.boletoDisplayDetails;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NextActionCardAwaitNotification getCardAwaitNotification() {
      return this.cardAwaitNotification;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NextActionDisplayBankTransferInstructions getDisplayBankTransferInstructions() {
      return this.displayBankTransferInstructions;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NextActionKonbiniDisplayDetails getKonbiniDisplayDetails() {
      return this.konbiniDisplayDetails;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NextActionOxxoDisplayDetails getOxxoDisplayDetails() {
      return this.oxxoDisplayDetails;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PaynowDisplayQrCode getPaynowDisplayQrCode() {
      return this.paynowDisplayQrCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PixDisplayQrCode getPixDisplayQrCode() {
      return this.pixDisplayQrCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PromptpayDisplayQrCode getPromptpayDisplayQrCode() {
      return this.promptpayDisplayQrCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NextActionRedirectToUrl getRedirectToUrl() {
      return this.redirectToUrl;
    }

    /**
     * Type of the next action to perform, one of {@code redirect_to_url}, {@code use_stripe_sdk},
     * {@code alipay_handle_redirect}, {@code oxxo_display_details}, or {@code
     * verify_with_microdeposits}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    /**
     * When confirming a PaymentIntent with Stripe.js, Stripe.js depends on the contents of this
     * dictionary to invoke authentication flows. The shape of the contents is subject to change and
     * is only intended to be used by Stripe.js.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getUseStripeSdk() {
      return this.useStripeSdk;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public VerifyWithMicrodeposits getVerifyWithMicrodeposits() {
      return this.verifyWithMicrodeposits;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WechatPayDisplayQrCode getWechatPayDisplayQrCode() {
      return this.wechatPayDisplayQrCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WechatPayRedirectToAndroidApp getWechatPayRedirectToAndroidApp() {
      return this.wechatPayRedirectToAndroidApp;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WechatPayRedirectToIosApp getWechatPayRedirectToIosApp() {
      return this.wechatPayRedirectToIosApp;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAlipayHandleRedirect(final NextActionAlipayHandleRedirect alipayHandleRedirect) {
      this.alipayHandleRedirect = alipayHandleRedirect;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBoletoDisplayDetails(final NextActionDisplayBoletoDetails boletoDisplayDetails) {
      this.boletoDisplayDetails = boletoDisplayDetails;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCardAwaitNotification(final NextActionCardAwaitNotification cardAwaitNotification) {
      this.cardAwaitNotification = cardAwaitNotification;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisplayBankTransferInstructions(final NextActionDisplayBankTransferInstructions displayBankTransferInstructions) {
      this.displayBankTransferInstructions = displayBankTransferInstructions;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setKonbiniDisplayDetails(final NextActionKonbiniDisplayDetails konbiniDisplayDetails) {
      this.konbiniDisplayDetails = konbiniDisplayDetails;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOxxoDisplayDetails(final NextActionOxxoDisplayDetails oxxoDisplayDetails) {
      this.oxxoDisplayDetails = oxxoDisplayDetails;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPaynowDisplayQrCode(final PaynowDisplayQrCode paynowDisplayQrCode) {
      this.paynowDisplayQrCode = paynowDisplayQrCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPixDisplayQrCode(final PixDisplayQrCode pixDisplayQrCode) {
      this.pixDisplayQrCode = pixDisplayQrCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPromptpayDisplayQrCode(final PromptpayDisplayQrCode promptpayDisplayQrCode) {
      this.promptpayDisplayQrCode = promptpayDisplayQrCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRedirectToUrl(final NextActionRedirectToUrl redirectToUrl) {
      this.redirectToUrl = redirectToUrl;
    }

    /**
     * Type of the next action to perform, one of {@code redirect_to_url}, {@code use_stripe_sdk},
     * {@code alipay_handle_redirect}, {@code oxxo_display_details}, or {@code
     * verify_with_microdeposits}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    /**
     * When confirming a PaymentIntent with Stripe.js, Stripe.js depends on the contents of this
     * dictionary to invoke authentication flows. The shape of the contents is subject to change and
     * is only intended to be used by Stripe.js.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUseStripeSdk(final Map<String, Object> useStripeSdk) {
      this.useStripeSdk = useStripeSdk;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVerifyWithMicrodeposits(final VerifyWithMicrodeposits verifyWithMicrodeposits) {
      this.verifyWithMicrodeposits = verifyWithMicrodeposits;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setWechatPayDisplayQrCode(final WechatPayDisplayQrCode wechatPayDisplayQrCode) {
      this.wechatPayDisplayQrCode = wechatPayDisplayQrCode;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setWechatPayRedirectToAndroidApp(final WechatPayRedirectToAndroidApp wechatPayRedirectToAndroidApp) {
      this.wechatPayRedirectToAndroidApp = wechatPayRedirectToAndroidApp;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setWechatPayRedirectToIosApp(final WechatPayRedirectToIosApp wechatPayRedirectToIosApp) {
      this.wechatPayRedirectToIosApp = wechatPayRedirectToIosApp;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.NextAction)) return false;
      final PaymentIntent.NextAction other = (PaymentIntent.NextAction) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$alipayHandleRedirect = this.getAlipayHandleRedirect();
      final java.lang.Object other$alipayHandleRedirect = other.getAlipayHandleRedirect();
      if (this$alipayHandleRedirect == null ? other$alipayHandleRedirect != null : !this$alipayHandleRedirect.equals(other$alipayHandleRedirect)) return false;
      final java.lang.Object this$boletoDisplayDetails = this.getBoletoDisplayDetails();
      final java.lang.Object other$boletoDisplayDetails = other.getBoletoDisplayDetails();
      if (this$boletoDisplayDetails == null ? other$boletoDisplayDetails != null : !this$boletoDisplayDetails.equals(other$boletoDisplayDetails)) return false;
      final java.lang.Object this$cardAwaitNotification = this.getCardAwaitNotification();
      final java.lang.Object other$cardAwaitNotification = other.getCardAwaitNotification();
      if (this$cardAwaitNotification == null ? other$cardAwaitNotification != null : !this$cardAwaitNotification.equals(other$cardAwaitNotification)) return false;
      final java.lang.Object this$displayBankTransferInstructions = this.getDisplayBankTransferInstructions();
      final java.lang.Object other$displayBankTransferInstructions = other.getDisplayBankTransferInstructions();
      if (this$displayBankTransferInstructions == null ? other$displayBankTransferInstructions != null : !this$displayBankTransferInstructions.equals(other$displayBankTransferInstructions)) return false;
      final java.lang.Object this$konbiniDisplayDetails = this.getKonbiniDisplayDetails();
      final java.lang.Object other$konbiniDisplayDetails = other.getKonbiniDisplayDetails();
      if (this$konbiniDisplayDetails == null ? other$konbiniDisplayDetails != null : !this$konbiniDisplayDetails.equals(other$konbiniDisplayDetails)) return false;
      final java.lang.Object this$oxxoDisplayDetails = this.getOxxoDisplayDetails();
      final java.lang.Object other$oxxoDisplayDetails = other.getOxxoDisplayDetails();
      if (this$oxxoDisplayDetails == null ? other$oxxoDisplayDetails != null : !this$oxxoDisplayDetails.equals(other$oxxoDisplayDetails)) return false;
      final java.lang.Object this$paynowDisplayQrCode = this.getPaynowDisplayQrCode();
      final java.lang.Object other$paynowDisplayQrCode = other.getPaynowDisplayQrCode();
      if (this$paynowDisplayQrCode == null ? other$paynowDisplayQrCode != null : !this$paynowDisplayQrCode.equals(other$paynowDisplayQrCode)) return false;
      final java.lang.Object this$pixDisplayQrCode = this.getPixDisplayQrCode();
      final java.lang.Object other$pixDisplayQrCode = other.getPixDisplayQrCode();
      if (this$pixDisplayQrCode == null ? other$pixDisplayQrCode != null : !this$pixDisplayQrCode.equals(other$pixDisplayQrCode)) return false;
      final java.lang.Object this$promptpayDisplayQrCode = this.getPromptpayDisplayQrCode();
      final java.lang.Object other$promptpayDisplayQrCode = other.getPromptpayDisplayQrCode();
      if (this$promptpayDisplayQrCode == null ? other$promptpayDisplayQrCode != null : !this$promptpayDisplayQrCode.equals(other$promptpayDisplayQrCode)) return false;
      final java.lang.Object this$redirectToUrl = this.getRedirectToUrl();
      final java.lang.Object other$redirectToUrl = other.getRedirectToUrl();
      if (this$redirectToUrl == null ? other$redirectToUrl != null : !this$redirectToUrl.equals(other$redirectToUrl)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      final java.lang.Object this$useStripeSdk = this.getUseStripeSdk();
      final java.lang.Object other$useStripeSdk = other.getUseStripeSdk();
      if (this$useStripeSdk == null ? other$useStripeSdk != null : !this$useStripeSdk.equals(other$useStripeSdk)) return false;
      final java.lang.Object this$verifyWithMicrodeposits = this.getVerifyWithMicrodeposits();
      final java.lang.Object other$verifyWithMicrodeposits = other.getVerifyWithMicrodeposits();
      if (this$verifyWithMicrodeposits == null ? other$verifyWithMicrodeposits != null : !this$verifyWithMicrodeposits.equals(other$verifyWithMicrodeposits)) return false;
      final java.lang.Object this$wechatPayDisplayQrCode = this.getWechatPayDisplayQrCode();
      final java.lang.Object other$wechatPayDisplayQrCode = other.getWechatPayDisplayQrCode();
      if (this$wechatPayDisplayQrCode == null ? other$wechatPayDisplayQrCode != null : !this$wechatPayDisplayQrCode.equals(other$wechatPayDisplayQrCode)) return false;
      final java.lang.Object this$wechatPayRedirectToAndroidApp = this.getWechatPayRedirectToAndroidApp();
      final java.lang.Object other$wechatPayRedirectToAndroidApp = other.getWechatPayRedirectToAndroidApp();
      if (this$wechatPayRedirectToAndroidApp == null ? other$wechatPayRedirectToAndroidApp != null : !this$wechatPayRedirectToAndroidApp.equals(other$wechatPayRedirectToAndroidApp)) return false;
      final java.lang.Object this$wechatPayRedirectToIosApp = this.getWechatPayRedirectToIosApp();
      final java.lang.Object other$wechatPayRedirectToIosApp = other.getWechatPayRedirectToIosApp();
      if (this$wechatPayRedirectToIosApp == null ? other$wechatPayRedirectToIosApp != null : !this$wechatPayRedirectToIosApp.equals(other$wechatPayRedirectToIosApp)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.NextAction;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $alipayHandleRedirect = this.getAlipayHandleRedirect();
      result = result * PRIME + ($alipayHandleRedirect == null ? 43 : $alipayHandleRedirect.hashCode());
      final java.lang.Object $boletoDisplayDetails = this.getBoletoDisplayDetails();
      result = result * PRIME + ($boletoDisplayDetails == null ? 43 : $boletoDisplayDetails.hashCode());
      final java.lang.Object $cardAwaitNotification = this.getCardAwaitNotification();
      result = result * PRIME + ($cardAwaitNotification == null ? 43 : $cardAwaitNotification.hashCode());
      final java.lang.Object $displayBankTransferInstructions = this.getDisplayBankTransferInstructions();
      result = result * PRIME + ($displayBankTransferInstructions == null ? 43 : $displayBankTransferInstructions.hashCode());
      final java.lang.Object $konbiniDisplayDetails = this.getKonbiniDisplayDetails();
      result = result * PRIME + ($konbiniDisplayDetails == null ? 43 : $konbiniDisplayDetails.hashCode());
      final java.lang.Object $oxxoDisplayDetails = this.getOxxoDisplayDetails();
      result = result * PRIME + ($oxxoDisplayDetails == null ? 43 : $oxxoDisplayDetails.hashCode());
      final java.lang.Object $paynowDisplayQrCode = this.getPaynowDisplayQrCode();
      result = result * PRIME + ($paynowDisplayQrCode == null ? 43 : $paynowDisplayQrCode.hashCode());
      final java.lang.Object $pixDisplayQrCode = this.getPixDisplayQrCode();
      result = result * PRIME + ($pixDisplayQrCode == null ? 43 : $pixDisplayQrCode.hashCode());
      final java.lang.Object $promptpayDisplayQrCode = this.getPromptpayDisplayQrCode();
      result = result * PRIME + ($promptpayDisplayQrCode == null ? 43 : $promptpayDisplayQrCode.hashCode());
      final java.lang.Object $redirectToUrl = this.getRedirectToUrl();
      result = result * PRIME + ($redirectToUrl == null ? 43 : $redirectToUrl.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      final java.lang.Object $useStripeSdk = this.getUseStripeSdk();
      result = result * PRIME + ($useStripeSdk == null ? 43 : $useStripeSdk.hashCode());
      final java.lang.Object $verifyWithMicrodeposits = this.getVerifyWithMicrodeposits();
      result = result * PRIME + ($verifyWithMicrodeposits == null ? 43 : $verifyWithMicrodeposits.hashCode());
      final java.lang.Object $wechatPayDisplayQrCode = this.getWechatPayDisplayQrCode();
      result = result * PRIME + ($wechatPayDisplayQrCode == null ? 43 : $wechatPayDisplayQrCode.hashCode());
      final java.lang.Object $wechatPayRedirectToAndroidApp = this.getWechatPayRedirectToAndroidApp();
      result = result * PRIME + ($wechatPayRedirectToAndroidApp == null ? 43 : $wechatPayRedirectToAndroidApp.hashCode());
      final java.lang.Object $wechatPayRedirectToIosApp = this.getWechatPayRedirectToIosApp();
      result = result * PRIME + ($wechatPayRedirectToIosApp == null ? 43 : $wechatPayRedirectToIosApp.hashCode());
      return result;
    }
  }


  /**
   * An universal link that redirect to WeChat Pay app.
   */
  public static class NextActionAlipayHandleRedirect extends StripeObject {
    /**
     * The native data to be used with Alipay SDK you must redirect your customer to in order to
     * authenticate the payment in an Android App.
     */
    @SerializedName("native_data")
    String nativeData;
    /**
     * The native URL you must redirect your customer to in order to authenticate the payment in an
     * iOS App.
     */
    @SerializedName("native_url")
    String nativeUrl;
    /**
     * If the customer does not exit their browser while authenticating, they will be redirected to
     * this specified URL after completion.
     */
    @SerializedName("return_url")
    String returnUrl;
    /**
     * The URL you must redirect your customer to in order to authenticate the payment.
     */
    @SerializedName("url")
    String url;

    /**
     * The native data to be used with Alipay SDK you must redirect your customer to in order to
     * authenticate the payment in an Android App.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNativeData() {
      return this.nativeData;
    }

    /**
     * The native URL you must redirect your customer to in order to authenticate the payment in an
     * iOS App.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNativeUrl() {
      return this.nativeUrl;
    }

    /**
     * If the customer does not exit their browser while authenticating, they will be redirected to
     * this specified URL after completion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReturnUrl() {
      return this.returnUrl;
    }

    /**
     * The URL you must redirect your customer to in order to authenticate the payment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUrl() {
      return this.url;
    }

    /**
     * The native data to be used with Alipay SDK you must redirect your customer to in order to
     * authenticate the payment in an Android App.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNativeData(final String nativeData) {
      this.nativeData = nativeData;
    }

    /**
     * The native URL you must redirect your customer to in order to authenticate the payment in an
     * iOS App.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNativeUrl(final String nativeUrl) {
      this.nativeUrl = nativeUrl;
    }

    /**
     * If the customer does not exit their browser while authenticating, they will be redirected to
     * this specified URL after completion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReturnUrl(final String returnUrl) {
      this.returnUrl = returnUrl;
    }

    /**
     * The URL you must redirect your customer to in order to authenticate the payment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUrl(final String url) {
      this.url = url;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.NextActionAlipayHandleRedirect)) return false;
      final PaymentIntent.NextActionAlipayHandleRedirect other = (PaymentIntent.NextActionAlipayHandleRedirect) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$nativeData = this.getNativeData();
      final java.lang.Object other$nativeData = other.getNativeData();
      if (this$nativeData == null ? other$nativeData != null : !this$nativeData.equals(other$nativeData)) return false;
      final java.lang.Object this$nativeUrl = this.getNativeUrl();
      final java.lang.Object other$nativeUrl = other.getNativeUrl();
      if (this$nativeUrl == null ? other$nativeUrl != null : !this$nativeUrl.equals(other$nativeUrl)) return false;
      final java.lang.Object this$returnUrl = this.getReturnUrl();
      final java.lang.Object other$returnUrl = other.getReturnUrl();
      if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) return false;
      final java.lang.Object this$url = this.getUrl();
      final java.lang.Object other$url = other.getUrl();
      if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.NextActionAlipayHandleRedirect;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $nativeData = this.getNativeData();
      result = result * PRIME + ($nativeData == null ? 43 : $nativeData.hashCode());
      final java.lang.Object $nativeUrl = this.getNativeUrl();
      result = result * PRIME + ($nativeUrl == null ? 43 : $nativeUrl.hashCode());
      final java.lang.Object $returnUrl = this.getReturnUrl();
      result = result * PRIME + ($returnUrl == null ? 43 : $returnUrl.hashCode());
      final java.lang.Object $url = this.getUrl();
      result = result * PRIME + ($url == null ? 43 : $url.hashCode());
      return result;
    }
  }


  public static class NextActionCardAwaitNotification extends StripeObject {
    /**
     * The time that payment will be attempted. If customer approval is required, they need to
     * provide approval before this time.
     */
    @SerializedName("charge_attempt_at")
    Long chargeAttemptAt;
    /**
     * For payments greater than INR 15000, the customer must provide explicit approval of the
     * payment with their bank. For payments of lower amount, no customer action is required.
     */
    @SerializedName("customer_approval_required")
    Boolean customerApprovalRequired;

    /**
     * The time that payment will be attempted. If customer approval is required, they need to
     * provide approval before this time.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getChargeAttemptAt() {
      return this.chargeAttemptAt;
    }

    /**
     * For payments greater than INR 15000, the customer must provide explicit approval of the
     * payment with their bank. For payments of lower amount, no customer action is required.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getCustomerApprovalRequired() {
      return this.customerApprovalRequired;
    }

    /**
     * The time that payment will be attempted. If customer approval is required, they need to
     * provide approval before this time.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setChargeAttemptAt(final Long chargeAttemptAt) {
      this.chargeAttemptAt = chargeAttemptAt;
    }

    /**
     * For payments greater than INR 15000, the customer must provide explicit approval of the
     * payment with their bank. For payments of lower amount, no customer action is required.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCustomerApprovalRequired(final Boolean customerApprovalRequired) {
      this.customerApprovalRequired = customerApprovalRequired;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.NextActionCardAwaitNotification)) return false;
      final PaymentIntent.NextActionCardAwaitNotification other = (PaymentIntent.NextActionCardAwaitNotification) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$chargeAttemptAt = this.getChargeAttemptAt();
      final java.lang.Object other$chargeAttemptAt = other.getChargeAttemptAt();
      if (this$chargeAttemptAt == null ? other$chargeAttemptAt != null : !this$chargeAttemptAt.equals(other$chargeAttemptAt)) return false;
      final java.lang.Object this$customerApprovalRequired = this.getCustomerApprovalRequired();
      final java.lang.Object other$customerApprovalRequired = other.getCustomerApprovalRequired();
      if (this$customerApprovalRequired == null ? other$customerApprovalRequired != null : !this$customerApprovalRequired.equals(other$customerApprovalRequired)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.NextActionCardAwaitNotification;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $chargeAttemptAt = this.getChargeAttemptAt();
      result = result * PRIME + ($chargeAttemptAt == null ? 43 : $chargeAttemptAt.hashCode());
      final java.lang.Object $customerApprovalRequired = this.getCustomerApprovalRequired();
      result = result * PRIME + ($customerApprovalRequired == null ? 43 : $customerApprovalRequired.hashCode());
      return result;
    }
  }


  public static class NextActionDisplayBankTransferInstructions extends StripeObject {
    /**
     * The remaining amount that needs to be transferred to complete the payment.
     */
    @SerializedName("amount_remaining")
    Long amountRemaining;
    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @SerializedName("currency")
    String currency;
    /**
     * A list of financial addresses that can be used to fund the customer balance.
     */
    @SerializedName("financial_addresses")
    List<PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress> financialAddresses;
    /**
     * A link to a hosted page that guides your customer through completing the transfer.
     */
    @SerializedName("hosted_instructions_url")
    String hostedInstructionsUrl;
    /**
     * A string identifying this payment. Instruct your customer to include this code in the
     * reference or memo field of their bank transfer.
     */
    @SerializedName("reference")
    String reference;
    /**
     * Type of bank transfer
     *
     * <p>One of {@code eu_bank_transfer}, {@code gb_bank_transfer}, {@code jp_bank_transfer}, or
     * {@code mx_bank_transfer}.
     */
    @SerializedName("type")
    String type;


    /**
     * FinancialAddresses contain identifying information that resolves to a FinancialAccount.
     */
    public static class FinancialAddress extends StripeObject {
      /** Iban Records contain E.U. bank account details per the SEPA format. */
      @SerializedName("iban")
      Iban iban;
      /** Sort Code Records contain U.K. bank account details per the sort code format. */
      @SerializedName("sort_code")
      SortCode sortCode;
      /** SPEI Records contain Mexico bank account details per the SPEI format. */
      @SerializedName("spei")
      Spei spei;
      /** The payment networks supported by this FinancialAddress. */
      @SerializedName("supported_networks")
      List<String> supportedNetworks;
      /**
       * The type of financial address
       *
       * <p>One of {@code iban}, {@code sort_code}, {@code spei}, or {@code zengin}.
       */
      @SerializedName("type")
      String type;
      /** Zengin Records contain Japan bank account details per the Zengin format. */
      @SerializedName("zengin")
      Zengin zengin;

      /** Iban Records contain E.U. bank account details per the SEPA format. */
      public static class Iban extends StripeObject {
        /** The name of the person or business that owns the bank account. */
        @SerializedName("account_holder_name")
        String accountHolderName;
        /** The BIC/SWIFT code of the account. */
        @SerializedName("bic")
        String bic;
        /**
         * Two-letter country code (<a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO
         * 3166-1 alpha-2</a>).
         */
        @SerializedName("country")
        String country;
        /** The IBAN of the account. */
        @SerializedName("iban")
        String iban;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccountHolderName() {
          return this.accountHolderName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBic() {
          return this.bic;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCountry() {
          return this.country;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getIban() {
          return this.iban;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAccountHolderName(final String accountHolderName) {
          this.accountHolderName = accountHolderName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBic(final String bic) {
          this.bic = bic;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCountry(final String country) {
          this.country = country;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setIban(final String iban) {
          this.iban = iban;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress.Iban)) return false;
          final PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress.Iban other = (PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress.Iban) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$accountHolderName = this.getAccountHolderName();
          final java.lang.Object other$accountHolderName = other.getAccountHolderName();
          if (this$accountHolderName == null ? other$accountHolderName != null : !this$accountHolderName.equals(other$accountHolderName)) return false;
          final java.lang.Object this$bic = this.getBic();
          final java.lang.Object other$bic = other.getBic();
          if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) return false;
          final java.lang.Object this$country = this.getCountry();
          final java.lang.Object other$country = other.getCountry();
          if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
          final java.lang.Object this$iban = this.getIban();
          final java.lang.Object other$iban = other.getIban();
          if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress.Iban;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $accountHolderName = this.getAccountHolderName();
          result = result * PRIME + ($accountHolderName == null ? 43 : $accountHolderName.hashCode());
          final java.lang.Object $bic = this.getBic();
          result = result * PRIME + ($bic == null ? 43 : $bic.hashCode());
          final java.lang.Object $country = this.getCountry();
          result = result * PRIME + ($country == null ? 43 : $country.hashCode());
          final java.lang.Object $iban = this.getIban();
          result = result * PRIME + ($iban == null ? 43 : $iban.hashCode());
          return result;
        }
      }

      /** Sort Code Records contain U.K. bank account details per the sort code format. */
      public static class SortCode extends StripeObject {
        /** The name of the person or business that owns the bank account. */
        @SerializedName("account_holder_name")
        String accountHolderName;
        /** The account number. */
        @SerializedName("account_number")
        String accountNumber;
        /** The six-digit sort code. */
        @SerializedName("sort_code")
        String sortCode;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccountHolderName() {
          return this.accountHolderName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccountNumber() {
          return this.accountNumber;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getSortCode() {
          return this.sortCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAccountHolderName(final String accountHolderName) {
          this.accountHolderName = accountHolderName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAccountNumber(final String accountNumber) {
          this.accountNumber = accountNumber;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setSortCode(final String sortCode) {
          this.sortCode = sortCode;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress.SortCode)) return false;
          final PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress.SortCode other = (PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress.SortCode) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$accountHolderName = this.getAccountHolderName();
          final java.lang.Object other$accountHolderName = other.getAccountHolderName();
          if (this$accountHolderName == null ? other$accountHolderName != null : !this$accountHolderName.equals(other$accountHolderName)) return false;
          final java.lang.Object this$accountNumber = this.getAccountNumber();
          final java.lang.Object other$accountNumber = other.getAccountNumber();
          if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) return false;
          final java.lang.Object this$sortCode = this.getSortCode();
          final java.lang.Object other$sortCode = other.getSortCode();
          if (this$sortCode == null ? other$sortCode != null : !this$sortCode.equals(other$sortCode)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress.SortCode;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $accountHolderName = this.getAccountHolderName();
          result = result * PRIME + ($accountHolderName == null ? 43 : $accountHolderName.hashCode());
          final java.lang.Object $accountNumber = this.getAccountNumber();
          result = result * PRIME + ($accountNumber == null ? 43 : $accountNumber.hashCode());
          final java.lang.Object $sortCode = this.getSortCode();
          result = result * PRIME + ($sortCode == null ? 43 : $sortCode.hashCode());
          return result;
        }
      }

      /** SPEI Records contain Mexico bank account details per the SPEI format. */
      public static class Spei extends StripeObject {
        /** The three-digit bank code. */
        @SerializedName("bank_code")
        String bankCode;
        /** The short banking institution name. */
        @SerializedName("bank_name")
        String bankName;
        /** The CLABE number. */
        @SerializedName("clabe")
        String clabe;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBankCode() {
          return this.bankCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBankName() {
          return this.bankName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getClabe() {
          return this.clabe;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBankCode(final String bankCode) {
          this.bankCode = bankCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBankName(final String bankName) {
          this.bankName = bankName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setClabe(final String clabe) {
          this.clabe = clabe;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress.Spei)) return false;
          final PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress.Spei other = (PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress.Spei) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$bankCode = this.getBankCode();
          final java.lang.Object other$bankCode = other.getBankCode();
          if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) return false;
          final java.lang.Object this$bankName = this.getBankName();
          final java.lang.Object other$bankName = other.getBankName();
          if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
          final java.lang.Object this$clabe = this.getClabe();
          final java.lang.Object other$clabe = other.getClabe();
          if (this$clabe == null ? other$clabe != null : !this$clabe.equals(other$clabe)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress.Spei;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $bankCode = this.getBankCode();
          result = result * PRIME + ($bankCode == null ? 43 : $bankCode.hashCode());
          final java.lang.Object $bankName = this.getBankName();
          result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
          final java.lang.Object $clabe = this.getClabe();
          result = result * PRIME + ($clabe == null ? 43 : $clabe.hashCode());
          return result;
        }
      }

      /** Zengin Records contain Japan bank account details per the Zengin format. */
      public static class Zengin extends StripeObject {
        /** The account holder name. */
        @SerializedName("account_holder_name")
        String accountHolderName;
        /** The account number. */
        @SerializedName("account_number")
        String accountNumber;
        /** The bank account type. In Japan, this can only be {@code futsu} or {@code toza}. */
        @SerializedName("account_type")
        String accountType;
        /** The bank code of the account. */
        @SerializedName("bank_code")
        String bankCode;
        /** The bank name of the account. */
        @SerializedName("bank_name")
        String bankName;
        /** The branch code of the account. */
        @SerializedName("branch_code")
        String branchCode;
        @SerializedName("branch_name")
        String branchName;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccountHolderName() {
          return this.accountHolderName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccountNumber() {
          return this.accountNumber;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccountType() {
          return this.accountType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBankCode() {
          return this.bankCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBankName() {
          return this.bankName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBranchCode() {
          return this.branchCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBranchName() {
          return this.branchName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAccountHolderName(final String accountHolderName) {
          this.accountHolderName = accountHolderName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAccountNumber(final String accountNumber) {
          this.accountNumber = accountNumber;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAccountType(final String accountType) {
          this.accountType = accountType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBankCode(final String bankCode) {
          this.bankCode = bankCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBankName(final String bankName) {
          this.bankName = bankName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBranchCode(final String branchCode) {
          this.branchCode = branchCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBranchName(final String branchName) {
          this.branchName = branchName;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress.Zengin)) return false;
          final PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress.Zengin other = (PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress.Zengin) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$accountHolderName = this.getAccountHolderName();
          final java.lang.Object other$accountHolderName = other.getAccountHolderName();
          if (this$accountHolderName == null ? other$accountHolderName != null : !this$accountHolderName.equals(other$accountHolderName)) return false;
          final java.lang.Object this$accountNumber = this.getAccountNumber();
          final java.lang.Object other$accountNumber = other.getAccountNumber();
          if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) return false;
          final java.lang.Object this$accountType = this.getAccountType();
          final java.lang.Object other$accountType = other.getAccountType();
          if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) return false;
          final java.lang.Object this$bankCode = this.getBankCode();
          final java.lang.Object other$bankCode = other.getBankCode();
          if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) return false;
          final java.lang.Object this$bankName = this.getBankName();
          final java.lang.Object other$bankName = other.getBankName();
          if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
          final java.lang.Object this$branchCode = this.getBranchCode();
          final java.lang.Object other$branchCode = other.getBranchCode();
          if (this$branchCode == null ? other$branchCode != null : !this$branchCode.equals(other$branchCode)) return false;
          final java.lang.Object this$branchName = this.getBranchName();
          final java.lang.Object other$branchName = other.getBranchName();
          if (this$branchName == null ? other$branchName != null : !this$branchName.equals(other$branchName)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress.Zengin;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $accountHolderName = this.getAccountHolderName();
          result = result * PRIME + ($accountHolderName == null ? 43 : $accountHolderName.hashCode());
          final java.lang.Object $accountNumber = this.getAccountNumber();
          result = result * PRIME + ($accountNumber == null ? 43 : $accountNumber.hashCode());
          final java.lang.Object $accountType = this.getAccountType();
          result = result * PRIME + ($accountType == null ? 43 : $accountType.hashCode());
          final java.lang.Object $bankCode = this.getBankCode();
          result = result * PRIME + ($bankCode == null ? 43 : $bankCode.hashCode());
          final java.lang.Object $bankName = this.getBankName();
          result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
          final java.lang.Object $branchCode = this.getBranchCode();
          result = result * PRIME + ($branchCode == null ? 43 : $branchCode.hashCode());
          final java.lang.Object $branchName = this.getBranchName();
          result = result * PRIME + ($branchName == null ? 43 : $branchName.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Iban getIban() {
        return this.iban;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public SortCode getSortCode() {
        return this.sortCode;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Spei getSpei() {
        return this.spei;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getSupportedNetworks() {
        return this.supportedNetworks;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getType() {
        return this.type;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Zengin getZengin() {
        return this.zengin;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setIban(final Iban iban) {
        this.iban = iban;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSortCode(final SortCode sortCode) {
        this.sortCode = sortCode;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSpei(final Spei spei) {
        this.spei = spei;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSupportedNetworks(final List<String> supportedNetworks) {
        this.supportedNetworks = supportedNetworks;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setType(final String type) {
        this.type = type;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setZengin(final Zengin zengin) {
        this.zengin = zengin;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress)) return false;
        final PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress other = (PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$iban = this.getIban();
        final java.lang.Object other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) return false;
        final java.lang.Object this$sortCode = this.getSortCode();
        final java.lang.Object other$sortCode = other.getSortCode();
        if (this$sortCode == null ? other$sortCode != null : !this$sortCode.equals(other$sortCode)) return false;
        final java.lang.Object this$spei = this.getSpei();
        final java.lang.Object other$spei = other.getSpei();
        if (this$spei == null ? other$spei != null : !this$spei.equals(other$spei)) return false;
        final java.lang.Object this$supportedNetworks = this.getSupportedNetworks();
        final java.lang.Object other$supportedNetworks = other.getSupportedNetworks();
        if (this$supportedNetworks == null ? other$supportedNetworks != null : !this$supportedNetworks.equals(other$supportedNetworks)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        final java.lang.Object this$zengin = this.getZengin();
        final java.lang.Object other$zengin = other.getZengin();
        if (this$zengin == null ? other$zengin != null : !this$zengin.equals(other$zengin)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $iban = this.getIban();
        result = result * PRIME + ($iban == null ? 43 : $iban.hashCode());
        final java.lang.Object $sortCode = this.getSortCode();
        result = result * PRIME + ($sortCode == null ? 43 : $sortCode.hashCode());
        final java.lang.Object $spei = this.getSpei();
        result = result * PRIME + ($spei == null ? 43 : $spei.hashCode());
        final java.lang.Object $supportedNetworks = this.getSupportedNetworks();
        result = result * PRIME + ($supportedNetworks == null ? 43 : $supportedNetworks.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        final java.lang.Object $zengin = this.getZengin();
        result = result * PRIME + ($zengin == null ? 43 : $zengin.hashCode());
        return result;
      }
    }

    /**
     * The remaining amount that needs to be transferred to complete the payment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountRemaining() {
      return this.amountRemaining;
    }

    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCurrency() {
      return this.currency;
    }

    /**
     * A list of financial addresses that can be used to fund the customer balance.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress> getFinancialAddresses() {
      return this.financialAddresses;
    }

    /**
     * A link to a hosted page that guides your customer through completing the transfer.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getHostedInstructionsUrl() {
      return this.hostedInstructionsUrl;
    }

    /**
     * A string identifying this payment. Instruct your customer to include this code in the
     * reference or memo field of their bank transfer.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReference() {
      return this.reference;
    }

    /**
     * Type of bank transfer
     *
     * <p>One of {@code eu_bank_transfer}, {@code gb_bank_transfer}, {@code jp_bank_transfer}, or
     * {@code mx_bank_transfer}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    /**
     * The remaining amount that needs to be transferred to complete the payment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountRemaining(final Long amountRemaining) {
      this.amountRemaining = amountRemaining;
    }

    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrency(final String currency) {
      this.currency = currency;
    }

    /**
     * A list of financial addresses that can be used to fund the customer balance.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFinancialAddresses(final List<PaymentIntent.NextActionDisplayBankTransferInstructions.FinancialAddress> financialAddresses) {
      this.financialAddresses = financialAddresses;
    }

    /**
     * A link to a hosted page that guides your customer through completing the transfer.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setHostedInstructionsUrl(final String hostedInstructionsUrl) {
      this.hostedInstructionsUrl = hostedInstructionsUrl;
    }

    /**
     * A string identifying this payment. Instruct your customer to include this code in the
     * reference or memo field of their bank transfer.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReference(final String reference) {
      this.reference = reference;
    }

    /**
     * Type of bank transfer
     *
     * <p>One of {@code eu_bank_transfer}, {@code gb_bank_transfer}, {@code jp_bank_transfer}, or
     * {@code mx_bank_transfer}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.NextActionDisplayBankTransferInstructions)) return false;
      final PaymentIntent.NextActionDisplayBankTransferInstructions other = (PaymentIntent.NextActionDisplayBankTransferInstructions) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amountRemaining = this.getAmountRemaining();
      final java.lang.Object other$amountRemaining = other.getAmountRemaining();
      if (this$amountRemaining == null ? other$amountRemaining != null : !this$amountRemaining.equals(other$amountRemaining)) return false;
      final java.lang.Object this$currency = this.getCurrency();
      final java.lang.Object other$currency = other.getCurrency();
      if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
      final java.lang.Object this$financialAddresses = this.getFinancialAddresses();
      final java.lang.Object other$financialAddresses = other.getFinancialAddresses();
      if (this$financialAddresses == null ? other$financialAddresses != null : !this$financialAddresses.equals(other$financialAddresses)) return false;
      final java.lang.Object this$hostedInstructionsUrl = this.getHostedInstructionsUrl();
      final java.lang.Object other$hostedInstructionsUrl = other.getHostedInstructionsUrl();
      if (this$hostedInstructionsUrl == null ? other$hostedInstructionsUrl != null : !this$hostedInstructionsUrl.equals(other$hostedInstructionsUrl)) return false;
      final java.lang.Object this$reference = this.getReference();
      final java.lang.Object other$reference = other.getReference();
      if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.NextActionDisplayBankTransferInstructions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amountRemaining = this.getAmountRemaining();
      result = result * PRIME + ($amountRemaining == null ? 43 : $amountRemaining.hashCode());
      final java.lang.Object $currency = this.getCurrency();
      result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
      final java.lang.Object $financialAddresses = this.getFinancialAddresses();
      result = result * PRIME + ($financialAddresses == null ? 43 : $financialAddresses.hashCode());
      final java.lang.Object $hostedInstructionsUrl = this.getHostedInstructionsUrl();
      result = result * PRIME + ($hostedInstructionsUrl == null ? 43 : $hostedInstructionsUrl.hashCode());
      final java.lang.Object $reference = this.getReference();
      result = result * PRIME + ($reference == null ? 43 : $reference.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }


  /**
   * The branch name of the account.
   */
  public static class NextActionDisplayBoletoDetails extends StripeObject {
    /**
     * The timestamp after which the boleto expires.
     */
    @SerializedName("expires_at")
    Long expiresAt;
    /**
     * The URL to the hosted boleto voucher page, which allows customers to view the boleto voucher.
     */
    @SerializedName("hosted_voucher_url")
    String hostedVoucherUrl;
    /**
     * The boleto number.
     */
    @SerializedName("number")
    String number;
    /**
     * The URL to the downloadable boleto voucher PDF.
     */
    @SerializedName("pdf")
    String pdf;

    /**
     * The timestamp after which the boleto expires.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getExpiresAt() {
      return this.expiresAt;
    }

    /**
     * The URL to the hosted boleto voucher page, which allows customers to view the boleto voucher.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getHostedVoucherUrl() {
      return this.hostedVoucherUrl;
    }

    /**
     * The boleto number.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNumber() {
      return this.number;
    }

    /**
     * The URL to the downloadable boleto voucher PDF.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPdf() {
      return this.pdf;
    }

    /**
     * The timestamp after which the boleto expires.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExpiresAt(final Long expiresAt) {
      this.expiresAt = expiresAt;
    }

    /**
     * The URL to the hosted boleto voucher page, which allows customers to view the boleto voucher.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setHostedVoucherUrl(final String hostedVoucherUrl) {
      this.hostedVoucherUrl = hostedVoucherUrl;
    }

    /**
     * The boleto number.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNumber(final String number) {
      this.number = number;
    }

    /**
     * The URL to the downloadable boleto voucher PDF.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPdf(final String pdf) {
      this.pdf = pdf;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.NextActionDisplayBoletoDetails)) return false;
      final PaymentIntent.NextActionDisplayBoletoDetails other = (PaymentIntent.NextActionDisplayBoletoDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$expiresAt = this.getExpiresAt();
      final java.lang.Object other$expiresAt = other.getExpiresAt();
      if (this$expiresAt == null ? other$expiresAt != null : !this$expiresAt.equals(other$expiresAt)) return false;
      final java.lang.Object this$hostedVoucherUrl = this.getHostedVoucherUrl();
      final java.lang.Object other$hostedVoucherUrl = other.getHostedVoucherUrl();
      if (this$hostedVoucherUrl == null ? other$hostedVoucherUrl != null : !this$hostedVoucherUrl.equals(other$hostedVoucherUrl)) return false;
      final java.lang.Object this$number = this.getNumber();
      final java.lang.Object other$number = other.getNumber();
      if (this$number == null ? other$number != null : !this$number.equals(other$number)) return false;
      final java.lang.Object this$pdf = this.getPdf();
      final java.lang.Object other$pdf = other.getPdf();
      if (this$pdf == null ? other$pdf != null : !this$pdf.equals(other$pdf)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.NextActionDisplayBoletoDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $expiresAt = this.getExpiresAt();
      result = result * PRIME + ($expiresAt == null ? 43 : $expiresAt.hashCode());
      final java.lang.Object $hostedVoucherUrl = this.getHostedVoucherUrl();
      result = result * PRIME + ($hostedVoucherUrl == null ? 43 : $hostedVoucherUrl.hashCode());
      final java.lang.Object $number = this.getNumber();
      result = result * PRIME + ($number == null ? 43 : $number.hashCode());
      final java.lang.Object $pdf = this.getPdf();
      result = result * PRIME + ($pdf == null ? 43 : $pdf.hashCode());
      return result;
    }
  }


  public static class NextActionKonbiniDisplayDetails extends StripeObject {
    /**
     * The timestamp at which the pending Konbini payment expires.
     */
    @SerializedName("expires_at")
    Long expiresAt;
    /**
     * The URL for the Konbini payment instructions page, which allows customers to view and print a
     * Konbini voucher.
     */
    @SerializedName("hosted_voucher_url")
    String hostedVoucherUrl;
    @SerializedName("stores")
    Stores stores;


    public static class Stores extends StripeObject {
      /** FamilyMart instruction details. */
      @SerializedName("familymart")
      Familymart familymart;
      /** Lawson instruction details. */
      @SerializedName("lawson")
      Lawson lawson;
      /** Ministop instruction details. */
      @SerializedName("ministop")
      Ministop ministop;
      /** Seicomart instruction details. */
      @SerializedName("seicomart")
      Seicomart seicomart;


      public static class Familymart extends StripeObject {
        /** The confirmation number. */
        @SerializedName("confirmation_number")
        String confirmationNumber;
        /** The payment code. */
        @SerializedName("payment_code")
        String paymentCode;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getConfirmationNumber() {
          return this.confirmationNumber;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getPaymentCode() {
          return this.paymentCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setConfirmationNumber(final String confirmationNumber) {
          this.confirmationNumber = confirmationNumber;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setPaymentCode(final String paymentCode) {
          this.paymentCode = paymentCode;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentIntent.NextActionKonbiniDisplayDetails.Stores.Familymart)) return false;
          final PaymentIntent.NextActionKonbiniDisplayDetails.Stores.Familymart other = (PaymentIntent.NextActionKonbiniDisplayDetails.Stores.Familymart) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$confirmationNumber = this.getConfirmationNumber();
          final java.lang.Object other$confirmationNumber = other.getConfirmationNumber();
          if (this$confirmationNumber == null ? other$confirmationNumber != null : !this$confirmationNumber.equals(other$confirmationNumber)) return false;
          final java.lang.Object this$paymentCode = this.getPaymentCode();
          final java.lang.Object other$paymentCode = other.getPaymentCode();
          if (this$paymentCode == null ? other$paymentCode != null : !this$paymentCode.equals(other$paymentCode)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentIntent.NextActionKonbiniDisplayDetails.Stores.Familymart;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $confirmationNumber = this.getConfirmationNumber();
          result = result * PRIME + ($confirmationNumber == null ? 43 : $confirmationNumber.hashCode());
          final java.lang.Object $paymentCode = this.getPaymentCode();
          result = result * PRIME + ($paymentCode == null ? 43 : $paymentCode.hashCode());
          return result;
        }
      }


      public static class Lawson extends StripeObject {
        /** The confirmation number. */
        @SerializedName("confirmation_number")
        String confirmationNumber;
        /** The payment code. */
        @SerializedName("payment_code")
        String paymentCode;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getConfirmationNumber() {
          return this.confirmationNumber;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getPaymentCode() {
          return this.paymentCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setConfirmationNumber(final String confirmationNumber) {
          this.confirmationNumber = confirmationNumber;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setPaymentCode(final String paymentCode) {
          this.paymentCode = paymentCode;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentIntent.NextActionKonbiniDisplayDetails.Stores.Lawson)) return false;
          final PaymentIntent.NextActionKonbiniDisplayDetails.Stores.Lawson other = (PaymentIntent.NextActionKonbiniDisplayDetails.Stores.Lawson) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$confirmationNumber = this.getConfirmationNumber();
          final java.lang.Object other$confirmationNumber = other.getConfirmationNumber();
          if (this$confirmationNumber == null ? other$confirmationNumber != null : !this$confirmationNumber.equals(other$confirmationNumber)) return false;
          final java.lang.Object this$paymentCode = this.getPaymentCode();
          final java.lang.Object other$paymentCode = other.getPaymentCode();
          if (this$paymentCode == null ? other$paymentCode != null : !this$paymentCode.equals(other$paymentCode)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentIntent.NextActionKonbiniDisplayDetails.Stores.Lawson;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $confirmationNumber = this.getConfirmationNumber();
          result = result * PRIME + ($confirmationNumber == null ? 43 : $confirmationNumber.hashCode());
          final java.lang.Object $paymentCode = this.getPaymentCode();
          result = result * PRIME + ($paymentCode == null ? 43 : $paymentCode.hashCode());
          return result;
        }
      }


      public static class Ministop extends StripeObject {
        /** The confirmation number. */
        @SerializedName("confirmation_number")
        String confirmationNumber;
        /** The payment code. */
        @SerializedName("payment_code")
        String paymentCode;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getConfirmationNumber() {
          return this.confirmationNumber;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getPaymentCode() {
          return this.paymentCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setConfirmationNumber(final String confirmationNumber) {
          this.confirmationNumber = confirmationNumber;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setPaymentCode(final String paymentCode) {
          this.paymentCode = paymentCode;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentIntent.NextActionKonbiniDisplayDetails.Stores.Ministop)) return false;
          final PaymentIntent.NextActionKonbiniDisplayDetails.Stores.Ministop other = (PaymentIntent.NextActionKonbiniDisplayDetails.Stores.Ministop) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$confirmationNumber = this.getConfirmationNumber();
          final java.lang.Object other$confirmationNumber = other.getConfirmationNumber();
          if (this$confirmationNumber == null ? other$confirmationNumber != null : !this$confirmationNumber.equals(other$confirmationNumber)) return false;
          final java.lang.Object this$paymentCode = this.getPaymentCode();
          final java.lang.Object other$paymentCode = other.getPaymentCode();
          if (this$paymentCode == null ? other$paymentCode != null : !this$paymentCode.equals(other$paymentCode)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentIntent.NextActionKonbiniDisplayDetails.Stores.Ministop;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $confirmationNumber = this.getConfirmationNumber();
          result = result * PRIME + ($confirmationNumber == null ? 43 : $confirmationNumber.hashCode());
          final java.lang.Object $paymentCode = this.getPaymentCode();
          result = result * PRIME + ($paymentCode == null ? 43 : $paymentCode.hashCode());
          return result;
        }
      }


      public static class Seicomart extends StripeObject {
        /** The confirmation number. */
        @SerializedName("confirmation_number")
        String confirmationNumber;
        @SerializedName("payment_code")
        String paymentCode;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getConfirmationNumber() {
          return this.confirmationNumber;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getPaymentCode() {
          return this.paymentCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setConfirmationNumber(final String confirmationNumber) {
          this.confirmationNumber = confirmationNumber;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setPaymentCode(final String paymentCode) {
          this.paymentCode = paymentCode;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentIntent.NextActionKonbiniDisplayDetails.Stores.Seicomart)) return false;
          final PaymentIntent.NextActionKonbiniDisplayDetails.Stores.Seicomart other = (PaymentIntent.NextActionKonbiniDisplayDetails.Stores.Seicomart) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$confirmationNumber = this.getConfirmationNumber();
          final java.lang.Object other$confirmationNumber = other.getConfirmationNumber();
          if (this$confirmationNumber == null ? other$confirmationNumber != null : !this$confirmationNumber.equals(other$confirmationNumber)) return false;
          final java.lang.Object this$paymentCode = this.getPaymentCode();
          final java.lang.Object other$paymentCode = other.getPaymentCode();
          if (this$paymentCode == null ? other$paymentCode != null : !this$paymentCode.equals(other$paymentCode)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentIntent.NextActionKonbiniDisplayDetails.Stores.Seicomart;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $confirmationNumber = this.getConfirmationNumber();
          result = result * PRIME + ($confirmationNumber == null ? 43 : $confirmationNumber.hashCode());
          final java.lang.Object $paymentCode = this.getPaymentCode();
          result = result * PRIME + ($paymentCode == null ? 43 : $paymentCode.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Familymart getFamilymart() {
        return this.familymart;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Lawson getLawson() {
        return this.lawson;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Ministop getMinistop() {
        return this.ministop;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Seicomart getSeicomart() {
        return this.seicomart;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFamilymart(final Familymart familymart) {
        this.familymart = familymart;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLawson(final Lawson lawson) {
        this.lawson = lawson;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMinistop(final Ministop ministop) {
        this.ministop = ministop;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSeicomart(final Seicomart seicomart) {
        this.seicomart = seicomart;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.NextActionKonbiniDisplayDetails.Stores)) return false;
        final PaymentIntent.NextActionKonbiniDisplayDetails.Stores other = (PaymentIntent.NextActionKonbiniDisplayDetails.Stores) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$familymart = this.getFamilymart();
        final java.lang.Object other$familymart = other.getFamilymart();
        if (this$familymart == null ? other$familymart != null : !this$familymart.equals(other$familymart)) return false;
        final java.lang.Object this$lawson = this.getLawson();
        final java.lang.Object other$lawson = other.getLawson();
        if (this$lawson == null ? other$lawson != null : !this$lawson.equals(other$lawson)) return false;
        final java.lang.Object this$ministop = this.getMinistop();
        final java.lang.Object other$ministop = other.getMinistop();
        if (this$ministop == null ? other$ministop != null : !this$ministop.equals(other$ministop)) return false;
        final java.lang.Object this$seicomart = this.getSeicomart();
        final java.lang.Object other$seicomart = other.getSeicomart();
        if (this$seicomart == null ? other$seicomart != null : !this$seicomart.equals(other$seicomart)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.NextActionKonbiniDisplayDetails.Stores;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $familymart = this.getFamilymart();
        result = result * PRIME + ($familymart == null ? 43 : $familymart.hashCode());
        final java.lang.Object $lawson = this.getLawson();
        result = result * PRIME + ($lawson == null ? 43 : $lawson.hashCode());
        final java.lang.Object $ministop = this.getMinistop();
        result = result * PRIME + ($ministop == null ? 43 : $ministop.hashCode());
        final java.lang.Object $seicomart = this.getSeicomart();
        result = result * PRIME + ($seicomart == null ? 43 : $seicomart.hashCode());
        return result;
      }
    }

    /**
     * The timestamp at which the pending Konbini payment expires.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getExpiresAt() {
      return this.expiresAt;
    }

    /**
     * The URL for the Konbini payment instructions page, which allows customers to view and print a
     * Konbini voucher.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getHostedVoucherUrl() {
      return this.hostedVoucherUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Stores getStores() {
      return this.stores;
    }

    /**
     * The timestamp at which the pending Konbini payment expires.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExpiresAt(final Long expiresAt) {
      this.expiresAt = expiresAt;
    }

    /**
     * The URL for the Konbini payment instructions page, which allows customers to view and print a
     * Konbini voucher.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setHostedVoucherUrl(final String hostedVoucherUrl) {
      this.hostedVoucherUrl = hostedVoucherUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStores(final Stores stores) {
      this.stores = stores;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.NextActionKonbiniDisplayDetails)) return false;
      final PaymentIntent.NextActionKonbiniDisplayDetails other = (PaymentIntent.NextActionKonbiniDisplayDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$expiresAt = this.getExpiresAt();
      final java.lang.Object other$expiresAt = other.getExpiresAt();
      if (this$expiresAt == null ? other$expiresAt != null : !this$expiresAt.equals(other$expiresAt)) return false;
      final java.lang.Object this$hostedVoucherUrl = this.getHostedVoucherUrl();
      final java.lang.Object other$hostedVoucherUrl = other.getHostedVoucherUrl();
      if (this$hostedVoucherUrl == null ? other$hostedVoucherUrl != null : !this$hostedVoucherUrl.equals(other$hostedVoucherUrl)) return false;
      final java.lang.Object this$stores = this.getStores();
      final java.lang.Object other$stores = other.getStores();
      if (this$stores == null ? other$stores != null : !this$stores.equals(other$stores)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.NextActionKonbiniDisplayDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $expiresAt = this.getExpiresAt();
      result = result * PRIME + ($expiresAt == null ? 43 : $expiresAt.hashCode());
      final java.lang.Object $hostedVoucherUrl = this.getHostedVoucherUrl();
      result = result * PRIME + ($hostedVoucherUrl == null ? 43 : $hostedVoucherUrl.hashCode());
      final java.lang.Object $stores = this.getStores();
      result = result * PRIME + ($stores == null ? 43 : $stores.hashCode());
      return result;
    }
  }


  /**
   * The payment code.
   */
  public static class NextActionOxxoDisplayDetails extends StripeObject {
    /**
     * The timestamp after which the OXXO voucher expires.
     */
    @SerializedName("expires_after")
    Long expiresAfter;
    /**
     * The URL for the hosted OXXO voucher page, which allows customers to view and print an OXXO
     * voucher.
     */
    @SerializedName("hosted_voucher_url")
    String hostedVoucherUrl;
    /**
     * OXXO reference number.
     */
    @SerializedName("number")
    String number;

    /**
     * The timestamp after which the OXXO voucher expires.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getExpiresAfter() {
      return this.expiresAfter;
    }

    /**
     * The URL for the hosted OXXO voucher page, which allows customers to view and print an OXXO
     * voucher.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getHostedVoucherUrl() {
      return this.hostedVoucherUrl;
    }

    /**
     * OXXO reference number.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNumber() {
      return this.number;
    }

    /**
     * The timestamp after which the OXXO voucher expires.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExpiresAfter(final Long expiresAfter) {
      this.expiresAfter = expiresAfter;
    }

    /**
     * The URL for the hosted OXXO voucher page, which allows customers to view and print an OXXO
     * voucher.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setHostedVoucherUrl(final String hostedVoucherUrl) {
      this.hostedVoucherUrl = hostedVoucherUrl;
    }

    /**
     * OXXO reference number.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNumber(final String number) {
      this.number = number;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.NextActionOxxoDisplayDetails)) return false;
      final PaymentIntent.NextActionOxxoDisplayDetails other = (PaymentIntent.NextActionOxxoDisplayDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$expiresAfter = this.getExpiresAfter();
      final java.lang.Object other$expiresAfter = other.getExpiresAfter();
      if (this$expiresAfter == null ? other$expiresAfter != null : !this$expiresAfter.equals(other$expiresAfter)) return false;
      final java.lang.Object this$hostedVoucherUrl = this.getHostedVoucherUrl();
      final java.lang.Object other$hostedVoucherUrl = other.getHostedVoucherUrl();
      if (this$hostedVoucherUrl == null ? other$hostedVoucherUrl != null : !this$hostedVoucherUrl.equals(other$hostedVoucherUrl)) return false;
      final java.lang.Object this$number = this.getNumber();
      final java.lang.Object other$number = other.getNumber();
      if (this$number == null ? other$number != null : !this$number.equals(other$number)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.NextActionOxxoDisplayDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $expiresAfter = this.getExpiresAfter();
      result = result * PRIME + ($expiresAfter == null ? 43 : $expiresAfter.hashCode());
      final java.lang.Object $hostedVoucherUrl = this.getHostedVoucherUrl();
      result = result * PRIME + ($hostedVoucherUrl == null ? 43 : $hostedVoucherUrl.hashCode());
      final java.lang.Object $number = this.getNumber();
      result = result * PRIME + ($number == null ? 43 : $number.hashCode());
      return result;
    }
  }


  public static class NextActionRedirectToUrl extends StripeObject {
    /**
     * If the customer does not exit their browser while authenticating, they will be redirected to
     * this specified URL after completion.
     */
    @SerializedName("return_url")
    String returnUrl;
    /**
     * The URL you must redirect your customer to in order to authenticate the payment.
     */
    @SerializedName("url")
    String url;

    /**
     * If the customer does not exit their browser while authenticating, they will be redirected to
     * this specified URL after completion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReturnUrl() {
      return this.returnUrl;
    }

    /**
     * The URL you must redirect your customer to in order to authenticate the payment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUrl() {
      return this.url;
    }

    /**
     * If the customer does not exit their browser while authenticating, they will be redirected to
     * this specified URL after completion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReturnUrl(final String returnUrl) {
      this.returnUrl = returnUrl;
    }

    /**
     * The URL you must redirect your customer to in order to authenticate the payment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUrl(final String url) {
      this.url = url;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.NextActionRedirectToUrl)) return false;
      final PaymentIntent.NextActionRedirectToUrl other = (PaymentIntent.NextActionRedirectToUrl) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$returnUrl = this.getReturnUrl();
      final java.lang.Object other$returnUrl = other.getReturnUrl();
      if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) return false;
      final java.lang.Object this$url = this.getUrl();
      final java.lang.Object other$url = other.getUrl();
      if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.NextActionRedirectToUrl;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $returnUrl = this.getReturnUrl();
      result = result * PRIME + ($returnUrl == null ? 43 : $returnUrl.hashCode());
      final java.lang.Object $url = this.getUrl();
      result = result * PRIME + ($url == null ? 43 : $url.hashCode());
      return result;
    }
  }


  public static class PaymentMethodOptions extends StripeObject {
    @SerializedName("acss_debit")
    AcssDebit acssDebit;
    @SerializedName("affirm")
    Affirm affirm;
    @SerializedName("afterpay_clearpay")
    AfterpayClearpay afterpayClearpay;
    @SerializedName("alipay")
    Alipay alipay;
    @SerializedName("au_becs_debit")
    AuBecsDebit auBecsDebit;
    @SerializedName("bacs_debit")
    BacsDebit bacsDebit;
    @SerializedName("bancontact")
    Bancontact bancontact;
    @SerializedName("blik")
    Blik blik;
    @SerializedName("boleto")
    Boleto boleto;
    @SerializedName("card")
    Card card;
    @SerializedName("card_present")
    CardPresent cardPresent;
    @SerializedName("customer_balance")
    CustomerBalance customerBalance;
    @SerializedName("eps")
    Eps eps;
    @SerializedName("fpx")
    Fpx fpx;
    @SerializedName("giropay")
    Giropay giropay;
    @SerializedName("grabpay")
    Grabpay grabpay;
    @SerializedName("ideal")
    Ideal ideal;
    @SerializedName("interac_present")
    InteracPresent interacPresent;
    @SerializedName("klarna")
    Klarna klarna;
    @SerializedName("konbini")
    Konbini konbini;
    @SerializedName("link")
    Link link;
    @SerializedName("oxxo")
    Oxxo oxxo;
    @SerializedName("p24")
    P24 p24;
    @SerializedName("paynow")
    Paynow paynow;
    @SerializedName("pix")
    Pix pix;
    @SerializedName("promptpay")
    Promptpay promptpay;
    @SerializedName("sepa_debit")
    SepaDebit sepaDebit;
    @SerializedName("sofort")
    Sofort sofort;
    @SerializedName("us_bank_account")
    UsBankAccount usBankAccount;
    @SerializedName("wechat_pay")
    WechatPay wechatPay;


    public static class AcssDebit extends StripeObject {
      @SerializedName("mandate_options")
      MandateOptions mandateOptions;
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;
      /**
       * Bank account verification method.
       *
       * <p>One of {@code automatic}, {@code instant}, or {@code microdeposits}.
       */
      @SerializedName("verification_method")
      String verificationMethod;


      public static class MandateOptions extends StripeObject {
        /** A URL for custom mandate text. */
        @SerializedName("custom_mandate_url")
        String customMandateUrl;
        /**
         * Description of the interval. Only required if the 'payment_schedule' parameter is
         * 'interval' or 'combined'.
         */
        @SerializedName("interval_description")
        String intervalDescription;
        /**
         * Payment schedule for the mandate.
         *
         * <p>One of {@code combined}, {@code interval}, or {@code sporadic}.
         */
        @SerializedName("payment_schedule")
        String paymentSchedule;
        @SerializedName("transaction_type")
        String transactionType;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCustomMandateUrl() {
          return this.customMandateUrl;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getIntervalDescription() {
          return this.intervalDescription;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getPaymentSchedule() {
          return this.paymentSchedule;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getTransactionType() {
          return this.transactionType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCustomMandateUrl(final String customMandateUrl) {
          this.customMandateUrl = customMandateUrl;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setIntervalDescription(final String intervalDescription) {
          this.intervalDescription = intervalDescription;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setPaymentSchedule(final String paymentSchedule) {
          this.paymentSchedule = paymentSchedule;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setTransactionType(final String transactionType) {
          this.transactionType = transactionType;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentIntent.PaymentMethodOptions.AcssDebit.MandateOptions)) return false;
          final PaymentIntent.PaymentMethodOptions.AcssDebit.MandateOptions other = (PaymentIntent.PaymentMethodOptions.AcssDebit.MandateOptions) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$customMandateUrl = this.getCustomMandateUrl();
          final java.lang.Object other$customMandateUrl = other.getCustomMandateUrl();
          if (this$customMandateUrl == null ? other$customMandateUrl != null : !this$customMandateUrl.equals(other$customMandateUrl)) return false;
          final java.lang.Object this$intervalDescription = this.getIntervalDescription();
          final java.lang.Object other$intervalDescription = other.getIntervalDescription();
          if (this$intervalDescription == null ? other$intervalDescription != null : !this$intervalDescription.equals(other$intervalDescription)) return false;
          final java.lang.Object this$paymentSchedule = this.getPaymentSchedule();
          final java.lang.Object other$paymentSchedule = other.getPaymentSchedule();
          if (this$paymentSchedule == null ? other$paymentSchedule != null : !this$paymentSchedule.equals(other$paymentSchedule)) return false;
          final java.lang.Object this$transactionType = this.getTransactionType();
          final java.lang.Object other$transactionType = other.getTransactionType();
          if (this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentIntent.PaymentMethodOptions.AcssDebit.MandateOptions;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $customMandateUrl = this.getCustomMandateUrl();
          result = result * PRIME + ($customMandateUrl == null ? 43 : $customMandateUrl.hashCode());
          final java.lang.Object $intervalDescription = this.getIntervalDescription();
          result = result * PRIME + ($intervalDescription == null ? 43 : $intervalDescription.hashCode());
          final java.lang.Object $paymentSchedule = this.getPaymentSchedule();
          result = result * PRIME + ($paymentSchedule == null ? 43 : $paymentSchedule.hashCode());
          final java.lang.Object $transactionType = this.getTransactionType();
          result = result * PRIME + ($transactionType == null ? 43 : $transactionType.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public MandateOptions getMandateOptions() {
        return this.mandateOptions;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Bank account verification method.
       *
       * <p>One of {@code automatic}, {@code instant}, or {@code microdeposits}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getVerificationMethod() {
        return this.verificationMethod;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMandateOptions(final MandateOptions mandateOptions) {
        this.mandateOptions = mandateOptions;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      /**
       * Bank account verification method.
       *
       * <p>One of {@code automatic}, {@code instant}, or {@code microdeposits}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setVerificationMethod(final String verificationMethod) {
        this.verificationMethod = verificationMethod;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.AcssDebit)) return false;
        final PaymentIntent.PaymentMethodOptions.AcssDebit other = (PaymentIntent.PaymentMethodOptions.AcssDebit) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$mandateOptions = this.getMandateOptions();
        final java.lang.Object other$mandateOptions = other.getMandateOptions();
        if (this$mandateOptions == null ? other$mandateOptions != null : !this$mandateOptions.equals(other$mandateOptions)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        final java.lang.Object this$verificationMethod = this.getVerificationMethod();
        final java.lang.Object other$verificationMethod = other.getVerificationMethod();
        if (this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.AcssDebit;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $mandateOptions = this.getMandateOptions();
        result = result * PRIME + ($mandateOptions == null ? 43 : $mandateOptions.hashCode());
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        final java.lang.Object $verificationMethod = this.getVerificationMethod();
        result = result * PRIME + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
        return result;
      }
    }


    /**
     * Transaction type of the mandate.
     *
     * <p>One of {@code business}, or {@code personal}.
     */
    public static class Affirm extends StripeObject {
      /**
       * Controls when the funds will be captured from the customer's account.
       *
       * <p>Equal to {@code manual}.
       */
      @SerializedName("capture_method")
      String captureMethod;
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Controls when the funds will be captured from the customer's account.
       *
       * <p>Equal to {@code manual}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCaptureMethod() {
        return this.captureMethod;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Controls when the funds will be captured from the customer's account.
       *
       * <p>Equal to {@code manual}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCaptureMethod(final String captureMethod) {
        this.captureMethod = captureMethod;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Affirm)) return false;
        final PaymentIntent.PaymentMethodOptions.Affirm other = (PaymentIntent.PaymentMethodOptions.Affirm) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$captureMethod = this.getCaptureMethod();
        final java.lang.Object other$captureMethod = other.getCaptureMethod();
        if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Affirm;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $captureMethod = this.getCaptureMethod();
        result = result * PRIME + ($captureMethod == null ? 43 : $captureMethod.hashCode());
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class AfterpayClearpay extends StripeObject {
      /**
       * Controls when the funds will be captured from the customer's account.
       *
       * <p>Equal to {@code manual}.
       */
      @SerializedName("capture_method")
      String captureMethod;
      /**
       * Order identifier shown to the customer in Afterpay’s online portal. We recommend using a
       * value that helps you answer any questions a customer might have about the payment. The
       * identifier is limited to 128 characters and may contain only letters, digits, underscores,
       * backslashes and dashes.
       */
      @SerializedName("reference")
      String reference;
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Controls when the funds will be captured from the customer's account.
       *
       * <p>Equal to {@code manual}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCaptureMethod() {
        return this.captureMethod;
      }

      /**
       * Order identifier shown to the customer in Afterpay’s online portal. We recommend using a
       * value that helps you answer any questions a customer might have about the payment. The
       * identifier is limited to 128 characters and may contain only letters, digits, underscores,
       * backslashes and dashes.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getReference() {
        return this.reference;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Controls when the funds will be captured from the customer's account.
       *
       * <p>Equal to {@code manual}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCaptureMethod(final String captureMethod) {
        this.captureMethod = captureMethod;
      }

      /**
       * Order identifier shown to the customer in Afterpay’s online portal. We recommend using a
       * value that helps you answer any questions a customer might have about the payment. The
       * identifier is limited to 128 characters and may contain only letters, digits, underscores,
       * backslashes and dashes.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReference(final String reference) {
        this.reference = reference;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.AfterpayClearpay)) return false;
        final PaymentIntent.PaymentMethodOptions.AfterpayClearpay other = (PaymentIntent.PaymentMethodOptions.AfterpayClearpay) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$captureMethod = this.getCaptureMethod();
        final java.lang.Object other$captureMethod = other.getCaptureMethod();
        if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) return false;
        final java.lang.Object this$reference = this.getReference();
        final java.lang.Object other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.AfterpayClearpay;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $captureMethod = this.getCaptureMethod();
        result = result * PRIME + ($captureMethod == null ? 43 : $captureMethod.hashCode());
        final java.lang.Object $reference = this.getReference();
        result = result * PRIME + ($reference == null ? 43 : $reference.hashCode());
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class Alipay extends StripeObject {
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, or {@code off_session}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, or {@code off_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, or {@code off_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Alipay)) return false;
        final PaymentIntent.PaymentMethodOptions.Alipay other = (PaymentIntent.PaymentMethodOptions.Alipay) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Alipay;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class AuBecsDebit extends StripeObject {
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.AuBecsDebit)) return false;
        final PaymentIntent.PaymentMethodOptions.AuBecsDebit other = (PaymentIntent.PaymentMethodOptions.AuBecsDebit) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.AuBecsDebit;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class BacsDebit extends StripeObject {
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.BacsDebit)) return false;
        final PaymentIntent.PaymentMethodOptions.BacsDebit other = (PaymentIntent.PaymentMethodOptions.BacsDebit) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.BacsDebit;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class Bancontact extends StripeObject {
      /**
       * Preferred language of the Bancontact authorization page that the customer is redirected to.
       *
       * <p>One of {@code de}, {@code en}, {@code fr}, or {@code nl}.
       */
      @SerializedName("preferred_language")
      String preferredLanguage;
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, or {@code off_session}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Preferred language of the Bancontact authorization page that the customer is redirected to.
       *
       * <p>One of {@code de}, {@code en}, {@code fr}, or {@code nl}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getPreferredLanguage() {
        return this.preferredLanguage;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, or {@code off_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Preferred language of the Bancontact authorization page that the customer is redirected to.
       *
       * <p>One of {@code de}, {@code en}, {@code fr}, or {@code nl}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPreferredLanguage(final String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, or {@code off_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Bancontact)) return false;
        final PaymentIntent.PaymentMethodOptions.Bancontact other = (PaymentIntent.PaymentMethodOptions.Bancontact) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$preferredLanguage = this.getPreferredLanguage();
        final java.lang.Object other$preferredLanguage = other.getPreferredLanguage();
        if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Bancontact;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $preferredLanguage = this.getPreferredLanguage();
        result = result * PRIME + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class BankTransfer extends StripeObject {
      @SerializedName("eu_bank_transfer")
      EuBankTransfer euBankTransfer;
      /**
       * List of address types that should be returned in the financial_addresses response. If not
       * specified, all valid types will be returned.
       *
       * <p>Permitted values include: {@code sort_code}, {@code zengin}, {@code iban}, or {@code
       * spei}.
       */
      @SerializedName("requested_address_types")
      List<String> requestedAddressTypes;
      /**
       * The bank transfer type that this PaymentIntent is allowed to use for funding Permitted
       * values include: {@code eu_bank_transfer}, {@code gb_bank_transfer}, {@code
       * jp_bank_transfer}, or {@code mx_bank_transfer}.
       *
       * <p>One of {@code eu_bank_transfer}, {@code gb_bank_transfer}, {@code jp_bank_transfer}, or
       * {@code mx_bank_transfer}.
       */
      @SerializedName("type")
      String type;


      public static class EuBankTransfer extends StripeObject {
        @SerializedName("country")
        String country;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCountry() {
          return this.country;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCountry(final String country) {
          this.country = country;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentIntent.PaymentMethodOptions.BankTransfer.EuBankTransfer)) return false;
          final PaymentIntent.PaymentMethodOptions.BankTransfer.EuBankTransfer other = (PaymentIntent.PaymentMethodOptions.BankTransfer.EuBankTransfer) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$country = this.getCountry();
          final java.lang.Object other$country = other.getCountry();
          if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentIntent.PaymentMethodOptions.BankTransfer.EuBankTransfer;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $country = this.getCountry();
          result = result * PRIME + ($country == null ? 43 : $country.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public EuBankTransfer getEuBankTransfer() {
        return this.euBankTransfer;
      }

      /**
       * List of address types that should be returned in the financial_addresses response. If not
       * specified, all valid types will be returned.
       *
       * <p>Permitted values include: {@code sort_code}, {@code zengin}, {@code iban}, or {@code
       * spei}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getRequestedAddressTypes() {
        return this.requestedAddressTypes;
      }

      /**
       * The bank transfer type that this PaymentIntent is allowed to use for funding Permitted
       * values include: {@code eu_bank_transfer}, {@code gb_bank_transfer}, {@code
       * jp_bank_transfer}, or {@code mx_bank_transfer}.
       *
       * <p>One of {@code eu_bank_transfer}, {@code gb_bank_transfer}, {@code jp_bank_transfer}, or
       * {@code mx_bank_transfer}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getType() {
        return this.type;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setEuBankTransfer(final EuBankTransfer euBankTransfer) {
        this.euBankTransfer = euBankTransfer;
      }

      /**
       * List of address types that should be returned in the financial_addresses response. If not
       * specified, all valid types will be returned.
       *
       * <p>Permitted values include: {@code sort_code}, {@code zengin}, {@code iban}, or {@code
       * spei}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequestedAddressTypes(final List<String> requestedAddressTypes) {
        this.requestedAddressTypes = requestedAddressTypes;
      }

      /**
       * The bank transfer type that this PaymentIntent is allowed to use for funding Permitted
       * values include: {@code eu_bank_transfer}, {@code gb_bank_transfer}, {@code
       * jp_bank_transfer}, or {@code mx_bank_transfer}.
       *
       * <p>One of {@code eu_bank_transfer}, {@code gb_bank_transfer}, {@code jp_bank_transfer}, or
       * {@code mx_bank_transfer}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setType(final String type) {
        this.type = type;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.BankTransfer)) return false;
        final PaymentIntent.PaymentMethodOptions.BankTransfer other = (PaymentIntent.PaymentMethodOptions.BankTransfer) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$euBankTransfer = this.getEuBankTransfer();
        final java.lang.Object other$euBankTransfer = other.getEuBankTransfer();
        if (this$euBankTransfer == null ? other$euBankTransfer != null : !this$euBankTransfer.equals(other$euBankTransfer)) return false;
        final java.lang.Object this$requestedAddressTypes = this.getRequestedAddressTypes();
        final java.lang.Object other$requestedAddressTypes = other.getRequestedAddressTypes();
        if (this$requestedAddressTypes == null ? other$requestedAddressTypes != null : !this$requestedAddressTypes.equals(other$requestedAddressTypes)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.BankTransfer;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $euBankTransfer = this.getEuBankTransfer();
        result = result * PRIME + ($euBankTransfer == null ? 43 : $euBankTransfer.hashCode());
        final java.lang.Object $requestedAddressTypes = this.getRequestedAddressTypes();
        result = result * PRIME + ($requestedAddressTypes == null ? 43 : $requestedAddressTypes.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        return result;
      }
    }


    /**
     * The desired country code of the bank account information. Permitted values include:
     * {@code DE}, {@code ES}, {@code FR}, {@code IE}, or {@code NL}.
     *
     * <p>One of {@code DE}, {@code ES}, {@code FR}, {@code IE}, or {@code NL}.
     */
    public static class Blik extends StripeObject {
      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Blik)) return false;
        final PaymentIntent.PaymentMethodOptions.Blik other = (PaymentIntent.PaymentMethodOptions.Blik) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Blik;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int result = 1;
        return result;
      }
    }


    public static class BlikMandateOptionsOffSessionDetails extends StripeObject {
      /**
       * Amount of each recurring payment.
       */
      @SerializedName("amount")
      Long amount;
      /**
       * Currency of each recurring payment.
       */
      @SerializedName("currency")
      String currency;
      /**
       * Frequency interval of each recurring payment.
       *
       * <p>One of {@code day}, {@code month}, {@code week}, or {@code year}.
       */
      @SerializedName("interval")
      String interval;
      /**
       * Frequency indicator of each recurring payment.
       */
      @SerializedName("interval_count")
      Long intervalCount;

      /**
       * Amount of each recurring payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getAmount() {
        return this.amount;
      }

      /**
       * Currency of each recurring payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCurrency() {
        return this.currency;
      }

      /**
       * Frequency interval of each recurring payment.
       *
       * <p>One of {@code day}, {@code month}, {@code week}, or {@code year}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getInterval() {
        return this.interval;
      }

      /**
       * Frequency indicator of each recurring payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getIntervalCount() {
        return this.intervalCount;
      }

      /**
       * Amount of each recurring payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAmount(final Long amount) {
        this.amount = amount;
      }

      /**
       * Currency of each recurring payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCurrency(final String currency) {
        this.currency = currency;
      }

      /**
       * Frequency interval of each recurring payment.
       *
       * <p>One of {@code day}, {@code month}, {@code week}, or {@code year}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setInterval(final String interval) {
        this.interval = interval;
      }

      /**
       * Frequency indicator of each recurring payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setIntervalCount(final Long intervalCount) {
        this.intervalCount = intervalCount;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.BlikMandateOptionsOffSessionDetails)) return false;
        final PaymentIntent.PaymentMethodOptions.BlikMandateOptionsOffSessionDetails other = (PaymentIntent.PaymentMethodOptions.BlikMandateOptionsOffSessionDetails) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$amount = this.getAmount();
        final java.lang.Object other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
        final java.lang.Object this$intervalCount = this.getIntervalCount();
        final java.lang.Object other$intervalCount = other.getIntervalCount();
        if (this$intervalCount == null ? other$intervalCount != null : !this$intervalCount.equals(other$intervalCount)) return false;
        final java.lang.Object this$currency = this.getCurrency();
        final java.lang.Object other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
        final java.lang.Object this$interval = this.getInterval();
        final java.lang.Object other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.BlikMandateOptionsOffSessionDetails;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $amount = this.getAmount();
        result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
        final java.lang.Object $intervalCount = this.getIntervalCount();
        result = result * PRIME + ($intervalCount == null ? 43 : $intervalCount.hashCode());
        final java.lang.Object $currency = this.getCurrency();
        result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
        final java.lang.Object $interval = this.getInterval();
        result = result * PRIME + ($interval == null ? 43 : $interval.hashCode());
        return result;
      }
    }


    public static class Boleto extends StripeObject {
      /**
       * The number of calendar days before a Boleto voucher expires. For example, if you create a
       * Boleto voucher on Monday and you set expires_after_days to 2, the Boleto voucher will
       * expire on Wednesday at 23:59 America/Sao_Paulo time.
       */
      @SerializedName("expires_after_days")
      Long expiresAfterDays;
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * The number of calendar days before a Boleto voucher expires. For example, if you create a
       * Boleto voucher on Monday and you set expires_after_days to 2, the Boleto voucher will
       * expire on Wednesday at 23:59 America/Sao_Paulo time.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getExpiresAfterDays() {
        return this.expiresAfterDays;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * The number of calendar days before a Boleto voucher expires. For example, if you create a
       * Boleto voucher on Monday and you set expires_after_days to 2, the Boleto voucher will
       * expire on Wednesday at 23:59 America/Sao_Paulo time.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExpiresAfterDays(final Long expiresAfterDays) {
        this.expiresAfterDays = expiresAfterDays;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Boleto)) return false;
        final PaymentIntent.PaymentMethodOptions.Boleto other = (PaymentIntent.PaymentMethodOptions.Boleto) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$expiresAfterDays = this.getExpiresAfterDays();
        final java.lang.Object other$expiresAfterDays = other.getExpiresAfterDays();
        if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !this$expiresAfterDays.equals(other$expiresAfterDays)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Boleto;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $expiresAfterDays = this.getExpiresAfterDays();
        result = result * PRIME + ($expiresAfterDays == null ? 43 : $expiresAfterDays.hashCode());
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class Card extends StripeObject {
      /**
       * Controls when the funds will be captured from the customer's account.
       *
       * <p>Equal to {@code manual}.
       */
      @SerializedName("capture_method")
      String captureMethod;
      /**
       * Installment details for this payment (Mexico only).
       *
       * <p>For more information, see the <a
       * href="https://stripe.com/docs/payments/installments">installments integration guide</a>.
       */
      @SerializedName("installments")
      Installments installments;
      /**
       * Configuration options for setting up an eMandate for cards issued in India.
       */
      @SerializedName("mandate_options")
      MandateOptions mandateOptions;
      /**
       * Selected network to process this payment intent on. Depends on the available networks of
       * the card attached to the payment intent. Can be only set confirm-time.
       */
      @SerializedName("network")
      String network;
      /**
       * We strongly recommend that you rely on our SCA Engine to automatically prompt your
       * customers for authentication based on risk level and <a
       * href="https://stripe.com/docs/strong-customer-authentication">other requirements</a>.
       * However, if you wish to request 3D Secure based on logic from your own fraud engine,
       * provide this option. Permitted values include: {@code automatic} or {@code any}. If not
       * provided, defaults to {@code automatic}. Read our guide on <a
       * href="https://stripe.com/docs/payments/3d-secure#manual-three-ds">manually requesting 3D
       * Secure</a> for more information on how this configuration interacts with Radar and our SCA
       * Engine.
       *
       * <p>One of {@code any}, {@code automatic}, or {@code challenge_only}.
       */
      @SerializedName("request_three_d_secure")
      String requestThreeDSecure;
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;
      /**
       * Provides information about a card payment that customers see on their statements.
       * Concatenated with the Kana prefix (shortened Kana descriptor) or Kana statement descriptor
       * that’s set on the account to form the complete statement descriptor. Maximum 22 characters.
       * On card statements, the <em>concatenation</em> of both prefix and suffix (including
       * separators) will appear truncated to 22 characters.
       */
      @SerializedName("statement_descriptor_suffix_kana")
      String statementDescriptorSuffixKana;
      /**
       * Provides information about a card payment that customers see on their statements.
       * Concatenated with the Kanji prefix (shortened Kanji descriptor) or Kanji statement
       * descriptor that’s set on the account to form the complete statement descriptor. Maximum 17
       * characters. On card statements, the <em>concatenation</em> of both prefix and suffix
       * (including separators) will appear truncated to 17 characters.
       */
      @SerializedName("statement_descriptor_suffix_kanji")
      String statementDescriptorSuffixKanji;


      public static class Installments extends StripeObject {
        /**
         * Installment plans that may be selected for this PaymentIntent.
         */
        @SerializedName("available_plans")
        List<PaymentIntent.PaymentMethodOptions.Card.Installments.Plan> availablePlans;
        /**
         * Whether Installments are enabled for this PaymentIntent.
         */
        @SerializedName("enabled")
        Boolean enabled;
        /**
         * Installment plan selected for this PaymentIntent.
         */
        @SerializedName("plan")
        Plan plan;


        public static class Plan extends StripeObject {
          /**
           * For {@code fixed_count} installment plans, this is the number of installment payments
           * your customer will make to their credit card.
           */
          @SerializedName("count")
          Long count;
          /**
           * For {@code fixed_count} installment plans, this is the interval between installment
           * payments your customer will make to their credit card. One of {@code month}.
           */
          @SerializedName("interval")
          String interval;
          @SerializedName("type")
          String type;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public Long getCount() {
            return this.count;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getInterval() {
            return this.interval;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getType() {
            return this.type;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setCount(final Long count) {
            this.count = count;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setInterval(final String interval) {
            this.interval = interval;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setType(final String type) {
            this.type = type;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof PaymentIntent.PaymentMethodOptions.Card.Installments.Plan)) return false;
            final PaymentIntent.PaymentMethodOptions.Card.Installments.Plan other = (PaymentIntent.PaymentMethodOptions.Card.Installments.Plan) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$count = this.getCount();
            final java.lang.Object other$count = other.getCount();
            if (this$count == null ? other$count != null : !this$count.equals(other$count)) return false;
            final java.lang.Object this$interval = this.getInterval();
            final java.lang.Object other$interval = other.getInterval();
            if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) return false;
            final java.lang.Object this$type = this.getType();
            final java.lang.Object other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof PaymentIntent.PaymentMethodOptions.Card.Installments.Plan;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $count = this.getCount();
            result = result * PRIME + ($count == null ? 43 : $count.hashCode());
            final java.lang.Object $interval = this.getInterval();
            result = result * PRIME + ($interval == null ? 43 : $interval.hashCode());
            final java.lang.Object $type = this.getType();
            result = result * PRIME + ($type == null ? 43 : $type.hashCode());
            return result;
          }
        }

        /**
         * Installment plans that may be selected for this PaymentIntent.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<PaymentIntent.PaymentMethodOptions.Card.Installments.Plan> getAvailablePlans() {
          return this.availablePlans;
        }

        /**
         * Whether Installments are enabled for this PaymentIntent.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getEnabled() {
          return this.enabled;
        }

        /**
         * Installment plan selected for this PaymentIntent.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Plan getPlan() {
          return this.plan;
        }

        /**
         * Installment plans that may be selected for this PaymentIntent.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAvailablePlans(final List<PaymentIntent.PaymentMethodOptions.Card.Installments.Plan> availablePlans) {
          this.availablePlans = availablePlans;
        }

        /**
         * Whether Installments are enabled for this PaymentIntent.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setEnabled(final Boolean enabled) {
          this.enabled = enabled;
        }

        /**
         * Installment plan selected for this PaymentIntent.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setPlan(final Plan plan) {
          this.plan = plan;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentIntent.PaymentMethodOptions.Card.Installments)) return false;
          final PaymentIntent.PaymentMethodOptions.Card.Installments other = (PaymentIntent.PaymentMethodOptions.Card.Installments) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$enabled = this.getEnabled();
          final java.lang.Object other$enabled = other.getEnabled();
          if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) return false;
          final java.lang.Object this$availablePlans = this.getAvailablePlans();
          final java.lang.Object other$availablePlans = other.getAvailablePlans();
          if (this$availablePlans == null ? other$availablePlans != null : !this$availablePlans.equals(other$availablePlans)) return false;
          final java.lang.Object this$plan = this.getPlan();
          final java.lang.Object other$plan = other.getPlan();
          if (this$plan == null ? other$plan != null : !this$plan.equals(other$plan)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentIntent.PaymentMethodOptions.Card.Installments;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $enabled = this.getEnabled();
          result = result * PRIME + ($enabled == null ? 43 : $enabled.hashCode());
          final java.lang.Object $availablePlans = this.getAvailablePlans();
          result = result * PRIME + ($availablePlans == null ? 43 : $availablePlans.hashCode());
          final java.lang.Object $plan = this.getPlan();
          result = result * PRIME + ($plan == null ? 43 : $plan.hashCode());
          return result;
        }
      }


      /**
       * Type of installment plan, one of {@code fixed_count}.
       */
      public static class MandateOptions extends StripeObject {
        /** Amount to be charged for future payments. */
        @SerializedName("amount")
        Long amount;
        /**
         * One of {@code fixed} or {@code maximum}. If {@code fixed}, the {@code amount} param
         * refers to the exact amount to be charged in future payments. If {@code maximum}, the
         * amount charged can be up to the value passed for the {@code amount} param.
         */
        @SerializedName("amount_type")
        String amountType;
        /**
         * A description of the mandate or subscription that is meant to be displayed to the
         * customer.
         */
        @SerializedName("description")
        String description;
        /**
         * End date of the mandate or subscription. If not provided, the mandate will be active
         * until canceled. If provided, end date should be after start date.
         */
        @SerializedName("end_date")
        Long endDate;
        /**
         * Specifies payment frequency. One of {@code day}, {@code week}, {@code month}, {@code
         * year}, or {@code sporadic}.
         */
        @SerializedName("interval")
        String interval;
        /**
         * The number of intervals between payments. For example, {@code interval=month} and {@code
         * interval_count=3} indicates one payment every three months. Maximum of one year interval
         * allowed (1 year, 12 months, or 52 weeks). This parameter is optional when {@code
         * interval=sporadic}.
         */
        @SerializedName("interval_count")
        Long intervalCount;
        /** Unique identifier for the mandate or subscription. */
        @SerializedName("reference")
        String reference;
        /**
         * Start date of the mandate or subscription. Start date should not be lesser than
         * yesterday.
         */
        @SerializedName("start_date")
        Long startDate;
        @SerializedName("supported_types")
        List<String> supportedTypes;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getAmount() {
          return this.amount;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAmountType() {
          return this.amountType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDescription() {
          return this.description;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getEndDate() {
          return this.endDate;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getInterval() {
          return this.interval;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getIntervalCount() {
          return this.intervalCount;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getReference() {
          return this.reference;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getStartDate() {
          return this.startDate;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getSupportedTypes() {
          return this.supportedTypes;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAmount(final Long amount) {
          this.amount = amount;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAmountType(final String amountType) {
          this.amountType = amountType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setDescription(final String description) {
          this.description = description;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setEndDate(final Long endDate) {
          this.endDate = endDate;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setInterval(final String interval) {
          this.interval = interval;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setIntervalCount(final Long intervalCount) {
          this.intervalCount = intervalCount;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setReference(final String reference) {
          this.reference = reference;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setStartDate(final Long startDate) {
          this.startDate = startDate;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setSupportedTypes(final List<String> supportedTypes) {
          this.supportedTypes = supportedTypes;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentIntent.PaymentMethodOptions.Card.MandateOptions)) return false;
          final PaymentIntent.PaymentMethodOptions.Card.MandateOptions other = (PaymentIntent.PaymentMethodOptions.Card.MandateOptions) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$amount = this.getAmount();
          final java.lang.Object other$amount = other.getAmount();
          if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
          final java.lang.Object this$endDate = this.getEndDate();
          final java.lang.Object other$endDate = other.getEndDate();
          if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) return false;
          final java.lang.Object this$intervalCount = this.getIntervalCount();
          final java.lang.Object other$intervalCount = other.getIntervalCount();
          if (this$intervalCount == null ? other$intervalCount != null : !this$intervalCount.equals(other$intervalCount)) return false;
          final java.lang.Object this$startDate = this.getStartDate();
          final java.lang.Object other$startDate = other.getStartDate();
          if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) return false;
          final java.lang.Object this$amountType = this.getAmountType();
          final java.lang.Object other$amountType = other.getAmountType();
          if (this$amountType == null ? other$amountType != null : !this$amountType.equals(other$amountType)) return false;
          final java.lang.Object this$description = this.getDescription();
          final java.lang.Object other$description = other.getDescription();
          if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
          final java.lang.Object this$interval = this.getInterval();
          final java.lang.Object other$interval = other.getInterval();
          if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) return false;
          final java.lang.Object this$reference = this.getReference();
          final java.lang.Object other$reference = other.getReference();
          if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) return false;
          final java.lang.Object this$supportedTypes = this.getSupportedTypes();
          final java.lang.Object other$supportedTypes = other.getSupportedTypes();
          if (this$supportedTypes == null ? other$supportedTypes != null : !this$supportedTypes.equals(other$supportedTypes)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentIntent.PaymentMethodOptions.Card.MandateOptions;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $amount = this.getAmount();
          result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
          final java.lang.Object $endDate = this.getEndDate();
          result = result * PRIME + ($endDate == null ? 43 : $endDate.hashCode());
          final java.lang.Object $intervalCount = this.getIntervalCount();
          result = result * PRIME + ($intervalCount == null ? 43 : $intervalCount.hashCode());
          final java.lang.Object $startDate = this.getStartDate();
          result = result * PRIME + ($startDate == null ? 43 : $startDate.hashCode());
          final java.lang.Object $amountType = this.getAmountType();
          result = result * PRIME + ($amountType == null ? 43 : $amountType.hashCode());
          final java.lang.Object $description = this.getDescription();
          result = result * PRIME + ($description == null ? 43 : $description.hashCode());
          final java.lang.Object $interval = this.getInterval();
          result = result * PRIME + ($interval == null ? 43 : $interval.hashCode());
          final java.lang.Object $reference = this.getReference();
          result = result * PRIME + ($reference == null ? 43 : $reference.hashCode());
          final java.lang.Object $supportedTypes = this.getSupportedTypes();
          result = result * PRIME + ($supportedTypes == null ? 43 : $supportedTypes.hashCode());
          return result;
        }
      }

      /**
       * Controls when the funds will be captured from the customer's account.
       *
       * <p>Equal to {@code manual}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCaptureMethod() {
        return this.captureMethod;
      }

      /**
       * Installment details for this payment (Mexico only).
       *
       * <p>For more information, see the <a
       * href="https://stripe.com/docs/payments/installments">installments integration guide</a>.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Installments getInstallments() {
        return this.installments;
      }

      /**
       * Configuration options for setting up an eMandate for cards issued in India.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public MandateOptions getMandateOptions() {
        return this.mandateOptions;
      }

      /**
       * Selected network to process this payment intent on. Depends on the available networks of
       * the card attached to the payment intent. Can be only set confirm-time.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getNetwork() {
        return this.network;
      }

      /**
       * We strongly recommend that you rely on our SCA Engine to automatically prompt your
       * customers for authentication based on risk level and <a
       * href="https://stripe.com/docs/strong-customer-authentication">other requirements</a>.
       * However, if you wish to request 3D Secure based on logic from your own fraud engine,
       * provide this option. Permitted values include: {@code automatic} or {@code any}. If not
       * provided, defaults to {@code automatic}. Read our guide on <a
       * href="https://stripe.com/docs/payments/3d-secure#manual-three-ds">manually requesting 3D
       * Secure</a> for more information on how this configuration interacts with Radar and our SCA
       * Engine.
       *
       * <p>One of {@code any}, {@code automatic}, or {@code challenge_only}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRequestThreeDSecure() {
        return this.requestThreeDSecure;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Provides information about a card payment that customers see on their statements.
       * Concatenated with the Kana prefix (shortened Kana descriptor) or Kana statement descriptor
       * that’s set on the account to form the complete statement descriptor. Maximum 22 characters.
       * On card statements, the <em>concatenation</em> of both prefix and suffix (including
       * separators) will appear truncated to 22 characters.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getStatementDescriptorSuffixKana() {
        return this.statementDescriptorSuffixKana;
      }

      /**
       * Provides information about a card payment that customers see on their statements.
       * Concatenated with the Kanji prefix (shortened Kanji descriptor) or Kanji statement
       * descriptor that’s set on the account to form the complete statement descriptor. Maximum 17
       * characters. On card statements, the <em>concatenation</em> of both prefix and suffix
       * (including separators) will appear truncated to 17 characters.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getStatementDescriptorSuffixKanji() {
        return this.statementDescriptorSuffixKanji;
      }

      /**
       * Controls when the funds will be captured from the customer's account.
       *
       * <p>Equal to {@code manual}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCaptureMethod(final String captureMethod) {
        this.captureMethod = captureMethod;
      }

      /**
       * Installment details for this payment (Mexico only).
       *
       * <p>For more information, see the <a
       * href="https://stripe.com/docs/payments/installments">installments integration guide</a>.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setInstallments(final Installments installments) {
        this.installments = installments;
      }

      /**
       * Configuration options for setting up an eMandate for cards issued in India.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMandateOptions(final MandateOptions mandateOptions) {
        this.mandateOptions = mandateOptions;
      }

      /**
       * Selected network to process this payment intent on. Depends on the available networks of
       * the card attached to the payment intent. Can be only set confirm-time.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setNetwork(final String network) {
        this.network = network;
      }

      /**
       * We strongly recommend that you rely on our SCA Engine to automatically prompt your
       * customers for authentication based on risk level and <a
       * href="https://stripe.com/docs/strong-customer-authentication">other requirements</a>.
       * However, if you wish to request 3D Secure based on logic from your own fraud engine,
       * provide this option. Permitted values include: {@code automatic} or {@code any}. If not
       * provided, defaults to {@code automatic}. Read our guide on <a
       * href="https://stripe.com/docs/payments/3d-secure#manual-three-ds">manually requesting 3D
       * Secure</a> for more information on how this configuration interacts with Radar and our SCA
       * Engine.
       *
       * <p>One of {@code any}, {@code automatic}, or {@code challenge_only}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequestThreeDSecure(final String requestThreeDSecure) {
        this.requestThreeDSecure = requestThreeDSecure;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      /**
       * Provides information about a card payment that customers see on their statements.
       * Concatenated with the Kana prefix (shortened Kana descriptor) or Kana statement descriptor
       * that’s set on the account to form the complete statement descriptor. Maximum 22 characters.
       * On card statements, the <em>concatenation</em> of both prefix and suffix (including
       * separators) will appear truncated to 22 characters.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setStatementDescriptorSuffixKana(final String statementDescriptorSuffixKana) {
        this.statementDescriptorSuffixKana = statementDescriptorSuffixKana;
      }

      /**
       * Provides information about a card payment that customers see on their statements.
       * Concatenated with the Kanji prefix (shortened Kanji descriptor) or Kanji statement
       * descriptor that’s set on the account to form the complete statement descriptor. Maximum 17
       * characters. On card statements, the <em>concatenation</em> of both prefix and suffix
       * (including separators) will appear truncated to 17 characters.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setStatementDescriptorSuffixKanji(final String statementDescriptorSuffixKanji) {
        this.statementDescriptorSuffixKanji = statementDescriptorSuffixKanji;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Card)) return false;
        final PaymentIntent.PaymentMethodOptions.Card other = (PaymentIntent.PaymentMethodOptions.Card) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$captureMethod = this.getCaptureMethod();
        final java.lang.Object other$captureMethod = other.getCaptureMethod();
        if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) return false;
        final java.lang.Object this$installments = this.getInstallments();
        final java.lang.Object other$installments = other.getInstallments();
        if (this$installments == null ? other$installments != null : !this$installments.equals(other$installments)) return false;
        final java.lang.Object this$mandateOptions = this.getMandateOptions();
        final java.lang.Object other$mandateOptions = other.getMandateOptions();
        if (this$mandateOptions == null ? other$mandateOptions != null : !this$mandateOptions.equals(other$mandateOptions)) return false;
        final java.lang.Object this$network = this.getNetwork();
        final java.lang.Object other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) return false;
        final java.lang.Object this$requestThreeDSecure = this.getRequestThreeDSecure();
        final java.lang.Object other$requestThreeDSecure = other.getRequestThreeDSecure();
        if (this$requestThreeDSecure == null ? other$requestThreeDSecure != null : !this$requestThreeDSecure.equals(other$requestThreeDSecure)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        final java.lang.Object this$statementDescriptorSuffixKana = this.getStatementDescriptorSuffixKana();
        final java.lang.Object other$statementDescriptorSuffixKana = other.getStatementDescriptorSuffixKana();
        if (this$statementDescriptorSuffixKana == null ? other$statementDescriptorSuffixKana != null : !this$statementDescriptorSuffixKana.equals(other$statementDescriptorSuffixKana)) return false;
        final java.lang.Object this$statementDescriptorSuffixKanji = this.getStatementDescriptorSuffixKanji();
        final java.lang.Object other$statementDescriptorSuffixKanji = other.getStatementDescriptorSuffixKanji();
        if (this$statementDescriptorSuffixKanji == null ? other$statementDescriptorSuffixKanji != null : !this$statementDescriptorSuffixKanji.equals(other$statementDescriptorSuffixKanji)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Card;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $captureMethod = this.getCaptureMethod();
        result = result * PRIME + ($captureMethod == null ? 43 : $captureMethod.hashCode());
        final java.lang.Object $installments = this.getInstallments();
        result = result * PRIME + ($installments == null ? 43 : $installments.hashCode());
        final java.lang.Object $mandateOptions = this.getMandateOptions();
        result = result * PRIME + ($mandateOptions == null ? 43 : $mandateOptions.hashCode());
        final java.lang.Object $network = this.getNetwork();
        result = result * PRIME + ($network == null ? 43 : $network.hashCode());
        final java.lang.Object $requestThreeDSecure = this.getRequestThreeDSecure();
        result = result * PRIME + ($requestThreeDSecure == null ? 43 : $requestThreeDSecure.hashCode());
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        final java.lang.Object $statementDescriptorSuffixKana = this.getStatementDescriptorSuffixKana();
        result = result * PRIME + ($statementDescriptorSuffixKana == null ? 43 : $statementDescriptorSuffixKana.hashCode());
        final java.lang.Object $statementDescriptorSuffixKanji = this.getStatementDescriptorSuffixKanji();
        result = result * PRIME + ($statementDescriptorSuffixKanji == null ? 43 : $statementDescriptorSuffixKanji.hashCode());
        return result;
      }
    }


    /**
     * Specifies the type of mandates supported. Possible values are {@code india}.
     */
    public static class CardPresent extends StripeObject {
      /**
       * Request ability to capture this payment beyond the standard <a
       * href="https://stripe.com/docs/terminal/features/extended-authorizations#authorization-validity">authorization
       * validity window.</a>
       */
      @SerializedName("request_extended_authorization")
      Boolean requestExtendedAuthorization;
      /**
       * Request ability to <a
       * href="https://stripe.com/docs/terminal/features/incremental-authorizations">increment</a>
       * this PaymentIntent if the combination of MCC and card brand is eligible. Check <a
       * href="https://stripe.com/docs/api/charges/object#charge_object-payment_method_details-card_present-incremental_authorization_supported">incremental_authorization_supported</a>
       * in the <a href="https://stripe.com/docs/api/payment_intents/confirm">Confirm</a> response
       * to verify support.
       */
      @SerializedName("request_incremental_authorization_support")
      Boolean requestIncrementalAuthorizationSupport;

      /**
       * Request ability to capture this payment beyond the standard <a
       * href="https://stripe.com/docs/terminal/features/extended-authorizations#authorization-validity">authorization
       * validity window.</a>
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getRequestExtendedAuthorization() {
        return this.requestExtendedAuthorization;
      }

      /**
       * Request ability to <a
       * href="https://stripe.com/docs/terminal/features/incremental-authorizations">increment</a>
       * this PaymentIntent if the combination of MCC and card brand is eligible. Check <a
       * href="https://stripe.com/docs/api/charges/object#charge_object-payment_method_details-card_present-incremental_authorization_supported">incremental_authorization_supported</a>
       * in the <a href="https://stripe.com/docs/api/payment_intents/confirm">Confirm</a> response
       * to verify support.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getRequestIncrementalAuthorizationSupport() {
        return this.requestIncrementalAuthorizationSupport;
      }

      /**
       * Request ability to capture this payment beyond the standard <a
       * href="https://stripe.com/docs/terminal/features/extended-authorizations#authorization-validity">authorization
       * validity window.</a>
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequestExtendedAuthorization(final Boolean requestExtendedAuthorization) {
        this.requestExtendedAuthorization = requestExtendedAuthorization;
      }

      /**
       * Request ability to <a
       * href="https://stripe.com/docs/terminal/features/incremental-authorizations">increment</a>
       * this PaymentIntent if the combination of MCC and card brand is eligible. Check <a
       * href="https://stripe.com/docs/api/charges/object#charge_object-payment_method_details-card_present-incremental_authorization_supported">incremental_authorization_supported</a>
       * in the <a href="https://stripe.com/docs/api/payment_intents/confirm">Confirm</a> response
       * to verify support.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequestIncrementalAuthorizationSupport(final Boolean requestIncrementalAuthorizationSupport) {
        this.requestIncrementalAuthorizationSupport = requestIncrementalAuthorizationSupport;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.CardPresent)) return false;
        final PaymentIntent.PaymentMethodOptions.CardPresent other = (PaymentIntent.PaymentMethodOptions.CardPresent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$requestExtendedAuthorization = this.getRequestExtendedAuthorization();
        final java.lang.Object other$requestExtendedAuthorization = other.getRequestExtendedAuthorization();
        if (this$requestExtendedAuthorization == null ? other$requestExtendedAuthorization != null : !this$requestExtendedAuthorization.equals(other$requestExtendedAuthorization)) return false;
        final java.lang.Object this$requestIncrementalAuthorizationSupport = this.getRequestIncrementalAuthorizationSupport();
        final java.lang.Object other$requestIncrementalAuthorizationSupport = other.getRequestIncrementalAuthorizationSupport();
        if (this$requestIncrementalAuthorizationSupport == null ? other$requestIncrementalAuthorizationSupport != null : !this$requestIncrementalAuthorizationSupport.equals(other$requestIncrementalAuthorizationSupport)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.CardPresent;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $requestExtendedAuthorization = this.getRequestExtendedAuthorization();
        result = result * PRIME + ($requestExtendedAuthorization == null ? 43 : $requestExtendedAuthorization.hashCode());
        final java.lang.Object $requestIncrementalAuthorizationSupport = this.getRequestIncrementalAuthorizationSupport();
        result = result * PRIME + ($requestIncrementalAuthorizationSupport == null ? 43 : $requestIncrementalAuthorizationSupport.hashCode());
        return result;
      }
    }


    public static class CustomerBalance extends StripeObject {
      @SerializedName("bank_transfer")
      BankTransfer bankTransfer;
      /**
       * The funding method type to be used when there are not enough funds in the customer balance.
       * Permitted values include: {@code bank_transfer}.
       *
       * <p>Equal to {@code bank_transfer}.
       */
      @SerializedName("funding_type")
      String fundingType;
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public BankTransfer getBankTransfer() {
        return this.bankTransfer;
      }

      /**
       * The funding method type to be used when there are not enough funds in the customer balance.
       * Permitted values include: {@code bank_transfer}.
       *
       * <p>Equal to {@code bank_transfer}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFundingType() {
        return this.fundingType;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankTransfer(final BankTransfer bankTransfer) {
        this.bankTransfer = bankTransfer;
      }

      /**
       * The funding method type to be used when there are not enough funds in the customer balance.
       * Permitted values include: {@code bank_transfer}.
       *
       * <p>Equal to {@code bank_transfer}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFundingType(final String fundingType) {
        this.fundingType = fundingType;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.CustomerBalance)) return false;
        final PaymentIntent.PaymentMethodOptions.CustomerBalance other = (PaymentIntent.PaymentMethodOptions.CustomerBalance) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$bankTransfer = this.getBankTransfer();
        final java.lang.Object other$bankTransfer = other.getBankTransfer();
        if (this$bankTransfer == null ? other$bankTransfer != null : !this$bankTransfer.equals(other$bankTransfer)) return false;
        final java.lang.Object this$fundingType = this.getFundingType();
        final java.lang.Object other$fundingType = other.getFundingType();
        if (this$fundingType == null ? other$fundingType != null : !this$fundingType.equals(other$fundingType)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.CustomerBalance;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $bankTransfer = this.getBankTransfer();
        result = result * PRIME + ($bankTransfer == null ? 43 : $bankTransfer.hashCode());
        final java.lang.Object $fundingType = this.getFundingType();
        result = result * PRIME + ($fundingType == null ? 43 : $fundingType.hashCode());
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class Eps extends StripeObject {
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Eps)) return false;
        final PaymentIntent.PaymentMethodOptions.Eps other = (PaymentIntent.PaymentMethodOptions.Eps) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Eps;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class Fpx extends StripeObject {
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Fpx)) return false;
        final PaymentIntent.PaymentMethodOptions.Fpx other = (PaymentIntent.PaymentMethodOptions.Fpx) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Fpx;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class Giropay extends StripeObject {
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Giropay)) return false;
        final PaymentIntent.PaymentMethodOptions.Giropay other = (PaymentIntent.PaymentMethodOptions.Giropay) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Giropay;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class Grabpay extends StripeObject {
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Grabpay)) return false;
        final PaymentIntent.PaymentMethodOptions.Grabpay other = (PaymentIntent.PaymentMethodOptions.Grabpay) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Grabpay;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class Ideal extends StripeObject {
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, or {@code off_session}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, or {@code off_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, or {@code off_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Ideal)) return false;
        final PaymentIntent.PaymentMethodOptions.Ideal other = (PaymentIntent.PaymentMethodOptions.Ideal) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Ideal;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class InteracPresent extends StripeObject {
      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.InteracPresent)) return false;
        final PaymentIntent.PaymentMethodOptions.InteracPresent other = (PaymentIntent.PaymentMethodOptions.InteracPresent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.InteracPresent;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int result = 1;
        return result;
      }
    }


    public static class Klarna extends StripeObject {
      /**
       * Controls when the funds will be captured from the customer's account.
       *
       * <p>Equal to {@code manual}.
       */
      @SerializedName("capture_method")
      String captureMethod;
      /**
       * Preferred locale of the Klarna checkout page that the customer is redirected to.
       */
      @SerializedName("preferred_locale")
      String preferredLocale;
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Controls when the funds will be captured from the customer's account.
       *
       * <p>Equal to {@code manual}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCaptureMethod() {
        return this.captureMethod;
      }

      /**
       * Preferred locale of the Klarna checkout page that the customer is redirected to.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getPreferredLocale() {
        return this.preferredLocale;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Controls when the funds will be captured from the customer's account.
       *
       * <p>Equal to {@code manual}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCaptureMethod(final String captureMethod) {
        this.captureMethod = captureMethod;
      }

      /**
       * Preferred locale of the Klarna checkout page that the customer is redirected to.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPreferredLocale(final String preferredLocale) {
        this.preferredLocale = preferredLocale;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Klarna)) return false;
        final PaymentIntent.PaymentMethodOptions.Klarna other = (PaymentIntent.PaymentMethodOptions.Klarna) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$captureMethod = this.getCaptureMethod();
        final java.lang.Object other$captureMethod = other.getCaptureMethod();
        if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) return false;
        final java.lang.Object this$preferredLocale = this.getPreferredLocale();
        final java.lang.Object other$preferredLocale = other.getPreferredLocale();
        if (this$preferredLocale == null ? other$preferredLocale != null : !this$preferredLocale.equals(other$preferredLocale)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Klarna;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $captureMethod = this.getCaptureMethod();
        result = result * PRIME + ($captureMethod == null ? 43 : $captureMethod.hashCode());
        final java.lang.Object $preferredLocale = this.getPreferredLocale();
        result = result * PRIME + ($preferredLocale == null ? 43 : $preferredLocale.hashCode());
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class Konbini extends StripeObject {
      /**
       * An optional 10 to 11 digit numeric-only string determining the confirmation code at
       * applicable convenience stores.
       */
      @SerializedName("confirmation_number")
      String confirmationNumber;
      /**
       * The number of calendar days (between 1 and 60) after which Konbini payment instructions
       * will expire. For example, if a PaymentIntent is confirmed with Konbini and {@code
       * expires_after_days} set to 2 on Monday JST, the instructions will expire on Wednesday
       * 23:59:59 JST.
       */
      @SerializedName("expires_after_days")
      Long expiresAfterDays;
      /**
       * The timestamp at which the Konbini payment instructions will expire. Only one of {@code
       * expires_after_days} or {@code expires_at} may be set.
       */
      @SerializedName("expires_at")
      Long expiresAt;
      /**
       * A product descriptor of up to 22 characters, which will appear to customers at the
       * convenience store.
       */
      @SerializedName("product_description")
      String productDescription;
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * An optional 10 to 11 digit numeric-only string determining the confirmation code at
       * applicable convenience stores.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getConfirmationNumber() {
        return this.confirmationNumber;
      }

      /**
       * The number of calendar days (between 1 and 60) after which Konbini payment instructions
       * will expire. For example, if a PaymentIntent is confirmed with Konbini and {@code
       * expires_after_days} set to 2 on Monday JST, the instructions will expire on Wednesday
       * 23:59:59 JST.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getExpiresAfterDays() {
        return this.expiresAfterDays;
      }

      /**
       * The timestamp at which the Konbini payment instructions will expire. Only one of {@code
       * expires_after_days} or {@code expires_at} may be set.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getExpiresAt() {
        return this.expiresAt;
      }

      /**
       * A product descriptor of up to 22 characters, which will appear to customers at the
       * convenience store.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getProductDescription() {
        return this.productDescription;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * An optional 10 to 11 digit numeric-only string determining the confirmation code at
       * applicable convenience stores.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setConfirmationNumber(final String confirmationNumber) {
        this.confirmationNumber = confirmationNumber;
      }

      /**
       * The number of calendar days (between 1 and 60) after which Konbini payment instructions
       * will expire. For example, if a PaymentIntent is confirmed with Konbini and {@code
       * expires_after_days} set to 2 on Monday JST, the instructions will expire on Wednesday
       * 23:59:59 JST.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExpiresAfterDays(final Long expiresAfterDays) {
        this.expiresAfterDays = expiresAfterDays;
      }

      /**
       * The timestamp at which the Konbini payment instructions will expire. Only one of {@code
       * expires_after_days} or {@code expires_at} may be set.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExpiresAt(final Long expiresAt) {
        this.expiresAt = expiresAt;
      }

      /**
       * A product descriptor of up to 22 characters, which will appear to customers at the
       * convenience store.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setProductDescription(final String productDescription) {
        this.productDescription = productDescription;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Konbini)) return false;
        final PaymentIntent.PaymentMethodOptions.Konbini other = (PaymentIntent.PaymentMethodOptions.Konbini) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$expiresAfterDays = this.getExpiresAfterDays();
        final java.lang.Object other$expiresAfterDays = other.getExpiresAfterDays();
        if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !this$expiresAfterDays.equals(other$expiresAfterDays)) return false;
        final java.lang.Object this$expiresAt = this.getExpiresAt();
        final java.lang.Object other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !this$expiresAt.equals(other$expiresAt)) return false;
        final java.lang.Object this$confirmationNumber = this.getConfirmationNumber();
        final java.lang.Object other$confirmationNumber = other.getConfirmationNumber();
        if (this$confirmationNumber == null ? other$confirmationNumber != null : !this$confirmationNumber.equals(other$confirmationNumber)) return false;
        final java.lang.Object this$productDescription = this.getProductDescription();
        final java.lang.Object other$productDescription = other.getProductDescription();
        if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Konbini;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $expiresAfterDays = this.getExpiresAfterDays();
        result = result * PRIME + ($expiresAfterDays == null ? 43 : $expiresAfterDays.hashCode());
        final java.lang.Object $expiresAt = this.getExpiresAt();
        result = result * PRIME + ($expiresAt == null ? 43 : $expiresAt.hashCode());
        final java.lang.Object $confirmationNumber = this.getConfirmationNumber();
        result = result * PRIME + ($confirmationNumber == null ? 43 : $confirmationNumber.hashCode());
        final java.lang.Object $productDescription = this.getProductDescription();
        result = result * PRIME + ($productDescription == null ? 43 : $productDescription.hashCode());
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class Link extends StripeObject {
      /**
       * Controls when the funds will be captured from the customer's account.
       *
       * <p>Equal to {@code manual}.
       */
      @SerializedName("capture_method")
      String captureMethod;
      /**
       * Token used for persistent Link logins.
       */
      @SerializedName("persistent_token")
      String persistentToken;
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, or {@code off_session}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Controls when the funds will be captured from the customer's account.
       *
       * <p>Equal to {@code manual}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCaptureMethod() {
        return this.captureMethod;
      }

      /**
       * Token used for persistent Link logins.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getPersistentToken() {
        return this.persistentToken;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, or {@code off_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Controls when the funds will be captured from the customer's account.
       *
       * <p>Equal to {@code manual}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCaptureMethod(final String captureMethod) {
        this.captureMethod = captureMethod;
      }

      /**
       * Token used for persistent Link logins.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPersistentToken(final String persistentToken) {
        this.persistentToken = persistentToken;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, or {@code off_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Link)) return false;
        final PaymentIntent.PaymentMethodOptions.Link other = (PaymentIntent.PaymentMethodOptions.Link) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$captureMethod = this.getCaptureMethod();
        final java.lang.Object other$captureMethod = other.getCaptureMethod();
        if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) return false;
        final java.lang.Object this$persistentToken = this.getPersistentToken();
        final java.lang.Object other$persistentToken = other.getPersistentToken();
        if (this$persistentToken == null ? other$persistentToken != null : !this$persistentToken.equals(other$persistentToken)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Link;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $captureMethod = this.getCaptureMethod();
        result = result * PRIME + ($captureMethod == null ? 43 : $captureMethod.hashCode());
        final java.lang.Object $persistentToken = this.getPersistentToken();
        result = result * PRIME + ($persistentToken == null ? 43 : $persistentToken.hashCode());
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class Oxxo extends StripeObject {
      /**
       * The number of calendar days before an OXXO invoice expires. For example, if you create an
       * OXXO invoice on Monday and you set expires_after_days to 2, the OXXO invoice will expire on
       * Wednesday at 23:59 America/Mexico_City time.
       */
      @SerializedName("expires_after_days")
      Long expiresAfterDays;
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * The number of calendar days before an OXXO invoice expires. For example, if you create an
       * OXXO invoice on Monday and you set expires_after_days to 2, the OXXO invoice will expire on
       * Wednesday at 23:59 America/Mexico_City time.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getExpiresAfterDays() {
        return this.expiresAfterDays;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * The number of calendar days before an OXXO invoice expires. For example, if you create an
       * OXXO invoice on Monday and you set expires_after_days to 2, the OXXO invoice will expire on
       * Wednesday at 23:59 America/Mexico_City time.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExpiresAfterDays(final Long expiresAfterDays) {
        this.expiresAfterDays = expiresAfterDays;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Oxxo)) return false;
        final PaymentIntent.PaymentMethodOptions.Oxxo other = (PaymentIntent.PaymentMethodOptions.Oxxo) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$expiresAfterDays = this.getExpiresAfterDays();
        final java.lang.Object other$expiresAfterDays = other.getExpiresAfterDays();
        if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !this$expiresAfterDays.equals(other$expiresAfterDays)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Oxxo;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $expiresAfterDays = this.getExpiresAfterDays();
        result = result * PRIME + ($expiresAfterDays == null ? 43 : $expiresAfterDays.hashCode());
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class P24 extends StripeObject {
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.P24)) return false;
        final PaymentIntent.PaymentMethodOptions.P24 other = (PaymentIntent.PaymentMethodOptions.P24) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.P24;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class Paynow extends StripeObject {
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Paynow)) return false;
        final PaymentIntent.PaymentMethodOptions.Paynow other = (PaymentIntent.PaymentMethodOptions.Paynow) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Paynow;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class Pix extends StripeObject {
      /**
       * The number of seconds (between 10 and 1209600) after which Pix payment will expire.
       */
      @SerializedName("expires_after_seconds")
      Long expiresAfterSeconds;
      /**
       * The timestamp at which the Pix expires.
       */
      @SerializedName("expires_at")
      Long expiresAt;
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * The number of seconds (between 10 and 1209600) after which Pix payment will expire.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getExpiresAfterSeconds() {
        return this.expiresAfterSeconds;
      }

      /**
       * The timestamp at which the Pix expires.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getExpiresAt() {
        return this.expiresAt;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * The number of seconds (between 10 and 1209600) after which Pix payment will expire.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExpiresAfterSeconds(final Long expiresAfterSeconds) {
        this.expiresAfterSeconds = expiresAfterSeconds;
      }

      /**
       * The timestamp at which the Pix expires.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setExpiresAt(final Long expiresAt) {
        this.expiresAt = expiresAt;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Pix)) return false;
        final PaymentIntent.PaymentMethodOptions.Pix other = (PaymentIntent.PaymentMethodOptions.Pix) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$expiresAfterSeconds = this.getExpiresAfterSeconds();
        final java.lang.Object other$expiresAfterSeconds = other.getExpiresAfterSeconds();
        if (this$expiresAfterSeconds == null ? other$expiresAfterSeconds != null : !this$expiresAfterSeconds.equals(other$expiresAfterSeconds)) return false;
        final java.lang.Object this$expiresAt = this.getExpiresAt();
        final java.lang.Object other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !this$expiresAt.equals(other$expiresAt)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Pix;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $expiresAfterSeconds = this.getExpiresAfterSeconds();
        result = result * PRIME + ($expiresAfterSeconds == null ? 43 : $expiresAfterSeconds.hashCode());
        final java.lang.Object $expiresAt = this.getExpiresAt();
        result = result * PRIME + ($expiresAt == null ? 43 : $expiresAt.hashCode());
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class Promptpay extends StripeObject {
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>Equal to {@code none}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Promptpay)) return false;
        final PaymentIntent.PaymentMethodOptions.Promptpay other = (PaymentIntent.PaymentMethodOptions.Promptpay) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Promptpay;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class SepaDebit extends StripeObject {
      @SerializedName("mandate_options")
      SepaDebitMandateOptions mandateOptions;
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public SepaDebitMandateOptions getMandateOptions() {
        return this.mandateOptions;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setMandateOptions(final SepaDebitMandateOptions mandateOptions) {
        this.mandateOptions = mandateOptions;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.SepaDebit)) return false;
        final PaymentIntent.PaymentMethodOptions.SepaDebit other = (PaymentIntent.PaymentMethodOptions.SepaDebit) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$mandateOptions = this.getMandateOptions();
        final java.lang.Object other$mandateOptions = other.getMandateOptions();
        if (this$mandateOptions == null ? other$mandateOptions != null : !this$mandateOptions.equals(other$mandateOptions)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.SepaDebit;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $mandateOptions = this.getMandateOptions();
        result = result * PRIME + ($mandateOptions == null ? 43 : $mandateOptions.hashCode());
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class SepaDebitMandateOptions extends StripeObject {
      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.SepaDebitMandateOptions)) return false;
        final PaymentIntent.PaymentMethodOptions.SepaDebitMandateOptions other = (PaymentIntent.PaymentMethodOptions.SepaDebitMandateOptions) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.SepaDebitMandateOptions;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int result = 1;
        return result;
      }
    }


    public static class Sofort extends StripeObject {
      /**
       * Preferred language of the SOFORT authorization page that the customer is redirected to.
       *
       * <p>One of {@code de}, {@code en}, {@code es}, {@code fr}, {@code it}, {@code nl}, or {@code
       * pl}.
       */
      @SerializedName("preferred_language")
      String preferredLanguage;
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, or {@code off_session}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      /**
       * Preferred language of the SOFORT authorization page that the customer is redirected to.
       *
       * <p>One of {@code de}, {@code en}, {@code es}, {@code fr}, {@code it}, {@code nl}, or {@code
       * pl}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getPreferredLanguage() {
        return this.preferredLanguage;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, or {@code off_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Preferred language of the SOFORT authorization page that the customer is redirected to.
       *
       * <p>One of {@code de}, {@code en}, {@code es}, {@code fr}, {@code it}, {@code nl}, or {@code
       * pl}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPreferredLanguage(final String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, or {@code off_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.Sofort)) return false;
        final PaymentIntent.PaymentMethodOptions.Sofort other = (PaymentIntent.PaymentMethodOptions.Sofort) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$preferredLanguage = this.getPreferredLanguage();
        final java.lang.Object other$preferredLanguage = other.getPreferredLanguage();
        if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.Sofort;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $preferredLanguage = this.getPreferredLanguage();
        result = result * PRIME + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }


    public static class UsBankAccount extends StripeObject {
      @SerializedName("financial_connections")
      FinancialConnections financialConnections;
      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @SerializedName("setup_future_usage")
      String setupFutureUsage;
      /**
       * Bank account verification method.
       *
       * <p>One of {@code automatic}, {@code instant}, or {@code microdeposits}.
       */
      @SerializedName("verification_method")
      String verificationMethod;


      public static class FinancialConnections extends StripeObject {
        /**
         * The list of permissions to request. The {@code payment_method} permission must be
         * included.
         */
        @SerializedName("permissions")
        List<String> permissions;
        @SerializedName("return_url")
        String returnUrl;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<String> getPermissions() {
          return this.permissions;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getReturnUrl() {
          return this.returnUrl;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setPermissions(final List<String> permissions) {
          this.permissions = permissions;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setReturnUrl(final String returnUrl) {
          this.returnUrl = returnUrl;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentIntent.PaymentMethodOptions.UsBankAccount.FinancialConnections)) return false;
          final PaymentIntent.PaymentMethodOptions.UsBankAccount.FinancialConnections other = (PaymentIntent.PaymentMethodOptions.UsBankAccount.FinancialConnections) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$permissions = this.getPermissions();
          final java.lang.Object other$permissions = other.getPermissions();
          if (this$permissions == null ? other$permissions != null : !this$permissions.equals(other$permissions)) return false;
          final java.lang.Object this$returnUrl = this.getReturnUrl();
          final java.lang.Object other$returnUrl = other.getReturnUrl();
          if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentIntent.PaymentMethodOptions.UsBankAccount.FinancialConnections;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $permissions = this.getPermissions();
          result = result * PRIME + ($permissions == null ? 43 : $permissions.hashCode());
          final java.lang.Object $returnUrl = this.getReturnUrl();
          result = result * PRIME + ($returnUrl == null ? 43 : $returnUrl.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public FinancialConnections getFinancialConnections() {
        return this.financialConnections;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      /**
       * Bank account verification method.
       *
       * <p>One of {@code automatic}, {@code instant}, or {@code microdeposits}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getVerificationMethod() {
        return this.verificationMethod;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFinancialConnections(final FinancialConnections financialConnections) {
        this.financialConnections = financialConnections;
      }

      /**
       * Indicates that you intend to make future payments with this PaymentIntent's payment method.
       *
       * <p>Providing this parameter will <a
       * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
       * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
       * required actions from the user are complete. If no Customer was provided, the payment
       * method can still be <a
       * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
       * the transaction completes.
       *
       * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
       * dynamically optimize your payment flow and comply with regional legislation and network
       * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
       *
       * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      /**
       * Bank account verification method.
       *
       * <p>One of {@code automatic}, {@code instant}, or {@code microdeposits}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setVerificationMethod(final String verificationMethod) {
        this.verificationMethod = verificationMethod;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.UsBankAccount)) return false;
        final PaymentIntent.PaymentMethodOptions.UsBankAccount other = (PaymentIntent.PaymentMethodOptions.UsBankAccount) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$financialConnections = this.getFinancialConnections();
        final java.lang.Object other$financialConnections = other.getFinancialConnections();
        if (this$financialConnections == null ? other$financialConnections != null : !this$financialConnections.equals(other$financialConnections)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        final java.lang.Object this$verificationMethod = this.getVerificationMethod();
        final java.lang.Object other$verificationMethod = other.getVerificationMethod();
        if (this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.UsBankAccount;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $financialConnections = this.getFinancialConnections();
        result = result * PRIME + ($financialConnections == null ? 43 : $financialConnections.hashCode());
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        final java.lang.Object $verificationMethod = this.getVerificationMethod();
        result = result * PRIME + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
        return result;
      }
    }


    /**
     * For webview integrations only. Upon completing OAuth login in the native browser, the
     * user will be redirected to this URL to return to your app.
     */
    public static class WechatPay extends StripeObject {
      /** The app ID registered with WeChat Pay. Only required when client is ios or android. */
      @SerializedName("app_id")
      String appId;
      /**
       * The client type that the end customer will pay from
       *
       * <p>One of {@code android}, {@code ios}, or {@code web}.
       */
      @SerializedName("client")
      String client;
      @SerializedName("setup_future_usage")
      String setupFutureUsage;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAppId() {
        return this.appId;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getClient() {
        return this.client;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getSetupFutureUsage() {
        return this.setupFutureUsage;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAppId(final String appId) {
        this.appId = appId;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setClient(final String client) {
        this.client = client;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSetupFutureUsage(final String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.PaymentMethodOptions.WechatPay)) return false;
        final PaymentIntent.PaymentMethodOptions.WechatPay other = (PaymentIntent.PaymentMethodOptions.WechatPay) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$appId = this.getAppId();
        final java.lang.Object other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) return false;
        final java.lang.Object this$client = this.getClient();
        final java.lang.Object other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) return false;
        final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
        final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.PaymentMethodOptions.WechatPay;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $appId = this.getAppId();
        result = result * PRIME + ($appId == null ? 43 : $appId.hashCode());
        final java.lang.Object $client = this.getClient();
        result = result * PRIME + ($client == null ? 43 : $client.hashCode());
        final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
        result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AcssDebit getAcssDebit() {
      return this.acssDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Affirm getAffirm() {
      return this.affirm;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AfterpayClearpay getAfterpayClearpay() {
      return this.afterpayClearpay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Alipay getAlipay() {
      return this.alipay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuBecsDebit getAuBecsDebit() {
      return this.auBecsDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BacsDebit getBacsDebit() {
      return this.bacsDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Bancontact getBancontact() {
      return this.bancontact;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Blik getBlik() {
      return this.blik;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boleto getBoleto() {
      return this.boleto;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Card getCard() {
      return this.card;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CardPresent getCardPresent() {
      return this.cardPresent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CustomerBalance getCustomerBalance() {
      return this.customerBalance;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Eps getEps() {
      return this.eps;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Fpx getFpx() {
      return this.fpx;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Giropay getGiropay() {
      return this.giropay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Grabpay getGrabpay() {
      return this.grabpay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Ideal getIdeal() {
      return this.ideal;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public InteracPresent getInteracPresent() {
      return this.interacPresent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Klarna getKlarna() {
      return this.klarna;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Konbini getKonbini() {
      return this.konbini;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Link getLink() {
      return this.link;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Oxxo getOxxo() {
      return this.oxxo;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public P24 getP24() {
      return this.p24;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Paynow getPaynow() {
      return this.paynow;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Pix getPix() {
      return this.pix;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Promptpay getPromptpay() {
      return this.promptpay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SepaDebit getSepaDebit() {
      return this.sepaDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Sofort getSofort() {
      return this.sofort;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UsBankAccount getUsBankAccount() {
      return this.usBankAccount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WechatPay getWechatPay() {
      return this.wechatPay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAcssDebit(final AcssDebit acssDebit) {
      this.acssDebit = acssDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAffirm(final Affirm affirm) {
      this.affirm = affirm;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAfterpayClearpay(final AfterpayClearpay afterpayClearpay) {
      this.afterpayClearpay = afterpayClearpay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAlipay(final Alipay alipay) {
      this.alipay = alipay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAuBecsDebit(final AuBecsDebit auBecsDebit) {
      this.auBecsDebit = auBecsDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBacsDebit(final BacsDebit bacsDebit) {
      this.bacsDebit = bacsDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBancontact(final Bancontact bancontact) {
      this.bancontact = bancontact;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBlik(final Blik blik) {
      this.blik = blik;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBoleto(final Boleto boleto) {
      this.boleto = boleto;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCard(final Card card) {
      this.card = card;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCardPresent(final CardPresent cardPresent) {
      this.cardPresent = cardPresent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCustomerBalance(final CustomerBalance customerBalance) {
      this.customerBalance = customerBalance;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEps(final Eps eps) {
      this.eps = eps;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFpx(final Fpx fpx) {
      this.fpx = fpx;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setGiropay(final Giropay giropay) {
      this.giropay = giropay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setGrabpay(final Grabpay grabpay) {
      this.grabpay = grabpay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIdeal(final Ideal ideal) {
      this.ideal = ideal;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInteracPresent(final InteracPresent interacPresent) {
      this.interacPresent = interacPresent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setKlarna(final Klarna klarna) {
      this.klarna = klarna;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setKonbini(final Konbini konbini) {
      this.konbini = konbini;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLink(final Link link) {
      this.link = link;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOxxo(final Oxxo oxxo) {
      this.oxxo = oxxo;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setP24(final P24 p24) {
      this.p24 = p24;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPaynow(final Paynow paynow) {
      this.paynow = paynow;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPix(final Pix pix) {
      this.pix = pix;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPromptpay(final Promptpay promptpay) {
      this.promptpay = promptpay;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSepaDebit(final SepaDebit sepaDebit) {
      this.sepaDebit = sepaDebit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSofort(final Sofort sofort) {
      this.sofort = sofort;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUsBankAccount(final UsBankAccount usBankAccount) {
      this.usBankAccount = usBankAccount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setWechatPay(final WechatPay wechatPay) {
      this.wechatPay = wechatPay;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.PaymentMethodOptions)) return false;
      final PaymentIntent.PaymentMethodOptions other = (PaymentIntent.PaymentMethodOptions) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$acssDebit = this.getAcssDebit();
      final java.lang.Object other$acssDebit = other.getAcssDebit();
      if (this$acssDebit == null ? other$acssDebit != null : !this$acssDebit.equals(other$acssDebit)) return false;
      final java.lang.Object this$affirm = this.getAffirm();
      final java.lang.Object other$affirm = other.getAffirm();
      if (this$affirm == null ? other$affirm != null : !this$affirm.equals(other$affirm)) return false;
      final java.lang.Object this$afterpayClearpay = this.getAfterpayClearpay();
      final java.lang.Object other$afterpayClearpay = other.getAfterpayClearpay();
      if (this$afterpayClearpay == null ? other$afterpayClearpay != null : !this$afterpayClearpay.equals(other$afterpayClearpay)) return false;
      final java.lang.Object this$alipay = this.getAlipay();
      final java.lang.Object other$alipay = other.getAlipay();
      if (this$alipay == null ? other$alipay != null : !this$alipay.equals(other$alipay)) return false;
      final java.lang.Object this$auBecsDebit = this.getAuBecsDebit();
      final java.lang.Object other$auBecsDebit = other.getAuBecsDebit();
      if (this$auBecsDebit == null ? other$auBecsDebit != null : !this$auBecsDebit.equals(other$auBecsDebit)) return false;
      final java.lang.Object this$bacsDebit = this.getBacsDebit();
      final java.lang.Object other$bacsDebit = other.getBacsDebit();
      if (this$bacsDebit == null ? other$bacsDebit != null : !this$bacsDebit.equals(other$bacsDebit)) return false;
      final java.lang.Object this$bancontact = this.getBancontact();
      final java.lang.Object other$bancontact = other.getBancontact();
      if (this$bancontact == null ? other$bancontact != null : !this$bancontact.equals(other$bancontact)) return false;
      final java.lang.Object this$blik = this.getBlik();
      final java.lang.Object other$blik = other.getBlik();
      if (this$blik == null ? other$blik != null : !this$blik.equals(other$blik)) return false;
      final java.lang.Object this$boleto = this.getBoleto();
      final java.lang.Object other$boleto = other.getBoleto();
      if (this$boleto == null ? other$boleto != null : !this$boleto.equals(other$boleto)) return false;
      final java.lang.Object this$card = this.getCard();
      final java.lang.Object other$card = other.getCard();
      if (this$card == null ? other$card != null : !this$card.equals(other$card)) return false;
      final java.lang.Object this$cardPresent = this.getCardPresent();
      final java.lang.Object other$cardPresent = other.getCardPresent();
      if (this$cardPresent == null ? other$cardPresent != null : !this$cardPresent.equals(other$cardPresent)) return false;
      final java.lang.Object this$customerBalance = this.getCustomerBalance();
      final java.lang.Object other$customerBalance = other.getCustomerBalance();
      if (this$customerBalance == null ? other$customerBalance != null : !this$customerBalance.equals(other$customerBalance)) return false;
      final java.lang.Object this$eps = this.getEps();
      final java.lang.Object other$eps = other.getEps();
      if (this$eps == null ? other$eps != null : !this$eps.equals(other$eps)) return false;
      final java.lang.Object this$fpx = this.getFpx();
      final java.lang.Object other$fpx = other.getFpx();
      if (this$fpx == null ? other$fpx != null : !this$fpx.equals(other$fpx)) return false;
      final java.lang.Object this$giropay = this.getGiropay();
      final java.lang.Object other$giropay = other.getGiropay();
      if (this$giropay == null ? other$giropay != null : !this$giropay.equals(other$giropay)) return false;
      final java.lang.Object this$grabpay = this.getGrabpay();
      final java.lang.Object other$grabpay = other.getGrabpay();
      if (this$grabpay == null ? other$grabpay != null : !this$grabpay.equals(other$grabpay)) return false;
      final java.lang.Object this$ideal = this.getIdeal();
      final java.lang.Object other$ideal = other.getIdeal();
      if (this$ideal == null ? other$ideal != null : !this$ideal.equals(other$ideal)) return false;
      final java.lang.Object this$interacPresent = this.getInteracPresent();
      final java.lang.Object other$interacPresent = other.getInteracPresent();
      if (this$interacPresent == null ? other$interacPresent != null : !this$interacPresent.equals(other$interacPresent)) return false;
      final java.lang.Object this$klarna = this.getKlarna();
      final java.lang.Object other$klarna = other.getKlarna();
      if (this$klarna == null ? other$klarna != null : !this$klarna.equals(other$klarna)) return false;
      final java.lang.Object this$konbini = this.getKonbini();
      final java.lang.Object other$konbini = other.getKonbini();
      if (this$konbini == null ? other$konbini != null : !this$konbini.equals(other$konbini)) return false;
      final java.lang.Object this$link = this.getLink();
      final java.lang.Object other$link = other.getLink();
      if (this$link == null ? other$link != null : !this$link.equals(other$link)) return false;
      final java.lang.Object this$oxxo = this.getOxxo();
      final java.lang.Object other$oxxo = other.getOxxo();
      if (this$oxxo == null ? other$oxxo != null : !this$oxxo.equals(other$oxxo)) return false;
      final java.lang.Object this$p24 = this.getP24();
      final java.lang.Object other$p24 = other.getP24();
      if (this$p24 == null ? other$p24 != null : !this$p24.equals(other$p24)) return false;
      final java.lang.Object this$paynow = this.getPaynow();
      final java.lang.Object other$paynow = other.getPaynow();
      if (this$paynow == null ? other$paynow != null : !this$paynow.equals(other$paynow)) return false;
      final java.lang.Object this$pix = this.getPix();
      final java.lang.Object other$pix = other.getPix();
      if (this$pix == null ? other$pix != null : !this$pix.equals(other$pix)) return false;
      final java.lang.Object this$promptpay = this.getPromptpay();
      final java.lang.Object other$promptpay = other.getPromptpay();
      if (this$promptpay == null ? other$promptpay != null : !this$promptpay.equals(other$promptpay)) return false;
      final java.lang.Object this$sepaDebit = this.getSepaDebit();
      final java.lang.Object other$sepaDebit = other.getSepaDebit();
      if (this$sepaDebit == null ? other$sepaDebit != null : !this$sepaDebit.equals(other$sepaDebit)) return false;
      final java.lang.Object this$sofort = this.getSofort();
      final java.lang.Object other$sofort = other.getSofort();
      if (this$sofort == null ? other$sofort != null : !this$sofort.equals(other$sofort)) return false;
      final java.lang.Object this$usBankAccount = this.getUsBankAccount();
      final java.lang.Object other$usBankAccount = other.getUsBankAccount();
      if (this$usBankAccount == null ? other$usBankAccount != null : !this$usBankAccount.equals(other$usBankAccount)) return false;
      final java.lang.Object this$wechatPay = this.getWechatPay();
      final java.lang.Object other$wechatPay = other.getWechatPay();
      if (this$wechatPay == null ? other$wechatPay != null : !this$wechatPay.equals(other$wechatPay)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.PaymentMethodOptions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $acssDebit = this.getAcssDebit();
      result = result * PRIME + ($acssDebit == null ? 43 : $acssDebit.hashCode());
      final java.lang.Object $affirm = this.getAffirm();
      result = result * PRIME + ($affirm == null ? 43 : $affirm.hashCode());
      final java.lang.Object $afterpayClearpay = this.getAfterpayClearpay();
      result = result * PRIME + ($afterpayClearpay == null ? 43 : $afterpayClearpay.hashCode());
      final java.lang.Object $alipay = this.getAlipay();
      result = result * PRIME + ($alipay == null ? 43 : $alipay.hashCode());
      final java.lang.Object $auBecsDebit = this.getAuBecsDebit();
      result = result * PRIME + ($auBecsDebit == null ? 43 : $auBecsDebit.hashCode());
      final java.lang.Object $bacsDebit = this.getBacsDebit();
      result = result * PRIME + ($bacsDebit == null ? 43 : $bacsDebit.hashCode());
      final java.lang.Object $bancontact = this.getBancontact();
      result = result * PRIME + ($bancontact == null ? 43 : $bancontact.hashCode());
      final java.lang.Object $blik = this.getBlik();
      result = result * PRIME + ($blik == null ? 43 : $blik.hashCode());
      final java.lang.Object $boleto = this.getBoleto();
      result = result * PRIME + ($boleto == null ? 43 : $boleto.hashCode());
      final java.lang.Object $card = this.getCard();
      result = result * PRIME + ($card == null ? 43 : $card.hashCode());
      final java.lang.Object $cardPresent = this.getCardPresent();
      result = result * PRIME + ($cardPresent == null ? 43 : $cardPresent.hashCode());
      final java.lang.Object $customerBalance = this.getCustomerBalance();
      result = result * PRIME + ($customerBalance == null ? 43 : $customerBalance.hashCode());
      final java.lang.Object $eps = this.getEps();
      result = result * PRIME + ($eps == null ? 43 : $eps.hashCode());
      final java.lang.Object $fpx = this.getFpx();
      result = result * PRIME + ($fpx == null ? 43 : $fpx.hashCode());
      final java.lang.Object $giropay = this.getGiropay();
      result = result * PRIME + ($giropay == null ? 43 : $giropay.hashCode());
      final java.lang.Object $grabpay = this.getGrabpay();
      result = result * PRIME + ($grabpay == null ? 43 : $grabpay.hashCode());
      final java.lang.Object $ideal = this.getIdeal();
      result = result * PRIME + ($ideal == null ? 43 : $ideal.hashCode());
      final java.lang.Object $interacPresent = this.getInteracPresent();
      result = result * PRIME + ($interacPresent == null ? 43 : $interacPresent.hashCode());
      final java.lang.Object $klarna = this.getKlarna();
      result = result * PRIME + ($klarna == null ? 43 : $klarna.hashCode());
      final java.lang.Object $konbini = this.getKonbini();
      result = result * PRIME + ($konbini == null ? 43 : $konbini.hashCode());
      final java.lang.Object $link = this.getLink();
      result = result * PRIME + ($link == null ? 43 : $link.hashCode());
      final java.lang.Object $oxxo = this.getOxxo();
      result = result * PRIME + ($oxxo == null ? 43 : $oxxo.hashCode());
      final java.lang.Object $p24 = this.getP24();
      result = result * PRIME + ($p24 == null ? 43 : $p24.hashCode());
      final java.lang.Object $paynow = this.getPaynow();
      result = result * PRIME + ($paynow == null ? 43 : $paynow.hashCode());
      final java.lang.Object $pix = this.getPix();
      result = result * PRIME + ($pix == null ? 43 : $pix.hashCode());
      final java.lang.Object $promptpay = this.getPromptpay();
      result = result * PRIME + ($promptpay == null ? 43 : $promptpay.hashCode());
      final java.lang.Object $sepaDebit = this.getSepaDebit();
      result = result * PRIME + ($sepaDebit == null ? 43 : $sepaDebit.hashCode());
      final java.lang.Object $sofort = this.getSofort();
      result = result * PRIME + ($sofort == null ? 43 : $sofort.hashCode());
      final java.lang.Object $usBankAccount = this.getUsBankAccount();
      result = result * PRIME + ($usBankAccount == null ? 43 : $usBankAccount.hashCode());
      final java.lang.Object $wechatPay = this.getWechatPay();
      result = result * PRIME + ($wechatPay == null ? 43 : $wechatPay.hashCode());
      return result;
    }
  }


  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * <p>Providing this parameter will <a
   * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a>
   * to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any
   * required actions from the user are complete. If no Customer was provided, the payment
   * method can still be <a
   * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer after
   * the transaction completes.
   *
   * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
   * dynamically optimize your payment flow and comply with regional legislation and network
   * rules, such as <a href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
   *
   * <p>Equal to {@code none}.
   */
  public static class Processing extends StripeObject {
    @SerializedName("card")
    Card card;
    /**
     * Type of the payment method for which payment is in {@code processing} state, one of {@code
     * card}.
     */
    @SerializedName("type")
    String type;


    public static class Card extends StripeObject {
      @SerializedName("customer_notification")
      CustomerNotification customerNotification;


      public static class CustomerNotification extends StripeObject {
        /**
         * Whether customer approval has been requested for this payment. For payments greater than
         * INR 15000 or mandate amount, the customer must provide explicit approval of the payment
         * with their bank.
         */
        @SerializedName("approval_requested")
        Boolean approvalRequested;
        @SerializedName("completes_at")
        Long completesAt;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getApprovalRequested() {
          return this.approvalRequested;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getCompletesAt() {
          return this.completesAt;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setApprovalRequested(final Boolean approvalRequested) {
          this.approvalRequested = approvalRequested;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCompletesAt(final Long completesAt) {
          this.completesAt = completesAt;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof PaymentIntent.Processing.Card.CustomerNotification)) return false;
          final PaymentIntent.Processing.Card.CustomerNotification other = (PaymentIntent.Processing.Card.CustomerNotification) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$approvalRequested = this.getApprovalRequested();
          final java.lang.Object other$approvalRequested = other.getApprovalRequested();
          if (this$approvalRequested == null ? other$approvalRequested != null : !this$approvalRequested.equals(other$approvalRequested)) return false;
          final java.lang.Object this$completesAt = this.getCompletesAt();
          final java.lang.Object other$completesAt = other.getCompletesAt();
          if (this$completesAt == null ? other$completesAt != null : !this$completesAt.equals(other$completesAt)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof PaymentIntent.Processing.Card.CustomerNotification;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $approvalRequested = this.getApprovalRequested();
          result = result * PRIME + ($approvalRequested == null ? 43 : $approvalRequested.hashCode());
          final java.lang.Object $completesAt = this.getCompletesAt();
          result = result * PRIME + ($completesAt == null ? 43 : $completesAt.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public CustomerNotification getCustomerNotification() {
        return this.customerNotification;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCustomerNotification(final CustomerNotification customerNotification) {
        this.customerNotification = customerNotification;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentIntent.Processing.Card)) return false;
        final PaymentIntent.Processing.Card other = (PaymentIntent.Processing.Card) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$customerNotification = this.getCustomerNotification();
        final java.lang.Object other$customerNotification = other.getCustomerNotification();
        if (this$customerNotification == null ? other$customerNotification != null : !this$customerNotification.equals(other$customerNotification)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentIntent.Processing.Card;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $customerNotification = this.getCustomerNotification();
        result = result * PRIME + ($customerNotification == null ? 43 : $customerNotification.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Card getCard() {
      return this.card;
    }

    /**
     * Type of the payment method for which payment is in {@code processing} state, one of {@code
     * card}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCard(final Card card) {
      this.card = card;
    }

    /**
     * Type of the payment method for which payment is in {@code processing} state, one of {@code
     * card}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.Processing)) return false;
      final PaymentIntent.Processing other = (PaymentIntent.Processing) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$card = this.getCard();
      final java.lang.Object other$card = other.getCard();
      if (this$card == null ? other$card != null : !this$card.equals(other$card)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.Processing;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $card = this.getCard();
      result = result * PRIME + ($card == null ? 43 : $card.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }


  /**
   * If customer approval is required, they need to provide approval before this time.
   */
  public static class TransferData extends StripeObject {
    /**
     * Amount intended to be collected by this PaymentIntent. A positive integer representing how
     * much to charge in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest
     * currency unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal
     * currency). The minimum amount is $0.50 US or <a
     * href="https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts">equivalent in
     * charge currency</a>. The amount value supports up to eight digits (e.g., a value of 99999999
     * for a USD charge of $999,999.99).
     */
    @SerializedName("amount")
    Long amount;
    /**
     * The account (if any) the payment will be attributed to for tax reporting, and where funds
     * from the payment will be transferred to upon payment success.
     */
    @SerializedName("destination")
    ExpandableField<Account> destination;

    /** Get ID of expandable {@code destination} object. */
    public String getDestination() {
      return (this.destination != null) ? this.destination.getId() : null;
    }

    public void setDestination(String id) {
      this.destination = ApiResource.setExpandableFieldId(id, this.destination);
    }

    /** Get expanded {@code destination}. */
    public Account getDestinationObject() {
      return (this.destination != null) ? this.destination.getExpanded() : null;
    }

    public void setDestinationObject(Account expandableObject) {
      this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentIntent.TransferData)) return false;
      final PaymentIntent.TransferData other = (PaymentIntent.TransferData) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$destination = this.getDestination();
      final java.lang.Object other$destination = other.getDestination();
      if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentIntent.TransferData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $destination = this.getDestination();
      result = result * PRIME + ($destination == null ? 43 : $destination.hashCode());
      return result;
    }
  }

  /**
   * Amount intended to be collected by this PaymentIntent. A positive integer representing how much
   * to charge in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
   * unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The
   * minimum amount is $0.50 US or <a
   * href="https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts">equivalent in
   * charge currency</a>. The amount value supports up to eight digits (e.g., a value of 99999999
   * for a USD charge of $999,999.99).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Amount that can be captured from this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountCapturable() {
    return this.amountCapturable;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AmountDetails getAmountDetails() {
    return this.amountDetails;
  }

  /**
   * Amount that was collected by this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountReceived() {
    return this.amountReceived;
  }

  /**
   * The amount of the application fee (if any) that will be requested to be applied to the payment
   * and transferred to the application owner's Stripe account. The amount of the application fee
   * collected will be capped at the total payment amount. For more information, see the
   * PaymentIntents <a href="https://stripe.com/docs/payments/connected-accounts">use case for
   * connected accounts</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getApplicationFeeAmount() {
    return this.applicationFeeAmount;
  }

  /**
   * Settings to configure compatible payment methods from the <a
   * href="https://dashboard.stripe.com/settings/payment_methods">Stripe Dashboard.</a>
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AutomaticPaymentMethodsPaymentIntent getAutomaticPaymentMethods() {
    return this.automaticPaymentMethods;
  }

  /**
   * Populated when {@code status} is {@code canceled}, this is the time at which the PaymentIntent
   * was canceled. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCanceledAt() {
    return this.canceledAt;
  }

  /**
   * Reason for cancellation of this PaymentIntent, either user-provided ({@code duplicate}, {@code
   * fraudulent}, {@code requested_by_customer}, or {@code abandoned}) or generated by Stripe
   * internally ({@code failed_invoice}, {@code void_invoice}, or {@code automatic}).
   *
   * <p>One of {@code abandoned}, {@code automatic}, {@code duplicate}, {@code failed_invoice},
   * {@code fraudulent}, {@code requested_by_customer}, or {@code void_invoice}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCancellationReason() {
    return this.cancellationReason;
  }

  /**
   * Controls when the funds will be captured from the customer's account.
   *
   * <p>One of {@code automatic}, or {@code manual}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCaptureMethod() {
    return this.captureMethod;
  }

  /**
   * Charges that were created by this PaymentIntent, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ChargeCollection getCharges() {
    return this.charges;
  }

  /**
   * The client secret of this PaymentIntent. Used for client-side retrieval using a publishable
   * key.
   *
   * <p>The client secret can be used to complete a payment from your frontend. It should not be
   * stored, logged, or exposed to anyone other than the customer. Make sure that you have TLS
   * enabled on any page that includes the client secret.
   *
   * <p>Refer to our docs to <a
   * href="https://stripe.com/docs/payments/accept-a-payment?ui=elements">accept a payment</a> and
   * learn about how {@code client_secret} should be handled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getClientSecret() {
    return this.clientSecret;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getConfirmationMethod() {
    return this.confirmationMethod;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * The payment error encountered in the previous PaymentIntent confirmation. It will be cleared if
   * the PaymentIntent is later updated for any reason.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public StripeError getLastPaymentError() {
    return this.lastPaymentError;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * If present, this property tells you what actions you need to take in order for your customer to
   * fulfill a payment using the provided source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public NextAction getNextAction() {
    return this.nextAction;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code payment_intent}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Payment-method-specific configuration for this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PaymentMethodOptions getPaymentMethodOptions() {
    return this.paymentMethodOptions;
  }

  /**
   * The list of payment method types (e.g. card) that this PaymentIntent is allowed to use.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getPaymentMethodTypes() {
    return this.paymentMethodTypes;
  }

  /**
   * If present, this property tells you about the processing state of the payment.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Processing getProcessing() {
    return this.processing;
  }

  /**
   * Email address that the receipt for the resulting payment will be sent to. If {@code
   * receipt_email} is specified for a payment in live mode, a receipt will be sent regardless of
   * your <a href="https://dashboard.stripe.com/account/emails">email settings</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReceiptEmail() {
    return this.receiptEmail;
  }

  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * <p>Providing this parameter will <a
   * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a> to
   * the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required
   * actions from the user are complete. If no Customer was provided, the payment method can still
   * be <a href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
   * after the transaction completes.
   *
   * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to dynamically
   * optimize your payment flow and comply with regional legislation and network rules, such as <a
   * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
   *
   * <p>One of {@code off_session}, or {@code on_session}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSetupFutureUsage() {
    return this.setupFutureUsage;
  }

  /**
   * Shipping information for this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ShippingDetails getShipping() {
    return this.shipping;
  }

  /**
   * For non-card charges, you can use this value as the complete description that appears on your
   * customers’ statements. Must contain at least one letter, maximum 22 characters.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatementDescriptor() {
    return this.statementDescriptor;
  }

  /**
   * Provides information about a card payment that customers see on their statements. Concatenated
   * with the prefix (shortened descriptor) or statement descriptor that’s set on the account to
   * form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatementDescriptorSuffix() {
    return this.statementDescriptorSuffix;
  }

  /**
   * Status of this PaymentIntent, one of {@code requires_payment_method}, {@code
   * requires_confirmation}, {@code requires_action}, {@code processing}, {@code requires_capture},
   * {@code canceled}, or {@code succeeded}. Read more about each PaymentIntent <a
   * href="https://stripe.com/docs/payments/intents#intent-statuses">status</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * The data with which to automatically create a Transfer when the payment is finalized. See the
   * PaymentIntents <a href="https://stripe.com/docs/payments/connected-accounts">use case for
   * connected accounts</a> for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TransferData getTransferData() {
    return this.transferData;
  }

  /**
   * A string that identifies the resulting payment as part of a group. See the PaymentIntents <a
   * href="https://stripe.com/docs/payments/connected-accounts">use case for connected accounts</a>
   * for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTransferGroup() {
    return this.transferGroup;
  }

  /**
   * Amount intended to be collected by this PaymentIntent. A positive integer representing how much
   * to charge in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest currency
   * unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The
   * minimum amount is $0.50 US or <a
   * href="https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts">equivalent in
   * charge currency</a>. The amount value supports up to eight digits (e.g., a value of 99999999
   * for a USD charge of $999,999.99).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Amount that can be captured from this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountCapturable(final Long amountCapturable) {
    this.amountCapturable = amountCapturable;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountDetails(final AmountDetails amountDetails) {
    this.amountDetails = amountDetails;
  }

  /**
   * Amount that was collected by this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountReceived(final Long amountReceived) {
    this.amountReceived = amountReceived;
  }

  /**
   * The amount of the application fee (if any) that will be requested to be applied to the payment
   * and transferred to the application owner's Stripe account. The amount of the application fee
   * collected will be capped at the total payment amount. For more information, see the
   * PaymentIntents <a href="https://stripe.com/docs/payments/connected-accounts">use case for
   * connected accounts</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApplicationFeeAmount(final Long applicationFeeAmount) {
    this.applicationFeeAmount = applicationFeeAmount;
  }

  /**
   * Settings to configure compatible payment methods from the <a
   * href="https://dashboard.stripe.com/settings/payment_methods">Stripe Dashboard.</a>
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAutomaticPaymentMethods(final AutomaticPaymentMethodsPaymentIntent automaticPaymentMethods) {
    this.automaticPaymentMethods = automaticPaymentMethods;
  }

  /**
   * Populated when {@code status} is {@code canceled}, this is the time at which the PaymentIntent
   * was canceled. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCanceledAt(final Long canceledAt) {
    this.canceledAt = canceledAt;
  }

  /**
   * Reason for cancellation of this PaymentIntent, either user-provided ({@code duplicate}, {@code
   * fraudulent}, {@code requested_by_customer}, or {@code abandoned}) or generated by Stripe
   * internally ({@code failed_invoice}, {@code void_invoice}, or {@code automatic}).
   *
   * <p>One of {@code abandoned}, {@code automatic}, {@code duplicate}, {@code failed_invoice},
   * {@code fraudulent}, {@code requested_by_customer}, or {@code void_invoice}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCancellationReason(final String cancellationReason) {
    this.cancellationReason = cancellationReason;
  }

  /**
   * Controls when the funds will be captured from the customer's account.
   *
   * <p>One of {@code automatic}, or {@code manual}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCaptureMethod(final String captureMethod) {
    this.captureMethod = captureMethod;
  }

  /**
   * Charges that were created by this PaymentIntent, if any.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCharges(final ChargeCollection charges) {
    this.charges = charges;
  }

  /**
   * The client secret of this PaymentIntent. Used for client-side retrieval using a publishable
   * key.
   *
   * <p>The client secret can be used to complete a payment from your frontend. It should not be
   * stored, logged, or exposed to anyone other than the customer. Make sure that you have TLS
   * enabled on any page that includes the client secret.
   *
   * <p>Refer to our docs to <a
   * href="https://stripe.com/docs/payments/accept-a-payment?ui=elements">accept a payment</a> and
   * learn about how {@code client_secret} should be handled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setClientSecret(final String clientSecret) {
    this.clientSecret = clientSecret;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setConfirmationMethod(final String confirmationMethod) {
    this.confirmationMethod = confirmationMethod;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The payment error encountered in the previous PaymentIntent confirmation. It will be cleared if
   * the PaymentIntent is later updated for any reason.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLastPaymentError(final StripeError lastPaymentError) {
    this.lastPaymentError = lastPaymentError;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format. For more information, see the <a
   * href="https://stripe.com/docs/payments/payment-intents/creating-payment-intents#storing-information-in-metadata">documentation</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * If present, this property tells you what actions you need to take in order for your customer to
   * fulfill a payment using the provided source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNextAction(final NextAction nextAction) {
    this.nextAction = nextAction;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code payment_intent}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Payment-method-specific configuration for this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentMethodOptions(final PaymentMethodOptions paymentMethodOptions) {
    this.paymentMethodOptions = paymentMethodOptions;
  }

  /**
   * The list of payment method types (e.g. card) that this PaymentIntent is allowed to use.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentMethodTypes(final List<String> paymentMethodTypes) {
    this.paymentMethodTypes = paymentMethodTypes;
  }

  /**
   * If present, this property tells you about the processing state of the payment.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProcessing(final Processing processing) {
    this.processing = processing;
  }

  /**
   * Email address that the receipt for the resulting payment will be sent to. If {@code
   * receipt_email} is specified for a payment in live mode, a receipt will be sent regardless of
   * your <a href="https://dashboard.stripe.com/account/emails">email settings</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReceiptEmail(final String receiptEmail) {
    this.receiptEmail = receiptEmail;
  }

  /**
   * Indicates that you intend to make future payments with this PaymentIntent's payment method.
   *
   * <p>Providing this parameter will <a
   * href="https://stripe.com/docs/payments/save-during-payment">attach the payment method</a> to
   * the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required
   * actions from the user are complete. If no Customer was provided, the payment method can still
   * be <a href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
   * after the transaction completes.
   *
   * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to dynamically
   * optimize your payment flow and comply with regional legislation and network rules, such as <a
   * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
   *
   * <p>One of {@code off_session}, or {@code on_session}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSetupFutureUsage(final String setupFutureUsage) {
    this.setupFutureUsage = setupFutureUsage;
  }

  /**
   * Shipping information for this PaymentIntent.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShipping(final ShippingDetails shipping) {
    this.shipping = shipping;
  }

  /**
   * For non-card charges, you can use this value as the complete description that appears on your
   * customers’ statements. Must contain at least one letter, maximum 22 characters.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatementDescriptor(final String statementDescriptor) {
    this.statementDescriptor = statementDescriptor;
  }

  /**
   * Provides information about a card payment that customers see on their statements. Concatenated
   * with the prefix (shortened descriptor) or statement descriptor that’s set on the account to
   * form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatementDescriptorSuffix(final String statementDescriptorSuffix) {
    this.statementDescriptorSuffix = statementDescriptorSuffix;
  }

  /**
   * Status of this PaymentIntent, one of {@code requires_payment_method}, {@code
   * requires_confirmation}, {@code requires_action}, {@code processing}, {@code requires_capture},
   * {@code canceled}, or {@code succeeded}. Read more about each PaymentIntent <a
   * href="https://stripe.com/docs/payments/intents#intent-statuses">status</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * The data with which to automatically create a Transfer when the payment is finalized. See the
   * PaymentIntents <a href="https://stripe.com/docs/payments/connected-accounts">use case for
   * connected accounts</a> for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferData(final TransferData transferData) {
    this.transferData = transferData;
  }

  /**
   * A string that identifies the resulting payment as part of a group. See the PaymentIntents <a
   * href="https://stripe.com/docs/payments/connected-accounts">use case for connected accounts</a>
   * for details.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferGroup(final String transferGroup) {
    this.transferGroup = transferGroup;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof PaymentIntent)) return false;
    final PaymentIntent other = (PaymentIntent) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$amountCapturable = this.getAmountCapturable();
    final java.lang.Object other$amountCapturable = other.getAmountCapturable();
    if (this$amountCapturable == null ? other$amountCapturable != null : !this$amountCapturable.equals(other$amountCapturable)) return false;
    final java.lang.Object this$amountReceived = this.getAmountReceived();
    final java.lang.Object other$amountReceived = other.getAmountReceived();
    if (this$amountReceived == null ? other$amountReceived != null : !this$amountReceived.equals(other$amountReceived)) return false;
    final java.lang.Object this$applicationFeeAmount = this.getApplicationFeeAmount();
    final java.lang.Object other$applicationFeeAmount = other.getApplicationFeeAmount();
    if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !this$applicationFeeAmount.equals(other$applicationFeeAmount)) return false;
    final java.lang.Object this$canceledAt = this.getCanceledAt();
    final java.lang.Object other$canceledAt = other.getCanceledAt();
    if (this$canceledAt == null ? other$canceledAt != null : !this$canceledAt.equals(other$canceledAt)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$amountDetails = this.getAmountDetails();
    final java.lang.Object other$amountDetails = other.getAmountDetails();
    if (this$amountDetails == null ? other$amountDetails != null : !this$amountDetails.equals(other$amountDetails)) return false;
    final java.lang.Object this$application = this.getApplication();
    final java.lang.Object other$application = other.getApplication();
    if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
    final java.lang.Object this$automaticPaymentMethods = this.getAutomaticPaymentMethods();
    final java.lang.Object other$automaticPaymentMethods = other.getAutomaticPaymentMethods();
    if (this$automaticPaymentMethods == null ? other$automaticPaymentMethods != null : !this$automaticPaymentMethods.equals(other$automaticPaymentMethods)) return false;
    final java.lang.Object this$cancellationReason = this.getCancellationReason();
    final java.lang.Object other$cancellationReason = other.getCancellationReason();
    if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) return false;
    final java.lang.Object this$captureMethod = this.getCaptureMethod();
    final java.lang.Object other$captureMethod = other.getCaptureMethod();
    if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) return false;
    final java.lang.Object this$charges = this.getCharges();
    final java.lang.Object other$charges = other.getCharges();
    if (this$charges == null ? other$charges != null : !this$charges.equals(other$charges)) return false;
    final java.lang.Object this$clientSecret = this.getClientSecret();
    final java.lang.Object other$clientSecret = other.getClientSecret();
    if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) return false;
    final java.lang.Object this$confirmationMethod = this.getConfirmationMethod();
    final java.lang.Object other$confirmationMethod = other.getConfirmationMethod();
    if (this$confirmationMethod == null ? other$confirmationMethod != null : !this$confirmationMethod.equals(other$confirmationMethod)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$invoice = this.getInvoice();
    final java.lang.Object other$invoice = other.getInvoice();
    if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) return false;
    final java.lang.Object this$lastPaymentError = this.getLastPaymentError();
    final java.lang.Object other$lastPaymentError = other.getLastPaymentError();
    if (this$lastPaymentError == null ? other$lastPaymentError != null : !this$lastPaymentError.equals(other$lastPaymentError)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$nextAction = this.getNextAction();
    final java.lang.Object other$nextAction = other.getNextAction();
    if (this$nextAction == null ? other$nextAction != null : !this$nextAction.equals(other$nextAction)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$onBehalfOf = this.getOnBehalfOf();
    final java.lang.Object other$onBehalfOf = other.getOnBehalfOf();
    if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) return false;
    final java.lang.Object this$paymentMethod = this.getPaymentMethod();
    final java.lang.Object other$paymentMethod = other.getPaymentMethod();
    if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) return false;
    final java.lang.Object this$paymentMethodOptions = this.getPaymentMethodOptions();
    final java.lang.Object other$paymentMethodOptions = other.getPaymentMethodOptions();
    if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !this$paymentMethodOptions.equals(other$paymentMethodOptions)) return false;
    final java.lang.Object this$paymentMethodTypes = this.getPaymentMethodTypes();
    final java.lang.Object other$paymentMethodTypes = other.getPaymentMethodTypes();
    if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !this$paymentMethodTypes.equals(other$paymentMethodTypes)) return false;
    final java.lang.Object this$processing = this.getProcessing();
    final java.lang.Object other$processing = other.getProcessing();
    if (this$processing == null ? other$processing != null : !this$processing.equals(other$processing)) return false;
    final java.lang.Object this$receiptEmail = this.getReceiptEmail();
    final java.lang.Object other$receiptEmail = other.getReceiptEmail();
    if (this$receiptEmail == null ? other$receiptEmail != null : !this$receiptEmail.equals(other$receiptEmail)) return false;
    final java.lang.Object this$review = this.getReview();
    final java.lang.Object other$review = other.getReview();
    if (this$review == null ? other$review != null : !this$review.equals(other$review)) return false;
    final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
    final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
    if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
    final java.lang.Object this$shipping = this.getShipping();
    final java.lang.Object other$shipping = other.getShipping();
    if (this$shipping == null ? other$shipping != null : !this$shipping.equals(other$shipping)) return false;
    final java.lang.Object this$source = this.getSource();
    final java.lang.Object other$source = other.getSource();
    if (this$source == null ? other$source != null : !this$source.equals(other$source)) return false;
    final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
    final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
    if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
    final java.lang.Object this$statementDescriptorSuffix = this.getStatementDescriptorSuffix();
    final java.lang.Object other$statementDescriptorSuffix = other.getStatementDescriptorSuffix();
    if (this$statementDescriptorSuffix == null ? other$statementDescriptorSuffix != null : !this$statementDescriptorSuffix.equals(other$statementDescriptorSuffix)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$transferData = this.getTransferData();
    final java.lang.Object other$transferData = other.getTransferData();
    if (this$transferData == null ? other$transferData != null : !this$transferData.equals(other$transferData)) return false;
    final java.lang.Object this$transferGroup = this.getTransferGroup();
    final java.lang.Object other$transferGroup = other.getTransferGroup();
    if (this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof PaymentIntent;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $amountCapturable = this.getAmountCapturable();
    result = result * PRIME + ($amountCapturable == null ? 43 : $amountCapturable.hashCode());
    final java.lang.Object $amountReceived = this.getAmountReceived();
    result = result * PRIME + ($amountReceived == null ? 43 : $amountReceived.hashCode());
    final java.lang.Object $applicationFeeAmount = this.getApplicationFeeAmount();
    result = result * PRIME + ($applicationFeeAmount == null ? 43 : $applicationFeeAmount.hashCode());
    final java.lang.Object $canceledAt = this.getCanceledAt();
    result = result * PRIME + ($canceledAt == null ? 43 : $canceledAt.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $amountDetails = this.getAmountDetails();
    result = result * PRIME + ($amountDetails == null ? 43 : $amountDetails.hashCode());
    final java.lang.Object $application = this.getApplication();
    result = result * PRIME + ($application == null ? 43 : $application.hashCode());
    final java.lang.Object $automaticPaymentMethods = this.getAutomaticPaymentMethods();
    result = result * PRIME + ($automaticPaymentMethods == null ? 43 : $automaticPaymentMethods.hashCode());
    final java.lang.Object $cancellationReason = this.getCancellationReason();
    result = result * PRIME + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
    final java.lang.Object $captureMethod = this.getCaptureMethod();
    result = result * PRIME + ($captureMethod == null ? 43 : $captureMethod.hashCode());
    final java.lang.Object $charges = this.getCharges();
    result = result * PRIME + ($charges == null ? 43 : $charges.hashCode());
    final java.lang.Object $clientSecret = this.getClientSecret();
    result = result * PRIME + ($clientSecret == null ? 43 : $clientSecret.hashCode());
    final java.lang.Object $confirmationMethod = this.getConfirmationMethod();
    result = result * PRIME + ($confirmationMethod == null ? 43 : $confirmationMethod.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $invoice = this.getInvoice();
    result = result * PRIME + ($invoice == null ? 43 : $invoice.hashCode());
    final java.lang.Object $lastPaymentError = this.getLastPaymentError();
    result = result * PRIME + ($lastPaymentError == null ? 43 : $lastPaymentError.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $nextAction = this.getNextAction();
    result = result * PRIME + ($nextAction == null ? 43 : $nextAction.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $onBehalfOf = this.getOnBehalfOf();
    result = result * PRIME + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
    final java.lang.Object $paymentMethod = this.getPaymentMethod();
    result = result * PRIME + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
    final java.lang.Object $paymentMethodOptions = this.getPaymentMethodOptions();
    result = result * PRIME + ($paymentMethodOptions == null ? 43 : $paymentMethodOptions.hashCode());
    final java.lang.Object $paymentMethodTypes = this.getPaymentMethodTypes();
    result = result * PRIME + ($paymentMethodTypes == null ? 43 : $paymentMethodTypes.hashCode());
    final java.lang.Object $processing = this.getProcessing();
    result = result * PRIME + ($processing == null ? 43 : $processing.hashCode());
    final java.lang.Object $receiptEmail = this.getReceiptEmail();
    result = result * PRIME + ($receiptEmail == null ? 43 : $receiptEmail.hashCode());
    final java.lang.Object $review = this.getReview();
    result = result * PRIME + ($review == null ? 43 : $review.hashCode());
    final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
    result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
    final java.lang.Object $shipping = this.getShipping();
    result = result * PRIME + ($shipping == null ? 43 : $shipping.hashCode());
    final java.lang.Object $source = this.getSource();
    result = result * PRIME + ($source == null ? 43 : $source.hashCode());
    final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
    result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
    final java.lang.Object $statementDescriptorSuffix = this.getStatementDescriptorSuffix();
    result = result * PRIME + ($statementDescriptorSuffix == null ? 43 : $statementDescriptorSuffix.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $transferData = this.getTransferData();
    result = result * PRIME + ($transferData == null ? 43 : $transferData.hashCode());
    final java.lang.Object $transferGroup = this.getTransferGroup();
    result = result * PRIME + ($transferGroup == null ? 43 : $transferGroup.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format. For more information, see the <a
   * href="https://stripe.com/docs/payments/payment-intents/creating-payment-intents#storing-information-in-metadata">documentation</a>.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
