// Generated by delombok at Thu Sep 29 15:26:29 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.treasury.TransactionListParams;
import com.stripe.param.treasury.TransactionRetrieveParams;
import java.util.Map;

/**
 * Transactions represent changes to a <a
 * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount's</a> balance.
 */
public class Transaction extends ApiResource implements HasId {
  /**
   * Amount (in cents) transferred.
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Change to a FinancialAccount's balance.
   */
  @SerializedName("balance_impact")
  BalanceImpact balanceImpact;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @SerializedName("description")
  String description;
  /**
   * A list of TransactionEntries that are part of this Transaction. This cannot be expanded in any
   * list endpoints.
   */
  @SerializedName("entries")
  TransactionEntryCollection entries;
  /**
   * The FinancialAccount associated with this object.
   */
  @SerializedName("financial_account")
  String financialAccount;
  /**
   * ID of the flow that created the Transaction.
   */
  @SerializedName("flow")
  String flow;
  /**
   * Details of the flow that created the Transaction.
   */
  @SerializedName("flow_details")
  FlowDetails flowDetails;
  /**
   * Type of the flow that created the Transaction.
   *
   * <p>One of {@code credit_reversal}, {@code debit_reversal}, {@code inbound_transfer}, {@code
   * issuing_authorization}, {@code other}, {@code outbound_payment}, {@code outbound_transfer},
   * {@code received_credit}, or {@code received_debit}.
   */
  @SerializedName("flow_type")
  String flowType;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.transaction}.
   */
  @SerializedName("object")
  String object;
  /**
   * Status of the Transaction.
   *
   * <p>One of {@code open}, {@code posted}, or {@code void}.
   */
  @SerializedName("status")
  String status;
  @SerializedName("status_transitions")
  StatusTransitions statusTransitions;

  /**
   * Retrieves a list of Transaction objects.
   */
  public static TransactionCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Retrieves a list of Transaction objects.
   */
  public static TransactionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/transactions");
    return ApiResource.requestCollection(url, params, TransactionCollection.class, options);
  }

  /**
   * Retrieves a list of Transaction objects.
   */
  public static TransactionCollection list(TransactionListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Retrieves a list of Transaction objects.
   */
  public static TransactionCollection list(TransactionListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/transactions");
    return ApiResource.requestCollection(url, params, TransactionCollection.class, options);
  }

  /**
   * Retrieves the details of an existing Transaction.
   */
  public static Transaction retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an existing Transaction.
   */
  public static Transaction retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an existing Transaction.
   */
  public static Transaction retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/transactions/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Transaction.class, options);
  }

  /**
   * Retrieves the details of an existing Transaction.
   */
  public static Transaction retrieve(String id, TransactionRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/transactions/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Transaction.class, options);
  }


  /**
   * Change to a FinancialAccount's balance.
   */
  public static class BalanceImpact extends StripeObject {
    /**
     * The change made to funds the user can spend right now.
     */
    @SerializedName("cash")
    Long cash;
    /**
     * The change made to funds that are not spendable yet, but will become available at a later
     * time.
     */
    @SerializedName("inbound_pending")
    Long inboundPending;
    /**
     * The change made to funds in the account, but not spendable because they are being held for
     * pending outbound flows.
     */
    @SerializedName("outbound_pending")
    Long outboundPending;

    /**
     * The change made to funds the user can spend right now.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCash() {
      return this.cash;
    }

    /**
     * The change made to funds that are not spendable yet, but will become available at a later
     * time.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getInboundPending() {
      return this.inboundPending;
    }

    /**
     * The change made to funds in the account, but not spendable because they are being held for
     * pending outbound flows.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getOutboundPending() {
      return this.outboundPending;
    }

    /**
     * The change made to funds the user can spend right now.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCash(final Long cash) {
      this.cash = cash;
    }

    /**
     * The change made to funds that are not spendable yet, but will become available at a later
     * time.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInboundPending(final Long inboundPending) {
      this.inboundPending = inboundPending;
    }

    /**
     * The change made to funds in the account, but not spendable because they are being held for
     * pending outbound flows.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOutboundPending(final Long outboundPending) {
      this.outboundPending = outboundPending;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Transaction.BalanceImpact)) return false;
      final Transaction.BalanceImpact other = (Transaction.BalanceImpact) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$cash = this.getCash();
      final java.lang.Object other$cash = other.getCash();
      if (this$cash == null ? other$cash != null : !this$cash.equals(other$cash)) return false;
      final java.lang.Object this$inboundPending = this.getInboundPending();
      final java.lang.Object other$inboundPending = other.getInboundPending();
      if (this$inboundPending == null ? other$inboundPending != null : !this$inboundPending.equals(other$inboundPending)) return false;
      final java.lang.Object this$outboundPending = this.getOutboundPending();
      final java.lang.Object other$outboundPending = other.getOutboundPending();
      if (this$outboundPending == null ? other$outboundPending != null : !this$outboundPending.equals(other$outboundPending)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Transaction.BalanceImpact;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $cash = this.getCash();
      result = result * PRIME + ($cash == null ? 43 : $cash.hashCode());
      final java.lang.Object $inboundPending = this.getInboundPending();
      result = result * PRIME + ($inboundPending == null ? 43 : $inboundPending.hashCode());
      final java.lang.Object $outboundPending = this.getOutboundPending();
      result = result * PRIME + ($outboundPending == null ? 43 : $outboundPending.hashCode());
      return result;
    }
  }


  public static class StatusTransitions extends StripeObject {
    /** Timestamp describing when the Transaction changed status to {@code posted}. */
    @SerializedName("posted_at")
    Long postedAt;
    /** Timestamp describing when the Transaction changed status to {@code void}. */
    @SerializedName("void_at")
    Long voidAt;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPostedAt() {
      return this.postedAt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getVoidAt() {
      return this.voidAt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPostedAt(final Long postedAt) {
      this.postedAt = postedAt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVoidAt(final Long voidAt) {
      this.voidAt = voidAt;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Transaction.StatusTransitions)) return false;
      final Transaction.StatusTransitions other = (Transaction.StatusTransitions) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$postedAt = this.getPostedAt();
      final java.lang.Object other$postedAt = other.getPostedAt();
      if (this$postedAt == null ? other$postedAt != null : !this$postedAt.equals(other$postedAt)) return false;
      final java.lang.Object this$voidAt = this.getVoidAt();
      final java.lang.Object other$voidAt = other.getVoidAt();
      if (this$voidAt == null ? other$voidAt != null : !this$voidAt.equals(other$voidAt)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Transaction.StatusTransitions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $postedAt = this.getPostedAt();
      result = result * PRIME + ($postedAt == null ? 43 : $postedAt.hashCode());
      final java.lang.Object $voidAt = this.getVoidAt();
      result = result * PRIME + ($voidAt == null ? 43 : $voidAt.hashCode());
      return result;
    }
  }

  /**
   * Amount (in cents) transferred.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Change to a FinancialAccount's balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BalanceImpact getBalanceImpact() {
    return this.balanceImpact;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * A list of TransactionEntries that are part of this Transaction. This cannot be expanded in any
   * list endpoints.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TransactionEntryCollection getEntries() {
    return this.entries;
  }

  /**
   * The FinancialAccount associated with this object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFinancialAccount() {
    return this.financialAccount;
  }

  /**
   * ID of the flow that created the Transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFlow() {
    return this.flow;
  }

  /**
   * Details of the flow that created the Transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public FlowDetails getFlowDetails() {
    return this.flowDetails;
  }

  /**
   * Type of the flow that created the Transaction.
   *
   * <p>One of {@code credit_reversal}, {@code debit_reversal}, {@code inbound_transfer}, {@code
   * issuing_authorization}, {@code other}, {@code outbound_payment}, {@code outbound_transfer},
   * {@code received_credit}, or {@code received_debit}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFlowType() {
    return this.flowType;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.transaction}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Status of the Transaction.
   *
   * <p>One of {@code open}, {@code posted}, or {@code void}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public StatusTransitions getStatusTransitions() {
    return this.statusTransitions;
  }

  /**
   * Amount (in cents) transferred.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Change to a FinancialAccount's balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBalanceImpact(final BalanceImpact balanceImpact) {
    this.balanceImpact = balanceImpact;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * A list of TransactionEntries that are part of this Transaction. This cannot be expanded in any
   * list endpoints.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEntries(final TransactionEntryCollection entries) {
    this.entries = entries;
  }

  /**
   * The FinancialAccount associated with this object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinancialAccount(final String financialAccount) {
    this.financialAccount = financialAccount;
  }

  /**
   * ID of the flow that created the Transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFlow(final String flow) {
    this.flow = flow;
  }

  /**
   * Details of the flow that created the Transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFlowDetails(final FlowDetails flowDetails) {
    this.flowDetails = flowDetails;
  }

  /**
   * Type of the flow that created the Transaction.
   *
   * <p>One of {@code credit_reversal}, {@code debit_reversal}, {@code inbound_transfer}, {@code
   * issuing_authorization}, {@code other}, {@code outbound_payment}, {@code outbound_transfer},
   * {@code received_credit}, or {@code received_debit}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFlowType(final String flowType) {
    this.flowType = flowType;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.transaction}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Status of the Transaction.
   *
   * <p>One of {@code open}, {@code posted}, or {@code void}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatusTransitions(final StatusTransitions statusTransitions) {
    this.statusTransitions = statusTransitions;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Transaction)) return false;
    final Transaction other = (Transaction) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$balanceImpact = this.getBalanceImpact();
    final java.lang.Object other$balanceImpact = other.getBalanceImpact();
    if (this$balanceImpact == null ? other$balanceImpact != null : !this$balanceImpact.equals(other$balanceImpact)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$entries = this.getEntries();
    final java.lang.Object other$entries = other.getEntries();
    if (this$entries == null ? other$entries != null : !this$entries.equals(other$entries)) return false;
    final java.lang.Object this$financialAccount = this.getFinancialAccount();
    final java.lang.Object other$financialAccount = other.getFinancialAccount();
    if (this$financialAccount == null ? other$financialAccount != null : !this$financialAccount.equals(other$financialAccount)) return false;
    final java.lang.Object this$flow = this.getFlow();
    final java.lang.Object other$flow = other.getFlow();
    if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) return false;
    final java.lang.Object this$flowDetails = this.getFlowDetails();
    final java.lang.Object other$flowDetails = other.getFlowDetails();
    if (this$flowDetails == null ? other$flowDetails != null : !this$flowDetails.equals(other$flowDetails)) return false;
    final java.lang.Object this$flowType = this.getFlowType();
    final java.lang.Object other$flowType = other.getFlowType();
    if (this$flowType == null ? other$flowType != null : !this$flowType.equals(other$flowType)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$statusTransitions = this.getStatusTransitions();
    final java.lang.Object other$statusTransitions = other.getStatusTransitions();
    if (this$statusTransitions == null ? other$statusTransitions != null : !this$statusTransitions.equals(other$statusTransitions)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Transaction;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $balanceImpact = this.getBalanceImpact();
    result = result * PRIME + ($balanceImpact == null ? 43 : $balanceImpact.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $entries = this.getEntries();
    result = result * PRIME + ($entries == null ? 43 : $entries.hashCode());
    final java.lang.Object $financialAccount = this.getFinancialAccount();
    result = result * PRIME + ($financialAccount == null ? 43 : $financialAccount.hashCode());
    final java.lang.Object $flow = this.getFlow();
    result = result * PRIME + ($flow == null ? 43 : $flow.hashCode());
    final java.lang.Object $flowDetails = this.getFlowDetails();
    result = result * PRIME + ($flowDetails == null ? 43 : $flowDetails.hashCode());
    final java.lang.Object $flowType = this.getFlowType();
    result = result * PRIME + ($flowType == null ? 43 : $flowType.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $statusTransitions = this.getStatusTransitions();
    result = result * PRIME + ($statusTransitions == null ? 43 : $statusTransitions.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
