// Generated by delombok at Fri Oct 07 15:56:17 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.capital;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.capital.FinancingTransactionListParams;
import com.stripe.param.capital.FinancingTransactionRetrieveParams;
import java.util.Map;

/**
 * This is an object representing the details of a transaction on a Capital financing object.
 */
public class FinancingTransaction extends ApiResource implements HasId {
  /**
   * The ID of the merchant associated with this financing transaction.
   */
  @SerializedName("account")
  String account;
  /**
   * Time at which the financing transaction was created. Given in seconds since unix epoch.
   */
  @SerializedName("created_at")
  Long createdAt;
  /**
   * This is an object representing a transaction on a Capital financing offer.
   */
  @SerializedName("details")
  Details details;
  /**
   * The Capital financing offer for this financing transaction.
   */
  @SerializedName("financing_offer")
  String financingOffer;
  /**
   * A unique identifier for the financing transaction object.
   */
  @SerializedName("id")
  String id;
  /**
   * The Capital transaction object that predates the Financing Transactions API and corresponds
   * with the balance transaction that was created as a result of this financing transaction.
   */
  @SerializedName("legacy_balance_transaction_source")
  String legacyBalanceTransactionSource;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * The object type: financing_transaction
   *
   * <p>Equal to {@code capital.financing_transaction}.
   */
  @SerializedName("object")
  String object;
  /**
   * The type of the financing transaction.
   *
   * <p>One of {@code payment}, {@code payout}, or {@code reversal}.
   */
  @SerializedName("type")
  String type;
  /**
   * A human-friendly description of the financing transaction.
   */
  @SerializedName("user_facing_description")
  String userFacingDescription;

  /**
   * Returns a list of financing transactions. The transactions are returned in sorted order, with
   * the most recent transactions appearing first.
   */
  public static FinancingTransactionCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of financing transactions. The transactions are returned in sorted order, with
   * the most recent transactions appearing first.
   */
  public static FinancingTransactionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/capital/financing_transactions");
    return ApiResource.requestCollection(url, params, FinancingTransactionCollection.class, options);
  }

  /**
   * Returns a list of financing transactions. The transactions are returned in sorted order, with
   * the most recent transactions appearing first.
   */
  public static FinancingTransactionCollection list(FinancingTransactionListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of financing transactions. The transactions are returned in sorted order, with
   * the most recent transactions appearing first.
   */
  public static FinancingTransactionCollection list(FinancingTransactionListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/capital/financing_transactions");
    return ApiResource.requestCollection(url, params, FinancingTransactionCollection.class, options);
  }

  /**
   * Retrieves a financing transaction for a financing offer.
   */
  public static FinancingTransaction retrieve(String financingTransaction) throws StripeException {
    return retrieve(financingTransaction, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves a financing transaction for a financing offer.
   */
  public static FinancingTransaction retrieve(String financingTransaction, RequestOptions options) throws StripeException {
    return retrieve(financingTransaction, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves a financing transaction for a financing offer.
   */
  public static FinancingTransaction retrieve(String financingTransaction, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/capital/financing_transactions/%s", ApiResource.urlEncodeId(financingTransaction)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FinancingTransaction.class, options);
  }

  /**
   * Retrieves a financing transaction for a financing offer.
   */
  public static FinancingTransaction retrieve(String financingTransaction, FinancingTransactionRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/capital/financing_transactions/%s", ApiResource.urlEncodeId(financingTransaction)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FinancingTransaction.class, options);
  }


  /**
   * This is an object representing a transaction on a Capital financing offer.
   */
  public static class Details extends StripeObject {
    /** The advance amount being repaid, paid out, or reversed in minor units. */
    @SerializedName("advance_amount")
    Long advanceAmount;
    /** The currency of the financing transaction. */
    @SerializedName("currency")
    String currency;
    /** The fee amount being repaid, paid out, or reversed in minor units. */
    @SerializedName("fee_amount")
    Long feeAmount;
    /**
     * The linked payment for the transaction. This field only applies to financing transactions of
     * type {@code paydown} and reason {@code automatic_withholding}.
     */
    @SerializedName("linked_payment")
    String linkedPayment;
    /**
     * The reason for the financing transaction (if applicable).
     *
     * <p>One of {@code automatic_withholding}, {@code automatic_withholding_refund}, {@code
     * collection}, {@code collection_failure}, {@code financing_cancellation}, {@code refill},
     * {@code requested_by_user}, or {@code user_initiated}.
     */
    @SerializedName("reason")
    String reason;
    /**
     * The reversed transaction. This field only applies to financing transactions of type {@code
     * reversal}.
     */
    @SerializedName("reversed_transaction")
    String reversedTransaction;
    /** The advance and fee amount being repaid, paid out, or reversed in minor units. */
    @SerializedName("total_amount")
    Long totalAmount;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAdvanceAmount() {
      return this.advanceAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCurrency() {
      return this.currency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getFeeAmount() {
      return this.feeAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLinkedPayment() {
      return this.linkedPayment;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReason() {
      return this.reason;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getReversedTransaction() {
      return this.reversedTransaction;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getTotalAmount() {
      return this.totalAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAdvanceAmount(final Long advanceAmount) {
      this.advanceAmount = advanceAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrency(final String currency) {
      this.currency = currency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFeeAmount(final Long feeAmount) {
      this.feeAmount = feeAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLinkedPayment(final String linkedPayment) {
      this.linkedPayment = linkedPayment;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReason(final String reason) {
      this.reason = reason;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReversedTransaction(final String reversedTransaction) {
      this.reversedTransaction = reversedTransaction;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTotalAmount(final Long totalAmount) {
      this.totalAmount = totalAmount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FinancingTransaction.Details)) return false;
      final FinancingTransaction.Details other = (FinancingTransaction.Details) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$advanceAmount = this.getAdvanceAmount();
      final java.lang.Object other$advanceAmount = other.getAdvanceAmount();
      if (this$advanceAmount == null ? other$advanceAmount != null : !this$advanceAmount.equals(other$advanceAmount)) return false;
      final java.lang.Object this$feeAmount = this.getFeeAmount();
      final java.lang.Object other$feeAmount = other.getFeeAmount();
      if (this$feeAmount == null ? other$feeAmount != null : !this$feeAmount.equals(other$feeAmount)) return false;
      final java.lang.Object this$totalAmount = this.getTotalAmount();
      final java.lang.Object other$totalAmount = other.getTotalAmount();
      if (this$totalAmount == null ? other$totalAmount != null : !this$totalAmount.equals(other$totalAmount)) return false;
      final java.lang.Object this$currency = this.getCurrency();
      final java.lang.Object other$currency = other.getCurrency();
      if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
      final java.lang.Object this$linkedPayment = this.getLinkedPayment();
      final java.lang.Object other$linkedPayment = other.getLinkedPayment();
      if (this$linkedPayment == null ? other$linkedPayment != null : !this$linkedPayment.equals(other$linkedPayment)) return false;
      final java.lang.Object this$reason = this.getReason();
      final java.lang.Object other$reason = other.getReason();
      if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
      final java.lang.Object this$reversedTransaction = this.getReversedTransaction();
      final java.lang.Object other$reversedTransaction = other.getReversedTransaction();
      if (this$reversedTransaction == null ? other$reversedTransaction != null : !this$reversedTransaction.equals(other$reversedTransaction)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FinancingTransaction.Details;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $advanceAmount = this.getAdvanceAmount();
      result = result * PRIME + ($advanceAmount == null ? 43 : $advanceAmount.hashCode());
      final java.lang.Object $feeAmount = this.getFeeAmount();
      result = result * PRIME + ($feeAmount == null ? 43 : $feeAmount.hashCode());
      final java.lang.Object $totalAmount = this.getTotalAmount();
      result = result * PRIME + ($totalAmount == null ? 43 : $totalAmount.hashCode());
      final java.lang.Object $currency = this.getCurrency();
      result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
      final java.lang.Object $linkedPayment = this.getLinkedPayment();
      result = result * PRIME + ($linkedPayment == null ? 43 : $linkedPayment.hashCode());
      final java.lang.Object $reason = this.getReason();
      result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
      final java.lang.Object $reversedTransaction = this.getReversedTransaction();
      result = result * PRIME + ($reversedTransaction == null ? 43 : $reversedTransaction.hashCode());
      return result;
    }
  }

  /**
   * The ID of the merchant associated with this financing transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAccount() {
    return this.account;
  }

  /**
   * Time at which the financing transaction was created. Given in seconds since unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreatedAt() {
    return this.createdAt;
  }

  /**
   * This is an object representing a transaction on a Capital financing offer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Details getDetails() {
    return this.details;
  }

  /**
   * The Capital financing offer for this financing transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFinancingOffer() {
    return this.financingOffer;
  }

  /**
   * The Capital transaction object that predates the Financing Transactions API and corresponds
   * with the balance transaction that was created as a result of this financing transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLegacyBalanceTransactionSource() {
    return this.legacyBalanceTransactionSource;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * The object type: financing_transaction
   *
   * <p>Equal to {@code capital.financing_transaction}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The type of the financing transaction.
   *
   * <p>One of {@code payment}, {@code payout}, or {@code reversal}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * A human-friendly description of the financing transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getUserFacingDescription() {
    return this.userFacingDescription;
  }

  /**
   * The ID of the merchant associated with this financing transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAccount(final String account) {
    this.account = account;
  }

  /**
   * Time at which the financing transaction was created. Given in seconds since unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreatedAt(final Long createdAt) {
    this.createdAt = createdAt;
  }

  /**
   * This is an object representing a transaction on a Capital financing offer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDetails(final Details details) {
    this.details = details;
  }

  /**
   * The Capital financing offer for this financing transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinancingOffer(final String financingOffer) {
    this.financingOffer = financingOffer;
  }

  /**
   * A unique identifier for the financing transaction object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The Capital transaction object that predates the Financing Transactions API and corresponds
   * with the balance transaction that was created as a result of this financing transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLegacyBalanceTransactionSource(final String legacyBalanceTransactionSource) {
    this.legacyBalanceTransactionSource = legacyBalanceTransactionSource;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * The object type: financing_transaction
   *
   * <p>Equal to {@code capital.financing_transaction}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The type of the financing transaction.
   *
   * <p>One of {@code payment}, {@code payout}, or {@code reversal}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  /**
   * A human-friendly description of the financing transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUserFacingDescription(final String userFacingDescription) {
    this.userFacingDescription = userFacingDescription;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof FinancingTransaction)) return false;
    final FinancingTransaction other = (FinancingTransaction) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$createdAt = this.getCreatedAt();
    final java.lang.Object other$createdAt = other.getCreatedAt();
    if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$account = this.getAccount();
    final java.lang.Object other$account = other.getAccount();
    if (this$account == null ? other$account != null : !this$account.equals(other$account)) return false;
    final java.lang.Object this$details = this.getDetails();
    final java.lang.Object other$details = other.getDetails();
    if (this$details == null ? other$details != null : !this$details.equals(other$details)) return false;
    final java.lang.Object this$financingOffer = this.getFinancingOffer();
    final java.lang.Object other$financingOffer = other.getFinancingOffer();
    if (this$financingOffer == null ? other$financingOffer != null : !this$financingOffer.equals(other$financingOffer)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$legacyBalanceTransactionSource = this.getLegacyBalanceTransactionSource();
    final java.lang.Object other$legacyBalanceTransactionSource = other.getLegacyBalanceTransactionSource();
    if (this$legacyBalanceTransactionSource == null ? other$legacyBalanceTransactionSource != null : !this$legacyBalanceTransactionSource.equals(other$legacyBalanceTransactionSource)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    final java.lang.Object this$userFacingDescription = this.getUserFacingDescription();
    final java.lang.Object other$userFacingDescription = other.getUserFacingDescription();
    if (this$userFacingDescription == null ? other$userFacingDescription != null : !this$userFacingDescription.equals(other$userFacingDescription)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof FinancingTransaction;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $createdAt = this.getCreatedAt();
    result = result * PRIME + ($createdAt == null ? 43 : $createdAt.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $account = this.getAccount();
    result = result * PRIME + ($account == null ? 43 : $account.hashCode());
    final java.lang.Object $details = this.getDetails();
    result = result * PRIME + ($details == null ? 43 : $details.hashCode());
    final java.lang.Object $financingOffer = this.getFinancingOffer();
    result = result * PRIME + ($financingOffer == null ? 43 : $financingOffer.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $legacyBalanceTransactionSource = this.getLegacyBalanceTransactionSource();
    result = result * PRIME + ($legacyBalanceTransactionSource == null ? 43 : $legacyBalanceTransactionSource.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    final java.lang.Object $userFacingDescription = this.getUserFacingDescription();
    result = result * PRIME + ($userFacingDescription == null ? 43 : $userFacingDescription.hashCode());
    return result;
  }

  /**
   * A unique identifier for the financing transaction object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
