// Generated by delombok at Fri Oct 07 15:56:17 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.treasury.OutboundTransferCancelParams;
import com.stripe.param.treasury.OutboundTransferCreateParams;
import com.stripe.param.treasury.OutboundTransferFailParams;
import com.stripe.param.treasury.OutboundTransferListParams;
import com.stripe.param.treasury.OutboundTransferPostParams;
import com.stripe.param.treasury.OutboundTransferRetrieveParams;
import com.stripe.param.treasury.OutboundTransferReturnOutboundTransferParams;
import java.util.Map;

/**
 * Use OutboundTransfers to transfer funds from a <a
 * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a> to a PaymentMethod
 * belonging to the same entity. To send funds to a different party, use <a
 * href="https://stripe.com/docs/api#outbound_payments">OutboundPayments</a> instead. You can send
 * funds over ACH rails or through a domestic wire transfer to a user's own external bank account.
 *
 * <p>Simulate OutboundTransfer state changes with the {@code
 * /v1/test_helpers/treasury/outbound_transfers} endpoints. These methods can only be called on test
 * mode objects.
 */
public class OutboundTransfer extends ApiResource implements HasId {
  /**
   * Amount (in cents) transferred.
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Returns {@code true} if the object can be canceled, and {@code false} otherwise.
   */
  @SerializedName("cancelable")
  Boolean cancelable;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @SerializedName("description")
  String description;
  /**
   * The PaymentMethod used as the payment instrument for an OutboundTransfer.
   */
  @SerializedName("destination_payment_method")
  String destinationPaymentMethod;
  @SerializedName("destination_payment_method_details")
  DestinationPaymentMethodDetails destinationPaymentMethodDetails;
  /**
   * The date when funds are expected to arrive in the destination account.
   */
  @SerializedName("expected_arrival_date")
  Long expectedArrivalDate;
  /**
   * The FinancialAccount that funds were pulled from.
   */
  @SerializedName("financial_account")
  String financialAccount;
  /**
   * A <a href="https://stripe.com/docs/treasury/moving-money/regulatory-receipts">hosted
   * transaction receipt</a> URL that is provided when money movement is considered regulated under
   * Stripe's money transmission licenses.
   */
  @SerializedName("hosted_regulatory_receipt_url")
  String hostedRegulatoryReceiptUrl;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * Details about the network used for the OutboundTransfer.
   */
  @SerializedName("network_details")
  NetworkDetails networkDetails;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.outbound_transfer}.
   */
  @SerializedName("object")
  String object;
  /**
   * Details about a returned OutboundTransfer. Only set when the status is {@code returned}.
   */
  @SerializedName("returned_details")
  ReturnedDetails returnedDetails;
  /**
   * Information about the OutboundTransfer to be sent to the recipient account.
   */
  @SerializedName("statement_descriptor")
  String statementDescriptor;
  /**
   * Current status of the OutboundTransfer: {@code processing}, {@code failed}, {@code canceled},
   * {@code posted}, {@code returned}. An OutboundTransfer is {@code processing} if it has been
   * created and is pending. The status changes to {@code posted} once the OutboundTransfer has been
   * &quot;confirmed&quot; and funds have left the account, or to {@code failed} or {@code
   * canceled}. If an OutboundTransfer fails to arrive at its destination, its status will change to
   * {@code returned}.
   *
   * <p>One of {@code canceled}, {@code failed}, {@code posted}, {@code processing}, or {@code
   * returned}.
   */
  @SerializedName("status")
  String status;
  @SerializedName("status_transitions")
  StatusTransitions statusTransitions;
  /**
   * The Transaction associated with this object.
   */
  @SerializedName("transaction")
  ExpandableField<Transaction> transaction;

  /**
   * Get ID of expandable {@code transaction} object.
   */
  public String getTransaction() {
    return (this.transaction != null) ? this.transaction.getId() : null;
  }

  public void setTransaction(String id) {
    this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
  }

  /**
   * Get expanded {@code transaction}.
   */
  public Transaction getTransactionObject() {
    return (this.transaction != null) ? this.transaction.getExpanded() : null;
  }

  public void setTransactionObject(Transaction expandableObject) {
    this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
  }

  /**
   * An OutboundTransfer can be canceled if the funds have not yet been paid out.
   */
  public OutboundTransfer cancel() throws StripeException {
    return cancel((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * An OutboundTransfer can be canceled if the funds have not yet been paid out.
   */
  public OutboundTransfer cancel(RequestOptions options) throws StripeException {
    return cancel((Map<String, Object>) null, options);
  }

  /**
   * An OutboundTransfer can be canceled if the funds have not yet been paid out.
   */
  public OutboundTransfer cancel(Map<String, Object> params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * An OutboundTransfer can be canceled if the funds have not yet been paid out.
   */
  public OutboundTransfer cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/outbound_transfers/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundTransfer.class, options);
  }

  /**
   * An OutboundTransfer can be canceled if the funds have not yet been paid out.
   */
  public OutboundTransfer cancel(OutboundTransferCancelParams params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * An OutboundTransfer can be canceled if the funds have not yet been paid out.
   */
  public OutboundTransfer cancel(OutboundTransferCancelParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/outbound_transfers/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundTransfer.class, options);
  }

  /**
   * Creates an OutboundTransfer.
   */
  public static OutboundTransfer create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates an OutboundTransfer.
   */
  public static OutboundTransfer create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/outbound_transfers");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundTransfer.class, options);
  }

  /**
   * Creates an OutboundTransfer.
   */
  public static OutboundTransfer create(OutboundTransferCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates an OutboundTransfer.
   */
  public static OutboundTransfer create(OutboundTransferCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/outbound_transfers");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundTransfer.class, options);
  }

  /**
   * Returns a list of OutboundTransfers sent from the specified FinancialAccount.
   */
  public static OutboundTransferCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of OutboundTransfers sent from the specified FinancialAccount.
   */
  public static OutboundTransferCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/outbound_transfers");
    return ApiResource.requestCollection(url, params, OutboundTransferCollection.class, options);
  }

  /**
   * Returns a list of OutboundTransfers sent from the specified FinancialAccount.
   */
  public static OutboundTransferCollection list(OutboundTransferListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of OutboundTransfers sent from the specified FinancialAccount.
   */
  public static OutboundTransferCollection list(OutboundTransferListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/outbound_transfers");
    return ApiResource.requestCollection(url, params, OutboundTransferCollection.class, options);
  }

  /**
   * Retrieves the details of an existing OutboundTransfer by passing the unique OutboundTransfer ID
   * from either the OutboundTransfer creation request or OutboundTransfer list.
   */
  public static OutboundTransfer retrieve(String outboundTransfer) throws StripeException {
    return retrieve(outboundTransfer, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an existing OutboundTransfer by passing the unique OutboundTransfer ID
   * from either the OutboundTransfer creation request or OutboundTransfer list.
   */
  public static OutboundTransfer retrieve(String outboundTransfer, RequestOptions options) throws StripeException {
    return retrieve(outboundTransfer, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an existing OutboundTransfer by passing the unique OutboundTransfer ID
   * from either the OutboundTransfer creation request or OutboundTransfer list.
   */
  public static OutboundTransfer retrieve(String outboundTransfer, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/outbound_transfers/%s", ApiResource.urlEncodeId(outboundTransfer)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, OutboundTransfer.class, options);
  }

  /**
   * Retrieves the details of an existing OutboundTransfer by passing the unique OutboundTransfer ID
   * from either the OutboundTransfer creation request or OutboundTransfer list.
   */
  public static OutboundTransfer retrieve(String outboundTransfer, OutboundTransferRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/outbound_transfers/%s", ApiResource.urlEncodeId(outboundTransfer)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, OutboundTransfer.class, options);
  }


  public static class DestinationPaymentMethodDetails extends StripeObject {
    @SerializedName("billing_details")
    BillingDetails billingDetails;
    /**
     * The type of the payment method used in the OutboundTransfer.
     *
     * <p>Equal to {@code us_bank_account}.
     */
    @SerializedName("type")
    String type;
    @SerializedName("us_bank_account")
    UsBankAccount usBankAccount;


    public static class BillingDetails extends StripeObject {
      @SerializedName("address")
      Address address;
      /**
       * Email address.
       */
      @SerializedName("email")
      String email;
      /**
       * Full name.
       */
      @SerializedName("name")
      String name;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Address getAddress() {
        return this.address;
      }

      /**
       * Email address.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getEmail() {
        return this.email;
      }

      /**
       * Full name.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getName() {
        return this.name;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAddress(final Address address) {
        this.address = address;
      }

      /**
       * Email address.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setEmail(final String email) {
        this.email = email;
      }

      /**
       * Full name.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setName(final String name) {
        this.name = name;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof OutboundTransfer.DestinationPaymentMethodDetails.BillingDetails)) return false;
        final OutboundTransfer.DestinationPaymentMethodDetails.BillingDetails other = (OutboundTransfer.DestinationPaymentMethodDetails.BillingDetails) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$address = this.getAddress();
        final java.lang.Object other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
        final java.lang.Object this$email = this.getEmail();
        final java.lang.Object other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof OutboundTransfer.DestinationPaymentMethodDetails.BillingDetails;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $address = this.getAddress();
        result = result * PRIME + ($address == null ? 43 : $address.hashCode());
        final java.lang.Object $email = this.getEmail();
        result = result * PRIME + ($email == null ? 43 : $email.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        return result;
      }
    }


    public static class UsBankAccount extends StripeObject {
      /**
       * Account holder type: individual or company.
       *
       * <p>One of {@code company}, or {@code individual}.
       */
      @SerializedName("account_holder_type")
      String accountHolderType;
      /**
       * Account type: checkings or savings. Defaults to checking if omitted.
       *
       * <p>One of {@code checking}, or {@code savings}.
       */
      @SerializedName("account_type")
      String accountType;
      /** Name of the bank associated with the bank account. */
      @SerializedName("bank_name")
      String bankName;
      /**
       * Uniquely identifies this particular bank account. You can use this attribute to check
       * whether two bank accounts are the same.
       */
      @SerializedName("fingerprint")
      String fingerprint;
      /** Last four digits of the bank account number. */
      @SerializedName("last4")
      String last4;
      /**
       * The US bank account network used to send funds.
       *
       * <p>One of {@code ach}, or {@code us_domestic_wire}.
       */
      @SerializedName("network")
      String network;
      @SerializedName("routing_number")
      String routingNumber;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAccountHolderType() {
        return this.accountHolderType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAccountType() {
        return this.accountType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBankName() {
        return this.bankName;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getFingerprint() {
        return this.fingerprint;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLast4() {
        return this.last4;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getNetwork() {
        return this.network;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRoutingNumber() {
        return this.routingNumber;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAccountHolderType(final String accountHolderType) {
        this.accountHolderType = accountHolderType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAccountType(final String accountType) {
        this.accountType = accountType;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankName(final String bankName) {
        this.bankName = bankName;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setFingerprint(final String fingerprint) {
        this.fingerprint = fingerprint;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLast4(final String last4) {
        this.last4 = last4;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setNetwork(final String network) {
        this.network = network;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRoutingNumber(final String routingNumber) {
        this.routingNumber = routingNumber;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof OutboundTransfer.DestinationPaymentMethodDetails.UsBankAccount)) return false;
        final OutboundTransfer.DestinationPaymentMethodDetails.UsBankAccount other = (OutboundTransfer.DestinationPaymentMethodDetails.UsBankAccount) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$accountHolderType = this.getAccountHolderType();
        final java.lang.Object other$accountHolderType = other.getAccountHolderType();
        if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) return false;
        final java.lang.Object this$accountType = this.getAccountType();
        final java.lang.Object other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) return false;
        final java.lang.Object this$bankName = this.getBankName();
        final java.lang.Object other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
        final java.lang.Object this$fingerprint = this.getFingerprint();
        final java.lang.Object other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) return false;
        final java.lang.Object this$last4 = this.getLast4();
        final java.lang.Object other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
        final java.lang.Object this$network = this.getNetwork();
        final java.lang.Object other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) return false;
        final java.lang.Object this$routingNumber = this.getRoutingNumber();
        final java.lang.Object other$routingNumber = other.getRoutingNumber();
        if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof OutboundTransfer.DestinationPaymentMethodDetails.UsBankAccount;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $accountHolderType = this.getAccountHolderType();
        result = result * PRIME + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
        final java.lang.Object $accountType = this.getAccountType();
        result = result * PRIME + ($accountType == null ? 43 : $accountType.hashCode());
        final java.lang.Object $bankName = this.getBankName();
        result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
        final java.lang.Object $fingerprint = this.getFingerprint();
        result = result * PRIME + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        final java.lang.Object $last4 = this.getLast4();
        result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
        final java.lang.Object $network = this.getNetwork();
        result = result * PRIME + ($network == null ? 43 : $network.hashCode());
        final java.lang.Object $routingNumber = this.getRoutingNumber();
        result = result * PRIME + ($routingNumber == null ? 43 : $routingNumber.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BillingDetails getBillingDetails() {
      return this.billingDetails;
    }

    /**
     * The type of the payment method used in the OutboundTransfer.
     *
     * <p>Equal to {@code us_bank_account}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UsBankAccount getUsBankAccount() {
      return this.usBankAccount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBillingDetails(final BillingDetails billingDetails) {
      this.billingDetails = billingDetails;
    }

    /**
     * The type of the payment method used in the OutboundTransfer.
     *
     * <p>Equal to {@code us_bank_account}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUsBankAccount(final UsBankAccount usBankAccount) {
      this.usBankAccount = usBankAccount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof OutboundTransfer.DestinationPaymentMethodDetails)) return false;
      final OutboundTransfer.DestinationPaymentMethodDetails other = (OutboundTransfer.DestinationPaymentMethodDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$billingDetails = this.getBillingDetails();
      final java.lang.Object other$billingDetails = other.getBillingDetails();
      if (this$billingDetails == null ? other$billingDetails != null : !this$billingDetails.equals(other$billingDetails)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      final java.lang.Object this$usBankAccount = this.getUsBankAccount();
      final java.lang.Object other$usBankAccount = other.getUsBankAccount();
      if (this$usBankAccount == null ? other$usBankAccount != null : !this$usBankAccount.equals(other$usBankAccount)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof OutboundTransfer.DestinationPaymentMethodDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $billingDetails = this.getBillingDetails();
      result = result * PRIME + ($billingDetails == null ? 43 : $billingDetails.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      final java.lang.Object $usBankAccount = this.getUsBankAccount();
      result = result * PRIME + ($usBankAccount == null ? 43 : $usBankAccount.hashCode());
      return result;
    }
  }


  /**
   * Routing number of the bank account.
   */
  public static class NetworkDetails extends StripeObject {
    /**
     * Details about an ACH transaction.
     */
    @SerializedName("ach")
    Ach ach;
    /**
     * The type of flow that originated the OutboundTransfer.
     *
     * <p>Equal to {@code ach}.
     */
    @SerializedName("type")
    String type;


    public static class Ach extends StripeObject {
      @SerializedName("addenda")
      String addenda;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getAddenda() {
        return this.addenda;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAddenda(final String addenda) {
        this.addenda = addenda;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof OutboundTransfer.NetworkDetails.Ach)) return false;
        final OutboundTransfer.NetworkDetails.Ach other = (OutboundTransfer.NetworkDetails.Ach) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$addenda = this.getAddenda();
        final java.lang.Object other$addenda = other.getAddenda();
        if (this$addenda == null ? other$addenda != null : !this$addenda.equals(other$addenda)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof OutboundTransfer.NetworkDetails.Ach;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $addenda = this.getAddenda();
        result = result * PRIME + ($addenda == null ? 43 : $addenda.hashCode());
        return result;
      }
    }

    /**
     * Details about an ACH transaction.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Ach getAch() {
      return this.ach;
    }

    /**
     * The type of flow that originated the OutboundTransfer.
     *
     * <p>Equal to {@code ach}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    /**
     * Details about an ACH transaction.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAch(final Ach ach) {
      this.ach = ach;
    }

    /**
     * The type of flow that originated the OutboundTransfer.
     *
     * <p>Equal to {@code ach}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof OutboundTransfer.NetworkDetails)) return false;
      final OutboundTransfer.NetworkDetails other = (OutboundTransfer.NetworkDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$ach = this.getAch();
      final java.lang.Object other$ach = other.getAch();
      if (this$ach == null ? other$ach != null : !this$ach.equals(other$ach)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof OutboundTransfer.NetworkDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $ach = this.getAch();
      result = result * PRIME + ($ach == null ? 43 : $ach.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }


  /**
   * ACH Addenda record.
   */
  public static class ReturnedDetails extends StripeObject {
    /**
     * Reason for the return.
     *
     * <p>One of {@code account_closed}, {@code account_frozen}, {@code bank_account_restricted},
     * {@code bank_ownership_changed}, {@code declined}, {@code incorrect_account_holder_name},
     * {@code invalid_account_number}, {@code invalid_currency}, {@code no_account}, or {@code
     * other}.
     */
    @SerializedName("code")
    String code;
    /**
     * The Transaction associated with this object.
     */
    @SerializedName("transaction")
    ExpandableField<Transaction> transaction;

    /**
     * Get ID of expandable {@code transaction} object.
     */
    public String getTransaction() {
      return (this.transaction != null) ? this.transaction.getId() : null;
    }

    public void setTransaction(String id) {
      this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
    }

    /**
     * Get expanded {@code transaction}.
     */
    public Transaction getTransactionObject() {
      return (this.transaction != null) ? this.transaction.getExpanded() : null;
    }

    public void setTransactionObject(Transaction expandableObject) {
      this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
    }

    /**
     * Reason for the return.
     *
     * <p>One of {@code account_closed}, {@code account_frozen}, {@code bank_account_restricted},
     * {@code bank_ownership_changed}, {@code declined}, {@code incorrect_account_holder_name},
     * {@code invalid_account_number}, {@code invalid_currency}, {@code no_account}, or {@code
     * other}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCode() {
      return this.code;
    }

    /**
     * Reason for the return.
     *
     * <p>One of {@code account_closed}, {@code account_frozen}, {@code bank_account_restricted},
     * {@code bank_ownership_changed}, {@code declined}, {@code incorrect_account_holder_name},
     * {@code invalid_account_number}, {@code invalid_currency}, {@code no_account}, or {@code
     * other}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCode(final String code) {
      this.code = code;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof OutboundTransfer.ReturnedDetails)) return false;
      final OutboundTransfer.ReturnedDetails other = (OutboundTransfer.ReturnedDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$code = this.getCode();
      final java.lang.Object other$code = other.getCode();
      if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
      final java.lang.Object this$transaction = this.getTransaction();
      final java.lang.Object other$transaction = other.getTransaction();
      if (this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof OutboundTransfer.ReturnedDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $code = this.getCode();
      result = result * PRIME + ($code == null ? 43 : $code.hashCode());
      final java.lang.Object $transaction = this.getTransaction();
      result = result * PRIME + ($transaction == null ? 43 : $transaction.hashCode());
      return result;
    }
  }


  public static class StatusTransitions extends StripeObject {
    /**
     * Timestamp describing when an OutboundTransfer changed status to {@code canceled}.
     */
    @SerializedName("canceled_at")
    Long canceledAt;
    /**
     * Timestamp describing when an OutboundTransfer changed status to {@code failed}.
     */
    @SerializedName("failed_at")
    Long failedAt;
    /**
     * Timestamp describing when an OutboundTransfer changed status to {@code posted}.
     */
    @SerializedName("posted_at")
    Long postedAt;
    /**
     * Timestamp describing when an OutboundTransfer changed status to {@code returned}.
     */
    @SerializedName("returned_at")
    Long returnedAt;

    /**
     * Timestamp describing when an OutboundTransfer changed status to {@code canceled}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCanceledAt() {
      return this.canceledAt;
    }

    /**
     * Timestamp describing when an OutboundTransfer changed status to {@code failed}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getFailedAt() {
      return this.failedAt;
    }

    /**
     * Timestamp describing when an OutboundTransfer changed status to {@code posted}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPostedAt() {
      return this.postedAt;
    }

    /**
     * Timestamp describing when an OutboundTransfer changed status to {@code returned}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getReturnedAt() {
      return this.returnedAt;
    }

    /**
     * Timestamp describing when an OutboundTransfer changed status to {@code canceled}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCanceledAt(final Long canceledAt) {
      this.canceledAt = canceledAt;
    }

    /**
     * Timestamp describing when an OutboundTransfer changed status to {@code failed}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFailedAt(final Long failedAt) {
      this.failedAt = failedAt;
    }

    /**
     * Timestamp describing when an OutboundTransfer changed status to {@code posted}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPostedAt(final Long postedAt) {
      this.postedAt = postedAt;
    }

    /**
     * Timestamp describing when an OutboundTransfer changed status to {@code returned}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReturnedAt(final Long returnedAt) {
      this.returnedAt = returnedAt;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof OutboundTransfer.StatusTransitions)) return false;
      final OutboundTransfer.StatusTransitions other = (OutboundTransfer.StatusTransitions) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$canceledAt = this.getCanceledAt();
      final java.lang.Object other$canceledAt = other.getCanceledAt();
      if (this$canceledAt == null ? other$canceledAt != null : !this$canceledAt.equals(other$canceledAt)) return false;
      final java.lang.Object this$failedAt = this.getFailedAt();
      final java.lang.Object other$failedAt = other.getFailedAt();
      if (this$failedAt == null ? other$failedAt != null : !this$failedAt.equals(other$failedAt)) return false;
      final java.lang.Object this$postedAt = this.getPostedAt();
      final java.lang.Object other$postedAt = other.getPostedAt();
      if (this$postedAt == null ? other$postedAt != null : !this$postedAt.equals(other$postedAt)) return false;
      final java.lang.Object this$returnedAt = this.getReturnedAt();
      final java.lang.Object other$returnedAt = other.getReturnedAt();
      if (this$returnedAt == null ? other$returnedAt != null : !this$returnedAt.equals(other$returnedAt)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof OutboundTransfer.StatusTransitions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $canceledAt = this.getCanceledAt();
      result = result * PRIME + ($canceledAt == null ? 43 : $canceledAt.hashCode());
      final java.lang.Object $failedAt = this.getFailedAt();
      result = result * PRIME + ($failedAt == null ? 43 : $failedAt.hashCode());
      final java.lang.Object $postedAt = this.getPostedAt();
      result = result * PRIME + ($postedAt == null ? 43 : $postedAt.hashCode());
      final java.lang.Object $returnedAt = this.getReturnedAt();
      result = result * PRIME + ($returnedAt == null ? 43 : $returnedAt.hashCode());
      return result;
    }
  }

  public TestHelpers getTestHelpers() {
    return new TestHelpers(this);
  }


  public static class TestHelpers {
    private final OutboundTransfer resource;

    private TestHelpers(OutboundTransfer resource) {
      this.resource = resource;
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>failed</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer fail() throws StripeException {
      return fail((Map<String, Object>) null, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>failed</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer fail(RequestOptions options) throws StripeException {
      return fail((Map<String, Object>) null, options);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>failed</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer fail(Map<String, Object> params) throws StripeException {
      return fail(params, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>failed</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer fail(Map<String, Object> params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/outbound_transfers/%s/fail", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundTransfer.class, options);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>failed</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer fail(OutboundTransferFailParams params) throws StripeException {
      return fail(params, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>failed</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer fail(OutboundTransferFailParams params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/outbound_transfers/%s/fail", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundTransfer.class, options);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>posted</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer post() throws StripeException {
      return post((Map<String, Object>) null, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>posted</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer post(RequestOptions options) throws StripeException {
      return post((Map<String, Object>) null, options);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>posted</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer post(Map<String, Object> params) throws StripeException {
      return post(params, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>posted</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer post(Map<String, Object> params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/outbound_transfers/%s/post", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundTransfer.class, options);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>posted</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer post(OutboundTransferPostParams params) throws StripeException {
      return post(params, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>posted</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer post(OutboundTransferPostParams params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/outbound_transfers/%s/post", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundTransfer.class, options);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>returned</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer returnOutboundTransfer() throws StripeException {
      return returnOutboundTransfer((Map<String, Object>) null, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>returned</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer returnOutboundTransfer(RequestOptions options) throws StripeException {
      return returnOutboundTransfer((Map<String, Object>) null, options);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>returned</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer returnOutboundTransfer(Map<String, Object> params) throws StripeException {
      return returnOutboundTransfer(params, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>returned</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer returnOutboundTransfer(Map<String, Object> params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/outbound_transfers/%s/return", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundTransfer.class, options);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>returned</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer returnOutboundTransfer(OutboundTransferReturnOutboundTransferParams params) throws StripeException {
      return returnOutboundTransfer(params, (RequestOptions) null);
    }

    /**
     * Transitions a test mode created OutboundTransfer to the <code>returned</code> status. The
     * OutboundTransfer must already be in the <code>processing</code> state.
     */
    public OutboundTransfer returnOutboundTransfer(OutboundTransferReturnOutboundTransferParams params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/treasury/outbound_transfers/%s/return", ApiResource.urlEncodeId(this.resource.getId())));
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, OutboundTransfer.class, options);
    }
  }

  /**
   * Amount (in cents) transferred.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Returns {@code true} if the object can be canceled, and {@code false} otherwise.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getCancelable() {
    return this.cancelable;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * The PaymentMethod used as the payment instrument for an OutboundTransfer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDestinationPaymentMethod() {
    return this.destinationPaymentMethod;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DestinationPaymentMethodDetails getDestinationPaymentMethodDetails() {
    return this.destinationPaymentMethodDetails;
  }

  /**
   * The date when funds are expected to arrive in the destination account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getExpectedArrivalDate() {
    return this.expectedArrivalDate;
  }

  /**
   * The FinancialAccount that funds were pulled from.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFinancialAccount() {
    return this.financialAccount;
  }

  /**
   * A <a href="https://stripe.com/docs/treasury/moving-money/regulatory-receipts">hosted
   * transaction receipt</a> URL that is provided when money movement is considered regulated under
   * Stripe's money transmission licenses.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHostedRegulatoryReceiptUrl() {
    return this.hostedRegulatoryReceiptUrl;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }

  /**
   * Details about the network used for the OutboundTransfer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public NetworkDetails getNetworkDetails() {
    return this.networkDetails;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.outbound_transfer}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Details about a returned OutboundTransfer. Only set when the status is {@code returned}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ReturnedDetails getReturnedDetails() {
    return this.returnedDetails;
  }

  /**
   * Information about the OutboundTransfer to be sent to the recipient account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatementDescriptor() {
    return this.statementDescriptor;
  }

  /**
   * Current status of the OutboundTransfer: {@code processing}, {@code failed}, {@code canceled},
   * {@code posted}, {@code returned}. An OutboundTransfer is {@code processing} if it has been
   * created and is pending. The status changes to {@code posted} once the OutboundTransfer has been
   * &quot;confirmed&quot; and funds have left the account, or to {@code failed} or {@code
   * canceled}. If an OutboundTransfer fails to arrive at its destination, its status will change to
   * {@code returned}.
   *
   * <p>One of {@code canceled}, {@code failed}, {@code posted}, {@code processing}, or {@code
   * returned}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public StatusTransitions getStatusTransitions() {
    return this.statusTransitions;
  }

  /**
   * Amount (in cents) transferred.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Returns {@code true} if the object can be canceled, and {@code false} otherwise.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCancelable(final Boolean cancelable) {
    this.cancelable = cancelable;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * The PaymentMethod used as the payment instrument for an OutboundTransfer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDestinationPaymentMethod(final String destinationPaymentMethod) {
    this.destinationPaymentMethod = destinationPaymentMethod;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDestinationPaymentMethodDetails(final DestinationPaymentMethodDetails destinationPaymentMethodDetails) {
    this.destinationPaymentMethodDetails = destinationPaymentMethodDetails;
  }

  /**
   * The date when funds are expected to arrive in the destination account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExpectedArrivalDate(final Long expectedArrivalDate) {
    this.expectedArrivalDate = expectedArrivalDate;
  }

  /**
   * The FinancialAccount that funds were pulled from.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinancialAccount(final String financialAccount) {
    this.financialAccount = financialAccount;
  }

  /**
   * A <a href="https://stripe.com/docs/treasury/moving-money/regulatory-receipts">hosted
   * transaction receipt</a> URL that is provided when money movement is considered regulated under
   * Stripe's money transmission licenses.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHostedRegulatoryReceiptUrl(final String hostedRegulatoryReceiptUrl) {
    this.hostedRegulatoryReceiptUrl = hostedRegulatoryReceiptUrl;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * Details about the network used for the OutboundTransfer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNetworkDetails(final NetworkDetails networkDetails) {
    this.networkDetails = networkDetails;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.outbound_transfer}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Details about a returned OutboundTransfer. Only set when the status is {@code returned}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReturnedDetails(final ReturnedDetails returnedDetails) {
    this.returnedDetails = returnedDetails;
  }

  /**
   * Information about the OutboundTransfer to be sent to the recipient account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatementDescriptor(final String statementDescriptor) {
    this.statementDescriptor = statementDescriptor;
  }

  /**
   * Current status of the OutboundTransfer: {@code processing}, {@code failed}, {@code canceled},
   * {@code posted}, {@code returned}. An OutboundTransfer is {@code processing} if it has been
   * created and is pending. The status changes to {@code posted} once the OutboundTransfer has been
   * &quot;confirmed&quot; and funds have left the account, or to {@code failed} or {@code
   * canceled}. If an OutboundTransfer fails to arrive at its destination, its status will change to
   * {@code returned}.
   *
   * <p>One of {@code canceled}, {@code failed}, {@code posted}, {@code processing}, or {@code
   * returned}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatusTransitions(final StatusTransitions statusTransitions) {
    this.statusTransitions = statusTransitions;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof OutboundTransfer)) return false;
    final OutboundTransfer other = (OutboundTransfer) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$cancelable = this.getCancelable();
    final java.lang.Object other$cancelable = other.getCancelable();
    if (this$cancelable == null ? other$cancelable != null : !this$cancelable.equals(other$cancelable)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$expectedArrivalDate = this.getExpectedArrivalDate();
    final java.lang.Object other$expectedArrivalDate = other.getExpectedArrivalDate();
    if (this$expectedArrivalDate == null ? other$expectedArrivalDate != null : !this$expectedArrivalDate.equals(other$expectedArrivalDate)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$destinationPaymentMethod = this.getDestinationPaymentMethod();
    final java.lang.Object other$destinationPaymentMethod = other.getDestinationPaymentMethod();
    if (this$destinationPaymentMethod == null ? other$destinationPaymentMethod != null : !this$destinationPaymentMethod.equals(other$destinationPaymentMethod)) return false;
    final java.lang.Object this$destinationPaymentMethodDetails = this.getDestinationPaymentMethodDetails();
    final java.lang.Object other$destinationPaymentMethodDetails = other.getDestinationPaymentMethodDetails();
    if (this$destinationPaymentMethodDetails == null ? other$destinationPaymentMethodDetails != null : !this$destinationPaymentMethodDetails.equals(other$destinationPaymentMethodDetails)) return false;
    final java.lang.Object this$financialAccount = this.getFinancialAccount();
    final java.lang.Object other$financialAccount = other.getFinancialAccount();
    if (this$financialAccount == null ? other$financialAccount != null : !this$financialAccount.equals(other$financialAccount)) return false;
    final java.lang.Object this$hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
    final java.lang.Object other$hostedRegulatoryReceiptUrl = other.getHostedRegulatoryReceiptUrl();
    if (this$hostedRegulatoryReceiptUrl == null ? other$hostedRegulatoryReceiptUrl != null : !this$hostedRegulatoryReceiptUrl.equals(other$hostedRegulatoryReceiptUrl)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$networkDetails = this.getNetworkDetails();
    final java.lang.Object other$networkDetails = other.getNetworkDetails();
    if (this$networkDetails == null ? other$networkDetails != null : !this$networkDetails.equals(other$networkDetails)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$returnedDetails = this.getReturnedDetails();
    final java.lang.Object other$returnedDetails = other.getReturnedDetails();
    if (this$returnedDetails == null ? other$returnedDetails != null : !this$returnedDetails.equals(other$returnedDetails)) return false;
    final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
    final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
    if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$statusTransitions = this.getStatusTransitions();
    final java.lang.Object other$statusTransitions = other.getStatusTransitions();
    if (this$statusTransitions == null ? other$statusTransitions != null : !this$statusTransitions.equals(other$statusTransitions)) return false;
    final java.lang.Object this$transaction = this.getTransaction();
    final java.lang.Object other$transaction = other.getTransaction();
    if (this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof OutboundTransfer;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $cancelable = this.getCancelable();
    result = result * PRIME + ($cancelable == null ? 43 : $cancelable.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $expectedArrivalDate = this.getExpectedArrivalDate();
    result = result * PRIME + ($expectedArrivalDate == null ? 43 : $expectedArrivalDate.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $destinationPaymentMethod = this.getDestinationPaymentMethod();
    result = result * PRIME + ($destinationPaymentMethod == null ? 43 : $destinationPaymentMethod.hashCode());
    final java.lang.Object $destinationPaymentMethodDetails = this.getDestinationPaymentMethodDetails();
    result = result * PRIME + ($destinationPaymentMethodDetails == null ? 43 : $destinationPaymentMethodDetails.hashCode());
    final java.lang.Object $financialAccount = this.getFinancialAccount();
    result = result * PRIME + ($financialAccount == null ? 43 : $financialAccount.hashCode());
    final java.lang.Object $hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
    result = result * PRIME + ($hostedRegulatoryReceiptUrl == null ? 43 : $hostedRegulatoryReceiptUrl.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $networkDetails = this.getNetworkDetails();
    result = result * PRIME + ($networkDetails == null ? 43 : $networkDetails.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $returnedDetails = this.getReturnedDetails();
    result = result * PRIME + ($returnedDetails == null ? 43 : $returnedDetails.hashCode());
    final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
    result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $statusTransitions = this.getStatusTransitions();
    result = result * PRIME + ($statusTransitions == null ? 43 : $statusTransitions.hashCode());
    final java.lang.Object $transaction = this.getTransaction();
    result = result * PRIME + ($transaction == null ? 43 : $transaction.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
