// Generated by delombok at Fri Oct 14 21:20:25 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.treasury.TransactionEntryListParams;
import com.stripe.param.treasury.TransactionEntryRetrieveParams;
import java.util.Map;

/**
 * TransactionEntries represent individual units of money movements within a single <a
 * href="https://stripe.com/docs/api#transactions">Transaction</a>.
 */
public class TransactionEntry extends ApiResource implements HasId {
  /**
   * Change to a FinancialAccount's balance.
   */
  @SerializedName("balance_impact")
  BalanceImpact balanceImpact;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * When the TransactionEntry will impact the FinancialAccount's balance.
   */
  @SerializedName("effective_at")
  Long effectiveAt;
  /**
   * The FinancialAccount associated with this object.
   */
  @SerializedName("financial_account")
  String financialAccount;
  /**
   * Token of the flow associated with the TransactionEntry.
   */
  @SerializedName("flow")
  String flow;
  /**
   * Details of the flow associated with the TransactionEntry.
   */
  @SerializedName("flow_details")
  FlowDetails flowDetails;
  /**
   * Type of the flow associated with the TransactionEntry.
   *
   * <p>One of {@code credit_reversal}, {@code debit_reversal}, {@code inbound_transfer}, {@code
   * issuing_authorization}, {@code other}, {@code outbound_payment}, {@code outbound_transfer},
   * {@code received_credit}, or {@code received_debit}.
   */
  @SerializedName("flow_type")
  String flowType;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.transaction_entry}.
   */
  @SerializedName("object")
  String object;
  /**
   * The Transaction associated with this object.
   */
  @SerializedName("transaction")
  ExpandableField<Transaction> transaction;
  /**
   * The specific money movement that generated the TransactionEntry.
   *
   * <p>One of {@code credit_reversal}, {@code credit_reversal_posting}, {@code debit_reversal},
   * {@code inbound_transfer}, {@code inbound_transfer_return}, {@code issuing_authorization_hold},
   * {@code issuing_authorization_release}, {@code other}, {@code outbound_payment}, {@code
   * outbound_payment_cancellation}, {@code outbound_payment_failure}, {@code
   * outbound_payment_posting}, {@code outbound_payment_return}, {@code outbound_transfer}, {@code
   * outbound_transfer_cancellation}, {@code outbound_transfer_failure}, {@code
   * outbound_transfer_posting}, {@code outbound_transfer_return}, {@code received_credit}, or
   * {@code received_debit}.
   */
  @SerializedName("type")
  String type;

  /**
   * Get ID of expandable {@code transaction} object.
   */
  public String getTransaction() {
    return (this.transaction != null) ? this.transaction.getId() : null;
  }

  public void setTransaction(String id) {
    this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
  }

  /**
   * Get expanded {@code transaction}.
   */
  public Transaction getTransactionObject() {
    return (this.transaction != null) ? this.transaction.getExpanded() : null;
  }

  public void setTransactionObject(Transaction expandableObject) {
    this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
  }

  /**
   * Retrieves a list of TransactionEntry objects.
   */
  public static TransactionEntryCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Retrieves a list of TransactionEntry objects.
   */
  public static TransactionEntryCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/transaction_entries");
    return ApiResource.requestCollection(url, params, TransactionEntryCollection.class, options);
  }

  /**
   * Retrieves a list of TransactionEntry objects.
   */
  public static TransactionEntryCollection list(TransactionEntryListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Retrieves a list of TransactionEntry objects.
   */
  public static TransactionEntryCollection list(TransactionEntryListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/transaction_entries");
    return ApiResource.requestCollection(url, params, TransactionEntryCollection.class, options);
  }

  /**
   * Retrieves a TransactionEntry object.
   */
  public static TransactionEntry retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves a TransactionEntry object.
   */
  public static TransactionEntry retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves a TransactionEntry object.
   */
  public static TransactionEntry retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/transaction_entries/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, TransactionEntry.class, options);
  }

  /**
   * Retrieves a TransactionEntry object.
   */
  public static TransactionEntry retrieve(String id, TransactionEntryRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/transaction_entries/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, TransactionEntry.class, options);
  }


  /**
   * Change to a FinancialAccount's balance.
   */
  public static class BalanceImpact extends StripeObject {
    /** The change made to funds the user can spend right now. */
    @SerializedName("cash")
    Long cash;
    /**
     * The change made to funds that are not spendable yet, but will become available at a later
     * time.
     */
    @SerializedName("inbound_pending")
    Long inboundPending;
    /**
     * The change made to funds in the account, but not spendable because they are being held for
     * pending outbound flows.
     */
    @SerializedName("outbound_pending")
    Long outboundPending;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCash() {
      return this.cash;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getInboundPending() {
      return this.inboundPending;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getOutboundPending() {
      return this.outboundPending;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCash(final Long cash) {
      this.cash = cash;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInboundPending(final Long inboundPending) {
      this.inboundPending = inboundPending;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOutboundPending(final Long outboundPending) {
      this.outboundPending = outboundPending;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof TransactionEntry.BalanceImpact)) return false;
      final TransactionEntry.BalanceImpact other = (TransactionEntry.BalanceImpact) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$cash = this.getCash();
      final java.lang.Object other$cash = other.getCash();
      if (this$cash == null ? other$cash != null : !this$cash.equals(other$cash)) return false;
      final java.lang.Object this$inboundPending = this.getInboundPending();
      final java.lang.Object other$inboundPending = other.getInboundPending();
      if (this$inboundPending == null ? other$inboundPending != null : !this$inboundPending.equals(other$inboundPending)) return false;
      final java.lang.Object this$outboundPending = this.getOutboundPending();
      final java.lang.Object other$outboundPending = other.getOutboundPending();
      if (this$outboundPending == null ? other$outboundPending != null : !this$outboundPending.equals(other$outboundPending)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof TransactionEntry.BalanceImpact;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $cash = this.getCash();
      result = result * PRIME + ($cash == null ? 43 : $cash.hashCode());
      final java.lang.Object $inboundPending = this.getInboundPending();
      result = result * PRIME + ($inboundPending == null ? 43 : $inboundPending.hashCode());
      final java.lang.Object $outboundPending = this.getOutboundPending();
      result = result * PRIME + ($outboundPending == null ? 43 : $outboundPending.hashCode());
      return result;
    }
  }

  /**
   * Change to a FinancialAccount's balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BalanceImpact getBalanceImpact() {
    return this.balanceImpact;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * When the TransactionEntry will impact the FinancialAccount's balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getEffectiveAt() {
    return this.effectiveAt;
  }

  /**
   * The FinancialAccount associated with this object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFinancialAccount() {
    return this.financialAccount;
  }

  /**
   * Token of the flow associated with the TransactionEntry.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFlow() {
    return this.flow;
  }

  /**
   * Details of the flow associated with the TransactionEntry.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public FlowDetails getFlowDetails() {
    return this.flowDetails;
  }

  /**
   * Type of the flow associated with the TransactionEntry.
   *
   * <p>One of {@code credit_reversal}, {@code debit_reversal}, {@code inbound_transfer}, {@code
   * issuing_authorization}, {@code other}, {@code outbound_payment}, {@code outbound_transfer},
   * {@code received_credit}, or {@code received_debit}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFlowType() {
    return this.flowType;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.transaction_entry}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The specific money movement that generated the TransactionEntry.
   *
   * <p>One of {@code credit_reversal}, {@code credit_reversal_posting}, {@code debit_reversal},
   * {@code inbound_transfer}, {@code inbound_transfer_return}, {@code issuing_authorization_hold},
   * {@code issuing_authorization_release}, {@code other}, {@code outbound_payment}, {@code
   * outbound_payment_cancellation}, {@code outbound_payment_failure}, {@code
   * outbound_payment_posting}, {@code outbound_payment_return}, {@code outbound_transfer}, {@code
   * outbound_transfer_cancellation}, {@code outbound_transfer_failure}, {@code
   * outbound_transfer_posting}, {@code outbound_transfer_return}, {@code received_credit}, or
   * {@code received_debit}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * Change to a FinancialAccount's balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBalanceImpact(final BalanceImpact balanceImpact) {
    this.balanceImpact = balanceImpact;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * When the TransactionEntry will impact the FinancialAccount's balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEffectiveAt(final Long effectiveAt) {
    this.effectiveAt = effectiveAt;
  }

  /**
   * The FinancialAccount associated with this object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinancialAccount(final String financialAccount) {
    this.financialAccount = financialAccount;
  }

  /**
   * Token of the flow associated with the TransactionEntry.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFlow(final String flow) {
    this.flow = flow;
  }

  /**
   * Details of the flow associated with the TransactionEntry.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFlowDetails(final FlowDetails flowDetails) {
    this.flowDetails = flowDetails;
  }

  /**
   * Type of the flow associated with the TransactionEntry.
   *
   * <p>One of {@code credit_reversal}, {@code debit_reversal}, {@code inbound_transfer}, {@code
   * issuing_authorization}, {@code other}, {@code outbound_payment}, {@code outbound_transfer},
   * {@code received_credit}, or {@code received_debit}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFlowType(final String flowType) {
    this.flowType = flowType;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.transaction_entry}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The specific money movement that generated the TransactionEntry.
   *
   * <p>One of {@code credit_reversal}, {@code credit_reversal_posting}, {@code debit_reversal},
   * {@code inbound_transfer}, {@code inbound_transfer_return}, {@code issuing_authorization_hold},
   * {@code issuing_authorization_release}, {@code other}, {@code outbound_payment}, {@code
   * outbound_payment_cancellation}, {@code outbound_payment_failure}, {@code
   * outbound_payment_posting}, {@code outbound_payment_return}, {@code outbound_transfer}, {@code
   * outbound_transfer_cancellation}, {@code outbound_transfer_failure}, {@code
   * outbound_transfer_posting}, {@code outbound_transfer_return}, {@code received_credit}, or
   * {@code received_debit}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof TransactionEntry)) return false;
    final TransactionEntry other = (TransactionEntry) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$effectiveAt = this.getEffectiveAt();
    final java.lang.Object other$effectiveAt = other.getEffectiveAt();
    if (this$effectiveAt == null ? other$effectiveAt != null : !this$effectiveAt.equals(other$effectiveAt)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$balanceImpact = this.getBalanceImpact();
    final java.lang.Object other$balanceImpact = other.getBalanceImpact();
    if (this$balanceImpact == null ? other$balanceImpact != null : !this$balanceImpact.equals(other$balanceImpact)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$financialAccount = this.getFinancialAccount();
    final java.lang.Object other$financialAccount = other.getFinancialAccount();
    if (this$financialAccount == null ? other$financialAccount != null : !this$financialAccount.equals(other$financialAccount)) return false;
    final java.lang.Object this$flow = this.getFlow();
    final java.lang.Object other$flow = other.getFlow();
    if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) return false;
    final java.lang.Object this$flowDetails = this.getFlowDetails();
    final java.lang.Object other$flowDetails = other.getFlowDetails();
    if (this$flowDetails == null ? other$flowDetails != null : !this$flowDetails.equals(other$flowDetails)) return false;
    final java.lang.Object this$flowType = this.getFlowType();
    final java.lang.Object other$flowType = other.getFlowType();
    if (this$flowType == null ? other$flowType != null : !this$flowType.equals(other$flowType)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$transaction = this.getTransaction();
    final java.lang.Object other$transaction = other.getTransaction();
    if (this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof TransactionEntry;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $effectiveAt = this.getEffectiveAt();
    result = result * PRIME + ($effectiveAt == null ? 43 : $effectiveAt.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $balanceImpact = this.getBalanceImpact();
    result = result * PRIME + ($balanceImpact == null ? 43 : $balanceImpact.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $financialAccount = this.getFinancialAccount();
    result = result * PRIME + ($financialAccount == null ? 43 : $financialAccount.hashCode());
    final java.lang.Object $flow = this.getFlow();
    result = result * PRIME + ($flow == null ? 43 : $flow.hashCode());
    final java.lang.Object $flowDetails = this.getFlowDetails();
    result = result * PRIME + ($flowDetails == null ? 43 : $flowDetails.hashCode());
    final java.lang.Object $flowType = this.getFlowType();
    result = result * PRIME + ($flowType == null ? 43 : $flowType.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $transaction = this.getTransaction();
    result = result * PRIME + ($transaction == null ? 43 : $transaction.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
