// Generated by delombok at Wed Nov 02 20:17:59 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.capital;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.capital.FinancingOfferListParams;
import com.stripe.param.capital.FinancingOfferMarkDeliveredParams;
import com.stripe.param.capital.FinancingOfferRetrieveParams;
import java.math.BigDecimal;
import java.util.Map;

/**
 * This is an object representing an offer of financing from Stripe Capital to a Connect subaccount.
 */
public class FinancingOffer extends ApiResource implements HasId {
  /**
   * This is an object representing the terms of an offer of financing from Stripe Capital to a
   * Connected account. This resource represents the terms accepted by the Connected account, which
   * may differ from those offered.
   */
  @SerializedName("accepted_terms")
  AcceptedTerms acceptedTerms;
  /**
   * The ID of the merchant associated with this financing object.
   */
  @SerializedName("account")
  String account;
  /**
   * Time at which the offer was created. Given in seconds since unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Time at which the offer expires. Given in seconds since unix epoch.
   */
  @SerializedName("expires_after")
  BigDecimal expiresAfter;
  /**
   * The type of financing being offered.
   *
   * <p>One of {@code cash_advance}, or {@code flex_loan}.
   */
  @SerializedName("financing_type")
  String financingType;
  /**
   * A unique identifier for the financing object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * The object type: financing_offer.
   *
   * <p>Equal to {@code capital.financing_offer}.
   */
  @SerializedName("object")
  String object;
  /**
   * This is an object representing the terms of an offer of financing from Stripe Capital to a
   * Connected account. This resource represents both the terms offered to the Connected account.
   */
  @SerializedName("offered_terms")
  OfferedTerms offeredTerms;
  /**
   * Financing product identifier.
   *
   * <p>One of {@code refill}, or {@code standard}.
   */
  @SerializedName("product_type")
  String productType;
  /**
   * The ID of the financing offer that replaced this offer.
   */
  @SerializedName("replacement")
  String replacement;
  /**
   * The ID of the financing offer that this offer is a replacement for.
   */
  @SerializedName("replacement_for")
  String replacementFor;
  /**
   * The current status of the offer.
   *
   * <p>One of {@code accepted}, {@code canceled}, {@code completed}, {@code delivered}, {@code
   * expired}, {@code fully_repaid}, {@code paid_out}, {@code rejected}, {@code replaced}, or {@code
   * undelivered}.
   */
  @SerializedName("status")
  String status;
  /**
   * See <a
   * href="https://stripe.com/docs/api/capital/connect_financing_object#financing_offer_object-financing_type">financing_type</a>.
   *
   * <p>One of {@code cash_advance}, or {@code flex_loan}.
   */
  @SerializedName("type")
  String type;

  /**
   * Retrieves the financing offers available for Connected accounts that belong to your platform.
   */
  public static FinancingOfferCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Retrieves the financing offers available for Connected accounts that belong to your platform.
   */
  public static FinancingOfferCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/capital/financing_offers");
    return ApiResource.requestCollection(url, params, FinancingOfferCollection.class, options);
  }

  /**
   * Retrieves the financing offers available for Connected accounts that belong to your platform.
   */
  public static FinancingOfferCollection list(FinancingOfferListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Retrieves the financing offers available for Connected accounts that belong to your platform.
   */
  public static FinancingOfferCollection list(FinancingOfferListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/capital/financing_offers");
    return ApiResource.requestCollection(url, params, FinancingOfferCollection.class, options);
  }

  /**
   * Acknowledges that platform has received and delivered the financing_offer to the intended
   * merchant recipient. This is required to make the application accessible.
   */
  public FinancingOffer markDelivered() throws StripeException {
    return markDelivered((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Acknowledges that platform has received and delivered the financing_offer to the intended
   * merchant recipient. This is required to make the application accessible.
   */
  public FinancingOffer markDelivered(RequestOptions options) throws StripeException {
    return markDelivered((Map<String, Object>) null, options);
  }

  /**
   * Acknowledges that platform has received and delivered the financing_offer to the intended
   * merchant recipient. This is required to make the application accessible.
   */
  public FinancingOffer markDelivered(Map<String, Object> params) throws StripeException {
    return markDelivered(params, (RequestOptions) null);
  }

  /**
   * Acknowledges that platform has received and delivered the financing_offer to the intended
   * merchant recipient. This is required to make the application accessible.
   */
  public FinancingOffer markDelivered(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/capital/financing_offers/%s/mark_delivered", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, FinancingOffer.class, options);
  }

  /**
   * Acknowledges that platform has received and delivered the financing_offer to the intended
   * merchant recipient. This is required to make the application accessible.
   */
  public FinancingOffer markDelivered(FinancingOfferMarkDeliveredParams params) throws StripeException {
    return markDelivered(params, (RequestOptions) null);
  }

  /**
   * Acknowledges that platform has received and delivered the financing_offer to the intended
   * merchant recipient. This is required to make the application accessible.
   */
  public FinancingOffer markDelivered(FinancingOfferMarkDeliveredParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/capital/financing_offers/%s/mark_delivered", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, FinancingOffer.class, options);
  }

  /**
   * Get the details of the financing offer.
   */
  public static FinancingOffer retrieve(String financingOffer) throws StripeException {
    return retrieve(financingOffer, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Get the details of the financing offer.
   */
  public static FinancingOffer retrieve(String financingOffer, RequestOptions options) throws StripeException {
    return retrieve(financingOffer, (Map<String, Object>) null, options);
  }

  /**
   * Get the details of the financing offer.
   */
  public static FinancingOffer retrieve(String financingOffer, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/capital/financing_offers/%s", ApiResource.urlEncodeId(financingOffer)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FinancingOffer.class, options);
  }

  /**
   * Get the details of the financing offer.
   */
  public static FinancingOffer retrieve(String financingOffer, FinancingOfferRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/capital/financing_offers/%s", ApiResource.urlEncodeId(financingOffer)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FinancingOffer.class, options);
  }


  /**
   * This is an object representing the terms of an offer of financing from Stripe Capital to a
   * Connected account. This resource represents the terms accepted by the Connected account, which
   * may differ from those offered.
   */
  public static class AcceptedTerms extends StripeObject {
    /**
     * Amount of financing offered, in minor units.
     */
    @SerializedName("advance_amount")
    Long advanceAmount;
    /**
     * Currency that the financing offer is transacted in. For example, {@code usd}.
     */
    @SerializedName("currency")
    String currency;
    /**
     * Fixed fee amount, in minor units.
     */
    @SerializedName("fee_amount")
    Long feeAmount;
    /**
     * Populated when the {@code product_type} of the {@code financingoffer} is {@code refill}.
     * Represents the discount amount on remaining premium for the existing loan at payout time.
     */
    @SerializedName("previous_financing_fee_discount_amount")
    Long previousFinancingFeeDiscountAmount;
    /**
     * Per-transaction rate at which Stripe will withhold funds to repay the financing.
     */
    @SerializedName("withhold_rate")
    BigDecimal withholdRate;

    /**
     * Amount of financing offered, in minor units.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAdvanceAmount() {
      return this.advanceAmount;
    }

    /**
     * Currency that the financing offer is transacted in. For example, {@code usd}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCurrency() {
      return this.currency;
    }

    /**
     * Fixed fee amount, in minor units.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getFeeAmount() {
      return this.feeAmount;
    }

    /**
     * Populated when the {@code product_type} of the {@code financingoffer} is {@code refill}.
     * Represents the discount amount on remaining premium for the existing loan at payout time.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPreviousFinancingFeeDiscountAmount() {
      return this.previousFinancingFeeDiscountAmount;
    }

    /**
     * Per-transaction rate at which Stripe will withhold funds to repay the financing.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BigDecimal getWithholdRate() {
      return this.withholdRate;
    }

    /**
     * Amount of financing offered, in minor units.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAdvanceAmount(final Long advanceAmount) {
      this.advanceAmount = advanceAmount;
    }

    /**
     * Currency that the financing offer is transacted in. For example, {@code usd}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrency(final String currency) {
      this.currency = currency;
    }

    /**
     * Fixed fee amount, in minor units.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFeeAmount(final Long feeAmount) {
      this.feeAmount = feeAmount;
    }

    /**
     * Populated when the {@code product_type} of the {@code financingoffer} is {@code refill}.
     * Represents the discount amount on remaining premium for the existing loan at payout time.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPreviousFinancingFeeDiscountAmount(final Long previousFinancingFeeDiscountAmount) {
      this.previousFinancingFeeDiscountAmount = previousFinancingFeeDiscountAmount;
    }

    /**
     * Per-transaction rate at which Stripe will withhold funds to repay the financing.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setWithholdRate(final BigDecimal withholdRate) {
      this.withholdRate = withholdRate;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FinancingOffer.AcceptedTerms)) return false;
      final FinancingOffer.AcceptedTerms other = (FinancingOffer.AcceptedTerms) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$advanceAmount = this.getAdvanceAmount();
      final java.lang.Object other$advanceAmount = other.getAdvanceAmount();
      if (this$advanceAmount == null ? other$advanceAmount != null : !this$advanceAmount.equals(other$advanceAmount)) return false;
      final java.lang.Object this$feeAmount = this.getFeeAmount();
      final java.lang.Object other$feeAmount = other.getFeeAmount();
      if (this$feeAmount == null ? other$feeAmount != null : !this$feeAmount.equals(other$feeAmount)) return false;
      final java.lang.Object this$previousFinancingFeeDiscountAmount = this.getPreviousFinancingFeeDiscountAmount();
      final java.lang.Object other$previousFinancingFeeDiscountAmount = other.getPreviousFinancingFeeDiscountAmount();
      if (this$previousFinancingFeeDiscountAmount == null ? other$previousFinancingFeeDiscountAmount != null : !this$previousFinancingFeeDiscountAmount.equals(other$previousFinancingFeeDiscountAmount)) return false;
      final java.lang.Object this$currency = this.getCurrency();
      final java.lang.Object other$currency = other.getCurrency();
      if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
      final java.lang.Object this$withholdRate = this.getWithholdRate();
      final java.lang.Object other$withholdRate = other.getWithholdRate();
      if (this$withholdRate == null ? other$withholdRate != null : !this$withholdRate.equals(other$withholdRate)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FinancingOffer.AcceptedTerms;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $advanceAmount = this.getAdvanceAmount();
      result = result * PRIME + ($advanceAmount == null ? 43 : $advanceAmount.hashCode());
      final java.lang.Object $feeAmount = this.getFeeAmount();
      result = result * PRIME + ($feeAmount == null ? 43 : $feeAmount.hashCode());
      final java.lang.Object $previousFinancingFeeDiscountAmount = this.getPreviousFinancingFeeDiscountAmount();
      result = result * PRIME + ($previousFinancingFeeDiscountAmount == null ? 43 : $previousFinancingFeeDiscountAmount.hashCode());
      final java.lang.Object $currency = this.getCurrency();
      result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
      final java.lang.Object $withholdRate = this.getWithholdRate();
      result = result * PRIME + ($withholdRate == null ? 43 : $withholdRate.hashCode());
      return result;
    }
  }


  /**
   * This is an object representing the terms of an offer of financing from Stripe Capital to a
   * Connected account. This resource represents both the terms offered to the Connected account.
   */
  public static class OfferedTerms extends StripeObject {
    /** Amount of financing offered, in minor units. */
    @SerializedName("advance_amount")
    Long advanceAmount;
    /**
     * Describes the type of user the offer is being extended to.
     *
     * <p>One of {@code newly_eligible_user}, {@code previously_eligible_user}, or {@code
     * repeat_user}.
     */
    @SerializedName("campaign_type")
    String campaignType;
    /** Currency that the financing offer is transacted in. For example, {@code usd}. */
    @SerializedName("currency")
    String currency;
    /** Fixed fee amount, in minor units. */
    @SerializedName("fee_amount")
    Long feeAmount;
    /**
     * Populated when the {@code product_type} of the {@code financingoffer} is {@code refill}.
     * Represents the discount rate percentage on remaining fee on the existing loan. When the
     * {@code financing_offer} is paid out, the {@code previous_financing_fee_discount_amount} will
     * be computed as the multiple of this rate and the remaining fee.
     */
    @SerializedName("previous_financing_fee_discount_rate")
    BigDecimal previousFinancingFeeDiscountRate;
    /** Per-transaction rate at which Stripe will withhold funds to repay the financing. */
    @SerializedName("withhold_rate")
    BigDecimal withholdRate;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAdvanceAmount() {
      return this.advanceAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCampaignType() {
      return this.campaignType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCurrency() {
      return this.currency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getFeeAmount() {
      return this.feeAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BigDecimal getPreviousFinancingFeeDiscountRate() {
      return this.previousFinancingFeeDiscountRate;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BigDecimal getWithholdRate() {
      return this.withholdRate;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAdvanceAmount(final Long advanceAmount) {
      this.advanceAmount = advanceAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCampaignType(final String campaignType) {
      this.campaignType = campaignType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrency(final String currency) {
      this.currency = currency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFeeAmount(final Long feeAmount) {
      this.feeAmount = feeAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPreviousFinancingFeeDiscountRate(final BigDecimal previousFinancingFeeDiscountRate) {
      this.previousFinancingFeeDiscountRate = previousFinancingFeeDiscountRate;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setWithholdRate(final BigDecimal withholdRate) {
      this.withholdRate = withholdRate;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FinancingOffer.OfferedTerms)) return false;
      final FinancingOffer.OfferedTerms other = (FinancingOffer.OfferedTerms) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$advanceAmount = this.getAdvanceAmount();
      final java.lang.Object other$advanceAmount = other.getAdvanceAmount();
      if (this$advanceAmount == null ? other$advanceAmount != null : !this$advanceAmount.equals(other$advanceAmount)) return false;
      final java.lang.Object this$feeAmount = this.getFeeAmount();
      final java.lang.Object other$feeAmount = other.getFeeAmount();
      if (this$feeAmount == null ? other$feeAmount != null : !this$feeAmount.equals(other$feeAmount)) return false;
      final java.lang.Object this$campaignType = this.getCampaignType();
      final java.lang.Object other$campaignType = other.getCampaignType();
      if (this$campaignType == null ? other$campaignType != null : !this$campaignType.equals(other$campaignType)) return false;
      final java.lang.Object this$currency = this.getCurrency();
      final java.lang.Object other$currency = other.getCurrency();
      if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
      final java.lang.Object this$previousFinancingFeeDiscountRate = this.getPreviousFinancingFeeDiscountRate();
      final java.lang.Object other$previousFinancingFeeDiscountRate = other.getPreviousFinancingFeeDiscountRate();
      if (this$previousFinancingFeeDiscountRate == null ? other$previousFinancingFeeDiscountRate != null : !this$previousFinancingFeeDiscountRate.equals(other$previousFinancingFeeDiscountRate)) return false;
      final java.lang.Object this$withholdRate = this.getWithholdRate();
      final java.lang.Object other$withholdRate = other.getWithholdRate();
      if (this$withholdRate == null ? other$withholdRate != null : !this$withholdRate.equals(other$withholdRate)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FinancingOffer.OfferedTerms;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $advanceAmount = this.getAdvanceAmount();
      result = result * PRIME + ($advanceAmount == null ? 43 : $advanceAmount.hashCode());
      final java.lang.Object $feeAmount = this.getFeeAmount();
      result = result * PRIME + ($feeAmount == null ? 43 : $feeAmount.hashCode());
      final java.lang.Object $campaignType = this.getCampaignType();
      result = result * PRIME + ($campaignType == null ? 43 : $campaignType.hashCode());
      final java.lang.Object $currency = this.getCurrency();
      result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
      final java.lang.Object $previousFinancingFeeDiscountRate = this.getPreviousFinancingFeeDiscountRate();
      result = result * PRIME + ($previousFinancingFeeDiscountRate == null ? 43 : $previousFinancingFeeDiscountRate.hashCode());
      final java.lang.Object $withholdRate = this.getWithholdRate();
      result = result * PRIME + ($withholdRate == null ? 43 : $withholdRate.hashCode());
      return result;
    }
  }

  /**
   * This is an object representing the terms of an offer of financing from Stripe Capital to a
   * Connected account. This resource represents the terms accepted by the Connected account, which
   * may differ from those offered.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AcceptedTerms getAcceptedTerms() {
    return this.acceptedTerms;
  }

  /**
   * The ID of the merchant associated with this financing object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAccount() {
    return this.account;
  }

  /**
   * Time at which the offer was created. Given in seconds since unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Time at which the offer expires. Given in seconds since unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getExpiresAfter() {
    return this.expiresAfter;
  }

  /**
   * The type of financing being offered.
   *
   * <p>One of {@code cash_advance}, or {@code flex_loan}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFinancingType() {
    return this.financingType;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }

  /**
   * The object type: financing_offer.
   *
   * <p>Equal to {@code capital.financing_offer}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * This is an object representing the terms of an offer of financing from Stripe Capital to a
   * Connected account. This resource represents both the terms offered to the Connected account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public OfferedTerms getOfferedTerms() {
    return this.offeredTerms;
  }

  /**
   * Financing product identifier.
   *
   * <p>One of {@code refill}, or {@code standard}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getProductType() {
    return this.productType;
  }

  /**
   * The ID of the financing offer that replaced this offer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReplacement() {
    return this.replacement;
  }

  /**
   * The ID of the financing offer that this offer is a replacement for.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReplacementFor() {
    return this.replacementFor;
  }

  /**
   * The current status of the offer.
   *
   * <p>One of {@code accepted}, {@code canceled}, {@code completed}, {@code delivered}, {@code
   * expired}, {@code fully_repaid}, {@code paid_out}, {@code rejected}, {@code replaced}, or {@code
   * undelivered}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * See <a
   * href="https://stripe.com/docs/api/capital/connect_financing_object#financing_offer_object-financing_type">financing_type</a>.
   *
   * <p>One of {@code cash_advance}, or {@code flex_loan}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * This is an object representing the terms of an offer of financing from Stripe Capital to a
   * Connected account. This resource represents the terms accepted by the Connected account, which
   * may differ from those offered.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAcceptedTerms(final AcceptedTerms acceptedTerms) {
    this.acceptedTerms = acceptedTerms;
  }

  /**
   * The ID of the merchant associated with this financing object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAccount(final String account) {
    this.account = account;
  }

  /**
   * Time at which the offer was created. Given in seconds since unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Time at which the offer expires. Given in seconds since unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExpiresAfter(final BigDecimal expiresAfter) {
    this.expiresAfter = expiresAfter;
  }

  /**
   * The type of financing being offered.
   *
   * <p>One of {@code cash_advance}, or {@code flex_loan}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinancingType(final String financingType) {
    this.financingType = financingType;
  }

  /**
   * A unique identifier for the financing object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * The object type: financing_offer.
   *
   * <p>Equal to {@code capital.financing_offer}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * This is an object representing the terms of an offer of financing from Stripe Capital to a
   * Connected account. This resource represents both the terms offered to the Connected account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOfferedTerms(final OfferedTerms offeredTerms) {
    this.offeredTerms = offeredTerms;
  }

  /**
   * Financing product identifier.
   *
   * <p>One of {@code refill}, or {@code standard}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProductType(final String productType) {
    this.productType = productType;
  }

  /**
   * The ID of the financing offer that replaced this offer.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReplacement(final String replacement) {
    this.replacement = replacement;
  }

  /**
   * The ID of the financing offer that this offer is a replacement for.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReplacementFor(final String replacementFor) {
    this.replacementFor = replacementFor;
  }

  /**
   * The current status of the offer.
   *
   * <p>One of {@code accepted}, {@code canceled}, {@code completed}, {@code delivered}, {@code
   * expired}, {@code fully_repaid}, {@code paid_out}, {@code rejected}, {@code replaced}, or {@code
   * undelivered}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * See <a
   * href="https://stripe.com/docs/api/capital/connect_financing_object#financing_offer_object-financing_type">financing_type</a>.
   *
   * <p>One of {@code cash_advance}, or {@code flex_loan}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof FinancingOffer)) return false;
    final FinancingOffer other = (FinancingOffer) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$acceptedTerms = this.getAcceptedTerms();
    final java.lang.Object other$acceptedTerms = other.getAcceptedTerms();
    if (this$acceptedTerms == null ? other$acceptedTerms != null : !this$acceptedTerms.equals(other$acceptedTerms)) return false;
    final java.lang.Object this$account = this.getAccount();
    final java.lang.Object other$account = other.getAccount();
    if (this$account == null ? other$account != null : !this$account.equals(other$account)) return false;
    final java.lang.Object this$expiresAfter = this.getExpiresAfter();
    final java.lang.Object other$expiresAfter = other.getExpiresAfter();
    if (this$expiresAfter == null ? other$expiresAfter != null : !this$expiresAfter.equals(other$expiresAfter)) return false;
    final java.lang.Object this$financingType = this.getFinancingType();
    final java.lang.Object other$financingType = other.getFinancingType();
    if (this$financingType == null ? other$financingType != null : !this$financingType.equals(other$financingType)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$offeredTerms = this.getOfferedTerms();
    final java.lang.Object other$offeredTerms = other.getOfferedTerms();
    if (this$offeredTerms == null ? other$offeredTerms != null : !this$offeredTerms.equals(other$offeredTerms)) return false;
    final java.lang.Object this$productType = this.getProductType();
    final java.lang.Object other$productType = other.getProductType();
    if (this$productType == null ? other$productType != null : !this$productType.equals(other$productType)) return false;
    final java.lang.Object this$replacement = this.getReplacement();
    final java.lang.Object other$replacement = other.getReplacement();
    if (this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement)) return false;
    final java.lang.Object this$replacementFor = this.getReplacementFor();
    final java.lang.Object other$replacementFor = other.getReplacementFor();
    if (this$replacementFor == null ? other$replacementFor != null : !this$replacementFor.equals(other$replacementFor)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof FinancingOffer;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $acceptedTerms = this.getAcceptedTerms();
    result = result * PRIME + ($acceptedTerms == null ? 43 : $acceptedTerms.hashCode());
    final java.lang.Object $account = this.getAccount();
    result = result * PRIME + ($account == null ? 43 : $account.hashCode());
    final java.lang.Object $expiresAfter = this.getExpiresAfter();
    result = result * PRIME + ($expiresAfter == null ? 43 : $expiresAfter.hashCode());
    final java.lang.Object $financingType = this.getFinancingType();
    result = result * PRIME + ($financingType == null ? 43 : $financingType.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $offeredTerms = this.getOfferedTerms();
    result = result * PRIME + ($offeredTerms == null ? 43 : $offeredTerms.hashCode());
    final java.lang.Object $productType = this.getProductType();
    result = result * PRIME + ($productType == null ? 43 : $productType.hashCode());
    final java.lang.Object $replacement = this.getReplacement();
    result = result * PRIME + ($replacement == null ? 43 : $replacement.hashCode());
    final java.lang.Object $replacementFor = this.getReplacementFor();
    result = result * PRIME + ($replacementFor == null ? 43 : $replacementFor.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    return result;
  }

  /**
   * A unique identifier for the financing object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
