/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.Charge;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentMethodCollection;
import com.stripe.model.SetupAttempt;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PaymentMethodAttachParams;
import com.stripe.param.PaymentMethodCreateParams;
import com.stripe.param.PaymentMethodDetachParams;
import com.stripe.param.PaymentMethodListParams;
import com.stripe.param.PaymentMethodRetrieveParams;
import com.stripe.param.PaymentMethodUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PaymentMethod
extends ApiResource
implements HasId,
MetadataStore<PaymentMethod> {
    @SerializedName(value="acss_debit")
    AcssDebit acssDebit;
    @SerializedName(value="affirm")
    Affirm affirm;
    @SerializedName(value="afterpay_clearpay")
    AfterpayClearpay afterpayClearpay;
    @SerializedName(value="alipay")
    Alipay alipay;
    @SerializedName(value="au_becs_debit")
    AuBecsDebit auBecsDebit;
    @SerializedName(value="bacs_debit")
    BacsDebit bacsDebit;
    @SerializedName(value="bancontact")
    Bancontact bancontact;
    @SerializedName(value="billing_details")
    BillingDetails billingDetails;
    @SerializedName(value="blik")
    Blik blik;
    @SerializedName(value="boleto")
    Boleto boleto;
    @SerializedName(value="card")
    Card card;
    @SerializedName(value="card_present")
    CardPresent cardPresent;
    @SerializedName(value="cashapp")
    Cashapp cashapp;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="customer_balance")
    CustomerBalance customerBalance;
    @SerializedName(value="eps")
    Eps eps;
    @SerializedName(value="fpx")
    Fpx fpx;
    @SerializedName(value="giropay")
    Giropay giropay;
    @SerializedName(value="grabpay")
    Grabpay grabpay;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="ideal")
    Ideal ideal;
    @SerializedName(value="interac_present")
    InteracPresent interacPresent;
    @SerializedName(value="klarna")
    Klarna klarna;
    @SerializedName(value="konbini")
    Konbini konbini;
    @SerializedName(value="link")
    Link link;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="oxxo")
    Oxxo oxxo;
    @SerializedName(value="p24")
    P24 p24;
    @SerializedName(value="paynow")
    Paynow paynow;
    @SerializedName(value="paypal")
    Paypal paypal;
    @SerializedName(value="pix")
    Pix pix;
    @SerializedName(value="promptpay")
    Promptpay promptpay;
    @SerializedName(value="radar_options")
    RadarOptions radarOptions;
    @SerializedName(value="sepa_debit")
    SepaDebit sepaDebit;
    @SerializedName(value="sofort")
    Sofort sofort;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="us_bank_account")
    USBankAccount usBankAccount;
    @SerializedName(value="wechat_pay")
    WechatPay wechatPay;
    @SerializedName(value="zip")
    Zip zip;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public PaymentMethod attach(Map<String, Object> params) throws StripeException {
        return this.attach(params, (RequestOptions)null);
    }

    public PaymentMethod attach(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s/attach", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
    }

    public PaymentMethod attach(PaymentMethodAttachParams params) throws StripeException {
        return this.attach(params, (RequestOptions)null);
    }

    public PaymentMethod attach(PaymentMethodAttachParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s/attach", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
    }

    public static PaymentMethod create(Map<String, Object> params) throws StripeException {
        return PaymentMethod.create(params, (RequestOptions)null);
    }

    public static PaymentMethod create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_methods");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
    }

    public static PaymentMethod create(PaymentMethodCreateParams params) throws StripeException {
        return PaymentMethod.create(params, (RequestOptions)null);
    }

    public static PaymentMethod create(PaymentMethodCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_methods");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
    }

    public PaymentMethod detach() throws StripeException {
        return this.detach((Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentMethod detach(RequestOptions options) throws StripeException {
        return this.detach((Map<String, Object>)null, options);
    }

    public PaymentMethod detach(Map<String, Object> params) throws StripeException {
        return this.detach(params, (RequestOptions)null);
    }

    public PaymentMethod detach(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s/detach", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
    }

    public PaymentMethod detach(PaymentMethodDetachParams params) throws StripeException {
        return this.detach(params, (RequestOptions)null);
    }

    public PaymentMethod detach(PaymentMethodDetachParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s/detach", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
    }

    public static PaymentMethodCollection list(Map<String, Object> params) throws StripeException {
        return PaymentMethod.list(params, (RequestOptions)null);
    }

    public static PaymentMethodCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_methods");
        return ApiResource.requestCollection(url, params, PaymentMethodCollection.class, options);
    }

    public static PaymentMethodCollection list(PaymentMethodListParams params) throws StripeException {
        return PaymentMethod.list(params, (RequestOptions)null);
    }

    public static PaymentMethodCollection list(PaymentMethodListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_methods");
        return ApiResource.requestCollection(url, params, PaymentMethodCollection.class, options);
    }

    public static PaymentMethod retrieve(String paymentMethod) throws StripeException {
        return PaymentMethod.retrieve(paymentMethod, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static PaymentMethod retrieve(String paymentMethod, RequestOptions options) throws StripeException {
        return PaymentMethod.retrieve(paymentMethod, (Map<String, Object>)null, options);
    }

    public static PaymentMethod retrieve(String paymentMethod, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s", ApiResource.urlEncodeId(paymentMethod)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentMethod.class, options);
    }

    public static PaymentMethod retrieve(String paymentMethod, PaymentMethodRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s", ApiResource.urlEncodeId(paymentMethod)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentMethod.class, options);
    }

    public PaymentMethod update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public PaymentMethod update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
    }

    public PaymentMethod update(PaymentMethodUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public PaymentMethod update(PaymentMethodUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_methods/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentMethod.class, options);
    }

    @Generated
    public AcssDebit getAcssDebit() {
        return this.acssDebit;
    }

    @Generated
    public Affirm getAffirm() {
        return this.affirm;
    }

    @Generated
    public AfterpayClearpay getAfterpayClearpay() {
        return this.afterpayClearpay;
    }

    @Generated
    public Alipay getAlipay() {
        return this.alipay;
    }

    @Generated
    public AuBecsDebit getAuBecsDebit() {
        return this.auBecsDebit;
    }

    @Generated
    public BacsDebit getBacsDebit() {
        return this.bacsDebit;
    }

    @Generated
    public Bancontact getBancontact() {
        return this.bancontact;
    }

    @Generated
    public BillingDetails getBillingDetails() {
        return this.billingDetails;
    }

    @Generated
    public Blik getBlik() {
        return this.blik;
    }

    @Generated
    public Boleto getBoleto() {
        return this.boleto;
    }

    @Generated
    public Card getCard() {
        return this.card;
    }

    @Generated
    public CardPresent getCardPresent() {
        return this.cardPresent;
    }

    @Generated
    public Cashapp getCashapp() {
        return this.cashapp;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public CustomerBalance getCustomerBalance() {
        return this.customerBalance;
    }

    @Generated
    public Eps getEps() {
        return this.eps;
    }

    @Generated
    public Fpx getFpx() {
        return this.fpx;
    }

    @Generated
    public Giropay getGiropay() {
        return this.giropay;
    }

    @Generated
    public Grabpay getGrabpay() {
        return this.grabpay;
    }

    @Generated
    public Ideal getIdeal() {
        return this.ideal;
    }

    @Generated
    public InteracPresent getInteracPresent() {
        return this.interacPresent;
    }

    @Generated
    public Klarna getKlarna() {
        return this.klarna;
    }

    @Generated
    public Konbini getKonbini() {
        return this.konbini;
    }

    @Generated
    public Link getLink() {
        return this.link;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Oxxo getOxxo() {
        return this.oxxo;
    }

    @Generated
    public P24 getP24() {
        return this.p24;
    }

    @Generated
    public Paynow getPaynow() {
        return this.paynow;
    }

    @Generated
    public Paypal getPaypal() {
        return this.paypal;
    }

    @Generated
    public Pix getPix() {
        return this.pix;
    }

    @Generated
    public Promptpay getPromptpay() {
        return this.promptpay;
    }

    @Generated
    public RadarOptions getRadarOptions() {
        return this.radarOptions;
    }

    @Generated
    public SepaDebit getSepaDebit() {
        return this.sepaDebit;
    }

    @Generated
    public Sofort getSofort() {
        return this.sofort;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public USBankAccount getUsBankAccount() {
        return this.usBankAccount;
    }

    @Generated
    public WechatPay getWechatPay() {
        return this.wechatPay;
    }

    @Generated
    public Zip getZip() {
        return this.zip;
    }

    @Generated
    public void setAcssDebit(AcssDebit acssDebit) {
        this.acssDebit = acssDebit;
    }

    @Generated
    public void setAffirm(Affirm affirm) {
        this.affirm = affirm;
    }

    @Generated
    public void setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
        this.afterpayClearpay = afterpayClearpay;
    }

    @Generated
    public void setAlipay(Alipay alipay) {
        this.alipay = alipay;
    }

    @Generated
    public void setAuBecsDebit(AuBecsDebit auBecsDebit) {
        this.auBecsDebit = auBecsDebit;
    }

    @Generated
    public void setBacsDebit(BacsDebit bacsDebit) {
        this.bacsDebit = bacsDebit;
    }

    @Generated
    public void setBancontact(Bancontact bancontact) {
        this.bancontact = bancontact;
    }

    @Generated
    public void setBillingDetails(BillingDetails billingDetails) {
        this.billingDetails = billingDetails;
    }

    @Generated
    public void setBlik(Blik blik) {
        this.blik = blik;
    }

    @Generated
    public void setBoleto(Boleto boleto) {
        this.boleto = boleto;
    }

    @Generated
    public void setCard(Card card) {
        this.card = card;
    }

    @Generated
    public void setCardPresent(CardPresent cardPresent) {
        this.cardPresent = cardPresent;
    }

    @Generated
    public void setCashapp(Cashapp cashapp) {
        this.cashapp = cashapp;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCustomerBalance(CustomerBalance customerBalance) {
        this.customerBalance = customerBalance;
    }

    @Generated
    public void setEps(Eps eps) {
        this.eps = eps;
    }

    @Generated
    public void setFpx(Fpx fpx) {
        this.fpx = fpx;
    }

    @Generated
    public void setGiropay(Giropay giropay) {
        this.giropay = giropay;
    }

    @Generated
    public void setGrabpay(Grabpay grabpay) {
        this.grabpay = grabpay;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIdeal(Ideal ideal) {
        this.ideal = ideal;
    }

    @Generated
    public void setInteracPresent(InteracPresent interacPresent) {
        this.interacPresent = interacPresent;
    }

    @Generated
    public void setKlarna(Klarna klarna) {
        this.klarna = klarna;
    }

    @Generated
    public void setKonbini(Konbini konbini) {
        this.konbini = konbini;
    }

    @Generated
    public void setLink(Link link) {
        this.link = link;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setOxxo(Oxxo oxxo) {
        this.oxxo = oxxo;
    }

    @Generated
    public void setP24(P24 p24) {
        this.p24 = p24;
    }

    @Generated
    public void setPaynow(Paynow paynow) {
        this.paynow = paynow;
    }

    @Generated
    public void setPaypal(Paypal paypal) {
        this.paypal = paypal;
    }

    @Generated
    public void setPix(Pix pix) {
        this.pix = pix;
    }

    @Generated
    public void setPromptpay(Promptpay promptpay) {
        this.promptpay = promptpay;
    }

    @Generated
    public void setRadarOptions(RadarOptions radarOptions) {
        this.radarOptions = radarOptions;
    }

    @Generated
    public void setSepaDebit(SepaDebit sepaDebit) {
        this.sepaDebit = sepaDebit;
    }

    @Generated
    public void setSofort(Sofort sofort) {
        this.sofort = sofort;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setUsBankAccount(USBankAccount usBankAccount) {
        this.usBankAccount = usBankAccount;
    }

    @Generated
    public void setWechatPay(WechatPay wechatPay) {
        this.wechatPay = wechatPay;
    }

    @Generated
    public void setZip(Zip zip) {
        this.zip = zip;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentMethod)) {
            return false;
        }
        PaymentMethod other = (PaymentMethod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        AcssDebit this$acssDebit = this.getAcssDebit();
        AcssDebit other$acssDebit = other.getAcssDebit();
        if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
            return false;
        }
        Affirm this$affirm = this.getAffirm();
        Affirm other$affirm = other.getAffirm();
        if (this$affirm == null ? other$affirm != null : !((Object)this$affirm).equals(other$affirm)) {
            return false;
        }
        AfterpayClearpay this$afterpayClearpay = this.getAfterpayClearpay();
        AfterpayClearpay other$afterpayClearpay = other.getAfterpayClearpay();
        if (this$afterpayClearpay == null ? other$afterpayClearpay != null : !((Object)this$afterpayClearpay).equals(other$afterpayClearpay)) {
            return false;
        }
        Alipay this$alipay = this.getAlipay();
        Alipay other$alipay = other.getAlipay();
        if (this$alipay == null ? other$alipay != null : !((Object)this$alipay).equals(other$alipay)) {
            return false;
        }
        AuBecsDebit this$auBecsDebit = this.getAuBecsDebit();
        AuBecsDebit other$auBecsDebit = other.getAuBecsDebit();
        if (this$auBecsDebit == null ? other$auBecsDebit != null : !((Object)this$auBecsDebit).equals(other$auBecsDebit)) {
            return false;
        }
        BacsDebit this$bacsDebit = this.getBacsDebit();
        BacsDebit other$bacsDebit = other.getBacsDebit();
        if (this$bacsDebit == null ? other$bacsDebit != null : !((Object)this$bacsDebit).equals(other$bacsDebit)) {
            return false;
        }
        Bancontact this$bancontact = this.getBancontact();
        Bancontact other$bancontact = other.getBancontact();
        if (this$bancontact == null ? other$bancontact != null : !((Object)this$bancontact).equals(other$bancontact)) {
            return false;
        }
        BillingDetails this$billingDetails = this.getBillingDetails();
        BillingDetails other$billingDetails = other.getBillingDetails();
        if (this$billingDetails == null ? other$billingDetails != null : !((Object)this$billingDetails).equals(other$billingDetails)) {
            return false;
        }
        Blik this$blik = this.getBlik();
        Blik other$blik = other.getBlik();
        if (this$blik == null ? other$blik != null : !((Object)this$blik).equals(other$blik)) {
            return false;
        }
        Boleto this$boleto = this.getBoleto();
        Boleto other$boleto = other.getBoleto();
        if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
            return false;
        }
        Card this$card = this.getCard();
        Card other$card = other.getCard();
        if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
            return false;
        }
        CardPresent this$cardPresent = this.getCardPresent();
        CardPresent other$cardPresent = other.getCardPresent();
        if (this$cardPresent == null ? other$cardPresent != null : !((Object)this$cardPresent).equals(other$cardPresent)) {
            return false;
        }
        Cashapp this$cashapp = this.getCashapp();
        Cashapp other$cashapp = other.getCashapp();
        if (this$cashapp == null ? other$cashapp != null : !((Object)this$cashapp).equals(other$cashapp)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        CustomerBalance this$customerBalance = this.getCustomerBalance();
        CustomerBalance other$customerBalance = other.getCustomerBalance();
        if (this$customerBalance == null ? other$customerBalance != null : !((Object)this$customerBalance).equals(other$customerBalance)) {
            return false;
        }
        Eps this$eps = this.getEps();
        Eps other$eps = other.getEps();
        if (this$eps == null ? other$eps != null : !((Object)this$eps).equals(other$eps)) {
            return false;
        }
        Fpx this$fpx = this.getFpx();
        Fpx other$fpx = other.getFpx();
        if (this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx)) {
            return false;
        }
        Giropay this$giropay = this.getGiropay();
        Giropay other$giropay = other.getGiropay();
        if (this$giropay == null ? other$giropay != null : !((Object)this$giropay).equals(other$giropay)) {
            return false;
        }
        Grabpay this$grabpay = this.getGrabpay();
        Grabpay other$grabpay = other.getGrabpay();
        if (this$grabpay == null ? other$grabpay != null : !((Object)this$grabpay).equals(other$grabpay)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Ideal this$ideal = this.getIdeal();
        Ideal other$ideal = other.getIdeal();
        if (this$ideal == null ? other$ideal != null : !((Object)this$ideal).equals(other$ideal)) {
            return false;
        }
        InteracPresent this$interacPresent = this.getInteracPresent();
        InteracPresent other$interacPresent = other.getInteracPresent();
        if (this$interacPresent == null ? other$interacPresent != null : !((Object)this$interacPresent).equals(other$interacPresent)) {
            return false;
        }
        Klarna this$klarna = this.getKlarna();
        Klarna other$klarna = other.getKlarna();
        if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
            return false;
        }
        Konbini this$konbini = this.getKonbini();
        Konbini other$konbini = other.getKonbini();
        if (this$konbini == null ? other$konbini != null : !((Object)this$konbini).equals(other$konbini)) {
            return false;
        }
        Link this$link = this.getLink();
        Link other$link = other.getLink();
        if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Oxxo this$oxxo = this.getOxxo();
        Oxxo other$oxxo = other.getOxxo();
        if (this$oxxo == null ? other$oxxo != null : !((Object)this$oxxo).equals(other$oxxo)) {
            return false;
        }
        P24 this$p24 = this.getP24();
        P24 other$p24 = other.getP24();
        if (this$p24 == null ? other$p24 != null : !((Object)this$p24).equals(other$p24)) {
            return false;
        }
        Paynow this$paynow = this.getPaynow();
        Paynow other$paynow = other.getPaynow();
        if (this$paynow == null ? other$paynow != null : !((Object)this$paynow).equals(other$paynow)) {
            return false;
        }
        Paypal this$paypal = this.getPaypal();
        Paypal other$paypal = other.getPaypal();
        if (this$paypal == null ? other$paypal != null : !((Object)this$paypal).equals(other$paypal)) {
            return false;
        }
        Pix this$pix = this.getPix();
        Pix other$pix = other.getPix();
        if (this$pix == null ? other$pix != null : !((Object)this$pix).equals(other$pix)) {
            return false;
        }
        Promptpay this$promptpay = this.getPromptpay();
        Promptpay other$promptpay = other.getPromptpay();
        if (this$promptpay == null ? other$promptpay != null : !((Object)this$promptpay).equals(other$promptpay)) {
            return false;
        }
        RadarOptions this$radarOptions = this.getRadarOptions();
        RadarOptions other$radarOptions = other.getRadarOptions();
        if (this$radarOptions == null ? other$radarOptions != null : !((Object)this$radarOptions).equals(other$radarOptions)) {
            return false;
        }
        SepaDebit this$sepaDebit = this.getSepaDebit();
        SepaDebit other$sepaDebit = other.getSepaDebit();
        if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
            return false;
        }
        Sofort this$sofort = this.getSofort();
        Sofort other$sofort = other.getSofort();
        if (this$sofort == null ? other$sofort != null : !((Object)this$sofort).equals(other$sofort)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        USBankAccount this$usBankAccount = this.getUsBankAccount();
        USBankAccount other$usBankAccount = other.getUsBankAccount();
        if (this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount)) {
            return false;
        }
        WechatPay this$wechatPay = this.getWechatPay();
        WechatPay other$wechatPay = other.getWechatPay();
        if (this$wechatPay == null ? other$wechatPay != null : !((Object)this$wechatPay).equals(other$wechatPay)) {
            return false;
        }
        Zip this$zip = this.getZip();
        Zip other$zip = other.getZip();
        return !(this$zip == null ? other$zip != null : !((Object)this$zip).equals(other$zip));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentMethod;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        AcssDebit $acssDebit = this.getAcssDebit();
        result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
        Affirm $affirm = this.getAffirm();
        result = result * 59 + ($affirm == null ? 43 : ((Object)$affirm).hashCode());
        AfterpayClearpay $afterpayClearpay = this.getAfterpayClearpay();
        result = result * 59 + ($afterpayClearpay == null ? 43 : ((Object)$afterpayClearpay).hashCode());
        Alipay $alipay = this.getAlipay();
        result = result * 59 + ($alipay == null ? 43 : ((Object)$alipay).hashCode());
        AuBecsDebit $auBecsDebit = this.getAuBecsDebit();
        result = result * 59 + ($auBecsDebit == null ? 43 : ((Object)$auBecsDebit).hashCode());
        BacsDebit $bacsDebit = this.getBacsDebit();
        result = result * 59 + ($bacsDebit == null ? 43 : ((Object)$bacsDebit).hashCode());
        Bancontact $bancontact = this.getBancontact();
        result = result * 59 + ($bancontact == null ? 43 : ((Object)$bancontact).hashCode());
        BillingDetails $billingDetails = this.getBillingDetails();
        result = result * 59 + ($billingDetails == null ? 43 : ((Object)$billingDetails).hashCode());
        Blik $blik = this.getBlik();
        result = result * 59 + ($blik == null ? 43 : ((Object)$blik).hashCode());
        Boleto $boleto = this.getBoleto();
        result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
        Card $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
        CardPresent $cardPresent = this.getCardPresent();
        result = result * 59 + ($cardPresent == null ? 43 : ((Object)$cardPresent).hashCode());
        Cashapp $cashapp = this.getCashapp();
        result = result * 59 + ($cashapp == null ? 43 : ((Object)$cashapp).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        CustomerBalance $customerBalance = this.getCustomerBalance();
        result = result * 59 + ($customerBalance == null ? 43 : ((Object)$customerBalance).hashCode());
        Eps $eps = this.getEps();
        result = result * 59 + ($eps == null ? 43 : ((Object)$eps).hashCode());
        Fpx $fpx = this.getFpx();
        result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
        Giropay $giropay = this.getGiropay();
        result = result * 59 + ($giropay == null ? 43 : ((Object)$giropay).hashCode());
        Grabpay $grabpay = this.getGrabpay();
        result = result * 59 + ($grabpay == null ? 43 : ((Object)$grabpay).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Ideal $ideal = this.getIdeal();
        result = result * 59 + ($ideal == null ? 43 : ((Object)$ideal).hashCode());
        InteracPresent $interacPresent = this.getInteracPresent();
        result = result * 59 + ($interacPresent == null ? 43 : ((Object)$interacPresent).hashCode());
        Klarna $klarna = this.getKlarna();
        result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
        Konbini $konbini = this.getKonbini();
        result = result * 59 + ($konbini == null ? 43 : ((Object)$konbini).hashCode());
        Link $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Oxxo $oxxo = this.getOxxo();
        result = result * 59 + ($oxxo == null ? 43 : ((Object)$oxxo).hashCode());
        P24 $p24 = this.getP24();
        result = result * 59 + ($p24 == null ? 43 : ((Object)$p24).hashCode());
        Paynow $paynow = this.getPaynow();
        result = result * 59 + ($paynow == null ? 43 : ((Object)$paynow).hashCode());
        Paypal $paypal = this.getPaypal();
        result = result * 59 + ($paypal == null ? 43 : ((Object)$paypal).hashCode());
        Pix $pix = this.getPix();
        result = result * 59 + ($pix == null ? 43 : ((Object)$pix).hashCode());
        Promptpay $promptpay = this.getPromptpay();
        result = result * 59 + ($promptpay == null ? 43 : ((Object)$promptpay).hashCode());
        RadarOptions $radarOptions = this.getRadarOptions();
        result = result * 59 + ($radarOptions == null ? 43 : ((Object)$radarOptions).hashCode());
        SepaDebit $sepaDebit = this.getSepaDebit();
        result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
        Sofort $sofort = this.getSofort();
        result = result * 59 + ($sofort == null ? 43 : ((Object)$sofort).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        USBankAccount $usBankAccount = this.getUsBankAccount();
        result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
        WechatPay $wechatPay = this.getWechatPay();
        result = result * 59 + ($wechatPay == null ? 43 : ((Object)$wechatPay).hashCode());
        Zip $zip = this.getZip();
        result = result * 59 + ($zip == null ? 43 : ((Object)$zip).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class AcssDebit
    extends StripeObject {
        @SerializedName(value="bank_name")
        String bankName;
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="institution_number")
        String institutionNumber;
        @SerializedName(value="last4")
        String last4;
        @SerializedName(value="transit_number")
        String transitNumber;

        @Generated
        public String getBankName() {
            return this.bankName;
        }

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public String getInstitutionNumber() {
            return this.institutionNumber;
        }

        @Generated
        public String getLast4() {
            return this.last4;
        }

        @Generated
        public String getTransitNumber() {
            return this.transitNumber;
        }

        @Generated
        public void setBankName(String bankName) {
            this.bankName = bankName;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setInstitutionNumber(String institutionNumber) {
            this.institutionNumber = institutionNumber;
        }

        @Generated
        public void setLast4(String last4) {
            this.last4 = last4;
        }

        @Generated
        public void setTransitNumber(String transitNumber) {
            this.transitNumber = transitNumber;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AcssDebit)) {
                return false;
            }
            AcssDebit other = (AcssDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bankName = this.getBankName();
            String other$bankName = other.getBankName();
            if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            String this$institutionNumber = this.getInstitutionNumber();
            String other$institutionNumber = other.getInstitutionNumber();
            if (this$institutionNumber == null ? other$institutionNumber != null : !this$institutionNumber.equals(other$institutionNumber)) {
                return false;
            }
            String this$last4 = this.getLast4();
            String other$last4 = other.getLast4();
            if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                return false;
            }
            String this$transitNumber = this.getTransitNumber();
            String other$transitNumber = other.getTransitNumber();
            return !(this$transitNumber == null ? other$transitNumber != null : !this$transitNumber.equals(other$transitNumber));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AcssDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bankName = this.getBankName();
            result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            String $institutionNumber = this.getInstitutionNumber();
            result = result * 59 + ($institutionNumber == null ? 43 : $institutionNumber.hashCode());
            String $last4 = this.getLast4();
            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
            String $transitNumber = this.getTransitNumber();
            result = result * 59 + ($transitNumber == null ? 43 : $transitNumber.hashCode());
            return result;
        }
    }

    public static class Affirm
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Affirm)) {
                return false;
            }
            Affirm other = (Affirm)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Affirm;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class AfterpayClearpay
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AfterpayClearpay)) {
                return false;
            }
            AfterpayClearpay other = (AfterpayClearpay)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AfterpayClearpay;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class Alipay
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Alipay)) {
                return false;
            }
            Alipay other = (Alipay)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Alipay;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class AuBecsDebit
    extends StripeObject {
        @SerializedName(value="bsb_number")
        String bsbNumber;
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="last4")
        String last4;

        @Generated
        public String getBsbNumber() {
            return this.bsbNumber;
        }

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public String getLast4() {
            return this.last4;
        }

        @Generated
        public void setBsbNumber(String bsbNumber) {
            this.bsbNumber = bsbNumber;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setLast4(String last4) {
            this.last4 = last4;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuBecsDebit)) {
                return false;
            }
            AuBecsDebit other = (AuBecsDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bsbNumber = this.getBsbNumber();
            String other$bsbNumber = other.getBsbNumber();
            if (this$bsbNumber == null ? other$bsbNumber != null : !this$bsbNumber.equals(other$bsbNumber)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            String this$last4 = this.getLast4();
            String other$last4 = other.getLast4();
            return !(this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AuBecsDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bsbNumber = this.getBsbNumber();
            result = result * 59 + ($bsbNumber == null ? 43 : $bsbNumber.hashCode());
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            String $last4 = this.getLast4();
            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
            return result;
        }
    }

    public static class BacsDebit
    extends StripeObject {
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="last4")
        String last4;
        @SerializedName(value="sort_code")
        String sortCode;

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public String getLast4() {
            return this.last4;
        }

        @Generated
        public String getSortCode() {
            return this.sortCode;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setLast4(String last4) {
            this.last4 = last4;
        }

        @Generated
        public void setSortCode(String sortCode) {
            this.sortCode = sortCode;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BacsDebit)) {
                return false;
            }
            BacsDebit other = (BacsDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            String this$last4 = this.getLast4();
            String other$last4 = other.getLast4();
            if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                return false;
            }
            String this$sortCode = this.getSortCode();
            String other$sortCode = other.getSortCode();
            return !(this$sortCode == null ? other$sortCode != null : !this$sortCode.equals(other$sortCode));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BacsDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            String $last4 = this.getLast4();
            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
            String $sortCode = this.getSortCode();
            result = result * 59 + ($sortCode == null ? 43 : $sortCode.hashCode());
            return result;
        }
    }

    public static class Bancontact
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bancontact)) {
                return false;
            }
            Bancontact other = (Bancontact)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Bancontact;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class BillingDetails
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="email")
        String email;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BillingDetails)) {
                return false;
            }
            BillingDetails other = (BillingDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BillingDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            return result;
        }
    }

    public static class Blik
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Blik)) {
                return false;
            }
            Blik other = (Blik)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Blik;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class Boleto
    extends StripeObject {
        @SerializedName(value="tax_id")
        String taxId;

        @Generated
        public String getTaxId() {
            return this.taxId;
        }

        @Generated
        public void setTaxId(String taxId) {
            this.taxId = taxId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Boleto)) {
                return false;
            }
            Boleto other = (Boleto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$taxId = this.getTaxId();
            String other$taxId = other.getTaxId();
            return !(this$taxId == null ? other$taxId != null : !this$taxId.equals(other$taxId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Boleto;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $taxId = this.getTaxId();
            result = result * 59 + ($taxId == null ? 43 : $taxId.hashCode());
            return result;
        }
    }

    public static class Card
    extends StripeObject {
        @SerializedName(value="brand")
        String brand;
        @SerializedName(value="checks")
        Checks checks;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="exp_month")
        Long expMonth;
        @SerializedName(value="exp_year")
        Long expYear;
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="funding")
        String funding;
        @SerializedName(value="iin")
        String iin;
        @SerializedName(value="issuer")
        String issuer;
        @SerializedName(value="last4")
        String last4;
        @SerializedName(value="networks")
        Networks networks;
        @SerializedName(value="three_d_secure_usage")
        ThreeDSecureUsage threeDSecureUsage;
        @SerializedName(value="wallet")
        Wallet wallet;

        @Generated
        public String getBrand() {
            return this.brand;
        }

        @Generated
        public Checks getChecks() {
            return this.checks;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Long getExpMonth() {
            return this.expMonth;
        }

        @Generated
        public Long getExpYear() {
            return this.expYear;
        }

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public String getFunding() {
            return this.funding;
        }

        @Generated
        public String getIin() {
            return this.iin;
        }

        @Generated
        public String getIssuer() {
            return this.issuer;
        }

        @Generated
        public String getLast4() {
            return this.last4;
        }

        @Generated
        public Networks getNetworks() {
            return this.networks;
        }

        @Generated
        public ThreeDSecureUsage getThreeDSecureUsage() {
            return this.threeDSecureUsage;
        }

        @Generated
        public Wallet getWallet() {
            return this.wallet;
        }

        @Generated
        public void setBrand(String brand) {
            this.brand = brand;
        }

        @Generated
        public void setChecks(Checks checks) {
            this.checks = checks;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setExpMonth(Long expMonth) {
            this.expMonth = expMonth;
        }

        @Generated
        public void setExpYear(Long expYear) {
            this.expYear = expYear;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setFunding(String funding) {
            this.funding = funding;
        }

        @Generated
        public void setIin(String iin) {
            this.iin = iin;
        }

        @Generated
        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Generated
        public void setLast4(String last4) {
            this.last4 = last4;
        }

        @Generated
        public void setNetworks(Networks networks) {
            this.networks = networks;
        }

        @Generated
        public void setThreeDSecureUsage(ThreeDSecureUsage threeDSecureUsage) {
            this.threeDSecureUsage = threeDSecureUsage;
        }

        @Generated
        public void setWallet(Wallet wallet) {
            this.wallet = wallet;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Card)) {
                return false;
            }
            Card other = (Card)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$expMonth = this.getExpMonth();
            Long other$expMonth = other.getExpMonth();
            if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                return false;
            }
            Long this$expYear = this.getExpYear();
            Long other$expYear = other.getExpYear();
            if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                return false;
            }
            String this$brand = this.getBrand();
            String other$brand = other.getBrand();
            if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                return false;
            }
            Checks this$checks = this.getChecks();
            Checks other$checks = other.getChecks();
            if (this$checks == null ? other$checks != null : !((Object)this$checks).equals(other$checks)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            String this$funding = this.getFunding();
            String other$funding = other.getFunding();
            if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
                return false;
            }
            String this$iin = this.getIin();
            String other$iin = other.getIin();
            if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) {
                return false;
            }
            String this$issuer = this.getIssuer();
            String other$issuer = other.getIssuer();
            if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                return false;
            }
            String this$last4 = this.getLast4();
            String other$last4 = other.getLast4();
            if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                return false;
            }
            Networks this$networks = this.getNetworks();
            Networks other$networks = other.getNetworks();
            if (this$networks == null ? other$networks != null : !((Object)this$networks).equals(other$networks)) {
                return false;
            }
            ThreeDSecureUsage this$threeDSecureUsage = this.getThreeDSecureUsage();
            ThreeDSecureUsage other$threeDSecureUsage = other.getThreeDSecureUsage();
            if (this$threeDSecureUsage == null ? other$threeDSecureUsage != null : !((Object)this$threeDSecureUsage).equals(other$threeDSecureUsage)) {
                return false;
            }
            Wallet this$wallet = this.getWallet();
            Wallet other$wallet = other.getWallet();
            return !(this$wallet == null ? other$wallet != null : !((Object)this$wallet).equals(other$wallet));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Card;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $expMonth = this.getExpMonth();
            result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
            Long $expYear = this.getExpYear();
            result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
            String $brand = this.getBrand();
            result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
            Checks $checks = this.getChecks();
            result = result * 59 + ($checks == null ? 43 : ((Object)$checks).hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            String $funding = this.getFunding();
            result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
            String $iin = this.getIin();
            result = result * 59 + ($iin == null ? 43 : $iin.hashCode());
            String $issuer = this.getIssuer();
            result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
            String $last4 = this.getLast4();
            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
            Networks $networks = this.getNetworks();
            result = result * 59 + ($networks == null ? 43 : ((Object)$networks).hashCode());
            ThreeDSecureUsage $threeDSecureUsage = this.getThreeDSecureUsage();
            result = result * 59 + ($threeDSecureUsage == null ? 43 : ((Object)$threeDSecureUsage).hashCode());
            Wallet $wallet = this.getWallet();
            result = result * 59 + ($wallet == null ? 43 : ((Object)$wallet).hashCode());
            return result;
        }

        public static class Checks
        extends StripeObject {
            @SerializedName(value="address_line1_check")
            String addressLine1Check;
            @SerializedName(value="address_postal_code_check")
            String addressPostalCodeCheck;
            @SerializedName(value="cvc_check")
            String cvcCheck;

            @Generated
            public String getAddressLine1Check() {
                return this.addressLine1Check;
            }

            @Generated
            public String getAddressPostalCodeCheck() {
                return this.addressPostalCodeCheck;
            }

            @Generated
            public String getCvcCheck() {
                return this.cvcCheck;
            }

            @Generated
            public void setAddressLine1Check(String addressLine1Check) {
                this.addressLine1Check = addressLine1Check;
            }

            @Generated
            public void setAddressPostalCodeCheck(String addressPostalCodeCheck) {
                this.addressPostalCodeCheck = addressPostalCodeCheck;
            }

            @Generated
            public void setCvcCheck(String cvcCheck) {
                this.cvcCheck = cvcCheck;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Checks)) {
                    return false;
                }
                Checks other = (Checks)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$addressLine1Check = this.getAddressLine1Check();
                String other$addressLine1Check = other.getAddressLine1Check();
                if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) {
                    return false;
                }
                String this$addressPostalCodeCheck = this.getAddressPostalCodeCheck();
                String other$addressPostalCodeCheck = other.getAddressPostalCodeCheck();
                if (this$addressPostalCodeCheck == null ? other$addressPostalCodeCheck != null : !this$addressPostalCodeCheck.equals(other$addressPostalCodeCheck)) {
                    return false;
                }
                String this$cvcCheck = this.getCvcCheck();
                String other$cvcCheck = other.getCvcCheck();
                return !(this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Checks;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $addressLine1Check = this.getAddressLine1Check();
                result = result * 59 + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
                String $addressPostalCodeCheck = this.getAddressPostalCodeCheck();
                result = result * 59 + ($addressPostalCodeCheck == null ? 43 : $addressPostalCodeCheck.hashCode());
                String $cvcCheck = this.getCvcCheck();
                result = result * 59 + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
                return result;
            }
        }

        public static class Networks
        extends StripeObject {
            @SerializedName(value="available")
            List<String> available;
            @SerializedName(value="preferred")
            String preferred;

            @Generated
            public List<String> getAvailable() {
                return this.available;
            }

            @Generated
            public String getPreferred() {
                return this.preferred;
            }

            @Generated
            public void setAvailable(List<String> available) {
                this.available = available;
            }

            @Generated
            public void setPreferred(String preferred) {
                this.preferred = preferred;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Networks)) {
                    return false;
                }
                Networks other = (Networks)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$available = this.getAvailable();
                List<String> other$available = other.getAvailable();
                if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                    return false;
                }
                String this$preferred = this.getPreferred();
                String other$preferred = other.getPreferred();
                return !(this$preferred == null ? other$preferred != null : !this$preferred.equals(other$preferred));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Networks;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $available = this.getAvailable();
                result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
                String $preferred = this.getPreferred();
                result = result * 59 + ($preferred == null ? 43 : $preferred.hashCode());
                return result;
            }
        }

        public static class ThreeDSecureUsage
        extends StripeObject {
            @SerializedName(value="supported")
            Boolean supported;

            @Generated
            public Boolean getSupported() {
                return this.supported;
            }

            @Generated
            public void setSupported(Boolean supported) {
                this.supported = supported;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ThreeDSecureUsage)) {
                    return false;
                }
                ThreeDSecureUsage other = (ThreeDSecureUsage)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$supported = this.getSupported();
                Boolean other$supported = other.getSupported();
                return !(this$supported == null ? other$supported != null : !((Object)this$supported).equals(other$supported));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ThreeDSecureUsage;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $supported = this.getSupported();
                result = result * 59 + ($supported == null ? 43 : ((Object)$supported).hashCode());
                return result;
            }
        }

        public static class Wallet
        extends StripeObject {
            @SerializedName(value="amex_express_checkout")
            AmexExpressCheckout amexExpressCheckout;
            @SerializedName(value="apple_pay")
            ApplePay applePay;
            @SerializedName(value="dynamic_last4")
            String dynamicLast4;
            @SerializedName(value="google_pay")
            GooglePay googlePay;
            @SerializedName(value="masterpass")
            Masterpass masterpass;
            @SerializedName(value="samsung_pay")
            SamsungPay samsungPay;
            @SerializedName(value="type")
            String type;
            @SerializedName(value="visa_checkout")
            VisaCheckout visaCheckout;

            @Generated
            public AmexExpressCheckout getAmexExpressCheckout() {
                return this.amexExpressCheckout;
            }

            @Generated
            public ApplePay getApplePay() {
                return this.applePay;
            }

            @Generated
            public String getDynamicLast4() {
                return this.dynamicLast4;
            }

            @Generated
            public GooglePay getGooglePay() {
                return this.googlePay;
            }

            @Generated
            public Masterpass getMasterpass() {
                return this.masterpass;
            }

            @Generated
            public SamsungPay getSamsungPay() {
                return this.samsungPay;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public VisaCheckout getVisaCheckout() {
                return this.visaCheckout;
            }

            @Generated
            public void setAmexExpressCheckout(AmexExpressCheckout amexExpressCheckout) {
                this.amexExpressCheckout = amexExpressCheckout;
            }

            @Generated
            public void setApplePay(ApplePay applePay) {
                this.applePay = applePay;
            }

            @Generated
            public void setDynamicLast4(String dynamicLast4) {
                this.dynamicLast4 = dynamicLast4;
            }

            @Generated
            public void setGooglePay(GooglePay googlePay) {
                this.googlePay = googlePay;
            }

            @Generated
            public void setMasterpass(Masterpass masterpass) {
                this.masterpass = masterpass;
            }

            @Generated
            public void setSamsungPay(SamsungPay samsungPay) {
                this.samsungPay = samsungPay;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public void setVisaCheckout(VisaCheckout visaCheckout) {
                this.visaCheckout = visaCheckout;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Wallet)) {
                    return false;
                }
                Wallet other = (Wallet)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                AmexExpressCheckout this$amexExpressCheckout = this.getAmexExpressCheckout();
                AmexExpressCheckout other$amexExpressCheckout = other.getAmexExpressCheckout();
                if (this$amexExpressCheckout == null ? other$amexExpressCheckout != null : !((Object)this$amexExpressCheckout).equals(other$amexExpressCheckout)) {
                    return false;
                }
                ApplePay this$applePay = this.getApplePay();
                ApplePay other$applePay = other.getApplePay();
                if (this$applePay == null ? other$applePay != null : !((Object)this$applePay).equals(other$applePay)) {
                    return false;
                }
                String this$dynamicLast4 = this.getDynamicLast4();
                String other$dynamicLast4 = other.getDynamicLast4();
                if (this$dynamicLast4 == null ? other$dynamicLast4 != null : !this$dynamicLast4.equals(other$dynamicLast4)) {
                    return false;
                }
                GooglePay this$googlePay = this.getGooglePay();
                GooglePay other$googlePay = other.getGooglePay();
                if (this$googlePay == null ? other$googlePay != null : !((Object)this$googlePay).equals(other$googlePay)) {
                    return false;
                }
                Masterpass this$masterpass = this.getMasterpass();
                Masterpass other$masterpass = other.getMasterpass();
                if (this$masterpass == null ? other$masterpass != null : !((Object)this$masterpass).equals(other$masterpass)) {
                    return false;
                }
                SamsungPay this$samsungPay = this.getSamsungPay();
                SamsungPay other$samsungPay = other.getSamsungPay();
                if (this$samsungPay == null ? other$samsungPay != null : !((Object)this$samsungPay).equals(other$samsungPay)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                VisaCheckout this$visaCheckout = this.getVisaCheckout();
                VisaCheckout other$visaCheckout = other.getVisaCheckout();
                return !(this$visaCheckout == null ? other$visaCheckout != null : !((Object)this$visaCheckout).equals(other$visaCheckout));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Wallet;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                AmexExpressCheckout $amexExpressCheckout = this.getAmexExpressCheckout();
                result = result * 59 + ($amexExpressCheckout == null ? 43 : ((Object)$amexExpressCheckout).hashCode());
                ApplePay $applePay = this.getApplePay();
                result = result * 59 + ($applePay == null ? 43 : ((Object)$applePay).hashCode());
                String $dynamicLast4 = this.getDynamicLast4();
                result = result * 59 + ($dynamicLast4 == null ? 43 : $dynamicLast4.hashCode());
                GooglePay $googlePay = this.getGooglePay();
                result = result * 59 + ($googlePay == null ? 43 : ((Object)$googlePay).hashCode());
                Masterpass $masterpass = this.getMasterpass();
                result = result * 59 + ($masterpass == null ? 43 : ((Object)$masterpass).hashCode());
                SamsungPay $samsungPay = this.getSamsungPay();
                result = result * 59 + ($samsungPay == null ? 43 : ((Object)$samsungPay).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                VisaCheckout $visaCheckout = this.getVisaCheckout();
                result = result * 59 + ($visaCheckout == null ? 43 : ((Object)$visaCheckout).hashCode());
                return result;
            }

            public static class AmexExpressCheckout
            extends StripeObject {
                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof AmexExpressCheckout)) {
                        return false;
                    }
                    AmexExpressCheckout other = (AmexExpressCheckout)o;
                    return other.canEqual(this);
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof AmexExpressCheckout;
                }

                @Generated
                public int hashCode() {
                    boolean result = true;
                    return 1;
                }
            }

            public static class ApplePay
            extends StripeObject {
                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ApplePay)) {
                        return false;
                    }
                    ApplePay other = (ApplePay)o;
                    return other.canEqual(this);
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof ApplePay;
                }

                @Generated
                public int hashCode() {
                    boolean result = true;
                    return 1;
                }
            }

            public static class GooglePay
            extends StripeObject {
                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof GooglePay)) {
                        return false;
                    }
                    GooglePay other = (GooglePay)o;
                    return other.canEqual(this);
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof GooglePay;
                }

                @Generated
                public int hashCode() {
                    boolean result = true;
                    return 1;
                }
            }

            public static class Masterpass
            extends StripeObject {
                @SerializedName(value="billing_address")
                Address billingAddress;
                @SerializedName(value="email")
                String email;
                @SerializedName(value="name")
                String name;
                @SerializedName(value="shipping_address")
                Address shippingAddress;

                @Generated
                public Address getBillingAddress() {
                    return this.billingAddress;
                }

                @Generated
                public String getEmail() {
                    return this.email;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public Address getShippingAddress() {
                    return this.shippingAddress;
                }

                @Generated
                public void setBillingAddress(Address billingAddress) {
                    this.billingAddress = billingAddress;
                }

                @Generated
                public void setEmail(String email) {
                    this.email = email;
                }

                @Generated
                public void setName(String name) {
                    this.name = name;
                }

                @Generated
                public void setShippingAddress(Address shippingAddress) {
                    this.shippingAddress = shippingAddress;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Masterpass)) {
                        return false;
                    }
                    Masterpass other = (Masterpass)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Address this$billingAddress = this.getBillingAddress();
                    Address other$billingAddress = other.getBillingAddress();
                    if (this$billingAddress == null ? other$billingAddress != null : !((Object)this$billingAddress).equals(other$billingAddress)) {
                        return false;
                    }
                    String this$email = this.getEmail();
                    String other$email = other.getEmail();
                    if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    Address this$shippingAddress = this.getShippingAddress();
                    Address other$shippingAddress = other.getShippingAddress();
                    return !(this$shippingAddress == null ? other$shippingAddress != null : !((Object)this$shippingAddress).equals(other$shippingAddress));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Masterpass;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Address $billingAddress = this.getBillingAddress();
                    result = result * 59 + ($billingAddress == null ? 43 : ((Object)$billingAddress).hashCode());
                    String $email = this.getEmail();
                    result = result * 59 + ($email == null ? 43 : $email.hashCode());
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    Address $shippingAddress = this.getShippingAddress();
                    result = result * 59 + ($shippingAddress == null ? 43 : ((Object)$shippingAddress).hashCode());
                    return result;
                }
            }

            public static class SamsungPay
            extends StripeObject {
                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof SamsungPay)) {
                        return false;
                    }
                    SamsungPay other = (SamsungPay)o;
                    return other.canEqual(this);
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof SamsungPay;
                }

                @Generated
                public int hashCode() {
                    boolean result = true;
                    return 1;
                }
            }

            public static class VisaCheckout
            extends StripeObject {
                @SerializedName(value="billing_address")
                Address billingAddress;
                @SerializedName(value="email")
                String email;
                @SerializedName(value="name")
                String name;
                @SerializedName(value="shipping_address")
                Address shippingAddress;

                @Generated
                public Address getBillingAddress() {
                    return this.billingAddress;
                }

                @Generated
                public String getEmail() {
                    return this.email;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public Address getShippingAddress() {
                    return this.shippingAddress;
                }

                @Generated
                public void setBillingAddress(Address billingAddress) {
                    this.billingAddress = billingAddress;
                }

                @Generated
                public void setEmail(String email) {
                    this.email = email;
                }

                @Generated
                public void setName(String name) {
                    this.name = name;
                }

                @Generated
                public void setShippingAddress(Address shippingAddress) {
                    this.shippingAddress = shippingAddress;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof VisaCheckout)) {
                        return false;
                    }
                    VisaCheckout other = (VisaCheckout)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Address this$billingAddress = this.getBillingAddress();
                    Address other$billingAddress = other.getBillingAddress();
                    if (this$billingAddress == null ? other$billingAddress != null : !((Object)this$billingAddress).equals(other$billingAddress)) {
                        return false;
                    }
                    String this$email = this.getEmail();
                    String other$email = other.getEmail();
                    if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    Address this$shippingAddress = this.getShippingAddress();
                    Address other$shippingAddress = other.getShippingAddress();
                    return !(this$shippingAddress == null ? other$shippingAddress != null : !((Object)this$shippingAddress).equals(other$shippingAddress));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof VisaCheckout;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Address $billingAddress = this.getBillingAddress();
                    result = result * 59 + ($billingAddress == null ? 43 : ((Object)$billingAddress).hashCode());
                    String $email = this.getEmail();
                    result = result * 59 + ($email == null ? 43 : $email.hashCode());
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    Address $shippingAddress = this.getShippingAddress();
                    result = result * 59 + ($shippingAddress == null ? 43 : ((Object)$shippingAddress).hashCode());
                    return result;
                }
            }
        }
    }

    public static class CardPresent
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CardPresent)) {
                return false;
            }
            CardPresent other = (CardPresent)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CardPresent;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class Cashapp
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cashapp)) {
                return false;
            }
            Cashapp other = (Cashapp)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Cashapp;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class CustomerBalance
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomerBalance)) {
                return false;
            }
            CustomerBalance other = (CustomerBalance)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomerBalance;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class Eps
    extends StripeObject {
        @SerializedName(value="bank")
        String bank;

        @Generated
        public String getBank() {
            return this.bank;
        }

        @Generated
        public void setBank(String bank) {
            this.bank = bank;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Eps)) {
                return false;
            }
            Eps other = (Eps)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bank = this.getBank();
            String other$bank = other.getBank();
            return !(this$bank == null ? other$bank != null : !this$bank.equals(other$bank));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Eps;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bank = this.getBank();
            result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
            return result;
        }
    }

    public static class Fpx
    extends StripeObject {
        @SerializedName(value="account_holder_type")
        String accountHolderType;
        @SerializedName(value="bank")
        String bank;

        @Generated
        public String getAccountHolderType() {
            return this.accountHolderType;
        }

        @Generated
        public String getBank() {
            return this.bank;
        }

        @Generated
        public void setAccountHolderType(String accountHolderType) {
            this.accountHolderType = accountHolderType;
        }

        @Generated
        public void setBank(String bank) {
            this.bank = bank;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fpx)) {
                return false;
            }
            Fpx other = (Fpx)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accountHolderType = this.getAccountHolderType();
            String other$accountHolderType = other.getAccountHolderType();
            if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) {
                return false;
            }
            String this$bank = this.getBank();
            String other$bank = other.getBank();
            return !(this$bank == null ? other$bank != null : !this$bank.equals(other$bank));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Fpx;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accountHolderType = this.getAccountHolderType();
            result = result * 59 + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
            String $bank = this.getBank();
            result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
            return result;
        }
    }

    public static class Giropay
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Giropay)) {
                return false;
            }
            Giropay other = (Giropay)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Giropay;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class Grabpay
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Grabpay)) {
                return false;
            }
            Grabpay other = (Grabpay)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Grabpay;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class Ideal
    extends StripeObject {
        @SerializedName(value="bank")
        String bank;
        @SerializedName(value="bic")
        String bic;

        @Generated
        public String getBank() {
            return this.bank;
        }

        @Generated
        public String getBic() {
            return this.bic;
        }

        @Generated
        public void setBank(String bank) {
            this.bank = bank;
        }

        @Generated
        public void setBic(String bic) {
            this.bic = bic;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ideal)) {
                return false;
            }
            Ideal other = (Ideal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bank = this.getBank();
            String other$bank = other.getBank();
            if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                return false;
            }
            String this$bic = this.getBic();
            String other$bic = other.getBic();
            return !(this$bic == null ? other$bic != null : !this$bic.equals(other$bic));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Ideal;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bank = this.getBank();
            result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
            String $bic = this.getBic();
            result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
            return result;
        }
    }

    public static class InteracPresent
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InteracPresent)) {
                return false;
            }
            InteracPresent other = (InteracPresent)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InteracPresent;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class Klarna
    extends StripeObject {
        @SerializedName(value="dob")
        DateOfBirth dob;

        @Generated
        public DateOfBirth getDob() {
            return this.dob;
        }

        @Generated
        public void setDob(DateOfBirth dob) {
            this.dob = dob;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Klarna)) {
                return false;
            }
            Klarna other = (Klarna)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DateOfBirth this$dob = this.getDob();
            DateOfBirth other$dob = other.getDob();
            return !(this$dob == null ? other$dob != null : !((Object)this$dob).equals(other$dob));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Klarna;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DateOfBirth $dob = this.getDob();
            result = result * 59 + ($dob == null ? 43 : ((Object)$dob).hashCode());
            return result;
        }

        public static class DateOfBirth
        extends StripeObject {
            @SerializedName(value="day")
            Long day;
            @SerializedName(value="month")
            Long month;
            @SerializedName(value="year")
            Long year;

            @Generated
            public Long getDay() {
                return this.day;
            }

            @Generated
            public Long getMonth() {
                return this.month;
            }

            @Generated
            public Long getYear() {
                return this.year;
            }

            @Generated
            public void setDay(Long day) {
                this.day = day;
            }

            @Generated
            public void setMonth(Long month) {
                this.month = month;
            }

            @Generated
            public void setYear(Long year) {
                this.year = year;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DateOfBirth)) {
                    return false;
                }
                DateOfBirth other = (DateOfBirth)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$day = this.getDay();
                Long other$day = other.getDay();
                if (this$day == null ? other$day != null : !((Object)this$day).equals(other$day)) {
                    return false;
                }
                Long this$month = this.getMonth();
                Long other$month = other.getMonth();
                if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
                    return false;
                }
                Long this$year = this.getYear();
                Long other$year = other.getYear();
                return !(this$year == null ? other$year != null : !((Object)this$year).equals(other$year));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DateOfBirth;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $day = this.getDay();
                result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
                Long $month = this.getMonth();
                result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
                Long $year = this.getYear();
                result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
                return result;
            }
        }
    }

    public static class Konbini
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Konbini)) {
                return false;
            }
            Konbini other = (Konbini)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Konbini;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class Link
    extends StripeObject {
        @SerializedName(value="email")
        String email;
        @SerializedName(value="persistent_token")
        String persistentToken;

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getPersistentToken() {
            return this.persistentToken;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setPersistentToken(String persistentToken) {
            this.persistentToken = persistentToken;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Link)) {
                return false;
            }
            Link other = (Link)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$persistentToken = this.getPersistentToken();
            String other$persistentToken = other.getPersistentToken();
            return !(this$persistentToken == null ? other$persistentToken != null : !this$persistentToken.equals(other$persistentToken));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Link;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $persistentToken = this.getPersistentToken();
            result = result * 59 + ($persistentToken == null ? 43 : $persistentToken.hashCode());
            return result;
        }
    }

    public static class Oxxo
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Oxxo)) {
                return false;
            }
            Oxxo other = (Oxxo)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Oxxo;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class P24
    extends StripeObject {
        @SerializedName(value="bank")
        String bank;

        @Generated
        public String getBank() {
            return this.bank;
        }

        @Generated
        public void setBank(String bank) {
            this.bank = bank;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof P24)) {
                return false;
            }
            P24 other = (P24)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bank = this.getBank();
            String other$bank = other.getBank();
            return !(this$bank == null ? other$bank != null : !this$bank.equals(other$bank));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof P24;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bank = this.getBank();
            result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
            return result;
        }
    }

    public static class Paynow
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Paynow)) {
                return false;
            }
            Paynow other = (Paynow)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Paynow;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class Paypal
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Paypal)) {
                return false;
            }
            Paypal other = (Paypal)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Paypal;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class Pix
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pix)) {
                return false;
            }
            Pix other = (Pix)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Pix;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class Promptpay
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Promptpay)) {
                return false;
            }
            Promptpay other = (Promptpay)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Promptpay;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class RadarOptions
    extends StripeObject {
        @SerializedName(value="session")
        String session;

        @Generated
        public String getSession() {
            return this.session;
        }

        @Generated
        public void setSession(String session) {
            this.session = session;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RadarOptions)) {
                return false;
            }
            RadarOptions other = (RadarOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$session = this.getSession();
            String other$session = other.getSession();
            return !(this$session == null ? other$session != null : !this$session.equals(other$session));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RadarOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $session = this.getSession();
            result = result * 59 + ($session == null ? 43 : $session.hashCode());
            return result;
        }
    }

    public static class SepaDebit
    extends StripeObject {
        @SerializedName(value="bank_code")
        String bankCode;
        @SerializedName(value="branch_code")
        String branchCode;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="generated_from")
        GeneratedFrom generatedFrom;
        @SerializedName(value="last4")
        String last4;

        @Generated
        public String getBankCode() {
            return this.bankCode;
        }

        @Generated
        public String getBranchCode() {
            return this.branchCode;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public GeneratedFrom getGeneratedFrom() {
            return this.generatedFrom;
        }

        @Generated
        public String getLast4() {
            return this.last4;
        }

        @Generated
        public void setBankCode(String bankCode) {
            this.bankCode = bankCode;
        }

        @Generated
        public void setBranchCode(String branchCode) {
            this.branchCode = branchCode;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setGeneratedFrom(GeneratedFrom generatedFrom) {
            this.generatedFrom = generatedFrom;
        }

        @Generated
        public void setLast4(String last4) {
            this.last4 = last4;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SepaDebit)) {
                return false;
            }
            SepaDebit other = (SepaDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bankCode = this.getBankCode();
            String other$bankCode = other.getBankCode();
            if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                return false;
            }
            String this$branchCode = this.getBranchCode();
            String other$branchCode = other.getBranchCode();
            if (this$branchCode == null ? other$branchCode != null : !this$branchCode.equals(other$branchCode)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            GeneratedFrom this$generatedFrom = this.getGeneratedFrom();
            GeneratedFrom other$generatedFrom = other.getGeneratedFrom();
            if (this$generatedFrom == null ? other$generatedFrom != null : !((Object)this$generatedFrom).equals(other$generatedFrom)) {
                return false;
            }
            String this$last4 = this.getLast4();
            String other$last4 = other.getLast4();
            return !(this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SepaDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bankCode = this.getBankCode();
            result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
            String $branchCode = this.getBranchCode();
            result = result * 59 + ($branchCode == null ? 43 : $branchCode.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            GeneratedFrom $generatedFrom = this.getGeneratedFrom();
            result = result * 59 + ($generatedFrom == null ? 43 : ((Object)$generatedFrom).hashCode());
            String $last4 = this.getLast4();
            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
            return result;
        }

        public static class GeneratedFrom
        extends StripeObject {
            @SerializedName(value="charge")
            ExpandableField<Charge> charge;
            @SerializedName(value="setup_attempt")
            ExpandableField<SetupAttempt> setupAttempt;

            public String getCharge() {
                return this.charge != null ? this.charge.getId() : null;
            }

            public void setCharge(String id) {
                this.charge = ApiResource.setExpandableFieldId(id, this.charge);
            }

            public Charge getChargeObject() {
                return this.charge != null ? this.charge.getExpanded() : null;
            }

            public void setChargeObject(Charge expandableObject) {
                this.charge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
            }

            public String getSetupAttempt() {
                return this.setupAttempt != null ? this.setupAttempt.getId() : null;
            }

            public void setSetupAttempt(String id) {
                this.setupAttempt = ApiResource.setExpandableFieldId(id, this.setupAttempt);
            }

            public SetupAttempt getSetupAttemptObject() {
                return this.setupAttempt != null ? this.setupAttempt.getExpanded() : null;
            }

            public void setSetupAttemptObject(SetupAttempt expandableObject) {
                this.setupAttempt = new ExpandableField<SetupAttempt>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GeneratedFrom)) {
                    return false;
                }
                GeneratedFrom other = (GeneratedFrom)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$charge = this.getCharge();
                String other$charge = other.getCharge();
                if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
                    return false;
                }
                String this$setupAttempt = this.getSetupAttempt();
                String other$setupAttempt = other.getSetupAttempt();
                return !(this$setupAttempt == null ? other$setupAttempt != null : !this$setupAttempt.equals(other$setupAttempt));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof GeneratedFrom;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $charge = this.getCharge();
                result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
                String $setupAttempt = this.getSetupAttempt();
                result = result * 59 + ($setupAttempt == null ? 43 : $setupAttempt.hashCode());
                return result;
            }
        }
    }

    public static class Sofort
    extends StripeObject {
        @SerializedName(value="country")
        String country;

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sofort)) {
                return false;
            }
            Sofort other = (Sofort)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            return !(this$country == null ? other$country != null : !this$country.equals(other$country));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Sofort;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            return result;
        }
    }

    public static class USBankAccount
    extends StripeObject {
        @SerializedName(value="account_holder_type")
        String accountHolderType;
        @SerializedName(value="account_type")
        String accountType;
        @SerializedName(value="bank_name")
        String bankName;
        @SerializedName(value="financial_connections_account")
        String financialConnectionsAccount;
        @SerializedName(value="fingerprint")
        String fingerprint;
        @SerializedName(value="last4")
        String last4;
        @SerializedName(value="networks")
        Networks networks;
        @SerializedName(value="routing_number")
        String routingNumber;

        @Generated
        public String getAccountHolderType() {
            return this.accountHolderType;
        }

        @Generated
        public String getAccountType() {
            return this.accountType;
        }

        @Generated
        public String getBankName() {
            return this.bankName;
        }

        @Generated
        public String getFinancialConnectionsAccount() {
            return this.financialConnectionsAccount;
        }

        @Generated
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Generated
        public String getLast4() {
            return this.last4;
        }

        @Generated
        public Networks getNetworks() {
            return this.networks;
        }

        @Generated
        public String getRoutingNumber() {
            return this.routingNumber;
        }

        @Generated
        public void setAccountHolderType(String accountHolderType) {
            this.accountHolderType = accountHolderType;
        }

        @Generated
        public void setAccountType(String accountType) {
            this.accountType = accountType;
        }

        @Generated
        public void setBankName(String bankName) {
            this.bankName = bankName;
        }

        @Generated
        public void setFinancialConnectionsAccount(String financialConnectionsAccount) {
            this.financialConnectionsAccount = financialConnectionsAccount;
        }

        @Generated
        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Generated
        public void setLast4(String last4) {
            this.last4 = last4;
        }

        @Generated
        public void setNetworks(Networks networks) {
            this.networks = networks;
        }

        @Generated
        public void setRoutingNumber(String routingNumber) {
            this.routingNumber = routingNumber;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof USBankAccount)) {
                return false;
            }
            USBankAccount other = (USBankAccount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accountHolderType = this.getAccountHolderType();
            String other$accountHolderType = other.getAccountHolderType();
            if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) {
                return false;
            }
            String this$accountType = this.getAccountType();
            String other$accountType = other.getAccountType();
            if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
                return false;
            }
            String this$bankName = this.getBankName();
            String other$bankName = other.getBankName();
            if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                return false;
            }
            String this$financialConnectionsAccount = this.getFinancialConnectionsAccount();
            String other$financialConnectionsAccount = other.getFinancialConnectionsAccount();
            if (this$financialConnectionsAccount == null ? other$financialConnectionsAccount != null : !this$financialConnectionsAccount.equals(other$financialConnectionsAccount)) {
                return false;
            }
            String this$fingerprint = this.getFingerprint();
            String other$fingerprint = other.getFingerprint();
            if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                return false;
            }
            String this$last4 = this.getLast4();
            String other$last4 = other.getLast4();
            if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                return false;
            }
            Networks this$networks = this.getNetworks();
            Networks other$networks = other.getNetworks();
            if (this$networks == null ? other$networks != null : !((Object)this$networks).equals(other$networks)) {
                return false;
            }
            String this$routingNumber = this.getRoutingNumber();
            String other$routingNumber = other.getRoutingNumber();
            return !(this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof USBankAccount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accountHolderType = this.getAccountHolderType();
            result = result * 59 + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
            String $accountType = this.getAccountType();
            result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
            String $bankName = this.getBankName();
            result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
            String $financialConnectionsAccount = this.getFinancialConnectionsAccount();
            result = result * 59 + ($financialConnectionsAccount == null ? 43 : $financialConnectionsAccount.hashCode());
            String $fingerprint = this.getFingerprint();
            result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
            String $last4 = this.getLast4();
            result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
            Networks $networks = this.getNetworks();
            result = result * 59 + ($networks == null ? 43 : ((Object)$networks).hashCode());
            String $routingNumber = this.getRoutingNumber();
            result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
            return result;
        }

        public static class Networks
        extends StripeObject {
            @SerializedName(value="preferred")
            String preferred;
            @SerializedName(value="supported")
            List<String> supported;

            @Generated
            public String getPreferred() {
                return this.preferred;
            }

            @Generated
            public List<String> getSupported() {
                return this.supported;
            }

            @Generated
            public void setPreferred(String preferred) {
                this.preferred = preferred;
            }

            @Generated
            public void setSupported(List<String> supported) {
                this.supported = supported;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Networks)) {
                    return false;
                }
                Networks other = (Networks)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$preferred = this.getPreferred();
                String other$preferred = other.getPreferred();
                if (this$preferred == null ? other$preferred != null : !this$preferred.equals(other$preferred)) {
                    return false;
                }
                List<String> this$supported = this.getSupported();
                List<String> other$supported = other.getSupported();
                return !(this$supported == null ? other$supported != null : !((Object)this$supported).equals(other$supported));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Networks;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $preferred = this.getPreferred();
                result = result * 59 + ($preferred == null ? 43 : $preferred.hashCode());
                List<String> $supported = this.getSupported();
                result = result * 59 + ($supported == null ? 43 : ((Object)$supported).hashCode());
                return result;
            }
        }
    }

    public static class WechatPay
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WechatPay)) {
                return false;
            }
            WechatPay other = (WechatPay)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WechatPay;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class Zip
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Zip)) {
                return false;
            }
            Zip other = (Zip)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Zip;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }
}

