/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SubscriptionScheduleAmendParams
extends ApiRequestParams {
    @SerializedName(value="amendments")
    List<Amendment> amendments;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="schedule_settings")
    ScheduleSettings scheduleSettings;

    private SubscriptionScheduleAmendParams(List<Amendment> amendments, List<String> expand, Map<String, Object> extraParams, ScheduleSettings scheduleSettings) {
        this.amendments = amendments;
        this.expand = expand;
        this.extraParams = extraParams;
        this.scheduleSettings = scheduleSettings;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public List<Amendment> getAmendments() {
        return this.amendments;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public ScheduleSettings getScheduleSettings() {
        return this.scheduleSettings;
    }

    public static class ScheduleSettings {
        @SerializedName(value="end_behavior")
        EndBehavior endBehavior;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private ScheduleSettings(EndBehavior endBehavior, Map<String, Object> extraParams) {
            this.endBehavior = endBehavior;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public EndBehavior getEndBehavior() {
            return this.endBehavior;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static enum EndBehavior implements ApiRequestParams.EnumParam
        {
            CANCEL("cancel"),
            RELEASE("release");

            private final String value;

            private EndBehavior(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private EndBehavior endBehavior;
            private Map<String, Object> extraParams;

            public ScheduleSettings build() {
                return new ScheduleSettings(this.endBehavior, this.extraParams);
            }

            public Builder setEndBehavior(EndBehavior endBehavior) {
                this.endBehavior = endBehavior;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class Builder {
        private List<Amendment> amendments;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private ScheduleSettings scheduleSettings;

        public SubscriptionScheduleAmendParams build() {
            return new SubscriptionScheduleAmendParams(this.amendments, this.expand, this.extraParams, this.scheduleSettings);
        }

        public Builder addAmendment(Amendment element) {
            if (this.amendments == null) {
                this.amendments = new ArrayList<Amendment>();
            }
            this.amendments.add(element);
            return this;
        }

        public Builder addAllAmendment(List<Amendment> elements) {
            if (this.amendments == null) {
                this.amendments = new ArrayList<Amendment>();
            }
            this.amendments.addAll(elements);
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setScheduleSettings(ScheduleSettings scheduleSettings) {
            this.scheduleSettings = scheduleSettings;
            return this;
        }
    }

    public static class Amendment {
        @SerializedName(value="amendment_end")
        AmendmentEnd amendmentEnd;
        @SerializedName(value="amendment_start")
        AmendmentStart amendmentStart;
        @SerializedName(value="billing_cycle_anchor")
        BillingCycleAnchor billingCycleAnchor;
        @SerializedName(value="discount_actions")
        List<DiscountAction> discountActions;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="item_actions")
        List<ItemAction> itemActions;
        @SerializedName(value="proration_behavior")
        ProrationBehavior prorationBehavior;
        @SerializedName(value="trial_settings")
        TrialSettings trialSettings;

        private Amendment(AmendmentEnd amendmentEnd, AmendmentStart amendmentStart, BillingCycleAnchor billingCycleAnchor, List<DiscountAction> discountActions, Map<String, Object> extraParams, List<ItemAction> itemActions, ProrationBehavior prorationBehavior, TrialSettings trialSettings) {
            this.amendmentEnd = amendmentEnd;
            this.amendmentStart = amendmentStart;
            this.billingCycleAnchor = billingCycleAnchor;
            this.discountActions = discountActions;
            this.extraParams = extraParams;
            this.itemActions = itemActions;
            this.prorationBehavior = prorationBehavior;
            this.trialSettings = trialSettings;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public AmendmentEnd getAmendmentEnd() {
            return this.amendmentEnd;
        }

        @Generated
        public AmendmentStart getAmendmentStart() {
            return this.amendmentStart;
        }

        @Generated
        public BillingCycleAnchor getBillingCycleAnchor() {
            return this.billingCycleAnchor;
        }

        @Generated
        public List<DiscountAction> getDiscountActions() {
            return this.discountActions;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public List<ItemAction> getItemActions() {
            return this.itemActions;
        }

        @Generated
        public ProrationBehavior getProrationBehavior() {
            return this.prorationBehavior;
        }

        @Generated
        public TrialSettings getTrialSettings() {
            return this.trialSettings;
        }

        public static class AmendmentEnd {
            @SerializedName(value="discount_end")
            DiscountEnd discountEnd;
            @SerializedName(value="duration")
            Duration duration;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="timestamp")
            Long timestamp;
            @SerializedName(value="type")
            Type type;

            private AmendmentEnd(DiscountEnd discountEnd, Duration duration, Map<String, Object> extraParams, Long timestamp, Type type) {
                this.discountEnd = discountEnd;
                this.duration = duration;
                this.extraParams = extraParams;
                this.timestamp = timestamp;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public DiscountEnd getDiscountEnd() {
                return this.discountEnd;
            }

            @Generated
            public Duration getDuration() {
                return this.duration;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Long getTimestamp() {
                return this.timestamp;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            public static class DiscountEnd {
                @SerializedName(value="discount")
                String discount;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private DiscountEnd(String discount, Map<String, Object> extraParams) {
                    this.discount = discount;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getDiscount() {
                    return this.discount;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class Builder {
                    private String discount;
                    private Map<String, Object> extraParams;

                    public DiscountEnd build() {
                        return new DiscountEnd(this.discount, this.extraParams);
                    }

                    public Builder setDiscount(String discount) {
                        this.discount = discount;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }

            public static class Duration {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="interval")
                Interval interval;
                @SerializedName(value="interval_count")
                Long intervalCount;

                private Duration(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
                    this.extraParams = extraParams;
                    this.interval = interval;
                    this.intervalCount = intervalCount;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Interval getInterval() {
                    return this.interval;
                }

                @Generated
                public Long getIntervalCount() {
                    return this.intervalCount;
                }

                public static enum Interval implements ApiRequestParams.EnumParam
                {
                    DAY("day"),
                    MONTH("month"),
                    WEEK("week"),
                    YEAR("year");

                    private final String value;

                    private Interval(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Interval interval;
                    private Long intervalCount;

                    public Duration build() {
                        return new Duration(this.extraParams, this.interval, this.intervalCount);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setInterval(Interval interval) {
                        this.interval = interval;
                        return this;
                    }

                    public Builder setIntervalCount(Long intervalCount) {
                        this.intervalCount = intervalCount;
                        return this;
                    }
                }
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                DISCOUNT_END("discount_end"),
                DURATION("duration"),
                SCHEDULE_END("schedule_end"),
                TIMESTAMP("timestamp"),
                UPCOMING_INVOICE("upcoming_invoice");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private DiscountEnd discountEnd;
                private Duration duration;
                private Map<String, Object> extraParams;
                private Long timestamp;
                private Type type;

                public AmendmentEnd build() {
                    return new AmendmentEnd(this.discountEnd, this.duration, this.extraParams, this.timestamp, this.type);
                }

                public Builder setDiscountEnd(DiscountEnd discountEnd) {
                    this.discountEnd = discountEnd;
                    return this;
                }

                public Builder setDuration(Duration duration) {
                    this.duration = duration;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setTimestamp(Long timestamp) {
                    this.timestamp = timestamp;
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }
            }
        }

        public static class AmendmentStart {
            @SerializedName(value="amendment_end")
            AmendmentEnd amendmentEnd;
            @SerializedName(value="discount_end")
            DiscountEnd discountEnd;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="timestamp")
            Long timestamp;
            @SerializedName(value="type")
            Type type;

            private AmendmentStart(AmendmentEnd amendmentEnd, DiscountEnd discountEnd, Map<String, Object> extraParams, Long timestamp, Type type) {
                this.amendmentEnd = amendmentEnd;
                this.discountEnd = discountEnd;
                this.extraParams = extraParams;
                this.timestamp = timestamp;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public AmendmentEnd getAmendmentEnd() {
                return this.amendmentEnd;
            }

            @Generated
            public DiscountEnd getDiscountEnd() {
                return this.discountEnd;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Long getTimestamp() {
                return this.timestamp;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            public static class AmendmentEnd {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="index")
                Long index;

                private AmendmentEnd(Map<String, Object> extraParams, Long index) {
                    this.extraParams = extraParams;
                    this.index = index;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Long getIndex() {
                    return this.index;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Long index;

                    public AmendmentEnd build() {
                        return new AmendmentEnd(this.extraParams, this.index);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setIndex(Long index) {
                        this.index = index;
                        return this;
                    }
                }
            }

            public static class DiscountEnd {
                @SerializedName(value="discount")
                String discount;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private DiscountEnd(String discount, Map<String, Object> extraParams) {
                    this.discount = discount;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getDiscount() {
                    return this.discount;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class Builder {
                    private String discount;
                    private Map<String, Object> extraParams;

                    public DiscountEnd build() {
                        return new DiscountEnd(this.discount, this.extraParams);
                    }

                    public Builder setDiscount(String discount) {
                        this.discount = discount;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                AMENDMENT_END("amendment_end"),
                DISCOUNT_END("discount_end"),
                NOW("now"),
                SCHEDULE_END("schedule_end"),
                TIMESTAMP("timestamp"),
                UPCOMING_INVOICE("upcoming_invoice");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private AmendmentEnd amendmentEnd;
                private DiscountEnd discountEnd;
                private Map<String, Object> extraParams;
                private Long timestamp;
                private Type type;

                public AmendmentStart build() {
                    return new AmendmentStart(this.amendmentEnd, this.discountEnd, this.extraParams, this.timestamp, this.type);
                }

                public Builder setAmendmentEnd(AmendmentEnd amendmentEnd) {
                    this.amendmentEnd = amendmentEnd;
                    return this;
                }

                public Builder setDiscountEnd(DiscountEnd discountEnd) {
                    this.discountEnd = discountEnd;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setTimestamp(Long timestamp) {
                    this.timestamp = timestamp;
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }
            }
        }

        public static enum BillingCycleAnchor implements ApiRequestParams.EnumParam
        {
            AMENDMENT_START("amendment_start"),
            AUTOMATIC("automatic");

            private final String value;

            private BillingCycleAnchor(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum ProrationBehavior implements ApiRequestParams.EnumParam
        {
            ALWAYS_INVOICE("always_invoice"),
            CREATE_PRORATIONS("create_prorations"),
            NONE("none");

            private final String value;

            private ProrationBehavior(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class TrialSettings {
            @SerializedName(value="end_behavior")
            EndBehavior endBehavior;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private TrialSettings(EndBehavior endBehavior, Map<String, Object> extraParams) {
                this.endBehavior = endBehavior;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public EndBehavior getEndBehavior() {
                return this.endBehavior;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class EndBehavior {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="prorate_up_front")
                ProrateUpFront prorateUpFront;

                private EndBehavior(Map<String, Object> extraParams, ProrateUpFront prorateUpFront) {
                    this.extraParams = extraParams;
                    this.prorateUpFront = prorateUpFront;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public ProrateUpFront getProrateUpFront() {
                    return this.prorateUpFront;
                }

                public static enum ProrateUpFront implements ApiRequestParams.EnumParam
                {
                    DEFER("defer"),
                    INCLUDE("include");

                    private final String value;

                    private ProrateUpFront(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private ProrateUpFront prorateUpFront;

                    public EndBehavior build() {
                        return new EndBehavior(this.extraParams, this.prorateUpFront);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setProrateUpFront(ProrateUpFront prorateUpFront) {
                        this.prorateUpFront = prorateUpFront;
                        return this;
                    }
                }
            }

            public static class Builder {
                private EndBehavior endBehavior;
                private Map<String, Object> extraParams;

                public TrialSettings build() {
                    return new TrialSettings(this.endBehavior, this.extraParams);
                }

                public Builder setEndBehavior(EndBehavior endBehavior) {
                    this.endBehavior = endBehavior;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Builder {
            private AmendmentEnd amendmentEnd;
            private AmendmentStart amendmentStart;
            private BillingCycleAnchor billingCycleAnchor;
            private List<DiscountAction> discountActions;
            private Map<String, Object> extraParams;
            private List<ItemAction> itemActions;
            private ProrationBehavior prorationBehavior;
            private TrialSettings trialSettings;

            public Amendment build() {
                return new Amendment(this.amendmentEnd, this.amendmentStart, this.billingCycleAnchor, this.discountActions, this.extraParams, this.itemActions, this.prorationBehavior, this.trialSettings);
            }

            public Builder setAmendmentEnd(AmendmentEnd amendmentEnd) {
                this.amendmentEnd = amendmentEnd;
                return this;
            }

            public Builder setAmendmentStart(AmendmentStart amendmentStart) {
                this.amendmentStart = amendmentStart;
                return this;
            }

            public Builder setBillingCycleAnchor(BillingCycleAnchor billingCycleAnchor) {
                this.billingCycleAnchor = billingCycleAnchor;
                return this;
            }

            public Builder addDiscountAction(DiscountAction element) {
                if (this.discountActions == null) {
                    this.discountActions = new ArrayList<DiscountAction>();
                }
                this.discountActions.add(element);
                return this;
            }

            public Builder addAllDiscountAction(List<DiscountAction> elements) {
                if (this.discountActions == null) {
                    this.discountActions = new ArrayList<DiscountAction>();
                }
                this.discountActions.addAll(elements);
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder addItemAction(ItemAction element) {
                if (this.itemActions == null) {
                    this.itemActions = new ArrayList<ItemAction>();
                }
                this.itemActions.add(element);
                return this;
            }

            public Builder addAllItemAction(List<ItemAction> elements) {
                if (this.itemActions == null) {
                    this.itemActions = new ArrayList<ItemAction>();
                }
                this.itemActions.addAll(elements);
                return this;
            }

            public Builder setProrationBehavior(ProrationBehavior prorationBehavior) {
                this.prorationBehavior = prorationBehavior;
                return this;
            }

            public Builder setTrialSettings(TrialSettings trialSettings) {
                this.trialSettings = trialSettings;
                return this;
            }
        }

        public static class ItemAction {
            @SerializedName(value="add")
            Add add;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="remove")
            Remove remove;
            @SerializedName(value="set")
            Set set;
            @SerializedName(value="type")
            Type type;

            private ItemAction(Add add, Map<String, Object> extraParams, Remove remove, Set set, Type type) {
                this.add = add;
                this.extraParams = extraParams;
                this.remove = remove;
                this.set = set;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Add getAdd() {
                return this.add;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Remove getRemove() {
                return this.remove;
            }

            @Generated
            public Set getSet() {
                return this.set;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            public static class Add {
                @SerializedName(value="discounts")
                List<Discount> discounts;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="metadata")
                Map<String, String> metadata;
                @SerializedName(value="price")
                String price;
                @SerializedName(value="quantity")
                Long quantity;
                @SerializedName(value="tax_rates")
                List<String> taxRates;
                @SerializedName(value="trial")
                Trial trial;

                private Add(List<Discount> discounts, Map<String, Object> extraParams, Map<String, String> metadata, String price, Long quantity, List<String> taxRates, Trial trial) {
                    this.discounts = discounts;
                    this.extraParams = extraParams;
                    this.metadata = metadata;
                    this.price = price;
                    this.quantity = quantity;
                    this.taxRates = taxRates;
                    this.trial = trial;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public List<Discount> getDiscounts() {
                    return this.discounts;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Map<String, String> getMetadata() {
                    return this.metadata;
                }

                @Generated
                public String getPrice() {
                    return this.price;
                }

                @Generated
                public Long getQuantity() {
                    return this.quantity;
                }

                @Generated
                public List<String> getTaxRates() {
                    return this.taxRates;
                }

                @Generated
                public Trial getTrial() {
                    return this.trial;
                }

                public static class Trial {
                    @SerializedName(value="converts_to")
                    List<String> convertsTo;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="type")
                    Type type;

                    private Trial(List<String> convertsTo, Map<String, Object> extraParams, Type type) {
                        this.convertsTo = convertsTo;
                        this.extraParams = extraParams;
                        this.type = type;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public List<String> getConvertsTo() {
                        return this.convertsTo;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Type getType() {
                        return this.type;
                    }

                    public static enum Type implements ApiRequestParams.EnumParam
                    {
                        FREE("free"),
                        PAID("paid");

                        private final String value;

                        private Type(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private List<String> convertsTo;
                        private Map<String, Object> extraParams;
                        private Type type;

                        public Trial build() {
                            return new Trial(this.convertsTo, this.extraParams, this.type);
                        }

                        public Builder addConvertsTo(String element) {
                            if (this.convertsTo == null) {
                                this.convertsTo = new ArrayList<String>();
                            }
                            this.convertsTo.add(element);
                            return this;
                        }

                        public Builder addAllConvertsTo(List<String> elements) {
                            if (this.convertsTo == null) {
                                this.convertsTo = new ArrayList<String>();
                            }
                            this.convertsTo.addAll(elements);
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setType(Type type) {
                            this.type = type;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private List<Discount> discounts;
                    private Map<String, Object> extraParams;
                    private Map<String, String> metadata;
                    private String price;
                    private Long quantity;
                    private List<String> taxRates;
                    private Trial trial;

                    public Add build() {
                        return new Add(this.discounts, this.extraParams, this.metadata, this.price, this.quantity, this.taxRates, this.trial);
                    }

                    public Builder addDiscount(Discount element) {
                        if (this.discounts == null) {
                            this.discounts = new ArrayList<Discount>();
                        }
                        this.discounts.add(element);
                        return this;
                    }

                    public Builder addAllDiscount(List<Discount> elements) {
                        if (this.discounts == null) {
                            this.discounts = new ArrayList<Discount>();
                        }
                        this.discounts.addAll(elements);
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder putMetadata(String key, String value) {
                        if (this.metadata == null) {
                            this.metadata = new HashMap<String, String>();
                        }
                        this.metadata.put(key, value);
                        return this;
                    }

                    public Builder putAllMetadata(Map<String, String> map) {
                        if (this.metadata == null) {
                            this.metadata = new HashMap<String, String>();
                        }
                        this.metadata.putAll(map);
                        return this;
                    }

                    public Builder setPrice(String price) {
                        this.price = price;
                        return this;
                    }

                    public Builder setQuantity(Long quantity) {
                        this.quantity = quantity;
                        return this;
                    }

                    public Builder addTaxRate(String element) {
                        if (this.taxRates == null) {
                            this.taxRates = new ArrayList<String>();
                        }
                        this.taxRates.add(element);
                        return this;
                    }

                    public Builder addAllTaxRate(List<String> elements) {
                        if (this.taxRates == null) {
                            this.taxRates = new ArrayList<String>();
                        }
                        this.taxRates.addAll(elements);
                        return this;
                    }

                    public Builder setTrial(Trial trial) {
                        this.trial = trial;
                        return this;
                    }
                }

                public static class Discount {
                    @SerializedName(value="coupon")
                    String coupon;
                    @SerializedName(value="discount")
                    String discount;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;

                    private Discount(String coupon, String discount, Map<String, Object> extraParams) {
                        this.coupon = coupon;
                        this.discount = discount;
                        this.extraParams = extraParams;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public String getCoupon() {
                        return this.coupon;
                    }

                    @Generated
                    public String getDiscount() {
                        return this.discount;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    public static class Builder {
                        private String coupon;
                        private String discount;
                        private Map<String, Object> extraParams;

                        public Discount build() {
                            return new Discount(this.coupon, this.discount, this.extraParams);
                        }

                        public Builder setCoupon(String coupon) {
                            this.coupon = coupon;
                            return this;
                        }

                        public Builder setDiscount(String discount) {
                            this.discount = discount;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }
                    }
                }
            }

            public static class Remove {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="price")
                String price;

                private Remove(Map<String, Object> extraParams, String price) {
                    this.extraParams = extraParams;
                    this.price = price;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getPrice() {
                    return this.price;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String price;

                    public Remove build() {
                        return new Remove(this.extraParams, this.price);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setPrice(String price) {
                        this.price = price;
                        return this;
                    }
                }
            }

            public static class Set {
                @SerializedName(value="discounts")
                List<Discount> discounts;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="metadata")
                Map<String, String> metadata;
                @SerializedName(value="price")
                String price;
                @SerializedName(value="quantity")
                Long quantity;
                @SerializedName(value="tax_rates")
                List<String> taxRates;
                @SerializedName(value="trial")
                Trial trial;

                private Set(List<Discount> discounts, Map<String, Object> extraParams, Map<String, String> metadata, String price, Long quantity, List<String> taxRates, Trial trial) {
                    this.discounts = discounts;
                    this.extraParams = extraParams;
                    this.metadata = metadata;
                    this.price = price;
                    this.quantity = quantity;
                    this.taxRates = taxRates;
                    this.trial = trial;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public List<Discount> getDiscounts() {
                    return this.discounts;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Map<String, String> getMetadata() {
                    return this.metadata;
                }

                @Generated
                public String getPrice() {
                    return this.price;
                }

                @Generated
                public Long getQuantity() {
                    return this.quantity;
                }

                @Generated
                public List<String> getTaxRates() {
                    return this.taxRates;
                }

                @Generated
                public Trial getTrial() {
                    return this.trial;
                }

                public static class Trial {
                    @SerializedName(value="converts_to")
                    List<String> convertsTo;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="type")
                    Type type;

                    private Trial(List<String> convertsTo, Map<String, Object> extraParams, Type type) {
                        this.convertsTo = convertsTo;
                        this.extraParams = extraParams;
                        this.type = type;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public List<String> getConvertsTo() {
                        return this.convertsTo;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Type getType() {
                        return this.type;
                    }

                    public static enum Type implements ApiRequestParams.EnumParam
                    {
                        FREE("free"),
                        PAID("paid");

                        private final String value;

                        private Type(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private List<String> convertsTo;
                        private Map<String, Object> extraParams;
                        private Type type;

                        public Trial build() {
                            return new Trial(this.convertsTo, this.extraParams, this.type);
                        }

                        public Builder addConvertsTo(String element) {
                            if (this.convertsTo == null) {
                                this.convertsTo = new ArrayList<String>();
                            }
                            this.convertsTo.add(element);
                            return this;
                        }

                        public Builder addAllConvertsTo(List<String> elements) {
                            if (this.convertsTo == null) {
                                this.convertsTo = new ArrayList<String>();
                            }
                            this.convertsTo.addAll(elements);
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setType(Type type) {
                            this.type = type;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private List<Discount> discounts;
                    private Map<String, Object> extraParams;
                    private Map<String, String> metadata;
                    private String price;
                    private Long quantity;
                    private List<String> taxRates;
                    private Trial trial;

                    public Set build() {
                        return new Set(this.discounts, this.extraParams, this.metadata, this.price, this.quantity, this.taxRates, this.trial);
                    }

                    public Builder addDiscount(Discount element) {
                        if (this.discounts == null) {
                            this.discounts = new ArrayList<Discount>();
                        }
                        this.discounts.add(element);
                        return this;
                    }

                    public Builder addAllDiscount(List<Discount> elements) {
                        if (this.discounts == null) {
                            this.discounts = new ArrayList<Discount>();
                        }
                        this.discounts.addAll(elements);
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder putMetadata(String key, String value) {
                        if (this.metadata == null) {
                            this.metadata = new HashMap<String, String>();
                        }
                        this.metadata.put(key, value);
                        return this;
                    }

                    public Builder putAllMetadata(Map<String, String> map) {
                        if (this.metadata == null) {
                            this.metadata = new HashMap<String, String>();
                        }
                        this.metadata.putAll(map);
                        return this;
                    }

                    public Builder setPrice(String price) {
                        this.price = price;
                        return this;
                    }

                    public Builder setQuantity(Long quantity) {
                        this.quantity = quantity;
                        return this;
                    }

                    public Builder addTaxRate(String element) {
                        if (this.taxRates == null) {
                            this.taxRates = new ArrayList<String>();
                        }
                        this.taxRates.add(element);
                        return this;
                    }

                    public Builder addAllTaxRate(List<String> elements) {
                        if (this.taxRates == null) {
                            this.taxRates = new ArrayList<String>();
                        }
                        this.taxRates.addAll(elements);
                        return this;
                    }

                    public Builder setTrial(Trial trial) {
                        this.trial = trial;
                        return this;
                    }
                }

                public static class Discount {
                    @SerializedName(value="coupon")
                    String coupon;
                    @SerializedName(value="discount")
                    String discount;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;

                    private Discount(String coupon, String discount, Map<String, Object> extraParams) {
                        this.coupon = coupon;
                        this.discount = discount;
                        this.extraParams = extraParams;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public String getCoupon() {
                        return this.coupon;
                    }

                    @Generated
                    public String getDiscount() {
                        return this.discount;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    public static class Builder {
                        private String coupon;
                        private String discount;
                        private Map<String, Object> extraParams;

                        public Discount build() {
                            return new Discount(this.coupon, this.discount, this.extraParams);
                        }

                        public Builder setCoupon(String coupon) {
                            this.coupon = coupon;
                            return this;
                        }

                        public Builder setDiscount(String discount) {
                            this.discount = discount;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }
                    }
                }
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                ADD("add"),
                REMOVE("remove"),
                SET("set");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Add add;
                private Map<String, Object> extraParams;
                private Remove remove;
                private Set set;
                private Type type;

                public ItemAction build() {
                    return new ItemAction(this.add, this.extraParams, this.remove, this.set, this.type);
                }

                public Builder setAdd(Add add) {
                    this.add = add;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRemove(Remove remove) {
                    this.remove = remove;
                    return this;
                }

                public Builder setSet(Set set) {
                    this.set = set;
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }
            }
        }

        public static class DiscountAction {
            @SerializedName(value="add")
            Add add;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="remove")
            Remove remove;
            @SerializedName(value="set")
            Set set;
            @SerializedName(value="type")
            Type type;

            private DiscountAction(Add add, Map<String, Object> extraParams, Remove remove, Set set, Type type) {
                this.add = add;
                this.extraParams = extraParams;
                this.remove = remove;
                this.set = set;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Add getAdd() {
                return this.add;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Remove getRemove() {
                return this.remove;
            }

            @Generated
            public Set getSet() {
                return this.set;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            public static class Add {
                @SerializedName(value="coupon")
                String coupon;
                @SerializedName(value="discount")
                String discount;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="index")
                Long index;

                private Add(String coupon, String discount, Map<String, Object> extraParams, Long index) {
                    this.coupon = coupon;
                    this.discount = discount;
                    this.extraParams = extraParams;
                    this.index = index;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCoupon() {
                    return this.coupon;
                }

                @Generated
                public String getDiscount() {
                    return this.discount;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Long getIndex() {
                    return this.index;
                }

                public static class Builder {
                    private String coupon;
                    private String discount;
                    private Map<String, Object> extraParams;
                    private Long index;

                    public Add build() {
                        return new Add(this.coupon, this.discount, this.extraParams, this.index);
                    }

                    public Builder setCoupon(String coupon) {
                        this.coupon = coupon;
                        return this;
                    }

                    public Builder setDiscount(String discount) {
                        this.discount = discount;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setIndex(Long index) {
                        this.index = index;
                        return this;
                    }
                }
            }

            public static class Remove {
                @SerializedName(value="coupon")
                String coupon;
                @SerializedName(value="discount")
                String discount;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private Remove(String coupon, String discount, Map<String, Object> extraParams) {
                    this.coupon = coupon;
                    this.discount = discount;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCoupon() {
                    return this.coupon;
                }

                @Generated
                public String getDiscount() {
                    return this.discount;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class Builder {
                    private String coupon;
                    private String discount;
                    private Map<String, Object> extraParams;

                    public Remove build() {
                        return new Remove(this.coupon, this.discount, this.extraParams);
                    }

                    public Builder setCoupon(String coupon) {
                        this.coupon = coupon;
                        return this;
                    }

                    public Builder setDiscount(String discount) {
                        this.discount = discount;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }

            public static class Set {
                @SerializedName(value="coupon")
                String coupon;
                @SerializedName(value="discount")
                String discount;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private Set(String coupon, String discount, Map<String, Object> extraParams) {
                    this.coupon = coupon;
                    this.discount = discount;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCoupon() {
                    return this.coupon;
                }

                @Generated
                public String getDiscount() {
                    return this.discount;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class Builder {
                    private String coupon;
                    private String discount;
                    private Map<String, Object> extraParams;

                    public Set build() {
                        return new Set(this.coupon, this.discount, this.extraParams);
                    }

                    public Builder setCoupon(String coupon) {
                        this.coupon = coupon;
                        return this;
                    }

                    public Builder setDiscount(String discount) {
                        this.discount = discount;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                ADD("add"),
                REMOVE("remove"),
                SET("set");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Add add;
                private Map<String, Object> extraParams;
                private Remove remove;
                private Set set;
                private Type type;

                public DiscountAction build() {
                    return new DiscountAction(this.add, this.extraParams, this.remove, this.set, this.type);
                }

                public Builder setAdd(Add add) {
                    this.add = add;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRemove(Remove remove) {
                    this.remove = remove;
                    return this;
                }

                public Builder setSet(Set set) {
                    this.set = set;
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }
            }
        }
    }
}

