// Generated by delombok at Fri Nov 04 15:31:23 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.AccountCapabilitiesParams;
import com.stripe.param.AccountCreateParams;
import com.stripe.param.AccountListParams;
import com.stripe.param.AccountPersonsParams;
import com.stripe.param.AccountRejectParams;
import com.stripe.param.AccountRetrieveParams;
import com.stripe.param.AccountUpdateParams;
import java.util.List;
import java.util.Map;

/**
 * This is an object representing a Stripe account. You can retrieve it to see properties on the
 * account like its current e-mail address or if the account is enabled yet to make live charges.
 *
 * <p>Some properties, marked below, are available only to platforms that want to <a
 * href="https://stripe.com/docs/connect/accounts">create and manage Express or Custom accounts</a>.
 */
public class Account extends ApiResource implements MetadataStore<Account>, PaymentSource {
  /**
   * Business information about the account.
   */
  @SerializedName("business_profile")
  BusinessProfile businessProfile;
  /**
   * The business type.
   *
   * <p>One of {@code company}, {@code government_entity}, {@code individual}, or {@code
   * non_profit}.
   */
  @SerializedName("business_type")
  String businessType;
  @SerializedName("capabilities")
  Capabilities capabilities;
  /**
   * Whether the account can create live charges.
   */
  @SerializedName("charges_enabled")
  Boolean chargesEnabled;
  @SerializedName("company")
  Company company;
  @SerializedName("controller")
  Controller controller;
  /**
   * The account's country.
   */
  @SerializedName("country")
  String country;
  /**
   * Time at which the account was connected. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter ISO currency code representing the default currency for the account. This must be
   * a currency that <a href="https://stripe.com/docs/payouts">Stripe supports in the account's
   * country</a>.
   */
  @SerializedName("default_currency")
  String defaultCurrency;
  /**
   * Always true for a deleted object.
   */
  @SerializedName("deleted")
  Boolean deleted;
  /**
   * Whether account details have been submitted. Standard accounts cannot receive payouts before
   * this is true.
   */
  @SerializedName("details_submitted")
  Boolean detailsSubmitted;
  /**
   * An email address associated with the account. You can treat this as metadata: it is not used
   * for authentication or messaging account holders.
   */
  @SerializedName("email")
  String email;
  /**
   * External accounts (bank accounts and debit cards) currently attached to this account.
   */
  @SerializedName("external_accounts")
  ExternalAccountCollection externalAccounts;
  @SerializedName("future_requirements")
  FutureRequirements futureRequirements;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * This is an object representing a person associated with a Stripe account.
   *
   * <p>A platform cannot access a Standard or Express account's persons after the account starts
   * onboarding, such as after generating an account link for the account. See the <a
   * href="https://stripe.com/docs/connect/standard-accounts">Standard onboarding</a> or <a
   * href="https://stripe.com/docs/connect/express-accounts">Express onboarding documentation</a>
   * for information about platform pre-filling and account onboarding steps.
   *
   * <p>Related guide: <a
   * href="https://stripe.com/docs/connect/identity-verification-api#person-information">Handling
   * Identity Verification with the API</a>.
   */
  @SerializedName("individual")
  Person individual;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code account}.
   */
  @SerializedName("object")
  String object;
  /**
   * Whether Stripe can send payouts to this account.
   */
  @SerializedName("payouts_enabled")
  Boolean payoutsEnabled;
  @SerializedName("requirements")
  Requirements requirements;
  /**
   * Options for customizing how the account functions within Stripe.
   */
  @SerializedName("settings")
  Settings settings;
  @SerializedName("tos_acceptance")
  TosAcceptance tosAcceptance;
  /**
   * The Stripe account type. Can be {@code standard}, {@code express}, or {@code custom}.
   */
  @SerializedName("type")
  String type;

  /**
   * Returns a list of capabilities associated with the account. The capabilities are returned
   * sorted by creation date, with the most recent capability appearing first.
   */
  public CapabilityCollection capabilities() throws StripeException {
    return capabilities((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Returns a list of capabilities associated with the account. The capabilities are returned
   * sorted by creation date, with the most recent capability appearing first.
   */
  public CapabilityCollection capabilities(Map<String, Object> params) throws StripeException {
    return capabilities(params, (RequestOptions) null);
  }

  /**
   * Returns a list of capabilities associated with the account. The capabilities are returned
   * sorted by creation date, with the most recent capability appearing first.
   */
  public CapabilityCollection capabilities(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/capabilities", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, CapabilityCollection.class, options);
  }

  /**
   * Returns a list of capabilities associated with the account. The capabilities are returned
   * sorted by creation date, with the most recent capability appearing first.
   */
  public CapabilityCollection capabilities(AccountCapabilitiesParams params) throws StripeException {
    return capabilities(params, (RequestOptions) null);
  }

  /**
   * Returns a list of capabilities associated with the account. The capabilities are returned
   * sorted by creation date, with the most recent capability appearing first.
   */
  public CapabilityCollection capabilities(AccountCapabilitiesParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/capabilities", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, CapabilityCollection.class, options);
  }

  /**
   * With <a href="https://stripe.com/docs/connect">Connect</a>, you can create Stripe accounts for
   * your users. To do this, you’ll first need to <a
   * href="https://dashboard.stripe.com/account/applications/settings">register your platform</a>.
   */
  public static Account create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * With <a href="https://stripe.com/docs/connect">Connect</a>, you can create Stripe accounts for
   * your users. To do this, you’ll first need to <a
   * href="https://dashboard.stripe.com/account/applications/settings">register your platform</a>.
   */
  public static Account create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/accounts");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
  }

  /**
   * With <a href="https://stripe.com/docs/connect">Connect</a>, you can create Stripe accounts for
   * your users. To do this, you’ll first need to <a
   * href="https://dashboard.stripe.com/account/applications/settings">register your platform</a>.
   */
  public static Account create(AccountCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * With <a href="https://stripe.com/docs/connect">Connect</a>, you can create Stripe accounts for
   * your users. To do this, you’ll first need to <a
   * href="https://dashboard.stripe.com/account/applications/settings">register your platform</a>.
   */
  public static Account create(AccountCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/accounts");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
  }

  /**
   * With <a href="https://stripe.com/docs/connect">Connect</a>, you can delete accounts you manage.
   *
   * <p>Accounts created using test-mode keys can be deleted at any time. Standard accounts created
   * using live-mode keys cannot be deleted. Custom or Express accounts created using live-mode keys
   * can only be deleted once all balances are zero.
   *
   * <p>If you want to delete your own account, use the <a
   * href="https://dashboard.stripe.com/account">account information tab in your account
   * settings</a> instead.
   */
  public Account delete() throws StripeException {
    return delete((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * With <a href="https://stripe.com/docs/connect">Connect</a>, you can delete accounts you manage.
   *
   * <p>Accounts created using test-mode keys can be deleted at any time. Standard accounts created
   * using live-mode keys cannot be deleted. Custom or Express accounts created using live-mode keys
   * can only be deleted once all balances are zero.
   *
   * <p>If you want to delete your own account, use the <a
   * href="https://dashboard.stripe.com/account">account information tab in your account
   * settings</a> instead.
   */
  public Account delete(RequestOptions options) throws StripeException {
    return delete((Map<String, Object>) null, options);
  }

  /**
   * With <a href="https://stripe.com/docs/connect">Connect</a>, you can delete accounts you manage.
   *
   * <p>Accounts created using test-mode keys can be deleted at any time. Standard accounts created
   * using live-mode keys cannot be deleted. Custom or Express accounts created using live-mode keys
   * can only be deleted once all balances are zero.
   *
   * <p>If you want to delete your own account, use the <a
   * href="https://dashboard.stripe.com/account">account information tab in your account
   * settings</a> instead.
   */
  public Account delete(Map<String, Object> params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * With <a href="https://stripe.com/docs/connect">Connect</a>, you can delete accounts you manage.
   *
   * <p>Accounts created using test-mode keys can be deleted at any time. Standard accounts created
   * using live-mode keys cannot be deleted. Custom or Express accounts created using live-mode keys
   * can only be deleted once all balances are zero.
   *
   * <p>If you want to delete your own account, use the <a
   * href="https://dashboard.stripe.com/account">account information tab in your account
   * settings</a> instead.
   */
  public Account delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Account.class, options);
  }

  /**
   * Returns a list of accounts connected to your platform via <a
   * href="https://stripe.com/docs/connect">Connect</a>. If you’re not a platform, the list is
   * empty.
   */
  public static AccountCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of accounts connected to your platform via <a
   * href="https://stripe.com/docs/connect">Connect</a>. If you’re not a platform, the list is
   * empty.
   */
  public static AccountCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/accounts");
    return ApiResource.requestCollection(url, params, AccountCollection.class, options);
  }

  /**
   * Returns a list of accounts connected to your platform via <a
   * href="https://stripe.com/docs/connect">Connect</a>. If you’re not a platform, the list is
   * empty.
   */
  public static AccountCollection list(AccountListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of accounts connected to your platform via <a
   * href="https://stripe.com/docs/connect">Connect</a>. If you’re not a platform, the list is
   * empty.
   */
  public static AccountCollection list(AccountListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/accounts");
    return ApiResource.requestCollection(url, params, AccountCollection.class, options);
  }

  /**
   * Returns a list of people associated with the account’s legal entity. The people are returned
   * sorted by creation date, with the most recent people appearing first.
   */
  public PersonCollection persons() throws StripeException {
    return persons((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Returns a list of people associated with the account’s legal entity. The people are returned
   * sorted by creation date, with the most recent people appearing first.
   */
  public PersonCollection persons(Map<String, Object> params) throws StripeException {
    return persons(params, (RequestOptions) null);
  }

  /**
   * Returns a list of people associated with the account’s legal entity. The people are returned
   * sorted by creation date, with the most recent people appearing first.
   */
  public PersonCollection persons(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/persons", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, PersonCollection.class, options);
  }

  /**
   * Returns a list of people associated with the account’s legal entity. The people are returned
   * sorted by creation date, with the most recent people appearing first.
   */
  public PersonCollection persons(AccountPersonsParams params) throws StripeException {
    return persons(params, (RequestOptions) null);
  }

  /**
   * Returns a list of people associated with the account’s legal entity. The people are returned
   * sorted by creation date, with the most recent people appearing first.
   */
  public PersonCollection persons(AccountPersonsParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/persons", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, PersonCollection.class, options);
  }

  /**
   * With <a href="https://stripe.com/docs/connect">Connect</a>, you may flag accounts as
   * suspicious.
   *
   * <p>Test-mode Custom and Express accounts can be rejected at any time. Accounts created using
   * live-mode keys may only be rejected once all balances are zero.
   */
  public Account reject(Map<String, Object> params) throws StripeException {
    return reject(params, (RequestOptions) null);
  }

  /**
   * With <a href="https://stripe.com/docs/connect">Connect</a>, you may flag accounts as
   * suspicious.
   *
   * <p>Test-mode Custom and Express accounts can be rejected at any time. Accounts created using
   * live-mode keys may only be rejected once all balances are zero.
   */
  public Account reject(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/reject", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
  }

  /**
   * With <a href="https://stripe.com/docs/connect">Connect</a>, you may flag accounts as
   * suspicious.
   *
   * <p>Test-mode Custom and Express accounts can be rejected at any time. Accounts created using
   * live-mode keys may only be rejected once all balances are zero.
   */
  public Account reject(AccountRejectParams params) throws StripeException {
    return reject(params, (RequestOptions) null);
  }

  /**
   * With <a href="https://stripe.com/docs/connect">Connect</a>, you may flag accounts as
   * suspicious.
   *
   * <p>Test-mode Custom and Express accounts can be rejected at any time. Accounts created using
   * live-mode keys may only be rejected once all balances are zero.
   */
  public Account reject(AccountRejectParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s/reject", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
  }

  /**
   * Retrieves the details of an account.
   */
  public static Account retrieve() throws StripeException {
    return retrieve((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an account.
   */
  public static Account retrieve(RequestOptions options) throws StripeException {
    return retrieve((Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an account.
   */
  public static Account retrieve(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/account");
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Account.class, options);
  }

  /**
   * Retrieves the details of an account.
   */
  public static Account retrieve(AccountRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/account");
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Account.class, options);
  }

  /**
   * Retrieves the details of an account.
   */
  public static Account retrieve(String account) throws StripeException {
    return retrieve(account, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an account.
   */
  public static Account retrieve(String account, RequestOptions options) throws StripeException {
    return retrieve(account, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an account.
   */
  public static Account retrieve(String account, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s", ApiResource.urlEncodeId(account)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Account.class, options);
  }

  /**
   * Retrieves the details of an account.
   */
  public static Account retrieve(String account, AccountRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s", ApiResource.urlEncodeId(account)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Account.class, options);
  }

  /**
   * Updates a <a href="https://stripe.com/docs/connect/accounts">connected account</a> by setting
   * the values of the parameters passed. Any parameters not provided are left unchanged. Most
   * parameters can be changed only for Custom accounts. (These are marked <strong>Custom
   * Only</strong> below.) Parameters marked <strong>Custom and Express</strong> are not supported
   * for Standard accounts.
   *
   * <p>To update your own account, use the <a
   * href="https://dashboard.stripe.com/account">Dashboard</a>. Refer to our <a
   * href="https://stripe.com/docs/connect/updating-accounts">Connect</a> documentation to learn
   * more about updating accounts.
   */
  @Override
  public Account update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a <a href="https://stripe.com/docs/connect/accounts">connected account</a> by setting
   * the values of the parameters passed. Any parameters not provided are left unchanged. Most
   * parameters can be changed only for Custom accounts. (These are marked <strong>Custom
   * Only</strong> below.) Parameters marked <strong>Custom and Express</strong> are not supported
   * for Standard accounts.
   *
   * <p>To update your own account, use the <a
   * href="https://dashboard.stripe.com/account">Dashboard</a>. Refer to our <a
   * href="https://stripe.com/docs/connect/updating-accounts">Connect</a> documentation to learn
   * more about updating accounts.
   */
  @Override
  public Account update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
  }

  /**
   * Updates a <a href="https://stripe.com/docs/connect/accounts">connected account</a> by setting
   * the values of the parameters passed. Any parameters not provided are left unchanged. Most
   * parameters can be changed only for Custom accounts. (These are marked <strong>Custom
   * Only</strong> below.) Parameters marked <strong>Custom and Express</strong> are not supported
   * for Standard accounts.
   *
   * <p>To update your own account, use the <a
   * href="https://dashboard.stripe.com/account">Dashboard</a>. Refer to our <a
   * href="https://stripe.com/docs/connect/updating-accounts">Connect</a> documentation to learn
   * more about updating accounts.
   */
  public Account update(AccountUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a <a href="https://stripe.com/docs/connect/accounts">connected account</a> by setting
   * the values of the parameters passed. Any parameters not provided are left unchanged. Most
   * parameters can be changed only for Custom accounts. (These are marked <strong>Custom
   * Only</strong> below.) Parameters marked <strong>Custom and Express</strong> are not supported
   * for Standard accounts.
   *
   * <p>To update your own account, use the <a
   * href="https://dashboard.stripe.com/account">Dashboard</a>. Refer to our <a
   * href="https://stripe.com/docs/connect/updating-accounts">Connect</a> documentation to learn
   * more about updating accounts.
   */
  public Account update(AccountUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/accounts/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Account.class, options);
  }


  public static class BusinessProfile extends StripeObject {
    /**
     * <a href="https://stripe.com/docs/connect/setting-mcc">The merchant category code for the
     * account</a>. MCCs are used to classify businesses based on the goods or services they
     * provide.
     */
    @SerializedName("mcc")
    String mcc;
    /**
     * The customer-facing business name.
     */
    @SerializedName("name")
    String name;
    /**
     * Internal-only description of the product sold or service provided by the business. It's used
     * by Stripe for risk and underwriting purposes.
     */
    @SerializedName("product_description")
    String productDescription;
    /**
     * A publicly available mailing address for sending support issues to.
     */
    @SerializedName("support_address")
    Address supportAddress;
    /**
     * A publicly available email address for sending support issues to.
     */
    @SerializedName("support_email")
    String supportEmail;
    /**
     * A publicly available phone number to call with support issues.
     */
    @SerializedName("support_phone")
    String supportPhone;
    /**
     * A publicly available website for handling support issues.
     */
    @SerializedName("support_url")
    String supportUrl;
    /**
     * The business's publicly available website.
     */
    @SerializedName("url")
    String url;

    /**
     * <a href="https://stripe.com/docs/connect/setting-mcc">The merchant category code for the
     * account</a>. MCCs are used to classify businesses based on the goods or services they
     * provide.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcc() {
      return this.mcc;
    }

    /**
     * The customer-facing business name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    /**
     * Internal-only description of the product sold or service provided by the business. It's used
     * by Stripe for risk and underwriting purposes.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getProductDescription() {
      return this.productDescription;
    }

    /**
     * A publicly available mailing address for sending support issues to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Address getSupportAddress() {
      return this.supportAddress;
    }

    /**
     * A publicly available email address for sending support issues to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSupportEmail() {
      return this.supportEmail;
    }

    /**
     * A publicly available phone number to call with support issues.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSupportPhone() {
      return this.supportPhone;
    }

    /**
     * A publicly available website for handling support issues.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSupportUrl() {
      return this.supportUrl;
    }

    /**
     * The business's publicly available website.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUrl() {
      return this.url;
    }

    /**
     * <a href="https://stripe.com/docs/connect/setting-mcc">The merchant category code for the
     * account</a>. MCCs are used to classify businesses based on the goods or services they
     * provide.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMcc(final String mcc) {
      this.mcc = mcc;
    }

    /**
     * The customer-facing business name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
      this.name = name;
    }

    /**
     * Internal-only description of the product sold or service provided by the business. It's used
     * by Stripe for risk and underwriting purposes.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProductDescription(final String productDescription) {
      this.productDescription = productDescription;
    }

    /**
     * A publicly available mailing address for sending support issues to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSupportAddress(final Address supportAddress) {
      this.supportAddress = supportAddress;
    }

    /**
     * A publicly available email address for sending support issues to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSupportEmail(final String supportEmail) {
      this.supportEmail = supportEmail;
    }

    /**
     * A publicly available phone number to call with support issues.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSupportPhone(final String supportPhone) {
      this.supportPhone = supportPhone;
    }

    /**
     * A publicly available website for handling support issues.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSupportUrl(final String supportUrl) {
      this.supportUrl = supportUrl;
    }

    /**
     * The business's publicly available website.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUrl(final String url) {
      this.url = url;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.BusinessProfile)) return false;
      final Account.BusinessProfile other = (Account.BusinessProfile) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$mcc = this.getMcc();
      final java.lang.Object other$mcc = other.getMcc();
      if (this$mcc == null ? other$mcc != null : !this$mcc.equals(other$mcc)) return false;
      final java.lang.Object this$name = this.getName();
      final java.lang.Object other$name = other.getName();
      if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
      final java.lang.Object this$productDescription = this.getProductDescription();
      final java.lang.Object other$productDescription = other.getProductDescription();
      if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) return false;
      final java.lang.Object this$supportAddress = this.getSupportAddress();
      final java.lang.Object other$supportAddress = other.getSupportAddress();
      if (this$supportAddress == null ? other$supportAddress != null : !this$supportAddress.equals(other$supportAddress)) return false;
      final java.lang.Object this$supportEmail = this.getSupportEmail();
      final java.lang.Object other$supportEmail = other.getSupportEmail();
      if (this$supportEmail == null ? other$supportEmail != null : !this$supportEmail.equals(other$supportEmail)) return false;
      final java.lang.Object this$supportPhone = this.getSupportPhone();
      final java.lang.Object other$supportPhone = other.getSupportPhone();
      if (this$supportPhone == null ? other$supportPhone != null : !this$supportPhone.equals(other$supportPhone)) return false;
      final java.lang.Object this$supportUrl = this.getSupportUrl();
      final java.lang.Object other$supportUrl = other.getSupportUrl();
      if (this$supportUrl == null ? other$supportUrl != null : !this$supportUrl.equals(other$supportUrl)) return false;
      final java.lang.Object this$url = this.getUrl();
      final java.lang.Object other$url = other.getUrl();
      if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.BusinessProfile;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $mcc = this.getMcc();
      result = result * PRIME + ($mcc == null ? 43 : $mcc.hashCode());
      final java.lang.Object $name = this.getName();
      result = result * PRIME + ($name == null ? 43 : $name.hashCode());
      final java.lang.Object $productDescription = this.getProductDescription();
      result = result * PRIME + ($productDescription == null ? 43 : $productDescription.hashCode());
      final java.lang.Object $supportAddress = this.getSupportAddress();
      result = result * PRIME + ($supportAddress == null ? 43 : $supportAddress.hashCode());
      final java.lang.Object $supportEmail = this.getSupportEmail();
      result = result * PRIME + ($supportEmail == null ? 43 : $supportEmail.hashCode());
      final java.lang.Object $supportPhone = this.getSupportPhone();
      result = result * PRIME + ($supportPhone == null ? 43 : $supportPhone.hashCode());
      final java.lang.Object $supportUrl = this.getSupportUrl();
      result = result * PRIME + ($supportUrl == null ? 43 : $supportUrl.hashCode());
      final java.lang.Object $url = this.getUrl();
      result = result * PRIME + ($url == null ? 43 : $url.hashCode());
      return result;
    }
  }


  public static class Capabilities extends StripeObject {
    /**
     * The status of the Canadian pre-authorized debits payments capability of the account, or
     * whether the account can directly process Canadian pre-authorized debits charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("acss_debit_payments")
    String acssDebitPayments;
    /**
     * The status of the Affirm capability of the account, or whether the account can directly
     * process Affirm charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("affirm_payments")
    String affirmPayments;
    /**
     * The status of the Afterpay Clearpay capability of the account, or whether the account can
     * directly process Afterpay Clearpay charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("afterpay_clearpay_payments")
    String afterpayClearpayPayments;
    /**
     * The status of the BECS Direct Debit (AU) payments capability of the account, or whether the
     * account can directly process BECS Direct Debit (AU) charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("au_becs_debit_payments")
    String auBecsDebitPayments;
    /**
     * The status of the Bacs Direct Debits payments capability of the account, or whether the
     * account can directly process Bacs Direct Debits charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("bacs_debit_payments")
    String bacsDebitPayments;
    /**
     * The status of the Bancontact payments capability of the account, or whether the account can
     * directly process Bancontact charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("bancontact_payments")
    String bancontactPayments;
    /**
     * The status of the customer_balance payments capability of the account, or whether the account
     * can directly process customer_balance charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("bank_transfer_payments")
    String bankTransferPayments;
    /**
     * The status of the blik payments capability of the account, or whether the account can
     * directly process blik charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("blik_payments")
    String blikPayments;
    /**
     * The status of the boleto payments capability of the account, or whether the account can
     * directly process boleto charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("boleto_payments")
    String boletoPayments;
    /**
     * The status of the card issuing capability of the account, or whether you can use Issuing to
     * distribute funds on cards
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("card_issuing")
    String cardIssuing;
    /**
     * The status of the card payments capability of the account, or whether the account can
     * directly process credit and debit card charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("card_payments")
    String cardPayments;
    /**
     * The status of the Cartes Bancaires payments capability of the account, or whether the account
     * can directly process Cartes Bancaires card charges in EUR currency.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("cartes_bancaires_payments")
    String cartesBancairesPayments;
    /**
     * The status of the EPS payments capability of the account, or whether the account can directly
     * process EPS charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("eps_payments")
    String epsPayments;
    /**
     * The status of the FPX payments capability of the account, or whether the account can directly
     * process FPX charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("fpx_payments")
    String fpxPayments;
    /**
     * The status of the giropay payments capability of the account, or whether the account can
     * directly process giropay charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("giropay_payments")
    String giropayPayments;
    /**
     * The status of the GrabPay payments capability of the account, or whether the account can
     * directly process GrabPay charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("grabpay_payments")
    String grabpayPayments;
    /**
     * The status of the iDEAL payments capability of the account, or whether the account can
     * directly process iDEAL charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("ideal_payments")
    String idealPayments;
    /**
     * The status of the JCB payments capability of the account, or whether the account (Japan only)
     * can directly process JCB credit card charges in JPY currency.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("jcb_payments")
    String jcbPayments;
    /**
     * The status of the Klarna payments capability of the account, or whether the account can
     * directly process Klarna charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("klarna_payments")
    String klarnaPayments;
    /**
     * The status of the konbini payments capability of the account, or whether the account can
     * directly process konbini charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("konbini_payments")
    String konbiniPayments;
    /**
     * The status of the legacy payments capability of the account.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("legacy_payments")
    String legacyPayments;
    /**
     * The status of the link_payments capability of the account, or whether the account can
     * directly process Link charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("link_payments")
    String linkPayments;
    /**
     * The status of the OXXO payments capability of the account, or whether the account can
     * directly process OXXO charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("oxxo_payments")
    String oxxoPayments;
    /**
     * The status of the P24 payments capability of the account, or whether the account can directly
     * process P24 charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("p24_payments")
    String p24Payments;
    /**
     * The status of the paynow payments capability of the account, or whether the account can
     * directly process paynow charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("paynow_payments")
    String paynowPayments;
    /**
     * The status of the promptpay payments capability of the account, or whether the account can
     * directly process promptpay charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("promptpay_payments")
    String promptpayPayments;
    /**
     * The status of the SEPA Direct Debits payments capability of the account, or whether the
     * account can directly process SEPA Direct Debits charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("sepa_debit_payments")
    String sepaDebitPayments;
    /**
     * The status of the Sofort payments capability of the account, or whether the account can
     * directly process Sofort charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("sofort_payments")
    String sofortPayments;
    /**
     * The status of the tax reporting 1099-K (US) capability of the account.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("tax_reporting_us_1099_k")
    String taxReportingUs1099K;
    /**
     * The status of the tax reporting 1099-MISC (US) capability of the account.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("tax_reporting_us_1099_misc")
    String taxReportingUs1099Misc;
    /**
     * The status of the transfers capability of the account, or whether your platform can transfer
     * funds to the account.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("transfers")
    String transfers;
    /**
     * The status of the banking capability, or whether the account can have bank accounts.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("treasury")
    String treasury;
    /**
     * The status of the US bank account ACH payments capability of the account, or whether the
     * account can directly process US bank account charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @SerializedName("us_bank_account_ach_payments")
    String usBankAccountAchPayments;

    /**
     * The status of the Canadian pre-authorized debits payments capability of the account, or
     * whether the account can directly process Canadian pre-authorized debits charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAcssDebitPayments() {
      return this.acssDebitPayments;
    }

    /**
     * The status of the Affirm capability of the account, or whether the account can directly
     * process Affirm charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAffirmPayments() {
      return this.affirmPayments;
    }

    /**
     * The status of the Afterpay Clearpay capability of the account, or whether the account can
     * directly process Afterpay Clearpay charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAfterpayClearpayPayments() {
      return this.afterpayClearpayPayments;
    }

    /**
     * The status of the BECS Direct Debit (AU) payments capability of the account, or whether the
     * account can directly process BECS Direct Debit (AU) charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAuBecsDebitPayments() {
      return this.auBecsDebitPayments;
    }

    /**
     * The status of the Bacs Direct Debits payments capability of the account, or whether the
     * account can directly process Bacs Direct Debits charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBacsDebitPayments() {
      return this.bacsDebitPayments;
    }

    /**
     * The status of the Bancontact payments capability of the account, or whether the account can
     * directly process Bancontact charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBancontactPayments() {
      return this.bancontactPayments;
    }

    /**
     * The status of the customer_balance payments capability of the account, or whether the account
     * can directly process customer_balance charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBankTransferPayments() {
      return this.bankTransferPayments;
    }

    /**
     * The status of the blik payments capability of the account, or whether the account can
     * directly process blik charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBlikPayments() {
      return this.blikPayments;
    }

    /**
     * The status of the boleto payments capability of the account, or whether the account can
     * directly process boleto charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBoletoPayments() {
      return this.boletoPayments;
    }

    /**
     * The status of the card issuing capability of the account, or whether you can use Issuing to
     * distribute funds on cards
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCardIssuing() {
      return this.cardIssuing;
    }

    /**
     * The status of the card payments capability of the account, or whether the account can
     * directly process credit and debit card charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCardPayments() {
      return this.cardPayments;
    }

    /**
     * The status of the Cartes Bancaires payments capability of the account, or whether the account
     * can directly process Cartes Bancaires card charges in EUR currency.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCartesBancairesPayments() {
      return this.cartesBancairesPayments;
    }

    /**
     * The status of the EPS payments capability of the account, or whether the account can directly
     * process EPS charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEpsPayments() {
      return this.epsPayments;
    }

    /**
     * The status of the FPX payments capability of the account, or whether the account can directly
     * process FPX charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFpxPayments() {
      return this.fpxPayments;
    }

    /**
     * The status of the giropay payments capability of the account, or whether the account can
     * directly process giropay charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGiropayPayments() {
      return this.giropayPayments;
    }

    /**
     * The status of the GrabPay payments capability of the account, or whether the account can
     * directly process GrabPay charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGrabpayPayments() {
      return this.grabpayPayments;
    }

    /**
     * The status of the iDEAL payments capability of the account, or whether the account can
     * directly process iDEAL charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIdealPayments() {
      return this.idealPayments;
    }

    /**
     * The status of the JCB payments capability of the account, or whether the account (Japan only)
     * can directly process JCB credit card charges in JPY currency.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getJcbPayments() {
      return this.jcbPayments;
    }

    /**
     * The status of the Klarna payments capability of the account, or whether the account can
     * directly process Klarna charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getKlarnaPayments() {
      return this.klarnaPayments;
    }

    /**
     * The status of the konbini payments capability of the account, or whether the account can
     * directly process konbini charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getKonbiniPayments() {
      return this.konbiniPayments;
    }

    /**
     * The status of the legacy payments capability of the account.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLegacyPayments() {
      return this.legacyPayments;
    }

    /**
     * The status of the link_payments capability of the account, or whether the account can
     * directly process Link charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLinkPayments() {
      return this.linkPayments;
    }

    /**
     * The status of the OXXO payments capability of the account, or whether the account can
     * directly process OXXO charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getOxxoPayments() {
      return this.oxxoPayments;
    }

    /**
     * The status of the P24 payments capability of the account, or whether the account can directly
     * process P24 charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getP24Payments() {
      return this.p24Payments;
    }

    /**
     * The status of the paynow payments capability of the account, or whether the account can
     * directly process paynow charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPaynowPayments() {
      return this.paynowPayments;
    }

    /**
     * The status of the promptpay payments capability of the account, or whether the account can
     * directly process promptpay charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPromptpayPayments() {
      return this.promptpayPayments;
    }

    /**
     * The status of the SEPA Direct Debits payments capability of the account, or whether the
     * account can directly process SEPA Direct Debits charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSepaDebitPayments() {
      return this.sepaDebitPayments;
    }

    /**
     * The status of the Sofort payments capability of the account, or whether the account can
     * directly process Sofort charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSofortPayments() {
      return this.sofortPayments;
    }

    /**
     * The status of the tax reporting 1099-K (US) capability of the account.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTaxReportingUs1099K() {
      return this.taxReportingUs1099K;
    }

    /**
     * The status of the tax reporting 1099-MISC (US) capability of the account.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTaxReportingUs1099Misc() {
      return this.taxReportingUs1099Misc;
    }

    /**
     * The status of the transfers capability of the account, or whether your platform can transfer
     * funds to the account.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTransfers() {
      return this.transfers;
    }

    /**
     * The status of the banking capability, or whether the account can have bank accounts.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTreasury() {
      return this.treasury;
    }

    /**
     * The status of the US bank account ACH payments capability of the account, or whether the
     * account can directly process US bank account charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUsBankAccountAchPayments() {
      return this.usBankAccountAchPayments;
    }

    /**
     * The status of the Canadian pre-authorized debits payments capability of the account, or
     * whether the account can directly process Canadian pre-authorized debits charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAcssDebitPayments(final String acssDebitPayments) {
      this.acssDebitPayments = acssDebitPayments;
    }

    /**
     * The status of the Affirm capability of the account, or whether the account can directly
     * process Affirm charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAffirmPayments(final String affirmPayments) {
      this.affirmPayments = affirmPayments;
    }

    /**
     * The status of the Afterpay Clearpay capability of the account, or whether the account can
     * directly process Afterpay Clearpay charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAfterpayClearpayPayments(final String afterpayClearpayPayments) {
      this.afterpayClearpayPayments = afterpayClearpayPayments;
    }

    /**
     * The status of the BECS Direct Debit (AU) payments capability of the account, or whether the
     * account can directly process BECS Direct Debit (AU) charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAuBecsDebitPayments(final String auBecsDebitPayments) {
      this.auBecsDebitPayments = auBecsDebitPayments;
    }

    /**
     * The status of the Bacs Direct Debits payments capability of the account, or whether the
     * account can directly process Bacs Direct Debits charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBacsDebitPayments(final String bacsDebitPayments) {
      this.bacsDebitPayments = bacsDebitPayments;
    }

    /**
     * The status of the Bancontact payments capability of the account, or whether the account can
     * directly process Bancontact charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBancontactPayments(final String bancontactPayments) {
      this.bancontactPayments = bancontactPayments;
    }

    /**
     * The status of the customer_balance payments capability of the account, or whether the account
     * can directly process customer_balance charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBankTransferPayments(final String bankTransferPayments) {
      this.bankTransferPayments = bankTransferPayments;
    }

    /**
     * The status of the blik payments capability of the account, or whether the account can
     * directly process blik charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBlikPayments(final String blikPayments) {
      this.blikPayments = blikPayments;
    }

    /**
     * The status of the boleto payments capability of the account, or whether the account can
     * directly process boleto charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBoletoPayments(final String boletoPayments) {
      this.boletoPayments = boletoPayments;
    }

    /**
     * The status of the card issuing capability of the account, or whether you can use Issuing to
     * distribute funds on cards
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCardIssuing(final String cardIssuing) {
      this.cardIssuing = cardIssuing;
    }

    /**
     * The status of the card payments capability of the account, or whether the account can
     * directly process credit and debit card charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCardPayments(final String cardPayments) {
      this.cardPayments = cardPayments;
    }

    /**
     * The status of the Cartes Bancaires payments capability of the account, or whether the account
     * can directly process Cartes Bancaires card charges in EUR currency.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCartesBancairesPayments(final String cartesBancairesPayments) {
      this.cartesBancairesPayments = cartesBancairesPayments;
    }

    /**
     * The status of the EPS payments capability of the account, or whether the account can directly
     * process EPS charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEpsPayments(final String epsPayments) {
      this.epsPayments = epsPayments;
    }

    /**
     * The status of the FPX payments capability of the account, or whether the account can directly
     * process FPX charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFpxPayments(final String fpxPayments) {
      this.fpxPayments = fpxPayments;
    }

    /**
     * The status of the giropay payments capability of the account, or whether the account can
     * directly process giropay charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setGiropayPayments(final String giropayPayments) {
      this.giropayPayments = giropayPayments;
    }

    /**
     * The status of the GrabPay payments capability of the account, or whether the account can
     * directly process GrabPay charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setGrabpayPayments(final String grabpayPayments) {
      this.grabpayPayments = grabpayPayments;
    }

    /**
     * The status of the iDEAL payments capability of the account, or whether the account can
     * directly process iDEAL charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIdealPayments(final String idealPayments) {
      this.idealPayments = idealPayments;
    }

    /**
     * The status of the JCB payments capability of the account, or whether the account (Japan only)
     * can directly process JCB credit card charges in JPY currency.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setJcbPayments(final String jcbPayments) {
      this.jcbPayments = jcbPayments;
    }

    /**
     * The status of the Klarna payments capability of the account, or whether the account can
     * directly process Klarna charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setKlarnaPayments(final String klarnaPayments) {
      this.klarnaPayments = klarnaPayments;
    }

    /**
     * The status of the konbini payments capability of the account, or whether the account can
     * directly process konbini charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setKonbiniPayments(final String konbiniPayments) {
      this.konbiniPayments = konbiniPayments;
    }

    /**
     * The status of the legacy payments capability of the account.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLegacyPayments(final String legacyPayments) {
      this.legacyPayments = legacyPayments;
    }

    /**
     * The status of the link_payments capability of the account, or whether the account can
     * directly process Link charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLinkPayments(final String linkPayments) {
      this.linkPayments = linkPayments;
    }

    /**
     * The status of the OXXO payments capability of the account, or whether the account can
     * directly process OXXO charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOxxoPayments(final String oxxoPayments) {
      this.oxxoPayments = oxxoPayments;
    }

    /**
     * The status of the P24 payments capability of the account, or whether the account can directly
     * process P24 charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setP24Payments(final String p24Payments) {
      this.p24Payments = p24Payments;
    }

    /**
     * The status of the paynow payments capability of the account, or whether the account can
     * directly process paynow charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPaynowPayments(final String paynowPayments) {
      this.paynowPayments = paynowPayments;
    }

    /**
     * The status of the promptpay payments capability of the account, or whether the account can
     * directly process promptpay charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPromptpayPayments(final String promptpayPayments) {
      this.promptpayPayments = promptpayPayments;
    }

    /**
     * The status of the SEPA Direct Debits payments capability of the account, or whether the
     * account can directly process SEPA Direct Debits charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSepaDebitPayments(final String sepaDebitPayments) {
      this.sepaDebitPayments = sepaDebitPayments;
    }

    /**
     * The status of the Sofort payments capability of the account, or whether the account can
     * directly process Sofort charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSofortPayments(final String sofortPayments) {
      this.sofortPayments = sofortPayments;
    }

    /**
     * The status of the tax reporting 1099-K (US) capability of the account.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTaxReportingUs1099K(final String taxReportingUs1099K) {
      this.taxReportingUs1099K = taxReportingUs1099K;
    }

    /**
     * The status of the tax reporting 1099-MISC (US) capability of the account.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTaxReportingUs1099Misc(final String taxReportingUs1099Misc) {
      this.taxReportingUs1099Misc = taxReportingUs1099Misc;
    }

    /**
     * The status of the transfers capability of the account, or whether your platform can transfer
     * funds to the account.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTransfers(final String transfers) {
      this.transfers = transfers;
    }

    /**
     * The status of the banking capability, or whether the account can have bank accounts.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTreasury(final String treasury) {
      this.treasury = treasury;
    }

    /**
     * The status of the US bank account ACH payments capability of the account, or whether the
     * account can directly process US bank account charges.
     *
     * <p>One of {@code active}, {@code inactive}, or {@code pending}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUsBankAccountAchPayments(final String usBankAccountAchPayments) {
      this.usBankAccountAchPayments = usBankAccountAchPayments;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.Capabilities)) return false;
      final Account.Capabilities other = (Account.Capabilities) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$acssDebitPayments = this.getAcssDebitPayments();
      final java.lang.Object other$acssDebitPayments = other.getAcssDebitPayments();
      if (this$acssDebitPayments == null ? other$acssDebitPayments != null : !this$acssDebitPayments.equals(other$acssDebitPayments)) return false;
      final java.lang.Object this$affirmPayments = this.getAffirmPayments();
      final java.lang.Object other$affirmPayments = other.getAffirmPayments();
      if (this$affirmPayments == null ? other$affirmPayments != null : !this$affirmPayments.equals(other$affirmPayments)) return false;
      final java.lang.Object this$afterpayClearpayPayments = this.getAfterpayClearpayPayments();
      final java.lang.Object other$afterpayClearpayPayments = other.getAfterpayClearpayPayments();
      if (this$afterpayClearpayPayments == null ? other$afterpayClearpayPayments != null : !this$afterpayClearpayPayments.equals(other$afterpayClearpayPayments)) return false;
      final java.lang.Object this$auBecsDebitPayments = this.getAuBecsDebitPayments();
      final java.lang.Object other$auBecsDebitPayments = other.getAuBecsDebitPayments();
      if (this$auBecsDebitPayments == null ? other$auBecsDebitPayments != null : !this$auBecsDebitPayments.equals(other$auBecsDebitPayments)) return false;
      final java.lang.Object this$bacsDebitPayments = this.getBacsDebitPayments();
      final java.lang.Object other$bacsDebitPayments = other.getBacsDebitPayments();
      if (this$bacsDebitPayments == null ? other$bacsDebitPayments != null : !this$bacsDebitPayments.equals(other$bacsDebitPayments)) return false;
      final java.lang.Object this$bancontactPayments = this.getBancontactPayments();
      final java.lang.Object other$bancontactPayments = other.getBancontactPayments();
      if (this$bancontactPayments == null ? other$bancontactPayments != null : !this$bancontactPayments.equals(other$bancontactPayments)) return false;
      final java.lang.Object this$bankTransferPayments = this.getBankTransferPayments();
      final java.lang.Object other$bankTransferPayments = other.getBankTransferPayments();
      if (this$bankTransferPayments == null ? other$bankTransferPayments != null : !this$bankTransferPayments.equals(other$bankTransferPayments)) return false;
      final java.lang.Object this$blikPayments = this.getBlikPayments();
      final java.lang.Object other$blikPayments = other.getBlikPayments();
      if (this$blikPayments == null ? other$blikPayments != null : !this$blikPayments.equals(other$blikPayments)) return false;
      final java.lang.Object this$boletoPayments = this.getBoletoPayments();
      final java.lang.Object other$boletoPayments = other.getBoletoPayments();
      if (this$boletoPayments == null ? other$boletoPayments != null : !this$boletoPayments.equals(other$boletoPayments)) return false;
      final java.lang.Object this$cardIssuing = this.getCardIssuing();
      final java.lang.Object other$cardIssuing = other.getCardIssuing();
      if (this$cardIssuing == null ? other$cardIssuing != null : !this$cardIssuing.equals(other$cardIssuing)) return false;
      final java.lang.Object this$cardPayments = this.getCardPayments();
      final java.lang.Object other$cardPayments = other.getCardPayments();
      if (this$cardPayments == null ? other$cardPayments != null : !this$cardPayments.equals(other$cardPayments)) return false;
      final java.lang.Object this$cartesBancairesPayments = this.getCartesBancairesPayments();
      final java.lang.Object other$cartesBancairesPayments = other.getCartesBancairesPayments();
      if (this$cartesBancairesPayments == null ? other$cartesBancairesPayments != null : !this$cartesBancairesPayments.equals(other$cartesBancairesPayments)) return false;
      final java.lang.Object this$epsPayments = this.getEpsPayments();
      final java.lang.Object other$epsPayments = other.getEpsPayments();
      if (this$epsPayments == null ? other$epsPayments != null : !this$epsPayments.equals(other$epsPayments)) return false;
      final java.lang.Object this$fpxPayments = this.getFpxPayments();
      final java.lang.Object other$fpxPayments = other.getFpxPayments();
      if (this$fpxPayments == null ? other$fpxPayments != null : !this$fpxPayments.equals(other$fpxPayments)) return false;
      final java.lang.Object this$giropayPayments = this.getGiropayPayments();
      final java.lang.Object other$giropayPayments = other.getGiropayPayments();
      if (this$giropayPayments == null ? other$giropayPayments != null : !this$giropayPayments.equals(other$giropayPayments)) return false;
      final java.lang.Object this$grabpayPayments = this.getGrabpayPayments();
      final java.lang.Object other$grabpayPayments = other.getGrabpayPayments();
      if (this$grabpayPayments == null ? other$grabpayPayments != null : !this$grabpayPayments.equals(other$grabpayPayments)) return false;
      final java.lang.Object this$idealPayments = this.getIdealPayments();
      final java.lang.Object other$idealPayments = other.getIdealPayments();
      if (this$idealPayments == null ? other$idealPayments != null : !this$idealPayments.equals(other$idealPayments)) return false;
      final java.lang.Object this$jcbPayments = this.getJcbPayments();
      final java.lang.Object other$jcbPayments = other.getJcbPayments();
      if (this$jcbPayments == null ? other$jcbPayments != null : !this$jcbPayments.equals(other$jcbPayments)) return false;
      final java.lang.Object this$klarnaPayments = this.getKlarnaPayments();
      final java.lang.Object other$klarnaPayments = other.getKlarnaPayments();
      if (this$klarnaPayments == null ? other$klarnaPayments != null : !this$klarnaPayments.equals(other$klarnaPayments)) return false;
      final java.lang.Object this$konbiniPayments = this.getKonbiniPayments();
      final java.lang.Object other$konbiniPayments = other.getKonbiniPayments();
      if (this$konbiniPayments == null ? other$konbiniPayments != null : !this$konbiniPayments.equals(other$konbiniPayments)) return false;
      final java.lang.Object this$legacyPayments = this.getLegacyPayments();
      final java.lang.Object other$legacyPayments = other.getLegacyPayments();
      if (this$legacyPayments == null ? other$legacyPayments != null : !this$legacyPayments.equals(other$legacyPayments)) return false;
      final java.lang.Object this$linkPayments = this.getLinkPayments();
      final java.lang.Object other$linkPayments = other.getLinkPayments();
      if (this$linkPayments == null ? other$linkPayments != null : !this$linkPayments.equals(other$linkPayments)) return false;
      final java.lang.Object this$oxxoPayments = this.getOxxoPayments();
      final java.lang.Object other$oxxoPayments = other.getOxxoPayments();
      if (this$oxxoPayments == null ? other$oxxoPayments != null : !this$oxxoPayments.equals(other$oxxoPayments)) return false;
      final java.lang.Object this$p24Payments = this.getP24Payments();
      final java.lang.Object other$p24Payments = other.getP24Payments();
      if (this$p24Payments == null ? other$p24Payments != null : !this$p24Payments.equals(other$p24Payments)) return false;
      final java.lang.Object this$paynowPayments = this.getPaynowPayments();
      final java.lang.Object other$paynowPayments = other.getPaynowPayments();
      if (this$paynowPayments == null ? other$paynowPayments != null : !this$paynowPayments.equals(other$paynowPayments)) return false;
      final java.lang.Object this$promptpayPayments = this.getPromptpayPayments();
      final java.lang.Object other$promptpayPayments = other.getPromptpayPayments();
      if (this$promptpayPayments == null ? other$promptpayPayments != null : !this$promptpayPayments.equals(other$promptpayPayments)) return false;
      final java.lang.Object this$sepaDebitPayments = this.getSepaDebitPayments();
      final java.lang.Object other$sepaDebitPayments = other.getSepaDebitPayments();
      if (this$sepaDebitPayments == null ? other$sepaDebitPayments != null : !this$sepaDebitPayments.equals(other$sepaDebitPayments)) return false;
      final java.lang.Object this$sofortPayments = this.getSofortPayments();
      final java.lang.Object other$sofortPayments = other.getSofortPayments();
      if (this$sofortPayments == null ? other$sofortPayments != null : !this$sofortPayments.equals(other$sofortPayments)) return false;
      final java.lang.Object this$taxReportingUs1099K = this.getTaxReportingUs1099K();
      final java.lang.Object other$taxReportingUs1099K = other.getTaxReportingUs1099K();
      if (this$taxReportingUs1099K == null ? other$taxReportingUs1099K != null : !this$taxReportingUs1099K.equals(other$taxReportingUs1099K)) return false;
      final java.lang.Object this$taxReportingUs1099Misc = this.getTaxReportingUs1099Misc();
      final java.lang.Object other$taxReportingUs1099Misc = other.getTaxReportingUs1099Misc();
      if (this$taxReportingUs1099Misc == null ? other$taxReportingUs1099Misc != null : !this$taxReportingUs1099Misc.equals(other$taxReportingUs1099Misc)) return false;
      final java.lang.Object this$transfers = this.getTransfers();
      final java.lang.Object other$transfers = other.getTransfers();
      if (this$transfers == null ? other$transfers != null : !this$transfers.equals(other$transfers)) return false;
      final java.lang.Object this$treasury = this.getTreasury();
      final java.lang.Object other$treasury = other.getTreasury();
      if (this$treasury == null ? other$treasury != null : !this$treasury.equals(other$treasury)) return false;
      final java.lang.Object this$usBankAccountAchPayments = this.getUsBankAccountAchPayments();
      final java.lang.Object other$usBankAccountAchPayments = other.getUsBankAccountAchPayments();
      if (this$usBankAccountAchPayments == null ? other$usBankAccountAchPayments != null : !this$usBankAccountAchPayments.equals(other$usBankAccountAchPayments)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.Capabilities;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $acssDebitPayments = this.getAcssDebitPayments();
      result = result * PRIME + ($acssDebitPayments == null ? 43 : $acssDebitPayments.hashCode());
      final java.lang.Object $affirmPayments = this.getAffirmPayments();
      result = result * PRIME + ($affirmPayments == null ? 43 : $affirmPayments.hashCode());
      final java.lang.Object $afterpayClearpayPayments = this.getAfterpayClearpayPayments();
      result = result * PRIME + ($afterpayClearpayPayments == null ? 43 : $afterpayClearpayPayments.hashCode());
      final java.lang.Object $auBecsDebitPayments = this.getAuBecsDebitPayments();
      result = result * PRIME + ($auBecsDebitPayments == null ? 43 : $auBecsDebitPayments.hashCode());
      final java.lang.Object $bacsDebitPayments = this.getBacsDebitPayments();
      result = result * PRIME + ($bacsDebitPayments == null ? 43 : $bacsDebitPayments.hashCode());
      final java.lang.Object $bancontactPayments = this.getBancontactPayments();
      result = result * PRIME + ($bancontactPayments == null ? 43 : $bancontactPayments.hashCode());
      final java.lang.Object $bankTransferPayments = this.getBankTransferPayments();
      result = result * PRIME + ($bankTransferPayments == null ? 43 : $bankTransferPayments.hashCode());
      final java.lang.Object $blikPayments = this.getBlikPayments();
      result = result * PRIME + ($blikPayments == null ? 43 : $blikPayments.hashCode());
      final java.lang.Object $boletoPayments = this.getBoletoPayments();
      result = result * PRIME + ($boletoPayments == null ? 43 : $boletoPayments.hashCode());
      final java.lang.Object $cardIssuing = this.getCardIssuing();
      result = result * PRIME + ($cardIssuing == null ? 43 : $cardIssuing.hashCode());
      final java.lang.Object $cardPayments = this.getCardPayments();
      result = result * PRIME + ($cardPayments == null ? 43 : $cardPayments.hashCode());
      final java.lang.Object $cartesBancairesPayments = this.getCartesBancairesPayments();
      result = result * PRIME + ($cartesBancairesPayments == null ? 43 : $cartesBancairesPayments.hashCode());
      final java.lang.Object $epsPayments = this.getEpsPayments();
      result = result * PRIME + ($epsPayments == null ? 43 : $epsPayments.hashCode());
      final java.lang.Object $fpxPayments = this.getFpxPayments();
      result = result * PRIME + ($fpxPayments == null ? 43 : $fpxPayments.hashCode());
      final java.lang.Object $giropayPayments = this.getGiropayPayments();
      result = result * PRIME + ($giropayPayments == null ? 43 : $giropayPayments.hashCode());
      final java.lang.Object $grabpayPayments = this.getGrabpayPayments();
      result = result * PRIME + ($grabpayPayments == null ? 43 : $grabpayPayments.hashCode());
      final java.lang.Object $idealPayments = this.getIdealPayments();
      result = result * PRIME + ($idealPayments == null ? 43 : $idealPayments.hashCode());
      final java.lang.Object $jcbPayments = this.getJcbPayments();
      result = result * PRIME + ($jcbPayments == null ? 43 : $jcbPayments.hashCode());
      final java.lang.Object $klarnaPayments = this.getKlarnaPayments();
      result = result * PRIME + ($klarnaPayments == null ? 43 : $klarnaPayments.hashCode());
      final java.lang.Object $konbiniPayments = this.getKonbiniPayments();
      result = result * PRIME + ($konbiniPayments == null ? 43 : $konbiniPayments.hashCode());
      final java.lang.Object $legacyPayments = this.getLegacyPayments();
      result = result * PRIME + ($legacyPayments == null ? 43 : $legacyPayments.hashCode());
      final java.lang.Object $linkPayments = this.getLinkPayments();
      result = result * PRIME + ($linkPayments == null ? 43 : $linkPayments.hashCode());
      final java.lang.Object $oxxoPayments = this.getOxxoPayments();
      result = result * PRIME + ($oxxoPayments == null ? 43 : $oxxoPayments.hashCode());
      final java.lang.Object $p24Payments = this.getP24Payments();
      result = result * PRIME + ($p24Payments == null ? 43 : $p24Payments.hashCode());
      final java.lang.Object $paynowPayments = this.getPaynowPayments();
      result = result * PRIME + ($paynowPayments == null ? 43 : $paynowPayments.hashCode());
      final java.lang.Object $promptpayPayments = this.getPromptpayPayments();
      result = result * PRIME + ($promptpayPayments == null ? 43 : $promptpayPayments.hashCode());
      final java.lang.Object $sepaDebitPayments = this.getSepaDebitPayments();
      result = result * PRIME + ($sepaDebitPayments == null ? 43 : $sepaDebitPayments.hashCode());
      final java.lang.Object $sofortPayments = this.getSofortPayments();
      result = result * PRIME + ($sofortPayments == null ? 43 : $sofortPayments.hashCode());
      final java.lang.Object $taxReportingUs1099K = this.getTaxReportingUs1099K();
      result = result * PRIME + ($taxReportingUs1099K == null ? 43 : $taxReportingUs1099K.hashCode());
      final java.lang.Object $taxReportingUs1099Misc = this.getTaxReportingUs1099Misc();
      result = result * PRIME + ($taxReportingUs1099Misc == null ? 43 : $taxReportingUs1099Misc.hashCode());
      final java.lang.Object $transfers = this.getTransfers();
      result = result * PRIME + ($transfers == null ? 43 : $transfers.hashCode());
      final java.lang.Object $treasury = this.getTreasury();
      result = result * PRIME + ($treasury == null ? 43 : $treasury.hashCode());
      final java.lang.Object $usBankAccountAchPayments = this.getUsBankAccountAchPayments();
      result = result * PRIME + ($usBankAccountAchPayments == null ? 43 : $usBankAccountAchPayments.hashCode());
      return result;
    }
  }


  public static class Company extends StripeObject {
    @SerializedName("address")
    Address address;
    /**
     * The Kana variation of the company's primary address (Japan only).
     */
    @SerializedName("address_kana")
    Person.JapanAddress addressKana;
    /**
     * The Kanji variation of the company's primary address (Japan only).
     */
    @SerializedName("address_kanji")
    Person.JapanAddress addressKanji;
    /**
     * Whether the company's directors have been provided. This Boolean will be {@code true} if
     * you've manually indicated that all directors are provided via <a
     * href="https://stripe.com/docs/api/accounts/update#update_account-company-directors_provided">the
     * {@code directors_provided} parameter</a>.
     */
    @SerializedName("directors_provided")
    Boolean directorsProvided;
    /**
     * Whether the company's executives have been provided. This Boolean will be {@code true} if
     * you've manually indicated that all executives are provided via <a
     * href="https://stripe.com/docs/api/accounts/update#update_account-company-executives_provided">the
     * {@code executives_provided} parameter</a>, or if Stripe determined that sufficient executives
     * were provided.
     */
    @SerializedName("executives_provided")
    Boolean executivesProvided;
    /**
     * The company's legal name.
     */
    @SerializedName("name")
    String name;
    /**
     * The Kana variation of the company's legal name (Japan only).
     */
    @SerializedName("name_kana")
    String nameKana;
    /**
     * The Kanji variation of the company's legal name (Japan only).
     */
    @SerializedName("name_kanji")
    String nameKanji;
    /**
     * Whether the company's owners have been provided. This Boolean will be {@code true} if you've
     * manually indicated that all owners are provided via <a
     * href="https://stripe.com/docs/api/accounts/update#update_account-company-owners_provided">the
     * {@code owners_provided} parameter</a>, or if Stripe determined that sufficient owners were
     * provided. Stripe determines ownership requirements using both the number of owners provided
     * and their total percent ownership (calculated by adding the {@code percent_ownership} of each
     * owner together).
     */
    @SerializedName("owners_provided")
    Boolean ownersProvided;
    /**
     * This hash is used to attest that the beneficial owner information provided to Stripe is both
     * current and correct.
     */
    @SerializedName("ownership_declaration")
    OwnershipDeclaration ownershipDeclaration;
    /**
     * The company's phone number (used for verification).
     */
    @SerializedName("phone")
    String phone;
    /**
     * The category identifying the legal structure of the company or legal entity. See <a
     * href="https://stripe.com/docs/connect/identity-verification#business-structure">Business
     * structure</a> for more details.
     *
     * <p>One of {@code free_zone_establishment}, {@code free_zone_llc}, {@code
     * government_instrumentality}, {@code governmental_unit}, {@code incorporated_non_profit},
     * {@code limited_liability_partnership}, {@code llc}, {@code multi_member_llc}, {@code
     * private_company}, {@code private_corporation}, {@code private_partnership}, {@code
     * public_company}, {@code public_corporation}, {@code public_partnership}, {@code
     * single_member_llc}, {@code sole_establishment}, {@code sole_proprietorship}, {@code
     * tax_exempt_government_instrumentality}, {@code unincorporated_association}, or {@code
     * unincorporated_non_profit}.
     */
    @SerializedName("structure")
    String structure;
    /**
     * Whether the company's business ID number was provided.
     */
    @SerializedName("tax_id_provided")
    Boolean taxIdProvided;
    /**
     * The jurisdiction in which the {@code tax_id} is registered (Germany-based companies only).
     */
    @SerializedName("tax_id_registrar")
    String taxIdRegistrar;
    /**
     * Whether the company's business VAT number was provided.
     */
    @SerializedName("vat_id_provided")
    Boolean vatIdProvided;
    /**
     * Information on the verification state of the company.
     */
    @SerializedName("verification")
    Verification verification;


    public static class OwnershipDeclaration extends StripeObject {
      /**
       * The Unix timestamp marking when the beneficial owner attestation was made.
       */
      @SerializedName("date")
      Long date;
      /**
       * The IP address from which the beneficial owner attestation was made.
       */
      @SerializedName("ip")
      String ip;
      /**
       * The user-agent string from the browser where the beneficial owner attestation was made.
       */
      @SerializedName("user_agent")
      String userAgent;

      /**
       * The Unix timestamp marking when the beneficial owner attestation was made.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getDate() {
        return this.date;
      }

      /**
       * The IP address from which the beneficial owner attestation was made.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getIp() {
        return this.ip;
      }

      /**
       * The user-agent string from the browser where the beneficial owner attestation was made.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getUserAgent() {
        return this.userAgent;
      }

      /**
       * The Unix timestamp marking when the beneficial owner attestation was made.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDate(final Long date) {
        this.date = date;
      }

      /**
       * The IP address from which the beneficial owner attestation was made.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setIp(final String ip) {
        this.ip = ip;
      }

      /**
       * The user-agent string from the browser where the beneficial owner attestation was made.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setUserAgent(final String userAgent) {
        this.userAgent = userAgent;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Account.Company.OwnershipDeclaration)) return false;
        final Account.Company.OwnershipDeclaration other = (Account.Company.OwnershipDeclaration) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$date = this.getDate();
        final java.lang.Object other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) return false;
        final java.lang.Object this$ip = this.getIp();
        final java.lang.Object other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) return false;
        final java.lang.Object this$userAgent = this.getUserAgent();
        final java.lang.Object other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Account.Company.OwnershipDeclaration;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $date = this.getDate();
        result = result * PRIME + ($date == null ? 43 : $date.hashCode());
        final java.lang.Object $ip = this.getIp();
        result = result * PRIME + ($ip == null ? 43 : $ip.hashCode());
        final java.lang.Object $userAgent = this.getUserAgent();
        result = result * PRIME + ($userAgent == null ? 43 : $userAgent.hashCode());
        return result;
      }
    }


    public static class Verification extends StripeObject {
      @SerializedName("document")
      VerificationDocument document;


      public static class VerificationDocument extends StripeObject {
        /**
         * The back of a document returned by a <a
         * href="https://stripe.com/docs/api#create_file">file upload</a> with a {@code purpose}
         * value of {@code additional_verification}.
         */
        @SerializedName("back")
        ExpandableField<File> back;
        /** A user-displayable string describing the verification state of this document. */
        @SerializedName("details")
        String details;
        /**
         * One of {@code document_corrupt}, {@code document_expired}, {@code document_failed_copy},
         * {@code document_failed_greyscale}, {@code document_failed_other}, {@code
         * document_failed_test_mode}, {@code document_fraudulent}, {@code document_incomplete},
         * {@code document_invalid}, {@code document_manipulated}, {@code document_not_readable},
         * {@code document_not_uploaded}, {@code document_type_not_supported}, or {@code
         * document_too_large}. A machine-readable code specifying the verification state for this
         * document.
         */
        @SerializedName("details_code")
        String detailsCode;
        /**
         * The front of a document returned by a <a
         * href="https://stripe.com/docs/api#create_file">file upload</a> with a {@code purpose}
         * value of {@code additional_verification}.
         */
        @SerializedName("front")
        ExpandableField<File> front;

        /** Get ID of expandable {@code back} object. */
        public String getBack() {
          return (this.back != null) ? this.back.getId() : null;
        }

        public void setBack(String id) {
          this.back = ApiResource.setExpandableFieldId(id, this.back);
        }

        /** Get expanded {@code back}. */
        public File getBackObject() {
          return (this.back != null) ? this.back.getExpanded() : null;
        }

        public void setBackObject(File expandableObject) {
          this.back = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        /** Get ID of expandable {@code front} object. */
        public String getFront() {
          return (this.front != null) ? this.front.getId() : null;
        }

        public void setFront(String id) {
          this.front = ApiResource.setExpandableFieldId(id, this.front);
        }

        public File getFrontObject() {
          return (this.front != null) ? this.front.getExpanded() : null;
        }

        public void setFrontObject(File expandableObject) {
          this.front = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDetails() {
          return this.details;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDetailsCode() {
          return this.detailsCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setDetails(final String details) {
          this.details = details;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setDetailsCode(final String detailsCode) {
          this.detailsCode = detailsCode;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Account.Company.Verification.VerificationDocument)) return false;
          final Account.Company.Verification.VerificationDocument other = (Account.Company.Verification.VerificationDocument) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$back = this.getBack();
          final java.lang.Object other$back = other.getBack();
          if (this$back == null ? other$back != null : !this$back.equals(other$back)) return false;
          final java.lang.Object this$details = this.getDetails();
          final java.lang.Object other$details = other.getDetails();
          if (this$details == null ? other$details != null : !this$details.equals(other$details)) return false;
          final java.lang.Object this$detailsCode = this.getDetailsCode();
          final java.lang.Object other$detailsCode = other.getDetailsCode();
          if (this$detailsCode == null ? other$detailsCode != null : !this$detailsCode.equals(other$detailsCode)) return false;
          final java.lang.Object this$front = this.getFront();
          final java.lang.Object other$front = other.getFront();
          if (this$front == null ? other$front != null : !this$front.equals(other$front)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Account.Company.Verification.VerificationDocument;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $back = this.getBack();
          result = result * PRIME + ($back == null ? 43 : $back.hashCode());
          final java.lang.Object $details = this.getDetails();
          result = result * PRIME + ($details == null ? 43 : $details.hashCode());
          final java.lang.Object $detailsCode = this.getDetailsCode();
          result = result * PRIME + ($detailsCode == null ? 43 : $detailsCode.hashCode());
          final java.lang.Object $front = this.getFront();
          result = result * PRIME + ($front == null ? 43 : $front.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public VerificationDocument getDocument() {
        return this.document;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDocument(final VerificationDocument document) {
        this.document = document;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Account.Company.Verification)) return false;
        final Account.Company.Verification other = (Account.Company.Verification) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$document = this.getDocument();
        final java.lang.Object other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Account.Company.Verification;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $document = this.getDocument();
        result = result * PRIME + ($document == null ? 43 : $document.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Address getAddress() {
      return this.address;
    }

    /**
     * The Kana variation of the company's primary address (Japan only).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Person.JapanAddress getAddressKana() {
      return this.addressKana;
    }

    /**
     * The Kanji variation of the company's primary address (Japan only).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Person.JapanAddress getAddressKanji() {
      return this.addressKanji;
    }

    /**
     * Whether the company's directors have been provided. This Boolean will be {@code true} if
     * you've manually indicated that all directors are provided via <a
     * href="https://stripe.com/docs/api/accounts/update#update_account-company-directors_provided">the
     * {@code directors_provided} parameter</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getDirectorsProvided() {
      return this.directorsProvided;
    }

    /**
     * Whether the company's executives have been provided. This Boolean will be {@code true} if
     * you've manually indicated that all executives are provided via <a
     * href="https://stripe.com/docs/api/accounts/update#update_account-company-executives_provided">the
     * {@code executives_provided} parameter</a>, or if Stripe determined that sufficient executives
     * were provided.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getExecutivesProvided() {
      return this.executivesProvided;
    }

    /**
     * The company's legal name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    /**
     * The Kana variation of the company's legal name (Japan only).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNameKana() {
      return this.nameKana;
    }

    /**
     * The Kanji variation of the company's legal name (Japan only).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNameKanji() {
      return this.nameKanji;
    }

    /**
     * Whether the company's owners have been provided. This Boolean will be {@code true} if you've
     * manually indicated that all owners are provided via <a
     * href="https://stripe.com/docs/api/accounts/update#update_account-company-owners_provided">the
     * {@code owners_provided} parameter</a>, or if Stripe determined that sufficient owners were
     * provided. Stripe determines ownership requirements using both the number of owners provided
     * and their total percent ownership (calculated by adding the {@code percent_ownership} of each
     * owner together).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getOwnersProvided() {
      return this.ownersProvided;
    }

    /**
     * This hash is used to attest that the beneficial owner information provided to Stripe is both
     * current and correct.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public OwnershipDeclaration getOwnershipDeclaration() {
      return this.ownershipDeclaration;
    }

    /**
     * The company's phone number (used for verification).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPhone() {
      return this.phone;
    }

    /**
     * The category identifying the legal structure of the company or legal entity. See <a
     * href="https://stripe.com/docs/connect/identity-verification#business-structure">Business
     * structure</a> for more details.
     *
     * <p>One of {@code free_zone_establishment}, {@code free_zone_llc}, {@code
     * government_instrumentality}, {@code governmental_unit}, {@code incorporated_non_profit},
     * {@code limited_liability_partnership}, {@code llc}, {@code multi_member_llc}, {@code
     * private_company}, {@code private_corporation}, {@code private_partnership}, {@code
     * public_company}, {@code public_corporation}, {@code public_partnership}, {@code
     * single_member_llc}, {@code sole_establishment}, {@code sole_proprietorship}, {@code
     * tax_exempt_government_instrumentality}, {@code unincorporated_association}, or {@code
     * unincorporated_non_profit}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStructure() {
      return this.structure;
    }

    /**
     * Whether the company's business ID number was provided.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getTaxIdProvided() {
      return this.taxIdProvided;
    }

    /**
     * The jurisdiction in which the {@code tax_id} is registered (Germany-based companies only).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTaxIdRegistrar() {
      return this.taxIdRegistrar;
    }

    /**
     * Whether the company's business VAT number was provided.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getVatIdProvided() {
      return this.vatIdProvided;
    }

    /**
     * Information on the verification state of the company.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Verification getVerification() {
      return this.verification;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddress(final Address address) {
      this.address = address;
    }

    /**
     * The Kana variation of the company's primary address (Japan only).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddressKana(final Person.JapanAddress addressKana) {
      this.addressKana = addressKana;
    }

    /**
     * The Kanji variation of the company's primary address (Japan only).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddressKanji(final Person.JapanAddress addressKanji) {
      this.addressKanji = addressKanji;
    }

    /**
     * Whether the company's directors have been provided. This Boolean will be {@code true} if
     * you've manually indicated that all directors are provided via <a
     * href="https://stripe.com/docs/api/accounts/update#update_account-company-directors_provided">the
     * {@code directors_provided} parameter</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDirectorsProvided(final Boolean directorsProvided) {
      this.directorsProvided = directorsProvided;
    }

    /**
     * Whether the company's executives have been provided. This Boolean will be {@code true} if
     * you've manually indicated that all executives are provided via <a
     * href="https://stripe.com/docs/api/accounts/update#update_account-company-executives_provided">the
     * {@code executives_provided} parameter</a>, or if Stripe determined that sufficient executives
     * were provided.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExecutivesProvided(final Boolean executivesProvided) {
      this.executivesProvided = executivesProvided;
    }

    /**
     * The company's legal name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
      this.name = name;
    }

    /**
     * The Kana variation of the company's legal name (Japan only).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNameKana(final String nameKana) {
      this.nameKana = nameKana;
    }

    /**
     * The Kanji variation of the company's legal name (Japan only).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setNameKanji(final String nameKanji) {
      this.nameKanji = nameKanji;
    }

    /**
     * Whether the company's owners have been provided. This Boolean will be {@code true} if you've
     * manually indicated that all owners are provided via <a
     * href="https://stripe.com/docs/api/accounts/update#update_account-company-owners_provided">the
     * {@code owners_provided} parameter</a>, or if Stripe determined that sufficient owners were
     * provided. Stripe determines ownership requirements using both the number of owners provided
     * and their total percent ownership (calculated by adding the {@code percent_ownership} of each
     * owner together).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOwnersProvided(final Boolean ownersProvided) {
      this.ownersProvided = ownersProvided;
    }

    /**
     * This hash is used to attest that the beneficial owner information provided to Stripe is both
     * current and correct.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOwnershipDeclaration(final OwnershipDeclaration ownershipDeclaration) {
      this.ownershipDeclaration = ownershipDeclaration;
    }

    /**
     * The company's phone number (used for verification).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPhone(final String phone) {
      this.phone = phone;
    }

    /**
     * The category identifying the legal structure of the company or legal entity. See <a
     * href="https://stripe.com/docs/connect/identity-verification#business-structure">Business
     * structure</a> for more details.
     *
     * <p>One of {@code free_zone_establishment}, {@code free_zone_llc}, {@code
     * government_instrumentality}, {@code governmental_unit}, {@code incorporated_non_profit},
     * {@code limited_liability_partnership}, {@code llc}, {@code multi_member_llc}, {@code
     * private_company}, {@code private_corporation}, {@code private_partnership}, {@code
     * public_company}, {@code public_corporation}, {@code public_partnership}, {@code
     * single_member_llc}, {@code sole_establishment}, {@code sole_proprietorship}, {@code
     * tax_exempt_government_instrumentality}, {@code unincorporated_association}, or {@code
     * unincorporated_non_profit}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStructure(final String structure) {
      this.structure = structure;
    }

    /**
     * Whether the company's business ID number was provided.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTaxIdProvided(final Boolean taxIdProvided) {
      this.taxIdProvided = taxIdProvided;
    }

    /**
     * The jurisdiction in which the {@code tax_id} is registered (Germany-based companies only).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTaxIdRegistrar(final String taxIdRegistrar) {
      this.taxIdRegistrar = taxIdRegistrar;
    }

    /**
     * Whether the company's business VAT number was provided.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVatIdProvided(final Boolean vatIdProvided) {
      this.vatIdProvided = vatIdProvided;
    }

    /**
     * Information on the verification state of the company.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVerification(final Verification verification) {
      this.verification = verification;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.Company)) return false;
      final Account.Company other = (Account.Company) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$directorsProvided = this.getDirectorsProvided();
      final java.lang.Object other$directorsProvided = other.getDirectorsProvided();
      if (this$directorsProvided == null ? other$directorsProvided != null : !this$directorsProvided.equals(other$directorsProvided)) return false;
      final java.lang.Object this$executivesProvided = this.getExecutivesProvided();
      final java.lang.Object other$executivesProvided = other.getExecutivesProvided();
      if (this$executivesProvided == null ? other$executivesProvided != null : !this$executivesProvided.equals(other$executivesProvided)) return false;
      final java.lang.Object this$ownersProvided = this.getOwnersProvided();
      final java.lang.Object other$ownersProvided = other.getOwnersProvided();
      if (this$ownersProvided == null ? other$ownersProvided != null : !this$ownersProvided.equals(other$ownersProvided)) return false;
      final java.lang.Object this$taxIdProvided = this.getTaxIdProvided();
      final java.lang.Object other$taxIdProvided = other.getTaxIdProvided();
      if (this$taxIdProvided == null ? other$taxIdProvided != null : !this$taxIdProvided.equals(other$taxIdProvided)) return false;
      final java.lang.Object this$vatIdProvided = this.getVatIdProvided();
      final java.lang.Object other$vatIdProvided = other.getVatIdProvided();
      if (this$vatIdProvided == null ? other$vatIdProvided != null : !this$vatIdProvided.equals(other$vatIdProvided)) return false;
      final java.lang.Object this$address = this.getAddress();
      final java.lang.Object other$address = other.getAddress();
      if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
      final java.lang.Object this$addressKana = this.getAddressKana();
      final java.lang.Object other$addressKana = other.getAddressKana();
      if (this$addressKana == null ? other$addressKana != null : !this$addressKana.equals(other$addressKana)) return false;
      final java.lang.Object this$addressKanji = this.getAddressKanji();
      final java.lang.Object other$addressKanji = other.getAddressKanji();
      if (this$addressKanji == null ? other$addressKanji != null : !this$addressKanji.equals(other$addressKanji)) return false;
      final java.lang.Object this$name = this.getName();
      final java.lang.Object other$name = other.getName();
      if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
      final java.lang.Object this$nameKana = this.getNameKana();
      final java.lang.Object other$nameKana = other.getNameKana();
      if (this$nameKana == null ? other$nameKana != null : !this$nameKana.equals(other$nameKana)) return false;
      final java.lang.Object this$nameKanji = this.getNameKanji();
      final java.lang.Object other$nameKanji = other.getNameKanji();
      if (this$nameKanji == null ? other$nameKanji != null : !this$nameKanji.equals(other$nameKanji)) return false;
      final java.lang.Object this$ownershipDeclaration = this.getOwnershipDeclaration();
      final java.lang.Object other$ownershipDeclaration = other.getOwnershipDeclaration();
      if (this$ownershipDeclaration == null ? other$ownershipDeclaration != null : !this$ownershipDeclaration.equals(other$ownershipDeclaration)) return false;
      final java.lang.Object this$phone = this.getPhone();
      final java.lang.Object other$phone = other.getPhone();
      if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) return false;
      final java.lang.Object this$structure = this.getStructure();
      final java.lang.Object other$structure = other.getStructure();
      if (this$structure == null ? other$structure != null : !this$structure.equals(other$structure)) return false;
      final java.lang.Object this$taxIdRegistrar = this.getTaxIdRegistrar();
      final java.lang.Object other$taxIdRegistrar = other.getTaxIdRegistrar();
      if (this$taxIdRegistrar == null ? other$taxIdRegistrar != null : !this$taxIdRegistrar.equals(other$taxIdRegistrar)) return false;
      final java.lang.Object this$verification = this.getVerification();
      final java.lang.Object other$verification = other.getVerification();
      if (this$verification == null ? other$verification != null : !this$verification.equals(other$verification)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.Company;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $directorsProvided = this.getDirectorsProvided();
      result = result * PRIME + ($directorsProvided == null ? 43 : $directorsProvided.hashCode());
      final java.lang.Object $executivesProvided = this.getExecutivesProvided();
      result = result * PRIME + ($executivesProvided == null ? 43 : $executivesProvided.hashCode());
      final java.lang.Object $ownersProvided = this.getOwnersProvided();
      result = result * PRIME + ($ownersProvided == null ? 43 : $ownersProvided.hashCode());
      final java.lang.Object $taxIdProvided = this.getTaxIdProvided();
      result = result * PRIME + ($taxIdProvided == null ? 43 : $taxIdProvided.hashCode());
      final java.lang.Object $vatIdProvided = this.getVatIdProvided();
      result = result * PRIME + ($vatIdProvided == null ? 43 : $vatIdProvided.hashCode());
      final java.lang.Object $address = this.getAddress();
      result = result * PRIME + ($address == null ? 43 : $address.hashCode());
      final java.lang.Object $addressKana = this.getAddressKana();
      result = result * PRIME + ($addressKana == null ? 43 : $addressKana.hashCode());
      final java.lang.Object $addressKanji = this.getAddressKanji();
      result = result * PRIME + ($addressKanji == null ? 43 : $addressKanji.hashCode());
      final java.lang.Object $name = this.getName();
      result = result * PRIME + ($name == null ? 43 : $name.hashCode());
      final java.lang.Object $nameKana = this.getNameKana();
      result = result * PRIME + ($nameKana == null ? 43 : $nameKana.hashCode());
      final java.lang.Object $nameKanji = this.getNameKanji();
      result = result * PRIME + ($nameKanji == null ? 43 : $nameKanji.hashCode());
      final java.lang.Object $ownershipDeclaration = this.getOwnershipDeclaration();
      result = result * PRIME + ($ownershipDeclaration == null ? 43 : $ownershipDeclaration.hashCode());
      final java.lang.Object $phone = this.getPhone();
      result = result * PRIME + ($phone == null ? 43 : $phone.hashCode());
      final java.lang.Object $structure = this.getStructure();
      result = result * PRIME + ($structure == null ? 43 : $structure.hashCode());
      final java.lang.Object $taxIdRegistrar = this.getTaxIdRegistrar();
      result = result * PRIME + ($taxIdRegistrar == null ? 43 : $taxIdRegistrar.hashCode());
      final java.lang.Object $verification = this.getVerification();
      result = result * PRIME + ($verification == null ? 43 : $verification.hashCode());
      return result;
    }
  }


  /**
   * Get expanded {@code front}.
   */
  public static class Controller extends StripeObject {
    /**
     * {@code true} if the Connect application retrieving the resource controls the account and can
     * therefore exercise <a
     * href="https://stripe.com/docs/connect/platform-controls-for-standard-accounts">platform
     * controls</a>. Otherwise, this field is null.
     */
    @SerializedName("is_controller")
    Boolean isController;
    /**
     * The controller type. Can be {@code application}, if a Connect application controls the
     * account, or {@code account}, if the account controls itself.
     */
    @SerializedName("type")
    String type;

    /**
     * {@code true} if the Connect application retrieving the resource controls the account and can
     * therefore exercise <a
     * href="https://stripe.com/docs/connect/platform-controls-for-standard-accounts">platform
     * controls</a>. Otherwise, this field is null.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsController() {
      return this.isController;
    }

    /**
     * The controller type. Can be {@code application}, if a Connect application controls the
     * account, or {@code account}, if the account controls itself.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    /**
     * {@code true} if the Connect application retrieving the resource controls the account and can
     * therefore exercise <a
     * href="https://stripe.com/docs/connect/platform-controls-for-standard-accounts">platform
     * controls</a>. Otherwise, this field is null.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIsController(final Boolean isController) {
      this.isController = isController;
    }

    /**
     * The controller type. Can be {@code application}, if a Connect application controls the
     * account, or {@code account}, if the account controls itself.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.Controller)) return false;
      final Account.Controller other = (Account.Controller) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$isController = this.getIsController();
      final java.lang.Object other$isController = other.getIsController();
      if (this$isController == null ? other$isController != null : !this$isController.equals(other$isController)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.Controller;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $isController = this.getIsController();
      result = result * PRIME + ($isController == null ? 43 : $isController.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }


  public static class DeclineChargeOn extends StripeObject {
    /**
     * Whether Stripe automatically declines charges with an incorrect ZIP or postal code. This
     * setting only applies when a ZIP or postal code is provided and they fail bank verification.
     */
    @SerializedName("avs_failure")
    Boolean avsFailure;
    /**
     * Whether Stripe automatically declines charges with an incorrect CVC. This setting only
     * applies when a CVC is provided and it fails bank verification.
     */
    @SerializedName("cvc_failure")
    Boolean cvcFailure;

    /**
     * Whether Stripe automatically declines charges with an incorrect ZIP or postal code. This
     * setting only applies when a ZIP or postal code is provided and they fail bank verification.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAvsFailure() {
      return this.avsFailure;
    }

    /**
     * Whether Stripe automatically declines charges with an incorrect CVC. This setting only
     * applies when a CVC is provided and it fails bank verification.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getCvcFailure() {
      return this.cvcFailure;
    }

    /**
     * Whether Stripe automatically declines charges with an incorrect ZIP or postal code. This
     * setting only applies when a ZIP or postal code is provided and they fail bank verification.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAvsFailure(final Boolean avsFailure) {
      this.avsFailure = avsFailure;
    }

    /**
     * Whether Stripe automatically declines charges with an incorrect CVC. This setting only
     * applies when a CVC is provided and it fails bank verification.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCvcFailure(final Boolean cvcFailure) {
      this.cvcFailure = cvcFailure;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.DeclineChargeOn)) return false;
      final Account.DeclineChargeOn other = (Account.DeclineChargeOn) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$avsFailure = this.getAvsFailure();
      final java.lang.Object other$avsFailure = other.getAvsFailure();
      if (this$avsFailure == null ? other$avsFailure != null : !this$avsFailure.equals(other$avsFailure)) return false;
      final java.lang.Object this$cvcFailure = this.getCvcFailure();
      final java.lang.Object other$cvcFailure = other.getCvcFailure();
      if (this$cvcFailure == null ? other$cvcFailure != null : !this$cvcFailure.equals(other$cvcFailure)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.DeclineChargeOn;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $avsFailure = this.getAvsFailure();
      result = result * PRIME + ($avsFailure == null ? 43 : $avsFailure.hashCode());
      final java.lang.Object $cvcFailure = this.getCvcFailure();
      result = result * PRIME + ($cvcFailure == null ? 43 : $cvcFailure.hashCode());
      return result;
    }
  }


  public static class FutureRequirements extends StripeObject {
    /**
     * Fields that are due and can be satisfied by providing the corresponding alternative fields
     * instead.
     */
    @SerializedName("alternatives")
    List<Account.FutureRequirements.Alternative> alternatives;
    /**
     * Date on which {@code future_requirements} merges with the main {@code requirements} hash and
     * {@code future_requirements} becomes empty. After the transition, {@code currently_due}
     * requirements may immediately become {@code past_due}, but the account may also be given a
     * grace period depending on its enablement state prior to transitioning.
     */
    @SerializedName("current_deadline")
    Long currentDeadline;
    /**
     * Fields that need to be collected to keep the account enabled. If not collected by {@code
     * future_requirements[current_deadline]}, these fields will transition to the main {@code
     * requirements} hash.
     */
    @SerializedName("currently_due")
    List<String> currentlyDue;
    /**
     * This is typed as a string for consistency with {@code requirements.disabled_reason}, but it
     * safe to assume {@code future_requirements.disabled_reason} is empty because fields in {@code
     * future_requirements} will never disable the account.
     */
    @SerializedName("disabled_reason")
    String disabledReason;
    /**
     * Fields that are {@code currently_due} and need to be collected again because validation or
     * verification failed.
     */
    @SerializedName("errors")
    List<Account.FutureRequirements.Errors> errors;
    /**
     * Fields that need to be collected assuming all volume thresholds are reached. As they become
     * required, they appear in {@code currently_due} as well.
     */
    @SerializedName("eventually_due")
    List<String> eventuallyDue;
    /**
     * Fields that weren't collected by {@code requirements.current_deadline}. These fields need to
     * be collected to enable the capability on the account. New fields will never appear here;
     * {@code future_requirements.past_due} will always be a subset of {@code
     * requirements.past_due}.
     */
    @SerializedName("past_due")
    List<String> pastDue;
    /**
     * Fields that may become required depending on the results of verification or review. Will be
     * an empty array unless an asynchronous verification is pending. If verification fails, these
     * fields move to {@code eventually_due} or {@code currently_due}.
     */
    @SerializedName("pending_verification")
    List<String> pendingVerification;


    public static class Alternative extends StripeObject {
      /**
       * Fields that can be provided to satisfy all fields in {@code original_fields_due}.
       */
      @SerializedName("alternative_fields_due")
      List<String> alternativeFieldsDue;
      /**
       * Fields that are due and can be satisfied by providing all fields in {@code
       * alternative_fields_due}.
       */
      @SerializedName("original_fields_due")
      List<String> originalFieldsDue;

      /**
       * Fields that can be provided to satisfy all fields in {@code original_fields_due}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getAlternativeFieldsDue() {
        return this.alternativeFieldsDue;
      }

      /**
       * Fields that are due and can be satisfied by providing all fields in {@code
       * alternative_fields_due}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getOriginalFieldsDue() {
        return this.originalFieldsDue;
      }

      /**
       * Fields that can be provided to satisfy all fields in {@code original_fields_due}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAlternativeFieldsDue(final List<String> alternativeFieldsDue) {
        this.alternativeFieldsDue = alternativeFieldsDue;
      }

      /**
       * Fields that are due and can be satisfied by providing all fields in {@code
       * alternative_fields_due}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setOriginalFieldsDue(final List<String> originalFieldsDue) {
        this.originalFieldsDue = originalFieldsDue;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Account.FutureRequirements.Alternative)) return false;
        final Account.FutureRequirements.Alternative other = (Account.FutureRequirements.Alternative) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$alternativeFieldsDue = this.getAlternativeFieldsDue();
        final java.lang.Object other$alternativeFieldsDue = other.getAlternativeFieldsDue();
        if (this$alternativeFieldsDue == null ? other$alternativeFieldsDue != null : !this$alternativeFieldsDue.equals(other$alternativeFieldsDue)) return false;
        final java.lang.Object this$originalFieldsDue = this.getOriginalFieldsDue();
        final java.lang.Object other$originalFieldsDue = other.getOriginalFieldsDue();
        if (this$originalFieldsDue == null ? other$originalFieldsDue != null : !this$originalFieldsDue.equals(other$originalFieldsDue)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Account.FutureRequirements.Alternative;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $alternativeFieldsDue = this.getAlternativeFieldsDue();
        result = result * PRIME + ($alternativeFieldsDue == null ? 43 : $alternativeFieldsDue.hashCode());
        final java.lang.Object $originalFieldsDue = this.getOriginalFieldsDue();
        result = result * PRIME + ($originalFieldsDue == null ? 43 : $originalFieldsDue.hashCode());
        return result;
      }
    }


    public static class Errors extends StripeObject {
      /**
       * The code for the type of error.
       *
       * <p>One of {@code invalid_address_city_state_postal_code}, {@code invalid_dob_age_under_18},
       * {@code invalid_representative_country}, {@code invalid_street_address}, {@code
       * invalid_tos_acceptance}, {@code invalid_value_other}, {@code
       * verification_document_address_mismatch}, {@code verification_document_address_missing},
       * {@code verification_document_corrupt}, {@code verification_document_country_not_supported},
       * {@code verification_document_dob_mismatch}, {@code verification_document_duplicate_type},
       * {@code verification_document_expired}, {@code verification_document_failed_copy}, {@code
       * verification_document_failed_greyscale}, {@code verification_document_failed_other}, {@code
       * verification_document_failed_test_mode}, {@code verification_document_fraudulent}, {@code
       * verification_document_id_number_mismatch}, {@code verification_document_id_number_missing},
       * {@code verification_document_incomplete}, {@code verification_document_invalid}, {@code
       * verification_document_issue_or_expiry_date_missing}, {@code
       * verification_document_manipulated}, {@code verification_document_missing_back}, {@code
       * verification_document_missing_front}, {@code verification_document_name_mismatch}, {@code
       * verification_document_name_missing}, {@code verification_document_nationality_mismatch},
       * {@code verification_document_not_readable}, {@code verification_document_not_signed},
       * {@code verification_document_not_uploaded}, {@code verification_document_photo_mismatch},
       * {@code verification_document_too_large}, {@code verification_document_type_not_supported},
       * {@code verification_failed_address_match}, {@code verification_failed_business_iec_number},
       * {@code verification_failed_document_match}, {@code verification_failed_id_number_match},
       * {@code verification_failed_keyed_identity}, {@code verification_failed_keyed_match}, {@code
       * verification_failed_name_match}, {@code verification_failed_other}, {@code
       * verification_failed_residential_address}, {@code verification_failed_tax_id_match}, {@code
       * verification_failed_tax_id_not_issued}, {@code verification_missing_executives}, {@code
       * verification_missing_owners}, or {@code
       * verification_requires_additional_memorandum_of_associations}.
       */
      @SerializedName("code")
      String code;
      /**
       * An informative message that indicates the error type and provides additional details about
       * the error.
       */
      @SerializedName("reason")
      String reason;
      @SerializedName("requirement")
      String requirement;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCode() {
        return this.code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getReason() {
        return this.reason;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRequirement() {
        return this.requirement;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCode(final String code) {
        this.code = code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReason(final String reason) {
        this.reason = reason;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequirement(final String requirement) {
        this.requirement = requirement;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Account.FutureRequirements.Errors)) return false;
        final Account.FutureRequirements.Errors other = (Account.FutureRequirements.Errors) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$code = this.getCode();
        final java.lang.Object other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
        final java.lang.Object this$reason = this.getReason();
        final java.lang.Object other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
        final java.lang.Object this$requirement = this.getRequirement();
        final java.lang.Object other$requirement = other.getRequirement();
        if (this$requirement == null ? other$requirement != null : !this$requirement.equals(other$requirement)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Account.FutureRequirements.Errors;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $code = this.getCode();
        result = result * PRIME + ($code == null ? 43 : $code.hashCode());
        final java.lang.Object $reason = this.getReason();
        result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
        final java.lang.Object $requirement = this.getRequirement();
        result = result * PRIME + ($requirement == null ? 43 : $requirement.hashCode());
        return result;
      }
    }

    /**
     * Fields that are due and can be satisfied by providing the corresponding alternative fields
     * instead.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Account.FutureRequirements.Alternative> getAlternatives() {
      return this.alternatives;
    }

    /**
     * Date on which {@code future_requirements} merges with the main {@code requirements} hash and
     * {@code future_requirements} becomes empty. After the transition, {@code currently_due}
     * requirements may immediately become {@code past_due}, but the account may also be given a
     * grace period depending on its enablement state prior to transitioning.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCurrentDeadline() {
      return this.currentDeadline;
    }

    /**
     * Fields that need to be collected to keep the account enabled. If not collected by {@code
     * future_requirements[current_deadline]}, these fields will transition to the main {@code
     * requirements} hash.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getCurrentlyDue() {
      return this.currentlyDue;
    }

    /**
     * This is typed as a string for consistency with {@code requirements.disabled_reason}, but it
     * safe to assume {@code future_requirements.disabled_reason} is empty because fields in {@code
     * future_requirements} will never disable the account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisabledReason() {
      return this.disabledReason;
    }

    /**
     * Fields that are {@code currently_due} and need to be collected again because validation or
     * verification failed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Account.FutureRequirements.Errors> getErrors() {
      return this.errors;
    }

    /**
     * Fields that need to be collected assuming all volume thresholds are reached. As they become
     * required, they appear in {@code currently_due} as well.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getEventuallyDue() {
      return this.eventuallyDue;
    }

    /**
     * Fields that weren't collected by {@code requirements.current_deadline}. These fields need to
     * be collected to enable the capability on the account. New fields will never appear here;
     * {@code future_requirements.past_due} will always be a subset of {@code
     * requirements.past_due}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getPastDue() {
      return this.pastDue;
    }

    /**
     * Fields that may become required depending on the results of verification or review. Will be
     * an empty array unless an asynchronous verification is pending. If verification fails, these
     * fields move to {@code eventually_due} or {@code currently_due}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getPendingVerification() {
      return this.pendingVerification;
    }

    /**
     * Fields that are due and can be satisfied by providing the corresponding alternative fields
     * instead.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAlternatives(final List<Account.FutureRequirements.Alternative> alternatives) {
      this.alternatives = alternatives;
    }

    /**
     * Date on which {@code future_requirements} merges with the main {@code requirements} hash and
     * {@code future_requirements} becomes empty. After the transition, {@code currently_due}
     * requirements may immediately become {@code past_due}, but the account may also be given a
     * grace period depending on its enablement state prior to transitioning.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrentDeadline(final Long currentDeadline) {
      this.currentDeadline = currentDeadline;
    }

    /**
     * Fields that need to be collected to keep the account enabled. If not collected by {@code
     * future_requirements[current_deadline]}, these fields will transition to the main {@code
     * requirements} hash.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrentlyDue(final List<String> currentlyDue) {
      this.currentlyDue = currentlyDue;
    }

    /**
     * This is typed as a string for consistency with {@code requirements.disabled_reason}, but it
     * safe to assume {@code future_requirements.disabled_reason} is empty because fields in {@code
     * future_requirements} will never disable the account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisabledReason(final String disabledReason) {
      this.disabledReason = disabledReason;
    }

    /**
     * Fields that are {@code currently_due} and need to be collected again because validation or
     * verification failed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setErrors(final List<Account.FutureRequirements.Errors> errors) {
      this.errors = errors;
    }

    /**
     * Fields that need to be collected assuming all volume thresholds are reached. As they become
     * required, they appear in {@code currently_due} as well.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEventuallyDue(final List<String> eventuallyDue) {
      this.eventuallyDue = eventuallyDue;
    }

    /**
     * Fields that weren't collected by {@code requirements.current_deadline}. These fields need to
     * be collected to enable the capability on the account. New fields will never appear here;
     * {@code future_requirements.past_due} will always be a subset of {@code
     * requirements.past_due}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPastDue(final List<String> pastDue) {
      this.pastDue = pastDue;
    }

    /**
     * Fields that may become required depending on the results of verification or review. Will be
     * an empty array unless an asynchronous verification is pending. If verification fails, these
     * fields move to {@code eventually_due} or {@code currently_due}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPendingVerification(final List<String> pendingVerification) {
      this.pendingVerification = pendingVerification;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.FutureRequirements)) return false;
      final Account.FutureRequirements other = (Account.FutureRequirements) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$currentDeadline = this.getCurrentDeadline();
      final java.lang.Object other$currentDeadline = other.getCurrentDeadline();
      if (this$currentDeadline == null ? other$currentDeadline != null : !this$currentDeadline.equals(other$currentDeadline)) return false;
      final java.lang.Object this$alternatives = this.getAlternatives();
      final java.lang.Object other$alternatives = other.getAlternatives();
      if (this$alternatives == null ? other$alternatives != null : !this$alternatives.equals(other$alternatives)) return false;
      final java.lang.Object this$currentlyDue = this.getCurrentlyDue();
      final java.lang.Object other$currentlyDue = other.getCurrentlyDue();
      if (this$currentlyDue == null ? other$currentlyDue != null : !this$currentlyDue.equals(other$currentlyDue)) return false;
      final java.lang.Object this$disabledReason = this.getDisabledReason();
      final java.lang.Object other$disabledReason = other.getDisabledReason();
      if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) return false;
      final java.lang.Object this$errors = this.getErrors();
      final java.lang.Object other$errors = other.getErrors();
      if (this$errors == null ? other$errors != null : !this$errors.equals(other$errors)) return false;
      final java.lang.Object this$eventuallyDue = this.getEventuallyDue();
      final java.lang.Object other$eventuallyDue = other.getEventuallyDue();
      if (this$eventuallyDue == null ? other$eventuallyDue != null : !this$eventuallyDue.equals(other$eventuallyDue)) return false;
      final java.lang.Object this$pastDue = this.getPastDue();
      final java.lang.Object other$pastDue = other.getPastDue();
      if (this$pastDue == null ? other$pastDue != null : !this$pastDue.equals(other$pastDue)) return false;
      final java.lang.Object this$pendingVerification = this.getPendingVerification();
      final java.lang.Object other$pendingVerification = other.getPendingVerification();
      if (this$pendingVerification == null ? other$pendingVerification != null : !this$pendingVerification.equals(other$pendingVerification)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.FutureRequirements;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $currentDeadline = this.getCurrentDeadline();
      result = result * PRIME + ($currentDeadline == null ? 43 : $currentDeadline.hashCode());
      final java.lang.Object $alternatives = this.getAlternatives();
      result = result * PRIME + ($alternatives == null ? 43 : $alternatives.hashCode());
      final java.lang.Object $currentlyDue = this.getCurrentlyDue();
      result = result * PRIME + ($currentlyDue == null ? 43 : $currentlyDue.hashCode());
      final java.lang.Object $disabledReason = this.getDisabledReason();
      result = result * PRIME + ($disabledReason == null ? 43 : $disabledReason.hashCode());
      final java.lang.Object $errors = this.getErrors();
      result = result * PRIME + ($errors == null ? 43 : $errors.hashCode());
      final java.lang.Object $eventuallyDue = this.getEventuallyDue();
      result = result * PRIME + ($eventuallyDue == null ? 43 : $eventuallyDue.hashCode());
      final java.lang.Object $pastDue = this.getPastDue();
      result = result * PRIME + ($pastDue == null ? 43 : $pastDue.hashCode());
      final java.lang.Object $pendingVerification = this.getPendingVerification();
      result = result * PRIME + ($pendingVerification == null ? 43 : $pendingVerification.hashCode());
      return result;
    }
  }


  /**
   * The specific user onboarding requirement field (in the requirements hash) that needs to be
   * resolved.
   */
  public static class PayoutSchedule extends StripeObject {
    /**
     * The number of days charges for the account will be held before being paid out.
     */
    @SerializedName("delay_days")
    Long delayDays;
    /**
     * How frequently funds will be paid out. One of {@code manual} (payouts only created via API
     * call), {@code daily}, {@code weekly}, or {@code monthly}.
     */
    @SerializedName("interval")
    String interval;
    /**
     * The day of the month funds will be paid out. Only shown if {@code interval} is monthly.
     * Payouts scheduled between the 29th and 31st of the month are sent on the last day of shorter
     * months.
     */
    @SerializedName("monthly_anchor")
    Long monthlyAnchor;
    /**
     * The day of the week funds will be paid out, of the style 'monday', 'tuesday', etc. Only shown
     * if {@code interval} is weekly.
     */
    @SerializedName("weekly_anchor")
    String weeklyAnchor;

    /**
     * The number of days charges for the account will be held before being paid out.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDelayDays() {
      return this.delayDays;
    }

    /**
     * How frequently funds will be paid out. One of {@code manual} (payouts only created via API
     * call), {@code daily}, {@code weekly}, or {@code monthly}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getInterval() {
      return this.interval;
    }

    /**
     * The day of the month funds will be paid out. Only shown if {@code interval} is monthly.
     * Payouts scheduled between the 29th and 31st of the month are sent on the last day of shorter
     * months.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMonthlyAnchor() {
      return this.monthlyAnchor;
    }

    /**
     * The day of the week funds will be paid out, of the style 'monday', 'tuesday', etc. Only shown
     * if {@code interval} is weekly.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWeeklyAnchor() {
      return this.weeklyAnchor;
    }

    /**
     * The number of days charges for the account will be held before being paid out.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDelayDays(final Long delayDays) {
      this.delayDays = delayDays;
    }

    /**
     * How frequently funds will be paid out. One of {@code manual} (payouts only created via API
     * call), {@code daily}, {@code weekly}, or {@code monthly}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInterval(final String interval) {
      this.interval = interval;
    }

    /**
     * The day of the month funds will be paid out. Only shown if {@code interval} is monthly.
     * Payouts scheduled between the 29th and 31st of the month are sent on the last day of shorter
     * months.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMonthlyAnchor(final Long monthlyAnchor) {
      this.monthlyAnchor = monthlyAnchor;
    }

    /**
     * The day of the week funds will be paid out, of the style 'monday', 'tuesday', etc. Only shown
     * if {@code interval} is weekly.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setWeeklyAnchor(final String weeklyAnchor) {
      this.weeklyAnchor = weeklyAnchor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.PayoutSchedule)) return false;
      final Account.PayoutSchedule other = (Account.PayoutSchedule) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$delayDays = this.getDelayDays();
      final java.lang.Object other$delayDays = other.getDelayDays();
      if (this$delayDays == null ? other$delayDays != null : !this$delayDays.equals(other$delayDays)) return false;
      final java.lang.Object this$monthlyAnchor = this.getMonthlyAnchor();
      final java.lang.Object other$monthlyAnchor = other.getMonthlyAnchor();
      if (this$monthlyAnchor == null ? other$monthlyAnchor != null : !this$monthlyAnchor.equals(other$monthlyAnchor)) return false;
      final java.lang.Object this$interval = this.getInterval();
      final java.lang.Object other$interval = other.getInterval();
      if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) return false;
      final java.lang.Object this$weeklyAnchor = this.getWeeklyAnchor();
      final java.lang.Object other$weeklyAnchor = other.getWeeklyAnchor();
      if (this$weeklyAnchor == null ? other$weeklyAnchor != null : !this$weeklyAnchor.equals(other$weeklyAnchor)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.PayoutSchedule;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $delayDays = this.getDelayDays();
      result = result * PRIME + ($delayDays == null ? 43 : $delayDays.hashCode());
      final java.lang.Object $monthlyAnchor = this.getMonthlyAnchor();
      result = result * PRIME + ($monthlyAnchor == null ? 43 : $monthlyAnchor.hashCode());
      final java.lang.Object $interval = this.getInterval();
      result = result * PRIME + ($interval == null ? 43 : $interval.hashCode());
      final java.lang.Object $weeklyAnchor = this.getWeeklyAnchor();
      result = result * PRIME + ($weeklyAnchor == null ? 43 : $weeklyAnchor.hashCode());
      return result;
    }
  }


  public static class Requirements extends StripeObject {
    /**
     * Fields that are due and can be satisfied by providing the corresponding alternative fields
     * instead.
     */
    @SerializedName("alternatives")
    List<Account.Requirements.Alternative> alternatives;
    /**
     * Date by which the fields in {@code currently_due} must be collected to keep the account
     * enabled. These fields may disable the account sooner if the next threshold is reached before
     * they are collected.
     */
    @SerializedName("current_deadline")
    Long currentDeadline;
    /**
     * Fields that need to be collected to keep the account enabled. If not collected by {@code
     * current_deadline}, these fields appear in {@code past_due} as well, and the account is
     * disabled.
     */
    @SerializedName("currently_due")
    List<String> currentlyDue;
    /**
     * If the account is disabled, this string describes why. Can be {@code requirements.past_due},
     * {@code requirements.pending_verification}, {@code listed}, {@code platform_paused}, {@code
     * rejected.fraud}, {@code rejected.listed}, {@code rejected.terms_of_service}, {@code
     * rejected.other}, {@code under_review}, or {@code other}.
     */
    @SerializedName("disabled_reason")
    String disabledReason;
    /**
     * Fields that are {@code currently_due} and need to be collected again because validation or
     * verification failed.
     */
    @SerializedName("errors")
    List<Account.Requirements.Errors> errors;
    /**
     * Fields that need to be collected assuming all volume thresholds are reached. As they become
     * required, they appear in {@code currently_due} as well, and {@code current_deadline} becomes
     * set.
     */
    @SerializedName("eventually_due")
    List<String> eventuallyDue;
    /**
     * Fields that weren't collected by {@code current_deadline}. These fields need to be collected
     * to enable the account.
     */
    @SerializedName("past_due")
    List<String> pastDue;
    /**
     * Fields that may become required depending on the results of verification or review. Will be
     * an empty array unless an asynchronous verification is pending. If verification fails, these
     * fields move to {@code eventually_due}, {@code currently_due}, or {@code past_due}.
     */
    @SerializedName("pending_verification")
    List<String> pendingVerification;


    public static class Alternative extends StripeObject {
      /**
       * Fields that can be provided to satisfy all fields in {@code original_fields_due}.
       */
      @SerializedName("alternative_fields_due")
      List<String> alternativeFieldsDue;
      /**
       * Fields that are due and can be satisfied by providing all fields in {@code
       * alternative_fields_due}.
       */
      @SerializedName("original_fields_due")
      List<String> originalFieldsDue;

      /**
       * Fields that can be provided to satisfy all fields in {@code original_fields_due}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getAlternativeFieldsDue() {
        return this.alternativeFieldsDue;
      }

      /**
       * Fields that are due and can be satisfied by providing all fields in {@code
       * alternative_fields_due}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getOriginalFieldsDue() {
        return this.originalFieldsDue;
      }

      /**
       * Fields that can be provided to satisfy all fields in {@code original_fields_due}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAlternativeFieldsDue(final List<String> alternativeFieldsDue) {
        this.alternativeFieldsDue = alternativeFieldsDue;
      }

      /**
       * Fields that are due and can be satisfied by providing all fields in {@code
       * alternative_fields_due}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setOriginalFieldsDue(final List<String> originalFieldsDue) {
        this.originalFieldsDue = originalFieldsDue;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Account.Requirements.Alternative)) return false;
        final Account.Requirements.Alternative other = (Account.Requirements.Alternative) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$alternativeFieldsDue = this.getAlternativeFieldsDue();
        final java.lang.Object other$alternativeFieldsDue = other.getAlternativeFieldsDue();
        if (this$alternativeFieldsDue == null ? other$alternativeFieldsDue != null : !this$alternativeFieldsDue.equals(other$alternativeFieldsDue)) return false;
        final java.lang.Object this$originalFieldsDue = this.getOriginalFieldsDue();
        final java.lang.Object other$originalFieldsDue = other.getOriginalFieldsDue();
        if (this$originalFieldsDue == null ? other$originalFieldsDue != null : !this$originalFieldsDue.equals(other$originalFieldsDue)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Account.Requirements.Alternative;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $alternativeFieldsDue = this.getAlternativeFieldsDue();
        result = result * PRIME + ($alternativeFieldsDue == null ? 43 : $alternativeFieldsDue.hashCode());
        final java.lang.Object $originalFieldsDue = this.getOriginalFieldsDue();
        result = result * PRIME + ($originalFieldsDue == null ? 43 : $originalFieldsDue.hashCode());
        return result;
      }
    }


    public static class Errors extends StripeObject {
      /**
       * The code for the type of error.
       *
       * <p>One of {@code invalid_address_city_state_postal_code}, {@code invalid_dob_age_under_18},
       * {@code invalid_representative_country}, {@code invalid_street_address}, {@code
       * invalid_tos_acceptance}, {@code invalid_value_other}, {@code
       * verification_document_address_mismatch}, {@code verification_document_address_missing},
       * {@code verification_document_corrupt}, {@code verification_document_country_not_supported},
       * {@code verification_document_dob_mismatch}, {@code verification_document_duplicate_type},
       * {@code verification_document_expired}, {@code verification_document_failed_copy}, {@code
       * verification_document_failed_greyscale}, {@code verification_document_failed_other}, {@code
       * verification_document_failed_test_mode}, {@code verification_document_fraudulent}, {@code
       * verification_document_id_number_mismatch}, {@code verification_document_id_number_missing},
       * {@code verification_document_incomplete}, {@code verification_document_invalid}, {@code
       * verification_document_issue_or_expiry_date_missing}, {@code
       * verification_document_manipulated}, {@code verification_document_missing_back}, {@code
       * verification_document_missing_front}, {@code verification_document_name_mismatch}, {@code
       * verification_document_name_missing}, {@code verification_document_nationality_mismatch},
       * {@code verification_document_not_readable}, {@code verification_document_not_signed},
       * {@code verification_document_not_uploaded}, {@code verification_document_photo_mismatch},
       * {@code verification_document_too_large}, {@code verification_document_type_not_supported},
       * {@code verification_failed_address_match}, {@code verification_failed_business_iec_number},
       * {@code verification_failed_document_match}, {@code verification_failed_id_number_match},
       * {@code verification_failed_keyed_identity}, {@code verification_failed_keyed_match}, {@code
       * verification_failed_name_match}, {@code verification_failed_other}, {@code
       * verification_failed_residential_address}, {@code verification_failed_tax_id_match}, {@code
       * verification_failed_tax_id_not_issued}, {@code verification_missing_executives}, {@code
       * verification_missing_owners}, or {@code
       * verification_requires_additional_memorandum_of_associations}.
       */
      @SerializedName("code")
      String code;
      /**
       * An informative message that indicates the error type and provides additional details about
       * the error.
       */
      @SerializedName("reason")
      String reason;
      @SerializedName("requirement")
      String requirement;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCode() {
        return this.code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getReason() {
        return this.reason;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRequirement() {
        return this.requirement;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCode(final String code) {
        this.code = code;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReason(final String reason) {
        this.reason = reason;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRequirement(final String requirement) {
        this.requirement = requirement;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Account.Requirements.Errors)) return false;
        final Account.Requirements.Errors other = (Account.Requirements.Errors) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$code = this.getCode();
        final java.lang.Object other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
        final java.lang.Object this$reason = this.getReason();
        final java.lang.Object other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
        final java.lang.Object this$requirement = this.getRequirement();
        final java.lang.Object other$requirement = other.getRequirement();
        if (this$requirement == null ? other$requirement != null : !this$requirement.equals(other$requirement)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Account.Requirements.Errors;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $code = this.getCode();
        result = result * PRIME + ($code == null ? 43 : $code.hashCode());
        final java.lang.Object $reason = this.getReason();
        result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
        final java.lang.Object $requirement = this.getRequirement();
        result = result * PRIME + ($requirement == null ? 43 : $requirement.hashCode());
        return result;
      }
    }

    /**
     * Fields that are due and can be satisfied by providing the corresponding alternative fields
     * instead.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Account.Requirements.Alternative> getAlternatives() {
      return this.alternatives;
    }

    /**
     * Date by which the fields in {@code currently_due} must be collected to keep the account
     * enabled. These fields may disable the account sooner if the next threshold is reached before
     * they are collected.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCurrentDeadline() {
      return this.currentDeadline;
    }

    /**
     * Fields that need to be collected to keep the account enabled. If not collected by {@code
     * current_deadline}, these fields appear in {@code past_due} as well, and the account is
     * disabled.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getCurrentlyDue() {
      return this.currentlyDue;
    }

    /**
     * If the account is disabled, this string describes why. Can be {@code requirements.past_due},
     * {@code requirements.pending_verification}, {@code listed}, {@code platform_paused}, {@code
     * rejected.fraud}, {@code rejected.listed}, {@code rejected.terms_of_service}, {@code
     * rejected.other}, {@code under_review}, or {@code other}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisabledReason() {
      return this.disabledReason;
    }

    /**
     * Fields that are {@code currently_due} and need to be collected again because validation or
     * verification failed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Account.Requirements.Errors> getErrors() {
      return this.errors;
    }

    /**
     * Fields that need to be collected assuming all volume thresholds are reached. As they become
     * required, they appear in {@code currently_due} as well, and {@code current_deadline} becomes
     * set.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getEventuallyDue() {
      return this.eventuallyDue;
    }

    /**
     * Fields that weren't collected by {@code current_deadline}. These fields need to be collected
     * to enable the account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getPastDue() {
      return this.pastDue;
    }

    /**
     * Fields that may become required depending on the results of verification or review. Will be
     * an empty array unless an asynchronous verification is pending. If verification fails, these
     * fields move to {@code eventually_due}, {@code currently_due}, or {@code past_due}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getPendingVerification() {
      return this.pendingVerification;
    }

    /**
     * Fields that are due and can be satisfied by providing the corresponding alternative fields
     * instead.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAlternatives(final List<Account.Requirements.Alternative> alternatives) {
      this.alternatives = alternatives;
    }

    /**
     * Date by which the fields in {@code currently_due} must be collected to keep the account
     * enabled. These fields may disable the account sooner if the next threshold is reached before
     * they are collected.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrentDeadline(final Long currentDeadline) {
      this.currentDeadline = currentDeadline;
    }

    /**
     * Fields that need to be collected to keep the account enabled. If not collected by {@code
     * current_deadline}, these fields appear in {@code past_due} as well, and the account is
     * disabled.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrentlyDue(final List<String> currentlyDue) {
      this.currentlyDue = currentlyDue;
    }

    /**
     * If the account is disabled, this string describes why. Can be {@code requirements.past_due},
     * {@code requirements.pending_verification}, {@code listed}, {@code platform_paused}, {@code
     * rejected.fraud}, {@code rejected.listed}, {@code rejected.terms_of_service}, {@code
     * rejected.other}, {@code under_review}, or {@code other}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisabledReason(final String disabledReason) {
      this.disabledReason = disabledReason;
    }

    /**
     * Fields that are {@code currently_due} and need to be collected again because validation or
     * verification failed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setErrors(final List<Account.Requirements.Errors> errors) {
      this.errors = errors;
    }

    /**
     * Fields that need to be collected assuming all volume thresholds are reached. As they become
     * required, they appear in {@code currently_due} as well, and {@code current_deadline} becomes
     * set.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEventuallyDue(final List<String> eventuallyDue) {
      this.eventuallyDue = eventuallyDue;
    }

    /**
     * Fields that weren't collected by {@code current_deadline}. These fields need to be collected
     * to enable the account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPastDue(final List<String> pastDue) {
      this.pastDue = pastDue;
    }

    /**
     * Fields that may become required depending on the results of verification or review. Will be
     * an empty array unless an asynchronous verification is pending. If verification fails, these
     * fields move to {@code eventually_due}, {@code currently_due}, or {@code past_due}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPendingVerification(final List<String> pendingVerification) {
      this.pendingVerification = pendingVerification;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.Requirements)) return false;
      final Account.Requirements other = (Account.Requirements) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$currentDeadline = this.getCurrentDeadline();
      final java.lang.Object other$currentDeadline = other.getCurrentDeadline();
      if (this$currentDeadline == null ? other$currentDeadline != null : !this$currentDeadline.equals(other$currentDeadline)) return false;
      final java.lang.Object this$alternatives = this.getAlternatives();
      final java.lang.Object other$alternatives = other.getAlternatives();
      if (this$alternatives == null ? other$alternatives != null : !this$alternatives.equals(other$alternatives)) return false;
      final java.lang.Object this$currentlyDue = this.getCurrentlyDue();
      final java.lang.Object other$currentlyDue = other.getCurrentlyDue();
      if (this$currentlyDue == null ? other$currentlyDue != null : !this$currentlyDue.equals(other$currentlyDue)) return false;
      final java.lang.Object this$disabledReason = this.getDisabledReason();
      final java.lang.Object other$disabledReason = other.getDisabledReason();
      if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) return false;
      final java.lang.Object this$errors = this.getErrors();
      final java.lang.Object other$errors = other.getErrors();
      if (this$errors == null ? other$errors != null : !this$errors.equals(other$errors)) return false;
      final java.lang.Object this$eventuallyDue = this.getEventuallyDue();
      final java.lang.Object other$eventuallyDue = other.getEventuallyDue();
      if (this$eventuallyDue == null ? other$eventuallyDue != null : !this$eventuallyDue.equals(other$eventuallyDue)) return false;
      final java.lang.Object this$pastDue = this.getPastDue();
      final java.lang.Object other$pastDue = other.getPastDue();
      if (this$pastDue == null ? other$pastDue != null : !this$pastDue.equals(other$pastDue)) return false;
      final java.lang.Object this$pendingVerification = this.getPendingVerification();
      final java.lang.Object other$pendingVerification = other.getPendingVerification();
      if (this$pendingVerification == null ? other$pendingVerification != null : !this$pendingVerification.equals(other$pendingVerification)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.Requirements;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $currentDeadline = this.getCurrentDeadline();
      result = result * PRIME + ($currentDeadline == null ? 43 : $currentDeadline.hashCode());
      final java.lang.Object $alternatives = this.getAlternatives();
      result = result * PRIME + ($alternatives == null ? 43 : $alternatives.hashCode());
      final java.lang.Object $currentlyDue = this.getCurrentlyDue();
      result = result * PRIME + ($currentlyDue == null ? 43 : $currentlyDue.hashCode());
      final java.lang.Object $disabledReason = this.getDisabledReason();
      result = result * PRIME + ($disabledReason == null ? 43 : $disabledReason.hashCode());
      final java.lang.Object $errors = this.getErrors();
      result = result * PRIME + ($errors == null ? 43 : $errors.hashCode());
      final java.lang.Object $eventuallyDue = this.getEventuallyDue();
      result = result * PRIME + ($eventuallyDue == null ? 43 : $eventuallyDue.hashCode());
      final java.lang.Object $pastDue = this.getPastDue();
      result = result * PRIME + ($pastDue == null ? 43 : $pastDue.hashCode());
      final java.lang.Object $pendingVerification = this.getPendingVerification();
      result = result * PRIME + ($pendingVerification == null ? 43 : $pendingVerification.hashCode());
      return result;
    }
  }


  /**
   * The specific user onboarding requirement field (in the requirements hash) that needs to be
   * resolved.
   */
  public static class Settings extends StripeObject {
    @SerializedName("bacs_debit_payments")
    BacsDebitPayments bacsDebitPayments;
    @SerializedName("branding")
    SettingsBranding branding;
    @SerializedName("card_issuing")
    SettingsCardIssuing cardIssuing;
    @SerializedName("card_payments")
    SettingsCardPayments cardPayments;
    @SerializedName("dashboard")
    SettingsDashboard dashboard;
    @SerializedName("payments")
    SettingsPayments payments;
    @SerializedName("payouts")
    SettingsPayouts payouts;
    @SerializedName("sepa_debit_payments")
    SepaDebitPayments sepaDebitPayments;
    @SerializedName("treasury")
    SettingsTreasury treasury;


    public static class BacsDebitPayments extends StripeObject {
      /**
       * The Bacs Direct Debit Display Name for this account. For payments made with Bacs Direct
       * Debit, this will appear on the mandate, and as the statement descriptor.
       */
      @SerializedName("display_name")
      String displayName;

      /**
       * The Bacs Direct Debit Display Name for this account. For payments made with Bacs Direct
       * Debit, this will appear on the mandate, and as the statement descriptor.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getDisplayName() {
        return this.displayName;
      }

      /**
       * The Bacs Direct Debit Display Name for this account. For payments made with Bacs Direct
       * Debit, this will appear on the mandate, and as the statement descriptor.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDisplayName(final String displayName) {
        this.displayName = displayName;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Account.Settings.BacsDebitPayments)) return false;
        final Account.Settings.BacsDebitPayments other = (Account.Settings.BacsDebitPayments) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$displayName = this.getDisplayName();
        final java.lang.Object other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Account.Settings.BacsDebitPayments;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $displayName = this.getDisplayName();
        result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
        return result;
      }
    }


    public static class SepaDebitPayments extends StripeObject {
      /**
       * SEPA creditor identifier that identifies the company making the payment.
       */
      @SerializedName("creditor_id")
      String creditorId;

      /**
       * SEPA creditor identifier that identifies the company making the payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCreditorId() {
        return this.creditorId;
      }

      /**
       * SEPA creditor identifier that identifies the company making the payment.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCreditorId(final String creditorId) {
        this.creditorId = creditorId;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Account.Settings.SepaDebitPayments)) return false;
        final Account.Settings.SepaDebitPayments other = (Account.Settings.SepaDebitPayments) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$creditorId = this.getCreditorId();
        final java.lang.Object other$creditorId = other.getCreditorId();
        if (this$creditorId == null ? other$creditorId != null : !this$creditorId.equals(other$creditorId)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Account.Settings.SepaDebitPayments;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $creditorId = this.getCreditorId();
        result = result * PRIME + ($creditorId == null ? 43 : $creditorId.hashCode());
        return result;
      }
    }


    public static class SettingsCardIssuing extends StripeObject {
      @SerializedName("tos_acceptance")
      TosAcceptance tosAcceptance;


      public static class TosAcceptance extends StripeObject {
        /**
         * The Unix timestamp marking when the account representative accepted the service
         * agreement.
         */
        @SerializedName("date")
        Long date;
        /** The IP address from which the account representative accepted the service agreement. */
        @SerializedName("ip")
        String ip;
        @SerializedName("user_agent")
        String userAgent;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getDate() {
          return this.date;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getIp() {
          return this.ip;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getUserAgent() {
          return this.userAgent;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setDate(final Long date) {
          this.date = date;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setIp(final String ip) {
          this.ip = ip;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setUserAgent(final String userAgent) {
          this.userAgent = userAgent;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Account.Settings.SettingsCardIssuing.TosAcceptance)) return false;
          final Account.Settings.SettingsCardIssuing.TosAcceptance other = (Account.Settings.SettingsCardIssuing.TosAcceptance) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$date = this.getDate();
          final java.lang.Object other$date = other.getDate();
          if (this$date == null ? other$date != null : !this$date.equals(other$date)) return false;
          final java.lang.Object this$ip = this.getIp();
          final java.lang.Object other$ip = other.getIp();
          if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) return false;
          final java.lang.Object this$userAgent = this.getUserAgent();
          final java.lang.Object other$userAgent = other.getUserAgent();
          if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Account.Settings.SettingsCardIssuing.TosAcceptance;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $date = this.getDate();
          result = result * PRIME + ($date == null ? 43 : $date.hashCode());
          final java.lang.Object $ip = this.getIp();
          result = result * PRIME + ($ip == null ? 43 : $ip.hashCode());
          final java.lang.Object $userAgent = this.getUserAgent();
          result = result * PRIME + ($userAgent == null ? 43 : $userAgent.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public TosAcceptance getTosAcceptance() {
        return this.tosAcceptance;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setTosAcceptance(final TosAcceptance tosAcceptance) {
        this.tosAcceptance = tosAcceptance;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Account.Settings.SettingsCardIssuing)) return false;
        final Account.Settings.SettingsCardIssuing other = (Account.Settings.SettingsCardIssuing) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$tosAcceptance = this.getTosAcceptance();
        final java.lang.Object other$tosAcceptance = other.getTosAcceptance();
        if (this$tosAcceptance == null ? other$tosAcceptance != null : !this$tosAcceptance.equals(other$tosAcceptance)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Account.Settings.SettingsCardIssuing;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $tosAcceptance = this.getTosAcceptance();
        result = result * PRIME + ($tosAcceptance == null ? 43 : $tosAcceptance.hashCode());
        return result;
      }
    }


    /**
     * The user agent of the browser from which the account representative accepted the service
     * agreement.
     */
    public static class SettingsTreasury extends StripeObject {
      @SerializedName("tos_acceptance")
      TosAcceptance tosAcceptance;


      public static class TosAcceptance extends StripeObject {
        /**
         * The Unix timestamp marking when the account representative accepted the service
         * agreement.
         */
        @SerializedName("date")
        Long date;
        /** The IP address from which the account representative accepted the service agreement. */
        @SerializedName("ip")
        String ip;
        @SerializedName("user_agent")
        String userAgent;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getDate() {
          return this.date;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getIp() {
          return this.ip;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getUserAgent() {
          return this.userAgent;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setDate(final Long date) {
          this.date = date;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setIp(final String ip) {
          this.ip = ip;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setUserAgent(final String userAgent) {
          this.userAgent = userAgent;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Account.Settings.SettingsTreasury.TosAcceptance)) return false;
          final Account.Settings.SettingsTreasury.TosAcceptance other = (Account.Settings.SettingsTreasury.TosAcceptance) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$date = this.getDate();
          final java.lang.Object other$date = other.getDate();
          if (this$date == null ? other$date != null : !this$date.equals(other$date)) return false;
          final java.lang.Object this$ip = this.getIp();
          final java.lang.Object other$ip = other.getIp();
          if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) return false;
          final java.lang.Object this$userAgent = this.getUserAgent();
          final java.lang.Object other$userAgent = other.getUserAgent();
          if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Account.Settings.SettingsTreasury.TosAcceptance;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $date = this.getDate();
          result = result * PRIME + ($date == null ? 43 : $date.hashCode());
          final java.lang.Object $ip = this.getIp();
          result = result * PRIME + ($ip == null ? 43 : $ip.hashCode());
          final java.lang.Object $userAgent = this.getUserAgent();
          result = result * PRIME + ($userAgent == null ? 43 : $userAgent.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public TosAcceptance getTosAcceptance() {
        return this.tosAcceptance;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setTosAcceptance(final TosAcceptance tosAcceptance) {
        this.tosAcceptance = tosAcceptance;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Account.Settings.SettingsTreasury)) return false;
        final Account.Settings.SettingsTreasury other = (Account.Settings.SettingsTreasury) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$tosAcceptance = this.getTosAcceptance();
        final java.lang.Object other$tosAcceptance = other.getTosAcceptance();
        if (this$tosAcceptance == null ? other$tosAcceptance != null : !this$tosAcceptance.equals(other$tosAcceptance)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Account.Settings.SettingsTreasury;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $tosAcceptance = this.getTosAcceptance();
        result = result * PRIME + ($tosAcceptance == null ? 43 : $tosAcceptance.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BacsDebitPayments getBacsDebitPayments() {
      return this.bacsDebitPayments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SettingsBranding getBranding() {
      return this.branding;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SettingsCardIssuing getCardIssuing() {
      return this.cardIssuing;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SettingsCardPayments getCardPayments() {
      return this.cardPayments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SettingsDashboard getDashboard() {
      return this.dashboard;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SettingsPayments getPayments() {
      return this.payments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SettingsPayouts getPayouts() {
      return this.payouts;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SepaDebitPayments getSepaDebitPayments() {
      return this.sepaDebitPayments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SettingsTreasury getTreasury() {
      return this.treasury;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBacsDebitPayments(final BacsDebitPayments bacsDebitPayments) {
      this.bacsDebitPayments = bacsDebitPayments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBranding(final SettingsBranding branding) {
      this.branding = branding;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCardIssuing(final SettingsCardIssuing cardIssuing) {
      this.cardIssuing = cardIssuing;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCardPayments(final SettingsCardPayments cardPayments) {
      this.cardPayments = cardPayments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDashboard(final SettingsDashboard dashboard) {
      this.dashboard = dashboard;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayments(final SettingsPayments payments) {
      this.payments = payments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayouts(final SettingsPayouts payouts) {
      this.payouts = payouts;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSepaDebitPayments(final SepaDebitPayments sepaDebitPayments) {
      this.sepaDebitPayments = sepaDebitPayments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTreasury(final SettingsTreasury treasury) {
      this.treasury = treasury;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.Settings)) return false;
      final Account.Settings other = (Account.Settings) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$bacsDebitPayments = this.getBacsDebitPayments();
      final java.lang.Object other$bacsDebitPayments = other.getBacsDebitPayments();
      if (this$bacsDebitPayments == null ? other$bacsDebitPayments != null : !this$bacsDebitPayments.equals(other$bacsDebitPayments)) return false;
      final java.lang.Object this$branding = this.getBranding();
      final java.lang.Object other$branding = other.getBranding();
      if (this$branding == null ? other$branding != null : !this$branding.equals(other$branding)) return false;
      final java.lang.Object this$cardIssuing = this.getCardIssuing();
      final java.lang.Object other$cardIssuing = other.getCardIssuing();
      if (this$cardIssuing == null ? other$cardIssuing != null : !this$cardIssuing.equals(other$cardIssuing)) return false;
      final java.lang.Object this$cardPayments = this.getCardPayments();
      final java.lang.Object other$cardPayments = other.getCardPayments();
      if (this$cardPayments == null ? other$cardPayments != null : !this$cardPayments.equals(other$cardPayments)) return false;
      final java.lang.Object this$dashboard = this.getDashboard();
      final java.lang.Object other$dashboard = other.getDashboard();
      if (this$dashboard == null ? other$dashboard != null : !this$dashboard.equals(other$dashboard)) return false;
      final java.lang.Object this$payments = this.getPayments();
      final java.lang.Object other$payments = other.getPayments();
      if (this$payments == null ? other$payments != null : !this$payments.equals(other$payments)) return false;
      final java.lang.Object this$payouts = this.getPayouts();
      final java.lang.Object other$payouts = other.getPayouts();
      if (this$payouts == null ? other$payouts != null : !this$payouts.equals(other$payouts)) return false;
      final java.lang.Object this$sepaDebitPayments = this.getSepaDebitPayments();
      final java.lang.Object other$sepaDebitPayments = other.getSepaDebitPayments();
      if (this$sepaDebitPayments == null ? other$sepaDebitPayments != null : !this$sepaDebitPayments.equals(other$sepaDebitPayments)) return false;
      final java.lang.Object this$treasury = this.getTreasury();
      final java.lang.Object other$treasury = other.getTreasury();
      if (this$treasury == null ? other$treasury != null : !this$treasury.equals(other$treasury)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.Settings;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $bacsDebitPayments = this.getBacsDebitPayments();
      result = result * PRIME + ($bacsDebitPayments == null ? 43 : $bacsDebitPayments.hashCode());
      final java.lang.Object $branding = this.getBranding();
      result = result * PRIME + ($branding == null ? 43 : $branding.hashCode());
      final java.lang.Object $cardIssuing = this.getCardIssuing();
      result = result * PRIME + ($cardIssuing == null ? 43 : $cardIssuing.hashCode());
      final java.lang.Object $cardPayments = this.getCardPayments();
      result = result * PRIME + ($cardPayments == null ? 43 : $cardPayments.hashCode());
      final java.lang.Object $dashboard = this.getDashboard();
      result = result * PRIME + ($dashboard == null ? 43 : $dashboard.hashCode());
      final java.lang.Object $payments = this.getPayments();
      result = result * PRIME + ($payments == null ? 43 : $payments.hashCode());
      final java.lang.Object $payouts = this.getPayouts();
      result = result * PRIME + ($payouts == null ? 43 : $payouts.hashCode());
      final java.lang.Object $sepaDebitPayments = this.getSepaDebitPayments();
      result = result * PRIME + ($sepaDebitPayments == null ? 43 : $sepaDebitPayments.hashCode());
      final java.lang.Object $treasury = this.getTreasury();
      result = result * PRIME + ($treasury == null ? 43 : $treasury.hashCode());
      return result;
    }
  }


  /**
   * The user agent of the browser from which the account representative accepted the service
   * agreement.
   */
  public static class SettingsBranding extends StripeObject {
    /**
     * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) An icon for
     * the account. Must be square and at least 128px x 128px.
     */
    @SerializedName("icon")
    ExpandableField<File> icon;
    /**
     * (ID of a <a href="https://stripe.com/docs/guides/file-upload">file upload</a>) A logo for the
     * account that will be used in Checkout instead of the icon and without the account's name next
     * to it if provided. Must be at least 128px x 128px.
     */
    @SerializedName("logo")
    ExpandableField<File> logo;
    /**
     * A CSS hex color value representing the primary branding color for this account.
     */
    @SerializedName("primary_color")
    String primaryColor;
    /**
     * A CSS hex color value representing the secondary branding color for this account.
     */
    @SerializedName("secondary_color")
    String secondaryColor;

    /**
     * Get ID of expandable {@code icon} object.
     */
    public String getIcon() {
      return (this.icon != null) ? this.icon.getId() : null;
    }

    public void setIcon(String id) {
      this.icon = ApiResource.setExpandableFieldId(id, this.icon);
    }

    /**
     * Get expanded {@code icon}.
     */
    public File getIconObject() {
      return (this.icon != null) ? this.icon.getExpanded() : null;
    }

    public void setIconObject(File expandableObject) {
      this.icon = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    /**
     * Get ID of expandable {@code logo} object.
     */
    public String getLogo() {
      return (this.logo != null) ? this.logo.getId() : null;
    }

    public void setLogo(String id) {
      this.logo = ApiResource.setExpandableFieldId(id, this.logo);
    }

    /**
     * Get expanded {@code logo}.
     */
    public File getLogoObject() {
      return (this.logo != null) ? this.logo.getExpanded() : null;
    }

    public void setLogoObject(File expandableObject) {
      this.logo = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    /**
     * A CSS hex color value representing the primary branding color for this account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPrimaryColor() {
      return this.primaryColor;
    }

    /**
     * A CSS hex color value representing the secondary branding color for this account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSecondaryColor() {
      return this.secondaryColor;
    }

    /**
     * A CSS hex color value representing the primary branding color for this account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPrimaryColor(final String primaryColor) {
      this.primaryColor = primaryColor;
    }

    /**
     * A CSS hex color value representing the secondary branding color for this account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSecondaryColor(final String secondaryColor) {
      this.secondaryColor = secondaryColor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.SettingsBranding)) return false;
      final Account.SettingsBranding other = (Account.SettingsBranding) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$icon = this.getIcon();
      final java.lang.Object other$icon = other.getIcon();
      if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) return false;
      final java.lang.Object this$logo = this.getLogo();
      final java.lang.Object other$logo = other.getLogo();
      if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) return false;
      final java.lang.Object this$primaryColor = this.getPrimaryColor();
      final java.lang.Object other$primaryColor = other.getPrimaryColor();
      if (this$primaryColor == null ? other$primaryColor != null : !this$primaryColor.equals(other$primaryColor)) return false;
      final java.lang.Object this$secondaryColor = this.getSecondaryColor();
      final java.lang.Object other$secondaryColor = other.getSecondaryColor();
      if (this$secondaryColor == null ? other$secondaryColor != null : !this$secondaryColor.equals(other$secondaryColor)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.SettingsBranding;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $icon = this.getIcon();
      result = result * PRIME + ($icon == null ? 43 : $icon.hashCode());
      final java.lang.Object $logo = this.getLogo();
      result = result * PRIME + ($logo == null ? 43 : $logo.hashCode());
      final java.lang.Object $primaryColor = this.getPrimaryColor();
      result = result * PRIME + ($primaryColor == null ? 43 : $primaryColor.hashCode());
      final java.lang.Object $secondaryColor = this.getSecondaryColor();
      result = result * PRIME + ($secondaryColor == null ? 43 : $secondaryColor.hashCode());
      return result;
    }
  }


  public static class SettingsCardPayments extends StripeObject {
    @SerializedName("decline_on")
    DeclineChargeOn declineOn;
    /**
     * The default text that appears on credit card statements when a charge is made. This field
     * prefixes any dynamic {@code statement_descriptor} specified on the charge. {@code
     * statement_descriptor_prefix} is useful for maximizing descriptor space for the dynamic
     * portion.
     */
    @SerializedName("statement_descriptor_prefix")
    String statementDescriptorPrefix;
    /**
     * The Kana variation of the default text that appears on credit card statements when a charge
     * is made (Japan only). This field prefixes any dynamic {@code
     * statement_descriptor_suffix_kana} specified on the charge. {@code
     * statement_descriptor_prefix_kana} is useful for maximizing descriptor space for the dynamic
     * portion.
     */
    @SerializedName("statement_descriptor_prefix_kana")
    String statementDescriptorPrefixKana;
    /**
     * The Kanji variation of the default text that appears on credit card statements when a charge
     * is made (Japan only). This field prefixes any dynamic {@code
     * statement_descriptor_suffix_kanji} specified on the charge. {@code
     * statement_descriptor_prefix_kanji} is useful for maximizing descriptor space for the dynamic
     * portion.
     */
    @SerializedName("statement_descriptor_prefix_kanji")
    String statementDescriptorPrefixKanji;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DeclineChargeOn getDeclineOn() {
      return this.declineOn;
    }

    /**
     * The default text that appears on credit card statements when a charge is made. This field
     * prefixes any dynamic {@code statement_descriptor} specified on the charge. {@code
     * statement_descriptor_prefix} is useful for maximizing descriptor space for the dynamic
     * portion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptorPrefix() {
      return this.statementDescriptorPrefix;
    }

    /**
     * The Kana variation of the default text that appears on credit card statements when a charge
     * is made (Japan only). This field prefixes any dynamic {@code
     * statement_descriptor_suffix_kana} specified on the charge. {@code
     * statement_descriptor_prefix_kana} is useful for maximizing descriptor space for the dynamic
     * portion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptorPrefixKana() {
      return this.statementDescriptorPrefixKana;
    }

    /**
     * The Kanji variation of the default text that appears on credit card statements when a charge
     * is made (Japan only). This field prefixes any dynamic {@code
     * statement_descriptor_suffix_kanji} specified on the charge. {@code
     * statement_descriptor_prefix_kanji} is useful for maximizing descriptor space for the dynamic
     * portion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptorPrefixKanji() {
      return this.statementDescriptorPrefixKanji;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDeclineOn(final DeclineChargeOn declineOn) {
      this.declineOn = declineOn;
    }

    /**
     * The default text that appears on credit card statements when a charge is made. This field
     * prefixes any dynamic {@code statement_descriptor} specified on the charge. {@code
     * statement_descriptor_prefix} is useful for maximizing descriptor space for the dynamic
     * portion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptorPrefix(final String statementDescriptorPrefix) {
      this.statementDescriptorPrefix = statementDescriptorPrefix;
    }

    /**
     * The Kana variation of the default text that appears on credit card statements when a charge
     * is made (Japan only). This field prefixes any dynamic {@code
     * statement_descriptor_suffix_kana} specified on the charge. {@code
     * statement_descriptor_prefix_kana} is useful for maximizing descriptor space for the dynamic
     * portion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptorPrefixKana(final String statementDescriptorPrefixKana) {
      this.statementDescriptorPrefixKana = statementDescriptorPrefixKana;
    }

    /**
     * The Kanji variation of the default text that appears on credit card statements when a charge
     * is made (Japan only). This field prefixes any dynamic {@code
     * statement_descriptor_suffix_kanji} specified on the charge. {@code
     * statement_descriptor_prefix_kanji} is useful for maximizing descriptor space for the dynamic
     * portion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptorPrefixKanji(final String statementDescriptorPrefixKanji) {
      this.statementDescriptorPrefixKanji = statementDescriptorPrefixKanji;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.SettingsCardPayments)) return false;
      final Account.SettingsCardPayments other = (Account.SettingsCardPayments) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$declineOn = this.getDeclineOn();
      final java.lang.Object other$declineOn = other.getDeclineOn();
      if (this$declineOn == null ? other$declineOn != null : !this$declineOn.equals(other$declineOn)) return false;
      final java.lang.Object this$statementDescriptorPrefix = this.getStatementDescriptorPrefix();
      final java.lang.Object other$statementDescriptorPrefix = other.getStatementDescriptorPrefix();
      if (this$statementDescriptorPrefix == null ? other$statementDescriptorPrefix != null : !this$statementDescriptorPrefix.equals(other$statementDescriptorPrefix)) return false;
      final java.lang.Object this$statementDescriptorPrefixKana = this.getStatementDescriptorPrefixKana();
      final java.lang.Object other$statementDescriptorPrefixKana = other.getStatementDescriptorPrefixKana();
      if (this$statementDescriptorPrefixKana == null ? other$statementDescriptorPrefixKana != null : !this$statementDescriptorPrefixKana.equals(other$statementDescriptorPrefixKana)) return false;
      final java.lang.Object this$statementDescriptorPrefixKanji = this.getStatementDescriptorPrefixKanji();
      final java.lang.Object other$statementDescriptorPrefixKanji = other.getStatementDescriptorPrefixKanji();
      if (this$statementDescriptorPrefixKanji == null ? other$statementDescriptorPrefixKanji != null : !this$statementDescriptorPrefixKanji.equals(other$statementDescriptorPrefixKanji)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.SettingsCardPayments;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $declineOn = this.getDeclineOn();
      result = result * PRIME + ($declineOn == null ? 43 : $declineOn.hashCode());
      final java.lang.Object $statementDescriptorPrefix = this.getStatementDescriptorPrefix();
      result = result * PRIME + ($statementDescriptorPrefix == null ? 43 : $statementDescriptorPrefix.hashCode());
      final java.lang.Object $statementDescriptorPrefixKana = this.getStatementDescriptorPrefixKana();
      result = result * PRIME + ($statementDescriptorPrefixKana == null ? 43 : $statementDescriptorPrefixKana.hashCode());
      final java.lang.Object $statementDescriptorPrefixKanji = this.getStatementDescriptorPrefixKanji();
      result = result * PRIME + ($statementDescriptorPrefixKanji == null ? 43 : $statementDescriptorPrefixKanji.hashCode());
      return result;
    }
  }


  public static class SettingsDashboard extends StripeObject {
    /**
     * The display name for this account. This is used on the Stripe Dashboard to differentiate
     * between accounts.
     */
    @SerializedName("display_name")
    String displayName;
    /**
     * The timezone used in the Stripe Dashboard for this account. A list of possible time zone
     * values is maintained at the <a href="http://www.iana.org/time-zones">IANA Time Zone
     * Database</a>.
     */
    @SerializedName("timezone")
    String timezone;

    /**
     * The display name for this account. This is used on the Stripe Dashboard to differentiate
     * between accounts.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisplayName() {
      return this.displayName;
    }

    /**
     * The timezone used in the Stripe Dashboard for this account. A list of possible time zone
     * values is maintained at the <a href="http://www.iana.org/time-zones">IANA Time Zone
     * Database</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTimezone() {
      return this.timezone;
    }

    /**
     * The display name for this account. This is used on the Stripe Dashboard to differentiate
     * between accounts.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisplayName(final String displayName) {
      this.displayName = displayName;
    }

    /**
     * The timezone used in the Stripe Dashboard for this account. A list of possible time zone
     * values is maintained at the <a href="http://www.iana.org/time-zones">IANA Time Zone
     * Database</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTimezone(final String timezone) {
      this.timezone = timezone;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.SettingsDashboard)) return false;
      final Account.SettingsDashboard other = (Account.SettingsDashboard) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$displayName = this.getDisplayName();
      final java.lang.Object other$displayName = other.getDisplayName();
      if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
      final java.lang.Object this$timezone = this.getTimezone();
      final java.lang.Object other$timezone = other.getTimezone();
      if (this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.SettingsDashboard;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $displayName = this.getDisplayName();
      result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
      final java.lang.Object $timezone = this.getTimezone();
      result = result * PRIME + ($timezone == null ? 43 : $timezone.hashCode());
      return result;
    }
  }


  public static class SettingsPayments extends StripeObject {
    /**
     * The default text that appears on credit card statements when a charge is made. This field
     * prefixes any dynamic {@code statement_descriptor} specified on the charge.
     */
    @SerializedName("statement_descriptor")
    String statementDescriptor;
    /**
     * The Kana variation of the default text that appears on credit card statements when a charge
     * is made (Japan only).
     */
    @SerializedName("statement_descriptor_kana")
    String statementDescriptorKana;
    /**
     * The Kanji variation of the default text that appears on credit card statements when a charge
     * is made (Japan only).
     */
    @SerializedName("statement_descriptor_kanji")
    String statementDescriptorKanji;
    /**
     * The Kana variation of the default text that appears on credit card statements when a charge
     * is made (Japan only). This field prefixes any dynamic {@code
     * statement_descriptor_suffix_kana} specified on the charge. {@code
     * statement_descriptor_prefix_kana} is useful for maximizing descriptor space for the dynamic
     * portion.
     */
    @SerializedName("statement_descriptor_prefix_kana")
    String statementDescriptorPrefixKana;
    /**
     * The Kanji variation of the default text that appears on credit card statements when a charge
     * is made (Japan only). This field prefixes any dynamic {@code
     * statement_descriptor_suffix_kanji} specified on the charge. {@code
     * statement_descriptor_prefix_kanji} is useful for maximizing descriptor space for the dynamic
     * portion.
     */
    @SerializedName("statement_descriptor_prefix_kanji")
    String statementDescriptorPrefixKanji;

    /**
     * The default text that appears on credit card statements when a charge is made. This field
     * prefixes any dynamic {@code statement_descriptor} specified on the charge.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptor() {
      return this.statementDescriptor;
    }

    /**
     * The Kana variation of the default text that appears on credit card statements when a charge
     * is made (Japan only).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptorKana() {
      return this.statementDescriptorKana;
    }

    /**
     * The Kanji variation of the default text that appears on credit card statements when a charge
     * is made (Japan only).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptorKanji() {
      return this.statementDescriptorKanji;
    }

    /**
     * The Kana variation of the default text that appears on credit card statements when a charge
     * is made (Japan only). This field prefixes any dynamic {@code
     * statement_descriptor_suffix_kana} specified on the charge. {@code
     * statement_descriptor_prefix_kana} is useful for maximizing descriptor space for the dynamic
     * portion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptorPrefixKana() {
      return this.statementDescriptorPrefixKana;
    }

    /**
     * The Kanji variation of the default text that appears on credit card statements when a charge
     * is made (Japan only). This field prefixes any dynamic {@code
     * statement_descriptor_suffix_kanji} specified on the charge. {@code
     * statement_descriptor_prefix_kanji} is useful for maximizing descriptor space for the dynamic
     * portion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptorPrefixKanji() {
      return this.statementDescriptorPrefixKanji;
    }

    /**
     * The default text that appears on credit card statements when a charge is made. This field
     * prefixes any dynamic {@code statement_descriptor} specified on the charge.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptor(final String statementDescriptor) {
      this.statementDescriptor = statementDescriptor;
    }

    /**
     * The Kana variation of the default text that appears on credit card statements when a charge
     * is made (Japan only).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptorKana(final String statementDescriptorKana) {
      this.statementDescriptorKana = statementDescriptorKana;
    }

    /**
     * The Kanji variation of the default text that appears on credit card statements when a charge
     * is made (Japan only).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptorKanji(final String statementDescriptorKanji) {
      this.statementDescriptorKanji = statementDescriptorKanji;
    }

    /**
     * The Kana variation of the default text that appears on credit card statements when a charge
     * is made (Japan only). This field prefixes any dynamic {@code
     * statement_descriptor_suffix_kana} specified on the charge. {@code
     * statement_descriptor_prefix_kana} is useful for maximizing descriptor space for the dynamic
     * portion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptorPrefixKana(final String statementDescriptorPrefixKana) {
      this.statementDescriptorPrefixKana = statementDescriptorPrefixKana;
    }

    /**
     * The Kanji variation of the default text that appears on credit card statements when a charge
     * is made (Japan only). This field prefixes any dynamic {@code
     * statement_descriptor_suffix_kanji} specified on the charge. {@code
     * statement_descriptor_prefix_kanji} is useful for maximizing descriptor space for the dynamic
     * portion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptorPrefixKanji(final String statementDescriptorPrefixKanji) {
      this.statementDescriptorPrefixKanji = statementDescriptorPrefixKanji;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.SettingsPayments)) return false;
      final Account.SettingsPayments other = (Account.SettingsPayments) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
      final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
      if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
      final java.lang.Object this$statementDescriptorKana = this.getStatementDescriptorKana();
      final java.lang.Object other$statementDescriptorKana = other.getStatementDescriptorKana();
      if (this$statementDescriptorKana == null ? other$statementDescriptorKana != null : !this$statementDescriptorKana.equals(other$statementDescriptorKana)) return false;
      final java.lang.Object this$statementDescriptorKanji = this.getStatementDescriptorKanji();
      final java.lang.Object other$statementDescriptorKanji = other.getStatementDescriptorKanji();
      if (this$statementDescriptorKanji == null ? other$statementDescriptorKanji != null : !this$statementDescriptorKanji.equals(other$statementDescriptorKanji)) return false;
      final java.lang.Object this$statementDescriptorPrefixKana = this.getStatementDescriptorPrefixKana();
      final java.lang.Object other$statementDescriptorPrefixKana = other.getStatementDescriptorPrefixKana();
      if (this$statementDescriptorPrefixKana == null ? other$statementDescriptorPrefixKana != null : !this$statementDescriptorPrefixKana.equals(other$statementDescriptorPrefixKana)) return false;
      final java.lang.Object this$statementDescriptorPrefixKanji = this.getStatementDescriptorPrefixKanji();
      final java.lang.Object other$statementDescriptorPrefixKanji = other.getStatementDescriptorPrefixKanji();
      if (this$statementDescriptorPrefixKanji == null ? other$statementDescriptorPrefixKanji != null : !this$statementDescriptorPrefixKanji.equals(other$statementDescriptorPrefixKanji)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.SettingsPayments;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
      result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
      final java.lang.Object $statementDescriptorKana = this.getStatementDescriptorKana();
      result = result * PRIME + ($statementDescriptorKana == null ? 43 : $statementDescriptorKana.hashCode());
      final java.lang.Object $statementDescriptorKanji = this.getStatementDescriptorKanji();
      result = result * PRIME + ($statementDescriptorKanji == null ? 43 : $statementDescriptorKanji.hashCode());
      final java.lang.Object $statementDescriptorPrefixKana = this.getStatementDescriptorPrefixKana();
      result = result * PRIME + ($statementDescriptorPrefixKana == null ? 43 : $statementDescriptorPrefixKana.hashCode());
      final java.lang.Object $statementDescriptorPrefixKanji = this.getStatementDescriptorPrefixKanji();
      result = result * PRIME + ($statementDescriptorPrefixKanji == null ? 43 : $statementDescriptorPrefixKanji.hashCode());
      return result;
    }
  }


  public static class SettingsPayouts extends StripeObject {
    /**
     * A Boolean indicating if Stripe should try to reclaim negative balances from an attached bank
     * account. See our <a href="https://stripe.com/docs/connect/account-balances">Understanding
     * Connect Account Balances</a> documentation for details. Default value is {@code false} for
     * Custom accounts, otherwise {@code true}.
     */
    @SerializedName("debit_negative_balances")
    Boolean debitNegativeBalances;
    @SerializedName("schedule")
    PayoutSchedule schedule;
    /**
     * The text that appears on the bank account statement for payouts. If not set, this defaults to
     * the platform's bank descriptor as set in the Dashboard.
     */
    @SerializedName("statement_descriptor")
    String statementDescriptor;

    /**
     * A Boolean indicating if Stripe should try to reclaim negative balances from an attached bank
     * account. See our <a href="https://stripe.com/docs/connect/account-balances">Understanding
     * Connect Account Balances</a> documentation for details. Default value is {@code false} for
     * Custom accounts, otherwise {@code true}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getDebitNegativeBalances() {
      return this.debitNegativeBalances;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PayoutSchedule getSchedule() {
      return this.schedule;
    }

    /**
     * The text that appears on the bank account statement for payouts. If not set, this defaults to
     * the platform's bank descriptor as set in the Dashboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatementDescriptor() {
      return this.statementDescriptor;
    }

    /**
     * A Boolean indicating if Stripe should try to reclaim negative balances from an attached bank
     * account. See our <a href="https://stripe.com/docs/connect/account-balances">Understanding
     * Connect Account Balances</a> documentation for details. Default value is {@code false} for
     * Custom accounts, otherwise {@code true}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDebitNegativeBalances(final Boolean debitNegativeBalances) {
      this.debitNegativeBalances = debitNegativeBalances;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSchedule(final PayoutSchedule schedule) {
      this.schedule = schedule;
    }

    /**
     * The text that appears on the bank account statement for payouts. If not set, this defaults to
     * the platform's bank descriptor as set in the Dashboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatementDescriptor(final String statementDescriptor) {
      this.statementDescriptor = statementDescriptor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.SettingsPayouts)) return false;
      final Account.SettingsPayouts other = (Account.SettingsPayouts) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$debitNegativeBalances = this.getDebitNegativeBalances();
      final java.lang.Object other$debitNegativeBalances = other.getDebitNegativeBalances();
      if (this$debitNegativeBalances == null ? other$debitNegativeBalances != null : !this$debitNegativeBalances.equals(other$debitNegativeBalances)) return false;
      final java.lang.Object this$schedule = this.getSchedule();
      final java.lang.Object other$schedule = other.getSchedule();
      if (this$schedule == null ? other$schedule != null : !this$schedule.equals(other$schedule)) return false;
      final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
      final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
      if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.SettingsPayouts;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $debitNegativeBalances = this.getDebitNegativeBalances();
      result = result * PRIME + ($debitNegativeBalances == null ? 43 : $debitNegativeBalances.hashCode());
      final java.lang.Object $schedule = this.getSchedule();
      result = result * PRIME + ($schedule == null ? 43 : $schedule.hashCode());
      final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
      result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
      return result;
    }
  }


  public static class TosAcceptance extends StripeObject {
    /**
     * The Unix timestamp marking when the account representative accepted their service agreement.
     */
    @SerializedName("date")
    Long date;
    /** The IP address from which the account representative accepted their service agreement. */
    @SerializedName("ip")
    String ip;
    /** The user's service agreement type. */
    @SerializedName("service_agreement")
    String serviceAgreement;
    /**
     * The user agent of the browser from which the account representative accepted their service
     * agreement.
     */
    @SerializedName("user_agent")
    String userAgent;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDate() {
      return this.date;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIp() {
      return this.ip;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getServiceAgreement() {
      return this.serviceAgreement;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUserAgent() {
      return this.userAgent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDate(final Long date) {
      this.date = date;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIp(final String ip) {
      this.ip = ip;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setServiceAgreement(final String serviceAgreement) {
      this.serviceAgreement = serviceAgreement;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUserAgent(final String userAgent) {
      this.userAgent = userAgent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.TosAcceptance)) return false;
      final Account.TosAcceptance other = (Account.TosAcceptance) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$date = this.getDate();
      final java.lang.Object other$date = other.getDate();
      if (this$date == null ? other$date != null : !this$date.equals(other$date)) return false;
      final java.lang.Object this$ip = this.getIp();
      final java.lang.Object other$ip = other.getIp();
      if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) return false;
      final java.lang.Object this$serviceAgreement = this.getServiceAgreement();
      final java.lang.Object other$serviceAgreement = other.getServiceAgreement();
      if (this$serviceAgreement == null ? other$serviceAgreement != null : !this$serviceAgreement.equals(other$serviceAgreement)) return false;
      final java.lang.Object this$userAgent = this.getUserAgent();
      final java.lang.Object other$userAgent = other.getUserAgent();
      if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.TosAcceptance;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $date = this.getDate();
      result = result * PRIME + ($date == null ? 43 : $date.hashCode());
      final java.lang.Object $ip = this.getIp();
      result = result * PRIME + ($ip == null ? 43 : $ip.hashCode());
      final java.lang.Object $serviceAgreement = this.getServiceAgreement();
      result = result * PRIME + ($serviceAgreement == null ? 43 : $serviceAgreement.hashCode());
      final java.lang.Object $userAgent = this.getUserAgent();
      result = result * PRIME + ($userAgent == null ? 43 : $userAgent.hashCode());
      return result;
    }
  }

  /**
   * Business information about the account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BusinessProfile getBusinessProfile() {
    return this.businessProfile;
  }

  /**
   * The business type.
   *
   * <p>One of {@code company}, {@code government_entity}, {@code individual}, or {@code
   * non_profit}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBusinessType() {
    return this.businessType;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Capabilities getCapabilities() {
    return this.capabilities;
  }

  /**
   * Whether the account can create live charges.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getChargesEnabled() {
    return this.chargesEnabled;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Company getCompany() {
    return this.company;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Controller getController() {
    return this.controller;
  }

  /**
   * The account's country.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCountry() {
    return this.country;
  }

  /**
   * Time at which the account was connected. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter ISO currency code representing the default currency for the account. This must be
   * a currency that <a href="https://stripe.com/docs/payouts">Stripe supports in the account's
   * country</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDefaultCurrency() {
    return this.defaultCurrency;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * Whether account details have been submitted. Standard accounts cannot receive payouts before
   * this is true.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDetailsSubmitted() {
    return this.detailsSubmitted;
  }

  /**
   * An email address associated with the account. You can treat this as metadata: it is not used
   * for authentication or messaging account holders.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEmail() {
    return this.email;
  }

  /**
   * External accounts (bank accounts and debit cards) currently attached to this account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ExternalAccountCollection getExternalAccounts() {
    return this.externalAccounts;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public FutureRequirements getFutureRequirements() {
    return this.futureRequirements;
  }

  /**
   * This is an object representing a person associated with a Stripe account.
   *
   * <p>A platform cannot access a Standard or Express account's persons after the account starts
   * onboarding, such as after generating an account link for the account. See the <a
   * href="https://stripe.com/docs/connect/standard-accounts">Standard onboarding</a> or <a
   * href="https://stripe.com/docs/connect/express-accounts">Express onboarding documentation</a>
   * for information about platform pre-filling and account onboarding steps.
   *
   * <p>Related guide: <a
   * href="https://stripe.com/docs/connect/identity-verification-api#person-information">Handling
   * Identity Verification with the API</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Person getIndividual() {
    return this.individual;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code account}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Whether Stripe can send payouts to this account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getPayoutsEnabled() {
    return this.payoutsEnabled;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Requirements getRequirements() {
    return this.requirements;
  }

  /**
   * Options for customizing how the account functions within Stripe.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Settings getSettings() {
    return this.settings;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TosAcceptance getTosAcceptance() {
    return this.tosAcceptance;
  }

  /**
   * The Stripe account type. Can be {@code standard}, {@code express}, or {@code custom}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }

  /**
   * Business information about the account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBusinessProfile(final BusinessProfile businessProfile) {
    this.businessProfile = businessProfile;
  }

  /**
   * The business type.
   *
   * <p>One of {@code company}, {@code government_entity}, {@code individual}, or {@code
   * non_profit}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBusinessType(final String businessType) {
    this.businessType = businessType;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCapabilities(final Capabilities capabilities) {
    this.capabilities = capabilities;
  }

  /**
   * Whether the account can create live charges.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setChargesEnabled(final Boolean chargesEnabled) {
    this.chargesEnabled = chargesEnabled;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCompany(final Company company) {
    this.company = company;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setController(final Controller controller) {
    this.controller = controller;
  }

  /**
   * The account's country.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCountry(final String country) {
    this.country = country;
  }

  /**
   * Time at which the account was connected. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter ISO currency code representing the default currency for the account. This must be
   * a currency that <a href="https://stripe.com/docs/payouts">Stripe supports in the account's
   * country</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDefaultCurrency(final String defaultCurrency) {
    this.defaultCurrency = defaultCurrency;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * Whether account details have been submitted. Standard accounts cannot receive payouts before
   * this is true.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDetailsSubmitted(final Boolean detailsSubmitted) {
    this.detailsSubmitted = detailsSubmitted;
  }

  /**
   * An email address associated with the account. You can treat this as metadata: it is not used
   * for authentication or messaging account holders.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEmail(final String email) {
    this.email = email;
  }

  /**
   * External accounts (bank accounts and debit cards) currently attached to this account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setExternalAccounts(final ExternalAccountCollection externalAccounts) {
    this.externalAccounts = externalAccounts;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFutureRequirements(final FutureRequirements futureRequirements) {
    this.futureRequirements = futureRequirements;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * This is an object representing a person associated with a Stripe account.
   *
   * <p>A platform cannot access a Standard or Express account's persons after the account starts
   * onboarding, such as after generating an account link for the account. See the <a
   * href="https://stripe.com/docs/connect/standard-accounts">Standard onboarding</a> or <a
   * href="https://stripe.com/docs/connect/express-accounts">Express onboarding documentation</a>
   * for information about platform pre-filling and account onboarding steps.
   *
   * <p>Related guide: <a
   * href="https://stripe.com/docs/connect/identity-verification-api#person-information">Handling
   * Identity Verification with the API</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIndividual(final Person individual) {
    this.individual = individual;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code account}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Whether Stripe can send payouts to this account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPayoutsEnabled(final Boolean payoutsEnabled) {
    this.payoutsEnabled = payoutsEnabled;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRequirements(final Requirements requirements) {
    this.requirements = requirements;
  }

  /**
   * Options for customizing how the account functions within Stripe.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSettings(final Settings settings) {
    this.settings = settings;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTosAcceptance(final TosAcceptance tosAcceptance) {
    this.tosAcceptance = tosAcceptance;
  }

  /**
   * The Stripe account type. Can be {@code standard}, {@code express}, or {@code custom}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setType(final String type) {
    this.type = type;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Account)) return false;
    final Account other = (Account) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$chargesEnabled = this.getChargesEnabled();
    final java.lang.Object other$chargesEnabled = other.getChargesEnabled();
    if (this$chargesEnabled == null ? other$chargesEnabled != null : !this$chargesEnabled.equals(other$chargesEnabled)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$detailsSubmitted = this.getDetailsSubmitted();
    final java.lang.Object other$detailsSubmitted = other.getDetailsSubmitted();
    if (this$detailsSubmitted == null ? other$detailsSubmitted != null : !this$detailsSubmitted.equals(other$detailsSubmitted)) return false;
    final java.lang.Object this$payoutsEnabled = this.getPayoutsEnabled();
    final java.lang.Object other$payoutsEnabled = other.getPayoutsEnabled();
    if (this$payoutsEnabled == null ? other$payoutsEnabled != null : !this$payoutsEnabled.equals(other$payoutsEnabled)) return false;
    final java.lang.Object this$businessProfile = this.getBusinessProfile();
    final java.lang.Object other$businessProfile = other.getBusinessProfile();
    if (this$businessProfile == null ? other$businessProfile != null : !this$businessProfile.equals(other$businessProfile)) return false;
    final java.lang.Object this$businessType = this.getBusinessType();
    final java.lang.Object other$businessType = other.getBusinessType();
    if (this$businessType == null ? other$businessType != null : !this$businessType.equals(other$businessType)) return false;
    final java.lang.Object this$capabilities = this.getCapabilities();
    final java.lang.Object other$capabilities = other.getCapabilities();
    if (this$capabilities == null ? other$capabilities != null : !this$capabilities.equals(other$capabilities)) return false;
    final java.lang.Object this$company = this.getCompany();
    final java.lang.Object other$company = other.getCompany();
    if (this$company == null ? other$company != null : !this$company.equals(other$company)) return false;
    final java.lang.Object this$controller = this.getController();
    final java.lang.Object other$controller = other.getController();
    if (this$controller == null ? other$controller != null : !this$controller.equals(other$controller)) return false;
    final java.lang.Object this$country = this.getCountry();
    final java.lang.Object other$country = other.getCountry();
    if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
    final java.lang.Object this$defaultCurrency = this.getDefaultCurrency();
    final java.lang.Object other$defaultCurrency = other.getDefaultCurrency();
    if (this$defaultCurrency == null ? other$defaultCurrency != null : !this$defaultCurrency.equals(other$defaultCurrency)) return false;
    final java.lang.Object this$email = this.getEmail();
    final java.lang.Object other$email = other.getEmail();
    if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
    final java.lang.Object this$externalAccounts = this.getExternalAccounts();
    final java.lang.Object other$externalAccounts = other.getExternalAccounts();
    if (this$externalAccounts == null ? other$externalAccounts != null : !this$externalAccounts.equals(other$externalAccounts)) return false;
    final java.lang.Object this$futureRequirements = this.getFutureRequirements();
    final java.lang.Object other$futureRequirements = other.getFutureRequirements();
    if (this$futureRequirements == null ? other$futureRequirements != null : !this$futureRequirements.equals(other$futureRequirements)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$individual = this.getIndividual();
    final java.lang.Object other$individual = other.getIndividual();
    if (this$individual == null ? other$individual != null : !this$individual.equals(other$individual)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$requirements = this.getRequirements();
    final java.lang.Object other$requirements = other.getRequirements();
    if (this$requirements == null ? other$requirements != null : !this$requirements.equals(other$requirements)) return false;
    final java.lang.Object this$settings = this.getSettings();
    final java.lang.Object other$settings = other.getSettings();
    if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) return false;
    final java.lang.Object this$tosAcceptance = this.getTosAcceptance();
    final java.lang.Object other$tosAcceptance = other.getTosAcceptance();
    if (this$tosAcceptance == null ? other$tosAcceptance != null : !this$tosAcceptance.equals(other$tosAcceptance)) return false;
    final java.lang.Object this$type = this.getType();
    final java.lang.Object other$type = other.getType();
    if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Account;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $chargesEnabled = this.getChargesEnabled();
    result = result * PRIME + ($chargesEnabled == null ? 43 : $chargesEnabled.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $detailsSubmitted = this.getDetailsSubmitted();
    result = result * PRIME + ($detailsSubmitted == null ? 43 : $detailsSubmitted.hashCode());
    final java.lang.Object $payoutsEnabled = this.getPayoutsEnabled();
    result = result * PRIME + ($payoutsEnabled == null ? 43 : $payoutsEnabled.hashCode());
    final java.lang.Object $businessProfile = this.getBusinessProfile();
    result = result * PRIME + ($businessProfile == null ? 43 : $businessProfile.hashCode());
    final java.lang.Object $businessType = this.getBusinessType();
    result = result * PRIME + ($businessType == null ? 43 : $businessType.hashCode());
    final java.lang.Object $capabilities = this.getCapabilities();
    result = result * PRIME + ($capabilities == null ? 43 : $capabilities.hashCode());
    final java.lang.Object $company = this.getCompany();
    result = result * PRIME + ($company == null ? 43 : $company.hashCode());
    final java.lang.Object $controller = this.getController();
    result = result * PRIME + ($controller == null ? 43 : $controller.hashCode());
    final java.lang.Object $country = this.getCountry();
    result = result * PRIME + ($country == null ? 43 : $country.hashCode());
    final java.lang.Object $defaultCurrency = this.getDefaultCurrency();
    result = result * PRIME + ($defaultCurrency == null ? 43 : $defaultCurrency.hashCode());
    final java.lang.Object $email = this.getEmail();
    result = result * PRIME + ($email == null ? 43 : $email.hashCode());
    final java.lang.Object $externalAccounts = this.getExternalAccounts();
    result = result * PRIME + ($externalAccounts == null ? 43 : $externalAccounts.hashCode());
    final java.lang.Object $futureRequirements = this.getFutureRequirements();
    result = result * PRIME + ($futureRequirements == null ? 43 : $futureRequirements.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $individual = this.getIndividual();
    result = result * PRIME + ($individual == null ? 43 : $individual.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $requirements = this.getRequirements();
    result = result * PRIME + ($requirements == null ? 43 : $requirements.hashCode());
    final java.lang.Object $settings = this.getSettings();
    result = result * PRIME + ($settings == null ? 43 : $settings.hashCode());
    final java.lang.Object $tosAcceptance = this.getTosAcceptance();
    result = result * PRIME + ($tosAcceptance == null ? 43 : $tosAcceptance.hashCode());
    final java.lang.Object $type = this.getType();
    result = result * PRIME + ($type == null ? 43 : $type.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
