// Generated by delombok at Fri Nov 04 15:31:23 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.treasury.DebitReversalCreateParams;
import com.stripe.param.treasury.DebitReversalListParams;
import com.stripe.param.treasury.DebitReversalRetrieveParams;
import java.util.Map;

/**
 * You can reverse some <a href="https://stripe.com/docs/api#received_debits">ReceivedDebits</a>
 * depending on their network and source flow. Reversing a ReceivedDebit leads to the creation of a
 * new object known as a DebitReversal.
 */
public class DebitReversal extends ApiResource implements HasId {
  /**
   * Amount (in cents) transferred.
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * The FinancialAccount to reverse funds from.
   */
  @SerializedName("financial_account")
  String financialAccount;
  /**
   * A <a href="https://stripe.com/docs/treasury/moving-money/regulatory-receipts">hosted
   * transaction receipt</a> URL that is provided when money movement is considered regulated under
   * Stripe's money transmission licenses.
   */
  @SerializedName("hosted_regulatory_receipt_url")
  String hostedRegulatoryReceiptUrl;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Other flows linked to a DebitReversal.
   */
  @SerializedName("linked_flows")
  LinkedFlows linkedFlows;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * The rails used to reverse the funds.
   *
   * <p>One of {@code ach}, or {@code card}.
   */
  @SerializedName("network")
  String network;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.debit_reversal}.
   */
  @SerializedName("object")
  String object;
  /**
   * The ReceivedDebit being reversed.
   */
  @SerializedName("received_debit")
  String receivedDebit;
  /**
   * Status of the DebitReversal
   *
   * <p>One of {@code failed}, {@code processing}, or {@code succeeded}.
   */
  @SerializedName("status")
  String status;
  @SerializedName("status_transitions")
  StatusTransitions statusTransitions;
  /**
   * The Transaction associated with this object.
   */
  @SerializedName("transaction")
  ExpandableField<Transaction> transaction;

  /**
   * Get ID of expandable {@code transaction} object.
   */
  public String getTransaction() {
    return (this.transaction != null) ? this.transaction.getId() : null;
  }

  public void setTransaction(String id) {
    this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
  }

  /**
   * Get expanded {@code transaction}.
   */
  public Transaction getTransactionObject() {
    return (this.transaction != null) ? this.transaction.getExpanded() : null;
  }

  public void setTransactionObject(Transaction expandableObject) {
    this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
  }

  /**
   * Reverses a ReceivedDebit and creates a DebitReversal object.
   */
  public static DebitReversal create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Reverses a ReceivedDebit and creates a DebitReversal object.
   */
  public static DebitReversal create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/debit_reversals");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, DebitReversal.class, options);
  }

  /**
   * Reverses a ReceivedDebit and creates a DebitReversal object.
   */
  public static DebitReversal create(DebitReversalCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Reverses a ReceivedDebit and creates a DebitReversal object.
   */
  public static DebitReversal create(DebitReversalCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/debit_reversals");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, DebitReversal.class, options);
  }

  /**
   * Returns a list of DebitReversals.
   */
  public static DebitReversalCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of DebitReversals.
   */
  public static DebitReversalCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/debit_reversals");
    return ApiResource.requestCollection(url, params, DebitReversalCollection.class, options);
  }

  /**
   * Returns a list of DebitReversals.
   */
  public static DebitReversalCollection list(DebitReversalListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of DebitReversals.
   */
  public static DebitReversalCollection list(DebitReversalListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/debit_reversals");
    return ApiResource.requestCollection(url, params, DebitReversalCollection.class, options);
  }

  /**
   * Retrieves a DebitReversal object.
   */
  public static DebitReversal retrieve(String debitReversal) throws StripeException {
    return retrieve(debitReversal, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves a DebitReversal object.
   */
  public static DebitReversal retrieve(String debitReversal, RequestOptions options) throws StripeException {
    return retrieve(debitReversal, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves a DebitReversal object.
   */
  public static DebitReversal retrieve(String debitReversal, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/debit_reversals/%s", ApiResource.urlEncodeId(debitReversal)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, DebitReversal.class, options);
  }

  /**
   * Retrieves a DebitReversal object.
   */
  public static DebitReversal retrieve(String debitReversal, DebitReversalRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/debit_reversals/%s", ApiResource.urlEncodeId(debitReversal)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, DebitReversal.class, options);
  }


  public static class LinkedFlows extends StripeObject {
    /**
     * Set if there is an Issuing dispute associated with the DebitReversal.
     */
    @SerializedName("issuing_dispute")
    String issuingDispute;

    /**
     * Set if there is an Issuing dispute associated with the DebitReversal.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIssuingDispute() {
      return this.issuingDispute;
    }

    /**
     * Set if there is an Issuing dispute associated with the DebitReversal.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIssuingDispute(final String issuingDispute) {
      this.issuingDispute = issuingDispute;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof DebitReversal.LinkedFlows)) return false;
      final DebitReversal.LinkedFlows other = (DebitReversal.LinkedFlows) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$issuingDispute = this.getIssuingDispute();
      final java.lang.Object other$issuingDispute = other.getIssuingDispute();
      if (this$issuingDispute == null ? other$issuingDispute != null : !this$issuingDispute.equals(other$issuingDispute)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof DebitReversal.LinkedFlows;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $issuingDispute = this.getIssuingDispute();
      result = result * PRIME + ($issuingDispute == null ? 43 : $issuingDispute.hashCode());
      return result;
    }
  }


  public static class StatusTransitions extends StripeObject {
    /** Timestamp describing when the DebitReversal changed status to {@code completed}. */
    @SerializedName("completed_at")
    Long completedAt;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCompletedAt() {
      return this.completedAt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCompletedAt(final Long completedAt) {
      this.completedAt = completedAt;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof DebitReversal.StatusTransitions)) return false;
      final DebitReversal.StatusTransitions other = (DebitReversal.StatusTransitions) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$completedAt = this.getCompletedAt();
      final java.lang.Object other$completedAt = other.getCompletedAt();
      if (this$completedAt == null ? other$completedAt != null : !this$completedAt.equals(other$completedAt)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof DebitReversal.StatusTransitions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $completedAt = this.getCompletedAt();
      result = result * PRIME + ($completedAt == null ? 43 : $completedAt.hashCode());
      return result;
    }
  }

  /**
   * Amount (in cents) transferred.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * The FinancialAccount to reverse funds from.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFinancialAccount() {
    return this.financialAccount;
  }

  /**
   * A <a href="https://stripe.com/docs/treasury/moving-money/regulatory-receipts">hosted
   * transaction receipt</a> URL that is provided when money movement is considered regulated under
   * Stripe's money transmission licenses.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHostedRegulatoryReceiptUrl() {
    return this.hostedRegulatoryReceiptUrl;
  }

  /**
   * Other flows linked to a DebitReversal.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LinkedFlows getLinkedFlows() {
    return this.linkedFlows;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }

  /**
   * The rails used to reverse the funds.
   *
   * <p>One of {@code ach}, or {@code card}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getNetwork() {
    return this.network;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.debit_reversal}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The ReceivedDebit being reversed.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReceivedDebit() {
    return this.receivedDebit;
  }

  /**
   * Status of the DebitReversal
   *
   * <p>One of {@code failed}, {@code processing}, or {@code succeeded}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public StatusTransitions getStatusTransitions() {
    return this.statusTransitions;
  }

  /**
   * Amount (in cents) transferred.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * The FinancialAccount to reverse funds from.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinancialAccount(final String financialAccount) {
    this.financialAccount = financialAccount;
  }

  /**
   * A <a href="https://stripe.com/docs/treasury/moving-money/regulatory-receipts">hosted
   * transaction receipt</a> URL that is provided when money movement is considered regulated under
   * Stripe's money transmission licenses.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHostedRegulatoryReceiptUrl(final String hostedRegulatoryReceiptUrl) {
    this.hostedRegulatoryReceiptUrl = hostedRegulatoryReceiptUrl;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Other flows linked to a DebitReversal.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLinkedFlows(final LinkedFlows linkedFlows) {
    this.linkedFlows = linkedFlows;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * The rails used to reverse the funds.
   *
   * <p>One of {@code ach}, or {@code card}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNetwork(final String network) {
    this.network = network;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.debit_reversal}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The ReceivedDebit being reversed.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReceivedDebit(final String receivedDebit) {
    this.receivedDebit = receivedDebit;
  }

  /**
   * Status of the DebitReversal
   *
   * <p>One of {@code failed}, {@code processing}, or {@code succeeded}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatusTransitions(final StatusTransitions statusTransitions) {
    this.statusTransitions = statusTransitions;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof DebitReversal)) return false;
    final DebitReversal other = (DebitReversal) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$financialAccount = this.getFinancialAccount();
    final java.lang.Object other$financialAccount = other.getFinancialAccount();
    if (this$financialAccount == null ? other$financialAccount != null : !this$financialAccount.equals(other$financialAccount)) return false;
    final java.lang.Object this$hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
    final java.lang.Object other$hostedRegulatoryReceiptUrl = other.getHostedRegulatoryReceiptUrl();
    if (this$hostedRegulatoryReceiptUrl == null ? other$hostedRegulatoryReceiptUrl != null : !this$hostedRegulatoryReceiptUrl.equals(other$hostedRegulatoryReceiptUrl)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$linkedFlows = this.getLinkedFlows();
    final java.lang.Object other$linkedFlows = other.getLinkedFlows();
    if (this$linkedFlows == null ? other$linkedFlows != null : !this$linkedFlows.equals(other$linkedFlows)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$network = this.getNetwork();
    final java.lang.Object other$network = other.getNetwork();
    if (this$network == null ? other$network != null : !this$network.equals(other$network)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$receivedDebit = this.getReceivedDebit();
    final java.lang.Object other$receivedDebit = other.getReceivedDebit();
    if (this$receivedDebit == null ? other$receivedDebit != null : !this$receivedDebit.equals(other$receivedDebit)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$statusTransitions = this.getStatusTransitions();
    final java.lang.Object other$statusTransitions = other.getStatusTransitions();
    if (this$statusTransitions == null ? other$statusTransitions != null : !this$statusTransitions.equals(other$statusTransitions)) return false;
    final java.lang.Object this$transaction = this.getTransaction();
    final java.lang.Object other$transaction = other.getTransaction();
    if (this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof DebitReversal;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $financialAccount = this.getFinancialAccount();
    result = result * PRIME + ($financialAccount == null ? 43 : $financialAccount.hashCode());
    final java.lang.Object $hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
    result = result * PRIME + ($hostedRegulatoryReceiptUrl == null ? 43 : $hostedRegulatoryReceiptUrl.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $linkedFlows = this.getLinkedFlows();
    result = result * PRIME + ($linkedFlows == null ? 43 : $linkedFlows.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $network = this.getNetwork();
    result = result * PRIME + ($network == null ? 43 : $network.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $receivedDebit = this.getReceivedDebit();
    result = result * PRIME + ($receivedDebit == null ? 43 : $receivedDebit.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $statusTransitions = this.getStatusTransitions();
    result = result * PRIME + ($statusTransitions == null ? 43 : $statusTransitions.hashCode());
    final java.lang.Object $transaction = this.getTransaction();
    result = result * PRIME + ($transaction == null ? 43 : $transaction.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
