// Generated by delombok at Tue Nov 08 20:35:27 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.testhelpers;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.testhelpers.TestClockAdvanceParams;
import com.stripe.param.testhelpers.TestClockCreateParams;
import com.stripe.param.testhelpers.TestClockListParams;
import com.stripe.param.testhelpers.TestClockRetrieveParams;
import java.util.Map;

/**
 * A test clock enables deterministic control over objects in testmode. With a test clock, you can
 * create objects at a frozen time in the past or future, and advance to a specific future time to
 * observe webhooks and state changes. After the clock advances, you can either validate the current
 * state of your scenario (and test your assumptions), change the current state of your scenario
 * (and test more complex scenarios), or keep advancing forward in time.
 */
public class TestClock extends ApiResource implements HasId {
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Always true for a deleted object.
   */
  @SerializedName("deleted")
  Boolean deleted;
  /**
   * Time at which this clock is scheduled to auto delete.
   */
  @SerializedName("deletes_after")
  Long deletesAfter;
  /**
   * Time at which all objects belonging to this clock are frozen.
   */
  @SerializedName("frozen_time")
  Long frozenTime;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * The custom name supplied at creation.
   */
  @SerializedName("name")
  String name;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code test_helpers.test_clock}.
   */
  @SerializedName("object")
  String object;
  /**
   * The status of the Test Clock.
   *
   * <p>One of {@code advancing}, {@code internal_failure}, or {@code ready}.
   */
  @SerializedName("status")
  String status;

  /**
   * Starts advancing a test clock to a specified time in the future. Advancement is done when
   * status changes to <code>Ready</code>.
   */
  public TestClock advance(Map<String, Object> params) throws StripeException {
    return advance(params, (RequestOptions) null);
  }

  /**
   * Starts advancing a test clock to a specified time in the future. Advancement is done when
   * status changes to <code>Ready</code>.
   */
  public TestClock advance(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/test_clocks/%s/advance", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, TestClock.class, options);
  }

  /**
   * Starts advancing a test clock to a specified time in the future. Advancement is done when
   * status changes to <code>Ready</code>.
   */
  public TestClock advance(TestClockAdvanceParams params) throws StripeException {
    return advance(params, (RequestOptions) null);
  }

  /**
   * Starts advancing a test clock to a specified time in the future. Advancement is done when
   * status changes to <code>Ready</code>.
   */
  public TestClock advance(TestClockAdvanceParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/test_clocks/%s/advance", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, TestClock.class, options);
  }

  /**
   * Creates a new test clock that can be attached to new customers and quotes.
   */
  public static TestClock create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new test clock that can be attached to new customers and quotes.
   */
  public static TestClock create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/test_helpers/test_clocks");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, TestClock.class, options);
  }

  /**
   * Creates a new test clock that can be attached to new customers and quotes.
   */
  public static TestClock create(TestClockCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new test clock that can be attached to new customers and quotes.
   */
  public static TestClock create(TestClockCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/test_helpers/test_clocks");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, TestClock.class, options);
  }

  /**
   * Deletes a test clock.
   */
  public TestClock delete() throws StripeException {
    return delete((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Deletes a test clock.
   */
  public TestClock delete(RequestOptions options) throws StripeException {
    return delete((Map<String, Object>) null, options);
  }

  /**
   * Deletes a test clock.
   */
  public TestClock delete(Map<String, Object> params) throws StripeException {
    return delete(params, (RequestOptions) null);
  }

  /**
   * Deletes a test clock.
   */
  public TestClock delete(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/test_clocks/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, TestClock.class, options);
  }

  /**
   * Returns a list of your test clocks.
   */
  public static TestClockCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your test clocks.
   */
  public static TestClockCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/test_helpers/test_clocks");
    return ApiResource.requestCollection(url, params, TestClockCollection.class, options);
  }

  /**
   * Returns a list of your test clocks.
   */
  public static TestClockCollection list(TestClockListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your test clocks.
   */
  public static TestClockCollection list(TestClockListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/test_helpers/test_clocks");
    return ApiResource.requestCollection(url, params, TestClockCollection.class, options);
  }

  /**
   * Retrieves a test clock.
   */
  public static TestClock retrieve(String testClock) throws StripeException {
    return retrieve(testClock, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves a test clock.
   */
  public static TestClock retrieve(String testClock, RequestOptions options) throws StripeException {
    return retrieve(testClock, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves a test clock.
   */
  public static TestClock retrieve(String testClock, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/test_clocks/%s", ApiResource.urlEncodeId(testClock)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, TestClock.class, options);
  }

  /**
   * Retrieves a test clock.
   */
  public static TestClock retrieve(String testClock, TestClockRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/test_clocks/%s", ApiResource.urlEncodeId(testClock)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, TestClock.class, options);
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * Time at which this clock is scheduled to auto delete.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getDeletesAfter() {
    return this.deletesAfter;
  }

  /**
   * Time at which all objects belonging to this clock are frozen.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getFrozenTime() {
    return this.frozenTime;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * The custom name supplied at creation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getName() {
    return this.name;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code test_helpers.test_clock}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The status of the Test Clock.
   *
   * <p>One of {@code advancing}, {@code internal_failure}, or {@code ready}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Always true for a deleted object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeleted(final Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * Time at which this clock is scheduled to auto delete.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeletesAfter(final Long deletesAfter) {
    this.deletesAfter = deletesAfter;
  }

  /**
   * Time at which all objects belonging to this clock are frozen.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFrozenTime(final Long frozenTime) {
    this.frozenTime = frozenTime;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * The custom name supplied at creation.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setName(final String name) {
    this.name = name;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code test_helpers.test_clock}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The status of the Test Clock.
   *
   * <p>One of {@code advancing}, {@code internal_failure}, or {@code ready}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof TestClock)) return false;
    final TestClock other = (TestClock) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$deleted = this.getDeleted();
    final java.lang.Object other$deleted = other.getDeleted();
    if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) return false;
    final java.lang.Object this$deletesAfter = this.getDeletesAfter();
    final java.lang.Object other$deletesAfter = other.getDeletesAfter();
    if (this$deletesAfter == null ? other$deletesAfter != null : !this$deletesAfter.equals(other$deletesAfter)) return false;
    final java.lang.Object this$frozenTime = this.getFrozenTime();
    final java.lang.Object other$frozenTime = other.getFrozenTime();
    if (this$frozenTime == null ? other$frozenTime != null : !this$frozenTime.equals(other$frozenTime)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$name = this.getName();
    final java.lang.Object other$name = other.getName();
    if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof TestClock;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $deleted = this.getDeleted();
    result = result * PRIME + ($deleted == null ? 43 : $deleted.hashCode());
    final java.lang.Object $deletesAfter = this.getDeletesAfter();
    result = result * PRIME + ($deletesAfter == null ? 43 : $deletesAfter.hashCode());
    final java.lang.Object $frozenTime = this.getFrozenTime();
    result = result * PRIME + ($frozenTime == null ? 43 : $frozenTime.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $name = this.getName();
    result = result * PRIME + ($name == null ? 43 : $name.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
