// Generated by delombok at Thu Nov 10 23:10:45 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.testhelpers.TestClock;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.SubscriptionScheduleAmendParams;
import com.stripe.param.SubscriptionScheduleCancelParams;
import com.stripe.param.SubscriptionScheduleCreateParams;
import com.stripe.param.SubscriptionScheduleListParams;
import com.stripe.param.SubscriptionScheduleReleaseParams;
import com.stripe.param.SubscriptionScheduleRetrieveParams;
import com.stripe.param.SubscriptionScheduleUpdateParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * A subscription schedule allows you to create and manage the lifecycle of a subscription by
 * predefining expected changes.
 *
 * <p>Related guide: <a
 * href="https://stripe.com/docs/billing/subscriptions/subscription-schedules">Subscription
 * Schedules</a>.
 */
public class SubscriptionSchedule extends ApiResource implements HasId, MetadataStore<SubscriptionSchedule> {
  /**
   * ID of the Connect Application that created the schedule.
   */
  @SerializedName("application")
  ExpandableField<Application> application;
  /**
   * Configures when the subscription schedule generates prorations for phase transitions. Possible
   * values are {@code prorate_on_next_phase} or {@code prorate_up_front} with the default being
   * {@code prorate_on_next_phase}. {@code prorate_on_next_phase} will apply phase changes and
   * generate prorations at transition time.{@code prorate_up_front} will bill for all phases within
   * the current billing cycle up front.
   *
   * <p>One of {@code prorate_on_next_phase}, or {@code prorate_up_front}.
   */
  @SerializedName("billing_behavior")
  String billingBehavior;
  /**
   * Time at which the subscription schedule was canceled. Measured in seconds since the Unix epoch.
   */
  @SerializedName("canceled_at")
  Long canceledAt;
  /**
   * Time at which the subscription schedule was completed. Measured in seconds since the Unix
   * epoch.
   */
  @SerializedName("completed_at")
  Long completedAt;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Object representing the start and end dates for the current phase of the subscription schedule,
   * if it is {@code active}.
   */
  @SerializedName("current_phase")
  CurrentPhase currentPhase;
  /**
   * ID of the customer who owns the subscription schedule.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  @SerializedName("default_settings")
  DefaultSettings defaultSettings;
  /**
   * Behavior of the subscription schedule and underlying subscription when it ends. Possible values
   * are {@code release} and {@code cancel}.
   *
   * <p>One of {@code cancel}, {@code none}, {@code release}, or {@code renew}.
   */
  @SerializedName("end_behavior")
  String endBehavior;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code subscription_schedule}.
   */
  @SerializedName("object")
  String object;
  /**
   * Configuration for the subscription schedule's phases.
   */
  @SerializedName("phases")
  List<SubscriptionSchedule.Phase> phases;
  /**
   * Time period and invoice for a Subscription billed in advance.
   */
  @SerializedName("prebilling")
  Prebilling prebilling;
  /**
   * Time at which the subscription schedule was released. Measured in seconds since the Unix epoch.
   */
  @SerializedName("released_at")
  Long releasedAt;
  /**
   * ID of the subscription once managed by the subscription schedule (if it is released).
   */
  @SerializedName("released_subscription")
  String releasedSubscription;
  /**
   * The present status of the subscription schedule. Possible values are {@code not_started},
   * {@code active}, {@code completed}, {@code released}, and {@code canceled}. You can read more
   * about the different states in our <a
   * href="https://stripe.com/docs/billing/subscriptions/subscription-schedules">behavior guide</a>.
   *
   * <p>One of {@code active}, {@code canceled}, {@code completed}, {@code not_started}, or {@code
   * released}.
   */
  @SerializedName("status")
  String status;
  /**
   * ID of the subscription managed by the subscription schedule.
   */
  @SerializedName("subscription")
  ExpandableField<Subscription> subscription;
  /**
   * ID of the test clock this subscription schedule belongs to.
   */
  @SerializedName("test_clock")
  ExpandableField<TestClock> testClock;

  /**
   * Get ID of expandable {@code application} object.
   */
  public String getApplication() {
    return (this.application != null) ? this.application.getId() : null;
  }

  public void setApplication(String id) {
    this.application = ApiResource.setExpandableFieldId(id, this.application);
  }

  /**
   * Get expanded {@code application}.
   */
  public Application getApplicationObject() {
    return (this.application != null) ? this.application.getExpanded() : null;
  }

  public void setApplicationObject(Application expandableObject) {
    this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code customer} object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded {@code customer}.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code subscription} object.
   */
  public String getSubscription() {
    return (this.subscription != null) ? this.subscription.getId() : null;
  }

  public void setSubscription(String id) {
    this.subscription = ApiResource.setExpandableFieldId(id, this.subscription);
  }

  /**
   * Get expanded {@code subscription}.
   */
  public Subscription getSubscriptionObject() {
    return (this.subscription != null) ? this.subscription.getExpanded() : null;
  }

  public void setSubscriptionObject(Subscription expandableObject) {
    this.subscription = new ExpandableField<Subscription>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code testClock} object.
   */
  public String getTestClock() {
    return (this.testClock != null) ? this.testClock.getId() : null;
  }

  public void setTestClock(String id) {
    this.testClock = ApiResource.setExpandableFieldId(id, this.testClock);
  }

  /**
   * Get expanded {@code testClock}.
   */
  public TestClock getTestClockObject() {
    return (this.testClock != null) ? this.testClock.getExpanded() : null;
  }

  public void setTestClockObject(TestClock expandableObject) {
    this.testClock = new ExpandableField<TestClock>(expandableObject.getId(), expandableObject);
  }

  /**
   * Amends an existing subscription schedule.
   */
  public SubscriptionSchedule amend() throws StripeException {
    return amend((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Amends an existing subscription schedule.
   */
  public SubscriptionSchedule amend(RequestOptions options) throws StripeException {
    return amend((Map<String, Object>) null, options);
  }

  /**
   * Amends an existing subscription schedule.
   */
  public SubscriptionSchedule amend(Map<String, Object> params) throws StripeException {
    return amend(params, (RequestOptions) null);
  }

  /**
   * Amends an existing subscription schedule.
   */
  public SubscriptionSchedule amend(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s/amend", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
  }

  /**
   * Amends an existing subscription schedule.
   */
  public SubscriptionSchedule amend(SubscriptionScheduleAmendParams params) throws StripeException {
    return amend(params, (RequestOptions) null);
  }

  /**
   * Amends an existing subscription schedule.
   */
  public SubscriptionSchedule amend(SubscriptionScheduleAmendParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s/amend", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
  }

  /**
   * Cancels a subscription schedule and its associated subscription immediately (if the
   * subscription schedule has an active subscription). A subscription schedule can only be canceled
   * if its status is <code>not_started</code> or <code>active</code>.
   */
  public SubscriptionSchedule cancel() throws StripeException {
    return cancel((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Cancels a subscription schedule and its associated subscription immediately (if the
   * subscription schedule has an active subscription). A subscription schedule can only be canceled
   * if its status is <code>not_started</code> or <code>active</code>.
   */
  public SubscriptionSchedule cancel(RequestOptions options) throws StripeException {
    return cancel((Map<String, Object>) null, options);
  }

  /**
   * Cancels a subscription schedule and its associated subscription immediately (if the
   * subscription schedule has an active subscription). A subscription schedule can only be canceled
   * if its status is <code>not_started</code> or <code>active</code>.
   */
  public SubscriptionSchedule cancel(Map<String, Object> params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * Cancels a subscription schedule and its associated subscription immediately (if the
   * subscription schedule has an active subscription). A subscription schedule can only be canceled
   * if its status is <code>not_started</code> or <code>active</code>.
   */
  public SubscriptionSchedule cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
  }

  /**
   * Cancels a subscription schedule and its associated subscription immediately (if the
   * subscription schedule has an active subscription). A subscription schedule can only be canceled
   * if its status is <code>not_started</code> or <code>active</code>.
   */
  public SubscriptionSchedule cancel(SubscriptionScheduleCancelParams params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * Cancels a subscription schedule and its associated subscription immediately (if the
   * subscription schedule has an active subscription). A subscription schedule can only be canceled
   * if its status is <code>not_started</code> or <code>active</code>.
   */
  public SubscriptionSchedule cancel(SubscriptionScheduleCancelParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
  }

  /**
   * Creates a new subscription schedule object. Each customer can have up to 500 active or
   * scheduled subscriptions.
   */
  public static SubscriptionSchedule create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new subscription schedule object. Each customer can have up to 500 active or
   * scheduled subscriptions.
   */
  public static SubscriptionSchedule create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_schedules");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
  }

  /**
   * Creates a new subscription schedule object. Each customer can have up to 500 active or
   * scheduled subscriptions.
   */
  public static SubscriptionSchedule create(SubscriptionScheduleCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new subscription schedule object. Each customer can have up to 500 active or
   * scheduled subscriptions.
   */
  public static SubscriptionSchedule create(SubscriptionScheduleCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_schedules");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
  }

  /**
   * Retrieves the list of your subscription schedules.
   */
  public static SubscriptionScheduleCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Retrieves the list of your subscription schedules.
   */
  public static SubscriptionScheduleCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_schedules");
    return ApiResource.requestCollection(url, params, SubscriptionScheduleCollection.class, options);
  }

  /**
   * Retrieves the list of your subscription schedules.
   */
  public static SubscriptionScheduleCollection list(SubscriptionScheduleListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Retrieves the list of your subscription schedules.
   */
  public static SubscriptionScheduleCollection list(SubscriptionScheduleListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_schedules");
    return ApiResource.requestCollection(url, params, SubscriptionScheduleCollection.class, options);
  }

  /**
   * Releases the subscription schedule immediately, which will stop scheduling of its phases, but
   * leave any existing subscription in place. A schedule can only be released if its status is
   * <code>not_started</code> or <code>active</code>. If the subscription schedule is currently
   * associated with a subscription, releasing it will remove its <code>subscription</code> property
   * and set the subscription’s ID to the <code>released_subscription</code> property.
   */
  public SubscriptionSchedule release() throws StripeException {
    return release((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Releases the subscription schedule immediately, which will stop scheduling of its phases, but
   * leave any existing subscription in place. A schedule can only be released if its status is
   * <code>not_started</code> or <code>active</code>. If the subscription schedule is currently
   * associated with a subscription, releasing it will remove its <code>subscription</code> property
   * and set the subscription’s ID to the <code>released_subscription</code> property.
   */
  public SubscriptionSchedule release(RequestOptions options) throws StripeException {
    return release((Map<String, Object>) null, options);
  }

  /**
   * Releases the subscription schedule immediately, which will stop scheduling of its phases, but
   * leave any existing subscription in place. A schedule can only be released if its status is
   * <code>not_started</code> or <code>active</code>. If the subscription schedule is currently
   * associated with a subscription, releasing it will remove its <code>subscription</code> property
   * and set the subscription’s ID to the <code>released_subscription</code> property.
   */
  public SubscriptionSchedule release(Map<String, Object> params) throws StripeException {
    return release(params, (RequestOptions) null);
  }

  /**
   * Releases the subscription schedule immediately, which will stop scheduling of its phases, but
   * leave any existing subscription in place. A schedule can only be released if its status is
   * <code>not_started</code> or <code>active</code>. If the subscription schedule is currently
   * associated with a subscription, releasing it will remove its <code>subscription</code> property
   * and set the subscription’s ID to the <code>released_subscription</code> property.
   */
  public SubscriptionSchedule release(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s/release", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
  }

  /**
   * Releases the subscription schedule immediately, which will stop scheduling of its phases, but
   * leave any existing subscription in place. A schedule can only be released if its status is
   * <code>not_started</code> or <code>active</code>. If the subscription schedule is currently
   * associated with a subscription, releasing it will remove its <code>subscription</code> property
   * and set the subscription’s ID to the <code>released_subscription</code> property.
   */
  public SubscriptionSchedule release(SubscriptionScheduleReleaseParams params) throws StripeException {
    return release(params, (RequestOptions) null);
  }

  /**
   * Releases the subscription schedule immediately, which will stop scheduling of its phases, but
   * leave any existing subscription in place. A schedule can only be released if its status is
   * <code>not_started</code> or <code>active</code>. If the subscription schedule is currently
   * associated with a subscription, releasing it will remove its <code>subscription</code> property
   * and set the subscription’s ID to the <code>released_subscription</code> property.
   */
  public SubscriptionSchedule release(SubscriptionScheduleReleaseParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s/release", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
  }

  /**
   * Retrieves the details of an existing subscription schedule. You only need to supply the unique
   * subscription schedule identifier that was returned upon subscription schedule creation.
   */
  public static SubscriptionSchedule retrieve(String schedule) throws StripeException {
    return retrieve(schedule, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an existing subscription schedule. You only need to supply the unique
   * subscription schedule identifier that was returned upon subscription schedule creation.
   */
  public static SubscriptionSchedule retrieve(String schedule, RequestOptions options) throws StripeException {
    return retrieve(schedule, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an existing subscription schedule. You only need to supply the unique
   * subscription schedule identifier that was returned upon subscription schedule creation.
   */
  public static SubscriptionSchedule retrieve(String schedule, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(schedule)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SubscriptionSchedule.class, options);
  }

  /**
   * Retrieves the details of an existing subscription schedule. You only need to supply the unique
   * subscription schedule identifier that was returned upon subscription schedule creation.
   */
  public static SubscriptionSchedule retrieve(String schedule, SubscriptionScheduleRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(schedule)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SubscriptionSchedule.class, options);
  }

  /**
   * Updates an existing subscription schedule.
   */
  @Override
  public SubscriptionSchedule update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates an existing subscription schedule.
   */
  @Override
  public SubscriptionSchedule update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
  }

  /**
   * Updates an existing subscription schedule.
   */
  public SubscriptionSchedule update(SubscriptionScheduleUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates an existing subscription schedule.
   */
  public SubscriptionSchedule update(SubscriptionScheduleUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
  }


  /**
   * An Add Invoice Item describes the prices and quantities that will be added as pending invoice
   * items when entering a phase.
   */
  public static class AddInvoiceItem extends StripeObject {
    /**
     * The stackable discounts that will be applied to the item.
     */
    @SerializedName("discounts")
    List<SubscriptionSchedule.AddInvoiceItem.StackableDiscount> discounts;
    /**
     * ID of the price used to generate the invoice item.
     */
    @SerializedName("price")
    ExpandableField<Price> price;
    /**
     * The quantity of the invoice item.
     */
    @SerializedName("quantity")
    Long quantity;
    /**
     * The tax rates which apply to the item. When set, the {@code default_tax_rates} do not apply
     * to this item.
     */
    @SerializedName("tax_rates")
    List<TaxRate> taxRates;

    /**
     * Get ID of expandable {@code price} object.
     */
    public String getPrice() {
      return (this.price != null) ? this.price.getId() : null;
    }

    public void setPrice(String id) {
      this.price = ApiResource.setExpandableFieldId(id, this.price);
    }

    /**
     * Get expanded {@code price}.
     */
    public Price getPriceObject() {
      return (this.price != null) ? this.price.getExpanded() : null;
    }

    public void setPriceObject(Price expandableObject) {
      this.price = new ExpandableField<Price>(expandableObject.getId(), expandableObject);
    }


    public static class StackableDiscount extends StripeObject {
      /** ID of the coupon to create a new discount for. */
      @SerializedName("coupon")
      ExpandableField<Coupon> coupon;
      /** ID of an existing discount on the object (or one of its ancestors) to reuse. */
      @SerializedName("discount")
      ExpandableField<Discount> discount;

      /** Get ID of expandable {@code coupon} object. */
      public String getCoupon() {
        return (this.coupon != null) ? this.coupon.getId() : null;
      }

      public void setCoupon(String id) {
        this.coupon = ApiResource.setExpandableFieldId(id, this.coupon);
      }

      /** Get expanded {@code coupon}. */
      public Coupon getCouponObject() {
        return (this.coupon != null) ? this.coupon.getExpanded() : null;
      }

      public void setCouponObject(Coupon expandableObject) {
        this.coupon = new ExpandableField<Coupon>(expandableObject.getId(), expandableObject);
      }

      /** Get ID of expandable {@code discount} object. */
      public String getDiscount() {
        return (this.discount != null) ? this.discount.getId() : null;
      }

      public void setDiscount(String id) {
        this.discount = ApiResource.setExpandableFieldId(id, this.discount);
      }

      public Discount getDiscountObject() {
        return (this.discount != null) ? this.discount.getExpanded() : null;
      }

      public void setDiscountObject(Discount expandableObject) {
        this.discount = new ExpandableField<Discount>(expandableObject.getId(), expandableObject);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SubscriptionSchedule.AddInvoiceItem.StackableDiscount)) return false;
        final SubscriptionSchedule.AddInvoiceItem.StackableDiscount other = (SubscriptionSchedule.AddInvoiceItem.StackableDiscount) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$coupon = this.getCoupon();
        final java.lang.Object other$coupon = other.getCoupon();
        if (this$coupon == null ? other$coupon != null : !this$coupon.equals(other$coupon)) return false;
        final java.lang.Object this$discount = this.getDiscount();
        final java.lang.Object other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SubscriptionSchedule.AddInvoiceItem.StackableDiscount;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $coupon = this.getCoupon();
        result = result * PRIME + ($coupon == null ? 43 : $coupon.hashCode());
        final java.lang.Object $discount = this.getDiscount();
        result = result * PRIME + ($discount == null ? 43 : $discount.hashCode());
        return result;
      }
    }

    /**
     * The stackable discounts that will be applied to the item.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<SubscriptionSchedule.AddInvoiceItem.StackableDiscount> getDiscounts() {
      return this.discounts;
    }

    /**
     * The quantity of the invoice item.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQuantity() {
      return this.quantity;
    }

    /**
     * The tax rates which apply to the item. When set, the {@code default_tax_rates} do not apply
     * to this item.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<TaxRate> getTaxRates() {
      return this.taxRates;
    }

    /**
     * The stackable discounts that will be applied to the item.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDiscounts(final List<SubscriptionSchedule.AddInvoiceItem.StackableDiscount> discounts) {
      this.discounts = discounts;
    }

    /**
     * The quantity of the invoice item.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setQuantity(final Long quantity) {
      this.quantity = quantity;
    }

    /**
     * The tax rates which apply to the item. When set, the {@code default_tax_rates} do not apply
     * to this item.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTaxRates(final List<TaxRate> taxRates) {
      this.taxRates = taxRates;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof SubscriptionSchedule.AddInvoiceItem)) return false;
      final SubscriptionSchedule.AddInvoiceItem other = (SubscriptionSchedule.AddInvoiceItem) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$quantity = this.getQuantity();
      final java.lang.Object other$quantity = other.getQuantity();
      if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) return false;
      final java.lang.Object this$discounts = this.getDiscounts();
      final java.lang.Object other$discounts = other.getDiscounts();
      if (this$discounts == null ? other$discounts != null : !this$discounts.equals(other$discounts)) return false;
      final java.lang.Object this$price = this.getPrice();
      final java.lang.Object other$price = other.getPrice();
      if (this$price == null ? other$price != null : !this$price.equals(other$price)) return false;
      final java.lang.Object this$taxRates = this.getTaxRates();
      final java.lang.Object other$taxRates = other.getTaxRates();
      if (this$taxRates == null ? other$taxRates != null : !this$taxRates.equals(other$taxRates)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof SubscriptionSchedule.AddInvoiceItem;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $quantity = this.getQuantity();
      result = result * PRIME + ($quantity == null ? 43 : $quantity.hashCode());
      final java.lang.Object $discounts = this.getDiscounts();
      result = result * PRIME + ($discounts == null ? 43 : $discounts.hashCode());
      final java.lang.Object $price = this.getPrice();
      result = result * PRIME + ($price == null ? 43 : $price.hashCode());
      final java.lang.Object $taxRates = this.getTaxRates();
      result = result * PRIME + ($taxRates == null ? 43 : $taxRates.hashCode());
      return result;
    }
  }


  /**
   * Get expanded {@code discount}.
   */
  public static class CurrentPhase extends StripeObject {
    /**
     * The end of this phase of the subscription schedule.
     */
    @SerializedName("end_date")
    Long endDate;
    /**
     * The start of this phase of the subscription schedule.
     */
    @SerializedName("start_date")
    Long startDate;

    /**
     * The end of this phase of the subscription schedule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getEndDate() {
      return this.endDate;
    }

    /**
     * The start of this phase of the subscription schedule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getStartDate() {
      return this.startDate;
    }

    /**
     * The end of this phase of the subscription schedule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEndDate(final Long endDate) {
      this.endDate = endDate;
    }

    /**
     * The start of this phase of the subscription schedule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStartDate(final Long startDate) {
      this.startDate = startDate;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof SubscriptionSchedule.CurrentPhase)) return false;
      final SubscriptionSchedule.CurrentPhase other = (SubscriptionSchedule.CurrentPhase) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$endDate = this.getEndDate();
      final java.lang.Object other$endDate = other.getEndDate();
      if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) return false;
      final java.lang.Object this$startDate = this.getStartDate();
      final java.lang.Object other$startDate = other.getStartDate();
      if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof SubscriptionSchedule.CurrentPhase;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $endDate = this.getEndDate();
      result = result * PRIME + ($endDate == null ? 43 : $endDate.hashCode());
      final java.lang.Object $startDate = this.getStartDate();
      result = result * PRIME + ($startDate == null ? 43 : $startDate.hashCode());
      return result;
    }
  }


  public static class DefaultSettings extends StripeObject {
    /**
     * A non-negative decimal between 0 and 100, with at most two decimal places. This represents
     * the percentage of the subscription invoice subtotal that will be transferred to the
     * application owner's Stripe account during this phase of the schedule.
     */
    @SerializedName("application_fee_percent")
    BigDecimal applicationFeePercent;
    @SerializedName("automatic_tax")
    AutomaticTax automaticTax;
    /**
     * Possible values are {@code phase_start} or {@code automatic}. If {@code phase_start} then
     * billing cycle anchor of the subscription is set to the start of the phase when entering the
     * phase. If {@code automatic} then the billing cycle anchor is automatically modified as needed
     * when entering the phase. For more information, see the billing cycle <a
     * href="https://stripe.com/docs/billing/subscriptions/billing-cycle">documentation</a>.
     *
     * <p>One of {@code automatic}, or {@code phase_start}.
     */
    @SerializedName("billing_cycle_anchor")
    String billingCycleAnchor;
    /**
     * Define thresholds at which an invoice will be sent, and the subscription advanced to a new
     * billing period.
     */
    @SerializedName("billing_thresholds")
    Subscription.BillingThresholds billingThresholds;
    /**
     * Either {@code charge_automatically}, or {@code send_invoice}. When charging automatically,
     * Stripe will attempt to pay the underlying subscription at the end of each billing cycle using
     * the default source attached to the customer. When sending an invoice, Stripe will email your
     * customer an invoice with payment instructions and mark the subscription as {@code active}.
     *
     * <p>One of {@code charge_automatically}, or {@code send_invoice}.
     */
    @SerializedName("collection_method")
    String collectionMethod;
    /**
     * ID of the default payment method for the subscription schedule. If not set, invoices will use
     * the default payment method in the customer's invoice settings.
     */
    @SerializedName("default_payment_method")
    ExpandableField<PaymentMethod> defaultPaymentMethod;
    /**
     * Subscription description, meant to be displayable to the customer. Use this field to
     * optionally store an explanation of the subscription.
     */
    @SerializedName("description")
    String description;
    /**
     * The subscription schedule's default invoice settings.
     */
    @SerializedName("invoice_settings")
    InvoiceSettings invoiceSettings;
    /**
     * The account (if any) the charge was made on behalf of for charges associated with the
     * schedule's subscription. See the Connect documentation for details.
     */
    @SerializedName("on_behalf_of")
    ExpandableField<Account> onBehalfOf;
    /**
     * The account (if any) the associated subscription's payments will be attributed to for tax
     * reporting, and where funds from each payment will be transferred to for each of the
     * subscription's invoices.
     */
    @SerializedName("transfer_data")
    Subscription.TransferData transferData;

    /**
     * Get ID of expandable {@code defaultPaymentMethod} object.
     */
    public String getDefaultPaymentMethod() {
      return (this.defaultPaymentMethod != null) ? this.defaultPaymentMethod.getId() : null;
    }

    public void setDefaultPaymentMethod(String id) {
      this.defaultPaymentMethod = ApiResource.setExpandableFieldId(id, this.defaultPaymentMethod);
    }

    /**
     * Get expanded {@code defaultPaymentMethod}.
     */
    public PaymentMethod getDefaultPaymentMethodObject() {
      return (this.defaultPaymentMethod != null) ? this.defaultPaymentMethod.getExpanded() : null;
    }

    public void setDefaultPaymentMethodObject(PaymentMethod expandableObject) {
      this.defaultPaymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
    }

    /**
     * Get ID of expandable {@code onBehalfOf} object.
     */
    public String getOnBehalfOf() {
      return (this.onBehalfOf != null) ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String id) {
      this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
    }

    /**
     * Get expanded {@code onBehalfOf}.
     */
    public Account getOnBehalfOfObject() {
      return (this.onBehalfOf != null) ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account expandableObject) {
      this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }


    public static class AutomaticTax extends StripeObject {
      @SerializedName("enabled")
      Boolean enabled;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getEnabled() {
        return this.enabled;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setEnabled(final Boolean enabled) {
        this.enabled = enabled;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SubscriptionSchedule.DefaultSettings.AutomaticTax)) return false;
        final SubscriptionSchedule.DefaultSettings.AutomaticTax other = (SubscriptionSchedule.DefaultSettings.AutomaticTax) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$enabled = this.getEnabled();
        final java.lang.Object other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SubscriptionSchedule.DefaultSettings.AutomaticTax;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $enabled = this.getEnabled();
        result = result * PRIME + ($enabled == null ? 43 : $enabled.hashCode());
        return result;
      }
    }

    /**
     * A non-negative decimal between 0 and 100, with at most two decimal places. This represents
     * the percentage of the subscription invoice subtotal that will be transferred to the
     * application owner's Stripe account during this phase of the schedule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BigDecimal getApplicationFeePercent() {
      return this.applicationFeePercent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AutomaticTax getAutomaticTax() {
      return this.automaticTax;
    }

    /**
     * Possible values are {@code phase_start} or {@code automatic}. If {@code phase_start} then
     * billing cycle anchor of the subscription is set to the start of the phase when entering the
     * phase. If {@code automatic} then the billing cycle anchor is automatically modified as needed
     * when entering the phase. For more information, see the billing cycle <a
     * href="https://stripe.com/docs/billing/subscriptions/billing-cycle">documentation</a>.
     *
     * <p>One of {@code automatic}, or {@code phase_start}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBillingCycleAnchor() {
      return this.billingCycleAnchor;
    }

    /**
     * Define thresholds at which an invoice will be sent, and the subscription advanced to a new
     * billing period.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Subscription.BillingThresholds getBillingThresholds() {
      return this.billingThresholds;
    }

    /**
     * Either {@code charge_automatically}, or {@code send_invoice}. When charging automatically,
     * Stripe will attempt to pay the underlying subscription at the end of each billing cycle using
     * the default source attached to the customer. When sending an invoice, Stripe will email your
     * customer an invoice with payment instructions and mark the subscription as {@code active}.
     *
     * <p>One of {@code charge_automatically}, or {@code send_invoice}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCollectionMethod() {
      return this.collectionMethod;
    }

    /**
     * Subscription description, meant to be displayable to the customer. Use this field to
     * optionally store an explanation of the subscription.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
      return this.description;
    }

    /**
     * The subscription schedule's default invoice settings.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public InvoiceSettings getInvoiceSettings() {
      return this.invoiceSettings;
    }

    /**
     * The account (if any) the associated subscription's payments will be attributed to for tax
     * reporting, and where funds from each payment will be transferred to for each of the
     * subscription's invoices.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Subscription.TransferData getTransferData() {
      return this.transferData;
    }

    /**
     * A non-negative decimal between 0 and 100, with at most two decimal places. This represents
     * the percentage of the subscription invoice subtotal that will be transferred to the
     * application owner's Stripe account during this phase of the schedule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setApplicationFeePercent(final BigDecimal applicationFeePercent) {
      this.applicationFeePercent = applicationFeePercent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAutomaticTax(final AutomaticTax automaticTax) {
      this.automaticTax = automaticTax;
    }

    /**
     * Possible values are {@code phase_start} or {@code automatic}. If {@code phase_start} then
     * billing cycle anchor of the subscription is set to the start of the phase when entering the
     * phase. If {@code automatic} then the billing cycle anchor is automatically modified as needed
     * when entering the phase. For more information, see the billing cycle <a
     * href="https://stripe.com/docs/billing/subscriptions/billing-cycle">documentation</a>.
     *
     * <p>One of {@code automatic}, or {@code phase_start}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBillingCycleAnchor(final String billingCycleAnchor) {
      this.billingCycleAnchor = billingCycleAnchor;
    }

    /**
     * Define thresholds at which an invoice will be sent, and the subscription advanced to a new
     * billing period.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBillingThresholds(final Subscription.BillingThresholds billingThresholds) {
      this.billingThresholds = billingThresholds;
    }

    /**
     * Either {@code charge_automatically}, or {@code send_invoice}. When charging automatically,
     * Stripe will attempt to pay the underlying subscription at the end of each billing cycle using
     * the default source attached to the customer. When sending an invoice, Stripe will email your
     * customer an invoice with payment instructions and mark the subscription as {@code active}.
     *
     * <p>One of {@code charge_automatically}, or {@code send_invoice}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCollectionMethod(final String collectionMethod) {
      this.collectionMethod = collectionMethod;
    }

    /**
     * Subscription description, meant to be displayable to the customer. Use this field to
     * optionally store an explanation of the subscription.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDescription(final String description) {
      this.description = description;
    }

    /**
     * The subscription schedule's default invoice settings.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInvoiceSettings(final InvoiceSettings invoiceSettings) {
      this.invoiceSettings = invoiceSettings;
    }

    /**
     * The account (if any) the associated subscription's payments will be attributed to for tax
     * reporting, and where funds from each payment will be transferred to for each of the
     * subscription's invoices.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTransferData(final Subscription.TransferData transferData) {
      this.transferData = transferData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof SubscriptionSchedule.DefaultSettings)) return false;
      final SubscriptionSchedule.DefaultSettings other = (SubscriptionSchedule.DefaultSettings) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$applicationFeePercent = this.getApplicationFeePercent();
      final java.lang.Object other$applicationFeePercent = other.getApplicationFeePercent();
      if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !this$applicationFeePercent.equals(other$applicationFeePercent)) return false;
      final java.lang.Object this$automaticTax = this.getAutomaticTax();
      final java.lang.Object other$automaticTax = other.getAutomaticTax();
      if (this$automaticTax == null ? other$automaticTax != null : !this$automaticTax.equals(other$automaticTax)) return false;
      final java.lang.Object this$billingCycleAnchor = this.getBillingCycleAnchor();
      final java.lang.Object other$billingCycleAnchor = other.getBillingCycleAnchor();
      if (this$billingCycleAnchor == null ? other$billingCycleAnchor != null : !this$billingCycleAnchor.equals(other$billingCycleAnchor)) return false;
      final java.lang.Object this$billingThresholds = this.getBillingThresholds();
      final java.lang.Object other$billingThresholds = other.getBillingThresholds();
      if (this$billingThresholds == null ? other$billingThresholds != null : !this$billingThresholds.equals(other$billingThresholds)) return false;
      final java.lang.Object this$collectionMethod = this.getCollectionMethod();
      final java.lang.Object other$collectionMethod = other.getCollectionMethod();
      if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) return false;
      final java.lang.Object this$defaultPaymentMethod = this.getDefaultPaymentMethod();
      final java.lang.Object other$defaultPaymentMethod = other.getDefaultPaymentMethod();
      if (this$defaultPaymentMethod == null ? other$defaultPaymentMethod != null : !this$defaultPaymentMethod.equals(other$defaultPaymentMethod)) return false;
      final java.lang.Object this$description = this.getDescription();
      final java.lang.Object other$description = other.getDescription();
      if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
      final java.lang.Object this$invoiceSettings = this.getInvoiceSettings();
      final java.lang.Object other$invoiceSettings = other.getInvoiceSettings();
      if (this$invoiceSettings == null ? other$invoiceSettings != null : !this$invoiceSettings.equals(other$invoiceSettings)) return false;
      final java.lang.Object this$onBehalfOf = this.getOnBehalfOf();
      final java.lang.Object other$onBehalfOf = other.getOnBehalfOf();
      if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) return false;
      final java.lang.Object this$transferData = this.getTransferData();
      final java.lang.Object other$transferData = other.getTransferData();
      if (this$transferData == null ? other$transferData != null : !this$transferData.equals(other$transferData)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof SubscriptionSchedule.DefaultSettings;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $applicationFeePercent = this.getApplicationFeePercent();
      result = result * PRIME + ($applicationFeePercent == null ? 43 : $applicationFeePercent.hashCode());
      final java.lang.Object $automaticTax = this.getAutomaticTax();
      result = result * PRIME + ($automaticTax == null ? 43 : $automaticTax.hashCode());
      final java.lang.Object $billingCycleAnchor = this.getBillingCycleAnchor();
      result = result * PRIME + ($billingCycleAnchor == null ? 43 : $billingCycleAnchor.hashCode());
      final java.lang.Object $billingThresholds = this.getBillingThresholds();
      result = result * PRIME + ($billingThresholds == null ? 43 : $billingThresholds.hashCode());
      final java.lang.Object $collectionMethod = this.getCollectionMethod();
      result = result * PRIME + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
      final java.lang.Object $defaultPaymentMethod = this.getDefaultPaymentMethod();
      result = result * PRIME + ($defaultPaymentMethod == null ? 43 : $defaultPaymentMethod.hashCode());
      final java.lang.Object $description = this.getDescription();
      result = result * PRIME + ($description == null ? 43 : $description.hashCode());
      final java.lang.Object $invoiceSettings = this.getInvoiceSettings();
      result = result * PRIME + ($invoiceSettings == null ? 43 : $invoiceSettings.hashCode());
      final java.lang.Object $onBehalfOf = this.getOnBehalfOf();
      result = result * PRIME + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
      final java.lang.Object $transferData = this.getTransferData();
      result = result * PRIME + ($transferData == null ? 43 : $transferData.hashCode());
      return result;
    }
  }


  /**
   * Whether Stripe automatically computes tax on invoices created during this phase.
   */
  public static class InvoiceSettings extends StripeObject {
    /**
     * Number of days within which a customer must pay invoices generated by this subscription
     * schedule. This value will be {@code null} for subscription schedules where {@code
     * billing=charge_automatically}.
     */
    @SerializedName("days_until_due")
    Long daysUntilDue;

    /**
     * Number of days within which a customer must pay invoices generated by this subscription
     * schedule. This value will be {@code null} for subscription schedules where {@code
     * billing=charge_automatically}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDaysUntilDue() {
      return this.daysUntilDue;
    }

    /**
     * Number of days within which a customer must pay invoices generated by this subscription
     * schedule. This value will be {@code null} for subscription schedules where {@code
     * billing=charge_automatically}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDaysUntilDue(final Long daysUntilDue) {
      this.daysUntilDue = daysUntilDue;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof SubscriptionSchedule.InvoiceSettings)) return false;
      final SubscriptionSchedule.InvoiceSettings other = (SubscriptionSchedule.InvoiceSettings) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$daysUntilDue = this.getDaysUntilDue();
      final java.lang.Object other$daysUntilDue = other.getDaysUntilDue();
      if (this$daysUntilDue == null ? other$daysUntilDue != null : !this$daysUntilDue.equals(other$daysUntilDue)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof SubscriptionSchedule.InvoiceSettings;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $daysUntilDue = this.getDaysUntilDue();
      result = result * PRIME + ($daysUntilDue == null ? 43 : $daysUntilDue.hashCode());
      return result;
    }
  }


  /**
   * A phase describes the plans, coupon, and trialing status of a subscription for a predefined
   * time period.
   */
  public static class Phase extends StripeObject {
    /**
     * A list of prices and quantities that will generate invoice items appended to the next invoice
     * for this phase.
     */
    @SerializedName("add_invoice_items")
    List<SubscriptionSchedule.AddInvoiceItem> addInvoiceItems;
    /**
     * A non-negative decimal between 0 and 100, with at most two decimal places. This represents
     * the percentage of the subscription invoice subtotal that will be transferred to the
     * application owner's Stripe account during this phase of the schedule.
     */
    @SerializedName("application_fee_percent")
    BigDecimal applicationFeePercent;
    @SerializedName("automatic_tax")
    AutomaticTax automaticTax;
    /**
     * Possible values are {@code phase_start} or {@code automatic}. If {@code phase_start} then
     * billing cycle anchor of the subscription is set to the start of the phase when entering the
     * phase. If {@code automatic} then the billing cycle anchor is automatically modified as needed
     * when entering the phase. For more information, see the billing cycle <a
     * href="https://stripe.com/docs/billing/subscriptions/billing-cycle">documentation</a>.
     *
     * <p>One of {@code automatic}, or {@code phase_start}.
     */
    @SerializedName("billing_cycle_anchor")
    String billingCycleAnchor;
    /**
     * Define thresholds at which an invoice will be sent, and the subscription advanced to a new
     * billing period.
     */
    @SerializedName("billing_thresholds")
    Subscription.BillingThresholds billingThresholds;
    /**
     * Either {@code charge_automatically}, or {@code send_invoice}. When charging automatically,
     * Stripe will attempt to pay the underlying subscription at the end of each billing cycle using
     * the default source attached to the customer. When sending an invoice, Stripe will email your
     * customer an invoice with payment instructions and mark the subscription as {@code active}.
     *
     * <p>One of {@code charge_automatically}, or {@code send_invoice}.
     */
    @SerializedName("collection_method")
    String collectionMethod;
    /**
     * ID of the coupon to use during this phase of the subscription schedule.
     */
    @SerializedName("coupon")
    ExpandableField<Coupon> coupon;
    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @SerializedName("currency")
    String currency;
    /**
     * ID of the default payment method for the subscription schedule. It must belong to the
     * customer associated with the subscription schedule. If not set, invoices will use the default
     * payment method in the customer's invoice settings.
     */
    @SerializedName("default_payment_method")
    ExpandableField<PaymentMethod> defaultPaymentMethod;
    /**
     * The default tax rates to apply to the subscription during this phase of the subscription
     * schedule.
     */
    @SerializedName("default_tax_rates")
    List<TaxRate> defaultTaxRates;
    /**
     * Subscription description, meant to be displayable to the customer. Use this field to
     * optionally store an explanation of the subscription.
     */
    @SerializedName("description")
    String description;
    /**
     * The stackable discounts that will be applied to the subscription on this phase. Subscription
     * item discounts are applied before subscription discounts.
     */
    @SerializedName("discounts")
    List<SubscriptionSchedule.Phase.Discount> discounts;
    /**
     * The end of this phase of the subscription schedule.
     */
    @SerializedName("end_date")
    Long endDate;
    /**
     * The invoice settings applicable during this phase.
     */
    @SerializedName("invoice_settings")
    InvoiceSettings invoiceSettings;
    /**
     * Subscription items to configure the subscription to during this phase of the subscription
     * schedule.
     */
    @SerializedName("items")
    List<SubscriptionSchedule.PhaseItem> items;
    /**
     * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
     * to a phase. Metadata on a schedule's phase will update the underlying subscription's {@code
     * metadata} when the phase is entered. Updating the underlying subscription's {@code metadata}
     * directly will not affect the current phase's {@code metadata}.
     */
    @SerializedName("metadata")
    Map<String, String> metadata;
    /**
     * The account (if any) the charge was made on behalf of for charges associated with the
     * schedule's subscription. See the Connect documentation for details.
     */
    @SerializedName("on_behalf_of")
    ExpandableField<Account> onBehalfOf;
    /**
     * If the subscription schedule will prorate when transitioning to this phase. Possible values
     * are {@code create_prorations} and {@code none}.
     *
     * <p>One of {@code always_invoice}, {@code create_prorations}, or {@code none}.
     */
    @SerializedName("proration_behavior")
    String prorationBehavior;
    /**
     * The start of this phase of the subscription schedule.
     */
    @SerializedName("start_date")
    Long startDate;
    /**
     * The account (if any) the associated subscription's payments will be attributed to for tax
     * reporting, and where funds from each payment will be transferred to for each of the
     * subscription's invoices.
     */
    @SerializedName("transfer_data")
    Subscription.TransferData transferData;
    /**
     * Specify behavior of the trial when crossing schedule phase boundaries
     *
     * <p>One of {@code continue}, or {@code none}.
     */
    @SerializedName("trial_continuation")
    String trialContinuation;
    /**
     * When the trial ends within the phase.
     */
    @SerializedName("trial_end")
    Long trialEnd;
    /**
     * Settings related to any trials on the subscription during this phase.
     */
    @SerializedName("trial_settings")
    TrialSettings trialSettings;

    /**
     * Get ID of expandable {@code coupon} object.
     */
    public String getCoupon() {
      return (this.coupon != null) ? this.coupon.getId() : null;
    }

    public void setCoupon(String id) {
      this.coupon = ApiResource.setExpandableFieldId(id, this.coupon);
    }

    /**
     * Get expanded {@code coupon}.
     */
    public Coupon getCouponObject() {
      return (this.coupon != null) ? this.coupon.getExpanded() : null;
    }

    public void setCouponObject(Coupon expandableObject) {
      this.coupon = new ExpandableField<Coupon>(expandableObject.getId(), expandableObject);
    }

    /**
     * Get ID of expandable {@code defaultPaymentMethod} object.
     */
    public String getDefaultPaymentMethod() {
      return (this.defaultPaymentMethod != null) ? this.defaultPaymentMethod.getId() : null;
    }

    public void setDefaultPaymentMethod(String id) {
      this.defaultPaymentMethod = ApiResource.setExpandableFieldId(id, this.defaultPaymentMethod);
    }

    /**
     * Get expanded {@code defaultPaymentMethod}.
     */
    public PaymentMethod getDefaultPaymentMethodObject() {
      return (this.defaultPaymentMethod != null) ? this.defaultPaymentMethod.getExpanded() : null;
    }

    public void setDefaultPaymentMethodObject(PaymentMethod expandableObject) {
      this.defaultPaymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
    }

    /**
     * Get ID of expandable {@code onBehalfOf} object.
     */
    public String getOnBehalfOf() {
      return (this.onBehalfOf != null) ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String id) {
      this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
    }

    /**
     * Get expanded {@code onBehalfOf}.
     */
    public Account getOnBehalfOfObject() {
      return (this.onBehalfOf != null) ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account expandableObject) {
      this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }


    public static class AutomaticTax extends StripeObject {
      /**
       * Whether Stripe automatically computes tax on invoices created during this phase.
       */
      @SerializedName("enabled")
      Boolean enabled;

      /**
       * Whether Stripe automatically computes tax on invoices created during this phase.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Boolean getEnabled() {
        return this.enabled;
      }

      /**
       * Whether Stripe automatically computes tax on invoices created during this phase.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setEnabled(final Boolean enabled) {
        this.enabled = enabled;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SubscriptionSchedule.Phase.AutomaticTax)) return false;
        final SubscriptionSchedule.Phase.AutomaticTax other = (SubscriptionSchedule.Phase.AutomaticTax) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$enabled = this.getEnabled();
        final java.lang.Object other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SubscriptionSchedule.Phase.AutomaticTax;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $enabled = this.getEnabled();
        result = result * PRIME + ($enabled == null ? 43 : $enabled.hashCode());
        return result;
      }
    }


    public static class Discount extends StripeObject {
      /**
       * ID of the coupon to create a new discount for.
       */
      @SerializedName("coupon")
      ExpandableField<Coupon> coupon;
      /**
       * ID of an existing discount on the object (or one of its ancestors) to reuse.
       */
      @SerializedName("discount")
      ExpandableField<com.stripe.model.Discount> discount;

      /**
       * Get ID of expandable {@code coupon} object.
       */
      public String getCoupon() {
        return (this.coupon != null) ? this.coupon.getId() : null;
      }

      public void setCoupon(String id) {
        this.coupon = ApiResource.setExpandableFieldId(id, this.coupon);
      }

      /**
       * Get expanded {@code coupon}.
       */
      public Coupon getCouponObject() {
        return (this.coupon != null) ? this.coupon.getExpanded() : null;
      }

      public void setCouponObject(Coupon expandableObject) {
        this.coupon = new ExpandableField<Coupon>(expandableObject.getId(), expandableObject);
      }

      /**
       * Get ID of expandable {@code discount} object.
       */
      public String getDiscount() {
        return (this.discount != null) ? this.discount.getId() : null;
      }

      public void setDiscount(String id) {
        this.discount = ApiResource.setExpandableFieldId(id, this.discount);
      }

      /**
       * Get expanded {@code discount}.
       */
      public com.stripe.model.Discount getDiscountObject() {
        return (this.discount != null) ? this.discount.getExpanded() : null;
      }

      public void setDiscountObject(com.stripe.model.Discount expandableObject) {
        this.discount = new ExpandableField<com.stripe.model.Discount>(expandableObject.getId(), expandableObject);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SubscriptionSchedule.Phase.Discount)) return false;
        final SubscriptionSchedule.Phase.Discount other = (SubscriptionSchedule.Phase.Discount) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$coupon = this.getCoupon();
        final java.lang.Object other$coupon = other.getCoupon();
        if (this$coupon == null ? other$coupon != null : !this$coupon.equals(other$coupon)) return false;
        final java.lang.Object this$discount = this.getDiscount();
        final java.lang.Object other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SubscriptionSchedule.Phase.Discount;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $coupon = this.getCoupon();
        result = result * PRIME + ($coupon == null ? 43 : $coupon.hashCode());
        final java.lang.Object $discount = this.getDiscount();
        result = result * PRIME + ($discount == null ? 43 : $discount.hashCode());
        return result;
      }
    }


    /**
     * Configures how the scheduled subscription behaves during the trial period.
     */
    public static class TrialSettings extends StripeObject {
      /** Defines how the subscription should behaves when a trial ensd. */
      @SerializedName("end_behavior")
      EndBehavior endBehavior;

      /** Defines how the scheduled subscription behaves when a trial ends. */
      public static class EndBehavior extends StripeObject {
        /**
         * Configure how an opt-in following a paid trial is billed when using {@code
         * billing_behavior: prorate_up_front}.
         *
         * <p>One of {@code defer}, or {@code include}.
         */
        @SerializedName("prorate_up_front")
        String prorateUpFront;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getProrateUpFront() {
          return this.prorateUpFront;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setProrateUpFront(final String prorateUpFront) {
          this.prorateUpFront = prorateUpFront;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof SubscriptionSchedule.Phase.TrialSettings.EndBehavior)) return false;
          final SubscriptionSchedule.Phase.TrialSettings.EndBehavior other = (SubscriptionSchedule.Phase.TrialSettings.EndBehavior) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$prorateUpFront = this.getProrateUpFront();
          final java.lang.Object other$prorateUpFront = other.getProrateUpFront();
          if (this$prorateUpFront == null ? other$prorateUpFront != null : !this$prorateUpFront.equals(other$prorateUpFront)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof SubscriptionSchedule.Phase.TrialSettings.EndBehavior;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $prorateUpFront = this.getProrateUpFront();
          result = result * PRIME + ($prorateUpFront == null ? 43 : $prorateUpFront.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public EndBehavior getEndBehavior() {
        return this.endBehavior;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setEndBehavior(final EndBehavior endBehavior) {
        this.endBehavior = endBehavior;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SubscriptionSchedule.Phase.TrialSettings)) return false;
        final SubscriptionSchedule.Phase.TrialSettings other = (SubscriptionSchedule.Phase.TrialSettings) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$endBehavior = this.getEndBehavior();
        final java.lang.Object other$endBehavior = other.getEndBehavior();
        if (this$endBehavior == null ? other$endBehavior != null : !this$endBehavior.equals(other$endBehavior)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SubscriptionSchedule.Phase.TrialSettings;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $endBehavior = this.getEndBehavior();
        result = result * PRIME + ($endBehavior == null ? 43 : $endBehavior.hashCode());
        return result;
      }
    }

    /**
     * A list of prices and quantities that will generate invoice items appended to the next invoice
     * for this phase.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<SubscriptionSchedule.AddInvoiceItem> getAddInvoiceItems() {
      return this.addInvoiceItems;
    }

    /**
     * A non-negative decimal between 0 and 100, with at most two decimal places. This represents
     * the percentage of the subscription invoice subtotal that will be transferred to the
     * application owner's Stripe account during this phase of the schedule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BigDecimal getApplicationFeePercent() {
      return this.applicationFeePercent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AutomaticTax getAutomaticTax() {
      return this.automaticTax;
    }

    /**
     * Possible values are {@code phase_start} or {@code automatic}. If {@code phase_start} then
     * billing cycle anchor of the subscription is set to the start of the phase when entering the
     * phase. If {@code automatic} then the billing cycle anchor is automatically modified as needed
     * when entering the phase. For more information, see the billing cycle <a
     * href="https://stripe.com/docs/billing/subscriptions/billing-cycle">documentation</a>.
     *
     * <p>One of {@code automatic}, or {@code phase_start}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBillingCycleAnchor() {
      return this.billingCycleAnchor;
    }

    /**
     * Define thresholds at which an invoice will be sent, and the subscription advanced to a new
     * billing period.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Subscription.BillingThresholds getBillingThresholds() {
      return this.billingThresholds;
    }

    /**
     * Either {@code charge_automatically}, or {@code send_invoice}. When charging automatically,
     * Stripe will attempt to pay the underlying subscription at the end of each billing cycle using
     * the default source attached to the customer. When sending an invoice, Stripe will email your
     * customer an invoice with payment instructions and mark the subscription as {@code active}.
     *
     * <p>One of {@code charge_automatically}, or {@code send_invoice}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCollectionMethod() {
      return this.collectionMethod;
    }

    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCurrency() {
      return this.currency;
    }

    /**
     * The default tax rates to apply to the subscription during this phase of the subscription
     * schedule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<TaxRate> getDefaultTaxRates() {
      return this.defaultTaxRates;
    }

    /**
     * Subscription description, meant to be displayable to the customer. Use this field to
     * optionally store an explanation of the subscription.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
      return this.description;
    }

    /**
     * The stackable discounts that will be applied to the subscription on this phase. Subscription
     * item discounts are applied before subscription discounts.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<SubscriptionSchedule.Phase.Discount> getDiscounts() {
      return this.discounts;
    }

    /**
     * The end of this phase of the subscription schedule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getEndDate() {
      return this.endDate;
    }

    /**
     * The invoice settings applicable during this phase.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public InvoiceSettings getInvoiceSettings() {
      return this.invoiceSettings;
    }

    /**
     * Subscription items to configure the subscription to during this phase of the subscription
     * schedule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<SubscriptionSchedule.PhaseItem> getItems() {
      return this.items;
    }

    /**
     * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
     * to a phase. Metadata on a schedule's phase will update the underlying subscription's {@code
     * metadata} when the phase is entered. Updating the underlying subscription's {@code metadata}
     * directly will not affect the current phase's {@code metadata}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getMetadata() {
      return this.metadata;
    }

    /**
     * If the subscription schedule will prorate when transitioning to this phase. Possible values
     * are {@code create_prorations} and {@code none}.
     *
     * <p>One of {@code always_invoice}, {@code create_prorations}, or {@code none}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getProrationBehavior() {
      return this.prorationBehavior;
    }

    /**
     * The start of this phase of the subscription schedule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getStartDate() {
      return this.startDate;
    }

    /**
     * The account (if any) the associated subscription's payments will be attributed to for tax
     * reporting, and where funds from each payment will be transferred to for each of the
     * subscription's invoices.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Subscription.TransferData getTransferData() {
      return this.transferData;
    }

    /**
     * Specify behavior of the trial when crossing schedule phase boundaries
     *
     * <p>One of {@code continue}, or {@code none}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTrialContinuation() {
      return this.trialContinuation;
    }

    /**
     * When the trial ends within the phase.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getTrialEnd() {
      return this.trialEnd;
    }

    /**
     * Settings related to any trials on the subscription during this phase.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TrialSettings getTrialSettings() {
      return this.trialSettings;
    }

    /**
     * A list of prices and quantities that will generate invoice items appended to the next invoice
     * for this phase.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddInvoiceItems(final List<SubscriptionSchedule.AddInvoiceItem> addInvoiceItems) {
      this.addInvoiceItems = addInvoiceItems;
    }

    /**
     * A non-negative decimal between 0 and 100, with at most two decimal places. This represents
     * the percentage of the subscription invoice subtotal that will be transferred to the
     * application owner's Stripe account during this phase of the schedule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setApplicationFeePercent(final BigDecimal applicationFeePercent) {
      this.applicationFeePercent = applicationFeePercent;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAutomaticTax(final AutomaticTax automaticTax) {
      this.automaticTax = automaticTax;
    }

    /**
     * Possible values are {@code phase_start} or {@code automatic}. If {@code phase_start} then
     * billing cycle anchor of the subscription is set to the start of the phase when entering the
     * phase. If {@code automatic} then the billing cycle anchor is automatically modified as needed
     * when entering the phase. For more information, see the billing cycle <a
     * href="https://stripe.com/docs/billing/subscriptions/billing-cycle">documentation</a>.
     *
     * <p>One of {@code automatic}, or {@code phase_start}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBillingCycleAnchor(final String billingCycleAnchor) {
      this.billingCycleAnchor = billingCycleAnchor;
    }

    /**
     * Define thresholds at which an invoice will be sent, and the subscription advanced to a new
     * billing period.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBillingThresholds(final Subscription.BillingThresholds billingThresholds) {
      this.billingThresholds = billingThresholds;
    }

    /**
     * Either {@code charge_automatically}, or {@code send_invoice}. When charging automatically,
     * Stripe will attempt to pay the underlying subscription at the end of each billing cycle using
     * the default source attached to the customer. When sending an invoice, Stripe will email your
     * customer an invoice with payment instructions and mark the subscription as {@code active}.
     *
     * <p>One of {@code charge_automatically}, or {@code send_invoice}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCollectionMethod(final String collectionMethod) {
      this.collectionMethod = collectionMethod;
    }

    /**
     * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency
     * code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported
     * currency</a>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrency(final String currency) {
      this.currency = currency;
    }

    /**
     * The default tax rates to apply to the subscription during this phase of the subscription
     * schedule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDefaultTaxRates(final List<TaxRate> defaultTaxRates) {
      this.defaultTaxRates = defaultTaxRates;
    }

    /**
     * Subscription description, meant to be displayable to the customer. Use this field to
     * optionally store an explanation of the subscription.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDescription(final String description) {
      this.description = description;
    }

    /**
     * The stackable discounts that will be applied to the subscription on this phase. Subscription
     * item discounts are applied before subscription discounts.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDiscounts(final List<SubscriptionSchedule.Phase.Discount> discounts) {
      this.discounts = discounts;
    }

    /**
     * The end of this phase of the subscription schedule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEndDate(final Long endDate) {
      this.endDate = endDate;
    }

    /**
     * The invoice settings applicable during this phase.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInvoiceSettings(final InvoiceSettings invoiceSettings) {
      this.invoiceSettings = invoiceSettings;
    }

    /**
     * Subscription items to configure the subscription to during this phase of the subscription
     * schedule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setItems(final List<SubscriptionSchedule.PhaseItem> items) {
      this.items = items;
    }

    /**
     * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
     * to a phase. Metadata on a schedule's phase will update the underlying subscription's {@code
     * metadata} when the phase is entered. Updating the underlying subscription's {@code metadata}
     * directly will not affect the current phase's {@code metadata}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMetadata(final Map<String, String> metadata) {
      this.metadata = metadata;
    }

    /**
     * If the subscription schedule will prorate when transitioning to this phase. Possible values
     * are {@code create_prorations} and {@code none}.
     *
     * <p>One of {@code always_invoice}, {@code create_prorations}, or {@code none}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProrationBehavior(final String prorationBehavior) {
      this.prorationBehavior = prorationBehavior;
    }

    /**
     * The start of this phase of the subscription schedule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStartDate(final Long startDate) {
      this.startDate = startDate;
    }

    /**
     * The account (if any) the associated subscription's payments will be attributed to for tax
     * reporting, and where funds from each payment will be transferred to for each of the
     * subscription's invoices.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTransferData(final Subscription.TransferData transferData) {
      this.transferData = transferData;
    }

    /**
     * Specify behavior of the trial when crossing schedule phase boundaries
     *
     * <p>One of {@code continue}, or {@code none}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTrialContinuation(final String trialContinuation) {
      this.trialContinuation = trialContinuation;
    }

    /**
     * When the trial ends within the phase.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTrialEnd(final Long trialEnd) {
      this.trialEnd = trialEnd;
    }

    /**
     * Settings related to any trials on the subscription during this phase.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTrialSettings(final TrialSettings trialSettings) {
      this.trialSettings = trialSettings;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof SubscriptionSchedule.Phase)) return false;
      final SubscriptionSchedule.Phase other = (SubscriptionSchedule.Phase) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$endDate = this.getEndDate();
      final java.lang.Object other$endDate = other.getEndDate();
      if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) return false;
      final java.lang.Object this$startDate = this.getStartDate();
      final java.lang.Object other$startDate = other.getStartDate();
      if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) return false;
      final java.lang.Object this$trialEnd = this.getTrialEnd();
      final java.lang.Object other$trialEnd = other.getTrialEnd();
      if (this$trialEnd == null ? other$trialEnd != null : !this$trialEnd.equals(other$trialEnd)) return false;
      final java.lang.Object this$addInvoiceItems = this.getAddInvoiceItems();
      final java.lang.Object other$addInvoiceItems = other.getAddInvoiceItems();
      if (this$addInvoiceItems == null ? other$addInvoiceItems != null : !this$addInvoiceItems.equals(other$addInvoiceItems)) return false;
      final java.lang.Object this$applicationFeePercent = this.getApplicationFeePercent();
      final java.lang.Object other$applicationFeePercent = other.getApplicationFeePercent();
      if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !this$applicationFeePercent.equals(other$applicationFeePercent)) return false;
      final java.lang.Object this$automaticTax = this.getAutomaticTax();
      final java.lang.Object other$automaticTax = other.getAutomaticTax();
      if (this$automaticTax == null ? other$automaticTax != null : !this$automaticTax.equals(other$automaticTax)) return false;
      final java.lang.Object this$billingCycleAnchor = this.getBillingCycleAnchor();
      final java.lang.Object other$billingCycleAnchor = other.getBillingCycleAnchor();
      if (this$billingCycleAnchor == null ? other$billingCycleAnchor != null : !this$billingCycleAnchor.equals(other$billingCycleAnchor)) return false;
      final java.lang.Object this$billingThresholds = this.getBillingThresholds();
      final java.lang.Object other$billingThresholds = other.getBillingThresholds();
      if (this$billingThresholds == null ? other$billingThresholds != null : !this$billingThresholds.equals(other$billingThresholds)) return false;
      final java.lang.Object this$collectionMethod = this.getCollectionMethod();
      final java.lang.Object other$collectionMethod = other.getCollectionMethod();
      if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) return false;
      final java.lang.Object this$coupon = this.getCoupon();
      final java.lang.Object other$coupon = other.getCoupon();
      if (this$coupon == null ? other$coupon != null : !this$coupon.equals(other$coupon)) return false;
      final java.lang.Object this$currency = this.getCurrency();
      final java.lang.Object other$currency = other.getCurrency();
      if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
      final java.lang.Object this$defaultPaymentMethod = this.getDefaultPaymentMethod();
      final java.lang.Object other$defaultPaymentMethod = other.getDefaultPaymentMethod();
      if (this$defaultPaymentMethod == null ? other$defaultPaymentMethod != null : !this$defaultPaymentMethod.equals(other$defaultPaymentMethod)) return false;
      final java.lang.Object this$defaultTaxRates = this.getDefaultTaxRates();
      final java.lang.Object other$defaultTaxRates = other.getDefaultTaxRates();
      if (this$defaultTaxRates == null ? other$defaultTaxRates != null : !this$defaultTaxRates.equals(other$defaultTaxRates)) return false;
      final java.lang.Object this$description = this.getDescription();
      final java.lang.Object other$description = other.getDescription();
      if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
      final java.lang.Object this$discounts = this.getDiscounts();
      final java.lang.Object other$discounts = other.getDiscounts();
      if (this$discounts == null ? other$discounts != null : !this$discounts.equals(other$discounts)) return false;
      final java.lang.Object this$invoiceSettings = this.getInvoiceSettings();
      final java.lang.Object other$invoiceSettings = other.getInvoiceSettings();
      if (this$invoiceSettings == null ? other$invoiceSettings != null : !this$invoiceSettings.equals(other$invoiceSettings)) return false;
      final java.lang.Object this$items = this.getItems();
      final java.lang.Object other$items = other.getItems();
      if (this$items == null ? other$items != null : !this$items.equals(other$items)) return false;
      final java.lang.Object this$metadata = this.getMetadata();
      final java.lang.Object other$metadata = other.getMetadata();
      if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
      final java.lang.Object this$onBehalfOf = this.getOnBehalfOf();
      final java.lang.Object other$onBehalfOf = other.getOnBehalfOf();
      if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) return false;
      final java.lang.Object this$prorationBehavior = this.getProrationBehavior();
      final java.lang.Object other$prorationBehavior = other.getProrationBehavior();
      if (this$prorationBehavior == null ? other$prorationBehavior != null : !this$prorationBehavior.equals(other$prorationBehavior)) return false;
      final java.lang.Object this$transferData = this.getTransferData();
      final java.lang.Object other$transferData = other.getTransferData();
      if (this$transferData == null ? other$transferData != null : !this$transferData.equals(other$transferData)) return false;
      final java.lang.Object this$trialContinuation = this.getTrialContinuation();
      final java.lang.Object other$trialContinuation = other.getTrialContinuation();
      if (this$trialContinuation == null ? other$trialContinuation != null : !this$trialContinuation.equals(other$trialContinuation)) return false;
      final java.lang.Object this$trialSettings = this.getTrialSettings();
      final java.lang.Object other$trialSettings = other.getTrialSettings();
      if (this$trialSettings == null ? other$trialSettings != null : !this$trialSettings.equals(other$trialSettings)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof SubscriptionSchedule.Phase;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $endDate = this.getEndDate();
      result = result * PRIME + ($endDate == null ? 43 : $endDate.hashCode());
      final java.lang.Object $startDate = this.getStartDate();
      result = result * PRIME + ($startDate == null ? 43 : $startDate.hashCode());
      final java.lang.Object $trialEnd = this.getTrialEnd();
      result = result * PRIME + ($trialEnd == null ? 43 : $trialEnd.hashCode());
      final java.lang.Object $addInvoiceItems = this.getAddInvoiceItems();
      result = result * PRIME + ($addInvoiceItems == null ? 43 : $addInvoiceItems.hashCode());
      final java.lang.Object $applicationFeePercent = this.getApplicationFeePercent();
      result = result * PRIME + ($applicationFeePercent == null ? 43 : $applicationFeePercent.hashCode());
      final java.lang.Object $automaticTax = this.getAutomaticTax();
      result = result * PRIME + ($automaticTax == null ? 43 : $automaticTax.hashCode());
      final java.lang.Object $billingCycleAnchor = this.getBillingCycleAnchor();
      result = result * PRIME + ($billingCycleAnchor == null ? 43 : $billingCycleAnchor.hashCode());
      final java.lang.Object $billingThresholds = this.getBillingThresholds();
      result = result * PRIME + ($billingThresholds == null ? 43 : $billingThresholds.hashCode());
      final java.lang.Object $collectionMethod = this.getCollectionMethod();
      result = result * PRIME + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
      final java.lang.Object $coupon = this.getCoupon();
      result = result * PRIME + ($coupon == null ? 43 : $coupon.hashCode());
      final java.lang.Object $currency = this.getCurrency();
      result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
      final java.lang.Object $defaultPaymentMethod = this.getDefaultPaymentMethod();
      result = result * PRIME + ($defaultPaymentMethod == null ? 43 : $defaultPaymentMethod.hashCode());
      final java.lang.Object $defaultTaxRates = this.getDefaultTaxRates();
      result = result * PRIME + ($defaultTaxRates == null ? 43 : $defaultTaxRates.hashCode());
      final java.lang.Object $description = this.getDescription();
      result = result * PRIME + ($description == null ? 43 : $description.hashCode());
      final java.lang.Object $discounts = this.getDiscounts();
      result = result * PRIME + ($discounts == null ? 43 : $discounts.hashCode());
      final java.lang.Object $invoiceSettings = this.getInvoiceSettings();
      result = result * PRIME + ($invoiceSettings == null ? 43 : $invoiceSettings.hashCode());
      final java.lang.Object $items = this.getItems();
      result = result * PRIME + ($items == null ? 43 : $items.hashCode());
      final java.lang.Object $metadata = this.getMetadata();
      result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
      final java.lang.Object $onBehalfOf = this.getOnBehalfOf();
      result = result * PRIME + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
      final java.lang.Object $prorationBehavior = this.getProrationBehavior();
      result = result * PRIME + ($prorationBehavior == null ? 43 : $prorationBehavior.hashCode());
      final java.lang.Object $transferData = this.getTransferData();
      result = result * PRIME + ($transferData == null ? 43 : $transferData.hashCode());
      final java.lang.Object $trialContinuation = this.getTrialContinuation();
      result = result * PRIME + ($trialContinuation == null ? 43 : $trialContinuation.hashCode());
      final java.lang.Object $trialSettings = this.getTrialSettings();
      result = result * PRIME + ($trialSettings == null ? 43 : $trialSettings.hashCode());
      return result;
    }
  }


  /**
   * A phase item describes the price and quantity of a phase.
   */
  public static class PhaseItem extends StripeObject {
    /**
     * Define thresholds at which an invoice will be sent, and the related subscription advanced to
     * a new billing period.
     */
    @SerializedName("billing_thresholds")
    SubscriptionItem.BillingThresholds billingThresholds;
    /**
     * The discounts applied to the subscription item. Subscription item discounts are applied
     * before subscription discounts. Use {@code expand[]=discounts} to expand each discount.
     */
    @SerializedName("discounts")
    List<SubscriptionSchedule.PhaseItem.StackableDiscount> discounts;
    /**
     * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
     * to an item. Metadata on this item will update the underlying subscription item's {@code
     * metadata} when the phase is entered.
     */
    @SerializedName("metadata")
    Map<String, String> metadata;
    /**
     * ID of the plan to which the customer should be subscribed.
     */
    @SerializedName("plan")
    ExpandableField<Plan> plan;
    /**
     * ID of the price to which the customer should be subscribed.
     */
    @SerializedName("price")
    ExpandableField<Price> price;
    /**
     * Quantity of the plan to which the customer should be subscribed.
     */
    @SerializedName("quantity")
    Long quantity;
    /**
     * The tax rates which apply to this {@code phase_item}. When set, the {@code default_tax_rates}
     * on the phase do not apply to this {@code phase_item}.
     */
    @SerializedName("tax_rates")
    List<TaxRate> taxRates;
    /**
     * Options that configure the trial on the subscription item.
     */
    @SerializedName("trial")
    Trial trial;

    /**
     * Get ID of expandable {@code plan} object.
     */
    public String getPlan() {
      return (this.plan != null) ? this.plan.getId() : null;
    }

    public void setPlan(String id) {
      this.plan = ApiResource.setExpandableFieldId(id, this.plan);
    }

    /**
     * Get expanded {@code plan}.
     */
    public Plan getPlanObject() {
      return (this.plan != null) ? this.plan.getExpanded() : null;
    }

    public void setPlanObject(Plan expandableObject) {
      this.plan = new ExpandableField<Plan>(expandableObject.getId(), expandableObject);
    }

    /**
     * Get ID of expandable {@code price} object.
     */
    public String getPrice() {
      return (this.price != null) ? this.price.getId() : null;
    }

    public void setPrice(String id) {
      this.price = ApiResource.setExpandableFieldId(id, this.price);
    }

    /**
     * Get expanded {@code price}.
     */
    public Price getPriceObject() {
      return (this.price != null) ? this.price.getExpanded() : null;
    }

    public void setPriceObject(Price expandableObject) {
      this.price = new ExpandableField<Price>(expandableObject.getId(), expandableObject);
    }


    public static class StackableDiscount extends StripeObject {
      /**
       * ID of the coupon to create a new discount for.
       */
      @SerializedName("coupon")
      ExpandableField<Coupon> coupon;
      /**
       * ID of an existing discount on the object (or one of its ancestors) to reuse.
       */
      @SerializedName("discount")
      ExpandableField<Discount> discount;

      /**
       * Get ID of expandable {@code coupon} object.
       */
      public String getCoupon() {
        return (this.coupon != null) ? this.coupon.getId() : null;
      }

      public void setCoupon(String id) {
        this.coupon = ApiResource.setExpandableFieldId(id, this.coupon);
      }

      /**
       * Get expanded {@code coupon}.
       */
      public Coupon getCouponObject() {
        return (this.coupon != null) ? this.coupon.getExpanded() : null;
      }

      public void setCouponObject(Coupon expandableObject) {
        this.coupon = new ExpandableField<Coupon>(expandableObject.getId(), expandableObject);
      }

      /**
       * Get ID of expandable {@code discount} object.
       */
      public String getDiscount() {
        return (this.discount != null) ? this.discount.getId() : null;
      }

      public void setDiscount(String id) {
        this.discount = ApiResource.setExpandableFieldId(id, this.discount);
      }

      /**
       * Get expanded {@code discount}.
       */
      public Discount getDiscountObject() {
        return (this.discount != null) ? this.discount.getExpanded() : null;
      }

      public void setDiscountObject(Discount expandableObject) {
        this.discount = new ExpandableField<Discount>(expandableObject.getId(), expandableObject);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SubscriptionSchedule.PhaseItem.StackableDiscount)) return false;
        final SubscriptionSchedule.PhaseItem.StackableDiscount other = (SubscriptionSchedule.PhaseItem.StackableDiscount) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$coupon = this.getCoupon();
        final java.lang.Object other$coupon = other.getCoupon();
        if (this$coupon == null ? other$coupon != null : !this$coupon.equals(other$coupon)) return false;
        final java.lang.Object this$discount = this.getDiscount();
        final java.lang.Object other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SubscriptionSchedule.PhaseItem.StackableDiscount;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $coupon = this.getCoupon();
        result = result * PRIME + ($coupon == null ? 43 : $coupon.hashCode());
        final java.lang.Object $discount = this.getDiscount();
        result = result * PRIME + ($discount == null ? 43 : $discount.hashCode());
        return result;
      }
    }


    public static class Trial extends StripeObject {
      /**
       * List of price IDs which, if present on the subscription following a paid trial, constitute
       * opting-in to the paid trial.
       */
      @SerializedName("converts_to")
      List<String> convertsTo;
      @SerializedName("type")
      String type;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getConvertsTo() {
        return this.convertsTo;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getType() {
        return this.type;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setConvertsTo(final List<String> convertsTo) {
        this.convertsTo = convertsTo;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setType(final String type) {
        this.type = type;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SubscriptionSchedule.PhaseItem.Trial)) return false;
        final SubscriptionSchedule.PhaseItem.Trial other = (SubscriptionSchedule.PhaseItem.Trial) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$convertsTo = this.getConvertsTo();
        final java.lang.Object other$convertsTo = other.getConvertsTo();
        if (this$convertsTo == null ? other$convertsTo != null : !this$convertsTo.equals(other$convertsTo)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SubscriptionSchedule.PhaseItem.Trial;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $convertsTo = this.getConvertsTo();
        result = result * PRIME + ($convertsTo == null ? 43 : $convertsTo.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        return result;
      }
    }

    /**
     * Define thresholds at which an invoice will be sent, and the related subscription advanced to
     * a new billing period.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SubscriptionItem.BillingThresholds getBillingThresholds() {
      return this.billingThresholds;
    }

    /**
     * The discounts applied to the subscription item. Subscription item discounts are applied
     * before subscription discounts. Use {@code expand[]=discounts} to expand each discount.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<SubscriptionSchedule.PhaseItem.StackableDiscount> getDiscounts() {
      return this.discounts;
    }

    /**
     * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
     * to an item. Metadata on this item will update the underlying subscription item's {@code
     * metadata} when the phase is entered.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getMetadata() {
      return this.metadata;
    }

    /**
     * Quantity of the plan to which the customer should be subscribed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQuantity() {
      return this.quantity;
    }

    /**
     * The tax rates which apply to this {@code phase_item}. When set, the {@code default_tax_rates}
     * on the phase do not apply to this {@code phase_item}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<TaxRate> getTaxRates() {
      return this.taxRates;
    }

    /**
     * Options that configure the trial on the subscription item.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Trial getTrial() {
      return this.trial;
    }

    /**
     * Define thresholds at which an invoice will be sent, and the related subscription advanced to
     * a new billing period.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBillingThresholds(final SubscriptionItem.BillingThresholds billingThresholds) {
      this.billingThresholds = billingThresholds;
    }

    /**
     * The discounts applied to the subscription item. Subscription item discounts are applied
     * before subscription discounts. Use {@code expand[]=discounts} to expand each discount.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDiscounts(final List<SubscriptionSchedule.PhaseItem.StackableDiscount> discounts) {
      this.discounts = discounts;
    }

    /**
     * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
     * to an item. Metadata on this item will update the underlying subscription item's {@code
     * metadata} when the phase is entered.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMetadata(final Map<String, String> metadata) {
      this.metadata = metadata;
    }

    /**
     * Quantity of the plan to which the customer should be subscribed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setQuantity(final Long quantity) {
      this.quantity = quantity;
    }

    /**
     * The tax rates which apply to this {@code phase_item}. When set, the {@code default_tax_rates}
     * on the phase do not apply to this {@code phase_item}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTaxRates(final List<TaxRate> taxRates) {
      this.taxRates = taxRates;
    }

    /**
     * Options that configure the trial on the subscription item.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTrial(final Trial trial) {
      this.trial = trial;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof SubscriptionSchedule.PhaseItem)) return false;
      final SubscriptionSchedule.PhaseItem other = (SubscriptionSchedule.PhaseItem) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$quantity = this.getQuantity();
      final java.lang.Object other$quantity = other.getQuantity();
      if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) return false;
      final java.lang.Object this$billingThresholds = this.getBillingThresholds();
      final java.lang.Object other$billingThresholds = other.getBillingThresholds();
      if (this$billingThresholds == null ? other$billingThresholds != null : !this$billingThresholds.equals(other$billingThresholds)) return false;
      final java.lang.Object this$discounts = this.getDiscounts();
      final java.lang.Object other$discounts = other.getDiscounts();
      if (this$discounts == null ? other$discounts != null : !this$discounts.equals(other$discounts)) return false;
      final java.lang.Object this$metadata = this.getMetadata();
      final java.lang.Object other$metadata = other.getMetadata();
      if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
      final java.lang.Object this$plan = this.getPlan();
      final java.lang.Object other$plan = other.getPlan();
      if (this$plan == null ? other$plan != null : !this$plan.equals(other$plan)) return false;
      final java.lang.Object this$price = this.getPrice();
      final java.lang.Object other$price = other.getPrice();
      if (this$price == null ? other$price != null : !this$price.equals(other$price)) return false;
      final java.lang.Object this$taxRates = this.getTaxRates();
      final java.lang.Object other$taxRates = other.getTaxRates();
      if (this$taxRates == null ? other$taxRates != null : !this$taxRates.equals(other$taxRates)) return false;
      final java.lang.Object this$trial = this.getTrial();
      final java.lang.Object other$trial = other.getTrial();
      if (this$trial == null ? other$trial != null : !this$trial.equals(other$trial)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof SubscriptionSchedule.PhaseItem;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $quantity = this.getQuantity();
      result = result * PRIME + ($quantity == null ? 43 : $quantity.hashCode());
      final java.lang.Object $billingThresholds = this.getBillingThresholds();
      result = result * PRIME + ($billingThresholds == null ? 43 : $billingThresholds.hashCode());
      final java.lang.Object $discounts = this.getDiscounts();
      result = result * PRIME + ($discounts == null ? 43 : $discounts.hashCode());
      final java.lang.Object $metadata = this.getMetadata();
      result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
      final java.lang.Object $plan = this.getPlan();
      result = result * PRIME + ($plan == null ? 43 : $plan.hashCode());
      final java.lang.Object $price = this.getPrice();
      result = result * PRIME + ($price == null ? 43 : $price.hashCode());
      final java.lang.Object $taxRates = this.getTaxRates();
      result = result * PRIME + ($taxRates == null ? 43 : $taxRates.hashCode());
      final java.lang.Object $trial = this.getTrial();
      result = result * PRIME + ($trial == null ? 43 : $trial.hashCode());
      return result;
    }
  }


  /**
   * Prebilling stores the time period and invoice for a Subscription billed in advance.
   */
  public static class Prebilling extends StripeObject {
    /** ID of the prebilling invoice. */
    @SerializedName("invoice")
    ExpandableField<Invoice> invoice;
    /** The end of the last period for which the invoice pre-bills. */
    @SerializedName("period_end")
    Long periodEnd;
    /** The start of the first period for which the invoice pre-bills. */
    @SerializedName("period_start")
    Long periodStart;

    /** Get ID of expandable {@code invoice} object. */
    public String getInvoice() {
      return (this.invoice != null) ? this.invoice.getId() : null;
    }

    public void setInvoice(String id) {
      this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
    }

    /** Get expanded {@code invoice}. */
    public Invoice getInvoiceObject() {
      return (this.invoice != null) ? this.invoice.getExpanded() : null;
    }

    public void setInvoiceObject(Invoice expandableObject) {
      this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPeriodEnd() {
      return this.periodEnd;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPeriodStart() {
      return this.periodStart;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPeriodEnd(final Long periodEnd) {
      this.periodEnd = periodEnd;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPeriodStart(final Long periodStart) {
      this.periodStart = periodStart;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof SubscriptionSchedule.Prebilling)) return false;
      final SubscriptionSchedule.Prebilling other = (SubscriptionSchedule.Prebilling) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$periodEnd = this.getPeriodEnd();
      final java.lang.Object other$periodEnd = other.getPeriodEnd();
      if (this$periodEnd == null ? other$periodEnd != null : !this$periodEnd.equals(other$periodEnd)) return false;
      final java.lang.Object this$periodStart = this.getPeriodStart();
      final java.lang.Object other$periodStart = other.getPeriodStart();
      if (this$periodStart == null ? other$periodStart != null : !this$periodStart.equals(other$periodStart)) return false;
      final java.lang.Object this$invoice = this.getInvoice();
      final java.lang.Object other$invoice = other.getInvoice();
      if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof SubscriptionSchedule.Prebilling;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $periodEnd = this.getPeriodEnd();
      result = result * PRIME + ($periodEnd == null ? 43 : $periodEnd.hashCode());
      final java.lang.Object $periodStart = this.getPeriodStart();
      result = result * PRIME + ($periodStart == null ? 43 : $periodStart.hashCode());
      final java.lang.Object $invoice = this.getInvoice();
      result = result * PRIME + ($invoice == null ? 43 : $invoice.hashCode());
      return result;
    }
  }

  /**
   * Configures when the subscription schedule generates prorations for phase transitions. Possible
   * values are {@code prorate_on_next_phase} or {@code prorate_up_front} with the default being
   * {@code prorate_on_next_phase}. {@code prorate_on_next_phase} will apply phase changes and
   * generate prorations at transition time.{@code prorate_up_front} will bill for all phases within
   * the current billing cycle up front.
   *
   * <p>One of {@code prorate_on_next_phase}, or {@code prorate_up_front}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBillingBehavior() {
    return this.billingBehavior;
  }

  /**
   * Time at which the subscription schedule was canceled. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCanceledAt() {
    return this.canceledAt;
  }

  /**
   * Time at which the subscription schedule was completed. Measured in seconds since the Unix
   * epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCompletedAt() {
    return this.completedAt;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Object representing the start and end dates for the current phase of the subscription schedule,
   * if it is {@code active}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CurrentPhase getCurrentPhase() {
    return this.currentPhase;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DefaultSettings getDefaultSettings() {
    return this.defaultSettings;
  }

  /**
   * Behavior of the subscription schedule and underlying subscription when it ends. Possible values
   * are {@code release} and {@code cancel}.
   *
   * <p>One of {@code cancel}, {@code none}, {@code release}, or {@code renew}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEndBehavior() {
    return this.endBehavior;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code subscription_schedule}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Configuration for the subscription schedule's phases.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<SubscriptionSchedule.Phase> getPhases() {
    return this.phases;
  }

  /**
   * Time period and invoice for a Subscription billed in advance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Prebilling getPrebilling() {
    return this.prebilling;
  }

  /**
   * Time at which the subscription schedule was released. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getReleasedAt() {
    return this.releasedAt;
  }

  /**
   * ID of the subscription once managed by the subscription schedule (if it is released).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReleasedSubscription() {
    return this.releasedSubscription;
  }

  /**
   * The present status of the subscription schedule. Possible values are {@code not_started},
   * {@code active}, {@code completed}, {@code released}, and {@code canceled}. You can read more
   * about the different states in our <a
   * href="https://stripe.com/docs/billing/subscriptions/subscription-schedules">behavior guide</a>.
   *
   * <p>One of {@code active}, {@code canceled}, {@code completed}, {@code not_started}, or {@code
   * released}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * Configures when the subscription schedule generates prorations for phase transitions. Possible
   * values are {@code prorate_on_next_phase} or {@code prorate_up_front} with the default being
   * {@code prorate_on_next_phase}. {@code prorate_on_next_phase} will apply phase changes and
   * generate prorations at transition time.{@code prorate_up_front} will bill for all phases within
   * the current billing cycle up front.
   *
   * <p>One of {@code prorate_on_next_phase}, or {@code prorate_up_front}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingBehavior(final String billingBehavior) {
    this.billingBehavior = billingBehavior;
  }

  /**
   * Time at which the subscription schedule was canceled. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCanceledAt(final Long canceledAt) {
    this.canceledAt = canceledAt;
  }

  /**
   * Time at which the subscription schedule was completed. Measured in seconds since the Unix
   * epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCompletedAt(final Long completedAt) {
    this.completedAt = completedAt;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Object representing the start and end dates for the current phase of the subscription schedule,
   * if it is {@code active}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrentPhase(final CurrentPhase currentPhase) {
    this.currentPhase = currentPhase;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDefaultSettings(final DefaultSettings defaultSettings) {
    this.defaultSettings = defaultSettings;
  }

  /**
   * Behavior of the subscription schedule and underlying subscription when it ends. Possible values
   * are {@code release} and {@code cancel}.
   *
   * <p>One of {@code cancel}, {@code none}, {@code release}, or {@code renew}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEndBehavior(final String endBehavior) {
    this.endBehavior = endBehavior;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code subscription_schedule}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Configuration for the subscription schedule's phases.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPhases(final List<SubscriptionSchedule.Phase> phases) {
    this.phases = phases;
  }

  /**
   * Time period and invoice for a Subscription billed in advance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPrebilling(final Prebilling prebilling) {
    this.prebilling = prebilling;
  }

  /**
   * Time at which the subscription schedule was released. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReleasedAt(final Long releasedAt) {
    this.releasedAt = releasedAt;
  }

  /**
   * ID of the subscription once managed by the subscription schedule (if it is released).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReleasedSubscription(final String releasedSubscription) {
    this.releasedSubscription = releasedSubscription;
  }

  /**
   * The present status of the subscription schedule. Possible values are {@code not_started},
   * {@code active}, {@code completed}, {@code released}, and {@code canceled}. You can read more
   * about the different states in our <a
   * href="https://stripe.com/docs/billing/subscriptions/subscription-schedules">behavior guide</a>.
   *
   * <p>One of {@code active}, {@code canceled}, {@code completed}, {@code not_started}, or {@code
   * released}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof SubscriptionSchedule)) return false;
    final SubscriptionSchedule other = (SubscriptionSchedule) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$canceledAt = this.getCanceledAt();
    final java.lang.Object other$canceledAt = other.getCanceledAt();
    if (this$canceledAt == null ? other$canceledAt != null : !this$canceledAt.equals(other$canceledAt)) return false;
    final java.lang.Object this$completedAt = this.getCompletedAt();
    final java.lang.Object other$completedAt = other.getCompletedAt();
    if (this$completedAt == null ? other$completedAt != null : !this$completedAt.equals(other$completedAt)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$releasedAt = this.getReleasedAt();
    final java.lang.Object other$releasedAt = other.getReleasedAt();
    if (this$releasedAt == null ? other$releasedAt != null : !this$releasedAt.equals(other$releasedAt)) return false;
    final java.lang.Object this$application = this.getApplication();
    final java.lang.Object other$application = other.getApplication();
    if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
    final java.lang.Object this$billingBehavior = this.getBillingBehavior();
    final java.lang.Object other$billingBehavior = other.getBillingBehavior();
    if (this$billingBehavior == null ? other$billingBehavior != null : !this$billingBehavior.equals(other$billingBehavior)) return false;
    final java.lang.Object this$currentPhase = this.getCurrentPhase();
    final java.lang.Object other$currentPhase = other.getCurrentPhase();
    if (this$currentPhase == null ? other$currentPhase != null : !this$currentPhase.equals(other$currentPhase)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$defaultSettings = this.getDefaultSettings();
    final java.lang.Object other$defaultSettings = other.getDefaultSettings();
    if (this$defaultSettings == null ? other$defaultSettings != null : !this$defaultSettings.equals(other$defaultSettings)) return false;
    final java.lang.Object this$endBehavior = this.getEndBehavior();
    final java.lang.Object other$endBehavior = other.getEndBehavior();
    if (this$endBehavior == null ? other$endBehavior != null : !this$endBehavior.equals(other$endBehavior)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$phases = this.getPhases();
    final java.lang.Object other$phases = other.getPhases();
    if (this$phases == null ? other$phases != null : !this$phases.equals(other$phases)) return false;
    final java.lang.Object this$prebilling = this.getPrebilling();
    final java.lang.Object other$prebilling = other.getPrebilling();
    if (this$prebilling == null ? other$prebilling != null : !this$prebilling.equals(other$prebilling)) return false;
    final java.lang.Object this$releasedSubscription = this.getReleasedSubscription();
    final java.lang.Object other$releasedSubscription = other.getReleasedSubscription();
    if (this$releasedSubscription == null ? other$releasedSubscription != null : !this$releasedSubscription.equals(other$releasedSubscription)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$subscription = this.getSubscription();
    final java.lang.Object other$subscription = other.getSubscription();
    if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) return false;
    final java.lang.Object this$testClock = this.getTestClock();
    final java.lang.Object other$testClock = other.getTestClock();
    if (this$testClock == null ? other$testClock != null : !this$testClock.equals(other$testClock)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof SubscriptionSchedule;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $canceledAt = this.getCanceledAt();
    result = result * PRIME + ($canceledAt == null ? 43 : $canceledAt.hashCode());
    final java.lang.Object $completedAt = this.getCompletedAt();
    result = result * PRIME + ($completedAt == null ? 43 : $completedAt.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $releasedAt = this.getReleasedAt();
    result = result * PRIME + ($releasedAt == null ? 43 : $releasedAt.hashCode());
    final java.lang.Object $application = this.getApplication();
    result = result * PRIME + ($application == null ? 43 : $application.hashCode());
    final java.lang.Object $billingBehavior = this.getBillingBehavior();
    result = result * PRIME + ($billingBehavior == null ? 43 : $billingBehavior.hashCode());
    final java.lang.Object $currentPhase = this.getCurrentPhase();
    result = result * PRIME + ($currentPhase == null ? 43 : $currentPhase.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $defaultSettings = this.getDefaultSettings();
    result = result * PRIME + ($defaultSettings == null ? 43 : $defaultSettings.hashCode());
    final java.lang.Object $endBehavior = this.getEndBehavior();
    result = result * PRIME + ($endBehavior == null ? 43 : $endBehavior.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $phases = this.getPhases();
    result = result * PRIME + ($phases == null ? 43 : $phases.hashCode());
    final java.lang.Object $prebilling = this.getPrebilling();
    result = result * PRIME + ($prebilling == null ? 43 : $prebilling.hashCode());
    final java.lang.Object $releasedSubscription = this.getReleasedSubscription();
    result = result * PRIME + ($releasedSubscription == null ? 43 : $releasedSubscription.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $subscription = this.getSubscription();
    result = result * PRIME + ($subscription == null ? 43 : $subscription.hashCode());
    final java.lang.Object $testClock = this.getTestClock();
    result = result * PRIME + ($testClock == null ? 43 : $testClock.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
