// Generated by delombok at Thu Nov 10 23:10:45 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.capital;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.capital.FinancingSummaryRetrieveParams;
import java.math.BigDecimal;
import java.util.Map;

/**
 * A financing object describes an account's current financing state. Used by Connect platforms to
 * read the state of Capital offered to their connected accounts.
 */
public class FinancingSummary extends ApiResource {
  /**
   * Additional information about the financing summary. Describes currency, advance amount, fee
   * amount, withhold rate, remaining amount, paid amount, current repayment interval, repayment
   * start date, and advance payout date.
   */
  @SerializedName("details")
  Details details;
  /**
   * The object type: financing_summary
   *
   * <p>Equal to {@code capital.financing_summary}.
   */
  @SerializedName("object")
  String object;
  /**
   * Status of the Connected Account's financing. <a
   * href="https://stripe.com/docs/api/capital/financing_summary">/v1/capital/financing_summary</a>
   * will only return {@code details} for {@code paid_out} financing.
   *
   * <p>One of {@code accepted}, {@code delivered}, or {@code none}.
   */
  @SerializedName("status")
  String status;

  /**
   * Retrieve the financing state for the account that was authenticated in the request.
   */
  public static FinancingSummary retrieve() throws StripeException {
    return retrieve((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieve the financing state for the account that was authenticated in the request.
   */
  public static FinancingSummary retrieve(RequestOptions options) throws StripeException {
    return retrieve((Map<String, Object>) null, options);
  }

  /**
   * Retrieve the financing state for the account that was authenticated in the request.
   */
  public static FinancingSummary retrieve(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/capital/financing_summary");
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FinancingSummary.class, options);
  }

  /**
   * Retrieve the financing state for the account that was authenticated in the request.
   */
  public static FinancingSummary retrieve(FinancingSummaryRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/capital/financing_summary");
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FinancingSummary.class, options);
  }


  public static class Details extends StripeObject {
    /** Amount of financing offered, in minor units. */
    @SerializedName("advance_amount")
    Long advanceAmount;
    /**
     * The time at which the funds were paid out the the Connected account's Stripe balance. Given
     * in milliseconds since unix epoch.
     */
    @SerializedName("advance_paid_out_at")
    BigDecimal advancePaidOutAt;
    /** Currency that the financing offer is transacted in. For example, {@code usd}. */
    @SerializedName("currency")
    String currency;
    /** The chronologically current repayment interval for the financing offer. */
    @SerializedName("current_repayment_interval")
    CurrentRepaymentInterval currentRepaymentInterval;
    /** Fixed fee amount, in minor units. */
    @SerializedName("fee_amount")
    Long feeAmount;
    /** The amount the Connected account has paid toward the financing debt so far. */
    @SerializedName("paid_amount")
    Long paidAmount;
    /** The balance remaining to be paid on the financing, in minor units. */
    @SerializedName("remaining_amount")
    Long remainingAmount;
    /**
     * The time at which Capital will begin withholding from payments. Given in seconds since unix
     * epoch.
     */
    @SerializedName("repayments_begin_at")
    BigDecimal repaymentsBeginAt;
    /** Per-transaction rate at which Stripe will withhold funds to repay the financing. */
    @SerializedName("withhold_rate")
    BigDecimal withholdRate;

    /** The current repayment interval for the Connected account. */
    public static class CurrentRepaymentInterval extends StripeObject {
      /**
       * The time at which the minimum payment amount will be due. If not met through withholding,
       * the Connected account's linked bank account will be debited. Given in seconds since unix
       * epoch.
       */
      @SerializedName("due_at")
      BigDecimal dueAt;
      /** The amount that has already been paid in the current repayment interval. */
      @SerializedName("paid_amount")
      Long paidAmount;
      /** The amount that is yet to be paid in the current repayment interval. */
      @SerializedName("remaining_amount")
      Long remainingAmount;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public BigDecimal getDueAt() {
        return this.dueAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getPaidAmount() {
        return this.paidAmount;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getRemainingAmount() {
        return this.remainingAmount;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDueAt(final BigDecimal dueAt) {
        this.dueAt = dueAt;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPaidAmount(final Long paidAmount) {
        this.paidAmount = paidAmount;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRemainingAmount(final Long remainingAmount) {
        this.remainingAmount = remainingAmount;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof FinancingSummary.Details.CurrentRepaymentInterval)) return false;
        final FinancingSummary.Details.CurrentRepaymentInterval other = (FinancingSummary.Details.CurrentRepaymentInterval) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$paidAmount = this.getPaidAmount();
        final java.lang.Object other$paidAmount = other.getPaidAmount();
        if (this$paidAmount == null ? other$paidAmount != null : !this$paidAmount.equals(other$paidAmount)) return false;
        final java.lang.Object this$remainingAmount = this.getRemainingAmount();
        final java.lang.Object other$remainingAmount = other.getRemainingAmount();
        if (this$remainingAmount == null ? other$remainingAmount != null : !this$remainingAmount.equals(other$remainingAmount)) return false;
        final java.lang.Object this$dueAt = this.getDueAt();
        final java.lang.Object other$dueAt = other.getDueAt();
        if (this$dueAt == null ? other$dueAt != null : !this$dueAt.equals(other$dueAt)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof FinancingSummary.Details.CurrentRepaymentInterval;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $paidAmount = this.getPaidAmount();
        result = result * PRIME + ($paidAmount == null ? 43 : $paidAmount.hashCode());
        final java.lang.Object $remainingAmount = this.getRemainingAmount();
        result = result * PRIME + ($remainingAmount == null ? 43 : $remainingAmount.hashCode());
        final java.lang.Object $dueAt = this.getDueAt();
        result = result * PRIME + ($dueAt == null ? 43 : $dueAt.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAdvanceAmount() {
      return this.advanceAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BigDecimal getAdvancePaidOutAt() {
      return this.advancePaidOutAt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCurrency() {
      return this.currency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CurrentRepaymentInterval getCurrentRepaymentInterval() {
      return this.currentRepaymentInterval;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getFeeAmount() {
      return this.feeAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPaidAmount() {
      return this.paidAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getRemainingAmount() {
      return this.remainingAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BigDecimal getRepaymentsBeginAt() {
      return this.repaymentsBeginAt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BigDecimal getWithholdRate() {
      return this.withholdRate;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAdvanceAmount(final Long advanceAmount) {
      this.advanceAmount = advanceAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAdvancePaidOutAt(final BigDecimal advancePaidOutAt) {
      this.advancePaidOutAt = advancePaidOutAt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrency(final String currency) {
      this.currency = currency;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrentRepaymentInterval(final CurrentRepaymentInterval currentRepaymentInterval) {
      this.currentRepaymentInterval = currentRepaymentInterval;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFeeAmount(final Long feeAmount) {
      this.feeAmount = feeAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPaidAmount(final Long paidAmount) {
      this.paidAmount = paidAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRemainingAmount(final Long remainingAmount) {
      this.remainingAmount = remainingAmount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRepaymentsBeginAt(final BigDecimal repaymentsBeginAt) {
      this.repaymentsBeginAt = repaymentsBeginAt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setWithholdRate(final BigDecimal withholdRate) {
      this.withholdRate = withholdRate;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FinancingSummary.Details)) return false;
      final FinancingSummary.Details other = (FinancingSummary.Details) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$advanceAmount = this.getAdvanceAmount();
      final java.lang.Object other$advanceAmount = other.getAdvanceAmount();
      if (this$advanceAmount == null ? other$advanceAmount != null : !this$advanceAmount.equals(other$advanceAmount)) return false;
      final java.lang.Object this$feeAmount = this.getFeeAmount();
      final java.lang.Object other$feeAmount = other.getFeeAmount();
      if (this$feeAmount == null ? other$feeAmount != null : !this$feeAmount.equals(other$feeAmount)) return false;
      final java.lang.Object this$paidAmount = this.getPaidAmount();
      final java.lang.Object other$paidAmount = other.getPaidAmount();
      if (this$paidAmount == null ? other$paidAmount != null : !this$paidAmount.equals(other$paidAmount)) return false;
      final java.lang.Object this$remainingAmount = this.getRemainingAmount();
      final java.lang.Object other$remainingAmount = other.getRemainingAmount();
      if (this$remainingAmount == null ? other$remainingAmount != null : !this$remainingAmount.equals(other$remainingAmount)) return false;
      final java.lang.Object this$advancePaidOutAt = this.getAdvancePaidOutAt();
      final java.lang.Object other$advancePaidOutAt = other.getAdvancePaidOutAt();
      if (this$advancePaidOutAt == null ? other$advancePaidOutAt != null : !this$advancePaidOutAt.equals(other$advancePaidOutAt)) return false;
      final java.lang.Object this$currency = this.getCurrency();
      final java.lang.Object other$currency = other.getCurrency();
      if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
      final java.lang.Object this$currentRepaymentInterval = this.getCurrentRepaymentInterval();
      final java.lang.Object other$currentRepaymentInterval = other.getCurrentRepaymentInterval();
      if (this$currentRepaymentInterval == null ? other$currentRepaymentInterval != null : !this$currentRepaymentInterval.equals(other$currentRepaymentInterval)) return false;
      final java.lang.Object this$repaymentsBeginAt = this.getRepaymentsBeginAt();
      final java.lang.Object other$repaymentsBeginAt = other.getRepaymentsBeginAt();
      if (this$repaymentsBeginAt == null ? other$repaymentsBeginAt != null : !this$repaymentsBeginAt.equals(other$repaymentsBeginAt)) return false;
      final java.lang.Object this$withholdRate = this.getWithholdRate();
      final java.lang.Object other$withholdRate = other.getWithholdRate();
      if (this$withholdRate == null ? other$withholdRate != null : !this$withholdRate.equals(other$withholdRate)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FinancingSummary.Details;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $advanceAmount = this.getAdvanceAmount();
      result = result * PRIME + ($advanceAmount == null ? 43 : $advanceAmount.hashCode());
      final java.lang.Object $feeAmount = this.getFeeAmount();
      result = result * PRIME + ($feeAmount == null ? 43 : $feeAmount.hashCode());
      final java.lang.Object $paidAmount = this.getPaidAmount();
      result = result * PRIME + ($paidAmount == null ? 43 : $paidAmount.hashCode());
      final java.lang.Object $remainingAmount = this.getRemainingAmount();
      result = result * PRIME + ($remainingAmount == null ? 43 : $remainingAmount.hashCode());
      final java.lang.Object $advancePaidOutAt = this.getAdvancePaidOutAt();
      result = result * PRIME + ($advancePaidOutAt == null ? 43 : $advancePaidOutAt.hashCode());
      final java.lang.Object $currency = this.getCurrency();
      result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
      final java.lang.Object $currentRepaymentInterval = this.getCurrentRepaymentInterval();
      result = result * PRIME + ($currentRepaymentInterval == null ? 43 : $currentRepaymentInterval.hashCode());
      final java.lang.Object $repaymentsBeginAt = this.getRepaymentsBeginAt();
      result = result * PRIME + ($repaymentsBeginAt == null ? 43 : $repaymentsBeginAt.hashCode());
      final java.lang.Object $withholdRate = this.getWithholdRate();
      result = result * PRIME + ($withholdRate == null ? 43 : $withholdRate.hashCode());
      return result;
    }
  }

  /**
   * Additional information about the financing summary. Describes currency, advance amount, fee
   * amount, withhold rate, remaining amount, paid amount, current repayment interval, repayment
   * start date, and advance payout date.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Details getDetails() {
    return this.details;
  }

  /**
   * The object type: financing_summary
   *
   * <p>Equal to {@code capital.financing_summary}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Status of the Connected Account's financing. <a
   * href="https://stripe.com/docs/api/capital/financing_summary">/v1/capital/financing_summary</a>
   * will only return {@code details} for {@code paid_out} financing.
   *
   * <p>One of {@code accepted}, {@code delivered}, or {@code none}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * Additional information about the financing summary. Describes currency, advance amount, fee
   * amount, withhold rate, remaining amount, paid amount, current repayment interval, repayment
   * start date, and advance payout date.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDetails(final Details details) {
    this.details = details;
  }

  /**
   * The object type: financing_summary
   *
   * <p>Equal to {@code capital.financing_summary}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Status of the Connected Account's financing. <a
   * href="https://stripe.com/docs/api/capital/financing_summary">/v1/capital/financing_summary</a>
   * will only return {@code details} for {@code paid_out} financing.
   *
   * <p>One of {@code accepted}, {@code delivered}, or {@code none}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof FinancingSummary)) return false;
    final FinancingSummary other = (FinancingSummary) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$details = this.getDetails();
    final java.lang.Object other$details = other.getDetails();
    if (this$details == null ? other$details != null : !this$details.equals(other$details)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof FinancingSummary;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $details = this.getDetails();
    result = result * PRIME + ($details == null ? 43 : $details.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    return result;
  }
}
