// Generated by delombok at Thu Nov 10 23:10:45 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.giftcards;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.giftcards.CardCreateParams;
import com.stripe.param.giftcards.CardListParams;
import com.stripe.param.giftcards.CardRetrieveParams;
import com.stripe.param.giftcards.CardUpdateParams;
import com.stripe.param.giftcards.CardValidateParams;
import java.util.Map;

/**
 * A gift card represents a single gift card owned by a customer, including the remaining balance,
 * gift card code, and whether or not it is active.
 */
public class Card extends ApiResource implements HasId, MetadataStore<Card> {
  /**
   * Whether this gift card can be used or not.
   */
  @SerializedName("active")
  Boolean active;
  /**
   * The amount of funds available for new transactions.
   */
  @SerializedName("amount_available")
  Long amountAvailable;
  /**
   * The amount of funds marked as held.
   */
  @SerializedName("amount_held")
  Long amountHeld;
  /**
   * Code used to redeem this gift card.
   */
  @SerializedName("code")
  String code;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * The related Stripe objects that created this gift card.
   */
  @SerializedName("created_by")
  CreatedBy createdBy;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code gift_cards.card}.
   */
  @SerializedName("object")
  String object;
  /**
   * Transactions on this gift card.
   */
  @SerializedName("transactions")
  TransactionCollection transactions;

  /**
   * Creates a new gift card object.
   */
  public static Card create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new gift card object.
   */
  public static Card create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/gift_cards/cards");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
  }

  /**
   * Creates a new gift card object.
   */
  public static Card create(CardCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new gift card object.
   */
  public static Card create(CardCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/gift_cards/cards");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
  }

  /**
   * List gift cards for an account.
   */
  public static CardCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * List gift cards for an account.
   */
  public static CardCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/gift_cards/cards");
    return ApiResource.requestCollection(url, params, CardCollection.class, options);
  }

  /**
   * List gift cards for an account.
   */
  public static CardCollection list(CardListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * List gift cards for an account.
   */
  public static CardCollection list(CardListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/gift_cards/cards");
    return ApiResource.requestCollection(url, params, CardCollection.class, options);
  }

  /**
   * Retrieve a gift card by id.
   */
  public static Card retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieve a gift card by id.
   */
  public static Card retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieve a gift card by id.
   */
  public static Card retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/gift_cards/cards/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Card.class, options);
  }

  /**
   * Retrieve a gift card by id.
   */
  public static Card retrieve(String id, CardRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/gift_cards/cards/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Card.class, options);
  }

  /**
   * Update a gift card.
   */
  @Override
  public Card update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Update a gift card.
   */
  @Override
  public Card update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/gift_cards/cards/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
  }

  /**
   * Update a gift card.
   */
  public Card update(CardUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Update a gift card.
   */
  public Card update(CardUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/gift_cards/cards/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
  }

  /**
   * Validates a gift card code, returning the matching gift card object if it exists.
   */
  public static Card validate(Map<String, Object> params) throws StripeException {
    return validate(params, (RequestOptions) null);
  }

  /**
   * Validates a gift card code, returning the matching gift card object if it exists.
   */
  public static Card validate(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/gift_cards/cards/validate");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
  }

  /**
   * Validates a gift card code, returning the matching gift card object if it exists.
   */
  public static Card validate(CardValidateParams params) throws StripeException {
    return validate(params, (RequestOptions) null);
  }

  /**
   * Validates a gift card code, returning the matching gift card object if it exists.
   */
  public static Card validate(CardValidateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/gift_cards/cards/validate");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
  }


  public static class CreatedBy extends StripeObject {
    @SerializedName("checkout")
    Checkout checkout;
    @SerializedName("order")
    Order order;
    @SerializedName("payment")
    Payment payment;
    /**
     * The type of event that created this object.
     *
     * <p>One of {@code checkout}, {@code order}, or {@code payment}.
     */
    @SerializedName("type")
    String type;


    public static class Checkout extends StripeObject {
      /** The Stripe CheckoutSession that created this object. */
      @SerializedName("checkout_session")
      String checkoutSession;
      /** The Stripe CheckoutSession LineItem that created this object. */
      @SerializedName("line_item")
      String lineItem;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCheckoutSession() {
        return this.checkoutSession;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLineItem() {
        return this.lineItem;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCheckoutSession(final String checkoutSession) {
        this.checkoutSession = checkoutSession;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLineItem(final String lineItem) {
        this.lineItem = lineItem;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Card.CreatedBy.Checkout)) return false;
        final Card.CreatedBy.Checkout other = (Card.CreatedBy.Checkout) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$checkoutSession = this.getCheckoutSession();
        final java.lang.Object other$checkoutSession = other.getCheckoutSession();
        if (this$checkoutSession == null ? other$checkoutSession != null : !this$checkoutSession.equals(other$checkoutSession)) return false;
        final java.lang.Object this$lineItem = this.getLineItem();
        final java.lang.Object other$lineItem = other.getLineItem();
        if (this$lineItem == null ? other$lineItem != null : !this$lineItem.equals(other$lineItem)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Card.CreatedBy.Checkout;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $checkoutSession = this.getCheckoutSession();
        result = result * PRIME + ($checkoutSession == null ? 43 : $checkoutSession.hashCode());
        final java.lang.Object $lineItem = this.getLineItem();
        result = result * PRIME + ($lineItem == null ? 43 : $lineItem.hashCode());
        return result;
      }
    }


    public static class Order extends StripeObject {
      /** The Stripe Order LineItem that created this object. */
      @SerializedName("line_item")
      String lineItem;
      /** The Stripe Order that created this object. */
      @SerializedName("order")
      String order;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLineItem() {
        return this.lineItem;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getOrder() {
        return this.order;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLineItem(final String lineItem) {
        this.lineItem = lineItem;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setOrder(final String order) {
        this.order = order;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Card.CreatedBy.Order)) return false;
        final Card.CreatedBy.Order other = (Card.CreatedBy.Order) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$lineItem = this.getLineItem();
        final java.lang.Object other$lineItem = other.getLineItem();
        if (this$lineItem == null ? other$lineItem != null : !this$lineItem.equals(other$lineItem)) return false;
        final java.lang.Object this$order = this.getOrder();
        final java.lang.Object other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Card.CreatedBy.Order;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $lineItem = this.getLineItem();
        result = result * PRIME + ($lineItem == null ? 43 : $lineItem.hashCode());
        final java.lang.Object $order = this.getOrder();
        result = result * PRIME + ($order == null ? 43 : $order.hashCode());
        return result;
      }
    }


    public static class Payment extends StripeObject {
      /** The PaymentIntent that created this object. */
      @SerializedName("payment_intent")
      String paymentIntent;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getPaymentIntent() {
        return this.paymentIntent;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPaymentIntent(final String paymentIntent) {
        this.paymentIntent = paymentIntent;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Card.CreatedBy.Payment)) return false;
        final Card.CreatedBy.Payment other = (Card.CreatedBy.Payment) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$paymentIntent = this.getPaymentIntent();
        final java.lang.Object other$paymentIntent = other.getPaymentIntent();
        if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Card.CreatedBy.Payment;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $paymentIntent = this.getPaymentIntent();
        result = result * PRIME + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Checkout getCheckout() {
      return this.checkout;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Order getOrder() {
      return this.order;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Payment getPayment() {
      return this.payment;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCheckout(final Checkout checkout) {
      this.checkout = checkout;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOrder(final Order order) {
      this.order = order;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPayment(final Payment payment) {
      this.payment = payment;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Card.CreatedBy)) return false;
      final Card.CreatedBy other = (Card.CreatedBy) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$checkout = this.getCheckout();
      final java.lang.Object other$checkout = other.getCheckout();
      if (this$checkout == null ? other$checkout != null : !this$checkout.equals(other$checkout)) return false;
      final java.lang.Object this$order = this.getOrder();
      final java.lang.Object other$order = other.getOrder();
      if (this$order == null ? other$order != null : !this$order.equals(other$order)) return false;
      final java.lang.Object this$payment = this.getPayment();
      final java.lang.Object other$payment = other.getPayment();
      if (this$payment == null ? other$payment != null : !this$payment.equals(other$payment)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Card.CreatedBy;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $checkout = this.getCheckout();
      result = result * PRIME + ($checkout == null ? 43 : $checkout.hashCode());
      final java.lang.Object $order = this.getOrder();
      result = result * PRIME + ($order == null ? 43 : $order.hashCode());
      final java.lang.Object $payment = this.getPayment();
      result = result * PRIME + ($payment == null ? 43 : $payment.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }

  /**
   * Whether this gift card can be used or not.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getActive() {
    return this.active;
  }

  /**
   * The amount of funds available for new transactions.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountAvailable() {
    return this.amountAvailable;
  }

  /**
   * The amount of funds marked as held.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountHeld() {
    return this.amountHeld;
  }

  /**
   * Code used to redeem this gift card.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCode() {
    return this.code;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * The related Stripe objects that created this gift card.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CreatedBy getCreatedBy() {
    return this.createdBy;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code gift_cards.card}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Transactions on this gift card.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TransactionCollection getTransactions() {
    return this.transactions;
  }

  /**
   * Whether this gift card can be used or not.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setActive(final Boolean active) {
    this.active = active;
  }

  /**
   * The amount of funds available for new transactions.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountAvailable(final Long amountAvailable) {
    this.amountAvailable = amountAvailable;
  }

  /**
   * The amount of funds marked as held.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountHeld(final Long amountHeld) {
    this.amountHeld = amountHeld;
  }

  /**
   * Code used to redeem this gift card.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCode(final String code) {
    this.code = code;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * The related Stripe objects that created this gift card.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreatedBy(final CreatedBy createdBy) {
    this.createdBy = createdBy;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code gift_cards.card}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Transactions on this gift card.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransactions(final TransactionCollection transactions) {
    this.transactions = transactions;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Card)) return false;
    final Card other = (Card) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$active = this.getActive();
    final java.lang.Object other$active = other.getActive();
    if (this$active == null ? other$active != null : !this$active.equals(other$active)) return false;
    final java.lang.Object this$amountAvailable = this.getAmountAvailable();
    final java.lang.Object other$amountAvailable = other.getAmountAvailable();
    if (this$amountAvailable == null ? other$amountAvailable != null : !this$amountAvailable.equals(other$amountAvailable)) return false;
    final java.lang.Object this$amountHeld = this.getAmountHeld();
    final java.lang.Object other$amountHeld = other.getAmountHeld();
    if (this$amountHeld == null ? other$amountHeld != null : !this$amountHeld.equals(other$amountHeld)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$code = this.getCode();
    final java.lang.Object other$code = other.getCode();
    if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
    final java.lang.Object this$createdBy = this.getCreatedBy();
    final java.lang.Object other$createdBy = other.getCreatedBy();
    if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$transactions = this.getTransactions();
    final java.lang.Object other$transactions = other.getTransactions();
    if (this$transactions == null ? other$transactions != null : !this$transactions.equals(other$transactions)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Card;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $active = this.getActive();
    result = result * PRIME + ($active == null ? 43 : $active.hashCode());
    final java.lang.Object $amountAvailable = this.getAmountAvailable();
    result = result * PRIME + ($amountAvailable == null ? 43 : $amountAvailable.hashCode());
    final java.lang.Object $amountHeld = this.getAmountHeld();
    result = result * PRIME + ($amountHeld == null ? 43 : $amountHeld.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $code = this.getCode();
    result = result * PRIME + ($code == null ? 43 : $code.hashCode());
    final java.lang.Object $createdBy = this.getCreatedBy();
    result = result * PRIME + ($createdBy == null ? 43 : $createdBy.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $transactions = this.getTransactions();
    result = result * PRIME + ($transactions == null ? 43 : $transactions.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
