/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Application;
import com.stripe.model.Coupon;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentMethod;
import com.stripe.model.Plan;
import com.stripe.model.Price;
import com.stripe.model.StripeObject;
import com.stripe.model.Subscription;
import com.stripe.model.SubscriptionItem;
import com.stripe.model.SubscriptionScheduleCollection;
import com.stripe.model.TaxRate;
import com.stripe.model.testhelpers.TestClock;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.SubscriptionScheduleAmendParams;
import com.stripe.param.SubscriptionScheduleCancelParams;
import com.stripe.param.SubscriptionScheduleCreateParams;
import com.stripe.param.SubscriptionScheduleListParams;
import com.stripe.param.SubscriptionScheduleReleaseParams;
import com.stripe.param.SubscriptionScheduleRetrieveParams;
import com.stripe.param.SubscriptionScheduleUpdateParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SubscriptionSchedule
extends ApiResource
implements HasId,
MetadataStore<SubscriptionSchedule> {
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="billing_behavior")
    String billingBehavior;
    @SerializedName(value="canceled_at")
    Long canceledAt;
    @SerializedName(value="completed_at")
    Long completedAt;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="current_phase")
    CurrentPhase currentPhase;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="default_settings")
    DefaultSettings defaultSettings;
    @SerializedName(value="end_behavior")
    String endBehavior;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="phases")
    List<Phase> phases;
    @SerializedName(value="prebilling")
    Prebilling prebilling;
    @SerializedName(value="released_at")
    Long releasedAt;
    @SerializedName(value="released_subscription")
    String releasedSubscription;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="subscription")
    ExpandableField<Subscription> subscription;
    @SerializedName(value="test_clock")
    ExpandableField<TestClock> testClock;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getSubscription() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    public void setSubscription(String id) {
        this.subscription = ApiResource.setExpandableFieldId(id, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        return this.subscription != null ? this.subscription.getExpanded() : null;
    }

    public void setSubscriptionObject(Subscription expandableObject) {
        this.subscription = new ExpandableField<Subscription>(expandableObject.getId(), expandableObject);
    }

    public String getTestClock() {
        return this.testClock != null ? this.testClock.getId() : null;
    }

    public void setTestClock(String id) {
        this.testClock = ApiResource.setExpandableFieldId(id, this.testClock);
    }

    public TestClock getTestClockObject() {
        return this.testClock != null ? this.testClock.getExpanded() : null;
    }

    public void setTestClockObject(TestClock expandableObject) {
        this.testClock = new ExpandableField<TestClock>(expandableObject.getId(), expandableObject);
    }

    public SubscriptionSchedule amend() throws StripeException {
        return this.amend((Map<String, Object>)null, (RequestOptions)null);
    }

    public SubscriptionSchedule amend(RequestOptions options) throws StripeException {
        return this.amend((Map<String, Object>)null, options);
    }

    public SubscriptionSchedule amend(Map<String, Object> params) throws StripeException {
        return this.amend(params, (RequestOptions)null);
    }

    public SubscriptionSchedule amend(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s/amend", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    public SubscriptionSchedule amend(SubscriptionScheduleAmendParams params) throws StripeException {
        return this.amend(params, (RequestOptions)null);
    }

    public SubscriptionSchedule amend(SubscriptionScheduleAmendParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s/amend", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    public SubscriptionSchedule cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public SubscriptionSchedule cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public SubscriptionSchedule cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public SubscriptionSchedule cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    public SubscriptionSchedule cancel(SubscriptionScheduleCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public SubscriptionSchedule cancel(SubscriptionScheduleCancelParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    public static SubscriptionSchedule create(Map<String, Object> params) throws StripeException {
        return SubscriptionSchedule.create(params, (RequestOptions)null);
    }

    public static SubscriptionSchedule create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_schedules");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    public static SubscriptionSchedule create(SubscriptionScheduleCreateParams params) throws StripeException {
        return SubscriptionSchedule.create(params, (RequestOptions)null);
    }

    public static SubscriptionSchedule create(SubscriptionScheduleCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_schedules");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    public static SubscriptionScheduleCollection list(Map<String, Object> params) throws StripeException {
        return SubscriptionSchedule.list(params, (RequestOptions)null);
    }

    public static SubscriptionScheduleCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_schedules");
        return ApiResource.requestCollection(url, params, SubscriptionScheduleCollection.class, options);
    }

    public static SubscriptionScheduleCollection list(SubscriptionScheduleListParams params) throws StripeException {
        return SubscriptionSchedule.list(params, (RequestOptions)null);
    }

    public static SubscriptionScheduleCollection list(SubscriptionScheduleListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/subscription_schedules");
        return ApiResource.requestCollection(url, params, SubscriptionScheduleCollection.class, options);
    }

    public SubscriptionSchedule release() throws StripeException {
        return this.release((Map<String, Object>)null, (RequestOptions)null);
    }

    public SubscriptionSchedule release(RequestOptions options) throws StripeException {
        return this.release((Map<String, Object>)null, options);
    }

    public SubscriptionSchedule release(Map<String, Object> params) throws StripeException {
        return this.release(params, (RequestOptions)null);
    }

    public SubscriptionSchedule release(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s/release", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    public SubscriptionSchedule release(SubscriptionScheduleReleaseParams params) throws StripeException {
        return this.release(params, (RequestOptions)null);
    }

    public SubscriptionSchedule release(SubscriptionScheduleReleaseParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s/release", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    public static SubscriptionSchedule retrieve(String schedule) throws StripeException {
        return SubscriptionSchedule.retrieve(schedule, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static SubscriptionSchedule retrieve(String schedule, RequestOptions options) throws StripeException {
        return SubscriptionSchedule.retrieve(schedule, (Map<String, Object>)null, options);
    }

    public static SubscriptionSchedule retrieve(String schedule, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(schedule)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SubscriptionSchedule.class, options);
    }

    public static SubscriptionSchedule retrieve(String schedule, SubscriptionScheduleRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(schedule)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, SubscriptionSchedule.class, options);
    }

    public SubscriptionSchedule update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public SubscriptionSchedule update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    public SubscriptionSchedule update(SubscriptionScheduleUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public SubscriptionSchedule update(SubscriptionScheduleUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, SubscriptionSchedule.class, options);
    }

    @Generated
    public String getBillingBehavior() {
        return this.billingBehavior;
    }

    @Generated
    public Long getCanceledAt() {
        return this.canceledAt;
    }

    @Generated
    public Long getCompletedAt() {
        return this.completedAt;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public CurrentPhase getCurrentPhase() {
        return this.currentPhase;
    }

    @Generated
    public DefaultSettings getDefaultSettings() {
        return this.defaultSettings;
    }

    @Generated
    public String getEndBehavior() {
        return this.endBehavior;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public List<Phase> getPhases() {
        return this.phases;
    }

    @Generated
    public Prebilling getPrebilling() {
        return this.prebilling;
    }

    @Generated
    public Long getReleasedAt() {
        return this.releasedAt;
    }

    @Generated
    public String getReleasedSubscription() {
        return this.releasedSubscription;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setBillingBehavior(String billingBehavior) {
        this.billingBehavior = billingBehavior;
    }

    @Generated
    public void setCanceledAt(Long canceledAt) {
        this.canceledAt = canceledAt;
    }

    @Generated
    public void setCompletedAt(Long completedAt) {
        this.completedAt = completedAt;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrentPhase(CurrentPhase currentPhase) {
        this.currentPhase = currentPhase;
    }

    @Generated
    public void setDefaultSettings(DefaultSettings defaultSettings) {
        this.defaultSettings = defaultSettings;
    }

    @Generated
    public void setEndBehavior(String endBehavior) {
        this.endBehavior = endBehavior;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPhases(List<Phase> phases) {
        this.phases = phases;
    }

    @Generated
    public void setPrebilling(Prebilling prebilling) {
        this.prebilling = prebilling;
    }

    @Generated
    public void setReleasedAt(Long releasedAt) {
        this.releasedAt = releasedAt;
    }

    @Generated
    public void setReleasedSubscription(String releasedSubscription) {
        this.releasedSubscription = releasedSubscription;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionSchedule)) {
            return false;
        }
        SubscriptionSchedule other = (SubscriptionSchedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$canceledAt = this.getCanceledAt();
        Long other$canceledAt = other.getCanceledAt();
        if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
            return false;
        }
        Long this$completedAt = this.getCompletedAt();
        Long other$completedAt = other.getCompletedAt();
        if (this$completedAt == null ? other$completedAt != null : !((Object)this$completedAt).equals(other$completedAt)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$releasedAt = this.getReleasedAt();
        Long other$releasedAt = other.getReleasedAt();
        if (this$releasedAt == null ? other$releasedAt != null : !((Object)this$releasedAt).equals(other$releasedAt)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$billingBehavior = this.getBillingBehavior();
        String other$billingBehavior = other.getBillingBehavior();
        if (this$billingBehavior == null ? other$billingBehavior != null : !this$billingBehavior.equals(other$billingBehavior)) {
            return false;
        }
        CurrentPhase this$currentPhase = this.getCurrentPhase();
        CurrentPhase other$currentPhase = other.getCurrentPhase();
        if (this$currentPhase == null ? other$currentPhase != null : !((Object)this$currentPhase).equals(other$currentPhase)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        DefaultSettings this$defaultSettings = this.getDefaultSettings();
        DefaultSettings other$defaultSettings = other.getDefaultSettings();
        if (this$defaultSettings == null ? other$defaultSettings != null : !((Object)this$defaultSettings).equals(other$defaultSettings)) {
            return false;
        }
        String this$endBehavior = this.getEndBehavior();
        String other$endBehavior = other.getEndBehavior();
        if (this$endBehavior == null ? other$endBehavior != null : !this$endBehavior.equals(other$endBehavior)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        List<Phase> this$phases = this.getPhases();
        List<Phase> other$phases = other.getPhases();
        if (this$phases == null ? other$phases != null : !((Object)this$phases).equals(other$phases)) {
            return false;
        }
        Prebilling this$prebilling = this.getPrebilling();
        Prebilling other$prebilling = other.getPrebilling();
        if (this$prebilling == null ? other$prebilling != null : !((Object)this$prebilling).equals(other$prebilling)) {
            return false;
        }
        String this$releasedSubscription = this.getReleasedSubscription();
        String other$releasedSubscription = other.getReleasedSubscription();
        if (this$releasedSubscription == null ? other$releasedSubscription != null : !this$releasedSubscription.equals(other$releasedSubscription)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        String this$testClock = this.getTestClock();
        String other$testClock = other.getTestClock();
        return !(this$testClock == null ? other$testClock != null : !this$testClock.equals(other$testClock));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionSchedule;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $canceledAt = this.getCanceledAt();
        result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
        Long $completedAt = this.getCompletedAt();
        result = result * 59 + ($completedAt == null ? 43 : ((Object)$completedAt).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $releasedAt = this.getReleasedAt();
        result = result * 59 + ($releasedAt == null ? 43 : ((Object)$releasedAt).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $billingBehavior = this.getBillingBehavior();
        result = result * 59 + ($billingBehavior == null ? 43 : $billingBehavior.hashCode());
        CurrentPhase $currentPhase = this.getCurrentPhase();
        result = result * 59 + ($currentPhase == null ? 43 : ((Object)$currentPhase).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        DefaultSettings $defaultSettings = this.getDefaultSettings();
        result = result * 59 + ($defaultSettings == null ? 43 : ((Object)$defaultSettings).hashCode());
        String $endBehavior = this.getEndBehavior();
        result = result * 59 + ($endBehavior == null ? 43 : $endBehavior.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        List<Phase> $phases = this.getPhases();
        result = result * 59 + ($phases == null ? 43 : ((Object)$phases).hashCode());
        Prebilling $prebilling = this.getPrebilling();
        result = result * 59 + ($prebilling == null ? 43 : ((Object)$prebilling).hashCode());
        String $releasedSubscription = this.getReleasedSubscription();
        result = result * 59 + ($releasedSubscription == null ? 43 : $releasedSubscription.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        String $testClock = this.getTestClock();
        result = result * 59 + ($testClock == null ? 43 : $testClock.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class CurrentPhase
    extends StripeObject {
        @SerializedName(value="end_date")
        Long endDate;
        @SerializedName(value="start_date")
        Long startDate;

        @Generated
        public Long getEndDate() {
            return this.endDate;
        }

        @Generated
        public Long getStartDate() {
            return this.startDate;
        }

        @Generated
        public void setEndDate(Long endDate) {
            this.endDate = endDate;
        }

        @Generated
        public void setStartDate(Long startDate) {
            this.startDate = startDate;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CurrentPhase)) {
                return false;
            }
            CurrentPhase other = (CurrentPhase)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$endDate = this.getEndDate();
            Long other$endDate = other.getEndDate();
            if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
                return false;
            }
            Long this$startDate = this.getStartDate();
            Long other$startDate = other.getStartDate();
            return !(this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CurrentPhase;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $endDate = this.getEndDate();
            result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
            Long $startDate = this.getStartDate();
            result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
            return result;
        }
    }

    public static class DefaultSettings
    extends StripeObject {
        @SerializedName(value="application_fee_percent")
        BigDecimal applicationFeePercent;
        @SerializedName(value="automatic_tax")
        AutomaticTax automaticTax;
        @SerializedName(value="billing_cycle_anchor")
        String billingCycleAnchor;
        @SerializedName(value="billing_thresholds")
        Subscription.BillingThresholds billingThresholds;
        @SerializedName(value="collection_method")
        String collectionMethod;
        @SerializedName(value="default_payment_method")
        ExpandableField<PaymentMethod> defaultPaymentMethod;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="invoice_settings")
        InvoiceSettings invoiceSettings;
        @SerializedName(value="on_behalf_of")
        ExpandableField<Account> onBehalfOf;
        @SerializedName(value="transfer_data")
        Subscription.TransferData transferData;

        public String getDefaultPaymentMethod() {
            return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getId() : null;
        }

        public void setDefaultPaymentMethod(String id) {
            this.defaultPaymentMethod = ApiResource.setExpandableFieldId(id, this.defaultPaymentMethod);
        }

        public PaymentMethod getDefaultPaymentMethodObject() {
            return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getExpanded() : null;
        }

        public void setDefaultPaymentMethodObject(PaymentMethod expandableObject) {
            this.defaultPaymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
        }

        public String getOnBehalfOf() {
            return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
        }

        public void setOnBehalfOf(String id) {
            this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
        }

        public Account getOnBehalfOfObject() {
            return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
        }

        public void setOnBehalfOfObject(Account expandableObject) {
            this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public BigDecimal getApplicationFeePercent() {
            return this.applicationFeePercent;
        }

        @Generated
        public AutomaticTax getAutomaticTax() {
            return this.automaticTax;
        }

        @Generated
        public String getBillingCycleAnchor() {
            return this.billingCycleAnchor;
        }

        @Generated
        public Subscription.BillingThresholds getBillingThresholds() {
            return this.billingThresholds;
        }

        @Generated
        public String getCollectionMethod() {
            return this.collectionMethod;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public InvoiceSettings getInvoiceSettings() {
            return this.invoiceSettings;
        }

        @Generated
        public Subscription.TransferData getTransferData() {
            return this.transferData;
        }

        @Generated
        public void setApplicationFeePercent(BigDecimal applicationFeePercent) {
            this.applicationFeePercent = applicationFeePercent;
        }

        @Generated
        public void setAutomaticTax(AutomaticTax automaticTax) {
            this.automaticTax = automaticTax;
        }

        @Generated
        public void setBillingCycleAnchor(String billingCycleAnchor) {
            this.billingCycleAnchor = billingCycleAnchor;
        }

        @Generated
        public void setBillingThresholds(Subscription.BillingThresholds billingThresholds) {
            this.billingThresholds = billingThresholds;
        }

        @Generated
        public void setCollectionMethod(String collectionMethod) {
            this.collectionMethod = collectionMethod;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setInvoiceSettings(InvoiceSettings invoiceSettings) {
            this.invoiceSettings = invoiceSettings;
        }

        @Generated
        public void setTransferData(Subscription.TransferData transferData) {
            this.transferData = transferData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultSettings)) {
                return false;
            }
            DefaultSettings other = (DefaultSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigDecimal this$applicationFeePercent = this.getApplicationFeePercent();
            BigDecimal other$applicationFeePercent = other.getApplicationFeePercent();
            if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !((Object)this$applicationFeePercent).equals(other$applicationFeePercent)) {
                return false;
            }
            AutomaticTax this$automaticTax = this.getAutomaticTax();
            AutomaticTax other$automaticTax = other.getAutomaticTax();
            if (this$automaticTax == null ? other$automaticTax != null : !((Object)this$automaticTax).equals(other$automaticTax)) {
                return false;
            }
            String this$billingCycleAnchor = this.getBillingCycleAnchor();
            String other$billingCycleAnchor = other.getBillingCycleAnchor();
            if (this$billingCycleAnchor == null ? other$billingCycleAnchor != null : !this$billingCycleAnchor.equals(other$billingCycleAnchor)) {
                return false;
            }
            Subscription.BillingThresholds this$billingThresholds = this.getBillingThresholds();
            Subscription.BillingThresholds other$billingThresholds = other.getBillingThresholds();
            if (this$billingThresholds == null ? other$billingThresholds != null : !((Object)this$billingThresholds).equals(other$billingThresholds)) {
                return false;
            }
            String this$collectionMethod = this.getCollectionMethod();
            String other$collectionMethod = other.getCollectionMethod();
            if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) {
                return false;
            }
            String this$defaultPaymentMethod = this.getDefaultPaymentMethod();
            String other$defaultPaymentMethod = other.getDefaultPaymentMethod();
            if (this$defaultPaymentMethod == null ? other$defaultPaymentMethod != null : !this$defaultPaymentMethod.equals(other$defaultPaymentMethod)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            InvoiceSettings this$invoiceSettings = this.getInvoiceSettings();
            InvoiceSettings other$invoiceSettings = other.getInvoiceSettings();
            if (this$invoiceSettings == null ? other$invoiceSettings != null : !((Object)this$invoiceSettings).equals(other$invoiceSettings)) {
                return false;
            }
            String this$onBehalfOf = this.getOnBehalfOf();
            String other$onBehalfOf = other.getOnBehalfOf();
            if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
                return false;
            }
            Subscription.TransferData this$transferData = this.getTransferData();
            Subscription.TransferData other$transferData = other.getTransferData();
            return !(this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DefaultSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigDecimal $applicationFeePercent = this.getApplicationFeePercent();
            result = result * 59 + ($applicationFeePercent == null ? 43 : ((Object)$applicationFeePercent).hashCode());
            AutomaticTax $automaticTax = this.getAutomaticTax();
            result = result * 59 + ($automaticTax == null ? 43 : ((Object)$automaticTax).hashCode());
            String $billingCycleAnchor = this.getBillingCycleAnchor();
            result = result * 59 + ($billingCycleAnchor == null ? 43 : $billingCycleAnchor.hashCode());
            Subscription.BillingThresholds $billingThresholds = this.getBillingThresholds();
            result = result * 59 + ($billingThresholds == null ? 43 : ((Object)$billingThresholds).hashCode());
            String $collectionMethod = this.getCollectionMethod();
            result = result * 59 + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
            String $defaultPaymentMethod = this.getDefaultPaymentMethod();
            result = result * 59 + ($defaultPaymentMethod == null ? 43 : $defaultPaymentMethod.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            InvoiceSettings $invoiceSettings = this.getInvoiceSettings();
            result = result * 59 + ($invoiceSettings == null ? 43 : ((Object)$invoiceSettings).hashCode());
            String $onBehalfOf = this.getOnBehalfOf();
            result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
            Subscription.TransferData $transferData = this.getTransferData();
            result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
            return result;
        }

        public static class AutomaticTax
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AutomaticTax)) {
                    return false;
                }
                AutomaticTax other = (AutomaticTax)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AutomaticTax;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                return result;
            }
        }
    }

    public static class Prebilling
    extends StripeObject {
        @SerializedName(value="invoice")
        ExpandableField<Invoice> invoice;
        @SerializedName(value="period_end")
        Long periodEnd;
        @SerializedName(value="period_start")
        Long periodStart;

        public String getInvoice() {
            return this.invoice != null ? this.invoice.getId() : null;
        }

        public void setInvoice(String id) {
            this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
        }

        public Invoice getInvoiceObject() {
            return this.invoice != null ? this.invoice.getExpanded() : null;
        }

        public void setInvoiceObject(Invoice expandableObject) {
            this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getPeriodEnd() {
            return this.periodEnd;
        }

        @Generated
        public Long getPeriodStart() {
            return this.periodStart;
        }

        @Generated
        public void setPeriodEnd(Long periodEnd) {
            this.periodEnd = periodEnd;
        }

        @Generated
        public void setPeriodStart(Long periodStart) {
            this.periodStart = periodStart;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prebilling)) {
                return false;
            }
            Prebilling other = (Prebilling)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$periodEnd = this.getPeriodEnd();
            Long other$periodEnd = other.getPeriodEnd();
            if (this$periodEnd == null ? other$periodEnd != null : !((Object)this$periodEnd).equals(other$periodEnd)) {
                return false;
            }
            Long this$periodStart = this.getPeriodStart();
            Long other$periodStart = other.getPeriodStart();
            if (this$periodStart == null ? other$periodStart != null : !((Object)this$periodStart).equals(other$periodStart)) {
                return false;
            }
            String this$invoice = this.getInvoice();
            String other$invoice = other.getInvoice();
            return !(this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Prebilling;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $periodEnd = this.getPeriodEnd();
            result = result * 59 + ($periodEnd == null ? 43 : ((Object)$periodEnd).hashCode());
            Long $periodStart = this.getPeriodStart();
            result = result * 59 + ($periodStart == null ? 43 : ((Object)$periodStart).hashCode());
            String $invoice = this.getInvoice();
            result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
            return result;
        }
    }

    public static class PhaseItem
    extends StripeObject {
        @SerializedName(value="billing_thresholds")
        SubscriptionItem.BillingThresholds billingThresholds;
        @SerializedName(value="discounts")
        List<StackableDiscount> discounts;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="plan")
        ExpandableField<Plan> plan;
        @SerializedName(value="price")
        ExpandableField<Price> price;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="tax_rates")
        List<TaxRate> taxRates;
        @SerializedName(value="trial")
        Trial trial;

        public String getPlan() {
            return this.plan != null ? this.plan.getId() : null;
        }

        public void setPlan(String id) {
            this.plan = ApiResource.setExpandableFieldId(id, this.plan);
        }

        public Plan getPlanObject() {
            return this.plan != null ? this.plan.getExpanded() : null;
        }

        public void setPlanObject(Plan expandableObject) {
            this.plan = new ExpandableField<Plan>(expandableObject.getId(), expandableObject);
        }

        public String getPrice() {
            return this.price != null ? this.price.getId() : null;
        }

        public void setPrice(String id) {
            this.price = ApiResource.setExpandableFieldId(id, this.price);
        }

        public Price getPriceObject() {
            return this.price != null ? this.price.getExpanded() : null;
        }

        public void setPriceObject(Price expandableObject) {
            this.price = new ExpandableField<Price>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public SubscriptionItem.BillingThresholds getBillingThresholds() {
            return this.billingThresholds;
        }

        @Generated
        public List<StackableDiscount> getDiscounts() {
            return this.discounts;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public Long getQuantity() {
            return this.quantity;
        }

        @Generated
        public List<TaxRate> getTaxRates() {
            return this.taxRates;
        }

        @Generated
        public Trial getTrial() {
            return this.trial;
        }

        @Generated
        public void setBillingThresholds(SubscriptionItem.BillingThresholds billingThresholds) {
            this.billingThresholds = billingThresholds;
        }

        @Generated
        public void setDiscounts(List<StackableDiscount> discounts) {
            this.discounts = discounts;
        }

        @Generated
        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }

        @Generated
        public void setQuantity(Long quantity) {
            this.quantity = quantity;
        }

        @Generated
        public void setTaxRates(List<TaxRate> taxRates) {
            this.taxRates = taxRates;
        }

        @Generated
        public void setTrial(Trial trial) {
            this.trial = trial;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PhaseItem)) {
                return false;
            }
            PhaseItem other = (PhaseItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$quantity = this.getQuantity();
            Long other$quantity = other.getQuantity();
            if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                return false;
            }
            SubscriptionItem.BillingThresholds this$billingThresholds = this.getBillingThresholds();
            SubscriptionItem.BillingThresholds other$billingThresholds = other.getBillingThresholds();
            if (this$billingThresholds == null ? other$billingThresholds != null : !((Object)this$billingThresholds).equals(other$billingThresholds)) {
                return false;
            }
            List<StackableDiscount> this$discounts = this.getDiscounts();
            List<StackableDiscount> other$discounts = other.getDiscounts();
            if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
                return false;
            }
            Map<String, String> this$metadata = this.getMetadata();
            Map<String, String> other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            String this$plan = this.getPlan();
            String other$plan = other.getPlan();
            if (this$plan == null ? other$plan != null : !this$plan.equals(other$plan)) {
                return false;
            }
            String this$price = this.getPrice();
            String other$price = other.getPrice();
            if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
                return false;
            }
            List<TaxRate> this$taxRates = this.getTaxRates();
            List<TaxRate> other$taxRates = other.getTaxRates();
            if (this$taxRates == null ? other$taxRates != null : !((Object)this$taxRates).equals(other$taxRates)) {
                return false;
            }
            Trial this$trial = this.getTrial();
            Trial other$trial = other.getTrial();
            return !(this$trial == null ? other$trial != null : !((Object)this$trial).equals(other$trial));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PhaseItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $quantity = this.getQuantity();
            result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
            SubscriptionItem.BillingThresholds $billingThresholds = this.getBillingThresholds();
            result = result * 59 + ($billingThresholds == null ? 43 : ((Object)$billingThresholds).hashCode());
            List<StackableDiscount> $discounts = this.getDiscounts();
            result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
            Map<String, String> $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            String $plan = this.getPlan();
            result = result * 59 + ($plan == null ? 43 : $plan.hashCode());
            String $price = this.getPrice();
            result = result * 59 + ($price == null ? 43 : $price.hashCode());
            List<TaxRate> $taxRates = this.getTaxRates();
            result = result * 59 + ($taxRates == null ? 43 : ((Object)$taxRates).hashCode());
            Trial $trial = this.getTrial();
            result = result * 59 + ($trial == null ? 43 : ((Object)$trial).hashCode());
            return result;
        }

        public static class Trial
        extends StripeObject {
            @SerializedName(value="converts_to")
            List<String> convertsTo;
            @SerializedName(value="type")
            String type;

            @Generated
            public List<String> getConvertsTo() {
                return this.convertsTo;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setConvertsTo(List<String> convertsTo) {
                this.convertsTo = convertsTo;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Trial)) {
                    return false;
                }
                Trial other = (Trial)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$convertsTo = this.getConvertsTo();
                List<String> other$convertsTo = other.getConvertsTo();
                if (this$convertsTo == null ? other$convertsTo != null : !((Object)this$convertsTo).equals(other$convertsTo)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Trial;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $convertsTo = this.getConvertsTo();
                result = result * 59 + ($convertsTo == null ? 43 : ((Object)$convertsTo).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class StackableDiscount
        extends StripeObject {
            @SerializedName(value="coupon")
            ExpandableField<Coupon> coupon;
            @SerializedName(value="discount")
            ExpandableField<Discount> discount;

            public String getCoupon() {
                return this.coupon != null ? this.coupon.getId() : null;
            }

            public void setCoupon(String id) {
                this.coupon = ApiResource.setExpandableFieldId(id, this.coupon);
            }

            public Coupon getCouponObject() {
                return this.coupon != null ? this.coupon.getExpanded() : null;
            }

            public void setCouponObject(Coupon expandableObject) {
                this.coupon = new ExpandableField<Coupon>(expandableObject.getId(), expandableObject);
            }

            public String getDiscount() {
                return this.discount != null ? this.discount.getId() : null;
            }

            public void setDiscount(String id) {
                this.discount = ApiResource.setExpandableFieldId(id, this.discount);
            }

            public Discount getDiscountObject() {
                return this.discount != null ? this.discount.getExpanded() : null;
            }

            public void setDiscountObject(Discount expandableObject) {
                this.discount = new ExpandableField<Discount>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StackableDiscount)) {
                    return false;
                }
                StackableDiscount other = (StackableDiscount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$coupon = this.getCoupon();
                String other$coupon = other.getCoupon();
                if (this$coupon == null ? other$coupon != null : !this$coupon.equals(other$coupon)) {
                    return false;
                }
                String this$discount = this.getDiscount();
                String other$discount = other.getDiscount();
                return !(this$discount == null ? other$discount != null : !this$discount.equals(other$discount));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof StackableDiscount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $coupon = this.getCoupon();
                result = result * 59 + ($coupon == null ? 43 : $coupon.hashCode());
                String $discount = this.getDiscount();
                result = result * 59 + ($discount == null ? 43 : $discount.hashCode());
                return result;
            }
        }
    }

    public static class Phase
    extends StripeObject {
        @SerializedName(value="add_invoice_items")
        List<AddInvoiceItem> addInvoiceItems;
        @SerializedName(value="application_fee_percent")
        BigDecimal applicationFeePercent;
        @SerializedName(value="automatic_tax")
        AutomaticTax automaticTax;
        @SerializedName(value="billing_cycle_anchor")
        String billingCycleAnchor;
        @SerializedName(value="billing_thresholds")
        Subscription.BillingThresholds billingThresholds;
        @SerializedName(value="collection_method")
        String collectionMethod;
        @SerializedName(value="coupon")
        ExpandableField<Coupon> coupon;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="default_payment_method")
        ExpandableField<PaymentMethod> defaultPaymentMethod;
        @SerializedName(value="default_tax_rates")
        List<TaxRate> defaultTaxRates;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="discounts")
        List<Discount> discounts;
        @SerializedName(value="end_date")
        Long endDate;
        @SerializedName(value="invoice_settings")
        InvoiceSettings invoiceSettings;
        @SerializedName(value="items")
        List<PhaseItem> items;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="on_behalf_of")
        ExpandableField<Account> onBehalfOf;
        @SerializedName(value="proration_behavior")
        String prorationBehavior;
        @SerializedName(value="start_date")
        Long startDate;
        @SerializedName(value="transfer_data")
        Subscription.TransferData transferData;
        @SerializedName(value="trial_continuation")
        String trialContinuation;
        @SerializedName(value="trial_end")
        Long trialEnd;
        @SerializedName(value="trial_settings")
        TrialSettings trialSettings;

        public String getCoupon() {
            return this.coupon != null ? this.coupon.getId() : null;
        }

        public void setCoupon(String id) {
            this.coupon = ApiResource.setExpandableFieldId(id, this.coupon);
        }

        public Coupon getCouponObject() {
            return this.coupon != null ? this.coupon.getExpanded() : null;
        }

        public void setCouponObject(Coupon expandableObject) {
            this.coupon = new ExpandableField<Coupon>(expandableObject.getId(), expandableObject);
        }

        public String getDefaultPaymentMethod() {
            return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getId() : null;
        }

        public void setDefaultPaymentMethod(String id) {
            this.defaultPaymentMethod = ApiResource.setExpandableFieldId(id, this.defaultPaymentMethod);
        }

        public PaymentMethod getDefaultPaymentMethodObject() {
            return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getExpanded() : null;
        }

        public void setDefaultPaymentMethodObject(PaymentMethod expandableObject) {
            this.defaultPaymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
        }

        public String getOnBehalfOf() {
            return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
        }

        public void setOnBehalfOf(String id) {
            this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
        }

        public Account getOnBehalfOfObject() {
            return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
        }

        public void setOnBehalfOfObject(Account expandableObject) {
            this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public List<AddInvoiceItem> getAddInvoiceItems() {
            return this.addInvoiceItems;
        }

        @Generated
        public BigDecimal getApplicationFeePercent() {
            return this.applicationFeePercent;
        }

        @Generated
        public AutomaticTax getAutomaticTax() {
            return this.automaticTax;
        }

        @Generated
        public String getBillingCycleAnchor() {
            return this.billingCycleAnchor;
        }

        @Generated
        public Subscription.BillingThresholds getBillingThresholds() {
            return this.billingThresholds;
        }

        @Generated
        public String getCollectionMethod() {
            return this.collectionMethod;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public List<TaxRate> getDefaultTaxRates() {
            return this.defaultTaxRates;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public List<Discount> getDiscounts() {
            return this.discounts;
        }

        @Generated
        public Long getEndDate() {
            return this.endDate;
        }

        @Generated
        public InvoiceSettings getInvoiceSettings() {
            return this.invoiceSettings;
        }

        @Generated
        public List<PhaseItem> getItems() {
            return this.items;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public String getProrationBehavior() {
            return this.prorationBehavior;
        }

        @Generated
        public Long getStartDate() {
            return this.startDate;
        }

        @Generated
        public Subscription.TransferData getTransferData() {
            return this.transferData;
        }

        @Generated
        public String getTrialContinuation() {
            return this.trialContinuation;
        }

        @Generated
        public Long getTrialEnd() {
            return this.trialEnd;
        }

        @Generated
        public TrialSettings getTrialSettings() {
            return this.trialSettings;
        }

        @Generated
        public void setAddInvoiceItems(List<AddInvoiceItem> addInvoiceItems) {
            this.addInvoiceItems = addInvoiceItems;
        }

        @Generated
        public void setApplicationFeePercent(BigDecimal applicationFeePercent) {
            this.applicationFeePercent = applicationFeePercent;
        }

        @Generated
        public void setAutomaticTax(AutomaticTax automaticTax) {
            this.automaticTax = automaticTax;
        }

        @Generated
        public void setBillingCycleAnchor(String billingCycleAnchor) {
            this.billingCycleAnchor = billingCycleAnchor;
        }

        @Generated
        public void setBillingThresholds(Subscription.BillingThresholds billingThresholds) {
            this.billingThresholds = billingThresholds;
        }

        @Generated
        public void setCollectionMethod(String collectionMethod) {
            this.collectionMethod = collectionMethod;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setDefaultTaxRates(List<TaxRate> defaultTaxRates) {
            this.defaultTaxRates = defaultTaxRates;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setDiscounts(List<Discount> discounts) {
            this.discounts = discounts;
        }

        @Generated
        public void setEndDate(Long endDate) {
            this.endDate = endDate;
        }

        @Generated
        public void setInvoiceSettings(InvoiceSettings invoiceSettings) {
            this.invoiceSettings = invoiceSettings;
        }

        @Generated
        public void setItems(List<PhaseItem> items) {
            this.items = items;
        }

        @Generated
        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }

        @Generated
        public void setProrationBehavior(String prorationBehavior) {
            this.prorationBehavior = prorationBehavior;
        }

        @Generated
        public void setStartDate(Long startDate) {
            this.startDate = startDate;
        }

        @Generated
        public void setTransferData(Subscription.TransferData transferData) {
            this.transferData = transferData;
        }

        @Generated
        public void setTrialContinuation(String trialContinuation) {
            this.trialContinuation = trialContinuation;
        }

        @Generated
        public void setTrialEnd(Long trialEnd) {
            this.trialEnd = trialEnd;
        }

        @Generated
        public void setTrialSettings(TrialSettings trialSettings) {
            this.trialSettings = trialSettings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Phase)) {
                return false;
            }
            Phase other = (Phase)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$endDate = this.getEndDate();
            Long other$endDate = other.getEndDate();
            if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
                return false;
            }
            Long this$startDate = this.getStartDate();
            Long other$startDate = other.getStartDate();
            if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
                return false;
            }
            Long this$trialEnd = this.getTrialEnd();
            Long other$trialEnd = other.getTrialEnd();
            if (this$trialEnd == null ? other$trialEnd != null : !((Object)this$trialEnd).equals(other$trialEnd)) {
                return false;
            }
            List<AddInvoiceItem> this$addInvoiceItems = this.getAddInvoiceItems();
            List<AddInvoiceItem> other$addInvoiceItems = other.getAddInvoiceItems();
            if (this$addInvoiceItems == null ? other$addInvoiceItems != null : !((Object)this$addInvoiceItems).equals(other$addInvoiceItems)) {
                return false;
            }
            BigDecimal this$applicationFeePercent = this.getApplicationFeePercent();
            BigDecimal other$applicationFeePercent = other.getApplicationFeePercent();
            if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !((Object)this$applicationFeePercent).equals(other$applicationFeePercent)) {
                return false;
            }
            AutomaticTax this$automaticTax = this.getAutomaticTax();
            AutomaticTax other$automaticTax = other.getAutomaticTax();
            if (this$automaticTax == null ? other$automaticTax != null : !((Object)this$automaticTax).equals(other$automaticTax)) {
                return false;
            }
            String this$billingCycleAnchor = this.getBillingCycleAnchor();
            String other$billingCycleAnchor = other.getBillingCycleAnchor();
            if (this$billingCycleAnchor == null ? other$billingCycleAnchor != null : !this$billingCycleAnchor.equals(other$billingCycleAnchor)) {
                return false;
            }
            Subscription.BillingThresholds this$billingThresholds = this.getBillingThresholds();
            Subscription.BillingThresholds other$billingThresholds = other.getBillingThresholds();
            if (this$billingThresholds == null ? other$billingThresholds != null : !((Object)this$billingThresholds).equals(other$billingThresholds)) {
                return false;
            }
            String this$collectionMethod = this.getCollectionMethod();
            String other$collectionMethod = other.getCollectionMethod();
            if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) {
                return false;
            }
            String this$coupon = this.getCoupon();
            String other$coupon = other.getCoupon();
            if (this$coupon == null ? other$coupon != null : !this$coupon.equals(other$coupon)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            String this$defaultPaymentMethod = this.getDefaultPaymentMethod();
            String other$defaultPaymentMethod = other.getDefaultPaymentMethod();
            if (this$defaultPaymentMethod == null ? other$defaultPaymentMethod != null : !this$defaultPaymentMethod.equals(other$defaultPaymentMethod)) {
                return false;
            }
            List<TaxRate> this$defaultTaxRates = this.getDefaultTaxRates();
            List<TaxRate> other$defaultTaxRates = other.getDefaultTaxRates();
            if (this$defaultTaxRates == null ? other$defaultTaxRates != null : !((Object)this$defaultTaxRates).equals(other$defaultTaxRates)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            List<Discount> this$discounts = this.getDiscounts();
            List<Discount> other$discounts = other.getDiscounts();
            if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
                return false;
            }
            InvoiceSettings this$invoiceSettings = this.getInvoiceSettings();
            InvoiceSettings other$invoiceSettings = other.getInvoiceSettings();
            if (this$invoiceSettings == null ? other$invoiceSettings != null : !((Object)this$invoiceSettings).equals(other$invoiceSettings)) {
                return false;
            }
            List<PhaseItem> this$items = this.getItems();
            List<PhaseItem> other$items = other.getItems();
            if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
                return false;
            }
            Map<String, String> this$metadata = this.getMetadata();
            Map<String, String> other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            String this$onBehalfOf = this.getOnBehalfOf();
            String other$onBehalfOf = other.getOnBehalfOf();
            if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
                return false;
            }
            String this$prorationBehavior = this.getProrationBehavior();
            String other$prorationBehavior = other.getProrationBehavior();
            if (this$prorationBehavior == null ? other$prorationBehavior != null : !this$prorationBehavior.equals(other$prorationBehavior)) {
                return false;
            }
            Subscription.TransferData this$transferData = this.getTransferData();
            Subscription.TransferData other$transferData = other.getTransferData();
            if (this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData)) {
                return false;
            }
            String this$trialContinuation = this.getTrialContinuation();
            String other$trialContinuation = other.getTrialContinuation();
            if (this$trialContinuation == null ? other$trialContinuation != null : !this$trialContinuation.equals(other$trialContinuation)) {
                return false;
            }
            TrialSettings this$trialSettings = this.getTrialSettings();
            TrialSettings other$trialSettings = other.getTrialSettings();
            return !(this$trialSettings == null ? other$trialSettings != null : !((Object)this$trialSettings).equals(other$trialSettings));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Phase;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $endDate = this.getEndDate();
            result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
            Long $startDate = this.getStartDate();
            result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
            Long $trialEnd = this.getTrialEnd();
            result = result * 59 + ($trialEnd == null ? 43 : ((Object)$trialEnd).hashCode());
            List<AddInvoiceItem> $addInvoiceItems = this.getAddInvoiceItems();
            result = result * 59 + ($addInvoiceItems == null ? 43 : ((Object)$addInvoiceItems).hashCode());
            BigDecimal $applicationFeePercent = this.getApplicationFeePercent();
            result = result * 59 + ($applicationFeePercent == null ? 43 : ((Object)$applicationFeePercent).hashCode());
            AutomaticTax $automaticTax = this.getAutomaticTax();
            result = result * 59 + ($automaticTax == null ? 43 : ((Object)$automaticTax).hashCode());
            String $billingCycleAnchor = this.getBillingCycleAnchor();
            result = result * 59 + ($billingCycleAnchor == null ? 43 : $billingCycleAnchor.hashCode());
            Subscription.BillingThresholds $billingThresholds = this.getBillingThresholds();
            result = result * 59 + ($billingThresholds == null ? 43 : ((Object)$billingThresholds).hashCode());
            String $collectionMethod = this.getCollectionMethod();
            result = result * 59 + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
            String $coupon = this.getCoupon();
            result = result * 59 + ($coupon == null ? 43 : $coupon.hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            String $defaultPaymentMethod = this.getDefaultPaymentMethod();
            result = result * 59 + ($defaultPaymentMethod == null ? 43 : $defaultPaymentMethod.hashCode());
            List<TaxRate> $defaultTaxRates = this.getDefaultTaxRates();
            result = result * 59 + ($defaultTaxRates == null ? 43 : ((Object)$defaultTaxRates).hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            List<Discount> $discounts = this.getDiscounts();
            result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
            InvoiceSettings $invoiceSettings = this.getInvoiceSettings();
            result = result * 59 + ($invoiceSettings == null ? 43 : ((Object)$invoiceSettings).hashCode());
            List<PhaseItem> $items = this.getItems();
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            Map<String, String> $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            String $onBehalfOf = this.getOnBehalfOf();
            result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
            String $prorationBehavior = this.getProrationBehavior();
            result = result * 59 + ($prorationBehavior == null ? 43 : $prorationBehavior.hashCode());
            Subscription.TransferData $transferData = this.getTransferData();
            result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
            String $trialContinuation = this.getTrialContinuation();
            result = result * 59 + ($trialContinuation == null ? 43 : $trialContinuation.hashCode());
            TrialSettings $trialSettings = this.getTrialSettings();
            result = result * 59 + ($trialSettings == null ? 43 : ((Object)$trialSettings).hashCode());
            return result;
        }

        public static class AutomaticTax
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AutomaticTax)) {
                    return false;
                }
                AutomaticTax other = (AutomaticTax)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AutomaticTax;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                return result;
            }
        }

        public static class TrialSettings
        extends StripeObject {
            @SerializedName(value="end_behavior")
            EndBehavior endBehavior;

            @Generated
            public EndBehavior getEndBehavior() {
                return this.endBehavior;
            }

            @Generated
            public void setEndBehavior(EndBehavior endBehavior) {
                this.endBehavior = endBehavior;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TrialSettings)) {
                    return false;
                }
                TrialSettings other = (TrialSettings)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                EndBehavior this$endBehavior = this.getEndBehavior();
                EndBehavior other$endBehavior = other.getEndBehavior();
                return !(this$endBehavior == null ? other$endBehavior != null : !((Object)this$endBehavior).equals(other$endBehavior));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TrialSettings;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                EndBehavior $endBehavior = this.getEndBehavior();
                result = result * 59 + ($endBehavior == null ? 43 : ((Object)$endBehavior).hashCode());
                return result;
            }

            public static class EndBehavior
            extends StripeObject {
                @SerializedName(value="prorate_up_front")
                String prorateUpFront;

                @Generated
                public String getProrateUpFront() {
                    return this.prorateUpFront;
                }

                @Generated
                public void setProrateUpFront(String prorateUpFront) {
                    this.prorateUpFront = prorateUpFront;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof EndBehavior)) {
                        return false;
                    }
                    EndBehavior other = (EndBehavior)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$prorateUpFront = this.getProrateUpFront();
                    String other$prorateUpFront = other.getProrateUpFront();
                    return !(this$prorateUpFront == null ? other$prorateUpFront != null : !this$prorateUpFront.equals(other$prorateUpFront));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof EndBehavior;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $prorateUpFront = this.getProrateUpFront();
                    result = result * 59 + ($prorateUpFront == null ? 43 : $prorateUpFront.hashCode());
                    return result;
                }
            }
        }

        public static class Discount
        extends StripeObject {
            @SerializedName(value="coupon")
            ExpandableField<Coupon> coupon;
            @SerializedName(value="discount")
            ExpandableField<com.stripe.model.Discount> discount;

            public String getCoupon() {
                return this.coupon != null ? this.coupon.getId() : null;
            }

            public void setCoupon(String id) {
                this.coupon = ApiResource.setExpandableFieldId(id, this.coupon);
            }

            public Coupon getCouponObject() {
                return this.coupon != null ? this.coupon.getExpanded() : null;
            }

            public void setCouponObject(Coupon expandableObject) {
                this.coupon = new ExpandableField<Coupon>(expandableObject.getId(), expandableObject);
            }

            public String getDiscount() {
                return this.discount != null ? this.discount.getId() : null;
            }

            public void setDiscount(String id) {
                this.discount = ApiResource.setExpandableFieldId(id, this.discount);
            }

            public com.stripe.model.Discount getDiscountObject() {
                return this.discount != null ? this.discount.getExpanded() : null;
            }

            public void setDiscountObject(com.stripe.model.Discount expandableObject) {
                this.discount = new ExpandableField<com.stripe.model.Discount>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Discount)) {
                    return false;
                }
                Discount other = (Discount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$coupon = this.getCoupon();
                String other$coupon = other.getCoupon();
                if (this$coupon == null ? other$coupon != null : !this$coupon.equals(other$coupon)) {
                    return false;
                }
                String this$discount = this.getDiscount();
                String other$discount = other.getDiscount();
                return !(this$discount == null ? other$discount != null : !this$discount.equals(other$discount));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Discount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $coupon = this.getCoupon();
                result = result * 59 + ($coupon == null ? 43 : $coupon.hashCode());
                String $discount = this.getDiscount();
                result = result * 59 + ($discount == null ? 43 : $discount.hashCode());
                return result;
            }
        }
    }

    public static class InvoiceSettings
    extends StripeObject {
        @SerializedName(value="days_until_due")
        Long daysUntilDue;

        @Generated
        public Long getDaysUntilDue() {
            return this.daysUntilDue;
        }

        @Generated
        public void setDaysUntilDue(Long daysUntilDue) {
            this.daysUntilDue = daysUntilDue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoiceSettings)) {
                return false;
            }
            InvoiceSettings other = (InvoiceSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$daysUntilDue = this.getDaysUntilDue();
            Long other$daysUntilDue = other.getDaysUntilDue();
            return !(this$daysUntilDue == null ? other$daysUntilDue != null : !((Object)this$daysUntilDue).equals(other$daysUntilDue));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InvoiceSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $daysUntilDue = this.getDaysUntilDue();
            result = result * 59 + ($daysUntilDue == null ? 43 : ((Object)$daysUntilDue).hashCode());
            return result;
        }
    }

    public static class AddInvoiceItem
    extends StripeObject {
        @SerializedName(value="discounts")
        List<StackableDiscount> discounts;
        @SerializedName(value="price")
        ExpandableField<Price> price;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="tax_rates")
        List<TaxRate> taxRates;

        public String getPrice() {
            return this.price != null ? this.price.getId() : null;
        }

        public void setPrice(String id) {
            this.price = ApiResource.setExpandableFieldId(id, this.price);
        }

        public Price getPriceObject() {
            return this.price != null ? this.price.getExpanded() : null;
        }

        public void setPriceObject(Price expandableObject) {
            this.price = new ExpandableField<Price>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public List<StackableDiscount> getDiscounts() {
            return this.discounts;
        }

        @Generated
        public Long getQuantity() {
            return this.quantity;
        }

        @Generated
        public List<TaxRate> getTaxRates() {
            return this.taxRates;
        }

        @Generated
        public void setDiscounts(List<StackableDiscount> discounts) {
            this.discounts = discounts;
        }

        @Generated
        public void setQuantity(Long quantity) {
            this.quantity = quantity;
        }

        @Generated
        public void setTaxRates(List<TaxRate> taxRates) {
            this.taxRates = taxRates;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddInvoiceItem)) {
                return false;
            }
            AddInvoiceItem other = (AddInvoiceItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$quantity = this.getQuantity();
            Long other$quantity = other.getQuantity();
            if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                return false;
            }
            List<StackableDiscount> this$discounts = this.getDiscounts();
            List<StackableDiscount> other$discounts = other.getDiscounts();
            if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
                return false;
            }
            String this$price = this.getPrice();
            String other$price = other.getPrice();
            if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
                return false;
            }
            List<TaxRate> this$taxRates = this.getTaxRates();
            List<TaxRate> other$taxRates = other.getTaxRates();
            return !(this$taxRates == null ? other$taxRates != null : !((Object)this$taxRates).equals(other$taxRates));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AddInvoiceItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $quantity = this.getQuantity();
            result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
            List<StackableDiscount> $discounts = this.getDiscounts();
            result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
            String $price = this.getPrice();
            result = result * 59 + ($price == null ? 43 : $price.hashCode());
            List<TaxRate> $taxRates = this.getTaxRates();
            result = result * 59 + ($taxRates == null ? 43 : ((Object)$taxRates).hashCode());
            return result;
        }

        public static class StackableDiscount
        extends StripeObject {
            @SerializedName(value="coupon")
            ExpandableField<Coupon> coupon;
            @SerializedName(value="discount")
            ExpandableField<Discount> discount;

            public String getCoupon() {
                return this.coupon != null ? this.coupon.getId() : null;
            }

            public void setCoupon(String id) {
                this.coupon = ApiResource.setExpandableFieldId(id, this.coupon);
            }

            public Coupon getCouponObject() {
                return this.coupon != null ? this.coupon.getExpanded() : null;
            }

            public void setCouponObject(Coupon expandableObject) {
                this.coupon = new ExpandableField<Coupon>(expandableObject.getId(), expandableObject);
            }

            public String getDiscount() {
                return this.discount != null ? this.discount.getId() : null;
            }

            public void setDiscount(String id) {
                this.discount = ApiResource.setExpandableFieldId(id, this.discount);
            }

            public Discount getDiscountObject() {
                return this.discount != null ? this.discount.getExpanded() : null;
            }

            public void setDiscountObject(Discount expandableObject) {
                this.discount = new ExpandableField<Discount>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StackableDiscount)) {
                    return false;
                }
                StackableDiscount other = (StackableDiscount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$coupon = this.getCoupon();
                String other$coupon = other.getCoupon();
                if (this$coupon == null ? other$coupon != null : !this$coupon.equals(other$coupon)) {
                    return false;
                }
                String this$discount = this.getDiscount();
                String other$discount = other.getDiscount();
                return !(this$discount == null ? other$discount != null : !this$discount.equals(other$discount));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof StackableDiscount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $coupon = this.getCoupon();
                result = result * 59 + ($coupon == null ? 43 : $coupon.hashCode());
                String $discount = this.getDiscount();
                result = result * 59 + ($discount == null ? 43 : $discount.hashCode());
                return result;
            }
        }
    }
}

