/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SubscriptionScheduleUpdateParams
extends ApiRequestParams {
    @SerializedName(value="billing_behavior")
    BillingBehavior billingBehavior;
    @SerializedName(value="default_settings")
    DefaultSettings defaultSettings;
    @SerializedName(value="end_behavior")
    EndBehavior endBehavior;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="metadata")
    Object metadata;
    @SerializedName(value="phases")
    List<Phase> phases;
    @SerializedName(value="prebilling")
    Prebilling prebilling;
    @SerializedName(value="proration_behavior")
    ProrationBehavior prorationBehavior;

    private SubscriptionScheduleUpdateParams(BillingBehavior billingBehavior, DefaultSettings defaultSettings, EndBehavior endBehavior, List<String> expand, Map<String, Object> extraParams, Object metadata, List<Phase> phases, Prebilling prebilling, ProrationBehavior prorationBehavior) {
        this.billingBehavior = billingBehavior;
        this.defaultSettings = defaultSettings;
        this.endBehavior = endBehavior;
        this.expand = expand;
        this.extraParams = extraParams;
        this.metadata = metadata;
        this.phases = phases;
        this.prebilling = prebilling;
        this.prorationBehavior = prorationBehavior;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public BillingBehavior getBillingBehavior() {
        return this.billingBehavior;
    }

    @Generated
    public DefaultSettings getDefaultSettings() {
        return this.defaultSettings;
    }

    @Generated
    public EndBehavior getEndBehavior() {
        return this.endBehavior;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public Object getMetadata() {
        return this.metadata;
    }

    @Generated
    public List<Phase> getPhases() {
        return this.phases;
    }

    @Generated
    public Prebilling getPrebilling() {
        return this.prebilling;
    }

    @Generated
    public ProrationBehavior getProrationBehavior() {
        return this.prorationBehavior;
    }

    public static enum BillingBehavior implements ApiRequestParams.EnumParam
    {
        PRORATE_ON_NEXT_PHASE("prorate_on_next_phase"),
        PRORATE_UP_FRONT("prorate_up_front");

        private final String value;

        private BillingBehavior(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class DefaultSettings {
        @SerializedName(value="application_fee_percent")
        BigDecimal applicationFeePercent;
        @SerializedName(value="automatic_tax")
        AutomaticTax automaticTax;
        @SerializedName(value="billing_cycle_anchor")
        BillingCycleAnchor billingCycleAnchor;
        @SerializedName(value="billing_thresholds")
        Object billingThresholds;
        @SerializedName(value="collection_method")
        CollectionMethod collectionMethod;
        @SerializedName(value="default_payment_method")
        Object defaultPaymentMethod;
        @SerializedName(value="description")
        Object description;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="invoice_settings")
        InvoiceSettings invoiceSettings;
        @SerializedName(value="on_behalf_of")
        Object onBehalfOf;
        @SerializedName(value="transfer_data")
        Object transferData;

        private DefaultSettings(BigDecimal applicationFeePercent, AutomaticTax automaticTax, BillingCycleAnchor billingCycleAnchor, Object billingThresholds, CollectionMethod collectionMethod, Object defaultPaymentMethod, Object description, Map<String, Object> extraParams, InvoiceSettings invoiceSettings, Object onBehalfOf, Object transferData) {
            this.applicationFeePercent = applicationFeePercent;
            this.automaticTax = automaticTax;
            this.billingCycleAnchor = billingCycleAnchor;
            this.billingThresholds = billingThresholds;
            this.collectionMethod = collectionMethod;
            this.defaultPaymentMethod = defaultPaymentMethod;
            this.description = description;
            this.extraParams = extraParams;
            this.invoiceSettings = invoiceSettings;
            this.onBehalfOf = onBehalfOf;
            this.transferData = transferData;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public BigDecimal getApplicationFeePercent() {
            return this.applicationFeePercent;
        }

        @Generated
        public AutomaticTax getAutomaticTax() {
            return this.automaticTax;
        }

        @Generated
        public BillingCycleAnchor getBillingCycleAnchor() {
            return this.billingCycleAnchor;
        }

        @Generated
        public Object getBillingThresholds() {
            return this.billingThresholds;
        }

        @Generated
        public CollectionMethod getCollectionMethod() {
            return this.collectionMethod;
        }

        @Generated
        public Object getDefaultPaymentMethod() {
            return this.defaultPaymentMethod;
        }

        @Generated
        public Object getDescription() {
            return this.description;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public InvoiceSettings getInvoiceSettings() {
            return this.invoiceSettings;
        }

        @Generated
        public Object getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Generated
        public Object getTransferData() {
            return this.transferData;
        }

        public static class AutomaticTax {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private AutomaticTax(Boolean enabled, Map<String, Object> extraParams) {
                this.enabled = enabled;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Boolean enabled;
                private Map<String, Object> extraParams;

                public AutomaticTax build() {
                    return new AutomaticTax(this.enabled, this.extraParams);
                }

                public Builder setEnabled(Boolean enabled) {
                    this.enabled = enabled;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static enum BillingCycleAnchor implements ApiRequestParams.EnumParam
        {
            AUTOMATIC("automatic"),
            PHASE_START("phase_start");

            private final String value;

            private BillingCycleAnchor(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum CollectionMethod implements ApiRequestParams.EnumParam
        {
            CHARGE_AUTOMATICALLY("charge_automatically"),
            SEND_INVOICE("send_invoice");

            private final String value;

            private CollectionMethod(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class InvoiceSettings {
            @SerializedName(value="days_until_due")
            Long daysUntilDue;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private InvoiceSettings(Long daysUntilDue, Map<String, Object> extraParams) {
                this.daysUntilDue = daysUntilDue;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getDaysUntilDue() {
                return this.daysUntilDue;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Long daysUntilDue;
                private Map<String, Object> extraParams;

                public InvoiceSettings build() {
                    return new InvoiceSettings(this.daysUntilDue, this.extraParams);
                }

                public Builder setDaysUntilDue(Long daysUntilDue) {
                    this.daysUntilDue = daysUntilDue;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Builder {
            private BigDecimal applicationFeePercent;
            private AutomaticTax automaticTax;
            private BillingCycleAnchor billingCycleAnchor;
            private Object billingThresholds;
            private CollectionMethod collectionMethod;
            private Object defaultPaymentMethod;
            private Object description;
            private Map<String, Object> extraParams;
            private InvoiceSettings invoiceSettings;
            private Object onBehalfOf;
            private Object transferData;

            public DefaultSettings build() {
                return new DefaultSettings(this.applicationFeePercent, this.automaticTax, this.billingCycleAnchor, this.billingThresholds, this.collectionMethod, this.defaultPaymentMethod, this.description, this.extraParams, this.invoiceSettings, this.onBehalfOf, this.transferData);
            }

            public Builder setApplicationFeePercent(BigDecimal applicationFeePercent) {
                this.applicationFeePercent = applicationFeePercent;
                return this;
            }

            public Builder setAutomaticTax(AutomaticTax automaticTax) {
                this.automaticTax = automaticTax;
                return this;
            }

            public Builder setBillingCycleAnchor(BillingCycleAnchor billingCycleAnchor) {
                this.billingCycleAnchor = billingCycleAnchor;
                return this;
            }

            public Builder setBillingThresholds(BillingThresholds billingThresholds) {
                this.billingThresholds = billingThresholds;
                return this;
            }

            public Builder setBillingThresholds(EmptyParam billingThresholds) {
                this.billingThresholds = billingThresholds;
                return this;
            }

            public Builder setCollectionMethod(CollectionMethod collectionMethod) {
                this.collectionMethod = collectionMethod;
                return this;
            }

            public Builder setDefaultPaymentMethod(String defaultPaymentMethod) {
                this.defaultPaymentMethod = defaultPaymentMethod;
                return this;
            }

            public Builder setDefaultPaymentMethod(EmptyParam defaultPaymentMethod) {
                this.defaultPaymentMethod = defaultPaymentMethod;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder setDescription(EmptyParam description) {
                this.description = description;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setInvoiceSettings(InvoiceSettings invoiceSettings) {
                this.invoiceSettings = invoiceSettings;
                return this;
            }

            public Builder setOnBehalfOf(String onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }

            public Builder setOnBehalfOf(EmptyParam onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }

            public Builder setTransferData(TransferData transferData) {
                this.transferData = transferData;
                return this;
            }

            public Builder setTransferData(EmptyParam transferData) {
                this.transferData = transferData;
                return this;
            }
        }

        public static class TransferData {
            @SerializedName(value="amount_percent")
            BigDecimal amountPercent;
            @SerializedName(value="destination")
            Object destination;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private TransferData(BigDecimal amountPercent, Object destination, Map<String, Object> extraParams) {
                this.amountPercent = amountPercent;
                this.destination = destination;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public BigDecimal getAmountPercent() {
                return this.amountPercent;
            }

            @Generated
            public Object getDestination() {
                return this.destination;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private BigDecimal amountPercent;
                private Object destination;
                private Map<String, Object> extraParams;

                public TransferData build() {
                    return new TransferData(this.amountPercent, this.destination, this.extraParams);
                }

                public Builder setAmountPercent(BigDecimal amountPercent) {
                    this.amountPercent = amountPercent;
                    return this;
                }

                public Builder setDestination(String destination) {
                    this.destination = destination;
                    return this;
                }

                public Builder setDestination(EmptyParam destination) {
                    this.destination = destination;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class BillingThresholds {
            @SerializedName(value="amount_gte")
            Long amountGte;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="reset_billing_cycle_anchor")
            Boolean resetBillingCycleAnchor;

            private BillingThresholds(Long amountGte, Map<String, Object> extraParams, Boolean resetBillingCycleAnchor) {
                this.amountGte = amountGte;
                this.extraParams = extraParams;
                this.resetBillingCycleAnchor = resetBillingCycleAnchor;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getAmountGte() {
                return this.amountGte;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getResetBillingCycleAnchor() {
                return this.resetBillingCycleAnchor;
            }

            public static class Builder {
                private Long amountGte;
                private Map<String, Object> extraParams;
                private Boolean resetBillingCycleAnchor;

                public BillingThresholds build() {
                    return new BillingThresholds(this.amountGte, this.extraParams, this.resetBillingCycleAnchor);
                }

                public Builder setAmountGte(Long amountGte) {
                    this.amountGte = amountGte;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setResetBillingCycleAnchor(Boolean resetBillingCycleAnchor) {
                    this.resetBillingCycleAnchor = resetBillingCycleAnchor;
                    return this;
                }
            }
        }
    }

    public static enum EndBehavior implements ApiRequestParams.EnumParam
    {
        CANCEL("cancel"),
        NONE("none"),
        RELEASE("release"),
        RENEW("renew");

        private final String value;

        private EndBehavior(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Prebilling {
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="iterations")
        Long iterations;

        private Prebilling(Map<String, Object> extraParams, Long iterations) {
            this.extraParams = extraParams;
            this.iterations = iterations;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Long getIterations() {
            return this.iterations;
        }

        public static class Builder {
            private Map<String, Object> extraParams;
            private Long iterations;

            public Prebilling build() {
                return new Prebilling(this.extraParams, this.iterations);
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setIterations(Long iterations) {
                this.iterations = iterations;
                return this;
            }
        }
    }

    public static enum ProrationBehavior implements ApiRequestParams.EnumParam
    {
        ALWAYS_INVOICE("always_invoice"),
        CREATE_PRORATIONS("create_prorations"),
        NONE("none");

        private final String value;

        private ProrationBehavior(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Builder {
        private BillingBehavior billingBehavior;
        private DefaultSettings defaultSettings;
        private EndBehavior endBehavior;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private Object metadata;
        private List<Phase> phases;
        private Prebilling prebilling;
        private ProrationBehavior prorationBehavior;

        public SubscriptionScheduleUpdateParams build() {
            return new SubscriptionScheduleUpdateParams(this.billingBehavior, this.defaultSettings, this.endBehavior, this.expand, this.extraParams, this.metadata, this.phases, this.prebilling, this.prorationBehavior);
        }

        public Builder setBillingBehavior(BillingBehavior billingBehavior) {
            this.billingBehavior = billingBehavior;
            return this;
        }

        public Builder setDefaultSettings(DefaultSettings defaultSettings) {
            this.defaultSettings = defaultSettings;
            return this;
        }

        public Builder setEndBehavior(EndBehavior endBehavior) {
            this.endBehavior = endBehavior;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null || this.metadata instanceof EmptyParam) {
                this.metadata = new HashMap();
            }
            ((Map)this.metadata).put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null || this.metadata instanceof EmptyParam) {
                this.metadata = new HashMap();
            }
            ((Map)this.metadata).putAll(map);
            return this;
        }

        public Builder setMetadata(EmptyParam metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder addPhase(Phase element) {
            if (this.phases == null) {
                this.phases = new ArrayList<Phase>();
            }
            this.phases.add(element);
            return this;
        }

        public Builder addAllPhase(List<Phase> elements) {
            if (this.phases == null) {
                this.phases = new ArrayList<Phase>();
            }
            this.phases.addAll(elements);
            return this;
        }

        public Builder setPrebilling(Prebilling prebilling) {
            this.prebilling = prebilling;
            return this;
        }

        public Builder setProrationBehavior(ProrationBehavior prorationBehavior) {
            this.prorationBehavior = prorationBehavior;
            return this;
        }
    }

    public static class Phase {
        @SerializedName(value="add_invoice_items")
        List<AddInvoiceItem> addInvoiceItems;
        @SerializedName(value="application_fee_percent")
        BigDecimal applicationFeePercent;
        @SerializedName(value="automatic_tax")
        AutomaticTax automaticTax;
        @SerializedName(value="billing_cycle_anchor")
        BillingCycleAnchor billingCycleAnchor;
        @SerializedName(value="billing_thresholds")
        Object billingThresholds;
        @SerializedName(value="collection_method")
        CollectionMethod collectionMethod;
        @SerializedName(value="coupon")
        Object coupon;
        @SerializedName(value="currency")
        Object currency;
        @SerializedName(value="default_payment_method")
        Object defaultPaymentMethod;
        @SerializedName(value="default_tax_rates")
        Object defaultTaxRates;
        @SerializedName(value="description")
        Object description;
        @SerializedName(value="discounts")
        Object discounts;
        @SerializedName(value="end_date")
        Object endDate;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="invoice_settings")
        InvoiceSettings invoiceSettings;
        @SerializedName(value="items")
        List<Item> items;
        @SerializedName(value="iterations")
        Long iterations;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="on_behalf_of")
        Object onBehalfOf;
        @SerializedName(value="proration_behavior")
        ProrationBehavior prorationBehavior;
        @SerializedName(value="start_date")
        Object startDate;
        @SerializedName(value="transfer_data")
        TransferData transferData;
        @SerializedName(value="trial")
        Boolean trial;
        @SerializedName(value="trial_continuation")
        TrialContinuation trialContinuation;
        @SerializedName(value="trial_end")
        Object trialEnd;
        @SerializedName(value="trial_settings")
        TrialSettings trialSettings;

        private Phase(List<AddInvoiceItem> addInvoiceItems, BigDecimal applicationFeePercent, AutomaticTax automaticTax, BillingCycleAnchor billingCycleAnchor, Object billingThresholds, CollectionMethod collectionMethod, Object coupon, Object currency, Object defaultPaymentMethod, Object defaultTaxRates, Object description, Object discounts, Object endDate, Map<String, Object> extraParams, InvoiceSettings invoiceSettings, List<Item> items, Long iterations, Map<String, String> metadata, Object onBehalfOf, ProrationBehavior prorationBehavior, Object startDate, TransferData transferData, Boolean trial, TrialContinuation trialContinuation, Object trialEnd, TrialSettings trialSettings) {
            this.addInvoiceItems = addInvoiceItems;
            this.applicationFeePercent = applicationFeePercent;
            this.automaticTax = automaticTax;
            this.billingCycleAnchor = billingCycleAnchor;
            this.billingThresholds = billingThresholds;
            this.collectionMethod = collectionMethod;
            this.coupon = coupon;
            this.currency = currency;
            this.defaultPaymentMethod = defaultPaymentMethod;
            this.defaultTaxRates = defaultTaxRates;
            this.description = description;
            this.discounts = discounts;
            this.endDate = endDate;
            this.extraParams = extraParams;
            this.invoiceSettings = invoiceSettings;
            this.items = items;
            this.iterations = iterations;
            this.metadata = metadata;
            this.onBehalfOf = onBehalfOf;
            this.prorationBehavior = prorationBehavior;
            this.startDate = startDate;
            this.transferData = transferData;
            this.trial = trial;
            this.trialContinuation = trialContinuation;
            this.trialEnd = trialEnd;
            this.trialSettings = trialSettings;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public List<AddInvoiceItem> getAddInvoiceItems() {
            return this.addInvoiceItems;
        }

        @Generated
        public BigDecimal getApplicationFeePercent() {
            return this.applicationFeePercent;
        }

        @Generated
        public AutomaticTax getAutomaticTax() {
            return this.automaticTax;
        }

        @Generated
        public BillingCycleAnchor getBillingCycleAnchor() {
            return this.billingCycleAnchor;
        }

        @Generated
        public Object getBillingThresholds() {
            return this.billingThresholds;
        }

        @Generated
        public CollectionMethod getCollectionMethod() {
            return this.collectionMethod;
        }

        @Generated
        public Object getCoupon() {
            return this.coupon;
        }

        @Generated
        public Object getCurrency() {
            return this.currency;
        }

        @Generated
        public Object getDefaultPaymentMethod() {
            return this.defaultPaymentMethod;
        }

        @Generated
        public Object getDefaultTaxRates() {
            return this.defaultTaxRates;
        }

        @Generated
        public Object getDescription() {
            return this.description;
        }

        @Generated
        public Object getDiscounts() {
            return this.discounts;
        }

        @Generated
        public Object getEndDate() {
            return this.endDate;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public InvoiceSettings getInvoiceSettings() {
            return this.invoiceSettings;
        }

        @Generated
        public List<Item> getItems() {
            return this.items;
        }

        @Generated
        public Long getIterations() {
            return this.iterations;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public Object getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Generated
        public ProrationBehavior getProrationBehavior() {
            return this.prorationBehavior;
        }

        @Generated
        public Object getStartDate() {
            return this.startDate;
        }

        @Generated
        public TransferData getTransferData() {
            return this.transferData;
        }

        @Generated
        public Boolean getTrial() {
            return this.trial;
        }

        @Generated
        public TrialContinuation getTrialContinuation() {
            return this.trialContinuation;
        }

        @Generated
        public Object getTrialEnd() {
            return this.trialEnd;
        }

        @Generated
        public TrialSettings getTrialSettings() {
            return this.trialSettings;
        }

        public static class AutomaticTax {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private AutomaticTax(Boolean enabled, Map<String, Object> extraParams) {
                this.enabled = enabled;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Boolean enabled;
                private Map<String, Object> extraParams;

                public AutomaticTax build() {
                    return new AutomaticTax(this.enabled, this.extraParams);
                }

                public Builder setEnabled(Boolean enabled) {
                    this.enabled = enabled;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static enum BillingCycleAnchor implements ApiRequestParams.EnumParam
        {
            AUTOMATIC("automatic"),
            PHASE_START("phase_start");

            private final String value;

            private BillingCycleAnchor(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum CollectionMethod implements ApiRequestParams.EnumParam
        {
            CHARGE_AUTOMATICALLY("charge_automatically"),
            SEND_INVOICE("send_invoice");

            private final String value;

            private CollectionMethod(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class InvoiceSettings {
            @SerializedName(value="days_until_due")
            Long daysUntilDue;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private InvoiceSettings(Long daysUntilDue, Map<String, Object> extraParams) {
                this.daysUntilDue = daysUntilDue;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getDaysUntilDue() {
                return this.daysUntilDue;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Long daysUntilDue;
                private Map<String, Object> extraParams;

                public InvoiceSettings build() {
                    return new InvoiceSettings(this.daysUntilDue, this.extraParams);
                }

                public Builder setDaysUntilDue(Long daysUntilDue) {
                    this.daysUntilDue = daysUntilDue;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static enum ProrationBehavior implements ApiRequestParams.EnumParam
        {
            ALWAYS_INVOICE("always_invoice"),
            CREATE_PRORATIONS("create_prorations"),
            NONE("none");

            private final String value;

            private ProrationBehavior(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class TransferData {
            @SerializedName(value="amount_percent")
            BigDecimal amountPercent;
            @SerializedName(value="destination")
            Object destination;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private TransferData(BigDecimal amountPercent, Object destination, Map<String, Object> extraParams) {
                this.amountPercent = amountPercent;
                this.destination = destination;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public BigDecimal getAmountPercent() {
                return this.amountPercent;
            }

            @Generated
            public Object getDestination() {
                return this.destination;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private BigDecimal amountPercent;
                private Object destination;
                private Map<String, Object> extraParams;

                public TransferData build() {
                    return new TransferData(this.amountPercent, this.destination, this.extraParams);
                }

                public Builder setAmountPercent(BigDecimal amountPercent) {
                    this.amountPercent = amountPercent;
                    return this;
                }

                public Builder setDestination(String destination) {
                    this.destination = destination;
                    return this;
                }

                public Builder setDestination(EmptyParam destination) {
                    this.destination = destination;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static enum TrialContinuation implements ApiRequestParams.EnumParam
        {
            CONTINUE("continue"),
            NONE("none");

            private final String value;

            private TrialContinuation(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class TrialSettings {
            @SerializedName(value="end_behavior")
            EndBehavior endBehavior;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private TrialSettings(EndBehavior endBehavior, Map<String, Object> extraParams) {
                this.endBehavior = endBehavior;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public EndBehavior getEndBehavior() {
                return this.endBehavior;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class EndBehavior {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="prorate_up_front")
                ProrateUpFront prorateUpFront;

                private EndBehavior(Map<String, Object> extraParams, ProrateUpFront prorateUpFront) {
                    this.extraParams = extraParams;
                    this.prorateUpFront = prorateUpFront;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public ProrateUpFront getProrateUpFront() {
                    return this.prorateUpFront;
                }

                public static enum ProrateUpFront implements ApiRequestParams.EnumParam
                {
                    DEFER("defer"),
                    INCLUDE("include");

                    private final String value;

                    private ProrateUpFront(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private ProrateUpFront prorateUpFront;

                    public EndBehavior build() {
                        return new EndBehavior(this.extraParams, this.prorateUpFront);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setProrateUpFront(ProrateUpFront prorateUpFront) {
                        this.prorateUpFront = prorateUpFront;
                        return this;
                    }
                }
            }

            public static class Builder {
                private EndBehavior endBehavior;
                private Map<String, Object> extraParams;

                public TrialSettings build() {
                    return new TrialSettings(this.endBehavior, this.extraParams);
                }

                public Builder setEndBehavior(EndBehavior endBehavior) {
                    this.endBehavior = endBehavior;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Builder {
            private List<AddInvoiceItem> addInvoiceItems;
            private BigDecimal applicationFeePercent;
            private AutomaticTax automaticTax;
            private BillingCycleAnchor billingCycleAnchor;
            private Object billingThresholds;
            private CollectionMethod collectionMethod;
            private Object coupon;
            private Object currency;
            private Object defaultPaymentMethod;
            private Object defaultTaxRates;
            private Object description;
            private Object discounts;
            private Object endDate;
            private Map<String, Object> extraParams;
            private InvoiceSettings invoiceSettings;
            private List<Item> items;
            private Long iterations;
            private Map<String, String> metadata;
            private Object onBehalfOf;
            private ProrationBehavior prorationBehavior;
            private Object startDate;
            private TransferData transferData;
            private Boolean trial;
            private TrialContinuation trialContinuation;
            private Object trialEnd;
            private TrialSettings trialSettings;

            public Phase build() {
                return new Phase(this.addInvoiceItems, this.applicationFeePercent, this.automaticTax, this.billingCycleAnchor, this.billingThresholds, this.collectionMethod, this.coupon, this.currency, this.defaultPaymentMethod, this.defaultTaxRates, this.description, this.discounts, this.endDate, this.extraParams, this.invoiceSettings, this.items, this.iterations, this.metadata, this.onBehalfOf, this.prorationBehavior, this.startDate, this.transferData, this.trial, this.trialContinuation, this.trialEnd, this.trialSettings);
            }

            public Builder addAddInvoiceItem(AddInvoiceItem element) {
                if (this.addInvoiceItems == null) {
                    this.addInvoiceItems = new ArrayList<AddInvoiceItem>();
                }
                this.addInvoiceItems.add(element);
                return this;
            }

            public Builder addAllAddInvoiceItem(List<AddInvoiceItem> elements) {
                if (this.addInvoiceItems == null) {
                    this.addInvoiceItems = new ArrayList<AddInvoiceItem>();
                }
                this.addInvoiceItems.addAll(elements);
                return this;
            }

            public Builder setApplicationFeePercent(BigDecimal applicationFeePercent) {
                this.applicationFeePercent = applicationFeePercent;
                return this;
            }

            public Builder setAutomaticTax(AutomaticTax automaticTax) {
                this.automaticTax = automaticTax;
                return this;
            }

            public Builder setBillingCycleAnchor(BillingCycleAnchor billingCycleAnchor) {
                this.billingCycleAnchor = billingCycleAnchor;
                return this;
            }

            public Builder setBillingThresholds(BillingThresholds billingThresholds) {
                this.billingThresholds = billingThresholds;
                return this;
            }

            public Builder setBillingThresholds(EmptyParam billingThresholds) {
                this.billingThresholds = billingThresholds;
                return this;
            }

            public Builder setCollectionMethod(CollectionMethod collectionMethod) {
                this.collectionMethod = collectionMethod;
                return this;
            }

            public Builder setCoupon(String coupon) {
                this.coupon = coupon;
                return this;
            }

            public Builder setCoupon(EmptyParam coupon) {
                this.coupon = coupon;
                return this;
            }

            public Builder setCurrency(String currency) {
                this.currency = currency;
                return this;
            }

            public Builder setCurrency(EmptyParam currency) {
                this.currency = currency;
                return this;
            }

            public Builder setDefaultPaymentMethod(String defaultPaymentMethod) {
                this.defaultPaymentMethod = defaultPaymentMethod;
                return this;
            }

            public Builder setDefaultPaymentMethod(EmptyParam defaultPaymentMethod) {
                this.defaultPaymentMethod = defaultPaymentMethod;
                return this;
            }

            public Builder addDefaultTaxRate(String element) {
                if (this.defaultTaxRates == null || this.defaultTaxRates instanceof EmptyParam) {
                    this.defaultTaxRates = new ArrayList();
                }
                ((List)this.defaultTaxRates).add(element);
                return this;
            }

            public Builder addAllDefaultTaxRate(List<String> elements) {
                if (this.defaultTaxRates == null || this.defaultTaxRates instanceof EmptyParam) {
                    this.defaultTaxRates = new ArrayList();
                }
                ((List)this.defaultTaxRates).addAll(elements);
                return this;
            }

            public Builder setDefaultTaxRates(EmptyParam defaultTaxRates) {
                this.defaultTaxRates = defaultTaxRates;
                return this;
            }

            public Builder setDefaultTaxRates(List<String> defaultTaxRates) {
                this.defaultTaxRates = defaultTaxRates;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder setDescription(EmptyParam description) {
                this.description = description;
                return this;
            }

            public Builder addDiscount(Discount element) {
                if (this.discounts == null || this.discounts instanceof EmptyParam) {
                    this.discounts = new ArrayList();
                }
                ((List)this.discounts).add(element);
                return this;
            }

            public Builder addAllDiscount(List<Discount> elements) {
                if (this.discounts == null || this.discounts instanceof EmptyParam) {
                    this.discounts = new ArrayList();
                }
                ((List)this.discounts).addAll(elements);
                return this;
            }

            public Builder setDiscounts(EmptyParam discounts) {
                this.discounts = discounts;
                return this;
            }

            public Builder setDiscounts(List<Discount> discounts) {
                this.discounts = discounts;
                return this;
            }

            public Builder setEndDate(Long endDate) {
                this.endDate = endDate;
                return this;
            }

            public Builder setEndDate(EndDate endDate) {
                this.endDate = endDate;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setInvoiceSettings(InvoiceSettings invoiceSettings) {
                this.invoiceSettings = invoiceSettings;
                return this;
            }

            public Builder addItem(Item element) {
                if (this.items == null) {
                    this.items = new ArrayList<Item>();
                }
                this.items.add(element);
                return this;
            }

            public Builder addAllItem(List<Item> elements) {
                if (this.items == null) {
                    this.items = new ArrayList<Item>();
                }
                this.items.addAll(elements);
                return this;
            }

            public Builder setIterations(Long iterations) {
                this.iterations = iterations;
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setOnBehalfOf(String onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }

            public Builder setOnBehalfOf(EmptyParam onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }

            public Builder setProrationBehavior(ProrationBehavior prorationBehavior) {
                this.prorationBehavior = prorationBehavior;
                return this;
            }

            public Builder setStartDate(Long startDate) {
                this.startDate = startDate;
                return this;
            }

            public Builder setStartDate(StartDate startDate) {
                this.startDate = startDate;
                return this;
            }

            public Builder setTransferData(TransferData transferData) {
                this.transferData = transferData;
                return this;
            }

            public Builder setTrial(Boolean trial) {
                this.trial = trial;
                return this;
            }

            public Builder setTrialContinuation(TrialContinuation trialContinuation) {
                this.trialContinuation = trialContinuation;
                return this;
            }

            public Builder setTrialEnd(Long trialEnd) {
                this.trialEnd = trialEnd;
                return this;
            }

            public Builder setTrialEnd(TrialEnd trialEnd) {
                this.trialEnd = trialEnd;
                return this;
            }

            public Builder setTrialSettings(TrialSettings trialSettings) {
                this.trialSettings = trialSettings;
                return this;
            }
        }

        public static enum TrialEnd implements ApiRequestParams.EnumParam
        {
            NOW("now");

            private final String value;

            private TrialEnd(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum StartDate implements ApiRequestParams.EnumParam
        {
            NOW("now");

            private final String value;

            private StartDate(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum EndDate implements ApiRequestParams.EnumParam
        {
            NOW("now");

            private final String value;

            private EndDate(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Item {
            @SerializedName(value="billing_thresholds")
            Object billingThresholds;
            @SerializedName(value="discounts")
            Object discounts;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="metadata")
            Map<String, String> metadata;
            @SerializedName(value="plan")
            Object plan;
            @SerializedName(value="price")
            Object price;
            @SerializedName(value="price_data")
            PriceData priceData;
            @SerializedName(value="quantity")
            Long quantity;
            @SerializedName(value="tax_rates")
            Object taxRates;
            @SerializedName(value="trial")
            Trial trial;

            private Item(Object billingThresholds, Object discounts, Map<String, Object> extraParams, Map<String, String> metadata, Object plan, Object price, PriceData priceData, Long quantity, Object taxRates, Trial trial) {
                this.billingThresholds = billingThresholds;
                this.discounts = discounts;
                this.extraParams = extraParams;
                this.metadata = metadata;
                this.plan = plan;
                this.price = price;
                this.priceData = priceData;
                this.quantity = quantity;
                this.taxRates = taxRates;
                this.trial = trial;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getBillingThresholds() {
                return this.billingThresholds;
            }

            @Generated
            public Object getDiscounts() {
                return this.discounts;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Map<String, String> getMetadata() {
                return this.metadata;
            }

            @Generated
            public Object getPlan() {
                return this.plan;
            }

            @Generated
            public Object getPrice() {
                return this.price;
            }

            @Generated
            public PriceData getPriceData() {
                return this.priceData;
            }

            @Generated
            public Long getQuantity() {
                return this.quantity;
            }

            @Generated
            public Object getTaxRates() {
                return this.taxRates;
            }

            @Generated
            public Trial getTrial() {
                return this.trial;
            }

            public static class PriceData {
                @SerializedName(value="currency")
                Object currency;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="product")
                Object product;
                @SerializedName(value="recurring")
                Recurring recurring;
                @SerializedName(value="tax_behavior")
                TaxBehavior taxBehavior;
                @SerializedName(value="unit_amount")
                Long unitAmount;
                @SerializedName(value="unit_amount_decimal")
                Object unitAmountDecimal;

                private PriceData(Object currency, Map<String, Object> extraParams, Object product, Recurring recurring, TaxBehavior taxBehavior, Long unitAmount, Object unitAmountDecimal) {
                    this.currency = currency;
                    this.extraParams = extraParams;
                    this.product = product;
                    this.recurring = recurring;
                    this.taxBehavior = taxBehavior;
                    this.unitAmount = unitAmount;
                    this.unitAmountDecimal = unitAmountDecimal;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Object getCurrency() {
                    return this.currency;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getProduct() {
                    return this.product;
                }

                @Generated
                public Recurring getRecurring() {
                    return this.recurring;
                }

                @Generated
                public TaxBehavior getTaxBehavior() {
                    return this.taxBehavior;
                }

                @Generated
                public Long getUnitAmount() {
                    return this.unitAmount;
                }

                @Generated
                public Object getUnitAmountDecimal() {
                    return this.unitAmountDecimal;
                }

                public static class Recurring {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="interval")
                    Interval interval;
                    @SerializedName(value="interval_count")
                    Long intervalCount;

                    private Recurring(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
                        this.extraParams = extraParams;
                        this.interval = interval;
                        this.intervalCount = intervalCount;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Interval getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public Long getIntervalCount() {
                        return this.intervalCount;
                    }

                    public static enum Interval implements ApiRequestParams.EnumParam
                    {
                        DAY("day"),
                        MONTH("month"),
                        WEEK("week"),
                        YEAR("year");

                        private final String value;

                        private Interval(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Interval interval;
                        private Long intervalCount;

                        public Recurring build() {
                            return new Recurring(this.extraParams, this.interval, this.intervalCount);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setInterval(Interval interval) {
                            this.interval = interval;
                            return this;
                        }

                        public Builder setIntervalCount(Long intervalCount) {
                            this.intervalCount = intervalCount;
                            return this;
                        }
                    }
                }

                public static enum TaxBehavior implements ApiRequestParams.EnumParam
                {
                    EXCLUSIVE("exclusive"),
                    INCLUSIVE("inclusive"),
                    UNSPECIFIED("unspecified");

                    private final String value;

                    private TaxBehavior(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Object currency;
                    private Map<String, Object> extraParams;
                    private Object product;
                    private Recurring recurring;
                    private TaxBehavior taxBehavior;
                    private Long unitAmount;
                    private Object unitAmountDecimal;

                    public PriceData build() {
                        return new PriceData(this.currency, this.extraParams, this.product, this.recurring, this.taxBehavior, this.unitAmount, this.unitAmountDecimal);
                    }

                    public Builder setCurrency(String currency) {
                        this.currency = currency;
                        return this;
                    }

                    public Builder setCurrency(EmptyParam currency) {
                        this.currency = currency;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setProduct(String product) {
                        this.product = product;
                        return this;
                    }

                    public Builder setProduct(EmptyParam product) {
                        this.product = product;
                        return this;
                    }

                    public Builder setRecurring(Recurring recurring) {
                        this.recurring = recurring;
                        return this;
                    }

                    public Builder setTaxBehavior(TaxBehavior taxBehavior) {
                        this.taxBehavior = taxBehavior;
                        return this;
                    }

                    public Builder setUnitAmount(Long unitAmount) {
                        this.unitAmount = unitAmount;
                        return this;
                    }

                    public Builder setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
                        this.unitAmountDecimal = unitAmountDecimal;
                        return this;
                    }

                    public Builder setUnitAmountDecimal(EmptyParam unitAmountDecimal) {
                        this.unitAmountDecimal = unitAmountDecimal;
                        return this;
                    }
                }
            }

            public static class Trial {
                @SerializedName(value="converts_to")
                List<String> convertsTo;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="type")
                Type type;

                private Trial(List<String> convertsTo, Map<String, Object> extraParams, Type type) {
                    this.convertsTo = convertsTo;
                    this.extraParams = extraParams;
                    this.type = type;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public List<String> getConvertsTo() {
                    return this.convertsTo;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Type getType() {
                    return this.type;
                }

                public static enum Type implements ApiRequestParams.EnumParam
                {
                    FREE("free"),
                    PAID("paid");

                    private final String value;

                    private Type(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private List<String> convertsTo;
                    private Map<String, Object> extraParams;
                    private Type type;

                    public Trial build() {
                        return new Trial(this.convertsTo, this.extraParams, this.type);
                    }

                    public Builder addConvertsTo(String element) {
                        if (this.convertsTo == null) {
                            this.convertsTo = new ArrayList<String>();
                        }
                        this.convertsTo.add(element);
                        return this;
                    }

                    public Builder addAllConvertsTo(List<String> elements) {
                        if (this.convertsTo == null) {
                            this.convertsTo = new ArrayList<String>();
                        }
                        this.convertsTo.addAll(elements);
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setType(Type type) {
                        this.type = type;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Object billingThresholds;
                private Object discounts;
                private Map<String, Object> extraParams;
                private Map<String, String> metadata;
                private Object plan;
                private Object price;
                private PriceData priceData;
                private Long quantity;
                private Object taxRates;
                private Trial trial;

                public Item build() {
                    return new Item(this.billingThresholds, this.discounts, this.extraParams, this.metadata, this.plan, this.price, this.priceData, this.quantity, this.taxRates, this.trial);
                }

                public Builder setBillingThresholds(BillingThresholds billingThresholds) {
                    this.billingThresholds = billingThresholds;
                    return this;
                }

                public Builder setBillingThresholds(EmptyParam billingThresholds) {
                    this.billingThresholds = billingThresholds;
                    return this;
                }

                public Builder addDiscount(Discount element) {
                    if (this.discounts == null || this.discounts instanceof EmptyParam) {
                        this.discounts = new ArrayList();
                    }
                    ((List)this.discounts).add(element);
                    return this;
                }

                public Builder addAllDiscount(List<Discount> elements) {
                    if (this.discounts == null || this.discounts instanceof EmptyParam) {
                        this.discounts = new ArrayList();
                    }
                    ((List)this.discounts).addAll(elements);
                    return this;
                }

                public Builder setDiscounts(EmptyParam discounts) {
                    this.discounts = discounts;
                    return this;
                }

                public Builder setDiscounts(List<Discount> discounts) {
                    this.discounts = discounts;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder putMetadata(String key, String value) {
                    if (this.metadata == null) {
                        this.metadata = new HashMap<String, String>();
                    }
                    this.metadata.put(key, value);
                    return this;
                }

                public Builder putAllMetadata(Map<String, String> map) {
                    if (this.metadata == null) {
                        this.metadata = new HashMap<String, String>();
                    }
                    this.metadata.putAll(map);
                    return this;
                }

                public Builder setPlan(String plan) {
                    this.plan = plan;
                    return this;
                }

                public Builder setPlan(EmptyParam plan) {
                    this.plan = plan;
                    return this;
                }

                public Builder setPrice(String price) {
                    this.price = price;
                    return this;
                }

                public Builder setPrice(EmptyParam price) {
                    this.price = price;
                    return this;
                }

                public Builder setPriceData(PriceData priceData) {
                    this.priceData = priceData;
                    return this;
                }

                public Builder setQuantity(Long quantity) {
                    this.quantity = quantity;
                    return this;
                }

                public Builder addTaxRate(String element) {
                    if (this.taxRates == null || this.taxRates instanceof EmptyParam) {
                        this.taxRates = new ArrayList();
                    }
                    ((List)this.taxRates).add(element);
                    return this;
                }

                public Builder addAllTaxRate(List<String> elements) {
                    if (this.taxRates == null || this.taxRates instanceof EmptyParam) {
                        this.taxRates = new ArrayList();
                    }
                    ((List)this.taxRates).addAll(elements);
                    return this;
                }

                public Builder setTaxRates(EmptyParam taxRates) {
                    this.taxRates = taxRates;
                    return this;
                }

                public Builder setTaxRates(List<String> taxRates) {
                    this.taxRates = taxRates;
                    return this;
                }

                public Builder setTrial(Trial trial) {
                    this.trial = trial;
                    return this;
                }
            }

            public static class Discount {
                @SerializedName(value="coupon")
                Object coupon;
                @SerializedName(value="discount")
                Object discount;
                @SerializedName(value="discount_end")
                DiscountEnd discountEnd;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private Discount(Object coupon, Object discount, DiscountEnd discountEnd, Map<String, Object> extraParams) {
                    this.coupon = coupon;
                    this.discount = discount;
                    this.discountEnd = discountEnd;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Object getCoupon() {
                    return this.coupon;
                }

                @Generated
                public Object getDiscount() {
                    return this.discount;
                }

                @Generated
                public DiscountEnd getDiscountEnd() {
                    return this.discountEnd;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class DiscountEnd {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="timestamp")
                    Long timestamp;
                    @SerializedName(value="type")
                    Type type;

                    private DiscountEnd(Map<String, Object> extraParams, Long timestamp, Type type) {
                        this.extraParams = extraParams;
                        this.timestamp = timestamp;
                        this.type = type;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Long getTimestamp() {
                        return this.timestamp;
                    }

                    @Generated
                    public Type getType() {
                        return this.type;
                    }

                    public static enum Type implements ApiRequestParams.EnumParam
                    {
                        TIMESTAMP("timestamp");

                        private final String value;

                        private Type(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Long timestamp;
                        private Type type;

                        public DiscountEnd build() {
                            return new DiscountEnd(this.extraParams, this.timestamp, this.type);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setTimestamp(Long timestamp) {
                            this.timestamp = timestamp;
                            return this;
                        }

                        public Builder setType(Type type) {
                            this.type = type;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Object coupon;
                    private Object discount;
                    private DiscountEnd discountEnd;
                    private Map<String, Object> extraParams;

                    public Discount build() {
                        return new Discount(this.coupon, this.discount, this.discountEnd, this.extraParams);
                    }

                    public Builder setCoupon(String coupon) {
                        this.coupon = coupon;
                        return this;
                    }

                    public Builder setCoupon(EmptyParam coupon) {
                        this.coupon = coupon;
                        return this;
                    }

                    public Builder setDiscount(String discount) {
                        this.discount = discount;
                        return this;
                    }

                    public Builder setDiscount(EmptyParam discount) {
                        this.discount = discount;
                        return this;
                    }

                    public Builder setDiscountEnd(DiscountEnd discountEnd) {
                        this.discountEnd = discountEnd;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }

            public static class BillingThresholds {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="usage_gte")
                Long usageGte;

                private BillingThresholds(Map<String, Object> extraParams, Long usageGte) {
                    this.extraParams = extraParams;
                    this.usageGte = usageGte;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Long getUsageGte() {
                    return this.usageGte;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Long usageGte;

                    public BillingThresholds build() {
                        return new BillingThresholds(this.extraParams, this.usageGte);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setUsageGte(Long usageGte) {
                        this.usageGte = usageGte;
                        return this;
                    }
                }
            }
        }

        public static class Discount {
            @SerializedName(value="coupon")
            Object coupon;
            @SerializedName(value="discount")
            Object discount;
            @SerializedName(value="discount_end")
            DiscountEnd discountEnd;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Discount(Object coupon, Object discount, DiscountEnd discountEnd, Map<String, Object> extraParams) {
                this.coupon = coupon;
                this.discount = discount;
                this.discountEnd = discountEnd;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getCoupon() {
                return this.coupon;
            }

            @Generated
            public Object getDiscount() {
                return this.discount;
            }

            @Generated
            public DiscountEnd getDiscountEnd() {
                return this.discountEnd;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class DiscountEnd {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="timestamp")
                Long timestamp;
                @SerializedName(value="type")
                Type type;

                private DiscountEnd(Map<String, Object> extraParams, Long timestamp, Type type) {
                    this.extraParams = extraParams;
                    this.timestamp = timestamp;
                    this.type = type;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Long getTimestamp() {
                    return this.timestamp;
                }

                @Generated
                public Type getType() {
                    return this.type;
                }

                public static enum Type implements ApiRequestParams.EnumParam
                {
                    TIMESTAMP("timestamp");

                    private final String value;

                    private Type(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Long timestamp;
                    private Type type;

                    public DiscountEnd build() {
                        return new DiscountEnd(this.extraParams, this.timestamp, this.type);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setTimestamp(Long timestamp) {
                        this.timestamp = timestamp;
                        return this;
                    }

                    public Builder setType(Type type) {
                        this.type = type;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Object coupon;
                private Object discount;
                private DiscountEnd discountEnd;
                private Map<String, Object> extraParams;

                public Discount build() {
                    return new Discount(this.coupon, this.discount, this.discountEnd, this.extraParams);
                }

                public Builder setCoupon(String coupon) {
                    this.coupon = coupon;
                    return this;
                }

                public Builder setCoupon(EmptyParam coupon) {
                    this.coupon = coupon;
                    return this;
                }

                public Builder setDiscount(String discount) {
                    this.discount = discount;
                    return this;
                }

                public Builder setDiscount(EmptyParam discount) {
                    this.discount = discount;
                    return this;
                }

                public Builder setDiscountEnd(DiscountEnd discountEnd) {
                    this.discountEnd = discountEnd;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class BillingThresholds {
            @SerializedName(value="amount_gte")
            Long amountGte;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="reset_billing_cycle_anchor")
            Boolean resetBillingCycleAnchor;

            private BillingThresholds(Long amountGte, Map<String, Object> extraParams, Boolean resetBillingCycleAnchor) {
                this.amountGte = amountGte;
                this.extraParams = extraParams;
                this.resetBillingCycleAnchor = resetBillingCycleAnchor;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getAmountGte() {
                return this.amountGte;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getResetBillingCycleAnchor() {
                return this.resetBillingCycleAnchor;
            }

            public static class Builder {
                private Long amountGte;
                private Map<String, Object> extraParams;
                private Boolean resetBillingCycleAnchor;

                public BillingThresholds build() {
                    return new BillingThresholds(this.amountGte, this.extraParams, this.resetBillingCycleAnchor);
                }

                public Builder setAmountGte(Long amountGte) {
                    this.amountGte = amountGte;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setResetBillingCycleAnchor(Boolean resetBillingCycleAnchor) {
                    this.resetBillingCycleAnchor = resetBillingCycleAnchor;
                    return this;
                }
            }
        }

        public static class AddInvoiceItem {
            @SerializedName(value="discounts")
            List<Discount> discounts;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="price")
            Object price;
            @SerializedName(value="price_data")
            PriceData priceData;
            @SerializedName(value="quantity")
            Long quantity;
            @SerializedName(value="tax_rates")
            Object taxRates;

            private AddInvoiceItem(List<Discount> discounts, Map<String, Object> extraParams, Object price, PriceData priceData, Long quantity, Object taxRates) {
                this.discounts = discounts;
                this.extraParams = extraParams;
                this.price = price;
                this.priceData = priceData;
                this.quantity = quantity;
                this.taxRates = taxRates;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public List<Discount> getDiscounts() {
                return this.discounts;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getPrice() {
                return this.price;
            }

            @Generated
            public PriceData getPriceData() {
                return this.priceData;
            }

            @Generated
            public Long getQuantity() {
                return this.quantity;
            }

            @Generated
            public Object getTaxRates() {
                return this.taxRates;
            }

            public static class PriceData {
                @SerializedName(value="currency")
                Object currency;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="product")
                Object product;
                @SerializedName(value="tax_behavior")
                TaxBehavior taxBehavior;
                @SerializedName(value="unit_amount")
                Long unitAmount;
                @SerializedName(value="unit_amount_decimal")
                Object unitAmountDecimal;

                private PriceData(Object currency, Map<String, Object> extraParams, Object product, TaxBehavior taxBehavior, Long unitAmount, Object unitAmountDecimal) {
                    this.currency = currency;
                    this.extraParams = extraParams;
                    this.product = product;
                    this.taxBehavior = taxBehavior;
                    this.unitAmount = unitAmount;
                    this.unitAmountDecimal = unitAmountDecimal;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Object getCurrency() {
                    return this.currency;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getProduct() {
                    return this.product;
                }

                @Generated
                public TaxBehavior getTaxBehavior() {
                    return this.taxBehavior;
                }

                @Generated
                public Long getUnitAmount() {
                    return this.unitAmount;
                }

                @Generated
                public Object getUnitAmountDecimal() {
                    return this.unitAmountDecimal;
                }

                public static enum TaxBehavior implements ApiRequestParams.EnumParam
                {
                    EXCLUSIVE("exclusive"),
                    INCLUSIVE("inclusive"),
                    UNSPECIFIED("unspecified");

                    private final String value;

                    private TaxBehavior(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Object currency;
                    private Map<String, Object> extraParams;
                    private Object product;
                    private TaxBehavior taxBehavior;
                    private Long unitAmount;
                    private Object unitAmountDecimal;

                    public PriceData build() {
                        return new PriceData(this.currency, this.extraParams, this.product, this.taxBehavior, this.unitAmount, this.unitAmountDecimal);
                    }

                    public Builder setCurrency(String currency) {
                        this.currency = currency;
                        return this;
                    }

                    public Builder setCurrency(EmptyParam currency) {
                        this.currency = currency;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setProduct(String product) {
                        this.product = product;
                        return this;
                    }

                    public Builder setProduct(EmptyParam product) {
                        this.product = product;
                        return this;
                    }

                    public Builder setTaxBehavior(TaxBehavior taxBehavior) {
                        this.taxBehavior = taxBehavior;
                        return this;
                    }

                    public Builder setUnitAmount(Long unitAmount) {
                        this.unitAmount = unitAmount;
                        return this;
                    }

                    public Builder setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
                        this.unitAmountDecimal = unitAmountDecimal;
                        return this;
                    }

                    public Builder setUnitAmountDecimal(EmptyParam unitAmountDecimal) {
                        this.unitAmountDecimal = unitAmountDecimal;
                        return this;
                    }
                }
            }

            public static class Builder {
                private List<Discount> discounts;
                private Map<String, Object> extraParams;
                private Object price;
                private PriceData priceData;
                private Long quantity;
                private Object taxRates;

                public AddInvoiceItem build() {
                    return new AddInvoiceItem(this.discounts, this.extraParams, this.price, this.priceData, this.quantity, this.taxRates);
                }

                public Builder addDiscount(Discount element) {
                    if (this.discounts == null) {
                        this.discounts = new ArrayList<Discount>();
                    }
                    this.discounts.add(element);
                    return this;
                }

                public Builder addAllDiscount(List<Discount> elements) {
                    if (this.discounts == null) {
                        this.discounts = new ArrayList<Discount>();
                    }
                    this.discounts.addAll(elements);
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPrice(String price) {
                    this.price = price;
                    return this;
                }

                public Builder setPrice(EmptyParam price) {
                    this.price = price;
                    return this;
                }

                public Builder setPriceData(PriceData priceData) {
                    this.priceData = priceData;
                    return this;
                }

                public Builder setQuantity(Long quantity) {
                    this.quantity = quantity;
                    return this;
                }

                public Builder addTaxRate(String element) {
                    if (this.taxRates == null || this.taxRates instanceof EmptyParam) {
                        this.taxRates = new ArrayList();
                    }
                    ((List)this.taxRates).add(element);
                    return this;
                }

                public Builder addAllTaxRate(List<String> elements) {
                    if (this.taxRates == null || this.taxRates instanceof EmptyParam) {
                        this.taxRates = new ArrayList();
                    }
                    ((List)this.taxRates).addAll(elements);
                    return this;
                }

                public Builder setTaxRates(EmptyParam taxRates) {
                    this.taxRates = taxRates;
                    return this;
                }

                public Builder setTaxRates(List<String> taxRates) {
                    this.taxRates = taxRates;
                    return this;
                }
            }

            public static class Discount {
                @SerializedName(value="coupon")
                Object coupon;
                @SerializedName(value="discount")
                Object discount;
                @SerializedName(value="discount_end")
                DiscountEnd discountEnd;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private Discount(Object coupon, Object discount, DiscountEnd discountEnd, Map<String, Object> extraParams) {
                    this.coupon = coupon;
                    this.discount = discount;
                    this.discountEnd = discountEnd;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Object getCoupon() {
                    return this.coupon;
                }

                @Generated
                public Object getDiscount() {
                    return this.discount;
                }

                @Generated
                public DiscountEnd getDiscountEnd() {
                    return this.discountEnd;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class DiscountEnd {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="timestamp")
                    Long timestamp;
                    @SerializedName(value="type")
                    Type type;

                    private DiscountEnd(Map<String, Object> extraParams, Long timestamp, Type type) {
                        this.extraParams = extraParams;
                        this.timestamp = timestamp;
                        this.type = type;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Long getTimestamp() {
                        return this.timestamp;
                    }

                    @Generated
                    public Type getType() {
                        return this.type;
                    }

                    public static enum Type implements ApiRequestParams.EnumParam
                    {
                        TIMESTAMP("timestamp");

                        private final String value;

                        private Type(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Long timestamp;
                        private Type type;

                        public DiscountEnd build() {
                            return new DiscountEnd(this.extraParams, this.timestamp, this.type);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setTimestamp(Long timestamp) {
                            this.timestamp = timestamp;
                            return this;
                        }

                        public Builder setType(Type type) {
                            this.type = type;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Object coupon;
                    private Object discount;
                    private DiscountEnd discountEnd;
                    private Map<String, Object> extraParams;

                    public Discount build() {
                        return new Discount(this.coupon, this.discount, this.discountEnd, this.extraParams);
                    }

                    public Builder setCoupon(String coupon) {
                        this.coupon = coupon;
                        return this;
                    }

                    public Builder setCoupon(EmptyParam coupon) {
                        this.coupon = coupon;
                        return this;
                    }

                    public Builder setDiscount(String discount) {
                        this.discount = discount;
                        return this;
                    }

                    public Builder setDiscount(EmptyParam discount) {
                        this.discount = discount;
                        return this;
                    }

                    public Builder setDiscountEnd(DiscountEnd discountEnd) {
                        this.discountEnd = discountEnd;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }
        }
    }
}

