// Generated by delombok at Thu Aug 11 22:35:45 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.OrderCancelParams;
import com.stripe.param.OrderCreateParams;
import com.stripe.param.OrderListLineItemsParams;
import com.stripe.param.OrderListParams;
import com.stripe.param.OrderReopenParams;
import com.stripe.param.OrderRetrieveParams;
import com.stripe.param.OrderSubmitParams;
import com.stripe.param.OrderUpdateParams;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Order extends ApiResource implements HasId, MetadataStore<Order> {
  /**
   * Order cost before any discounts or taxes are applied. A positive integer representing the
   * subtotal of the order in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest
   * currency unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal
   * currency).
   */
  @SerializedName("amount_subtotal")
  Long amountSubtotal;
  /**
   * Total order cost after discounts and taxes are applied. A positive integer representing the
   * cost of the order in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest
   * currency unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal
   * currency). To submit an order, the total must be either 0 or at least $0.50 USD or <a
   * href="https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts">equivalent in
   * charge currency</a>.
   */
  @SerializedName("amount_total")
  Long amountTotal;
  /**
   * ID of the Connect application that created the Order, if any.
   */
  @SerializedName("application")
  ExpandableField<Application> application;
  @SerializedName("automatic_tax")
  AutomaticTax automaticTax;
  /**
   * Customer billing details associated with the order.
   */
  @SerializedName("billing_details")
  BillingDetails billingDetails;
  /**
   * The client secret of this Order. Used for client-side retrieval using a publishable key.
   *
   * <p>The client secret can be used to complete a payment for an Order from your frontend. It
   * should not be stored, logged, embedded in URLs, or exposed to anyone other than the customer.
   * Make sure that you have TLS enabled on any page that includes the client secret.
   *
   * <p>Refer to our docs for <a
   * href="https://stripe.com/docs/orders-beta/create-and-process">creating and processing an
   * order</a> to learn about how client_secret should be handled.
   */
  @SerializedName("client_secret")
  String clientSecret;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * The customer which this orders belongs to.
   */
  @SerializedName("customer")
  ExpandableField<Customer> customer;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @SerializedName("description")
  String description;
  /**
   * The discounts applied to the order. Use {@code expand[]=discounts} to expand each discount.
   */
  @SerializedName("discounts")
  List<ExpandableField<Discount>> discounts;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * A recent IP address of the purchaser used for tax reporting and tax location inference.
   */
  @SerializedName("ip_address")
  String ipAddress;
  /**
   * A list of line items the customer is ordering. Each line item includes information about the
   * product, the quantity, and the resulting cost. There is a maximum of 100 line items.
   */
  @SerializedName("line_items")
  LineItemCollection lineItems;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code order}.
   */
  @SerializedName("object")
  String object;
  @SerializedName("payment")
  Payment payment;
  /**
   * The details of the customer cost of shipping, including the customer chosen ShippingRate.
   */
  @SerializedName("shipping_cost")
  ShippingCost shippingCost;
  /**
   * Customer shipping information associated with the order.
   */
  @SerializedName("shipping_details")
  ShippingDetails shippingDetails;
  /**
   * The overall status of the order.
   *
   * <p>One of {@code canceled}, {@code complete}, {@code open}, {@code processing}, or {@code
   * submitted}.
   */
  @SerializedName("status")
  String status;
  @SerializedName("tax_details")
  TaxDetails taxDetails;
  @SerializedName("total_details")
  TotalDetails totalDetails;

  /**
   * Get ID of expandable {@code application} object.
   */
  public String getApplication() {
    return (this.application != null) ? this.application.getId() : null;
  }

  public void setApplication(String id) {
    this.application = ApiResource.setExpandableFieldId(id, this.application);
  }

  /**
   * Get expanded {@code application}.
   */
  public Application getApplicationObject() {
    return (this.application != null) ? this.application.getExpanded() : null;
  }

  public void setApplicationObject(Application expandableObject) {
    this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get ID of expandable {@code customer} object.
   */
  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String id) {
    this.customer = ApiResource.setExpandableFieldId(id, this.customer);
  }

  /**
   * Get expanded {@code customer}.
   */
  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer expandableObject) {
    this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
  }

  /**
   * Get IDs of expandable {@code discounts} object list.
   */
  public List<String> getDiscounts() {
    return (this.discounts != null) ? this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
  }

  public void setDiscounts(List<String> ids) {
    if (ids == null) {
      this.discounts = null;
      return;
    }
    if (this.discounts != null && this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
      // noop if the ids are equal to what are already present
      return;
    }
    this.discounts = (ids != null) ? ids.stream().map(id -> new ExpandableField<Discount>(id, null)).collect(Collectors.toList()) : null;
  }

  /**
   * Get expanded {@code discounts}.
   */
  public List<Discount> getDiscountObjects() {
    return (this.discounts != null) ? this.discounts.stream().map(x -> x.getExpanded()).collect(Collectors.toList()) : null;
  }

  public void setDiscountObjects(List<Discount> objs) {
    this.discounts = objs != null ? objs.stream().map(x -> new ExpandableField<Discount>(x.getId(), x)).collect(Collectors.toList()) : null;
  }

  /**
   * Creates a new <code>open</code> order object.
   */
  public static Order create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new <code>open</code> order object.
   */
  public static Order create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/orders");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Order.class, options);
  }

  /**
   * Creates a new <code>open</code> order object.
   */
  public static Order create(OrderCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a new <code>open</code> order object.
   */
  public static Order create(OrderCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/orders");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Order.class, options);
  }

  /**
   * Returns a list of your orders. The orders are returned sorted by creation date, with the most
   * recently created orders appearing first.
   */
  public static OrderCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your orders. The orders are returned sorted by creation date, with the most
   * recently created orders appearing first.
   */
  public static OrderCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/orders");
    return ApiResource.requestCollection(url, params, OrderCollection.class, options);
  }

  /**
   * Returns a list of your orders. The orders are returned sorted by creation date, with the most
   * recently created orders appearing first.
   */
  public static OrderCollection list(OrderListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your orders. The orders are returned sorted by creation date, with the most
   * recently created orders appearing first.
   */
  public static OrderCollection list(OrderListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/orders");
    return ApiResource.requestCollection(url, params, OrderCollection.class, options);
  }

  /**
   * Retrieves the details of an existing order. Supply the unique order ID from either an order
   * creation request or the order list, and Stripe will return the corresponding order information.
   */
  public static Order retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an existing order. Supply the unique order ID from either an order
   * creation request or the order list, and Stripe will return the corresponding order information.
   */
  public static Order retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an existing order. Supply the unique order ID from either an order
   * creation request or the order list, and Stripe will return the corresponding order information.
   */
  public static Order retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Order.class, options);
  }

  /**
   * Retrieves the details of an existing order. Supply the unique order ID from either an order
   * creation request or the order list, and Stripe will return the corresponding order information.
   */
  public static Order retrieve(String id, OrderRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Order.class, options);
  }

  /**
   * Updates the specific order by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   */
  @Override
  public Order update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specific order by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   */
  @Override
  public Order update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Order.class, options);
  }

  /**
   * Updates the specific order by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   */
  public Order update(OrderUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates the specific order by setting the values of the parameters passed. Any parameters not
   * provided will be left unchanged.
   */
  public Order update(OrderUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Order.class, options);
  }

  /**
   * Submitting an Order transitions the status to <code>processing</code> and creates a
   * PaymentIntent object so the order can be paid. If the Order has an <code>amount_total</code> of
   * 0, no PaymentIntent object will be created. Once the order is submitted, its contents cannot be
   * changed, unless the <a href="https://stripe.com/docs/api#reopen_order">reopen</a> method is
   * called.
   */
  public Order submit(Map<String, Object> params) throws StripeException {
    return submit(params, (RequestOptions) null);
  }

  /**
   * Submitting an Order transitions the status to <code>processing</code> and creates a
   * PaymentIntent object so the order can be paid. If the Order has an <code>amount_total</code> of
   * 0, no PaymentIntent object will be created. Once the order is submitted, its contents cannot be
   * changed, unless the <a href="https://stripe.com/docs/api#reopen_order">reopen</a> method is
   * called.
   */
  public Order submit(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s/submit", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Order.class, options);
  }

  /**
   * Submitting an Order transitions the status to <code>processing</code> and creates a
   * PaymentIntent object so the order can be paid. If the Order has an <code>amount_total</code> of
   * 0, no PaymentIntent object will be created. Once the order is submitted, its contents cannot be
   * changed, unless the <a href="https://stripe.com/docs/api#reopen_order">reopen</a> method is
   * called.
   */
  public Order submit(OrderSubmitParams params) throws StripeException {
    return submit(params, (RequestOptions) null);
  }

  /**
   * Submitting an Order transitions the status to <code>processing</code> and creates a
   * PaymentIntent object so the order can be paid. If the Order has an <code>amount_total</code> of
   * 0, no PaymentIntent object will be created. Once the order is submitted, its contents cannot be
   * changed, unless the <a href="https://stripe.com/docs/api#reopen_order">reopen</a> method is
   * called.
   */
  public Order submit(OrderSubmitParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s/submit", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Order.class, options);
  }

  /**
   * Cancels the order as well as the payment intent if one is attached.
   */
  public Order cancel() throws StripeException {
    return cancel((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Cancels the order as well as the payment intent if one is attached.
   */
  public Order cancel(RequestOptions options) throws StripeException {
    return cancel((Map<String, Object>) null, options);
  }

  /**
   * Cancels the order as well as the payment intent if one is attached.
   */
  public Order cancel(Map<String, Object> params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * Cancels the order as well as the payment intent if one is attached.
   */
  public Order cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Order.class, options);
  }

  /**
   * Cancels the order as well as the payment intent if one is attached.
   */
  public Order cancel(OrderCancelParams params) throws StripeException {
    return cancel(params, (RequestOptions) null);
  }

  /**
   * Cancels the order as well as the payment intent if one is attached.
   */
  public Order cancel(OrderCancelParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s/cancel", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Order.class, options);
  }

  /**
   * Reopens a <code>submitted</code> order.
   */
  public Order reopen() throws StripeException {
    return reopen((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Reopens a <code>submitted</code> order.
   */
  public Order reopen(RequestOptions options) throws StripeException {
    return reopen((Map<String, Object>) null, options);
  }

  /**
   * Reopens a <code>submitted</code> order.
   */
  public Order reopen(Map<String, Object> params) throws StripeException {
    return reopen(params, (RequestOptions) null);
  }

  /**
   * Reopens a <code>submitted</code> order.
   */
  public Order reopen(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s/reopen", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Order.class, options);
  }

  /**
   * Reopens a <code>submitted</code> order.
   */
  public Order reopen(OrderReopenParams params) throws StripeException {
    return reopen(params, (RequestOptions) null);
  }

  /**
   * Reopens a <code>submitted</code> order.
   */
  public Order reopen(OrderReopenParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s/reopen", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Order.class, options);
  }

  /**
   * When retrieving an order, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems() throws StripeException {
    return listLineItems((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * When retrieving an order, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems(Map<String, Object> params) throws StripeException {
    return listLineItems(params, (RequestOptions) null);
  }

  /**
   * When retrieving an order, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s/line_items", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
  }

  /**
   * When retrieving an order, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems(OrderListLineItemsParams params) throws StripeException {
    return listLineItems(params, (RequestOptions) null);
  }

  /**
   * When retrieving an order, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems(OrderListLineItemsParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/orders/%s/line_items", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
  }


  public static class AutomaticTax extends StripeObject {
    /**
     * Whether Stripe automatically computes tax on this Order.
     */
    @SerializedName("enabled")
    Boolean enabled;
    /**
     * The status of the most recent automated tax calculation for this Order.
     *
     * <p>One of {@code complete}, {@code failed}, or {@code requires_location_inputs}.
     */
    @SerializedName("status")
    String status;

    /**
     * Whether Stripe automatically computes tax on this Order.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getEnabled() {
      return this.enabled;
    }

    /**
     * The status of the most recent automated tax calculation for this Order.
     *
     * <p>One of {@code complete}, {@code failed}, or {@code requires_location_inputs}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    /**
     * Whether Stripe automatically computes tax on this Order.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEnabled(final Boolean enabled) {
      this.enabled = enabled;
    }

    /**
     * The status of the most recent automated tax calculation for this Order.
     *
     * <p>One of {@code complete}, {@code failed}, or {@code requires_location_inputs}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Order.AutomaticTax)) return false;
      final Order.AutomaticTax other = (Order.AutomaticTax) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$enabled = this.getEnabled();
      final java.lang.Object other$enabled = other.getEnabled();
      if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Order.AutomaticTax;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $enabled = this.getEnabled();
      result = result * PRIME + ($enabled == null ? 43 : $enabled.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      return result;
    }
  }


  public static class BillingDetails extends StripeObject {
    /**
     * Billing address for the order.
     */
    @SerializedName("address")
    Address address;
    /**
     * Email address for the order.
     */
    @SerializedName("email")
    String email;
    /**
     * Full name for the order.
     */
    @SerializedName("name")
    String name;
    /**
     * Billing phone number for the order (including extension).
     */
    @SerializedName("phone")
    String phone;

    /**
     * Billing address for the order.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Address getAddress() {
      return this.address;
    }

    /**
     * Email address for the order.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEmail() {
      return this.email;
    }

    /**
     * Full name for the order.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    /**
     * Billing phone number for the order (including extension).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPhone() {
      return this.phone;
    }

    /**
     * Billing address for the order.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddress(final Address address) {
      this.address = address;
    }

    /**
     * Email address for the order.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEmail(final String email) {
      this.email = email;
    }

    /**
     * Full name for the order.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
      this.name = name;
    }

    /**
     * Billing phone number for the order (including extension).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPhone(final String phone) {
      this.phone = phone;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Order.BillingDetails)) return false;
      final Order.BillingDetails other = (Order.BillingDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$address = this.getAddress();
      final java.lang.Object other$address = other.getAddress();
      if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
      final java.lang.Object this$email = this.getEmail();
      final java.lang.Object other$email = other.getEmail();
      if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
      final java.lang.Object this$name = this.getName();
      final java.lang.Object other$name = other.getName();
      if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
      final java.lang.Object this$phone = this.getPhone();
      final java.lang.Object other$phone = other.getPhone();
      if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Order.BillingDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $address = this.getAddress();
      result = result * PRIME + ($address == null ? 43 : $address.hashCode());
      final java.lang.Object $email = this.getEmail();
      result = result * PRIME + ($email == null ? 43 : $email.hashCode());
      final java.lang.Object $name = this.getName();
      result = result * PRIME + ($name == null ? 43 : $name.hashCode());
      final java.lang.Object $phone = this.getPhone();
      result = result * PRIME + ($phone == null ? 43 : $phone.hashCode());
      return result;
    }
  }


  public static class Payment extends StripeObject {
    /**
     * ID of the payment intent associated with this order. Null when the order is {@code open}.
     */
    @SerializedName("payment_intent")
    ExpandableField<PaymentIntent> paymentIntent;
    /**
     * Settings describing how the order should configure generated PaymentIntents.
     */
    @SerializedName("settings")
    Settings settings;
    /**
     * The status of the underlying payment associated with this order, if any. Null when the order
     * is {@code open}.
     *
     * <p>One of {@code canceled}, {@code complete}, {@code not_required}, {@code processing},
     * {@code requires_action}, {@code requires_capture}, {@code requires_confirmation}, or {@code
     * requires_payment_method}.
     */
    @SerializedName("status")
    String status;

    /**
     * Get ID of expandable {@code paymentIntent} object.
     */
    public String getPaymentIntent() {
      return (this.paymentIntent != null) ? this.paymentIntent.getId() : null;
    }

    public void setPaymentIntent(String id) {
      this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
    }

    /**
     * Get expanded {@code paymentIntent}.
     */
    public PaymentIntent getPaymentIntentObject() {
      return (this.paymentIntent != null) ? this.paymentIntent.getExpanded() : null;
    }

    public void setPaymentIntentObject(PaymentIntent expandableObject) {
      this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
    }


    public static class Settings extends StripeObject {
      /**
       * The amount of the application fee (if any) that will be requested to be applied to the
       * payment and transferred to the application owner's Stripe account.
       */
      @SerializedName("application_fee_amount")
      Long applicationFeeAmount;
      /**
       * Indicates whether order has been opted into using <a
       * href="https://dashboard.stripe.com/settings/payment_methods">Stripe Dashboard</a> to manage
       * payment method types.
       */
      @SerializedName("automatic_payment_methods")
      AutomaticPaymentMethods automaticPaymentMethods;
      /** PaymentMethod-specific configuration to provide to the order's PaymentIntent. */
      @SerializedName("payment_method_options")
      PaymentMethodOptions paymentMethodOptions;
      /**
       * The list of <a href="https://stripe.com/docs/payments/payment-methods/overview">payment
       * method types</a> to provide to the order's PaymentIntent. Do not include this attribute if
       * you prefer to manage your payment methods from the <a
       * href="https://dashboard.stripe.com/settings/payment_methods">Stripe Dashboard</a>.
       */
      @SerializedName("payment_method_types")
      List<String> paymentMethodTypes;
      /** The URL to redirect the customer to after they authenticate their payment. */
      @SerializedName("return_url")
      String returnUrl;
      /**
       * For non-card charges, you can use this value as the complete description that appears on
       * your customers' statements. Must contain at least one letter, maximum 22 characters.
       */
      @SerializedName("statement_descriptor")
      String statementDescriptor;
      /**
       * Provides information about a card payment that customers see on their statements.
       * Concatenated with the prefix (shortened descriptor) or statement descriptor that’s set on
       * the account to form the complete statement descriptor. Maximum 22 characters for the
       * concatenated descriptor.
       */
      @SerializedName("statement_descriptor_suffix")
      String statementDescriptorSuffix;
      /** Provides configuration for completing a transfer for the order after it is paid. */
      @SerializedName("transfer_data")
      TransferData transferData;


      public static class AutomaticPaymentMethods extends StripeObject {
        /**
         * Whether this Order has been opted into managing payment method types via the <a
         * href="https://dashboard.stripe.com/settings/payment_methods">Stripe Dashboard</a>.
         */
        @SerializedName("enabled")
        Boolean enabled;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Boolean getEnabled() {
          return this.enabled;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setEnabled(final Boolean enabled) {
          this.enabled = enabled;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Order.Payment.Settings.AutomaticPaymentMethods)) return false;
          final Order.Payment.Settings.AutomaticPaymentMethods other = (Order.Payment.Settings.AutomaticPaymentMethods) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$enabled = this.getEnabled();
          final java.lang.Object other$enabled = other.getEnabled();
          if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Order.Payment.Settings.AutomaticPaymentMethods;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $enabled = this.getEnabled();
          result = result * PRIME + ($enabled == null ? 43 : $enabled.hashCode());
          return result;
        }
      }


      public static class PaymentMethodOptions extends StripeObject {
        @SerializedName("acss_debit")
        AcssDebit acssDebit;
        @SerializedName("afterpay_clearpay")
        AfterpayClearpay afterpayClearpay;
        @SerializedName("alipay")
        Alipay alipay;
        @SerializedName("bancontact")
        Bancontact bancontact;
        @SerializedName("card")
        Card card;
        @SerializedName("customer_balance")
        CustomerBalance customerBalance;
        @SerializedName("ideal")
        Ideal ideal;
        @SerializedName("klarna")
        Klarna klarna;
        @SerializedName("link")
        Link link;
        @SerializedName("oxxo")
        Oxxo oxxo;
        @SerializedName("p24")
        P24 p24;
        @SerializedName("paypal")
        Paypal paypal;
        @SerializedName("sepa_debit")
        SepaDebit sepaDebit;
        @SerializedName("sofort")
        Sofort sofort;
        @SerializedName("wechat_pay")
        WechatPay wechatPay;


        public static class AcssDebit extends StripeObject {
          @SerializedName("mandate_options")
          MandateOptions mandateOptions;
          /**
           * Indicates that you intend to make future payments with this PaymentIntent's payment
           * method.
           *
           * <p>Providing this parameter will <a
           * href="https://stripe.com/docs/payments/save-during-payment">attach the payment
           * method</a> to the PaymentIntent's Customer, if present, after the PaymentIntent is
           * confirmed and any required actions from the user are complete. If no Customer was
           * provided, the payment method can still be <a
           * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
           * after the transaction completes.
           *
           * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
           * dynamically optimize your payment flow and comply with regional legislation and network
           * rules, such as <a
           * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
           *
           * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
           */
          @SerializedName("setup_future_usage")
          String setupFutureUsage;
          /**
           * Bank account verification method.
           *
           * <p>One of {@code automatic}, {@code instant}, or {@code microdeposits}.
           */
          @SerializedName("verification_method")
          String verificationMethod;


          public static class MandateOptions extends StripeObject {
            /** A URL for custom mandate text. */
            @SerializedName("custom_mandate_url")
            String customMandateUrl;
            /**
             * Description of the interval. Only required if the 'payment_schedule' parameter is
             * 'interval' or 'combined'.
             */
            @SerializedName("interval_description")
            String intervalDescription;
            /**
             * Payment schedule for the mandate.
             *
             * <p>One of {@code combined}, {@code interval}, or {@code sporadic}.
             */
            @SerializedName("payment_schedule")
            String paymentSchedule;
            /**
             * Transaction type of the mandate.
             *
             * <p>One of {@code business}, or {@code personal}.
             */
            @SerializedName("transaction_type")
            String transactionType;

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public String getCustomMandateUrl() {
              return this.customMandateUrl;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public String getIntervalDescription() {
              return this.intervalDescription;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public String getPaymentSchedule() {
              return this.paymentSchedule;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public String getTransactionType() {
              return this.transactionType;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public void setCustomMandateUrl(final String customMandateUrl) {
              this.customMandateUrl = customMandateUrl;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public void setIntervalDescription(final String intervalDescription) {
              this.intervalDescription = intervalDescription;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public void setPaymentSchedule(final String paymentSchedule) {
              this.paymentSchedule = paymentSchedule;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public void setTransactionType(final String transactionType) {
              this.transactionType = transactionType;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public boolean equals(final java.lang.Object o) {
              if (o == this) return true;
              if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.AcssDebit.MandateOptions)) return false;
              final Order.Payment.Settings.PaymentMethodOptions.AcssDebit.MandateOptions other = (Order.Payment.Settings.PaymentMethodOptions.AcssDebit.MandateOptions) o;
              if (!other.canEqual((java.lang.Object) this)) return false;
              final java.lang.Object this$customMandateUrl = this.getCustomMandateUrl();
              final java.lang.Object other$customMandateUrl = other.getCustomMandateUrl();
              if (this$customMandateUrl == null ? other$customMandateUrl != null : !this$customMandateUrl.equals(other$customMandateUrl)) return false;
              final java.lang.Object this$intervalDescription = this.getIntervalDescription();
              final java.lang.Object other$intervalDescription = other.getIntervalDescription();
              if (this$intervalDescription == null ? other$intervalDescription != null : !this$intervalDescription.equals(other$intervalDescription)) return false;
              final java.lang.Object this$paymentSchedule = this.getPaymentSchedule();
              final java.lang.Object other$paymentSchedule = other.getPaymentSchedule();
              if (this$paymentSchedule == null ? other$paymentSchedule != null : !this$paymentSchedule.equals(other$paymentSchedule)) return false;
              final java.lang.Object this$transactionType = this.getTransactionType();
              final java.lang.Object other$transactionType = other.getTransactionType();
              if (this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType)) return false;
              return true;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected boolean canEqual(final java.lang.Object other) {
              return other instanceof Order.Payment.Settings.PaymentMethodOptions.AcssDebit.MandateOptions;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public int hashCode() {
              final int PRIME = 59;
              int result = 1;
              final java.lang.Object $customMandateUrl = this.getCustomMandateUrl();
              result = result * PRIME + ($customMandateUrl == null ? 43 : $customMandateUrl.hashCode());
              final java.lang.Object $intervalDescription = this.getIntervalDescription();
              result = result * PRIME + ($intervalDescription == null ? 43 : $intervalDescription.hashCode());
              final java.lang.Object $paymentSchedule = this.getPaymentSchedule();
              result = result * PRIME + ($paymentSchedule == null ? 43 : $paymentSchedule.hashCode());
              final java.lang.Object $transactionType = this.getTransactionType();
              result = result * PRIME + ($transactionType == null ? 43 : $transactionType.hashCode());
              return result;
            }
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public MandateOptions getMandateOptions() {
            return this.mandateOptions;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getSetupFutureUsage() {
            return this.setupFutureUsage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getVerificationMethod() {
            return this.verificationMethod;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setMandateOptions(final MandateOptions mandateOptions) {
            this.mandateOptions = mandateOptions;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setSetupFutureUsage(final String setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setVerificationMethod(final String verificationMethod) {
            this.verificationMethod = verificationMethod;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.AcssDebit)) return false;
            final Order.Payment.Settings.PaymentMethodOptions.AcssDebit other = (Order.Payment.Settings.PaymentMethodOptions.AcssDebit) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$mandateOptions = this.getMandateOptions();
            final java.lang.Object other$mandateOptions = other.getMandateOptions();
            if (this$mandateOptions == null ? other$mandateOptions != null : !this$mandateOptions.equals(other$mandateOptions)) return false;
            final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
            final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
            if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
            final java.lang.Object this$verificationMethod = this.getVerificationMethod();
            final java.lang.Object other$verificationMethod = other.getVerificationMethod();
            if (this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Order.Payment.Settings.PaymentMethodOptions.AcssDebit;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $mandateOptions = this.getMandateOptions();
            result = result * PRIME + ($mandateOptions == null ? 43 : $mandateOptions.hashCode());
            final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
            result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
            final java.lang.Object $verificationMethod = this.getVerificationMethod();
            result = result * PRIME + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
            return result;
          }
        }


        public static class AfterpayClearpay extends StripeObject {
          /**
           * Controls when the funds will be captured from the customer's account.
           *
           * <p>One of {@code automatic}, or {@code manual}.
           */
          @SerializedName("capture_method")
          String captureMethod;
          /**
           * Order identifier shown to the user in Afterpay's online portal. We recommend using a
           * value that helps you answer any questions a customer might have about the payment. The
           * identifier is limited to 128 characters and may contain only letters, digits,
           * underscores, backslashes and dashes.
           */
          @SerializedName("reference")
          String reference;
          /**
           * Indicates that you intend to make future payments with the payment method.
           *
           * <p>Providing this parameter will <a
           * href="https://stripe.com/docs/payments/save-during-payment">attach the payment
           * method</a> to the order's Customer, if present, after the order's PaymentIntent is
           * confirmed and any required actions from the user are complete. If no Customer was
           * provided, the payment method can still be <a
           * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
           * after the transaction completes.
           *
           * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
           * dynamically optimize your payment flow and comply with regional legislation and network
           * rules, such as <a
           * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
           *
           * <p>If {@code setup_future_usage} is already set and you are performing a request using
           * a publishable key, you may only update the value from {@code on_session} to {@code
           * off_session}.
           *
           * <p>Equal to {@code none}.
           */
          @SerializedName("setup_future_usage")
          String setupFutureUsage;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getCaptureMethod() {
            return this.captureMethod;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getReference() {
            return this.reference;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getSetupFutureUsage() {
            return this.setupFutureUsage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setCaptureMethod(final String captureMethod) {
            this.captureMethod = captureMethod;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setReference(final String reference) {
            this.reference = reference;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setSetupFutureUsage(final String setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.AfterpayClearpay)) return false;
            final Order.Payment.Settings.PaymentMethodOptions.AfterpayClearpay other = (Order.Payment.Settings.PaymentMethodOptions.AfterpayClearpay) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$captureMethod = this.getCaptureMethod();
            final java.lang.Object other$captureMethod = other.getCaptureMethod();
            if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) return false;
            final java.lang.Object this$reference = this.getReference();
            final java.lang.Object other$reference = other.getReference();
            if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) return false;
            final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
            final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
            if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Order.Payment.Settings.PaymentMethodOptions.AfterpayClearpay;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $captureMethod = this.getCaptureMethod();
            result = result * PRIME + ($captureMethod == null ? 43 : $captureMethod.hashCode());
            final java.lang.Object $reference = this.getReference();
            result = result * PRIME + ($reference == null ? 43 : $reference.hashCode());
            final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
            result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
            return result;
          }
        }


        public static class Alipay extends StripeObject {
          /**
           * Indicates that you intend to make future payments with this PaymentIntent's payment
           * method.
           *
           * <p>Providing this parameter will <a
           * href="https://stripe.com/docs/payments/save-during-payment">attach the payment
           * method</a> to the PaymentIntent's Customer, if present, after the PaymentIntent is
           * confirmed and any required actions from the user are complete. If no Customer was
           * provided, the payment method can still be <a
           * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
           * after the transaction completes.
           *
           * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
           * dynamically optimize your payment flow and comply with regional legislation and network
           * rules, such as <a
           * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
           *
           * <p>One of {@code none}, or {@code off_session}.
           */
          @SerializedName("setup_future_usage")
          String setupFutureUsage;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getSetupFutureUsage() {
            return this.setupFutureUsage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setSetupFutureUsage(final String setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.Alipay)) return false;
            final Order.Payment.Settings.PaymentMethodOptions.Alipay other = (Order.Payment.Settings.PaymentMethodOptions.Alipay) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
            final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
            if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Order.Payment.Settings.PaymentMethodOptions.Alipay;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
            result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
            return result;
          }
        }


        public static class Bancontact extends StripeObject {
          /**
           * Preferred language of the Bancontact authorization page that the customer is redirected
           * to.
           *
           * <p>One of {@code de}, {@code en}, {@code fr}, or {@code nl}.
           */
          @SerializedName("preferred_language")
          String preferredLanguage;
          /**
           * Indicates that you intend to make future payments with this PaymentIntent's payment
           * method.
           *
           * <p>Providing this parameter will <a
           * href="https://stripe.com/docs/payments/save-during-payment">attach the payment
           * method</a> to the PaymentIntent's Customer, if present, after the PaymentIntent is
           * confirmed and any required actions from the user are complete. If no Customer was
           * provided, the payment method can still be <a
           * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
           * after the transaction completes.
           *
           * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
           * dynamically optimize your payment flow and comply with regional legislation and network
           * rules, such as <a
           * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
           *
           * <p>One of {@code none}, or {@code off_session}.
           */
          @SerializedName("setup_future_usage")
          String setupFutureUsage;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getPreferredLanguage() {
            return this.preferredLanguage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getSetupFutureUsage() {
            return this.setupFutureUsage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setPreferredLanguage(final String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setSetupFutureUsage(final String setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.Bancontact)) return false;
            final Order.Payment.Settings.PaymentMethodOptions.Bancontact other = (Order.Payment.Settings.PaymentMethodOptions.Bancontact) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$preferredLanguage = this.getPreferredLanguage();
            final java.lang.Object other$preferredLanguage = other.getPreferredLanguage();
            if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) return false;
            final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
            final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
            if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Order.Payment.Settings.PaymentMethodOptions.Bancontact;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $preferredLanguage = this.getPreferredLanguage();
            result = result * PRIME + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
            final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
            result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
            return result;
          }
        }


        public static class Card extends StripeObject {
          /**
           * Controls when the funds will be captured from the customer's account.
           *
           * <p>One of {@code automatic}, or {@code manual}.
           */
          @SerializedName("capture_method")
          String captureMethod;
          /**
           * Indicates that you intend to make future payments with the payment method.
           *
           * <p>Providing this parameter will <a
           * href="https://stripe.com/docs/payments/save-during-payment">attach the payment
           * method</a> to the order's Customer, if present, after the order's PaymentIntent is
           * confirmed and any required actions from the user are complete. If no Customer was
           * provided, the payment method can still be <a
           * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
           * after the transaction completes.
           *
           * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
           * dynamically optimize your payment flow and comply with regional legislation and network
           * rules, such as <a
           * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
           *
           * <p>If {@code setup_future_usage} is already set and you are performing a request using
           * a publishable key, you may only update the value from {@code on_session} to {@code
           * off_session}.
           *
           * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
           */
          @SerializedName("setup_future_usage")
          String setupFutureUsage;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getCaptureMethod() {
            return this.captureMethod;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getSetupFutureUsage() {
            return this.setupFutureUsage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setCaptureMethod(final String captureMethod) {
            this.captureMethod = captureMethod;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setSetupFutureUsage(final String setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.Card)) return false;
            final Order.Payment.Settings.PaymentMethodOptions.Card other = (Order.Payment.Settings.PaymentMethodOptions.Card) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$captureMethod = this.getCaptureMethod();
            final java.lang.Object other$captureMethod = other.getCaptureMethod();
            if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) return false;
            final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
            final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
            if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Order.Payment.Settings.PaymentMethodOptions.Card;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $captureMethod = this.getCaptureMethod();
            result = result * PRIME + ($captureMethod == null ? 43 : $captureMethod.hashCode());
            final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
            result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
            return result;
          }
        }


        public static class CustomerBalance extends StripeObject {
          @SerializedName("bank_transfer")
          BankTransfer bankTransfer;
          /**
           * The funding method type to be used when there are not enough funds in the customer
           * balance. Permitted values include: {@code bank_transfer}.
           *
           * <p>Equal to {@code bank_transfer}.
           */
          @SerializedName("funding_type")
          String fundingType;
          /**
           * Indicates that you intend to make future payments with this PaymentIntent's payment
           * method.
           *
           * <p>Providing this parameter will <a
           * href="https://stripe.com/docs/payments/save-during-payment">attach the payment
           * method</a> to the PaymentIntent's Customer, if present, after the PaymentIntent is
           * confirmed and any required actions from the user are complete. If no Customer was
           * provided, the payment method can still be <a
           * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
           * after the transaction completes.
           *
           * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
           * dynamically optimize your payment flow and comply with regional legislation and network
           * rules, such as <a
           * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
           *
           * <p>Equal to {@code none}.
           */
          @SerializedName("setup_future_usage")
          String setupFutureUsage;


          public static class BankTransfer extends StripeObject {
            @SerializedName("eu_bank_transfer")
            PaymentIntent.PaymentMethodOptions.BankTransfer.EuBankTransfer euBankTransfer;
            /**
             * List of address types that should be returned in the financial_addresses response. If
             * not specified, all valid types will be returned.
             *
             * <p>Permitted values include: {@code sort_code}, {@code zengin}, {@code iban}, or
             * {@code spei}.
             */
            @SerializedName("requested_address_types")
            List<String> requestedAddressTypes;
            /**
             * The bank transfer type that this PaymentIntent is allowed to use for funding
             * Permitted values include: {@code eu_bank_transfer}, {@code gb_bank_transfer}, {@code
             * jp_bank_transfer}, or {@code mx_bank_transfer}.
             *
             * <p>One of {@code eu_bank_transfer}, {@code gb_bank_transfer}, {@code
             * jp_bank_transfer}, or {@code mx_bank_transfer}.
             */
            @SerializedName("type")
            String type;


            public static class EuBankTransfer extends StripeObject {
              /**
               * The desired country code of the bank account information. Permitted values include:
               * {@code DE}, {@code ES}, {@code FR}, {@code IE}, or {@code NL}.
               *
               * <p>One of {@code DE}, {@code ES}, {@code FR}, {@code IE}, or {@code NL}.
               */
              @SerializedName("country")
              String country;

              @java.lang.SuppressWarnings("all")
              @lombok.Generated
              public String getCountry() {
                return this.country;
              }

              @java.lang.SuppressWarnings("all")
              @lombok.Generated
              public void setCountry(final String country) {
                this.country = country;
              }

              @java.lang.Override
              @java.lang.SuppressWarnings("all")
              @lombok.Generated
              public boolean equals(final java.lang.Object o) {
                if (o == this) return true;
                if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.CustomerBalance.BankTransfer.EuBankTransfer)) return false;
                final Order.Payment.Settings.PaymentMethodOptions.CustomerBalance.BankTransfer.EuBankTransfer other = (Order.Payment.Settings.PaymentMethodOptions.CustomerBalance.BankTransfer.EuBankTransfer) o;
                if (!other.canEqual((java.lang.Object) this)) return false;
                final java.lang.Object this$country = this.getCountry();
                final java.lang.Object other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
                return true;
              }

              @java.lang.SuppressWarnings("all")
              @lombok.Generated
              protected boolean canEqual(final java.lang.Object other) {
                return other instanceof Order.Payment.Settings.PaymentMethodOptions.CustomerBalance.BankTransfer.EuBankTransfer;
              }

              @java.lang.Override
              @java.lang.SuppressWarnings("all")
              @lombok.Generated
              public int hashCode() {
                final int PRIME = 59;
                int result = 1;
                final java.lang.Object $country = this.getCountry();
                result = result * PRIME + ($country == null ? 43 : $country.hashCode());
                return result;
              }
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public PaymentIntent.PaymentMethodOptions.BankTransfer.EuBankTransfer getEuBankTransfer() {
              return this.euBankTransfer;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public List<String> getRequestedAddressTypes() {
              return this.requestedAddressTypes;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public String getType() {
              return this.type;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public void setEuBankTransfer(final PaymentIntent.PaymentMethodOptions.BankTransfer.EuBankTransfer euBankTransfer) {
              this.euBankTransfer = euBankTransfer;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public void setRequestedAddressTypes(final List<String> requestedAddressTypes) {
              this.requestedAddressTypes = requestedAddressTypes;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public void setType(final String type) {
              this.type = type;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public boolean equals(final java.lang.Object o) {
              if (o == this) return true;
              if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.CustomerBalance.BankTransfer)) return false;
              final Order.Payment.Settings.PaymentMethodOptions.CustomerBalance.BankTransfer other = (Order.Payment.Settings.PaymentMethodOptions.CustomerBalance.BankTransfer) o;
              if (!other.canEqual((java.lang.Object) this)) return false;
              final java.lang.Object this$euBankTransfer = this.getEuBankTransfer();
              final java.lang.Object other$euBankTransfer = other.getEuBankTransfer();
              if (this$euBankTransfer == null ? other$euBankTransfer != null : !this$euBankTransfer.equals(other$euBankTransfer)) return false;
              final java.lang.Object this$requestedAddressTypes = this.getRequestedAddressTypes();
              final java.lang.Object other$requestedAddressTypes = other.getRequestedAddressTypes();
              if (this$requestedAddressTypes == null ? other$requestedAddressTypes != null : !this$requestedAddressTypes.equals(other$requestedAddressTypes)) return false;
              final java.lang.Object this$type = this.getType();
              final java.lang.Object other$type = other.getType();
              if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
              return true;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected boolean canEqual(final java.lang.Object other) {
              return other instanceof Order.Payment.Settings.PaymentMethodOptions.CustomerBalance.BankTransfer;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public int hashCode() {
              final int PRIME = 59;
              int result = 1;
              final java.lang.Object $euBankTransfer = this.getEuBankTransfer();
              result = result * PRIME + ($euBankTransfer == null ? 43 : $euBankTransfer.hashCode());
              final java.lang.Object $requestedAddressTypes = this.getRequestedAddressTypes();
              result = result * PRIME + ($requestedAddressTypes == null ? 43 : $requestedAddressTypes.hashCode());
              final java.lang.Object $type = this.getType();
              result = result * PRIME + ($type == null ? 43 : $type.hashCode());
              return result;
            }
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public BankTransfer getBankTransfer() {
            return this.bankTransfer;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getFundingType() {
            return this.fundingType;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getSetupFutureUsage() {
            return this.setupFutureUsage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setBankTransfer(final BankTransfer bankTransfer) {
            this.bankTransfer = bankTransfer;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setFundingType(final String fundingType) {
            this.fundingType = fundingType;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setSetupFutureUsage(final String setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.CustomerBalance)) return false;
            final Order.Payment.Settings.PaymentMethodOptions.CustomerBalance other = (Order.Payment.Settings.PaymentMethodOptions.CustomerBalance) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$bankTransfer = this.getBankTransfer();
            final java.lang.Object other$bankTransfer = other.getBankTransfer();
            if (this$bankTransfer == null ? other$bankTransfer != null : !this$bankTransfer.equals(other$bankTransfer)) return false;
            final java.lang.Object this$fundingType = this.getFundingType();
            final java.lang.Object other$fundingType = other.getFundingType();
            if (this$fundingType == null ? other$fundingType != null : !this$fundingType.equals(other$fundingType)) return false;
            final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
            final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
            if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Order.Payment.Settings.PaymentMethodOptions.CustomerBalance;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $bankTransfer = this.getBankTransfer();
            result = result * PRIME + ($bankTransfer == null ? 43 : $bankTransfer.hashCode());
            final java.lang.Object $fundingType = this.getFundingType();
            result = result * PRIME + ($fundingType == null ? 43 : $fundingType.hashCode());
            final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
            result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
            return result;
          }
        }


        public static class Ideal extends StripeObject {
          /**
           * Indicates that you intend to make future payments with this PaymentIntent's payment
           * method.
           *
           * <p>Providing this parameter will <a
           * href="https://stripe.com/docs/payments/save-during-payment">attach the payment
           * method</a> to the PaymentIntent's Customer, if present, after the PaymentIntent is
           * confirmed and any required actions from the user are complete. If no Customer was
           * provided, the payment method can still be <a
           * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
           * after the transaction completes.
           *
           * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
           * dynamically optimize your payment flow and comply with regional legislation and network
           * rules, such as <a
           * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
           *
           * <p>One of {@code none}, or {@code off_session}.
           */
          @SerializedName("setup_future_usage")
          String setupFutureUsage;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getSetupFutureUsage() {
            return this.setupFutureUsage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setSetupFutureUsage(final String setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.Ideal)) return false;
            final Order.Payment.Settings.PaymentMethodOptions.Ideal other = (Order.Payment.Settings.PaymentMethodOptions.Ideal) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
            final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
            if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Order.Payment.Settings.PaymentMethodOptions.Ideal;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
            result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
            return result;
          }
        }


        public static class Klarna extends StripeObject {
          /**
           * Controls when the funds will be captured from the customer's account.
           *
           * <p>Equal to {@code manual}.
           */
          @SerializedName("capture_method")
          String captureMethod;
          /** Preferred locale of the Klarna checkout page that the customer is redirected to. */
          @SerializedName("preferred_locale")
          String preferredLocale;
          /**
           * Indicates that you intend to make future payments with this PaymentIntent's payment
           * method.
           *
           * <p>Providing this parameter will <a
           * href="https://stripe.com/docs/payments/save-during-payment">attach the payment
           * method</a> to the PaymentIntent's Customer, if present, after the PaymentIntent is
           * confirmed and any required actions from the user are complete. If no Customer was
           * provided, the payment method can still be <a
           * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
           * after the transaction completes.
           *
           * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
           * dynamically optimize your payment flow and comply with regional legislation and network
           * rules, such as <a
           * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
           *
           * <p>Equal to {@code none}.
           */
          @SerializedName("setup_future_usage")
          String setupFutureUsage;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getCaptureMethod() {
            return this.captureMethod;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getPreferredLocale() {
            return this.preferredLocale;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getSetupFutureUsage() {
            return this.setupFutureUsage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setCaptureMethod(final String captureMethod) {
            this.captureMethod = captureMethod;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setPreferredLocale(final String preferredLocale) {
            this.preferredLocale = preferredLocale;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setSetupFutureUsage(final String setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.Klarna)) return false;
            final Order.Payment.Settings.PaymentMethodOptions.Klarna other = (Order.Payment.Settings.PaymentMethodOptions.Klarna) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$captureMethod = this.getCaptureMethod();
            final java.lang.Object other$captureMethod = other.getCaptureMethod();
            if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) return false;
            final java.lang.Object this$preferredLocale = this.getPreferredLocale();
            final java.lang.Object other$preferredLocale = other.getPreferredLocale();
            if (this$preferredLocale == null ? other$preferredLocale != null : !this$preferredLocale.equals(other$preferredLocale)) return false;
            final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
            final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
            if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Order.Payment.Settings.PaymentMethodOptions.Klarna;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $captureMethod = this.getCaptureMethod();
            result = result * PRIME + ($captureMethod == null ? 43 : $captureMethod.hashCode());
            final java.lang.Object $preferredLocale = this.getPreferredLocale();
            result = result * PRIME + ($preferredLocale == null ? 43 : $preferredLocale.hashCode());
            final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
            result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
            return result;
          }
        }


        public static class Link extends StripeObject {
          /**
           * Controls when the funds will be captured from the customer's account.
           *
           * <p>Equal to {@code manual}.
           */
          @SerializedName("capture_method")
          String captureMethod;
          /** Token used for persistent Link logins. */
          @SerializedName("persistent_token")
          String persistentToken;
          /**
           * Indicates that you intend to make future payments with this PaymentIntent's payment
           * method.
           *
           * <p>Providing this parameter will <a
           * href="https://stripe.com/docs/payments/save-during-payment">attach the payment
           * method</a> to the PaymentIntent's Customer, if present, after the PaymentIntent is
           * confirmed and any required actions from the user are complete. If no Customer was
           * provided, the payment method can still be <a
           * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
           * after the transaction completes.
           *
           * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
           * dynamically optimize your payment flow and comply with regional legislation and network
           * rules, such as <a
           * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
           *
           * <p>One of {@code none}, or {@code off_session}.
           */
          @SerializedName("setup_future_usage")
          String setupFutureUsage;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getCaptureMethod() {
            return this.captureMethod;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getPersistentToken() {
            return this.persistentToken;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getSetupFutureUsage() {
            return this.setupFutureUsage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setCaptureMethod(final String captureMethod) {
            this.captureMethod = captureMethod;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setPersistentToken(final String persistentToken) {
            this.persistentToken = persistentToken;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setSetupFutureUsage(final String setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.Link)) return false;
            final Order.Payment.Settings.PaymentMethodOptions.Link other = (Order.Payment.Settings.PaymentMethodOptions.Link) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$captureMethod = this.getCaptureMethod();
            final java.lang.Object other$captureMethod = other.getCaptureMethod();
            if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) return false;
            final java.lang.Object this$persistentToken = this.getPersistentToken();
            final java.lang.Object other$persistentToken = other.getPersistentToken();
            if (this$persistentToken == null ? other$persistentToken != null : !this$persistentToken.equals(other$persistentToken)) return false;
            final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
            final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
            if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Order.Payment.Settings.PaymentMethodOptions.Link;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $captureMethod = this.getCaptureMethod();
            result = result * PRIME + ($captureMethod == null ? 43 : $captureMethod.hashCode());
            final java.lang.Object $persistentToken = this.getPersistentToken();
            result = result * PRIME + ($persistentToken == null ? 43 : $persistentToken.hashCode());
            final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
            result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
            return result;
          }
        }


        public static class Oxxo extends StripeObject {
          /**
           * The number of calendar days before an OXXO invoice expires. For example, if you create
           * an OXXO invoice on Monday and you set expires_after_days to 2, the OXXO invoice will
           * expire on Wednesday at 23:59 America/Mexico_City time.
           */
          @SerializedName("expires_after_days")
          Long expiresAfterDays;
          /**
           * Indicates that you intend to make future payments with this PaymentIntent's payment
           * method.
           *
           * <p>Providing this parameter will <a
           * href="https://stripe.com/docs/payments/save-during-payment">attach the payment
           * method</a> to the PaymentIntent's Customer, if present, after the PaymentIntent is
           * confirmed and any required actions from the user are complete. If no Customer was
           * provided, the payment method can still be <a
           * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
           * after the transaction completes.
           *
           * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
           * dynamically optimize your payment flow and comply with regional legislation and network
           * rules, such as <a
           * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
           *
           * <p>Equal to {@code none}.
           */
          @SerializedName("setup_future_usage")
          String setupFutureUsage;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public Long getExpiresAfterDays() {
            return this.expiresAfterDays;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getSetupFutureUsage() {
            return this.setupFutureUsage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setExpiresAfterDays(final Long expiresAfterDays) {
            this.expiresAfterDays = expiresAfterDays;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setSetupFutureUsage(final String setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.Oxxo)) return false;
            final Order.Payment.Settings.PaymentMethodOptions.Oxxo other = (Order.Payment.Settings.PaymentMethodOptions.Oxxo) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$expiresAfterDays = this.getExpiresAfterDays();
            final java.lang.Object other$expiresAfterDays = other.getExpiresAfterDays();
            if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !this$expiresAfterDays.equals(other$expiresAfterDays)) return false;
            final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
            final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
            if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Order.Payment.Settings.PaymentMethodOptions.Oxxo;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $expiresAfterDays = this.getExpiresAfterDays();
            result = result * PRIME + ($expiresAfterDays == null ? 43 : $expiresAfterDays.hashCode());
            final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
            result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
            return result;
          }
        }


        public static class P24 extends StripeObject {
          /**
           * Indicates that you intend to make future payments with this PaymentIntent's payment
           * method.
           *
           * <p>Providing this parameter will <a
           * href="https://stripe.com/docs/payments/save-during-payment">attach the payment
           * method</a> to the PaymentIntent's Customer, if present, after the PaymentIntent is
           * confirmed and any required actions from the user are complete. If no Customer was
           * provided, the payment method can still be <a
           * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
           * after the transaction completes.
           *
           * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
           * dynamically optimize your payment flow and comply with regional legislation and network
           * rules, such as <a
           * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
           *
           * <p>Equal to {@code none}.
           */
          @SerializedName("setup_future_usage")
          String setupFutureUsage;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getSetupFutureUsage() {
            return this.setupFutureUsage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setSetupFutureUsage(final String setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.P24)) return false;
            final Order.Payment.Settings.PaymentMethodOptions.P24 other = (Order.Payment.Settings.PaymentMethodOptions.P24) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
            final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
            if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Order.Payment.Settings.PaymentMethodOptions.P24;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
            result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
            return result;
          }
        }


        public static class Paypal extends StripeObject {
          /**
           * Controls when the funds will be captured from the customer's account.
           *
           * <p>Equal to {@code manual}.
           */
          @SerializedName("capture_method")
          String captureMethod;
          /** Preferred locale of the PayPal checkout page that the customer is redirected to. */
          @SerializedName("preferred_locale")
          String preferredLocale;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getCaptureMethod() {
            return this.captureMethod;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getPreferredLocale() {
            return this.preferredLocale;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setCaptureMethod(final String captureMethod) {
            this.captureMethod = captureMethod;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setPreferredLocale(final String preferredLocale) {
            this.preferredLocale = preferredLocale;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.Paypal)) return false;
            final Order.Payment.Settings.PaymentMethodOptions.Paypal other = (Order.Payment.Settings.PaymentMethodOptions.Paypal) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$captureMethod = this.getCaptureMethod();
            final java.lang.Object other$captureMethod = other.getCaptureMethod();
            if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) return false;
            final java.lang.Object this$preferredLocale = this.getPreferredLocale();
            final java.lang.Object other$preferredLocale = other.getPreferredLocale();
            if (this$preferredLocale == null ? other$preferredLocale != null : !this$preferredLocale.equals(other$preferredLocale)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Order.Payment.Settings.PaymentMethodOptions.Paypal;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $captureMethod = this.getCaptureMethod();
            result = result * PRIME + ($captureMethod == null ? 43 : $captureMethod.hashCode());
            final java.lang.Object $preferredLocale = this.getPreferredLocale();
            result = result * PRIME + ($preferredLocale == null ? 43 : $preferredLocale.hashCode());
            return result;
          }
        }


        public static class SepaDebit extends StripeObject {
          @SerializedName("mandate_options")
          MandateOptions mandateOptions;
          /**
           * Indicates that you intend to make future payments with this PaymentIntent's payment
           * method.
           *
           * <p>Providing this parameter will <a
           * href="https://stripe.com/docs/payments/save-during-payment">attach the payment
           * method</a> to the PaymentIntent's Customer, if present, after the PaymentIntent is
           * confirmed and any required actions from the user are complete. If no Customer was
           * provided, the payment method can still be <a
           * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
           * after the transaction completes.
           *
           * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
           * dynamically optimize your payment flow and comply with regional legislation and network
           * rules, such as <a
           * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
           *
           * <p>One of {@code none}, {@code off_session}, or {@code on_session}.
           */
          @SerializedName("setup_future_usage")
          String setupFutureUsage;


          public static class MandateOptions extends StripeObject {
            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public boolean equals(final java.lang.Object o) {
              if (o == this) return true;
              if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.SepaDebit.MandateOptions)) return false;
              final Order.Payment.Settings.PaymentMethodOptions.SepaDebit.MandateOptions other = (Order.Payment.Settings.PaymentMethodOptions.SepaDebit.MandateOptions) o;
              if (!other.canEqual((java.lang.Object) this)) return false;
              return true;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected boolean canEqual(final java.lang.Object other) {
              return other instanceof Order.Payment.Settings.PaymentMethodOptions.SepaDebit.MandateOptions;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public int hashCode() {
              final int result = 1;
              return result;
            }
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public MandateOptions getMandateOptions() {
            return this.mandateOptions;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getSetupFutureUsage() {
            return this.setupFutureUsage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setMandateOptions(final MandateOptions mandateOptions) {
            this.mandateOptions = mandateOptions;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setSetupFutureUsage(final String setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.SepaDebit)) return false;
            final Order.Payment.Settings.PaymentMethodOptions.SepaDebit other = (Order.Payment.Settings.PaymentMethodOptions.SepaDebit) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$mandateOptions = this.getMandateOptions();
            final java.lang.Object other$mandateOptions = other.getMandateOptions();
            if (this$mandateOptions == null ? other$mandateOptions != null : !this$mandateOptions.equals(other$mandateOptions)) return false;
            final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
            final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
            if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Order.Payment.Settings.PaymentMethodOptions.SepaDebit;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $mandateOptions = this.getMandateOptions();
            result = result * PRIME + ($mandateOptions == null ? 43 : $mandateOptions.hashCode());
            final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
            result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
            return result;
          }
        }


        public static class Sofort extends StripeObject {
          /**
           * Preferred language of the SOFORT authorization page that the customer is redirected to.
           *
           * <p>One of {@code de}, {@code en}, {@code es}, {@code fr}, {@code it}, {@code nl}, or
           * {@code pl}.
           */
          @SerializedName("preferred_language")
          String preferredLanguage;
          /**
           * Indicates that you intend to make future payments with this PaymentIntent's payment
           * method.
           *
           * <p>Providing this parameter will <a
           * href="https://stripe.com/docs/payments/save-during-payment">attach the payment
           * method</a> to the PaymentIntent's Customer, if present, after the PaymentIntent is
           * confirmed and any required actions from the user are complete. If no Customer was
           * provided, the payment method can still be <a
           * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
           * after the transaction completes.
           *
           * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
           * dynamically optimize your payment flow and comply with regional legislation and network
           * rules, such as <a
           * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
           *
           * <p>One of {@code none}, or {@code off_session}.
           */
          @SerializedName("setup_future_usage")
          String setupFutureUsage;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getPreferredLanguage() {
            return this.preferredLanguage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getSetupFutureUsage() {
            return this.setupFutureUsage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setPreferredLanguage(final String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setSetupFutureUsage(final String setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.Sofort)) return false;
            final Order.Payment.Settings.PaymentMethodOptions.Sofort other = (Order.Payment.Settings.PaymentMethodOptions.Sofort) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$preferredLanguage = this.getPreferredLanguage();
            final java.lang.Object other$preferredLanguage = other.getPreferredLanguage();
            if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) return false;
            final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
            final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
            if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Order.Payment.Settings.PaymentMethodOptions.Sofort;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $preferredLanguage = this.getPreferredLanguage();
            result = result * PRIME + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
            final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
            result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
            return result;
          }
        }


        public static class WechatPay extends StripeObject {
          /** The app ID registered with WeChat Pay. Only required when client is ios or android. */
          @SerializedName("app_id")
          String appId;
          /**
           * The client type that the end customer will pay from
           *
           * <p>One of {@code android}, {@code ios}, or {@code web}.
           */
          @SerializedName("client")
          String client;
          /**
           * Indicates that you intend to make future payments with this PaymentIntent's payment
           * method.
           *
           * <p>Providing this parameter will <a
           * href="https://stripe.com/docs/payments/save-during-payment">attach the payment
           * method</a> to the PaymentIntent's Customer, if present, after the PaymentIntent is
           * confirmed and any required actions from the user are complete. If no Customer was
           * provided, the payment method can still be <a
           * href="https://stripe.com/docs/api/payment_methods/attach">attached</a> to a Customer
           * after the transaction completes.
           *
           * <p>When processing card payments, Stripe also uses {@code setup_future_usage} to
           * dynamically optimize your payment flow and comply with regional legislation and network
           * rules, such as <a
           * href="https://stripe.com/docs/strong-customer-authentication">SCA</a>.
           *
           * <p>Equal to {@code none}.
           */
          @SerializedName("setup_future_usage")
          String setupFutureUsage;

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getAppId() {
            return this.appId;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getClient() {
            return this.client;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public String getSetupFutureUsage() {
            return this.setupFutureUsage;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setAppId(final String appId) {
            this.appId = appId;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setClient(final String client) {
            this.client = client;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public void setSetupFutureUsage(final String setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions.WechatPay)) return false;
            final Order.Payment.Settings.PaymentMethodOptions.WechatPay other = (Order.Payment.Settings.PaymentMethodOptions.WechatPay) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$appId = this.getAppId();
            final java.lang.Object other$appId = other.getAppId();
            if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) return false;
            final java.lang.Object this$client = this.getClient();
            final java.lang.Object other$client = other.getClient();
            if (this$client == null ? other$client != null : !this$client.equals(other$client)) return false;
            final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
            final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
            if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
            return true;
          }

          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          protected boolean canEqual(final java.lang.Object other) {
            return other instanceof Order.Payment.Settings.PaymentMethodOptions.WechatPay;
          }

          @java.lang.Override
          @java.lang.SuppressWarnings("all")
          @lombok.Generated
          public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $appId = this.getAppId();
            result = result * PRIME + ($appId == null ? 43 : $appId.hashCode());
            final java.lang.Object $client = this.getClient();
            result = result * PRIME + ($client == null ? 43 : $client.hashCode());
            final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
            result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
            return result;
          }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AcssDebit getAcssDebit() {
          return this.acssDebit;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AfterpayClearpay getAfterpayClearpay() {
          return this.afterpayClearpay;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Alipay getAlipay() {
          return this.alipay;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Bancontact getBancontact() {
          return this.bancontact;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Card getCard() {
          return this.card;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public CustomerBalance getCustomerBalance() {
          return this.customerBalance;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Ideal getIdeal() {
          return this.ideal;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Klarna getKlarna() {
          return this.klarna;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Link getLink() {
          return this.link;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Oxxo getOxxo() {
          return this.oxxo;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public P24 getP24() {
          return this.p24;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Paypal getPaypal() {
          return this.paypal;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SepaDebit getSepaDebit() {
          return this.sepaDebit;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Sofort getSofort() {
          return this.sofort;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public WechatPay getWechatPay() {
          return this.wechatPay;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAcssDebit(final AcssDebit acssDebit) {
          this.acssDebit = acssDebit;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAfterpayClearpay(final AfterpayClearpay afterpayClearpay) {
          this.afterpayClearpay = afterpayClearpay;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAlipay(final Alipay alipay) {
          this.alipay = alipay;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBancontact(final Bancontact bancontact) {
          this.bancontact = bancontact;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCard(final Card card) {
          this.card = card;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCustomerBalance(final CustomerBalance customerBalance) {
          this.customerBalance = customerBalance;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setIdeal(final Ideal ideal) {
          this.ideal = ideal;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setKlarna(final Klarna klarna) {
          this.klarna = klarna;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setLink(final Link link) {
          this.link = link;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setOxxo(final Oxxo oxxo) {
          this.oxxo = oxxo;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setP24(final P24 p24) {
          this.p24 = p24;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setPaypal(final Paypal paypal) {
          this.paypal = paypal;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setSepaDebit(final SepaDebit sepaDebit) {
          this.sepaDebit = sepaDebit;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setSofort(final Sofort sofort) {
          this.sofort = sofort;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setWechatPay(final WechatPay wechatPay) {
          this.wechatPay = wechatPay;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Order.Payment.Settings.PaymentMethodOptions)) return false;
          final Order.Payment.Settings.PaymentMethodOptions other = (Order.Payment.Settings.PaymentMethodOptions) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$acssDebit = this.getAcssDebit();
          final java.lang.Object other$acssDebit = other.getAcssDebit();
          if (this$acssDebit == null ? other$acssDebit != null : !this$acssDebit.equals(other$acssDebit)) return false;
          final java.lang.Object this$afterpayClearpay = this.getAfterpayClearpay();
          final java.lang.Object other$afterpayClearpay = other.getAfterpayClearpay();
          if (this$afterpayClearpay == null ? other$afterpayClearpay != null : !this$afterpayClearpay.equals(other$afterpayClearpay)) return false;
          final java.lang.Object this$alipay = this.getAlipay();
          final java.lang.Object other$alipay = other.getAlipay();
          if (this$alipay == null ? other$alipay != null : !this$alipay.equals(other$alipay)) return false;
          final java.lang.Object this$bancontact = this.getBancontact();
          final java.lang.Object other$bancontact = other.getBancontact();
          if (this$bancontact == null ? other$bancontact != null : !this$bancontact.equals(other$bancontact)) return false;
          final java.lang.Object this$card = this.getCard();
          final java.lang.Object other$card = other.getCard();
          if (this$card == null ? other$card != null : !this$card.equals(other$card)) return false;
          final java.lang.Object this$customerBalance = this.getCustomerBalance();
          final java.lang.Object other$customerBalance = other.getCustomerBalance();
          if (this$customerBalance == null ? other$customerBalance != null : !this$customerBalance.equals(other$customerBalance)) return false;
          final java.lang.Object this$ideal = this.getIdeal();
          final java.lang.Object other$ideal = other.getIdeal();
          if (this$ideal == null ? other$ideal != null : !this$ideal.equals(other$ideal)) return false;
          final java.lang.Object this$klarna = this.getKlarna();
          final java.lang.Object other$klarna = other.getKlarna();
          if (this$klarna == null ? other$klarna != null : !this$klarna.equals(other$klarna)) return false;
          final java.lang.Object this$link = this.getLink();
          final java.lang.Object other$link = other.getLink();
          if (this$link == null ? other$link != null : !this$link.equals(other$link)) return false;
          final java.lang.Object this$oxxo = this.getOxxo();
          final java.lang.Object other$oxxo = other.getOxxo();
          if (this$oxxo == null ? other$oxxo != null : !this$oxxo.equals(other$oxxo)) return false;
          final java.lang.Object this$p24 = this.getP24();
          final java.lang.Object other$p24 = other.getP24();
          if (this$p24 == null ? other$p24 != null : !this$p24.equals(other$p24)) return false;
          final java.lang.Object this$paypal = this.getPaypal();
          final java.lang.Object other$paypal = other.getPaypal();
          if (this$paypal == null ? other$paypal != null : !this$paypal.equals(other$paypal)) return false;
          final java.lang.Object this$sepaDebit = this.getSepaDebit();
          final java.lang.Object other$sepaDebit = other.getSepaDebit();
          if (this$sepaDebit == null ? other$sepaDebit != null : !this$sepaDebit.equals(other$sepaDebit)) return false;
          final java.lang.Object this$sofort = this.getSofort();
          final java.lang.Object other$sofort = other.getSofort();
          if (this$sofort == null ? other$sofort != null : !this$sofort.equals(other$sofort)) return false;
          final java.lang.Object this$wechatPay = this.getWechatPay();
          final java.lang.Object other$wechatPay = other.getWechatPay();
          if (this$wechatPay == null ? other$wechatPay != null : !this$wechatPay.equals(other$wechatPay)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Order.Payment.Settings.PaymentMethodOptions;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $acssDebit = this.getAcssDebit();
          result = result * PRIME + ($acssDebit == null ? 43 : $acssDebit.hashCode());
          final java.lang.Object $afterpayClearpay = this.getAfterpayClearpay();
          result = result * PRIME + ($afterpayClearpay == null ? 43 : $afterpayClearpay.hashCode());
          final java.lang.Object $alipay = this.getAlipay();
          result = result * PRIME + ($alipay == null ? 43 : $alipay.hashCode());
          final java.lang.Object $bancontact = this.getBancontact();
          result = result * PRIME + ($bancontact == null ? 43 : $bancontact.hashCode());
          final java.lang.Object $card = this.getCard();
          result = result * PRIME + ($card == null ? 43 : $card.hashCode());
          final java.lang.Object $customerBalance = this.getCustomerBalance();
          result = result * PRIME + ($customerBalance == null ? 43 : $customerBalance.hashCode());
          final java.lang.Object $ideal = this.getIdeal();
          result = result * PRIME + ($ideal == null ? 43 : $ideal.hashCode());
          final java.lang.Object $klarna = this.getKlarna();
          result = result * PRIME + ($klarna == null ? 43 : $klarna.hashCode());
          final java.lang.Object $link = this.getLink();
          result = result * PRIME + ($link == null ? 43 : $link.hashCode());
          final java.lang.Object $oxxo = this.getOxxo();
          result = result * PRIME + ($oxxo == null ? 43 : $oxxo.hashCode());
          final java.lang.Object $p24 = this.getP24();
          result = result * PRIME + ($p24 == null ? 43 : $p24.hashCode());
          final java.lang.Object $paypal = this.getPaypal();
          result = result * PRIME + ($paypal == null ? 43 : $paypal.hashCode());
          final java.lang.Object $sepaDebit = this.getSepaDebit();
          result = result * PRIME + ($sepaDebit == null ? 43 : $sepaDebit.hashCode());
          final java.lang.Object $sofort = this.getSofort();
          result = result * PRIME + ($sofort == null ? 43 : $sofort.hashCode());
          final java.lang.Object $wechatPay = this.getWechatPay();
          result = result * PRIME + ($wechatPay == null ? 43 : $wechatPay.hashCode());
          return result;
        }
      }


      public static class TransferData extends StripeObject {
        /**
         * The amount that will be transferred automatically when the order is paid. If no amount is
         * set, the full amount is transferred. There cannot be any line items with recurring prices
         * when using this field.
         */
        @SerializedName("amount")
        Long amount;
        /** ID of the Connected account receiving the transfer. */
        @SerializedName("destination")
        ExpandableField<Account> destination;

        /** Get ID of expandable {@code destination} object. */
        public String getDestination() {
          return (this.destination != null) ? this.destination.getId() : null;
        }

        public void setDestination(String id) {
          this.destination = ApiResource.setExpandableFieldId(id, this.destination);
        }

        public Account getDestinationObject() {
          return (this.destination != null) ? this.destination.getExpanded() : null;
        }

        public void setDestinationObject(Account expandableObject) {
          this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getAmount() {
          return this.amount;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAmount(final Long amount) {
          this.amount = amount;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Order.Payment.Settings.TransferData)) return false;
          final Order.Payment.Settings.TransferData other = (Order.Payment.Settings.TransferData) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$amount = this.getAmount();
          final java.lang.Object other$amount = other.getAmount();
          if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
          final java.lang.Object this$destination = this.getDestination();
          final java.lang.Object other$destination = other.getDestination();
          if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Order.Payment.Settings.TransferData;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $amount = this.getAmount();
          result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
          final java.lang.Object $destination = this.getDestination();
          result = result * PRIME + ($destination == null ? 43 : $destination.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getApplicationFeeAmount() {
        return this.applicationFeeAmount;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public AutomaticPaymentMethods getAutomaticPaymentMethods() {
        return this.automaticPaymentMethods;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public PaymentMethodOptions getPaymentMethodOptions() {
        return this.paymentMethodOptions;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getReturnUrl() {
        return this.returnUrl;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getStatementDescriptor() {
        return this.statementDescriptor;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getStatementDescriptorSuffix() {
        return this.statementDescriptorSuffix;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public TransferData getTransferData() {
        return this.transferData;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setApplicationFeeAmount(final Long applicationFeeAmount) {
        this.applicationFeeAmount = applicationFeeAmount;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAutomaticPaymentMethods(final AutomaticPaymentMethods automaticPaymentMethods) {
        this.automaticPaymentMethods = automaticPaymentMethods;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPaymentMethodOptions(final PaymentMethodOptions paymentMethodOptions) {
        this.paymentMethodOptions = paymentMethodOptions;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setPaymentMethodTypes(final List<String> paymentMethodTypes) {
        this.paymentMethodTypes = paymentMethodTypes;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setReturnUrl(final String returnUrl) {
        this.returnUrl = returnUrl;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setStatementDescriptor(final String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setStatementDescriptorSuffix(final String statementDescriptorSuffix) {
        this.statementDescriptorSuffix = statementDescriptorSuffix;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setTransferData(final TransferData transferData) {
        this.transferData = transferData;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Order.Payment.Settings)) return false;
        final Order.Payment.Settings other = (Order.Payment.Settings) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$applicationFeeAmount = this.getApplicationFeeAmount();
        final java.lang.Object other$applicationFeeAmount = other.getApplicationFeeAmount();
        if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !this$applicationFeeAmount.equals(other$applicationFeeAmount)) return false;
        final java.lang.Object this$automaticPaymentMethods = this.getAutomaticPaymentMethods();
        final java.lang.Object other$automaticPaymentMethods = other.getAutomaticPaymentMethods();
        if (this$automaticPaymentMethods == null ? other$automaticPaymentMethods != null : !this$automaticPaymentMethods.equals(other$automaticPaymentMethods)) return false;
        final java.lang.Object this$paymentMethodOptions = this.getPaymentMethodOptions();
        final java.lang.Object other$paymentMethodOptions = other.getPaymentMethodOptions();
        if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !this$paymentMethodOptions.equals(other$paymentMethodOptions)) return false;
        final java.lang.Object this$paymentMethodTypes = this.getPaymentMethodTypes();
        final java.lang.Object other$paymentMethodTypes = other.getPaymentMethodTypes();
        if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !this$paymentMethodTypes.equals(other$paymentMethodTypes)) return false;
        final java.lang.Object this$returnUrl = this.getReturnUrl();
        final java.lang.Object other$returnUrl = other.getReturnUrl();
        if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) return false;
        final java.lang.Object this$statementDescriptor = this.getStatementDescriptor();
        final java.lang.Object other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) return false;
        final java.lang.Object this$statementDescriptorSuffix = this.getStatementDescriptorSuffix();
        final java.lang.Object other$statementDescriptorSuffix = other.getStatementDescriptorSuffix();
        if (this$statementDescriptorSuffix == null ? other$statementDescriptorSuffix != null : !this$statementDescriptorSuffix.equals(other$statementDescriptorSuffix)) return false;
        final java.lang.Object this$transferData = this.getTransferData();
        final java.lang.Object other$transferData = other.getTransferData();
        if (this$transferData == null ? other$transferData != null : !this$transferData.equals(other$transferData)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Order.Payment.Settings;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $applicationFeeAmount = this.getApplicationFeeAmount();
        result = result * PRIME + ($applicationFeeAmount == null ? 43 : $applicationFeeAmount.hashCode());
        final java.lang.Object $automaticPaymentMethods = this.getAutomaticPaymentMethods();
        result = result * PRIME + ($automaticPaymentMethods == null ? 43 : $automaticPaymentMethods.hashCode());
        final java.lang.Object $paymentMethodOptions = this.getPaymentMethodOptions();
        result = result * PRIME + ($paymentMethodOptions == null ? 43 : $paymentMethodOptions.hashCode());
        final java.lang.Object $paymentMethodTypes = this.getPaymentMethodTypes();
        result = result * PRIME + ($paymentMethodTypes == null ? 43 : $paymentMethodTypes.hashCode());
        final java.lang.Object $returnUrl = this.getReturnUrl();
        result = result * PRIME + ($returnUrl == null ? 43 : $returnUrl.hashCode());
        final java.lang.Object $statementDescriptor = this.getStatementDescriptor();
        result = result * PRIME + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        final java.lang.Object $statementDescriptorSuffix = this.getStatementDescriptorSuffix();
        result = result * PRIME + ($statementDescriptorSuffix == null ? 43 : $statementDescriptorSuffix.hashCode());
        final java.lang.Object $transferData = this.getTransferData();
        result = result * PRIME + ($transferData == null ? 43 : $transferData.hashCode());
        return result;
      }
    }

    /**
     * Settings describing how the order should configure generated PaymentIntents.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Settings getSettings() {
      return this.settings;
    }

    /**
     * The status of the underlying payment associated with this order, if any. Null when the order
     * is {@code open}.
     *
     * <p>One of {@code canceled}, {@code complete}, {@code not_required}, {@code processing},
     * {@code requires_action}, {@code requires_capture}, {@code requires_confirmation}, or {@code
     * requires_payment_method}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    /**
     * Settings describing how the order should configure generated PaymentIntents.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSettings(final Settings settings) {
      this.settings = settings;
    }

    /**
     * The status of the underlying payment associated with this order, if any. Null when the order
     * is {@code open}.
     *
     * <p>One of {@code canceled}, {@code complete}, {@code not_required}, {@code processing},
     * {@code requires_action}, {@code requires_capture}, {@code requires_confirmation}, or {@code
     * requires_payment_method}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Order.Payment)) return false;
      final Order.Payment other = (Order.Payment) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$paymentIntent = this.getPaymentIntent();
      final java.lang.Object other$paymentIntent = other.getPaymentIntent();
      if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) return false;
      final java.lang.Object this$settings = this.getSettings();
      final java.lang.Object other$settings = other.getSettings();
      if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Order.Payment;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $paymentIntent = this.getPaymentIntent();
      result = result * PRIME + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
      final java.lang.Object $settings = this.getSettings();
      result = result * PRIME + ($settings == null ? 43 : $settings.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      return result;
    }
  }


  /**
   * Get expanded {@code destination}.
   */
  public static class ShippingCost extends StripeObject {
    /**
     * Total shipping cost before any discounts or taxes are applied.
     */
    @SerializedName("amount_subtotal")
    Long amountSubtotal;
    /**
     * Total tax amount applied due to shipping costs. If no tax was applied, defaults to 0.
     */
    @SerializedName("amount_tax")
    Long amountTax;
    /**
     * Total shipping cost after discounts and taxes are applied.
     */
    @SerializedName("amount_total")
    Long amountTotal;
    /**
     * The ID of the ShippingRate for this order.
     */
    @SerializedName("shipping_rate")
    ExpandableField<ShippingRate> shippingRate;
    /**
     * The taxes applied to the shipping rate.
     */
    @SerializedName("taxes")
    List<Order.ShippingCost.Tax> taxes;

    /**
     * Get ID of expandable {@code shippingRate} object.
     */
    public String getShippingRate() {
      return (this.shippingRate != null) ? this.shippingRate.getId() : null;
    }

    public void setShippingRate(String id) {
      this.shippingRate = ApiResource.setExpandableFieldId(id, this.shippingRate);
    }

    /**
     * Get expanded {@code shippingRate}.
     */
    public ShippingRate getShippingRateObject() {
      return (this.shippingRate != null) ? this.shippingRate.getExpanded() : null;
    }

    public void setShippingRateObject(ShippingRate expandableObject) {
      this.shippingRate = new ExpandableField<ShippingRate>(expandableObject.getId(), expandableObject);
    }


    public static class Tax extends StripeObject {
      /** Amount of tax applied for this rate. */
      @SerializedName("amount")
      Long amount;
      @SerializedName("rate")
      TaxRate rate;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Long getAmount() {
        return this.amount;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public TaxRate getRate() {
        return this.rate;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAmount(final Long amount) {
        this.amount = amount;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRate(final TaxRate rate) {
        this.rate = rate;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Order.ShippingCost.Tax)) return false;
        final Order.ShippingCost.Tax other = (Order.ShippingCost.Tax) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$amount = this.getAmount();
        final java.lang.Object other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
        final java.lang.Object this$rate = this.getRate();
        final java.lang.Object other$rate = other.getRate();
        if (this$rate == null ? other$rate != null : !this$rate.equals(other$rate)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Order.ShippingCost.Tax;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $amount = this.getAmount();
        result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
        final java.lang.Object $rate = this.getRate();
        result = result * PRIME + ($rate == null ? 43 : $rate.hashCode());
        return result;
      }
    }

    /**
     * Total shipping cost before any discounts or taxes are applied.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountSubtotal() {
      return this.amountSubtotal;
    }

    /**
     * Total tax amount applied due to shipping costs. If no tax was applied, defaults to 0.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountTax() {
      return this.amountTax;
    }

    /**
     * Total shipping cost after discounts and taxes are applied.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountTotal() {
      return this.amountTotal;
    }

    /**
     * The taxes applied to the shipping rate.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Order.ShippingCost.Tax> getTaxes() {
      return this.taxes;
    }

    /**
     * Total shipping cost before any discounts or taxes are applied.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountSubtotal(final Long amountSubtotal) {
      this.amountSubtotal = amountSubtotal;
    }

    /**
     * Total tax amount applied due to shipping costs. If no tax was applied, defaults to 0.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountTax(final Long amountTax) {
      this.amountTax = amountTax;
    }

    /**
     * Total shipping cost after discounts and taxes are applied.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountTotal(final Long amountTotal) {
      this.amountTotal = amountTotal;
    }

    /**
     * The taxes applied to the shipping rate.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTaxes(final List<Order.ShippingCost.Tax> taxes) {
      this.taxes = taxes;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Order.ShippingCost)) return false;
      final Order.ShippingCost other = (Order.ShippingCost) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amountSubtotal = this.getAmountSubtotal();
      final java.lang.Object other$amountSubtotal = other.getAmountSubtotal();
      if (this$amountSubtotal == null ? other$amountSubtotal != null : !this$amountSubtotal.equals(other$amountSubtotal)) return false;
      final java.lang.Object this$amountTax = this.getAmountTax();
      final java.lang.Object other$amountTax = other.getAmountTax();
      if (this$amountTax == null ? other$amountTax != null : !this$amountTax.equals(other$amountTax)) return false;
      final java.lang.Object this$amountTotal = this.getAmountTotal();
      final java.lang.Object other$amountTotal = other.getAmountTotal();
      if (this$amountTotal == null ? other$amountTotal != null : !this$amountTotal.equals(other$amountTotal)) return false;
      final java.lang.Object this$shippingRate = this.getShippingRate();
      final java.lang.Object other$shippingRate = other.getShippingRate();
      if (this$shippingRate == null ? other$shippingRate != null : !this$shippingRate.equals(other$shippingRate)) return false;
      final java.lang.Object this$taxes = this.getTaxes();
      final java.lang.Object other$taxes = other.getTaxes();
      if (this$taxes == null ? other$taxes != null : !this$taxes.equals(other$taxes)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Order.ShippingCost;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amountSubtotal = this.getAmountSubtotal();
      result = result * PRIME + ($amountSubtotal == null ? 43 : $amountSubtotal.hashCode());
      final java.lang.Object $amountTax = this.getAmountTax();
      result = result * PRIME + ($amountTax == null ? 43 : $amountTax.hashCode());
      final java.lang.Object $amountTotal = this.getAmountTotal();
      result = result * PRIME + ($amountTotal == null ? 43 : $amountTotal.hashCode());
      final java.lang.Object $shippingRate = this.getShippingRate();
      result = result * PRIME + ($shippingRate == null ? 43 : $shippingRate.hashCode());
      final java.lang.Object $taxes = this.getTaxes();
      result = result * PRIME + ($taxes == null ? 43 : $taxes.hashCode());
      return result;
    }
  }


  /**
   * Tax rates can be applied to <a
   * href="https://stripe.com/docs/billing/invoices/tax-rates">invoices</a>, <a
   * href="https://stripe.com/docs/billing/subscriptions/taxes">subscriptions</a> and <a
   * href="https://stripe.com/docs/payments/checkout/set-up-a-subscription#tax-rates">Checkout
   * Sessions</a> to collect tax.
   *
   * <p>Related guide: <a href="https://stripe.com/docs/billing/taxes/tax-rates">Tax Rates</a>.
   */
  public static class ShippingDetails extends StripeObject {
    /**
     * Recipient shipping address. Required if the order includes products that are shippable.
     */
    @SerializedName("address")
    Address address;
    /**
     * Recipient name.
     */
    @SerializedName("name")
    String name;
    /**
     * Recipient phone (including extension).
     */
    @SerializedName("phone")
    String phone;

    /**
     * Recipient shipping address. Required if the order includes products that are shippable.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Address getAddress() {
      return this.address;
    }

    /**
     * Recipient name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
      return this.name;
    }

    /**
     * Recipient phone (including extension).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPhone() {
      return this.phone;
    }

    /**
     * Recipient shipping address. Required if the order includes products that are shippable.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAddress(final Address address) {
      this.address = address;
    }

    /**
     * Recipient name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
      this.name = name;
    }

    /**
     * Recipient phone (including extension).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPhone(final String phone) {
      this.phone = phone;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Order.ShippingDetails)) return false;
      final Order.ShippingDetails other = (Order.ShippingDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$address = this.getAddress();
      final java.lang.Object other$address = other.getAddress();
      if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
      final java.lang.Object this$name = this.getName();
      final java.lang.Object other$name = other.getName();
      if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
      final java.lang.Object this$phone = this.getPhone();
      final java.lang.Object other$phone = other.getPhone();
      if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Order.ShippingDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $address = this.getAddress();
      result = result * PRIME + ($address == null ? 43 : $address.hashCode());
      final java.lang.Object $name = this.getName();
      result = result * PRIME + ($name == null ? 43 : $name.hashCode());
      final java.lang.Object $phone = this.getPhone();
      result = result * PRIME + ($phone == null ? 43 : $phone.hashCode());
      return result;
    }
  }


  public static class TaxDetails extends StripeObject {
    /**
     * Describes the purchaser's tax exemption status. One of {@code none}, {@code exempt}, or
     * {@code reverse}.
     */
    @SerializedName("tax_exempt")
    String taxExempt;
    /**
     * The purchaser's tax IDs to be used in calculation of tax for this Order.
     */
    @SerializedName("tax_ids")
    List<Order.TaxDetails.TaxId> taxIds;


    public static class TaxId extends StripeObject {
      /**
       * The type of the tax ID, one of {@code eu_vat}, {@code br_cnpj}, {@code br_cpf}, {@code
       * eu_oss_vat}, {@code gb_vat}, {@code nz_gst}, {@code au_abn}, {@code au_arn}, {@code
       * in_gst}, {@code no_vat}, {@code za_vat}, {@code ch_vat}, {@code mx_rfc}, {@code sg_uen},
       * {@code ru_inn}, {@code ru_kpp}, {@code ca_bn}, {@code hk_br}, {@code es_cif}, {@code
       * tw_vat}, {@code th_vat}, {@code jp_cn}, {@code jp_rn}, {@code li_uid}, {@code my_itn},
       * {@code us_ein}, {@code kr_brn}, {@code ca_qst}, {@code ca_gst_hst}, {@code ca_pst_bc},
       * {@code ca_pst_mb}, {@code ca_pst_sk}, {@code my_sst}, {@code sg_gst}, {@code ae_trn},
       * {@code cl_tin}, {@code sa_vat}, {@code id_npwp}, {@code my_frp}, {@code il_vat}, {@code
       * ge_vat}, {@code ua_vat}, {@code is_vat}, {@code bg_uic}, {@code hu_tin}, {@code si_tin}, or
       * {@code unknown}.
       */
      @SerializedName("type")
      String type;
      @SerializedName("value")
      String value;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getType() {
        return this.type;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getValue() {
        return this.value;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setType(final String type) {
        this.type = type;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setValue(final String value) {
        this.value = value;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Order.TaxDetails.TaxId)) return false;
        final Order.TaxDetails.TaxId other = (Order.TaxDetails.TaxId) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        final java.lang.Object this$value = this.getValue();
        final java.lang.Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Order.TaxDetails.TaxId;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        final java.lang.Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        return result;
      }
    }

    /**
     * Describes the purchaser's tax exemption status. One of {@code none}, {@code exempt}, or
     * {@code reverse}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTaxExempt() {
      return this.taxExempt;
    }

    /**
     * The purchaser's tax IDs to be used in calculation of tax for this Order.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Order.TaxDetails.TaxId> getTaxIds() {
      return this.taxIds;
    }

    /**
     * Describes the purchaser's tax exemption status. One of {@code none}, {@code exempt}, or
     * {@code reverse}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTaxExempt(final String taxExempt) {
      this.taxExempt = taxExempt;
    }

    /**
     * The purchaser's tax IDs to be used in calculation of tax for this Order.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTaxIds(final List<Order.TaxDetails.TaxId> taxIds) {
      this.taxIds = taxIds;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Order.TaxDetails)) return false;
      final Order.TaxDetails other = (Order.TaxDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$taxExempt = this.getTaxExempt();
      final java.lang.Object other$taxExempt = other.getTaxExempt();
      if (this$taxExempt == null ? other$taxExempt != null : !this$taxExempt.equals(other$taxExempt)) return false;
      final java.lang.Object this$taxIds = this.getTaxIds();
      final java.lang.Object other$taxIds = other.getTaxIds();
      if (this$taxIds == null ? other$taxIds != null : !this$taxIds.equals(other$taxIds)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Order.TaxDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $taxExempt = this.getTaxExempt();
      result = result * PRIME + ($taxExempt == null ? 43 : $taxExempt.hashCode());
      final java.lang.Object $taxIds = this.getTaxIds();
      result = result * PRIME + ($taxIds == null ? 43 : $taxIds.hashCode());
      return result;
    }
  }


  /**
   * The value of the tax ID.
   */
  public static class TotalDetails extends StripeObject {
    /** This is the sum of all the discounts. */
    @SerializedName("amount_discount")
    Long amountDiscount;
    /** This is the sum of all the shipping amounts. */
    @SerializedName("amount_shipping")
    Long amountShipping;
    /** This is the sum of all the tax amounts. */
    @SerializedName("amount_tax")
    Long amountTax;
    @SerializedName("breakdown")
    Breakdown breakdown;


    public static class Breakdown extends StripeObject {
      /** The aggregated discounts. */
      @SerializedName("discounts")
      List<Order.TotalDetails.Breakdown.Discount> discounts;
      /** The aggregated tax amounts by rate. */
      @SerializedName("taxes")
      List<Order.TotalDetails.Breakdown.Tax> taxes;


      public static class Discount extends StripeObject {
        /** The amount discounted. */
        @SerializedName("amount")
        Long amount;
        /**
         * A discount represents the actual application of a <a
         * href="https://stripe.com/docs/api#coupons">coupon</a> or <a
         * href="https://stripe.com/docs/api#promotion_codes">promotion code</a>. It contains
         * information about when the discount began, when it will end, and what it is applied to.
         *
         * <p>Related guide: <a
         * href="https://stripe.com/docs/billing/subscriptions/discounts">Applying Discounts to
         * Subscriptions</a>.
         */
        @SerializedName("discount")
        Discount discount;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getAmount() {
          return this.amount;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Discount getDiscount() {
          return this.discount;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAmount(final Long amount) {
          this.amount = amount;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setDiscount(final Discount discount) {
          this.discount = discount;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Order.TotalDetails.Breakdown.Discount)) return false;
          final Order.TotalDetails.Breakdown.Discount other = (Order.TotalDetails.Breakdown.Discount) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$amount = this.getAmount();
          final java.lang.Object other$amount = other.getAmount();
          if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
          final java.lang.Object this$discount = this.getDiscount();
          final java.lang.Object other$discount = other.getDiscount();
          if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Order.TotalDetails.Breakdown.Discount;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $amount = this.getAmount();
          result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
          final java.lang.Object $discount = this.getDiscount();
          result = result * PRIME + ($discount == null ? 43 : $discount.hashCode());
          return result;
        }
      }


      public static class Tax extends StripeObject {
        /** Amount of tax applied for this rate. */
        @SerializedName("amount")
        Long amount;
        /**
         * Tax rates can be applied to <a
         * href="https://stripe.com/docs/billing/invoices/tax-rates">invoices</a>, <a
         * href="https://stripe.com/docs/billing/subscriptions/taxes">subscriptions</a> and <a
         * href="https://stripe.com/docs/payments/checkout/set-up-a-subscription#tax-rates">Checkout
         * Sessions</a> to collect tax.
         *
         * <p>Related guide: <a href="https://stripe.com/docs/billing/taxes/tax-rates">Tax
         * Rates</a>.
         */
        @SerializedName("rate")
        TaxRate rate;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getAmount() {
          return this.amount;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public TaxRate getRate() {
          return this.rate;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAmount(final Long amount) {
          this.amount = amount;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setRate(final TaxRate rate) {
          this.rate = rate;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof Order.TotalDetails.Breakdown.Tax)) return false;
          final Order.TotalDetails.Breakdown.Tax other = (Order.TotalDetails.Breakdown.Tax) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$amount = this.getAmount();
          final java.lang.Object other$amount = other.getAmount();
          if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
          final java.lang.Object this$rate = this.getRate();
          final java.lang.Object other$rate = other.getRate();
          if (this$rate == null ? other$rate != null : !this$rate.equals(other$rate)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof Order.TotalDetails.Breakdown.Tax;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $amount = this.getAmount();
          result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
          final java.lang.Object $rate = this.getRate();
          result = result * PRIME + ($rate == null ? 43 : $rate.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Order.TotalDetails.Breakdown.Discount> getDiscounts() {
        return this.discounts;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<Order.TotalDetails.Breakdown.Tax> getTaxes() {
        return this.taxes;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDiscounts(final List<Order.TotalDetails.Breakdown.Discount> discounts) {
        this.discounts = discounts;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setTaxes(final List<Order.TotalDetails.Breakdown.Tax> taxes) {
        this.taxes = taxes;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Order.TotalDetails.Breakdown)) return false;
        final Order.TotalDetails.Breakdown other = (Order.TotalDetails.Breakdown) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$discounts = this.getDiscounts();
        final java.lang.Object other$discounts = other.getDiscounts();
        if (this$discounts == null ? other$discounts != null : !this$discounts.equals(other$discounts)) return false;
        final java.lang.Object this$taxes = this.getTaxes();
        final java.lang.Object other$taxes = other.getTaxes();
        if (this$taxes == null ? other$taxes != null : !this$taxes.equals(other$taxes)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Order.TotalDetails.Breakdown;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $discounts = this.getDiscounts();
        result = result * PRIME + ($discounts == null ? 43 : $discounts.hashCode());
        final java.lang.Object $taxes = this.getTaxes();
        result = result * PRIME + ($taxes == null ? 43 : $taxes.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountDiscount() {
      return this.amountDiscount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountShipping() {
      return this.amountShipping;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountTax() {
      return this.amountTax;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Breakdown getBreakdown() {
      return this.breakdown;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountDiscount(final Long amountDiscount) {
      this.amountDiscount = amountDiscount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountShipping(final Long amountShipping) {
      this.amountShipping = amountShipping;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountTax(final Long amountTax) {
      this.amountTax = amountTax;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBreakdown(final Breakdown breakdown) {
      this.breakdown = breakdown;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Order.TotalDetails)) return false;
      final Order.TotalDetails other = (Order.TotalDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amountDiscount = this.getAmountDiscount();
      final java.lang.Object other$amountDiscount = other.getAmountDiscount();
      if (this$amountDiscount == null ? other$amountDiscount != null : !this$amountDiscount.equals(other$amountDiscount)) return false;
      final java.lang.Object this$amountShipping = this.getAmountShipping();
      final java.lang.Object other$amountShipping = other.getAmountShipping();
      if (this$amountShipping == null ? other$amountShipping != null : !this$amountShipping.equals(other$amountShipping)) return false;
      final java.lang.Object this$amountTax = this.getAmountTax();
      final java.lang.Object other$amountTax = other.getAmountTax();
      if (this$amountTax == null ? other$amountTax != null : !this$amountTax.equals(other$amountTax)) return false;
      final java.lang.Object this$breakdown = this.getBreakdown();
      final java.lang.Object other$breakdown = other.getBreakdown();
      if (this$breakdown == null ? other$breakdown != null : !this$breakdown.equals(other$breakdown)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Order.TotalDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amountDiscount = this.getAmountDiscount();
      result = result * PRIME + ($amountDiscount == null ? 43 : $amountDiscount.hashCode());
      final java.lang.Object $amountShipping = this.getAmountShipping();
      result = result * PRIME + ($amountShipping == null ? 43 : $amountShipping.hashCode());
      final java.lang.Object $amountTax = this.getAmountTax();
      result = result * PRIME + ($amountTax == null ? 43 : $amountTax.hashCode());
      final java.lang.Object $breakdown = this.getBreakdown();
      result = result * PRIME + ($breakdown == null ? 43 : $breakdown.hashCode());
      return result;
    }
  }

  /**
   * Order cost before any discounts or taxes are applied. A positive integer representing the
   * subtotal of the order in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest
   * currency unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal
   * currency).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountSubtotal() {
    return this.amountSubtotal;
  }

  /**
   * Total order cost after discounts and taxes are applied. A positive integer representing the
   * cost of the order in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest
   * currency unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal
   * currency). To submit an order, the total must be either 0 or at least $0.50 USD or <a
   * href="https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts">equivalent in
   * charge currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountTotal() {
    return this.amountTotal;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AutomaticTax getAutomaticTax() {
    return this.automaticTax;
  }

  /**
   * Customer billing details associated with the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BillingDetails getBillingDetails() {
    return this.billingDetails;
  }

  /**
   * The client secret of this Order. Used for client-side retrieval using a publishable key.
   *
   * <p>The client secret can be used to complete a payment for an Order from your frontend. It
   * should not be stored, logged, embedded in URLs, or exposed to anyone other than the customer.
   * Make sure that you have TLS enabled on any page that includes the client secret.
   *
   * <p>Refer to our docs for <a
   * href="https://stripe.com/docs/orders-beta/create-and-process">creating and processing an
   * order</a> to learn about how client_secret should be handled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getClientSecret() {
    return this.clientSecret;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * A recent IP address of the purchaser used for tax reporting and tax location inference.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getIpAddress() {
    return this.ipAddress;
  }

  /**
   * A list of line items the customer is ordering. Each line item includes information about the
   * product, the quantity, and the resulting cost. There is a maximum of 100 line items.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LineItemCollection getLineItems() {
    return this.lineItems;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code order}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Payment getPayment() {
    return this.payment;
  }

  /**
   * The details of the customer cost of shipping, including the customer chosen ShippingRate.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ShippingCost getShippingCost() {
    return this.shippingCost;
  }

  /**
   * Customer shipping information associated with the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ShippingDetails getShippingDetails() {
    return this.shippingDetails;
  }

  /**
   * The overall status of the order.
   *
   * <p>One of {@code canceled}, {@code complete}, {@code open}, {@code processing}, or {@code
   * submitted}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TaxDetails getTaxDetails() {
    return this.taxDetails;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TotalDetails getTotalDetails() {
    return this.totalDetails;
  }

  /**
   * Order cost before any discounts or taxes are applied. A positive integer representing the
   * subtotal of the order in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest
   * currency unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal
   * currency).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountSubtotal(final Long amountSubtotal) {
    this.amountSubtotal = amountSubtotal;
  }

  /**
   * Total order cost after discounts and taxes are applied. A positive integer representing the
   * cost of the order in the <a href="https://stripe.com/docs/currencies#zero-decimal">smallest
   * currency unit</a> (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal
   * currency). To submit an order, the total must be either 0 or at least $0.50 USD or <a
   * href="https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts">equivalent in
   * charge currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountTotal(final Long amountTotal) {
    this.amountTotal = amountTotal;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAutomaticTax(final AutomaticTax automaticTax) {
    this.automaticTax = automaticTax;
  }

  /**
   * Customer billing details associated with the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingDetails(final BillingDetails billingDetails) {
    this.billingDetails = billingDetails;
  }

  /**
   * The client secret of this Order. Used for client-side retrieval using a publishable key.
   *
   * <p>The client secret can be used to complete a payment for an Order from your frontend. It
   * should not be stored, logged, embedded in URLs, or exposed to anyone other than the customer.
   * Make sure that you have TLS enabled on any page that includes the client secret.
   *
   * <p>Refer to our docs for <a
   * href="https://stripe.com/docs/orders-beta/create-and-process">creating and processing an
   * order</a> to learn about how client_secret should be handled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setClientSecret(final String clientSecret) {
    this.clientSecret = clientSecret;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * A recent IP address of the purchaser used for tax reporting and tax location inference.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIpAddress(final String ipAddress) {
    this.ipAddress = ipAddress;
  }

  /**
   * A list of line items the customer is ordering. Each line item includes information about the
   * product, the quantity, and the resulting cost. There is a maximum of 100 line items.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLineItems(final LineItemCollection lineItems) {
    this.lineItems = lineItems;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code order}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPayment(final Payment payment) {
    this.payment = payment;
  }

  /**
   * The details of the customer cost of shipping, including the customer chosen ShippingRate.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShippingCost(final ShippingCost shippingCost) {
    this.shippingCost = shippingCost;
  }

  /**
   * Customer shipping information associated with the order.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShippingDetails(final ShippingDetails shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  /**
   * The overall status of the order.
   *
   * <p>One of {@code canceled}, {@code complete}, {@code open}, {@code processing}, or {@code
   * submitted}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTaxDetails(final TaxDetails taxDetails) {
    this.taxDetails = taxDetails;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalDetails(final TotalDetails totalDetails) {
    this.totalDetails = totalDetails;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Order)) return false;
    final Order other = (Order) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amountSubtotal = this.getAmountSubtotal();
    final java.lang.Object other$amountSubtotal = other.getAmountSubtotal();
    if (this$amountSubtotal == null ? other$amountSubtotal != null : !this$amountSubtotal.equals(other$amountSubtotal)) return false;
    final java.lang.Object this$amountTotal = this.getAmountTotal();
    final java.lang.Object other$amountTotal = other.getAmountTotal();
    if (this$amountTotal == null ? other$amountTotal != null : !this$amountTotal.equals(other$amountTotal)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$application = this.getApplication();
    final java.lang.Object other$application = other.getApplication();
    if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
    final java.lang.Object this$automaticTax = this.getAutomaticTax();
    final java.lang.Object other$automaticTax = other.getAutomaticTax();
    if (this$automaticTax == null ? other$automaticTax != null : !this$automaticTax.equals(other$automaticTax)) return false;
    final java.lang.Object this$billingDetails = this.getBillingDetails();
    final java.lang.Object other$billingDetails = other.getBillingDetails();
    if (this$billingDetails == null ? other$billingDetails != null : !this$billingDetails.equals(other$billingDetails)) return false;
    final java.lang.Object this$clientSecret = this.getClientSecret();
    final java.lang.Object other$clientSecret = other.getClientSecret();
    if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customer = this.getCustomer();
    final java.lang.Object other$customer = other.getCustomer();
    if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$discounts = this.getDiscounts();
    final java.lang.Object other$discounts = other.getDiscounts();
    if (this$discounts == null ? other$discounts != null : !this$discounts.equals(other$discounts)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$ipAddress = this.getIpAddress();
    final java.lang.Object other$ipAddress = other.getIpAddress();
    if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) return false;
    final java.lang.Object this$lineItems = this.getLineItems();
    final java.lang.Object other$lineItems = other.getLineItems();
    if (this$lineItems == null ? other$lineItems != null : !this$lineItems.equals(other$lineItems)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$payment = this.getPayment();
    final java.lang.Object other$payment = other.getPayment();
    if (this$payment == null ? other$payment != null : !this$payment.equals(other$payment)) return false;
    final java.lang.Object this$shippingCost = this.getShippingCost();
    final java.lang.Object other$shippingCost = other.getShippingCost();
    if (this$shippingCost == null ? other$shippingCost != null : !this$shippingCost.equals(other$shippingCost)) return false;
    final java.lang.Object this$shippingDetails = this.getShippingDetails();
    final java.lang.Object other$shippingDetails = other.getShippingDetails();
    if (this$shippingDetails == null ? other$shippingDetails != null : !this$shippingDetails.equals(other$shippingDetails)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$taxDetails = this.getTaxDetails();
    final java.lang.Object other$taxDetails = other.getTaxDetails();
    if (this$taxDetails == null ? other$taxDetails != null : !this$taxDetails.equals(other$taxDetails)) return false;
    final java.lang.Object this$totalDetails = this.getTotalDetails();
    final java.lang.Object other$totalDetails = other.getTotalDetails();
    if (this$totalDetails == null ? other$totalDetails != null : !this$totalDetails.equals(other$totalDetails)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Order;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amountSubtotal = this.getAmountSubtotal();
    result = result * PRIME + ($amountSubtotal == null ? 43 : $amountSubtotal.hashCode());
    final java.lang.Object $amountTotal = this.getAmountTotal();
    result = result * PRIME + ($amountTotal == null ? 43 : $amountTotal.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $application = this.getApplication();
    result = result * PRIME + ($application == null ? 43 : $application.hashCode());
    final java.lang.Object $automaticTax = this.getAutomaticTax();
    result = result * PRIME + ($automaticTax == null ? 43 : $automaticTax.hashCode());
    final java.lang.Object $billingDetails = this.getBillingDetails();
    result = result * PRIME + ($billingDetails == null ? 43 : $billingDetails.hashCode());
    final java.lang.Object $clientSecret = this.getClientSecret();
    result = result * PRIME + ($clientSecret == null ? 43 : $clientSecret.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customer = this.getCustomer();
    result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $discounts = this.getDiscounts();
    result = result * PRIME + ($discounts == null ? 43 : $discounts.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $ipAddress = this.getIpAddress();
    result = result * PRIME + ($ipAddress == null ? 43 : $ipAddress.hashCode());
    final java.lang.Object $lineItems = this.getLineItems();
    result = result * PRIME + ($lineItems == null ? 43 : $lineItems.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $payment = this.getPayment();
    result = result * PRIME + ($payment == null ? 43 : $payment.hashCode());
    final java.lang.Object $shippingCost = this.getShippingCost();
    result = result * PRIME + ($shippingCost == null ? 43 : $shippingCost.hashCode());
    final java.lang.Object $shippingDetails = this.getShippingDetails();
    result = result * PRIME + ($shippingDetails == null ? 43 : $shippingDetails.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $taxDetails = this.getTaxDetails();
    result = result * PRIME + ($taxDetails == null ? 43 : $taxDetails.hashCode());
    final java.lang.Object $totalDetails = this.getTotalDetails();
    result = result * PRIME + ($totalDetails == null ? 43 : $totalDetails.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
