// Generated by delombok at Thu Aug 11 22:35:45 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.QuotePhaseListLineItemsParams;
import com.stripe.param.QuotePhaseRetrieveParams;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class QuotePhase extends ApiResource implements HasId {
  /**
   * Total before any discounts or taxes are applied.
   */
  @SerializedName("amount_subtotal")
  Long amountSubtotal;
  /**
   * Total after discounts and taxes are applied.
   */
  @SerializedName("amount_total")
  Long amountTotal;
  /**
   * If set to {@code reset}, the billing_cycle_anchor of the subscription is set to the start of
   * the phase when entering the phase. If unset, then the billing cycle anchor is automatically
   * modified as needed when entering the phase. For more information, see the billing cycle <a
   * href="https://stripe.com/docs/billing/subscriptions/billing-cycle">documentation</a>.
   *
   * <p>Equal to {@code reset}.
   */
  @SerializedName("billing_cycle_anchor")
  String billingCycleAnchor;
  /**
   * Either {@code charge_automatically}, or {@code send_invoice}. When charging automatically,
   * Stripe will attempt to pay the underlying subscription at the end of each billing cycle using
   * the default source attached to the customer. When sending an invoice, Stripe will email your
   * customer an invoice with payment instructions.
   *
   * <p>One of {@code charge_automatically}, or {@code send_invoice}.
   */
  @SerializedName("collection_method")
  String collectionMethod;
  /**
   * The default tax rates to apply to the subscription during this phase of the quote.
   */
  @SerializedName("default_tax_rates")
  List<ExpandableField<TaxRate>> defaultTaxRates;
  /**
   * The stackable discounts that will be applied to the subscription on this phase. Subscription
   * item discounts are applied before subscription discounts.
   */
  @SerializedName("discounts")
  List<ExpandableField<Discount>> discounts;
  /**
   * The end of this phase of the quote.
   */
  @SerializedName("end_date")
  Long endDate;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * The invoice settings applicable during this phase.
   */
  @SerializedName("invoice_settings")
  InvoiceSettings invoiceSettings;
  /**
   * Integer representing the multiplier applied to the price interval. For example, {@code
   * iterations=2} applied to a price with {@code interval=month} and {@code interval_count=3}
   * results in a phase of duration {@code 2 * 3 months = 6 months}.
   */
  @SerializedName("iterations")
  Long iterations;
  /**
   * A list of items the customer is being quoted for.
   */
  @SerializedName("line_items")
  LineItemCollection lineItems;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code quote_phase}.
   */
  @SerializedName("object")
  String object;
  /**
   * If the quote will prorate when transitioning to this phase. Possible values are {@code
   * create_prorations} and {@code none}.
   *
   * <p>One of {@code always_invoice}, {@code create_prorations}, or {@code none}.
   */
  @SerializedName("proration_behavior")
  String prorationBehavior;
  @SerializedName("total_details")
  TotalDetails totalDetails;
  /**
   * If set to true the entire phase is counted as a trial and the customer will not be charged for
   * any recurring fees.
   */
  @SerializedName("trial")
  Boolean trial;
  /**
   * When the trial ends within the phase.
   */
  @SerializedName("trial_end")
  Long trialEnd;

  /**
   * Get IDs of expandable {@code defaultTaxRates} object list.
   */
  public List<String> getDefaultTaxRates() {
    return (this.defaultTaxRates != null) ? this.defaultTaxRates.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
  }

  public void setDefaultTaxRates(List<String> ids) {
    if (ids == null) {
      this.defaultTaxRates = null;
      return;
    }
    if (this.defaultTaxRates != null && this.defaultTaxRates.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
      // noop if the ids are equal to what are already present
      return;
    }
    this.defaultTaxRates = (ids != null) ? ids.stream().map(id -> new ExpandableField<TaxRate>(id, null)).collect(Collectors.toList()) : null;
  }

  /**
   * Get expanded {@code defaultTaxRates}.
   */
  public List<TaxRate> getDefaultTaxRateObjects() {
    return (this.defaultTaxRates != null) ? this.defaultTaxRates.stream().map(x -> x.getExpanded()).collect(Collectors.toList()) : null;
  }

  public void setDefaultTaxRateObjects(List<TaxRate> objs) {
    this.defaultTaxRates = objs != null ? objs.stream().map(x -> new ExpandableField<TaxRate>(x.getId(), x)).collect(Collectors.toList()) : null;
  }

  /**
   * Get IDs of expandable {@code discounts} object list.
   */
  public List<String> getDiscounts() {
    return (this.discounts != null) ? this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
  }

  public void setDiscounts(List<String> ids) {
    if (ids == null) {
      this.discounts = null;
      return;
    }
    if (this.discounts != null && this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
      // noop if the ids are equal to what are already present
      return;
    }
    this.discounts = (ids != null) ? ids.stream().map(id -> new ExpandableField<Discount>(id, null)).collect(Collectors.toList()) : null;
  }

  /**
   * Get expanded {@code discounts}.
   */
  public List<Discount> getDiscountObjects() {
    return (this.discounts != null) ? this.discounts.stream().map(x -> x.getExpanded()).collect(Collectors.toList()) : null;
  }

  public void setDiscountObjects(List<Discount> objs) {
    this.discounts = objs != null ? objs.stream().map(x -> new ExpandableField<Discount>(x.getId(), x)).collect(Collectors.toList()) : null;
  }

  /**
   * Retrieves the quote phase with the given ID.
   */
  public static QuotePhase retrieve(String quotePhase) throws StripeException {
    return retrieve(quotePhase, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the quote phase with the given ID.
   */
  public static QuotePhase retrieve(String quotePhase, RequestOptions options) throws StripeException {
    return retrieve(quotePhase, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the quote phase with the given ID.
   */
  public static QuotePhase retrieve(String quotePhase, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/quote_phases/%s", ApiResource.urlEncodeId(quotePhase)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, QuotePhase.class, options);
  }

  /**
   * Retrieves the quote phase with the given ID.
   */
  public static QuotePhase retrieve(String quotePhase, QuotePhaseRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/quote_phases/%s", ApiResource.urlEncodeId(quotePhase)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, QuotePhase.class, options);
  }

  /**
   * When retrieving a quote phase, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems() throws StripeException {
    return listLineItems((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * When retrieving a quote phase, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems(Map<String, Object> params) throws StripeException {
    return listLineItems(params, (RequestOptions) null);
  }

  /**
   * When retrieving a quote phase, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/quote_phases/%s/line_items", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
  }

  /**
   * When retrieving a quote phase, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems(QuotePhaseListLineItemsParams params) throws StripeException {
    return listLineItems(params, (RequestOptions) null);
  }

  /**
   * When retrieving a quote phase, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems(QuotePhaseListLineItemsParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/quote_phases/%s/line_items", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
  }


  public static class InvoiceSettings extends StripeObject {
    /**
     * Number of days within which a customer must pay invoices generated by this subscription
     * schedule. This value will be {@code null} for subscription schedules where {@code
     * billing=charge_automatically}.
     */
    @SerializedName("days_until_due")
    Long daysUntilDue;

    /**
     * Number of days within which a customer must pay invoices generated by this subscription
     * schedule. This value will be {@code null} for subscription schedules where {@code
     * billing=charge_automatically}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDaysUntilDue() {
      return this.daysUntilDue;
    }

    /**
     * Number of days within which a customer must pay invoices generated by this subscription
     * schedule. This value will be {@code null} for subscription schedules where {@code
     * billing=charge_automatically}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDaysUntilDue(final Long daysUntilDue) {
      this.daysUntilDue = daysUntilDue;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof QuotePhase.InvoiceSettings)) return false;
      final QuotePhase.InvoiceSettings other = (QuotePhase.InvoiceSettings) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$daysUntilDue = this.getDaysUntilDue();
      final java.lang.Object other$daysUntilDue = other.getDaysUntilDue();
      if (this$daysUntilDue == null ? other$daysUntilDue != null : !this$daysUntilDue.equals(other$daysUntilDue)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof QuotePhase.InvoiceSettings;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $daysUntilDue = this.getDaysUntilDue();
      result = result * PRIME + ($daysUntilDue == null ? 43 : $daysUntilDue.hashCode());
      return result;
    }
  }


  public static class TotalDetails extends StripeObject {
    /** This is the sum of all the discounts. */
    @SerializedName("amount_discount")
    Long amountDiscount;
    /** This is the sum of all the shipping amounts. */
    @SerializedName("amount_shipping")
    Long amountShipping;
    /** This is the sum of all the tax amounts. */
    @SerializedName("amount_tax")
    Long amountTax;
    @SerializedName("breakdown")
    Breakdown breakdown;


    public static class Breakdown extends StripeObject {
      /** The aggregated discounts. */
      @SerializedName("discounts")
      List<LineItem.Discount> discounts;
      /** The aggregated tax amounts by rate. */
      @SerializedName("taxes")
      List<QuotePhase.TotalDetails.Breakdown.Tax> taxes;


      public static class Tax extends StripeObject {
        /** Amount of tax applied for this rate. */
        @SerializedName("amount")
        Long amount;
        /**
         * Tax rates can be applied to <a
         * href="https://stripe.com/docs/billing/invoices/tax-rates">invoices</a>, <a
         * href="https://stripe.com/docs/billing/subscriptions/taxes">subscriptions</a> and <a
         * href="https://stripe.com/docs/payments/checkout/set-up-a-subscription#tax-rates">Checkout
         * Sessions</a> to collect tax.
         *
         * <p>Related guide: <a href="https://stripe.com/docs/billing/taxes/tax-rates">Tax
         * Rates</a>.
         */
        @SerializedName("rate")
        TaxRate rate;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getAmount() {
          return this.amount;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public TaxRate getRate() {
          return this.rate;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAmount(final Long amount) {
          this.amount = amount;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setRate(final TaxRate rate) {
          this.rate = rate;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof QuotePhase.TotalDetails.Breakdown.Tax)) return false;
          final QuotePhase.TotalDetails.Breakdown.Tax other = (QuotePhase.TotalDetails.Breakdown.Tax) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$amount = this.getAmount();
          final java.lang.Object other$amount = other.getAmount();
          if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
          final java.lang.Object this$rate = this.getRate();
          final java.lang.Object other$rate = other.getRate();
          if (this$rate == null ? other$rate != null : !this$rate.equals(other$rate)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof QuotePhase.TotalDetails.Breakdown.Tax;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $amount = this.getAmount();
          result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
          final java.lang.Object $rate = this.getRate();
          result = result * PRIME + ($rate == null ? 43 : $rate.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<LineItem.Discount> getDiscounts() {
        return this.discounts;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<QuotePhase.TotalDetails.Breakdown.Tax> getTaxes() {
        return this.taxes;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setDiscounts(final List<LineItem.Discount> discounts) {
        this.discounts = discounts;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setTaxes(final List<QuotePhase.TotalDetails.Breakdown.Tax> taxes) {
        this.taxes = taxes;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof QuotePhase.TotalDetails.Breakdown)) return false;
        final QuotePhase.TotalDetails.Breakdown other = (QuotePhase.TotalDetails.Breakdown) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$discounts = this.getDiscounts();
        final java.lang.Object other$discounts = other.getDiscounts();
        if (this$discounts == null ? other$discounts != null : !this$discounts.equals(other$discounts)) return false;
        final java.lang.Object this$taxes = this.getTaxes();
        final java.lang.Object other$taxes = other.getTaxes();
        if (this$taxes == null ? other$taxes != null : !this$taxes.equals(other$taxes)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof QuotePhase.TotalDetails.Breakdown;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $discounts = this.getDiscounts();
        result = result * PRIME + ($discounts == null ? 43 : $discounts.hashCode());
        final java.lang.Object $taxes = this.getTaxes();
        result = result * PRIME + ($taxes == null ? 43 : $taxes.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountDiscount() {
      return this.amountDiscount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountShipping() {
      return this.amountShipping;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmountTax() {
      return this.amountTax;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Breakdown getBreakdown() {
      return this.breakdown;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountDiscount(final Long amountDiscount) {
      this.amountDiscount = amountDiscount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountShipping(final Long amountShipping) {
      this.amountShipping = amountShipping;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmountTax(final Long amountTax) {
      this.amountTax = amountTax;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBreakdown(final Breakdown breakdown) {
      this.breakdown = breakdown;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof QuotePhase.TotalDetails)) return false;
      final QuotePhase.TotalDetails other = (QuotePhase.TotalDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amountDiscount = this.getAmountDiscount();
      final java.lang.Object other$amountDiscount = other.getAmountDiscount();
      if (this$amountDiscount == null ? other$amountDiscount != null : !this$amountDiscount.equals(other$amountDiscount)) return false;
      final java.lang.Object this$amountShipping = this.getAmountShipping();
      final java.lang.Object other$amountShipping = other.getAmountShipping();
      if (this$amountShipping == null ? other$amountShipping != null : !this$amountShipping.equals(other$amountShipping)) return false;
      final java.lang.Object this$amountTax = this.getAmountTax();
      final java.lang.Object other$amountTax = other.getAmountTax();
      if (this$amountTax == null ? other$amountTax != null : !this$amountTax.equals(other$amountTax)) return false;
      final java.lang.Object this$breakdown = this.getBreakdown();
      final java.lang.Object other$breakdown = other.getBreakdown();
      if (this$breakdown == null ? other$breakdown != null : !this$breakdown.equals(other$breakdown)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof QuotePhase.TotalDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amountDiscount = this.getAmountDiscount();
      result = result * PRIME + ($amountDiscount == null ? 43 : $amountDiscount.hashCode());
      final java.lang.Object $amountShipping = this.getAmountShipping();
      result = result * PRIME + ($amountShipping == null ? 43 : $amountShipping.hashCode());
      final java.lang.Object $amountTax = this.getAmountTax();
      result = result * PRIME + ($amountTax == null ? 43 : $amountTax.hashCode());
      final java.lang.Object $breakdown = this.getBreakdown();
      result = result * PRIME + ($breakdown == null ? 43 : $breakdown.hashCode());
      return result;
    }
  }

  /**
   * Total before any discounts or taxes are applied.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountSubtotal() {
    return this.amountSubtotal;
  }

  /**
   * Total after discounts and taxes are applied.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmountTotal() {
    return this.amountTotal;
  }

  /**
   * If set to {@code reset}, the billing_cycle_anchor of the subscription is set to the start of
   * the phase when entering the phase. If unset, then the billing cycle anchor is automatically
   * modified as needed when entering the phase. For more information, see the billing cycle <a
   * href="https://stripe.com/docs/billing/subscriptions/billing-cycle">documentation</a>.
   *
   * <p>Equal to {@code reset}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBillingCycleAnchor() {
    return this.billingCycleAnchor;
  }

  /**
   * Either {@code charge_automatically}, or {@code send_invoice}. When charging automatically,
   * Stripe will attempt to pay the underlying subscription at the end of each billing cycle using
   * the default source attached to the customer. When sending an invoice, Stripe will email your
   * customer an invoice with payment instructions.
   *
   * <p>One of {@code charge_automatically}, or {@code send_invoice}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCollectionMethod() {
    return this.collectionMethod;
  }

  /**
   * The end of this phase of the quote.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getEndDate() {
    return this.endDate;
  }

  /**
   * The invoice settings applicable during this phase.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public InvoiceSettings getInvoiceSettings() {
    return this.invoiceSettings;
  }

  /**
   * Integer representing the multiplier applied to the price interval. For example, {@code
   * iterations=2} applied to a price with {@code interval=month} and {@code interval_count=3}
   * results in a phase of duration {@code 2 * 3 months = 6 months}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getIterations() {
    return this.iterations;
  }

  /**
   * A list of items the customer is being quoted for.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LineItemCollection getLineItems() {
    return this.lineItems;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code quote_phase}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * If the quote will prorate when transitioning to this phase. Possible values are {@code
   * create_prorations} and {@code none}.
   *
   * <p>One of {@code always_invoice}, {@code create_prorations}, or {@code none}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getProrationBehavior() {
    return this.prorationBehavior;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TotalDetails getTotalDetails() {
    return this.totalDetails;
  }

  /**
   * If set to true the entire phase is counted as a trial and the customer will not be charged for
   * any recurring fees.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getTrial() {
    return this.trial;
  }

  /**
   * When the trial ends within the phase.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getTrialEnd() {
    return this.trialEnd;
  }

  /**
   * Total before any discounts or taxes are applied.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountSubtotal(final Long amountSubtotal) {
    this.amountSubtotal = amountSubtotal;
  }

  /**
   * Total after discounts and taxes are applied.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmountTotal(final Long amountTotal) {
    this.amountTotal = amountTotal;
  }

  /**
   * If set to {@code reset}, the billing_cycle_anchor of the subscription is set to the start of
   * the phase when entering the phase. If unset, then the billing cycle anchor is automatically
   * modified as needed when entering the phase. For more information, see the billing cycle <a
   * href="https://stripe.com/docs/billing/subscriptions/billing-cycle">documentation</a>.
   *
   * <p>Equal to {@code reset}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingCycleAnchor(final String billingCycleAnchor) {
    this.billingCycleAnchor = billingCycleAnchor;
  }

  /**
   * Either {@code charge_automatically}, or {@code send_invoice}. When charging automatically,
   * Stripe will attempt to pay the underlying subscription at the end of each billing cycle using
   * the default source attached to the customer. When sending an invoice, Stripe will email your
   * customer an invoice with payment instructions.
   *
   * <p>One of {@code charge_automatically}, or {@code send_invoice}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCollectionMethod(final String collectionMethod) {
    this.collectionMethod = collectionMethod;
  }

  /**
   * The end of this phase of the quote.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEndDate(final Long endDate) {
    this.endDate = endDate;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The invoice settings applicable during this phase.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setInvoiceSettings(final InvoiceSettings invoiceSettings) {
    this.invoiceSettings = invoiceSettings;
  }

  /**
   * Integer representing the multiplier applied to the price interval. For example, {@code
   * iterations=2} applied to a price with {@code interval=month} and {@code interval_count=3}
   * results in a phase of duration {@code 2 * 3 months = 6 months}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIterations(final Long iterations) {
    this.iterations = iterations;
  }

  /**
   * A list of items the customer is being quoted for.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLineItems(final LineItemCollection lineItems) {
    this.lineItems = lineItems;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code quote_phase}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * If the quote will prorate when transitioning to this phase. Possible values are {@code
   * create_prorations} and {@code none}.
   *
   * <p>One of {@code always_invoice}, {@code create_prorations}, or {@code none}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProrationBehavior(final String prorationBehavior) {
    this.prorationBehavior = prorationBehavior;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalDetails(final TotalDetails totalDetails) {
    this.totalDetails = totalDetails;
  }

  /**
   * If set to true the entire phase is counted as a trial and the customer will not be charged for
   * any recurring fees.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTrial(final Boolean trial) {
    this.trial = trial;
  }

  /**
   * When the trial ends within the phase.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTrialEnd(final Long trialEnd) {
    this.trialEnd = trialEnd;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof QuotePhase)) return false;
    final QuotePhase other = (QuotePhase) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amountSubtotal = this.getAmountSubtotal();
    final java.lang.Object other$amountSubtotal = other.getAmountSubtotal();
    if (this$amountSubtotal == null ? other$amountSubtotal != null : !this$amountSubtotal.equals(other$amountSubtotal)) return false;
    final java.lang.Object this$amountTotal = this.getAmountTotal();
    final java.lang.Object other$amountTotal = other.getAmountTotal();
    if (this$amountTotal == null ? other$amountTotal != null : !this$amountTotal.equals(other$amountTotal)) return false;
    final java.lang.Object this$endDate = this.getEndDate();
    final java.lang.Object other$endDate = other.getEndDate();
    if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) return false;
    final java.lang.Object this$iterations = this.getIterations();
    final java.lang.Object other$iterations = other.getIterations();
    if (this$iterations == null ? other$iterations != null : !this$iterations.equals(other$iterations)) return false;
    final java.lang.Object this$trial = this.getTrial();
    final java.lang.Object other$trial = other.getTrial();
    if (this$trial == null ? other$trial != null : !this$trial.equals(other$trial)) return false;
    final java.lang.Object this$trialEnd = this.getTrialEnd();
    final java.lang.Object other$trialEnd = other.getTrialEnd();
    if (this$trialEnd == null ? other$trialEnd != null : !this$trialEnd.equals(other$trialEnd)) return false;
    final java.lang.Object this$billingCycleAnchor = this.getBillingCycleAnchor();
    final java.lang.Object other$billingCycleAnchor = other.getBillingCycleAnchor();
    if (this$billingCycleAnchor == null ? other$billingCycleAnchor != null : !this$billingCycleAnchor.equals(other$billingCycleAnchor)) return false;
    final java.lang.Object this$collectionMethod = this.getCollectionMethod();
    final java.lang.Object other$collectionMethod = other.getCollectionMethod();
    if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) return false;
    final java.lang.Object this$defaultTaxRates = this.getDefaultTaxRates();
    final java.lang.Object other$defaultTaxRates = other.getDefaultTaxRates();
    if (this$defaultTaxRates == null ? other$defaultTaxRates != null : !this$defaultTaxRates.equals(other$defaultTaxRates)) return false;
    final java.lang.Object this$discounts = this.getDiscounts();
    final java.lang.Object other$discounts = other.getDiscounts();
    if (this$discounts == null ? other$discounts != null : !this$discounts.equals(other$discounts)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$invoiceSettings = this.getInvoiceSettings();
    final java.lang.Object other$invoiceSettings = other.getInvoiceSettings();
    if (this$invoiceSettings == null ? other$invoiceSettings != null : !this$invoiceSettings.equals(other$invoiceSettings)) return false;
    final java.lang.Object this$lineItems = this.getLineItems();
    final java.lang.Object other$lineItems = other.getLineItems();
    if (this$lineItems == null ? other$lineItems != null : !this$lineItems.equals(other$lineItems)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$prorationBehavior = this.getProrationBehavior();
    final java.lang.Object other$prorationBehavior = other.getProrationBehavior();
    if (this$prorationBehavior == null ? other$prorationBehavior != null : !this$prorationBehavior.equals(other$prorationBehavior)) return false;
    final java.lang.Object this$totalDetails = this.getTotalDetails();
    final java.lang.Object other$totalDetails = other.getTotalDetails();
    if (this$totalDetails == null ? other$totalDetails != null : !this$totalDetails.equals(other$totalDetails)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof QuotePhase;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amountSubtotal = this.getAmountSubtotal();
    result = result * PRIME + ($amountSubtotal == null ? 43 : $amountSubtotal.hashCode());
    final java.lang.Object $amountTotal = this.getAmountTotal();
    result = result * PRIME + ($amountTotal == null ? 43 : $amountTotal.hashCode());
    final java.lang.Object $endDate = this.getEndDate();
    result = result * PRIME + ($endDate == null ? 43 : $endDate.hashCode());
    final java.lang.Object $iterations = this.getIterations();
    result = result * PRIME + ($iterations == null ? 43 : $iterations.hashCode());
    final java.lang.Object $trial = this.getTrial();
    result = result * PRIME + ($trial == null ? 43 : $trial.hashCode());
    final java.lang.Object $trialEnd = this.getTrialEnd();
    result = result * PRIME + ($trialEnd == null ? 43 : $trialEnd.hashCode());
    final java.lang.Object $billingCycleAnchor = this.getBillingCycleAnchor();
    result = result * PRIME + ($billingCycleAnchor == null ? 43 : $billingCycleAnchor.hashCode());
    final java.lang.Object $collectionMethod = this.getCollectionMethod();
    result = result * PRIME + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
    final java.lang.Object $defaultTaxRates = this.getDefaultTaxRates();
    result = result * PRIME + ($defaultTaxRates == null ? 43 : $defaultTaxRates.hashCode());
    final java.lang.Object $discounts = this.getDiscounts();
    result = result * PRIME + ($discounts == null ? 43 : $discounts.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $invoiceSettings = this.getInvoiceSettings();
    result = result * PRIME + ($invoiceSettings == null ? 43 : $invoiceSettings.hashCode());
    final java.lang.Object $lineItems = this.getLineItems();
    result = result * PRIME + ($lineItems == null ? 43 : $lineItems.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $prorationBehavior = this.getProrationBehavior();
    result = result * PRIME + ($prorationBehavior == null ? 43 : $prorationBehavior.hashCode());
    final java.lang.Object $totalDetails = this.getTotalDetails();
    result = result * PRIME + ($totalDetails == null ? 43 : $totalDetails.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
