// Generated by delombok at Tue Aug 23 21:13:09 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PaymentLinkCreateParams;
import com.stripe.param.PaymentLinkListLineItemsParams;
import com.stripe.param.PaymentLinkListParams;
import com.stripe.param.PaymentLinkRetrieveParams;
import com.stripe.param.PaymentLinkUpdateParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * A payment link is a shareable URL that will take your customers to a hosted payment page. A
 * payment link can be shared and used multiple times.
 *
 * <p>When a customer opens a payment link it will open a new <a
 * href="https://stripe.com/docs/api/checkout/sessions">checkout session</a> to render the payment
 * page. You can use <a
 * href="https://stripe.com/docs/api/events/types#event_types-checkout.session.completed">checkout
 * session events</a> to track payments through payment links.
 *
 * <p>Related guide: <a href="https://stripe.com/docs/payments/payment-links/api">Payment Links
 * API</a>
 */
public class PaymentLink extends ApiResource implements HasId, MetadataStore<PaymentLink> {
  /**
   * Whether the payment link's {@code url} is active. If {@code false}, customers visiting the URL
   * will be shown a page saying that the link has been deactivated.
   */
  @SerializedName("active")
  Boolean active;
  @SerializedName("after_completion")
  AfterCompletion afterCompletion;
  /**
   * Whether user redeemable promotion codes are enabled.
   */
  @SerializedName("allow_promotion_codes")
  Boolean allowPromotionCodes;
  /**
   * The amount of the application fee (if any) that will be requested to be applied to the payment
   * and transferred to the application owner's Stripe account.
   */
  @SerializedName("application_fee_amount")
  Long applicationFeeAmount;
  /**
   * This represents the percentage of the subscription invoice subtotal that will be transferred to
   * the application owner's Stripe account.
   */
  @SerializedName("application_fee_percent")
  BigDecimal applicationFeePercent;
  @SerializedName("automatic_tax")
  AutomaticTax automaticTax;
  /**
   * Configuration for collecting the customer's billing address.
   *
   * <p>One of {@code auto}, or {@code required}.
   */
  @SerializedName("billing_address_collection")
  String billingAddressCollection;
  /**
   * When set, provides configuration to gather active consent from customers.
   */
  @SerializedName("consent_collection")
  ConsentCollection consentCollection;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * Configuration for Customer creation during checkout.
   *
   * <p>One of {@code always}, or {@code if_required}.
   */
  @SerializedName("customer_creation")
  String customerCreation;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * The line items representing what is being sold.
   */
  @SerializedName("line_items")
  LineItemCollection lineItems;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @SerializedName("metadata")
  Map<String, String> metadata;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code payment_link}.
   */
  @SerializedName("object")
  String object;
  /**
   * The account on behalf of which to charge. See the <a
   * href="https://support.stripe.com/questions/sending-invoices-on-behalf-of-connected-accounts">Connect
   * documentation</a> for details.
   */
  @SerializedName("on_behalf_of")
  ExpandableField<Account> onBehalfOf;
  /**
   * Indicates the parameters to be passed to PaymentIntent creation during checkout.
   */
  @SerializedName("payment_intent_data")
  PaymentIntentData paymentIntentData;
  /**
   * Configuration for collecting a payment method during checkout.
   *
   * <p>One of {@code always}, or {@code if_required}.
   */
  @SerializedName("payment_method_collection")
  String paymentMethodCollection;
  /**
   * The list of payment method types that customers can use. When {@code null}, Stripe will
   * dynamically show relevant payment methods you've enabled in your <a
   * href="https://dashboard.stripe.com/settings/payment_methods">payment method settings</a>.
   */
  @SerializedName("payment_method_types")
  List<String> paymentMethodTypes;
  @SerializedName("phone_number_collection")
  PhoneNumberCollection phoneNumberCollection;
  /**
   * Configuration for collecting the customer's shipping address.
   */
  @SerializedName("shipping_address_collection")
  ShippingAddressCollection shippingAddressCollection;
  /**
   * The shipping rate options applied to the session.
   */
  @SerializedName("shipping_options")
  List<PaymentLink.ShippingOption> shippingOptions;
  /**
   * Indicates the type of transaction being performed which customizes relevant text on the page,
   * such as the submit button.
   *
   * <p>One of {@code auto}, {@code book}, {@code donate}, or {@code pay}.
   */
  @SerializedName("submit_type")
  String submitType;
  /**
   * When creating a subscription, the specified configuration data will be used. There must be at
   * least one line item with a recurring price to use {@code subscription_data}.
   */
  @SerializedName("subscription_data")
  SubscriptionData subscriptionData;
  @SerializedName("tax_id_collection")
  TaxIdCollection taxIdCollection;
  /**
   * The account (if any) the payments will be attributed to for tax reporting, and where funds from
   * each payment will be transferred to.
   */
  @SerializedName("transfer_data")
  TransferData transferData;
  /**
   * The public URL that can be shared with customers.
   */
  @SerializedName("url")
  String url;

  /**
   * Get ID of expandable {@code onBehalfOf} object.
   */
  public String getOnBehalfOf() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getId() : null;
  }

  public void setOnBehalfOf(String id) {
    this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
  }

  /**
   * Get expanded {@code onBehalfOf}.
   */
  public Account getOnBehalfOfObject() {
    return (this.onBehalfOf != null) ? this.onBehalfOf.getExpanded() : null;
  }

  public void setOnBehalfOfObject(Account expandableObject) {
    this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
  }

  /**
   * Creates a payment link.
   */
  public static PaymentLink create(Map<String, Object> params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a payment link.
   */
  public static PaymentLink create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_links");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentLink.class, options);
  }

  /**
   * Creates a payment link.
   */
  public static PaymentLink create(PaymentLinkCreateParams params) throws StripeException {
    return create(params, (RequestOptions) null);
  }

  /**
   * Creates a payment link.
   */
  public static PaymentLink create(PaymentLinkCreateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_links");
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentLink.class, options);
  }

  /**
   * Returns a list of your payment links.
   */
  public static PaymentLinkCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your payment links.
   */
  public static PaymentLinkCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_links");
    return ApiResource.requestCollection(url, params, PaymentLinkCollection.class, options);
  }

  /**
   * Returns a list of your payment links.
   */
  public static PaymentLinkCollection list(PaymentLinkListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of your payment links.
   */
  public static PaymentLinkCollection list(PaymentLinkListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/payment_links");
    return ApiResource.requestCollection(url, params, PaymentLinkCollection.class, options);
  }

  /**
   * When retrieving a payment link, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems() throws StripeException {
    return listLineItems((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * When retrieving a payment link, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems(Map<String, Object> params) throws StripeException {
    return listLineItems(params, (RequestOptions) null);
  }

  /**
   * When retrieving a payment link, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s/line_items", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
  }

  /**
   * When retrieving a payment link, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems(PaymentLinkListLineItemsParams params) throws StripeException {
    return listLineItems(params, (RequestOptions) null);
  }

  /**
   * When retrieving a payment link, there is an includable <strong>line_items</strong> property
   * containing the first handful of those items. There is also a URL where you can retrieve the
   * full (paginated) list of line items.
   */
  public LineItemCollection listLineItems(PaymentLinkListLineItemsParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s/line_items", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, LineItemCollection.class, options);
  }

  /**
   * Retrieve a payment link.
   */
  public static PaymentLink retrieve(String paymentLink) throws StripeException {
    return retrieve(paymentLink, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieve a payment link.
   */
  public static PaymentLink retrieve(String paymentLink, RequestOptions options) throws StripeException {
    return retrieve(paymentLink, (Map<String, Object>) null, options);
  }

  /**
   * Retrieve a payment link.
   */
  public static PaymentLink retrieve(String paymentLink, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(paymentLink)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentLink.class, options);
  }

  /**
   * Retrieve a payment link.
   */
  public static PaymentLink retrieve(String paymentLink, PaymentLinkRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(paymentLink)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, PaymentLink.class, options);
  }

  /**
   * Updates a payment link.
   */
  @Override
  public PaymentLink update(Map<String, Object> params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a payment link.
   */
  @Override
  public PaymentLink update(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentLink.class, options);
  }

  /**
   * Updates a payment link.
   */
  public PaymentLink update(PaymentLinkUpdateParams params) throws StripeException {
    return update(params, (RequestOptions) null);
  }

  /**
   * Updates a payment link.
   */
  public PaymentLink update(PaymentLinkUpdateParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/payment_links/%s", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, PaymentLink.class, options);
  }


  public static class AfterCompletion extends StripeObject {
    @SerializedName("hosted_confirmation")
    HostedConfirmation hostedConfirmation;
    @SerializedName("redirect")
    Redirect redirect;
    /**
     * The specified behavior after the purchase is complete.
     *
     * <p>One of {@code hosted_confirmation}, or {@code redirect}.
     */
    @SerializedName("type")
    String type;


    public static class HostedConfirmation extends StripeObject {
      /**
       * The custom message that is displayed to the customer after the purchase is complete.
       */
      @SerializedName("custom_message")
      String customMessage;

      /**
       * The custom message that is displayed to the customer after the purchase is complete.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getCustomMessage() {
        return this.customMessage;
      }

      /**
       * The custom message that is displayed to the customer after the purchase is complete.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setCustomMessage(final String customMessage) {
        this.customMessage = customMessage;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentLink.AfterCompletion.HostedConfirmation)) return false;
        final PaymentLink.AfterCompletion.HostedConfirmation other = (PaymentLink.AfterCompletion.HostedConfirmation) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$customMessage = this.getCustomMessage();
        final java.lang.Object other$customMessage = other.getCustomMessage();
        if (this$customMessage == null ? other$customMessage != null : !this$customMessage.equals(other$customMessage)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentLink.AfterCompletion.HostedConfirmation;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $customMessage = this.getCustomMessage();
        result = result * PRIME + ($customMessage == null ? 43 : $customMessage.hashCode());
        return result;
      }
    }


    public static class Redirect extends StripeObject {
      @SerializedName("url")
      String url;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getUrl() {
        return this.url;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setUrl(final String url) {
        this.url = url;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaymentLink.AfterCompletion.Redirect)) return false;
        final PaymentLink.AfterCompletion.Redirect other = (PaymentLink.AfterCompletion.Redirect) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$url = this.getUrl();
        final java.lang.Object other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaymentLink.AfterCompletion.Redirect;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $url = this.getUrl();
        result = result * PRIME + ($url == null ? 43 : $url.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HostedConfirmation getHostedConfirmation() {
      return this.hostedConfirmation;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Redirect getRedirect() {
      return this.redirect;
    }

    /**
     * The specified behavior after the purchase is complete.
     *
     * <p>One of {@code hosted_confirmation}, or {@code redirect}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setHostedConfirmation(final HostedConfirmation hostedConfirmation) {
      this.hostedConfirmation = hostedConfirmation;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRedirect(final Redirect redirect) {
      this.redirect = redirect;
    }

    /**
     * The specified behavior after the purchase is complete.
     *
     * <p>One of {@code hosted_confirmation}, or {@code redirect}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentLink.AfterCompletion)) return false;
      final PaymentLink.AfterCompletion other = (PaymentLink.AfterCompletion) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$hostedConfirmation = this.getHostedConfirmation();
      final java.lang.Object other$hostedConfirmation = other.getHostedConfirmation();
      if (this$hostedConfirmation == null ? other$hostedConfirmation != null : !this$hostedConfirmation.equals(other$hostedConfirmation)) return false;
      final java.lang.Object this$redirect = this.getRedirect();
      final java.lang.Object other$redirect = other.getRedirect();
      if (this$redirect == null ? other$redirect != null : !this$redirect.equals(other$redirect)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentLink.AfterCompletion;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $hostedConfirmation = this.getHostedConfirmation();
      result = result * PRIME + ($hostedConfirmation == null ? 43 : $hostedConfirmation.hashCode());
      final java.lang.Object $redirect = this.getRedirect();
      result = result * PRIME + ($redirect == null ? 43 : $redirect.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }


  /**
   * The URL the customer will be redirected to after the purchase is complete.
   */
  public static class AutomaticTax extends StripeObject {
    /**
     * If {@code true}, tax will be calculated automatically using the customer's location.
     */
    @SerializedName("enabled")
    Boolean enabled;

    /**
     * If {@code true}, tax will be calculated automatically using the customer's location.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getEnabled() {
      return this.enabled;
    }

    /**
     * If {@code true}, tax will be calculated automatically using the customer's location.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEnabled(final Boolean enabled) {
      this.enabled = enabled;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentLink.AutomaticTax)) return false;
      final PaymentLink.AutomaticTax other = (PaymentLink.AutomaticTax) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$enabled = this.getEnabled();
      final java.lang.Object other$enabled = other.getEnabled();
      if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentLink.AutomaticTax;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $enabled = this.getEnabled();
      result = result * PRIME + ($enabled == null ? 43 : $enabled.hashCode());
      return result;
    }
  }


  public static class ConsentCollection extends StripeObject {
    /**
     * If set to {@code auto}, enables the collection of customer consent for promotional
     * communications.
     *
     * <p>One of {@code auto}, or {@code none}.
     */
    @SerializedName("promotions")
    String promotions;

    /**
     * If set to {@code auto}, enables the collection of customer consent for promotional
     * communications.
     *
     * <p>One of {@code auto}, or {@code none}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPromotions() {
      return this.promotions;
    }

    /**
     * If set to {@code auto}, enables the collection of customer consent for promotional
     * communications.
     *
     * <p>One of {@code auto}, or {@code none}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPromotions(final String promotions) {
      this.promotions = promotions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentLink.ConsentCollection)) return false;
      final PaymentLink.ConsentCollection other = (PaymentLink.ConsentCollection) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$promotions = this.getPromotions();
      final java.lang.Object other$promotions = other.getPromotions();
      if (this$promotions == null ? other$promotions != null : !this$promotions.equals(other$promotions)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentLink.ConsentCollection;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $promotions = this.getPromotions();
      result = result * PRIME + ($promotions == null ? 43 : $promotions.hashCode());
      return result;
    }
  }


  public static class PaymentIntentData extends StripeObject {
    /**
     * Indicates when the funds will be captured from the customer's account.
     *
     * <p>One of {@code automatic}, or {@code manual}.
     */
    @SerializedName("capture_method")
    String captureMethod;
    /**
     * Indicates that you intend to make future payments with the payment method collected during
     * checkout.
     *
     * <p>One of {@code off_session}, or {@code on_session}.
     */
    @SerializedName("setup_future_usage")
    String setupFutureUsage;

    /**
     * Indicates when the funds will be captured from the customer's account.
     *
     * <p>One of {@code automatic}, or {@code manual}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCaptureMethod() {
      return this.captureMethod;
    }

    /**
     * Indicates that you intend to make future payments with the payment method collected during
     * checkout.
     *
     * <p>One of {@code off_session}, or {@code on_session}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSetupFutureUsage() {
      return this.setupFutureUsage;
    }

    /**
     * Indicates when the funds will be captured from the customer's account.
     *
     * <p>One of {@code automatic}, or {@code manual}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCaptureMethod(final String captureMethod) {
      this.captureMethod = captureMethod;
    }

    /**
     * Indicates that you intend to make future payments with the payment method collected during
     * checkout.
     *
     * <p>One of {@code off_session}, or {@code on_session}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSetupFutureUsage(final String setupFutureUsage) {
      this.setupFutureUsage = setupFutureUsage;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentLink.PaymentIntentData)) return false;
      final PaymentLink.PaymentIntentData other = (PaymentLink.PaymentIntentData) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$captureMethod = this.getCaptureMethod();
      final java.lang.Object other$captureMethod = other.getCaptureMethod();
      if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) return false;
      final java.lang.Object this$setupFutureUsage = this.getSetupFutureUsage();
      final java.lang.Object other$setupFutureUsage = other.getSetupFutureUsage();
      if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentLink.PaymentIntentData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $captureMethod = this.getCaptureMethod();
      result = result * PRIME + ($captureMethod == null ? 43 : $captureMethod.hashCode());
      final java.lang.Object $setupFutureUsage = this.getSetupFutureUsage();
      result = result * PRIME + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
      return result;
    }
  }


  public static class PhoneNumberCollection extends StripeObject {
    /**
     * If {@code true}, a phone number will be collected during checkout.
     */
    @SerializedName("enabled")
    Boolean enabled;

    /**
     * If {@code true}, a phone number will be collected during checkout.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getEnabled() {
      return this.enabled;
    }

    /**
     * If {@code true}, a phone number will be collected during checkout.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEnabled(final Boolean enabled) {
      this.enabled = enabled;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentLink.PhoneNumberCollection)) return false;
      final PaymentLink.PhoneNumberCollection other = (PaymentLink.PhoneNumberCollection) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$enabled = this.getEnabled();
      final java.lang.Object other$enabled = other.getEnabled();
      if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentLink.PhoneNumberCollection;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $enabled = this.getEnabled();
      result = result * PRIME + ($enabled == null ? 43 : $enabled.hashCode());
      return result;
    }
  }


  public static class ShippingAddressCollection extends StripeObject {
    /**
     * An array of two-letter ISO country codes representing which countries Checkout should provide
     * as options for shipping locations. Unsupported country codes: {@code AS, CX, CC, CU, HM, IR,
     * KP, MH, FM, NF, MP, PW, SD, SY, UM, VI}.
     */
    @SerializedName("allowed_countries")
    List<String> allowedCountries;

    /**
     * An array of two-letter ISO country codes representing which countries Checkout should provide
     * as options for shipping locations. Unsupported country codes: {@code AS, CX, CC, CU, HM, IR,
     * KP, MH, FM, NF, MP, PW, SD, SY, UM, VI}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getAllowedCountries() {
      return this.allowedCountries;
    }

    /**
     * An array of two-letter ISO country codes representing which countries Checkout should provide
     * as options for shipping locations. Unsupported country codes: {@code AS, CX, CC, CU, HM, IR,
     * KP, MH, FM, NF, MP, PW, SD, SY, UM, VI}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAllowedCountries(final List<String> allowedCountries) {
      this.allowedCountries = allowedCountries;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentLink.ShippingAddressCollection)) return false;
      final PaymentLink.ShippingAddressCollection other = (PaymentLink.ShippingAddressCollection) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$allowedCountries = this.getAllowedCountries();
      final java.lang.Object other$allowedCountries = other.getAllowedCountries();
      if (this$allowedCountries == null ? other$allowedCountries != null : !this$allowedCountries.equals(other$allowedCountries)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentLink.ShippingAddressCollection;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $allowedCountries = this.getAllowedCountries();
      result = result * PRIME + ($allowedCountries == null ? 43 : $allowedCountries.hashCode());
      return result;
    }
  }


  public static class ShippingOption extends StripeObject {
    /**
     * A non-negative integer in cents representing how much to charge.
     */
    @SerializedName("shipping_amount")
    Long shippingAmount;
    /**
     * The ID of the Shipping Rate to use for this shipping option.
     */
    @SerializedName("shipping_rate")
    ExpandableField<ShippingRate> shippingRate;

    /**
     * Get ID of expandable {@code shippingRate} object.
     */
    public String getShippingRate() {
      return (this.shippingRate != null) ? this.shippingRate.getId() : null;
    }

    public void setShippingRate(String id) {
      this.shippingRate = ApiResource.setExpandableFieldId(id, this.shippingRate);
    }

    /**
     * Get expanded {@code shippingRate}.
     */
    public ShippingRate getShippingRateObject() {
      return (this.shippingRate != null) ? this.shippingRate.getExpanded() : null;
    }

    public void setShippingRateObject(ShippingRate expandableObject) {
      this.shippingRate = new ExpandableField<ShippingRate>(expandableObject.getId(), expandableObject);
    }

    /**
     * A non-negative integer in cents representing how much to charge.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getShippingAmount() {
      return this.shippingAmount;
    }

    /**
     * A non-negative integer in cents representing how much to charge.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setShippingAmount(final Long shippingAmount) {
      this.shippingAmount = shippingAmount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentLink.ShippingOption)) return false;
      final PaymentLink.ShippingOption other = (PaymentLink.ShippingOption) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$shippingAmount = this.getShippingAmount();
      final java.lang.Object other$shippingAmount = other.getShippingAmount();
      if (this$shippingAmount == null ? other$shippingAmount != null : !this$shippingAmount.equals(other$shippingAmount)) return false;
      final java.lang.Object this$shippingRate = this.getShippingRate();
      final java.lang.Object other$shippingRate = other.getShippingRate();
      if (this$shippingRate == null ? other$shippingRate != null : !this$shippingRate.equals(other$shippingRate)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentLink.ShippingOption;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $shippingAmount = this.getShippingAmount();
      result = result * PRIME + ($shippingAmount == null ? 43 : $shippingAmount.hashCode());
      final java.lang.Object $shippingRate = this.getShippingRate();
      result = result * PRIME + ($shippingRate == null ? 43 : $shippingRate.hashCode());
      return result;
    }
  }


  public static class SubscriptionData extends StripeObject {
    /**
     * Integer representing the number of trial period days before the customer is charged for the
     * first time.
     */
    @SerializedName("trial_period_days")
    Long trialPeriodDays;

    /**
     * Integer representing the number of trial period days before the customer is charged for the
     * first time.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getTrialPeriodDays() {
      return this.trialPeriodDays;
    }

    /**
     * Integer representing the number of trial period days before the customer is charged for the
     * first time.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTrialPeriodDays(final Long trialPeriodDays) {
      this.trialPeriodDays = trialPeriodDays;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentLink.SubscriptionData)) return false;
      final PaymentLink.SubscriptionData other = (PaymentLink.SubscriptionData) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$trialPeriodDays = this.getTrialPeriodDays();
      final java.lang.Object other$trialPeriodDays = other.getTrialPeriodDays();
      if (this$trialPeriodDays == null ? other$trialPeriodDays != null : !this$trialPeriodDays.equals(other$trialPeriodDays)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentLink.SubscriptionData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $trialPeriodDays = this.getTrialPeriodDays();
      result = result * PRIME + ($trialPeriodDays == null ? 43 : $trialPeriodDays.hashCode());
      return result;
    }
  }


  public static class TaxIdCollection extends StripeObject {
    /**
     * Indicates whether tax ID collection is enabled for the session.
     */
    @SerializedName("enabled")
    Boolean enabled;

    /**
     * Indicates whether tax ID collection is enabled for the session.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getEnabled() {
      return this.enabled;
    }

    /**
     * Indicates whether tax ID collection is enabled for the session.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEnabled(final Boolean enabled) {
      this.enabled = enabled;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentLink.TaxIdCollection)) return false;
      final PaymentLink.TaxIdCollection other = (PaymentLink.TaxIdCollection) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$enabled = this.getEnabled();
      final java.lang.Object other$enabled = other.getEnabled();
      if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentLink.TaxIdCollection;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $enabled = this.getEnabled();
      result = result * PRIME + ($enabled == null ? 43 : $enabled.hashCode());
      return result;
    }
  }


  public static class TransferData extends StripeObject {
    /**
     * The amount in %s that will be transferred to the destination account. By default, the entire
     * amount is transferred to the destination.
     */
    @SerializedName("amount")
    Long amount;
    /** The connected account receiving the transfer. */
    @SerializedName("destination")
    ExpandableField<Account> destination;

    /** Get ID of expandable {@code destination} object. */
    public String getDestination() {
      return (this.destination != null) ? this.destination.getId() : null;
    }

    public void setDestination(String id) {
      this.destination = ApiResource.setExpandableFieldId(id, this.destination);
    }

    /** Get expanded {@code destination}. */
    public Account getDestinationObject() {
      return (this.destination != null) ? this.destination.getExpanded() : null;
    }

    public void setDestinationObject(Account expandableObject) {
      this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAmount() {
      return this.amount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAmount(final Long amount) {
      this.amount = amount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof PaymentLink.TransferData)) return false;
      final PaymentLink.TransferData other = (PaymentLink.TransferData) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$amount = this.getAmount();
      final java.lang.Object other$amount = other.getAmount();
      if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
      final java.lang.Object this$destination = this.getDestination();
      final java.lang.Object other$destination = other.getDestination();
      if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof PaymentLink.TransferData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $amount = this.getAmount();
      result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
      final java.lang.Object $destination = this.getDestination();
      result = result * PRIME + ($destination == null ? 43 : $destination.hashCode());
      return result;
    }
  }

  /**
   * Whether the payment link's {@code url} is active. If {@code false}, customers visiting the URL
   * will be shown a page saying that the link has been deactivated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getActive() {
    return this.active;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AfterCompletion getAfterCompletion() {
    return this.afterCompletion;
  }

  /**
   * Whether user redeemable promotion codes are enabled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getAllowPromotionCodes() {
    return this.allowPromotionCodes;
  }

  /**
   * The amount of the application fee (if any) that will be requested to be applied to the payment
   * and transferred to the application owner's Stripe account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getApplicationFeeAmount() {
    return this.applicationFeeAmount;
  }

  /**
   * This represents the percentage of the subscription invoice subtotal that will be transferred to
   * the application owner's Stripe account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getApplicationFeePercent() {
    return this.applicationFeePercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AutomaticTax getAutomaticTax() {
    return this.automaticTax;
  }

  /**
   * Configuration for collecting the customer's billing address.
   *
   * <p>One of {@code auto}, or {@code required}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getBillingAddressCollection() {
    return this.billingAddressCollection;
  }

  /**
   * When set, provides configuration to gather active consent from customers.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ConsentCollection getConsentCollection() {
    return this.consentCollection;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * Configuration for Customer creation during checkout.
   *
   * <p>One of {@code always}, or {@code if_required}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCustomerCreation() {
    return this.customerCreation;
  }

  /**
   * The line items representing what is being sold.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LineItemCollection getLineItems() {
    return this.lineItems;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code payment_link}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Indicates the parameters to be passed to PaymentIntent creation during checkout.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PaymentIntentData getPaymentIntentData() {
    return this.paymentIntentData;
  }

  /**
   * Configuration for collecting a payment method during checkout.
   *
   * <p>One of {@code always}, or {@code if_required}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPaymentMethodCollection() {
    return this.paymentMethodCollection;
  }

  /**
   * The list of payment method types that customers can use. When {@code null}, Stripe will
   * dynamically show relevant payment methods you've enabled in your <a
   * href="https://dashboard.stripe.com/settings/payment_methods">payment method settings</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getPaymentMethodTypes() {
    return this.paymentMethodTypes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PhoneNumberCollection getPhoneNumberCollection() {
    return this.phoneNumberCollection;
  }

  /**
   * Configuration for collecting the customer's shipping address.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ShippingAddressCollection getShippingAddressCollection() {
    return this.shippingAddressCollection;
  }

  /**
   * The shipping rate options applied to the session.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<PaymentLink.ShippingOption> getShippingOptions() {
    return this.shippingOptions;
  }

  /**
   * Indicates the type of transaction being performed which customizes relevant text on the page,
   * such as the submit button.
   *
   * <p>One of {@code auto}, {@code book}, {@code donate}, or {@code pay}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSubmitType() {
    return this.submitType;
  }

  /**
   * When creating a subscription, the specified configuration data will be used. There must be at
   * least one line item with a recurring price to use {@code subscription_data}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public SubscriptionData getSubscriptionData() {
    return this.subscriptionData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TaxIdCollection getTaxIdCollection() {
    return this.taxIdCollection;
  }

  /**
   * The account (if any) the payments will be attributed to for tax reporting, and where funds from
   * each payment will be transferred to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TransferData getTransferData() {
    return this.transferData;
  }

  /**
   * The public URL that can be shared with customers.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getUrl() {
    return this.url;
  }

  /**
   * Whether the payment link's {@code url} is active. If {@code false}, customers visiting the URL
   * will be shown a page saying that the link has been deactivated.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setActive(final Boolean active) {
    this.active = active;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAfterCompletion(final AfterCompletion afterCompletion) {
    this.afterCompletion = afterCompletion;
  }

  /**
   * Whether user redeemable promotion codes are enabled.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAllowPromotionCodes(final Boolean allowPromotionCodes) {
    this.allowPromotionCodes = allowPromotionCodes;
  }

  /**
   * The amount of the application fee (if any) that will be requested to be applied to the payment
   * and transferred to the application owner's Stripe account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApplicationFeeAmount(final Long applicationFeeAmount) {
    this.applicationFeeAmount = applicationFeeAmount;
  }

  /**
   * This represents the percentage of the subscription invoice subtotal that will be transferred to
   * the application owner's Stripe account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setApplicationFeePercent(final BigDecimal applicationFeePercent) {
    this.applicationFeePercent = applicationFeePercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAutomaticTax(final AutomaticTax automaticTax) {
    this.automaticTax = automaticTax;
  }

  /**
   * Configuration for collecting the customer's billing address.
   *
   * <p>One of {@code auto}, or {@code required}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingAddressCollection(final String billingAddressCollection) {
    this.billingAddressCollection = billingAddressCollection;
  }

  /**
   * When set, provides configuration to gather active consent from customers.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setConsentCollection(final ConsentCollection consentCollection) {
    this.consentCollection = consentCollection;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * Configuration for Customer creation during checkout.
   *
   * <p>One of {@code always}, or {@code if_required}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCustomerCreation(final String customerCreation) {
    this.customerCreation = customerCreation;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The line items representing what is being sold.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLineItems(final LineItemCollection lineItems) {
    this.lineItems = lineItems;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMetadata(final Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code payment_link}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Indicates the parameters to be passed to PaymentIntent creation during checkout.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentIntentData(final PaymentIntentData paymentIntentData) {
    this.paymentIntentData = paymentIntentData;
  }

  /**
   * Configuration for collecting a payment method during checkout.
   *
   * <p>One of {@code always}, or {@code if_required}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentMethodCollection(final String paymentMethodCollection) {
    this.paymentMethodCollection = paymentMethodCollection;
  }

  /**
   * The list of payment method types that customers can use. When {@code null}, Stripe will
   * dynamically show relevant payment methods you've enabled in your <a
   * href="https://dashboard.stripe.com/settings/payment_methods">payment method settings</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentMethodTypes(final List<String> paymentMethodTypes) {
    this.paymentMethodTypes = paymentMethodTypes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPhoneNumberCollection(final PhoneNumberCollection phoneNumberCollection) {
    this.phoneNumberCollection = phoneNumberCollection;
  }

  /**
   * Configuration for collecting the customer's shipping address.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShippingAddressCollection(final ShippingAddressCollection shippingAddressCollection) {
    this.shippingAddressCollection = shippingAddressCollection;
  }

  /**
   * The shipping rate options applied to the session.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setShippingOptions(final List<PaymentLink.ShippingOption> shippingOptions) {
    this.shippingOptions = shippingOptions;
  }

  /**
   * Indicates the type of transaction being performed which customizes relevant text on the page,
   * such as the submit button.
   *
   * <p>One of {@code auto}, {@code book}, {@code donate}, or {@code pay}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubmitType(final String submitType) {
    this.submitType = submitType;
  }

  /**
   * When creating a subscription, the specified configuration data will be used. There must be at
   * least one line item with a recurring price to use {@code subscription_data}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubscriptionData(final SubscriptionData subscriptionData) {
    this.subscriptionData = subscriptionData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTaxIdCollection(final TaxIdCollection taxIdCollection) {
    this.taxIdCollection = taxIdCollection;
  }

  /**
   * The account (if any) the payments will be attributed to for tax reporting, and where funds from
   * each payment will be transferred to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferData(final TransferData transferData) {
    this.transferData = transferData;
  }

  /**
   * The public URL that can be shared with customers.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setUrl(final String url) {
    this.url = url;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof PaymentLink)) return false;
    final PaymentLink other = (PaymentLink) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$active = this.getActive();
    final java.lang.Object other$active = other.getActive();
    if (this$active == null ? other$active != null : !this$active.equals(other$active)) return false;
    final java.lang.Object this$allowPromotionCodes = this.getAllowPromotionCodes();
    final java.lang.Object other$allowPromotionCodes = other.getAllowPromotionCodes();
    if (this$allowPromotionCodes == null ? other$allowPromotionCodes != null : !this$allowPromotionCodes.equals(other$allowPromotionCodes)) return false;
    final java.lang.Object this$applicationFeeAmount = this.getApplicationFeeAmount();
    final java.lang.Object other$applicationFeeAmount = other.getApplicationFeeAmount();
    if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !this$applicationFeeAmount.equals(other$applicationFeeAmount)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$afterCompletion = this.getAfterCompletion();
    final java.lang.Object other$afterCompletion = other.getAfterCompletion();
    if (this$afterCompletion == null ? other$afterCompletion != null : !this$afterCompletion.equals(other$afterCompletion)) return false;
    final java.lang.Object this$applicationFeePercent = this.getApplicationFeePercent();
    final java.lang.Object other$applicationFeePercent = other.getApplicationFeePercent();
    if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !this$applicationFeePercent.equals(other$applicationFeePercent)) return false;
    final java.lang.Object this$automaticTax = this.getAutomaticTax();
    final java.lang.Object other$automaticTax = other.getAutomaticTax();
    if (this$automaticTax == null ? other$automaticTax != null : !this$automaticTax.equals(other$automaticTax)) return false;
    final java.lang.Object this$billingAddressCollection = this.getBillingAddressCollection();
    final java.lang.Object other$billingAddressCollection = other.getBillingAddressCollection();
    if (this$billingAddressCollection == null ? other$billingAddressCollection != null : !this$billingAddressCollection.equals(other$billingAddressCollection)) return false;
    final java.lang.Object this$consentCollection = this.getConsentCollection();
    final java.lang.Object other$consentCollection = other.getConsentCollection();
    if (this$consentCollection == null ? other$consentCollection != null : !this$consentCollection.equals(other$consentCollection)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$customerCreation = this.getCustomerCreation();
    final java.lang.Object other$customerCreation = other.getCustomerCreation();
    if (this$customerCreation == null ? other$customerCreation != null : !this$customerCreation.equals(other$customerCreation)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$lineItems = this.getLineItems();
    final java.lang.Object other$lineItems = other.getLineItems();
    if (this$lineItems == null ? other$lineItems != null : !this$lineItems.equals(other$lineItems)) return false;
    final java.lang.Object this$metadata = this.getMetadata();
    final java.lang.Object other$metadata = other.getMetadata();
    if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$onBehalfOf = this.getOnBehalfOf();
    final java.lang.Object other$onBehalfOf = other.getOnBehalfOf();
    if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) return false;
    final java.lang.Object this$paymentIntentData = this.getPaymentIntentData();
    final java.lang.Object other$paymentIntentData = other.getPaymentIntentData();
    if (this$paymentIntentData == null ? other$paymentIntentData != null : !this$paymentIntentData.equals(other$paymentIntentData)) return false;
    final java.lang.Object this$paymentMethodCollection = this.getPaymentMethodCollection();
    final java.lang.Object other$paymentMethodCollection = other.getPaymentMethodCollection();
    if (this$paymentMethodCollection == null ? other$paymentMethodCollection != null : !this$paymentMethodCollection.equals(other$paymentMethodCollection)) return false;
    final java.lang.Object this$paymentMethodTypes = this.getPaymentMethodTypes();
    final java.lang.Object other$paymentMethodTypes = other.getPaymentMethodTypes();
    if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !this$paymentMethodTypes.equals(other$paymentMethodTypes)) return false;
    final java.lang.Object this$phoneNumberCollection = this.getPhoneNumberCollection();
    final java.lang.Object other$phoneNumberCollection = other.getPhoneNumberCollection();
    if (this$phoneNumberCollection == null ? other$phoneNumberCollection != null : !this$phoneNumberCollection.equals(other$phoneNumberCollection)) return false;
    final java.lang.Object this$shippingAddressCollection = this.getShippingAddressCollection();
    final java.lang.Object other$shippingAddressCollection = other.getShippingAddressCollection();
    if (this$shippingAddressCollection == null ? other$shippingAddressCollection != null : !this$shippingAddressCollection.equals(other$shippingAddressCollection)) return false;
    final java.lang.Object this$shippingOptions = this.getShippingOptions();
    final java.lang.Object other$shippingOptions = other.getShippingOptions();
    if (this$shippingOptions == null ? other$shippingOptions != null : !this$shippingOptions.equals(other$shippingOptions)) return false;
    final java.lang.Object this$submitType = this.getSubmitType();
    final java.lang.Object other$submitType = other.getSubmitType();
    if (this$submitType == null ? other$submitType != null : !this$submitType.equals(other$submitType)) return false;
    final java.lang.Object this$subscriptionData = this.getSubscriptionData();
    final java.lang.Object other$subscriptionData = other.getSubscriptionData();
    if (this$subscriptionData == null ? other$subscriptionData != null : !this$subscriptionData.equals(other$subscriptionData)) return false;
    final java.lang.Object this$taxIdCollection = this.getTaxIdCollection();
    final java.lang.Object other$taxIdCollection = other.getTaxIdCollection();
    if (this$taxIdCollection == null ? other$taxIdCollection != null : !this$taxIdCollection.equals(other$taxIdCollection)) return false;
    final java.lang.Object this$transferData = this.getTransferData();
    final java.lang.Object other$transferData = other.getTransferData();
    if (this$transferData == null ? other$transferData != null : !this$transferData.equals(other$transferData)) return false;
    final java.lang.Object this$url = this.getUrl();
    final java.lang.Object other$url = other.getUrl();
    if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof PaymentLink;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $active = this.getActive();
    result = result * PRIME + ($active == null ? 43 : $active.hashCode());
    final java.lang.Object $allowPromotionCodes = this.getAllowPromotionCodes();
    result = result * PRIME + ($allowPromotionCodes == null ? 43 : $allowPromotionCodes.hashCode());
    final java.lang.Object $applicationFeeAmount = this.getApplicationFeeAmount();
    result = result * PRIME + ($applicationFeeAmount == null ? 43 : $applicationFeeAmount.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $afterCompletion = this.getAfterCompletion();
    result = result * PRIME + ($afterCompletion == null ? 43 : $afterCompletion.hashCode());
    final java.lang.Object $applicationFeePercent = this.getApplicationFeePercent();
    result = result * PRIME + ($applicationFeePercent == null ? 43 : $applicationFeePercent.hashCode());
    final java.lang.Object $automaticTax = this.getAutomaticTax();
    result = result * PRIME + ($automaticTax == null ? 43 : $automaticTax.hashCode());
    final java.lang.Object $billingAddressCollection = this.getBillingAddressCollection();
    result = result * PRIME + ($billingAddressCollection == null ? 43 : $billingAddressCollection.hashCode());
    final java.lang.Object $consentCollection = this.getConsentCollection();
    result = result * PRIME + ($consentCollection == null ? 43 : $consentCollection.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $customerCreation = this.getCustomerCreation();
    result = result * PRIME + ($customerCreation == null ? 43 : $customerCreation.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $lineItems = this.getLineItems();
    result = result * PRIME + ($lineItems == null ? 43 : $lineItems.hashCode());
    final java.lang.Object $metadata = this.getMetadata();
    result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $onBehalfOf = this.getOnBehalfOf();
    result = result * PRIME + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
    final java.lang.Object $paymentIntentData = this.getPaymentIntentData();
    result = result * PRIME + ($paymentIntentData == null ? 43 : $paymentIntentData.hashCode());
    final java.lang.Object $paymentMethodCollection = this.getPaymentMethodCollection();
    result = result * PRIME + ($paymentMethodCollection == null ? 43 : $paymentMethodCollection.hashCode());
    final java.lang.Object $paymentMethodTypes = this.getPaymentMethodTypes();
    result = result * PRIME + ($paymentMethodTypes == null ? 43 : $paymentMethodTypes.hashCode());
    final java.lang.Object $phoneNumberCollection = this.getPhoneNumberCollection();
    result = result * PRIME + ($phoneNumberCollection == null ? 43 : $phoneNumberCollection.hashCode());
    final java.lang.Object $shippingAddressCollection = this.getShippingAddressCollection();
    result = result * PRIME + ($shippingAddressCollection == null ? 43 : $shippingAddressCollection.hashCode());
    final java.lang.Object $shippingOptions = this.getShippingOptions();
    result = result * PRIME + ($shippingOptions == null ? 43 : $shippingOptions.hashCode());
    final java.lang.Object $submitType = this.getSubmitType();
    result = result * PRIME + ($submitType == null ? 43 : $submitType.hashCode());
    final java.lang.Object $subscriptionData = this.getSubscriptionData();
    result = result * PRIME + ($subscriptionData == null ? 43 : $subscriptionData.hashCode());
    final java.lang.Object $taxIdCollection = this.getTaxIdCollection();
    result = result * PRIME + ($taxIdCollection == null ? 43 : $taxIdCollection.hashCode());
    final java.lang.Object $transferData = this.getTransferData();
    result = result * PRIME + ($transferData == null ? 43 : $transferData.hashCode());
    final java.lang.Object $url = this.getUrl();
    result = result * PRIME + ($url == null ? 43 : $url.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  /**
   * Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach
   * to an object. This can be useful for storing additional information about the object in a
   * structured format.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getMetadata() {
    return this.metadata;
  }
}
