// Generated by delombok at Tue Aug 23 21:13:09 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.financialconnections;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.financialconnections.AccountDisconnectParams;
import com.stripe.param.financialconnections.AccountListOwnersParams;
import com.stripe.param.financialconnections.AccountListParams;
import com.stripe.param.financialconnections.AccountRefreshParams;
import com.stripe.param.financialconnections.AccountRetrieveParams;
import java.util.List;
import java.util.Map;

/**
 * A Financial Connections Account represents an account that exists outside of Stripe, to which you
 * have been granted some degree of access.
 */
public class Account extends ApiResource implements HasId {
  /**
   * The account holder that this account belongs to.
   */
  @SerializedName("account_holder")
  AccountHolder accountHolder;
  /**
   * The most recent information about the account's balance.
   */
  @SerializedName("balance")
  Balance balance;
  /**
   * The state of the most recent attempt to refresh the account balance.
   */
  @SerializedName("balance_refresh")
  BalanceRefresh balanceRefresh;
  /**
   * The type of the account. Account category is further divided in {@code subcategory}.
   *
   * <p>One of {@code cash}, {@code credit}, {@code investment}, or {@code other}.
   */
  @SerializedName("category")
  String category;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * A human-readable name that has been assigned to this account, either by the account holder or
   * by the institution.
   */
  @SerializedName("display_name")
  String displayName;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  /**
   * The name of the institution that holds this account.
   */
  @SerializedName("institution_name")
  String institutionName;
  /**
   * The last 4 digits of the account number. If present, this will be 4 numeric characters.
   */
  @SerializedName("last4")
  String last4;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code financial_connections.account}.
   */
  @SerializedName("object")
  String object;
  /**
   * The most recent information about the account's owners.
   */
  @SerializedName("ownership")
  ExpandableField<AccountOwnership> ownership;
  /**
   * The state of the most recent attempt to refresh the account owners.
   */
  @SerializedName("ownership_refresh")
  OwnershipRefresh ownershipRefresh;
  /**
   * The list of permissions granted by this account.
   */
  @SerializedName("permissions")
  List<String> permissions;
  /**
   * The status of the link to the account.
   *
   * <p>One of {@code active}, {@code disconnected}, or {@code inactive}.
   */
  @SerializedName("status")
  String status;
  /**
   * If {@code category} is {@code cash}, one of:
   *
   * <p>- {@code checking} - {@code savings} - {@code other}
   *
   * <p>If {@code category} is {@code credit}, one of:
   *
   * <p>- {@code mortgage} - {@code line_of_credit} - {@code credit_card} - {@code other}
   *
   * <p>If {@code category} is {@code investment} or {@code other}, this will be {@code other}.
   */
  @SerializedName("subcategory")
  String subcategory;
  /**
   * The <a
   * href="https://stripe.com/docs/api/payment_methods/object#payment_method_object-type">PaymentMethod
   * type</a>(s) that can be created from this account.
   */
  @SerializedName("supported_payment_method_types")
  List<String> supportedPaymentMethodTypes;

  /**
   * Get ID of expandable {@code ownership} object.
   */
  public String getOwnership() {
    return (this.ownership != null) ? this.ownership.getId() : null;
  }

  public void setOwnership(String id) {
    this.ownership = ApiResource.setExpandableFieldId(id, this.ownership);
  }

  /**
   * Get expanded {@code ownership}.
   */
  public AccountOwnership getOwnershipObject() {
    return (this.ownership != null) ? this.ownership.getExpanded() : null;
  }

  public void setOwnershipObject(AccountOwnership expandableObject) {
    this.ownership = new ExpandableField<AccountOwnership>(expandableObject.getId(), expandableObject);
  }

  /**
   * Disables your access to a Financial Connections <code>Account</code>. You will no longer be
   * able to access data associated with the account (e.g. balances, transactions).
   */
  public com.stripe.model.financialconnections.Account disconnect() throws StripeException {
    return disconnect((Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Disables your access to a Financial Connections <code>Account</code>. You will no longer be
   * able to access data associated with the account (e.g. balances, transactions).
   */
  public com.stripe.model.financialconnections.Account disconnect(RequestOptions options) throws StripeException {
    return disconnect((Map<String, Object>) null, options);
  }

  /**
   * Disables your access to a Financial Connections <code>Account</code>. You will no longer be
   * able to access data associated with the account (e.g. balances, transactions).
   */
  public com.stripe.model.financialconnections.Account disconnect(Map<String, Object> params) throws StripeException {
    return disconnect(params, (RequestOptions) null);
  }

  /**
   * Disables your access to a Financial Connections <code>Account</code>. You will no longer be
   * able to access data associated with the account (e.g. balances, transactions).
   */
  public com.stripe.model.financialconnections.Account disconnect(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/financial_connections/accounts/%s/disconnect", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, com.stripe.model.financialconnections.Account.class, options);
  }

  /**
   * Disables your access to a Financial Connections <code>Account</code>. You will no longer be
   * able to access data associated with the account (e.g. balances, transactions).
   */
  public com.stripe.model.financialconnections.Account disconnect(AccountDisconnectParams params) throws StripeException {
    return disconnect(params, (RequestOptions) null);
  }

  /**
   * Disables your access to a Financial Connections <code>Account</code>. You will no longer be
   * able to access data associated with the account (e.g. balances, transactions).
   */
  public com.stripe.model.financialconnections.Account disconnect(AccountDisconnectParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/financial_connections/accounts/%s/disconnect", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, com.stripe.model.financialconnections.Account.class, options);
  }

  /**
   * Returns a list of Financial Connections <code>Account</code> objects.
   */
  public static AccountCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of Financial Connections <code>Account</code> objects.
   */
  public static AccountCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/financial_connections/accounts");
    return ApiResource.requestCollection(url, params, AccountCollection.class, options);
  }

  /**
   * Returns a list of Financial Connections <code>Account</code> objects.
   */
  public static AccountCollection list(AccountListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of Financial Connections <code>Account</code> objects.
   */
  public static AccountCollection list(AccountListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/financial_connections/accounts");
    return ApiResource.requestCollection(url, params, AccountCollection.class, options);
  }

  /**
   * Lists all owners for a given <code>Account</code>.
   */
  public AccountOwnerCollection listOwners(Map<String, Object> params) throws StripeException {
    return listOwners(params, (RequestOptions) null);
  }

  /**
   * Lists all owners for a given <code>Account</code>.
   */
  public AccountOwnerCollection listOwners(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/financial_connections/accounts/%s/owners", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, AccountOwnerCollection.class, options);
  }

  /**
   * Lists all owners for a given <code>Account</code>.
   */
  public AccountOwnerCollection listOwners(AccountListOwnersParams params) throws StripeException {
    return listOwners(params, (RequestOptions) null);
  }

  /**
   * Lists all owners for a given <code>Account</code>.
   */
  public AccountOwnerCollection listOwners(AccountListOwnersParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/financial_connections/accounts/%s/owners", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.requestCollection(url, params, AccountOwnerCollection.class, options);
  }

  /**
   * Refreshes the data associated with a Financial Connections <code>Account</code>.
   */
  public com.stripe.model.financialconnections.Account refresh(Map<String, Object> params) throws StripeException {
    return refresh(params, (RequestOptions) null);
  }

  /**
   * Refreshes the data associated with a Financial Connections <code>Account</code>.
   */
  public com.stripe.model.financialconnections.Account refresh(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/financial_connections/accounts/%s/refresh", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, com.stripe.model.financialconnections.Account.class, options);
  }

  /**
   * Refreshes the data associated with a Financial Connections <code>Account</code>.
   */
  public com.stripe.model.financialconnections.Account refresh(AccountRefreshParams params) throws StripeException {
    return refresh(params, (RequestOptions) null);
  }

  /**
   * Refreshes the data associated with a Financial Connections <code>Account</code>.
   */
  public com.stripe.model.financialconnections.Account refresh(AccountRefreshParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/financial_connections/accounts/%s/refresh", ApiResource.urlEncodeId(this.getId())));
    return ApiResource.request(ApiResource.RequestMethod.POST, url, params, com.stripe.model.financialconnections.Account.class, options);
  }

  /**
   * Retrieves the details of an Financial Connections <code>Account</code>.
   */
  public static com.stripe.model.financialconnections.Account retrieve(String account) throws StripeException {
    return retrieve(account, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an Financial Connections <code>Account</code>.
   */
  public static com.stripe.model.financialconnections.Account retrieve(String account, RequestOptions options) throws StripeException {
    return retrieve(account, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an Financial Connections <code>Account</code>.
   */
  public static com.stripe.model.financialconnections.Account retrieve(String account, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/financial_connections/accounts/%s", ApiResource.urlEncodeId(account)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, com.stripe.model.financialconnections.Account.class, options);
  }

  /**
   * Retrieves the details of an Financial Connections <code>Account</code>.
   */
  public static com.stripe.model.financialconnections.Account retrieve(String account, AccountRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/financial_connections/accounts/%s", ApiResource.urlEncodeId(account)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, com.stripe.model.financialconnections.Account.class, options);
  }


  public static class AccountHolder extends StripeObject {
    /**
     * The ID of the Stripe account this account belongs to. Should only be present if {@code
     * account_holder.type} is {@code account}.
     */
    @SerializedName("account")
    ExpandableField<com.stripe.model.Account> account;
    /**
     * ID of the Stripe customer this account belongs to. Present if and only if {@code
     * account_holder.type} is {@code customer}.
     */
    @SerializedName("customer")
    ExpandableField<Customer> customer;
    /**
     * Type of account holder that this account belongs to.
     *
     * <p>One of {@code account}, or {@code customer}.
     */
    @SerializedName("type")
    String type;

    /**
     * Get ID of expandable {@code account} object.
     */
    public String getAccount() {
      return (this.account != null) ? this.account.getId() : null;
    }

    public void setAccount(String id) {
      this.account = ApiResource.setExpandableFieldId(id, this.account);
    }

    /**
     * Get expanded {@code account}.
     */
    public com.stripe.model.Account getAccountObject() {
      return (this.account != null) ? this.account.getExpanded() : null;
    }

    public void setAccountObject(com.stripe.model.Account expandableObject) {
      this.account = new ExpandableField<com.stripe.model.Account>(expandableObject.getId(), expandableObject);
    }

    /**
     * Get ID of expandable {@code customer} object.
     */
    public String getCustomer() {
      return (this.customer != null) ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
      this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    /**
     * Get expanded {@code customer}.
     */
    public Customer getCustomerObject() {
      return (this.customer != null) ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
      this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    /**
     * Type of account holder that this account belongs to.
     *
     * <p>One of {@code account}, or {@code customer}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    /**
     * Type of account holder that this account belongs to.
     *
     * <p>One of {@code account}, or {@code customer}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.AccountHolder)) return false;
      final Account.AccountHolder other = (Account.AccountHolder) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$account = this.getAccount();
      final java.lang.Object other$account = other.getAccount();
      if (this$account == null ? other$account != null : !this$account.equals(other$account)) return false;
      final java.lang.Object this$customer = this.getCustomer();
      final java.lang.Object other$customer = other.getCustomer();
      if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.AccountHolder;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $account = this.getAccount();
      result = result * PRIME + ($account == null ? 43 : $account.hashCode());
      final java.lang.Object $customer = this.getCustomer();
      result = result * PRIME + ($customer == null ? 43 : $customer.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }


  public static class Balance extends StripeObject {
    /**
     * The time that the external institution calculated this balance. Measured in seconds since the
     * Unix epoch.
     */
    @SerializedName("as_of")
    Long asOf;
    @SerializedName("cash")
    CashBalance cash;
    @SerializedName("credit")
    CreditBalance credit;
    /**
     * The balances owed to (or by) the account holder.
     *
     * <p>Each key is a three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO
     * currency code</a>, in lowercase.
     *
     * <p>Each value is a integer amount. A positive amount indicates money owed to the account
     * holder. A negative amount indicates money owed by the account holder.
     */
    @SerializedName("current")
    Map<String, Long> current;
    /**
     * The {@code type} of the balance. An additional hash is included on the balance with a name
     * matching this value.
     *
     * <p>One of {@code cash}, or {@code credit}.
     */
    @SerializedName("type")
    String type;


    public static class CashBalance extends StripeObject {
      /**
       * The funds available to the account holder. Typically this is the current balance less any
       * holds.
       *
       * <p>Each key is a three-letter <a
       * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>, in
       * lowercase.
       *
       * <p>Each value is a integer amount. A positive amount indicates money owed to the account
       * holder. A negative amount indicates money owed by the account holder.
       */
      @SerializedName("available")
      Map<String, Long> available;

      /**
       * The funds available to the account holder. Typically this is the current balance less any
       * holds.
       *
       * <p>Each key is a three-letter <a
       * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>, in
       * lowercase.
       *
       * <p>Each value is a integer amount. A positive amount indicates money owed to the account
       * holder. A negative amount indicates money owed by the account holder.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Long> getAvailable() {
        return this.available;
      }

      /**
       * The funds available to the account holder. Typically this is the current balance less any
       * holds.
       *
       * <p>Each key is a three-letter <a
       * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>, in
       * lowercase.
       *
       * <p>Each value is a integer amount. A positive amount indicates money owed to the account
       * holder. A negative amount indicates money owed by the account holder.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAvailable(final Map<String, Long> available) {
        this.available = available;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Account.Balance.CashBalance)) return false;
        final Account.Balance.CashBalance other = (Account.Balance.CashBalance) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$available = this.getAvailable();
        final java.lang.Object other$available = other.getAvailable();
        if (this$available == null ? other$available != null : !this$available.equals(other$available)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Account.Balance.CashBalance;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $available = this.getAvailable();
        result = result * PRIME + ($available == null ? 43 : $available.hashCode());
        return result;
      }
    }


    public static class CreditBalance extends StripeObject {
      @SerializedName("used")
      Map<String, Long> used;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Map<String, Long> getUsed() {
        return this.used;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setUsed(final Map<String, Long> used) {
        this.used = used;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Account.Balance.CreditBalance)) return false;
        final Account.Balance.CreditBalance other = (Account.Balance.CreditBalance) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$used = this.getUsed();
        final java.lang.Object other$used = other.getUsed();
        if (this$used == null ? other$used != null : !this$used.equals(other$used)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Account.Balance.CreditBalance;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $used = this.getUsed();
        result = result * PRIME + ($used == null ? 43 : $used.hashCode());
        return result;
      }
    }

    /**
     * The time that the external institution calculated this balance. Measured in seconds since the
     * Unix epoch.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getAsOf() {
      return this.asOf;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CashBalance getCash() {
      return this.cash;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CreditBalance getCredit() {
      return this.credit;
    }

    /**
     * The balances owed to (or by) the account holder.
     *
     * <p>Each key is a three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO
     * currency code</a>, in lowercase.
     *
     * <p>Each value is a integer amount. A positive amount indicates money owed to the account
     * holder. A negative amount indicates money owed by the account holder.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Long> getCurrent() {
      return this.current;
    }

    /**
     * The {@code type} of the balance. An additional hash is included on the balance with a name
     * matching this value.
     *
     * <p>One of {@code cash}, or {@code credit}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    /**
     * The time that the external institution calculated this balance. Measured in seconds since the
     * Unix epoch.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAsOf(final Long asOf) {
      this.asOf = asOf;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCash(final CashBalance cash) {
      this.cash = cash;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCredit(final CreditBalance credit) {
      this.credit = credit;
    }

    /**
     * The balances owed to (or by) the account holder.
     *
     * <p>Each key is a three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO
     * currency code</a>, in lowercase.
     *
     * <p>Each value is a integer amount. A positive amount indicates money owed to the account
     * holder. A negative amount indicates money owed by the account holder.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCurrent(final Map<String, Long> current) {
      this.current = current;
    }

    /**
     * The {@code type} of the balance. An additional hash is included on the balance with a name
     * matching this value.
     *
     * <p>One of {@code cash}, or {@code credit}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.Balance)) return false;
      final Account.Balance other = (Account.Balance) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$asOf = this.getAsOf();
      final java.lang.Object other$asOf = other.getAsOf();
      if (this$asOf == null ? other$asOf != null : !this$asOf.equals(other$asOf)) return false;
      final java.lang.Object this$cash = this.getCash();
      final java.lang.Object other$cash = other.getCash();
      if (this$cash == null ? other$cash != null : !this$cash.equals(other$cash)) return false;
      final java.lang.Object this$credit = this.getCredit();
      final java.lang.Object other$credit = other.getCredit();
      if (this$credit == null ? other$credit != null : !this$credit.equals(other$credit)) return false;
      final java.lang.Object this$current = this.getCurrent();
      final java.lang.Object other$current = other.getCurrent();
      if (this$current == null ? other$current != null : !this$current.equals(other$current)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.Balance;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $asOf = this.getAsOf();
      result = result * PRIME + ($asOf == null ? 43 : $asOf.hashCode());
      final java.lang.Object $cash = this.getCash();
      result = result * PRIME + ($cash == null ? 43 : $cash.hashCode());
      final java.lang.Object $credit = this.getCredit();
      result = result * PRIME + ($credit == null ? 43 : $credit.hashCode());
      final java.lang.Object $current = this.getCurrent();
      result = result * PRIME + ($current == null ? 43 : $current.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }


  /**
   * The credit that has been used by the account holder.
   *
   * <p>Each key is a three-letter <a
   * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>, in
   * lowercase.
   *
   * <p>Each value is a integer amount. A positive amount indicates money owed to the account
   * holder. A negative amount indicates money owed by the account holder.
   */
  public static class BalanceRefresh extends StripeObject {
    /**
     * The time at which the last refresh attempt was initiated. Measured in seconds since the Unix
     * epoch.
     */
    @SerializedName("last_attempted_at")
    Long lastAttemptedAt;
    /**
     * The status of the last refresh attempt.
     *
     * <p>One of {@code failed}, {@code pending}, or {@code succeeded}.
     */
    @SerializedName("status")
    String status;

    /**
     * The time at which the last refresh attempt was initiated. Measured in seconds since the Unix
     * epoch.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLastAttemptedAt() {
      return this.lastAttemptedAt;
    }

    /**
     * The status of the last refresh attempt.
     *
     * <p>One of {@code failed}, {@code pending}, or {@code succeeded}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    /**
     * The time at which the last refresh attempt was initiated. Measured in seconds since the Unix
     * epoch.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLastAttemptedAt(final Long lastAttemptedAt) {
      this.lastAttemptedAt = lastAttemptedAt;
    }

    /**
     * The status of the last refresh attempt.
     *
     * <p>One of {@code failed}, {@code pending}, or {@code succeeded}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.BalanceRefresh)) return false;
      final Account.BalanceRefresh other = (Account.BalanceRefresh) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$lastAttemptedAt = this.getLastAttemptedAt();
      final java.lang.Object other$lastAttemptedAt = other.getLastAttemptedAt();
      if (this$lastAttemptedAt == null ? other$lastAttemptedAt != null : !this$lastAttemptedAt.equals(other$lastAttemptedAt)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.BalanceRefresh;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $lastAttemptedAt = this.getLastAttemptedAt();
      result = result * PRIME + ($lastAttemptedAt == null ? 43 : $lastAttemptedAt.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      return result;
    }
  }


  public static class OwnershipRefresh extends StripeObject {
    /**
     * The time at which the last refresh attempt was initiated. Measured in seconds since the Unix
     * epoch.
     */
    @SerializedName("last_attempted_at")
    Long lastAttemptedAt;
    /**
     * The status of the last refresh attempt.
     *
     * <p>One of {@code failed}, {@code pending}, or {@code succeeded}.
     */
    @SerializedName("status")
    String status;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLastAttemptedAt() {
      return this.lastAttemptedAt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
      return this.status;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLastAttemptedAt(final Long lastAttemptedAt) {
      this.lastAttemptedAt = lastAttemptedAt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStatus(final String status) {
      this.status = status;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof Account.OwnershipRefresh)) return false;
      final Account.OwnershipRefresh other = (Account.OwnershipRefresh) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$lastAttemptedAt = this.getLastAttemptedAt();
      final java.lang.Object other$lastAttemptedAt = other.getLastAttemptedAt();
      if (this$lastAttemptedAt == null ? other$lastAttemptedAt != null : !this$lastAttemptedAt.equals(other$lastAttemptedAt)) return false;
      final java.lang.Object this$status = this.getStatus();
      final java.lang.Object other$status = other.getStatus();
      if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof Account.OwnershipRefresh;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $lastAttemptedAt = this.getLastAttemptedAt();
      result = result * PRIME + ($lastAttemptedAt == null ? 43 : $lastAttemptedAt.hashCode());
      final java.lang.Object $status = this.getStatus();
      result = result * PRIME + ($status == null ? 43 : $status.hashCode());
      return result;
    }
  }

  /**
   * The account holder that this account belongs to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AccountHolder getAccountHolder() {
    return this.accountHolder;
  }

  /**
   * The most recent information about the account's balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Balance getBalance() {
    return this.balance;
  }

  /**
   * The state of the most recent attempt to refresh the account balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BalanceRefresh getBalanceRefresh() {
    return this.balanceRefresh;
  }

  /**
   * The type of the account. Account category is further divided in {@code subcategory}.
   *
   * <p>One of {@code cash}, {@code credit}, {@code investment}, or {@code other}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCategory() {
    return this.category;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * A human-readable name that has been assigned to this account, either by the account holder or
   * by the institution.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDisplayName() {
    return this.displayName;
  }

  /**
   * The name of the institution that holds this account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getInstitutionName() {
    return this.institutionName;
  }

  /**
   * The last 4 digits of the account number. If present, this will be 4 numeric characters.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getLast4() {
    return this.last4;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code financial_connections.account}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * The state of the most recent attempt to refresh the account owners.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public OwnershipRefresh getOwnershipRefresh() {
    return this.ownershipRefresh;
  }

  /**
   * The list of permissions granted by this account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getPermissions() {
    return this.permissions;
  }

  /**
   * The status of the link to the account.
   *
   * <p>One of {@code active}, {@code disconnected}, or {@code inactive}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * If {@code category} is {@code cash}, one of:
   *
   * <p>- {@code checking} - {@code savings} - {@code other}
   *
   * <p>If {@code category} is {@code credit}, one of:
   *
   * <p>- {@code mortgage} - {@code line_of_credit} - {@code credit_card} - {@code other}
   *
   * <p>If {@code category} is {@code investment} or {@code other}, this will be {@code other}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSubcategory() {
    return this.subcategory;
  }

  /**
   * The <a
   * href="https://stripe.com/docs/api/payment_methods/object#payment_method_object-type">PaymentMethod
   * type</a>(s) that can be created from this account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getSupportedPaymentMethodTypes() {
    return this.supportedPaymentMethodTypes;
  }

  /**
   * The account holder that this account belongs to.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAccountHolder(final AccountHolder accountHolder) {
    this.accountHolder = accountHolder;
  }

  /**
   * The most recent information about the account's balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBalance(final Balance balance) {
    this.balance = balance;
  }

  /**
   * The state of the most recent attempt to refresh the account balance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBalanceRefresh(final BalanceRefresh balanceRefresh) {
    this.balanceRefresh = balanceRefresh;
  }

  /**
   * The type of the account. Account category is further divided in {@code subcategory}.
   *
   * <p>One of {@code cash}, {@code credit}, {@code investment}, or {@code other}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCategory(final String category) {
    this.category = category;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * A human-readable name that has been assigned to this account, either by the account holder or
   * by the institution.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDisplayName(final String displayName) {
    this.displayName = displayName;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  /**
   * The name of the institution that holds this account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setInstitutionName(final String institutionName) {
    this.institutionName = institutionName;
  }

  /**
   * The last 4 digits of the account number. If present, this will be 4 numeric characters.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLast4(final String last4) {
    this.last4 = last4;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code financial_connections.account}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * The state of the most recent attempt to refresh the account owners.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOwnershipRefresh(final OwnershipRefresh ownershipRefresh) {
    this.ownershipRefresh = ownershipRefresh;
  }

  /**
   * The list of permissions granted by this account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPermissions(final List<String> permissions) {
    this.permissions = permissions;
  }

  /**
   * The status of the link to the account.
   *
   * <p>One of {@code active}, {@code disconnected}, or {@code inactive}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  /**
   * If {@code category} is {@code cash}, one of:
   *
   * <p>- {@code checking} - {@code savings} - {@code other}
   *
   * <p>If {@code category} is {@code credit}, one of:
   *
   * <p>- {@code mortgage} - {@code line_of_credit} - {@code credit_card} - {@code other}
   *
   * <p>If {@code category} is {@code investment} or {@code other}, this will be {@code other}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubcategory(final String subcategory) {
    this.subcategory = subcategory;
  }

  /**
   * The <a
   * href="https://stripe.com/docs/api/payment_methods/object#payment_method_object-type">PaymentMethod
   * type</a>(s) that can be created from this account.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSupportedPaymentMethodTypes(final List<String> supportedPaymentMethodTypes) {
    this.supportedPaymentMethodTypes = supportedPaymentMethodTypes;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Account)) return false;
    final Account other = (Account) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$accountHolder = this.getAccountHolder();
    final java.lang.Object other$accountHolder = other.getAccountHolder();
    if (this$accountHolder == null ? other$accountHolder != null : !this$accountHolder.equals(other$accountHolder)) return false;
    final java.lang.Object this$balance = this.getBalance();
    final java.lang.Object other$balance = other.getBalance();
    if (this$balance == null ? other$balance != null : !this$balance.equals(other$balance)) return false;
    final java.lang.Object this$balanceRefresh = this.getBalanceRefresh();
    final java.lang.Object other$balanceRefresh = other.getBalanceRefresh();
    if (this$balanceRefresh == null ? other$balanceRefresh != null : !this$balanceRefresh.equals(other$balanceRefresh)) return false;
    final java.lang.Object this$category = this.getCategory();
    final java.lang.Object other$category = other.getCategory();
    if (this$category == null ? other$category != null : !this$category.equals(other$category)) return false;
    final java.lang.Object this$displayName = this.getDisplayName();
    final java.lang.Object other$displayName = other.getDisplayName();
    if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$institutionName = this.getInstitutionName();
    final java.lang.Object other$institutionName = other.getInstitutionName();
    if (this$institutionName == null ? other$institutionName != null : !this$institutionName.equals(other$institutionName)) return false;
    final java.lang.Object this$last4 = this.getLast4();
    final java.lang.Object other$last4 = other.getLast4();
    if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$ownership = this.getOwnership();
    final java.lang.Object other$ownership = other.getOwnership();
    if (this$ownership == null ? other$ownership != null : !this$ownership.equals(other$ownership)) return false;
    final java.lang.Object this$ownershipRefresh = this.getOwnershipRefresh();
    final java.lang.Object other$ownershipRefresh = other.getOwnershipRefresh();
    if (this$ownershipRefresh == null ? other$ownershipRefresh != null : !this$ownershipRefresh.equals(other$ownershipRefresh)) return false;
    final java.lang.Object this$permissions = this.getPermissions();
    final java.lang.Object other$permissions = other.getPermissions();
    if (this$permissions == null ? other$permissions != null : !this$permissions.equals(other$permissions)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$subcategory = this.getSubcategory();
    final java.lang.Object other$subcategory = other.getSubcategory();
    if (this$subcategory == null ? other$subcategory != null : !this$subcategory.equals(other$subcategory)) return false;
    final java.lang.Object this$supportedPaymentMethodTypes = this.getSupportedPaymentMethodTypes();
    final java.lang.Object other$supportedPaymentMethodTypes = other.getSupportedPaymentMethodTypes();
    if (this$supportedPaymentMethodTypes == null ? other$supportedPaymentMethodTypes != null : !this$supportedPaymentMethodTypes.equals(other$supportedPaymentMethodTypes)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Account;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $accountHolder = this.getAccountHolder();
    result = result * PRIME + ($accountHolder == null ? 43 : $accountHolder.hashCode());
    final java.lang.Object $balance = this.getBalance();
    result = result * PRIME + ($balance == null ? 43 : $balance.hashCode());
    final java.lang.Object $balanceRefresh = this.getBalanceRefresh();
    result = result * PRIME + ($balanceRefresh == null ? 43 : $balanceRefresh.hashCode());
    final java.lang.Object $category = this.getCategory();
    result = result * PRIME + ($category == null ? 43 : $category.hashCode());
    final java.lang.Object $displayName = this.getDisplayName();
    result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $institutionName = this.getInstitutionName();
    result = result * PRIME + ($institutionName == null ? 43 : $institutionName.hashCode());
    final java.lang.Object $last4 = this.getLast4();
    result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $ownership = this.getOwnership();
    result = result * PRIME + ($ownership == null ? 43 : $ownership.hashCode());
    final java.lang.Object $ownershipRefresh = this.getOwnershipRefresh();
    result = result * PRIME + ($ownershipRefresh == null ? 43 : $ownershipRefresh.hashCode());
    final java.lang.Object $permissions = this.getPermissions();
    result = result * PRIME + ($permissions == null ? 43 : $permissions.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $subcategory = this.getSubcategory();
    result = result * PRIME + ($subcategory == null ? 43 : $subcategory.hashCode());
    final java.lang.Object $supportedPaymentMethodTypes = this.getSupportedPaymentMethodTypes();
    result = result * PRIME + ($supportedPaymentMethodTypes == null ? 43 : $supportedPaymentMethodTypes.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
