// Generated by delombok at Tue Aug 23 21:13:09 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.treasury.ReceivedDebitCreateParams;
import com.stripe.param.treasury.ReceivedDebitListParams;
import com.stripe.param.treasury.ReceivedDebitRetrieveParams;
import java.util.Map;

/**
 * ReceivedDebits represent funds pulled from a <a
 * href="https://stripe.com/docs/api#financial_accounts">FinancialAccount</a>. These are not
 * initiated from the FinancialAccount.
 */
public class ReceivedDebit extends ApiResource implements HasId {
  /**
   * Amount (in cents) transferred.
   */
  @SerializedName("amount")
  Long amount;
  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @SerializedName("created")
  Long created;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @SerializedName("description")
  String description;
  /**
   * Reason for the failure. A ReceivedDebit might fail because the FinancialAccount doesn't have
   * sufficient funds, is closed, or is frozen.
   *
   * <p>One of {@code account_closed}, {@code account_frozen}, {@code insufficient_funds}, or {@code
   * other}.
   */
  @SerializedName("failure_code")
  String failureCode;
  /**
   * The FinancialAccount that funds were pulled from.
   */
  @SerializedName("financial_account")
  String financialAccount;
  /**
   * A <a href="https://stripe.com/docs/treasury/moving-money/regulatory-receipts">hosted
   * transaction receipt</a> URL that is provided when money movement is considered regulated under
   * Stripe's money transmission licenses.
   */
  @SerializedName("hosted_regulatory_receipt_url")
  String hostedRegulatoryReceiptUrl;
  /**
   * Unique identifier for the object.
   */
  @SerializedName("id")
  String id;
  @SerializedName("initiating_payment_method_details")
  InitiatingPaymentMethodDetails initiatingPaymentMethodDetails;
  @SerializedName("linked_flows")
  LinkedFlows linkedFlows;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * The network used for the ReceivedDebit.
   *
   * <p>One of {@code ach}, {@code card}, or {@code stripe}.
   */
  @SerializedName("network")
  String network;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.received_debit}.
   */
  @SerializedName("object")
  String object;
  /**
   * Details describing when a ReceivedDebit might be reversed.
   */
  @SerializedName("reversal_details")
  ReversalDetails reversalDetails;
  /**
   * Status of the ReceivedDebit. ReceivedDebits are created with a status of either {@code
   * succeeded} (approved) or {@code failed} (declined). The failure reason can be found under the
   * {@code failure_code}.
   *
   * <p>One of {@code failed}, or {@code succeeded}.
   */
  @SerializedName("status")
  String status;
  /**
   * The Transaction associated with this object.
   */
  @SerializedName("transaction")
  ExpandableField<Transaction> transaction;

  /**
   * Get ID of expandable {@code transaction} object.
   */
  public String getTransaction() {
    return (this.transaction != null) ? this.transaction.getId() : null;
  }

  public void setTransaction(String id) {
    this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
  }

  /**
   * Get expanded {@code transaction}.
   */
  public Transaction getTransactionObject() {
    return (this.transaction != null) ? this.transaction.getExpanded() : null;
  }

  public void setTransactionObject(Transaction expandableObject) {
    this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
  }

  /**
   * Returns a list of ReceivedDebits.
   */
  public static ReceivedDebitCollection list(Map<String, Object> params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of ReceivedDebits.
   */
  public static ReceivedDebitCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/received_debits");
    return ApiResource.requestCollection(url, params, ReceivedDebitCollection.class, options);
  }

  /**
   * Returns a list of ReceivedDebits.
   */
  public static ReceivedDebitCollection list(ReceivedDebitListParams params) throws StripeException {
    return list(params, (RequestOptions) null);
  }

  /**
   * Returns a list of ReceivedDebits.
   */
  public static ReceivedDebitCollection list(ReceivedDebitListParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), "/v1/treasury/received_debits");
    return ApiResource.requestCollection(url, params, ReceivedDebitCollection.class, options);
  }

  /**
   * Retrieves the details of an existing ReceivedDebit by passing the unique ReceivedDebit ID from
   * the ReceivedDebit list.
   */
  public static ReceivedDebit retrieve(String id) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, (RequestOptions) null);
  }

  /**
   * Retrieves the details of an existing ReceivedDebit by passing the unique ReceivedDebit ID from
   * the ReceivedDebit list.
   */
  public static ReceivedDebit retrieve(String id, RequestOptions options) throws StripeException {
    return retrieve(id, (Map<String, Object>) null, options);
  }

  /**
   * Retrieves the details of an existing ReceivedDebit by passing the unique ReceivedDebit ID from
   * the ReceivedDebit list.
   */
  public static ReceivedDebit retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/received_debits/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ReceivedDebit.class, options);
  }

  /**
   * Retrieves the details of an existing ReceivedDebit by passing the unique ReceivedDebit ID from
   * the ReceivedDebit list.
   */
  public static ReceivedDebit retrieve(String id, ReceivedDebitRetrieveParams params, RequestOptions options) throws StripeException {
    String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/treasury/received_debits/%s", ApiResource.urlEncodeId(id)));
    return ApiResource.request(ApiResource.RequestMethod.GET, url, params, ReceivedDebit.class, options);
  }


  public static class InitiatingPaymentMethodDetails extends StripeObject {
    /**
     * Set when {@code type} is {@code balance}.
     *
     * <p>Equal to {@code payments}.
     */
    @SerializedName("balance")
    String balance;
    @SerializedName("billing_details")
    BillingDetails billingDetails;
    @SerializedName("financial_account")
    FinancialAccount financialAccount;
    /**
     * Set when {@code type} is {@code issuing_card}. This is an <a
     * href="https://stripe.com/docs/api#issuing_cards">Issuing Card</a> ID.
     */
    @SerializedName("issuing_card")
    String issuingCard;
    /**
     * Polymorphic type matching the originating money movement's source. This can be an external
     * account, a Stripe balance, or a FinancialAccount.
     *
     * <p>One of {@code balance}, {@code financial_account}, {@code issuing_card}, {@code stripe},
     * or {@code us_bank_account}.
     */
    @SerializedName("type")
    String type;
    @SerializedName("us_bank_account")
    ReceivedCredit.InitiatingPaymentMethodDetails.UsBankAccount usBankAccount;


    public static class BillingDetails extends StripeObject {
      @SerializedName("address")
      Address address;
      /**
       * Email address.
       */
      @SerializedName("email")
      String email;
      /**
       * Full name.
       */
      @SerializedName("name")
      String name;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Address getAddress() {
        return this.address;
      }

      /**
       * Email address.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getEmail() {
        return this.email;
      }

      /**
       * Full name.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getName() {
        return this.name;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setAddress(final Address address) {
        this.address = address;
      }

      /**
       * Email address.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setEmail(final String email) {
        this.email = email;
      }

      /**
       * Full name.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setName(final String name) {
        this.name = name;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ReceivedDebit.InitiatingPaymentMethodDetails.BillingDetails)) return false;
        final ReceivedDebit.InitiatingPaymentMethodDetails.BillingDetails other = (ReceivedDebit.InitiatingPaymentMethodDetails.BillingDetails) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$address = this.getAddress();
        final java.lang.Object other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
        final java.lang.Object this$email = this.getEmail();
        final java.lang.Object other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ReceivedDebit.InitiatingPaymentMethodDetails.BillingDetails;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $address = this.getAddress();
        result = result * PRIME + ($address == null ? 43 : $address.hashCode());
        final java.lang.Object $email = this.getEmail();
        result = result * PRIME + ($email == null ? 43 : $email.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        return result;
      }
    }


    public static class FinancialAccount extends StripeObject implements HasId {
      /**
       * The FinancialAccount ID.
       */
      @SerializedName("id")
      String id;
      /**
       * The rails the ReceivedCredit was sent over. A FinancialAccount can only send funds over
       * {@code stripe}.
       *
       * <p>Equal to {@code stripe}.
       */
      @SerializedName("network")
      String network;

      /**
       * The rails the ReceivedCredit was sent over. A FinancialAccount can only send funds over
       * {@code stripe}.
       *
       * <p>Equal to {@code stripe}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getNetwork() {
        return this.network;
      }

      /**
       * The FinancialAccount ID.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setId(final String id) {
        this.id = id;
      }

      /**
       * The rails the ReceivedCredit was sent over. A FinancialAccount can only send funds over
       * {@code stripe}.
       *
       * <p>Equal to {@code stripe}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setNetwork(final String network) {
        this.network = network;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ReceivedDebit.InitiatingPaymentMethodDetails.FinancialAccount)) return false;
        final ReceivedDebit.InitiatingPaymentMethodDetails.FinancialAccount other = (ReceivedDebit.InitiatingPaymentMethodDetails.FinancialAccount) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$network = this.getNetwork();
        final java.lang.Object other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ReceivedDebit.InitiatingPaymentMethodDetails.FinancialAccount;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $network = this.getNetwork();
        result = result * PRIME + ($network == null ? 43 : $network.hashCode());
        return result;
      }

      /**
       * The FinancialAccount ID.
       */
      @Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getId() {
        return this.id;
      }
    }


    public static class UsBankAccount extends StripeObject {
      /** Bank name. */
      @SerializedName("bank_name")
      String bankName;
      /** The last four digits of the bank account number. */
      @SerializedName("last4")
      String last4;
      @SerializedName("routing_number")
      String routingNumber;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getBankName() {
        return this.bankName;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getLast4() {
        return this.last4;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getRoutingNumber() {
        return this.routingNumber;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setBankName(final String bankName) {
        this.bankName = bankName;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setLast4(final String last4) {
        this.last4 = last4;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setRoutingNumber(final String routingNumber) {
        this.routingNumber = routingNumber;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ReceivedDebit.InitiatingPaymentMethodDetails.UsBankAccount)) return false;
        final ReceivedDebit.InitiatingPaymentMethodDetails.UsBankAccount other = (ReceivedDebit.InitiatingPaymentMethodDetails.UsBankAccount) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$bankName = this.getBankName();
        final java.lang.Object other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
        final java.lang.Object this$last4 = this.getLast4();
        final java.lang.Object other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) return false;
        final java.lang.Object this$routingNumber = this.getRoutingNumber();
        final java.lang.Object other$routingNumber = other.getRoutingNumber();
        if (this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ReceivedDebit.InitiatingPaymentMethodDetails.UsBankAccount;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $bankName = this.getBankName();
        result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
        final java.lang.Object $last4 = this.getLast4();
        result = result * PRIME + ($last4 == null ? 43 : $last4.hashCode());
        final java.lang.Object $routingNumber = this.getRoutingNumber();
        result = result * PRIME + ($routingNumber == null ? 43 : $routingNumber.hashCode());
        return result;
      }
    }

    /**
     * Set when {@code type} is {@code balance}.
     *
     * <p>Equal to {@code payments}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBalance() {
      return this.balance;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BillingDetails getBillingDetails() {
      return this.billingDetails;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public FinancialAccount getFinancialAccount() {
      return this.financialAccount;
    }

    /**
     * Set when {@code type} is {@code issuing_card}. This is an <a
     * href="https://stripe.com/docs/api#issuing_cards">Issuing Card</a> ID.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIssuingCard() {
      return this.issuingCard;
    }

    /**
     * Polymorphic type matching the originating money movement's source. This can be an external
     * account, a Stripe balance, or a FinancialAccount.
     *
     * <p>One of {@code balance}, {@code financial_account}, {@code issuing_card}, {@code stripe},
     * or {@code us_bank_account}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ReceivedCredit.InitiatingPaymentMethodDetails.UsBankAccount getUsBankAccount() {
      return this.usBankAccount;
    }

    /**
     * Set when {@code type} is {@code balance}.
     *
     * <p>Equal to {@code payments}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBalance(final String balance) {
      this.balance = balance;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBillingDetails(final BillingDetails billingDetails) {
      this.billingDetails = billingDetails;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFinancialAccount(final FinancialAccount financialAccount) {
      this.financialAccount = financialAccount;
    }

    /**
     * Set when {@code type} is {@code issuing_card}. This is an <a
     * href="https://stripe.com/docs/api#issuing_cards">Issuing Card</a> ID.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIssuingCard(final String issuingCard) {
      this.issuingCard = issuingCard;
    }

    /**
     * Polymorphic type matching the originating money movement's source. This can be an external
     * account, a Stripe balance, or a FinancialAccount.
     *
     * <p>One of {@code balance}, {@code financial_account}, {@code issuing_card}, {@code stripe},
     * or {@code us_bank_account}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUsBankAccount(final ReceivedCredit.InitiatingPaymentMethodDetails.UsBankAccount usBankAccount) {
      this.usBankAccount = usBankAccount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof ReceivedDebit.InitiatingPaymentMethodDetails)) return false;
      final ReceivedDebit.InitiatingPaymentMethodDetails other = (ReceivedDebit.InitiatingPaymentMethodDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$balance = this.getBalance();
      final java.lang.Object other$balance = other.getBalance();
      if (this$balance == null ? other$balance != null : !this$balance.equals(other$balance)) return false;
      final java.lang.Object this$billingDetails = this.getBillingDetails();
      final java.lang.Object other$billingDetails = other.getBillingDetails();
      if (this$billingDetails == null ? other$billingDetails != null : !this$billingDetails.equals(other$billingDetails)) return false;
      final java.lang.Object this$financialAccount = this.getFinancialAccount();
      final java.lang.Object other$financialAccount = other.getFinancialAccount();
      if (this$financialAccount == null ? other$financialAccount != null : !this$financialAccount.equals(other$financialAccount)) return false;
      final java.lang.Object this$issuingCard = this.getIssuingCard();
      final java.lang.Object other$issuingCard = other.getIssuingCard();
      if (this$issuingCard == null ? other$issuingCard != null : !this$issuingCard.equals(other$issuingCard)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      final java.lang.Object this$usBankAccount = this.getUsBankAccount();
      final java.lang.Object other$usBankAccount = other.getUsBankAccount();
      if (this$usBankAccount == null ? other$usBankAccount != null : !this$usBankAccount.equals(other$usBankAccount)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof ReceivedDebit.InitiatingPaymentMethodDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $balance = this.getBalance();
      result = result * PRIME + ($balance == null ? 43 : $balance.hashCode());
      final java.lang.Object $billingDetails = this.getBillingDetails();
      result = result * PRIME + ($billingDetails == null ? 43 : $billingDetails.hashCode());
      final java.lang.Object $financialAccount = this.getFinancialAccount();
      result = result * PRIME + ($financialAccount == null ? 43 : $financialAccount.hashCode());
      final java.lang.Object $issuingCard = this.getIssuingCard();
      result = result * PRIME + ($issuingCard == null ? 43 : $issuingCard.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      final java.lang.Object $usBankAccount = this.getUsBankAccount();
      result = result * PRIME + ($usBankAccount == null ? 43 : $usBankAccount.hashCode());
      return result;
    }
  }


  /**
   * The routing number for the bank account.
   */
  public static class LinkedFlows extends StripeObject {
    /**
     * The DebitReversal created as a result of this ReceivedDebit being reversed.
     */
    @SerializedName("debit_reversal")
    String debitReversal;
    /**
     * Set if the ReceivedDebit is associated with an InboundTransfer's return of funds.
     */
    @SerializedName("inbound_transfer")
    String inboundTransfer;
    /**
     * Set if the ReceivedDebit was created due to an <a
     * href="https://stripe.com/docs/api#issuing_authorizations">Issuing Authorization</a> object.
     */
    @SerializedName("issuing_authorization")
    String issuingAuthorization;
    /**
     * Set if the ReceivedDebit is also viewable as an <a
     * href="https://stripe.com/docs/api#issuing_disputes">Issuing Dispute</a> object.
     */
    @SerializedName("issuing_transaction")
    String issuingTransaction;

    /**
     * The DebitReversal created as a result of this ReceivedDebit being reversed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDebitReversal() {
      return this.debitReversal;
    }

    /**
     * Set if the ReceivedDebit is associated with an InboundTransfer's return of funds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getInboundTransfer() {
      return this.inboundTransfer;
    }

    /**
     * Set if the ReceivedDebit was created due to an <a
     * href="https://stripe.com/docs/api#issuing_authorizations">Issuing Authorization</a> object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIssuingAuthorization() {
      return this.issuingAuthorization;
    }

    /**
     * Set if the ReceivedDebit is also viewable as an <a
     * href="https://stripe.com/docs/api#issuing_disputes">Issuing Dispute</a> object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIssuingTransaction() {
      return this.issuingTransaction;
    }

    /**
     * The DebitReversal created as a result of this ReceivedDebit being reversed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDebitReversal(final String debitReversal) {
      this.debitReversal = debitReversal;
    }

    /**
     * Set if the ReceivedDebit is associated with an InboundTransfer's return of funds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setInboundTransfer(final String inboundTransfer) {
      this.inboundTransfer = inboundTransfer;
    }

    /**
     * Set if the ReceivedDebit was created due to an <a
     * href="https://stripe.com/docs/api#issuing_authorizations">Issuing Authorization</a> object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIssuingAuthorization(final String issuingAuthorization) {
      this.issuingAuthorization = issuingAuthorization;
    }

    /**
     * Set if the ReceivedDebit is also viewable as an <a
     * href="https://stripe.com/docs/api#issuing_disputes">Issuing Dispute</a> object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIssuingTransaction(final String issuingTransaction) {
      this.issuingTransaction = issuingTransaction;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof ReceivedDebit.LinkedFlows)) return false;
      final ReceivedDebit.LinkedFlows other = (ReceivedDebit.LinkedFlows) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$debitReversal = this.getDebitReversal();
      final java.lang.Object other$debitReversal = other.getDebitReversal();
      if (this$debitReversal == null ? other$debitReversal != null : !this$debitReversal.equals(other$debitReversal)) return false;
      final java.lang.Object this$inboundTransfer = this.getInboundTransfer();
      final java.lang.Object other$inboundTransfer = other.getInboundTransfer();
      if (this$inboundTransfer == null ? other$inboundTransfer != null : !this$inboundTransfer.equals(other$inboundTransfer)) return false;
      final java.lang.Object this$issuingAuthorization = this.getIssuingAuthorization();
      final java.lang.Object other$issuingAuthorization = other.getIssuingAuthorization();
      if (this$issuingAuthorization == null ? other$issuingAuthorization != null : !this$issuingAuthorization.equals(other$issuingAuthorization)) return false;
      final java.lang.Object this$issuingTransaction = this.getIssuingTransaction();
      final java.lang.Object other$issuingTransaction = other.getIssuingTransaction();
      if (this$issuingTransaction == null ? other$issuingTransaction != null : !this$issuingTransaction.equals(other$issuingTransaction)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof ReceivedDebit.LinkedFlows;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $debitReversal = this.getDebitReversal();
      result = result * PRIME + ($debitReversal == null ? 43 : $debitReversal.hashCode());
      final java.lang.Object $inboundTransfer = this.getInboundTransfer();
      result = result * PRIME + ($inboundTransfer == null ? 43 : $inboundTransfer.hashCode());
      final java.lang.Object $issuingAuthorization = this.getIssuingAuthorization();
      result = result * PRIME + ($issuingAuthorization == null ? 43 : $issuingAuthorization.hashCode());
      final java.lang.Object $issuingTransaction = this.getIssuingTransaction();
      result = result * PRIME + ($issuingTransaction == null ? 43 : $issuingTransaction.hashCode());
      return result;
    }
  }


  public static class ReversalDetails extends StripeObject {
    /**
     * Time before which a ReceivedDebit can be reversed.
     */
    @SerializedName("deadline")
    Long deadline;
    /**
     * Set if a ReceivedDebit can't be reversed.
     *
     * <p>One of {@code already_reversed}, {@code deadline_passed}, {@code network_restricted},
     * {@code other}, or {@code source_flow_restricted}.
     */
    @SerializedName("restricted_reason")
    String restrictedReason;

    /**
     * Time before which a ReceivedDebit can be reversed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDeadline() {
      return this.deadline;
    }

    /**
     * Set if a ReceivedDebit can't be reversed.
     *
     * <p>One of {@code already_reversed}, {@code deadline_passed}, {@code network_restricted},
     * {@code other}, or {@code source_flow_restricted}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRestrictedReason() {
      return this.restrictedReason;
    }

    /**
     * Time before which a ReceivedDebit can be reversed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDeadline(final Long deadline) {
      this.deadline = deadline;
    }

    /**
     * Set if a ReceivedDebit can't be reversed.
     *
     * <p>One of {@code already_reversed}, {@code deadline_passed}, {@code network_restricted},
     * {@code other}, or {@code source_flow_restricted}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRestrictedReason(final String restrictedReason) {
      this.restrictedReason = restrictedReason;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof ReceivedDebit.ReversalDetails)) return false;
      final ReceivedDebit.ReversalDetails other = (ReceivedDebit.ReversalDetails) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$deadline = this.getDeadline();
      final java.lang.Object other$deadline = other.getDeadline();
      if (this$deadline == null ? other$deadline != null : !this$deadline.equals(other$deadline)) return false;
      final java.lang.Object this$restrictedReason = this.getRestrictedReason();
      final java.lang.Object other$restrictedReason = other.getRestrictedReason();
      if (this$restrictedReason == null ? other$restrictedReason != null : !this$restrictedReason.equals(other$restrictedReason)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof ReceivedDebit.ReversalDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $deadline = this.getDeadline();
      result = result * PRIME + ($deadline == null ? 43 : $deadline.hashCode());
      final java.lang.Object $restrictedReason = this.getRestrictedReason();
      result = result * PRIME + ($restrictedReason == null ? 43 : $restrictedReason.hashCode());
      return result;
    }
  }


  public static class StatusTransitions extends StripeObject {
    /**
     * Timestamp describing when the DebitReversal changed status to {@code completed}.
     */
    @SerializedName("completed_at")
    Long completedAt;

    /**
     * Timestamp describing when the DebitReversal changed status to {@code completed}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCompletedAt() {
      return this.completedAt;
    }

    /**
     * Timestamp describing when the DebitReversal changed status to {@code completed}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCompletedAt(final Long completedAt) {
      this.completedAt = completedAt;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof ReceivedDebit.StatusTransitions)) return false;
      final ReceivedDebit.StatusTransitions other = (ReceivedDebit.StatusTransitions) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$completedAt = this.getCompletedAt();
      final java.lang.Object other$completedAt = other.getCompletedAt();
      if (this$completedAt == null ? other$completedAt != null : !this$completedAt.equals(other$completedAt)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof ReceivedDebit.StatusTransitions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $completedAt = this.getCompletedAt();
      result = result * PRIME + ($completedAt == null ? 43 : $completedAt.hashCode());
      return result;
    }
  }


  public static class TestHelpers {
    private TestHelpers() {
    }

    /**
     * Use this endpoint to simulate a test mode ReceivedDebit initiated by a third party. In live
     * mode, you can’t directly create ReceivedDebits initiated by third parties.
     */
    public static ReceivedDebit create(Map<String, Object> params) throws StripeException {
      return create(params, (RequestOptions) null);
    }

    /**
     * Use this endpoint to simulate a test mode ReceivedDebit initiated by a third party. In live
     * mode, you can’t directly create ReceivedDebits initiated by third parties.
     */
    public static ReceivedDebit create(Map<String, Object> params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), "/v1/test_helpers/treasury/received_debits");
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ReceivedDebit.class, options);
    }

    /**
     * Use this endpoint to simulate a test mode ReceivedDebit initiated by a third party. In live
     * mode, you can’t directly create ReceivedDebits initiated by third parties.
     */
    public static ReceivedDebit create(ReceivedDebitCreateParams params) throws StripeException {
      return create(params, (RequestOptions) null);
    }

    /**
     * Use this endpoint to simulate a test mode ReceivedDebit initiated by a third party. In live
     * mode, you can’t directly create ReceivedDebits initiated by third parties.
     */
    public static ReceivedDebit create(ReceivedDebitCreateParams params, RequestOptions options) throws StripeException {
      String url = String.format("%s%s", Stripe.getApiBase(), "/v1/test_helpers/treasury/received_debits");
      return ApiResource.request(ApiResource.RequestMethod.POST, url, params, ReceivedDebit.class, options);
    }
  }

  /**
   * Amount (in cents) transferred.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getAmount() {
    return this.amount;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreated() {
    return this.created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDescription() {
    return this.description;
  }

  /**
   * Reason for the failure. A ReceivedDebit might fail because the FinancialAccount doesn't have
   * sufficient funds, is closed, or is frozen.
   *
   * <p>One of {@code account_closed}, {@code account_frozen}, {@code insufficient_funds}, or {@code
   * other}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFailureCode() {
    return this.failureCode;
  }

  /**
   * The FinancialAccount that funds were pulled from.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFinancialAccount() {
    return this.financialAccount;
  }

  /**
   * A <a href="https://stripe.com/docs/treasury/moving-money/regulatory-receipts">hosted
   * transaction receipt</a> URL that is provided when money movement is considered regulated under
   * Stripe's money transmission licenses.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHostedRegulatoryReceiptUrl() {
    return this.hostedRegulatoryReceiptUrl;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public InitiatingPaymentMethodDetails getInitiatingPaymentMethodDetails() {
    return this.initiatingPaymentMethodDetails;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LinkedFlows getLinkedFlows() {
    return this.linkedFlows;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * The network used for the ReceivedDebit.
   *
   * <p>One of {@code ach}, {@code card}, or {@code stripe}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getNetwork() {
    return this.network;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.received_debit}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  /**
   * Details describing when a ReceivedDebit might be reversed.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ReversalDetails getReversalDetails() {
    return this.reversalDetails;
  }

  /**
   * Status of the ReceivedDebit. ReceivedDebits are created with a status of either {@code
   * succeeded} (approved) or {@code failed} (declined). The failure reason can be found under the
   * {@code failure_code}.
   *
   * <p>One of {@code failed}, or {@code succeeded}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatus() {
    return this.status;
  }

  /**
   * Amount (in cents) transferred.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAmount(final Long amount) {
    this.amount = amount;
  }

  /**
   * Time at which the object was created. Measured in seconds since the Unix epoch.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreated(final Long created) {
    this.created = created;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * An arbitrary string attached to the object. Often useful for displaying to users.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDescription(final String description) {
    this.description = description;
  }

  /**
   * Reason for the failure. A ReceivedDebit might fail because the FinancialAccount doesn't have
   * sufficient funds, is closed, or is frozen.
   *
   * <p>One of {@code account_closed}, {@code account_frozen}, {@code insufficient_funds}, or {@code
   * other}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFailureCode(final String failureCode) {
    this.failureCode = failureCode;
  }

  /**
   * The FinancialAccount that funds were pulled from.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinancialAccount(final String financialAccount) {
    this.financialAccount = financialAccount;
  }

  /**
   * A <a href="https://stripe.com/docs/treasury/moving-money/regulatory-receipts">hosted
   * transaction receipt</a> URL that is provided when money movement is considered regulated under
   * Stripe's money transmission licenses.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHostedRegulatoryReceiptUrl(final String hostedRegulatoryReceiptUrl) {
    this.hostedRegulatoryReceiptUrl = hostedRegulatoryReceiptUrl;
  }

  /**
   * Unique identifier for the object.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setInitiatingPaymentMethodDetails(final InitiatingPaymentMethodDetails initiatingPaymentMethodDetails) {
    this.initiatingPaymentMethodDetails = initiatingPaymentMethodDetails;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLinkedFlows(final LinkedFlows linkedFlows) {
    this.linkedFlows = linkedFlows;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * The network used for the ReceivedDebit.
   *
   * <p>One of {@code ach}, {@code card}, or {@code stripe}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNetwork(final String network) {
    this.network = network;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code treasury.received_debit}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  /**
   * Details describing when a ReceivedDebit might be reversed.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReversalDetails(final ReversalDetails reversalDetails) {
    this.reversalDetails = reversalDetails;
  }

  /**
   * Status of the ReceivedDebit. ReceivedDebits are created with a status of either {@code
   * succeeded} (approved) or {@code failed} (declined). The failure reason can be found under the
   * {@code failure_code}.
   *
   * <p>One of {@code failed}, or {@code succeeded}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatus(final String status) {
    this.status = status;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ReceivedDebit)) return false;
    final ReceivedDebit other = (ReceivedDebit) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$amount = this.getAmount();
    final java.lang.Object other$amount = other.getAmount();
    if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
    final java.lang.Object this$created = this.getCreated();
    final java.lang.Object other$created = other.getCreated();
    if (this$created == null ? other$created != null : !this$created.equals(other$created)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$description = this.getDescription();
    final java.lang.Object other$description = other.getDescription();
    if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
    final java.lang.Object this$failureCode = this.getFailureCode();
    final java.lang.Object other$failureCode = other.getFailureCode();
    if (this$failureCode == null ? other$failureCode != null : !this$failureCode.equals(other$failureCode)) return false;
    final java.lang.Object this$financialAccount = this.getFinancialAccount();
    final java.lang.Object other$financialAccount = other.getFinancialAccount();
    if (this$financialAccount == null ? other$financialAccount != null : !this$financialAccount.equals(other$financialAccount)) return false;
    final java.lang.Object this$hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
    final java.lang.Object other$hostedRegulatoryReceiptUrl = other.getHostedRegulatoryReceiptUrl();
    if (this$hostedRegulatoryReceiptUrl == null ? other$hostedRegulatoryReceiptUrl != null : !this$hostedRegulatoryReceiptUrl.equals(other$hostedRegulatoryReceiptUrl)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$initiatingPaymentMethodDetails = this.getInitiatingPaymentMethodDetails();
    final java.lang.Object other$initiatingPaymentMethodDetails = other.getInitiatingPaymentMethodDetails();
    if (this$initiatingPaymentMethodDetails == null ? other$initiatingPaymentMethodDetails != null : !this$initiatingPaymentMethodDetails.equals(other$initiatingPaymentMethodDetails)) return false;
    final java.lang.Object this$linkedFlows = this.getLinkedFlows();
    final java.lang.Object other$linkedFlows = other.getLinkedFlows();
    if (this$linkedFlows == null ? other$linkedFlows != null : !this$linkedFlows.equals(other$linkedFlows)) return false;
    final java.lang.Object this$network = this.getNetwork();
    final java.lang.Object other$network = other.getNetwork();
    if (this$network == null ? other$network != null : !this$network.equals(other$network)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$reversalDetails = this.getReversalDetails();
    final java.lang.Object other$reversalDetails = other.getReversalDetails();
    if (this$reversalDetails == null ? other$reversalDetails != null : !this$reversalDetails.equals(other$reversalDetails)) return false;
    final java.lang.Object this$status = this.getStatus();
    final java.lang.Object other$status = other.getStatus();
    if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
    final java.lang.Object this$transaction = this.getTransaction();
    final java.lang.Object other$transaction = other.getTransaction();
    if (this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ReceivedDebit;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $amount = this.getAmount();
    result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
    final java.lang.Object $created = this.getCreated();
    result = result * PRIME + ($created == null ? 43 : $created.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $description = this.getDescription();
    result = result * PRIME + ($description == null ? 43 : $description.hashCode());
    final java.lang.Object $failureCode = this.getFailureCode();
    result = result * PRIME + ($failureCode == null ? 43 : $failureCode.hashCode());
    final java.lang.Object $financialAccount = this.getFinancialAccount();
    result = result * PRIME + ($financialAccount == null ? 43 : $financialAccount.hashCode());
    final java.lang.Object $hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
    result = result * PRIME + ($hostedRegulatoryReceiptUrl == null ? 43 : $hostedRegulatoryReceiptUrl.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $initiatingPaymentMethodDetails = this.getInitiatingPaymentMethodDetails();
    result = result * PRIME + ($initiatingPaymentMethodDetails == null ? 43 : $initiatingPaymentMethodDetails.hashCode());
    final java.lang.Object $linkedFlows = this.getLinkedFlows();
    result = result * PRIME + ($linkedFlows == null ? 43 : $linkedFlows.hashCode());
    final java.lang.Object $network = this.getNetwork();
    result = result * PRIME + ($network == null ? 43 : $network.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $reversalDetails = this.getReversalDetails();
    result = result * PRIME + ($reversalDetails == null ? 43 : $reversalDetails.hashCode());
    final java.lang.Object $status = this.getStatus();
    result = result * PRIME + ($status == null ? 43 : $status.hashCode());
    final java.lang.Object $transaction = this.getTransaction();
    result = result * PRIME + ($transaction == null ? 43 : $transaction.hashCode());
    return result;
  }

  /**
   * Unique identifier for the object.
   */
  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
}
