/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.terminal;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentIntent;
import com.stripe.model.SetupIntent;
import com.stripe.model.StripeObject;
import com.stripe.model.terminal.Location;
import com.stripe.model.terminal.ReaderCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.terminal.ReaderCancelActionParams;
import com.stripe.param.terminal.ReaderCreateParams;
import com.stripe.param.terminal.ReaderListParams;
import com.stripe.param.terminal.ReaderPresentPaymentMethodParams;
import com.stripe.param.terminal.ReaderProcessPaymentIntentParams;
import com.stripe.param.terminal.ReaderProcessSetupIntentParams;
import com.stripe.param.terminal.ReaderRetrieveParams;
import com.stripe.param.terminal.ReaderSetReaderDisplayParams;
import com.stripe.param.terminal.ReaderUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Reader
extends ApiResource
implements HasId,
MetadataStore<Reader> {
    @SerializedName(value="action")
    ReaderAction action;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="device_sw_version")
    String deviceSwVersion;
    @SerializedName(value="device_type")
    String deviceType;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="ip_address")
    String ipAddress;
    @SerializedName(value="label")
    String label;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="location")
    ExpandableField<Location> location;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="serial_number")
    String serialNumber;
    @SerializedName(value="status")
    String status;

    public String getLocation() {
        return this.location != null ? this.location.getId() : null;
    }

    public void setLocation(String id) {
        this.location = ApiResource.setExpandableFieldId(id, this.location);
    }

    public Location getLocationObject() {
        return this.location != null ? this.location.getExpanded() : null;
    }

    public void setLocationObject(Location expandableObject) {
        this.location = new ExpandableField<Location>(expandableObject.getId(), expandableObject);
    }

    public Reader cancelAction() throws StripeException {
        return this.cancelAction((Map<String, Object>)null, (RequestOptions)null);
    }

    public Reader cancelAction(RequestOptions options) throws StripeException {
        return this.cancelAction((Map<String, Object>)null, options);
    }

    public Reader cancelAction(Map<String, Object> params) throws StripeException {
        return this.cancelAction(params, (RequestOptions)null);
    }

    public Reader cancelAction(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s/cancel_action", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
    }

    public Reader cancelAction(ReaderCancelActionParams params) throws StripeException {
        return this.cancelAction(params, (RequestOptions)null);
    }

    public Reader cancelAction(ReaderCancelActionParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s/cancel_action", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
    }

    public static Reader create(Map<String, Object> params) throws StripeException {
        return Reader.create(params, (RequestOptions)null);
    }

    public static Reader create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/readers");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
    }

    public static Reader create(ReaderCreateParams params) throws StripeException {
        return Reader.create(params, (RequestOptions)null);
    }

    public static Reader create(ReaderCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/readers");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
    }

    public Reader delete() throws StripeException {
        return this.delete(null, null);
    }

    public Reader delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Reader delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Reader delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Reader.class, options);
    }

    public static ReaderCollection list(Map<String, Object> params) throws StripeException {
        return Reader.list(params, (RequestOptions)null);
    }

    public static ReaderCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/readers");
        return ApiResource.requestCollection(url, params, ReaderCollection.class, options);
    }

    public static ReaderCollection list(ReaderListParams params) throws StripeException {
        return Reader.list(params, (RequestOptions)null);
    }

    public static ReaderCollection list(ReaderListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/terminal/readers");
        return ApiResource.requestCollection(url, params, ReaderCollection.class, options);
    }

    public Reader processPaymentIntent(Map<String, Object> params) throws StripeException {
        return this.processPaymentIntent(params, (RequestOptions)null);
    }

    public Reader processPaymentIntent(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s/process_payment_intent", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
    }

    public Reader processPaymentIntent(ReaderProcessPaymentIntentParams params) throws StripeException {
        return this.processPaymentIntent(params, (RequestOptions)null);
    }

    public Reader processPaymentIntent(ReaderProcessPaymentIntentParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s/process_payment_intent", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
    }

    public Reader processSetupIntent(Map<String, Object> params) throws StripeException {
        return this.processSetupIntent(params, (RequestOptions)null);
    }

    public Reader processSetupIntent(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s/process_setup_intent", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
    }

    public Reader processSetupIntent(ReaderProcessSetupIntentParams params) throws StripeException {
        return this.processSetupIntent(params, (RequestOptions)null);
    }

    public Reader processSetupIntent(ReaderProcessSetupIntentParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s/process_setup_intent", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
    }

    public static Reader retrieve(String reader) throws StripeException {
        return Reader.retrieve(reader, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Reader retrieve(String reader, RequestOptions options) throws StripeException {
        return Reader.retrieve(reader, (Map<String, Object>)null, options);
    }

    public static Reader retrieve(String reader, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(reader)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Reader.class, options);
    }

    public static Reader retrieve(String reader, ReaderRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(reader)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Reader.class, options);
    }

    public Reader setReaderDisplay(Map<String, Object> params) throws StripeException {
        return this.setReaderDisplay(params, (RequestOptions)null);
    }

    public Reader setReaderDisplay(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s/set_reader_display", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
    }

    public Reader setReaderDisplay(ReaderSetReaderDisplayParams params) throws StripeException {
        return this.setReaderDisplay(params, (RequestOptions)null);
    }

    public Reader setReaderDisplay(ReaderSetReaderDisplayParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s/set_reader_display", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
    }

    public Reader update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Reader update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
    }

    public Reader update(ReaderUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Reader update(ReaderUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
    }

    public TestHelpers getTestHelpers() {
        return new TestHelpers(this);
    }

    @Generated
    public ReaderAction getAction() {
        return this.action;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDeviceSwVersion() {
        return this.deviceSwVersion;
    }

    @Generated
    public String getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setAction(ReaderAction action) {
        this.action = action;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDeviceSwVersion(String deviceSwVersion) {
        this.deviceSwVersion = deviceSwVersion;
    }

    @Generated
    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reader)) {
            return false;
        }
        Reader other = (Reader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        ReaderAction this$action = this.getAction();
        ReaderAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)this$action).equals(other$action)) {
            return false;
        }
        String this$deviceSwVersion = this.getDeviceSwVersion();
        String other$deviceSwVersion = other.getDeviceSwVersion();
        if (this$deviceSwVersion == null ? other$deviceSwVersion != null : !this$deviceSwVersion.equals(other$deviceSwVersion)) {
            return false;
        }
        String this$deviceType = this.getDeviceType();
        String other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$serialNumber = this.getSerialNumber();
        String other$serialNumber = other.getSerialNumber();
        if (this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Reader;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        ReaderAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)$action).hashCode());
        String $deviceSwVersion = this.getDeviceSwVersion();
        result = result * 59 + ($deviceSwVersion == null ? 43 : $deviceSwVersion.hashCode());
        String $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TestHelpers {
        private final Reader resource;

        private TestHelpers(Reader resource) {
            this.resource = resource;
        }

        public Reader presentPaymentMethod() throws StripeException {
            return this.presentPaymentMethod((Map<String, Object>)null, (RequestOptions)null);
        }

        public Reader presentPaymentMethod(RequestOptions options) throws StripeException {
            return this.presentPaymentMethod((Map<String, Object>)null, options);
        }

        public Reader presentPaymentMethod(Map<String, Object> params) throws StripeException {
            return this.presentPaymentMethod(params, (RequestOptions)null);
        }

        public Reader presentPaymentMethod(Map<String, Object> params, RequestOptions options) throws StripeException {
            String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/terminal/readers/%s/present_payment_method", ApiResource.urlEncodeId(this.resource.getId())));
            return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
        }

        public Reader presentPaymentMethod(ReaderPresentPaymentMethodParams params) throws StripeException {
            return this.presentPaymentMethod(params, (RequestOptions)null);
        }

        public Reader presentPaymentMethod(ReaderPresentPaymentMethodParams params, RequestOptions options) throws StripeException {
            String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/test_helpers/terminal/readers/%s/present_payment_method", ApiResource.urlEncodeId(this.resource.getId())));
            return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Reader.class, options);
        }
    }

    public static class ReaderAction
    extends StripeObject {
        @SerializedName(value="failure_code")
        String failureCode;
        @SerializedName(value="failure_message")
        String failureMessage;
        @SerializedName(value="process_payment_intent")
        ProcessPaymentIntentAction processPaymentIntent;
        @SerializedName(value="process_setup_intent")
        ProcessSetupIntentAction processSetupIntent;
        @SerializedName(value="set_reader_display")
        SetReaderDisplayAction setReaderDisplay;
        @SerializedName(value="status")
        String status;
        @SerializedName(value="type")
        String type;

        @Generated
        public String getFailureCode() {
            return this.failureCode;
        }

        @Generated
        public String getFailureMessage() {
            return this.failureMessage;
        }

        @Generated
        public ProcessPaymentIntentAction getProcessPaymentIntent() {
            return this.processPaymentIntent;
        }

        @Generated
        public ProcessSetupIntentAction getProcessSetupIntent() {
            return this.processSetupIntent;
        }

        @Generated
        public SetReaderDisplayAction getSetReaderDisplay() {
            return this.setReaderDisplay;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Generated
        public void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Generated
        public void setProcessPaymentIntent(ProcessPaymentIntentAction processPaymentIntent) {
            this.processPaymentIntent = processPaymentIntent;
        }

        @Generated
        public void setProcessSetupIntent(ProcessSetupIntentAction processSetupIntent) {
            this.processSetupIntent = processSetupIntent;
        }

        @Generated
        public void setSetReaderDisplay(SetReaderDisplayAction setReaderDisplay) {
            this.setReaderDisplay = setReaderDisplay;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReaderAction)) {
                return false;
            }
            ReaderAction other = (ReaderAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$failureCode = this.getFailureCode();
            String other$failureCode = other.getFailureCode();
            if (this$failureCode == null ? other$failureCode != null : !this$failureCode.equals(other$failureCode)) {
                return false;
            }
            String this$failureMessage = this.getFailureMessage();
            String other$failureMessage = other.getFailureMessage();
            if (this$failureMessage == null ? other$failureMessage != null : !this$failureMessage.equals(other$failureMessage)) {
                return false;
            }
            ProcessPaymentIntentAction this$processPaymentIntent = this.getProcessPaymentIntent();
            ProcessPaymentIntentAction other$processPaymentIntent = other.getProcessPaymentIntent();
            if (this$processPaymentIntent == null ? other$processPaymentIntent != null : !((Object)this$processPaymentIntent).equals(other$processPaymentIntent)) {
                return false;
            }
            ProcessSetupIntentAction this$processSetupIntent = this.getProcessSetupIntent();
            ProcessSetupIntentAction other$processSetupIntent = other.getProcessSetupIntent();
            if (this$processSetupIntent == null ? other$processSetupIntent != null : !((Object)this$processSetupIntent).equals(other$processSetupIntent)) {
                return false;
            }
            SetReaderDisplayAction this$setReaderDisplay = this.getSetReaderDisplay();
            SetReaderDisplayAction other$setReaderDisplay = other.getSetReaderDisplay();
            if (this$setReaderDisplay == null ? other$setReaderDisplay != null : !((Object)this$setReaderDisplay).equals(other$setReaderDisplay)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReaderAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $failureCode = this.getFailureCode();
            result = result * 59 + ($failureCode == null ? 43 : $failureCode.hashCode());
            String $failureMessage = this.getFailureMessage();
            result = result * 59 + ($failureMessage == null ? 43 : $failureMessage.hashCode());
            ProcessPaymentIntentAction $processPaymentIntent = this.getProcessPaymentIntent();
            result = result * 59 + ($processPaymentIntent == null ? 43 : ((Object)$processPaymentIntent).hashCode());
            ProcessSetupIntentAction $processSetupIntent = this.getProcessSetupIntent();
            result = result * 59 + ($processSetupIntent == null ? 43 : ((Object)$processSetupIntent).hashCode());
            SetReaderDisplayAction $setReaderDisplay = this.getSetReaderDisplay();
            result = result * 59 + ($setReaderDisplay == null ? 43 : ((Object)$setReaderDisplay).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class ProcessPaymentIntentAction
        extends StripeObject {
            @SerializedName(value="payment_intent")
            ExpandableField<PaymentIntent> paymentIntent;
            @SerializedName(value="process_config")
            ProcessConfig processConfig;

            public String getPaymentIntent() {
                return this.paymentIntent != null ? this.paymentIntent.getId() : null;
            }

            public void setPaymentIntent(String id) {
                this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
            }

            public PaymentIntent getPaymentIntentObject() {
                return this.paymentIntent != null ? this.paymentIntent.getExpanded() : null;
            }

            public void setPaymentIntentObject(PaymentIntent expandableObject) {
                this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public ProcessConfig getProcessConfig() {
                return this.processConfig;
            }

            @Generated
            public void setProcessConfig(ProcessConfig processConfig) {
                this.processConfig = processConfig;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ProcessPaymentIntentAction)) {
                    return false;
                }
                ProcessPaymentIntentAction other = (ProcessPaymentIntentAction)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$paymentIntent = this.getPaymentIntent();
                String other$paymentIntent = other.getPaymentIntent();
                if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) {
                    return false;
                }
                ProcessConfig this$processConfig = this.getProcessConfig();
                ProcessConfig other$processConfig = other.getProcessConfig();
                return !(this$processConfig == null ? other$processConfig != null : !((Object)this$processConfig).equals(other$processConfig));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ProcessPaymentIntentAction;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $paymentIntent = this.getPaymentIntent();
                result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
                ProcessConfig $processConfig = this.getProcessConfig();
                result = result * 59 + ($processConfig == null ? 43 : ((Object)$processConfig).hashCode());
                return result;
            }

            public static class ProcessConfig
            extends StripeObject {
                @SerializedName(value="skip_tipping")
                Boolean skipTipping;

                @Generated
                public Boolean getSkipTipping() {
                    return this.skipTipping;
                }

                @Generated
                public void setSkipTipping(Boolean skipTipping) {
                    this.skipTipping = skipTipping;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ProcessConfig)) {
                        return false;
                    }
                    ProcessConfig other = (ProcessConfig)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$skipTipping = this.getSkipTipping();
                    Boolean other$skipTipping = other.getSkipTipping();
                    return !(this$skipTipping == null ? other$skipTipping != null : !((Object)this$skipTipping).equals(other$skipTipping));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof ProcessConfig;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $skipTipping = this.getSkipTipping();
                    result = result * 59 + ($skipTipping == null ? 43 : ((Object)$skipTipping).hashCode());
                    return result;
                }
            }
        }

        public static class ProcessSetupIntentAction
        extends StripeObject {
            @SerializedName(value="generated_card")
            String generatedCard;
            @SerializedName(value="setup_intent")
            ExpandableField<SetupIntent> setupIntent;

            public String getSetupIntent() {
                return this.setupIntent != null ? this.setupIntent.getId() : null;
            }

            public void setSetupIntent(String id) {
                this.setupIntent = ApiResource.setExpandableFieldId(id, this.setupIntent);
            }

            public SetupIntent getSetupIntentObject() {
                return this.setupIntent != null ? this.setupIntent.getExpanded() : null;
            }

            public void setSetupIntentObject(SetupIntent expandableObject) {
                this.setupIntent = new ExpandableField<SetupIntent>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getGeneratedCard() {
                return this.generatedCard;
            }

            @Generated
            public void setGeneratedCard(String generatedCard) {
                this.generatedCard = generatedCard;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ProcessSetupIntentAction)) {
                    return false;
                }
                ProcessSetupIntentAction other = (ProcessSetupIntentAction)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$generatedCard = this.getGeneratedCard();
                String other$generatedCard = other.getGeneratedCard();
                if (this$generatedCard == null ? other$generatedCard != null : !this$generatedCard.equals(other$generatedCard)) {
                    return false;
                }
                String this$setupIntent = this.getSetupIntent();
                String other$setupIntent = other.getSetupIntent();
                return !(this$setupIntent == null ? other$setupIntent != null : !this$setupIntent.equals(other$setupIntent));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ProcessSetupIntentAction;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $generatedCard = this.getGeneratedCard();
                result = result * 59 + ($generatedCard == null ? 43 : $generatedCard.hashCode());
                String $setupIntent = this.getSetupIntent();
                result = result * 59 + ($setupIntent == null ? 43 : $setupIntent.hashCode());
                return result;
            }
        }

        public static class SetReaderDisplayAction
        extends StripeObject {
            @SerializedName(value="cart")
            Cart cart;
            @SerializedName(value="type")
            String type;

            @Generated
            public Cart getCart() {
                return this.cart;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setCart(Cart cart) {
                this.cart = cart;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SetReaderDisplayAction)) {
                    return false;
                }
                SetReaderDisplayAction other = (SetReaderDisplayAction)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Cart this$cart = this.getCart();
                Cart other$cart = other.getCart();
                if (this$cart == null ? other$cart != null : !((Object)this$cart).equals(other$cart)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SetReaderDisplayAction;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Cart $cart = this.getCart();
                result = result * 59 + ($cart == null ? 43 : ((Object)$cart).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Cart
            extends StripeObject {
                @SerializedName(value="currency")
                String currency;
                @SerializedName(value="line_items")
                List<LineItem> lineItems;
                @SerializedName(value="tax")
                Long tax;
                @SerializedName(value="total")
                Long total;

                @Generated
                public String getCurrency() {
                    return this.currency;
                }

                @Generated
                public List<LineItem> getLineItems() {
                    return this.lineItems;
                }

                @Generated
                public Long getTax() {
                    return this.tax;
                }

                @Generated
                public Long getTotal() {
                    return this.total;
                }

                @Generated
                public void setCurrency(String currency) {
                    this.currency = currency;
                }

                @Generated
                public void setLineItems(List<LineItem> lineItems) {
                    this.lineItems = lineItems;
                }

                @Generated
                public void setTax(Long tax) {
                    this.tax = tax;
                }

                @Generated
                public void setTotal(Long total) {
                    this.total = total;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Cart)) {
                        return false;
                    }
                    Cart other = (Cart)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$tax = this.getTax();
                    Long other$tax = other.getTax();
                    if (this$tax == null ? other$tax != null : !((Object)this$tax).equals(other$tax)) {
                        return false;
                    }
                    Long this$total = this.getTotal();
                    Long other$total = other.getTotal();
                    if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
                        return false;
                    }
                    String this$currency = this.getCurrency();
                    String other$currency = other.getCurrency();
                    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                        return false;
                    }
                    List<LineItem> this$lineItems = this.getLineItems();
                    List<LineItem> other$lineItems = other.getLineItems();
                    return !(this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Cart;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $tax = this.getTax();
                    result = result * 59 + ($tax == null ? 43 : ((Object)$tax).hashCode());
                    Long $total = this.getTotal();
                    result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
                    String $currency = this.getCurrency();
                    result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                    List<LineItem> $lineItems = this.getLineItems();
                    result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
                    return result;
                }

                public static class LineItem
                extends StripeObject {
                    @SerializedName(value="amount")
                    Long amount;
                    @SerializedName(value="description")
                    String description;
                    @SerializedName(value="quantity")
                    Long quantity;

                    @Generated
                    public Long getAmount() {
                        return this.amount;
                    }

                    @Generated
                    public String getDescription() {
                        return this.description;
                    }

                    @Generated
                    public Long getQuantity() {
                        return this.quantity;
                    }

                    @Generated
                    public void setAmount(Long amount) {
                        this.amount = amount;
                    }

                    @Generated
                    public void setDescription(String description) {
                        this.description = description;
                    }

                    @Generated
                    public void setQuantity(Long quantity) {
                        this.quantity = quantity;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof LineItem)) {
                            return false;
                        }
                        LineItem other = (LineItem)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$amount = this.getAmount();
                        Long other$amount = other.getAmount();
                        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                            return false;
                        }
                        Long this$quantity = this.getQuantity();
                        Long other$quantity = other.getQuantity();
                        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                            return false;
                        }
                        String this$description = this.getDescription();
                        String other$description = other.getDescription();
                        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof LineItem;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $amount = this.getAmount();
                        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                        Long $quantity = this.getQuantity();
                        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
                        String $description = this.getDescription();
                        result = result * 59 + ($description == null ? 43 : $description.hashCode());
                        return result;
                    }
                }
            }
        }
    }
}

