// Generated by delombok at Fri Aug 26 15:21:55 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import java.util.List;

/**
 * Each customer has a <a
 * href="https://stripe.com/docs/api/customers/object#customer_object-balance">{@code balance}</a>
 * that is automatically applied to future invoices and payments using the {@code customer_balance}
 * payment method. Customers can fund this balance by initiating a bank transfer to any account in
 * the {@code financial_addresses} field. Related guide: <a
 * href="https://stripe.com/docs/payments/customer-balance/funding-instructions">Customer Balance -
 * Funding Instructions</a> to learn more
 */
public class FundingInstructions extends StripeObject {
  @SerializedName("bank_transfer")
  BankTransfer bankTransfer;
  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * The {@code funding_type} of the returned instructions
   *
   * <p>Equal to {@code bank_transfer}.
   */
  @SerializedName("funding_type")
  String fundingType;
  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @SerializedName("livemode")
  Boolean livemode;
  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code funding_instructions}.
   */
  @SerializedName("object")
  String object;


  public static class BankTransfer extends StripeObject {
    /** The country of the bank account to fund. */
    @SerializedName("country")
    String country;
    /** A list of financial addresses that can be used to fund a particular balance. */
    @SerializedName("financial_addresses")
    List<FundingInstructions.BankTransfer.FinancialAddress> financialAddresses;
    /**
     * The bank_transfer type
     *
     * <p>One of {@code eu_bank_transfer}, or {@code jp_bank_transfer}.
     */
    @SerializedName("type")
    String type;

    /** FinancialAddresses contain identifying information that resolves to a FinancialAccount. */
    public static class FinancialAddress extends StripeObject {
      /** Iban Records contain E.U. bank account details per the SEPA format. */
      @SerializedName("iban")
      Iban iban;
      /** Sort Code Records contain U.K. bank account details per the sort code format. */
      @SerializedName("sort_code")
      SortCode sortCode;
      /** SPEI Records contain Mexico bank account details per the SPEI format. */
      @SerializedName("spei")
      Spei spei;
      /** The payment networks supported by this FinancialAddress. */
      @SerializedName("supported_networks")
      List<String> supportedNetworks;
      /**
       * The type of financial address
       *
       * <p>One of {@code iban}, {@code sort_code}, {@code spei}, or {@code zengin}.
       */
      @SerializedName("type")
      String type;
      /** Zengin Records contain Japan bank account details per the Zengin format. */
      @SerializedName("zengin")
      Zengin zengin;

      /** Iban Records contain E.U. bank account details per the SEPA format. */
      public static class Iban extends StripeObject {
        /** The name of the person or business that owns the bank account. */
        @SerializedName("account_holder_name")
        String accountHolderName;
        /** The BIC/SWIFT code of the account. */
        @SerializedName("bic")
        String bic;
        /**
         * Two-letter country code (<a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO
         * 3166-1 alpha-2</a>).
         */
        @SerializedName("country")
        String country;
        /** The IBAN of the account. */
        @SerializedName("iban")
        String iban;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccountHolderName() {
          return this.accountHolderName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBic() {
          return this.bic;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCountry() {
          return this.country;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getIban() {
          return this.iban;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAccountHolderName(final String accountHolderName) {
          this.accountHolderName = accountHolderName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBic(final String bic) {
          this.bic = bic;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCountry(final String country) {
          this.country = country;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setIban(final String iban) {
          this.iban = iban;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof FundingInstructions.BankTransfer.FinancialAddress.Iban)) return false;
          final FundingInstructions.BankTransfer.FinancialAddress.Iban other = (FundingInstructions.BankTransfer.FinancialAddress.Iban) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$accountHolderName = this.getAccountHolderName();
          final java.lang.Object other$accountHolderName = other.getAccountHolderName();
          if (this$accountHolderName == null ? other$accountHolderName != null : !this$accountHolderName.equals(other$accountHolderName)) return false;
          final java.lang.Object this$bic = this.getBic();
          final java.lang.Object other$bic = other.getBic();
          if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) return false;
          final java.lang.Object this$country = this.getCountry();
          final java.lang.Object other$country = other.getCountry();
          if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
          final java.lang.Object this$iban = this.getIban();
          final java.lang.Object other$iban = other.getIban();
          if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof FundingInstructions.BankTransfer.FinancialAddress.Iban;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $accountHolderName = this.getAccountHolderName();
          result = result * PRIME + ($accountHolderName == null ? 43 : $accountHolderName.hashCode());
          final java.lang.Object $bic = this.getBic();
          result = result * PRIME + ($bic == null ? 43 : $bic.hashCode());
          final java.lang.Object $country = this.getCountry();
          result = result * PRIME + ($country == null ? 43 : $country.hashCode());
          final java.lang.Object $iban = this.getIban();
          result = result * PRIME + ($iban == null ? 43 : $iban.hashCode());
          return result;
        }
      }

      /** Sort Code Records contain U.K. bank account details per the sort code format. */
      public static class SortCode extends StripeObject {
        /** The name of the person or business that owns the bank account. */
        @SerializedName("account_holder_name")
        String accountHolderName;
        /** The account number. */
        @SerializedName("account_number")
        String accountNumber;
        /** The six-digit sort code. */
        @SerializedName("sort_code")
        String sortCode;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccountHolderName() {
          return this.accountHolderName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccountNumber() {
          return this.accountNumber;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getSortCode() {
          return this.sortCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAccountHolderName(final String accountHolderName) {
          this.accountHolderName = accountHolderName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAccountNumber(final String accountNumber) {
          this.accountNumber = accountNumber;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setSortCode(final String sortCode) {
          this.sortCode = sortCode;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof FundingInstructions.BankTransfer.FinancialAddress.SortCode)) return false;
          final FundingInstructions.BankTransfer.FinancialAddress.SortCode other = (FundingInstructions.BankTransfer.FinancialAddress.SortCode) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$accountHolderName = this.getAccountHolderName();
          final java.lang.Object other$accountHolderName = other.getAccountHolderName();
          if (this$accountHolderName == null ? other$accountHolderName != null : !this$accountHolderName.equals(other$accountHolderName)) return false;
          final java.lang.Object this$accountNumber = this.getAccountNumber();
          final java.lang.Object other$accountNumber = other.getAccountNumber();
          if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) return false;
          final java.lang.Object this$sortCode = this.getSortCode();
          final java.lang.Object other$sortCode = other.getSortCode();
          if (this$sortCode == null ? other$sortCode != null : !this$sortCode.equals(other$sortCode)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof FundingInstructions.BankTransfer.FinancialAddress.SortCode;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $accountHolderName = this.getAccountHolderName();
          result = result * PRIME + ($accountHolderName == null ? 43 : $accountHolderName.hashCode());
          final java.lang.Object $accountNumber = this.getAccountNumber();
          result = result * PRIME + ($accountNumber == null ? 43 : $accountNumber.hashCode());
          final java.lang.Object $sortCode = this.getSortCode();
          result = result * PRIME + ($sortCode == null ? 43 : $sortCode.hashCode());
          return result;
        }
      }

      /** SPEI Records contain Mexico bank account details per the SPEI format. */
      public static class Spei extends StripeObject {
        /** The three-digit bank code. */
        @SerializedName("bank_code")
        String bankCode;
        /** The short banking institution name. */
        @SerializedName("bank_name")
        String bankName;
        /** The CLABE number. */
        @SerializedName("clabe")
        String clabe;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBankCode() {
          return this.bankCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBankName() {
          return this.bankName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getClabe() {
          return this.clabe;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBankCode(final String bankCode) {
          this.bankCode = bankCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBankName(final String bankName) {
          this.bankName = bankName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setClabe(final String clabe) {
          this.clabe = clabe;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof FundingInstructions.BankTransfer.FinancialAddress.Spei)) return false;
          final FundingInstructions.BankTransfer.FinancialAddress.Spei other = (FundingInstructions.BankTransfer.FinancialAddress.Spei) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$bankCode = this.getBankCode();
          final java.lang.Object other$bankCode = other.getBankCode();
          if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) return false;
          final java.lang.Object this$bankName = this.getBankName();
          final java.lang.Object other$bankName = other.getBankName();
          if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
          final java.lang.Object this$clabe = this.getClabe();
          final java.lang.Object other$clabe = other.getClabe();
          if (this$clabe == null ? other$clabe != null : !this$clabe.equals(other$clabe)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof FundingInstructions.BankTransfer.FinancialAddress.Spei;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $bankCode = this.getBankCode();
          result = result * PRIME + ($bankCode == null ? 43 : $bankCode.hashCode());
          final java.lang.Object $bankName = this.getBankName();
          result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
          final java.lang.Object $clabe = this.getClabe();
          result = result * PRIME + ($clabe == null ? 43 : $clabe.hashCode());
          return result;
        }
      }

      /** Zengin Records contain Japan bank account details per the Zengin format. */
      public static class Zengin extends StripeObject {
        /** The account holder name. */
        @SerializedName("account_holder_name")
        String accountHolderName;
        /** The account number. */
        @SerializedName("account_number")
        String accountNumber;
        /** The bank account type. In Japan, this can only be {@code futsu} or {@code toza}. */
        @SerializedName("account_type")
        String accountType;
        /** The bank code of the account. */
        @SerializedName("bank_code")
        String bankCode;
        /** The bank name of the account. */
        @SerializedName("bank_name")
        String bankName;
        /** The branch code of the account. */
        @SerializedName("branch_code")
        String branchCode;
        /** The branch name of the account. */
        @SerializedName("branch_name")
        String branchName;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccountHolderName() {
          return this.accountHolderName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccountNumber() {
          return this.accountNumber;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccountType() {
          return this.accountType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBankCode() {
          return this.bankCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBankName() {
          return this.bankName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBranchCode() {
          return this.branchCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBranchName() {
          return this.branchName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAccountHolderName(final String accountHolderName) {
          this.accountHolderName = accountHolderName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAccountNumber(final String accountNumber) {
          this.accountNumber = accountNumber;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAccountType(final String accountType) {
          this.accountType = accountType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBankCode(final String bankCode) {
          this.bankCode = bankCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBankName(final String bankName) {
          this.bankName = bankName;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBranchCode(final String branchCode) {
          this.branchCode = branchCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBranchName(final String branchName) {
          this.branchName = branchName;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
          if (o == this) return true;
          if (!(o instanceof FundingInstructions.BankTransfer.FinancialAddress.Zengin)) return false;
          final FundingInstructions.BankTransfer.FinancialAddress.Zengin other = (FundingInstructions.BankTransfer.FinancialAddress.Zengin) o;
          if (!other.canEqual((java.lang.Object) this)) return false;
          final java.lang.Object this$accountHolderName = this.getAccountHolderName();
          final java.lang.Object other$accountHolderName = other.getAccountHolderName();
          if (this$accountHolderName == null ? other$accountHolderName != null : !this$accountHolderName.equals(other$accountHolderName)) return false;
          final java.lang.Object this$accountNumber = this.getAccountNumber();
          final java.lang.Object other$accountNumber = other.getAccountNumber();
          if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) return false;
          final java.lang.Object this$accountType = this.getAccountType();
          final java.lang.Object other$accountType = other.getAccountType();
          if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) return false;
          final java.lang.Object this$bankCode = this.getBankCode();
          final java.lang.Object other$bankCode = other.getBankCode();
          if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) return false;
          final java.lang.Object this$bankName = this.getBankName();
          final java.lang.Object other$bankName = other.getBankName();
          if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) return false;
          final java.lang.Object this$branchCode = this.getBranchCode();
          final java.lang.Object other$branchCode = other.getBranchCode();
          if (this$branchCode == null ? other$branchCode != null : !this$branchCode.equals(other$branchCode)) return false;
          final java.lang.Object this$branchName = this.getBranchName();
          final java.lang.Object other$branchName = other.getBranchName();
          if (this$branchName == null ? other$branchName != null : !this$branchName.equals(other$branchName)) return false;
          return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
          return other instanceof FundingInstructions.BankTransfer.FinancialAddress.Zengin;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
          final int PRIME = 59;
          int result = 1;
          final java.lang.Object $accountHolderName = this.getAccountHolderName();
          result = result * PRIME + ($accountHolderName == null ? 43 : $accountHolderName.hashCode());
          final java.lang.Object $accountNumber = this.getAccountNumber();
          result = result * PRIME + ($accountNumber == null ? 43 : $accountNumber.hashCode());
          final java.lang.Object $accountType = this.getAccountType();
          result = result * PRIME + ($accountType == null ? 43 : $accountType.hashCode());
          final java.lang.Object $bankCode = this.getBankCode();
          result = result * PRIME + ($bankCode == null ? 43 : $bankCode.hashCode());
          final java.lang.Object $bankName = this.getBankName();
          result = result * PRIME + ($bankName == null ? 43 : $bankName.hashCode());
          final java.lang.Object $branchCode = this.getBranchCode();
          result = result * PRIME + ($branchCode == null ? 43 : $branchCode.hashCode());
          final java.lang.Object $branchName = this.getBranchName();
          result = result * PRIME + ($branchName == null ? 43 : $branchName.hashCode());
          return result;
        }
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Iban getIban() {
        return this.iban;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public SortCode getSortCode() {
        return this.sortCode;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Spei getSpei() {
        return this.spei;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public List<String> getSupportedNetworks() {
        return this.supportedNetworks;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public String getType() {
        return this.type;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public Zengin getZengin() {
        return this.zengin;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setIban(final Iban iban) {
        this.iban = iban;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSortCode(final SortCode sortCode) {
        this.sortCode = sortCode;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSpei(final Spei spei) {
        this.spei = spei;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setSupportedNetworks(final List<String> supportedNetworks) {
        this.supportedNetworks = supportedNetworks;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setType(final String type) {
        this.type = type;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public void setZengin(final Zengin zengin) {
        this.zengin = zengin;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof FundingInstructions.BankTransfer.FinancialAddress)) return false;
        final FundingInstructions.BankTransfer.FinancialAddress other = (FundingInstructions.BankTransfer.FinancialAddress) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$iban = this.getIban();
        final java.lang.Object other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) return false;
        final java.lang.Object this$sortCode = this.getSortCode();
        final java.lang.Object other$sortCode = other.getSortCode();
        if (this$sortCode == null ? other$sortCode != null : !this$sortCode.equals(other$sortCode)) return false;
        final java.lang.Object this$spei = this.getSpei();
        final java.lang.Object other$spei = other.getSpei();
        if (this$spei == null ? other$spei != null : !this$spei.equals(other$spei)) return false;
        final java.lang.Object this$supportedNetworks = this.getSupportedNetworks();
        final java.lang.Object other$supportedNetworks = other.getSupportedNetworks();
        if (this$supportedNetworks == null ? other$supportedNetworks != null : !this$supportedNetworks.equals(other$supportedNetworks)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        final java.lang.Object this$zengin = this.getZengin();
        final java.lang.Object other$zengin = other.getZengin();
        if (this$zengin == null ? other$zengin != null : !this$zengin.equals(other$zengin)) return false;
        return true;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      protected boolean canEqual(final java.lang.Object other) {
        return other instanceof FundingInstructions.BankTransfer.FinancialAddress;
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $iban = this.getIban();
        result = result * PRIME + ($iban == null ? 43 : $iban.hashCode());
        final java.lang.Object $sortCode = this.getSortCode();
        result = result * PRIME + ($sortCode == null ? 43 : $sortCode.hashCode());
        final java.lang.Object $spei = this.getSpei();
        result = result * PRIME + ($spei == null ? 43 : $spei.hashCode());
        final java.lang.Object $supportedNetworks = this.getSupportedNetworks();
        result = result * PRIME + ($supportedNetworks == null ? 43 : $supportedNetworks.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        final java.lang.Object $zengin = this.getZengin();
        result = result * PRIME + ($zengin == null ? 43 : $zengin.hashCode());
        return result;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCountry() {
      return this.country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<FundingInstructions.BankTransfer.FinancialAddress> getFinancialAddresses() {
      return this.financialAddresses;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
      return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCountry(final String country) {
      this.country = country;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFinancialAddresses(final List<FundingInstructions.BankTransfer.FinancialAddress> financialAddresses) {
      this.financialAddresses = financialAddresses;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setType(final String type) {
      this.type = type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof FundingInstructions.BankTransfer)) return false;
      final FundingInstructions.BankTransfer other = (FundingInstructions.BankTransfer) o;
      if (!other.canEqual((java.lang.Object) this)) return false;
      final java.lang.Object this$country = this.getCountry();
      final java.lang.Object other$country = other.getCountry();
      if (this$country == null ? other$country != null : !this$country.equals(other$country)) return false;
      final java.lang.Object this$financialAddresses = this.getFinancialAddresses();
      final java.lang.Object other$financialAddresses = other.getFinancialAddresses();
      if (this$financialAddresses == null ? other$financialAddresses != null : !this$financialAddresses.equals(other$financialAddresses)) return false;
      final java.lang.Object this$type = this.getType();
      final java.lang.Object other$type = other.getType();
      if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
      return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
      return other instanceof FundingInstructions.BankTransfer;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      final java.lang.Object $country = this.getCountry();
      result = result * PRIME + ($country == null ? 43 : $country.hashCode());
      final java.lang.Object $financialAddresses = this.getFinancialAddresses();
      result = result * PRIME + ($financialAddresses == null ? 43 : $financialAddresses.hashCode());
      final java.lang.Object $type = this.getType();
      result = result * PRIME + ($type == null ? 43 : $type.hashCode());
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BankTransfer getBankTransfer() {
    return this.bankTransfer;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * The {@code funding_type} of the returned instructions
   *
   * <p>Equal to {@code bank_transfer}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFundingType() {
    return this.fundingType;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code funding_instructions}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBankTransfer(final BankTransfer bankTransfer) {
    this.bankTransfer = bankTransfer;
  }

  /**
   * Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>,
   * in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrency(final String currency) {
    this.currency = currency;
  }

  /**
   * The {@code funding_type} of the returned instructions
   *
   * <p>Equal to {@code bank_transfer}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFundingType(final String fundingType) {
    this.fundingType = fundingType;
  }

  /**
   * Has the value {@code true} if the object exists in live mode or the value {@code false} if the
   * object exists in test mode.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  /**
   * String representing the object's type. Objects of the same type share the same value.
   *
   * <p>Equal to {@code funding_instructions}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof FundingInstructions)) return false;
    final FundingInstructions other = (FundingInstructions) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$bankTransfer = this.getBankTransfer();
    final java.lang.Object other$bankTransfer = other.getBankTransfer();
    if (this$bankTransfer == null ? other$bankTransfer != null : !this$bankTransfer.equals(other$bankTransfer)) return false;
    final java.lang.Object this$currency = this.getCurrency();
    final java.lang.Object other$currency = other.getCurrency();
    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
    final java.lang.Object this$fundingType = this.getFundingType();
    final java.lang.Object other$fundingType = other.getFundingType();
    if (this$fundingType == null ? other$fundingType != null : !this$fundingType.equals(other$fundingType)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof FundingInstructions;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $bankTransfer = this.getBankTransfer();
    result = result * PRIME + ($bankTransfer == null ? 43 : $bankTransfer.hashCode());
    final java.lang.Object $currency = this.getCurrency();
    result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
    final java.lang.Object $fundingType = this.getFundingType();
    result = result * PRIME + ($fundingType == null ? 43 : $fundingType.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    return result;
  }
}
