/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.giftcards;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.giftcards.CardCollection;
import com.stripe.model.giftcards.TransactionCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.giftcards.CardCreateParams;
import com.stripe.param.giftcards.CardListParams;
import com.stripe.param.giftcards.CardRetrieveParams;
import com.stripe.param.giftcards.CardUpdateParams;
import com.stripe.param.giftcards.CardValidateParams;
import java.util.Map;
import lombok.Generated;

public class Card
extends ApiResource
implements HasId,
MetadataStore<Card> {
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="amount_available")
    Long amountAvailable;
    @SerializedName(value="amount_held")
    Long amountHeld;
    @SerializedName(value="code")
    String code;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="created_by")
    CreatedBy createdBy;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="transactions")
    TransactionCollection transactions;

    public static Card create(Map<String, Object> params) throws StripeException {
        return Card.create(params, (RequestOptions)null);
    }

    public static Card create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/gift_cards/cards");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
    }

    public static Card create(CardCreateParams params) throws StripeException {
        return Card.create(params, (RequestOptions)null);
    }

    public static Card create(CardCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/gift_cards/cards");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
    }

    public static CardCollection list(Map<String, Object> params) throws StripeException {
        return Card.list(params, (RequestOptions)null);
    }

    public static CardCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/gift_cards/cards");
        return ApiResource.requestCollection(url, params, CardCollection.class, options);
    }

    public static CardCollection list(CardListParams params) throws StripeException {
        return Card.list(params, (RequestOptions)null);
    }

    public static CardCollection list(CardListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/gift_cards/cards");
        return ApiResource.requestCollection(url, params, CardCollection.class, options);
    }

    public static Card retrieve(String id) throws StripeException {
        return Card.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Card retrieve(String id, RequestOptions options) throws StripeException {
        return Card.retrieve(id, (Map<String, Object>)null, options);
    }

    public static Card retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/gift_cards/cards/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Card.class, options);
    }

    public static Card retrieve(String id, CardRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/gift_cards/cards/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Card.class, options);
    }

    public Card update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Card update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/gift_cards/cards/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
    }

    public Card update(CardUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Card update(CardUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/gift_cards/cards/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
    }

    public static Card validate(Map<String, Object> params) throws StripeException {
        return Card.validate(params, (RequestOptions)null);
    }

    public static Card validate(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/gift_cards/cards/validate");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
    }

    public static Card validate(CardValidateParams params) throws StripeException {
        return Card.validate(params, (RequestOptions)null);
    }

    public static Card validate(CardValidateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/gift_cards/cards/validate");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Card.class, options);
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Long getAmountAvailable() {
        return this.amountAvailable;
    }

    @Generated
    public Long getAmountHeld() {
        return this.amountHeld;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public CreatedBy getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public TransactionCollection getTransactions() {
        return this.transactions;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setAmountAvailable(Long amountAvailable) {
        this.amountAvailable = amountAvailable;
    }

    @Generated
    public void setAmountHeld(Long amountHeld) {
        this.amountHeld = amountHeld;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCreatedBy(CreatedBy createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setTransactions(TransactionCollection transactions) {
        this.transactions = transactions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Card)) {
            return false;
        }
        Card other = (Card)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Long this$amountAvailable = this.getAmountAvailable();
        Long other$amountAvailable = other.getAmountAvailable();
        if (this$amountAvailable == null ? other$amountAvailable != null : !((Object)this$amountAvailable).equals(other$amountAvailable)) {
            return false;
        }
        Long this$amountHeld = this.getAmountHeld();
        Long other$amountHeld = other.getAmountHeld();
        if (this$amountHeld == null ? other$amountHeld != null : !((Object)this$amountHeld).equals(other$amountHeld)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        CreatedBy this$createdBy = this.getCreatedBy();
        CreatedBy other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        TransactionCollection this$transactions = this.getTransactions();
        TransactionCollection other$transactions = other.getTransactions();
        return !(this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Card;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Long $amountAvailable = this.getAmountAvailable();
        result = result * 59 + ($amountAvailable == null ? 43 : ((Object)$amountAvailable).hashCode());
        Long $amountHeld = this.getAmountHeld();
        result = result * 59 + ($amountHeld == null ? 43 : ((Object)$amountHeld).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        CreatedBy $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        TransactionCollection $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class CreatedBy
    extends StripeObject {
        @SerializedName(value="checkout")
        Checkout checkout;
        @SerializedName(value="order")
        Order order;
        @SerializedName(value="payment")
        Payment payment;
        @SerializedName(value="type")
        String type;

        @Generated
        public Checkout getCheckout() {
            return this.checkout;
        }

        @Generated
        public Order getOrder() {
            return this.order;
        }

        @Generated
        public Payment getPayment() {
            return this.payment;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setCheckout(Checkout checkout) {
            this.checkout = checkout;
        }

        @Generated
        public void setOrder(Order order) {
            this.order = order;
        }

        @Generated
        public void setPayment(Payment payment) {
            this.payment = payment;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreatedBy)) {
                return false;
            }
            CreatedBy other = (CreatedBy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Checkout this$checkout = this.getCheckout();
            Checkout other$checkout = other.getCheckout();
            if (this$checkout == null ? other$checkout != null : !((Object)this$checkout).equals(other$checkout)) {
                return false;
            }
            Order this$order = this.getOrder();
            Order other$order = other.getOrder();
            if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
                return false;
            }
            Payment this$payment = this.getPayment();
            Payment other$payment = other.getPayment();
            if (this$payment == null ? other$payment != null : !((Object)this$payment).equals(other$payment)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreatedBy;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Checkout $checkout = this.getCheckout();
            result = result * 59 + ($checkout == null ? 43 : ((Object)$checkout).hashCode());
            Order $order = this.getOrder();
            result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
            Payment $payment = this.getPayment();
            result = result * 59 + ($payment == null ? 43 : ((Object)$payment).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Checkout
        extends StripeObject {
            @SerializedName(value="checkout_session")
            String checkoutSession;
            @SerializedName(value="line_item")
            String lineItem;

            @Generated
            public String getCheckoutSession() {
                return this.checkoutSession;
            }

            @Generated
            public String getLineItem() {
                return this.lineItem;
            }

            @Generated
            public void setCheckoutSession(String checkoutSession) {
                this.checkoutSession = checkoutSession;
            }

            @Generated
            public void setLineItem(String lineItem) {
                this.lineItem = lineItem;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Checkout)) {
                    return false;
                }
                Checkout other = (Checkout)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$checkoutSession = this.getCheckoutSession();
                String other$checkoutSession = other.getCheckoutSession();
                if (this$checkoutSession == null ? other$checkoutSession != null : !this$checkoutSession.equals(other$checkoutSession)) {
                    return false;
                }
                String this$lineItem = this.getLineItem();
                String other$lineItem = other.getLineItem();
                return !(this$lineItem == null ? other$lineItem != null : !this$lineItem.equals(other$lineItem));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Checkout;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $checkoutSession = this.getCheckoutSession();
                result = result * 59 + ($checkoutSession == null ? 43 : $checkoutSession.hashCode());
                String $lineItem = this.getLineItem();
                result = result * 59 + ($lineItem == null ? 43 : $lineItem.hashCode());
                return result;
            }
        }

        public static class Order
        extends StripeObject {
            @SerializedName(value="line_item")
            String lineItem;
            @SerializedName(value="order")
            String order;

            @Generated
            public String getLineItem() {
                return this.lineItem;
            }

            @Generated
            public String getOrder() {
                return this.order;
            }

            @Generated
            public void setLineItem(String lineItem) {
                this.lineItem = lineItem;
            }

            @Generated
            public void setOrder(String order) {
                this.order = order;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Order)) {
                    return false;
                }
                Order other = (Order)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$lineItem = this.getLineItem();
                String other$lineItem = other.getLineItem();
                if (this$lineItem == null ? other$lineItem != null : !this$lineItem.equals(other$lineItem)) {
                    return false;
                }
                String this$order = this.getOrder();
                String other$order = other.getOrder();
                return !(this$order == null ? other$order != null : !this$order.equals(other$order));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Order;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $lineItem = this.getLineItem();
                result = result * 59 + ($lineItem == null ? 43 : $lineItem.hashCode());
                String $order = this.getOrder();
                result = result * 59 + ($order == null ? 43 : $order.hashCode());
                return result;
            }
        }

        public static class Payment
        extends StripeObject {
            @SerializedName(value="payment_intent")
            String paymentIntent;

            @Generated
            public String getPaymentIntent() {
                return this.paymentIntent;
            }

            @Generated
            public void setPaymentIntent(String paymentIntent) {
                this.paymentIntent = paymentIntent;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Payment)) {
                    return false;
                }
                Payment other = (Payment)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$paymentIntent = this.getPaymentIntent();
                String other$paymentIntent = other.getPaymentIntent();
                return !(this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Payment;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $paymentIntent = this.getPaymentIntent();
                result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
                return result;
            }
        }
    }
}

