// Generated by delombok at Tue Sep 06 21:15:17 UTC 2022
// File generated from our OpenAPI spec
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BalanceTransactionListParams extends ApiRequestParams {
  /**
   * This parameter is deprecated and we recommend listing by created and filtering in memory
   * instead.
   */
  @SerializedName("available_on")
  Object availableOn;
  @SerializedName("created")
  Object created;
  /**
   * Only return transactions in a certain currency. Three-letter <a
   * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>, in lowercase.
   * Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @SerializedName("currency")
  String currency;
  /**
   * A cursor for use in pagination. {@code ending_before} is an object ID that defines your place
   * in the list. For instance, if you make a list request and receive 100 objects, starting with
   * {@code obj_bar}, your subsequent call can include {@code ending_before=obj_bar} in order to
   * fetch the previous page of the list.
   */
  @SerializedName("ending_before")
  String endingBefore;
  /**
   * Specifies which fields in the response should be expanded.
   */
  @SerializedName("expand")
  List<String> expand;
  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
  Map<String, Object> extraParams;
  /**
   * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the
   * default is 10.
   */
  @SerializedName("limit")
  Long limit;
  /**
   * For automatic Stripe payouts only, only returns transactions that were paid out on the
   * specified payout ID.
   */
  @SerializedName("payout")
  String payout;
  /**
   * Only returns the original transaction.
   */
  @SerializedName("source")
  String source;
  /**
   * A cursor for use in pagination. {@code starting_after} is an object ID that defines your place
   * in the list. For instance, if you make a list request and receive 100 objects, ending with
   * {@code obj_foo}, your subsequent call can include {@code starting_after=obj_foo} in order to
   * fetch the next page of the list.
   */
  @SerializedName("starting_after")
  String startingAfter;
  /**
   * Only returns transactions of the given type. One of: {@code adjustment}, {@code advance},
   * {@code advance_funding}, {@code anticipation_repayment}, {@code application_fee}, {@code
   * application_fee_refund}, {@code charge}, {@code connect_collection_transfer}, {@code
   * contribution}, {@code issuing_authorization_hold}, {@code issuing_authorization_release},
   * {@code issuing_dispute}, {@code issuing_transaction}, {@code payment}, {@code
   * payment_failure_refund}, {@code payment_refund}, {@code payout}, {@code payout_cancel}, {@code
   * payout_failure}, {@code refund}, {@code refund_failure}, {@code reserve_transaction}, {@code
   * reserved_funds}, {@code stripe_fee}, {@code stripe_fx_fee}, {@code tax_fee}, {@code topup},
   * {@code topup_reversal}, {@code transfer}, {@code transfer_cancel}, {@code transfer_failure}, or
   * {@code transfer_refund}.
   */
  @SerializedName("type")
  String type;

  private BalanceTransactionListParams(Object availableOn, Object created, String currency, String endingBefore, List<String> expand, Map<String, Object> extraParams, Long limit, String payout, String source, String startingAfter, String type) {
    this.availableOn = availableOn;
    this.created = created;
    this.currency = currency;
    this.endingBefore = endingBefore;
    this.expand = expand;
    this.extraParams = extraParams;
    this.limit = limit;
    this.payout = payout;
    this.source = source;
    this.startingAfter = startingAfter;
    this.type = type;
  }

  public static Builder builder() {
    return new Builder();
  }


  public static class Builder {
    private Object availableOn;
    private Object created;
    private String currency;
    private String endingBefore;
    private List<String> expand;
    private Map<String, Object> extraParams;
    private Long limit;
    private String payout;
    private String source;
    private String startingAfter;
    private String type;

    /**
     * Finalize and obtain parameter instance from this builder.
     */
    public BalanceTransactionListParams build() {
      return new BalanceTransactionListParams(this.availableOn, this.created, this.currency, this.endingBefore, this.expand, this.extraParams, this.limit, this.payout, this.source, this.startingAfter, this.type);
    }

    /**
     * This parameter is deprecated and we recommend listing by created and filtering in memory
     * instead.
     */
    public Builder setAvailableOn(AvailableOn availableOn) {
      this.availableOn = availableOn;
      return this;
    }

    /**
     * This parameter is deprecated and we recommend listing by created and filtering in memory
     * instead.
     */
    public Builder setAvailableOn(Long availableOn) {
      this.availableOn = availableOn;
      return this;
    }

    public Builder setCreated(Created created) {
      this.created = created;
      return this;
    }

    public Builder setCreated(Long created) {
      this.created = created;
      return this;
    }

    /**
     * Only return transactions in a certain currency. Three-letter <a
     * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>, in lowercase.
     * Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
     */
    public Builder setCurrency(String currency) {
      this.currency = currency;
      return this;
    }

    /**
     * A cursor for use in pagination. {@code ending_before} is an object ID that defines your place
     * in the list. For instance, if you make a list request and receive 100 objects, starting with
     * {@code obj_bar}, your subsequent call can include {@code ending_before=obj_bar} in order to
     * fetch the previous page of the list.
     */
    public Builder setEndingBefore(String endingBefore) {
      this.endingBefore = endingBefore;
      return this;
    }

    /**
     * Add an element to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * BalanceTransactionListParams#expand} for the field documentation.
     */
    public Builder addExpand(String element) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.add(element);
      return this;
    }

    /**
     * Add all elements to `expand` list. A list is initialized for the first `add/addAll` call, and
     * subsequent calls adds additional elements to the original list. See {@link
     * BalanceTransactionListParams#expand} for the field documentation.
     */
    public Builder addAllExpand(List<String> elements) {
      if (this.expand == null) {
        this.expand = new ArrayList<>();
      }
      this.expand.addAll(elements);
      return this;
    }

    /**
     * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
     * call, and subsequent calls add additional key/value pairs to the original map. See {@link
     * BalanceTransactionListParams#extraParams} for the field documentation.
     */
    public Builder putExtraParam(String key, Object value) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.put(key, value);
      return this;
    }

    /**
     * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
     * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
     * See {@link BalanceTransactionListParams#extraParams} for the field documentation.
     */
    public Builder putAllExtraParam(Map<String, Object> map) {
      if (this.extraParams == null) {
        this.extraParams = new HashMap<>();
      }
      this.extraParams.putAll(map);
      return this;
    }

    /**
     * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the
     * default is 10.
     */
    public Builder setLimit(Long limit) {
      this.limit = limit;
      return this;
    }

    /**
     * For automatic Stripe payouts only, only returns transactions that were paid out on the
     * specified payout ID.
     */
    public Builder setPayout(String payout) {
      this.payout = payout;
      return this;
    }

    /**
     * Only returns the original transaction.
     */
    public Builder setSource(String source) {
      this.source = source;
      return this;
    }

    /**
     * A cursor for use in pagination. {@code starting_after} is an object ID that defines your
     * place in the list. For instance, if you make a list request and receive 100 objects, ending
     * with {@code obj_foo}, your subsequent call can include {@code starting_after=obj_foo} in
     * order to fetch the next page of the list.
     */
    public Builder setStartingAfter(String startingAfter) {
      this.startingAfter = startingAfter;
      return this;
    }

    /**
     * Only returns transactions of the given type. One of: {@code adjustment}, {@code advance},
     * {@code advance_funding}, {@code anticipation_repayment}, {@code application_fee}, {@code
     * application_fee_refund}, {@code charge}, {@code connect_collection_transfer}, {@code
     * contribution}, {@code issuing_authorization_hold}, {@code issuing_authorization_release},
     * {@code issuing_dispute}, {@code issuing_transaction}, {@code payment}, {@code
     * payment_failure_refund}, {@code payment_refund}, {@code payout}, {@code payout_cancel},
     * {@code payout_failure}, {@code refund}, {@code refund_failure}, {@code reserve_transaction},
     * {@code reserved_funds}, {@code stripe_fee}, {@code stripe_fx_fee}, {@code tax_fee}, {@code
     * topup}, {@code topup_reversal}, {@code transfer}, {@code transfer_cancel}, {@code
     * transfer_failure}, or {@code transfer_refund}.
     */
    public Builder setType(String type) {
      this.type = type;
      return this;
    }
  }


  public static class AvailableOn {
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;
    /**
     * Minimum value to filter by (exclusive).
     */
    @SerializedName("gt")
    Long gt;
    /**
     * Minimum value to filter by (inclusive).
     */
    @SerializedName("gte")
    Long gte;
    /**
     * Maximum value to filter by (exclusive).
     */
    @SerializedName("lt")
    Long lt;
    /**
     * Maximum value to filter by (inclusive).
     */
    @SerializedName("lte")
    Long lte;

    private AvailableOn(Map<String, Object> extraParams, Long gt, Long gte, Long lt, Long lte) {
      this.extraParams = extraParams;
      this.gt = gt;
      this.gte = gte;
      this.lt = lt;
      this.lte = lte;
    }

    public static Builder builder() {
      return new Builder();
    }


    public static class Builder {
      private Map<String, Object> extraParams;
      private Long gt;
      private Long gte;
      private Long lt;
      private Long lte;

      /** Finalize and obtain parameter instance from this builder. */
      public AvailableOn build() {
        return new AvailableOn(this.extraParams, this.gt, this.gte, this.lt, this.lte);
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * BalanceTransactionListParams.AvailableOn#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link BalanceTransactionListParams.AvailableOn#extraParams} for the field
       * documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }

      /** Minimum value to filter by (exclusive). */
      public Builder setGt(Long gt) {
        this.gt = gt;
        return this;
      }

      /** Minimum value to filter by (inclusive). */
      public Builder setGte(Long gte) {
        this.gte = gte;
        return this;
      }

      /** Maximum value to filter by (exclusive). */
      public Builder setLt(Long lt) {
        this.lt = lt;
        return this;
      }

      public Builder setLte(Long lte) {
        this.lte = lte;
        return this;
      }
    }

    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getExtraParams() {
      return this.extraParams;
    }

    /**
     * Minimum value to filter by (exclusive).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getGt() {
      return this.gt;
    }

    /**
     * Minimum value to filter by (inclusive).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getGte() {
      return this.gte;
    }

    /**
     * Maximum value to filter by (exclusive).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLt() {
      return this.lt;
    }

    /**
     * Maximum value to filter by (inclusive).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLte() {
      return this.lte;
    }
  }


  /**
   * Maximum value to filter by (inclusive).
   */
  public static class Created {
    /**
     * Map of extra parameters for custom features not available in this client library. The content
     * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
     * key/value pair is serialized as if the key is a root-level field (serialized) name in this
     * param object. Effectively, this map is flattened to its parent instance.
     */
    @SerializedName(ApiRequestParams.EXTRA_PARAMS_KEY)
    Map<String, Object> extraParams;
    /** Minimum value to filter by (exclusive). */
    @SerializedName("gt")
    Long gt;
    /** Minimum value to filter by (inclusive). */
    @SerializedName("gte")
    Long gte;
    /** Maximum value to filter by (exclusive). */
    @SerializedName("lt")
    Long lt;
    /** Maximum value to filter by (inclusive). */
    @SerializedName("lte")
    Long lte;

    private Created(Map<String, Object> extraParams, Long gt, Long gte, Long lt, Long lte) {
      this.extraParams = extraParams;
      this.gt = gt;
      this.gte = gte;
      this.lt = lt;
      this.lte = lte;
    }

    public static Builder builder() {
      return new Builder();
    }


    public static class Builder {
      private Map<String, Object> extraParams;
      private Long gt;
      private Long gte;
      private Long lt;
      private Long lte;

      /** Finalize and obtain parameter instance from this builder. */
      public Created build() {
        return new Created(this.extraParams, this.gt, this.gte, this.lt, this.lte);
      }

      /**
       * Add a key/value pair to `extraParams` map. A map is initialized for the first `put/putAll`
       * call, and subsequent calls add additional key/value pairs to the original map. See {@link
       * BalanceTransactionListParams.Created#extraParams} for the field documentation.
       */
      public Builder putExtraParam(String key, Object value) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.put(key, value);
        return this;
      }

      /**
       * Add all map key/value pairs to `extraParams` map. A map is initialized for the first
       * `put/putAll` call, and subsequent calls add additional key/value pairs to the original map.
       * See {@link BalanceTransactionListParams.Created#extraParams} for the field documentation.
       */
      public Builder putAllExtraParam(Map<String, Object> map) {
        if (this.extraParams == null) {
          this.extraParams = new HashMap<>();
        }
        this.extraParams.putAll(map);
        return this;
      }

      /** Minimum value to filter by (exclusive). */
      public Builder setGt(Long gt) {
        this.gt = gt;
        return this;
      }

      /** Minimum value to filter by (inclusive). */
      public Builder setGte(Long gte) {
        this.gte = gte;
        return this;
      }

      /** Maximum value to filter by (exclusive). */
      public Builder setLt(Long lt) {
        this.lt = lt;
        return this;
      }

      /** Maximum value to filter by (inclusive). */
      public Builder setLte(Long lte) {
        this.lte = lte;
        return this;
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getExtraParams() {
      return this.extraParams;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getGt() {
      return this.gt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getGte() {
      return this.gte;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLt() {
      return this.lt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLte() {
      return this.lte;
    }
  }

  /**
   * This parameter is deprecated and we recommend listing by created and filtering in memory
   * instead.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Object getAvailableOn() {
    return this.availableOn;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Object getCreated() {
    return this.created;
  }

  /**
   * Only return transactions in a certain currency. Three-letter <a
   * href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>, in lowercase.
   * Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCurrency() {
    return this.currency;
  }

  /**
   * A cursor for use in pagination. {@code ending_before} is an object ID that defines your place
   * in the list. For instance, if you make a list request and receive 100 objects, starting with
   * {@code obj_bar}, your subsequent call can include {@code ending_before=obj_bar} in order to
   * fetch the previous page of the list.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getEndingBefore() {
    return this.endingBefore;
  }

  /**
   * Specifies which fields in the response should be expanded.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<String> getExpand() {
    return this.expand;
  }

  /**
   * Map of extra parameters for custom features not available in this client library. The content
   * in this map is not serialized under this field's {@code @SerializedName} value. Instead, each
   * key/value pair is serialized as if the key is a root-level field (serialized) name in this
   * param object. Effectively, this map is flattened to its parent instance.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, Object> getExtraParams() {
    return this.extraParams;
  }

  /**
   * A limit on the number of objects to be returned. Limit can range between 1 and 100, and the
   * default is 10.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getLimit() {
    return this.limit;
  }

  /**
   * For automatic Stripe payouts only, only returns transactions that were paid out on the
   * specified payout ID.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPayout() {
    return this.payout;
  }

  /**
   * Only returns the original transaction.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSource() {
    return this.source;
  }

  /**
   * A cursor for use in pagination. {@code starting_after} is an object ID that defines your place
   * in the list. For instance, if you make a list request and receive 100 objects, ending with
   * {@code obj_foo}, your subsequent call can include {@code starting_after=obj_foo} in order to
   * fetch the next page of the list.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStartingAfter() {
    return this.startingAfter;
  }

  /**
   * Only returns transactions of the given type. One of: {@code adjustment}, {@code advance},
   * {@code advance_funding}, {@code anticipation_repayment}, {@code application_fee}, {@code
   * application_fee_refund}, {@code charge}, {@code connect_collection_transfer}, {@code
   * contribution}, {@code issuing_authorization_hold}, {@code issuing_authorization_release},
   * {@code issuing_dispute}, {@code issuing_transaction}, {@code payment}, {@code
   * payment_failure_refund}, {@code payment_refund}, {@code payout}, {@code payout_cancel}, {@code
   * payout_failure}, {@code refund}, {@code refund_failure}, {@code reserve_transaction}, {@code
   * reserved_funds}, {@code stripe_fee}, {@code stripe_fx_fee}, {@code tax_fee}, {@code topup},
   * {@code topup_reversal}, {@code transfer}, {@code transfer_cancel}, {@code transfer_failure}, or
   * {@code transfer_refund}.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getType() {
    return this.type;
  }
}
